/*!
 * OpenUI5
 * (c) Copyright 2009-2019 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["sap/ui/documentation/sdk/controller/BaseController","sap/ui/model/json/JSONModel","sap/ui/documentation/sdk/controller/util/ControlsInfo","sap/ui/documentation/sdk/util/ToggleFullScreenHandler","sap/ui/documentation/sdk/controller/util/APIInfo","sap/ui/documentation/sdk/model/formatter","sap/ui/core/library","sap/base/Log"],function(B,J,C,T,A,f,c,L){"use strict";var V=c.mvc.ViewType;return B.extend("sap.ui.documentation.sdk.controller.ApiDetail",{NOT_AVAILABLE:'N/A',NOT_FOUND:'Not found',onInit:function(){this.getRouter().getRoute("apiId").attachPatternMatched(this._onTopicMatched,this);this._oModel=new J();this._oModel.setSizeLimit(10000);this._oContainerPage=this.getView().byId("apiDetailPageContainer");},_onTopicMatched:function(e){if(this._oView){this._oView.destroy();this._oContainerPage.setBusy(true);}var o=this.getOwnerComponent();this._sTopicid=decodeURIComponent(e.getParameter("arguments").id);this._sEntityType=e.getParameter("arguments").entityType;this._sEntityId=decodeURIComponent(e.getParameter("arguments").entityId);o.loadVersionInfo().then(function(){this._aAllowedMembers=this.getModel("versionData").getProperty("/allowedMembers");}.bind(this)).then(A.getIndexJsonPromise).then(this._processApiIndexAndLoadApiJson.bind(this)).then(this._findEntityInApiJsonData.bind(this)).then(this._buildBorrowedModel.bind(this)).then(this._createModelAndSubView.bind(this)).then(this._initSubView.bind(this)).catch(function(r){if(r===this.NOT_FOUND){this._oContainerPage.setBusy(false);this.getRouter().myNavToWithoutHash("sap.ui.documentation.sdk.view.NotFound","XML",false);}else if(typeof r==="string"){L.error(r);}else if(r.name){L.error(r.name,r.message);}else if(r.message){L.error(r.message);}}.bind(this));},_initSubView:function(v){var o=v.getController();this._oContainerPage.addContent(v);this._oContainerPage.setBusy(false);o.initiate({sTopicId:this._sTopicid,oModel:this._oModel,aApiIndex:this._aApiIndex,aAllowedMembers:this._aAllowedMembers,oEntityData:this._oEntityData,sEntityType:this._sEntityType,sEntityId:this._sEntityId,oOwnerComponent:this.getOwnerComponent(),oContainerView:this.getView(),oContainerController:this});},_createModelAndSubView:function(b){this._oControlData.borrowed=b;this._bindData(this._sTopicid);this._oView=sap.ui.view({height:"100%",viewName:"sap.ui.documentation.sdk.view.SubApiDetail",type:V.XML,async:true,preprocessors:{xml:{models:{data:this._oModel}}}});return this._oView.loaded();},_buildBorrowedModel:function(o){this._oControlData=o;return this.buildBorrowedModel(o);},_findEntityInApiJsonData:function(l){var o,a,i;for(i=0,a=l.length;i<a;i++){o=l[i];if(o.name===this._sTopicid){if(o.visibility===undefined||this._aAllowedMembers.indexOf(o.visibility)>=0){return o;}else{return Promise.reject(this.NOT_FOUND);}}}return Promise.reject(this.NOT_FOUND);},_processApiIndexAndLoadApiJson:function(d){var e,m,t=this._sTopicid;this._aApiIndex=d;function b(a){return a.some(function(o){var F=o.name===t;if(!F&&o.nodes){return b(o.nodes);}else if(F){e=o;return true;}return false;});}b(d);if(e){this._oEntityData=e;if(e.deprecated){m=this.getOwnerComponent().getConfigUtil().getMasterView("apiId").getController();m.selectDeprecatedSymbol(this._sTopicid);}return A.getLibraryElementsJSONPromise(e.lib).then(function(d){return Promise.resolve(d);});}return Promise.reject(this.NOT_FOUND);},_bindData:function(t){var o=this._oControlData,m,u,s=function(a,b){if(a.name>b.name){return 1;}else if(a.name<b.name){return-1;}return 0;};u=o['ui5-metadata'];o.hasProperties=false;o.hasOwnMethods=false;o.hasControlProperties=false;o.hasAssociations=false;o.hasAggregations=false;o.hasSpecialSettings=false;o.hasAnnotations=false;var i=function(e){return(this._aAllowedMembers.indexOf(e.visibility)>=0);}.bind(this);var F=function(e){e.name&&(e.name=f.apiRefEntityName(e.name));e.code&&(e.code=f.apiRefEntityName(e.code));if(e.name){var p=e.name.replace(/[$#/]/g,".");e.placeholderId=p+"_method";e.subPlaceholderId=p+"__method";}return e;};if(o.borrowed.properties.length){u.properties=(u.properties||[]).concat(o.borrowed.properties).sort(s);}if(o.borrowed.aggregations.length){u.aggregations=(u.aggregations||[]).concat(o.borrowed.aggregations).sort(s);}if(o.borrowed.associations.length){u.associations=(u.associations||[]).concat(o.borrowed.associations).sort(s);}if(o.properties){o.properties=this.transformElements(o.properties,i,F);o.hasProperties=!!o.properties.length;}if(o.methods){o.methods=this.transformElements(o.methods,i,F);o.hasOwnMethods=!!o.methods.length;}if(u){o.dnd=u.dnd;if(u.properties){u.properties=this.transformElements(u.properties,i);o.hasControlProperties=!!u.properties.length;}if(u.associations){u.associations=this.transformElements(u.associations,i);o.hasAssociations=!!u.associations.length;}if(u.aggregations){u.aggregations=this.transformElements(u.aggregations,i);o.hasAggregations=!!u.aggregations.length;o.hasAggregationAltTypes=u.aggregations.some(function(e){return!!e.altTypes;});}if(u.specialSettings){u.specialSettings=this.transformElements(u.specialSettings,i);o.hasSpecialSettings=!!u.specialSettings.length;}o.hasAnnotations=!!(u.annotations&&u.annotations.length);}o.hasChildren=!!o.nodes;o.hasConstructor=o.hasOwnProperty("constructor")&&!!o.constructor;o.hasOwnEvents=!!o.events;o.hasEvents=!!(o.hasOwnEvents||(o.borrowed&&o.borrowed.events.length>0));o.hasMethods=!!(o.hasOwnMethods||(o.borrowed&&o.borrowed.methods.length>0));if(o.implements&&o.implements.length){o.implementsParsed=o.implements.map(function(a,b,d){var D=a.split("."),e=D[D.length-1];return{href:a,name:e};});o.hasImplementsData=true;}else{o.hasImplementsData=false;}o.isFunction=o.kind==="function";o.isClass=o.kind==="class";o.isNamespace=o.kind==="namespace";o.isDerived=!!o.extends;o.extendsText=o.extends||this.NOT_AVAILABLE;o.sinceText=o.since||this.NOT_AVAILABLE;o.module=o.module||this.NOT_AVAILABLE;this._oModel.setData(o);if(this.extHookbindData){this.extHookbindData(t,m);}},buildBorrowedModel:function(b){var d,e,g,h,j,s,k,m,M,p,P,l,n,q,r,I,R=[],S;if(!b){return Promise.resolve({events:[],methods:[],properties:[],aggregations:[],associations:[]});}k={methods:[],events:[],properties:[],aggregations:[],associations:[]};s=b.extends;var v=function(i){return this._aAllowedMembers.indexOf(i.visibility)!==-1;}.bind(this);m=b.methods||[];M=m.map(function(o){return o.name;});p=b["ui5-metadata"]&&b["ui5-metadata"].properties||[];P=p.map(function(o){return o.name;});l=b["ui5-metadata"]&&b["ui5-metadata"].aggregations||[];n=l.map(function(a){return a.name;});q=b["ui5-metadata"]&&b["ui5-metadata"].associations||[];r=q.map(function(a){return a.name;});var O=function(i){return M.indexOf(i.name)===-1;};var t=function(i){return P.indexOf(i.name)===-1&&!i.borrowedFrom&&!k.properties.some(function(o){return o.name===i.name;});};var u=function(i){return n.indexOf(i.name)===-1&&!i.borrowedFrom;};var w=function(i){return r.indexOf(i.name)===-1&&!i.borrowedFrom;};function x(a,i){return a.some(function(o){var F=o.name===i;if(!F&&o.nodes){return x(o.nodes,i);}else if(F){S=o;return true;}return false;});}I=[s];while(s){x(this._aApiIndex,s);if(S){s=S.extends;if(s){I.push(s);}if(R.indexOf(S.lib)===-1){R.push(S.lib);}}else{s=false;break;}}var y=R.map(function(a){return A.getLibraryElementsJSONPromise(a);});return Promise.all(y).then(function(a){var o=[],z;a.forEach(function(i){o=o.concat(i);});I.forEach(function(s){var D,i=o.length;while(i--){if(o[i].name===s){D=o[i];break;}}var E=function(H){return{name:H.name,link:"#/api/"+s+"/methods/"+H.name};};var F=function(H){return{name:H.name,link:"#/api/"+s+"/events/"+H.name};};var G=function(H){return Object.assign({},H,{borrowedFrom:s});};if(D){z=D["ui5-metadata"]||[];d=(D.methods||[]).filter(v).filter(O).map(E);if(d.length){k.methods.push({name:s,methods:d});}e=(D.events||[]).filter(v).map(F);if(e.length){k.events.push({name:s,events:e});}g=(z.properties||[]).filter(v).filter(t).map(G);if(g.length){k.properties=k.properties.concat(g);}h=(z.aggregations||[]).filter(v).filter(u).map(G);if(h.length){k.aggregations=k.aggregations.concat(h);}j=(z.associations||[]).filter(v).filter(w).map(G);if(j.length){k.associations=k.associations.concat(j);}}});return k;});},transformElements:function(e,F,a){var i,l=e.length,n=[],E;for(i=0;i<l;i++){E=e[i];if(F&&!F(E)){continue;}if(a){a(E);}n.push(E);}return n;}});});
