/*!
 * OpenUI5
 * (c) Copyright 2009-2019 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["sap/ui/fl/registry/ChangeRegistry","sap/ui/fl/registry/ChangeHandlerRegistration","sap/ui/fl/Utils","sap/ui/fl/FlexCustomData","sap/ui/fl/write/api/FeaturesAPI","sap/ui/fl/Change","sap/ui/fl/Variant","sap/ui/fl/registry/Settings","sap/ui/fl/LrepConnector","sap/ui/fl/ChangePersistenceFactory","sap/ui/fl/context/ContextManager","sap/ui/core/util/reflection/JsControlTreeModifier","sap/ui/core/util/reflection/XmlTreeModifier","sap/ui/core/Component","sap/ui/core/Element","sap/base/Log"],function(C,a,U,F,b,c,V,d,L,e,f,J,X,g,E,h){"use strict";var l=function(s,A){this._oChangePersistence=undefined;this._sComponentName=s||"";this._sAppVersion=A||U.DEFAULT_APP_VERSION;if(this._sComponentName&&this._sAppVersion){this._createChangePersistence();}};l.PENDING="sap.ui.fl:PendingChange";l.variantTechnicalParameterName="sap-ui-fl-control-variant-id";l.prototype.setComponentName=function(s){this._sComponentName=s;this._createChangePersistence();};l.prototype.getComponentName=function(){return this._sComponentName;};l.prototype.getAppVersion=function(){return this._sAppVersion;};l.prototype.getVariantModelData=function(){var D;if(this._oChangePersistence&&this._oChangePersistence._oVariantController._mVariantManagement&&Object.keys(this._oChangePersistence._oVariantController._mVariantManagement).length>0){D=this._oChangePersistence._oVariantController.fillVariantModel();}return D;};l.prototype.setVariantSwitchPromise=function(p){this._oVariantSwitchPromise=p;};l.prototype.waitForVariantSwitch=function(){if(!this._oVariantSwitchPromise){this._oVariantSwitchPromise=Promise.resolve();}return this._oVariantSwitchPromise;};l.prototype.createBaseChange=function(o,A){var i;var j;var k=f._getContextIdsFromUrl();if(k.length>1){throw new Error("More than one DesignTime Context is currently active.");}if(!A){throw new Error("No application component found. To offer flexibility a valid relation to its owning component must be present.");}o.reference=this.getComponentName();o.packageName="$TMP";o.context=k.length===1?k[0]:"";o.validAppVersions=U.getValidAppVersions({appVersion:this.getAppVersion(),developerMode:o.developerMode,scenario:o.scenario});i=c.createInitialFileContent(o);j=new c(i);if(o.variantReference){j.setVariantReference(o.variantReference);}return j;};l.prototype.createChange=function(o,i){var A;var j;return Promise.resolve().then(function(){if(!i){throw new Error("A flexibility change cannot be created without a targeted control.");}var s=i.id||i.getId();if(!o.selector){o.selector={};}A=i.appComponent||U.getAppComponentForControl(i);if(!A){throw new Error("No application component found. To offer flexibility, the control with the ID '"+s+"' has to have a valid relation to its owning application component.");}Object.assign(o.selector,J.getSelector(s,A));j=this.createBaseChange(o,A);var k=i.controlType||U.getControlType(i);if(!k){throw new Error("No control type found - the change handler can not be retrieved.");}return this._getChangeHandler(j,k,i,J);}.bind(this)).then(function(k){if(k){k.completeChangeContent(j,o,{modifier:J,appComponent:A});}else{throw new Error("Change handler could not be retrieved for change "+JSON.stringify(o)+".");}return j;});};l.prototype.createVariant=function(v,A){var o;var i;if(!A){throw new Error("No Application Component found - to offer flexibility the variant has to have a valid relation to its owning application component.");}if(v.content.variantManagementReference){var j=J.checkControlId(v.content.variantManagementReference,A);if(!j){throw new Error("Generated ID attribute found - to offer flexibility a stable VariantManagement ID is needed to assign the changes to, but for this VariantManagement control the ID was generated by SAPUI5 "+v.content.variantManagementReference);}}v.content.reference=this.getComponentName();v.content.packageName="$TMP";v.content.validAppVersions=U.getValidAppVersions(this.getAppVersion(),v.developerMode,v.scenario);i=V.createInitialFileContent(v);o=new V(i);return o;};l.prototype.addChange=function(o,i){return this.createChange(o,i).then(function(j){var A=U.getAppComponentForControl(i);this.addPreparedChange(j,A);return j;}.bind(this));};l.prototype.addPreparedChange=function(o,A){if(o.getVariantReference()){var m=A.getModel(U.VARIANT_MODEL_NAME);m.addChange(o);}this._oChangePersistence.addChange(o,A);return o;};l.prototype.deleteChange=function(o,A){this._oChangePersistence.deleteChange(o);if(o.getVariantReference()){A.getModel(U.VARIANT_MODEL_NAME).removeChange(o);}};l.prototype.createAndApplyChange=function(o,i){var j;return Promise.resolve().then(function(){return this.addChange(o,i);}.bind(this)).then(function(A){j=A;var p={modifier:J,appComponent:U.getAppComponentForControl(i),view:U.getViewForControl(i)};j.setQueuedForApply();return this.checkTargetAndApplyChange(j,i,p);}.bind(this)).then(function(r){if(!r.success){var k=r.error||new Error("The change could not be applied.");this._oChangePersistence.deleteChange(j,true);throw k;}return j;}.bind(this));};l.prototype._checkDependencies=function(o,D,m,A,r){var R=this._canChangePotentiallyBeApplied(o,A);if(!R){return[];}r.push(o);var s=o.getId();var j=D[s]&&D[s].dependencies||[];for(var i=0,n=j.length;i<n;i++){var k=U.getChangeFromChangesMap(m,j[i]);R=this._checkDependencies(k,D,m,A,r);if(R.length===0){r=[];break;}delete D[s];}return r;};l.prototype._canChangePotentiallyBeApplied=function(o,A){var s=o.getDependentControlSelectorList();s.push(o.getSelector());return!s.some(function(S){return!J.bySelector(S,A);});};l.prototype.waitForChangesToBeApplied=function(o){var m=this._oChangePersistence.getChangesMapForComponent();var p=[];var D=Object.assign({},m.mDependencies);var i=m.mChanges;var j=i[o.getId()]||[];var n=j.filter(function(k){return!k.isCurrentProcessFinished();},this);var A=U.getAppComponentForControl(o);var r=[];n.forEach(function(k){var q=this._checkDependencies(k,D,m.mChanges,A,[]);q.forEach(function(s){if(r.indexOf(s)===-1){r.push(s);}});}.bind(this));r.forEach(function(k){p=p.concat(k.addChangeProcessingPromises());},this);p.push(this.waitForVariantSwitch());return Promise.all(p).then(function(){return undefined;});};l.prototype.saveAll=function(s){return this._oChangePersistence.saveDirtyChanges(s);};l.prototype.processXmlView=function(v,p){var o=g.get(p.componentId);var A=U.getAppComponentForControl(o);var m=A.getManifest();p.appComponent=A;p.appDescriptor=m;p.modifier=X;p.view=v;return this.processViewByModifier(p);};l.prototype.processViewByModifier=function(p){p.siteId=U.getSiteId(p.appComponent);return this._oChangePersistence.getChangesForView(p.viewId,p).then(this._resolveGetChangesForView.bind(this,p),this._handlePromiseChainError.bind(this,p.view));};l.prototype._checkForDependentSelectorControls=function(o,p){var D=o.getDependentControlSelectorList();D.forEach(function(s){var i=p.modifier.bySelector(s,p.appComponent,p.view);if(!i){throw new Error("A dependent selector control of the flexibility change is not available.");}});};l.prototype._resolveGetChangesForView=function(p,i){var P=[];if(!Array.isArray(i)){var s="No list of changes was passed for processing the flexibility on view: "+p.view+".";h.error(s,undefined,"sap.ui.fl.FlexController");return[];}i.forEach(function(o){try{var S=this._getSelectorOfChange(o);if(!S||!S.id){throw new Error("No selector in change found or no selector ID.");}var j=p.modifier.bySelector(S,p.appComponent,p.view);if(!j){throw new Error("A flexibility change tries to change a nonexistent control.");}this._checkForDependentSelectorControls(o,p);o.setQueuedForApply();P.push(function(){var I=this._isChangeCurrentlyApplied(j,o,p.modifier);var m=o.isApplyProcessFinished();if(m&&!I){o.setInitialApplyState();}else if(!m&&I){o.markFinished();return new U.FakePromise();}return this.checkTargetAndApplyChange(o,j,p).then(function(r){if(!r.success){this._logApplyChangeError(r.error||{},o);}}.bind(this));}.bind(this));}catch(k){this._logApplyChangeError(k,o);}}.bind(this));return U.execPromiseQueueSequentially(P).then(function(){return p.view;});};l.prototype._logApplyChangeError=function(o,i){var D=i.getDefinition();var s=D.changeType;var t=D.selector.id;var j=D.namespace+D.fileName+"."+D.fileType;var w="A flexibility change could not be applied.";w+="\nThe displayed UI might not be displayed as intedend.";if(o.message){w+="\n   occurred error message: '"+o.message+"'";}w+="\n   type of change: '"+s+"'";w+="\n   LRep location of the change: "+j;w+="\n   id of targeted control: '"+t+"'.";h.warning(w,undefined,"sap.ui.fl.FlexController");};l.prototype._isXmlModifier=function(p){return p.modifier.targets==="xmlTree";};l.prototype.checkTargetAndApplyChange=function(o,i,p){var x=this._isXmlModifier(p);var m=p.modifier;var s=m.getControlType(i);var j=this._getControlIfTemplateAffected(o,i,s,p);var S;var r;var R;var k=m.getLibraryName(j.control);var w=new U.FakePromise();if(a.isChangeHandlerRegistrationInProgress(k)){w=a.waitForChangeHandlerRegistration(k);}return w.then(function(){return this._getChangeHandler(o,j.controlType,j.control,m);}.bind(this)).then(function(n){if(!n){var q="Change handler implementation for change not found or change type not enabled for current layer - Change ignored";h.warning(q);R={success:false,error:new Error(q)};o.setInitialApplyState();return R;}if(x&&o.getDefinition().jsOnly){R={success:false,error:new Error("Change cannot be applied in XML. Retrying in JS.")};o.setInitialApplyState();return R;}if(o.hasApplyProcessStarted()){return o.addPromiseForApplyProcessing().then(function(R){o.markFinished();return R;});}else if(!o.isApplyProcessFinished()){o.startApplying();var t;return this.isChangeHandlerRevertible(o,j.control,n).then(function(u){t=u;S=d.getInstanceOrUndef();if(!t&&S&&S._oSettings.recordUndo){if(x){throw new Error();}return new Promise(function(v){sap.ui.require(["sap/ui/rta/ControlTreeModifier"],function(y){if(!y){h.error("Please load 'sap/ui/rta' library if you want to record undo");}else{p.modifier=y;y.startRecordingUndo();r=y;}v();});});}}).then(function(){return n.applyChange(o,j.control,p);}).then(function(I){if(I instanceof E){j.control=I;}if(j.control){m.updateAggregation(i,o.getContent().boundAggregation);}if(!t&&S&&S._oSettings.recordUndo&&r){o.setUndoOperations(r.stopRecordingUndo());}F.addAppliedCustomData(j.control,o,p,t&&x);R={success:true};o.markFinished(R);return R;}).catch(function(u){this._logErrorAndWriteCustomData(u,o,p,j.control,x);R={success:false,error:u};if(x){o.setInitialApplyState();}else{o.markFinished(R);}return R;}.bind(this));}R={success:true};o.markFinished(R);return R;}.bind(this));};l.prototype._removeFromAppliedChangesAndMaybeRevert=function(o,i,p,r){var R=Promise.resolve(true);if(r){R=this._revertChange(o,i,p);}return R.then(function(j){this._removeChangeFromControl(i,o,p.modifier);return j;}.bind(this));};l.prototype._revertChange=function(o,i,p){var m=p.modifier;var s=m.getControlType(i);var j=this._getControlIfTemplateAffected(o,i,s,p);var S;var I;var k;return this._getChangeHandler(o,j.controlType,j.control,m).then(function(r){k=r;var M;if(!k){M="Change handler implementation for change not found or change type not enabled for current layer - Change ignored";}else if(!(typeof k.revertChange==="function")){M="No revert change function available to handle revert data for control type "+j.controlType;}if(M){h.error(M);o.markRevertFinished(new Error(M));return new U.FakePromise(false);}if(o.getChangeType()==="stashControl"&&s==="sap.ui.core._StashedControl"){S=true;if(!o.getRevertData()){k.setChangeRevertData(o,false);}}I=o.isApplyProcessFinished();if(!I&&o.hasApplyProcessStarted()){return o.addPromiseForApplyProcessing().then(function(R){if(R&&R.error){o.markRevertFinished(R.error);throw Error(R.error);}return true;});}return false;}).then(function(P){if(P||(!P&&I)||S){if(!o.getRevertData()){o.setRevertData(F.getParsedRevertDataFromCustomData(i,o,m));}o.startReverting();return k.revertChange(o,j.control,p);}throw Error("Change was never applied");}).then(function(){j.control=p.modifier.bySelector(o.getSelector(),p.appComponent,p.view);if(j.bTemplateAffected){m.updateAggregation(j.control,o.getContent().boundAggregation);}o.markRevertFinished();return true;}).catch(function(n){var q="Change could not be reverted: "+n.message;h.error(q);o.markRevertFinished(q);return false;});};l.prototype._removeChangeFromControl=function(o,i,m){F.destroyAppliedCustomData(o,i,m);};l.prototype._logErrorAndWriteCustomData=function(r,o,p,i,x){var s=o.getId();var j="Change ''{0}'' could not be applied.";var k=r instanceof Error;var m=F.getCustomDataIdentifier(false,k,x);switch(m){case F.notApplicableChangesCustomDataKey:U.formatAndLogMessage("info",[j,r.message],[s]);break;case F.failedChangesCustomDataKeyXml:U.formatAndLogMessage("warning",[j,"Merge error detected while processing the XML tree."],[s],r.stack);break;case F.failedChangesCustomDataKeyJs:U.formatAndLogMessage("error",[j,"Merge error detected while processing the JS control tree."],[s],r.stack);break;}F.addFailedCustomData(i,o,p,m);};l.prototype._isChangeCurrentlyApplied=function(o,i,m){return F.hasChangeApplyFinishedCustomData(o,i,m);};l.prototype._handlePromiseChainError=function(v,o){h.error("Error processing view "+o+".");return v;};l.prototype._getSelectorOfChange=function(o){if(!o||!o.getSelector){return undefined;}return o.getSelector();};l.prototype._getChangeHandler=function(o,s,i,m){var j=o.getChangeType();var k=o.getLayer();return this._getChangeRegistry().getChangeHandler(j,s,i,m,k);};l.prototype._getChangeRegistry=function(){var i=C.getInstance();i.initSettings();return i;};l.prototype._getControlIfTemplateAffected=function(o,i,s,p){var j=o.getDefinition();var m={};if(o.getContent().boundAggregation&&j.dependentSelector.originalSelector){var M=p.modifier;m.control=M.bySelector(j.dependentSelector.originalSelector,p.appComponent,p.view);m.controlType=M.getControlType(m.control);m.bTemplateAffected=true;}else{m.control=i;m.controlType=s;m.bTemplateAffected=false;}return m;};l.prototype.getComponentChanges=function(p,i){return this._oChangePersistence.getChangesForComponent(p,i);};l.prototype.checkForOpenDependenciesForControl=function(s,m,o){return this._oChangePersistence.checkForOpenDependenciesForControl(s,m,o);};l.prototype.hasHigherLayerChanges=function(p){p=p||{};var s=p.upToLayer||U.getCurrentLayer(false);p.includeVariants=true;p.includeCtrlVariants=true;return this.getComponentChanges(p).then(function(v){var H=v===this._oChangePersistence.HIGHER_LAYER_CHANGES_EXIST||v.some(function(o){return U.compareAgainstCurrentLayer(o.getLayer(),s)>0;});return!!H;}.bind(this));};l.prototype._createChangePersistence=function(){this._oChangePersistence=e.getChangePersistenceForComponent(this.getComponentName(),this.getAppVersion());return this._oChangePersistence;};l.prototype.resetChanges=function(s,G,o,S,i){return this._oChangePersistence.resetChanges(s,G,S,i).then(function(j){if(j.length!==0){return this.revertChangesOnControl(j,o);}}.bind(this)).then(function(){if(o){var m=o.getModel(U.VARIANT_MODEL_NAME);if(m){m.updateEntry({parameters:[],updateURL:true,updateHashEntry:true});}}});};l.prototype.discardChanges=function(i,D){var A=U.getCurrentLayer(!!D);var I=0;var j;var o;j=i.length;while(I<i.length){o=i[I];if(o&&o.getLayer&&o.getLayer()===A){this._oChangePersistence.deleteChange(o);}if(j===i.length){I++;}else{j=i.length;}}return this._oChangePersistence.saveDirtyChanges();};l.prototype.discardChangesForId=function(i,D){if(!i){return Promise.resolve();}var o=this._oChangePersistence.getChangesMapForComponent();var j=o.mChanges[i]||[];return this.discardChanges(j,D);};l.prototype._checkIfDependencyIsStillValid=function(A,m,s){var o=U.getChangeFromChangesMap(this._oChangePersistence._mChanges.mChanges,s);var i=m.bySelector(o.getSelector(),A);if(this._isChangeCurrentlyApplied(i,o,m)||o.hasApplyProcessStarted()){return false;}return true;};l.prototype._applyChangesOnControl=function(G,A,o){var p=[];var m=G();var i=m.mChanges;var D=m.mDependencies;var j=m.mDependentChangesOnMe;var k=i[o.getId()]||[];var P={modifier:J,appComponent:A,view:U.getViewForControl(o)};k.forEach(function(n){var s=J.getControlType(o);var q=this._getControlIfTemplateAffected(n,o,s,P);var I=this._isChangeCurrentlyApplied(q.control,n,P.modifier);var r=n.isApplyProcessFinished();if(r&&!I){m=this._oChangePersistence.copyDependenciesFromInitialChangesMap(n,this._checkIfDependencyIsStillValid.bind(this,A,P.modifier));D=m.mDependencies;j=m.mDependentChangesOnMe;n.setInitialApplyState();}else if(!r&&I){n.markFinished();}n.setQueuedForApply();if(!D[n.getId()]){p.push(function(){return this.checkTargetAndApplyChange(n,o,P).then(function(){this._updateDependencies(D,j,n.getId());}.bind(this));}.bind(this));}else{D[n.getId()][l.PENDING]=this.checkTargetAndApplyChange.bind(this,n,o,P);}}.bind(this));if(k.length){return U.execPromiseQueueSequentially(p).then(function(){return this._processDependentQueue(D,j,A);}.bind(this));}return new U.FakePromise();};l.prototype.getBoundApplyChangesOnControl=function(G,o){var B=this._applyChangesOnControl.bind(this,G,o);B._bIsSapUiFlFlexControllerApplyChangesOnControl=true;return B;};l.prototype.revertChangesOnControl=function(i,A){var p=[];i.forEach(function(o){o.setQueuedForRevert();p.push(function(){var s=this._getSelectorOfChange(o);var j=J.bySelector(s,A);var P={modifier:J,appComponent:A,view:U.getViewForControl(j)};return this._removeFromAppliedChangesAndMaybeRevert(o,j,P,true).then(function(S){if(S){this._oChangePersistence._deleteChangeInMap(o);}}.bind(this));}.bind(this));}.bind(this));return U.execPromiseQueueSequentially(p);};l.prototype.isChangeHandlerRevertible=function(o,v,i){var p=new U.FakePromise(i);if(!i){var s=v.controlType?v.controlType:J.getControlType(v);p=p.then(this._getChangeHandler.bind(this,o,s,v,J));}return p.then(function(i){return!!(i&&typeof i.revertChange==="function");});};l.prototype.applyVariantChanges=function(i,A){var p=[];i.forEach(function(o){this._oChangePersistence._addChangeAndUpdateDependencies(A,o);p.push(function(){var m=J;var s=this._getSelectorOfChange(o);var j=m.bySelector(s,A);if(!j){h.error("A flexibility change tries to change a nonexistent control.");return new U.FakePromise();}return this._applyChangesOnControl(this._oChangePersistence.getChangesMapForComponent.bind(this._oChangePersistence),A,j);}.bind(this));}.bind(this));return U.execPromiseQueueSequentially(p);};l.prototype.removeFromAppliedChangesOnControl=function(o,A,i){var p={modifier:J,appComponent:A,view:U.getViewForControl(i)};return this._removeFromAppliedChangesAndMaybeRevert(o,i,p,false);};l.prototype._updateControlsDependencies=function(D,A){var o;Object.keys(D).forEach(function(s){var i=D[s];if(i.controlsDependencies&&i.controlsDependencies.length>0){var j=i.controlsDependencies.length;while(j--){var S=i.controlsDependencies[j];o=J.bySelector(S,A);if(o){i.controlsDependencies.splice(j,1);}}}});};l.prototype._updateDependencies=function(D,m,s){if(m[s]){m[s].forEach(function(k){var o=D[k];var i=o?o.dependencies.indexOf(s):-1;if(i>-1){o.dependencies.splice(i,1);}});delete m[s];}};l.prototype._iterateDependentQueue=function(D,m,A){var i=[];var n=[];var p=[];this._updateControlsDependencies(D,A);Object.keys(D).forEach(function(s){var o=D[s];if(o[l.PENDING]&&o.dependencies.length===0&&!(o.controlsDependencies&&o.controlsDependencies.length>0)){p.push(function(){return o[l.PENDING]().then(function(){n.push(s);i.push(o.changeObject.getId());});});}});return U.execPromiseQueueSequentially(p).then(function(){for(var j=0;j<n.length;j++){delete D[n[j]];}for(var k=0;k<i.length;k++){this._updateDependencies(D,m,i[k]);}return i;}.bind(this));};l.prototype._processDependentQueue=function(D,m,A){return this._iterateDependentQueue(D,m,A).then(function(i){if(i.length>0){return this._processDependentQueue(D,m,A);}}.bind(this));};l.prototype.saveSequenceOfDirtyChanges=function(D){return this._oChangePersistence.saveSequenceOfDirtyChanges(D);};l.prototype.getResetAndPublishInfo=function(p){p.reference=this._sComponentName;p.appVersion=this._sAppVersion;return L.createConnector().getFlexInfo(p);};return l;},true);
