/*
 * ! OpenUI5
 * (c) Copyright 2009-2019 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

sap.ui.define([
	"sap/ui/fl/apply/_internal/ChangesController",
	"sap/ui/fl/Cache"
], function(
	ChangesController,
	Cache
) {
	"use strict";

	var UI2PersonalizationApplyAPI = {
		/**
		 * Retrieves a personalization object stored for an application under a given container ID and item name;
		 * in case no itemName is given all items for the given container key are returned.
		 *
		 * @param {object} mPropertyBag - Object with parameters as properties
		 * @param {sap.ui.fl.Selector} mPropertyBag.selector - Used to retrieve the associated flex persistence
		 * @param {string} mPropertyBag.containerKey The key of the container in which the personalization was stored
		 * @param {string} [mPropertyBag.itemName] The item name under which the personalization was stored
		 * @returns {Promise} Promise resolving with the object stored under the passed container key and item name,
		 * or undefined in case no entry was stored for these;
		 * in case no sItemName was passed all entries known for the container key
		 */
		load: function(mPropertyBag) {
			var oFlexController = ChangesController.getDescriptorFlexControllerInstance(mPropertyBag.selector);

			mPropertyBag.reference = oFlexController.getComponentName();
			mPropertyBag.appVersion = oFlexController.getAppVersion();

			if (
				!mPropertyBag.reference
				|| !mPropertyBag.containerKey
			) {
				return Promise.reject(new Error("not all mandatory properties were provided for the loading of the personalization"));
			}

			return Cache.getPersonalization(mPropertyBag.reference, mPropertyBag.appVersion, mPropertyBag.containerKey, mPropertyBag.itemName);
		}
	};

	return UI2PersonalizationApplyAPI;
}, true);