/*!
 * OpenUI5
 * (c) Copyright 2009-2019 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["sap/ui/core/Control","sap/ui/model/resource/ResourceModel","./utils/ObjectBinding","sap/base/util/ObjectPath",'sap/base/util/merge',"sap/base/util/deepClone","sap/ui/model/json/JSONModel","sap/base/i18n/ResourceBundle","sap/ui/model/BindingMode"],function(C,R,O,a,m,d,J,b,B){"use strict";var c=C.extend("sap.ui.integration.designtime.controls.BaseEditor",{metadata:{properties:{"config":{type:"object"},"json":{type:"object",multiple:false},"_defaultConfig":{type:"object",visibility:"hidden",defaultValue:{}}},aggregations:{"_propertyEditors":{type:"sap.ui.core.Control",visibility:"hidden"}},events:{jsonChanged:{parameters:{json:{type:"object"}}},propertyEditorsReady:{parameters:{propertyEditors:{type:"array"}}}}},init:function(){this.setConfig({});},exit:function(){this._cleanup();},renderer:function(r,e){r.write("<div");r.writeElementData(e);r.addClass("sapUiIntegrationEditor");r.writeClasses();r.writeStyles();r.write(">");e.getPropertyEditors().forEach(function(p){p.addStyleClass("sapUiSmallMargin");r.renderControl(p);});r.write("</div>");},setJson:function(j){if(typeof j==="string"){j=JSON.parse(j);}var r=this.setProperty("json",j,false);this._initialize();return r;},addDefaultConfig:function(o){return this.setProperty("_defaultConfig",this._mergeConfig(this.getProperty("_defaultConfig"),o));},setConfig:function(o){return this._setConfig(this._mergeConfig(this.getProperty("_defaultConfig"),o));},addConfig:function(n){return this._setConfig(this._mergeConfig(this.getConfig(),n));},getPropertyEditor:function(p){return this._mPropertyEditors[p];},getPropertyEditors:function(t){var h=function(p,T){return p.getPropertyInfo().tags&&(p.getPropertyInfo().tags.indexOf(T)!==-1);};if(!t){return this.getAggregation("_propertyEditors");}else if(typeof t==="string"){return this.getPropertyEditors().filter(function(p){return h(p,t);});}else if(Array.isArray(t)){return this.getPropertyEditors().filter(function(p){return t.every(function(T){return h(p,T);});});}else{return[];}}});c.prototype._mergeConfig=function(t,s){var r=d(t);m(r,s);r.i18n=[].concat(t.i18n||[],s.i18n||[]);return r;};c.prototype._setConfig=function(o){var r=this.setProperty("config",o,false);this._initialize();return r;};c.prototype._cleanup=function(o){if(this._oContextModel){this._oContextModel.destroy();delete this._oContextModel;}if(this._oPropertyModel){this._oPropertyModel.destroy();delete this._oPropertyModel;}if(this._oI18nModel){this._oI18nModel.destroy();delete this._oI18nModel;}if(this._oPropertyObjectBinding){this._oPropertyObjectBinding.destroy();delete this._oPropertyObjectBinding;}this._mPropertyEditors={};this.destroyAggregation("_propertyEditors");};c.prototype._initialize=function(){this._cleanup();if(this.getConfig()&&this.getConfig().properties){this._createModels();this._createEditors();}};c.prototype._createModels=function(){this._createContextModel();this._createPropertyModel();this._createI18nModel();};c.prototype._createContextModel=function(){var o=this.getJson();var e=this.getConfig();if(e.context){o=a.get(e.context.split("/"),o);}this._oContextModel=new J(o);this._oContextModel.setDefaultBindingMode(B.OneWay);};c.prototype._createPropertyModel=function(){var o=this.getConfig();this._oPropertyModel=new J(o.properties);this._oPropertyModel.setDefaultBindingMode(B.OneWay);this._oPropertyObjectBinding=new O(o.properties,this._oPropertyModel,"properties");Object.keys(o.properties).forEach(function(p){var P=o.properties[p];if(P.path){this._syncPropertyValue(P);}}.bind(this));};c.prototype._createI18nModel=function(){var o=this.getConfig();o.i18n.forEach(function(i){b.create({url:sap.ui.require.toUrl(i),async:true}).then(function(e){if(!this._oI18nModel){this._oI18nModel=new R({bundle:e});this.setModel(this._oI18nModel,"i18n");this._oI18nModel.setDefaultBindingMode(B.OneWay);}else{this._oI18nModel.enhance(e);}}.bind(this));}.bind(this));};c.prototype._syncPropertyValue=function(p){var o=this._oContextModel.getData();if(o&&p.path){p.value=a.get(p.path.split("/"),o);}if(typeof p.value==="undefined"){p.value=p.defaultValue;}};c.prototype._createEditors=function(){var o=this.getConfig();var t=Object.keys(o.propertyEditors);var M=t.map(function(T){return o.propertyEditors[T];});var e={};this.__createEditorsCallCount=(this.__createEditorsCallCount||0)+1;var i=this.__createEditorsCallCount;sap.ui.require(M,function(){if(this.__createEditorsCallCount===i){Array.from(arguments).forEach(function(E,I){e[t[I]]=E;});Object.keys(o.properties).forEach(function(p){var P=this._oPropertyModel.getContext("/"+p);var E=e[P.getObject().type];if(E){this._mPropertyEditors[p]=this._createPropertyEditor(E,P);this.addAggregation("_propertyEditors",this._mPropertyEditors[p]);}}.bind(this));this.firePropertyEditorsReady({propertyEditors:this.getPropertyEditors()});}}.bind(this));};c.prototype._createPropertyEditor=function(E,p){var P=new E({visible:typeof p.getObject().visible!==undefined?p.getObject().visible:true});P.setModel(this._oPropertyModel);P.setBindingContext(p);P.setModel(this._oContextModel,"context");P.attachPropertyChanged(this._onPropertyChanged.bind(this));return P;};c.prototype._onPropertyChanged=function(e){var p=e.getParameter("path");this._oContextModel.setProperty("/"+p,e.getParameter("value"));this._updatePropertyModel(p);this.fireJsonChanged({json:d(this.getJson())});};c.prototype._updatePropertyModel=function(p){var P=this._oPropertyModel.getData();Object.keys(P).filter(function(k){return P[k].path===p;}).forEach(function(k){this._syncPropertyValue(P[k]);}.bind(this));this._oPropertyModel.checkUpdate();};return c;});
