//@ui5-bundle sap/ui/integration/library-preload.js
/*!
 * OpenUI5
 * (c) Copyright 2009-2019 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine('sap/ui/integration/Widget',["sap/ui/thirdparty/jquery","sap/ui/core/Core","sap/ui/core/Control","sap/ui/integration/util/Manifest","sap/base/Log",'sap/ui/model/json/JSONModel',"sap/ui/model/resource/ResourceModel","sap/ui/integration/WidgetRenderer","sap/ui/integration/library","sap/base/util/LoaderExtensions","sap/ui/core/ComponentContainer"],function(q,C,a,W,L,J,R,b,l,c,d){"use strict";var M={APP_TYPE:"/sap.app/type",PARAMS:"/sap.widget/configuration/parameters"};
var e=a.extend("sap.ui.integration.Widget",{
metadata:{library:"sap.ui.integration",properties:{manifest:{type:"any",defaultValue:""},parameters:{type:"object",defaultValue:null},configuration:{type:"object"},baseUrl:{type:"string",defaultValue:""}},aggregations:{_content:{type:"sap.ui.core.Control",multiple:false,visibility:"hidden"}},events:{action:{parameters:{actionSource:{type:"sap.ui.core.Control"},manifestParameters:{type:"object"}}}}},
renderer:b
});
e.prototype.init=function(){this.setBusyIndicatorDelay(0);};
e.prototype.onBeforeRendering=function(){if(this._bApplyManifest){this._bApplyManifest=false;var m=this.getManifest();if(!m){this.destroyManifest();}else{this.createManifest(m,this.getBaseUrl());}}};
e.prototype.exit=function(){this.destroyManifest();};
e.prototype.destroyManifest=function(){if(this._oWidgetManifest){this._oWidgetManifest.destroy();this._oWidgetManifest=null;}this.destroyAggregation("_content");};
e.prototype.setManifest=function(v){this.setProperty("manifest",v);this._bApplyManifest=true;return this;};
e.prototype.setParameters=function(v){this.setProperty("parameters",v);this._bApplyManifest=true;return this;};
e.prototype.getManifest=function(){var v=this.getProperty("manifest");if(v&&typeof v==="object"){return q.extend(true,{},v);}return v;};
e.prototype.createManifest=function(m,B){var o={};if(typeof m==="string"){o.manifestUrl=m;m=null;}this.setBusy(true);this._oWidgetManifest=new W("sap.widget",m,B);this._oWidgetManifest.load(o).then(this._applyManifest.bind(this)).catch(this._applyManifest.bind(this));};
e.prototype.setConfiguration=function(v){this._bApplyManifest=true;this.setBusy(true);this.setProperty("configuration",v);return this;};
e.prototype.getParameters=function(){var v=this.getProperty("parameters");if(v&&typeof v==="object"){return q.extend(true,{},v);}return v;};
e.prototype._applyManifest=function(){var p=this.getParameters(),A=this._oWidgetManifest.get(M.APP_TYPE),o=this.getConfiguration();if(A&&A!=="widget"){L.error("sap.app/type entry in manifest is not 'widget'");}this._oWidgetManifest._mergeConfiguration(o);this._createComponent(this._oWidgetManifest.getJson());this._registerManifestModulePath();this._oWidgetManifest.processParameters(p);};
e.prototype._registerManifestModulePath=function(){if(!this._oWidgetManifest){return;}var A=this._oWidgetManifest.get("/sap.app/id");if(A){c.registerResourcePath(A.replace(/\./g,"/"),this._oWidgetManifest.getUrl());}else{L.error("Widget sap.app/id entry in the manifest is mandatory");}};
e.prototype._createComponent=function(m){var o=new d({manifest:m,async:true,componentCreated:function(E){var o=E.getParameter("component");this.setBusy(false);o.attachEvent("action",function(E){this.fireEvent("action",{actionSource:E.getParameter("actionSource"),manifestParameters:E.getParameter("manifestParameters")});}.bind(this));}.bind(this),componentFailed:function(E){this.setBusy(false);L.error(E.getParameter("reason"));}});this.setAggregation("_content",o);};
e.prototype.loadDesigntime=function(){if(!this._oWidgetManifest){return Promise.reject("Manifest not yet available");}var A=this._oWidgetManifest.get("/sap.app/id");if(!A){return Promise.reject("App id not maintained");}var m=A.replace(/\./g,"/");return new Promise(function(r,f){var s=m+"/"+(this._oWidgetManifest.get("/sap.widget/designtime")||"designtime/Widget.designtime");if(s){sap.ui.require([s,"sap/base/util/deepClone"],function(D,g){r({configuration:g(this._oWidgetManifest.get("/sap.widget"),30),designtime:D,manifest:g(this._oWidgetManifest.oJson,30)});}.bind(this),function(){f({error:s+" not found"});});}else{f();}}.bind(this));};
return e;});
sap.ui.predefine('sap/ui/integration/WidgetComponent',["sap/ui/core/UIComponent","sap/ui/model/json/JSONModel"],function(U,J){"use strict";
var W=U.extend("sap.ui.integration.WidgetComponent");
W.prototype.init=function(){var r=U.prototype.init.apply(this,arguments);this._applyWidgetModel();return r;};
W.prototype._applyWidgetModel=function(){var m=new J();m.setData(this.getManifestEntry("sap.widget")||{});this.setModel(m,"sap.widget");};
W.prototype.fireAction=function(p){this.oContainer.getParent().fireAction(p);};
W.prototype.getWidgetConfiguration=function(p){return this.getModel("sap.widget").getProperty(p||"/");};
W.prototype.update=function(){};
return W;});
sap.ui.predefine('sap/ui/integration/WidgetRenderer',[],function(){"use strict";var W={},r=sap.ui.getCore().getLibraryResourceBundle("sap.f");
W.render=function(R,w){var c=w.getAggregation("_content");R.write("<div");R.writeElementData(w);R.writeClasses();R.writeAccessibilityState(w,{role:"region",roledescription:{value:r.getText("ARIA_ROLEDESCRIPTION_CARD"),append:true}});R.write(">");if(c){R.renderControl(c);}R.write("</div>");};
return W;});
sap.ui.predefine('sap/ui/integration/host/HostConfiguration',['sap/ui/core/Control',"sap/ui/integration/host/HostConfigurationCompiler"],function(C,H){"use strict";
var a=C.extend("sap.ui.integration.host.HostConfiguration",{
metadata:{library:"sap.ui.integration",properties:{config:{type:"any"},css:{type:"string"}},events:{cssChanged:{}}},
renderer:function(r,c){r.write("<style ");r.writeElementData(c);r.write(">");r.write(c._getCssText()||"");r.write("</style>");}
});
a.prototype.setConfig=function(v,s){this._sCssText=null;return this.setProperty("config",v,s);};
a.prototype.setCss=function(v,s){this._sCssText=null;return this.setProperty("css",v,s);};
a.prototype.onBeforeRendering=function(){if(!this._sCssText){if(this.getCss()){this._applyCss();}else{this._applyConfig();}}};
a.prototype._applyCss=function(){var c=this.getCss();H.loadResource(c,"text").then(function(s){this._sCssText=s;this.invalidate();}.bind(this)).catch(function(){});};
a.prototype._applyConfig=function(){var v=this.getConfig();if(typeof v==="string"){H.loadResource(v,"json").then(function(v){this._oConfig=v;this.invalidate();}.bind(this)).catch(function(){});}else if(typeof v==="object"&&!Array.isArray(v)){this._oConfig=v;this.invalidate();}};
a.prototype._getCssText=function(){var c=this._oConfig;if(!c&&!this.getCss()){return"";}if(this._sCssText){return this._sCssText;}var s=this.getId().replace(/-/g,"_").replace(/\./g,"_").replace(/\,/g,"_");this._sCssText=H.generateCssText(this._oConfig,s);this.fireCssChanged({cssText:this._sCssText});return this._sCssText;};
a.prototype.generateJSONSettings=function(t){return H.generateJSONSettings(this._oConfig,t);};
return a;});
sap.ui.predefine('sap/ui/integration/host/HostConfigurationCompiler',["sap/ui/thirdparty/less","sap/base/Log"],function(L,a){"use strict";var p=jQuery.sap.loadResource("sap/ui/integration/host/HostConfigurationMap.json",{dataType:"json"}),l=jQuery.sap.loadResource("sap/ui/integration/host/HostConfiguration.less",{dataType:"text"});
function b(u,t){return new Promise(function(r,e){jQuery.ajax({url:u,async:true,dataType:t,success:function(j){r(j);},error:function(){e();}});});}
function _(n,P){if(!P){return n;}var e=P.split("/"),i=0;if(!e[0]){n=n;i++;}while(n&&e[i]){n=n[e[i]];i++;}return n;}
function g(C,s){var m=p.less,P=[];for(var n in m){var M=m[n],v=_(C,M.path),u=M.unit;if(v){P.push(n+":"+v+(u?u:""));}else{P.push(n+": /*null*/");}}var r=l.replace(/\#hostConfigName/g,"."+s);r=r.replace(/\/\* HOSTCONFIG PARAMETERS \*\//,P.join(";\n")+";");var o=new L.Parser(),S="";o.parse(r,function(e,R){try{S=R.toCSS();}catch(f){S=" ";}});return S;}
function c(C,N){function e(C,v){var r=null;if(v.path){r=_(C,v.path);if(v.unit){v.unit=r+v.unit;}}else if(v.value){r=v.value;}else if(Array.isArray(v)){r=[];for(var i=0;i<v.length;i++){r.push(e(C,v[i]));}}return r;}var m=p[N],s={};for(var n in m){var M=m[n],o=n.split("/"),f=s;if(M){for(var i=0;i<o.length-1;i++){if(f[o[i]]===undefined){f[o[i]]={};}f=f[o[i]];}f[o[o.length-1]]=e(C,M);}}return s;}
function d(C,o){return b(C,"json").then(function(o){return g(o,o);});}
return{loadResource:b,generateCssText:g,generateCssTextAsync:d,generateJSONSettings:c};});
sap.ui.predefine('sap/ui/integration/library',["sap/ui/base/DataType","sap/ui/Global","sap/ui/core/library","sap/m/library","sap/f/library"],function(D){"use strict";sap.ui.getCore().initLibrary({name:"sap.ui.integration",version:"1.70.0",dependencies:["sap.ui.core","sap.f","sap.m"],types:["sap.ui.integration.CardActionType","sap.ui.integration.CardDataMode"],controls:["sap.ui.integration.widgets.Card","sap.ui.integration.Widget","sap.ui.integration.host.HostConfiguration"],elements:[],noLibraryCSS:true,customTags:{"card":"sap/ui/integration/widgets/Card","widget":"sap/ui/integration/Widget","host-configuration":"sap/ui/integration/host/HostConfiguration"},defaultTagPrefix:"ui"});var t=sap.ui.integration;t.CardActionType={Navigation:"Navigation"};t.CardDataMode={Active:"Active",Inactive:"Inactive"};return t;});
sap.ui.predefine('sap/ui/integration/services/Data',['./Service'],function(S){"use strict";var D=S.extend();
D.prototype.attachDataChanged=function(d,p){};
D.prototype.detachDataChanged=function(d){};
D.prototype.getData=function(i){return Promise.resolve(false);};
return D;});
sap.ui.predefine('sap/ui/integration/services/Navigation',['./Service'],function(S){"use strict";var N=S.extend();
N.prototype.navigate=function(c){};
S.prototype.enabled=function(c){return Promise.resolve(false);};
return N;});
sap.ui.predefine('sap/ui/integration/services/Service',[],function(){"use strict";var S=function(){};
S.extend=function(C){if(!C){var t=this;C=function(){t.apply(this,arguments);};}C.prototype=Object.create(this.prototype);C.prototype.constructor=C;C.extend=this.extend.bind(C);return C;};
S.prototype.getInterface=function(){return this;};
return S;});
sap.ui.predefine('sap/ui/integration/util/CustomElements',["sap/base/Log"],function(L){"use strict";var E=window.Element;if(E.prototype.getAttributeNames==undefined){E.prototype.getAttributeNames=function(){var g=this.attributes;var l=g.length;var r=new Array(l);for(var i=0;i<l;i++){r[i]=g[i].name;}return r;};}var e=document.createElement("span"),o,I={registerTag:function registerTag(t,p,g){p=p+"-";var h=p+t;d.apply(this,[h,g]);},coreInstance:null};
function a(){if(typeof window.CustomEvent==="function"){return false;}function C(g,p){p=p||{bubbles:false,cancelable:false,detail:undefined};var h=document.createEvent('CustomEvent');h.initCustomEvent(g,p.bubbles,p.cancelable,p.detail);return h;}C.prototype=window.Event.prototype;window.CustomEvent=C;}
function f(n,g,h){var i=new window.CustomEvent(g),j=n.getAttribute("on-"+g);i.data=h;if(j){e.setAttribute("onclick",j);n.addEventListener(g,e.onclick);}n.dispatchEvent(i);}
function c(){var g={childList:true,subtree:true};function h(m,o){m.forEach(function(j){if(j.type=='childList'){var k=j.addedNodes,r=j.removedNodes,n,x,l,t,i;for(l=0;l<k.length;l++){n=k[l];if(!document.createCustomElement._querySelector){return;}if(n.tagName&&document.createCustomElement.hasOwnProperty(n.tagName.toLowerCase())){if(!n._control){document.createCustomElement[n.tagName.toLowerCase()].connectToNode(n);}n._control._connectedCallback();}if(n.tagName){t=n.querySelectorAll(document.createCustomElement._querySelector);for(i=0;i<t.length;i++){x=t[i];if(x.tagName&&document.createCustomElement.hasOwnProperty(x.tagName.toLowerCase())){if(!x._control){document.createCustomElement[x.tagName.toLowerCase()].connectToNode(x);}x._control._connectedCallback();}}}}for(l=0;l<r.length;l++){n=r[l];if(!document.createCustomElement._querySelector){return;}if(n._control){n._control._disconnectedCallback();}if(n.tagName){t=n.querySelectorAll(document.createCustomElement._querySelector);for(i=0;i<t.length;i++){x=t[i];if(x._control){x._control._disconnectedCallback();}}}}}else if(j.type==="attributes"&&j.target&&j.target._control){j.target._control._changeProperty.call(j.target._control,j.attributeName,j.target.getAttribute(j.attributeName));}});}var o=new window.MutationObserver(h);if(!document.body){L.error("CustomElements.js was loaded before a body element was present in the DOM. Ensure to load CustomElements.js after the document was parsed, i.e. after the windows onload event.");return null;}o.observe(document.body,g);return o;}
function b(t){if(typeof t!=="string"){return false;}try{JSON.parse(t);return true;}catch(g){return false;}}
function d(p,T){if(document.createCustomElement[p]){return document.createCustomElement[p];}var t=T.getMetadata(),g=t.getAllProperties(),h=t.getAllAssociations(),j=t.getEvents(),k={};Object.keys(g).map(function(n){k[n.toLowerCase()]=g[n];});Object.keys(h).map(function(n){k[n.toLowerCase()]=h[n];});Object.keys(j).map(function(n){k["on-"+n.toLowerCase()]=j[n];});var l=function(r){this._node=r;r._control=this;l.initCloneNode(r);l.defineProperties(r);this._controlImpl=this._controlImpl||new T();this._changeProperties(r);this._uiArea=I.coreInstance.createUIArea(r);this._uiArea.addContent(this._controlImpl);if(l.isInActiveDocument(r)){this._connectedCallback();}Object.keys(j).map(function(n){this._controlImpl[j[n]._sMutator](function(s){f(r,n,s);});}.bind(this));return r;};l.cloneNode=function(){var n=this._cloneNode.call(this);n.removeAttribute("data-sap-ui-area");n.removeAttribute("id");n._controlImpl=this._control._controlImpl.clone();l.connectToNode(n);return n;};l.initCloneNode=function(r){if(!r._cloneNode){r._cloneNode=r.cloneNode;r.cloneNode=l.cloneNode;}};l.isInActiveDocument=function(r){return!!(r.parentNode&&r.ownerDocument===document);};l.defineProperty=function(r,n,s){Object.defineProperty(r,n,{get:function(){return t.getProperty(n).get(r._control._controlImpl);},set:function(v){r._control._changeProperty(n,v);return t.getProperty(n).get(r._control._controlImpl);}});};l.defineProperties=function(r){for(var n in k){if(n.charAt(0)!=="_"){l.defineProperty(r,n,k[n].defaultValue);}}};l.observer=o;l.connectToNode=function(r){new l(r);return l.observer&&l.observer.observe(r,{attributes:true});};l.prototype._connectedCallback=function(){this._connected||((this._connected=true)&&this._controlImpl.invalidate());};l.prototype._disconnectedCallback=function(){this._connected=false;};l.prototype._changeProperties=function(r){var n=r.getAttributeNames();for(var i=0;i<n.length;i++){this._changeProperty(n[i],r.getAttribute(n[i]));}};l.prototype._changeProperty=function(n,u){var v=this._controlImpl,w=k[n];if(n==="id"){return;}if(w&&(w._iKind===0||w._iKind===3)){var x=w.getType();var V=x.parseValue(u);var O=w.get(v);if(n==="manifest"&&x.getName()==="any"&&b(V)){V=JSON.parse(V);}if(x.isValid(V)){w.set(v,V);}else{w.set(v,O);}}else if(n==="class"){var C=u.split(" ");this._addedClasses=this._addedClasses||[];this._addedClasses.forEach(function(s){if(s){v.removeStyleClass(s);}});C.forEach(function(s){s=v.addStyleClass(s);});this._addedClasses=C;}};l.prototype.fireCustomEvent=function(n,s){f(this._node,n,s);};var m=document.createCustomElement;m[p]=l;if(m._querySelector){m._querySelector+=",";}else{Object.defineProperty(m,"_querySelector",{enumerable:false,writable:true});m._querySelector="";}var S=p.replace("-","\\-");m._querySelector+=S;var q=document.querySelectorAll(S);for(var i=0;i<q.length;i++){var r=q[i];m[p].connectToNode(r);}return l;}
if(!document.createCustomElement){document.createCustomElement=function(t){var n=document.createElement(t);document.createCustomElement[t].connectToNode(n);return n;};}a();o=c();return I;});
sap.ui.predefine('sap/ui/integration/util/Manifest',["sap/ui/base/Object","sap/ui/core/Manifest","sap/base/util/deepClone","sap/base/util/merge","sap/base/Log"],function(B,C,d,m,L){"use strict";var M="/{SECTION}/configuration/parameters",a="/{SECTION}";
var b=B.extend("sap.ui.integration.util.Manifest",{constructor:function(s,o,i){B.call(this);this.PARAMETERS=M.replace("{SECTION}",s);this.CONFIGURATION=a.replace("{SECTION}",s);if(o){var O={};O.process=false;if(i){O.baseUrl=i;this._sBaseUrl=i;}else{L.warning("If no base URL is provided when the manifest is an object static resources cannot be loaded.");}this._oManifest=new C(o,O);this.oJson=this._oManifest.getRawJson();}}});
b.prototype.getJson=function(){return this._unfreeze(this.oJson);};
b.prototype.get=function(P){return this._unfreeze(h(this.oJson,P));};
b.prototype.getUrl=function(){return this._oManifest.resolveUri("./","manifest");};
b.prototype.getResourceBundle=function(){return this.oResourceBundle;};
b.prototype._unfreeze=function(v){if(typeof v==="object"){return JSON.parse(JSON.stringify(v));}return v;};
b.prototype.destroy=function(){this.oJson=null;this.oResourceBundle=null;if(this._oManifest){this._oManifest.destroy();}};
b.prototype.load=function(s){if(!s||!s.manifestUrl){if(this._sBaseUrl&&this._oManifest){return this.loadI18n().then(function(){this.processManifest();}.bind(this));}else{return new Promise(function(r,i){i("Cannot load manifest.");});}}return C.load({manifestUrl:s.manifestUrl,async:true}).then(function(o){this._oManifest=o;this.oJson=this._oManifest.getRawJson();return this.loadI18n().then(function(){this.processManifest();}.bind(this));}.bind(this));};
b.prototype.loadI18n=function(){return this._oManifest._loadI18n(true).then(function(o){this.oResourceBundle=o;}.bind(this));};
b.prototype.processManifest=function(P){var i=0,j=15,u=jQuery.extend(true,{},this._oManifest.getRawJson());g(u,this.oResourceBundle,i,j,P);c(u);this.oJson=u;};
function c(o){if(o&&typeof o==='object'&&!Object.isFrozen(o)){Object.freeze(o);for(var k in o){if(o.hasOwnProperty(k)){c(o[k]);}}}}
function e(v){return(typeof v==="string")&&v.indexOf("{{")===0&&v.indexOf("}}")===v.length-2;}
function f(v){return(typeof v==="string")&&(v.indexOf("{{parameters.")>-1);}
function p(P,o){var i=new Date().toISOString();var s=P.replace("{{parameters.NOW_ISO}}",i);s=s.replace("{{parameters.TODAY_ISO}}",i.slice(0,10));if(o){for(var j in o){s=s.replace("{{parameters."+j+"}}",o[j].value);}}return s;}
function g(o,r,i,j,P){if(i===j){return;}if(Array.isArray(o)){o.forEach(function(I,k,A){if(typeof I==="object"){g(I,r,i+1,j,P);}else if(f(I,o,P)){A[k]=p(I,P);}else if(e(I)&&r){A[k]=r.getText(I.substring(2,I.length-2));}},this);}else{for(var s in o){if(typeof o[s]==="object"){g(o[s],r,i+1,j,P);}else if(f(o[s],o,P)){o[s]=p(o[s],P);}else if(e(o[s])&&r){o[s]=r.getText(o[s].substring(2,o[s].length-2));}}}}
function h(o,P){if(o&&P&&typeof P==="string"&&P[0]==="/"){var j=P.substring(1).split("/"),s;for(var i=0,l=j.length;i<l;i++){s=j[i];o=o.hasOwnProperty(s)?o[s]:undefined;if(o===null||typeof o!=="object"){if(i+1<l&&o!==undefined){o=undefined;}break;}}return o;}return o&&o[P];}
b.prototype.processParameters=function(P){if(!this._oManifest){return;}var o=this.get(this.PARAMETERS);if(P&&!o){L.error("If parameters property is set, parameters should be described in the manifest");return;}var i=this._syncParameters(P,o);this.processManifest(i);};
b.prototype._mergeConfiguration=function(o){if(!this._oManifest){return;}if(!o){return;}var i=this.get(this.CONFIGURATION),j=d(this.oJson,30,30);j[this.CONFIGURATION.substring(1)]=m({},i,o);this._oManifest._oManifest=j;this.oJson=j;};
b.prototype._syncParameters=function(P,o){if(!P){return o;}var k=d(o,20,20),l=Object.getOwnPropertyNames(P),n=Object.getOwnPropertyNames(k);for(var i=0;i<n.length;i++){for(var j=0;j<l.length;j++){if(n[i]===l[j]){k[n[i]].value=P[l[j]];}}}return k;};
return b;},true);
sap.ui.predefine('sap/ui/integration/util/ServiceManager',["sap/ui/base/EventProvider","sap/base/Log"],function(E,L){"use strict";
var S=E.extend("sap.ui.integration.util.ServiceManager",{
metadata:{library:"sap.ui.integration"},
constructor:function(s,o){if(!s){throw new Error("Missing manifest services reference!");}if(!o){throw new Error("Missing context object");}this._mServiceFactoryReferences=s;this._mServices={};this._oServiceContext=o;this._initAllServices();}
});
S.prototype._initAllServices=function(){for(var s in this._mServiceFactoryReferences){this._initService(s);}};
S.prototype._initService=function(n){var s=this._mServices[n]||{};s.promise=S._getService(this._oServiceContext,n,this._mServiceFactoryReferences).then(function(o){s.instance=o;}).catch(function(e){L.error(e.message);});this._mServices[n]=s;};
S.prototype.getService=function(s){var e="Invalid service";return new Promise(function(r,R){if(!s||!this._mServices[s]||!Object.keys(this._mServices[s])){R(e);return;}this._mServices[s].promise.then(function(){if(this._mServices[s].instance){r(this._mServices[s].instance);}else{R(e);}}.bind(this)).catch(R);}.bind(this));};
S.prototype.destroy=function(){this._mServices=null;};
S._getService=function(i,n,s){return new Promise(function(r,R){var o,f;if(i.bIsDestroyed){R(new Error("Service "+n+" could not be loaded as the requestor "+i.getMetadata().getName()+" was destroyed."));return;}if(!s){R(new Error("No Services declared"));return;}else{o=s[n];}if(!o||!o.factoryName){R(new Error("No Service '"+n+"' declared or factoryName missing"));return;}else{f=o.factoryName;}sap.ui.require(["sap/ui/core/service/ServiceFactoryRegistry"],function(a){var b=a.get(f);if(b){b.createInstance({scopeObject:i,scopeType:"component",settings:o.settings||{}}).then(function(c){if(c.getInterface){r(c.getInterface());}else{r(c);}}).catch(R);}else{var e=new Error("ServiceFactory '"+f+"' for Service '"+n+"' not found in ServiceFactoryRegistry");e._optional=o.optional;R(e);}});});};
return S;});
sap.ui.predefine('sap/ui/integration/widgets/Card',["sap/ui/thirdparty/jquery","sap/ui/core/Core","sap/ui/core/Control","sap/ui/integration/util/Manifest","sap/ui/integration/util/ServiceManager","sap/base/Log","sap/f/cards/DataProviderFactory","sap/f/cards/NumericHeader","sap/f/cards/Header","sap/f/cards/BaseContent","sap/m/HBox","sap/m/VBox","sap/ui/core/Icon","sap/m/Text","sap/ui/model/json/JSONModel","sap/ui/model/resource/ResourceModel","sap/base/util/LoaderExtensions","sap/f/CardRenderer","sap/f/library","sap/ui/integration/library"],function(q,C,a,b,S,L,D,N,H,B,c,V,I,T,J,R,d,e,l,f){"use strict";var M={TYPE:"/sap.card/type",DATA:"/sap.card/data",HEADER:"/sap.card/header",HEADER_POSITION:"/sap.card/headerPosition",CONTENT:"/sap.card/content",SERVICES:"/sap.ui5/services",APP_TYPE:"/sap.app/type",PARAMS:"/sap.card/configuration/parameters"};var g=l.cards.HeaderPosition;var h=f.CardDataMode;
var i=a.extend("sap.ui.integration.widgets.Card",{
metadata:{library:"sap.ui.integration",interfaces:["sap.f.ICard"],properties:{manifest:{type:"any",defaultValue:""},parameters:{type:"object",defaultValue:null},width:{type:"sap.ui.core.CSSSize",group:"Appearance",defaultValue:"100%"},height:{type:"sap.ui.core.CSSSize",group:"Appearance",defaultValue:"auto"},dataMode:{type:"sap.ui.integration.CardDataMode",group:"Behavior",defaultValue:h.Active},baseUrl:{type:"sap.ui.core.URI",defaultValue:null}},aggregations:{_header:{type:"sap.f.cards.IHeader",multiple:false,visibility:"hidden"},_content:{type:"sap.ui.core.Control",multiple:false,visibility:"hidden"}},events:{action:{parameters:{actionSource:{type:"sap.ui.core.Control"},manifestParameters:{type:"object"},type:{type:"sap.ui.integration.CardActionType"}}}},associations:{hostConfigurationId:{}}},
renderer:e
});
i.prototype.init=function(){this.setModel(new J(),"parameters");this.setBusyIndicatorDelay(0);};
i.prototype._initReadyState=function(){this._aReadyPromises=[];this._awaitEvent("_headerReady");this._awaitEvent("_contentReady");this._awaitEvent("_cardReady");this._oReadyPromise=Promise.all(this._aReadyPromises).then(function(){this._bReady=true;this.fireEvent("_ready");}.bind(this));};
i.prototype._clearReadyState=function(){this._bReady=false;this._aReadyPromises=[];this._oReadyPromise=null;};
i.prototype.onBeforeRendering=function(){var s=this.getHostConfigurationId();if(this.getDataMode()!==h.Active){return;}if(s){this.addStyleClass(s.replace(/-/g,"_"));}if(this._bApplyManifest){this._bApplyManifest=false;var m=this.getManifest();this._clearReadyState();this._initReadyState();if(!m){this.destroyManifest();}else{this.createManifest(m,this.getBaseUrl());}}};
i.prototype.setManifest=function(v){this.setProperty("manifest",v);this._bApplyManifest=true;return this;};
i.prototype.setParameters=function(v){this.setProperty("parameters",v);this._bApplyManifest=true;return this;};
i.prototype.createManifest=function(m,s){var o={};if(typeof m==="string"){o.manifestUrl=m;m=null;}this.setBusy(true);this._oCardManifest=new b("sap.card",m,s);this._oCardManifest.load(o).then(this._applyManifest.bind(this)).catch(this._applyManifest.bind(this));};
i.prototype._applyManifest=function(){var p=this.getParameters();this._registerManifestModulePath();if(this._oCardManifest&&this._oCardManifest.getResourceBundle()){var r=new R({bundle:this._oCardManifest.getResourceBundle()});r.enhance(C.getLibraryResourceBundle("sap.ui.integration"));this.setModel(r,"i18n");}this._oCardManifest.processParameters(p);this._applyManifestSettings();};
i.prototype._awaitEvent=function(E){this._aReadyPromises.push(new Promise(function(r){this.attachEventOnce(E,function(){r();});}.bind(this)));};
i.prototype.isReady=function(){return this._bReady;};
i.prototype.refresh=function(){if(this.getDataMode()===h.Active){this._clearReadyState();this._initReadyState();this.destroyManifest();this._bApplyManifest=true;this.invalidate();}};
i.prototype.exit=function(){this.destroyManifest();};
i.prototype.destroyManifest=function(){if(this._oCardManifest){this._oCardManifest.destroy();this._oCardManifest=null;}if(this._oServiceManager){this._oServiceManager.destroy();this._oServiceManager=null;}if(this._oDataProviderFactory){this._oDataProviderFactory.destroy();this._oDataProviderFactory=null;this._oDataProvider=null;}if(this._oTemporaryContent){this._oTemporaryContent.destroy();this._oTemporaryContent=null;}this.destroyAggregation("_header");this.destroyAggregation("_content");this._aReadyPromises=null;};
i.prototype._registerManifestModulePath=function(){if(!this._oCardManifest){return;}var A=this._oCardManifest.get("/sap.app/id");if(A){d.registerResourcePath(A.replace(/\./g,"/"),this._oCardManifest.getUrl());this.getModel("parameters").setProperty("/appId",A);}else{L.error("Card sap.app/id entry in the manifest is mandatory");}};
i.prototype.getManifest=function(){var v=this.getProperty("manifest");if(v&&typeof v==="object"){return q.extend(true,{},v);}return v;};
i.prototype.getParameters=function(){var v=this.getProperty("parameters");if(v&&typeof v==="object"){return q.extend(true,{},v);}return v;};
i.prototype._applyManifestSettings=function(){var A=this._oCardManifest.get(M.APP_TYPE);if(A&&A!=="card"){L.error("sap.app/type entry in manifest is not 'card'");}if(this._oDataProviderFactory){this._oDataProviderFactory.destroy();}this._oDataProviderFactory=new D();this._applyServiceManifestSettings();this._applyDataManifestSettings();this._applyHeaderManifestSettings();this._applyContentManifestSettings();};
i.prototype._applyDataManifestSettings=function(){var o=this._oCardManifest.get(M.DATA);if(!o){this.fireEvent("_cardReady");return;}if(this._oDataProvider){this._oDataProvider.destroy();}this._oDataProvider=this._oDataProviderFactory.create(o,this._oServiceManager);if(this._oDataProvider){this.setModel(new J());this._oDataProvider.attachDataChanged(function(E){this.getModel().setData(E.getParameter("data"));}.bind(this));this._oDataProvider.attachError(function(E){this._handleError("Data service unavailable. "+E.getParameter("message"));}.bind(this));this._oDataProvider.triggerDataUpdate().then(function(){this.fireEvent("_cardReady");}.bind(this));}};
i.prototype._applyServiceManifestSettings=function(){var s=this._oCardManifest.get(M.SERVICES);if(!s){return;}if(!this._oServiceManager){this._oServiceManager=new S(s,this);}};
i.prototype.getCardHeader=function(){return this.getAggregation("_header");};
i.prototype.getCardHeaderPosition=function(){if(!this._oCardManifest){return"Top";}return this._oCardManifest.get(M.HEADER_POSITION)||g.Top;};
i.prototype.getCardContent=function(){return this.getAggregation("_content");};
i.prototype._applyHeaderManifestSettings=function(){var m=this._oCardManifest.get(M.HEADER);if(!m){this.fireEvent("_headerReady");return;}var o=H;if(m.type==="Numeric"){o=N;}this._setCardHeader(o);};
i.prototype._applyContentManifestSettings=function(){var s=this._oCardManifest.get(M.TYPE),j=s&&s.toLowerCase()==="component",m=this._oCardManifest.get(M.CONTENT),k=!!m;if(k&&!s){L.error("Card type property is mandatory!");this.fireEvent("_contentReady");return;}if(!k&&!j){this.setBusy(false);this.fireEvent("_contentReady");return;}if(!m&&j){m=this._oCardManifest.getJson();}this._setTemporaryContent();B.create(s,m,this._oServiceManager,this._oDataProviderFactory).then(function(o){this._setCardContent(o);}.bind(this)).catch(function(E){this._handleError(E);}.bind(this)).finally(function(){this.setBusy(false);}.bind(this));};
i.prototype._setCardHeader=function(j){var s=this._oCardManifest.get(M.HEADER),o=j.create(s,this._oServiceManager,this._oDataProviderFactory);o.attachEvent("action",function(E){this.fireEvent("action",{manifestParameters:E.getParameter("manifestParameters"),actionSource:E.getParameter("actionSource"),type:E.getParameter("type")});}.bind(this));var p=this.getAggregation("_header");if(p){p.destroy();}this.setAggregation("_header",o);if(o.isReady()){this.fireEvent("_headerReady");}else{o.attachEvent("_ready",function(){this.fireEvent("_headerReady");}.bind(this));}};
i.prototype._fireReady=function(o,r){if(o.isReady()){this.fireEvent(r);}else{o.attachEvent("_ready",function(){this.fireEvent(r);this.setBusy(false);}.bind(this));}};
i.prototype.onAfterRendering=function(){var s;if(this._oCardManifest&&this._oCardManifest.get(M.TYPE)){s=this._oCardManifest.get(M.TYPE).toLowerCase();}if(s==="analytical"){this.$().addClass("sapFCardAnalytical");}};
i.prototype._setCardContent=function(o){o.attachEvent("action",function(E){this.fireEvent("action",{actionSource:E.getParameter("actionSource"),manifestParameters:E.getParameter("manifestParameters"),type:E.getParameter("type")});}.bind(this));o.attachEvent("_error",function(E){this._handleError(E.getParameter("logMessage"),E.getParameter("displayMessage"));}.bind(this));o.setBusyIndicatorDelay(0);var p=this.getAggregation("_content");if(p&&p!==this._oTemporaryContent){p.destroy();}this.setAggregation("_content",o);if(o.isReady()){this.fireEvent("_contentReady");}else{o.attachEvent("_ready",function(){this.fireEvent("_contentReady");}.bind(this));}};
i.prototype._setTemporaryContent=function(){var t=this._getTemporaryContent(),p=this.getAggregation("_content");if(p&&p!==t){p.destroy();}this.setAggregation("_content",t);};
i.prototype._handleError=function(s,j){L.error(s);this.setBusy(false);this.fireEvent("_error",{message:s});var k="Unable to load the data.",E=j||k,t=this._getTemporaryContent(),p=this.getAggregation("_content");var o=new V({justifyContent:"Center",alignItems:"Center",items:[new I({src:"sap-icon://message-error",size:"1rem"}).addStyleClass("sapUiTinyMargin"),new T({text:E})]});if(p&&p!==t){p.destroy();this.fireEvent("_contentReady");}t.setBusy(false);t.addItem(o);this.setAggregation("_content",t);};
i.prototype._getTemporaryContent=function(){if(!this._oTemporaryContent){this._oTemporaryContent=new c({height:"100%",justifyContent:"Center",busyIndicatorDelay:0,busy:true});this._oTemporaryContent.addStyleClass("sapFCardContentBusy");this._oTemporaryContent.addEventDelegate({onAfterRendering:function(){if(!this._oCardManifest){return;}var t=this._oCardManifest.get(M.TYPE)+"Content",o=this._oCardManifest.get(M.CONTENT),s=B.getMinHeight(t,o);if(this.getHeight()==="auto"){this._oTemporaryContent.$().css({"min-height":s});}}},this);}this._oTemporaryContent.destroyItems();return this._oTemporaryContent;};
i.prototype.setDataMode=function(m){if(this._oDataProviderFactory&&m===h.Inactive){this._oDataProviderFactory.destroy();this._oDataProviderFactory=null;}this.setProperty("dataMode",m,true);if(this.getProperty("dataMode")===h.Active){this.refresh();}return this;};
return i;});
sap.ui.require.preload({
	"sap/ui/integration/manifest.json":'{"_version":"1.9.0","sap.app":{"id":"sap.ui.integration","type":"library","embeds":[],"applicationVersion":{"version":"1.70.0"},"title":"SAPUI5 library with integration-related controls.","description":"SAPUI5 library with integration-related controls.","ach":"CA-UI5-CTR","resources":"resources.json","offline":true},"sap.ui":{"technology":"UI5","supportedThemes":[]},"sap.ui5":{"dependencies":{"minUI5Version":"1.70","libs":{"sap.ui.core":{"minVersion":"1.70.0"},"sap.f":{"minVersion":"1.70.0"}}},"library":{"i18n":"messagebundle.properties","css":false,"content":{"controls":["sap.ui.integration.widgets.Card","sap.ui.integration.Widget","sap.ui.integration.host.HostConfiguration"],"elements":[],"types":["sap.ui.integration.CardActionType","sap.ui.integration.CardDataMode"]}}}}',
	"sap-ui-integration.js":function(){(function(w){"use strict";w["sap-ui-config"]=w["sap-ui-config"]||{};var c=w["sap-ui-config"];c["bindingSyntax"]="complex";c["async"]=true;c["compatVersion"]="edge";c["xx-waitForTheme"]=true;var s,m,b;var a,C;s=document.getElementById("sap-ui-bootstrap");if(s){m=/^(?:.*\/)?resources\//.exec(s.getAttribute("src"));if(m){b=m[0];}}if(b==null){throw new Error("sap-ui-boot.js: could not identify script tag!");}
function l(u,g){var h=u.length,j=0;if(h===0){g();return;}function k(e){h--;if(e.type==='error'){j++;}e.target.removeEventListener("load",k);e.target.removeEventListener("error",k);if(h===0&&j===0&&g){g();}}for(var i=0;i<u.length;i++){var n=document.createElement("script");n.addEventListener("load",k);n.addEventListener("error",k);n.src=b+u[i];document.head.appendChild(n);}}
var p=[];if(/(trident)\/[\w.]+;.*rv:([\w.]+)/i.test(w.navigator.userAgent)){p.push("sap/ui/thirdparty/baseuri.js");p.push("sap/ui/thirdparty/es6-promise.js");p.push("sap/ui/thirdparty/es6-shim-nopromise.js");}else if(/(edge)[ \/]([\w.]+)/i.test(w.navigator.userAgent)||/(Version\/(11\.0)|PhantomJS).*Safari/.test(w.navigator.userAgent)){p.push("sap/ui/thirdparty/es6-promise.js");}l(p,function(){l(["ui5loader.js"],function(){sap.ui.loader.config({async:true});l(["ui5loader-autoconfig.js"],function(){d();});});});
function d(){if(w.sap&&w.sap.ui&&w.sap.ui.getCore){a=w.sap.ui.getCore();return f();}w.sap.ui.require(['/ui5loader-autoconfig','sap/ui/core/Core','sap/ui/integration/util/CustomElements'],function(c,e,g){C=g;e.boot();a=e;e.attachInit(function(){f();});C.coreInstance=a;});}
function r(L){var e=a.getLoadedLibraries()[L];var P=e.defaultTagPrefix,t=Object.keys(e.customTags);w.sap.ui.require(t.map(function(o,i){return e.customTags[t[i]];}),function(){var g=arguments;t.forEach(function(o,i){C.registerTag(t[i],P,g[i]);});});}
function f(){w.addEventListener("load",function(){a.loadLibraries(["sap/ui/integration"],{async:true}).then(function(){r("sap.ui.integration");});});}
})(window);
},
	"sap/ui/integration/library-bootstrap.js":function(){(function(w){"use strict";var c,C;var s=document.currentScript||document.querySelector("script[src*='/sap-ui-integration.js']");
function b(){if(w.sap&&w.sap.ui&&w.sap.ui.getCore){c=w.sap.ui.getCore();return a();}w.sap.ui.require(['sap/ui/core/Core','sap/ui/integration/util/CustomElements'],function(d,e){C=e;d.boot();c=d;d.attachInit(function(){a();});C.coreInstance=c;});}
function r(l){var L=c.getLoadedLibraries()[l];var p=s.getAttribute("prefix")||L.defaultTagPrefix,t=Object.keys(L.customTags),T=s.getAttribute("tags");if(T){t=T.split(",");}w.sap.ui.require(t.map(function(o,i){return L.customTags[t[i]];}),function(){var d=arguments;t.forEach(function(o,i){C.registerTag(t[i],p,d[i]);});});}
function a(){c.loadLibraries(["sap/ui/integration"],{async:true}).then(function(){r("sap.ui.integration");});}
b();})(window);
},
	"sap/ui/integration/sap-ui-integration-config.js":function(){window["sap-ui-config"]=window["sap-ui-config"]||{};window["sap-ui-config"].bindingSyntax="complex";window["sap-ui-config"].compatVersion="edge";window["sap-ui-config"].async=true;window["sap-ui-config"]["xx-waitForTheme"]=true;
},
	"sap/ui/integration/sap-ui-integration-define-nojQuery.js":function(){(function(){"use strict";sap["ui"].define("sap/ui/thirdparty/jquery",function(){return jQuery;});sap["ui"].define("sap/ui/thirdparty/jqueryui/jquery-ui-position",function(){return jQuery;});})();
}
},"sap/ui/integration/library-preload"
);
//# sourceMappingURL=library-preload.js.map