/*!
 * OpenUI5
 * (c) Copyright 2009-2019 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["./_Batch","./_GroupLock","./_Helper","./_V2Requestor","sap/base/Log","sap/ui/base/SyncPromise","sap/ui/thirdparty/jquery"],function(_,a,b,c,L,S,q){"use strict";var B={"Accept":"multipart/mixed"},C="sap.ui.model.odata.v4.lib._Requestor",d,r=/^\d+$/;function g(h){var s;h=h.toLowerCase();for(s in this.headers){if(s.toLowerCase()===h){return this.headers[s];}}}function R(s,h,Q,m){this.mBatchQueue={};this.mHeaders=h||{};this.oModelInterface=m;this.sQueryParams=b.buildQuery(Q);this.mRunningChangeRequests={};this.oSecurityTokenPromise=null;this.iSessionTimer=0;this.iSerialNumber=0;this.sServiceUrl=s;}R.prototype.mFinalHeaders={"Content-Type":"application/json;charset=UTF-8;IEEE754Compatible=true"};R.prototype.mPredefinedPartHeaders={"Accept":"application/json;odata.metadata=minimal;IEEE754Compatible=true"};R.prototype.mPredefinedRequestHeaders={"Accept":"application/json;odata.metadata=minimal;IEEE754Compatible=true","OData-MaxVersion":"4.0","OData-Version":"4.0","X-CSRF-Token":"Fetch"};R.prototype.addChangeSet=function(G){var e=[],f=this.getOrCreateBatchQueue(G);e.iSerialNumber=this.getSerialNumber();f.iChangeSet+=1;f.splice(f.iChangeSet,0,e);};R.prototype.batchRequestSent=function(G,h){if(h){if(G in this.mRunningChangeRequests){this.mRunningChangeRequests[G]+=1;}else{this.mRunningChangeRequests[G]=1;}}};R.prototype.batchResponseReceived=function(G,h){if(h){this.mRunningChangeRequests[G]-=1;if(this.mRunningChangeRequests[G]===0){delete this.mRunningChangeRequests[G];}}};R.prototype.buildQueryString=function(m,Q,D,s){return b.buildQuery(this.convertQueryOptions(m,Q,D,s));};R.prototype.cancelChanges=function(G){if(this.mRunningChangeRequests[G]){throw new Error("Cannot cancel the changes for group '"+G+"', the batch request is running");}this.cancelChangesByFilter(function(){return true;},G);};R.prototype.cancelChangesByFilter=function(f,G){var e=false,t=this;function h(s){var k=t.mBatchQueue[s],o,l,E,i,j;for(j=k.length-1;j>=0;j-=1){if(Array.isArray(k[j])){l=k[j];for(i=l.length-1;i>=0;i-=1){o=l[i];if(o.$cancel&&f(o)){o.$cancel();E=new Error("Request canceled: "+o.method+" "+o.url+"; group: "+s);E.canceled=true;o.$reject(E);l.splice(i,1);e=true;}}}}}if(G){if(this.mBatchQueue[G]){h(G);}}else{for(G in this.mBatchQueue){h(G);}}return e;};R.prototype.cleanUpChangeSets=function(e){var f,h=false,i;function j(o){if(!m(o)){f.push(o);}}function m(o){if(o.method!=="PATCH"){return false;}return f.some(function(k){if(k.method==="PATCH"&&k.headers["If-Match"]===o.headers["If-Match"]){q.extend(true,k.body,o.body);o.$resolve(k.$promise);return true;}});}for(i=e.iChangeSet;i>=0;i-=1){f=[];e[i].forEach(j);if(f.length===0){e.splice(i,1);}else if(f.length===1&&this.isChangeSetOptional()){e[i]=f[0];}else{e[i]=f;}h=h||f.length>0;}return h;};R.prototype.clearSessionContext=function(t){if(t){this.oModelInterface.fireSessionTimeout();}delete this.mHeaders["SAP-ContextId"];if(this.iSessionTimer){clearInterval(this.iSessionTimer);this.iSessionTimer=0;}};R.prototype.convertExpand=function(e,s){var k,f=[],t=this;if(!e||typeof e!=="object"){throw new Error("$expand must be a valid object");}k=Object.keys(e);if(s){k=k.sort();}k.forEach(function(E){var v=e[E];if(v&&typeof v==="object"){f.push(t.convertExpandOptions(E,v,s));}else{f.push(E);}});return f.join(",");};R.prototype.convertExpandOptions=function(e,E,s){var f=[];this.doConvertSystemQueryOptions(undefined,E,function(o,O){f.push(o+'='+O);},undefined,s);return f.length?e+"("+f.join(";")+")":e;};R.prototype.convertQueryOptions=function(m,Q,D,s){var e={};if(!Q){return undefined;}this.doConvertSystemQueryOptions(m,Q,function(k,v){e[k]=v;},D,s);return e;};R.prototype.convertResourcePath=function(s){return s;};R.prototype.destroy=function(){this.clearSessionContext();};R.prototype.doCheckVersionHeader=function(G,s,v){var o=G("OData-Version"),D=!o&&G("DataServiceVersion");if(D){throw new Error("Expected 'OData-Version' header with value '4.0' but received"+" 'DataServiceVersion' header with value '"+D+"' in response for "+this.sServiceUrl+s);}if(o==="4.0"||!o&&v){return;}throw new Error("Expected 'OData-Version' header with value '4.0' but received value '"+o+"' in response for "+this.sServiceUrl+s);};R.prototype.doConvertResponse=function(o,m){return o;};R.prototype.doConvertSystemQueryOptions=function(m,Q,f,D,s){var t=this;Object.keys(Q).forEach(function(k){var v=Q[k];if(D&&k[0]==='$'){return;}switch(k){case"$expand":v=t.convertExpand(v,s);break;case"$select":if(Array.isArray(v)){v=s?v.sort().join(","):v.join(",");}break;default:}f(k,v);});};R.prototype.fetchTypeForPath=function(m,A){return this.oModelInterface.fetchMetadata(m+(A?"/$Type":"/"));};R.prototype.formatPropertyAsLiteral=function(v,p){return b.formatLiteral(v,p.$Type);};R.prototype.getGroupSubmitMode=function(G){return this.oModelInterface.getGroupProperty(G,"submit");};R.prototype.getModelInterface=function(){return this.oModelInterface;};R.prototype.getOrCreateBatchQueue=function(G){var e,f=this.mBatchQueue[G];if(!f){e=[];e.iSerialNumber=0;f=this.mBatchQueue[G]=[e];f.iChangeSet=0;if(this.oModelInterface.onCreateGroup){this.oModelInterface.onCreateGroup(G);}}return f;};R.prototype.getPathAndAddQueryOptions=function(p,o,P){var A=[],n,N={},e,t=this;p=p.slice(1,-5);if(o.$Parameter){o.$Parameter.forEach(function(e){N[e.$Name]=e;});}if(o.$kind==="Function"){for(n in P){e=N[n];if(e){if(e.$isCollection){throw new Error("Unsupported collection-valued parameter: "+n);}A.push(encodeURIComponent(n)+"="+encodeURIComponent(t.formatPropertyAsLiteral(P[n],e)));}}p+="("+A.join(",")+")";}else{for(n in P){if(!(n in N)){delete P[n];}}}return p;};R.prototype.getSerialNumber=function(){this.iSerialNumber+=1;return this.iSerialNumber;};R.prototype.getServiceUrl=function(){return this.sServiceUrl;};R.prototype.hasChanges=function(G,e){var f=this.mBatchQueue[G];if(f){return f.some(function(v){return Array.isArray(v)&&v.some(function(o){return o.headers["If-Match"]===e;});});}return false;};R.prototype.hasPendingChanges=function(G){var t=this;function f(m){var k=Object.keys(m);return G===undefined?k:k.filter(function(s){return G===s;});}return f(this.mRunningChangeRequests).length>0||f(this.mBatchQueue).some(function(s){return t.mBatchQueue[s].some(function(v){return Array.isArray(v)&&v.some(function(o){return o.$cancel;});});});};R.prototype.isActionBodyOptional=function(){return false;};R.prototype.isChangeSetOptional=function(){return true;};R.prototype.ready=function(){return S.resolve();};R.prototype.refreshSecurityToken=function(o){var t=this;if(!this.oSecurityTokenPromise){if(o!==this.mHeaders["X-CSRF-Token"]){return Promise.resolve();}this.oSecurityTokenPromise=new Promise(function(f,e){q.ajax(t.sServiceUrl+t.sQueryParams,{method:"HEAD",headers:{"X-CSRF-Token":"Fetch"}}).then(function(D,T,j){t.mHeaders["X-CSRF-Token"]=j.getResponseHeader("X-CSRF-Token");t.oSecurityTokenPromise=null;f();},function(j,T,E){t.oSecurityTokenPromise=null;e(b.createError(j,"Could not refresh security token"));});});}return this.oSecurityTokenPromise;};R.prototype.relocate=function(s,o,n){var e=this.mBatchQueue[s],t=this,f=e&&e[0].some(function(h,i){if(h.body===o){t.request(h.method,h.url,new a(n),h.headers,o,h.$submit,h.$cancel).then(h.$resolve,h.$reject);e[0].splice(i,1);return true;}});if(!f){throw new Error("Request not found in group '"+s+"'");}};R.prototype.relocateAll=function(s,n,e){var j=0,f=this.mBatchQueue[s],t=this;if(f){f[0].slice().forEach(function(o){if(!e||o.headers["If-Match"]===e){f[0].splice(j,1);t.request(o.method,o.url,new a(n),o.headers,o.body,o.$submit,o.$cancel).then(o.$resolve,o.$reject);}else{j+=1;}});}};R.prototype.removePatch=function(p){var e=this.cancelChangesByFilter(function(o){return o.$promise===p;});if(!e){throw new Error("Cannot reset the changes, the batch request is running");}};R.prototype.removePost=function(G,o){var e=this.cancelChangesByFilter(function(f){return f.body===o;},G);if(!e){throw new Error("Cannot reset the changes, the batch request is running");}};R.prototype.reportUnboundMessagesAsJSON=function(s,m){this.oModelInterface.reportUnboundMessages(s,JSON.parse(m||null));};R.prototype.request=function(m,s,G,h,p,f,e,M,o,A){var i,E,j=G&&G.getGroupId()||"$direct",P,k=Infinity,l,t=this;if(j==="$cached"){E=new Error("Unexpected request: "+m+" "+s);E.$cached=true;throw E;}if(G){G.unlock();k=G.getSerialNumber();}s=this.convertResourcePath(s);o=o||s;if(this.getGroupSubmitMode(j)!=="Direct"){P=new Promise(function(n,u){var v=t.getOrCreateBatchQueue(j);l={method:m,url:s,headers:q.extend({},t.mPredefinedPartHeaders,t.mHeaders,h,t.mFinalHeaders),body:p,$cancel:e,$metaPath:M,$reject:u,$resolve:n,$resourcePath:o,$submit:f};if(m==="GET"){v.push(l);}else if(A){v[0].unshift(l);}else{i=v.iChangeSet;while(v[i].iSerialNumber>k){i-=1;}v[i].push(l);}});l.$promise=P;return P;}if(f){f();}return this.sendRequest(m,s,q.extend({},h,this.mFinalHeaders),JSON.stringify(d.cleanPayload(p)),o).then(function(n){t.reportUnboundMessagesAsJSON(n.resourcePath,n.messages);return t.doConvertResponse(n.body,M);});};R.prototype.sendBatch=function(e){var o=_.serializeBatchRequest(e);return this.sendRequest("POST","$batch"+this.sQueryParams,q.extend(o.headers,B),o.body).then(function(f){if(f.messages!==null){throw new Error("Unexpected 'sap-messages' response header for batch request");}return _.deserializeBatchResponse(f.contentType,f.body);});};R.prototype.sendRequest=function(m,s,h,p,o){var e=this.sServiceUrl+s,t=this;return new Promise(function(f,i){function j(I){var O=t.mHeaders["X-CSRF-Token"];return q.ajax(e,{data:p,headers:q.extend({},t.mPredefinedRequestHeaders,t.mHeaders,b.resolveIfMatchHeader(h)),method:m}).then(function(v,T,k){var E=k.getResponseHeader("ETag");try{t.doCheckVersionHeader(k.getResponseHeader,s,!v);}catch(l){i(l);return;}t.mHeaders["X-CSRF-Token"]=k.getResponseHeader("X-CSRF-Token")||t.mHeaders["X-CSRF-Token"];t.setSessionContext(k.getResponseHeader("SAP-ContextId"),k.getResponseHeader("SAP-Http-Session-Timeout"));v=v||{};if(E){v["@odata.etag"]=E;}f({body:v,contentType:k.getResponseHeader("Content-Type"),messages:k.getResponseHeader("sap-messages"),resourcePath:s});},function(k,T,E){var l=k.getResponseHeader("SAP-ContextId"),n=k.getResponseHeader("X-CSRF-Token"),M;if(!I&&k.status===403&&n&&n.toLowerCase()==="required"){t.refreshSecurityToken(O).then(function(){j(true);},i);}else{M="Communication error";if(l){t.setSessionContext(l,k.getResponseHeader("SAP-Http-Session-Timeout"));}else if(t.mHeaders["SAP-ContextId"]){M="Session not found on server";L.error(M,undefined,C);t.clearSessionContext(true);}i(b.createError(k,M,e,o));}});}if(t.oSecurityTokenPromise&&m!=="GET"){return t.oSecurityTokenPromise.then(j);}return j();});};R.prototype.setSessionContext=function(s,e){var t=r.test(e)?parseInt(e):0,i=Date.now()+15*60*1000,f=this;this.clearSessionContext();if(s){f.mHeaders["SAP-ContextId"]=s;if(t>=60){this.iSessionTimer=setInterval(function(){if(Date.now()>=i){f.clearSessionContext(true);}else{q.ajax(f.sServiceUrl+f.sQueryParams,{method:"HEAD",headers:{"SAP-ContextId":f.mHeaders["SAP-ContextId"]}}).fail(function(j){if(j.getResponseHeader("SAP-Err-Id")==="ICMENOSESSION"){L.error("Session not found on server",undefined,C);f.clearSessionContext(true);}});}},(t-5)*1000);}else if(e!==null){L.warning("Unsupported SAP-Http-Session-Timeout header",e,C);}}};R.prototype.submitBatch=function(G){var h,e=this.mBatchQueue[G]||[],t=this;function v(e,i){var j;e.forEach(function(k,l){var E,s,m,n=i[l];if(Array.isArray(n)){v(k,n);}else if(!n){E=new Error("HTTP request was not processed because the previous request failed");E.cause=j;E.$reported=true;k.$reject(E);}else if(n.status>=400){n.getResponseHeader=g;j=b.createError(n,"Communication error",k.url,k.$resourcePath);f(j,k);}else{if(n.responseText){try{t.doCheckVersionHeader(g.bind(n),k.url,true);m=t.doConvertResponse(JSON.parse(n.responseText),k.$metaPath);}catch(p){k.$reject(p);return;}}else{m={};}t.reportUnboundMessagesAsJSON(k.url,g.call(n,"sap-messages"));s=g.call(n,"ETag");if(s){m["@odata.etag"]=s;}k.$resolve(m);}});}function o(i){if(Array.isArray(i)){i.forEach(o);}else if(i.$submit){i.$submit();}}function f(E,i){if(Array.isArray(i)){i.forEach(f.bind(null,E));}else{i.$reject(E);}}delete this.mBatchQueue[G];o(e);h=this.cleanUpChangeSets(e);if(e.length===0){return Promise.resolve();}this.batchRequestSent(G,h);return this.sendBatch(d.cleanBatch(e)).then(function(i){t.batchResponseReceived(G,h);v(e,i);}).catch(function(E){var i=new Error("HTTP request was not processed because $batch failed");function j(e){e.forEach(function(k){if(Array.isArray(k)){j(k);}else{k.$reject(i);}});}t.batchResponseReceived(G,h);i.cause=E;j(e);throw E;});};d={cleanBatch:function(e){e.forEach(function(o){if(Array.isArray(o)){d.cleanBatch(o);}else{o.body=d.cleanPayload(o.body);}});return e;},cleanPayload:function(p){var o=p;if(o){Object.keys(o).forEach(function(k){if(k.indexOf("@$ui5.")===0){if(o===p){o=q.extend({},p);}delete o[k];}});}return o;},create:function(s,m,h,Q,o){var e=new R(s,h,Q,m);if(o==="2.0"){c(e);}return e;}};return d;},false);
