/*!
 * OpenUI5
 * (c) Copyright 2009-2019 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["sap/ui/fl/Utils","sap/m/MessageBox","sap/ui/rta/Utils","sap/ui/fl/descriptorRelated/internal/Utils","sap/ui/core/BusyIndicator","sap/base/util/uid","sap/base/Log","sap/ui/fl/write/api/PersistenceWriteAPI","sap/ui/fl/write/api/ChangesWriteAPI"],function(F,M,R,D,B,u,L,P,C){"use strict";var A={};var H=56;A._newAppVariantId=null;A.getManifirstSupport=function(r){var s='/sap/bc/ui2/app_index/ui5_app_mani_first_supported/?id='+r;return D.sendRequest(s,'GET');};A.isStandAloneApp=function(){if(sap.ushell_abap){return false;}return true;};A.getNewAppVariantId=function(){return A._newAppVariantId;};A.setNewAppVariantId=function(n){A._newAppVariantId=n;};A.trimIdIfRequired=function(i){if(i.length>H){var I=i.split('.');var t;var g=I[I.length-1].length;var G=I.pop();t=I.join(".");if(t.length>g){t=t.substring(0,t.length-g);}else{return i.substr(0,H);}if(t[t.length-1]==='.'){t=t+G;}else{t=t+"."+G;}return this.trimIdIfRequired(t);}return i;};A.getId=function(b){var c;var i=b.split('.');if(i[0]!=="customer"){i[0]="customer."+i[0];}var r=false;var a=/^id.*/i;i.forEach(function(s,d,e){if(s.match(a)){s=s.replace(a,u().replace(/-/g,"_"));e[d]=s;r=true;}});c=i.join(".");if(!r){c=c+"."+u().replace(/-/g,"_");}c=this.trimIdIfRequired(c);this.setNewAppVariantId(c);return c;};A.createAppVariant=function(r,p){p.version="1.0.0";return P.saveAs(Object.assign({selector:r},p));};A.getInlineChangeInput=function(v,c){return{type:"XTIT",maxLength:50,comment:c,value:{"":v}};};A.getInlinePropertyChange=function(p,s){var c="New "+p+" entered by a key user via RTA tool";return this.getInlineChangeInput(s,c);};A.getInlineChangeInputIcon=function(i){return{icon:i};};A.getInlineChangeRemoveInbounds=function(i){return{inboundId:i};};A.getInboundInfo=function(i){var I={};if(!i){I.currentRunningInbound="customer.savedAsAppVariant";I.addNewInboundRequired=true;return I;}var p=F.getParsedURLHash();var a=Object.keys(i);var b=[];a.forEach(function(s){if((i[s].action===p.action)&&(i[s].semanticObject===p.semanticObject)){b.push(s);}});switch(b.length){case 0:I.currentRunningInbound="customer.savedAsAppVariant";I.addNewInboundRequired=true;break;case 1:I.currentRunningInbound=b[0];I.addNewInboundRequired=false;break;default:I=undefined;break;}return I;};A.getInboundPropertiesKey=function(a,c,p){return a+"_sap.app.crossNavigation.inbounds."+c+"."+p;};A.getInlineChangesForInboundProperties=function(c,r,p,s){var o={inboundId:c,entityPropertyChange:{propertyPath:p,operation:"UPSERT",propertyValue:{}},texts:{}};if(p==="title"||p==="subTitle"){var k=this.getInboundPropertiesKey(r,c,p);o.entityPropertyChange.propertyValue="{{"+k+"}}";o.texts[k]=this.getInlinePropertyChange(p,s);}else if(p==="icon"){o.entityPropertyChange.propertyValue=s;}return o;};A.getInlineChangeForInboundPropertySaveAs=function(c,a){return{inboundId:c,entityPropertyChange:{propertyPath:"signature/parameters/sap-appvar-id",operation:"UPSERT",propertyValue:{required:true,filter:{value:a,format:"plain"},launcherValue:{value:a}}}};};A.getInlineChangeCreateInbound=function(c){var p=F.getParsedURLHash();var o={inbound:{}};o.inbound[c]={semanticObject:p.semanticObject,action:p.action};return o;};A.createInlineChange=function(c,i,r){var o={changeType:i,content:c};if(o.content.texts){o.texts=o.content.texts;delete o.content.texts;}return C.create({changeSpecificData:o,selector:r});};A.addChangesToPersistence=function(a,r){a.forEach(function(c){return P.add({change:c,selector:r});});return Promise.resolve();};A.removeChangesFromPersistence=function(a,r){a.forEach(function(c){return P.remove({change:c,selector:r});});return Promise.resolve();};A.getTransportInput=function(p,n,N,t){return{getPackage:function(){return p;},getNamespace:function(){return n;},getId:function(){return N;},getDefinition:function(){return{fileType:t};}};};A.triggerCatalogAssignment=function(a,r){var s='/sap/bc/lrep/appdescr_variants/'+a+'?action=assignCatalogs&assignFromAppId='+r;return D.sendRequest(s,'POST');};A.triggerCatalogUnAssignment=function(a){var r='/sap/bc/lrep/appdescr_variants/'+a+'?action=unassignCatalogs';return D.sendRequest(r,'POST');};A.isS4HanaCloud=function(s){return s.isAtoEnabled()&&s.isAtoAvailable();};A.copyId=function(i){var t=document.createElement("textarea");t.value=i;document.body.appendChild(t);t.select();document.execCommand('copy');document.body.removeChild(t);return true;};A.getTextResources=function(){return sap.ui.getCore().getLibraryResourceBundle("sap.ui.rta");};A.getText=function(m,t){var T=this.getTextResources();return t?T.getText(m,t):T.getText(m);};A._getErrorMessageText=function(e){var E;if(e.messages&&e.messages.length){E=e.messages.map(function(e){return e.text;}).join("\n");}else if(e.iamAppId){E="IAM App Id: "+e.iamAppId;}else{E=e.stack||e.message||e.status||e;}return E;};A.buildErrorInfo=function(m,e,a){var E=this._getErrorMessageText(e);var s=A.getText(m)+"\n\n";if(a){s+=A.getText("MSG_APP_VARIANT_ID",a)+"\n";}s+=A.getText("MSG_TECHNICAL_ERROR",E);L.error("App variant error: ",E);return{text:s,appVariantId:a,error:true};};A.buildSuccessInfo=function(a,s,i){var S=i?"CLOUD":"ON_PREMISE";var o=s?"":"_OVERVIEW_LIST";var t=i?undefined:a;var m=A.getText("SAVE_APP_VARIANT_SUCCESS_MESSAGE")+"\n\n";m+=A.getText("SAVE_APP_VARIANT_SUCCESS_S4HANA_"+S+"_MESSAGE"+o,t);return{text:m,appVariantId:a,copyId:!i};};A.buildFinalSuccessInfoS4HANACloud=function(){var m=A.getText("MSG_SAVE_APP_VARIANT_NEW_TILE_AVAILABLE");return{text:m};};A.buildDeleteSuccessMessage=function(a){var m=A.getText("DELETE_APP_VARIANT_SUCCESS_MESSAGE",a);return{text:m};};A.showRelevantDialog=function(i,s){B.hide();var t;var r;var o;var c;var a=[];if(s){t=this.getText("SAVE_APP_VARIANT_SUCCESS_MESSAGE_TITLE");r=this.getText("SAVE_APP_VARIANT_OK_TEXT");}else{t=this.getText("HEADER_SAVE_APP_VARIANT_FAILED");r=this.getText("SAVE_APP_VARIANT_CLOSE_TEXT");}if(i&&i.copyId){c=this.getText("SAVE_APP_VARIANT_COPY_ID_TEXT");a.push(c);}else if(i&&i.deleteAppVariant){t=this.getText("DELETE_APP_VARIANT_INFO_MESSAGE_TITLE");o=this.getText("DELETE_APP_VARIANT_OK_TEXT");a.push(o);r=this.getText("DELETE_APP_VARIANT_CLOSE_TEXT");}a.push(r);return new Promise(function(b,d){var f=function(e){if(e===c){A.copyId(i.appVariantId);}if(s){b();}else if(i.overviewDialog){b(false);}else if(i.deleteAppVariant&&e===o){b();}else if(i.deleteAppVariant&&e===r){d(i.deleteAppVariant);}else if(i.error){d(i.error);}else{b();}};M.show(i.text,{icon:(s||i.deleteAppVariant)?M.Icon.INFORMATION:M.Icon.ERROR,onClose:f,title:t,actions:a,styleClass:R.getRtaStyleClassName()});});};A.closeOverviewDialog=function(){sap.ui.getCore().getEventBus().publish("sap.ui.rta.appVariant.manageApps.controller.ManageApps","navigate");};A.navigateToFLPHomepage=function(){var a=sap.ushell.services.AppConfiguration.getCurrentApplication();var c=a.componentHandle.getInstance();if(c){var U=F.getUshellContainer();var o=U&&U.getService("CrossApplicationNavigation");if(o&&o.toExternal){o.toExternal({target:{shellHash:"#"}},c);}}return Promise.resolve();};A.deleteAppVariant=function(s){return P.deleteAppVariant({selector:s});};A.handleBeforeUnloadEvent=function(){var m=A.getText("MSG_DO_NOT_CLOSE_BROWSER");return m;};A.showMessage=function(m){var s=A.getText(m);var i={text:s,copyId:false};return A.showRelevantDialog(i,true);};A.catchErrorDialog=function(e,m,i){B.hide();var E=A.buildErrorInfo(m,e,i);return A.showRelevantDialog(E,false);};return A;},true);
