/*!
 * OpenUI5
 * (c) Copyright 2009-2019 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(['sap/ui/core/Control','sap/ui/core/LocaleData','sap/ui/unified/calendar/CalendarUtils','sap/ui/unified/DateRange','./calendar/Header','./calendar/Month','./calendar/MonthPicker','./calendar/YearPicker','./calendar/YearRangePicker','./calendar/CalendarDate',"sap/ui/core/date/UniversalDate",'./library','sap/ui/Device','sap/ui/core/format/DateFormat','sap/ui/core/ResizeHandler','sap/ui/core/Locale','sap/ui/events/KeyCodes',"./CalendarRenderer","sap/ui/dom/containsOrEquals","sap/base/util/deepEqual","sap/base/Log","sap/ui/thirdparty/jquery"],function(C,L,a,D,H,M,b,Y,c,d,U,l,e,f,R,g,K,h,j,k,m,q){"use strict";var o=sap.ui.getCore().getLibraryResourceBundle("sap.ui.unified");var s=sap.ui.getCore().getConfiguration().getLocale().getLanguage();var n=sap.ui.core.CalendarType;var p=C.extend("sap.ui.unified.Calendar",{metadata:{library:"sap.ui.unified",designtime:"sap/ui/unified/designtime/Calendar.designtime",properties:{intervalSelection:{type:"boolean",group:"Behavior",defaultValue:false},singleSelection:{type:"boolean",group:"Behavior",defaultValue:true},months:{type:"int",group:"Appearance",defaultValue:1},firstDayOfWeek:{type:"int",group:"Appearance",defaultValue:-1},nonWorkingDays:{type:"int[]",group:"Appearance",defaultValue:null},primaryCalendarType:{type:"sap.ui.core.CalendarType",group:"Appearance",defaultValue:null},secondaryCalendarType:{type:"sap.ui.core.CalendarType",group:"Appearance",defaultValue:null},width:{type:"sap.ui.core.CSSSize",group:"Dimension",defaultValue:null},minDate:{type:"object",group:"Misc",defaultValue:null},maxDate:{type:"object",group:"Misc",defaultValue:null},showWeekNumbers:{type:"boolean",group:"Appearance",defaultValue:true}},aggregations:{selectedDates:{type:"sap.ui.unified.DateRange",multiple:true,singularName:"selectedDate"},specialDates:{type:"sap.ui.unified.DateTypeRange",multiple:true,singularName:"specialDate"},disabledDates:{type:"sap.ui.unified.DateRange",multiple:true,singularName:"disabledDate"},header:{type:"sap.ui.unified.calendar.Header",multiple:false,visibility:"hidden"},secondMonthHeader:{type:"sap.ui.unified.calendar.Header",multiple:false,visibility:"hidden"},month:{type:"sap.ui.unified.calendar.Month",multiple:true,visibility:"hidden"},monthPicker:{type:"sap.ui.unified.calendar.MonthPicker",multiple:false,visibility:"hidden"},yearPicker:{type:"sap.ui.unified.calendar.YearPicker",multiple:false,visibility:"hidden"},yearRangePicker:{type:"sap.ui.unified.calendar.YearPicker",multiple:false,visibility:"hidden"}},associations:{ariaLabelledBy:{type:"sap.ui.core.Control",multiple:true,singularName:"ariaLabelledBy"},legend:{type:"sap.ui.unified.CalendarLegend",multiple:false}},events:{select:{},cancel:{},startDateChange:{},weekNumberSelect:{allowPreventDefault:true,parameters:{weekNumber:{type:"int"},weekDays:{type:"sap.ui.unified.DateRange"}}}}}});p.prototype.init=function(){this._iBreakPointTablet=e.media._predefinedRangeSets[e.media.RANGESETS.SAP_STANDARD_EXTENDED].points[0];this._iBreakPointDesktop=e.media._predefinedRangeSets[e.media.RANGESETS.SAP_STANDARD_EXTENDED].points[1];this._iBreakPointLargeDesktop=e.media._predefinedRangeSets[e.media.RANGESETS.SAP_STANDARD_EXTENDED].points[2];var i=sap.ui.getCore().getConfiguration().getCalendarType();this.setProperty("primaryCalendarType",i);this.setProperty("secondaryCalendarType",i);this._iMode=0;this._iColumns=1;this._oYearFormat=f.getDateInstance({format:"y",calendarType:i});this.data("sap-ui-fastnavgroup","true",true);this._oMinDate=a._minDate(this.getPrimaryCalendarType());this._oMaxDate=a._maxDate(this.getPrimaryCalendarType());this._initializeHeader();this._initializeSecondMonthHeader();var F=this._createMonth(this.getId()+"--Month0");F.attachEvent("focus",this._handleFocus,this);F.attachEvent("select",y,this);F.attachEvent("_renderMonth",x,this);F.attachEvent("_bindMousemove",z,this);F.attachEvent("_unbindMousemove",A,this);F._bNoThemeChange=true;this.addAggregation("month",F);this._initilizeMonthPicker();this._initilizeYearPicker();this._initilizeYearRangePicker();this._resizeProxy=q.proxy(r,this);this._oSelectedMonth;this._bSkipCancelButtonRendering=false;};p.prototype.exit=function(){if(this._sInvalidateMonth){clearTimeout(this._sInvalidateMonth);}if(this._sResizeListener){R.deregister(this._sResizeListener);this._sResizeListener=undefined;}this._oSelectedMonth=null;};p.prototype._initializeHeader=function(){var i=new H(this.getId()+"--Head");i.attachEvent("pressPrevious",this._handlePrevious,this);i.attachEvent("pressNext",this._handleNext,this);i.attachEvent("pressButton1",this._handleButton1,this);i.attachEvent("pressButton2",this._handleButton2,this);i.attachEvent("pressButton3",this._handleButton1,this);i.attachEvent("pressButton4",this._handleButton2,this);this.setAggregation("header",i);};p.prototype._initializeSecondMonthHeader=function(){var S=new H(this.getId()+"--SecondMonthHead");S.addStyleClass("sapUiCalHeadSecondMonth");S.attachEvent("pressPrevious",this._handlePrevious,this);S.attachEvent("pressNext",this._handleNext,this);S.attachEvent("pressButton1",this._handleButton1,this);S.attachEvent("pressButton2",this._handleButton2,this);this.setAggregation("secondMonthHeader",S);};p.prototype._initilizeMonthPicker=function(){var i=new b(this.getId()+"--MP");i.attachEvent("select",this._selectMonth,this);i.attachEvent("pageChange",B,this);i._bNoThemeChange=true;this.setAggregation("monthPicker",i);};p.prototype._initilizeYearPicker=function(){var i=new Y(this.getId()+"--YP");i.attachEvent("select",this._selectYear,this);i.attachEvent("pageChange",E,this);this.setAggregation("yearPicker",i);};p.prototype._initilizeYearRangePicker=function(){var i=new c(this.getId()+"--YRP");i.attachEvent("select",this._selectYearRange,this);i.setPrimaryCalendarType(this.getPrimaryCalendarType());this.setAggregation("yearRangePicker",i);};p.prototype._createMonth=function(i){var F=new M(i,{width:"100%"});F.attachEvent("datehovered",this._handleDateHovered,this);F.attachEvent("weekNumberSelect",this._handleWeekNumberSelect,this);return F;};p.prototype._handleWeekNumberSelect=function(i){var F=this.fireWeekNumberSelect({weekNumber:i.getParameter("weekNumber"),weekDays:i.getParameter("weekDays")});if(!F){i.preventDefault();}return this;};p.prototype._handleDateHovered=function(F){var G=this.getAggregation("month"),I=F.getParameter("date1"),J=F.getParameter("date2"),i;for(i=0;i<G.length;i++){G[i]._markDatesBetweenStartAndHoveredDate(I,J);}};p.prototype.onBeforeRendering=function(){var F=this.getAggregation("month"),G,I=F[0].getDate(),J=this._getFocusedDate(),N=this.getAggregation("header");if(F.length>1&&I){G=d.fromLocalJSDate(I,this.getPrimaryCalendarType());}else if(F.length>1){G=t.call(this,this._getFocusedDate());}else{G=J;}for(var i=0;i<F.length;i++){I=new d(G);if(i>0){I.setMonth(I.getMonth()+i,1);}var O=I;if(J.getYear()===I.getYear()&&J.getMonth()===I.getMonth()){O=J;}F[i].displayDate(O.toLocalJSDate());F[i].setShowWeekNumbers(this.getShowWeekNumbers());}this._updateHeader(G);this._iSize=0;if(!this._getSucessorsPickerPopup()){N.setVisibleButton1(true);N.setVisibleButton2(true);}this._adjustYearRangeDisplay();};p.prototype.onAfterRendering=function(i){if(!this._getSucessorsPickerPopup()){u.call(this);}if(w.call(this)>1||this._bInitMonth){i.size={width:this.getDomRef().offsetWidth};r.call(this,i,true);if(!this._sResizeListener){this._sResizeListener=R.register(this,this._resizeProxy);}this._bInitMonth=undefined;}};p.prototype.invalidate=function(O){if(!this._bDateRangeChanged&&(!O||!(O instanceof D))){C.prototype.invalidate.apply(this,arguments);}else if(this.getDomRef()&&this._iMode==0&&!this._sInvalidateMonth){this._sInvalidateMonth=setTimeout(this._invalidateMonth.bind(this,O),0);}};p.prototype.removeSelectedDate=function(S){this._bDateRangeChanged=true;return this.removeAggregation("selectedDates",S);};p.prototype.removeAllSelectedDates=function(){this._bDateRangeChanged=true;var i=this.removeAllAggregation("selectedDates");return i;};p.prototype.destroySelectedDates=function(){this._bDateRangeChanged=true;var i=this.destroyAggregation("selectedDates");return i;};p.prototype.removeAllSpecialDates=function(){this._bDateRangeChanged=true;var i=this.removeAllAggregation("specialDates");return i;};p.prototype.destroySpecialDates=function(){this._bDateRangeChanged=true;var i=this.destroyAggregation("specialDates");return i;};p.prototype._setSpecialDatesControlOrigin=function(i){this._oSpecialDatesControlOrigin=i;};p.prototype.getSpecialDates=function(){var P=this.getParent();if(this._oSpecialDatesControlOrigin){return this._oSpecialDatesControlOrigin.getSpecialDates();}if(P&&P.getSpecialDates){return P.getSpecialDates();}else{return this.getAggregation("specialDates",[]);}};p.prototype.removeAllDisabledDates=function(){this._bDateRangeChanged=true;var i=this.removeAllAggregation("disabledDates");return i;};p.prototype.destroyDisabledDates=function(){this._bDateRangeChanged=true;var i=this.destroyAggregation("disabledDates");return i;};p.prototype.setLocale=function(i){if(this._sLocale!=i){this._sLocale=i;this._oLocaleData=undefined;this.invalidate();}return this;};p.prototype.getLocale=function(){if(!this._sLocale){this._sLocale=sap.ui.getCore().getConfiguration().getFormatSettings().getFormatLocale().toString();}return this._sLocale;};p.prototype._getFocusedDate=function(){if(!this._oFocusedDate){_.call(this);}return this._oFocusedDate;};p.prototype._setFocusedDate=function(i){a._checkCalendarDate(i);this._oFocusedDate=new d(i,this.getPrimaryCalendarType());};p.prototype.focusDate=function(i){v.call(this,i,false);return this;};p.prototype.displayDate=function(i){v.call(this,i,true);return this;};p.prototype.getStartDate=function(){var S;if(this.getDomRef()){var i=this.getAggregation("month");S=d.fromLocalJSDate(i[0].getDate(),this.getPrimaryCalendarType());}else{S=new d(this._getFocusedDate());}S.setDate(1);return S.toLocalJSDate();};p.prototype.setPopupMode=function(P){this._bPoupupMode=P;return this;};p.prototype.setMonths=function(F){this._bDateRangeChanged=undefined;this.setProperty("months",F,false);F=w.call(this);var G=this.getAggregation("month");var i=0;var I;if(G.length<F){for(i=G.length;i<F;i++){I=this._createMonth(this.getId()+"--Month"+i);I.attachEvent("focus",this._handleFocus,this);I.attachEvent("select",y,this);I.attachEvent("_renderMonth",x,this);I.attachEvent("_bindMousemove",z,this);I.attachEvent("_unbindMousemove",A,this);I._bNoThemeChange=true;this.addAggregation("month",I);}}else if(G.length>F){for(i=G.length;i>F;i--){I=this.removeAggregation("month",i-1);I.destroy();}if(F==1){this._bInitMonth=true;}}if(F>1&&G[0].getDate()){G[0].setProperty("date",null,true);}return this;};p.prototype.setPrimaryCalendarType=function(F){var G=this.getAggregation("month"),I=false,J,N,O,P,i;if(G.length>1){I=true;}this.setProperty("primaryCalendarType",F,!I);this._adjustYearRangeDisplay();this._oYearFormat=f.getDateInstance({format:"y",calendarType:F});if(this._oFocusedDate){this._oFocusedDate=new d(this._oFocusedDate,F);}this._oMinDate=new d(this._oMinDate,F);this._oMaxDate=new d(this._oMaxDate,F);for(i=0;i<G.length;i++){J=G[i];J.setPrimaryCalendarType(F);}if(!this._getSucessorsPickerPopup()){N=this.getAggregation("monthPicker");N.setPrimaryCalendarType(F);O=this.getAggregation("yearPicker");O.setPrimaryCalendarType(F);P=this.getAggregation("yearRangePicker");P.setPrimaryCalendarType(F);}if(this.getDomRef()){this._updateHeader(this._oFocusedDate);if(!this._getSucessorsPickerPopup()){if(this.iMode!=1&&N.getDomRef()){N.$().remove();}if(this.iMode!=2&&O.getDomRef()){O.$().remove();}if(this.iMode!=3&&P.getDomRef()){P.$().remove();}}}return this;};p.prototype.setSecondaryCalendarType=function(F){this._bSecondaryCalendarTypeSet=true;this.setProperty("secondaryCalendarType",F,true);this._oYearFormatSecondary=f.getDateInstance({format:"y",calendarType:F});var G=this.getAggregation("month");for(var i=0;i<G.length;i++){var I=G[i];I.setSecondaryCalendarType(F);}if(this.getDomRef()){this._updateHeader(this._getFocusedDate());this.$().toggleClass("sapUiCalSecType",!!this._getSecondaryCalendarType());}return this;};p.prototype._getSecondaryCalendarType=function(){var S;if(this._bSecondaryCalendarTypeSet){S=this.getSecondaryCalendarType();var P=this.getPrimaryCalendarType();if(S==P){S=undefined;}}return S;};p.prototype.setMinDate=function(i){var P=this.getPrimaryCalendarType(),F;if(k(i,this.getMinDate())){return this;}if(!i){this._oMinDate=a._minDate(P);}else{a._checkJSDateObject(i);this._oMinDate=d.fromLocalJSDate(i,P);var G=this._oMinDate.getYear();a._checkYearInValidRange(G);if(this._oMaxDate.isBefore(this._oMinDate)){m.warning("minDate > maxDate -> maxDate set to end of the month",this);this._oMaxDate=d.fromLocalJSDate(i,P);this._oMaxDate.setDate(a._daysInMonth(this._oMaxDate));this.setProperty("maxDate",this._oMaxDate.toLocalJSDate(),true);}this._setMinMaxDateExtend(d.fromLocalJSDate(i,P));}this.setProperty("minDate",i,false);if(!this._getSucessorsPickerPopup()){F=this._oMinDate.getYear();this.getAggregation("yearPicker")._oMinDate.setYear(F);this.getAggregation("yearRangePicker")._oMinDate.setYear(F);}return this;};p.prototype.setMaxDate=function(i){var P,F;if(k(i,this.getMaxDate())){return this;}if(!i){this._oMaxDate=a._maxDate(P);}else{a._checkJSDateObject(i);this._oMaxDate=d.fromLocalJSDate(i,P);var G=this._oMaxDate.getYear();a._checkYearInValidRange(G);if(this._oMinDate.isAfter(this._oMaxDate)){m.warning("maxDate < minDate -> minDate set to begin of the month",this);this._oMinDate=d.fromLocalJSDate(i,P);this._oMinDate.setDate(1);this.setProperty("minDate",this._oMinDate.toLocalJSDate(),true);}this._setMinMaxDateExtend(d.fromLocalJSDate(i,P));}this.setProperty("maxDate",i,false);if(!this._getSucessorsPickerPopup()){F=this._oMaxDate.getYear();this.getAggregation("yearPicker")._oMaxDate.setYear(F);this.getAggregation("yearRangePicker")._oMaxDate.setYear(F);}return this;};p.prototype._setMinMaxDateExtend=function(i){if(this._oFocusedDate){if(a._isOutside(this._oFocusedDate,this._oMinDate,this._oMaxDate)){m.warning("focused date is not between [minDate - maxDate] -> refocus to the new max/min date: "+i.toString(),this);this.focusDate(i.toLocalJSDate());}}};p.prototype._getLocaleData=function(){if(!this._oLocaleData){var i=this.getLocale();var F=new g(i);this._oLocaleData=L.getInstance(F);}return this._oLocaleData;};p.prototype._getShowMonthHeader=function(){var i=w.call(this);if(i>2){return true;}else{return false;}};p.prototype.setWidth=function(W){this.setProperty("width",W,true);if(this.getDomRef()){W=this.getWidth();this.$().css("width",W);if(W){this.$().addClass("sapUiCalWidth");}else{this.$().removeClass("sapUiCalWidth");}}return this;};p.prototype.onclick=function(i){var F=i.target;if(i.isMarked("delayedMouseEvent")){return;}if(F.id==this.getId()+"-cancel"){this.onsapescape(i);}};p.prototype.onmousedown=function(i){if(i.cancelable){i.preventDefault();}i.setMark("cancelAutoClose");};p.prototype.onsapescape=function(i){this.fireCancel();this._closedPickers();if(!this._getSucessorsPickerPopup()){this._updateHeadersButtons();this._setHeaderText(this._getFocusedDate());}};p.prototype.onsapshow=function(i){if(this._bPoupupMode){this._closedPickers();this.fireCancel();i.preventDefault();}};p.prototype.onkeydown=function(i){var F=i.which||i.keyCode,S=i.shiftKey;if(this._getSucessorsPickerPopup()||F!==K.F4){return;}i.preventDefault();S?this._showYearPicker():this._showMonthPicker();};p.prototype.onsaphide=p.prototype.onsapshow;p.prototype.onsaptabnext=function(F){var G=this.getAggregation("header");if(j(this.getDomRef("content"),F.target)){if(this._shouldFocusB2OnTabNext(F)){var I=G.getDomRef("B2");if(I){I.focus();}}else{var J=G.getDomRef("B1");if(J){J.focus();}}if(!this._bPoupupMode){var N=this.getAggregation("month");for(var i=0;i<N.length;i++){var O=N[i];q(O._oItemNavigation.getItemDomRefs()[O._oItemNavigation.getFocusedIndex()]).attr("tabindex","-1");}if(!this._getSucessorsPickerPopup()){var P=this.getAggregation("monthPicker");var Q=this.getAggregation("yearPicker");if(P.getDomRef()){q(P._oItemNavigation.getItemDomRefs()[P._oItemNavigation.getFocusedIndex()]).attr("tabindex","-1");}if(Q.getDomRef()){q(Q._oItemNavigation.getItemDomRefs()[Q._oItemNavigation.getFocusedIndex()]).attr("tabindex","-1");}}}F.preventDefault();}else if(this._shouldFocusB2OnTabNext(F)){var I=G.getDomRef("B2");if(I){I.focus();}F.preventDefault();}};p.prototype._shouldFocusB2OnTabNext=function(i){var F=this.getAggregation("header");return(i.target.id==F.getId()+"-B1");};p.prototype._shouldFocusB2OnTabPrevious=function(i){return this._bPoupupMode;};p.prototype.onsaptabprevious=function(F){var G=this.getAggregation("header");if(j(this.getDomRef("content"),F.target)){if(this._shouldFocusB2OnTabPrevious()){var I=G.getDomRef("B2");if(I){I.focus();}F.preventDefault();}}else if(F.target.id==G.getId()+"-B1"){var J=this.getAggregation("month");var N;switch(this._iMode){case 0:N=this._getFocusedDate();for(var i=0;i<J.length;i++){var O=J[i];var P=d.fromLocalJSDate(O.getDate(),this.getPrimaryCalendarType());if(N.isSame(P)){O._oItemNavigation.focusItem(O._oItemNavigation.getFocusedIndex());}else{q(O._oItemNavigation.getItemDomRefs()[O._oItemNavigation.getFocusedIndex()]).attr("tabindex","0");}}break;case 1:if(!this._getSucessorsPickerPopup()){var Q=this.getAggregation("monthPicker");Q._oItemNavigation.focusItem(Q._oItemNavigation.getFocusedIndex());}break;case 2:if(!this._getSucessorsPickerPopup()){var S=this.getAggregation("yearPicker");S._oItemNavigation.focusItem(S._oItemNavigation.getFocusedIndex());}break;}F.preventDefault();}else if(F.target.id==G.getId()+"-B2"){var T=G.getDomRef("B1");if(T){T.focus();}F.preventDefault();}};p.prototype.onfocusin=function(F){if(F.target.id==this.getId()+"-end"){var G=this.getAggregation("month");this._focusOnShiftTab();if(!this._bPoupupMode){for(var i=0;i<G.length;i++){var I=G[i];q(I._oItemNavigation.getItemDomRefs()[I._oItemNavigation.getFocusedIndex()]).attr("tabindex","-1");}if(!this._getSucessorsPickerPopup()){var J=this.getAggregation("monthPicker");var N=this.getAggregation("yearPicker");if(J.getDomRef()){q(J._oItemNavigation.getItemDomRefs()[J._oItemNavigation.getFocusedIndex()]).attr("tabindex","-1");}if(N.getDomRef()){q(N._oItemNavigation.getItemDomRefs()[N._oItemNavigation.getFocusedIndex()]).attr("tabindex","-1");}}}}this.$("end").attr("tabindex","-1");};p.prototype._focusOnShiftTab=function(){var i=this.getAggregation("header");var F=i.getDomRef("B2");if(F){F.focus();}};p.prototype.onsapfocusleave=function(F){var G,I,J,N;if(!F.relatedControlId||!j(this.getDomRef(),sap.ui.getCore().byId(F.relatedControlId).getFocusDomRef())){this.$("end").attr("tabindex","0");if(!this._bPoupupMode){G=this.getAggregation("month");switch(this._iMode){case 0:for(var i=0;i<G.length;i++){I=G[i];q(I._oItemNavigation.getItemDomRefs()[I._oItemNavigation.getFocusedIndex()]).attr("tabindex","0");}break;case 1:if(!this._getSucessorsPickerPopup()){J=this.getAggregation("monthPicker");q(J._oItemNavigation.getItemDomRefs()[J._oItemNavigation.getFocusedIndex()]).attr("tabindex","0");}break;case 2:if(!this._getSucessorsPickerPopup()){N=this.getAggregation("yearPicker");q(N._oItemNavigation.getItemDomRefs()[N._oItemNavigation.getFocusedIndex()]).attr("tabindex","0");}break;}}}};p.prototype.getFocusDomRef=function(){var i=this._oSelectedMonth?this._oSelectedMonth:this.getAggregation("month")[0];return i._oItemNavigation.getItemDomRefs()[i._oItemNavigation.getFocusedIndex()];};p.prototype.onThemeChanged=function(){var F;if(!this.getDomRef()){return;}this._bNamesLengthChecked=undefined;if(!this._getSucessorsPickerPopup()){F=this.getAggregation("monthPicker");this._showMonthPicker(true);F._bNoThemeChange=false;F.onThemeChanged(arguments);F._bNoThemeChange=true;this._bLongMonth=F._bLongMonth;this._hideMonthPicker(true);}var G=this.getAggregation("month");for(var i=0;i<G.length;i++){var I=G[i];I._bNoThemeChange=false;I.onThemeChanged(arguments);I._bNoThemeChange=true;}var J;if(G.length>1){J=d.fromLocalJSDate(G[0].getDate(),this.getPrimaryCalendarType());}else{J=this._getFocusedDate();}this._setHeaderText(J);this._updateHeadersButtons();this._setPrimaryHeaderMonthButtonText();this._toggleTwoMonthsInTwoColumnsCSS();if(!this._getSucessorsPickerPopup()){u.call(this);}};p.prototype._updateHeader=function(i){this._setHeaderText(i);this._togglePrevNext(i,true);};p.prototype._togglePrevNext=function(i,F){var G=this._oMaxDate.getYear();var I=this._oMinDate.getYear();var J=this._oMaxDate.getMonth();var N=this._oMinDate.getMonth();var O=this.getAggregation("header");var P=w.call(this);var Q=new d(i,this.getPrimaryCalendarType());if(this._iMode==0&&P>1){Q=t.call(this,i);Q.setMonth(Q.getMonth()+P-1);Q.setDate(a._daysInMonth(Q));}else{Q.setDate(a._daysInMonth(Q));}var S=Q.getYear();var T=Q.getMonth();if(S>G||(S==G&&(!F||T>=J))||(this._iMode==1&&this._getSucessorsPickerPopup())){O.setEnabledNext(false);}else{O.setEnabledNext(true);}if(this._iMode==0&&P>1){Q.setMonth(Q.getMonth()-P+1,1);}else{Q.setDate(1);}S=Q.getYear();T=Q.getMonth();if(S<I||(S==I&&(!F||T<=N))||(this._iMode==1&&this._getSucessorsPickerPopup())){O.setEnabledPrevious(false);}else{O.setEnabledPrevious(true);}};p.prototype._togglePrevNexYearPicker=function(){var i=this.getAggregation("yearRangePicker"),F=this.getAggregation("yearPicker"),P=this.getPrimaryCalendarType(),G=new d(this._oMinDate,P),I=new d(this._oMaxDate,P),J=this.getAggregation("header"),N=1,O,Q;if(i.getDomRef()&&i.getDomRef().style.display===""){Q=i.getYears();O=d.fromLocalJSDate(i.getFirstRenderedDate());N=i.getRangeSize();}else{Q=F.getYears();O=d.fromLocalJSDate(F.getFirstRenderedDate());}O.setYear(O.getYear()+Math.floor(Q/2)*N);I.setYear(I.getYear()-Math.ceil(Q/2)*N);I.setMonth(11,31);G.setYear(G.getYear()+Math.floor(Q/2)*N+1);G.setMonth(0,1);J.setEnabledNext(O.isSameOrBefore(I));J.setEnabledPrevious(O.isSameOrAfter(G));};p.prototype._handlePrevious=function(i){var F=this._getFocusedDate(),G=w.call(this),I,J,S=false;switch(this._iMode){case 0:if(G>1){I=d.fromLocalJSDate(this.getAggregation("month")[0].getDate(),this.getPrimaryCalendarType());I.setDate(1);this._setFocusedDate(I);F=this._getFocusedDate();}else{F.setDate(1);}F.setDate(F.getDate()-1);this._renderMonth(S,true);break;case 1:F.setYear(F.getYear()-1);this._updateHeadersYearPrimaryText(this._oYearFormat.format(F.toUTCJSDate(),true));var N=this._getSecondaryCalendarType();if(N){J=new d(F,N);J.setMonth(0,1);this._updateHeadersYearAdditionalText(this._oYearFormatSecondary.format(J.toUTCJSDate(),true));}else{this._updateHeadersYearAdditionalText();}this._togglePrevNext(F);this._setDisabledMonths(F.getYear());break;case 2:this.getAggregation("yearPicker").previousPage();this._togglePrevNexYearPicker();this._updateHeadersYearPrimaryText(this._getYearString());break;case 3:this.getAggregation("yearRangePicker").previousPage();this._togglePrevNexYearPicker();this._updateHeadersYearPrimaryText(this._getYearString());break;}};p.prototype._handleNext=function(i){var F=this._getFocusedDate(),G=w.call(this),I,J;switch(this._iMode){case 0:if(G>1){I=d.fromLocalJSDate(this.getAggregation("month")[0].getDate(),this.getPrimaryCalendarType());I.setMonth(I.getMonth(),1);this._setFocusedDate(I);F=this._getFocusedDate();}F.setMonth(F.getMonth()+1,1);this._renderMonth();break;case 1:F.setYear(F.getYear()+1);this._updateHeadersYearPrimaryText(this._oYearFormat.format(F.toUTCJSDate(),true));var S=this._getSecondaryCalendarType();if(S){J=new d(F,S);J.setMonth(0,1);this._updateHeadersYearAdditionalText(this._oYearFormatSecondary.format(J.toUTCJSDate(),true));}else{this._updateHeadersYearAdditionalText();}this._togglePrevNext(F);this._setDisabledMonths(F.getYear());break;case 2:this.getAggregation("yearPicker").nextPage();this._togglePrevNexYearPicker();this._updateHeadersYearPrimaryText(this._getYearString());break;case 3:this.getAggregation("yearRangePicker").nextPage();this._togglePrevNexYearPicker();this._updateHeadersYearPrimaryText(this._getYearString());break;}};p.prototype._getYearString=function(){var i=this.getAggregation("yearPicker"),F=i.getDomRef(),G=this._getFocusedDate(),I,J;if(i&&F&&F.style.display===""){I=Math.floor(i.getYears()/2);J=i._oItemNavigation.getItemDomRefs()[I].getAttribute("data-sap-year-start");G=d.fromLocalJSDate(i._oFormatYyyymmdd.parse(J),this.getPrimaryCalendarType());G.setDate(1);}return this._oYearFormat.format(U.getInstance(G.toUTCJSDate(),G.getCalendarType()),true);};p.prototype._getDisplayedMonths=function(F){var G=[];var I=F.getMonth();var J=w.call(this);if(J>1){for(var i=0;i<J;i++){G.push((I+i)%12);}}else{G.push(I);}return G;};p.prototype._getDisplayedSecondaryMonths=function(P,S){var i=this.getAggregation("month");var F=d.fromLocalJSDate(i[0].getDate(),P);F.setDate(1);F=new d(F,S);var G=F.getMonth();var I=d.fromLocalJSDate(i[i.length-1].getDate(),P);I.setDate(a._daysInMonth(I));I=new d(I,S);var J=I.getMonth();return{start:G,end:J};};p.prototype._closedPickers=function(){switch(this._iMode){case 0:break;case 1:this._hideMonthPicker();break;case 2:this._hideYearPicker();break;case 3:this._hideYearRangePicker();break;}};p.prototype._setDisabledMonths=function(i,F){var G=0;var I=11;if(i==this._oMinDate.getYear()){G=this._oMinDate.getMonth();}if(i==this._oMaxDate.getYear()){I=this._oMaxDate.getMonth();}if(!F){F=this.getAggregation("monthPicker");}F.setMinMax(G,I);};p.prototype._handleFocus=function(i){var F=d.fromLocalJSDate(i.getParameter("date"),this.getPrimaryCalendarType());var O=i.getParameter("otherMonth");var G=i.getParameter("restoreOldDate");if(G){if(!k(this._getFocusedDate(),F)){this._renderMonth(false,false,true);}}else{this._focusDate(F,O);}};p.prototype._getVisibleDays=function(){var i=this.getAggregation("month")[0];return i._getVisibleDays(i._getDate(),false);};p.prototype._renderMonth=function(S,I,N){var F=this._getFocusedDate(),G=this.getAggregation("month"),J=false,O,P,Q,i=0;for(i=0;i<G.length;i++){O=G[i];if(O.checkDateFocusable(F.toLocalJSDate())&&G[0].getDate()&&F.getMonth()===G[0].getDate().getMonth()){J=true;}if(J||G.length==1){if(!S){O.setDate(F.toLocalJSDate());}else{O.displayDate(F.toLocalJSDate());}break;}}if(!J){Q=new d(F,this.getPrimaryCalendarType());if(G.length>1){Q=t.call(this,Q);for(i=0;i<G.length;i++){O=G[i];P=new d(Q,this.getPrimaryCalendarType());P.setMonth(Q.getMonth()+i);if(!S&&a._isSameMonthAndYear(P,F)){O.setDate(F.toLocalJSDate());}else{O.displayDate(P.toLocalJSDate());}}}this._updateHeader(Q);this._updateHeadersButtons();this._setPrimaryHeaderMonthButtonText();this._toggleTwoMonthsInTwoColumnsCSS();if(!N){this.fireStartDateChange();}}};p.prototype._showMonthPicker=function(S){if(this._iMode==2){this._hideYearPicker(true);}var F=this._getFocusedDate();var G=this.getAggregation("monthPicker");if(G.getDomRef()){G.$().css("display","");}else{var I=sap.ui.getCore().createRenderManager();var $=this.$("content");I.renderControl(G);I.flush($[0],false,true);I.destroy();}this._showOverlay();if(!S){G.setMonth(F.getMonth());this._setDisabledMonths(F.getYear(),G);if(this._iMode==0){var J=this.getAggregation("month");for(var i=0;i<J.length;i++){var N=J[i];q(N._oItemNavigation.getItemDomRefs()[N._oItemNavigation.getFocusedIndex()]).attr("tabindex","-1");}}}this._iMode=1;this._togglePrevNext(F,false);this._setHeaderText(this._getFocusedDate());};p.prototype._hideMonthPicker=function(S){this._iMode=0;var F=this.getAggregation("monthPicker");F.$().css("display","none");this._hideOverlay();if(!S){this._renderMonth();if(w.call(this)>1){var G=this.getAggregation("month");for(var i=0;i<G.length;i++){var I=G[i];q(I._oItemNavigation.getItemDomRefs()[I._oItemNavigation.getFocusedIndex()]).attr("tabindex","0");}}}this._togglePrevNext(this._getFocusedDate(),true);};p.prototype._showYearPicker=function(){var F,G,I,$,J,N,O;if(this._iMode==1){this._hideMonthPicker(true);}F=this._getFocusedDate();G=this.getAggregation("yearPicker");if(G.getDomRef()){G.$().css("display","");}else{I=sap.ui.getCore().createRenderManager();$=this.$("content");I.renderControl(G);I.flush($[0],false,true);I.destroy();}this._showOverlay();G.setDate(F.toLocalJSDate());if(w.call(this)==1){J=this.getAggregation("month")[0];O=J.$("days").find(".sapUiCalItem");if(O.length==28){G.$().addClass("sapUiCalYearNoTop");}else{G.$().removeClass("sapUiCalYearNoTop");}}if(this._iMode==0){N=this.getAggregation("month");for(var i=0;i<N.length;i++){J=N[i];q(J._oItemNavigation.getItemDomRefs()[J._oItemNavigation.getFocusedIndex()]).attr("tabindex","-1");}}this._togglePrevNexYearPicker();this._iMode=2;this._updateHeadersButtons();this._updateHeadersYearPrimaryText(this._getYearString());};p.prototype._hideYearPicker=function(S){this._iMode=0;var F=this.getAggregation("yearPicker");F.$().css("display","none");this._hideOverlay();if(!S){this._renderMonth();if(w.call(this)>1){var G=this.getAggregation("month");for(var i=0;i<G.length;i++){var I=G[i];q(I._oItemNavigation.getItemDomRefs()[I._oItemNavigation.getFocusedIndex()]).attr("tabindex","0");}}}this._togglePrevNext(this._getFocusedDate(),true);};p.prototype._focusDate=function(i,O,N){var F;var G=false;var I=false;if(i.isBefore(this._oMinDate)){F=this._oMinDate;G=true;}else if(i.isAfter(this._oMaxDate)){F=this._oMaxDate;G=true;}else{F=i;}if(this._focusDateExtend){I=this._focusDateExtend(i,O,N);}var J=F.isBefore(this._getFocusedDate());this._setFocusedDate(F);if(G||O){this._renderMonth(false,J,N);}if(I){this.fireStartDateChange();}};p.prototype._invalidateMonth=function(O){this._sInvalidateMonth=undefined;var F=this.getAggregation("month");if(F){for(var i=0;i<F.length;i++){var G=F[i];G._bDateRangeChanged=true;G._bInvalidateSync=true;G._bNoFocus=true;G.invalidate(O);G._bInvalidateSync=undefined;}}this._bDateRangeChanged=undefined;};p.prototype._setHeaderText=function(i){var F=this.getAggregation("header");var S=this.getAggregation("secondMonthHeader");var G=this._getLocaleData();var I=[];var J=[];var N=[];var O=[];var P;var Q=false;var T;var V;var W;var X;var Z;var $=this.getPrimaryCalendarType();var a1=this._getSecondaryCalendarType();var b1="";if(this._bLongMonth||!this._bNamesLengthChecked){I=G.getMonthsStandAlone("wide",$);}else{Q=true;I=G.getMonthsStandAlone("abbreviated",$);J=G.getMonthsStandAlone("wide",$);}if(a1){N=G.getMonthsStandAlone("abbreviated",a1);O=G.getMonthsStandAlone("wide",a1);var c1=this._getDisplayedSecondaryMonths($,a1);if(c1.start==c1.end){W=N[c1.start];b1=O[c1.start];}else{Z=G.getIntervalPattern();W=Z.replace(/\{0\}/,N[c1.start]).replace(/\{1\}/,N[c1.end]);b1=Z.replace(/\{0\}/,O[c1.start]).replace(/\{1\}/,O[c1.end]);}}F.setAdditionalTextButton1(W);F._setAdditionalTextButton3(W);S.setAdditionalTextButton1(W);var d1=this._getDisplayedMonths(i);this._sFirstMonthName=T=I[d1[0]];V=I[d1[d1.length-1]];if(d1.length>1&&!this._bShowOneMonth){if(!Z){Z=G.getIntervalPattern();}W=Z.replace(/\{0\}/,T).replace(/\{1\}/,V);P=J.length?Z.replace(/\{0\}/,J[d1[0]]).replace(/\{1\}/,J[d1[d1.length-1]]):W;}else{W=T;P=J[d1[0]]||W;}if(!this._getSucessorsPickerPopup()){if(b1){P+=", "+b1;}P+=". "+o.getText("CALENDAR_MONTH_PICKER_OPEN_HINT");}F.setTextButton1(W);F.setAriaLabelButton1(P);F._setTextButton3(V);F._setAriaLabelButton3(V);S.setTextButton1(V);S.setAriaLabelButton1(V);var e1=new d(i,$);e1.setDate(1);X=this._oYearFormat.format(e1.toUTCJSDate(),true);if(e1.getMonth()===11){this._updateHeadersYearPrimaryText(X,(parseInt(X)+1).toString());}else{this._updateHeadersYearPrimaryText(X,X);}if(a1){e1=new d(e1,a1);this._updateHeadersYearAdditionalText(this._oYearFormatSecondary.format(e1.toUTCJSDate(),true));}else{this._updateHeadersYearAdditionalText();}return{sMonth:W,sYear:X,sAriaLabel:P,bShort:Q};};p.prototype._handleButton1=function(i){if(this._iMode!=1){this._showMonthPicker();}else{this._hideMonthPicker();}};p.prototype._handleButton2=function(i){if(this._iMode<=1){this._showYearPicker();}else{this._hideYearPicker();this._showYearRangePicker();}};p.prototype._selectMonth=function(){var F=new d(this._getFocusedDate(),this.getPrimaryCalendarType()),i=this.getAggregation("monthPicker"),G=i.getMonth();F.setMonth(G);if(G!=F.getMonth()){F.setDate(0);}this._focusDate(F,true);this._hideMonthPicker();};p.prototype._getSucessorsPickerPopup=function(){return this.getPickerPopup&&this.getPickerPopup();};p.prototype._selectYear=function(){var F=new d(this._getFocusedDate(),this.getPrimaryCalendarType());var i=this.getAggregation("yearPicker");var G=d.fromLocalJSDate(i.getDate(),this.getPrimaryCalendarType());G.setMonth(F.getMonth(),F.getDate());F=G;this._focusDate(F,true);this._hideYearPicker();this._updateHeadersButtons();this._setHeaderText(this._getFocusedDate());};p.prototype._selectYearRange=function(){var i=this.getAggregation("yearRangePicker"),F=this.getAggregation("yearPicker"),P=this.getPrimaryCalendarType(),G=this.getAggregation("header"),I=d.fromLocalJSDate(i.getDate(),P),S=new d(I,P),J=new d(I,P),N,O;S.setYear(S.getYear()+i.getRangeSize()-1);J.setYear(J.getYear()+Math.floor(i.getRangeSize()/2));I.setDate(1);S.setDate(1);J.setDate(1);N=this._oYearFormat.format(U.getInstance(I.toUTCJSDate(),I.getCalendarType()),true);O=this._oYearFormat.format(U.getInstance(S.toUTCJSDate(),S.getCalendarType()),true);this._hideYearRangePicker();this._showYearPicker();this._updateHeadersButtons();G.setTextButton2(N+" - "+O);G._setTextButton4(N+" - "+O);I.setMonth(0);a._checkJSDateObject(I.toLocalJSDate());a._checkYearInValidRange(I.toLocalJSDate().getFullYear());F.getDomRef()&&F._updateYears(I,Math.floor(F.getYears()/2));this._togglePrevNexYearPicker();};p.prototype._showYearRangePicker=function(){var i=this.getAggregation("yearRangePicker"),F=this.getAggregation("yearPicker"),G=d.fromLocalJSDate(F.getFirstRenderedDate(),this.getPrimaryCalendarType()),I,$;if(i.getDomRef()){i.$().css("display","");}else{I=sap.ui.getCore().createRenderManager();$=this.$("content");I.renderControl(i);I.flush($[0],false,true);I.destroy();}this._showOverlay();i.setDate(G.toLocalJSDate());this._togglePrevNexYearPicker();this._iMode=3;this._updateHeadersButtons();};p.prototype._hideYearRangePicker=function(){this._iMode=0;this.getAggregation("yearRangePicker").$().css("display","none");this._hideOverlay();};p.prototype._showOverlay=function(){this.$("contentOver").css("display","");};p.prototype._hideOverlay=function(){this.$("contentOver").css("display","none");};p.prototype._setColumns=function(i){this._iColumns=i;return this;};p.prototype._getColumns=function(){return this._iColumns;};p.prototype._updateHeadersButtonsHelper=function(i,F,G,I){var J=this.getAggregation("header");J.setVisibleButton1(i);J.setVisibleButton2(F);J._setVisibleButton3(G);J._setVisibleButton4(I);};p.prototype._updateHeadersButtons=function(){var S=this.getAggregation("secondMonthHeader");if(this._isTwoMonthsInOneColumn()){S.setVisible(true);if(this._iMode===2){this._updateHeadersButtonsHelper(false,true,false,false);}else if(this._iMode===3){this._updateHeadersButtonsHelper(false,false,false,false);}else{this._updateHeadersButtonsHelper(true,true,false,false);}}else if(this._isTwoMonthsInTwoColumns()){S.setVisible(false);if(this._iMode===2){this._updateHeadersButtonsHelper(false,true,false,true);}else if(this._iMode===3){this._updateHeadersButtonsHelper(false,false,false,false);}else{this._updateHeadersButtonsHelper(true,true,true,true);}}else{S.setVisible(false);if(this._iMode===2){this._updateHeadersButtonsHelper(false,true,false,false);}else if(this._iMode===3){this._updateHeadersButtonsHelper(false,false,false,false);}else{this._updateHeadersButtonsHelper(true,true,false,false);}}if(this._getSucessorsPickerPopup()){this.getAggregation("header").setVisibleButton2(false);}};p.prototype._setPrimaryHeaderMonthButtonText=function(){var i=this.getAggregation("header");if(this._isTwoMonthsInOneColumn()||this._isTwoMonthsInTwoColumns()){i.setTextButton1(this._sFirstMonthName);}};p.prototype._toggleTwoMonthsInTwoColumnsCSS=function(){if(this._isTwoMonthsInTwoColumns()){if(s.toLowerCase()==="ja"||s.toLowerCase()==="zh"){this.addStyleClass("sapUiCalTwoMonthsTwoColumnsJaZh");}else{this.addStyleClass("sapUiCalTwoMonthsTwoColumns");}}else{if(s.toLowerCase()==="ja"||s.toLowerCase()==="zh"){this.removeStyleClass("sapUiCalTwoMonthsTwoColumnsJaZh");}else{this.removeStyleClass("sapUiCalTwoMonthsTwoColumns");}}};p.prototype._isTwoMonthsInOneColumn=function(){var i=w.call(this);return this._getColumns()===1&&i===2;};p.prototype._isTwoMonthsInTwoColumns=function(){var i=w.call(this);return this._getColumns()===2&&i===2;};p.prototype._updateHeadersYearPrimaryText=function(F,S){var i=this.getAggregation("yearPicker"),G=this.getAggregation("header"),I=this.getAggregation("secondMonthHeader"),J=F,N=F,O=S||F,P=this.getPrimaryCalendarType();if(!this._getSecondaryCalendarType()){J+=(this._getSucessorsPickerPopup()?"":". "+o.getText("CALENDAR_YEAR_PICKER_OPEN_HINT"));}if(this._iMode===2&&i&&i.getDomRef()){var Q=i._oItemNavigation.getItemDomRefs(),T=Q[0].getAttribute("data-sap-year-start"),V=Q[Q.length-1].getAttribute("data-sap-year-start"),W=d.fromLocalJSDate(i._oFormatYyyymmdd.parse(T),P),X=d.fromLocalJSDate(i._oFormatYyyymmdd.parse(V),P),Z,$;W.setDate(1);X.setDate(1);Z=this._oYearFormat.format(U.getInstance(W.toUTCJSDate(),W.getCalendarType()),true);$=this._oYearFormat.format(U.getInstance(X.toUTCJSDate(),X.getCalendarType()),true);N=Z+" - "+$;O=Z+" - "+$;}G._setTextButton4(N);G._setAriaLabelButton4(N);I.setTextButton2(O);I.setAriaLabelButton2(O);G.setTextButton2(N);G.setAriaLabelButton2(J);};p.prototype._updateHeadersYearAdditionalText=function(i){var F=this.getAggregation("header"),S=this.getAggregation("secondMonthHeader"),G=F.getAriaLabelButton2();if(i){G+=", "+i+(this._getSucessorsPickerPopup()?"":". "+o.getText("CALENDAR_YEAR_PICKER_OPEN_HINT"));F.setAriaLabelButton2(G);}F.setAdditionalTextButton2(i);F._setAdditionalTextButton4(i);S.setAdditionalTextButton2(i);};p.prototype._adjustYearRangeDisplay=function(){var i=this.getAggregation("yearRangePicker");if(!this._getSucessorsPickerPopup()){switch(this.getPrimaryCalendarType()){case n.Japanese:i.setColumns(1);i.setYears(4);break;case n.Gregorian:i.setColumns(3);i.setYears(9);break;default:i.setColumns(2);i.setYears(8);}}};function _(){var S=this.getSelectedDates();var i=this.getPrimaryCalendarType();if(S&&S[0]&&S[0].getStartDate()){this._oFocusedDate=d.fromLocalJSDate(S[0].getStartDate(),i);}else{this._oFocusedDate=d.fromLocalJSDate(new Date(),i);}if(this._oFocusedDate.isBefore(this._oMinDate)){this._oFocusedDate=new d(this._oMinDate,i);}else if(this._oFocusedDate.isAfter(this._oMaxDate)){this._oFocusedDate=new d(this._oMaxDate,i);}}function r(F){var W=F.size.width;if(W<=0){return;}var O=this._iSize;if(W<this._iBreakPointTablet){this._iSize=0;}else if(W<this._iBreakPointDesktop){this._iSize=1;}else if(W<this._iBreakPointLargeDesktop){this._iSize=2;}else{this._iSize=3;}var G=w.call(this);if(O!=this._iSize||this._bInitMonth){switch(this._iSize){case 1:this._setColumns(2);break;case 2:this._setColumns(3);break;case 3:this._setColumns(4);break;default:this._setColumns(1);break;}if(G<this._getColumns()){this._setColumns(G);}if(this._getColumns()>2&&G>this._getColumns()){var I=this._getColumns();var J=0.0;var N=this._getColumns();while(I>=2){var P=G%I;if(P==0){N=I;break;}else{var Q=P/I;if(Q>J){J=Q;N=I;}}I--;}this._setColumns(N);}var S;var T=this.getAggregation("month");if(this._getColumns()>1){S=100/this._getColumns()+"%";this.$("content").removeClass("sapUiCalContentSingle");}else{S="100%";this.$("content").addClass("sapUiCalContentSingle");}for(var i=0;i<T.length;i++){var V=T[i];V.setWidth(S);}}this._updateHeadersButtons();this._setPrimaryHeaderMonthButtonText();this._toggleTwoMonthsInTwoColumnsCSS();}function t(i){var F=new d(i,this.getPrimaryCalendarType());F.setDate(1);var G=w.call(this);if(G<=12){var I=i.getMonth();if(12%G>0&&I+G>11){I=12-G;}F.setMonth(I);}return F;}function u(){var i,F,G;if(!this._bNamesLengthChecked){this._showMonthPicker(true);this._hideMonthPicker(true);i=this.getAggregation("monthPicker");this._bLongMonth=i._bLongMonth;this._bNamesLengthChecked=true;if(!this._bLongMonth){F=this.getAggregation("month");G;if(F.length>1){G=d.fromLocalJSDate(F[0].getDate(),this.getPrimaryCalendarType());}else{G=this._getFocusedDate();}this._setHeaderText(G);this._updateHeadersButtons();this._setPrimaryHeaderMonthButtonText();this._toggleTwoMonthsInTwoColumnsCSS();}}else if(w.call(this)>1){this._focusDate(this._getFocusedDate(),true,true);}}function v(i,S){var F,G;if(!i){return;}F=d.fromLocalJSDate(i,this.getPrimaryCalendarType());G=F.getYear();a._checkYearInValidRange(G);if(a._isOutside(F,this._oMinDate,this._oMaxDate)){throw new Error("Date must not be in valid range (minDate and maxDate); "+this);}this._setFocusedDate(F);if(this.getDomRef()&&this._iMode==0){this._renderMonth(S,false,true);}}function w(){if(e.system.phone){return 1;}else{return this.getMonths();}}function x(i){this.fireEvent("_renderMonth",{days:i.getParameter("days")});}function y(F){if(w.call(this)>1){var G=this.getAggregation("month");for(var i=0;i<G.length;i++){var I=G[i];if(I.getId()!=F.oSource.getId()){I._updateSelection();}}}this._oSelectedMonth=F.oSource;this.fireSelect();}function z(F){var G,I,i;if(w.call(this)>1){G=this.getAggregation("month");for(i=0;i<G.length;i++){I=G[i];if(I.getId()!=F.oSource.getId()){I._bindMousemove();}}}}function A(F){var G,I,i;if(w.call(this)>1){G=this.getAggregation("month");for(i=0;i<G.length;i++){I=G[i];if(I.getId()!=F.oSource.getId()){I._unbindMousemove();}}}}function B(i){var O=i.getParameter("offset");if(O>0){this._handleNext(i);}if(O<0){this._handlePrevious(i);}}function E(){this._updateHeadersYearPrimaryText(this._getYearString());}return p;});
