/*!
 * OpenUI5
 * (c) Copyright 2009-2019 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(['sap/ui/core/Control','sap/ui/core/LocaleData','sap/ui/core/delegate/ItemNavigation','sap/ui/unified/calendar/CalendarUtils','sap/ui/core/date/UniversalDate','sap/ui/unified/library','sap/ui/core/format/DateFormat','sap/ui/core/library','sap/ui/core/Locale',"./TimesRowRenderer","sap/ui/dom/containsOrEquals","sap/base/util/deepEqual","sap/ui/thirdparty/jquery","sap/ui/unified/DateRange"],function(C,L,I,a,U,l,D,c,b,T,d,e,q,f){"use strict";var g=c.CalendarType;var h=C.extend("sap.ui.unified.calendar.TimesRow",{metadata:{library:"sap.ui.unified",properties:{date:{type:"object",group:"Data"},startDate:{type:"object",group:"Data"},items:{type:"int",group:"Appearance",defaultValue:12},intervalMinutes:{type:"int",group:"Appearance",defaultValue:60},intervalSelection:{type:"boolean",group:"Behavior",defaultValue:false},singleSelection:{type:"boolean",group:"Behavior",defaultValue:true},showHeader:{type:"boolean",group:"Appearance",defaultValue:false}},aggregations:{selectedDates:{type:"sap.ui.unified.DateRange",multiple:true,singularName:"selectedDate"},specialDates:{type:"sap.ui.unified.DateTypeRange",multiple:true,singularName:"specialDate"}},associations:{ariaLabelledBy:{type:"sap.ui.core.Control",multiple:true,singularName:"ariaLabelledBy"},legend:{type:"sap.ui.unified.CalendarLegend",multiple:false}},events:{select:{},focus:{parameters:{date:{type:"object"},notVisible:{type:"boolean"}}}}}});h.prototype.init=function(){this._oFormatYyyyMMddHHmm=D.getInstance({pattern:"yyyyMMddHHmm",calendarType:g.Gregorian});this._oFormatLong=D.getDateTimeInstance({style:"long/short"});this._oFormatDate=D.getDateInstance({style:"medium"});this._mouseMoveProxy=q.proxy(this._handleMouseMove,this);this._rb=sap.ui.getCore().getLibraryResourceBundle("sap.ui.unified");};h.prototype.exit=function(){if(this._oItemNavigation){this.removeDelegate(this._oItemNavigation);this._oItemNavigation.destroy();delete this._oItemNavigation;}if(this._sInvalidateTimes){clearTimeout(this._sInvalidateTimes);}};h.prototype.onAfterRendering=function(){_.call(this);};h.prototype.onsapfocusleave=function(E){if(!E.relatedControlId||!d(this.getDomRef(),sap.ui.getCore().byId(E.relatedControlId).getFocusDomRef())){if(this._bMouseMove){z.call(this,true);t.call(this,this._getDate());this._bMoveChange=false;this._bMousedownChange=false;w.call(this);}if(this._bMousedownChange){this._bMousedownChange=false;w.call(this);}}};h.prototype.invalidate=function(O){if(!this._bDateRangeChanged&&(!O||!(O instanceof f))){C.prototype.invalidate.apply(this,arguments);}else if(this.getDomRef()&&!this._sInvalidateTimes){if(this._bInvalidateSync){x.call(this);}else{this._sInvalidateTimes=setTimeout(x.bind(this),0);}}};h.prototype.removeAllSelectedDates=function(){this._bDateRangeChanged=true;var R=this.removeAllAggregation("selectedDates");return R;};h.prototype.destroySelectedDates=function(){this._bDateRangeChanged=true;var i=this.destroyAggregation("selectedDates");return i;};h.prototype.removeAllSpecialDates=function(){this._bDateRangeChanged=true;var R=this.removeAllAggregation("specialDates");return R;};h.prototype.destroySpecialDates=function(){this._bDateRangeChanged=true;var i=this.destroyAggregation("specialDates");return i;};h.prototype.setIntervalMinutes=function(M){if(M>=720){throw new Error("Only intervals < 720 minutes are allowed; "+this);}if(1440%M>0){throw new Error("A day must be divisible by the interval size; "+this);}this.setProperty("intervalMinutes",M,false);this._oFormatTime=undefined;return this;};h.prototype.setDate=function(i){o.call(this,i,false);return this;};h.prototype._setDate=function(i){var B=a._createLocalDate(i,true);this.setProperty("date",B,true);this._oUTCDate=i;};h.prototype._getDate=function(){if(!this._oUTCDate){this._oUTCDate=a._createUniversalUTCDate(new Date(),undefined,true);}return this._oUTCDate;};h.prototype.setStartDate=function(S){a._checkJSDateObject(S);var Y=S.getFullYear();a._checkYearInValidRange(Y);var i=a._createUniversalUTCDate(S,undefined,true);this.setProperty("startDate",S,true);this._oUTCStartDate=this._getIntervalStart(i);if(this.getDomRef()){var O=a._createLocalDate(this._getDate(),true);this._bNoRangeCheck=true;this.displayDate(S);this._bNoRangeCheck=false;if(O&&this.checkDateFocusable(O)){this.displayDate(O);}}return this;};h.prototype._getStartDate=function(){if(!this._oUTCStartDate){this._oUTCStartDate=a._createUniversalUTCDate(new Date(),undefined,true);this._oUTCStartDate=this._getIntervalStart(this._oUTCStartDate);}return this._oUTCStartDate;};h.prototype.displayDate=function(i){o.call(this,i,true);return this;};h.prototype._getLocale=function(){var P=this.getParent();if(P&&P.getLocale){return P.getLocale();}else if(!this._sLocale){this._sLocale=sap.ui.getCore().getConfiguration().getFormatSettings().getFormatLocale().toString();}return this._sLocale;};h.prototype._getLocaleData=function(){var P=this.getParent();if(P&&P._getLocaleData){return P._getLocaleData();}else if(!this._oLocaleData){var i=this._getLocale();var B=new b(i);this._oLocaleData=L.getInstance(B);}return this._oLocaleData;};h.prototype._getFormatLong=function(){var i=this._getLocale();if(this._oFormatLong.oLocale.toString()!=i){var B=new b(i);this._oFormatLong=D.getInstance({style:"long/short"},B);}return this._oFormatLong;};h.prototype._getFormatTime=function(){var i=this._getLocale();if(!this._oFormatTime||this._oFormatTime.oLocale.toString()!=i){var B=new b(i);var E=this.getIntervalMinutes();var F=this._getLocaleData();var P;var G=F.getTimePattern("short");this._oFormatTimeAmPm=undefined;if(E%60==0){P=A(G);if(G.search("a")>=0){this._oFormatTimeAmPm=D.getTimeInstance({pattern:"a"},B);}}else{P=G;P=P.replace("HH","H");P=P.replace("hh","h");if(P.search("a")>=0){this._oFormatTimeAmPm=D.getTimeInstance({pattern:"a"},B);P=P.replace("a","").trim();}}this._oFormatTime=D.getTimeInstance({pattern:P},B);}return this._oFormatTime;};h.prototype._getFormatDate=function(){var i=this._getLocale();if(this._oFormatDate.oLocale.toString()!=i){var B=new b(i);this._oFormatDate=D.getDateInstance({style:"medium"},B);}return this._oFormatDate;};h.prototype.getIntervalSelection=function(){var P=this.getParent();if(P&&P.getIntervalSelection){return P.getIntervalSelection();}else{return this.getProperty("intervalSelection");}};h.prototype.getSingleSelection=function(){var P=this.getParent();if(P&&P.getSingleSelection){return P.getSingleSelection();}else{return this.getProperty("singleSelection");}};h.prototype.getSelectedDates=function(){var P=this.getParent();if(P&&P.getSelectedDates){return P.getSelectedDates();}else{return this.getAggregation("selectedDates",[]);}};h.prototype.getSpecialDates=function(){var P=this.getParent();if(P&&P.getSpecialDates){return P.getSpecialDates();}else{return this.getAggregation("specialDates",[]);}};h.prototype._getShowHeader=function(){var P=this.getParent();if(P&&P._getShowItemHeader){return P._getShowItemHeader();}else{return this.getProperty("showHeader");}};h.prototype.getIntervalMinutes=function(){var P=this.getParent();if(P&&P.getIntervalMinutes){return P.getIntervalMinutes();}else{return this.getProperty("intervalMinutes");}};h.prototype.getAriaLabelledBy=function(){var P=this.getParent();if(P&&P.getAriaLabelledBy){return P.getAriaLabelledBy();}else{return this.getAssociation("ariaLabelledBy",[]);}};h.prototype.getLegend=function(){var P=this.getParent();if(P&&P.getLegend){return P.getLegend();}else{return this.getAssociation("ariaLabelledBy",[]);}};h.prototype._checkDateSelected=function(B){if(!(B instanceof U)){throw new Error("Date must be a UniversalDate object "+this);}var S=0;var E=this.getSelectedDates();var M=new U(B.getTime());M=this._getIntervalStart(M);var F=M.getTime();for(var i=0;i<E.length;i++){var R=E[i];var G=R.getStartDate();var H=0;if(G){G=a._createUniversalUTCDate(G,undefined,true);G=this._getIntervalStart(G);H=G.getTime();}var J=R.getEndDate();var K=0;if(J){J=a._createUniversalUTCDate(J,undefined,true);J=this._getIntervalStart(J);K=J.getTime();}if(F==H&&!J){S=1;break;}else if(F==H&&J){S=2;if(J&&F==K){S=5;}break;}else if(J&&F==K){S=3;break;}else if(J&&F>H&&F<K){S=4;break;}if(this.getSingleSelection()){break;}}return S;};h.prototype._getDateType=function(B){if(!(B instanceof U)){throw new Error("Date must be a UniversalDate object "+this);}var E;var S=this.getSpecialDates();var M=new U(B.getTime());M=this._getIntervalStart(M);var F=M.getTime();for(var i=0;i<S.length;i++){var R=S[i];var G=R.getStartDate();var H=0;if(G){G=a._createUniversalUTCDate(G,undefined,true);G=this._getIntervalStart(G);H=G.getTime();}var J=R.getEndDate();var K=0;if(J){J=a._createUniversalUTCDate(J,undefined,true);J=this._getIntervalStart(J);J.setUTCMinutes(J.getUTCMinutes()+this.getIntervalMinutes()-1);K=J.getTime();}else if(G.getUTCHours()==0&&G.getUTCMinutes()==0&&G.getUTCSeconds()==0&&G.getUTCMilliseconds()==0){J=new U(G.getTime());J.setUTCDate(J.getUTCDate()+1);K=J.getTime();}if((F==H&&!J)||(F>=H&&F<=K)){E={type:R.getType(),tooltip:R.getTooltip_AsString()};break;}}return E;};h.prototype._checkTimeEnabled=function(i){if(!(i instanceof U)){throw new Error("Date must be a UniversalDate object "+this);}var B=i.getTime();var P=this.getParent();if(P&&P._oMinDate&&P._oMaxDate){if(B<P._oMinDate.getTime()||B>P._oMaxDate.getTime()){return false;}}return true;};h.prototype._handleMouseMove=function(E){if(!this.$().is(":visible")){z.call(this,true);}var $=q(E.target);if($.hasClass("sapUiCalItemText")){$=$.parent();}if($.hasClass("sapUiCalItem")){var O=this._getDate();var F=new U(this._oFormatYyyyMMddHHmm.parse($.attr("data-sap-time"),true).getTime());if(F.getTime()!=O.getTime()){this._setDate(F);t.call(this,F,true);this._bMoveChange=true;}}};h.prototype.onmouseup=function(E){if(this._bMouseMove){z.call(this,true);var F=this._getDate();var B=this._oItemNavigation.getItemDomRefs();for(var i=0;i<B.length;i++){var $=q(B[i]);if($.attr("data-sap-time")==this._oFormatYyyyMMddHHmm.format(F.getJSDate(),true)){$.focus();break;}}if(this._bMoveChange){var G=q(E.target);if(G.hasClass("sapUiCalItemText")){G=G.parent();}if(G.hasClass("sapUiCalItem")){F=new U(this._oFormatYyyyMMddHHmm.parse(G.attr("data-sap-time"),true).getTime());}t.call(this,F);this._bMoveChange=false;this._bMousedownChange=false;w.call(this);}}if(this._bMousedownChange){this._bMousedownChange=false;w.call(this);}};h.prototype.onsapselect=function(E){var S=t.call(this,this._getDate());if(S){w.call(this);}E.stopPropagation();E.preventDefault();};h.prototype.onsapselectmodifiers=function(E){this.onsapselect(E);};h.prototype.onsappageupmodifiers=function(E){var F=new U(this._getDate().getTime());var i=F.getUTCDate();if(E.metaKey||E.ctrlKey){F.setUTCDate(i-7);}else{F.setUTCDate(i-1);}this.fireFocus({date:a._createLocalDate(F,true),notVisible:true});E.preventDefault();};h.prototype.onsappagedownmodifiers=function(E){var F=new U(this._getDate().getTime());var i=F.getUTCDate();if(E.metaKey||E.ctrlKey){F.setUTCDate(i+7);}else{F.setUTCDate(i+1);}this.fireFocus({date:a._createLocalDate(F,true),notVisible:true});E.preventDefault();};h.prototype.checkDateFocusable=function(i){a._checkJSDateObject(i);if(this._bNoRangeCheck){return false;}var S=this._getStartDate();var E=new U(S.getTime());E.setUTCMinutes(E.getUTCMinutes()+this.getItems()*this.getIntervalMinutes());var B=a._createUniversalUTCDate(i,undefined,true);if(B.getTime()>=S.getTime()&&B.getTime()<E.getTime()){return true;}else{return false;}};h.prototype.applyFocusInfo=function(i){this._oItemNavigation.focusItem(this._oItemNavigation.getFocusedIndex());return this;};h.prototype._getIntervalStart=function(i){var B=i.getTime();var S=new U(i.getTime());S.setUTCHours(0);S.setUTCMinutes(0);S.setUTCSeconds(0);S.setUTCMilliseconds(0);var M=this.getIntervalMinutes();while(S.getTime()<=B){S.setUTCMinutes(S.getUTCMinutes()+M);}var E=new U(S.getTime());E.setUTCMinutes(E.getUTCMinutes()-M);return E;};h.prototype._setAriaRole=function(R){this._ariaRole=R;return this;};h.prototype._getAriaRole=function(){return this._ariaRole?this._ariaRole:"gridcell";};h.prototype._updateItemARIASelected=function($,S){var R=this._getAriaRole();if(R==="gridcell"){$.attr("aria-selected",S);}return this;};function _(){var B=this._getDate();var Y=this._oFormatYyyyMMddHHmm.format(B.getJSDate(),true);var E=0;var R=this.$("times").get(0);var F=this.$("times").children(".sapUiCalItem");for(var i=0;i<F.length;i++){var $=q(F[i]);if($.attr("data-sap-time")===Y){E=i;break;}}if(!this._oItemNavigation){this._oItemNavigation=new I();this._oItemNavigation.attachEvent(I.Events.AfterFocus,j,this);this._oItemNavigation.attachEvent(I.Events.FocusAgain,k,this);this._oItemNavigation.attachEvent(I.Events.BorderReached,m,this);this.addDelegate(this._oItemNavigation);this._oItemNavigation.setDisabledModifiers({sapnext:["alt"],sapprevious:["alt"],saphome:["alt"],sapend:["alt"]});this._oItemNavigation.setCycling(false);this._oItemNavigation.setColumns(1,true);}this._oItemNavigation.setRootDomRef(R);this._oItemNavigation.setItemDomRefs(F);this._oItemNavigation.setFocusedIndex(E);this._oItemNavigation.setPageSize(F.length);}function j(i){var B=i.getParameter("index");var E=i.getParameter("event");if(!E){return;}var O=this._getDate();var F=new U(O.getTime());var G=this._oItemNavigation.getItemDomRefs();var $=q(G[B]);F=new U(this._oFormatYyyyMMddHHmm.parse($.attr("data-sap-time"),true).getTime());this._setDate(F);this.fireFocus({date:a._createLocalDate(F,true),notVisible:false});if(E.type=="mousedown"){n.call(this,E,F,B);}}function k(i){var B=i.getParameter("index");var E=i.getParameter("event");if(!E){return;}if(E.type=="mousedown"){var F=this._getDate();n.call(this,E,F,B);}}function m(i){var E=i.getParameter("event");var B=this.getItems();var M=this.getIntervalMinutes();var O=this._getDate();var F=new U(O.getTime());if(E.type){switch(E.type){case"sapnext":case"sapnextmodifiers":F.setUTCMinutes(F.getUTCMinutes()+M);break;case"sapprevious":case"sappreviousmodifiers":F.setUTCMinutes(F.getUTCMinutes()-M);break;case"sappagedown":F.setUTCMinutes(F.getUTCMinutes()+M*B);break;case"sappageup":F.setUTCMinutes(F.getUTCMinutes()-M*B);break;default:break;}this.fireFocus({date:a._createLocalDate(F,true),notVisible:true});}}function n(E,F,i){if(E.button){return;}var S=t.call(this,F);if(S){this._bMousedownChange=true;}if(this._bMouseMove){z.call(this,true);this._bMoveChange=false;}else if(this.getIntervalSelection()&&this.$().is(":visible")){y.call(this,true);}E.preventDefault();E.setMark("cancelAutoClose");}function o(i,N){a._checkJSDateObject(i);var Y=i.getFullYear();a._checkYearInValidRange(Y);var F=true;if(!e(this.getDate(),i)){var B=a._createUniversalUTCDate(i,undefined,true);B=this._getIntervalStart(B);F=this.checkDateFocusable(i);if(!this._bNoRangeCheck&&!F){throw new Error("Date must be in visible date range; "+this);}this.setProperty("date",i,true);this._oUTCDate=B;}if(this.getDomRef()){if(F){p.call(this,this._oUTCDate,N);}else{r.call(this,N);}}}function p(B,N){var Y=this._oFormatYyyyMMddHHmm.format(B.getJSDate(),true);var E=this._oItemNavigation.getItemDomRefs();var $;for(var i=0;i<E.length;i++){$=q(E[i]);if($.attr("data-sap-time")==Y){if(document.activeElement!=E[i]){if(N){this._oItemNavigation.setFocusedIndex(i);}else{this._oItemNavigation.focusItem(i);}}break;}}}function r(N){var i=this._getStartDate();var $=this.$("times");if($.length>0){var R=sap.ui.getCore().createRenderManager();this.getRenderer().renderTimes(R,this,i);R.flush($[0]);R.destroy();}s.call(this);_.call(this);if(!N){this._oItemNavigation.focusItem(this._oItemNavigation.getFocusedIndex());}}function s(){var S=this._getStartDate();if(this._getShowHeader()){var $=this.$("Head");if($.length>0){var i=this._getLocaleData();var R=sap.ui.getCore().createRenderManager();this.getRenderer().renderHeaderLine(R,this,i,S);R.flush($[0]);R.destroy();}}}function t(B,M){if(!this._checkTimeEnabled(B)){return false;}var S=this.getSelectedDates();var E;var F=this._oItemNavigation.getItemDomRefs();var $;var Y;var i=0;var P=this.getParent();var G=this;var H;if(P&&P.getSelectedDates){G=P;}if(this.getSingleSelection()){if(S.length>0){E=S[0];H=E.getStartDate();if(H){H=a._createUniversalUTCDate(H,undefined,true);H=this._getIntervalStart(H);}}else{E=new f();G.addAggregation("selectedDates",E,true);}if(this.getIntervalSelection()&&(!E.getEndDate()||M)&&H){var J;if(B.getTime()<H.getTime()){J=H;H=B;if(!M){E.setProperty("startDate",a._createLocalDate(new Date(H.getTime()),true),true);E.setProperty("endDate",a._createLocalDate(new Date(J.getTime()),true),true);}}else if(B.getTime()>=H.getTime()){J=B;if(!M){E.setProperty("endDate",a._createLocalDate(new Date(J.getTime()),true),true);}}u.call(this,H,J);}else{u.call(this,B);E.setProperty("startDate",a._createLocalDate(new Date(B.getTime()),true),true);E.setProperty("endDate",undefined,true);}}else{if(this.getIntervalSelection()){throw new Error("Calender don't support multiple interval selection");}else{var K=this._checkDateSelected(B);if(K>0){for(i=0;i<S.length;i++){H=S[i].getStartDate();if(H){H=a._createUniversalUTCDate(H,undefined,true);H=this._getIntervalStart(H);if(B.getTime()==H.getTime()){G.removeAggregation("selectedDates",i,true);break;}}}}else{E=new f({startDate:a._createLocalDate(new Date(B.getTime()),true)});G.addAggregation("selectedDates",E,true);}Y=this._oFormatYyyyMMddHHmm.format(B.getJSDate(),true);for(i=0;i<F.length;i++){$=q(F[i]);if($.attr("data-sap-time")==Y){if(K>0){$.removeClass("sapUiCalItemSel");this._updateItemARIASelected($,false);}else{$.addClass("sapUiCalItemSel");this._updateItemARIASelected($,true);}}}}}return true;}function u(S,E){var B=this._oItemNavigation.getItemDomRefs();var $;var i=0;var F=false;var G=false;if(!E){var Y=this._oFormatYyyyMMddHHmm.format(S.getJSDate(),true);for(i=0;i<B.length;i++){$=q(B[i]);F=false;G=false;if($.attr("data-sap-time")==Y){$.addClass("sapUiCalItemSel");this._updateItemARIASelected($,true);F=true;}else if($.hasClass("sapUiCalItemSel")){$.removeClass("sapUiCalItemSel");this._updateItemARIASelected($,false);}if($.hasClass("sapUiCalItemSelStart")){$.removeClass("sapUiCalItemSelStart");}else if($.hasClass("sapUiCalItemSelBetween")){$.removeClass("sapUiCalItemSelBetween");}else if($.hasClass("sapUiCalItemSelEnd")){$.removeClass("sapUiCalItemSelEnd");}v.call(this,$,F,G);}}else{var H;for(i=0;i<B.length;i++){$=q(B[i]);F=false;G=false;H=new U(this._oFormatYyyyMMddHHmm.parse($.attr("data-sap-time"),true).getTime());if(H.getTime()==S.getTime()){$.addClass("sapUiCalItemSelStart");F=true;$.addClass("sapUiCalItemSel");this._updateItemARIASelected($,true);if(E&&H.getTime()==E.getTime()){$.addClass("sapUiCalItemSelEnd");G=true;}$.removeClass("sapUiCalItemSelBetween");}else if(E&&H.getTime()>S.getTime()&&H.getTime()<E.getTime()){$.addClass("sapUiCalItemSel");this._updateItemARIASelected($,true);$.addClass("sapUiCalItemSelBetween");$.removeClass("sapUiCalItemSelStart");$.removeClass("sapUiCalItemSelEnd");}else if(E&&H.getTime()==E.getTime()){$.addClass("sapUiCalItemSelEnd");G=true;$.addClass("sapUiCalItemSel");this._updateItemARIASelected($,true);$.removeClass("sapUiCalItemSelStart");$.removeClass("sapUiCalItemSelBetween");}else{if($.hasClass("sapUiCalItemSel")){$.removeClass("sapUiCalItemSel");this._updateItemARIASelected($,false);}if($.hasClass("sapUiCalItemSelStart")){$.removeClass("sapUiCalItemSelStart");}else if($.hasClass("sapUiCalItemSelBetween")){$.removeClass("sapUiCalItemSelBetween");}else if($.hasClass("sapUiCalItemSelEnd")){$.removeClass("sapUiCalItemSelEnd");}}v.call(this,$,F,G);}}}function v($,S,E){if(!this.getIntervalSelection()){return;}var B="";var F=[];var G=this.getId();var H=false;B=$.attr("aria-describedby");if(B){F=B.split(" ");}var J=-1;var K=-1;for(var i=0;i<F.length;i++){var M=F[i];if(M==(G+"-Start")){J=i;}if(M==(G+"-End")){K=i;}}if(J>=0&&!S){F.splice(J,1);H=true;if(K>J){K--;}}if(K>=0&&!E){F.splice(K,1);H=true;}if(J<0&&S){F.push(G+"-Start");H=true;}if(K<0&&E){F.push(G+"-End");H=true;}if(H){B=F.join(" ");$.attr("aria-describedby",B);}}function w(){if(this._bMouseMove){z.call(this,true);}this.fireSelect();}function x(){this._sInvalidateTimes=undefined;r.call(this,this._bNoFocus);this._bDateRangeChanged=undefined;this._bNoFocus=undefined;}function y(){q(window.document).bind('mousemove',this._mouseMoveProxy);this._bMouseMove=true;}function z(){q(window.document).unbind('mousemove',this._mouseMoveProxy);this._bMouseMove=undefined;}function A(i){var P;if(i.toUpperCase().indexOf("K")>-1){P=i.indexOf("k")>-1?"k":"K";}else{P=i.indexOf("h")>-1?"h":"H";}return P;}return h;});
