/*!
 * OpenUI5
 * (c) Copyright 2009-2019 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["sap/ui/core/Control","sap/ui/core/Core","sap/ui/base/ManagedObjectObserver",'sap/ui/core/ResizeHandler',"sap/ui/core/delegate/ItemNavigation","sap/f/GridContainerRenderer","sap/ui/Device","sap/ui/layout/cssgrid/VirtualGrid","sap/f/GridContainerSettings","sap/base/strings/capitalize"],function(C,a,M,R,I,G,D,V,b,c){"use strict";var d=a.getConfiguration().getRTL();var E=16;function e(){return!D.browser.msie&&!(D.browser.edge&&D.browser.version<E);}function g(i){var l=i.getLayoutData();return l?l.getColumns():1;}function f(i){var l=i.getLayoutData();return l?l.getActualRows():1;}function h(i){var l=i.getLayoutData();return l?l.hasAutoHeight():true;}var j=C.extend("sap.f.GridContainer",{metadata:{library:"sap.f",interfaces:["sap.f.dnd.IGridDroppable"],properties:{width:{type:"sap.ui.core.CSSSize",group:"Appearance",defaultValue:""},containerQuery:{type:"boolean",group:"Behavior",defaultValue:false},snapToRow:{type:"boolean",group:"Appearance",defaultValue:false},allowDenseFill:{type:"boolean",group:"Appearance",defaultValue:false},inlineBlockLayout:{type:"boolean",group:"Appearance",defaultValue:false}},defaultAggregation:"items",aggregations:{items:{type:"sap.ui.core.Control",multiple:true,singularName:"item",dnd:true},layout:{type:"sap.f.GridContainerSettings",multiple:false},layoutXS:{type:"sap.f.GridContainerSettings",multiple:false},layoutS:{type:"sap.f.GridContainerSettings",multiple:false},layoutM:{type:"sap.f.GridContainerSettings",multiple:false},layoutL:{type:"sap.f.GridContainerSettings",multiple:false},layoutXL:{type:"sap.f.GridContainerSettings",multiple:false},_defaultLayout:{type:"sap.f.GridContainerSettings",multiple:false,visibility:"hidden"}},events:{layoutChange:{parameters:{layout:{type:"string"}}}},dnd:{draggable:false,droppable:true}}});j.prototype.bUseExtendedChangeDetection=true;j.prototype.getActiveLayoutSettings=function(){var s=this.getAggregation(this._sActiveLayout);if(!s&&this._sActiveLayout==="layoutXS"){s=this.getAggregation("layoutS");}if(!s){s=this.getAggregation("layout")||this.getAggregation("_defaultLayout");}return s;};j.prototype._onBeforeItemRendering=function(){var i=this.getParent(),r=i._resizeListeners[this.getId()];if(r){R.deregister(r);}delete i._resizeListeners[this.getId()];};j.prototype._onAfterItemRendering=function(){var i=this.getParent();i._resizeListeners[this.getId()]=R.register(this,i._resizeItemHandler);i._setItemNavigationItems();if(!e()){i._scheduleIEPolyfill();return;}i._applyItemAutoRows(this);};j.prototype._onItemChange=function(i){if(i.name!=="items"||!i.child){return;}if(i.mutation==="insert"){i.child.addEventDelegate(this._itemDelegate,i.child);}else if(i.mutation==="remove"){i.child.removeEventDelegate(this._itemDelegate,i.child);}};j.prototype._deregisterResizeListeners=function(){var k,i;for(k in this._resizeListeners){i=this._resizeListeners[k];R.deregister(i);}delete this._resizeListeners;if(!this.getContainerQuery()){D.resize.detachHandler(this._resizeHandler);}};j.prototype._setItemNavigationItems=function(){if(!this._isRenderingFinished){return;}};j.prototype._detectActiveLayout=function(){var w=(this.getContainerQuery()&&this.getDomRef())?this.$().outerWidth():D.resize.width,r=D.media.getCurrentRange("GridContainerRangeSet",w),l="layout"+r.name,o=this.getActiveLayoutSettings(),s=false;if(this._sActiveLayout!==l){this.addStyleClass("sapFGridContainer"+c(l));if(this._sActiveLayout){this.removeStyleClass("sapFGridContainer"+c(this._sActiveLayout));}this._sActiveLayout=l;s=o!==this.getActiveLayoutSettings();this.fireLayoutChange({layout:this._sActiveLayout});}return s;};j.prototype._getActiveGridStyles=function(){var s=this.getActiveLayoutSettings(),i=s.getColumns()||"auto-fill",k=s.getColumnSize(),m=s.getMinColumnSize(),l=s.getMaxColumnSize(),S={"grid-gap":s.getGap()};if(m&&l){S["grid-template-columns"]="repeat("+i+", minmax("+m+", "+l+"))";}else{S["grid-template-columns"]="repeat("+i+", "+k+")";}if(this.getInlineBlockLayout()){S["grid-auto-rows"]="min-content";}else{S["grid-auto-rows"]=s.getRowSize();}return S;};j.prototype.init=function(){this.setAggregation("_defaultLayout",new b());this._initRangeSet();this._resizeListeners={};this._itemDelegate={onBeforeRendering:this._onBeforeItemRendering,onAfterRendering:this._onAfterItemRendering};this._itemsObserver=new M(this._onItemChange.bind(this));this._itemsObserver.observe(this,{aggregations:["items"]});this._resizeHandler=this._resize.bind(this);if(!this.getContainerQuery()){D.resize.attachHandler(this._resizeHandler);}this._resizeItemHandler=this._resizeItem.bind(this);this._itemNavigation=new I().setCycling(false);this._itemNavigation.setDisabledModifiers({sapnext:["alt","meta"],sapprevious:["alt","meta"]});this.addDelegate(this._itemNavigation);if(!e()){this._attachDndPolyfill();}};j.prototype.insertItem=function(i,k){if(!this.getDomRef()||!e()){return this.insertAggregation("items",i,k);}var r=a.createRenderManager(),w=this._createItemWrapper(i),t=this._getItemAt(k),o=this.getDomRef();if(t){o.insertBefore(w,t.getDomRef().parentElement);}else{o.appendChild(w);}this.insertAggregation("items",i,k,true);r.render(i,w);r.destroy();return this;};j.prototype.removeItem=function(i){var r=this.removeAggregation("items",i,true),o=this.getDomRef(),k=r.getDomRef();if(!o||!k||!e()){this.invalidate();return r;}o.removeChild(k.parentElement);return r;};j.prototype.onBeforeRendering=function(){this._detectActiveLayout();var r=this._resizeListeners[this.getId()];if(r){R.deregister(r);}this._isRenderingFinished=false;};j.prototype.onAfterRendering=function(){this._resizeListeners[this.getId()]=R.register(this.getDomRef(),this._resizeHandler);this._isRenderingFinished=true;this._setItemNavigationItems();this._applyLayout(true);};j.prototype.exit=function(){this._deregisterResizeListeners();if(this._itemsObserver){this._itemsObserver.disconnect();delete this._itemsObserver;}if(this._itemNavigation){this.removeDelegate(this._itemNavigation);this._itemNavigation.destroy();delete this._itemNavigation;}if(!e()){this._detachDndPolyfill();}};j.prototype._initRangeSet=function(){if(!D.media.hasRangeSet("GridContainerRangeSet")){D.media.initRangeSet("GridContainerRangeSet",[375,600,1024,1440],"px",["XS","S","M","L","XL"]);}};j.prototype._resize=function(){if(!this._isWidthChanged()){return;}var s=this._detectActiveLayout();this._applyLayout(s);};j.prototype._isWidthChanged=function(){var i=this.getDomRef()?this.$().outerWidth():0,v=D.resize.width;if(this._lastGridWidth===i&&this._lastViewportWidth===v){return false;}this._lastGridWidth=i;this._lastViewportWidth=v;return true;};j.prototype._resizeItem=function(o){if(!e()){this._scheduleIEPolyfill();return;}this._applyItemAutoRows(o.control);};j.prototype._applyLayout=function(s){if(!this._isRenderingFinished){return;}if(!e()){this._scheduleIEPolyfill(s);return;}if(s){this.$().css(this._getActiveGridStyles());this.getItems().forEach(this._applyItemAutoRows.bind(this));}this._enforceMaxColumns();};j.prototype._applyItemAutoRows=function(i){if(!this._isRenderingFinished){return;}if(this.getInlineBlockLayout()){return;}if(h(i)){var $=i.$(),s=this.getActiveLayoutSettings(),r=s.calculateRowsForItem($.height());if(!r){return;}$.parent().css({'grid-row':'span '+Math.max(r,f(i))});}};j.prototype._enforceMaxColumns=function(){var s=this.getActiveLayoutSettings(),m=s.getComputedColumnsCount(this.$().innerWidth());if(!m){return;}this.getItems().forEach(function(i){i.$().parent().css("grid-column","span "+Math.min(g(i),m));});};j.prototype._getItemAt=function(i){var k=this.getItems(),t;if(i<0){i=0;}if(k.length&&k[i]){t=k[i];}return t;};j.prototype._createItemWrapper=function(i){var s=G.getStylesForItemWrapper(i,this),S=s.styles,k=s.classes,w=document.createElement("div");S.forEach(function(v,K){w.style.setProperty(K,v);});k.forEach(function(v){w.classList.add(v);});return w;};j.prototype._scheduleIEPolyfill=function(i){if(this._iPolyfillCallId){clearTimeout(this._iPolyfillCallId);}if(i){this._applyIEPolyfillLayout();return;}this._iPolyfillCallId=setTimeout(this._applyIEPolyfillLayout.bind(this),0);};j.prototype._applyIEPolyfillLayout=function(){if(!this._isRenderingFinished){return;}var $=this.$(),l=$.innerWidth(),s=this.getActiveLayoutSettings(),m=s.getColumnSizeInPx(),r=s.getRowSizeInPx(),n=s.getGapInPx(),o=s.getComputedColumnsCount(l),t=parseInt($.css("padding-top").replace("px","")),p=parseInt($.css("padding-left").replace("px","")),q=this.getItems();if(s.getMinColumnSize()){return;}if(!m||!r){return;}if(!q.length){return;}var v=new V();v.init({numberOfCols:Math.max(1,o),cellWidth:m,cellHeight:r,unitOfMeasure:"px",gapSize:n,topOffset:t?t:0,leftOffset:p?p:0,allowDenseFill:this.getAllowDenseFill(),rtl:d,width:l});var i,k,u,w,x,y,F=[];var z=function(K){v.fitElement(K+'',s.calculateColumnsForItem(Math.round(this._polyfillDropIndicator.width)),s.calculateRowsForItem(Math.round(this._polyfillDropIndicator.height)));F.push({id:K+'',domRef:this._polyfillDropIndicator.domRef});}.bind(this);for(i=0,k=0;i<q.length;i++){if(this._polyfillDropIndicator&&this._polyfillDropIndicator.insertAt===i){z(k);k++;}u=q[i];w=u.$();if(!w.is(":visible")){continue;}x=g(u);if(h(u)){y=s.calculateRowsForItem(w.height());}else{y=f(u);}v.fitElement(k+'',x,y);F.push({id:k+'',domRef:w.parent()});k++;}if(this._polyfillDropIndicator&&this._polyfillDropIndicator.insertAt>=q.length){z(q.length);}v.calculatePositions();F.forEach(function(A){var B=v.getItems()[A.id];A.domRef.css({position:'absolute',top:B.top,left:B.left,width:B.width,height:B.height});});$.css("height",v.getHeight()+"px");};j.prototype._polyfillAfterDragOver=function(o){var $=o.getParameter("indicator");this._polyfillDropIndicator={width:o.getParameter("width"),height:o.getParameter("height"),domRef:$,insertAt:$.index()};this._scheduleIEPolyfill();};j.prototype._polyfillAfterDragEnd=function(o){this._polyfillDropIndicator=null;};j.prototype._attachDndPolyfill=function(){this.attachEvent("_gridPolyfillAfterDragOver",this._polyfillAfterDragOver,this);this.attachEvent("_gridPolyfillAfterDragEnd",this._polyfillAfterDragEnd,this);};j.prototype._detachDndPolyfill=function(){this.detachEvent("_gridPolyfillAfterDragOver",this._polyfillAfterDragOver,this);this.detachEvent("_gridPolyfillAfterDragEnd",this._polyfillAfterDragEnd,this);};return j;});
