/*!
 * OpenUI5
 * (c) Copyright 2009-2019 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["sap/f/library","sap/ui/core/Control","sap/m/Text","sap/f/Avatar","sap/ui/Device",'sap/f/cards/DataProviderFactory','sap/ui/model/json/JSONModel',"sap/f/cards/HeaderRenderer","sap/f/cards/IconFormatter","sap/f/cards/ActionEnablement","sap/base/strings/formatMessage"],function(l,C,T,A,D,a,J,H,I,b,f){"use strict";var c=l.AvatarShape;var d=C.extend("sap.f.cards.Header",{metadata:{library:"sap.f",interfaces:["sap.f.cards.IHeader"],properties:{title:{type:"string",defaultValue:""},subtitle:{type:"string",defaultValue:""},statusText:{type:"string",defaultValue:""},iconDisplayShape:{type:"sap.f.AvatarShape",defaultValue:c.Circle},iconSrc:{type:"sap.ui.core.URI",defaultValue:""},iconInitials:{type:"string",defaultValue:""}},aggregations:{_title:{type:"sap.m.Text",multiple:false,visibility:"hidden"},_subtitle:{type:"sap.m.Text",multiple:false,visibility:"hidden"},_avatar:{type:"sap.f.Avatar",multiple:false,visibility:"hidden"}},events:{press:{}}}});d.prototype.init=function(){this._aReadyPromises=[];this._bReady=false;this._awaitEvent("_dataReady");this._awaitEvent("_actionHeaderReady");Promise.all(this._aReadyPromises).then(function(){this._bReady=true;this.fireEvent("_ready");}.bind(this));this.setBusyIndicatorDelay(0);};d.prototype.exit=function(){this._oServiceManager=null;this._oDataProviderFactory=null;if(this._oDataProvider){this._oDataProvider.destroy();this._oDataProvider=null;}};d.prototype._awaitEvent=function(e){this._aReadyPromises.push(new Promise(function(r){this.attachEventOnce(e,function(){r();});}.bind(this)));};d.prototype.isReady=function(){return this._bReady;};d.prototype._getTitle=function(){var t=this.getAggregation("_title");if(!t){t=new T({maxLines:3}).addStyleClass("sapFCardTitle");this.setAggregation("_title",t);}return t;};d.prototype._getSubtitle=function(){var s=this.getAggregation("_subtitle");if(!s){s=new T({maxLines:2}).addStyleClass("sapFCardSubtitle");this.setAggregation("_subtitle",s);}return s;};d.prototype._getAvatar=function(){var o=this.getAggregation("_avatar");if(!o){o=new A().addStyleClass("sapFCardIcon");this.setAggregation("_avatar",o);}return o;};d.prototype.onBeforeRendering=function(){this._getTitle().setText(this.getTitle());this._getSubtitle().setText(this.getSubtitle());this._getAvatar().setDisplayShape(this.getIconDisplayShape());if(this.isInsideIntegrationCard()&&this.getIconSrc()){var s=this.getModel("parameters").getProperty("/appId");var S=this.getBindingInfo("iconSrc");if(S){S.formatter=function(v){return I.formatSrc(v,s);};this._getAvatar().bindProperty("src",S);}else{this._getAvatar().setSrc(I.formatSrc(this.getIconSrc(),s));}}else{this._getAvatar().setSrc(this.getIconSrc());}this._getAvatar().setInitials(this.getIconInitials());};d.prototype._getHeaderAccessibility=function(){var t=this._getTitle()?this._getTitle().getId():"",s=this._getSubtitle()?this._getSubtitle().getId():"",e=this._getAvatar()?this._getAvatar().getId():"";return t+" "+s+" "+e;};d.prototype.onAfterRendering=function(){if(D.browser.msie){if(this.getTitle()){this._getTitle().clampText();}if(this.getSubtitle()){this._getSubtitle().clampText();}}};d.prototype.ontap=function(){this.firePress();};d.prototype.isInsideIntegrationCard=function(){var p=this.getParent();if(p&&p.isA("sap.ui.integration.widgets.Card")){return true;}return false;};d.create=function(m,s,o){var S={title:m.title,subtitle:m.subTitle};if(m.icon){S.iconSrc=m.icon.src;S.iconDisplayShape=m.icon.shape;S.iconInitials=m.icon.text;}if(m.status&&typeof m.status.text==="string"){S.statusText=m.status.text;}var h=new d(S);if(m.status&&m.status.text&&m.status.text.format){d._bindStatusText(m.status.text.format,h);}h.setServiceManager(s);h.setDataProviderFactory(o);h._setData(m.data);h._attachActions(m,h);return h;};d._bindStatusText=function(F,h){if(F.parts&&F.translationKey&&F.parts.length===2){var B={parts:[F.translationKey,F.parts[0].toString(),F.parts[1].toString()],formatter:function(t,p,P){var s=p||F.parts[0];var e=P||F.parts[1];if(Array.isArray(p)){s=p.length;}if(Array.isArray(P)){e=P.length;}var i=parseFloat(s)||0;var g=parseFloat(e)||0;return f(t,[i,g]);}};h.bindProperty("statusText",B);}};d.prototype.setServiceManager=function(s){this._oServiceManager=s;return this;};d.prototype.setDataProviderFactory=function(o){this._oDataProviderFactory=o;return this;};d.prototype._setData=function(o){var p="/";if(o&&o.path){p=o.path;}this.bindObject(p);if(this._oDataProvider){this._oDataProvider.destroy();}this._oDataProvider=this._oDataProviderFactory.create(o,this._oServiceManager);if(this._oDataProvider){this.setBusy(true);this.setModel(new J());this._oDataProvider.attachDataChanged(function(e){this._updateModel(e.getParameter("data"));this.setBusy(false);}.bind(this));this._oDataProvider.attachError(function(e){this._handleError(e.getParameter("message"));this.setBusy(false);}.bind(this));this._oDataProvider.triggerDataUpdate().then(function(){this.fireEvent("_dataReady");}.bind(this));}else{this.fireEvent("_dataReady");}};d.prototype._updateModel=function(o){this.getModel().setData(o);};d.prototype._handleError=function(L){this.fireEvent("_error",{logMessage:L});};b.enrich(d);return d;});
