/*!
 * OpenUI5
 * (c) Copyright 2009-2019 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(['sap/ui/core/Control',"sap/f/cards/ActionEnablement",'sap/m/NumericContent','sap/m/Text','sap/ui/model/json/JSONModel',"sap/f/cards/NumericSideIndicator","sap/f/cards/NumericHeaderRenderer","sap/base/strings/formatMessage"],function(C,A,N,T,J,a,b,f){"use strict";var c=C.extend("sap.f.cards.NumericHeader",{metadata:{library:"sap.f",interfaces:["sap.f.cards.IHeader"],properties:{title:{"type":"string",group:"Appearance"},subtitle:{"type":"string",group:"Appearance"},statusText:{type:"string",defaultValue:""},unitOfMeasurement:{"type":"string",group:"Data"},number:{"type":"string",group:"Data"},scale:{"type":"string",group:"Data"},trend:{"type":"sap.m.DeviationIndicator",group:"Appearance",defaultValue:"None"},state:{"type":"sap.m.ValueColor",group:"Appearance",defaultValue:"Neutral"},details:{"type":"string",group:"Appearance"}},aggregations:{sideIndicators:{type:"sap.f.cards.NumericSideIndicator",multiple:true},_title:{type:"sap.m.Text",multiple:false,visibility:"hidden"},_subtitle:{type:"sap.m.Text",multiple:false,visibility:"hidden"},_unitOfMeasurement:{type:"sap.m.Text",multiple:false,visibility:"hidden"},_details:{type:"sap.m.Text",multiple:false,visibility:"hidden"},_mainIndicator:{type:"sap.m.NumericContent",multiple:false,visibility:"hidden"}},events:{press:{}}}});c.prototype.init=function(){this._aReadyPromises=[];this._bReady=false;this._awaitEvent("_dataReady");Promise.all(this._aReadyPromises).then(function(){this._bReady=true;this.fireEvent("_ready");}.bind(this));this.setBusyIndicatorDelay(0);};c.prototype.exit=function(){this._oServiceManager=null;this._oDataProviderFactory=null;if(this._oDataProvider){this._oDataProvider.destroy();this._oDataProvider=null;}};c.prototype._awaitEvent=function(e){this._aReadyPromises.push(new Promise(function(r){this.attachEventOnce(e,function(){r();});}.bind(this)));};c.prototype.isReady=function(){return this._bReady;};c.prototype.setTitle=function(v){this.setProperty("title",v,true);this._getTitle().setText(v);return this;};c.prototype.setSubtitle=function(v){this.setProperty("subtitle",v,true);this._getSubtitle().setText(v);return this;};c.prototype.setUnitOfMeasurement=function(v){this.setProperty("unitOfMeasurement",v,true);this._getUnitOfMeasurement().setText(v);return this;};c.prototype.setDetails=function(v){this.setProperty("details",v,true);this._getDetails().setText(v);return this;};c.prototype.setNumber=function(v){this.setProperty("number",v,true);this._getMainIndicator().setValue(v);return this;};c.prototype.setScale=function(v){this.setProperty("scale",v,true);this._getMainIndicator().setScale(v);return this;};c.prototype.setTrend=function(v){this.setProperty("trend",v,true);this._getMainIndicator().setIndicator(v);return this;};c.prototype.setState=function(v){this.setProperty("state",v,true);this._getMainIndicator().setValueColor(v);return this;};c.prototype._getTitle=function(){var o=this.getAggregation("_title");if(!o){o=new T({id:this.getId()+"-title",wrapping:true,maxLines:3});this.setAggregation("_title",o);}return o;};c.prototype._getSubtitle=function(){var o=this.getAggregation("_subtitle");if(!o){o=new T({id:this.getId()+"-subtitle",wrapping:true,maxLines:2});this.setAggregation("_subtitle",o);}return o;};c.prototype._getUnitOfMeasurement=function(){var o=this.getAggregation("_unitOfMeasurement");if(!o){o=new T({id:this.getId()+"-unitOfMeasurement",wrapping:false});this.setAggregation("_unitOfMeasurement",o);}return o;};c.prototype._getDetails=function(){var o=this.getAggregation("_details");if(!o){o=new T({id:this.getId()+"-details",wrapping:false});this.setAggregation("_details",o);}return o;};c.prototype._getMainIndicator=function(){var o=this.getAggregation("_mainIndicator");if(!o){o=new N({id:this.getId()+"-mainIndicator",withMargin:false,nullifyValue:false,animateTextChange:false,truncateValueTo:5});this.setAggregation("_mainIndicator",o);}return o;};c.prototype.ontap=function(){this.firePress();};c.create=function(m,s,d){var S={title:m.title,subtitle:m.subTitle,unitOfMeasurement:m.unitOfMeasurement,details:m.details};if(m.mainIndicator){S.number=m.mainIndicator.number;S.scale=m.mainIndicator.unit;S.trend=m.mainIndicator.trend;S.state=m.mainIndicator.state;}if(m.sideIndicators){S.sideIndicators=m.sideIndicators.map(function(i){return new a(i);});}if(m.status&&typeof m.status.text==="string"){S.statusText=m.status.text;}var h=new c(S);if(m.status&&m.status.text&&m.status.text.format){c._bindStatusText(m.status.text.format,h);}h.setServiceManager(s);h.setDataProviderFactory(d);h._setData(m.data);h._attachActions(m,h);return h;};c._bindStatusText=function(F,h){if(F.parts&&F.translationKey&&F.parts.length===2){var B={parts:[F.translationKey,F.parts[0].toString(),F.parts[1].toString()],formatter:function(t,p,P){var s=p||F.parts[0];var d=P||F.parts[1];if(Array.isArray(p)){s=p.length;}if(Array.isArray(P)){d=P.length;}var i=parseFloat(s)||0;var e=parseFloat(d)||0;return f(t,[i,e]);}};h.bindProperty("statusText",B);}};c.prototype.setServiceManager=function(s){this._oServiceManager=s;return this;};c.prototype.setDataProviderFactory=function(d){this._oDataProviderFactory=d;return this;};c.prototype._setData=function(d){var p="/";if(d&&d.path){p=d.path;}this.bindObject(p);if(this._oDataProvider){this._oDataProvider.destroy();}this._oDataProvider=this._oDataProviderFactory.create(d,this._oServiceManager);if(this._oDataProvider){this.setBusy(true);this.setModel(new J());this._oDataProvider.attachDataChanged(function(e){this._updateModel(e.getParameter("data"));this.setBusy(false);}.bind(this));this._oDataProvider.attachError(function(e){this._handleError(e.getParameter("message"));this.setBusy(false);}.bind(this));this._oDataProvider.triggerDataUpdate().then(function(){this.fireEvent("_dataReady");}.bind(this));}else{this.fireEvent("_dataReady");}};c.prototype._updateModel=function(d){this.getModel().setData(d);};c.prototype._handleError=function(l){this.fireEvent("_error",{logMessage:l});};c.prototype._getHeaderAccessibility=function(){var t=this._getTitle()?this._getTitle().getId():"",s=this._getSubtitle()?this._getSubtitle().getId():"",u=this._getUnitOfMeasurement()?this._getUnitOfMeasurement().getId():"",S=this.getSideIndicators()?this._getSideIndicatorIds():"",d=this._getDetails()?this._getDetails().getId():"",m=this._getMainIndicator()?this._getMainIndicator().getId():"";return t+" "+s+" "+u+" "+m+S+" "+d;};c.prototype._getSideIndicatorIds=function(){var s="";this.getSideIndicators().forEach(function(S){s+=" "+S.getId();});return s;};A.enrich(c);return c;});
