/*!
 * OpenUI5
 * (c) Copyright 2009-2019 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["./library","sap/m/ToggleButton","sap/ui/core/InvisibleText","sap/m/Toolbar","sap/m/ToolbarSpacer","sap/m/OverflowToolbarLayoutData","sap/m/OverflowToolbarAssociativePopover","sap/m/OverflowToolbarAssociativePopoverControls",'sap/ui/core/ResizeHandler',"sap/ui/core/IconPool",'sap/ui/core/theming/Parameters','sap/ui/dom/units/Rem',"sap/ui/Device","./OverflowToolbarRenderer","sap/base/Log","sap/ui/dom/jquery/Focusable"],function(l,T,I,a,b,O,c,d,R,e,P,D,f,g,L){"use strict";var h=l.PlacementType;var B=l.ButtonType;var j=l.OverflowToolbarPriority;var k=a.extend("sap.m.OverflowToolbar",{metadata:{properties:{asyncMode:{type:"boolean",group:"Behavior",defaultValue:false}},aggregations:{_overflowButton:{type:"sap.m.ToggleButton",multiple:false,visibility:"hidden"},_popover:{type:"sap.m.Popover",multiple:false,visibility:"hidden"}},designtime:"sap/m/designtime/OverflowToolbar.designtime"}});k.prototype._callToolbarMethod=function(F,A){return a.prototype[F].apply(this,A);};k.prototype.init=function(){this._callToolbarMethod("init",arguments);this._iPreviousToolbarWidth=null;this._bOverflowButtonNeeded=false;this._bNestedInAPopover=null;this._bListenForControlPropertyChanges=false;this._bListenForInvalidationEvents=false;this._bControlsInfoCached=false;this._bSkipOptimization=false;this._bHasFlexibleContent=false;this._aControlSizes={};this._iFrameRequest=null;this._aMovableControls=[];this._aToolbarOnlyControls=[];this._aPopoverOnlyControls=[];this._aAllCollections=[this._aMovableControls,this._aToolbarOnlyControls,this._aPopoverOnlyControls];};k.prototype.exit=function(){var p=this.getAggregation("_popover");if(p){p.destroy();}if(this._iFrameRequest){window.cancelAnimationFrame(this._iFrameRequest);this._iFrameRequest=null;}};k.prototype.setAsyncMode=function(v){return this.setProperty("asyncMode",v,true);};k.prototype.onAfterRendering=function(){this._getOverflowButton().$().attr("aria-haspopup","true");if(this._bContentVisibilityChanged){this._bControlsInfoCached=false;this._bContentVisibilityChanged=false;}if(this.getAsyncMode()){this._doLayoutAsync().then(this._applyFocus.bind(this));}else{this._doLayout();this._applyFocus();}};k.prototype.onsapfocusleave=function(){this._resetChildControlFocusInfo();};k.prototype._doLayout=function(){var C=sap.ui.getCore(),w;if(!C.isThemeApplied()){L.debug("OverflowToolbar: theme not applied yet, skipping calculations",this);return;}w=this.$().width();this._bListenForControlPropertyChanges=false;this._bListenForInvalidationEvents=false;this._deregisterToolbarResize();if(w>0){if(!this._isControlsInfoCached()){this._cacheControlsInfo();}if(this._iPreviousToolbarWidth!==w){this._iPreviousToolbarWidth=w;this._setControlsOverflowAndShrinking(w);this.fireEvent("_controlWidthChanged");}}this._registerToolbarResize();this._bListenForControlPropertyChanges=true;this._bListenForInvalidationEvents=true;};k.prototype._doLayoutAsync=function(){return new Promise(function(r,i){this._iFrameRequest=window.requestAnimationFrame(function(){this._doLayout();r();}.bind(this));}.bind(this));};k.prototype._applyFocus=function(){var F,$,i=this.$().lastFocusableDomRef();if(this.sFocusedChildControlId){F=sap.ui.getCore().byId(this.sFocusedChildControlId);$=F&&F.$();}if($&&$.length){$.focus();}else if(this._bControlWasFocused){this._getOverflowButton().focus();this._bControlWasFocused=false;this._bOverflowButtonWasFocused=true;}else if(this._bOverflowButtonWasFocused&&!this._getOverflowButtonNeeded()){i&&i.focus();this._bOverflowButtonWasFocused=false;}};k.prototype._preserveChildControlFocusInfo=function(){var A=sap.ui.getCore().getCurrentFocusedControlId();if(this._getControlsIds().indexOf(A)!==-1){this._bControlWasFocused=true;this.sFocusedChildControlId=A;}else if(A===this._getOverflowButton().getId()){this._bOverflowButtonWasFocused=true;this.sFocusedChildControlId="";}};k.prototype._resetChildControlFocusInfo=function(){this._bControlWasFocused=false;this._bOverflowButtonWasFocused=false;this.sFocusedChildControlId="";};k.prototype._registerToolbarResize=function(){if(a.isRelativeWidth(this.getWidth())){var r=this._handleResize.bind(this);this._sResizeListenerId=R.register(this,r);}};k.prototype._deregisterToolbarResize=function(){if(this._sResizeListenerId){R.deregister(this._sResizeListenerId);this._sResizeListenerId="";}};k.prototype._handleResize=function(){if(this.getAsyncMode()){this._doLayoutAsync();}else{this._doLayout();}};k.prototype._cacheControlsInfo=function(){var v,H;this._iOldContentSize=this._iContentSize;this._iContentSize=0;this._bHasFlexibleContent=false;this.getContent().forEach(this._updateControlsCachedSizes,this);if(f.system.phone){this._iContentSize-=1;}if(this._aPopoverOnlyControls.length){v=this._aPopoverOnlyControls.filter(function(C){return C.getVisible();});H=(v.length>0);if(H){this._iContentSize+=this._getOverflowButtonSize();}}this._bControlsInfoCached=true;if(this._iOldContentSize!==this._iContentSize){this.fireEvent("_contentSizeChange",{contentSize:this._iContentSize,invalidate:this._bHasFlexibleContent});}};k.prototype._updateControlsCachedSizes=function(C){var p,i;p=k._getControlPriority(C);i=this._calculateControlSize(C);this._aControlSizes[C.getId()]=i;if(p!==j.AlwaysOverflow){this._iContentSize+=i;}this._bHasFlexibleContent=this._bHasFlexibleContent||C.isA("sap.m.IOverflowToolbarFlexibleContent");};k.prototype._calculateControlSize=function(C){return this._getOptimalControlWidth(C,this._aControlSizes[C.getId()]);};k.prototype._isControlsInfoCached=function(){return this._bControlsInfoCached;};k.prototype._flushButtonsToPopover=function(){this._aButtonsToMoveToPopover.forEach(this._moveButtonToPopover,this);};k.prototype._invalidateIfHashChanged=function(H){if(typeof H==="undefined"||this._getPopover()._getContentIdsHash()!==H){this._preserveChildControlFocusInfo();this.invalidate();}};k.prototype._addOverflowButton=function(){if(!this._getOverflowButtonNeeded()){this._iCurrentContentSize+=this._getOverflowButtonSize();this._setOverflowButtonNeeded(true);}};k.prototype._aggregateMovableControls=function(){var G={},A=[],C,p,s,i,m;this._aMovableControls.forEach(function(o){C=k._getControlGroup(o);p=k._oPriorityOrder;if(C){s=k._getControlPriority(o);i=this._getControlIndex(o);G[C]=G[C]||[];m=G[C];m.unshift(o);if(!m._priority||p[m._priority]<p[s]){m._priority=s;}if(!m._index||m._index<i){m._index=i;}}else{A.push(o);}},this);Object.keys(G).forEach(function(n){A.push(G[n]);});return A;};k.prototype._extractControlsToMoveToOverflow=function(A,t){var i,m;for(i=0;i<A.length;i++){m=A[i];if(m.length){m.forEach(this._addToPopoverArrAndUpdateContentSize,this);}else{this._addToPopoverArrAndUpdateContentSize(m);}if(this._iCurrentContentSize<=t){break;}}};k.prototype._addToPopoverArrAndUpdateContentSize=function(C){this._aButtonsToMoveToPopover.unshift(C);this._iCurrentContentSize-=this._aControlSizes[C.getId()];};k.prototype._sortByPriorityAndIndex=function(C,v){var p=k._oPriorityOrder,s=k._getControlPriority(C),i=k._getControlPriority(v),m=p[s]-p[i];if(m!==0){return m;}else{return this._getControlIndex(v)-this._getControlIndex(C);}};k.prototype._setControlsOverflowAndShrinking=function(t){var i;this._iCurrentContentSize=this._iContentSize;this._aButtonsToMoveToPopover=[];if(this._bSkipOptimization){this._bSkipOptimization=false;}else{i=this._getPopover()._getContentIdsHash();}this._resetToolbar();this._collectPopoverOnlyControls();this._markControlsWithShrinkableLayoutData();if(this._iCurrentContentSize<=t){this._flushButtonsToPopover();this._invalidateIfHashChanged(i);return;}this._moveControlsToPopover(t);this._flushButtonsToPopover();if(this._iCurrentContentSize>t){this._checkContents();}this._invalidateIfHashChanged(i);};k.prototype._markControlsWithShrinkableLayoutData=function(){this.getContent().forEach(this._markControlWithShrinkableLayoutData,this);};k.prototype._collectPopoverOnlyControls=function(){var p=this._aPopoverOnlyControls.length,i,C;if(p){for(i=p-1;i>=0;i--){C=this._aPopoverOnlyControls[i];if(C.getVisible()){this._aButtonsToMoveToPopover.unshift(C);}}if(this._aButtonsToMoveToPopover.length>0){this._setOverflowButtonNeeded(true);}}};k.prototype._moveControlsToPopover=function(t){var A=[];if(this._aMovableControls.length){this._addOverflowButton();A=this._aggregateMovableControls();A.sort(this._sortByPriorityAndIndex.bind(this));this._extractControlsToMoveToOverflow(A,t);}};k.prototype._markControlWithShrinkableLayoutData=function(C){var w,o;C.removeStyleClass(a.shrinkClass);w=a.getOrigWidth(C.getId());if(!a.isRelativeWidth(w)){return;}o=C.getLayoutData();if(o&&o.isA("sap.m.ToolbarLayoutData")&&o.getShrinkable()){C.addStyleClass(a.shrinkClass);}};k.prototype._resetToolbar=function(){this._getPopover().close();this._getPopover()._getAllContent().forEach(this._restoreButtonInToolbar,this);this._setOverflowButtonNeeded(false);this.getContent().forEach(this._removeShrinkingClass);};k.prototype._removeShrinkingClass=function(C){C.removeStyleClass(a.shrinkClass);};k.prototype._moveButtonToPopover=function(o){this._getPopover().addAssociatedContent(o);};k.prototype._restoreButtonInToolbar=function(v){if(typeof v==="object"){v=v.getId();}this._getPopover().removeAssociatedContent(v);};k.prototype._resetAndInvalidateToolbar=function(H){if(this._bIsBeingDestroyed){return;}this._resetToolbar();this._bControlsInfoCached=false;this._bNestedInAPopover=null;this._iPreviousToolbarWidth=null;if(H){this._bSkipOptimization=true;}if(this.$().length){this._preserveChildControlFocusInfo();this.invalidate();}};k.prototype._getVisibleContent=function(){var t=this.getContent(),p=this._getPopover()._getAllContent();return t.filter(function(C){return p.indexOf(C)===-1;});};k.prototype._getVisibleAndNonOverflowContent=function(){return this._getVisibleContent().filter(function(C){return C.getVisible();});};k.prototype._getOverflowButton=function(){var o;if(!this.getAggregation("_overflowButton")){o=new T({id:this.getId()+"-overflowButton",icon:e.getIconURI("overflow"),press:this._overflowButtonPressed.bind(this),ariaLabelledBy:I.getStaticId("sap.ui.core","Icon.overflow"),type:B.Transparent});this.setAggregation("_overflowButton",o,true);}return this.getAggregation("_overflowButton");};k.prototype._overflowButtonPressed=function(E){var p=this._getPopover(),s=this._getBestPopoverPlacement();if(p.getPlacement()!==s){p.setPlacement(s);}if(p.isOpen()){p.close();}else{p.openBy(E.getSource());}};k.prototype._getPopover=function(){var p;if(!this.getAggregation("_popover")){p=new c(this.getId()+"-popover",{showHeader:false,showArrow:false,modal:false,horizontalScrolling:f.system.phone?false:true,contentWidth:f.system.phone?"100%":"auto",offsetY:this._detireminePopoverVerticalOffset(),ariaLabelledBy:I.getStaticId("sap.m","INPUT_AVALIABLE_VALUES")});p._adaptPositionParams=function(){c.prototype._adaptPositionParams.call(this);this._myPositions=["end top","begin center","end bottom","end center"];this._atPositions=["end bottom","end center","end top","begin center"];};if(f.system.phone){p.attachBeforeOpen(this._shiftPopupShadow,this);}p.attachAfterClose(this._popOverClosedHandler,this);this.setAggregation("_popover",p,true);}return this.getAggregation("_popover");};k.prototype._shiftPopupShadow=function(){var p=this._getPopover(),s=p.getCurrentPosition();if(s===h.Bottom){p.addStyleClass("sapMOTAPopoverNoShadowTop");p.removeStyleClass("sapMOTAPopoverNoShadowBottom");}else if(s===h.Top){p.addStyleClass("sapMOTAPopoverNoShadowBottom");p.removeStyleClass("sapMOTAPopoverNoShadowTop");}};k.prototype._popOverClosedHandler=function(){var w=f.os.windows_phone||f.browser.edge&&f.browser.mobile;this._getOverflowButton().setPressed(false);this._getOverflowButton().$().focus();if(this._isNestedInsideAPopup()||w){return;}this._getOverflowButton().setEnabled(false);setTimeout(function(){this._getOverflowButton().setEnabled(true);setTimeout(function(){this._getOverflowButton().$().focus();}.bind(this),0);}.bind(this),0);};k.prototype._isNestedInsideAPopup=function(){var s;if(this._bNestedInAPopover!==null){return this._bNestedInAPopover;}s=function(C){if(!C){return false;}if(C.getMetadata().isInstanceOf("sap.ui.core.PopupInterface")){return true;}return s(C.getParent());};this._bNestedInAPopover=s(this);return this._bNestedInAPopover;};k.prototype._getOverflowButtonNeeded=function(){return this._bOverflowButtonNeeded;};k.prototype._setOverflowButtonNeeded=function(v){if(this._bOverflowButtonNeeded!==v){this._bOverflowButtonNeeded=v;}return this;};k.prototype._updateContentInfoInControlsCollections=function(C){this._removeContentFromControlsCollections(C);this._moveControlInSuitableCollection(C,k._getControlPriority(C));};k.prototype._moveControlInSuitableCollection=function(C,p){var i=p!==j.NeverOverflow,A=p===j.AlwaysOverflow;if(d.supportsControl(C)&&A){this._aPopoverOnlyControls.push(C);}else{if(d.supportsControl(C)&&i&&C.getVisible()){this._aMovableControls.push(C);}else{this._aToolbarOnlyControls.push(C);}}};k.prototype._removeContentFromControlsCollections=function(C){var i,m,n;for(i=0;i<this._aAllCollections.length;i++){m=this._aAllCollections[i];n=m.indexOf(C);if(n!==-1){m.splice(n,1);}}};k.prototype._clearAllControlsCollections=function(){this._aMovableControls=[];this._aToolbarOnlyControls=[];this._aPopoverOnlyControls=[];this._aAllCollections=[this._aMovableControls,this._aToolbarOnlyControls,this._aPopoverOnlyControls];};k.prototype.onLayoutDataChange=function(E){this._resetAndInvalidateToolbar(true);E&&this._updateContentInfoInControlsCollections(E.srcControl);};k.prototype.addContent=function(C){this._registerControlListener(C);this._resetAndInvalidateToolbar(false);if(C){this._moveControlInSuitableCollection(C,k._getControlPriority(C));}return this._callToolbarMethod("addContent",arguments);};k.prototype.insertContent=function(C,i){this._registerControlListener(C);this._resetAndInvalidateToolbar(false);if(C){this._moveControlInSuitableCollection(C,k._getControlPriority(C));}return this._callToolbarMethod("insertContent",arguments);};k.prototype.removeContent=function(){var C=this._callToolbarMethod("removeContent",arguments);if(C){this._getPopover().removeAssociatedContent(C.getId());}this._resetAndInvalidateToolbar(false);this._deregisterControlListener(C);this._removeContentFromControlsCollections(C);return C;};k.prototype.removeAllContent=function(){var C=this._callToolbarMethod("removeAllContent",arguments);C.forEach(this._deregisterControlListener,this);C.forEach(this._removeContentFromControlsCollections,this);this._resetAndInvalidateToolbar(false);this._clearAllControlsCollections();return C;};k.prototype.destroyContent=function(){this._resetAndInvalidateToolbar(false);setTimeout(function(){this._resetAndInvalidateToolbar(false);}.bind(this),0);this._clearAllControlsCollections();return this._callToolbarMethod("destroyContent",arguments);};k.prototype._registerControlListener=function(C){var i;if(C){C.attachEvent("_change",this._onContentPropertyChangedOverflowToolbar,this);if(C.getMetadata().getInterfaces().indexOf("sap.m.IOverflowToolbarContent")>-1){i=C.getOverflowToolbarConfig().invalidationEvents;if(i&&Array.isArray(i)){i.forEach(function(E){C.attachEvent(E,this._onInvalidationEventFired,this);},this);}}}};k.prototype._deregisterControlListener=function(C){var i;if(C){C.detachEvent("_change",this._onContentPropertyChangedOverflowToolbar,this);if(C.getMetadata().getInterfaces().indexOf("sap.m.IOverflowToolbarContent")>-1){i=C.getOverflowToolbarConfig().invalidationEvents;if(i&&Array.isArray(i)){i.forEach(function(E){C.detachEvent(E,this._onInvalidationEventFired,this);},this);}}}};k.prototype._onContentPropertyChangedOverflowToolbar=function(E){var s=E.getSource(),C,p;this._updateContentInfoInControlsCollections(s);if(!this._bListenForControlPropertyChanges){return;}C=d.getControlConfig(s);p=E.getParameter("name");if(typeof C!=="undefined"&&C.noInvalidationProps.indexOf(p)!==-1){return;}if(p==="visible"){this._bContentVisibilityChanged=true;}this._resetAndInvalidateToolbar(true);};k.prototype._onInvalidationEventFired=function(){if(!this._bListenForInvalidationEvents){return;}this._resetAndInvalidateToolbar(true);};k.prototype._getOverflowButtonSize=function(){var i=parseInt(l.BaseFontSize),C=this.$().parents().hasClass('sapUiSizeCompact')?2.5:3,m=D.toPx(P.get("_sap_m_Toolbar_MarginRight")),n=m===0?0.25*i:0;return parseInt(i*C)-n;};k.prototype._getBestPopoverPlacement=function(){var H=this.getHTMLTag();if(H==="Footer"){return h.Top;}else if(H==="Header"){return h.Bottom;}return h.Vertical;};k.prototype._getControlsIds=function(){return this.getContent().map(function(i){return i.getId();});};k.prototype._getControlIndex=function(C){return C.length?C._index:this.indexOfContent(C);};k.prototype._getOptimalControlWidth=function(C,o){var i,m=C.getLayoutData(),s=m&&m.isA("sap.m.ToolbarLayoutData")?m.getShrinkable():false,M=s?this._getMinWidthOfShrinkableControl(C):0,v=C.getVisible(),S;if(C.isA("sap.m.ToolbarSpacer")){S=parseInt(C.$().css('width'));M=(C.getWidth()&&S)?S:0;i=M+(C.$().outerWidth(true)-C.$().outerWidth());}else if(s&&M>0&&v){i=M+C.$().outerWidth(true)-C.$().outerWidth();}else{i=v?C.$().outerWidth(true):0;}if(i===null){i=typeof o!=="undefined"?o:0;}return i;};k.prototype._getMinWidthOfShrinkableControl=function(C){var m=C.$().css("min-width"),M=parseInt(m),r=a.isRelativeWidth(m);if(r){return(M*this.$().width())/100;}else{return M;}};k._getControlPriority=function(C){var i,o,p,G;if(C.length){return C._priority;}i=C.getMetadata().getInterfaces().indexOf("sap.m.IOverflowToolbarContent")>-1;G=i&&C.getOverflowToolbarConfig().getCustomImportance;if(i&&typeof G==="function"){return G();}o=C.getLayoutData&&C.getLayoutData();if(o&&o instanceof O){if(o.getMoveToOverflow()===false){return j.NeverOverflow;}if(o.getStayInOverflow()===true){return j.AlwaysOverflow;}p=o.getPriority();if(p===j.Never){return j.NeverOverflow;}if(p===j.Always){return j.AlwaysOverflow;}return p;}return j.High;};k._getControlGroup=function(C){var o=C.getLayoutData();if(o instanceof O){return o.getGroup();}};k._oPriorityOrder=(function(){var p={};p[j.Disappear]=1;p[j.Low]=2;p["Medium"]=3;p[j.High]=4;return p;})();k.prototype._detireminePopoverVerticalOffset=function(){return this.$().parents().hasClass('sapUiSizeCompact')?2:3;};k.prototype.onThemeChanged=function(){this._resetAndInvalidateToolbar();for(var C in this._aControlSizes){if(this._aControlSizes.hasOwnProperty(C)){this._aControlSizes[C]=0;}}};k.prototype.closeOverflow=function(){this._getPopover().close();};return k;});
