/*!
 * OpenUI5
 * (c) Copyright 2009-2019 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(['sap/ui/core/Control','sap/ui/base/ManagedObject','sap/ui/base/ManagedObjectObserver','sap/ui/unified/library','sap/ui/unified/calendar/CalendarUtils','sap/ui/unified/calendar/CalendarDate','sap/ui/unified/DateRange','sap/ui/unified/CalendarAppointment','sap/ui/unified/CalendarRow','sap/ui/unified/CalendarRowRenderer','sap/ui/unified/CalendarDateInterval','sap/ui/unified/CalendarWeekInterval','sap/ui/unified/CalendarOneMonthInterval','sap/ui/unified/CalendarMonthInterval','sap/ui/unified/CalendarTimeInterval','sap/ui/Device','sap/ui/core/Element','sap/ui/core/Renderer','sap/ui/core/ResizeHandler','sap/ui/core/Item','sap/ui/core/dnd/DragInfo','sap/ui/core/dnd/DropInfo','sap/ui/core/dnd/DragDropInfo','sap/m/Select','sap/m/Button','sap/m/OverflowToolbar','sap/m/Toolbar','sap/m/Table','sap/m/Column','sap/m/ColumnListItem','sap/m/ColumnListItemRenderer','sap/m/StandardListItem','sap/m/StandardListItemRenderer','sap/m/PlanningCalendarRow','sap/m/PlanningCalendarRenderer','sap/m/PlanningCalendarView','sap/m/CheckBox','sap/m/library',"sap/base/util/deepEqual","sap/base/Log","sap/ui/thirdparty/jquery","sap/ui/dom/jquery/control"],function(C,M,a,u,b,c,D,d,e,f,g,h,k,l,m,n,E,R,o,I,p,q,r,S,B,O,T,s,t,v,w,x,y,P,z,A,F,G,H,L,Q){"use strict";var J=G.Sticky;var K=u.CalendarDayType;var N=G.ListMode;var U=G.ToolbarDesign;var V=G.ButtonType;var W=G.PlanningCalendarBuiltInView;var X=G.ScreenSize;var Y=u.CalendarAppointmentVisualization;var Z=u.GroupAppointmentsMode;var $=u.CalendarIntervalType;var _="DragDropConfig";var a1="ResizeConfig";var b1="CreateConfig";var c1="-CLI";var d1=C.extend("sap.m.PlanningCalendar",{metadata:{library:"sap.m",properties:{startDate:{type:"object",group:"Data"},viewKey:{type:"string",group:"Appearance",defaultValue:$.Hour},singleSelection:{type:"boolean",group:"Misc",defaultValue:true},width:{type:"sap.ui.core.CSSSize",group:"Dimension",defaultValue:null},height:{type:"sap.ui.core.CSSSize",group:"Dimension",defaultValue:null},showIntervalHeaders:{type:"boolean",group:"Appearance",defaultValue:true},showEmptyIntervalHeaders:{type:"boolean",group:"Appearance",defaultValue:true},showRowHeaders:{type:"boolean",group:"Appearance",defaultValue:true},noDataText:{type:"string",group:"Misc",defaultValue:null},groupAppointmentsMode:{type:"sap.ui.unified.GroupAppointmentsMode",group:"Appearance",defaultValue:Z.Collapsed},appointmentsReducedHeight:{type:"boolean",group:"Appearance",defaultValue:false},appointmentsVisualization:{type:"sap.ui.unified.CalendarAppointmentVisualization",group:"Appearance",defaultValue:Y.Standard},minDate:{type:"object",group:"Misc",defaultValue:null},maxDate:{type:"object",group:"Misc",defaultValue:null},showDayNamesLine:{type:"boolean",group:"Appearance",defaultValue:false},showWeekNumbers:{type:"boolean",group:"Appearance",defaultValue:false},builtInViews:{type:"string[]",group:"Appearance",defaultValue:[]},stickyHeader:{type:"boolean",group:"Appearance",defaultValue:false}},aggregations:{rows:{type:"sap.m.PlanningCalendarRow",multiple:true,singularName:"row"},views:{type:"sap.m.PlanningCalendarView",multiple:true,singularName:"view"},specialDates:{type:"sap.ui.unified.DateTypeRange",multiple:true,singularName:"specialDate"},toolbarContent:{type:"sap.ui.core.Control",multiple:true,singularName:"toolbarContent",forwarding:{getter:"_getTableHeaderToolbar",aggregation:"content"},forwardBinding:true},table:{type:"sap.m.Table",multiple:false,visibility:"hidden"}},associations:{ariaLabelledBy:{type:"sap.ui.core.Control",multiple:true,singularName:"ariaLabelledBy"},legend:{type:"sap.ui.unified.CalendarLegend",multiple:false}},events:{appointmentSelect:{parameters:{appointment:{type:"sap.ui.unified.CalendarAppointment"},appointments:{type:"sap.ui.unified.CalendarAppointment[]"},multiSelect:{type:"boolean"},domRefId:{type:"string"}}},intervalSelect:{parameters:{startDate:{type:"object"},endDate:{type:"object"},subInterval:{type:"boolean"},row:{type:"sap.m.PlanningCalendarRow"}}},rowSelectionChange:{parameters:{rows:{type:"sap.m.PlanningCalendarRow[]"}}},startDateChange:{},viewChange:{},rowHeaderClick:{row:{type:"sap.m.PlanningCalendarRow"}}},designtime:"sap/m/designtime/PlanningCalendar.designtime"},constructor:function(i,j){C.prototype.constructor.apply(this,arguments);if(typeof i!=="string"){j=i;}if(j&&typeof j.customAppointmentsSorterCallback==="function"){this._fnCustomSortedAppointments=j.customAppointmentsSorterCallback;}}});var e1=["_oTimeInterval","_oDateInterval","_oMonthInterval","_oWeekInterval","_oOneMonthInterval"],f1={};f1[$.Day]={sInstanceName:"_oDateInterval",sIdSuffix:"-DateInt",oClass:g};f1[$.Week]={sInstanceName:"_oWeekInterval",sIdSuffix:"-WeekInt",oClass:h};f1[$.OneMonth]={sInstanceName:"_oOneMonthInterval",sIdSuffix:"-OneMonthInt",oClass:k};var g1=X.Desktop;var h1=[W.Hour,W.Day,W.Month,W.Week,W.OneMonth];var i1={PHONE:"600",TABLET:"1024"};var j1=["sap.ui.unified.CalendarTimeInterval","sap.ui.unified.CalendarDateInterval","sap.ui.unified.CalendarMonthInterval"];var k1=C.extend("CalendarHeader",{metadata:{aggregations:{"toolbar":{type:"sap.m.Toolbar",multiple:false},"allCheckBox":{type:"sap.m.CheckBox",multiple:false}}},renderer:function(i,j){i.write("<div");i.writeControlData(j);i.addClass("sapMPlanCalHead");i.writeClasses();i.write(">");var M1=j.getToolbar();if(M1){i.renderControl(M1);}var N1=j.getAllCheckBox();if(N1){i.renderControl(N1);}i.write("</div>");}});d1.prototype.init=function(){this._iBreakPointTablet=n.media._predefinedRangeSets[n.media.RANGESETS.SAP_STANDARD_EXTENDED].points[0];this._iBreakPointDesktop=n.media._predefinedRangeSets[n.media.RANGESETS.SAP_STANDARD_EXTENDED].points[1];this._iBreakPointLargeDesktop=n.media._predefinedRangeSets[n.media.RANGESETS.SAP_STANDARD_EXTENDED].points[2];if(n.system.phone||Q('html').hasClass("sapUiMedia-Std-Phone")){this._iSize=0;this._iSizeScreen=0;}else if(n.system.tablet||Q('html').hasClass("sapUiMedia-Std-Tablet")){this._iSize=1;this._iSizeScreen=1;}else{this._iSize=2;this._iSizeScreen=2;}this._oRB=sap.ui.getCore().getLibraryResourceBundle("sap.m");var i=this.getId();this._oIntervalTypeSelect=new S(i+"-IntType",{maxWidth:"15rem",ariaLabelledBy:i+"-SelDescr"});this._oIntervalTypeSelect.attachEvent("change",m1,this);this._oTodayButton=new B(i+"-Today",{text:this._oRB.getText("PLANNINGCALENDAR_TODAY"),type:V.Transparent});this._oTodayButton.attachEvent("press",this._handleTodayPress,this);this._oHeaderToolbar=new T(i+"-HeaderToolbar",{design:U.Transparent,content:[this._oIntervalTypeSelect,this._oTodayButton]});this._oCalendarHeader=new k1(i+"-CalHead",{toolbar:this._oHeaderToolbar});this._oInfoToolbar=new T(i+"-InfoToolbar",{height:"auto",design:U.Transparent,content:[this._oCalendarHeader,this._oTimeInterval]});var j=new O(this.getId()+"-Toolbar",{design:U.Transparent,visible:false});j._oPlanningCalendar=this;var M1=new s(i+"-Table",{sticky:[],infoToolbar:this._oInfoToolbar,headerToolbar:j,mode:N.SingleSelectMaster,columns:[new t({styleClass:"sapMPlanCalRowHead"}),new t({width:"80%",styleClass:"sapMPlanCalAppRow",minScreenWidth:g1,demandPopin:true})],ariaLabelledBy:i+"-Descr"});M1.attachEvent("selectionChange",C1,this);M1.addDelegate({onBeforeRendering:function(){if(this._rowHeaderClickEvent){this._rowHeaderClickEvent.off();}},onAfterRendering:function(){this._rowHeaderClickEvent=M1.$().find(".sapMPlanCalRowHead > div.sapMLIB").click(function(N1){var O1=Q(N1.currentTarget).control(0),P1=y1(O1.getParent());this.fireRowHeaderClick({row:P1});}.bind(this));}},false,this);this.setAggregation("table",M1,true);this.setStartDate(new Date());this._resizeProxy=Q.proxy(q1,this);this._fnCustomSortedAppointments=undefined;this.iWidth=0;};d1.prototype.exit=function(){if(this._sResizeListener){o.deregister(this._sResizeListener);this._sResizeListener=undefined;}n.orientation.detachHandler(this._updateStickyHeader,this);if(this._sUpdateCurrentTime){clearTimeout(this._sUpdateCurrentTime);this._sUpdateCurrentTime=undefined;}var i=this.getAggregation("table");i.removeAllItems();e1.forEach(function(M1){if(this[M1]){this[M1]._oPlanningCalendar=undefined;this[M1].destroy();this[M1]=undefined;}},this);if(this._oViews){for(var j in this._oViews){this._oViews[j].destroy();}}if(this._oSelectAllCheckBox){this._oSelectAllCheckBox.destroy();}if(this._rowHeaderClickEvent){this._rowHeaderClickEvent.off();this._rowHeaderClickEvent=null;}};d1.prototype.onBeforeRendering=function(){this._bBeforeRendering=true;if((!this._oTimeInterval&&!this._oDateInterval&&!this._oMonthInterval&&!this._oWeekInterval&&!this._oOneMonthInterval)||this._bCheckView){this.setViewKey(this.getViewKey());this._bCheckView=undefined;}F1.call(this);if(this._sUpdateCurrentTime){clearTimeout(this._sUpdateCurrentTime);this._sUpdateCurrentTime=undefined;}this._updateTodayButtonState();n.orientation.detachHandler(this._updateStickyHeader,this);this._bBeforeRendering=undefined;};d1.prototype.attachEvent=function(i,j,M1,N1){C.prototype.attachEvent.call(this,i,j,M1,N1);if(this.hasListeners("intervalSelect")){e1.forEach(function(O1){if(this[O1]){this[O1]._setAriaRole("button");}},this);}return this;};d1.prototype.detachEvent=function(i,j,M1){C.prototype.detachEvent.call(this,i,j,M1);if(!this.hasListeners("intervalSelect")){e1.forEach(function(N1){if(this[N1]){this[N1]._setAriaRole("gridcell");}},this);}return this;};d1.prototype._setAriaRole=function(i){if(this.hasListeners("intervalSelect")){i._setAriaRole("button");}else{i._setAriaRole("gridcell");}};d1.prototype._updateTodayButtonState=function(){if(this._oTodayButton){this._oTodayButton.setEnabled(!this._dateMatchesVisibleRange(new Date(),this.getViewKey()));}};d1.prototype._dateMatchesVisibleRange=function(i,j){var M1=this._getView(j,!this._bBeforeRendering);if(!M1){return false;}var N1=M1.getIntervalType(),O1=f1[N1],P1=O1?this[O1.sInstanceName]:null,Q1=false;if(P1&&P1._dateMatchesVisibleRange){Q1=P1._dateMatchesVisibleRange(i);}return Q1;};d1.prototype.onAfterRendering=function(i){i.size={width:this.getDomRef().offsetWidth};q1.call(this,i,true);if(!this._sResizeListener){this._sResizeListener=o.register(this,this._resizeProxy);}if(n.system.phone&&this.getStickyHeader()){n.orientation.attachHandler(this._updateStickyHeader,this);}this._updateCurrentTimeVisualization(false);if(this.getHeight()){var j=this.getDomRef().querySelector("table");var M1=this.$().height()-this._oInfoToolbar.$().height()-this._getTableHeaderToolbar().$().height()+"px";j.style.height=M1;}};d1.prototype.addToolbarContent=function(i){this.addAggregation("toolbarContent",i);l1.call(this);return this;};d1.prototype.insertToolbarContent=function(i,j){this.insertAggregation("toolbarContent",i,j);l1.call(this);return this;};d1.prototype.removeToolbarContent=function(i){var j=this.removeAggregation("toolbarContent",i);l1.call(this);return j;};d1.prototype.removeAllToolbarContent=function(){var i=this.removeAllAggregation("toolbarContent");l1.call(this);return i;};d1.prototype.destroyToolbarContent=function(){var i=this.destroyAggregation("toolbarContent");l1.call(this);return i;};function l1(){this._getTableHeaderToolbar().setVisible(!!this.getToolbarContent().length);}d1.prototype.setStartDate=function(i){var j,M1,N1;if(!i){N1=new Date();}else{b._checkJSDateObject(i);N1=new Date(i.getTime());}if(this.getViewKey()===W.Week){j=b.getFirstDateOfWeek(b._createUniversalUTCDate(N1,undefined,true));N1.setTime(b._createLocalDate(j,true).getTime());}if(this.getViewKey()===W.OneMonth||this.getViewKey()===W.Month){M1=b.getFirstDateOfMonth(b._createUniversalUTCDate(N1,undefined,true));N1.setTime(b._createLocalDate(M1,true).getTime());}if(H(N1,this.getStartDate())){this._updateTodayButtonState();return this;}var O1=N1.getFullYear();b._checkYearInValidRange(O1);var P1=this.getMinDate();if(P1&&P1.getTime()>N1.getTime()){L.warning("StartDate < minDate -> StartDate set to minDate",this);N1=new Date(P1.getTime());}else{var Q1=this.getMaxDate();if(Q1&&Q1.getTime()<N1.getTime()){L.warning("StartDate > maxDate -> StartDate set to minDate",this);if(P1){N1=new Date(P1.getTime());}else{N1=new Date(1,0,1);N1.setFullYear(1);}}}this.setProperty("startDate",N1,true);e1.forEach(function(R1){if(this[R1]){this[R1].setStartDate(new Date(N1.getTime()));}},this);this._setRowsStartDate(new Date(N1.getTime()));if(this.getViewKey()===W.Week||this.getViewKey()===W.OneMonth){this._updateTodayButtonState();}if(this.getDomRef()){this._updateCurrentTimeVisualization(false);}return this;};d1.prototype.setMinDate=function(i){if(H(i,this.getMinDate())){return this;}var j=this.getMaxDate();if(i){b._checkJSDateObject(i);var M1=i.getFullYear();b._checkYearInValidRange(M1);this.setProperty("minDate",i,true);this._bNoStartDateChange=true;e1.forEach(function(P1){if(this[P1]){this[P1].setMinDate(new Date(i.getTime()));}},this);if(j&&j.getTime()<i.getTime()){L.warning("minDate > maxDate -> maxDate set to end of the month",this);j=new Date(i.getTime());j.setMonth(j.getMonth()+1,0);j.setHours(23);j.setMinutes(59);j.setSeconds(59);j.setMilliseconds(0);this.setMaxDate(j);}this._bNoStartDateChange=undefined;var N1=this.getStartDate();if(N1&&N1.getTime()<i.getTime()){L.warning("StartDate < minDate -> StartDate set to minDate",this);N1=new Date(i.getTime());this.setStartDate(N1);}}else{this.setProperty("minDate",undefined,true);e1.forEach(function(P1){if(this[P1]){this[P1].setMinDate();}},this);}var O1=new Date();if(i&&O1.getTime()<i.getTime()){this._oTodayButton.setVisible(false);}else if(!j||O1.getTime()<j.getTime()){this._oTodayButton.setVisible(true);}return this;};d1.prototype.setMaxDate=function(i){if(H(i,this.getMaxDate())){return this;}var j=this.getMinDate();if(i){b._checkJSDateObject(i);var M1=i.getFullYear();b._checkYearInValidRange(M1);this.setProperty("maxDate",i,true);this._bNoStartDateChange=true;e1.forEach(function(P1){if(this[P1]){this[P1].setMaxDate(new Date(i.getTime()));}},this);if(j&&j.getTime()>i.getTime()){L.warning("maxDate < minDate -> maxDate set to begin of the month",this);j=new Date(i.getTime());j.setDate(1);j.setHours(0);j.setMinutes(0);j.setSeconds(0);j.setMilliseconds(0);this.setMinDate(j);}this._bNoStartDateChange=undefined;var N1=this.getStartDate();if(N1&&N1.getTime()>i.getTime()){L.warning("StartDate > maxDate -> StartDate set to minDate",this);if(j){N1=new Date(j.getTime());}else{N1=new Date(1,0,1);N1.setFullYear(1);}this.setStartDate(N1);}}else{this.setProperty("maxDate",undefined,true);e1.forEach(function(P1){if(this[P1]){this[P1].setMaxDate();}},this);}var O1=new Date();if(i&&O1.getTime()>i.getTime()){this._oTodayButton.setVisible(false);}else if(!j||O1.getTime()>j.getTime()){this._oTodayButton.setVisible(true);}return this;};d1.prototype.removeIntervalInstanceFromInfoToolbar=function(){var i=this._oInfoToolbar.getContent();i.forEach(function(j){if(j.isA(j1)){this._oInfoToolbar.removeContent(j);}}.bind(this));};d1.prototype.setViewKey=function(j){var M1,N1,O1,P1=this.getViewKey(),Q1;this.setProperty("viewKey",j,true);this._oIntervalTypeSelect.setSelectedKey(j);this.removeIntervalInstanceFromInfoToolbar();if(j===W.Week||j===W.OneMonth||j===W.Month){N1=this.getStartDate();this.setStartDate(new Date(N1.getTime()));if(N1.getTime()!==this.getStartDate().getTime()){this.fireStartDateChange();}}var R1=this.getStartDate();var S1=this.getMinDate();var T1=this.getMaxDate();var U1=this._getView(j,!this._bBeforeRendering);if(!U1){this._bCheckView=true;this.invalidate();}else{var V1=U1.getIntervalType();var W1=this._getIntervals(U1);this._bCheckView=false;switch(V1){case $.Hour:if(!this._oTimeInterval){this._oTimeInterval=new m(this.getId()+"-TimeInt",{startDate:new Date(R1.getTime()),items:W1,pickerPopup:true,legend:this.getLegend()});this._setAriaRole(this._oTimeInterval);this._oTimeInterval.attachEvent("startDateChange",this._handleStartDateChange,this);this._oTimeInterval.attachEvent("select",this._handleCalendarSelect,this);this._oTimeInterval._oPlanningCalendar=this;this._oTimeInterval.getSpecialDates=function(){return this._oPlanningCalendar.getSpecialDates();};if(S1){this._oTimeInterval.setMinDate(new Date(S1.getTime()));}if(T1){this._oTimeInterval.setMaxDate(new Date(T1.getTime()));}}else if(this._oTimeInterval.getItems()!=W1){this._oTimeInterval.setItems(W1);}this._insertInterval(this._oTimeInterval);break;case $.Day:case $.Week:case $.OneMonth:O1=f1[V1];M1=this[O1.sInstanceName];if(!M1){M1=new O1.oClass(this.getId()+O1.sIdSuffix,{startDate:new Date(R1.getTime()),days:W1,showDayNamesLine:this.getShowDayNamesLine(),pickerPopup:true,legend:this.getLegend(),showWeekNumbers:this.getShowWeekNumbers()});this._setAriaRole(M1);M1.attachEvent("startDateChange",this._handleStartDateChange,this);M1.attachEvent("select",this._handleCalendarSelect,this);if(j===W.OneMonth){M1._setRowsStartDate=this._setRowsStartDate.bind(this);}M1._oPlanningCalendar=this;M1.getSpecialDates=function(){return this._oPlanningCalendar.getSpecialDates();};if(S1){M1.setMinDate(new Date(S1.getTime()));}if(T1){M1.setMaxDate(new Date(T1.getTime()));}}else if(M1.getDays()!==W1){M1.setDays(W1);}this._insertInterval(M1);this[O1.sInstanceName]=M1;break;case $.Month:if(!this._oMonthInterval){this._oMonthInterval=new l(this.getId()+"-MonthInt",{startDate:new Date(R1.getTime()),months:W1,pickerPopup:true,legend:this.getLegend()});this._setAriaRole(this._oMonthInterval);this._oMonthInterval.attachEvent("startDateChange",this._handleStartDateChange,this);this._oMonthInterval.attachEvent("select",this._handleCalendarSelect,this);this._oMonthInterval._oPlanningCalendar=this;this._oMonthInterval.getSpecialDates=function(){return this._oPlanningCalendar.getSpecialDates();};if(S1){this._oMonthInterval.setMinDate(new Date(S1.getTime()));}if(T1){this._oMonthInterval.setMaxDate(new Date(T1.getTime()));}}else if(this._oMonthInterval.setMonths()!=W1){this._oMonthInterval.setMonths(W1);}this._insertInterval(this._oMonthInterval);break;default:throw new Error("Unknown IntervalType: "+V1+"; "+this);}var X1=this.getRows();for(var i=0;i<X1.length;i++){var Y1=X1[i];var Z1=B1(Y1);Z1.setIntervalType(V1);Z1.setIntervals(W1);Z1.setShowSubIntervals(U1.getShowSubIntervals());}if(this.getDomRef()){this._updateCurrentTimeVisualization(false);o1.call(this,this.getShowWeekNumbers(),this._viewAllowsWeekNumbers(j));p1.call(this,this.getShowDayNamesLine(),!!M1);}}if(this._oOneMonthInterval&&j===W.OneMonth){this._oOneMonthInterval._setDisplayMode(this._iSize);this._oOneMonthInterval._adjustSelectedDate(c.fromLocalJSDate(N1));if(this._iSize<2){this._setRowsStartDate(N1);}}else if(this._oOneMonthInterval&&P1===W.OneMonth&&this._oOneMonthInterval.getSelectedDates().length){Q1=this._oOneMonthInterval.getSelectedDates()[0].getStartDate();if(Q1){this.setStartDate(Q1);}}this._updateTodayButtonState();return this;};d1.prototype._insertInterval=function(i){if(this._iSizeScreen>1){this._oInfoToolbar.addContent(i);}else{this._oInfoToolbar.insertContent(i,1);}};d1.prototype._viewAllowsWeekNumbers=function(i){var j=this._getView(i).getIntervalType(),M1=f1[j];return!!M1&&!!M1.oClass.prototype.setShowWeekNumbers;};d1.prototype._viewAllowsDayNamesLine=function(i){var j=this._getView(i).getIntervalType(),M1=f1[j];return!!M1&&!!M1.oClass.prototype.setShowDayNamesLine;};d1.prototype._getIntervalInstanceByViewKey=function(i){var j=this._getView(i).getIntervalType(),M1=f1[j],N1;if(M1){N1=this[M1.sInstanceName];}return N1;};d1.prototype.setShowWeekNumbers=function(i){this.setProperty("showWeekNumbers",i,true);this._getViews().forEach(function(j){var M1=j.getKey(),N1=this._viewAllowsWeekNumbers(M1),O1=this._getIntervalInstanceByViewKey(M1);if(O1&&N1){this._getIntervalInstanceByViewKey(M1).setShowWeekNumbers(i);}if(this.getDomRef()&&this.getViewKey()===M1){o1.call(this,i,N1);}},this);return this;};d1.prototype.setShowIntervalHeaders=function(j){this.setProperty("showIntervalHeaders",j,true);var M1=this.getRows();for(var i=0;i<M1.length;i++){var N1=M1[i];B1(N1).setShowIntervalHeaders(j);}return this;};d1.prototype.setShowEmptyIntervalHeaders=function(j){this.setProperty("showEmptyIntervalHeaders",j,true);var M1=this.getRows();for(var i=0;i<M1.length;i++){var N1=M1[i];B1(N1).setShowEmptyIntervalHeaders(j);}return this;};d1.prototype.setGroupAppointmentsMode=function(j){this.setProperty("groupAppointmentsMode",j,true);var M1=this.getRows();for(var i=0;i<M1.length;i++){var N1=M1[i];B1(N1).setGroupAppointmentsMode(j);}return this;};d1.prototype.setAppointmentsReducedHeight=function(j){this.setProperty("appointmentsReducedHeight",j,true);var M1=this.getRows();for(var i=0;i<M1.length;i++){var N1=M1[i];B1(N1).setAppointmentsReducedHeight(j);}return this;};d1.prototype.setAppointmentsVisualization=function(j){this.setProperty("appointmentsVisualization",j,true);var M1=this.getRows();for(var i=0;i<M1.length;i++){var N1=M1[i];B1(N1).setAppointmentsVisualization(j);}return this;};d1.prototype.setShowRowHeaders=function(i){this.setProperty("showRowHeaders",i,true);var j=this.getAggregation("table");j.getColumns()[0].setVisible(i);this._toggleAppointmentsColumnPopinState(i);this.$().toggleClass("sapMPlanCalNoHead",!i);J1.call(this);K1.call(this);return this;};d1.prototype.setShowDayNamesLine=function(i){var j,M1,N1,O1=!!this.getDomRef(),P1=this.getViewKey();for(j in f1){M1=f1[j].sInstanceName;if(this[M1]){N1=this[M1];N1.setShowDayNamesLine(i);if(O1&&j===P1){p1.call(this,i,true);}}}return this.setProperty("showDayNamesLine",i,false);};d1.prototype.setStickyHeader=function(i){if(this.getStickyHeader()===i){return this;}this.setProperty("stickyHeader",i,true);if(n.system.phone){if(i){n.orientation.attachHandler(this._updateStickyHeader,this);}else{n.orientation.detachHandler(this._updateStickyHeader,this);}}this._updateStickyHeader();return this;};d1.prototype._updateStickyHeader=function(){var i=[],j=this.getStickyHeader(),M1=this.getViewKey()===W.OneMonth&&this._iSize<2,N1=j&&!n.system.phone&&!M1,O1=j&&!(n.system.phone&&n.orientation.landscape)&&!M1;if(N1){i.push(J.HeaderToolbar);}if(this._oInfoToolbar&&O1){i.push(J.InfoToolbar);}this.getAggregation("table").setSticky(i);};d1.prototype.addRow=function(i){this.addAggregation("rows",i,true);this.getAggregation("table").addItem(this._createPlanningCalendarListItem(i));return this;};d1.prototype.insertRow=function(i,j){this.insertAggregation("rows",i,j);this.getAggregation("table").insertItem(this._createPlanningCalendarListItem(i),j,true);return this;};d1.prototype.removeRow=function(i){var j=this.removeAggregation("rows",i,true),M1=this.getAggregation("table");M1.removeItem(z1(j),true);this._handleRowRemoval(j);I1.call(this);K1.call(this);return j;};d1.prototype.removeAllRows=function(){var i=this.removeAllAggregation("rows",true),j=this.getAggregation("table");j.removeAllItems(true);i.forEach(this._handleRowRemoval,this);I1.call(this);K1.call(this);return i;};d1.prototype.destroyRows=function(){var i;var j=this.getAggregation("table");j.destroyItems(true);i=this.destroyAggregation("rows");I1.call(this);K1.call(this);return i;};d1.prototype.setSingleSelection=function(i){this.setProperty("singleSelection",i,true);J1.call(this);K1.call(this);if(i){this.selectAllRows(false);}else{I1.call(this);}this.$().toggleClass("sapMPlanCalMultiSel",!i);return this;};d1.prototype.setNoDataText=function(i){this.setProperty("noDataText",i,true);var j=this.getAggregation("table");j.setNoDataText(i);return this;};d1.prototype.setLegend=function(j){this.setAssociation("legend",j,true);var M1=this.getRows(),N1=this.getLegend()&&sap.ui.getCore().byId(this.getLegend()),O1;for(var i=0;i<M1.length;i++){var P1=M1[i];B1(P1).setLegend(j);}e1.forEach(function(Q1){if(this[Q1]){this[Q1].setLegend(j);}},this);if(N1){O1=new a(function(Q1){this.invalidate();}.bind(this));O1.observe(N1,{destroy:true});}return this;};d1.prototype.addAriaLabelledBy=function(i){this.addAssociation("ariaLabelledBy",i,true);var j=this.getAggregation("table");j.addAriaLabelledBy(i);return this;};d1.prototype.removeAriaLabelledBy=function(i){this.removeAssociation("ariaLabelledBy",i,true);var j=this.getAggregation("table");j.removeAriaLabelledBy(i);return this;};d1.prototype.removeAllAriaLabelledBy=function(){this.removeAllAssociation("ariaLabelledBy",true);var i=this.getAggregation("table");i.removeAllAriaLabelledBy();i.addAriaLabelledBy(this.getId()+"-Descr");return this;};d1.prototype.invalidate=function(i){var j=i&&i instanceof D;if(!this._bIsBeingDestroyed&&(this._bDateRangeChanged||j)){if(this.getDomRef()){var M1=this.getViewKey();var N1=this._getView(M1);var O1=N1.getIntervalType();switch(O1){case $.Hour:if(this._oTimeInterval){this._oTimeInterval.invalidate(arguments);}break;case $.Day:if(this._oDateInterval){this._oDateInterval.invalidate(arguments);}break;case $.Month:if(this._oMonthInterval){this._oMonthInterval.invalidate(arguments);}break;case $.OneMonth:if(this._oOneMonthInterval){this._oOneMonthInterval.invalidate(arguments);}break;case $.Week:if(this._oWeekInterval){this._oWeekInterval.invalidate(arguments);}break;default:throw new Error("Unknown IntervalType: "+O1+"; "+this);}}this._bDateRangeChanged=undefined;}else{if(i&&i instanceof sap.m.PlanningCalendarView){this._bCheckView=true;}C.prototype.invalidate.apply(this,arguments);}};d1.prototype.addSpecialDate=function(i){this._bDateRangeChanged=true;return C.prototype.addAggregation.call(this,"specialDates",i);};d1.prototype.insertSpecialDate=function(i,j){this._bDateRangeChanged=true;return C.prototype.insertAggregation.call(this,"specialDates",i,j);};d1.prototype.removeSpecialDate=function(i){this._bDateRangeChanged=true;return C.prototype.removeAggregation.call(this,"specialDates",i);};d1.prototype.removeAllSpecialDates=function(){this._bDateRangeChanged=true;return this.removeAllAggregation("specialDates");};d1.prototype.destroySpecialDates=function(){this._bDateRangeChanged=true;return this.destroyAggregation("specialDates");};d1.prototype.removeAllViews=function(){this._bCheckView=true;var i=this.removeAllAggregation("views"),j=this.getBuiltInViews();if(j.length){this.setViewKey(j[0]);}else{this.setViewKey(h1[0]);}return i;};d1.prototype.destroyViews=function(){this._bCheckView=true;var i=this.destroyAggregation("views"),j=this.getBuiltInViews();if(j.length){this.setViewKey(j[0]);}else{this.setViewKey(h1[0]);}return i;};d1.prototype.getSelectedRows=function(){return this.getRows().filter(function(i){return i.getSelected();});};d1.prototype.selectAllRows=function(j){var M1=this.getRows();if(!(j&&this.getSingleSelection())){for(var i=0;i<M1.length;i++){var N1=M1[i];N1.setSelected(j);}if(this._oSelectAllCheckBox){this._oSelectAllCheckBox.setSelected(j);}}return this;};d1.prototype.onsaphomemodifiers=function(i){if((i.metaKey||i.ctrlKey)&&!i.altKey&&!i.shiftKey){var j=this.getRows();var M1=j[0];var N1=new Q.Event("saphome");N1._bPlanningCalendar=true;B1(M1).onsaphome(N1);i.preventDefault();i.stopPropagation();}};d1.prototype.onsapendmodifiers=function(i){if((i.metaKey||i.ctrlKey)&&!i.altKey&&!i.shiftKey){var j=this.getRows();var M1=j[j.length-1];var N1=new Q.Event("sapend");N1._bPlanningCalendar=true;B1(M1).onsapend(N1);i.preventDefault();i.stopPropagation();}};d1.prototype.setBuiltInViews=function(i){this.setProperty("builtInViews",i);this.setViewKey(this._getViews()[0].getKey());return this;};d1.prototype.removeView=function(i){var j=this.removeAggregation("views",i);if(!this.getViews().length){this.setViewKey(this._getViews()[0].getKey());}return j;};d1.prototype._getIntervals=function(i){var j=0;switch(this._iSize){case 0:j=i.getIntervalsS();break;case 1:j=i.getIntervalsM();break;default:j=i.getIntervalsL();break;}return j;};d1.prototype._getView=function(j,M1){var N1=this._getViews();var O1;for(var i=0;i<N1.length;i++){O1=N1[i];if(O1.getKey()!=j){O1=undefined;}else{break;}}if(!O1&&!M1){throw new Error("PlanningCalendarView with key "+j+"not assigned "+this);}return O1;};d1.prototype._changeStartDate=function(i){if(this._bNoStartDateChange){return;}this.setStartDate(new Date(i.getTime()));this.fireStartDateChange();};d1.prototype._updateCurrentTimeVisualization=function(j){if(this._sUpdateCurrentTime){clearTimeout(this._sUpdateCurrentTime);this._sUpdateCurrentTime=undefined;}if(j){var M1=this.getRows();for(var i=0;i<M1.length;i++){var N1=M1[i];B1(N1).updateCurrentTimeVisualization();}}var O1=new Date();var P1=this.getStartDate();var Q1=this.getViewKey();var R1=this._getView(Q1);var S1=R1.getIntervalType();var T1=this._getIntervals(R1);var U1=0;var V1=0;var W1=0;switch(S1){case $.Hour:U1=60000;V1=P1.getTime()-3600000;W1=P1.getTime()+T1*3600000;break;case $.Day:case $.Week:case $.OneMonth:U1=1800000;V1=P1.getTime()-3600000;W1=P1.getTime()+T1*86400000;break;default:U1=-1;break;}if(O1.getTime()<=W1&&O1.getTime()>=V1&&U1>0){this._sUpdateCurrentTime=setTimeout(this['_updateCurrentTimeVisualization'].bind(this,true),U1);}};function m1(i){this.setViewKey(i.getParameter("selectedItem").getKey());this.fireViewChange();}d1.prototype._handleTodayPress=function(i){var j=new Date(),M1,N1=this.getViewKey();if(N1===W.OneMonth){M1=b.getFirstDateOfMonth(b._createUniversalUTCDate(j,undefined,true));this._oOneMonthInterval._adjustSelectedDate(c.fromLocalJSDate(j),false);j=b._createLocalDate(M1,true);}if(N1===W.Week){M1=this.getStartDate();j.setHours(M1.getHours());j.setMinutes(M1.getMinutes());j.setSeconds(M1.getSeconds());}this.setStartDate(j);this.fireStartDateChange();};d1.prototype._handleStartDateChange=function(i){var j=i.oSource.getStartDate();if(this._getView(this.getViewKey()).getIntervalType()!==$.Hour){var M1=this.getStartDate();j.setHours(M1.getHours());j.setMinutes(M1.getMinutes());j.setSeconds(M1.getSeconds());}this._changeStartDate(j);};d1.prototype._handleCalendarSelect=function(i){var j=i.oSource.getSelectedDates();if(!j.length){return;}var M1=new Date(j[0].getStartDate());var N1=b._createUniversalUTCDate(M1,undefined,true);var O1=this.getViewKey();var P1=this._getView(O1);var Q1=P1.getIntervalType();if(Q1!==$.OneMonth||this._iSize>1){j[0].setStartDate();}switch(Q1){case $.Hour:N1.setUTCHours(N1.getUTCHours()+1);break;case $.Day:case $.Week:N1.setUTCDate(N1.getUTCDate()+1);break;case $.OneMonth:if(this._iSize<2){var R1=new Date(M1.getTime());if(b.monthsDiffer(this.getStartDate(),M1)){this.setStartDate(M1);}this._setRowsStartDate(R1);this._oOneMonthInterval.getAggregation('month')[0]._focusDate(c.fromLocalJSDate(R1),true);}else if(b._isNextMonth(M1,this.getStartDate())){this._oOneMonthInterval._handleNext();return;}N1.setUTCDate(N1.getUTCDate()+1);break;case $.Month:N1.setUTCMonth(N1.getUTCMonth()+1);break;default:throw new Error("Unknown IntervalType: "+Q1+"; "+this);}N1.setUTCMilliseconds(N1.getUTCMilliseconds()-1);N1=b._createLocalDate(N1,true);this.fireIntervalSelect({startDate:M1,endDate:N1,subInterval:false,row:undefined});};function n1(i){var j=i.getParameter("startDate");var M1=this.getViewKey();var N1=this._getView(M1);var O1=N1.getIntervalType();if(O1===$.OneMonth&&b._isNextMonth(j,this.getStartDate())){this._oOneMonthInterval._handleNext();return;}var P1=i.getParameter("endDate");var Q1=i.getParameter("subInterval");var R1=y1(i.oSource.getParent());this.fireIntervalSelect({startDate:j,endDate:P1,subInterval:Q1,row:R1});}d1.prototype._applyContextualSettings=function(i){return C.prototype._applyContextualSettings.call(this,i||M._defaultContextualSettings);};d1.prototype._getTableHeaderToolbar=function(){return this.getAggregation("table").getHeaderToolbar();};function o1(i,j){this.$().toggleClass("sapMPlanCalWithWeekNumbers",i&&j);}function p1(i,j){this.$().toggleClass("sapMPlanCalWithDayNamesLine",i&&j);}function q1(j,M1){if(j.size.width<=0){return;}if(Math.abs(this.iWidth-j.size.width)<15){return;}this.iWidth=j.size.width;this._applyContextualSettings({contextualWidth:this.iWidth});var N1=this.getRows();var O1;var i=0;var P1=this._iSize;D1.call(this,j.size.width);if(P1!=this._iSize){E1.call(this,this._iSize);var Q1=this.getViewKey();var R1=this._getView(Q1);var S1=R1.getIntervalType();var T1=this._getIntervals(R1);for(i=0;i<N1.length;i++){O1=N1[i];var U1=B1(O1);if(T1!=U1.getIntervals()){U1.setIntervals(T1);}else{U1.handleResize();}}switch(S1){case $.Hour:if(this._oTimeInterval&&this._oTimeInterval.getItems()!=T1){this._oTimeInterval.setItems(T1);}break;case $.Day:if(this._oDateInterval&&this._oDateInterval.getDays()!=T1){this._oDateInterval.setDays(T1);}break;case $.Month:if(this._oMonthInterval&&this._oMonthInterval.getMonths()!=T1){this._oMonthInterval.setMonths(T1);}break;case $.Week:if(this._oWeekInterval&&this._oWeekInterval.getDays()!=T1){this._oWeekInterval.setDays(T1);}break;case $.OneMonth:if(this._oOneMonthInterval&&this._oOneMonthInterval.getDays()!=T1){this._oOneMonthInterval.setDays(T1);if(this._iSize>1){this._setRowsStartDate(new Date(this.getStartDate().getTime()));}}break;default:throw new Error("Unknown IntervalType: "+S1+"; "+this);}J1.call(this);}else if(!M1){for(i=0;i<N1.length;i++){O1=N1[i];B1(O1).handleResize();}}if(this._oOneMonthInterval){this._oOneMonthInterval._setDisplayMode(this._iSize);}if(this.getStickyHeader()){this._updateStickyHeader();}}function r1(M1){var N1=M1.getParameter("appointment"),O1=M1.getParameter("multiSelect"),P1=M1.getParameter("appointments"),Q1=M1.getParameter("domRefId"),R1,S1,T1,U1,V1,i,j;if(!O1){S1=this.getRows();for(i=0;i<S1.length;i++){T1=S1[i];if(M1.oSource!=B1(T1)){U1=T1.getAppointments();for(j=0;j<U1.length;j++){V1=U1[j];V1.setSelected(false);}}}}R1={appointment:N1,appointments:P1,multiSelect:O1,domRefId:Q1};this.fireAppointmentSelect(R1);}d1.prototype._setRowsStartDate=function(j){var M1=this.getRows(),N1,i;for(i=0;i<M1.length;i++){N1=M1[i];B1(N1).setStartDate(j);}};d1.prototype._toggleAppointmentsColumnPopinState=function(i){var j=this.getAggregation("table"),M1=j.getColumns()[1];M1.setDemandPopin(i);M1.setMinScreenWidth(i?g1:"");};d1.prototype._getViews=function(){var i=this.getViews(),j=this.getBuiltInViews(),M1,N1=[],O1=W,P1=$;if(!this._oViews){this._oViews={};}if(j.length){N1=j;}else{N1=i.length?[]:h1;}M1=N1.map(function(R1){switch(R1){case O1.Hour:return this._oViews[O1.Hour]||(this._oViews[O1.Hour]=new A(this.getId()+"-HourView",{key:O1.Hour,intervalType:P1.Hour,description:this._oRB.getText("PLANNINGCALENDAR_HOURS"),intervalsS:6,intervalsM:6,intervalsL:12}));case O1.Day:return this._oViews[O1.Day]||(this._oViews[O1.Day]=new A(this.getId()+"-DayView",{key:O1.Day,intervalType:P1.Day,description:this._oRB.getText("PLANNINGCALENDAR_DAYS"),intervalsS:7,intervalsM:7,intervalsL:14}));case O1.Month:return this._oViews[O1.Month]||(this._oViews[O1.Month]=new A(this.getId()+"-MonthView",{key:O1.Month,intervalType:P1.Month,description:this._oRB.getText("PLANNINGCALENDAR_MONTHS"),intervalsS:3,intervalsM:6,intervalsL:12}));case O1.Week:return this._oViews[O1.Week]||(this._oViews[O1.Week]=new A(this.getId()+"-WeekView",{key:O1.Week,intervalType:P1.Week,description:this._oRB.getText("PLANNINGCALENDAR_WEEK"),intervalsS:7,intervalsM:7,intervalsL:7}));case O1.OneMonth:return this._oViews[O1.OneMonth]||(this._oViews[O1.OneMonth]=new A(this.getId()+"-OneMonthView",{key:O1.OneMonth,intervalType:P1.OneMonth,description:this._oRB.getText("PLANNINGCALENDAR_ONE_MONTH"),intervalsS:1,intervalsM:1,intervalsL:31}));default:L.error("Cannot get PlanningCalendar views. Invalid view key "+R1);break;}},this);for(var Q1 in this._oViews){if(N1.indexOf(Q1)<0){this._oViews[Q1].destroy();delete this._oViews[Q1];}}if(i.length){M1=M1.concat(i);}return M1;};d1.prototype.getSelectedAppointments=function(){var i=[];this.getRows().filter(function(j){i.push.apply(i,B1(j).aSelectedAppointments);});return i;};d1.prototype.setCustomAppointmentsSorterCallback=function(i){if(typeof i==="function"||i===null||i===undefined){this.getRows().forEach(function(j){B1(j)._setCustomAppointmentsSorterCallback(i);});this._fnCustomSortedAppointments=i;}else{L.warning("Your custom sort function won't be used, but the old one will be preserved.",this);}return this;};d1.prototype.getCustomAppointmentsSorterCallback=function(){return this._fnCustomSortedAppointments;};d1.prototype._onRowDeselectAppointment=function(){var M1=this.getRows();for(var i=0;i<M1.length;i++){var N1=B1(M1[i]).aSelectedAppointments;for(var j=0;j<N1.length;j++){var O1=sap.ui.getCore().byId(N1[j]);if(O1){O1.setProperty("selected",false,true);O1.$().removeClass("sapUiCalendarAppSel");}}B1(M1[i]).aSelectedAppointments=[];}};d1.prototype._updateRowTimeline=function(i){var j=B1(i),M1,N1,O1,P1,Q1=this.getViewKey()===W.OneMonth&&this._iSize<2,R1=this.getStartDate();j.setNonWorkingDays(i.getNonWorkingDays());j.setNonWorkingHours(i.getNonWorkingHours());if(Q1&&this._oOneMonthInterval&&this._oOneMonthInterval.getSelectedDates().length){R1=this._oOneMonthInterval.getSelectedDates()[0].getStartDate();}j.setStartDate(R1);j.setShowIntervalHeaders(this.getShowIntervalHeaders());j.setShowEmptyIntervalHeaders(this.getShowEmptyIntervalHeaders());j.setGroupAppointmentsMode(this.getGroupAppointmentsMode());j.setAppointmentsReducedHeight(this.getAppointmentsReducedHeight());j.setLegend(this.getLegend());j.setAppointmentsVisualization(this.getAppointmentsVisualization());j.attachEvent("select",r1,this);j.attachEvent("startDateChange",this._handleStartDateChange,this);j.attachEvent("leaveRow",H1,this);j.attachEvent("intervalSelect",n1,this);I1.call(this);if(L1.call(this)){M1=this.getViewKey();N1=this._getView(M1);O1=N1.getIntervalType();P1=this._getIntervals(N1);j.setIntervalType(O1);j.setIntervals(P1);j.setShowSubIntervals(N1.getShowSubIntervals());}K1.call(this);if(this._fnCustomSortedAppointments){j._setCustomAppointmentsSorterCallback(this._fnCustomSortedAppointments);}};d1.prototype._observeRowChanges=function(i){var j=z1(i),M1=A1(i),N1=B1(i);var O1={destroy:function(){j.destroy();},change:{title:function(P1){M1.setProperty(P1.name,P1.current);},icon:function(P1){M1.setProperty(P1.name,P1.current);},text:function(P1){N1.toggleStyleClass("sapMPlanCalRowLarge",!!P1.current);M1.setProperty("description",P1.current);},enableAppointmentsDragAndDrop:function(P1){this._enableAppointmentsDragAndDrop(i);}.bind(this),enableAppointmentsResize:function(P1){this._enableAppointmentsResize(i);}.bind(this),enableAppointmentsCreate:function(P1){this._enableAppointmentsCreate(i);}.bind(this),nonWorkingDays:function(P1){N1.setProperty(P1.name,P1.current);},nonWorkingHours:function(P1){N1.setProperty(P1.name,P1.current);},selected:function(P1){I1.call(this);j.setProperty(P1.name,P1.current);}.bind(this),tooltip:function(P1){if(P1.mutation==="insert"){M1.setTooltip(P1.child);}else if(P1.mutation==="remove"){M1.setTooltip();}},intervalHeaders:function(P1){N1.invalidate();},appointments:function(P1){N1.invalidate();}}};new a(function(P1){if(P1.type==="destroy"){O1.destroy();}else if(O1.change[P1.name]){O1.change[P1.name](P1);}}).observe(i,{properties:["icon","text","title","nonWorkingDays","nonWorkingHours","selected","enableAppointmentsDragAndDrop","enableAppointmentsResize","enableAppointmentsCreate"],aggregations:["tooltip","appointments","intervalHeaders","headerContent"],destroy:true});i.invalidate=function(P1){if(!P1||!(P1 instanceof d)){E.prototype.invalidate.apply(this,arguments);}else if(j){N1.invalidate(P1);}};i.applyFocusInfo=function(P1){N1.applyFocusInfo(P1);return this;};};d1.prototype._createPlanningCalendarListItem=function(i){var j,M1,N1;if(i.getHeaderContent().length||i.getBindingInfo("headerContent")){M1=i._getPlanningCalendarCustomRowHeader();}else{M1=new s1(i.getId()+"-Head",{icon:i.getIcon(),description:i.getText(),title:i.getTitle(),tooltip:i.getTooltip()});}N1=new u1(i.getId()+"-CalRow",{checkResize:false,updateCurrentTime:false,ariaLabelledBy:M1.getId()});N1.getAppointments=function(){return i.getAppointments();};N1.getIntervalHeaders=function(){return i.getIntervalHeaders();};j=new w1(i.getId()+c1,{cells:[M1,N1]});this._updateRowTimeline(i);this._observeRowChanges(i);this._enableAppointmentsDragAndDrop(i);this._enableAppointmentsResize(i);this._enableAppointmentsCreate(i);return j;};d1.prototype._handleRowRemoval=function(i){var j=B1(i);j.detachEvent("select",r1,this);j.detachEvent("startDateChange",this._handleStartDateChange,this);j.detachEvent("leaveRow",H1,this);j.detachEvent("intervalSelect",n1,this);if(this._fnCustomSortedAppointments){j._fnCustomSortedAppointments=undefined;}z1(i).destroy();};var s1=x.extend("PlanningCalendarRowHeader",{renderer:R.extend(y),TagName:"div"});s1.prototype.isSelectable=function(){return false;};PlanningCalendarRowHeaderRenderer.renderTabIndex=function(i,j){};PlanningCalendarRowHeaderRenderer.getAriaRole=function(i,j){};var t1=R.extend(f);t1.getLegendItems=function(i){var j=[],M1,N1=i.getLegend();if(N1){M1=sap.ui.getCore().byId(N1);if(M1){j=M1.getAppointmentItems?M1.getAppointmentItems():M1.getItems();}else{L.error("PlanningCalendarLegend with id '"+N1+"' does not exist!",i);}}return j;};t1.renderBeforeAppointments=function(j,M1){var N1=y1(M1.getParent()),O1;if(!N1.getEnableAppointmentsDragAndDrop()&&!N1.getEnableAppointmentsResize()&&!N1.getEnableAppointmentsCreate()||M1._isOneMonthIntervalOnSmallSizes()){return;}O1=M1.getAggregation("_intervalPlaceholders");j.write("<div class=\"sapUiCalendarRowAppsOverlay\">");if(O1){for(var i=0;i<O1.length;i++){var P1=O1[i];P1.setWidth(100/O1.length+"%");j.renderControl(P1);}}j.write("</div>");};t1.renderResizeHandle=function(i,j,M1){if(!y1(j.getParent()).getEnableAppointmentsResize()||j._isOneMonthIntervalOnSmallSizes()||(M1._aAppointments&&M1._aAppointments.length>0)){return;}i.write("<span");i.addClass("sapUiCalendarAppResizeHandle");i.writeClasses();i.write(">");i.write("</span>");};t1.writeCustomAttributes=function(i,j){if(y1(j.getParent()).getEnableAppointmentsCreate()){i.writeAttribute("draggable","true");}};t1.renderInterval=function(j,M1,N1,O1,P1,Q1,R1,S1,T1,U1,V1,W1,X1){var Y1=M1.getIntervalType();if(Y1===$.Day||Y1===$.Week||Y1===$.OneMonth){var Z1=y1(M1.getParent()),$1=Z1.getParent(),_1=function(j2){return j2.getType()===K.NonWorking;},a2=Z1.getSpecialDates().filter(_1),b2=$1.getSpecialDates().filter(_1),c2=M1.getStartDate(),d2,e2,f2,g2;if(b2&&a2){d2=b2.concat(a2);}else if(a2){d2=a2;}if(d2&&d2.length){var h2=function(j2){return j2===e2.getDay();};e2=new Date(c2.getTime());e2.setHours(0,0,0);e2.setDate(c2.getDate()+N1);for(var i=0;i<d2.length;i++){if(d2[i].getStartDate()){f2=new Date(d2[i].getStartDate().getTime());}if(d2[i].getEndDate()){g2=new Date(d2[i].getEndDate().getTime());}else{g2=new Date(d2[i].getStartDate().getTime());g2.setHours(23,59,59);}if(e2.getTime()>=f2.getTime()&&e2.getTime()<=g2.getTime()){var i2=Q1.some(h2);if(!i2){j.addClass("sapUiCalendarRowAppsNoWork");}}}}}f.renderInterval(j,M1,N1,O1,P1,Q1,R1,S1,T1,U1,V1,W1,X1);};var u1=e.extend("PlanningCalendarRowTimeline",{metadata:{aggregations:{intervalHeaders:{type:"sap.ui.unified.CalendarAppointment",multiple:true},_intervalPlaceholders:{type:"IntervalPlaceholder",multiple:true,visibility:"hidden",dnd:{droppable:true}}},dnd:true},renderer:t1});u1.prototype._updatePlaceholders=function(){var j=this.getProperty("intervals");if(this.getIntervalType()===$.Hour){j*=2;}this.removeAllAggregation("_intervalPlaceholders");for(var i=0;i<j;i++){this.addAggregation("_intervalPlaceholders",new v1());}};u1.prototype.onBeforeRendering=function(){e.prototype.onBeforeRendering.call(this);this._updatePlaceholders();};u1.prototype.onmousedown=function(i){var j=i.target.classList;this._isResizeHandleMouseDownTarget=j.contains("sapUiCalendarAppResizeHandle");this._isRowAppsIntervalMouseDownTarget=j.contains("sapUiCalendarRowAppsInt");};u1.prototype._isResizingPerformed=function(){return this._isResizeHandleMouseDownTarget;};u1.prototype._isDraggingPerformed=function(){return!this._isResizeHandleMouseDownTarget&&!this._isRowAppsIntervalMouseDownTarget;};u1.prototype._isCreatingPerformed=function(){return this._isRowAppsIntervalMouseDownTarget;};var v1=C.extend("IntervalPlaceholder",{metadata:{properties:{width:{type:"sap.ui.core.CSSSize",group:"Appearance",defaultValue:null}}},renderer:function(i,j){i.write("<div");i.writeControlData(j);i.addStyle("width",j.getWidth());i.writeStyles();i.addClass("sapUiCalendarRowAppsPlaceholder");i.writeClasses();i.write("></div>");}});var w1=v.extend("sap.m.internal.PlanningCalendarRowListItem",{metadata:{library:"sap.m"},renderer:w});w1.prototype.getHeader=function(){return this.getCells()[0];};w1.prototype.getTimeline=function(){return this.getCells()[1];};w1.prototype.getCustomData=function(){return y1(this).getCustomData();};d1.prototype._getSelectedDates=function(){var i=this.getViewKey(),j=this._getView(i),M1=j.getIntervalType(),N1=f1[M1];return this[N1.sInstanceName].getSelectedDates();};d1.prototype._enableAppointmentsDragAndDrop=function(i){var j=B1(i),M1;if(i.getEnableAppointmentsDragAndDrop()){M1=i.getDragDropConfig().some(function(N1){return N1.getGroupName()===_;});if(!M1){this._addDragDropInfo(i,B1(i));}}else{i.getDragDropConfig().forEach(function(N1){if(N1.getGroupName()===_){i.removeDragDropConfig(N1);}});j.getDragDropConfig().forEach(function(N1){if(N1.getGroupName()===_){j.removeDragDropConfig(N1);}});}};d1.prototype._enableAppointmentsResize=function(i){var j=i.getEnableAppointmentsResize(),M1=this._getConfigFromDragDropConfigAggregation(i.getAggregation("dragDropConfig"),a1),N1=this._getResizeConfig(i);if(j&&!M1){i.addAggregation("dragDropConfig",N1,true);}if(!j){i.removeAggregation("dragDropConfig",M1,true);}};d1.prototype._enableAppointmentsCreate=function(i){var j=i.getEnableAppointmentsCreate(),M1=B1(i),N1=this._getConfigFromDragDropConfigAggregation(M1.getAggregation("dragDropConfig"),b1),O1=this._getAppointmentsCreateConfig(i);if(j&&!N1){M1.addAggregation("dragDropConfig",O1,true);}if(!j){M1.removeAggregation("dragDropConfig",N1,true);}};d1.prototype._addDragDropInfo=function(i,j){i.addDragDropConfig(new p({groupName:_,sourceAggregation:"appointments",dragStart:function(M1){var N1=function(){var O1=Q(".sapUiCalendarRowAppsOverlay");setTimeout(function(){O1.addClass("sapUiCalendarRowAppsOverlayDragging");},0);Q(document).one("dragend",function(){O1.removeClass("sapUiCalendarRowAppsOverlayDragging");});};if(j._isOneMonthIntervalOnSmallSizes()||!j._isDraggingPerformed()){M1.preventDefault();return;}N1();}}));j.addDragDropConfig(new q({groupName:_,targetAggregation:"_intervalPlaceholders",dragEnter:function(M1){var N1=M1.getParameter("dragSession"),O1=N1.getDragControl(),P1=j.getIntervalType(),Q1=j.getStartDate(),R1=j.indexOfAggregation("_intervalPlaceholders",N1.getDropControl()),S1=j.getId(),T1,U1=function(){var W1=Q(N1.getIndicator()),X1=N1.getDropControl().getDomRef().getBoundingClientRect(),Y1=sap.ui.getCore().byId(S1).getDomRef().getBoundingClientRect(),Z1=N1.getDragControl().$().outerWidth(),$1=sap.ui.getCore().getConfiguration().getRTL(),_1=$1?Math.ceil(X1.right)-Y1.left:Y1.right-Math.ceil(X1.left);W1.css("min-width",(Z1<_1)?Z1:_1).css($1?"border-left-width":"border-right-width",(Z1>_1)?"0":"").css("margin-left",$1?-(W1.outerWidth()-parseFloat(W1.context.style.width)):"");};if(i.hasListeners("appointmentDragEnter")){if(P1===$.Hour){T1=this._calcNewHoursAppPos(Q1,O1.getStartDate(),O1.getEndDate(),R1);}else if(P1===$.Day||P1===$.Week||(P1===$.OneMonth&&!j._isOneMonthIntervalOnSmallSizes())){T1=this._calcNewDaysAppPos(Q1,O1.getStartDate(),O1.getEndDate(),R1);}else if(P1===$.Month){T1=this._calcNewMonthsAppPos(Q1,O1.getStartDate(),O1.getEndDate(),R1);}var V1=i.fireAppointmentDragEnter({appointment:O1,startDate:T1.startDate,endDate:T1.endDate,calendarRow:y1(j.getParent())});if(!V1){M1.preventDefault();return;}}else if(B1(O1.getParent())!==j){M1.preventDefault();return;}if(j.getIntervalType()!==$.Hour){return;}if(!N1.getIndicator()){setTimeout(U1,0);}else{U1();}}.bind(this),drop:function(M1){var N1=M1.getParameter("dragSession"),O1=N1.getDragControl(),P1=j.getIntervalType(),Q1=j.getStartDate(),R1=j.indexOfAggregation("_intervalPlaceholders",N1.getDropControl()),S1,T1=M1.getParameter("browserEvent"),U1=(T1.metaKey||T1.ctrlKey);if(P1===$.Hour){S1=this._calcNewHoursAppPos(Q1,O1.getStartDate(),O1.getEndDate(),R1);}else if(P1===$.Day||P1===$.Week||(P1===$.OneMonth&&!j._isOneMonthIntervalOnSmallSizes())){S1=this._calcNewDaysAppPos(Q1,O1.getStartDate(),O1.getEndDate(),R1);}else if(P1===$.Month){S1=this._calcNewMonthsAppPos(Q1,O1.getStartDate(),O1.getEndDate(),R1);}j.$().find(".sapUiCalendarRowAppsOverlay").removeClass("sapUiCalendarRowAppsOverlayDragging");if(O1.getStartDate().getTime()===S1.startDate.getTime()&&O1.getParent()===y1(j.getParent())){return;}i.fireAppointmentDrop({appointment:O1,startDate:S1.startDate,endDate:S1.endDate,calendarRow:y1(j.getParent()),copy:U1});}.bind(this)}));};d1.prototype._calcNewHoursAppPos=function(i,j,M1,N1){var O1=new Date(i.getFullYear(),i.getMonth(),i.getDate(),i.getHours());O1=new Date(O1.getTime()+(N1*30*60*1000));return{startDate:O1,endDate:new Date(O1.getTime()+M1.getTime()-j.getTime())};};d1.prototype._calcNewDaysAppPos=function(i,j,M1,N1){var O1=new Date(i);O1.setDate(O1.getDate()+N1);O1=new Date(O1.getFullYear(),O1.getMonth(),O1.getDate(),j.getHours(),j.getMinutes(),j.getSeconds());return{startDate:O1,endDate:new Date(O1.getTime()+M1.getTime()-j.getTime())};};d1.prototype._calcNewMonthsAppPos=function(i,j,M1,N1){var O1=new Date(i);O1.setMonth(O1.getMonth()+N1);O1=new Date(O1.getFullYear(),O1.getMonth(),j.getDate(),j.getHours(),j.getMinutes(),j.getSeconds());return{startDate:O1,endDate:new Date(O1.getTime()+M1.getTime()-j.getTime())};};d1.prototype._getResizeConfig=function(i){var j=B1(i),M1=new r({sourceAggregation:"appointments",targetAggregation:"_intervalPlaceholders",targetElement:B1(i),dragStart:function(N1){if(!i.getEnableAppointmentsResize()||j._isOneMonthIntervalOnSmallSizes()||!j._isResizingPerformed()){N1.preventDefault();return;}var O1=N1.getParameter("dragSession"),P1=j.$().find(".sapUiCalendarRowAppsOverlay"),Q1=Q(O1.getIndicator()),R1=O1.getDragControl().$();Q1.addClass("sapUiDnDIndicatorHide");setTimeout(function(){P1.addClass("sapUiCalendarRowAppsOverlayDragging");},0);Q(document).one("dragend",function(){P1.removeClass("sapUiCalendarRowAppsOverlayDragging");Q1.removeClass("sapUiDnDIndicatorHide");R1.css({width:"auto","min-width":"auto","z-index":"auto",opacity:1});});if(!n.browser.msie&&!n.browser.edge){N1.getParameter("browserEvent").dataTransfer.setDragImage(x1(),0,0);}},dragEnter:function(N1){var O1=N1.getParameter("dragSession"),P1=this.getTargetElement(),Q1=function(){var U1=Q(O1.getIndicator());U1.addClass("sapUiDnDIndicatorHide");},R1=O1.getDropControl().getDomRef().getBoundingClientRect(),S1=sap.ui.getCore().byId(P1).getDomRef().getBoundingClientRect(),T1={width:R1.left+R1.width-(O1.getDragControl().$().position().left+S1.left),"min-width":Math.min(O1.getDragControl().$().outerWidth(),O1.getDropControl().$().outerWidth()),"z-index":1,opacity:0.8};O1.getDragControl().$().css(T1);if(!O1.getIndicator()){setTimeout(Q1,0);}else{Q1();}},drop:function(N1){var j=B1(i),O1=N1.getParameter("dragSession"),P1=O1.getDragControl(),Q1=j.getIntervalType(),R1=j.getStartDate(),S1=j.indexOfAggregation("_intervalPlaceholders",O1.getDropControl()),T1;if(Q1===$.Hour){T1=this._calcResizeNewHoursAppPos(R1,P1.getStartDate(),P1.getEndDate(),S1);}else if(Q1===$.Day||Q1===$.Week||(Q1===$.OneMonth&&!j._isOneMonthIntervalOnSmallSizes())){T1=this._calcResizeNewDaysAppPos(R1,P1.getStartDate(),P1.getEndDate(),S1);}else if(Q1===$.Month){T1=this._calcResizeNewMonthsAppPos(R1,P1.getStartDate(),P1.getEndDate(),S1);}j.$().find(".sapUiCalendarRowAppsOverlay").removeClass("sapUiCalendarRowAppsOverlayDragging");Q(O1.getIndicator()).removeClass("sapUiDnDIndicatorHide");P1.$().css({width:"auto","min-width":"auto","z-index":"auto",opacity:1});if(P1.getEndDate().getTime()===T1.endDate.getTime()){return;}i.fireAppointmentResize({appointment:P1,startDate:T1.startDate,endDate:T1.endDate,calendarRow:i});}.bind(this)});M1.setProperty("groupName",a1);return M1;};d1.prototype._calcResizeNewHoursAppPos=function(i,j,M1,N1){var O1=new Date(i.getFullYear(),i.getMonth(),i.getDate(),i.getHours()),P1=30*60*1000;O1=new Date(O1.getTime()+((N1+1)*P1));if(O1.getTime()<=j.getTime()){O1=new Date(j.getTime()+P1);}return{startDate:j,endDate:O1};};d1.prototype._calcResizeNewDaysAppPos=function(i,j,M1,N1){var O1=new Date(i),P1=O1.getDate()+N1+1,Q1=new Date(O1.getFullYear(),O1.getMonth(),O1.getDate());Q1.setDate(P1);if(Q1.getTime()<=j.getTime()){P1=j.getDate()+1;}O1.setDate(P1);O1=new Date(O1.getFullYear(),O1.getMonth(),O1.getDate());return{startDate:j,endDate:O1};};d1.prototype._calcResizeNewMonthsAppPos=function(i,j,M1,N1){var O1=new Date(i),P1=O1.getMonth()+N1+1;if(P1<=j.getMonth()){P1=j.getMonth()+1;}O1.setMonth(P1);O1=new Date(O1.getFullYear(),O1.getMonth(),1);return{startDate:j,endDate:O1};};d1.prototype._calcCreateNewAppHours=function(i,j,M1){var N1=30*60*1000,O1,P1;if(j<=M1){O1=new Date(i.getTime()+(j*N1));P1=new Date(i.getTime()+((M1+1)*N1));}else{O1=new Date(i.getTime()+(M1*N1));P1=new Date(i.getTime()+(j*N1));}return{startDate:O1,endDate:P1};};d1.prototype._calcCreateNewAppDays=function(i,j,M1){var N1=new Date(i),O1=new Date(i);if(j<=M1){N1=new Date(i.getFullYear(),i.getMonth(),i.getDate()+j);O1=new Date(i.getFullYear(),i.getMonth(),i.getDate()+M1+1);}else{N1=new Date(i.getFullYear(),i.getMonth(),i.getDate()+M1);O1=new Date(i.getFullYear(),i.getMonth(),i.getDate()+j);}return{startDate:N1,endDate:O1};};d1.prototype._calcCreateNewAppMonths=function(i,j,M1){var N1=new Date(i),O1=new Date(i);if(j<=M1){N1=new Date(i.getFullYear(),i.getMonth()+j,1);O1=new Date(i.getFullYear(),i.getMonth()+M1+1,1);}else{N1=new Date(i.getFullYear(),i.getMonth()+M1,1);O1=new Date(i.getFullYear(),i.getMonth()+j,1);}return{startDate:N1,endDate:O1};};d1.prototype._getConfigFromDragDropConfigAggregation=function(j,M1){var N1=j,O1=N1&&N1.length;for(var i=0;i<O1;i++){if(N1[i].getGroupName()===M1){return N1[i];}}return null;};d1.prototype._getAppointmentsCreateConfig=function(i){var j=B1(i),M1=new r({targetAggregation:"_intervalPlaceholders",dragStart:function(N1){if(!i.getEnableAppointmentsCreate()||j._isOneMonthIntervalOnSmallSizes()||!j._isCreatingPerformed()){N1.preventDefault();return;}var O1=N1.getParameter("dragSession"),P1=j.$().find(".sapUiCalendarRowAppsOverlay"),Q1=Q(O1.getIndicator());setTimeout(function(){P1.addClass("sapUiCalendarRowAppsOverlayDragging");},0);Q(document).one("dragend",function(){P1.removeClass("sapUiCalendarRowAppsOverlayDragging");Q1.html("");Q1.removeClass("sapUiCalendarApp sapUiCalendarAppType01 sapUiAppCreate");});if(!n.browser.msie&&!n.browser.edge){N1.getParameter("browserEvent").dataTransfer.setDragImage(x1(),0,0);}},dragEnter:function(N1){var O1=N1.getParameter("dragSession"),P1=O1.getDropControl().getDomRef().getBoundingClientRect(),Q1=function(){var S1=Q(O1.getIndicator());S1.addClass("sapUiCalendarApp sapUiCalendarAppType01 sapUiAppCreate");};var R1=O1.getData("text")?parseFloat(O1.getData("text").split("|")[0]):0;if(R1){if(R1<=P1.left){O1.setIndicatorConfig({left:R1,width:Math.max((P1.left+P1.width-R1),P1.width)});}else{O1.setIndicatorConfig({left:P1.left,width:R1-P1.left});}}else{O1.setData("text",P1.left+"|"+j.indexOfAggregation("_intervalPlaceholders",O1.getDropControl()));}if(!O1.getIndicator()){setTimeout(Q1,0);}else{Q1();}},drop:function(N1){var O1=N1.getParameter("dragSession"),P1=Q(O1.getIndicator()),Q1=j.getIntervalType(),R1=B1(i).getStartDate(),S1=parseInt(O1.getData("text").split("|")[1]),T1=j.indexOfAggregation("_intervalPlaceholders",O1.getDropControl()),U1;if(Q1===$.Hour){U1=this._calcCreateNewAppHours(R1,S1,T1);}else if(Q1===$.Day||Q1===$.Week||(Q1===$.OneMonth&&!j._isOneMonthIntervalOnSmallSizes())){U1=this._calcCreateNewAppDays(R1,S1,T1);}else if(Q1===$.Month){U1=this._calcCreateNewAppMonths(R1,S1,T1);}i.fireAppointmentCreate({startDate:U1.startDate,endDate:U1.endDate,calendarRow:i});P1.html("");P1.removeClass("sapUiCalendarApp sapUiCalendarAppType01 sapUiAppCreate");}.bind(this)});M1.setProperty("groupName",b1);return M1;};function x1(){var i=Q("<span></span>").addClass("sapUiCalAppResizeGhost");i.appendTo(document.body);setTimeout(function(){i.remove();},0);return i.get(0);}function y1(i){var j=i.getId();return sap.ui.getCore().byId(j.substring(0,j.indexOf(c1)));}function z1(i){return sap.ui.getCore().byId(i.getId()+c1);}function A1(i){var j=z1(i);return j?j.getHeader():null;}function B1(i){var j=z1(i);return j?j.getTimeline():null;}function C1(j){var M1=[];var N1=this.getRows();for(var i=0;i<N1.length;i++){var O1=N1[i];var P1=z1(O1);var Q1=P1.getSelected();if(O1.getSelected()!=Q1){O1.setProperty("selected",Q1,true);M1.push(O1);}}if(!this.getSingleSelection()){I1.call(this);}if(M1.length>0){this.fireRowSelectionChange({rows:M1});}}function D1(i){if(i<this._iBreakPointTablet){this._iSize=0;}else if(i<this._iBreakPointDesktop){this._iSize=1;}else{this._iSize=2;}if(i<i1.PHONE){this._iSizeScreen=0;}else if(i<i1.TABLET){this._iSizeScreen=1;}else{this._iSizeScreen=2;}}function E1(j){var M1='sapMSize'+j,N1=this.$(),i,O1;if(N1){for(i=0;i<3;i++){O1='sapMSize'+i;if(O1===M1){N1.addClass(O1);}else{N1.removeClass(O1);}}}}function F1(){var j=this._getViews();this._oIntervalTypeSelect.destroyItems();var i;var M1;for(i=0;i<j.length;i++){var N1=j[i];M1=new I(this.getId()+"-"+i,{key:N1.getKey(),text:N1.getDescription(),tooltip:N1.getTooltip()});this._oIntervalTypeSelect.addItem(M1);}this._oIntervalTypeSelect.setVisible(!(j.length===1));}function G1(i){var j=i.getParameter("selected");var M1=this.getRows();if(j){M1=this.getRows().filter(function(N1){return!N1.getSelected();});}this.selectAllRows(j);this.fireRowSelectionChange({rows:M1});}function H1(j){var M1=j.oSource;var N1=j.getParameter("type");var O1=this.getRows();var P1;var Q1;var R1;var S1;var i=0;var T1=0;var U1;for(i=0;i<O1.length;i++){P1=O1[i];if(B1(P1)==M1){T1=i;break;}}switch(N1){case"sapup":R1=M1.getFocusedAppointment();S1=R1.getStartDate();if(T1>0){T1--;}Q1=O1[T1];B1(Q1).focusNearestAppointment(S1);break;case"sapdown":R1=M1.getFocusedAppointment();S1=R1.getStartDate();if(T1<O1.length-1){T1++;}Q1=O1[T1];B1(Q1).focusNearestAppointment(S1);break;case"saphome":if(T1>0){Q1=O1[0];U1=new Q.Event(N1);U1._bPlanningCalendar=true;B1(Q1).onsaphome(U1);}break;case"sapend":if(T1<O1.length-1){Q1=O1[O1.length-1];U1=new Q.Event(N1);U1._bPlanningCalendar=true;B1(Q1).onsapend(U1);}break;default:break;}}function I1(){if(this._oSelectAllCheckBox){var i=this.getRows();var j=this.getSelectedRows();if(i.length==j.length&&j.length>0){this._oSelectAllCheckBox.setSelected(true);}else{this._oSelectAllCheckBox.setSelected(false);}}}function J1(){if(this.getSingleSelection()){if(this._oCalendarHeader.getAllCheckBox()){this._oCalendarHeader.setAllCheckBox();}else if(this._oInfoToolbar.getContent().length>2){this._oInfoToolbar.removeContent(this._oSelectAllCheckBox);}}else{if(!this._oSelectAllCheckBox){this._oSelectAllCheckBox=new F(this.getId()+"-All",{text:this._oRB.getText("COLUMNSPANEL_SELECT_ALL")});this._oSelectAllCheckBox.attachEvent("select",G1,this);}if(this._iSizeScreen<2||!this.getShowRowHeaders()){var i=this._oInfoToolbar.indexOfContent(this._oSelectAllCheckBox);if(this._iSizeScreen<2){if(i<this._oInfoToolbar.getContent().length-1){this._oInfoToolbar.addContent(this._oSelectAllCheckBox);}}else if(i<0||i>1){if(i>1){this._oInfoToolbar.removeContent(this._oSelectAllCheckBox);}this._oInfoToolbar.insertContent(this._oSelectAllCheckBox,1);}}else{this._oCalendarHeader.setAllCheckBox(this._oSelectAllCheckBox);}}}function K1(){var i=this.getAggregation("table");var j=i.getMode();var M1;if(this.getSingleSelection()){if(!this.getShowRowHeaders()&&this.getRows().length==1){M1=N.None;}else{M1=N.SingleSelectMaster;}}else{M1=N.MultiSelect;}if(j!=M1){i.setMode(M1);}}function L1(){return this._oTimeInterval||this._oDateInterval||this._oMonthInterval||this._oWeekInterval||this._oOneMonthInterval;}return d1;});
