/*!
 * OpenUI5
 * (c) Copyright 2009-2019 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["./library","sap/ui/core/Control","sap/ui/core/Core","sap/ui/core/delegate/ScrollEnablement","./WizardProgressNavigator","sap/ui/Device","./WizardRenderer","sap/ui/dom/containsOrEquals","sap/base/Log","sap/ui/thirdparty/jquery","sap/ui/dom/jquery/Focusable"],function(l,C,a,S,W,D,b,c,L,q){"use strict";var d=C.extend("sap.m.Wizard",{metadata:{library:"sap.m",designtime:"sap/m/designtime/Wizard.designtime",properties:{width:{type:"sap.ui.core.CSSSize",group:"Appearance",defaultValue:"auto"},height:{type:"sap.ui.core.CSSSize",group:"Appearance",defaultValue:"100%"},showNextButton:{type:"boolean",group:"Behavior",defaultValue:true},finishButtonText:{type:"string",group:"Appearance",defaultValue:"Review"},enableBranching:{type:"boolean",group:"Behavior",defaultValue:false}},defaultAggregation:"steps",aggregations:{steps:{type:"sap.m.WizardStep",multiple:true,singularName:"step"},_progressNavigator:{type:"sap.ui.core.Control",multiple:false,visibility:"hidden"},_nextButton:{type:"sap.m.Button",multiple:false,visibility:"hidden"}},associations:{
/**
					 * This association controls the current activated step of the wizard (meaning the last step)
					 * For example if we have A->B->C->D steps, we are on step A and we setCurrentStep(C) A,B and C are going to be activated. D will still remain unvisited.
					 * The parameter needs to be a Wizard step that is part of the current Wizard
					 * @since 1.50
					 */
currentStep:{type:"sap.m.WizardStep",multiple:false}},events:{stepActivate:{parameters:{index:{type:"int"}}},complete:{parameters:{}}},dnd:{draggable:false,droppable:true}}});d.CONSTANTS={MINIMUM_STEPS:3,MAXIMUM_STEPS:8,ANIMATION_TIME:300,SCROLL_OFFSET:16};d.prototype.init=function(){this._stepCount=0;this._stepPath=[];this._scrollLocked=false;this._scroller=this._initScrollEnablement();this._resourceBundle=a.getLibraryResourceBundle("sap.m");this._initProgressNavigator();};d.prototype.onBeforeRendering=function(){var s=this._getStartingStep();if(!this._isMinStepCountReached()||this._isMaxStepCountExceeded()){L.error("The Wizard is supposed to handle from 3 to 8 steps.");}this._saveInitialValidatedState();if(s&&this._stepPath.indexOf(s)<0){this._activateStep(s);s._setNumberInvisibleText(1);}};d.prototype.onAfterRendering=function(){if(!this.getCurrentStep()){this.setAssociation("currentStep",this._getStartingStep(),true);}var s=this._getCurrentStepInstance();this._activateAllPreceedingSteps(s);this._attachScrollHandler();};d.prototype.exit=function(){var e=this.getDomRef("step-container");if(e){e.onscroll=null;}this._scroller.destroy();this._scroller=null;this._stepPath=null;this._stepCount=null;this._scrollLocked=null;this._resourceBundle=null;};d.prototype.validateStep=function(s){if(!this._containsStep(s)){L.error("The wizard does not contain this step");return this;}s.setValidated(true);return this;};d.prototype.invalidateStep=function(s){if(!this._containsStep(s)){L.error("The wizard does not contain this step");return this;}s.setValidated(false);return this;};d.prototype.nextStep=function(){var e=this._getProgressNavigator().getProgress()-1;var f=this._stepPath[e];this.validateStep(f);f._complete();return this;};d.prototype.previousStep=function(){var p=this._getProgressNavigator().getProgress()-2;if(p>=0){this.discardProgress(this._stepPath[p]);}return this;};d.prototype.getProgress=function(){return this._getProgressNavigator().getProgress();};d.prototype.getProgressStep=function(){return this._stepPath[this.getProgress()-1];};d.prototype.goToStep=function(s,f){if(!this.getVisible()||this._stepPath.indexOf(s)<0){return this;}s._setNumberInvisibleText(this.getProgress());var t=this,m={scrollTop:this._getStepScrollOffset(s)},A={queue:false,duration:d.CONSTANTS.ANIMATION_TIME,start:function(){t._scrollLocked=true;},complete:function(){t._scrollLocked=false;var p=t._getProgressNavigator();if(!p){return;}p._updateCurrentStep(t._stepPath.indexOf(s)+1);if(f||f===undefined){t._focusFirstStepElement(s);}}};q(this.getDomRef("step-container")).animate(m,A);return this;};d.prototype.discardProgress=function(s,p){var e=this.getProgress(),f=this._stepPath,g=this._stepPath.indexOf(s),h=this._stepPath[g],j=g+1;if(j>e||j<=0){L.warning("The given step is either not yet reached, or is not present in the wizard control.");return this;}this._getProgressNavigator().discardProgress(j,true);this._updateProgressNavigator();this._restoreInitialValidatedState(j);for(var i=j;i<f.length;i++){f[i]._deactivate();if(f[i].getSubsequentSteps().length>1){f[i].setNextStep(null);}}this.setAssociation("currentStep",s);h.setWizardContext({sButtonText:this._getNextButtonText(),bLast:true});if(s.getSubsequentSteps().length>1&&!p){s.setNextStep(null);}f.splice(j);return this;};d.prototype.setCurrentStep=function(s){var e=(typeof s==="string")?a.byId(s):s;if(!this.getEnableBranching()){this.setAssociation("currentStep",s,true);}if(e&&this._isStepReachable(e)){this._activateAllPreceedingSteps(e);}else{L.error("The given step could not be set as current step.");}return this;};d.prototype.setShowNextButton=function(v){this.setProperty("showNextButton",v,true);this.getSteps().forEach(function(s){s.setWizardContext({bParentAllowsButtonShow:v});});return this;};d.prototype.setFinishButtonText=function(v){this.setProperty("finishButtonText",v,true);return this;};d.prototype.getFinishButtonText=function(){if(this.getProperty("finishButtonText")==="Review"){return this._resourceBundle.getText("WIZARD_FINISH");}else{return this.getProperty("finishButtonText");}};d.prototype.addStep=function(w){if(this._isMaxStepCountExceeded()){L.error("The Wizard is supposed to handle up to 8 steps.");return this;}w.setWizardContext({bParentAllowsButtonShow:this.getShowNextButton()});w.attachComplete(this._handleNextButtonPress.bind(this));this._incrementStepCount();return this.addAggregation("steps",w);};d.prototype.insertStep=function(w,i){throw new Error("Dynamic step insertion is not yet supported.");};d.prototype.removeStep=function(w){throw new Error("Dynamic step removal is not yet supported.");};d.prototype.removeAllSteps=function(){this._resetStepCount();return this.removeAllAggregation("steps");};d.prototype.destroySteps=function(){this._resetStepCount();return this.destroyAggregation("steps");};d.prototype._activateAllPreceedingSteps=function(s){if(this._stepPath.indexOf(s)>=0){this.discardProgress(s,true);return;}while(this.getProgressStep()!==s){this.nextStep();}};d.prototype._isNextStepDetermined=function(s,p){if(!this.getEnableBranching()){return true;}s=s||this._getCurrentStepInstance();return this._getNextStep(s,p)!==null;};d.prototype._isStepReachable=function(s){if(this.getEnableBranching()){var e=this._getStartingStep();while(e!==s){e=e._getNextStepReference();if(e==null){return false;}}this.setAssociation("currentStep",s);return true;}else{return this.getSteps().indexOf(s)>=0;}};d.prototype._initScrollEnablement=function(){return new S(this,null,{scrollContainerId:this.getId()+"-step-container",horizontal:false,vertical:true});};d.prototype._initProgressNavigator=function(){var t=this,p=new W(this.getId()+"-progressNavigator",{stepChanged:this._handleStepChanged.bind(this)});p._setOnEnter(function(e,s){var f=t._stepPath[s];setTimeout(function(){this._focusFirstStepElement(f);}.bind(t),d.CONSTANTS.ANIMATION_TIME);});this.setAggregation("_progressNavigator",p);};d.prototype._handleNextButtonPress=function(){var p=this._getProgressNavigator(),e=p.getProgress(),s=this.isStepFinal();if(s){this.fireComplete();}else{var f=this.getProgressStep();if(!this._isNextStepDetermined(f,e)){throw new Error("The wizard is in branching mode, and the nextStep association is not set.");}p.incrementProgress();this._handleStepActivated(p.getProgress());this._handleStepChanged(p.getProgress());}};d.prototype._getStepScrollOffset=function(s){var i=this._scroller.getScrollTop(),p=this._getCurrentStepInstance(),n=this._getNextButton(),A=0,e=0;if(s&&s.$()&&s.$().position()){e=s.$().position().top||0;}if(!D.system.phone&&p&&n&&!c(p.getDomRef(),n.getDomRef())){A=n.$().outerHeight();}return(i+e)-(d.CONSTANTS.SCROLL_OFFSET+A);};d.prototype._focusFirstStepElement=function(s){var $=s.$();if($&&$.firstFocusableDomRef()){$.firstFocusableDomRef().focus();}};d.prototype._handleStepChanged=function(e){var p=((typeof e==="number")?e:e.getParameter("current"))-2,f=this._stepPath[p],s=this._getNextStep(f,p),g=D.system.desktop?true:false;this.goToStep(s,g);};d.prototype._handleStepActivated=function(i){var p=i-2,e=this._stepPath[p],n=this._getNextStep(e,p);this._activateStep(n);this._updateProgressNavigator();this.fireStepActivate({index:i});this.setAssociation("currentStep",this.getProgressStep(),true);this.getProgressStep().setWizardContext({bLast:true,bReviewStep:this.isStepFinal(),sButtonText:this._getNextButtonText()});};d.prototype._isMaxStepCountExceeded=function(){var s=this._getStepCount();if(this.getEnableBranching()){return false;}return s>=d.CONSTANTS.MAXIMUM_STEPS;};d.prototype._isMinStepCountReached=function(){var s=this._getStepCount();return s>=d.CONSTANTS.MINIMUM_STEPS;};d.prototype._getStepCount=function(){return this._stepCount;};d.prototype._incrementStepCount=function(){this._stepCount+=1;this._getProgressNavigator().setStepCount(this._getStepCount());};d.prototype._decrementStepCount=function(){this._stepCount-=1;this._getProgressNavigator().setStepCount(this._getStepCount());};d.prototype._resetStepCount=function(){this._stepCount=0;this._getProgressNavigator().setStepCount(this._getStepCount());};d.prototype._getProgressNavigator=function(){return this.getAggregation("_progressNavigator");};d.prototype._saveInitialValidatedState=function(){if(this._initialValidatedState){return;}this._initialValidatedState=this.getSteps().map(function(s){return s.getValidated();});};d.prototype._restoreInitialValidatedState=function(e){var s=this._stepPath,f=this.getSteps();for(var i=e;i<s.length;i++){var g=s[i],h=f.indexOf(g),j=this._initialValidatedState[h];g.setValidated(j);}};d.prototype._getNextStep=function(s,p){if(!this.getEnableBranching()){return this.getSteps()[p+1];}if(p<0){return this._getStartingStep();}var n=s._getNextStepReference();if(n===null){throw new Error("The wizard is in branching mode, and no next step is defined for "+"the current step, please set one.");}if(!this._containsStep(n)){throw new Error("The next step that you have defined is not part of the wizard steps aggregation."+"Please add it to the wizard control.");}var e=s.getSubsequentSteps();if(e.length>0&&!s._containsSubsequentStep(n.getId())){throw new Error("The next step that you have defined is not contained inside the subsequentSteps"+" association of the current step.");}return n;};d.prototype.isStepFinal=function(){var s,i=this._getStepCount(),p=this.getProgress();if(this.getEnableBranching()){s=this._stepPath[this._stepPath.length-1]._isLeaf();}else{s=p===i;}return s;};d.prototype._getNextButtonText=function(){if(this.isStepFinal()){return this.getFinishButtonText();}else{return this._resourceBundle.getText("WIZARD_STEP")+" "+(this.getProgress()+1);}};d.prototype._getNextButton=function(){var s=this._getCurrentStepInstance();if(s){return s.getAggregation("_nextButton");}else{return null;}};d.prototype._updateProgressNavigator=function(){var p=this._getProgressNavigator(),e=this._getStartingStep(),f=this.getSteps(),s=[e.getTitle()],g=[e.getIcon()],h=[e.getOptional()],i=1;if(this.getEnableBranching()){while(!e._isLeaf()&&e._getNextStepReference()!==null){i++;e=e._getNextStepReference();s.push(e.getTitle());h.push(e.getOptional());g.push(e.getIcon());}p.setVaryingStepCount(e._isBranched());p.setStepCount(i);}else{s=f.map(function(j){return j.getTitle();});h=f.map(function(j){return j.getOptional();});g=f.map(function(j){return j.getIcon();});}p.setStepTitles(s);p._stepOptionalIndication=h;p.setStepIcons(g);};d.prototype._getStartingStep=function(){return this.getSteps()[0];};d.prototype._attachScrollHandler=function(){var e=this.getDomRef("step-container");e.onscroll=this._scrollHandler.bind(this);};d.prototype._scrollHandler=function(e){if(this._scrollLocked){return;}var s=e.target.scrollTop,p=this._getProgressNavigator(),f=this._stepPath[p.getCurrentStep()-1].getDomRef();if(!f){return;}var g=f.clientHeight,h=f.offsetTop,i=100;if(s+i>=h+g&&p._isActiveStep(p._currentStep+1)){p.nextStep();}while(s+i<=h){p.previousStep();f=this._stepPath[p.getCurrentStep()-1].getDomRef();if(!f){return;}h=f.offsetTop;}};d.prototype._getCurrentStepInstance=function(){return a.byId(this.getCurrentStep());};d.prototype._containsStep=function(s){return this.getSteps().some(function(o){return o===s;});};d.prototype._checkCircularReference=function(s){if(this._stepPath.indexOf(s)>=0){throw new Error("The step that you are trying to activate has already been visited. You are creating "+"a loop inside the wizard.");}};d.prototype._activateStep=function(s){this._checkCircularReference(s);this._stepPath.push(s);s._activate();};return d;});
