/*!
 * OpenUI5
 * (c) Copyright 2009-2019 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(['./BindingParser','./DataType','./EventProvider','./ManagedObjectMetadata','./Object','../model/BindingMode','../model/StaticBinding','../model/CompositeBinding','../model/Context','../model/FormatException','../model/ParseException','../model/Type','../model/ValidateException',"sap/ui/base/SyncPromise","sap/ui/util/ActivityDetection","sap/base/util/ObjectPath","sap/base/Log","sap/base/assert","sap/base/util/deepClone","sap/base/util/deepEqual","sap/base/util/uid","sap/ui/thirdparty/jquery","sap/base/util/isEmptyObject"],function(B,D,E,M,d,e,S,C,f,F,P,T,V,g,A,O,L,h,j,k,u,q,m){"use strict";var I;var o=E.extend("sap.ui.base.ManagedObject",{metadata:{"abstract":true,publicMethods:["getId","getMetadata","getModel","setModel","hasModel","bindProperty","unbindProperty","bindAggregation","unbindAggregation","bindObject","unbindObject","getObjectBinding"],library:"sap.ui.core",properties:{},aggregations:{},associations:{},events:{"validationSuccess":{enableEventBubbling:true,parameters:{element:{type:'sap.ui.base.ManagedObject'},property:{type:'string'},type:{type:'sap.ui.model.Type'},newValue:{type:'any'},oldValue:{type:'any'}}},"validationError":{enableEventBubbling:true,parameters:{element:{type:'sap.ui.base.ManagedObject'},property:{type:'string'},type:{type:'sap.ui.model.Type'},newValue:{type:'any'},oldValue:{type:'any'},message:{type:'string'}}},"parseError":{enableEventBubbling:true,parameters:{element:{type:'sap.ui.base.ManagedObject'},property:{type:'string'},type:{type:'sap.ui.model.Type'},newValue:{type:'any'},oldValue:{type:'any'},message:{type:'string'}}},"formatError":{enableEventBubbling:true,parameters:{element:{type:'sap.ui.base.ManagedObject'},property:{type:'string'},type:{type:'sap.ui.model.Type'},newValue:{type:'any'},oldValue:{type:'any'}}},"modelContextChange":{}},specialSettings:{id:'sap.ui.core.ID',models:'object',bindingContexts:'object',objectBindings:'object',metadataContexts:'object',Type:{type:'string',visibility:'hidden'}}},constructor:function(i,a,b){var c=this;E.call(this);if(typeof i!=='string'&&i!==undefined){b=a;a=i;i=a&&a.id;}if(!i){i=this.getMetadata().uid();}else{var l=o._fnIdPreprocessor;i=(l?l.call(this,i):i);var n=I||(I=D.getType("sap.ui.core.ID"));if(!n.isValid(i)){throw new Error("\""+i+"\" is not a valid ID.");}}this.sId=i;this.mProperties=this.getMetadata().createPropertyBag();this.mAggregations={};this.mAssociations={};this.oParent=null;this.aDelegates=[];this.aBeforeDelegates=[];this.iSuppressInvalidate=0;this.oPropagatedProperties=o._oEmptyPropagatedProperties;this.mSkipPropagation={};this.oModels={};this.aPropagationListeners=[];this.oBindingContexts={};this.mElementBindingContexts={};this.mBindingInfos={};this.mObjectBindingInfos={};this._oContextualSettings=o._defaultContextualSettings;this._sOwnerId=o._sOwnerId;(function(){var w=false;if(c.register){c.register();}try{if(c._initCompositeSupport){c._initCompositeSupport(a);}if(c.init){c.init();}c.applySettings(a,b);w=true;}finally{if(!w&&c.deregister){c.deregister();}}}());}},M);o.create=function(a,K,b){if(!a||a instanceof o||typeof a!=="object"||a instanceof String){return a;}function c(n){if(typeof n==="function"){return n;}if(typeof n==="string"){return O.get(n);}}var i=c(a.Type)||c(K&&K.type);if(typeof i==="function"){return new i(a,b);}var l="Don't know how to create a ManagedObject from "+a+" ("+(typeof a)+")";L.fatal(l);throw new Error(l);};var p;function r(i){if(!p){p=sap.ui.require("sap/ui/core/StashedControlSupport");}if(p){return p.getStashedControls(i);}return[];}o._fnIdPreprocessor=null;o._fnSettingsPreprocessor=null;o.runWithPreprocessors=function(a,b,c){h(typeof a==="function","fn must be a function");h(!b||typeof b==="object","oPreprocessors must be an object");var i={id:this._fnIdPreprocessor,settings:this._fnSettingsPreprocessor};b=b||{};this._fnIdPreprocessor=b.id;this._fnSettingsPreprocessor=b.settings;try{return a.call(c);}finally{this._fnIdPreprocessor=i.id;this._fnSettingsPreprocessor=i.settings;}};o.prototype.applySettings=function(a,b){if(!a||m(a)){return this;}var c=this,n=this.getMetadata(),w=n.getJSONKeys(),x=o.create,y=o._fnSettingsPreprocessor,K,z,G;function H(R){for(var i=0,U=R.length;i<U;i++){var W=R[i];if(Array.isArray(W)){H(W);}else{c[G._sMutator](x(W,G,b));}}}function J(R){c[G._sMutator](R[0],R[1],R[2]);}function N(R){var U=D.getType(R),W=U&&U.getPrimitiveType().getName();return W==="object"||W==="any";}y&&y.call(this,a);if(a.metadataContexts&&this._processMetadataContexts){this._processMetadataContexts(a.metadataContexts,a);}if(a.models){if(typeof a.models!=="object"){throw new Error("models must be a simple object");}if(d.isA(a.models,"sap.ui.model.Model")){this.setModel(a.models);}else{for(K in a.models){this.setModel(a.models[K],K==="undefined"?undefined:K);}}}if(a.bindingContexts){if(typeof a.bindingContexts!=="object"){throw new Error("bindingContexts must be a simple object");}if(a.bindingContexts instanceof f){this.setBindingContext(a.bindingContexts);}else{for(K in a.bindingContexts){this.setBindingContext(a.bindingContexts[K],K==="undefined"?undefined:K);}}}if(a.objectBindings){if(typeof a.objectBindings!=="string"&&typeof a.objectBindings!=="object"){throw new Error("binding must be a string or simple object");}if(typeof a.objectBindings==="string"||a.objectBindings.path){this.bindObject(a.objectBindings);}else{for(var K in a.objectBindings){a.objectBindings.model=K;this.bindObject(a.objectBindings[K]);}}}for(K in a){z=a[K];if((G=w[K])!==undefined){var Q;switch(G._iKind){case 0:Q=this.extractBindingInfo(z,b,!N(G.type));if(Q&&typeof Q==="object"){this.bindProperty(K,Q);}else{this[G._sMutator](Q||z);}break;case 1:Q=G.altTypes&&this.extractBindingInfo(z,b,!G.altTypes.some(N));if(Q&&typeof Q==="object"){this.bindProperty(K,Q);}else{if(Array.isArray(z)){if(z.length>1){L.error("Tried to add an array of controls to a single aggregation");}z=z[0];}this[G._sMutator](x(Q||z,G,b));}break;case 2:Q=this.extractBindingInfo(z,b);if(Q&&typeof Q==="object"){this.bindAggregation(K,Q);}else{z=Q||z;if(z){if(Array.isArray(z)){H(z);}else{c[G._sMutator](x(z,G,b));}}}break;case 3:this[G._sMutator](z);break;case 4:if(z){if(Array.isArray(z)){for(var i=0,l=z.length;i<l;i++){this[G._sMutator](z[i]);}}else{this[G._sMutator](z);}}break;case 5:if(typeof z=="function"){this[G._sMutator](z);}else if(Array.isArray(z[0])&&(z.length<=1||Array.isArray(z[1]))){z.forEach(J);}else{J(z);}break;case-1:default:break;}}else{h(false,"ManagedObject.apply: encountered unknown setting '"+K+"' for class '"+n.getName()+"' (value:'"+z+"')");}}return this;};o.escapeSettingsValue=function(a){return(typeof a==="string")?o.bindingParser.escape(a):a;};o.prototype.toString=function(){return"ManagedObject "+this.getMetadata().getName()+"#"+this.getId();};o.prototype.getId=function(){return this.sId;};o.prototype.setProperty=function(a,b,c){var i=this.mProperties[a];b=this.validateProperty(a,b);if(k(i,b)){this.mProperties[a]=b;return this;}if(c){A.refresh();}this.mProperties[a]=b;if(!c&&!this.isInvalidateSuppressed()){this.invalidate();}this.updateModelProperty(a,b,i);if(this.mEventRegistry["_change"]){E.prototype.fireEvent.call(this,"_change",{"id":this.getId(),"name":a,"oldValue":i,"newValue":b});}if(this._observer){this._observer.propertyChange(this,a,i,b);}return this;};o.prototype.getProperty=function(a){var b=this.mProperties[a],c=this.getMetadata().getManagedProperty(a),i;if(!c){throw new Error("Property \""+a+"\" does not exist in "+this);}i=D.getType(c.type);if(i instanceof D&&i.isArrayType()&&Array.isArray(b)){b=b.slice(0);}if(b instanceof String){b=b.valueOf();}if(c.byValue){b=j(b);}return b;};o.prototype.validateProperty=function(a,b){var c=this.getMetadata().getManagedProperty(a),l;if(!c){throw new Error("Property \""+a+"\" does not exist in "+this);}l=D.getType(c.type);if(l instanceof D&&l.isArrayType()&&Array.isArray(b)){b=b.slice(0);}if(b==null){b=c.getDefaultValue();}else if(l instanceof D){if(l.getName()=="string"){if(!(typeof b=="string"||b instanceof String)){b=""+b;}}else if(l.getName()=="string[]"){if(typeof b=="string"){b=[b];}if(!Array.isArray(b)){throw new Error("\""+b+"\" is of type "+typeof b+", expected string[]"+" for property \""+a+"\" of "+this);}for(var i=0;i<b.length;i++){if(typeof b[i]!=="string"){b[i]=""+b[i];}}}else if(!l.isValid(b)){throw new Error("\""+b+"\" is of type "+typeof b+", expected "+l.getName()+" for property \""+a+"\" of "+this);}}if(c.byValue){b=j(b);}if(l&&l.normalize&&typeof l.normalize==="function"){b=l.normalize(b);}return b;};o.prototype.isPropertyInitial=function(a){return!Object.prototype.hasOwnProperty.call(this.mProperties,a)&&!this.isBound(a);};o.prototype.resetProperty=function(a){if(this.mProperties.hasOwnProperty(a)){var b=this.getMetadata().getManagedProperty(a);b.set(this,null);if(this.mProperties[a]===b.getDefaultValue()){delete this.mProperties[a];}}return this;};o.prototype.getOriginInfo=function(a){var b=this.mProperties[a];if(!(b instanceof String&&b.originInfo)){return null;}return b.originInfo;};o.prototype.setAssociation=function(a,i,b){if(i instanceof o){i=i.getId();}else if(i!=null&&typeof i!=="string"){h(false,"setAssociation(): sId must be a string, an instance of sap.ui.base.ManagedObject or null");return this;}if(this.mAssociations[a]===i){return this;}if(b){this.iSuppressInvalidate++;}if(this._observer&&this.mAssociations[a]!=null){this._observer.associationChange(this,a,"remove",this.mAssociations[a]);}this.mAssociations[a]=i;if(this._observer&&this.mAssociations[a]!=null){this._observer.associationChange(this,a,"insert",i);}if(!this.isInvalidateSuppressed()){this.invalidate();}if(b){this.iSuppressInvalidate--;}return this;};o.prototype.getAssociation=function(a,b){var c=this.mAssociations[a];if(!c){c=this.mAssociations[a]=b||null;}else{if(typeof c.length==='number'&&!(c.propertyIsEnumerable('length'))){return c.slice();}return c;}return c;};o.prototype.addAssociation=function(a,i,b){if(i instanceof o){i=i.getId();}else if(typeof i!=="string"){h(false,"addAssociation(): sId must be a string or an instance of sap.ui.base.ManagedObject");return this;}if(b){this.iSuppressInvalidate++;}var c=this.mAssociations[a];if(!c){c=this.mAssociations[a]=[i];}else{c.push(i);}if(this._observer){this._observer.associationChange(this,a,"insert",i);}if(!this.isInvalidateSuppressed()){this.invalidate();}if(b){this.iSuppressInvalidate--;}return this;};o.prototype.removeAssociation=function(a,b,c){var l=this.mAssociations[a];var n=null;if(!l){return null;}if(c){this.iSuppressInvalidate++;}if(typeof(b)=="object"&&b.getId){b=b.getId();}if(typeof(b)=="string"){for(var i=0;i<l.length;i++){if(l[i]==b){b=i;break;}}}if(typeof(b)=="number"){if(b<0||b>=l.length){L.warning("ManagedObject.removeAssociation called with invalid index: "+a+", "+b);}else{n=l[b];l.splice(b,1);if(this._observer){this._observer.associationChange(this,a,"remove",n);}if(!this.isInvalidateSuppressed()){this.invalidate();}}}if(c){this.iSuppressInvalidate--;}return n;};o.prototype.removeAllAssociation=function(a,b){var i=this.mAssociations[a];if(!i){return[];}delete this.mAssociations[a];if(!i.length){return i;}if(b){this.iSuppressInvalidate++;}if(this._observer){this._observer.associationChange(this,a,"remove",i);}if(!this.isInvalidateSuppressed()){this.invalidate();}if(b){this.iSuppressInvalidate--;}return i;};o.prototype.validateAggregation=function(a,b,c,l){var n=this.getMetadata(),w=n.getManagedAggregation(a),x,y,i,z;if(!w){throw new Error("Aggregation \""+a+"\" does not exist in "+this);}if(w.multiple!==c){throw new Error("Aggregation '"+a+"' of "+this+" used with wrong cardinality (declared as "+(w.multiple?"0..n":"0..1")+")");}var G=n.getAggregationForwarder(a);if(G&&!l){G.getTarget(this).validateAggregation(G.targetAggregationName,b,c);}if(!w.multiple&&!b){return b;}if(b instanceof d&&b.isA(w.type)){return b;}x=w.altTypes;if(x&&x.length){if(b==null){return b;}for(i=0;i<x.length;i++){y=D.getType(x[i]);if(y instanceof D){if(y.isValid(b)){return b;}}}}y=O.get(w.type);if(typeof y==="function"&&b instanceof y){return b;}z="\""+b+"\" is not valid for aggregation \""+a+"\" of "+this;if(D.isInterfaceType(w.type)){h(false,z);return b;}else{throw new Error(z);}};o.prototype.setAggregation=function(a,b,c){var i=this.getMetadata().getAggregationForwarder(a);if(i){b=this.validateAggregation(a,b,false,true);return i.set(this,b);}var l=this.mAggregations[a];if(l===b){return this;}b=this.validateAggregation(a,b,false);if(c){this.iSuppressInvalidate++;}this.mAggregations[a]=null;if(l instanceof o){l.setParent(null);}else{if(this._observer!=null&&l!=null){this._observer.aggregationChange(this,a,"remove",l);}}this.mAggregations[a]=b;if(b instanceof o){b.setParent(this,a,c);}else{if(!this.isInvalidateSuppressed()){this.invalidate();}if(this._observer!=null&&b!=null){this._observer.aggregationChange(this,a,"insert",b);}}if(c){this.iSuppressInvalidate--;}return this;};o.prototype.getAggregation=function(a,b){var c=this.getMetadata().getAggregationForwarder(a);if(c){return c.get(this);}var i=this.mAggregations[a];if(!i){i=this.mAggregations[a]=b||null;}if(i){if(typeof i.length==='number'&&!(i.propertyIsEnumerable('length'))){return i.slice();}return i;}else{return null;}};o.prototype.indexOfAggregation=function(a,b){var c=this.getMetadata().getAggregationForwarder(a);if(c){return c.indexOf(this,b);}var l=this.mAggregations[a];if(l){if(l.length==undefined){return-2;}for(var i=0;i<l.length;i++){if(l[i]==b){return i;}}}return-1;};o.prototype.insertAggregation=function(a,b,c,l){if(!b){return this;}b=this.validateAggregation(a,b,true,true);var n=this.getMetadata().getAggregationForwarder(a);if(n){return n.insert(this,b,c);}var w=this.mAggregations[a]||(this.mAggregations[a]=[]);var i;if(c<0){i=0;}else if(c>w.length){i=w.length;}else{i=c;}if(i!==c){L.warning("ManagedObject.insertAggregation: index '"+c+"' out of range [0,"+w.length+"], forced to "+i);}w.splice(i,0,b);b.setParent(this,a,l);return this;};o.prototype.addAggregation=function(a,b,c){if(!b){return this;}b=this.validateAggregation(a,b,true,true);var i=this.getMetadata().getAggregationForwarder(a);if(i){return i.add(this,b);}var l=this.mAggregations[a];if(!l){l=this.mAggregations[a]=[b];}else{l.push(b);}b.setParent(this,a,c);return this;};o.prototype.removeAggregation=function(a,b,c){var l=this.getMetadata().getAggregationForwarder(a);if(l){return l.remove(this,b);}var n=this.mAggregations[a],w=null,i;if(!n){return null;}if(c){this.iSuppressInvalidate++;}if(typeof(b)=="string"){for(i=0;i<n.length;i++){if(n[i]&&n[i].getId()===b){b=i;break;}}}if(typeof(b)=="object"){for(i=0;i<n.length;i++){if(n[i]==b){b=i;break;}}}if(typeof(b)=="number"){if(b<0||b>=n.length){L.warning("ManagedObject.removeAggregation called with invalid index: "+a+", "+b);}else{w=n[b];n.splice(b,1);w.setParent(null);if(!this.isInvalidateSuppressed()){this.invalidate();}}}if(c){this.iSuppressInvalidate--;}return w;};o.prototype.removeAllAggregation=function(a,b){var c=this.getMetadata().getAggregationForwarder(a);if(c){return c.removeAll(this);}var l=this.mAggregations[a];if(!l){return[];}delete this.mAggregations[a];if(!l.length){return l;}if(b){this.iSuppressInvalidate++;}for(var i=0;i<l.length;i++){l[i].setParent(null);}if(!this.isInvalidateSuppressed()){this.invalidate();}if(b){this.iSuppressInvalidate--;}return l;};o.prototype.destroyAggregation=function(a,b){var l=this.getMetadata().getAggregationForwarder(a);if(l){return l.destroy(this);}var n=this.mAggregations[a],i,w;r(this.getId()).forEach(function(c){if(c.sParentAggregationName===a){c.destroy();}});if(!n){return this;}delete this.mAggregations[a];if(Array.isArray(n)&&!n.length){return this;}if(b){this.iSuppressInvalidate++;}if(n instanceof o){n.destroy(b);if(this._observer){this._observer.aggregationChange(this,a,"remove",n);}}else if(Array.isArray(n)){for(i=n.length-1;i>=0;i--){w=n[i];if(w){w.destroy(b);if(this._observer){this._observer.aggregationChange(this,a,"remove",w);}}}}if(!this.isInvalidateSuppressed()){this.invalidate();}if(b){this.iSuppressInvalidate--;}return this;};o.prototype.invalidate=function(){if(this.oParent){this.oParent.invalidate(this);}};o.prototype.isInvalidateSuppressed=function(){var i=this.iSuppressInvalidate>0;if(this.oParent&&this.oParent instanceof o){i=i||this.oParent.isInvalidateSuppressed();}return i;};o.prototype._removeChild=function(c,a,b){if(!a){L.error("Cannot remove aggregated child without aggregation name.",null,this);}else{if(b){this.iSuppressInvalidate++;}var i=this.indexOfAggregation(a,c);var l=this.getMetadata().getAggregation(a);if(i==-2){if(l&&this[l._sMutator]){this[l._sMutator](null);}else{this.setAggregation(a,null,b);}}else if(i>-1){if(l&&this[l._sRemoveMutator]){this[l._sRemoveMutator](i);}else{this.removeAggregation(a,i,b);}}if(b){this.iSuppressInvalidate--;}}};function s(a,b){while(a&&a!==b){a=a.oParent;}return!!a;}o.prototype.setParent=function(a,b,c){h(a==null||a instanceof o,"oParent either must be null, undefined or a ManagedObject");var i;if(!a){if(this.oParent){i=this._observer||this.oParent._observer;if(i){i.parentChange(this,this.sParentAggregationName,"unset",this.oParent);}if(this.aAPIParentInfos&&this.aAPIParentInfos.forwardingCounter===0){delete this.aAPIParentInfos;}}this.oParent=null;this.sParentAggregationName=null;var l=o._oEmptyPropagatedProperties;if(l!==this.oPropagatedProperties){this.oPropagatedProperties=l;if(!this._bIsBeingDestroyed){Promise.resolve().then(function(){if(!this.oParent){this.updateBindings(true,null);this.updateBindingContext(false,undefined,true);this.propagateProperties(true);this.fireModelContextChange();}}.bind(this));}}this._oContextualSettings=o._defaultContextualSettings;if(!this._bIsBeingDestroyed){setTimeout(function(){if(!this.oParent){this._propagateContextualSettings();}}.bind(this),0);}A.refresh();return;}if(s(a,this)){throw new Error("Cycle detected: new parent '"+a+"' is already a descendant of (or equal to) '"+this+"'");}if(c){A.refresh();this.iSuppressInvalidate++;}var n=this.getParent();if(n){n._removeChild(this,this.sParentAggregationName);}this.oParent=a;this.sParentAggregationName=b;if(!a.mSkipPropagation[b]){var l=this.aAPIParentInfos?this.aAPIParentInfos[0].parent._getPropertiesToPropagate():a._getPropertiesToPropagate();if(l!==this.oPropagatedProperties){this.oPropagatedProperties=l;if(this.hasModel()){this.updateBindings(true,null);this.updateBindingContext(false,undefined,true);this.propagateProperties(true);}this._callPropagationListener();this.fireModelContextChange();}}this._applyContextualSettings(a._oContextualSettings);if(a&&!this.isInvalidateSuppressed()){a.invalidate(this);}if(c){this.iSuppressInvalidate--;}i=this._observer||this.oParent._observer;if(i){i.parentChange(this,b,"set",this.oParent);}return this;};o.prototype._applyContextualSettings=function(c){if(this._oContextualSettings!==c){this._oContextualSettings=c;this._propagateContextualSettings();this._onContextualSettingsChanged();}};o.prototype._onContextualSettingsChanged=function(){};o.prototype._propagateContextualSettings=function(){var a=this._oContextualSettings,b,c,i;for(b in this.mAggregations){c=this.mAggregations[b];if(c instanceof o){c._applyContextualSettings(a);}else if(c instanceof Array){for(i=0;i<c.length;i++){if(c[i]instanceof o){c[i]._applyContextualSettings(a);}}}}};o.prototype._getContextualSettings=function(){return this._oContextualSettings;};o.prototype.getParent=function(){return this.oParent;};o.prototype.destroy=function(b){if(this.bIsDestroyed){return;}var a=this;this._bIsBeingDestroyed=true;if(b){this.iSuppressInvalidate++;}if(this.exit){this.exit();}if(this._exitCompositeSupport){this._exitCompositeSupport();}for(var i in this.mAggregations){this.destroyAggregation(i,b);}r(this.getId()).forEach(function(c){c.destroy();});if(this.deregister){this.deregister();}if(this.oParent&&this.sParentAggregationName){this.oParent._removeChild(this,this.sParentAggregationName,b);}delete this.oParent;q.each(this.mBindingInfos,function(n,c){if(c.factory){a.unbindAggregation(n,true);}else{a.unbindProperty(n,true);}});q.each(this.mObjectBindingInfos,function(n,c){a.unbindObject(n,true);});if(b){this.iSuppressInvalidate--;}if(this._observer){this._observer.objectDestroyed(this);}if(this.aAPIParentInfos){this.aAPIParentInfos=null;}E.prototype.destroy.apply(this,arguments);this.setParent=function(){throw Error("The object with ID "+a.getId()+" was destroyed and cannot be used anymore.");};this.bIsDestroyed=true;};o.bindingParser=B.simpleParser;o.prototype.isBinding=function(a,K){return typeof this.extractBindingInfo(a)==="object";};o.prototype.extractBindingInfo=function(a,b,c){if(a&&typeof a==="object"){if(a.ui5object){delete a.ui5object;}else if(a.path!=undefined||a.parts||(c&&a.value!=undefined)){if(a.template){a.template=o.create(a.template);}return a;}}if(typeof a==="string"){return o.bindingParser(a,b,true);}};o.prototype.getBindingInfo=function(n){var a=this.getMetadata().getAggregationForwarder(n);if(a&&a.forwardBinding){return a.getTarget(this).getBindingInfo(a.targetAggregationName);}return this.mBindingInfos[n];};o.prototype.bindObject=function(b){var a,c,i;if(typeof b=="string"){c=b;b={path:c,parameters:arguments[1]};}else{c=b.path;}i=c.indexOf(">");if(i>0){b.model=c.substr(0,i);b.path=c.substr(i+1);}a=b.model;if(this.mObjectBindingInfos[a]){this.unbindObject(a,true);}this.mObjectBindingInfos[a]=b;if(this.getModel(a)){this._bindObject(b);}return this;};o.prototype._bindObject=function(b){var a,c,i,l,n=this;var w=function(y){n.setElementBindingContext(a.getBoundContext(),i);};var x=function(y){var z=a.getDataState();if(!z){return;}if(n.refreshDataState){n.refreshDataState('',z);}};i=b.model;l=this.getModel(i);c=this.getBindingContext(i);a=l.bindContext(b.path,c,b.parameters);if(b.suspended){a.suspend(true);}a.attachChange(w);b.binding=a;b.modelChangeHandler=w;b.dataStateChangeHandler=x;a.attachEvents(b.events);if(this.refreshDataState){a.attachAggregatedDataStateChange(x);}a.initialize();};o.prototype.unbindObject=function(a,b){var c=this.mObjectBindingInfos[a];if(c){if(c.binding){c.binding.detachChange(c.modelChangeHandler);c.binding.detachEvents(c.events);if(this.refreshDataState){c.binding.detachAggregatedDataStateChange(c.dataStateChangeHandler);}c.binding.destroy();}delete this.mObjectBindingInfos[a];delete this.mElementBindingContexts[a];if(!b){this.updateBindingContext(false,a);this.propagateProperties(a);this.fireModelContextChange();}}return this;};o.prototype.bindContext=function(a){return this.bindObject(a);};o.prototype.unbindContext=function(a){return this.unbindObject(a);};o.prototype.bindProperty=function(n,b,a,c){var l,w=true,x=this.getMetadata().getPropertyLikeSetting(n);if(!x){throw new Error("Property \""+n+"\" does not exist in "+this);}if(typeof b=="string"){b={parts:[{path:b,type:a instanceof T?a:undefined,mode:c}],formatter:typeof a==='function'?a:undefined};}if(!b.parts){b.parts=[];b.parts[0]={path:b.path,targetType:b.targetType,type:b.type,suspended:b.suspended,formatOptions:b.formatOptions,constraints:b.constraints,model:b.model,mode:b.mode,value:b.value};delete b.path;delete b.targetType;delete b.mode;delete b.model;delete b.value;}for(var i=0;i<b.parts.length;i++){var y=b.parts[i];if(typeof y=="string"){y={path:y};b.parts[i]=y;}if(y.path!==undefined){l=y.path.indexOf(">");if(l>0){y.model=y.path.substr(0,l);y.path=y.path.substr(l+1);}}if(b.formatter&&y.mode!=e.OneWay&&y.mode!=e.OneTime){y.mode=e.OneWay;}if(y.value===undefined&&!this.getModel(y.model)){w=false;}}b.skipPropertyUpdate=0;b.skipModelUpdate=0;if(this.isBound(n)){this.unbindProperty(n,true);}this.mBindingInfos[n]=b;if(this._observer){this._observer.bindingChange(this,n,"prepare",b,"property");}if(w){this._bindProperty(n,b);}return this;};o.prototype._bindProperty=function(n,b){var a,c,i,l,w=e.TwoWay,x,y,z=this.getMetadata().getPropertyLikeSetting(n),G=z._iKind===0?z.type:z.altTypes[0],H=this,J=[],K=function(Q){H.updateProperty(n);var R=i.getDataState();if(R){var U=R.getControlMessages();if(U&&U.length>0){var W=sap.ui.getCore().getMessageManager();R.setControlMessages([]);if(U){W.removeMessages(U);}}R.setInvalidValue(undefined);}if(i.getBindingMode()===e.OneTime&&i.isResolved()){i.detachChange(K);if(this.refreshDataState){i.detachAggregatedDataStateChange(N);}i.detachEvents(b.events);}},N=function(){var Q=i.getDataState();if(!Q){return;}if(H.refreshDataState){H.refreshDataState(n,Q);}};b.parts.forEach(function(Q){c=H.getBindingContext(Q.model);a=H.getModel(Q.model);x=Q.type;if(typeof x=="string"){y=O.get(x);if(typeof y!=="function"){throw new Error("Cannot find type \""+x+"\" used in control \""+H.getId()+"\"!");}x=new y(Q.formatOptions,Q.constraints);}if(Q.value!==undefined){i=new S(Q.value);}else{i=a.bindProperty(Q.path,c,Q.parameters||b.parameters);}i.setType(x,Q.targetType||G);i.setFormatter(Q.formatter);if(Q.suspended){i.suspend(true);}l=Q.mode||(a&&a.getDefaultBindingMode())||e.TwoWay;i.setBindingMode(l);if(l!==e.TwoWay){w=e.OneWay;}J.push(i);});if(J.length>1||(b.formatter&&b.formatter.textFragments)){x=b.type;if(typeof x=="string"){y=O.get(x);x=new y(b.formatOptions,b.constraints);}i=new C(J,b.useRawValues,b.useInternalValues);i.setType(x,b.targetType||G);i.setBindingMode(b.mode||w);}else{i=J[0];}i.attachChange(K);if(this.refreshDataState){i.attachAggregatedDataStateChange(N);}i.setFormatter(q.proxy(b.formatter,this));b.binding=i;b.modelChangeHandler=K;b.dataStateChangeHandler=N;i.attachEvents(b.events);i.initialize();if(this._observer){this._observer.bindingChange(this,n,"ready",b,"property");}};o.prototype.unbindProperty=function(n,b){var a=this.mBindingInfos[n];if(a){if(a.binding){a.binding.detachChange(a.modelChangeHandler);if(this.refreshDataState){a.binding.detachAggregatedDataStateChange(a.dataStateChangeHandler);}a.binding.detachEvents(a.events);a.binding.destroy();}if(this._observer){this._observer.bindingChange(this,n,"remove",this.mBindingInfos[n],"property");}delete this.mBindingInfos[n];if(!b){this.resetProperty(n);}}return this;};o.prototype.updateProperty=function(n){var b=this.mBindingInfos[n],a=b.binding,c=this.getMetadata().getPropertyLikeSetting(n),i=this;function l(w){if(w instanceof F){i.fireFormatError({element:i,property:n,type:a.getType(),newValue:a.getValue(),oldValue:i[c._sGetter](),exception:w,message:w.message},false,true);b.skipModelUpdate++;i.resetProperty(n);b.skipModelUpdate--;}else{throw w;}}if(b.skipPropertyUpdate){return;}g.resolve().then(function(){return a.getExternalValue();}).then(function(w){b.skipModelUpdate++;i[c._sMutator](w);b.skipModelUpdate--;}).catch(function(w){l(w);}).unwrap();};o.prototype.updateModelProperty=function(n,a,b){var c,i,l=this;function w(y){var z={element:l,property:n,type:i.getType(),newValue:a,oldValue:b,exception:y,message:y.message};if(y instanceof P){l.fireParseError(z,false,true);}else if(y instanceof V){l.fireValidationError(z,false,true);}else{throw y;}}function x(){var y={element:l,property:n,type:i.getType(),newValue:a,oldValue:b};if(i.hasValidation()){l.fireValidationSuccess(y,false,true);}}if(this.isBound(n)){var c=this.mBindingInfos[n],i=c.binding;if(c.skipModelUpdate||(i&&i.isSuspended())){return;}if(i&&i.getBindingMode()==e.TwoWay){c.skipPropertyUpdate++;g.resolve(a).then(function(a){return i.setExternalValue(a);}).then(function(){c.skipPropertyUpdate--;return i.getExternalValue();}).then(function(y){if(a!=y){l.updateProperty(n);}x();}).catch(function(y){c.skipPropertyUpdate--;w(y);}).unwrap();}}};var t=1;o.prototype.bindAggregation=function(n,b){var a,c,i,l,w=this.getMetadata(),x=w.getAggregation(n);if(!x){throw new Error("Aggregation \""+n+"\" does not exist in "+this);}if(!x.multiple){L.error("Binding of single aggregation \""+n+"\" of "+this+" is not supported!");}if(typeof b=="string"){a=arguments[1];c=arguments[2];i=arguments[3];l=arguments[4];b={path:a,sorter:i,filters:l};if(c instanceof o){b.template=c;}else if(typeof c==="function"){b.factory=c;}}var y=w.getAggregationForwarder(n);if(y&&y.forwardBinding){y.getTarget(this).bindAggregation(y.targetAggregationName,b);return this;}if(this.isBound(n)){this.unbindAggregation(n);}if(!(b.template||b.factory)){if(x._doesNotRequireFactory){b.factory=function(){throw new Error("dummy factory called unexpectedly ");};}else{throw new Error("Missing template or factory function for aggregation "+n+" of "+this+" !");}}if(b.template){if(b.template._sapui_candidateForDestroy){L.warning("A binding template that is marked as 'candidate for destroy' is reused in a binding. "+"You can use 'templateShareable:true' to fix this issue for all bindings that are affected "+"(The template is used in aggregation '"+n+"' of object '"+this.getId()+"'). "+"For more information, see documentation under 'Aggregation Binding'.");delete b.template._sapui_candidateForDestroy;}if(b.templateShareable===undefined){b.templateShareable=t;}b.factory=function(G){return b.template.clone(G);};}var z=b.path.indexOf(">");if(z>0){b.model=b.path.substr(0,z);b.path=b.path.substr(z+1);}this.mBindingInfos[n]=b;if(this._observer){this._observer.bindingChange(this,n,"prepare",b,"aggregation");}if(this.getModel(b.model)){this._bindAggregation(n,b);}return this;};o.prototype._bindAggregation=function(n,b){var a=this,c,i=this.getMetadata().getAggregation(n),l=function(z){i.update(a,z.getParameter("reason"));},w=function(z){i.refresh(a,z.getParameter("reason"));},x=function(z){var G=c.getDataState();if(!G){return;}if(a.refreshDataState){a.refreshDataState(n,G);}};var y=this.getModel(b.model);if(this.isTreeBinding(n)){c=y.bindTree(b.path,this.getBindingContext(b.model),b.filters,b.parameters,b.sorter);}else{c=y.bindList(b.path,this.getBindingContext(b.model),b.sorter,b.filters,b.parameters);if(this.bUseExtendedChangeDetection){h(!this.oExtendedChangeDetectionConfig||!this.oExtendedChangeDetectionConfig.symbol,"symbol function must not be set by controls");c.enableExtendedChangeDetection(!b.template,b.key,this.oExtendedChangeDetectionConfig);}}if(b.suspended){c.suspend(true);}b.binding=c;b.modelChangeHandler=l;b.modelRefreshHandler=w;b.dataStateChangeHandler=x;c.attachChange(l);c.attachRefresh(w);c.attachEvents(b.events);if(this.refreshDataState){c.attachAggregatedDataStateChange(x);}c.initialize();if(this._observer){this._observer.bindingChange(this,n,"ready",b,"aggregation");}};o.prototype.unbindAggregation=function(n,b){var a=this.getMetadata().getAggregationForwarder(n);if(a&&a.forwardBinding){a.getTarget(this).unbindAggregation(a.targetAggregationName,b);return this;}var c=this.mBindingInfos[n],i=this.getMetadata().getAggregation(n);if(c){if(c.binding){c.binding.detachChange(c.modelChangeHandler);c.binding.detachRefresh(c.modelRefreshHandler);c.binding.detachEvents(c.events);if(this.refreshDataState){c.binding.detachAggregatedDataStateChange(c.dataStateChangeHandler);}c.binding.destroy();}if(c.template){if(!c.templateShareable&&c.template.destroy){c.template.destroy();}if(c.templateShareable===t){c.template._sapui_candidateForDestroy=true;}}if(this._observer){this._observer.bindingChange(this,n,"remove",this.mBindingInfos[n],"aggregation");}delete this.mBindingInfos[n];if(!b){this[i._sDestructor]();}}return this;};o.prototype.updateAggregation=function(n){var b=this.mBindingInfos[n],a=b.binding,c=b.factory,l=this.getMetadata().getAggregation(n),G,w,x,y=l._sMutator+"Group",z=this;function H(i,R){if(z.bUseExtendedChangeDetection){return M.uid('clone');}else{return i.getId()+"-"+R;}}function J(R,x,U,W){var X=R[l._sGetter]()||[],Y,Z;if(X.length>x.length){for(var i=x.length;i<X.length;i++){Z=X[i];R[l._sRemoveMutator](Z);Z.destroy("KeepDom");}}for(var i=0;i<x.length;i++){Y=x[i];Z=X[i];if(U){U(Y);}if(Z){Z.setBindingContext(Y,b.model);}else{Z=c(H(R,i),Y);Z.setBindingContext(Y,b.model);R[l._sMutator](Z);}if(W){W(Y,Z);}}}function K(R,x){var U=x.diff,W=R[l._sGetter]()||[],X,Y,Z,i;if(!U||W.length===0){J(R,x);return;}for(i=0;i<U.length;i++){X=U[i];switch(X.type){case"insert":Z=x[X.index];Y=c(H(R,X.index),Z);Y.setBindingContext(Z,b.model);R[l._sInsertMutator](Y,X.index);break;case"delete":Y=R[l._sRemoveMutator](X.index);Y.destroy("KeepDom");break;default:L.error("Unknown diff type \""+X.type+"\"");}}W=R[l._sGetter]()||[];for(i=0;i<W.length;i++){W[i].setBindingContext(x[i]);}}function N(i){var R=a.getGroup(i);if(R.key!==G){var U;if(b.groupHeaderFactory){U=b.groupHeaderFactory(R);}z[y](R,U);G=R.key;}}function Q(i,R){J(i,R,null,function(U,W){Q(W,a.getNodeContexts(U));});}if(d.isA(a,"sap.ui.model.ListBinding")){x=a.getContexts(b.startIndex,b.length);w=a.isGrouped()&&z[y];if(w||a.bWasGrouped){this[l._sDestructor]();J(this,x,w?N:undefined);}else if(this.bUseExtendedChangeDetection){K(this,x);}else{if(!b.template){this[l._sDestructor]();}J(this,x);}a.bWasGrouped=w;}else if(d.isA(a,"sap.ui.model.TreeBinding")){if(!b.template){this[l._sDestructor]();}Q(this,a.getRootContexts());}};o.prototype.refreshAggregation=function(n){var b=this.mBindingInfos[n],a=b.binding;a.getContexts(b.startIndex,b.length);};o.prototype.propagateMessages=function(n,a){L.warning("Message for "+this+", Property "+n);};o.prototype.isTreeBinding=function(n){return false;};o.prototype.updateBindings=function(U,a){var b=this,n,c;function l(c){var z=c.parts,i;if(z){if(z.length==1){return(U||z[0].model==a)&&!c.binding.updateRequired(b.getModel(z[0].model));}else{for(i=0;i<z.length;i++){if((U||z[i].model==a)&&!c.binding.aBindings[i].updateRequired(b.getModel(z[i].model))){return true;}}}}else{return(U||c.model==a)&&!c.binding.updateRequired(b.getModel(c.model));}}function w(c){var z=c.parts,i;if(z){for(i=0;i<z.length;i++){if(!b.getModel(z[i].model)){return false;}}return true;}else{return!!b.getModel(c.model);}}function x(c){if(b.refreshDataState){b.refreshDataState(n,c.binding.getDataState());}c.binding.detachChange(c.modelChangeHandler);if(c.modelRefreshHandler){c.binding.detachRefresh(c.modelRefreshHandler);}c.binding.detachEvents(c.events);c.binding.destroy();delete c.binding;delete c.modelChangeHandler;delete c.dataStateChangeHandler;delete c.modelRefreshHandler;}for(n in this.mObjectBindingInfos){c=this.mObjectBindingInfos[n];if(c.binding&&l(c)){x(c);}if(!c.binding&&w(c)){this._bindObject(c);}}for(n in this.mBindingInfos){c=this.mBindingInfos[n];if(c.binding&&l(c)){if(this._observer){var y=c.factory?"aggregation":"property";this._observer.bindingChange(this,n,"remove",c,y);}x(c);}if(!c.binding&&w(c)){if(c.factory){this._bindAggregation(n,c);}else{this._bindProperty(n,c);}}}};o.prototype.isBound=function(n){return!!this.getBindingInfo(n);};o.prototype.getObjectBinding=function(a){return this.mObjectBindingInfos[a]&&this.mObjectBindingInfos[a].binding;};o.prototype.getEventingParent=function(){return this.oParent;};o.prototype.getBinding=function(n){var i=this.getBindingInfo(n);return i&&i.binding;};o.prototype.getBindingPath=function(n){var i=this.getBindingInfo(n);return i&&(i.path||(i.parts&&i.parts[0]&&i.parts[0].path));};o.prototype.setBindingContext=function(c,a){h(a===undefined||(typeof a==="string"&&!/^(undefined|null)?$/.test(a)),"sModelName must be a string or omitted");var b=this.oBindingContexts[a];if(f.hasChanged(b,c)){if(c===undefined){delete this.oBindingContexts[a];}else{this.oBindingContexts[a]=c;}this.updateBindingContext(false,a);this.propagateProperties(a);this.fireModelContextChange();}return this;};o.prototype.setElementBindingContext=function(c,a){h(a===undefined||(typeof a==="string"&&!/^(undefined|null)?$/.test(a)),"sModelName must be a string or omitted");var b=this.mElementBindingContexts[a];if(f.hasChanged(b,c)){if(c===undefined){delete this.mElementBindingContexts[a];}else{this.mElementBindingContexts[a]=c;}this.updateBindingContext(true,a);this.propagateProperties(a);this.fireModelContextChange();}return this;};o.prototype.updateBindingContext=function(b,a,U){var c,l={},n,w,N,x,i;if(U){for(n in this.oModels){if(this.oModels.hasOwnProperty(n)){l[n]=n;}}for(n in this.oPropagatedProperties.oModels){if(this.oPropagatedProperties.oModels.hasOwnProperty(n)){l[n]=n;}}}else{l[a]=a;}for(n in l){if(l.hasOwnProperty(n)){n=n==="undefined"?undefined:n;c=this.getModel(n);x=this.mObjectBindingInfos[n];if(c&&x&&!b){if(!x.binding){this._bindObject(x);}else{w=this._getBindingContext(n);if(f.hasChanged(x.binding.getContext(),w)){x.binding.setContext(w);}}continue;}w=this.getBindingContext(n);for(N in this.mBindingInfos){var x=this.mBindingInfos[N],y=x.binding,z=x.parts;if(!y){continue;}if(z&&z.length>1){for(i=0;i<z.length;i++){if(z[i].model==n){y.aBindings[i].setContext(w);}}}else if(x.factory){if(x.model==n){y.setContext(w);}}else{if(z[0].model==n){y.setContext(w);}}}}}};o.prototype.getBindingContext=function(a){var b=this.getModel(a),c=this.mElementBindingContexts[a];if(c&&!b){return c;}else if(c&&b&&c.getModel()===b){return c;}else if(c===null){return c;}else{return this._getBindingContext(a);}};o.prototype._getBindingContext=function(a){var b=this.getModel(a),c=this.oBindingContexts[a],i=this.oPropagatedProperties.oBindingContexts[a];if(c&&!b){return this.oBindingContexts[a];}else if(c&&b&&c.getModel()===b){return this.oBindingContexts[a];}else if(c===null){return c;}else if(i&&b&&i.getModel()!==b){return undefined;}else{return i;}};o.prototype.setModel=function(a,n){h(a==null||d.isA(a,"sap.ui.model.Model"),"oModel must be an instance of sap.ui.model.Model, null or undefined");h(n===undefined||(typeof n==="string"&&!/^(undefined|null)?$/.test(n)),"sName must be a string or omitted");if(!a&&this.oModels[n]){delete this.oModels[n];this.propagateProperties(n);this.updateBindings(false,n);this.fireModelContextChange();}else if(a&&a!==this.oModels[n]){this.oModels[n]=a;this.propagateProperties(n);this.updateBindingContext(false,n);this.updateBindings(false,n);this.fireModelContextChange();}return this;};o.prototype.addPropagationListener=function(l){h(typeof l==='function',"listener must be a function");this.aPropagationListeners.push(l);this.propagateProperties(false);this._callPropagationListener(l);return this;};o.prototype.removePropagationListener=function(l){h(typeof l==='function',"listener must be a function");var a=this.aPropagationListeners;var i=a.indexOf(l);if(i>=0){a.splice(i,1);this.propagateProperties(false);}return this;};o.prototype.getPropagationListeners=function(){return this.oPropagatedProperties.aPropagationListeners.concat(this.aPropagationListeners);};o.prototype._callPropagationListener=function(l){var a;if(l){l(this);}else{a=this.getPropagationListeners();for(var i=0;i<a.length;i++){l=a[i];l(this);}}return this;};o._oEmptyPropagatedProperties={oModels:{},oBindingContexts:{},aPropagationListeners:[]};var v=Object.assign||q.extend;function _(a,c){return!c.aAPIParentInfos||c.aAPIParentInfos[0].parent===a;}o.prototype.propagateProperties=function(n){var a=this._getPropertiesToPropagate(),U=n===true,b=n===false,N=U?undefined:n,c,l,i,w=v({},this.mAggregations,this.mForwardedAggregations);for(c in w){if(this.mSkipPropagation[c]){continue;}l=w[c];if(l instanceof o){if(_(this,l)){this._propagateProperties(n,l,a,U,N,b);}}else if(l instanceof Array){for(i=0;i<l.length;i++){if(l[i]instanceof o){if(_(this,l[i])){this._propagateProperties(n,l[i],a,U,N,b);}}}}}};o.prototype._propagateProperties=function(n,a,b,U,N,c){if(!b){b=this._getPropertiesToPropagate();U=n===true;c=n===false;N=U?undefined:n;}if(a.oPropagatedProperties!==b){a.oPropagatedProperties=b;if(c!==true){a.updateBindings(U,N);a.updateBindingContext(false,N,U);}a.propagateProperties(n);if(c||U){a._callPropagationListener();}a.fireModelContextChange();}};o.prototype._getPropertiesToPropagate=function(){var n=m(this.oModels),N=m(this.oBindingContexts),b=this.aPropagationListeners.length===0,a=m(this.mElementBindingContexts);function c(l,w,x,y){return l?w:q.extend({},w,x,y);}function i(l,w,x){return l?w:w.concat(x);}if(N&&n&&a&&b){return this.oPropagatedProperties;}else{return{oModels:c(n,this.oPropagatedProperties.oModels,this.oModels),oBindingContexts:c((N&&a),this.oPropagatedProperties.oBindingContexts,this.oBindingContexts,this.mElementBindingContexts),aPropagationListeners:i(b,this.oPropagatedProperties.aPropagationListeners,this.aPropagationListeners)};}};o.prototype.getModel=function(a){h(a===undefined||(typeof a==="string"&&!/^(undefined|null)?$/.test(a)),"sModelName must be a string or omitted");return this.oModels[a]||this.oPropagatedProperties.oModels[a];};o.prototype.hasModel=function(){return!(m(this.oModels)&&m(this.oPropagatedProperties.oModels));};o.prototype.clone=function(a,b,c){var n=true,w=true;if(c){n=!!c.cloneChildren;w=!!c.cloneBindings;}if(!a){a=M.uid("clone")||u();}if(!b&&n){b=this.findAggregatedObjects(true).map(function(d1){return d1.getId();});}var x=this.getMetadata(),y=x._oClass,z=this.getId()+"-"+a,G={},H,J=this.mProperties,K,N,Q,R=o.bindingParser.escape,i,U;var W=Object.keys(J);i=W.length;while(i>0){K=W[--i];H=x.getProperty(K);if(H&&!(this.isBound(K)&&w)){if(typeof J[K]==="string"){G[K]=R(J[K]);}else{G[K]=H.byValue?j(J[K]):J[K];}}}G["models"]=this.oModels;G["bindingContexts"]=this.oBindingContexts;if(n){var X=v({},this.mAggregations,this.mForwardedAggregations);for(N in X){var Y=X[N];if(x.hasAggregation(N)&&!(this.isBound(N)&&w)){if(Y instanceof o){G[N]=Y.clone(a,b);}else if(Array.isArray(Y)){G[N]=[];for(var i=0;i<Y.length;i++){G[N].push(Y[i].clone(a,b));}}else{G[N]=Y;}}}var Z=r(this.getId());for(var i=0,l=Z.length;i<l;i++){var $=Z[i].clone(a);$.sParentId=z;$.sParentAggregationName=Z[i].sParentAggregationName;}for(N in this.mAssociations){if(!x.hasAssociation(N)){continue;}var a1=this.mAssociations[N];if(Array.isArray(a1)){a1=a1.slice(0);for(var i=0;i<a1.length;i++){if(b.indexOf(a1[i])>=0){a1[i]+="-"+a;}}}else if(b.indexOf(a1)>=0){a1+="-"+a;}G[N]=a1;}}Q=new y(z,G);function b1(d1,N,Q,e1){var f1=d1.mBindingInfos[N];f1=f1||d1.getBindingInfo(N);var g1=q.extend({},f1);if(!f1.templateShareable&&f1.template&&f1.template.clone){g1.template=f1.template.clone(a,b);delete g1.factory;}else if(f1.templateShareable===t){f1.templateShareable=g1.templateShareable=true;L.error("During a clone operation, a template was found that neither was marked with 'templateShareable:true' nor 'templateShareable:false'. "+"The framework won't destroy the template. This could cause errors (e.g. duplicate IDs) or memory leaks "+"(The template is used in aggregation '"+N+"' of object '"+d1.getId()+"')."+"For more information, see documentation under 'Aggregation Binding'.");}delete g1.binding;delete g1.modelChangeHandler;delete g1.dataStateChangeHandler;delete g1.modelRefreshHandler;if(f1.factory||f1.template){Q.bindAggregation(e1,g1);}else{Q.bindProperty(e1,g1);}}for(N in this.mObjectBindingInfos){Q.mObjectBindingInfos[N]=q.extend({},this.mObjectBindingInfos[N]);}for(N in this.mEventRegistry){Q.mEventRegistry[N]=this.mEventRegistry[N].slice();}if(w){for(N in this.mBindingInfos){b1(this,N,Q,N);}}if(o._supportInfo){o._supportInfo.addSupportInfo(Q.getId(),o._supportInfo.byId(this.getId()));}if(this._cloneMetadataContexts){this._cloneMetadataContexts(Q);}if(this.mForwardedAggregations){for(N in this.mForwardedAggregations){var c1=Q.getMetadata().getAggregationForwarder(N);if(c1){U=c1.getTarget(Q,true);if(c1.forwardBinding&&this.isBound(N)){b1(this,N,U,c1.targetAggregationName);}}}}return Q;};o._handleLocalizationChange=function(a){var i;if(a===1){q.each(this.oModels,function(n,b){if(b&&b._handleLocalizationChange){b._handleLocalizationChange();}});}else if(a===2){q.each(this.mBindingInfos,function(n,b){var c=b.parts;if(c){for(i=0;i<c.length;i++){if(b.type&&b.type._handleLocalizationChange){b.type._handleLocalizationChange();}}if(b.modelChangeHandler){b.modelChangeHandler();}}});}};o.prototype.findAggregatedObjects=function(R,c){var b=[];if(c&&typeof c!=="function"){c=null;}function l(w){var a,i,n;for(n in w.mAggregations){a=w.mAggregations[n];if(Array.isArray(a)){for(i=0;i<a.length;i++){if(!c||c(a[i])){b.push(a[i]);}if(R){l(a[i]);}}}else if(a instanceof o){if(!c||c(a)){b.push(a);}if(R){l(a);}}}}l(this);return b;};o._defaultContextualSettings={};return o;});
