/*!
 * OpenUI5
 * (c) Copyright 2009-2019 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(['./LabelEnablement','sap/ui/base/Object','sap/ui/performance/trace/Interaction','sap/base/util/uid',"sap/ui/util/ActivityDetection","sap/ui/thirdparty/jquery","sap/base/security/encodeXML","sap/base/security/encodeCSS","sap/base/assert","sap/ui/performance/Measurement","sap/base/Log","./InvisibleRenderer","./Patcher"],function(L,B,I,u,A,q,a,b,c,M,d,f,P){"use strict";var C=["renderControl","cleanupControlWithoutRendering","accessibilityState","icon"];var s=["write","writeEscaped","writeAcceleratorKey","writeControlData","writeElementData","writeAttribute","writeAttributeEscaped","addClass","writeClasses","addStyle","writeStyles","writeAccessibilityState","writeIcon","translate","getConfiguration","getHTML"];var D=["openStart","voidStart","attr","class","style","openEnd","voidEnd","text","unsafeHtml","close"];var n=["render","flush","destroy"];function R(){var p=this,F,v,x,S,z,E,O="",V=false,G,H="",J={},K={};this._setFocusHandler=function(e){c(e&&B.isA(e,'sap.ui.core.FocusHandler'),"oFocusHandler must be an sap.ui.core.FocusHandler");F=e;};function N(){v=p.aBuffer=[];x=p.aRenderedControls=[];S=p.aStyleStack=[{}];G=undefined;V=false;O="";}function Q(e,i){c(e&&typeof e=="string"&&/^[a-z_][a-zA-Z0-9_\-]*$/.test(e),"The "+i+" name provided '"+e+"' is not valid; it must contain alphanumeric characters, hyphens or underscores");}function T(e){c(O,"There is no open tag; '"+e+"' must not be called without an open tag");}function U(e){var i=(e===undefined)?!O:e;c(i,"There is an open tag; '"+O+"' tag has not yet ended with '"+(V?"voidEnd":"openEnd")+"'");}function W(e){Q(e,"attr");c(e!="class"&&e!="style","Attributes 'class' and 'style' must not be written, instead use dedicated 'class' or 'style' method");}function X(e){c(typeof e=="string"&&!/\s/.test(e)&&arguments.length===1,"Method 'class' must be called with exactly one class name");}function Y(e){c(e&&typeof e=="string"&&!/\s/.test(e),"Method 'style' must be called with a non-empty string name");}this.write=function(e){c((typeof e==="string")||(typeof e==="number"),"sText must be a string or number");v.push.apply(v,arguments);return this;};this.writeEscaped=function(e,i){if(e!=null){e=a(String(e));if(i){e=e.replace(/&#xa;/g,"<br>");}v.push(e);}return this;};this.writeAttribute=function(e,i){c(typeof e==="string","sName must be a string");c(typeof i==="string"||typeof i==="number"||typeof i==="boolean","value must be a string, number or boolean");v.push(" ",e,"=\"",i,"\"");return this;};this.writeAttributeEscaped=function(e,i){c(typeof e==="string","sName must be a string");v.push(" ",e,"=\"",a(String(i)),"\"");return this;};this.addStyle=function(e,i){c(typeof e==="string","sName must be a string");if(i!=null&&i!=""){c((typeof i==="string"||typeof i==="number"),"value must be a string or number");var j=S[S.length-1];if(!j.aStyle){j.aStyle=[];}j.aStyle.push(e+": "+i+";");}return this;};this.writeStyles=function(){var e=S[S.length-1];if(e.aStyle&&e.aStyle.length){this.writeAttribute("style",e.aStyle.join(" "));}e.aStyle=null;return this;};this.addClass=function(e){if(e){c(typeof e==="string","sName must be a string");var i=S[S.length-1];if(!i.aClasses){i.aClasses=[];}i.aClasses.push(e);}return this;};this.writeClasses=function(e){c(!e||typeof e==="boolean"||B.isA(e,'sap.ui.core.Element'),"oElement must be empty, a boolean, or an sap.ui.core.Element");var i=S[S.length-1];var j;if(e){j=e.aCustomStyleClasses;}else if(e===false){j=[];}else{j=i.aCustomStyleClasses;}if(i.aClasses||j){var b1=[].concat(i.aClasses||[],j||[]);if(b1.length){this.writeAttribute("class",b1.join(" "));}}if(!e){i.aCustomStyleClasses=null;}i.aClasses=null;return this;};this.openStart=function(e,i){Q(e,"tag");U();O=e;this.write("<"+e);if(i){if(typeof i=="string"){this.attr("id",i);}else{this.writeElementData(i);}}return this;};this.openEnd=function(e){T("openEnd");U(!V);O="";this.writeClasses(e?false:undefined);this.writeStyles();this.write(">");return this;};this.close=function(e){Q(e,"tag");U();this.write("</"+e+">");return this;};this.voidStart=function(e,i){this.openStart(e,i);V=true;return this;};this.voidEnd=function(e){T("voidEnd");U(V||!O);V=false;O="";this.writeClasses(e?false:undefined);this.writeStyles();this.write(">");return this;};this.unsafeHtml=function(e){U();this.write(e);return this;};this.text=function(e){U();this.writeEscaped(e);return this;};this.attr=function(e,i){W(e);this.writeAttributeEscaped(e,i);return this;};this.class=function(e){if(e){X.apply(this,arguments);this.addClass(a(e));}return this;};this.style=function(e,i){Y(e);this.addStyle(e,i);return this;};this.accessibilityState=this.writeAccessibilityState;this.icon=this.writeIcon;K.openStart=function(e,i){Q(e,"tag");U();O=e;if(!i){P.openStart(e);}else if(typeof i=="string"){P.openStart(e,i);}else{P.openStart(e,i.getId());y(this,i);}return this;};K.voidStart=function(e,i){this.openStart(e,i);V=true;return this;};K.attr=function(e,i){W(e);T("attr");P.attr(e,i);return this;};K.class=function(e){if(e){X.apply(this,arguments);T("class");P.class(e);}return this;};K.style=function(e,i){Y(e);T("style");P.style(e,i);return this;};K.openEnd=function(e){if(!e){var i=S[S.length-1];var j=i.aCustomStyleClasses;if(j){j.forEach(P.class,P);i.aCustomStyleClasses=null;}}T("openEnd");U(!V);O="";P.openEnd();return this;};K.voidEnd=function(e){if(!e){var i=S[S.length-1];var j=i.aCustomStyleClasses;if(j){j.forEach(P.class,P);i.aCustomStyleClasses=null;}}T("voidEnd");U(V||!O);V=false;O="";P.voidEnd();return this;};K.text=function(e){U();if(e!=null){P.text(e);}return this;};K.unsafeHtml=function(e){U();P.unsafeHtml(e);return this;};K.close=function(e){Q(e,"tag");U();P.close(e);return this;};function Z(e){E=true;try{var i=q.Event("BeforeRendering");i.srcControl=e;e._handleEvent(i);}finally{E=false;}}this.cleanupControlWithoutRendering=function(e){c(!e||B.isA(e,'sap.ui.core.Control'),"oControl must be an sap.ui.core.Control or empty");if(!e||!e.getDomRef()){return;}Z(e);e.bOutput=false;};this.renderControl=function(e){c(!e||B.isA(e,'sap.ui.core.Control'),"oControl must be an sap.ui.core.Control or empty");if(!e){return this;}if(!z){z=[];}if(z&&z.length>0){M.pause(z[0]+"---renderControl");}else if(e.getParent()&&e.getParent().getMetadata().getName()=="sap.ui.core.UIArea"){M.pause(e.getParent().getId()+"---rerender");}z.unshift(e.getId());M.start(e.getId()+"---renderControl","Rendering of "+e.getMetadata().getName(),["rendering","control"]);Z(e);M.pause(e.getId()+"---renderControl");var j;var b1=e.getMetadata();var c1=e.getVisible();if(c1){j=b1.getRenderer();}else{var d1=b1.getProperty("visible");var e1=d1&&d1._oParent&&d1._oParent.getName()=="sap.ui.core.Control";j=e1?f:b1.getRenderer();}M.resume(e.getId()+"---renderControl");var f1=e.aBindParameters;if(f1&&f1.length>0){var g1=q(e.getDomRef());if(g1&&g1[0]){for(var i=0;i<f1.length;i++){var h1=f1[i];g1.unbind(h1.sEventType,h1.fnProxy);}}}if(j&&typeof j.render==="function"){if(v.length){G=false;}else if(G===undefined){var i1=e.getDomRef();if(!i1&&!c1){i1=document.getElementById(f.createInvisiblePlaceholderId(e));}if(i1&&R.getApiVersion(j)==2&&!R.isPreservedContent(i1)){F&&F.storePatchingControlFocusInfo(i1);P.setRootNode(i1);G=true;}else{G=false;}}else if(!H&&G){if(R.getApiVersion(j)!=2){H=e.getId();G=false;}}var j1={};if(e.aCustomStyleClasses&&e.aCustomStyleClasses.length>0){j1.aCustomStyleClasses=e.aCustomStyleClasses;}S.push(j1);if(G){var k1=P.getCurrentNode();j.render(K,e);if(P.getCurrentNode()==k1){P.unsafeHtml("",e.getId());e.bOutput=false;}else{e.bOutput=true;}}else{var l1=v.length;j.render(J,e);e.bOutput=(v.length!==l1);}S.pop();if(H&&H===e.getId()){P.unsafeHtml(v.join(""),H);H="";G=true;v=[];}}else{d.error("The renderer for class "+b1.getName()+" is not defined or does not define a render function! Rendering of "+e.getId()+" will be skipped!");}x.push(e);if(e.getUIArea&&e.getUIArea()){e.getUIArea()._onControlRendered(e);}if(j===f){e.bOutput="invisible";}M.end(e.getId()+"---renderControl");z.shift();if(z&&z.length>0){M.resume(z[0]+"---renderControl");}else if(e.getParent()&&e.getParent().getMetadata().getName()=="sap.ui.core.UIArea"){M.resume(e.getParent().getId()+"---rerender");}return this;};this.getHTML=function(e){c(e&&B.isA(e,'sap.ui.core.Control'),"oControl must be an sap.ui.core.Control");var i=v;var j=v=this.aBuffer=[];this.renderControl(e);v=this.aBuffer=i;return j.join("");};function $(b1){var i,c1=x.length;for(i=0;i<c1;i++){x[i]._sapui_bInAfterRenderingPhase=true;}E=true;try{for(i=0;i<c1;i++){var d1=x[i];if(d1.bOutput&&d1.bOutput!=="invisible"){var e1=q.Event("AfterRendering");e1.srcControl=d1;M.start(d1.getId()+"---AfterRendering","AfterRendering of "+d1.getMetadata().getName(),["rendering","after"]);d1._handleEvent(e1);M.end(d1.getId()+"---AfterRendering");}}}finally{for(i=0;i<c1;i++){delete x[i]._sapui_bInAfterRenderingPhase;}E=false;}try{F.restoreFocus(b1);}catch(e){d.warning("Problems while restoring the focus after rendering: "+e,null);}for(i=0;i<c1;i++){var d1=x[i],f1=d1.aBindParameters;if(f1&&f1.length>0){var g1=q(d1.getDomRef());if(g1&&g1[0]){for(var j=0;j<f1.length;j++){var h1=f1[j];g1.bind(h1.sEventType,h1.fnProxy);}}}}}function _(e){var i;if(!G){i=F&&F.getControlFocusInfo();e(v.join(""));}else{i=F&&F.getPatchingControlFocusInfo();P.reset();}$(i);N();A.refresh();I.notifyStepEnd();}this.flush=function(e,j,b1){c((typeof e==="object")&&(e.ownerDocument==document),"oTargetDomNode must be a DOM element");if(!j&&(typeof b1!=="number")&&!b1){R.preserveContent(e);}_(function(c1){for(var i=0;i<x.length;i++){var d1=x[i].getDomRef();if(d1&&!R.isPreservedContent(d1)){if(R.isInlineTemplate(d1)){q(d1).empty();}else{q(d1).remove();}}}if(typeof b1==="number"){if(b1<=0){q(e).prepend(c1);}else{var e1=q(e).children().eq(b1-1);if(e1.length===1){e1.after(c1);}else{q(e).append(c1);}}}else if(!b1){q(e).html(c1);}else{q(e).append(c1);}});};this.render=function(e,i){c(e&&B.isA(e,'sap.ui.core.Control'),"oControl must be a control");c(typeof i==="object"&&i.ownerDocument==document,"oTargetDomNode must be a DOM element");if(E){d.error("Render must not be called within Before or After Rendering Phase. Call ignored.",null,this);return;}N();this.renderControl(e);_(function(j){if(e&&i){var b1=e.getDomRef();if(!b1||R.isPreservedContent(b1)){b1=document.getElementById(f.createInvisiblePlaceholderId(e))||document.getElementById(g.Dummy+e.getId());}var c1=b1&&b1.parentNode!=i;var d1=function(){var e1=q(i);if(i.innerHTML==""){e1.html(j);}else{e1.append(j);}};if(c1){if(!R.isPreservedContent(b1)){if(R.isInlineTemplate(b1)){q(b1).empty();}else{q(b1).remove();}}if(j){d1();}}else{if(j){if(b1){if(R.isInlineTemplate(b1)){q(b1).html(j);}else{q(b1).replaceWith(j);}}else{d1();}}else{if(R.isInlineTemplate(b1)){q(b1).empty();}else{if(!e.getParent()||!e.getParent()._onChildRerenderedEmpty||!e.getParent()._onChildRerenderedEmpty(e,b1)){q(b1).remove();}}}}}});};this.destroy=function(){N();};var a1={};C.forEach(function(e){J[e]=K[e]=a1[e]=this[e];},this);D.forEach(function(e){J[e]=a1[e]=this[e];},this);s.forEach(function(e){J[e]=a1[e]=this[e];},this);n.forEach(function(e){a1[e]=this[e];},this);this.getRendererInterface=function(){return J;};this.getInterface=function(){return a1;};N();}R.prototype.getConfiguration=function(){return sap.ui.getCore().getConfiguration();};R.prototype.translate=function(K){};R.prototype.writeAcceleratorKey=function(){return this;};R.prototype.writeControlData=function(e){c(e&&B.isA(e,'sap.ui.core.Control'),"oControl must be an sap.ui.core.Control");this.writeElementData(e);return this;};R.prototype.writeElementData=function(e){c(e&&B.isA(e,'sap.ui.core.Element'),"oElement must be an sap.ui.core.Element");this.attr("id",e.getId());y(this,e);return this;};R.prototype.writeAccessibilityState=function(e,j){if(!sap.ui.getCore().getConfiguration().getAccessibility()){return this;}if(arguments.length==1&&!(B.isA(e,'sap.ui.core.Element'))){j=e;e=null;}var z={};if(e!=null){var E=e.getMetadata();var F=function(i,v,V){var O=E.getProperty(i);if(O&&e[O._sGetter]()===V){z[v]="true";}};var G=function(v,O){var Q=E.getAssociation(v);if(Q&&Q.multiple){var S=e[Q._sGetter]();if(v=="ariaLabelledBy"){var T=L.getReferencingLabels(e);var U=T.length;if(U){var V=[];for(var i=0;i<U;i++){if(S.indexOf(T[i])<0){V.push(T[i]);}}S=V.concat(S);}}if(S.length>0){z[O]=S.join(" ");}}};F("editable","readonly",false);F("enabled","disabled",false);F("visible","hidden",false);if(L.isRequired(e)){z["required"]="true";}F("selected","selected",true);F("checked","checked",true);G("ariaDescribedBy","describedby");G("ariaLabelledBy","labelledby");}if(j){var H=function(v){var i=typeof(v);return v===null||v===""||i==="number"||i==="string"||i==="boolean";};var J={};var x,K,N;for(x in j){K=j[x];if(H(K)){J[x]=K;}else if(typeof(K)==="object"&&H(K.value)){N="";if(K.append&&(x==="describedby"||x==="labelledby")){N=z[x]?z[x]+" ":"";}J[x]=N+K.value;}}q.extend(z,J);}if(B.isA(e,'sap.ui.core.Element')&&e.getParent()&&e.getParent().enhanceAccessibilityState){e.getParent().enhanceAccessibilityState(e,z);}for(var p in z){if(z[p]!=null&&z[p]!==""){this.attr(p==="role"?p:"aria-"+p,z[p]);}}return this;};R.prototype.writeIcon=function(U,e,i){var j=sap.ui.requireSync("sap/ui/core/IconPool"),p=j.isIconURI(U),v=false,x,z,E,F,G;if(typeof e==="string"){e=[e];}if(p){z=j.getIconInfo(U);if(!z){d.error("An unregistered icon: "+U+" is used in sap.ui.core.RenderManager's writeIcon method.");return this;}if(!e){e=[];}e.push("sapUiIcon");if(!z.suppressMirroring){e.push("sapUiIconMirrorInRTL");}}if(p){this.openStart("span");}else{this.voidStart("img");}if(Array.isArray(e)){e.forEach(function(H){this.class(H);},this);}if(p){E={"data-sap-ui-icon-content":z.content,"role":"presentation","title":z.text||null};this.style("font-family","'"+b(z.fontFamily)+"'");}else{E={role:"presentation",alt:"",src:U};}i=q.extend(E,i);if(!i.id){i.id=u();}if(p){F=i.alt||i.title||z.text||z.name;G=i.id+"-label";if(i["aria-labelledby"]){v=true;i["aria-labelledby"]+=(" "+G);}else if(!i.hasOwnProperty("aria-label")){i["aria-label"]=F;}}if(typeof i==="object"){for(x in i){if(i.hasOwnProperty(x)&&i[x]!==null){this.attr(x,i[x]);}}}if(p){this.openEnd();if(v){this.openStart("span");this.style("display","none");this.attr("id",G);this.openEnd("span");this.text(F);this.close("span");}this.close("span");}else{this.voidEnd();}return this;};R.prototype.getRenderer=function(e){c(e&&B.isA(e,'sap.ui.core.Control'),"oControl must be an sap.ui.core.Control");return R.getRenderer(e);};var g=R.RenderPrefixes={Invisible:f.PlaceholderPrefix,Dummy:"sap-ui-dummy-",Temporary:"sap-ui-tmp-"};R.getRenderer=function(e){c(e&&B.isA(e,'sap.ui.core.Control'),"oControl must be an sap.ui.core.Control");return e.getMetadata().getRenderer();};R.forceRepaint=function(v){var e=v?window.document.getElementById(v):null;var i=typeof v=="string"?e:v;if(i){d.debug("forcing a repaint for "+(i.id||String(i)));var O=i.style.display;var j=document.activeElement;i.style.display="none";i.offsetHeight;i.style.display=O;if(document.activeElement!==j&&j){j.focus();}}};R.createInvisiblePlaceholderId=function(e){return f.createInvisiblePlaceholderId(e);};var h="sap-ui-preserve",k="sap-ui-static",l="data-sap-ui-preserve",m="data-sap-ui-area";function o(){var $=q(document.getElementById(h));if($.length===0){$=q("<DIV/>",{"aria-hidden":"true",id:h}).addClass("sapUiHidden").addClass("sapUiForcedHidden").css("width","0").css("height","0").css("overflow","hidden").appendTo(document.body);}return $;}function r(e){q("<DIV/>",{id:g.Dummy+e.id}).addClass("sapUiHidden").insertBefore(e);}var t=[];R.attachPreserveContent=function(e,i){R.detachPreserveContent(e);t.push({fn:e,context:i});};R.detachPreserveContent=function(e){t=t.filter(function(i){return i.fn!==e;});};R.preserveContent=function(e,p,j){c(typeof e==="object"&&e.ownerDocument==document,"oRootNode must be a DOM element");t.forEach(function(i){i.fn.call(i.context||R,{domNode:e});});var $=o();function v(i){while(i&&i!=e&&i.parentNode){i=i.parentNode;if(i.hasAttribute(l)){return true;}if(i.hasAttribute("data-sap-ui")){break;}}}function x(i){if(i.id===h||i.id===k){return;}if(i.hasAttribute(l)){if(i===e||v(i)){r(i);}$.append(i);}else if(j&&i.id){R.markPreservableContent(q(i),i.id);$.append(i);return;}if(!i.hasAttribute(m)){var z=i.firstChild;while(z){i=z;z=z.nextSibling;if(i.nodeType===1){x(i);}}}}M.start(e.id+"---preserveContent","preserveContent for "+e.id,["rendering","preserve"]);if(p){x(e);}else{q(e).children().each(function(i,N){x(N);});}M.end(e.id+"---preserveContent");};R.findPreservedContent=function(i){c(typeof i==="string","sId must be a string");var $=o(),e=$.children("["+l+"='"+i.replace(/(:|\.)/g,'\\$1')+"']");return e;};R.markPreservableContent=function($,i){$.attr(l,i);};R.isPreservedContent=function(e){return(e&&e.getAttribute(l)&&e.parentNode&&e.parentNode.id==h);};R.getPreserveAreaRef=function(){return o()[0];};var w="data-sap-ui-template";R.markInlineTemplate=function($){$.attr(w,"");};R.isInlineTemplate=function(e){return(e&&e.hasAttribute(w));};R.getApiVersion=function(e){if(e.hasOwnProperty("apiVersion")){return e.apiVersion;}return 1;};function y(e,E){var i=E.getId();e.attr("data-sap-ui",i);E.getCustomData().forEach(function(v){var x=v._checkWriteToDom(E);if(x){e.attr(x.key.toLowerCase(),x.value);}});var j=E.getDragDropConfig().some(function(v){return v.isDraggable(E);});if(!j){var p=E.getParent();if(p&&p.getDragDropConfig){j=p.getDragDropConfig().some(function(v){return v.isDraggable(E);});}}if(j){e.attr("draggable","true");e.attr("data-sap-ui-draggable","true");}return this;}return R;},true);
