/*!
 * OpenUI5
 * (c) Copyright 2009-2019 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["sap/ui/fl/Change","sap/ui/fl/Variant","sap/ui/fl/Utils","sap/ui/fl/LrepConnector","sap/ui/fl/Cache","sap/ui/fl/context/ContextManager","sap/ui/fl/registry/Settings","sap/ui/fl/transport/TransportSelection","sap/ui/fl/variants/VariantController","sap/ui/core/BusyIndicator","sap/ui/core/Component","sap/m/MessageBox","sap/ui/model/json/JSONModel","sap/ui/thirdparty/jquery","sap/base/util/merge","sap/base/util/isEmptyObject","sap/base/Log"],function(C,V,U,L,a,b,S,T,c,B,d,M,J,q,m,i,e){"use strict";var f=function(g){this._mComponent=g;this._mChanges={mChanges:{},mDependencies:{},mDependentChangesOnMe:{},aChanges:[]};this._mChangesInitial=m({},this._mChanges);this._mVariantsChanges={};if(!this._mComponent||!this._mComponent.name){e.error("The Control does not belong to an SAPUI5 component. Personalization and changes for this control might not work as expected.");throw new Error("Missing component name.");}this._oVariantController=new c(this._mComponent.name,this._mComponent.appVersion,{});this._oTransportSelection=new T();this._oConnector=this._createLrepConnector();this._aDirtyChanges=[];this._oMessagebundle=undefined;this._mChangesEntries={};this._bHasChangesOverMaxLayer=false;this.HIGHER_LAYER_CHANGES_EXIST="higher_layer_changes_exist";};f.prototype.getComponentName=function(){return this._mComponent.name;};f.prototype._createLrepConnector=function(){return L.createConnector();};f.prototype.getCacheKey=function(A){return a.getCacheKey(this._mComponent,A);};f.prototype._preconditionsFulfilled=function(A,I,o){var g=o instanceof C?o.getDefinition():o;if(!g.fileName){e.warning("A change without fileName is detected and excluded from component: "+this._mComponent.name);return false;}function _(){if(I){return(g.fileType==="change")||(g.fileType==="variant");}return(g.fileType==="change")&&(g.changeType!=="defaultVariant");}function h(){if(I){if((g.fileType==="variant")||(g.changeType==="defaultVariant")){return g.selector&&g.selector.persistencyKey;}}return true;}function j(){return b.doesContextMatch(g,A);}function k(){if((g.fileType==="ctrl_variant")||(g.fileType==="ctrl_variant_change")||(g.fileType==="ctrl_variant_management_change")){return g.variantManagementReference||g.variantReference||(g.selector&&g.selector.id);}}if((_()&&h()&&j())||k()){return true;}return false;};f.prototype.getChangesForComponent=function(p,I){return a.getChangesFillingCache(this._oConnector,this._mComponent,p,I).then(function(w){var o=m({},w);var A=p&&p.component&&U.getAppComponentForControl(p.component);if(o.changes&&o.changes.settings){S._storeInstance(o.changes.settings);}var F=o.changes&&Array.isArray(o.changes.changes)&&o.changes.changes.length!==0;var v=o.changes&&o.changes.variantSection&&!i(o.changes.variantSection);if(!F&&!v){return[];}var j=A?A.getComponentData():(p&&p.componentData||{});var k=o.changes.changes;if(!this._oMessagebundle&&o.messagebundle&&A){if(!A.getModel("i18nFlexVendor")){if(k.some(function(D){return D.layer==="VENDOR";})){this._oMessagebundle=o.messagebundle;var l=new J(this._oMessagebundle);A.setModel(l,"i18nFlexVendor");}}}var n=p&&p.includeCtrlVariants;var s=p&&p.currentLayer;var t=!(p&&p.ignoreMaxLayerParameter);var u=[o.changes.variantSection];if(s){k=k.filter(this._filterChangeForCurrentLayer.bind(this,s));u.push(false,s);}else if(U.isLayerFilteringRequired()&&t){k=k.filter(this._filterChangeForMaxLayer.bind(this));u.push(true);}else if(this._bHasChangesOverMaxLayer&&!t){this._bHasChangesOverMaxLayer=false;return this.HIGHER_LAYER_CHANGES_EXIST;}if(v){if(n||u.length>1){var x=this._getAllCtrlVariantChanges.apply(this,u);k=n?k.concat(x):k;}this._oVariantController.checkAndSetVariantContent(o,j&&j.technicalParameters);}if(!n&&!i(this._oVariantController.getChangeFileContent())){k=k.concat(this._oVariantController.loadInitialChanges());}var y=p&&p.includeVariants;var z=o.changes.contexts||[];return new Promise(function(D){b.getActiveContexts(z).then(function(E){D(k.filter(this._preconditionsFulfilled.bind(this,E,y)).map(h.bind(this,o)));}.bind(this));}.bind(this));}.bind(this));function g(v,o){var F;Object.keys(v).some(function(s){return v[s].variants.some(function(j){if(j.content.fileName===o.getDefinition().variantReference){F=j;return true;}});});return F;}function r(v,o){return v.controlChanges.some(function(j,k){if(j.fileName===o.getDefinition().fileName){v.controlChanges.splice(k,1,o);return true;}});}function h(F,o){var j;if(o instanceof C){j=o;this._mChangesEntries[j.getFileName()]=j;}else{if(!this._mChangesEntries[o.fileName]){this._mChangesEntries[o.fileName]=new C(o);}j=this._mChangesEntries[o.fileName];j.setState(C.states.PERSISTED);if(j.getVariantReference()){var v=this._oVariantController.getChangeFileContent();var k=g.call(this,v,j);if(k&&r(k,j)){a.setVariantManagementSection(this._mComponent,v);}}}return j;}};f.prototype._filterChangeForMaxLayer=function(o){if(U.isOverMaxLayer(this._getLayerFromChangeOrChangeContent(o))){if(!this._bHasChangesOverMaxLayer){this._bHasChangesOverMaxLayer=true;}return false;}return true;};f.prototype._filterChangeForCurrentLayer=function(l,o){return l===this._getLayerFromChangeOrChangeContent(o);};f.prototype._getLayerFromChangeOrChangeContent=function(o){var s;if(o instanceof V||o instanceof C){s=o.getLayer();}else{s=o.layer;}return s;};f.prototype._getAllCtrlVariantChanges=function(v,F,s){var g=[];var h=function(){return true;};if(F){h=this._filterChangeForMaxLayer.bind(this);}else if(typeof s==="string"&&s!==""){h=this._filterChangeForCurrentLayer.bind(this,s);}Object.keys(v).forEach(function(j){var o=v[j];o.variants=o.variants.filter(function(k){return!k.content.layer||h(k.content);});o.variants.forEach(function(k){if(Array.isArray(k.variantChanges.setVisible)){k.variantChanges.setVisible=k.variantChanges.setVisible.filter(h);var A=k.variantChanges.setVisible.slice(-1)[0];if(A&&!A.content.visible&&A.content.createdByReset){return;}g=g.concat(k.variantChanges.setVisible);}Object.keys(k.variantChanges).forEach(function(l){if(l!=="setVisible"){k.variantChanges[l]=k.variantChanges[l].filter(h);g=k.variantChanges[l].length>0?g.concat(k.variantChanges[l].slice(-1)[0]):g;}});g=(k.content.fileName!==j)?g.concat([k.content]):g;k.controlChanges=k.controlChanges.filter(h);g=g.concat(k.controlChanges);});Object.keys(o.variantManagementChanges).forEach(function(k){o.variantManagementChanges[k]=o.variantManagementChanges[k].filter(h);g=o.variantManagementChanges[k].length>0?g.concat(o.variantManagementChanges[k].slice(-1)[0]):g;});});return g;};f.prototype.getSmartVariantManagementChangeMap=function(){return this._mVariantsChanges;};f.prototype.getChangesForVariant=function(s,g,p){if(this._mVariantsChanges[g]){return Promise.resolve(this._mVariantsChanges[g]);}var h=function(o){var j=false;var k=o._oDefinition.selector;q.each(k,function(n,v){if(n===s&&v===g){j=true;}});return j;};var l=function(k,t){e.error("key : "+k+" and text : "+t.value);};return this.getChangesForComponent(p).then(function(j){return j.filter(h);}).then(function(j){if(!this._mVariantsChanges[g]){this._mVariantsChanges[g]={};}var I;j.forEach(function(o){I=o.getId();if(o.isValid()){if(this._mVariantsChanges[g][I]&&o.isVariant()){e.error("Id collision - two or more variant files having the same id detected: "+I);q.each(o.getDefinition().texts,l);e.error("already exists in variant : ");q.each(this._mVariantsChanges[g][I].getDefinition().texts,l);}this._mVariantsChanges[g][I]=o;}}.bind(this));return this._mVariantsChanges[g];}.bind(this));};f.prototype.addChangeForVariant=function(s,g,p){var F;var I;var h;var o;var j;if(!p){return undefined;}if(!p.type){e.error("sap.ui.fl.Persistence.addChange : type is not defined");}var k=q.type(p.content);if(k!=='object'&&k!=='array'){e.error("mParameters.content is not of expected type object or array, but is: "+k,"sap.ui.fl.Persistence#addChange");}h={};if(typeof(p.texts)==="object"){q.each(p.texts,function(l,t){h[l]={value:t,type:"XFLD"};});}var v={creation:this._mComponent.appVersion,from:this._mComponent.appVersion};if(this._mComponent.appVersion&&p.developerMode){v.to=this._mComponent.appVersion;}I={changeType:p.type,service:p.ODataService,texts:h,content:p.content,reference:this._mComponent.name,isVariant:p.isVariant,packageName:p.packageName,isUserDependent:p.isUserDependent,validAppVersions:v};I.selector={};I.selector[s]=g;F=C.createInitialFileContent(I);if(p.id){F.fileName=p.id;}o=new C(F);j=o.getId();if(!this._mVariantsChanges[g]){this._mVariantsChanges[g]={};}this._mVariantsChanges[g][j]=o;return o.getId();};f.prototype.saveAllChangesForVariant=function(s){var p=[];var t=this;q.each(this._mVariantsChanges[s],function(g,o){var h=o.getId();switch(o.getPendingAction()){case"NEW":p.push(t._oConnector.create(o.getDefinition(),o.getRequest(),o.isVariant()).then(function(r){o.setResponse(r.response);if(a.isActive()){a.addChange({name:t._mComponent.name,appVersion:t._mComponent.appVersion},r.response);}return r;}));break;case"UPDATE":p.push(t._oConnector.update(o.getDefinition(),o.getId(),o.getRequest(),o.isVariant()).then(function(r){o.setResponse(r.response);if(a.isActive()){a.updateChange({name:t._mComponent.name,appVersion:t._mComponent.appVersion},r.response);}return r;}));break;case"DELETE":p.push(t._oConnector.deleteChange({sChangeName:o.getId(),sLayer:o.getLayer(),sNamespace:o.getNamespace(),sChangelist:o.getRequest()},o.isVariant()).then(function(r){var o=t._mVariantsChanges[s][h];if(o.getPendingAction()==="DELETE"){delete t._mVariantsChanges[s][h];}if(a.isActive()){a.deleteChange({name:t._mComponent.name,appVersion:t._mComponent.appVersion},o.getDefinition());}return r;}));break;default:break;}});return Promise.all(p);};f.prototype._addChangeIntoMap=function(A,o){var s=o.getSelector();if(s&&s.id){var g=s.id;if(s.idIsLocal){g=A.createId(g);}this._addMapEntry(g,o);if(s.idIsLocal===undefined&&g.indexOf("---")!==-1){var h=g.split("---")[0];if(h!==A.getId()){g=g.split("---")[1];g=A.createId(g);this._addMapEntry(g,o);}}}return this._mChanges;};f.prototype._addMapEntry=function(s,o){if(!this._mChanges.mChanges[s]){this._mChanges.mChanges[s]=[];}if(this._mChanges.mChanges[s].indexOf(o)===-1){this._mChanges.mChanges[s].push(o);}if(this._mChanges.aChanges.indexOf(o)===-1){this._mChanges.aChanges.push(o);}};f.prototype._addDependency=function(D,o,r){var g=r?this._mChangesInitial:this._mChanges;if(!g.mDependencies[D.getId()]){g.mDependencies[D.getId()]={changeObject:D,dependencies:[]};}g.mDependencies[D.getId()].dependencies.push(o.getId());if(!g.mDependentChangesOnMe[o.getId()]){g.mDependentChangesOnMe[o.getId()]=[];}g.mDependentChangesOnMe[o.getId()].push(D.getId());};f.prototype._addControlsDependencies=function(D,g,r){var h=r?this._mChangesInitial:this._mChanges;if(g.length>0){if(!h.mDependencies[D.getId()]){h.mDependencies[D.getId()]={changeObject:D,dependencies:[],controlsDependencies:[]};}h.mDependencies[D.getId()].controlsDependencies=g;}};f.prototype.loadChangesMapForComponent=function(A,p){p.component=!i(A)&&A;return this.getChangesForComponent(p).then(g.bind(this));function g(h){this._mChanges={mChanges:{},mDependencies:{},mDependentChangesOnMe:{},aChanges:[]};h.forEach(this._addChangeAndUpdateDependencies.bind(this,A));this._mChangesInitial=m({},this._mChanges);return this.getChangesMapForComponent.bind(this);}};f.prototype.checkForOpenDependenciesForControl=function(s,o,A){return Object.keys(this._mChanges.mDependencies).some(function(k){return this._mChanges.mDependencies[k].changeObject.getDependentSelectorList().some(function(D){return D===o.getControlIdBySelector(s,A);});},this);};f.prototype.copyDependenciesFromInitialChangesMap=function(o,D){var I=m({},this._mChangesInitial.mDependencies);var g=I[o.getId()];if(g){var n=[];g.dependencies.forEach(function(s){if(D(s)){this._mChanges.mDependentChangesOnMe[s]=this._mChanges.mDependentChangesOnMe[s]||[];this._mChanges.mDependentChangesOnMe[s].push(o.getId());n.push(s);}}.bind(this));g.dependencies=n;this._mChanges.mDependencies[o.getId()]=g;}return this._mChanges;};f.prototype._addChangeAndUpdateDependencies=function(A,o){o.setInitialApplyState();this._addChangeIntoMap(A,o);this._updateDependencies(o,false);};f.prototype._addRunTimeCreatedChangeAndUpdateDependencies=function(A,o){this._addChangeIntoMap(A,o);this._updateDependencies(o,true);};f.prototype._updateDependencies=function(o,r){var g=this.getChangesMapForComponent().aChanges;var D=o.getDependentSelectorList();var h=o.getDependentControlSelectorList();this._addControlsDependencies(o,h,r);g.slice(0,g.length-1).reverse().forEach(function(E){var j=E.getDependentSelectorList();D.some(function(k){var l=U.indexOfObject(j,k);if(l>-1){this._addDependency(o,E,r);return true;}}.bind(this));}.bind(this));};f.prototype.getChangesMapForComponent=function(){return this._mChanges;};f.prototype.getChangesForView=function(v,p){var t=this;return this.getChangesForComponent(p).then(function(h){return h.filter(g.bind(t));});function g(o){var s=o.getSelector();if(!s){return false;}var h=s.id;if(!h||!p){return false;}var j=h.slice(0,h.lastIndexOf("--"));var v;if(o.getSelector().idIsLocal){var k=p.appComponent;if(k){v=k.getLocalId(p.viewId);}}else{v=p.viewId;}return j===v;}};f.prototype.addChange=function(v,A){var o=this.addDirtyChange(v);this._addRunTimeCreatedChangeAndUpdateDependencies(A,o);this._addPropagationListener(A);return o;};f.prototype.addDirtyChange=function(v){var n;if(v instanceof C||v instanceof V){n=v;}else{n=new C(v);}if(this._aDirtyChanges.indexOf(n)===-1){this._aDirtyChanges.push(n);}return n;};f.prototype._addPropagationListener=function(o){var A=U.getAppComponentForControl(o);if(A instanceof d){var g=function(p){return!p._bIsSapUiFlFlexControllerApplyChangesOnControl;};var n=A.getPropagationListeners().every(g);if(n){var h=A.getManifestObject();var v=U.getAppVersionFromManifest(h);var F=sap.ui.require("sap/ui/fl/FlexControllerFactory");var j=F.create(this.getComponentName(),v);var p=j.getBoundApplyChangesOnControl(this.getChangesMapForComponent.bind(this),A);A.addPropagationListener(p);}}};f.prototype.saveDirtyChanges=function(s){var D=this._aDirtyChanges.slice(0);var g=this._aDirtyChanges;var r=this._getRequests(D);var p=this._getPendingActions(D);if(p.length===1&&r.length===1&&p[0]==="NEW"){var R=r[0];var P=this._prepareDirtyChanges(g);return this._oConnector.create(P,R).then(function(o){this._massUpdateCacheAndDirtyState(g,D,s);return o;}.bind(this));}return this.saveSequenceOfDirtyChanges(D,s);};f.prototype.saveSequenceOfDirtyChanges=function(D,s){var A=this.getDirtyChanges();return D.reduce(function(p,o){return p.then(this._performSingleSaveAction(o)).then(this._updateCacheAndDirtyState.bind(this,A,o,s));}.bind(this),Promise.resolve());};f.prototype._performSingleSaveAction=function(D){return function(){if(D.getPendingAction()==="NEW"){return this._oConnector.create(D.getDefinition(),D.getRequest());}if(D.getPendingAction()==="DELETE"){return this._oConnector.deleteChange({sChangeName:D.getId(),sLayer:D.getLayer(),sNamespace:D.getNamespace(),sChangelist:D.getRequest()});}}.bind(this);};f.prototype._updateCacheAndDirtyState=function(D,o,s){if(!s){if(o.getPendingAction()==="NEW"){U.isChangeRelatedToVariants(o)?a.setVariantManagementSection(this._mComponent,m({},this._oVariantController.getChangeFileContent())):a.addChange(this._mComponent,o.getDefinition());}else if(o.getPendingAction()==="DELETE"){U.isChangeRelatedToVariants(o)?a.setVariantManagementSection(this._mComponent,m({},this._oVariantController.getChangeFileContent())):a.deleteChange(this._mComponent,o.getDefinition());}}var I=D.indexOf(o);if(I>-1){D.splice(I,1);}};f.prototype._massUpdateCacheAndDirtyState=function(D,g,s){g.forEach(function(o){this._updateCacheAndDirtyState(D,o,s);},this);};f.prototype._getRequests=function(D){var r=[];D.forEach(function(o){var R=o.getRequest();if(r.indexOf(R)===-1){r.push(R);}});return r;};f.prototype._getPendingActions=function(D){var p=[];D.forEach(function(o){var P=o.getPendingAction();if(p.indexOf(P)===-1){p.push(P);}});return p;};f.prototype._prepareDirtyChanges=function(D){var g=[];D.forEach(function(o){g.push(o.getDefinition());});return g;};f.prototype.getDirtyChanges=function(){return this._aDirtyChanges;};f.prototype.deleteChange=function(o,r){var n=this._aDirtyChanges.indexOf(o);if(n>-1){if(o.getPendingAction()==="DELETE"){return;}this._aDirtyChanges.splice(n,1);this._deleteChangeInMap(o,r);return;}o.markForDeletion();this.addDirtyChange(o);this._deleteChangeInMap(o,r);};f.prototype._deleteChangeInMap=function(o,r){var s=o.getId();var g=this._mChanges.mChanges;var h=r?this._mChangesInitial:this._mChanges;var D=h.mDependencies;var j=h.mDependentChangesOnMe;Object.keys(g).some(function(k){var l=g[k];var n=l.map(function(E){return E.getId();}).indexOf(o.getId());if(n!==-1){l.splice(n,1);return true;}});Object.keys(D).forEach(function(k){if(k===s){delete D[k];}else if(D[k].dependencies&&Array.isArray(D[k].dependencies)&&D[k].dependencies.indexOf(s)!==-1){D[k].dependencies.splice(D[k].dependencies.indexOf(s),1);if(D[k].dependencies.length===0){delete D[k];}}});Object.keys(j).forEach(function(k){if(k===s){delete j[k];}else if(Array.isArray(j[k])&&j[k].indexOf(s)!==-1){j[k].splice(j[k].indexOf(s),1);if(j[k].length===0){delete j[k];}}});var I=this._mChanges.aChanges.indexOf(o);if(I!==-1){this._mChanges.aChanges.splice(I,1);}};f.prototype.loadSwitchChangesMapForComponent=function(p){p.changesMap=this._mChanges.mChanges;return this._oVariantController.getChangesForVariantSwitch(p);};f.prototype.transportAllUIChanges=function(r,s,l,A){var h=function(E){B.hide();var R=sap.ui.getCore().getLibraryResourceBundle("sap.ui.fl");var g=R.getText("MSG_TRANSPORT_ERROR",E?[E.message||E]:undefined);var t=R.getText("HEADER_TRANSPORT_ERROR");e.error("transport error"+E);M.show(g,{icon:M.Icon.ERROR,title:t,styleClass:s});return"Error";};return this._oTransportSelection.openTransportSelection(null,r,s).then(function(t){if(this._oTransportSelection.checkTransportInfo(t)){B.show(0);return this.getChangesForComponent({currentLayer:l,includeCtrlVariants:true}).then(function(g){var o={reference:this.getComponentName(),appVersion:this._mComponent.appVersion,layer:l};return this._oTransportSelection._prepareChangesForTransport(t,g,A,o).then(function(){B.hide();});}.bind(this));}return"Cancel";}.bind(this))['catch'](h);};f.prototype._getChangesFromMapByNames=function(n){return this._mChanges.aChanges.filter(function(o){return n.indexOf(o.getFileName())!==-1;});};f.prototype.resetChanges=function(l,g,s,h){var j=[];var t;var k=s&&s.length>0;var n=h&&h.length>0;if(!g&&!k&&!n){e.error("Of the generator, selector IDs and change types parameters at least one has to filled");return Promise.reject("Of the generator, selector IDs and change types parameters at least one has to filled");}if(l==="USER"){t=Promise.resolve();}else{t=this.getChangesForComponent({currentLayer:l,includeCtrlVariants:true}).then(function(o){j=o;return S.getInstance(this.getComponentName());}.bind(this)).then(function(o){if(!o.isProductiveSystem()){return this._oTransportSelection.setTransports(j,d.get(this.getComponentName()));}}.bind(this));}return t.then(function(){var o="";j.some(function(r){if(r.getRequest()){o=r.getRequest();return true;}return false;});var p={sReference:this.getComponentName(),sAppVersion:this._mComponent.appVersion,sLayer:l,sChangelist:o};if(g){p.sGenerator=g;}if(k){p.aSelectorIds=s;}if(n){p.aChangeTypes=h;}return this._oConnector.resetChanges(p);}.bind(this)).then(function(r){var o=[];if(s||h){var N=[];if(r&&r.response&&r.response.length>0){r.response.forEach(function(p){N.push(p.name);});}a.removeChanges(this._mComponent,N);o=this._getChangesFromMapByNames(N);}return o;}.bind(this));};f.prototype.resetVariantMap=function(r){return this._oVariantController.resetMap(r);};return f;},true);
