/*!
 * OpenUI5
 * (c) Copyright 2009-2019 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["sap/ui/fl/Utils","sap/ui/thirdparty/jquery","sap/ui/fl/registry/ChangeRegistryItem","sap/ui/fl/registry/ChangeTypeMetadata","sap/ui/fl/registry/Settings","sap/ui/fl/changeHandler/HideControl","sap/ui/fl/changeHandler/MoveElements","sap/ui/fl/changeHandler/MoveControls","sap/ui/fl/changeHandler/PropertyChange","sap/ui/fl/changeHandler/PropertyBindingChange","sap/ui/fl/changeHandler/UnhideControl","sap/ui/fl/changeHandler/StashControl","sap/ui/fl/changeHandler/UnstashControl","sap/ui/fl/changeHandler/AddXML","sap/base/Log"],function(U,q,C,a,S,H,M,b,P,c,d,e,f,A,L){"use strict";var g=function(){this._registeredItems={};this.initSettings();this.initDeveloperModeChangeHandlers();};g._instance=undefined;g.prototype._oDefaultActiveChangeHandlers={};g.prototype._oDefaultChangeHandlers={hideControl:H,moveElements:M,moveControls:b,unhideControl:d,stashControl:e,unstashControl:f};g.prototype._mDeveloperModeChangeHandlers={propertyChange:{changeHandler:P},propertyBindingChange:{changeHandler:c},addXML:{changeHandler:A}};g.prototype.initDeveloperModeChangeHandlers=function(){Object.keys(this._mDeveloperModeChangeHandlers).forEach(function(s){var o=this._mDeveloperModeChangeHandlers[s].changeHandler;var l=this._oSettings.getDeveloperModeLayerPermissions();var h={changeType:s,changeHandler:o,layers:l};var i=this._createChangeRegistryItemForSimpleChange("defaultActiveForAllControls",h);this._oDefaultActiveChangeHandlers[s]=i;}.bind(this));};g.getInstance=function(){if(!g._instance){g._instance=new g();}return g._instance;};g.prototype.hasRegisteredChangeHandlersForControl=function(s){var h=Object.keys(this._registeredItems);return h.indexOf(s)!==-1;};g.prototype.hasChangeHandlerForControlAndChange=function(s,h){if(!this.hasRegisteredChangeHandlersForControl(s)){return false;}var r=this._registeredItems[s];var i=Object.keys(r);return i.indexOf(h)!==-1;};g.prototype.registerControlsForChanges=function(m){var p=[];q.each(m,function(s,v){var h={};if(Array.isArray(v)){v.forEach(function(o){h[o.changeType]=o.changeHandler;});}else{h=v;}p.push(this._registerChangeHandlersForControl(s,h));}.bind(this));return Promise.all(p);};g.prototype._registerChangeHandlersForControl=function(s,o){var p=Promise.resolve(o);var h="ChangeRegistry._registerChangeHandlersForControl.skip_next_then";if(typeof o==="string"){p=U.requireAsync(o+".flexibility").catch(function(E){L.error("Flexibility change handler registration failed.\nControlType: "+s+"\n"+E.message);return Promise.resolve(h);});}return p.then(function(r){if(r!==h){q.each(r,function(i,j){var k=this._getChangeHandlerEntry(i,j);var l={changeType:i,changeHandler:k.changeHandler,layers:k.layers};this.registerControlForSimpleChange(s,l);}.bind(this));}}.bind(this));};g.prototype._getInstanceSpecificChangeRegistryItem=function(s,o,m){var h=m.getChangeHandlerModulePath(o);if(typeof h!=="string"){return new U.FakePromise(undefined);}return U.requireAsync(h).then(function(i){var v=i[s];if(!v){return undefined;}var j=this._getChangeHandlerEntry(s,v);var k={changeType:s,changeHandler:j.changeHandler,layers:j.layers};var l=m.getControlType(o);var n=this._createChangeRegistryItemForSimpleChange(l,k);return n;}.bind(this)).catch(function(E){L.error("Flexibility registration for control "+m.getId(o)+" failed to load module "+h+"\n"+E.message);return undefined;});};g.prototype._getChangeHandlerEntry=function(s,v){var r={};var D=Object.keys(this._mDeveloperModeChangeHandlers);if(!v||!v.changeHandler){r.changeHandler=v;}else{r=v;}if(r.changeHandler==="default"){r.changeHandler=this._oDefaultChangeHandlers[s];}else if(D.indexOf(s)>-1){throw new Error("You can't use a custom change handler for the following Developer Mode change types: "+D.toString()+". Please use 'default' instead.");}return r;};g.prototype._getChangeRegistryItem=function(s,h,l){var m;if(!s||!h){return undefined;}m=this.getRegistryItems({changeTypeName:s,controlType:h,layer:l});if(m&&m[h]&&m[h][s]){return m[h][s];}else if(m&&m[h]){return m[h];}return m;};g.prototype.getChangeHandler=function(s,h,o,m,l){return this._getInstanceSpecificChangeRegistryItem(s,o,m).then(function(i){if(i&&i.getChangeTypeMetadata){var j=i.getChangeTypeMetadata().getChangeHandler();if(j){return j;}}var k=this._getChangeRegistryItem(s,h,l);if(k&&k.getChangeTypeMetadata){var O=k.getChangeTypeMetadata().getChangeHandler();if(O){return O;}}return undefined;}.bind(this));};g.prototype.registerControlForSimpleChange=function(s,o){var h;if(!s){return;}if(!o||!o.changeType||!o.changeHandler){return;}h=this._createChangeRegistryItemForSimpleChange(s,o);if(h){this.addRegistryItem(h);}};g.prototype._createChangeRegistryItemForSimpleChange=function(s,o){var p;var h;var i;var l;l=Object.assign({},this._oSettings.getDefaultLayerPermissions());var j=o.layers;if(j){Object.keys(j).forEach(function(k){if(l[k]===undefined){throw new Error("The Layer '"+k+"' is not supported. Please only use supported layers");}l[k]=j[k];});}p={name:o.changeType,changeHandler:o.changeHandler,layers:l};h=new a(p);p={changeTypeMetadata:h,controlType:s};i=new C(p);return i;};g.prototype.addRegistryItem=function(r){var s;var h;if(!r){return;}s=r.getChangeTypeName();h=r.getControlType();this._registeredItems[h]=this._registeredItems[h]||{};this._registeredItems[h][s]=r;};g.prototype.removeRegistryItem=function(p){if(!p.changeTypeName&&!p.controlType){L.error("sap.ui.fl.registry.ChangeRegistry: ChangeType and/or ControlType required");return;}if(p.controlType&&p.changeTypeName){if(this._registeredItems[p.controlType]){if(Object.keys(this._registeredItems[p.controlType]).length===1){delete this._registeredItems[p.controlType];}else{delete this._registeredItems[p.controlType][p.changeTypeName];}}}else if(p.controlType){if(this._registeredItems[p.controlType]){delete this._registeredItems[p.controlType];}}else if(p.changeTypeName){for(var h in this._registeredItems){var i=this._registeredItems[h];delete i[p.changeTypeName];}}};g.prototype.getRegistryItems=function(p){if(!p){L.error("sap.ui.fl.registry.ChangeRegistry: no parameters passed for getRegistryItems");}var s=p.changeTypeName;var h=p.controlType;if(!s&&!h){L.error("sap.ui.fl.registry.ChangeRegistry: Change Type Name and/or Control Type required");}var r=null;if(h&&s){var o=this._getOrLoadChangeHandler(h,s);if(o){r={};r[h]={};r[h][s]=o;}}else if(h){r={};r[h]={};if(this._registeredItems[h]){var i=Object.keys(this._registeredItems[h]);i.forEach(function(s){r[h][s]=this._getOrLoadChangeHandler(h,s);}.bind(this));}for(var k in this._oDefaultActiveChangeHandlers){r[h][k]=this._oDefaultActiveChangeHandlers[k];}}else if(s){r={};for(h in this._registeredItems){if(this._registeredItems[h][s]){r[h]={};r[h][s]=this._getOrLoadChangeHandler(h,s);}}r["defaultActiveForAllControls"]={};for(var j in this._oDefaultActiveChangeHandlers){r["defaultActiveForAllControls"][j]=this._oDefaultActiveChangeHandlers[j];}}this._filterChangeTypes(r,p.layer);return r;};g.prototype._getOrLoadChangeHandler=function(s,h){var o=this._registeredItems[s];if(o){var i=o[h];if(i){var j=i.getChangeTypeMetadata();var k=j.getChangeHandler();if(typeof k==="string"){k=sap.ui.requireSync(k.replace(/\./g,"/"));j._changeHandler=k;}return i;}}var D=this._oDefaultActiveChangeHandlers[h];if(D){return D;}return null;};g.prototype.initSettings=function(){this._oSettings=S.getInstanceOrUndef();if(!this._oSettings){this._oSettings=new S({});}};g.prototype._filterChangeTypes=function(r,l){if(this._oSettings&&l&&r){var i=false;q.each(r,function(s,o){q.each(o,function(h,R){var j=R.getChangeTypeMetadata().getLayers();i=j[l];if(!i){L.warning("Change type "+h+" not enabled for layer "+l);delete o[h];}});});}};g.prototype.getDragInfo=function(s){var h=this._registeredItems[s];if(h){return h.getDragInfo();}return null;};return g;},true);
