/*!
 * OpenUI5
 * (c) Copyright 2009-2019 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["sap/ui/rta/plugin/Plugin","sap/ui/rta/Utils","sap/ui/dt/Util","sap/base/Log"],function(P,U,D,B){"use strict";var S=P.extend("sap.ui.rta.plugin.Settings",{metadata:{library:"sap.ui.rta",properties:{commandStack:{type:"any"}},associations:{},events:{}}});S.prototype._isEditable=function(o){var s=this.getAction(o);if(s){if(s.handler){return this.hasStableId(o);}var h=Object.keys(s).some(function(a){var b=s[a];return b.handler&&this._checkRelevantContainerStableID(b,o);}.bind(this));if(h){return this.hasStableId(o);}}return false;};S.prototype.isEnabled=function(e){var E=e[0];var a=this.getAction(E);if(!a){return false;}if(typeof a.isEnabled!=="undefined"){if(typeof a.isEnabled==="function"){return a.isEnabled(E.getElement());}return a.isEnabled;}return true;};S.prototype._getUnsavedChanges=function(i,c){var e;var u=this.getCommandStack().getAllExecutedCommands().filter(function(C){e=C.getElementId&&C.getElementId()||C.getElement&&C.getElement().getId();if(e===i&&c.indexOf(C.getChangeType())>=0){return true;}}).map(function(C){return C.getPreparedChange();});return u;};S.prototype._handleFlexChangeCommand=function(c,s,C){var m=c.changeSpecificData;var v;var a=c.selectorElement||c.selectorControl;var b;var o;if(a.controlType){b=a.controlType;}else{o=a;}return this._getChangeHandler(m.changeType,o,b).then(function(d){if(s[0].getVariantManagement&&d&&d.revertChange){v=s[0].getVariantManagement();}return this.getCommandFactory().getCommandFor(a,"settings",m,undefined,v);}.bind(this)).then(function(d){return C.addCommand(d);});};S.prototype._handleAppDescriptorChangeCommand=function(c,e,C){var m=c.changeSpecificData;var o=c.appComponent;var M=o.getManifest();var r=M["sap.app"].id;return this.getCommandFactory().getCommandFor(e,"appDescriptor",{reference:r,appComponent:o,changeType:m.appDescriptorChangeType,parameters:m.content.parameters,texts:m.content.texts}).then(function(a){return C.addCommand(a);});};S.prototype._handleCompositeCommand=function(e,E,c){var C;return this.getCommandFactory().getCommandFor(E,"composite").then(function(_){C=_;}).then(function(){return c.map(function(m){var a=m.changeSpecificData;if(a.changeType){return this._handleFlexChangeCommand(m,e,C);}else if(a.appDescriptorChangeType){return this._handleAppDescriptorChangeCommand(m,E,C);}},this);}.bind(this)).then(function(p){return Promise.all(p);}).then(function(){if(C.getCommands().length>0){this.fireElementModified({command:C});}}.bind(this));};S.prototype.handler=function(e,p){p=p||{};var E=e[0].getElement();var h=p.fnHandler;if(!h){h=e[0].getDesignTimeMetadata().getAction("settings").handler;if(!h){throw new Error("Handler not found for settings action");}}p.getUnsavedChanges=this._getUnsavedChanges.bind(this);p.styleClass=U.getRtaStyleClassName();return h(E,p).then(function(c){if(c.length>0){return this._handleCompositeCommand(e,E,c);}}.bind(this)).catch(function(v){throw D.propagateError(v,"Settings#handler","Error occured during handler execution","sap.ui.rta.plugin");});};S.prototype.getMenuItems=function(e){var E=e[0];var s=this.getAction(E);var r=110;var p="CTX_SETTINGS";if(s){if(s.handler&&this._checkRelevantContainerStableID(s,E)){return this._getMenuItems([E],{pluginId:p,rank:r,icon:this._getActionIcon(s)});}var m=[];var a=Object.keys(s);var A=0;a.forEach(function(b){var o=s[b];var c=this.getActionText(E,o,o.name);if(o.handler&&this._checkRelevantContainerStableID(o,E)){m.push({id:p+A,text:c,icon:this._getActionIcon(o),enabled:(typeof o.isEnabled==='function'&&(function(e){return o.isEnabled(e[0].getElement());})||o.isEnabled),handler:function(h,e,d){d=d||{};d.fnHandler=h;return this.handler(e,d);}.bind(this,o.handler),rank:r+A});A++;}else{B.warning("Handler not found for settings action '"+c+"' or relevant container has no stable id");}},this);return m;}return[];};S.prototype._getActionIcon=function(s){var d="sap-icon://key-user-settings";var a=s.icon;if(!a){return d;}if(typeof a!=="string"){B.error("Icon setting for settingsAction should be a string");return d;}return a;};S.prototype.getActionName=function(){return"settings";};return S;},true);
