/*!
 * OpenUI5
 * (c) Copyright 2009-2019 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(['sap/ui/Device','sap/ui/core/Control','sap/ui/core/Element','sap/ui/core/IconPool','sap/ui/core/util/PasteHelper','sap/ui/model/ChangeReason','sap/ui/model/Filter','sap/ui/model/Sorter','sap/ui/model/BindingMode','./Column','./Row','./library','./TableUtils','./TableExtension','./TableAccExtension','./TableKeyboardExtension','./TablePointerExtension','./TableScrollExtension','./TableDragAndDropExtension',"./TableRenderer","./rowmodes/FixedRowMode","./rowmodes/InteractiveRowMode","./rowmodes/AutoRowMode","./plugins/SelectionModelPlugin","sap/ui/thirdparty/jquery","sap/base/Log"],function(D,C,E,I,P,a,F,S,B,b,R,c,T,d,e,f,g,h,j,k,m,n,A,o,q,L){"use strict";var G=c.GroupEventType,N=c.NavigationMode,p=c.SelectionMode,r=c.SelectionBehavior,s=c.SortOrder,V=c.VisibleRowCountMode;var t=C.extend("sap.ui.table.Table",{metadata:{library:"sap.ui.table",dnd:true,properties:{width:{type:"sap.ui.core.CSSSize",group:"Dimension",defaultValue:'auto'},rowHeight:{type:"int",group:"Appearance",defaultValue:null},columnHeaderHeight:{type:"int",group:"Appearance",defaultValue:null},columnHeaderVisible:{type:"boolean",group:"Appearance",defaultValue:true},visibleRowCount:{type:"int",group:"Appearance",defaultValue:10},firstVisibleRow:{type:"int",group:"Appearance",defaultValue:0},selectionMode:{type:"sap.ui.table.SelectionMode",group:"Behavior",defaultValue:p.MultiToggle},selectionBehavior:{type:"sap.ui.table.SelectionBehavior",group:"Behavior",defaultValue:r.RowSelector},selectedIndex:{type:"int",group:"Appearance",defaultValue:-1},editable:{type:"boolean",group:"Behavior",defaultValue:true},navigationMode:{type:"sap.ui.table.NavigationMode",group:"Behavior",defaultValue:N.Scrollbar,deprecated:true},threshold:{type:"int",group:"Appearance",defaultValue:100},enableColumnReordering:{type:"boolean",group:"Behavior",defaultValue:true},enableGrouping:{type:"boolean",group:"Behavior",defaultValue:false},showColumnVisibilityMenu:{type:"boolean",group:"Appearance",defaultValue:false},showNoData:{type:"boolean",group:"Appearance",defaultValue:true},visibleRowCountMode:{type:"sap.ui.table.VisibleRowCountMode",group:"Appearance",defaultValue:V.Fixed},minAutoRowCount:{type:"int",group:"Appearance",defaultValue:5},fixedColumnCount:{type:"int",group:"Appearance",defaultValue:0},fixedRowCount:{type:"int",group:"Appearance",defaultValue:0},fixedBottomRowCount:{type:"int",group:"Appearance",defaultValue:0},enableColumnFreeze:{type:"boolean",group:"Behavior",defaultValue:false},enableCellFilter:{type:"boolean",group:"Behavior",defaultValue:false},showOverlay:{type:"boolean",group:"Appearance",defaultValue:false},enableSelectAll:{type:"boolean",group:"Behavior",defaultValue:true},enableCustomFilter:{type:"boolean",group:"Behavior",defaultValue:false},enableBusyIndicator:{type:"boolean",group:"Behavior",defaultValue:false},rowActionCount:{type:"int",group:"Appearance",defaultValue:0},alternateRowColors:{type:"boolean",group:"Appearance",defaultValue:false}},defaultAggregation:"columns",aggregations:{title:{type:"sap.ui.core.Control",altTypes:["string"],multiple:false},footer:{type:"sap.ui.core.Control",altTypes:["string"],multiple:false},toolbar:{type:"sap.ui.core.Toolbar",multiple:false,deprecated:true},extension:{type:"sap.ui.core.Control",multiple:true,singularName:"extension"},columns:{type:"sap.ui.table.Column",multiple:true,singularName:"column",bindable:"bindable",dnd:{layout:"Horizontal"}},rows:{type:"sap.ui.table.Row",multiple:true,singularName:"row",bindable:"bindable",selector:"#{id}-tableCCnt",dnd:true},rowMode:{type:"sap.ui.core.Element",multiple:false,visibility:"hidden"},creationRow:{type:"sap.ui.core.Control",multiple:false,visibility:"hidden"},noData:{type:"sap.ui.core.Control",altTypes:["string"],multiple:false},rowActionTemplate:{type:"sap.ui.table.RowAction",multiple:false},rowSettingsTemplate:{type:"sap.ui.table.RowSettings",multiple:false},contextMenu:{type:"sap.ui.core.IContextMenu",multiple:false},plugins:{type:"sap.ui.table.plugins.SelectionPlugin",multiple:true,singularName:"plugin"}},associations:{groupBy:{type:"sap.ui.table.Column",multiple:false},ariaLabelledBy:{type:"sap.ui.core.Control",multiple:true,singularName:"ariaLabelledBy"}},events:{rowSelectionChange:{parameters:{rowIndex:{type:"int"},rowContext:{type:"object"},rowIndices:{type:"int[]"},selectAll:{type:"boolean"},userInteraction:{type:"boolean"}}},columnSelect:{allowPreventDefault:true,parameters:{column:{type:"sap.ui.table.Column"}}},columnResize:{allowPreventDefault:true,parameters:{column:{type:"sap.ui.table.Column"},width:{type:"sap.ui.core.CSSSize"}}},columnMove:{allowPreventDefault:true,parameters:{column:{type:"sap.ui.table.Column"},newPos:{type:"int"}}},sort:{allowPreventDefault:true,parameters:{column:{type:"sap.ui.table.Column"},sortOrder:{type:"sap.ui.table.SortOrder"},columnAdded:{type:"boolean"}}},filter:{allowPreventDefault:true,parameters:{column:{type:"sap.ui.table.Column"},value:{type:"string"}}},group:{allowPreventDefault:true,parameters:{column:{type:"sap.ui.table.Column"}}},columnVisibility:{allowPreventDefault:true,parameters:{column:{type:"sap.ui.table.Column"},newVisible:{type:"boolean"}}},cellClick:{allowPreventDefault:true,parameters:{cellControl:{type:"sap.ui.core.Control"},cellDomRef:{type:"Object"},rowIndex:{type:"int"},columnIndex:{type:"int"},columnId:{type:"string"},rowBindingContext:{type:"sap.ui.model.Context"}}},cellContextmenu:{allowPreventDefault:true,parameters:{cellControl:{type:"sap.ui.core.Control"},cellDomRef:{type:"Object"},rowIndex:{type:"int"},columnIndex:{type:"int"},columnId:{type:"string"},rowBindingContext:{type:"sap.ui.model.Context"}},deprecated:true},beforeOpenContextMenu:{allowPreventDefault:true,parameters:{rowIndex:{type:"int"},columnIndex:{type:"int"},contextMenu:{type:"sap.ui.core.IContextMenu"}}},columnFreeze:{allowPreventDefault:true,parameters:{column:{type:"sap.ui.table.Column"}}},customFilter:{column:{type:"sap.ui.table.Column"},value:{type:"string"}},firstVisibleRowChanged:{firstVisibleRow:{type:"int"}},busyStateChanged:{busy:{type:"boolean"}},paste:{allowPreventDefault:true,parameters:{data:{type:"string[][]"}}}},designtime:"sap/ui/table/designtime/Table.designtime"}});I.insertFontFaceStyle();t.prototype.init=function(){this.mSkipPropagation={rowActionTemplate:true,rowSettingsTemplate:true};this._attachExtensions();this._bRtlMode=sap.ui.getCore().getConfiguration().getRTL();this._bIsFlexItem=false;this._bBindingReady=false;this._bContextsAvailable=false;this._aRowClones=[];this._bRowAggregationInvalid=true;this._mTimeouts={};this._mAnimationFrames={};this._bHideStandardTooltips=false;this._aRowHeights=[];this._iRenderedFirstVisibleRow=0;this._aSortedColumns=[];this._aTableHeaders=[];this._bAllowColumnHeaderTextSelection=false;this._iPendingRequests=0;this._bPendingRequest=false;this._iBindingLength=null;this._bFirstRendering=true;this._nDevicePixelRatio=window.devicePixelRatio;if(sap.ui.getCore().isThemeApplied()){T.readThemeParameters();}this._bInvalid=true;};t.prototype.applySettings=function(l,x){if(l){var y=["rowMode","plugins"];var _={};for(var i=0;i<y.length;i++){var z=y[i];if(z in l){_[z]=l[z];delete l[z];}}C.prototype.applySettings.call(this,_,x);}this._initLegacyRowMode();this._initLegacySelectionPlugin();C.prototype.applySettings.call(this,l,x);};t.prototype._attachExtensions=function(){if(this._bExtensionsInitialized){return;}d.enrich(this,g);d.enrich(this,h);d.enrich(this,f);d.enrich(this,e);d.enrich(this,j);this._bExtensionsInitialized=true;};t.prototype.exit=function(){this.invalidateRowsAggregation();this._detachExtensions();this._destroyLegacyRowMode();this._destroyLegacySelectionPlugin();if(this._dataReceivedHandlerId){clearTimeout(this._dataReceivedHandlerId);delete this._dataReceivedHandlerId;}this._cleanUpTimers();this._detachEvents();delete this._aTableHeaders;};t.prototype._detachExtensions=function(){d.cleanup(this);};t.prototype.onpaste=function(i){if(i.isMarked()||/^(input|textarea)$/i.test(i.target.tagName)||!this.getDomRef("sapUiTableCnt").contains(i.target)){return;}var l=P.getPastedDataAs2DArray(i.originalEvent);if(l.length===0||l[0].length===0){return;}this.firePaste({data:l});};t.prototype.onThemeChanged=function(){T.readThemeParameters();if(this.getDomRef()){this.invalidate();}};t.prototype.onlocalizationChanged=function(i){var l=i.changes||{};var x=l.hasOwnProperty("rtl");var y=l.hasOwnProperty("language");this._adaptLocalization(x,y).then(function(){this.invalidate();}.bind(this));};t.prototype._adaptLocalization=function(i,l){if(!i&&!l){return Promise.reject();}var x=Promise.resolve();if(i){this._bRtlMode=sap.ui.getCore().getConfiguration().getRTL();}if(l){x=T.getResourceBundle({async:true,reload:true});}return x.then(function(){if(l){T.Menu.cleanupDataCellContextMenu(this);this._invalidateColumnMenus();}}.bind(this));};t.prototype._collectRowHeights=function(H){var l=this.getDomRef();if(!l){return[];}var x=this._getBaseRowHeight();var y=H?".sapUiTableColHdrTr":".sapUiTableTr";var z=l.querySelectorAll(".sapUiTableCtrlFixed > tbody > tr"+y);var J=l.querySelectorAll(".sapUiTableCtrlScroll > tbody > tr"+y);var K=this.getRows().length;var M=[];var O=D.browser.chrome&&window.devicePixelRatio!=1;if(H){if(this.getColumnHeaderHeight()>0){x=this.getColumnHeaderHeight();}else if(this.getRowMode()){x=this._getDefaultRowHeight();}}for(var i=0;i<K;i++){var Q=z[i]?z[i].getBoundingClientRect().height:0;var U=J[i]?J[i].getBoundingClientRect().height:0;var W=Math.max(Q,U);if(O){var X=x-W;if(X>0&&X<1){M.push(Math.max(W,x-1));continue;}}M.push(Math.max(W,x));}if(M.length>0&&!H){T.dynamicCall(this._getSyncExtension,function(Y){var Z=Y.syncRowHeights(M.slice());if(Z&&Z.length===M.length){M=Z.slice();}});}return M;};t.prototype._resetRowHeights=function(){var l=this._getBaseRowHeight();var x="";if(l){x=l+"px";}var y=this.getDomRef("tableCCnt");if(y){var z=y.querySelectorAll(".sapUiTableTr");for(var i=0;i<z.length;i++){z[i].style.height=x;}}};t.prototype._resetColumnHeaderHeights=function(){var l=this.getDomRef();if(l){var x=l.querySelectorAll(".sapUiTableColHdrTr");for(var i=0;i<x.length;i++){x[i].style.height=null;}}};t.prototype._collectTableSizes=function(){var l={tableCtrlScrollWidth:0,tableRowHdrScrWidth:0,tableCtrlScrWidth:0,tableHSbScrollLeft:0,tableCtrlFixedWidth:0,tableCntHeight:0,tableCntWidth:0};var x=this.getDomRef();if(!x){return l;}var y=x.querySelector(".sapUiTableCnt");if(y){l.tableCntHeight=y.clientHeight;l.tableCntWidth=y.clientWidth;}var z=x.querySelector(".sapUiTableCtrlScroll:not(.sapUiTableCHT)");if(z){l.tableCtrlScrollWidth=z.clientWidth;}var H=x.querySelector(".sapUiTableRowHdrScr");if(H){l.tableRowHdrScrWidth=H.clientWidth;}var J=x.querySelector(".sapUiTableCtrlScr:not(.sapUiTableCHA)");if(J){l.tableCtrlScrWidth=J.clientWidth;}var K=this._getScrollExtension().getHorizontalScrollbar();if(K){l.tableHSbScrollLeft=K.scrollLeft;}var M=x.querySelector(".sapUiTableCtrlScrFixed:not(.sapUiTableCHA) > .sapUiTableCtrlFixed");if(M){l.tableCtrlFixedWidth=M.clientWidth;}var O=this.getFixedColumnCount();var Q=0;if(O){var U=this.getColumns();var W=x.querySelectorAll(".sapUiTableCtrlFirstCol:not(.sapUiTableCHTHR) > th");for(var i=0;i<W.length;i++){var X=parseInt(W[i].getAttribute("data-sap-ui-headcolindex"));if(!isNaN(X)&&(X<O)){var Y=U[X];var Z;if(Y._iFixWidth!=null){Z=Y._iFixWidth;}else{Z=W[i].getBoundingClientRect().width;}Q+=Z;}}}if(Q>0){var $=this._getScrollExtension();var _=l.tableRowHdrScrWidth;var a1=$.getVerticalScrollbar();if(a1&&!$.isVerticalScrollbarExternal()){_+=a1.offsetWidth;}if(T.hasRowActions(this)){var b1=this.getDomRef("sapUiTableRowActionScr");if(b1){_+=b1.offsetWidth;}}_+=T.Column.getMinColumnWidth();var c1=l.tableCntWidth-_;var d1=c1>Q;var e1=!d1;if(this._bIgnoreFixedColumnCount!==e1){this._bIgnoreFixedColumnCount=e1;if(this.getEnableColumnFreeze()){this._invalidateColumnMenus();}this.invalidate();}}return l;};t.prototype._updateRowHeights=function(i,H){var l=this.getDomRef();if(!l){return;}function x(O,Q){var U=i[Q];if(U){O.style.height=U+"px";}}var y=H?".sapUiTableColHdrTr":".sapUiTableTr";var z=H?[]:l.querySelectorAll(".sapUiTableRowSelectionCell");var J=H?[]:l.querySelectorAll(".sapUiTableRowActionCell");var K=l.querySelectorAll(".sapUiTableCtrlFixed > tbody > tr"+y);var M=l.querySelectorAll(".sapUiTableCtrlScroll > tbody > tr"+y);Array.prototype.forEach.call(z,x);Array.prototype.forEach.call(J,x);Array.prototype.forEach.call(K,x);Array.prototype.forEach.call(M,x);};t.prototype.onBeforeRendering=function(i){this._detachEvents();if(i&&i.isMarked("renderRows")){return;}this._cleanUpTimers();this.getBinding("rows");this._aTableHeaders=[];};t.prototype.onAfterRendering=function(i){var l=i&&i.isMarked("renderRows");this._bInvalid=false;this._attachEvents();this._initRowDomRefs();if(!this._bAllowColumnHeaderTextSelection&&!l){this._disableTextSelection(this.$().find(".sapUiTableColHdrCnt"));}this.getDomRef().classList.remove("sapUiTableRActFlexible");if(!l){this._aTableHeaders=this.$().find(".sapUiTableColHdrCnt th");}this._updateTableSizes(T.RowsUpdateReason.Render,true);T.registerResizeHandler(this,"Table",this._onTableResize.bind(this));this._bFirstRendering=false;};t.prototype.invalidate=function(){this._bInvalid=true;T.Column.invalidateColumnUtils(this);return C.prototype.invalidate.call(this);};t.prototype._initRowDomRefs=function(){var l=this.getRows();for(var i=0;i<l.length;i++){l[i].initDomRefs();}};t.prototype._updateTableSizes=function(l,x){x=x===true;var y=this.getDomRef();if(this._bInvalid||!y||!sap.ui.getCore().isThemeApplied()||y.offsetWidth===0){return;}if(!x){this._resetRowHeights();this._resetColumnHeaderHeights();}this._aRowHeights=this._collectRowHeights(false);var z=this._collectRowHeights(true);if(T.isVariableRowHeightEnabled(this)&&!T.isNoDataVisible(this)){this._getScrollExtension().updateInnerVerticalScrollPosition();}function H(a1){var b1=a1.getDomRef();var c1=T.Column.getMinColumnWidth();var d1=[];var e1=a1.getColumnHeaderVisible();function f1(i1,j1){if(i1<=j1){return Math.max(i1,j1-5,c1)+"px";}return-1;}function g1(j1){var k1=Math.max(j1._minWidth||0,c1,j1.getMinWidth());var l1=j1.getWidth();var m1;var n1;var o1;if(T.isVariableWidth(l1)&&!T.isFixedColumn(a1,j1.getIndex())){m1=b1.querySelectorAll('th[data-sap-ui-colid="'+j1.getId()+'"]');n1=m1[e1?0:1];o1=n1?n1.offsetWidth:null;if(o1!==null){if(o1<=k1){return{headers:m1,newWidth:f1(o1,k1)};}else if(n1&&n1.style.width!=l1){d1.push({col:j1,header:n1,minWidth:k1,headers:m1});return{headers:m1,newWidth:l1};}d1.push({col:j1,header:n1,minWidth:k1,headers:m1});}}return null;}function h1(j1){if(j1){Array.prototype.forEach.call(j1.headers,function(k1){k1.style.width=j1.newWidth;});}}a1._getVisibleColumns().map(g1).forEach(h1);if(d1.length){var i1;for(var i=0;i<d1.length;i++){i1=d1[i].header&&d1[i].header.offsetWidth;d1[i].newWidth=f1(i1,d1[i].minWidth);if(parseInt(d1[i].newWidth)>=0){h1(d1[i]);}}}}H(this);var J=this._collectTableSizes();this._updateRowHeights(this._aRowHeights,false);this._updateRowHeights(z,true);T.dynamicCall(this._getSyncExtension,function(i){i.syncLayout({top:this.getDomRef("sapUiTableCnt").offsetTop,headerHeight:this.getDomRef().querySelector(".sapUiTableColHdrCnt").getBoundingClientRect().height,contentHeight:this.getDomRef("tableCCnt").getBoundingClientRect().height});},this);var K=this._getScrollExtension();K.updateHorizontalScrollbar(J);K.updateVerticalScrollbarPosition();K.updateVerticalScrollbarVisibility();var $=this.$();if(T.hasRowActions(this)){var M=$.hasClass("sapUiTableRActFlexible");var O=this.getDomRef("dummycolhdr");if(O){var Q=this.getDomRef("header");var U=Q.clientWidth;var W=this.getColumns().reduce(function(W,i){if(i.getDomRef()&&i.getIndex()>=this.getComputedFixedColumnCount()){return W+T.convertCSSSizeToPixel(i.getWidth());}return W;}.bind(this),0);var X=O.clientWidth;var Y=U>W;if(!M&&Y){var Z=J.tableCtrlScrWidth+J.tableRowHdrScrWidth+J.tableCtrlFixedWidth-X;var _={width:"auto"};_[this._bRtlMode?"right":"left"]=Z;this.$("sapUiTableRowActionScr").css(_);this.$("rowacthdr").css(_);$.toggleClass("sapUiTableRActFlexible",true);}else if(M&&!Y){this.$("sapUiTableRowActionScr").removeAttr("style");this.$("rowacthdr").removeAttr("style");$.toggleClass("sapUiTableRActFlexible",false);}}}$.find(".sapUiTableNoOpacity").addBack().removeClass("sapUiTableNoOpacity");this._getRowMode().updateTableSizes(l);};t.prototype.setShowOverlay=function(i){i=!!i;this.setProperty("showOverlay",i,true);if(this.getDomRef()){var l=document.activeElement;this.$().toggleClass("sapUiTableOverlay",i);this._getAccExtension().updateAriaStateForOverlayAndNoData();this._getKeyboardExtension().updateNoDataAndOverlayFocus(l);}return this;};t.prototype._updateFixedBottomRows=function(){var i=this.getDomRef();if(!i||this._getRowCounts().fixedBottom===0){return;}var l=T.getFirstFixedBottomRowIndex(this);var x=this.getRows();var $;q(i).find(".sapUiTableRowLastScrollable").removeClass("sapUiTableRowLastScrollable");q(i).find(".sapUiTableRowFirstFixedBottom").removeClass("sapUiTableRowFirstFixedBottom");if(l>=0&&l<x.length){$=x[l].getDomRefs(true);$.row.addClass("sapUiTableRowFirstFixedBottom",true);}if(l>=1&&l<x.length){$=x[l-1].getDomRefs(true);$.row.addClass("sapUiTableRowLastScrollable",true);}};t.prototype.getFocusInfo=function(){var i=this.$().find(":focus").attr("id");if(i){return{customId:i};}else{return E.prototype.getFocusInfo.apply(this,arguments);}};t.prototype.applyFocusInfo=function(i){if(i&&i.customId){q(document.getElementById(i.customId)).focus();}else{E.prototype.applyFocusInfo.apply(this,arguments);}return this;};t.prototype.setTitle=function(i){var l=i;if(typeof(i)==="string"||i instanceof String){l=c.TableHelper.createTextView({text:i,width:"100%"});l.addStyleClass("sapUiTableHdrTitle");}this.setAggregation("title",l);return this;};t.prototype.setFooter=function(i){var l=i;if(typeof(i)==="string"||i instanceof String){l=c.TableHelper.createTextView({text:i,width:"100%"});}this.setAggregation("footer",l);return this;};t.prototype.setSelectionMode=function(i){if(i===p.Multi){i=p.MultiToggle;L.warning("The selection mode 'Multi' is deprecated and must not be used anymore."+" Your setting was defaulted to selection mode 'MultiToggle'",this);}if(this._hasSelectionPlugin()){L.warning("If a selection plugin is applied to the table, the selection mode is controlled by the plugin.",this);}else{this.setProperty("selectionMode",i);this._oLegacySelectionPlugin.setSelectionMode(i);}return this;};t.prototype.setFirstVisibleRow=function(i,O,l){if(parseInt(i)<0){L.error("The index of the first visible row must be greater than or equal to 0. The value has been set to 0.",this);i=0;}if(this._getTotalRowCount()>0){var M=this._getMaxFirstVisibleRowIndex();if(M<i){L.warning("The index of the first visible row must be lesser or equal than the scrollable row count minus the visible row count."+" The value has been set to "+M+".",this);i=M;}}var x=this.getFirstVisibleRow()!=i;var y=this._getScrollExtension();if(x){var z=this._getFirstRenderedRowIndex();this.setProperty("firstVisibleRow",i,true);var H=this._getFirstRenderedRowIndex()!==z;if(this.getBinding("rows")){if(H){var J=O===true?T.RowsUpdateReason.VerticalScroll:T.RowsUpdateReason.FirstVisibleRowChange;this.updateRows(J);}if(!O){y.updateVerticalScrollPosition();}}if(!l){this.fireFirstVisibleRowChanged({firstVisibleRow:i});}}else if(!O){y.updateVerticalScrollPosition();}return this;};t.getMetadata().getAggregation("rows")._doesNotRequireFactory=true;t.prototype.bindAggregation=function(i){if(i==="rows"){return this.bindRows.apply(this,[].slice.call(arguments,1));}return C.prototype.bindAggregation.apply(this,arguments);};t.prototype._bindAggregation=function(i,l){if(i==="rows"){this._bBindingReady=false;this._bContextsAvailable=false;t._addBindingListener(l,"change",this._onBindingChange.bind(this));t._addBindingListener(l,"dataRequested",this._onBindingDataRequested.bind(this));t._addBindingListener(l,"dataReceived",this._onBindingDataReceived.bind(this));}C.prototype._bindAggregation.call(this,i,l);if(i==="rows"){var x=this.getBinding("rows");var M=x?x.getModel():null;this._getSelectionPlugin()._setBinding(x);if(M&&M.getDefaultBindingMode()===B.OneTime){L.error("The binding mode of the model is set to \"OneTime\"."+" This binding mode is not supported for the \"rows\" aggregation!"+" Scrolling can not be performed.",this);}}};t.prototype.unbindAggregation=function(i,l){var x=this.getBinding("rows");if(i==="rows"&&this.isBound("rows")){l=true;}var y=C.prototype.unbindAggregation.call(this,i,l);if(i==="rows"&&x){this._invalidateColumnMenus();}return y;};t.prototype.destroyAggregation=function(i,l){C.prototype.destroyAggregation.apply(this,arguments);if(i==="rows"){this._aRowClones.forEach(function(x){x.destroy();});this._aRowClones=[];}return this;};t.prototype.bindRows=function(i){this._bBindingReady=false;this._bContextsAvailable=false;this._iPendingRequests=0;this._bPendingRequest=false;this._iBindingLength=null;if(this.getEnableBusyIndicator()){this.setBusy(false);}return C.prototype.bindAggregation.call(this,"rows",t._getSanitizedBindingInfo(arguments));};t.prototype.unbindRows=function(){C.prototype.unbindAggregation.call(this,"rows");this._getSelectionPlugin()._setBinding(null);this._adjustToTotalRowCount();this._getRowMode().unbindRows();return this;};t._getSanitizedBindingInfo=function(i){var l;if(i==null||i[0]==null){l=null;}else if(typeof i[0]==="string"){var x=i[0];var y=i[1];var z=i[2];var H=i[3];if(y instanceof S||Array.isArray(z)&&z[0]instanceof F){H=z;z=y;y=undefined;}l={path:x,sorter:z,filters:H,template:y};}else{l=i[0];}return l;};t._addBindingListener=function(i,l,H){if(!i.events){i.events={};}if(!i.events[l]){i.events[l]=H;}else{var O=i.events[l];i.events[l]=function(){H.apply(this,arguments);O.apply(this,arguments);};}};t.prototype._onBindingChange=function(i){var l=i.getParameter("reason");if(l===a.Sort||l===a.Filter){this.setFirstVisibleRow(0);}};t.prototype.setRowMode=function(i){this._destroyLegacyRowMode();this.setAggregation("rowMode",i);this._initLegacyRowMode();};t.prototype.getRowMode=function(){return this.getAggregation("rowMode");};t.prototype._getRowMode=function(){var i=this.getRowMode()||this._oLegacyRowMode;if(!i){this._initLegacyRowMode();i=this._oLegacyRowMode;}return i;};t.prototype._initLegacyRowMode=function(){if(this._oLegacyRowMode||this.getRowMode()){return;}this._oLegacyRowMode=u(this);};t.prototype._destroyLegacyRowMode=function(){if(this._oLegacyRowMode){this._oLegacyRowMode.destroy();delete this._oLegacyRowMode;}};function u(i){var l;switch(i.getVisibleRowCountMode()){case V.Fixed:l=new m(true,i);break;case V.Interactive:l=new n(true,i);break;case V.Auto:l=new A(true,i);break;default:}return l;}t.prototype._getRowCounts=function(){return this._getRowMode().getComputedRowCounts();};t.prototype.setVisibleRowCountMode=function(i){if(this.getRowMode()){L.warning("If the \"rowMode\" aggregation is set, setting the \"visibleRowCountMode\" has no effect");return this.setProperty("visibleRowCountMode",i,true);}var O=this.getVisibleRowCountMode();this.setProperty("visibleRowCountMode",i);var l=this.getVisibleRowCountMode();if(l!==O){this._destroyLegacyRowMode();this._initLegacyRowMode();}return this;};t.prototype.setVisibleRowCount=function(i){var l=this.getVisibleRowCountMode();if(l==V.Auto){L.error("VisibleRowCount will be ignored since VisibleRowCountMode is set to Auto",this);return this;}if(i!=null&&!isFinite(i)){return this;}var x=this.getFixedRowCount()+this.getFixedBottomRowCount();if(i<=x&&x>0){L.error("Table: "+this.getId()+" visibleRowCount('"+i+"') must be bigger than number of"+" fixed rows('"+(this.getFixedRowCount()+this.getFixedBottomRowCount())+"')",this);return this;}if(this.getRowMode()){L.warning("If the \"rowMode\" aggregation is set, setting the \"visibleRowCount\" has no effect");return this.setProperty("visibleRowCount",i,true);}i=this.validateProperty("visibleRowCount",i);if(this.getBinding("rows")&&this._getTotalRowCount()<=i){this.setProperty("firstVisibleRow",0);}this.setProperty("visibleRowCount",i);T.dynamicCall(this._getSyncExtension,function(y){y.syncRowCount(i);});return this;};t.prototype.setMinAutoRowCount=function(M){if(parseInt(M)<1){L.error("The minAutoRowCount property must be greater than 0. The value has been set to 1.",this);M=1;}if(this.getRowMode()){L.warning("If the \"rowMode\" aggregation is set, setting the \"minAutoRowCount\" has no effect");return this.setProperty("minAutoRowCount",M,true);}return this.setProperty("minAutoRowCount",M);};t.prototype.setTooltip=function(i){L.warning("The aggregation tooltip is not supported for sap.ui.table.Table",this);return this.setAggregation("tooltip",i,true);};t.prototype.setNavigationMode=function(){this.setProperty("navigationMode",N.Scrollbar,true);L.error("The navigationMode property is deprecated and must not be used anymore. Your setting was defaulted to 'Scrollbar'",this);return this;};t.prototype._getFixedBottomRowContexts=function(){var i=this._getRowCounts();var l=this._getTotalRowCount();if(i.fixedBottom>0&&i.count-i.fixedBottom<l){return this._getContexts(l-i.fixedBottom,i.fixedBottom);}else{return[];}};t.prototype._getFixedRowContexts=function(){var i=this._getRowCounts();if(i.fixedTop>0){return this._getContexts(0,i.fixedTop);}else{return[];}};t.prototype._getContexts=function(i,l,x){var y=this.getBinding("rows");if(y){return y.getContexts(i,l,x);}else{return[];}};t.prototype._getRowContexts=function(l,x,y){var z=this.getBinding("rows");var H=this.getRows().length;l=l==null?H:l;l=Math.max(l,this._getRowMode().getMinRequestLength());if(!z||l<=0){return[];}x=x===true;y=y===true;var J=this._getFirstRenderedRowIndex();var K=this._getRowCounts();var M=[];var O;var Q=l-K.fixedBottom;var U=0;var W=Q;var X=this.getThreshold();X=X?Math.max(H,X):0;var Y=J;var Z=function(a1,b1,Y){for(var i=0;i<b1.length;i++){a1[Y+i]=b1[i];}};if(K.fixedTop>0&&J>0){Y=J+K.fixedTop;Q-=K.fixedTop;U=K.fixedTop;O=this._getFixedRowContexts();M=M.concat(O);}O=this._getContexts(Y,Q,X);if(!x){this._adjustToTotalRowCount();}var $=this._getTotalRowCount();Z(M,O,U);W=Math.min(W,Math.max($-K.fixedBottom,0));if(K.fixedBottom>0){O=this._getFixedBottomRowContexts();Z(M,O,W);}var _=this._getMaxFirstRenderedRowIndex();if(_<J&&this._bContextsAvailable&&!y){this.setProperty("firstVisibleRow",_,true);M=this._getRowContexts(l,x,true);}return M;};t.prototype._adjustToTotalRowCount=function(){var i=this.getBinding("rows");var l=this._getTotalRowCount();var x=this._getScrollExtension();if(this._iBindingLength!==l){this._iBindingLength=l;this._updateFixedBottomRows();x.updateVerticalScrollbarVisibility();x.updateVerticalScrollHeight();x.updateVerticalScrollPosition();if(!i||!T.hasPendingRequests(this)){this._updateNoData();}}};t.prototype.refreshRows=function(i){var l=this.getBinding("rows");if(!l){L.error("RefreshRows must not be called without a binding",this);return;}this._bBindingReady=true;this._bContextsAvailable=false;if(i===a.Sort||i===a.Filter){this.setFirstVisibleRow(0);}this._getRowMode().refreshRows(i);};t.prototype.updateRows=function(i){if(this.bIsDestroyed||this._bIsBeingDestroyed){return;}var l=this.getBinding("rows");if(!this._bBindingReady&&(typeof l.isLengthFinal!=="function"||l.isLengthFinal())){this._bBindingReady=true;}this._bContextsAvailable=this._bBindingReady;this._getRowMode().updateRows(i);};t.prototype.insertRow=function(){L.error("The control manages the rows aggregation. The method \"insertRow\" cannot be used programmatically!",this);return this;};t.prototype.addRow=function(){L.error("The control manages the rows aggregation. The method \"addRow\" cannot be used programmatically!",this);return this;};t.prototype.removeRow=function(){L.error("The control manages the rows aggregation. The method \"removeRow\" cannot be used programmatically!",this);return null;};t.prototype.removeAllRows=function(){L.error("The control manages the rows aggregation. The method \"removeAllRows\" cannot be used programmatically!",this);return[];};t.prototype.destroyRows=function(){L.error("The control manages the rows aggregation. The method \"destroyRows\" cannot be used programmatically!",this);return this;};t.prototype.setCreationRow=function(i){if(!T.isA(i,"sap.ui.table.CreationRow")){i=null;}return this.setAggregation("creationRow",i);};t.prototype.getCreationRow=function(){return this.getAggregation("creationRow");};t.prototype.destroyCreationRow=function(){return this.destroyAggregation("creationRow");};t.prototype.autoResizeColumn=function(i){this._getPointerExtension().doAutoResizeColumn(i);};t.prototype._attachEvents=function(){var $=this.$();if(sap.ui.getCore().getConfiguration().getAnimation()){q(document.body).on("webkitTransitionEnd transitionend",function(i){if(q(i.target).has($).length>0){this._updateTableSizes(T.RowsUpdateReason.Animation);}}.bind(this));}D.resize.attachHandler(this._onWindowResize,this);d.attachEvents(this);};t.prototype._detachEvents=function(){q(document.body).off('webkitTransitionEnd transitionend');T.deregisterResizeHandler(this,"Table");D.resize.detachHandler(this._onWindowResize,this);d.detachEvents(this);};t.prototype._cleanUpTimers=function(){var K;for(K in this._mTimeouts){if(this._mTimeouts[K]){window.clearTimeout(this._mTimeouts[K]);delete this._mTimeouts[K];}}for(K in this._mAnimationFrames){if(this._mAnimationFrames[K]){window.cancelAnimationFrame(this._mAnimationFrames[K]);delete this._mAnimationFrames[K];}}};t.prototype._updateNoData=function(){if(!this.getDomRef()){return;}var i=document.activeElement;this.$().toggleClass("sapUiTableEmpty",T.isNoDataVisible(this));this._getAccExtension().updateAriaStateForOverlayAndNoData();this._getKeyboardExtension().updateNoDataAndOverlayFocus(i);};t.prototype.removeColumn=function(i,l){var x=this.removeAggregation('columns',i,l);if(typeof i==="number"&&i>-1){i=this.getColumns()[i];}var y=this._aSortedColumns.indexOf(i);if(!this._bReorderInProcess&&y>=0){this._aSortedColumns.splice(y,1);}this.invalidateRowsAggregation();var z=this.getCreationRow();if(z){z._update();}return x;};t.prototype.removeAllColumns=function(){var i=this.removeAllAggregation('columns');this._aSortedColumns=[];this.invalidateRowsAggregation();var l=this.getCreationRow();if(l){l._update();}return i;};t.prototype.destroyColumns=function(){var i=this.destroyAggregation('columns');this._aSortedColumns=[];this.invalidateRowsAggregation();var l=this.getCreationRow();if(l){l._update();}return i;};t.prototype.addColumn=function(i,l){this.addAggregation('columns',i,l);this.invalidateRowsAggregation();var x=this.getCreationRow();if(x){x._update();}return this;};t.prototype.insertColumn=function(i,l,x){this.insertAggregation('columns',i,l,x);this.invalidateRowsAggregation();var y=this.getCreationRow();if(y){y._update();}return this;};t.prototype._getTotalRowCount=function(){var i=this.getBinding("rows");var l=this.getBindingInfo("rows");if(!i){return 0;}if(l.length!=null){return l.length;}return i.getLength();};t.prototype._getMaxFirstVisibleRowIndex=function(){var M;if(T.isVariableRowHeightEnabled(this)){M=this._getTotalRowCount()-1;}else{M=this._getTotalRowCount()-this._getRowCounts().count;}return Math.max(0,M);};t.prototype._getMaxFirstRenderedRowIndex=function(){var M;if(T.isVariableRowHeightEnabled(this)){M=this._getTotalRowCount()-this._getRowCounts().count-1;}else{M=this._getTotalRowCount()-this._getRowCounts().count;}return Math.max(0,M);};t.prototype._getFirstRenderedRowIndex=function(){var i=this.getFirstVisibleRow();if(T.isVariableRowHeightEnabled(this)&&i>this._getMaxFirstRenderedRowIndex()){return this._getMaxFirstRenderedRowIndex();}else{return i;}};t.prototype._getVisibleColumns=function(){var x=[];var y=this.getColumns();for(var i=0,l=y.length;i<l;i++){if(y[i].shouldRender()){x.push(y[i]);}}return x;};t.prototype._getColumnsWidth=function(x,y){var z=this.getColumns();var H=0;if(x!==0&&!x){x=0;}if(y!==0&&!y){y=z.length;}for(var i=x,l=y;i<l;i++){if(z[i]&&z[i].shouldRender()){var J=T.convertCSSSizeToPixel(z[i].getWidth());if(J==null){J=T.Column.getMinColumnWidth();}H+=J;}}return H;};t.prototype._onTableResize=function(i){var O=i.oldSize.width;var l=i.size.width;if(this._bInvalid||!this.getDomRef()||O===l){return;}this._updateTableSizes(T.RowsUpdateReason.Resize);};t.prototype._onWindowResize=function(){if(this._bInvalid||!this.getDomRef()){return;}if(D.browser.chrome&&window.devicePixelRatio!==this._nDevicePixelRatio){this._nDevicePixelRatio=window.devicePixelRatio;this._updateTableSizes(T.RowsUpdateReason.Zoom);this._adjustOutlineOffset();}};t.prototype._adjustOutlineOffset=function(){if(window.devicePixelRatio<1){this.addStyleClass("sapUiTableZoomout");}else{this.removeStyleClass("sapUiTableZoomout");}};t.prototype._disableTextSelection=function(i){q(i||document.body).attr("unselectable","on").css({"-moz-user-select":"none","-webkit-user-select":"none","user-select":"none"}).bind("selectstart",function(l){l.preventDefault();return false;});};t.prototype._enableTextSelection=function(i){q(i||document.body).attr("unselectable","off").css({"-moz-user-select":"","-webkit-user-select":"","user-select":""}).unbind("selectstart");};t.prototype._clearTextSelection=function(){if(window.getSelection){if(window.getSelection().empty){window.getSelection().empty();}else if(window.getSelection().removeAllRanges){window.getSelection().removeAllRanges();}}else if(document.selection&&document.selection.empty){try{document.selection.empty();}catch(i){}}};t.prototype._findAndfireCellEvent=function(i,l,x){var $=q(l.target);var y=$.closest(".sapUiTableDataCell");var z=y.attr("id");var M=/.*-row(\d*)-col(\d*)/i.exec(z);var H=false;if(M){var J=M[1];var K=M[2];var O=this.getRows()[J];var Q=O&&O.getCells()[K];var U=O&&O.getIndex();var W=b.ofCell(Q).getId();var X;if(this.getBindingInfo("rows")){X=O.getBindingContext(this.getBindingInfo("rows").model);}var Y={rowIndex:U,columnIndex:K,columnId:W,cellControl:Q,rowBindingContext:X,cellDomRef:y.get(0)};H=!i.call(this,Y);if(!H&&typeof x==="function"){Y.cellDomRef=y[0];H=x.call(this,Y);}}return H;};t.prototype.getFocusDomRef=function(){this._getKeyboardExtension().initItemNavigation();var i=T.getFocusedItemInfo(this);if(i){return i.domRef||C.prototype.getFocusDomRef.apply(this,arguments);}return null;};t.prototype.pushSortedColumn=function(i,l){if(!l){this._aSortedColumns=[];}this._aSortedColumns.push(i);};t.prototype.getSortedColumns=function(){return this._aSortedColumns.slice();};t.prototype.sort=function(l,x,y){if(!l){for(var i=0;i<this._aSortedColumns.length;i++){this._aSortedColumns[i].setSorted(false);}var z=this.getBinding("rows");if(z){z.sort();}this._aSortedColumns=[];}if(this.getColumns().indexOf(l)>=0){l.sort(x===s.Descending,y);}};t.prototype.filter=function(i,l){if(this.getColumns().indexOf(i)>=0){i.filter(l);}};t.prototype._updateSelection=function(){var l=this.getSelectionMode();if(l===p.None){return;}var x=this._getSelectionPlugin().getRenderConfig();var y;var z;var $=this.$("selall");var H=this._getAccExtension().getAriaTextsForSelectionMode(true);var J=this.getRows();for(var i=0;i<J.length;i++){var K=J[i];K._updateSelection(this,H);}if(x.headerSelector.visible){var M=T.areAllRowsSelected(this);$.toggleClass("sapUiTableSelAll",!M);this._getAccExtension().setSelectAllState(M);if(x.headerSelector.type==="toggle"){y=M?"TBL_DESELECT_ALL":"TBL_SELECT_ALL";}}if(x.headerSelector.type==="clear"&&x.headerSelector.visible){$.attr("disabled",!x.headerSelector.enabled);y="TBL_DESELECT_ALL";if(x.headerSelector.enabled){$.removeAttr("aria-disabled");}else{$.attr("aria-disabled","true");}}if(y){z=T.getResourceText(y);if(this._getShowStandardTooltips()&&x.headerSelector.visible){$.attr('title',z);}else if(x.headerSelector.type==="toggle"){this.getDomRef("ariaselectall").innerText=z;}}};t.prototype._getShowStandardTooltips=function(){return!this._bHideStandardTooltips;};t.prototype._onSelectionChanged=function(i){var l=this._getSelectionPlugin();var x=i.getParameter("rowIndices");var y=i.getParameter("selectAll");var z=this._iSourceRowIndex!==undefined?this._iSourceRowIndex:l.getSelectedIndex();var H=i.getParameter("limitReached");if(H){this.setFirstVisibleRow(Math.max(0,l.getSelectedIndex()-this._getRowCounts().count+1));}this._updateSelection();if(!this._hasSelectionPlugin()){this.setProperty("selectedIndex",z,true);this.fireRowSelectionChange({rowIndex:z,rowContext:this.getContextByIndex(z),rowIndices:x,selectAll:y,userInteraction:this._iSourceRowIndex!==undefined});}};t.prototype.getContextByIndex=function(i){var l=this.getBinding("rows");return i>=0&&l?l.getContexts(i,1)[0]:null;};t.prototype.getSelectedIndex=function(){if(this._hasSelectionPlugin()){throw new Error("Unsupported operation: sap.ui.table.Table#getSelectedIndex must not be called if a selection plugin is applied.");}return this._getSelectionPlugin().getSelectedIndex();};t.prototype.setSelectedIndex=function(i){if(this._hasSelectionPlugin()){throw new Error("Unsupported operation: sap.ui.table.Table#setSelectedIndex must not be called if a selection plugin is applied.");}this._getSelectionPlugin().setSelectedIndex(i);return this;};t.prototype.clearSelection=function(){if(this._hasSelectionPlugin()){throw new Error("Unsupported operation: sap.ui.table.Table#clearSelection must not be called if a selection plugin is applied.");}this._getSelectionPlugin().clearSelection();return this;};t.prototype.selectAll=function(){if(this._hasSelectionPlugin()){throw new Error("Unsupported operation: sap.ui.table.Table#selectAll must not be called if a selection plugin is applied.");}if(T.hasSelectAll(this)){this._getSelectionPlugin().selectAll();}return this;};t.prototype.getSelectedIndices=function(){if(this._hasSelectionPlugin()){throw new Error("Unsupported operation: sap.ui.table.Table#getSelectedIndices must not be called if a selection plugin is applied.");}return this._getSelectionPlugin().getSelectedIndices();};t.prototype.addSelectionInterval=function(i,l){if(this._hasSelectionPlugin()){throw new Error("Unsupported operation: sap.ui.table.Table#addSelectionInterval must not be called if a selection plugin is applied.");}this._getSelectionPlugin().addSelectionInterval(i,l);return this;};t.prototype.setSelectionInterval=function(i,l){if(this._hasSelectionPlugin()){throw new Error("Unsupported operation: sap.ui.table.Table#setSelectionInterval must not be called if a selection plugin is applied.");}this._getSelectionPlugin().setSelectionInterval(i,l);return this;};t.prototype.removeSelectionInterval=function(i,l){if(this._hasSelectionPlugin()){throw new Error("Unsupported operation: sap.ui.table.Table#removeSelectionInterval must not be called if a selection plugin is applied.");}this._getSelectionPlugin().removeSelectionInterval(i,l);return this;};t.prototype.isIndexSelected=function(i){if(this._hasSelectionPlugin()){throw new Error("Unsupported operation: sap.ui.table.Table#isIndexSelected must not be called if a selection plugin is applied.");}return this._getSelectionPlugin().isIndexSelected(i);};t.prototype.setGroupBy=function(i){var l=i;var O=sap.ui.getCore().byId(this.getGroupBy());if(typeof l==="string"){l=sap.ui.getCore().byId(l);}var x=false;if(l instanceof b&&l!==O){if(this.getColumns().indexOf(l)===-1){throw new Error("Column has to be part of the columns aggregation!");}var y=this.fireGroup({column:l,groupedColumns:[l.getId()],type:G.group});if(O){O.setGrouped(false);x=true;}if(y&&this.getEnableGrouping()){l.setGrouped(true);}}if(!l||x){if(O){O.setGrouped(false);}T.Grouping.resetExperimentalGrouping(this);}return this.setAssociation("groupBy",l);};t.prototype.getBinding=function(i){T.Grouping.setupExperimentalGrouping(this);return E.prototype.getBinding.call(this,[i||"rows"]);};t.prototype.setEnableGrouping=function(i){var l=sap.ui.getCore().byId(this.getGroupBy());this.setProperty("enableGrouping",i);if(l){l.setGrouped(i);}T.Grouping.resetExperimentalGrouping(this);this._invalidateColumnMenus();return this;};t.prototype.setEnableCustomFilter=function(i){this.setProperty("enableCustomFilter",i);this._invalidateColumnMenus();return this;};t.prototype.setEnableColumnFreeze=function(i){this.setProperty("enableColumnFreeze",i);this._invalidateColumnMenus();return this;};t.prototype.setShowColumnVisibilityMenu=function(i){this.setProperty("showColumnVisibilityMenu",i);this._invalidateColumnMenus();return this;};t.prototype.getComputedFixedColumnCount=function(){if(this._bIgnoreFixedColumnCount){return 0;}return this.getFixedColumnCount();};t.prototype.setFixedColumnCount=function(l,x){var y=this.getColumns();var z,i;for(i=l-1;i>=0;i--){z=y[i];if(z&&z.getVisible()){l=Math.max(l,z.getIndex()+T.Column.getHeaderSpan(z));break;}}var $=this.$().find(".sapUiTableCtrlFirstCol > th");for(i=l-1;i>=0;i--){z=y[i];if(z&&T.isVariableWidth(z.getWidth())){z._iFixWidth=$.filter("[data-sap-ui-headcolindex='"+z.getIndex()+"']").width();}}this.setProperty("fixedColumnCount",l,x);this._collectTableSizes();if(this.getEnableColumnFreeze()){this._invalidateColumnMenus();}return this;};t.prototype.setFixedRowCount=function(i){if(!(parseInt(i)>=0)){L.error("Number of fixed rows must be greater or equal 0",this);return this;}if((i+this.getFixedBottomRowCount())>=this.getVisibleRowCount()){L.error("Table '"+this.getId()+"' fixed rows('"+(i+this.getFixedBottomRowCount())+"') must be smaller than"+" numberOfVisibleRows('"+this.getVisibleRowCount()+"')",this);return this;}if(this.getRowMode()){L.warning("If the \"rowMode\" aggregation is set, setting the \"fixedRowCount\" has no effect");return this.setProperty("fixedRowCount",i,true);}return this.setProperty("fixedRowCount",i);};t.prototype.setFixedBottomRowCount=function(i){if(!(parseInt(i)>=0)){L.error("Number of fixed bottom rows must be greater or equal 0",this);return this;}if((i+this.getFixedRowCount())>=this.getVisibleRowCount()){L.error("Table '"+this.getId()+"' fixed rows('"+(i+this.getFixedRowCount())+"') must be smaller than"+" numberOfVisibleRows('"+this.getVisibleRowCount()+"')",this);return this;}if(this.getRowMode()){L.warning("If the \"rowMode\" aggregation is set, setting the \"iFixedBottomRowCount\" has no effect");return this.setProperty("fixedBottomRowCount",i,true);}return this.setProperty("fixedBottomRowCount",i);};t.prototype.setThreshold=function(i){this.setProperty("threshold",i,true);return this;};t.prototype._invalidateColumnMenus=function(){var x=this.getColumns();for(var i=0,l=x.length;i<l;i++){x[i].invalidateMenu();}};t.prototype._isTouchEvent=function(i){return!!(i&&i.originalEvent&&i.originalEvent.touches);};t.prototype._getRowClone=function(x){var y=this._aRowClones[x];if(y&&!y.bIsDestroyed){return y;}y=new R(this.getId()+"-rows"+"-row"+x);this._aRowClones[x]=y;var z=this.getColumns();for(var i=0,l=z.length;i<l;i++){if(z[i].getVisible()){var H=z[i].getTemplateClone(i);if(H){y.addCell(H);}}}if(T.hasRowActions(this)){var J=this.getRowActionTemplate().clone();J._setFixedLayout(true);J._setCount(this.getRowActionCount());J._setIconLabel(this.getId()+"-rowacthdr");y.setAggregation("_rowAction",J,true);}var K=this.getRowSettingsTemplate();if(K){var M=K.clone();y.setAggregation("_settings",M,true);}return y;};t.prototype.invalidateRowsAggregation=function(){this._bRowAggregationInvalid=true;};t.prototype._getBaseRowHeight=function(){var i=this._getRowMode().getBaseRowContentHeight();if(i>0){return i+T.RowHorizontalFrameSize;}else{return this._getDefaultRowHeight();}};t.prototype._getDefaultRowHeight=function(){var i=T.getContentDensity(this);return T.DefaultRowHeight[i];};t.prototype._getDefaultRowContentHeight=function(){var i=T.getContentDensity(this);return T.BaseSize[i];};t.prototype.setShowNoData=function(i){this.setProperty('showNoData',i,true);this._updateNoData();return this;};t.prototype.setNoData=function(i){var O=T.getNoDataText(this);this.setAggregation("noData",i,true);var l=T.getNoDataText(this);if(O!=null&&l!=null){if(O!==l){this.$("noDataMsg").text(l);}}else{this.invalidate();}return this;};t.prototype.exportData=function(x){var y=sap.ui.requireSync("sap/ui/core/util/Export");x=x||{};if(!x.rows){var z=this.getBinding("rows"),H=this.getBindingInfo("rows");var J=z.aFilters.concat(z.aApplicationFilters);x.rows={path:H.path,model:H.model,sorter:z.aSorters,filters:J,parameters:H.parameters};}if(!x.exportType){var K=sap.ui.requireSync("sap/ui/core/util/ExportTypeCSV");x.exportType=new K();}var M=x.rows.model;if(!M){var O=x.rows.path;var Q=O.indexOf(">");if(Q>0){M=O.substr(0,Q);}}if(!x.columns){x.columns=[];var U=this.getColumns();for(var i=0,l=U.length;i<l;i++){var W=U[i];if(W.getSortProperty()){x.columns.push({name:W.getLabel().getText(),template:{content:{path:W.getSortProperty(),model:M}}});}}}var X=new y(x);this.addDependent(X);return X;};t.prototype._onPersoApplied=function(){var x=this.getColumns();var y=[];for(var i=0,l=x.length;i<l;i++){var z=x[i];if(z.getSorted()){y.push(new S(z.getSortProperty(),z.getSortOrder()===s.Descending));}}var H=this.getBinding("rows");if(H){if(y.length>0){H.sort(y);}this.refreshRows();}};t.prototype._toggleSelectAll=function(){if(!T.hasData(this)||this.getSelectionMode()!==p.MultiToggle){return;}var i=this._getSelectionPlugin();if(T.areAllRowsSelected(this)){this._iSourceRowIndex=-1;i.clearSelection();}else{this._iSourceRowIndex=0;i.selectAll();}this._iSourceRowIndex=undefined;};t.prototype.setBusy=function(i,l){var x=this.getBusy()!=i;l="sapUiTableGridCnt";var y=C.prototype.setBusy.call(this,i,l);if(x){this.fireBusyStateChanged({busy:i});}return y;};t.prototype.setEnableBusyIndicator=function(i){this.setProperty("enableBusyIndicator",i,true);if(!i){this.setBusy(false);}return this;};t.prototype._onBindingDataRequested=function(i){if(i.getSource()!=this.getBinding("rows")||i.getParameter("__simulateAsyncAnalyticalBinding")){return;}this._iPendingRequests++;this._bPendingRequest=true;var l=T.canUsePendingRequestsCounter(this);if(this.getEnableBusyIndicator()&&(l&&this._iPendingRequests===1||!l)){this.setBusy(true);}if(this._dataReceivedHandlerId!=null){clearTimeout(this._dataReceivedHandlerId);delete this._dataReceivedHandlerId;}};t.prototype._onBindingDataReceived=function(i){if(i.getSource()!=this.getBinding("rows")||i.getParameter("__simulateAsyncAnalyticalBinding")){return;}this._iPendingRequests--;this._bPendingRequest=false;this._adjustToTotalRowCount();if(!T.hasPendingRequests(this)){this._dataReceivedHandlerId=setTimeout(function(){if(this.getEnableBusyIndicator()){this.setBusy(false);}this._updateNoData();delete this._dataReceivedHandlerId;}.bind(this),0);}};t.prototype._setLargeDataScrolling=function(l){this._bLargeDataScrolling=!!l;};t.prototype._updateTableContent=function(){T.Grouping.updateGroups(this);};t.prototype.setRowActionTemplate=function(i){this.setAggregation("rowActionTemplate",i);i=this.getRowActionTemplate();if(i){i._setCount(this.getRowActionCount());}this.invalidateRowsAggregation();return this;};t.prototype.setRowActionCount=function(l){this.setProperty("rowActionCount",l);l=this.getRowActionCount();var x=this.getRowActionTemplate();if(x){x._setCount(l);}for(var i=0;i<this._aRowClones.length;i++){x=this._aRowClones[i].getRowAction();if(x){x._setCount(l);}}return this;};t.prototype.setRowSettingsTemplate=function(i){this.setAggregation("rowSettingsTemplate",i);this.invalidateRowsAggregation();return this;};t.prototype.addPlugin=function(i){this.addAggregation("plugins",i);if(T.isA(i,"sap.ui.table.plugins.SelectionPlugin")){this._initSelectionPlugin();}return this;};t.prototype.insertPlugin=function(i,l){this.insertAggregation("plugins",i,l);if(T.isA(i,"sap.ui.table.plugins.SelectionPlugin")){this._initSelectionPlugin();}return this;};t.prototype.removePlugin=function(i){var l=this.removeAggregation("plugins",i);if(T.isA(l,"sap.ui.table.plugins.SelectionPlugin")){this._initSelectionPlugin();}return l;};t.prototype.removeAllPlugins=function(){var i=this.removeAllAggregation("plugins");this._initSelectionPlugin();return i;};t.prototype.destroyPlugins=function(){this.destroyAggregation('plugins');this._initSelectionPlugin();return this;};t.prototype.getPlugin=function(l){if(typeof l!=="string"){return null;}var x=this.getPlugins();for(var i=0;i<x.length;i++){if(x[i].isA(l)){return x[i];}}return null;};t.prototype._getSelectionPlugin=function(){var i=this._oSelectionPlugin||this._oLegacySelectionPlugin;if(!i){this._initLegacySelectionPlugin();i=this._oLegacySelectionPlugin;}if(typeof this._getSelectedIndicesCount==="function"&&i.getSelectedCount!==this._getSelectedIndicesCount){i.getSelectedCount=this._getSelectedIndicesCount;["isIndexSelected","setSelectedIndex","getSelectedIndex","getSelectedIndices","setSelectionInterval","addSelectionInterval","removeSelectionInterval","selectAll","clearSelection"].forEach(function(M){i[M]=this[M];}.bind(this));}return i;};t.prototype._hasSelectionPlugin=function(){return this._oSelectionPlugin!=null;};t.prototype._initSelectionPlugin=function(){var i=this.getPlugin("sap.ui.table.plugins.SelectionPlugin");if(i){this._destroyLegacySelectionPlugin();if(i!==this._oSelectionPlugin){w(this,this._oSelectionPlugin);v(this,i);this._oSelectionPlugin=i;}}else{this._initLegacySelectionPlugin();w(this,this._oSelectionPlugin);delete this._oSelectionPlugin;}};t.prototype._initLegacySelectionPlugin=function(){if(this._oLegacySelectionPlugin||this.getPlugin("sap.ui.table.plugins.SelectionPlugin")){return;}this._oLegacySelectionPlugin=this._createLegacySelectionPlugin();v(this,this._oLegacySelectionPlugin);};t.prototype._destroyLegacySelectionPlugin=function(){if(this._oLegacySelectionPlugin){this._oLegacySelectionPlugin.destroy();delete this._oLegacySelectionPlugin;}};t.prototype._createLegacySelectionPlugin=function(){return new o(this);};function v(i,l){if(l){l.attachSelectionChange(i._onSelectionChanged,i);l._setBinding(i.getBinding("rows"));}}function w(i,l){if(l){l.detachSelectionChange(i._onSelectionChanged,i);l._setBinding();}}t.prototype.getCellControl=function(i,l,x){var y=T.getRowColCell(this,i,l,!x);return y.cell;};t.prototype._fireRowsUpdated=function(i){if(i==null){i=T.RowsUpdateReason.Unknown;}var l={reason:i};this.onRowsUpdated(l);clearTimeout(this._mTimeouts.fireRowsUpdated);this._mTimeouts.fireRowsUpdated=setTimeout(function(){this.fireEvent("_rowsUpdated",l);}.bind(this),0);};t.prototype.onRowsUpdated=function(i){if(this.getRows().length>0){this._updateTableContent();this._updateSelection();this._getAccExtension().updateAccForCurrentCell(i.reason);this._resetRowHeights();this._aRowHeights=this._collectRowHeights(false);this._updateRowHeights(this._aRowHeights,false);}this._iRenderedFirstVisibleRow=this._getFirstRenderedRowIndex();this._getScrollExtension().updateVerticalScrollbarVisibility();};t.prototype._enableSynchronization=function(){var i=this;return new Promise(function(l,x){sap.ui.require(["sap/ui/table/TableSyncExtension"],function(y){l(d.enrich(i,y).getInterface());},function(y){x(y);});});};t.prototype._enableLegacyMultiSelection=function(){if(this._hasSelectionPlugin()){throw new Error("Unsupported operation: sap.ui.table.Table#_enableLegacyMultiSelection must not be called"+" if a selection plugin is applied.");}this._legacyMultiSelection=function(i,l){if(this._hasSelectionPlugin()){throw new Error("Unsupported operation: The legacy multi selection is not supported if a selection plugin is applied");}var x=!!(l.metaKey||l.ctrlKey);if(!this.isIndexSelected(i)){if(x){this.addSelectionInterval(i,i);}else{this.setSelectedIndex(i);}}else if(x||this._getSelectionPlugin().getSelectedCount()===1){this.removeSelectionInterval(i,i);}else{this.setSelectedIndex(i);}}.bind(this);};return t;});
