/*
 * OpenUI5
 * (c) Copyright 2009-2019 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["./SelectionPlugin","./SelectionModelPlugin","./BindingSelectionPlugin","../library","../TableUtils","sap/ui/core/Icon","sap/ui/core/IconPool","sap/base/Log"],function(S,a,B,l,T,I,b,L){"use strict";var c=l.SelectionMode;var M=S.extend("sap.ui.table.plugins.MultiSelectionPlugin",{metadata:{properties:{limit:{type:"int",group:"Behavior",defaultValue:200},showHeaderSelector:{type:"boolean",group:"Appearance",defaultValue:true},selectionMode:{type:"sap.ui.table.SelectionMode",group:"Behavior",defaultValue:c.MultiToggle}},events:{selectionChange:{parameters:{indices:{type:"int[]"},limitReached:{type:"boolean"}}}}}});M.prototype.init=function(){S.prototype.init.call(this);var i=new I({src:b.getIconURI(T.ThemeParameters.resetIcon),useIconTooltip:false});i.addStyleClass("sapUiTableSelectClear");this._bLimitReached=false;this._bLimitDisabled=this.getLimit()===0;this.oInnerSelectionPlugin=null;this.oDeselectAllIcon=i;};M.prototype.exit=function(){if(this.oInnerSelectionPlugin){this.oInnerSelectionPlugin.destroy();this.oInnerSelectionPlugin=null;}if(this.oDeselectAllIcon){this.oDeselectAllIcon.destroy();this.oDeselectAllIcon=null;}};M.prototype.getRenderConfig=function(){return{headerSelector:{type:this._bLimitDisabled?"toggle":"clear",icon:this.oDeselectAllIcon,visible:this.getSelectionMode()===c.MultiToggle&&this.getShowHeaderSelector(),enabled:this._bLimitDisabled||this.getSelectedCount()>0}};};M.prototype.onHeaderSelectorPress=function(){var r=this.getRenderConfig();if(!r.headerSelector.visible||!r.headerSelector.enabled){return;}if(r.headerSelector.type==="toggle"){t(this);}else if(r.headerSelector.type==="clear"){this.clearSelection();}};M.prototype.onKeyboardShortcut=function(s){if(s==="toggle"){if(this._bLimitDisabled){t(this);}}else if(s==="clear"){this.clearSelection();}};function t(P){if(P.getSelectableCount()>P.getSelectedCount()){P.selectAll();}else{P.clearSelection();}}M.prototype.setSelectionMode=function(s){var o=this.getSelectionMode();var f=this.getParent();if(f){f.setProperty("selectionMode",s,true);}this.setProperty("selectionMode",s);if(this.getSelectionMode()!==o){this.clearSelection();}return this;};M.prototype.setLimit=function(i){if(typeof i==="number"&&i<0){L.warning("The limit must be greater than or equal to 0",this);return this;}this.setProperty("limit",i);this._bLimitDisabled=i===0;return this;};M.prototype.isLimitReached=function(){return this._bLimitReached;};M.prototype.setLimitReached=function(f){this._bLimitReached=f;};M.prototype.selectAll=function(){if(this._bLimitDisabled){var i=this._getBinding().getLength()-1;this.addSelectionInterval(0,i);}};function p(m,i,f,A){var g=m.getLimit();var r=f<i;var o=m._getBinding();var G=r?f:i;if(m.isIndexSelected(i)&&A){if(!r){i++;G++;}else{i--;}}var h=Math.abs(f-i)+1;if(!m._bLimitDisabled){m.setLimitReached(h>g);if(m.isLimitReached()){if(!r){f=i+g-1;}else{f=i-g+1;}h=g+1;}}if(o&&G>=0&&h>0){return d(o,G,h).then(function(){return{indexFrom:i,indexTo:f};});}return Promise.resolve();}M.prototype.setSelectionInterval=function(i,f){var s=this.getSelectionMode();if(s===c.None){return;}else if(s===c.Single){i=f;}p(this,i,f,false).then(function(m){if(m){this.oInnerSelectionPlugin.setSelectionInterval(m.indexFrom,m.indexTo);this._scrollTable(m.indexFrom>m.indexTo,m.indexTo);}}.bind(this));};M.prototype.setSelectedIndex=function(i){this.setSelectionInterval(i,i);};M.prototype.addSelectionInterval=function(i,f){var s=this.getSelectionMode();if(s===c.None){return;}else if(s===c.Single){i=f;this.setSelectionInterval(i,f);return;}p(this,i,f,true).then(function(m){if(m){this.oInnerSelectionPlugin.addSelectionInterval(m.indexFrom,m.indexTo);this._scrollTable(m.indexFrom>m.indexTo,m.indexTo);}}.bind(this));};M.prototype._scrollTable=function(r,i){var o=this.getParent();if(o&&this.isLimitReached()){if(!r){o.setFirstVisibleRow(Math.max(0,i-o.getVisibleRowCount()+2));}else{o.setFirstVisibleRow(Math.max(0,i-1));}}};function d(o,s,i){return new Promise(function(r){e(o,s,i,r);});}function e(o,s,f,r){var C=o.getContexts(s,f);var g=false;for(var i=0;i<C.length;i++){if(!C[i]){g=true;break;}}if(!g&&!C.dataRequested){r(C);return;}o.attachEventOnce("dataReceived",function(){C=o.getContexts(s,f);if(C.length==f){r(C);}else{e(o,s,f,r);}});}M.prototype.clearSelection=function(){if(this.oInnerSelectionPlugin){this.setLimitReached(false);this.oInnerSelectionPlugin.clearSelection();}};M.prototype.getSelectedIndex=function(){if(this.oInnerSelectionPlugin){return this.oInnerSelectionPlugin.getSelectedIndex();}return-1;};M.prototype.getSelectedIndices=function(){if(this.oInnerSelectionPlugin){return this.oInnerSelectionPlugin.getSelectedIndices();}return[];};M.prototype.getSelectableCount=function(){if(this.oInnerSelectionPlugin){return this.oInnerSelectionPlugin.getSelectableCount();}return 0;};M.prototype.getSelectedCount=function(){if(this.oInnerSelectionPlugin){return this.oInnerSelectionPlugin.getSelectedCount();}return 0;};M.prototype.isIndexSelectable=function(i){if(this.oInnerSelectionPlugin){return this.oInnerSelectionPlugin.isIndexSelectable(i);}return false;};M.prototype.isIndexSelected=function(i){if(this.oInnerSelectionPlugin){return this.oInnerSelectionPlugin.isIndexSelected(i);}return false;};M.prototype.removeSelectionInterval=function(i,f){if(this.oInnerSelectionPlugin){this.setLimitReached(false);this.oInnerSelectionPlugin.removeSelectionInterval(i,f);}};M.prototype.setParent=function(P){var r=S.prototype.setParent.apply(this,arguments);if(this.oInnerSelectionPlugin){this.oInnerSelectionPlugin.destroy();this.oInnerSelectionPlugin=null;}if(P){this.oInnerSelectionPlugin=P._createLegacySelectionPlugin();this.oInnerSelectionPlugin.attachSelectionChange(this._onSelectionChange,this);P.setProperty("selectionMode",this.getSelectionMode());}return r;};M.prototype._onSelectionChange=function(E){var r=E.getParameter("rowIndices");this.fireSelectionChange({rowIndices:r,limitReached:this.isLimitReached()});};M.prototype._getLastIndex=function(){if(this.oInnerSelectionPlugin){return this.oInnerSelectionPlugin._getLastIndex();}return 0;};M.prototype._getBinding=function(){if(this.oInnerSelectionPlugin){return this.oInnerSelectionPlugin._getBinding();}return null;};M.prototype._setBinding=function(o){if(this.oInnerSelectionPlugin){return this.oInnerSelectionPlugin._setBinding(o);}};M.prototype._onBindingChange=function(E){if(this.oInnerSelectionPlugin){return this.oInnerSelectionPlugin._onBindingChange(E);}};M.prototype.onThemeChanged=function(){this.oDeselectAllIcon.setSrc(b.getIconURI(T.ThemeParameters.resetIcon));};return M;});
