/*
 * OpenUI5
 * (c) Copyright 2009-2019 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["../library","./RowMode","../TableUtils"],function(l,R,T){"use strict";var F=R.extend("sap.ui.table.rowmodes.FixedRowMode",{metadata:{library:"sap.ui.table",properties:{rowContentHeight:{type:"int",defaultValue:0,group:"Appearance"},hideEmptyRows:{type:"boolean",defaultValue:false,group:"Appearance"}}},constructor:function(i){Object.defineProperty(this,"bLegacy",{value:typeof i==="boolean"?i:false});if(this.bLegacy){var t=arguments[1];this.getParent=function(){return t;};R.call(this);this.attachEvents();}else{R.apply(this,arguments);}}});var a={};F.prototype.attachEvents=function(){R.prototype.attachEvents.apply(this,arguments);T.addDelegate(this.getTable(),a,this);};F.prototype.detachEvents=function(){R.prototype.detachEvents.apply(this,arguments);T.removeDelegate(this.getTable(),a);};F.prototype.getRowCount=function(){return this.bLegacy?this.getTable().getVisibleRowCount():this.getProperty("rowCount");};F.prototype.getFixedTopRowCount=function(){return this.bLegacy?this.getTable().getFixedRowCount():this.getProperty("fixedTopRowCount");};F.prototype.getFixedBottomRowCount=function(){return this.bLegacy?this.getTable().getFixedBottomRowCount():this.getProperty("fixedBottomRowCount");};F.prototype.getRowContentHeight=function(){return this.bLegacy?this.getTable().getRowHeight():this.getProperty("rowContentHeight");};F.prototype.getMinRequestLength=function(){return Math.max(0,this.getRowCount());};F.prototype.getComputedRowCounts=function(){var r=this.getRowCount();var f=this.getFixedTopRowCount();var i=this.getFixedBottomRowCount();if(this.getHideEmptyRows()){r=Math.min(r,this.getTotalRowCountOfTable());}return this.sanitizeRowCounts(r,f,i);};F.prototype.getTableStyles=function(){return{height:"auto"};};F.prototype.getTableBottomPlaceholderStyles=function(){if(!this.getHideEmptyRows()){return undefined;}var r=Math.max(0,this.getRowCount()-this.getComputedRowCounts().count);return{height:r*this.getBaseRowHeightOfTable()+"px"};};F.prototype.getRowContainerStyles=function(){var h=this.getComputedRowCounts().count*this.getBaseRowHeightOfTable()+"px";if(this.bLegacy&&!T.isVariableRowHeightEnabled(this.getTable())){return{minHeight:h};}else{return{height:h};}};F.prototype.renderRowStyles=function(r){var i=this.getRowContentHeight();if(i>0){r.style("height",this.getBaseRowHeightOfTable()+"px");}};F.prototype.renderCellContentStyles=function(r){var i=this.getRowContentHeight();if(this.bLegacy){return;}if(i<=0){i=this.getDefaultRowContentHeightOfTable();}if(i>0){r.style("max-height",i+"px");}};F.prototype.getBaseRowContentHeight=function(){return Math.max(0,this.getRowContentHeight());};F.prototype.refreshRows=function(){var r=this.getRowCount();if(r>0){this.initTableRowsAfterDataRequested(r);this.getRowContexts(r,true);}};a.onBeforeRendering=function(e){var r=e&&e.isMarked("renderRows");if(!r){this.updateTable(T.RowsUpdateReason.Render);}};a.onAfterRendering=function(e){var t=this.getTable();var r=e&&e.isMarked("renderRows");if(!r&&t.getRows().length>0){t._fireRowsUpdated(T.RowsUpdateReason.Render);}};return F;});
