/*!
 * OpenUI5
 * (c) Copyright 2009-2019 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["sap/ui/core/Control","sap/ui/core/Core","sap/ui/base/ManagedObjectObserver",'sap/ui/core/ResizeHandler',"sap/ui/core/delegate/ItemNavigation","sap/f/GridContainerRenderer","sap/ui/Device","sap/ui/layout/cssgrid/VirtualGrid","sap/f/GridContainerSettings","sap/base/strings/capitalize","sap/ui/core/InvisibleRenderer"],function(C,a,M,R,I,G,D,V,b,c,d){"use strict";var e=a.getConfiguration().getRTL();var E=16;function f(){return!D.browser.msie&&!(D.browser.edge&&D.browser.version<E);}function g(i){var k=i.getLayoutData();return k?k.getColumns():1;}function h(i){var k=i.getLayoutData();return k?k.getActualRows():1;}function j(i){var k=i.getLayoutData();return k?k.hasAutoHeight():true;}var l=C.extend("sap.f.GridContainer",{metadata:{library:"sap.f",interfaces:["sap.f.dnd.IGridDroppable"],properties:{width:{type:"sap.ui.core.CSSSize",group:"Appearance",defaultValue:""},containerQuery:{type:"boolean",group:"Behavior",defaultValue:false},snapToRow:{type:"boolean",group:"Appearance",defaultValue:false},allowDenseFill:{type:"boolean",group:"Appearance",defaultValue:false},inlineBlockLayout:{type:"boolean",group:"Appearance",defaultValue:false}},defaultAggregation:"items",aggregations:{items:{type:"sap.ui.core.Control",multiple:true,singularName:"item",dnd:true},layout:{type:"sap.f.GridContainerSettings",multiple:false},layoutXS:{type:"sap.f.GridContainerSettings",multiple:false},layoutS:{type:"sap.f.GridContainerSettings",multiple:false},layoutM:{type:"sap.f.GridContainerSettings",multiple:false},layoutL:{type:"sap.f.GridContainerSettings",multiple:false},layoutXL:{type:"sap.f.GridContainerSettings",multiple:false},_defaultLayout:{type:"sap.f.GridContainerSettings",multiple:false,visibility:"hidden"}},events:{layoutChange:{parameters:{layout:{type:"string"}}}},dnd:{draggable:false,droppable:true}}});l.prototype.bUseExtendedChangeDetection=true;l.prototype.getActiveLayoutSettings=function(){var s=this.getAggregation(this._sActiveLayout);if(!s&&this._sActiveLayout==="layoutXS"){s=this.getAggregation("layoutS");}if(!s){s=this.getAggregation("layout")||this.getAggregation("_defaultLayout");}return s;};l.prototype._onBeforeItemRendering=function(){var o=this.getParent();if(o._reflectItemVisibilityToWrapper(this)&&!f()){o._scheduleIEPolyfill();}};l.prototype._onAfterItemRendering=function(){var i=this.getParent();if(!i._resizeListeners[this.getId()]){i._resizeListeners[this.getId()]=R.register(this,i._resizeItemHandler);}i._setItemNavigationItems();if(!f()){i._scheduleIEPolyfill();return;}i._applyItemAutoRows(this);};l.prototype._reflectItemVisibilityToWrapper=function(i){var o=i.getDomRef(),k=document.getElementById(d.createInvisiblePlaceholderId(i)),m,$;if(!o&&!k){return false;}m=(o?o:k).parentElement;$=jQuery(m);if(i.getVisible()&&$.hasClass("sapFGridContainerInvisiblePlaceholder")){$.removeClass("sapFGridContainerInvisiblePlaceholder");}else if(!i.getVisible()&&!$.hasClass("sapFGridContainerInvisiblePlaceholder")){$.addClass("sapFGridContainerInvisiblePlaceholder");return true;}return false;};l.prototype._onItemChange=function(i){if(i.name!=="items"||!i.child){return;}if(i.mutation==="insert"){i.child.addEventDelegate(this._itemDelegate,i.child);}else if(i.mutation==="remove"){i.child.removeEventDelegate(this._itemDelegate,i.child);}};l.prototype._deregisterResizeListeners=function(){var k,i;for(k in this._resizeListeners){i=this._resizeListeners[k];R.deregister(i);}delete this._resizeListeners;if(!this.getContainerQuery()){D.resize.detachHandler(this._resizeHandler);}};l.prototype._setItemNavigationItems=function(){if(!this._isRenderingFinished){return;}};l.prototype._detectActiveLayout=function(){var w=(this.getContainerQuery()&&this.getDomRef())?this._getComputedWidth():D.resize.width,r=D.media.getCurrentRange("GridContainerRangeSet",w),L="layout"+r.name,o=this.getActiveLayoutSettings(),s=false;if(!w){return false;}if(this._sActiveLayout!==L){this.addStyleClass("sapFGridContainer"+c(L));if(this._sActiveLayout){this.removeStyleClass("sapFGridContainer"+c(this._sActiveLayout));}this._sActiveLayout=L;s=o!==this.getActiveLayoutSettings();this.fireLayoutChange({layout:this._sActiveLayout});}return s;};l.prototype._getActiveGridStyles=function(){var s=this.getActiveLayoutSettings(),i=s.getColumns()||"auto-fill",k=s.getColumnSize(),m=s.getMinColumnSize(),n=s.getMaxColumnSize(),S={"grid-gap":s.getGap()};if(m&&n){S["grid-template-columns"]="repeat("+i+", minmax("+m+", "+n+"))";}else{S["grid-template-columns"]="repeat("+i+", "+k+")";}if(this.getInlineBlockLayout()){S["grid-auto-rows"]="min-content";}else{S["grid-auto-rows"]=s.getRowSize();}return S;};l.prototype.init=function(){this.setAggregation("_defaultLayout",new b());this._initRangeSet();this._resizeListeners={};this._itemDelegate={onBeforeRendering:this._onBeforeItemRendering,onAfterRendering:this._onAfterItemRendering};this._itemsObserver=new M(this._onItemChange.bind(this));this._itemsObserver.observe(this,{aggregations:["items"]});this._resizeHandler=this._resize.bind(this);if(!this.getContainerQuery()){D.resize.attachHandler(this._resizeHandler);}this._resizeItemHandler=this._resizeItem.bind(this);this._itemNavigation=new I().setCycling(false);this._itemNavigation.setDisabledModifiers({sapnext:["alt","meta"],sapprevious:["alt","meta"]});this.addDelegate(this._itemNavigation);if(!f()){this._attachDndPolyfill();}};l.prototype.insertItem=function(i,k){if(!this.getDomRef()||!f()){return this.insertAggregation("items",i,k);}var r=a.createRenderManager(),w=this._createItemWrapper(i),t=this._getItemAt(k),o=this.getDomRef();if(t){o.insertBefore(w,t.getDomRef().parentElement);}else{o.appendChild(w);}this.insertAggregation("items",i,k,true);r.render(i,w);r.destroy();return this;};l.prototype.removeItem=function(i){var r=this.removeAggregation("items",i,true),o=this.getDomRef(),k=r.getDomRef();if(!o||!k||!f()){this.invalidate();return r;}o.removeChild(k.parentElement);return r;};l.prototype.onBeforeRendering=function(){this._detectActiveLayout();var r=this._resizeListeners[this.getId()];if(r){R.deregister(r);}this._isRenderingFinished=false;};l.prototype.onAfterRendering=function(){this._resizeListeners[this.getId()]=R.register(this.getDomRef(),this._resizeHandler);this._isRenderingFinished=true;this._setItemNavigationItems();this._applyLayout(true);};l.prototype.exit=function(){this._deregisterResizeListeners();if(this._itemsObserver){this._itemsObserver.disconnect();delete this._itemsObserver;}if(this._itemNavigation){this.removeDelegate(this._itemNavigation);this._itemNavigation.destroy();delete this._itemNavigation;}if(!f()){this._detachDndPolyfill();}};l.prototype._initRangeSet=function(){if(!D.media.hasRangeSet("GridContainerRangeSet")){D.media.initRangeSet("GridContainerRangeSet",[375,600,1024,1440],"px",["XS","S","M","L","XL"]);}};l.prototype._resize=function(){if(!this._isWidthChanged()){return;}var s=this._detectActiveLayout();this._applyLayout(s);};l.prototype._isWidthChanged=function(){var i=this._getComputedWidth(),v=D.resize.width;if(this._lastGridWidth===i&&this._lastViewportWidth===v){return false;}this._lastGridWidth=i;this._lastViewportWidth=v;return true;};l.prototype._getComputedWidth=function(){if(!this.getDomRef()){return null;}return this.getDomRef().getBoundingClientRect().width;};l.prototype._resizeItem=function(o){if(!f()){this._scheduleIEPolyfill();return;}this._applyItemAutoRows(o.control);};l.prototype._applyLayout=function(s){if(!this._isRenderingFinished){return;}if(!f()){this._scheduleIEPolyfill(s);return;}if(s){this.$().css(this._getActiveGridStyles());this.getItems().forEach(this._applyItemAutoRows.bind(this));}this._enforceMaxColumns();};l.prototype._applyItemAutoRows=function(i){if(!this._isRenderingFinished){return;}if(this.getInlineBlockLayout()){return;}if(j(i)){var $=i.$(),s=this.getActiveLayoutSettings(),r=s.calculateRowsForItem($.outerHeight());if(!r){return;}$.parent().css({'grid-row':'span '+Math.max(r,h(i))});}};l.prototype._enforceMaxColumns=function(){var s=this.getActiveLayoutSettings(),m=s.getComputedColumnsCount(this.$().innerWidth());if(!m){return;}this.getItems().forEach(function(i){i.$().parent().css("grid-column","span "+Math.min(g(i),m));});};l.prototype._getItemAt=function(i){var k=this.getItems(),t;if(i<0){i=0;}if(k.length&&k[i]){t=k[i];}return t;};l.prototype._createItemWrapper=function(i){var s=G.getStylesForItemWrapper(i,this),S=s.styles,k=s.classes,w=document.createElement("div");S.forEach(function(v,K){w.style.setProperty(K,v);});k.forEach(function(v){w.classList.add(v);});return w;};l.prototype._scheduleIEPolyfill=function(i){if(this._iPolyfillCallId){clearTimeout(this._iPolyfillCallId);}if(i){this._applyIEPolyfillLayout();return;}this._iPolyfillCallId=setTimeout(this._applyIEPolyfillLayout.bind(this),0);};l.prototype._applyIEPolyfillLayout=function(){if(!this._isRenderingFinished){return;}var $=this.$(),m=$.innerWidth(),s=this.getActiveLayoutSettings(),n=s.getMinColumnSizeInPx()||s.getColumnSizeInPx(),r=s.getRowSizeInPx(),o=s.getGapInPx(),p=s.getComputedColumnsCount(m),t=parseInt($.css("padding-top").replace("px","")),q=parseInt($.css("padding-left").replace("px","")),u=this.getItems();if(!n||!r){return;}if(!u.length){return;}var v=new V();v.init({numberOfCols:Math.max(1,p),cellWidth:n,cellHeight:r,unitOfMeasure:"px",gapSize:o,topOffset:t?t:0,leftOffset:q?q:0,allowDenseFill:this.getAllowDenseFill(),rtl:e,width:m});var i,k,w,x,y,z,F=[];var A=function(K){v.fitElement(K+'',this._polyfillDropIndicator.columns||s.calculateColumnsForItem(Math.round(this._polyfillDropIndicator.width)),this._polyfillDropIndicator.rows||s.calculateRowsForItem(Math.round(this._polyfillDropIndicator.height)));F.push({id:K+'',domRef:this._polyfillDropIndicator.domRef});}.bind(this);for(i=0,k=0;i<u.length;i++){if(this._polyfillDropIndicator&&this._polyfillDropIndicator.insertAt===i){A(k);k++;}w=u[i];x=w.$();if(!x.is(":visible")){continue;}y=g(w);if(j(w)){z=this._calcAutoRowsForPolyfill(w,s);}else{z=h(w);}v.fitElement(k+'',y,z);F.push({id:k+'',domRef:x.parent()});k++;}if(this._polyfillDropIndicator&&this._polyfillDropIndicator.insertAt>=u.length){A(u.length);}v.calculatePositions();F.forEach(function(B){var H=v.getItems()[B.id];B.domRef.css({position:'absolute',top:H.top,left:H.left,width:H.width,height:H.height});});$.css("height",v.getHeight()+"px");if(!this.getWidth()&&s.getColumns()){$.css("width",v.getWidth()+"px");}};l.prototype._calcAutoRowsForPolyfill=function(i,o){var $=i.$(),k,r;if($.hasClass("sapFCardAnalytical")){k=$[0].scrollHeight;}else{k=$.outerHeight();}r=Math.max(o.calculateRowsForItem(k),h(i));return r;};l.prototype._polyfillAfterDragOver=function(o){var $=o.getParameter("indicator");this._polyfillDropIndicator={rows:o.getParameter("rows"),columns:o.getParameter("columns"),width:o.getParameter("width"),height:o.getParameter("height"),domRef:$,insertAt:$.index()};this._scheduleIEPolyfill();};l.prototype._polyfillAfterDragEnd=function(o){this._polyfillDropIndicator=null;};l.prototype._attachDndPolyfill=function(){this.attachEvent("_gridPolyfillAfterDragOver",this._polyfillAfterDragOver,this);this.attachEvent("_gridPolyfillAfterDragEnd",this._polyfillAfterDragEnd,this);};l.prototype._detachDndPolyfill=function(){this.detachEvent("_gridPolyfillAfterDragOver",this._polyfillAfterDragOver,this);this.detachEvent("_gridPolyfillAfterDragEnd",this._polyfillAfterDragEnd,this);};return l;});
