/*!
 * OpenUI5
 * (c) Copyright 2009-2019 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["sap/f/library","sap/ui/core/Control","sap/m/Text","sap/f/Avatar","sap/ui/Device",'sap/f/cards/DataProviderFactory','sap/ui/model/json/JSONModel',"sap/f/cards/HeaderRenderer","sap/f/cards/IconFormatter","sap/f/cards/CardActions","sap/base/strings/formatMessage"],function(l,C,T,A,D,a,J,H,I,b,f){"use strict";var c=l.AvatarShape;var d=l.cards.AreaType;var e=C.extend("sap.f.cards.Header",{metadata:{library:"sap.f",interfaces:["sap.f.cards.IHeader"],properties:{title:{type:"string",defaultValue:""},subtitle:{type:"string",defaultValue:""},statusText:{type:"string",defaultValue:""},iconDisplayShape:{type:"sap.f.AvatarShape",defaultValue:c.Circle},iconSrc:{type:"sap.ui.core.URI",defaultValue:""},iconInitials:{type:"string",defaultValue:""}},aggregations:{_title:{type:"sap.m.Text",multiple:false,visibility:"hidden"},_subtitle:{type:"sap.m.Text",multiple:false,visibility:"hidden"},_avatar:{type:"sap.f.Avatar",multiple:false,visibility:"hidden"}},events:{press:{}}}});e.prototype.init=function(){this._aReadyPromises=[];this._bReady=false;this._awaitEvent("_dataReady");this._awaitEvent("_actionHeaderReady");Promise.all(this._aReadyPromises).then(function(){this._bReady=true;this.fireEvent("_ready");}.bind(this));this.setBusyIndicatorDelay(0);};e.prototype.exit=function(){this._oServiceManager=null;this._oDataProviderFactory=null;if(this._oDataProvider){this._oDataProvider.destroy();this._oDataProvider=null;}if(this._oActions){this._oActions.destroy();this._oActions=null;}};e.prototype._awaitEvent=function(E){this._aReadyPromises.push(new Promise(function(r){this.attachEventOnce(E,function(){r();});}.bind(this)));};e.prototype.isReady=function(){return this._bReady;};e.prototype._getTitle=function(){var t=this.getAggregation("_title");if(!t){t=new T({maxLines:3}).addStyleClass("sapFCardTitle");this.setAggregation("_title",t);}return t;};e.prototype._getSubtitle=function(){var s=this.getAggregation("_subtitle");if(!s){s=new T({maxLines:2}).addStyleClass("sapFCardSubtitle");this.setAggregation("_subtitle",s);}return s;};e.prototype._getAvatar=function(){var o=this.getAggregation("_avatar");if(!o){o=new A().addStyleClass("sapFCardIcon");this.setAggregation("_avatar",o);}return o;};e.prototype.onBeforeRendering=function(){this._getTitle().setText(this.getTitle());this._getSubtitle().setText(this.getSubtitle());this._getAvatar().setDisplayShape(this.getIconDisplayShape());if(this.isInsideIntegrationCard()&&this.getIconSrc()){var s=this.getBindingInfo("iconSrc");if(s){if(!s.formatter){s.formatter=function(v){return I.formatSrc(v,this._sAppId);}.bind(this);}this._getAvatar().bindProperty("src",s);}else{this._getAvatar().setSrc(I.formatSrc(this.getIconSrc(),this._sAppId));}}else{this._getAvatar().setSrc(this.getIconSrc());}this._getAvatar().setInitials(this.getIconInitials());};e.prototype._getHeaderAccessibility=function(){var t=this._getTitle()?this._getTitle().getId():"",s=this._getSubtitle()?this._getSubtitle().getId():"",g=this._getAvatar()?this._getAvatar().getId():"";return t+" "+s+" "+g;};e.prototype.onAfterRendering=function(){if(D.browser.msie){if(this.getTitle()){this._getTitle().clampText();}if(this.getSubtitle()){this._getSubtitle().clampText();}}};e.prototype.ontap=function(){this.firePress();};e.prototype.onsapselect=function(){this.firePress();};e.prototype.isInsideIntegrationCard=function(){var p=this.getParent();if(p&&p.isA("sap.ui.integration.widgets.Card")){return true;}return false;};e.create=function(m,s,o,g){var S={title:m.title,subtitle:m.subTitle};if(m.icon){S.iconSrc=m.icon.src;S.iconDisplayShape=m.icon.shape;S.iconInitials=m.icon.text;}if(m.status&&typeof m.status.text==="string"){S.statusText=m.status.text;}var h=new e(S);h._sAppId=g;if(m.status&&m.status.text&&m.status.text.format){e._bindStatusText(m.status.text.format,h);}h.setServiceManager(s);h.setDataProviderFactory(o);h._setData(m.data);var i=new b({areaType:d.Header});i.attach(m,h);h._oActions=i;return h;};e._bindStatusText=function(F,h){if(F.parts&&F.translationKey&&F.parts.length===2){var B={parts:[F.translationKey,F.parts[0].toString(),F.parts[1].toString()],formatter:function(t,p,P){var s=p||F.parts[0];var g=P||F.parts[1];if(Array.isArray(p)){s=p.length;}if(Array.isArray(P)){g=P.length;}var i=parseFloat(s)||0;var j=parseFloat(g)||0;return f(t,[i,j]);}};h.bindProperty("statusText",B);}};e.prototype.setServiceManager=function(s){this._oServiceManager=s;return this;};e.prototype.setDataProviderFactory=function(o){this._oDataProviderFactory=o;return this;};e.prototype._setData=function(o){var p="/";if(o&&o.path){p=o.path;}this.bindObject(p);if(this._oDataProvider){this._oDataProvider.destroy();}this._oDataProvider=this._oDataProviderFactory.create(o,this._oServiceManager);if(this._oDataProvider){this.setBusy(true);this.setModel(new J());this._oDataProvider.attachDataChanged(function(E){this._updateModel(E.getParameter("data"));this.setBusy(false);}.bind(this));this._oDataProvider.attachError(function(E){this._handleError(E.getParameter("message"));this.setBusy(false);}.bind(this));this._oDataProvider.triggerDataUpdate().then(function(){this.fireEvent("_dataReady");}.bind(this));}else{this.fireEvent("_dataReady");}};e.prototype._updateModel=function(o){this.getModel().setData(o);};e.prototype._handleError=function(L){this.fireEvent("_error",{logMessage:L});};return e;});
