/*!
 * OpenUI5
 * (c) Copyright 2009-2019 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(['sap/f/library','sap/ui/core/Control',"sap/f/cards/CardActions",'sap/m/NumericContent','sap/m/Text','sap/ui/model/json/JSONModel',"sap/f/cards/NumericSideIndicator","sap/f/cards/NumericHeaderRenderer","sap/base/strings/formatMessage"],function(l,C,a,N,T,J,b,c,f){"use strict";var A=l.cards.AreaType;var d=C.extend("sap.f.cards.NumericHeader",{metadata:{library:"sap.f",interfaces:["sap.f.cards.IHeader"],properties:{title:{"type":"string",group:"Appearance"},subtitle:{"type":"string",group:"Appearance"},statusText:{type:"string",defaultValue:""},unitOfMeasurement:{"type":"string",group:"Data"},number:{"type":"string",group:"Data"},scale:{"type":"string",group:"Data"},trend:{"type":"sap.m.DeviationIndicator",group:"Appearance",defaultValue:"None"},state:{"type":"sap.m.ValueColor",group:"Appearance",defaultValue:"Neutral"},details:{"type":"string",group:"Appearance"}},aggregations:{sideIndicators:{type:"sap.f.cards.NumericSideIndicator",multiple:true},_title:{type:"sap.m.Text",multiple:false,visibility:"hidden"},_subtitle:{type:"sap.m.Text",multiple:false,visibility:"hidden"},_unitOfMeasurement:{type:"sap.m.Text",multiple:false,visibility:"hidden"},_details:{type:"sap.m.Text",multiple:false,visibility:"hidden"},_mainIndicator:{type:"sap.m.NumericContent",multiple:false,visibility:"hidden"}},events:{press:{}}}});d.prototype.init=function(){this._aReadyPromises=[];this._bReady=false;this._awaitEvent("_dataReady");Promise.all(this._aReadyPromises).then(function(){this._bReady=true;this.fireEvent("_ready");}.bind(this));this.setBusyIndicatorDelay(0);};d.prototype.exit=function(){this._oServiceManager=null;this._oDataProviderFactory=null;if(this._oDataProvider){this._oDataProvider.destroy();this._oDataProvider=null;}if(this._oActions){this._oActions.destroy();this._oActions=null;}};d.prototype._awaitEvent=function(e){this._aReadyPromises.push(new Promise(function(r){this.attachEventOnce(e,function(){r();});}.bind(this)));};d.prototype.isReady=function(){return this._bReady;};d.prototype.setTitle=function(v){this.setProperty("title",v,true);this._getTitle().setText(v);return this;};d.prototype.setSubtitle=function(v){this.setProperty("subtitle",v,true);this._getSubtitle().setText(v);return this;};d.prototype.setUnitOfMeasurement=function(v){this.setProperty("unitOfMeasurement",v,true);this._getUnitOfMeasurement().setText(v);return this;};d.prototype.setDetails=function(v){this.setProperty("details",v,true);this._getDetails().setText(v);return this;};d.prototype.setNumber=function(v){this.setProperty("number",v,true);this._getMainIndicator().setValue(v);return this;};d.prototype.setScale=function(v){this.setProperty("scale",v,true);this._getMainIndicator().setScale(v);return this;};d.prototype.setTrend=function(v){this.setProperty("trend",v,true);this._getMainIndicator().setIndicator(v);return this;};d.prototype.setState=function(v){this.setProperty("state",v,true);this._getMainIndicator().setValueColor(v);return this;};d.prototype._getTitle=function(){var o=this.getAggregation("_title");if(!o){o=new T({id:this.getId()+"-title",wrapping:true,maxLines:3});this.setAggregation("_title",o);}return o;};d.prototype._getSubtitle=function(){var o=this.getAggregation("_subtitle");if(!o){o=new T({id:this.getId()+"-subtitle",wrapping:true,maxLines:2});this.setAggregation("_subtitle",o);}return o;};d.prototype._getUnitOfMeasurement=function(){var o=this.getAggregation("_unitOfMeasurement");if(!o){o=new T({id:this.getId()+"-unitOfMeasurement",wrapping:false});this.setAggregation("_unitOfMeasurement",o);}return o;};d.prototype._getDetails=function(){var o=this.getAggregation("_details");if(!o){o=new T({id:this.getId()+"-details",wrapping:false});this.setAggregation("_details",o);}return o;};d.prototype._getMainIndicator=function(){var o=this.getAggregation("_mainIndicator");if(!o){o=new N({id:this.getId()+"-mainIndicator",withMargin:false,nullifyValue:false,animateTextChange:false,truncateValueTo:5});this.setAggregation("_mainIndicator",o);}return o;};d.prototype.ontap=function(){this.firePress();};d.prototype.onsapselect=function(){this.firePress();};d.create=function(m,s,D,e){var S={title:m.title,subtitle:m.subTitle,unitOfMeasurement:m.unitOfMeasurement,details:m.details};if(m.mainIndicator){S.number=m.mainIndicator.number;S.scale=m.mainIndicator.unit;S.trend=m.mainIndicator.trend;S.state=m.mainIndicator.state;}if(m.sideIndicators){S.sideIndicators=m.sideIndicators.map(function(i){return new b(i);});}if(m.status&&typeof m.status.text==="string"){S.statusText=m.status.text;}var h=new d(S);h._sAppId=e;if(m.status&&m.status.text&&m.status.text.format){d._bindStatusText(m.status.text.format,h);}h.setServiceManager(s);h.setDataProviderFactory(D);h._setData(m.data);var o=new a({areaType:A.Header});o.attach(m,h);h._oActions=o;return h;};d._bindStatusText=function(F,h){if(F.parts&&F.translationKey&&F.parts.length===2){var B={parts:[F.translationKey,F.parts[0].toString(),F.parts[1].toString()],formatter:function(t,p,P){var s=p||F.parts[0];var e=P||F.parts[1];if(Array.isArray(p)){s=p.length;}if(Array.isArray(P)){e=P.length;}var i=parseFloat(s)||0;var g=parseFloat(e)||0;return f(t,[i,g]);}};h.bindProperty("statusText",B);}};d.prototype.setServiceManager=function(s){this._oServiceManager=s;return this;};d.prototype.setDataProviderFactory=function(D){this._oDataProviderFactory=D;return this;};d.prototype._setData=function(D){var p="/";if(D&&D.path){p=D.path;}this.bindObject(p);if(this._oDataProvider){this._oDataProvider.destroy();}this._oDataProvider=this._oDataProviderFactory.create(D,this._oServiceManager);if(this._oDataProvider){this.setBusy(true);this.setModel(new J());this._oDataProvider.attachDataChanged(function(e){this._updateModel(e.getParameter("data"));this.setBusy(false);}.bind(this));this._oDataProvider.attachError(function(e){this._handleError(e.getParameter("message"));this.setBusy(false);}.bind(this));this._oDataProvider.triggerDataUpdate().then(function(){this.fireEvent("_dataReady");}.bind(this));}else{this.fireEvent("_dataReady");}};d.prototype._updateModel=function(D){this.getModel().setData(D);};d.prototype._handleError=function(L){this.fireEvent("_error",{logMessage:L});};d.prototype._getHeaderAccessibility=function(){var t=this._getTitle()?this._getTitle().getId():"",s=this._getSubtitle()?this._getSubtitle().getId():"",u=this._getUnitOfMeasurement()?this._getUnitOfMeasurement().getId():"",S=this.getSideIndicators()?this._getSideIndicatorIds():"",D=this._getDetails()?this._getDetails().getId():"",m=this._getMainIndicator()?this._getMainIndicator().getId():"";return t+" "+s+" "+u+" "+m+S+" "+D;};d.prototype._getSideIndicatorIds=function(){var s="";this.getSideIndicators().forEach(function(S){s+=" "+S.getId();});return s;};return d;});
