//@ui5-bundle sap/f/library-preload.js
/*!
 * OpenUI5
 * (c) Copyright 2009-2019 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine('sap/f/Avatar',["./library","sap/ui/core/Control","sap/ui/core/IconPool","./AvatarRenderer","sap/ui/events/KeyCodes","sap/base/Log"],function(l,C,I,A,K,L){"use strict";var a=l.AvatarType;var b=l.AvatarImageFitType;var c=l.AvatarColor;var d=l.AvatarSize;var e=l.AvatarShape;
var f=C.extend("sap.f.Avatar",{metadata:{library:"sap.f",properties:{src:{type:"sap.ui.core.URI",group:"Data",defaultValue:null},initials:{type:"string",group:"Data",defaultValue:null},displayShape:{type:"sap.f.AvatarShape",group:"Appearance",defaultValue:e.Circle},displaySize:{type:"sap.f.AvatarSize",group:"Appearance",defaultValue:d.S},customDisplaySize:{type:"sap.ui.core.CSSSize",group:"Appearance",defaultValue:"3rem"},customFontSize:{type:"sap.ui.core.CSSSize",group:"Appearance",defaultValue:"1.125rem"},imageFitType:{type:"sap.f.AvatarImageFitType",group:"Appearance",defaultValue:b.Cover},fallbackIcon:{type:"string",group:"Data",defaultValue:null},backgroundColor:{type:"sap.f.AvatarColor",group:"Appearance",defaultValue:c.Accent6},showBorder:{type:"boolean",group:"Appearance",defaultValue:false}},aggregations:{detailBox:{type:'sap.m.LightBox',multiple:false,bindable:"bindable"}},associations:{ariaDescribedBy:{type:"sap.ui.core.Control",multiple:true,singularName:"ariaDescribedBy"},ariaLabelledBy:{type:"sap.ui.core.Control",multiple:true,singularName:"ariaLabelledBy"}},events:{press:{}},dnd:{draggable:true,droppable:false},designtime:"sap/f/designtime/Avatar.designtime"}});
f.DEFAULT_CIRCLE_PLACEHOLDER="sap-icon://person-placeholder";f.DEFAULT_SQUARE_PLACEHOLDER="sap-icon://product";
f.prototype.init=function(){this._sActualType=null;this._bIsDefaultIcon=true;this._sImageFallbackType=null;};
f.prototype.exit=function(){if(this._icon){this._icon.destroy();}if(this._fnLightBoxOpen){this._fnLightBoxOpen=null;}};
f.prototype.setDetailBox=function(o){var g=this.getDetailBox();if(o){if(o===g){return this;}if(g){this.detachPress(this._fnLightBoxOpen,g);}this._fnLightBoxOpen=o.open;this.attachPress(this._fnLightBoxOpen,o);}else if(this._fnLightBoxOpen){this.detachPress(this._fnLightBoxOpen,g);this._fnLightBoxOpen=null;}return this.setAggregation("detailBox",o);};
f.prototype.clone=function(){var o=C.prototype.clone.apply(this,arguments),g=o.getDetailBox();if(g){o.detachPress(this._fnLightBoxOpen,this.getDetailBox());o._fnLightBoxOpen=g.open;o.attachPress(o._fnLightBoxOpen,g);}return o;};
f.prototype.attachPress=function(){Array.prototype.unshift.apply(arguments,["press"]);C.prototype.attachEvent.apply(this,arguments);if(this.hasListeners("press")){this.$().attr("tabindex","0");this.$().attr("role","button");}return this;};
f.prototype.detachPress=function(){Array.prototype.unshift.apply(arguments,["press"]);C.prototype.detachEvent.apply(this,arguments);if(!this.hasListeners("press")){this.$().removeAttr("tabindex");this.$().attr("role","img");}return this;};
f.prototype.ontap=function(){this.firePress({});};
f.prototype.onkeyup=function(E){if(E.which===K.SPACE||E.which===K.ENTER){this.firePress({});E.stopPropagation();}};
f.prototype._areInitialsValid=function(i){var v=/^[a-zA-Z]{1,2}$/;if(!v.test(i)){L.warning("Initials should consist of only 1 or 2 latin letters",this);this._sActualType=a.Icon;this._bIsDefaultIcon=true;return false;}return true;};
f.prototype._validateSrc=function(s){if(I.isIconURI(s)){this._sActualType=a.Icon;this._bIsDefaultIcon=I.getIconInfo(s)?false:true;}else{this._bIsDefaultIcon=true;this._sActualType=a.Image;this.preloadedImage=new window.Image();this.preloadedImage.src=s;this.preloadedImage.onload=this._onImageLoad.bind(this);this.preloadedImage.onerror=this._onImageError.bind(this);}return this;};
f.prototype._getActualDisplayType=function(){var s=this.getSrc(),i=this.getInitials();if(s){this._validateSrc(s);}else if(i&&this._areInitialsValid(i)){this._sActualType=a.Initials;}else{L.warning("No src and initials were provided",this);this._sActualType=a.Icon;this._bIsDefaultIcon=true;}return this._sActualType;};
f.prototype._getImageFallbackType=function(){var i=this.getInitials();if(this._sActualType===a.Image){this._sImageFallbackType=i&&this._areInitialsValid(i)?a.Initials:a.Icon;}return this._sImageFallbackType;};
f.prototype._getDefaultIconPath=function(D){var s=null,F=this.getFallbackIcon();if(F&&I.isIconURI(F)){s=F;}else if(D===e.Circle){s=f.DEFAULT_CIRCLE_PLACEHOLDER;}else if(D===e.Square){s=f.DEFAULT_SQUARE_PLACEHOLDER;}return s;};
f.prototype._getIcon=function(){var s=this.getSrc(),D=this.getDisplayShape();if(this._bIsDefaultIcon){s=this._getDefaultIconPath(D);}if(!this._icon){this._icon=I.createControlByURI({alt:"Image placeholder",src:s});}else if(this._icon.getSrc()!==s){this._icon.setSrc(s);}return this._icon;};
f.prototype._getDefaultTooltip=function(){return sap.ui.getCore().getLibraryResourceBundle("sap.f").getText("AVATAR_TOOLTIP");};
f.prototype._onImageLoad=function(){delete this.preloadedImage;};
f.prototype._onImageError=function(){var F=this._getImageFallbackType();this.$().removeClass("sapFAvatarImage").addClass("sapFAvatar"+F);delete this.preloadedImage;};
return f;});
sap.ui.predefine('sap/f/AvatarRenderer',["sap/f/library","sap/base/security/encodeCSS"],function(l,e){"use strict";var A=l.AvatarSize;var a=l.AvatarType;var b=l.AvatarColor;var c={apiVersion:2};
c.render=function(r,o){var i=o.getInitials(),s=o._getActualDisplayType(),I=o._getImageFallbackType(),d=o.getDisplaySize(),D=o.getDisplayShape(),f=o.getImageFitType(),C=o.getCustomDisplaySize(),g=o.getCustomFontSize(),S=o.getSrc(),h="sapFAvatar",t=o.getTooltip_AsString(),j=o._getDefaultTooltip(),L=o.getAriaLabelledBy(),k=o.getAriaDescribedBy(),m=t&&i?j+" "+t:j,n=i?j+" "+i:j;r.openStart("span",o);r.class(h);c.addBackgroundColorClass(r,o);r.class(h+d);r.class(h+s);r.class(h+D);if(o.hasListeners("press")){r.class("sapMPointer");r.class(h+"Focusable");r.attr("role","button");r.attr("tabindex",0);}else{r.attr("role","img");}if(o.getShowBorder()){r.class("sapFAvatarBorder");}if(d===A.Custom){r.style("width",C);r.style("height",C);r.style("font-size",g);}if(t){r.attr("title",t);r.attr("aria-label",m);}else{r.attr("aria-label",n);}if(L&&L.length>0){r.attr("aria-labelledby",L.join(" "));}if(k&&k.length>0){r.attr("aria-describedby",k.join(" "));}r.openEnd();if(s===a.Icon||I===a.Icon){r.renderControl(o._getIcon());}else if(s===a.Initials||I===a.Initials){r.openStart("span");r.class(h+"InitialsHolder");r.openEnd();r.text(i);r.close("span");}if(s===a.Image){r.openStart("span");r.class(h+"ImageHolder");r.class(h+s+f);r.style("background-image","url('"+e(S)+"')");r.openEnd();r.close("span");}if(o._fnLightBoxOpen){r.openStart("span").class(h+"MagnifyingGlass").openEnd().close("span");}r.close("span");};
c.addBackgroundColorClass=function(r,o){var B=o.getBackgroundColor(),k;if(o.getBackgroundColor()===b.Random){k=Object.keys(b);k.splice(k.indexOf(b.Random),1);B=b[k[k.length*Math.random()<<0]];}r.class("sapFAvatarColor"+B);};
return c;},true);
sap.ui.predefine('sap/f/Card',["sap/ui/core/Control","sap/f/CardRenderer","sap/f/library"],function(C,a,l){"use strict";var H=l.cards.HeaderPosition;
var b=C.extend("sap.f.Card",{
metadata:{library:"sap.f",interfaces:["sap.f.ICard"],properties:{width:{type:"sap.ui.core.CSSSize",group:"Appearance",defaultValue:"100%"},height:{type:"sap.ui.core.CSSSize",group:"Appearance",defaultValue:"auto"},headerPosition:{type:"sap.f.cards.HeaderPosition",group:"Appearance",defaultValue:H.Top}},aggregations:{header:{type:"sap.f.cards.IHeader",multiple:false},content:{type:"sap.ui.core.Control",multiple:false}}},
renderer:a
});
b.prototype.getCardHeader=function(){return this.getHeader();};
b.prototype.getCardHeaderPosition=function(){return this.getHeaderPosition();};
b.prototype.getCardContent=function(){return this.getContent();};
return b;});
sap.ui.predefine('sap/f/CardRenderer',["sap/f/library"],function(l){"use strict";var H=l.cards.HeaderPosition;var C={},r=sap.ui.getCore().getLibraryResourceBundle("sap.f");
C.render=function(R,c){var h=c.getCardHeader(),s=c.getHeight(),b=h&&c.getCardHeaderPosition()===H.Bottom;R.write("<div");R.writeElementData(c);R.addClass("sapFCard");if(!c.getCardContent()){R.addClass("sapFCardNoContent");}if(b){R.addClass("sapFCardBottomHeader");}R.writeClasses();R.addStyle("width",c.getWidth());if(s&&s!=='auto'){R.addStyle("height",s);}R.writeAccessibilityState(c,{role:"region",roledescription:{value:r.getText("ARIA_ROLEDESCRIPTION_CARD"),append:true}});if(h){var t=h._getTitle();if(t){R.writeAccessibilityState(c,{labelledby:{value:t.getId(),append:true}});}}R.writeStyles();R.write(">");if(h&&c.getCardHeaderPosition()==="Top"){R.renderControl(h);}C.renderContentSection(R,c);if(b){R.renderControl(h);}R.write("</div>");};
C.renderContentSection=function(R,c){var o=c.getCardContent();if(o){R.write("<div");R.addClass("sapFCardContent");R.writeClasses();R.writeAccessibilityState(c,{role:"group",label:{value:r.getText("ARIA_LABEL_CARD_CONTENT"),append:true}});R.write(">");R.renderControl(o);R.write("</div>");}};
return C;});
sap.ui.predefine('sap/f/DynamicPage',["./library","sap/ui/core/Control","sap/m/ScrollBar","sap/m/library","sap/ui/base/ManagedObjectObserver","sap/ui/core/ResizeHandler","sap/ui/core/Configuration","sap/ui/core/delegate/ScrollEnablement","sap/ui/Device","sap/f/DynamicPageTitle","sap/f/DynamicPageHeader","./DynamicPageRenderer","sap/base/Log","sap/ui/dom/getScrollbarSize","sap/ui/core/library"],function(l,C,S,L,M,R,a,b,D,c,d,e,f,g,h){"use strict";var P=L.PageBackgroundDesign;
var i=C.extend("sap.f.DynamicPage",{metadata:{library:"sap.f",properties:{preserveHeaderStateOnScroll:{type:"boolean",group:"Behavior",defaultValue:false},headerExpanded:{type:"boolean",group:"Behavior",defaultValue:true},toggleHeaderOnTitleClick:{type:"boolean",group:"Behavior",defaultValue:true},showFooter:{type:"boolean",group:"Behavior",defaultValue:false},backgroundDesign:{type:"sap.m.PageBackgroundDesign",group:"Appearance",defaultValue:P.Standard},fitContent:{type:"boolean",group:"Behavior",defaultValue:false}},associations:{stickySubheaderProvider:{type:"sap.f.IDynamicPageStickyContent",multiple:false}},aggregations:{title:{type:"sap.f.DynamicPageTitle",multiple:false},header:{type:"sap.f.DynamicPageHeader",multiple:false},content:{type:"sap.ui.core.Control",multiple:false},footer:{type:"sap.m.IBar",multiple:false},landmarkInfo:{type:"sap.f.DynamicPageAccessibleLandmarkInfo",multiple:false},_scrollBar:{type:"sap.ui.core.Control",multiple:false,visibility:"hidden"}},dnd:{draggable:false,droppable:true},designtime:"sap/f/designtime/DynamicPage.designtime"}});
function j(o){if(arguments.length===1){return o&&("length"in o)?o.length>0:!!o;}return Array.prototype.slice.call(arguments).every(function(O){return j(O);});}
function k(E){var o;if(!E){return false;}o=E.getBoundingClientRect();return!!(o.width&&o.height);}
var A=h.AccessibleLandmarkRole;i.HEADER_MAX_ALLOWED_PINNED_PERCENTAGE=0.6;i.HEADER_MAX_ALLOWED_NON_SROLLABLE_PERCENTAGE=0.6;i.HEADER_MAX_ALLOWED_NON_SROLLABLE_ON_MOBILE=0.3;i.BREAK_POINTS={TABLET:1024,PHONE:600};i.EVENTS={TITLE_PRESS:"_titlePress",TITLE_MOUSE_OVER:"_titleMouseOver",TITLE_MOUSE_OUT:"_titleMouseOut",PIN_UNPIN_PRESS:"_pinUnpinPress",VISUAL_INDICATOR_MOUSE_OVER:"_visualIndicatorMouseOver",VISUAL_INDICATOR_MOUSE_OUT:"_visualIndicatorMouseOut",HEADER_VISUAL_INDICATOR_PRESS:"_headerVisualIndicatorPress",TITLE_VISUAL_INDICATOR_PRESS:"_titleVisualIndicatorPress"};i.MEDIA={PHONE:"sapFDynamicPage-Std-Phone",TABLET:"sapFDynamicPage-Std-Tablet",DESKTOP:"sapFDynamicPage-Std-Desktop"};i.RESIZE_HANDLER_ID={PAGE:"_sResizeHandlerId",TITLE:"_sTitleResizeHandlerId",HEADER:"_sHeaderResizeHandlerId",CONTENT:"_sContentResizeHandlerId"};i.DIV="div";i.HEADER="header";i.FOOTER="footer";i.SHOW_FOOTER_CLASS_NAME="sapFDynamicPageActualFooterControlShow";i.HIDE_FOOTER_CLASS_NAME="sapFDynamicPageActualFooterControlHide";
i.prototype.init=function(){this._bPinned=false;this._bHeaderInTitleArea=false;this._bExpandingWithAClick=false;this._bSuppressToggleHeaderOnce=false;this._headerBiggerThanAllowedHeight=false;this._oStickySubheader=null;this._bStickySubheaderInTitleArea=false;this._bMSBrowser=D.browser.internet_explorer||D.browser.edge||false;this._oScrollHelper=new b(this,this.getId()+"-content",{horizontal:false,vertical:true});this._oStickyHeaderObserver=null;this._oHeaderObserver=null;this._oSubHeaderAfterRenderingDelegate={onAfterRendering:function(){this._bStickySubheaderInTitleArea=false;this._adjustStickyContent();}};};
i.prototype.onBeforeRendering=function(){if(!this._preserveHeaderStateOnScroll()){this._attachPinPressHandler();}this._attachTitlePressHandler();this._attachVisualIndicatorsPressHandlers();this._attachVisualIndicatorMouseOverHandlers();this._attachTitleMouseOverHandlers();this._attachHeaderObserver();this._addStickySubheaderAfterRenderingDelegate();this._detachScrollHandler();};
i.prototype.onAfterRendering=function(){var s,m;if(this._preserveHeaderStateOnScroll()){setTimeout(this._overridePreserveHeaderStateOnScroll.bind(this),0);}this._bPinned=false;this._cacheDomElements();this._detachResizeHandlers();this._attachResizeHandlers();this._updateMedia(this._getWidth(this));this._attachScrollHandler();this._updateScrollBar();this._attachPageChildrenAfterRenderingDelegates();this._resetPinButtonState();if(!this.getHeaderExpanded()){this._snapHeader(false);s=this.getHeader()&&!this.getPreserveHeaderStateOnScroll()&&this._canSnapHeaderOnScroll();if(s){m=this._getScrollBar().getScrollPosition();this._setScrollPosition(m?m:this._getSnappingHeight());}else{this._toggleHeaderVisibility(false);this._moveHeaderToTitleArea();}}this._updateToggleHeaderVisualIndicators();this._updateTitleVisualState();};
i.prototype.exit=function(){this._detachResizeHandlers();if(this._oScrollHelper){this._oScrollHelper.destroy();}if(this._oStickyHeaderObserver){this._oStickyHeaderObserver.disconnect();}if(this._oHeaderObserver){this._oHeaderObserver.disconnect();}if(this._oStickySubheader){this._oStickySubheader.removeEventDelegate(this._oSubHeaderAfterRenderingDelegate);}};
i.prototype.setShowFooter=function(s){var r=this.setProperty("showFooter",s,true);this._toggleFooter(s);return r;};
i.prototype.setHeader=function(H){var o;if(H===o){return;}o=this.getHeader();if(o){if(this._oStickyHeaderObserver){this._oStickyHeaderObserver.disconnect();}if(this._oHeaderObserver){this._oHeaderObserver.disconnect();}this._deRegisterResizeHandler(i.RESIZE_HANDLER_ID.HEADER);o.detachEvent(i.EVENTS.PIN_UNPIN_PRESS,this._onPinUnpinButtonPress);this._bAlreadyAttachedPinPressHandler=false;o.detachEvent(i.EVENTS.HEADER_VISUAL_INDICATOR_PRESS,this._onCollapseHeaderVisualIndicatorPress);this._bAlreadyAttachedHeaderIndicatorPressHandler=false;o.detachEvent(i.EVENTS.VISUAL_INDICATOR_MOUSE_OVER,this._onVisualIndicatorMouseOver);o.detachEvent(i.EVENTS.VISUAL_INDICATOR_MOUSE_OUT,this._onVisualIndicatorMouseOut);this._bAlreadyAttachedVisualIndicatorMouseOverOutHandler=false;this._bAlreadyAttachedStickyHeaderObserver=false;this._bAlreadyAttachedHeaderObserver=false;}this.setAggregation("header",H);return this;};
i.prototype.setStickySubheaderProvider=function(s){var o,O=this.getStickySubheaderProvider();if(s===O){return this;}o=sap.ui.getCore().byId(O);if(this._oStickySubheader&&o){o._returnStickyContent();o._setStickySubheaderSticked(false);this._oStickySubheader.removeEventDelegate(this._oSubHeaderAfterRenderingDelegate);this._bAlreadyAddedStickySubheaderAfterRenderingDelegate=false;this._oStickySubheader=null;}this.setAssociation("stickySubheaderProvider",s);return this;};
i.prototype.setHeaderExpanded=function(H){H=this.validateProperty("headerExpanded",H);if(this._bPinned){return this;}if(this.getHeaderExpanded()===H){return this;}if(this.getDomRef()){this._titleExpandCollapseWhenAllowed();}this.setProperty("headerExpanded",H,true);return this;};
i.prototype.setToggleHeaderOnTitleClick=function(t){var H=this.getHeaderExpanded(),r=this.setProperty("toggleHeaderOnTitleClick",t,true);t=this.getProperty("toggleHeaderOnTitleClick");this._updateTitleVisualState();this._updateToggleHeaderVisualIndicators();this._updateARIAStates(H);return r;};
i.prototype.setFitContent=function(F){var r=this.setProperty("fitContent",F,true);if(j(this.$())){this._updateFitContainer();}return r;};
i.prototype.getScrollDelegate=function(){return this._oScrollHelper;};
i.prototype._overridePreserveHeaderStateOnScroll=function(){if(!this._shouldOverridePreserveHeaderStateOnScroll()){this._headerBiggerThanAllowedHeight=false;return;}this._headerBiggerThanAllowedHeight=true;if(this.getHeaderExpanded()){this._moveHeaderToContentArea(true);}else{this._adjustSnap();}this._updateScrollBar();};
i.prototype._shouldOverridePreserveHeaderStateOnScroll=function(){return!D.system.desktop&&this._headerBiggerThanAllowedToBeFixed()&&this._preserveHeaderStateOnScroll();};
i.prototype._toggleFooter=function(s){var F=this.getFooter(),u;if(!j(this.$())||!j(F)||!j(this.$footerWrapper)){return;}u=sap.ui.getCore().getConfiguration().getAnimationMode()!==a.AnimationMode.none;this._toggleFooterSpacer(s);if(u){this._toggleFooterAnimation(s,F);}else{this.$footerWrapper.toggleClass("sapUiHidden",!s);}this._updateScrollBar();};
i.prototype._toggleFooterAnimation=function(s,F){this.$footerWrapper.bind("webkitAnimationEnd animationend",this._onToggleFooterAnimationEnd.bind(this,F));if(s){this.$footerWrapper.removeClass("sapUiHidden");}F.toggleStyleClass(i.SHOW_FOOTER_CLASS_NAME,s);F.toggleStyleClass(i.HIDE_FOOTER_CLASS_NAME,!s);};
i.prototype._onToggleFooterAnimationEnd=function(F){this.$footerWrapper.unbind("webkitAnimationEnd animationend");if(F.hasStyleClass(i.HIDE_FOOTER_CLASS_NAME)){this.$footerWrapper.addClass("sapUiHidden");F.removeStyleClass(i.HIDE_FOOTER_CLASS_NAME);}else{F.removeStyleClass(i.SHOW_FOOTER_CLASS_NAME);}};
i.prototype._toggleFooterSpacer=function(t){var $=this.$("spacer");if(j($)){$.toggleClass("sapFDynamicPageContentWrapperSpacer",t);}if(j(this.$contentFitContainer)){this.$contentFitContainer.toggleClass("sapFDynamicPageContentFitContainerFooterVisible",t);}};
i.prototype._toggleHeaderInTabChain=function(t){var o=this.getTitle(),m=this.getHeader();if(!j(o)||!j(m)){return;}m.$().css("visibility",t?"visible":"hidden");};
i.prototype._snapHeader=function(m,u){var o=this.getTitle();if(this._bPinned&&!u){f.debug("DynamicPage :: aborted snapping, header is pinned",this);return;}f.debug("DynamicPage :: snapped header",this);if(this._bPinned&&u){this._unPin();this._togglePinButtonPressedState(false);}if(j(o)){o._toggleState(false,u);if(m&&this._bHeaderInTitleArea){this._moveHeaderToContentArea(true);}}if(!j(this.$titleArea)){f.warning("DynamicPage :: couldn't snap header. There's no title.",this);return;}this.setProperty("headerExpanded",false,true);if(this._hasVisibleTitleAndHeader()){this.$titleArea.addClass(D.system.phone&&o.getSnappedTitleOnMobile()?"sapFDynamicPageTitleSnappedTitleOnMobile":"sapFDynamicPageTitleSnapped");this._updateToggleHeaderVisualIndicators();this._togglePinButtonVisibility(false);}this._toggleHeaderInTabChain(false);this._updateARIAStates(false);};
i.prototype._expandHeader=function(m,u){var o=this.getTitle();f.debug("DynamicPage :: expand header",this);if(j(o)){o._toggleState(true,u);if(m){this._moveHeaderToTitleArea(true);}}if(!j(this.$titleArea)){f.warning("DynamicPage :: couldn't expand header. There's no title.",this);return;}this.setProperty("headerExpanded",true,true);if(this._hasVisibleTitleAndHeader()){this.$titleArea.removeClass(D.system.phone&&o.getSnappedTitleOnMobile()?"sapFDynamicPageTitleSnappedTitleOnMobile":"sapFDynamicPageTitleSnapped");this._updateToggleHeaderVisualIndicators();if(!this.getPreserveHeaderStateOnScroll()&&!this._headerBiggerThanAllowedToPin()){this._togglePinButtonVisibility(true);}}this._toggleHeaderInTabChain(true);this._updateARIAStates(true);};
i.prototype._toggleHeaderVisibility=function(s,u){var E=this.getHeaderExpanded(),o=this.getTitle(),m=this.getHeader();if(this._bPinned&&!u){f.debug("DynamicPage :: header toggle aborted, header is pinned",this);return;}if(j(o)){o._toggleState(E);}if(j(m)){m.$().toggleClass("sapFDynamicPageHeaderHidden",!s);this._updateScrollBar();}};
i.prototype._moveHeaderToContentArea=function(o){var m=this.getHeader();if(j(m)){m.$().prependTo(this.$wrapper);this._bHeaderInTitleArea=false;if(o){this._offsetContentOnMoveHeader();}}};
i.prototype._moveHeaderToTitleArea=function(o){var m=this.getHeader();if(j(m)){m.$().prependTo(this.$stickyPlaceholder);this._bHeaderInTitleArea=true;if(o){this._offsetContentOnMoveHeader();}}};
i.prototype._offsetContentOnMoveHeader=function(){var o=Math.ceil(this._getHeaderHeight()),m=this._getScrollPosition(),n=this._getScrollBar().getScrollPosition(),N;if(!o){return;}if(!m&&n){N=this._getScrollBar().getScrollPosition();}else{N=this._bHeaderInTitleArea?m-o:m+o;}N=Math.max(N,0);this._setScrollPosition(N,true);};
i.prototype._pin=function(){var $=this.$();if(this._bPinned){return;}this._bPinned=true;if(!this._bHeaderInTitleArea){this._moveHeaderToTitleArea(true);this._updateScrollBar();}this._updateToggleHeaderVisualIndicators();this._togglePinButtonARIAState(this._bPinned);if(j($)){$.addClass("sapFDynamicPageHeaderPinned");}};
i.prototype._unPin=function(){var $=this.$();if(!this._bPinned){return;}this._bPinned=false;this._updateToggleHeaderVisualIndicators();this._togglePinButtonARIAState(this._bPinned);if(j($)){$.removeClass("sapFDynamicPageHeaderPinned");}};
i.prototype._togglePinButtonVisibility=function(t){var o=this.getHeader();if(j(o)){o._setShowPinBtn(t);}};
i.prototype._togglePinButtonPressedState=function(p){var o=this.getHeader();if(j(o)){o._togglePinButton(p);}};
i.prototype._togglePinButtonARIAState=function(p){var o=this.getHeader();if(j(o)){o._updateARIAPinButtonState(p);}};
i.prototype._resetPinButtonState=function(){if(this._preserveHeaderStateOnScroll()){this._togglePinButtonVisibility(false);}else{this._togglePinButtonPressedState(false);this._togglePinButtonARIAState(false);}};
i.prototype._restorePinButtonFocus=function(){this.getHeader()._focusPinButton();};
i.prototype._getScrollPosition=function(){return j(this.$wrapper)?Math.ceil(this.$wrapper.scrollTop()):0;};
i.prototype._setScrollPosition=function(n,s){if(!j(this.$wrapper)){return;}if(this._getScrollPosition()===n){return;}if(s){this._bSuppressToggleHeaderOnce=true;}if(!this.getScrollDelegate()._$Container){this.getScrollDelegate()._$Container=this.$wrapper;}this.getScrollDelegate().scrollTo(0,n);};
i.prototype._shouldSnapOnScroll=function(){return!this._preserveHeaderStateOnScroll()&&this._getScrollPosition()>=this._getSnappingHeight()&&this.getHeaderExpanded()&&!this._bPinned;};
i.prototype._shouldExpandOnScroll=function(){var I=this._needsVerticalScrollBar();return!this._preserveHeaderStateOnScroll()&&this._getScrollPosition()<this._getSnappingHeight()&&!this.getHeaderExpanded()&&!this._bPinned&&I;};
i.prototype._shouldStickStickyContent=function(){var I,s,m;m=this._getScrollPosition();I=m<=Math.ceil(this._getHeaderHeight())&&!this._bPinned&&!this.getPreserveHeaderStateOnScroll();s=m===0||I&&this._hasVisibleHeader();return!s;};
i.prototype._headerScrolledOut=function(){return this._getScrollPosition()>=this._getSnappingHeight();};
i.prototype._headerSnapAllowed=function(){return!this._preserveHeaderStateOnScroll()&&this.getHeaderExpanded()&&!this._bPinned;};
i.prototype._canSnapHeaderOnScroll=function(){var m=this._getMaxScrollPosition(),t=this._bMSBrowser?1:0;if(this._bHeaderInTitleArea){m+=this._getHeaderHeight();m-=t;}return m>this._getSnappingHeight();};
i.prototype._getSnappingHeight=function(){return Math.ceil(this._getHeaderHeight()||this._getTitleHeight());};
i.prototype._getMaxScrollPosition=function(){var $;if(j(this.$wrapper)){$=this.$wrapper[0];return $.scrollHeight-$.clientHeight;}return 0;};
i.prototype._needsVerticalScrollBar=function(){var t=this._bMSBrowser?1:0;return this._getMaxScrollPosition()>t;};
i.prototype._getOwnHeight=function(){return this._getHeight(this);};
i.prototype._getEntireHeaderHeight=function(){var t=0,H=0,o=this.getTitle(),m=this.getHeader();if(j(o)){t=o.$().outerHeight();}if(j(m)){H=m.$().outerHeight();}return t+H;};
i.prototype._headerBiggerThanAllowedToPin=function(m){if(!(typeof m==="number"&&!isNaN(parseInt(m)))){m=this._getOwnHeight();}return this._getEntireHeaderHeight()>i.HEADER_MAX_ALLOWED_PINNED_PERCENTAGE*m;};
i.prototype._headerBiggerThanAllowedToBeFixed=function(){var m=this._getOwnHeight();return this._getEntireHeaderHeight()>i.HEADER_MAX_ALLOWED_NON_SROLLABLE_PERCENTAGE*m;};
i.prototype._headerBiggerThanAllowedToBeExpandedInTitleArea=function(){var E=this._getEntireHeaderHeight(),m=this._getOwnHeight();if(m===0){return false;}return D.system.phone?E>=i.HEADER_MAX_ALLOWED_NON_SROLLABLE_ON_MOBILE*m:E>=m;};
i.prototype._measureScrollBarOffsetHeight=function(){var H=0,s=!this.getHeaderExpanded(),m=this._bHeaderInTitleArea;if(this._preserveHeaderStateOnScroll()||this._bPinned||(!s&&this._bHeaderInTitleArea)){H=this._getTitleAreaHeight();f.debug("DynamicPage :: preserveHeaderState is enabled or header pinned :: title area height"+H,this);return H;}if(s||!j(this.getTitle())||!this._canSnapHeaderOnScroll()){H=this._getTitleHeight();f.debug("DynamicPage :: header snapped :: title height "+H,this);return H;}this._snapHeader(true);H=this._getTitleHeight();if(!s){this._expandHeader(m);}f.debug("DynamicPage :: snapped mode :: title height "+H,this);return H;};
i.prototype._updateScrollBar=function(){var s,m,n;if(!D.system.desktop||!j(this.$wrapper)||(this._getHeight(this)===0)){return;}s=this._getScrollBar();s.setContentSize(this._measureScrollBarOffsetHeight()+this.$wrapper[0].scrollHeight+"px");m=this._needsVerticalScrollBar();n=this.bHasScrollbar!==m;if(n){s.toggleStyleClass("sapUiHidden",!m);this.toggleStyleClass("sapFDynamicPageWithScroll",m);this.bHasScrollbar=m;}setTimeout(this._updateFitContainer.bind(this),0);setTimeout(this._updateScrollBarOffset.bind(this),0);};
i.prototype._updateFitContainer=function(n){var N=typeof n!=='undefined'?!n:!this._needsVerticalScrollBar(),F=this.getFitContent(),t=F||N;this.$contentFitContainer.toggleClass("sapFDynamicPageContentFitContainer",t);};
i.prototype._updateScrollBarOffset=function(){var s=sap.ui.getCore().getConfiguration().getRTL()?"left":"right",o=this._needsVerticalScrollBar()?g().width+"px":0,F=this.getFooter();this.$titleArea.css("padding-"+s,o);if(j(F)){F.$().css(s,o);}};
i.prototype._updateHeaderARIAState=function(E){var o=this.getHeader();if(j(o)){o._updateARIAState(E);}};
i.prototype._updateTitleARIAState=function(E){var o=this.getTitle();if(j(o)){o._updateARIAState(E);}};
i.prototype._updateARIAStates=function(E){this._updateHeaderARIAState(E);this._updateTitleARIAState(E);};
i.prototype._updateMedia=function(w){if(w<=i.BREAK_POINTS.PHONE){this._updateMediaStyle(i.MEDIA.PHONE);}else if(w<=i.BREAK_POINTS.TABLET){this._updateMediaStyle(i.MEDIA.TABLET);}else{this._updateMediaStyle(i.MEDIA.DESKTOP);}};
i.prototype._updateMediaStyle=function(s){Object.keys(i.MEDIA).forEach(function(m){var E=s===i.MEDIA[m];this.toggleStyleClass(i.MEDIA[m],E);},this);};
i.prototype._toggleExpandVisualIndicator=function(t){var o=this.getTitle();if(j(o)){o._toggleExpandButton(t);}};
i.prototype._focusExpandVisualIndicator=function(){var o=this.getTitle();if(j(o)){o._focusExpandButton();}};
i.prototype._toggleCollapseVisualIndicator=function(t){var o=this.getHeader();if(j(o)){o._toggleCollapseButton(t);}};
i.prototype._focusCollapseVisualIndicator=function(){var o=this.getHeader();if(j(o)){o._focusCollapseButton();}};
i.prototype._updateToggleHeaderVisualIndicators=function(){var H,m,E,n=this._hasVisibleTitleAndHeader(),o=this.getHeader(),p=false;if(j(o)){p=!!o.getContent().length;}if(!this.getToggleHeaderOnTitleClick()||!n){m=false;E=false;}else{H=this.getHeaderExpanded();m=H;E=D.system.phone&&this.getTitle().getAggregation("snappedTitleOnMobile")?false:!H;}E=E&&p;m=m&&p;this._toggleCollapseVisualIndicator(m);this._toggleExpandVisualIndicator(E);};
i.prototype._updateTitleVisualState=function(){var t=this.getTitle(),T=this._hasVisibleTitleAndHeader()&&this.getToggleHeaderOnTitleClick();this.$().toggleClass("sapFDynamicPageTitleClickEnabled",T&&!D.system.phone);if(j(t)){t._toggleFocusableState(T);}};
i.prototype._scrollBellowCollapseVisualIndicator=function(){var H=this.getHeader(),$,m,v,o;if(j(H)){$=this.getHeader()._getCollapseButton().getDomRef();m=$.getBoundingClientRect().height;v=this.$wrapper[0].getBoundingClientRect().height;o=$.offsetTop+m-v;this._setScrollPosition(o);}};
i.prototype._hasVisibleTitleAndHeader=function(){var t=this.getTitle();return j(t)&&t.getVisible()&&this._hasVisibleHeader();};
i.prototype._hasVisibleHeader=function(){var H=this.getHeader();return j(H)&&H.getVisible()&&j(H.getContent());};
i.prototype._getHeight=function(o){var $;if(!(o instanceof C)){return 0;}$=o.getDomRef();return $?$.getBoundingClientRect().height:0;};
i.prototype._getWidth=function(o){return!(o instanceof C)?0:o.$().outerWidth()||0;};
i.prototype._getTitleAreaHeight=function(){return j(this.$titleArea)?this.$titleArea.outerHeight()||0:0;};
i.prototype._getTitleHeight=function(){return this._getHeight(this.getTitle());};
i.prototype._getHeaderHeight=function(){return this._getHeight(this.getHeader());};
i.prototype._preserveHeaderStateOnScroll=function(){return this.getPreserveHeaderStateOnScroll()&&!this._headerBiggerThanAllowedHeight;};
i.prototype._getScrollBar=function(){if(!j(this.getAggregation("_scrollBar"))){var v=new S(this.getId()+"-vertSB",{scrollPosition:0,scroll:this._onScrollBarScroll.bind(this)});this.setAggregation("_scrollBar",v,true);}return this.getAggregation("_scrollBar");};
i.prototype._cacheDomElements=function(){var F=this.getFooter();if(j(F)){this.$footer=F.$();this.$footerWrapper=this.$("footerWrapper");}this.$wrapper=this.$("contentWrapper");this.$contentFitContainer=this.$("contentFitContainer");this.$titleArea=this.$("header");this.$stickyPlaceholder=this.$("stickyPlaceholder");this._cacheTitleDom();this._cacheHeaderDom();};
i.prototype._cacheTitleDom=function(){var t=this.getTitle();if(j(t)){this.$title=t.$();}};
i.prototype._cacheHeaderDom=function(){var H=this.getHeader();if(j(H)){this.$header=H.$();}};
i.prototype._adjustSnap=function(){var o,I,m,n,s,p,$=this.$();if(!j($)){return;}if(!k($[0])){return;}o=this.getHeader();I=!this.getHeaderExpanded();if(!o||!I){return;}m=!this._preserveHeaderStateOnScroll()&&this._canSnapHeaderOnScroll();n=I&&o.$().hasClass("sapFDynamicPageHeaderHidden");if(m&&n){this._toggleHeaderVisibility(true);this._moveHeaderToContentArea(true);return;}if(!m&&!n){this._moveHeaderToTitleArea(true);this._toggleHeaderVisibility(false);return;}if(m){s=this._getScrollPosition();p=this._getSnappingHeight();if(s<p){this._setScrollPosition(p);}}};
i.prototype.ontouchmove=function(E){E.setMarked();};
i.prototype._onChildControlAfterRendering=function(E){var s=E.srcControl;if(s instanceof c){this._cacheTitleDom();this._deRegisterResizeHandler(i.RESIZE_HANDLER_ID.TITLE);this._registerResizeHandler(i.RESIZE_HANDLER_ID.TITLE,this.$title[0],this._onChildControlsHeightChange.bind(this));}else if(s instanceof d){this._cacheHeaderDom();this._deRegisterResizeHandler(i.RESIZE_HANDLER_ID.HEADER);this._registerResizeHandler(i.RESIZE_HANDLER_ID.HEADER,this.$header[0],this._onChildControlsHeightChange.bind(this));}setTimeout(this._updateScrollBar.bind(this),0);};
i.prototype._onChildControlsHeightChange=function(){var n=this._needsVerticalScrollBar();if(n){this._updateFitContainer(n);}this._adjustSnap();if(!this._bExpandingWithAClick){this._updateScrollBar();}this._bExpandingWithAClick=false;};
i.prototype._onResize=function(E){var o=this.getTitle(),m=this.getHeader(),n=E.size.width;if(!this._preserveHeaderStateOnScroll()&&m){if(this._headerBiggerThanAllowedToPin(E.size.height)||D.system.phone){this._unPin();this._togglePinButtonVisibility(false);this._togglePinButtonPressedState(false);}else{this._togglePinButtonVisibility(true);}if(this.getHeaderExpanded()&&this._bHeaderInTitleArea&&this._headerBiggerThanAllowedToBeExpandedInTitleArea()){this._expandHeader(false);this._setScrollPosition(0);}}if(j(o)){o._onResize(n);}this._adjustSnap();this._updateScrollBar();this._updateMedia(n);};
i.prototype._onWrapperScroll=function(E){var s=Math.max(E.target.scrollTop,0);if(D.system.desktop){if(this.allowCustomScroll===true){this.allowCustomScroll=false;return;}this.allowInnerDiv=true;this._getScrollBar().setScrollPosition(s);this.toggleStyleClass("sapFDynamicPageWithScroll",this._needsVerticalScrollBar());}};
i.prototype._toggleHeaderOnScroll=function(){this._adjustStickyContent();if(this._bSuppressToggleHeaderOnce){this._bSuppressToggleHeaderOnce=false;return;}if(D.system.desktop&&this._bExpandingWithAClick){return;}if(this._preserveHeaderStateOnScroll()){return;}if(this._shouldSnapOnScroll()){this._snapHeader(true,true);}else if(this._shouldExpandOnScroll()){this._expandHeader(false,true);this._toggleHeaderVisibility(true);}else if(!this._bPinned&&this._bHeaderInTitleArea){var m=(this._getScrollPosition()>=this._getSnappingHeight());this._moveHeaderToContentArea(m);}};
i.prototype._adjustStickyContent=function(){if(!this._oStickySubheader){return;}var o,s=this._shouldStickStickyContent(),m,n=this.getStickySubheaderProvider();if(s===this._bStickySubheaderInTitleArea){return;}m=sap.ui.getCore().byId(n);if(!j(m)){return;}o=document.activeElement;m._setStickySubheaderSticked(s);if(s){this._oStickySubheader.$().appendTo(this.$stickyPlaceholder);}else{m._returnStickyContent();}o.focus();this._bStickySubheaderInTitleArea=s;};
i.prototype._onScrollBarScroll=function(){if(this.allowInnerDiv===true){this.allowInnerDiv=false;return;}this.allowCustomScroll=true;this._setScrollPosition(this._getScrollBar().getScrollPosition());};
i.prototype._onTitlePress=function(){if(this.getToggleHeaderOnTitleClick()&&this._hasVisibleTitleAndHeader()){this._titleExpandCollapseWhenAllowed(true);this.getTitle()._focus();}};
i.prototype._onExpandHeaderVisualIndicatorPress=function(){this._onTitlePress();if(this._headerBiggerThanAllowedToBeExpandedInTitleArea()){this._scrollBellowCollapseVisualIndicator();}this._focusCollapseVisualIndicator();};
i.prototype._onCollapseHeaderVisualIndicatorPress=function(){this._onTitlePress();this._focusExpandVisualIndicator();};
i.prototype._onVisualIndicatorMouseOver=function(){var $=this.$();if(j($)){$.addClass("sapFDynamicPageTitleForceHovered");}};
i.prototype._onVisualIndicatorMouseOut=function(){var $=this.$();if(j($)){$.removeClass("sapFDynamicPageTitleForceHovered");}};
i.prototype._onTitleMouseOver=i.prototype._onVisualIndicatorMouseOver;i.prototype._onTitleMouseOut=i.prototype._onVisualIndicatorMouseOut;
i.prototype._titleExpandCollapseWhenAllowed=function(u){var m;if(this._bPinned&&!u){return this;}if(this._preserveHeaderStateOnScroll()||!this._canSnapHeaderOnScroll()||!this.getHeader()){if(!this.getHeaderExpanded()){this._expandHeader(false,u);this._toggleHeaderVisibility(true,u);}else{this._snapHeader(false,u);this._toggleHeaderVisibility(false,u);}}else if(!this.getHeaderExpanded()){m=!this._headerBiggerThanAllowedToBeExpandedInTitleArea();this._bExpandingWithAClick=true;this._expandHeader(m,u);this.getHeader().$().removeClass("sapFDynamicPageHeaderHidden");if(!m){this._setScrollPosition(0);}this._bExpandingWithAClick=false;}else{var n=this._bHeaderInTitleArea;this._snapHeader(n,u);if(!n){this._setScrollPosition(this._getSnappingHeight());}}};
i.prototype._onPinUnpinButtonPress=function(){if(this._bPinned){this._unPin();}else{this._pin();this._restorePinButtonFocus();}};
i.prototype._attachResizeHandlers=function(){var m=this._onChildControlsHeightChange.bind(this);this._registerResizeHandler(i.RESIZE_HANDLER_ID.PAGE,this,this._onResize.bind(this));if(j(this.$title)){this._registerResizeHandler(i.RESIZE_HANDLER_ID.TITLE,this.$title[0],m);}if(j(this.$header)){this._registerResizeHandler(i.RESIZE_HANDLER_ID.HEADER,this.$header[0],m);}if(j(this.$contentFitContainer)){this._registerResizeHandler(i.RESIZE_HANDLER_ID.CONTENT,this.$contentFitContainer[0],m);}};
i.prototype._registerResizeHandler=function(H,o,m){if(!this[H]){this[H]=R.register(o,m);}};
i.prototype._detachResizeHandlers=function(){this._deRegisterResizeHandler(i.RESIZE_HANDLER_ID.PAGE);this._deRegisterResizeHandler(i.RESIZE_HANDLER_ID.TITLE);this._deRegisterResizeHandler(i.RESIZE_HANDLER_ID.HEADER);this._deRegisterResizeHandler(i.RESIZE_HANDLER_ID.CONTENT);};
i.prototype._deRegisterResizeHandler=function(H){if(this[H]){R.deregister(this[H]);this[H]=null;}};
i.prototype._attachPageChildrenAfterRenderingDelegates=function(){var t=this.getTitle(),H=this.getHeader(),o=this.getContent(),p={onAfterRendering:this._onChildControlAfterRendering.bind(this)};if(j(t)){t.addEventDelegate(p);}if(j(o)){o.addEventDelegate(p);}if(j(H)){H.addEventDelegate(p);}};
i.prototype._attachTitlePressHandler=function(){var t=this.getTitle();if(j(t)&&!this._bAlreadyAttachedTitlePressHandler){t.attachEvent(i.EVENTS.TITLE_PRESS,this._onTitlePress,this);this._bAlreadyAttachedTitlePressHandler=true;}};
i.prototype._attachPinPressHandler=function(){var H=this.getHeader();if(j(H)&&!this._bAlreadyAttachedPinPressHandler){H.attachEvent(i.EVENTS.PIN_UNPIN_PRESS,this._onPinUnpinButtonPress,this);this._bAlreadyAttachedPinPressHandler=true;}};
i.prototype._attachStickyHeaderObserver=function(){var H=this.getHeader();if(j(H)&&!this._bAlreadyAttachedStickyHeaderObserver){if(!this._oStickyHeaderObserver){this._oStickyHeaderObserver=new M(this._adjustStickyContent.bind(this));}this._oStickyHeaderObserver.observe(H,{properties:["visible"]});this._bAlreadyAttachedStickyHeaderObserver=true;}};
i.prototype._attachHeaderObserver=function(){var H=this.getHeader();if(j(H)&&!this._bAlreadyAttachedHeaderObserver){if(!this._oHeaderObserver){this._oHeaderObserver=new M(this._updateToggleHeaderVisualIndicators.bind(this));}this._oHeaderObserver.observe(H,{aggregations:["content"]});this._bAlreadyAttachedHeaderObserver=true;}};
i.prototype._attachVisualIndicatorsPressHandlers=function(){var t=this.getTitle(),H=this.getHeader();if(j(t)&&!this._bAlreadyAttachedTitleIndicatorPressHandler){t.attachEvent(i.EVENTS.TITLE_VISUAL_INDICATOR_PRESS,this._onExpandHeaderVisualIndicatorPress,this);this._bAlreadyAttachedTitleIndicatorPressHandler=true;}if(j(H)&&!this._bAlreadyAttachedHeaderIndicatorPressHandler){H.attachEvent(i.EVENTS.HEADER_VISUAL_INDICATOR_PRESS,this._onCollapseHeaderVisualIndicatorPress,this);this._bAlreadyAttachedHeaderIndicatorPressHandler=true;}};
i.prototype._addStickySubheaderAfterRenderingDelegate=function(){var s,m=this.getStickySubheaderProvider(),I;s=sap.ui.getCore().byId(m);if(j(s)&&!this._bAlreadyAddedStickySubheaderAfterRenderingDelegate){I=s.getMetadata().getInterfaces().indexOf("sap.f.IDynamicPageStickyContent")!==-1;if(I){this._oStickySubheader=s._getStickyContent();this._oStickySubheader.addEventDelegate(this._oSubHeaderAfterRenderingDelegate,this);this._bAlreadyAddedStickySubheaderAfterRenderingDelegate=true;this._attachStickyHeaderObserver();}}};
i.prototype._attachVisualIndicatorMouseOverHandlers=function(){var H=this.getHeader();if(j(H)&&!this._bAlreadyAttachedVisualIndicatorMouseOverOutHandler){H.attachEvent(i.EVENTS.VISUAL_INDICATOR_MOUSE_OVER,this._onVisualIndicatorMouseOver,this);H.attachEvent(i.EVENTS.VISUAL_INDICATOR_MOUSE_OUT,this._onVisualIndicatorMouseOut,this);this._bAlreadyAttachedVisualIndicatorMouseOverOutHandler=true;}};
i.prototype._attachTitleMouseOverHandlers=function(){var t=this.getTitle();if(j(t)&&!this._bAlreadyAttachedTitleMouseOverOutHandler){t.attachEvent(i.EVENTS.TITLE_MOUSE_OVER,this._onTitleMouseOver,this);t.attachEvent(i.EVENTS.TITLE_MOUSE_OUT,this._onTitleMouseOut,this);this._bAlreadyAttachedTitleMouseOverOutHandler=true;}};
i.prototype._attachScrollHandler=function(){this._onWrapperScrollReference=this._onWrapperScroll.bind(this);this._toggleHeaderOnScrollReference=this._toggleHeaderOnScroll.bind(this);this.$wrapper.on("scroll",this._onWrapperScrollReference);this.$wrapper.on("scroll",this._toggleHeaderOnScrollReference);};
i.prototype._detachScrollHandler=function(){if(this.$wrapper){this.$wrapper.off("scroll",this._onWrapperScrollReference);this.$wrapper.off("scroll",this._toggleHeaderOnScrollReference);}};
i.prototype._formatLandmarkInfo=function(o,p){if(o){var r=o["get"+p+"Role"]()||"",s=o["get"+p+"Label"]()||"";if(r===A.None){r='';}return{role:r.toLowerCase(),label:s};}return{};};
i.prototype._getHeaderTag=function(o){if(o&&o.getHeaderRole()!==A.None){return i.DIV;}return i.HEADER;};
i.prototype._getFooterTag=function(o){if(o&&o.getFooterRole()!==A.None){return i.DIV;}return i.FOOTER;};
return i;});
sap.ui.predefine('sap/f/DynamicPageAccessibleLandmarkInfo',['sap/ui/core/Element','./library'],function(E,l){"use strict";
var D=E.extend("sap.f.DynamicPageAccessibleLandmarkInfo",{metadata:{library:"sap.f",properties:{rootRole:{type:"sap.ui.core.AccessibleLandmarkRole",defaultValue:"None"},rootLabel:{type:"string",defaultValue:null},contentRole:{type:"sap.ui.core.AccessibleLandmarkRole",defaultValue:"None"},contentLabel:{type:"string",defaultValue:null},headerRole:{type:"sap.ui.core.AccessibleLandmarkRole",defaultValue:"None"},headerLabel:{type:"string",defaultValue:null},footerRole:{type:"sap.ui.core.AccessibleLandmarkRole",defaultValue:"None"},footerLabel:{type:"string",defaultValue:null}}}});
return D;});
sap.ui.predefine('sap/f/DynamicPageHeader',["./library","sap/ui/Device","sap/ui/core/Control","sap/m/ToggleButton","sap/m/Button","./DynamicPageHeaderRenderer"],function(l,D,C,T,B,a){"use strict";
var b=C.extend("sap.f.DynamicPageHeader",{metadata:{library:"sap.f",properties:{pinnable:{type:"boolean",group:"Appearance",defaultValue:true},backgroundDesign:{type:"sap.m.BackgroundDesign",group:"Appearance"}},defaultAggregation:"content",aggregations:{content:{type:"sap.ui.core.Control",multiple:true},_pinButton:{type:"sap.m.Button",multiple:false,visibility:"hidden"},_collapseButton:{type:"sap.m.Button",multiple:false,visibility:"hidden"}},designtime:"sap/f/designtime/DynamicPageHeader.designtime"}});
b._getResourceBundle=function(){return sap.ui.getCore().getLibraryResourceBundle("sap.f");};
b.ARIA={ARIA_CONTROLS:"aria-controls",ARIA_EXPANDED:"aria-expanded",ARIA_LABEL:"aria-label",LABEL_EXPANDED:b._getResourceBundle().getText("EXPANDED_HEADER"),LABEL_COLLAPSED:b._getResourceBundle().getText("SNAPPED_HEADER"),LABEL_PINNED:b._getResourceBundle().getText("PIN_HEADER"),LABEL_UNPINNED:b._getResourceBundle().getText("UNPIN_HEADER"),TOOLTIP_COLLAPSE_BUTTON:b._getResourceBundle().getText("COLLAPSE_HEADER_BUTTON_TOOLTIP"),STATE_TRUE:"true",STATE_FALSE:"false"};
b.prototype.init=function(){this._bShowCollapseButton=true;};
b.prototype.onAfterRendering=function(){this._initARIAState();this._initPinButtonARIAState();};
b.prototype._togglePinButton=function(v){this._getPinButton().setPressed(v);};
b.prototype._setShowPinBtn=function(v){this._getPinButton().$().toggleClass("sapUiHidden",!v);};
b.prototype._pinUnpinFireEvent=function(){this.fireEvent("_pinUnpinPress");};
b.prototype._onCollapseButtonPress=function(){this.fireEvent("_headerVisualIndicatorPress");};
b.prototype._onCollapseButtonMouseOver=function(){this.fireEvent("_visualIndicatorMouseOver");};
b.prototype._onCollapseButtonMouseOut=function(){this.fireEvent("_visualIndicatorMouseOut");};
b.prototype._initARIAState=function(){var $=this.$();$.attr(b.ARIA.ARIA_EXPANDED,b.ARIA.STATE_TRUE);$.attr(b.ARIA.ARIA_LABEL,b.ARIA.LABEL_EXPANDED);};
b.prototype._initPinButtonARIAState=function(){var $;if(this.getPinnable()){$=this._getPinButtonJQueryRef();$.attr(b.ARIA.ARIA_CONTROLS,this.getId());}};
b.prototype._updateARIAState=function(e){var $=this.$();if(e){$.attr(b.ARIA.ARIA_EXPANDED,b.ARIA.STATE_TRUE);$.attr(b.ARIA.ARIA_LABEL,b.ARIA.LABEL_EXPANDED);}else{$.attr(b.ARIA.ARIA_EXPANDED,b.ARIA.STATE_FALSE);$.attr(b.ARIA.ARIA_LABEL,b.ARIA.LABEL_COLLAPSED);}};
b.prototype._updateARIAPinButtonState=function(p){var P=this._getPinButton();if(p){P.setTooltip(b.ARIA.LABEL_UNPINNED);}else{P.setTooltip(b.ARIA.LABEL_PINNED);}};
b.prototype._getPinButton=function(){if(!this.getAggregation("_pinButton")){var p=new T({id:this.getId()+"-pinBtn",icon:"sap-icon://pushpin-off",tooltip:b.ARIA.LABEL_PINNED,press:this._pinUnpinFireEvent.bind(this)}).addStyleClass("sapFDynamicPageHeaderPinButton");this.setAggregation("_pinButton",p,true);}return this.getAggregation("_pinButton");};
b.prototype._getCollapseButton=function(){if(!this.getAggregation("_collapseButton")){var c=new B({id:this.getId()+"-collapseBtn",icon:"sap-icon://slim-arrow-up",press:this._onCollapseButtonPress.bind(this),tooltip:b.ARIA.TOOLTIP_COLLAPSE_BUTTON}).addStyleClass("sapFDynamicPageToggleHeaderIndicator");c.onmouseover=this._onCollapseButtonMouseOver.bind(this);c.onmouseout=this._onCollapseButtonMouseOut.bind(this);this.setAggregation("_collapseButton",c,true);}return this.getAggregation("_collapseButton");};
b.prototype._toggleCollapseButton=function(t){this._setShowCollapseButton(t);this._getCollapseButton().$().toggleClass("sapUiHidden",!t);};
b.prototype._getShowCollapseButton=function(){return this._bShowCollapseButton&&!!this.getContent().length;};
b.prototype._setShowCollapseButton=function(v){this._bShowCollapseButton=!!v;};
b.prototype._focusCollapseButton=function(){this._getCollapseButton().$().focus();};
b.prototype._focusPinButton=function(){this._getPinButtonJQueryRef().focus();};
b.prototype._getPinButtonJQueryRef=function(){return this._getPinButton().$();};
b.prototype._getState=function(){var c=this.getContent(),h=c.length>0,H=this.getPinnable()&&h&&!D.system.phone,p=this._getPinButton(),o=this._getCollapseButton();o.toggleStyleClass("sapUiHidden",!this._getShowCollapseButton());return{content:c,headerHasContent:h,headerPinnable:H,hasContent:c.length>0,pinButton:p,collapseButton:o};};
return b;});
sap.ui.predefine('sap/f/DynamicPageHeaderRenderer',[],function(){"use strict";var D={apiVersion:2};
D.render=function(r,d){var o=d._getState(),s="sapFDynamicPageHeader",b=d.getBackgroundDesign();r.openStart("header",d);r.accessibilityState({role:"region"});r.class("sapContrastPlus");r.class(s);if(o.headerHasContent){r.class("sapFDynamicPageHeaderWithContent");}if(o.headerPinnable){r.class("sapFDynamicPageHeaderPinnable");}if(b){r.class(s+b);}r.openEnd();this._renderHeaderContent(r,o);r.renderControl(o.collapseButton);if(o.headerPinnable){r.renderControl(o.pinButton);}r.close("header");};
D._renderHeaderContent=function(r,d){if(d.headerHasContent){r.openStart("div");r.class("sapFDynamicPageHeaderContent");r.openEnd();d.content.forEach(r.renderControl,r);r.close("div");}};
return D;},true);
sap.ui.predefine('sap/f/DynamicPageRenderer',["sap/ui/Device"],function(D){"use strict";var a={apiVersion:2};
a.render=function(r,d){var o=d.getTitle(),b=d.getHeader(),c=d.getFooter(),e=d.getContent(),h=d.getHeaderExpanded(),H=b?b.getContent():[],f=H.length>0,s=d.getShowFooter(),p=d._preserveHeaderStateOnScroll(),l=d.getLandmarkInfo(),g=d._getHeaderTag(l),F=d._getFooterTag(l);r.openStart("article",d);r.class("sapFDynamicPage");if(d.getToggleHeaderOnTitleClick()){r.class("sapFDynamicPageTitleClickEnabled");}r.accessibilityState(d,d._formatLandmarkInfo(l,"Root"));r.openEnd();if(D.system.desktop){r.renderControl(d._getScrollBar());}r.openStart(g,d.getId()+"-header");r.class("sapContrastPlus");r.class("sapFDynamicPageTitleWrapper");if(!h){r.class(D.system.phone&&o&&o.getSnappedTitleOnMobile()?"sapFDynamicPageTitleSnappedTitleOnMobile":"sapFDynamicPageTitleSnapped");}if(!f){r.class("sapFDynamicPageTitleOnly");}r.accessibilityState(d,d._formatLandmarkInfo(l,"Header"));r.openEnd();r.renderControl(o);r.openStart("div",d.getId()+"-stickyPlaceholder");r.openEnd();if(p){r.renderControl(b);}r.close("div");r.close(g);r.openStart("div",d.getId()+"-contentWrapper");r.class("sapFDynamicPageContentWrapper");if(d.getBackgroundDesign()){r.class("sapFDynamicPageContentWrapper"+d.getBackgroundDesign());}r.openEnd();if(!p){r.renderControl(b);}r.openStart("div",d.getId()+"-content");r.class("sapFDynamicPageContent");r.accessibilityState(d,d._formatLandmarkInfo(l,"Content"));r.openEnd();r.openStart("div",d.getId()+"-contentFitContainer");if(d.getFitContent()){r.class("sapFDynamicPageContentFitContainer");}if(c&&s){r.class("sapFDynamicPageContentFitContainerFooterVisible");}r.openEnd();r.renderControl(e);a.renderFooterSpacer(r,d,c,s);r.close("div");r.close("div");r.close("div");a.renderFooter(r,d,c,s,F,l);r.close("article");};
a.renderFooter=function(r,d,o,s,f,l){if(o){r.openStart(f,d.getId()+"-footerWrapper");r.class("sapContrast").class("sapContrastPlus").class("sapFDynamicPageFooter").class("sapFFooter-CTX");if(!s){r.class("sapUiHidden");}r.accessibilityState(d,d._formatLandmarkInfo(l,"Footer"));r.openEnd();o.addStyleClass("sapFDynamicPageActualFooterControl");r.renderControl(o);r.close(f);}};
a.renderFooterSpacer=function(r,d,o,s){if(o){r.openStart("div",d.getId()+"-spacer");if(s){r.class("sapFDynamicPageContentWrapperSpacer");}r.openEnd();r.close("div");}};
return a;},true);
sap.ui.predefine('sap/f/DynamicPageTitle',["./library","sap/ui/core/Control","sap/ui/base/ManagedObjectObserver","sap/m/library","sap/m/Toolbar","sap/m/ToolbarSeparator","sap/m/OverflowToolbar","sap/m/Button","sap/ui/core/InvisibleText","./DynamicPageTitleRenderer","sap/base/Log","sap/ui/core/HTML","sap/ui/core/Icon","sap/ui/Device","sap/ui/events/KeyCodes"],function(l,C,M,m,T,a,O,B,I,D,L,H,b,c,K){"use strict";var d=l.DynamicPageTitleArea,e=m.ToolbarStyle;var o=sap.ui.getCore();
var f=C.extend("sap.f.DynamicPageTitle",{metadata:{library:"sap.f",properties:{primaryArea:{type:"sap.f.DynamicPageTitleArea",group:"Appearance",defaultValue:d.Begin},areaShrinkRatio:{type:"sap.f.DynamicPageTitleShrinkRatio",group:"Appearance",defaultValue:"1:1.6:1.6"},backgroundDesign:{type:"sap.m.BackgroundDesign",group:"Appearance"}},aggregations:{heading:{type:"sap.ui.core.Control",multiple:false,defaultValue:null},snappedHeading:{type:"sap.ui.core.Control",multiple:false,defaultValue:null},expandedHeading:{type:"sap.ui.core.Control",multiple:false,defaultValue:null},actions:{type:"sap.ui.core.Control",multiple:true,singularName:"action"},navigationActions:{type:"sap.m.Button",multiple:true,singularName:"navigationAction"},content:{type:"sap.ui.core.Control",multiple:true},snappedContent:{type:"sap.ui.core.Control",multiple:true},expandedContent:{type:"sap.ui.core.Control",multiple:true},snappedTitleOnMobile:{type:"sap.m.Title",multiple:false},breadcrumbs:{type:"sap.m.IBreadcrumbs",multiple:false},_actionsToolbar:{type:"sap.m.OverflowToolbar",multiple:false,visibility:"hidden"},_navActionsToolbar:{type:"sap.m.Toolbar",multiple:false,visibility:"hidden"},_navActionsToolbarSeparator:{type:"sap.m.ToolbarSeparator",multiple:false,visibility:"hidden"},_expandButton:{type:"sap.m.Button",multiple:false,visibility:"hidden"},_snappedTitleOnMobileIcon:{type:"sap.ui.core.Icon",multiple:false,visibility:"hidden"},_focusSpan:{type:"sap.ui.core.HTML",multiple:false,visibility:"hidden"}},events:{stateChange:{parameters:{isExpanded:{type:"boolean"}}}},designtime:"sap/f/designtime/DynamicPageTitle.designtime"}});
function g(v){if(arguments.length===1){return v&&("length"in v)?v.length>0:!!v;}return Array.prototype.slice.call(arguments).every(function(h){return g(h);});}
f.NAV_ACTIONS_PLACEMENT_BREAK_POINT=1280;f.PRIMARY_AREA_MIDDLE_SHRINK_FACTORS={headingAreaShrinkFactor:1.6,contentAreaShrinkFactor:1,actionsAreaShrinkFactor:1.6};f.TOGGLE_HEADER_TEXT_ID=I.getStaticId("sap.f","TOGGLE_HEADER");f.DEFAULT_HEADER_TEXT_ID=I.getStaticId("sap.f","DEFAULT_HEADER_TEXT");
f._renderControl=function(h,j){var r;if(!j||!h){return;}r=o.createRenderManager();r.renderControl(j);r.flush(h);r.destroy();};
function i(h){return typeof h==="function";}
f.prototype.init=function(){this._bExpandedState=true;this._bShowExpandButton=false;this._bIsFocusable=true;this._fnActionSubstituteParentFunction=function(){return this;}.bind(this);this._bNavigationActionsInTopArea=false;this._oRB=o.getLibraryResourceBundle("sap.f");this._oObserver=new M(f.prototype._observeChanges.bind(this));this._oObserver.observe(this,{aggregations:["content","_actionsToolbar"]});this._oRB=sap.ui.getCore().getLibraryResourceBundle("sap.f");};
f.prototype.onBeforeRendering=function(){this._getActionsToolbar();this._observeControl(this.getBreadcrumbs());};
f.prototype.onAfterRendering=function(){this._cacheDomElements();this._toggleState(this._bExpandedState);this._doNavigationActionsLayout();};
f.prototype.exit=function(){if(this._oObserver){this._oObserver.disconnect();this._oObserver=null;}};
f.prototype.setPrimaryArea=function(A){var s=this.getAreaShrinkRatio(),S=this._getShrinkFactorsObject(),h=this.getMetadata().getProperty("areaShrinkRatio").getDefaultValue();if(!this.getDomRef()){return this.setProperty("primaryArea",A,true);}if(s!==h){return this.setProperty("primaryArea",A,true);}if(A===d.Begin){this._setShrinkFactors(S.headingAreaShrinkFactor,S.contentAreaShrinkFactor,S.actionsAreaShrinkFactor);}else{this._setShrinkFactors(f.PRIMARY_AREA_MIDDLE_SHRINK_FACTORS.headingAreaShrinkFactor,f.PRIMARY_AREA_MIDDLE_SHRINK_FACTORS.contentAreaShrinkFactor,f.PRIMARY_AREA_MIDDLE_SHRINK_FACTORS.actionsAreaShrinkFactor);}return this.setProperty("primaryArea",A,true);};
f.prototype.setAreaShrinkRatio=function(A){A=this.validateProperty("areaShrinkRatio",A);this.setProperty("areaShrinkRatio",A,true);var s=this._getShrinkFactorsObject();if(this.getPrimaryArea()===d.Middle){L.warning("DynamicPageTitle :: Property primaryArea is disregarded when areaShrinkRatio is set.",this);}if(s.headingAreaShrinkFactor>1&&s.contentAreaShrinkFactor>1&&s.actionsAreaShrinkFactor>1){L.warning("DynamicPageTitle :: One of the shrink factors should be set to 1.",this);}this._setShrinkFactors(s.headingAreaShrinkFactor,s.contentAreaShrinkFactor,s.actionsAreaShrinkFactor);return this;};
f.prototype.ontap=function(E){var s=E.srcControl;if(s===this||s===this.getAggregation("_actionsToolbar")||s===this.getAggregation("breadcrumbs")||s===this.getAggregation("snappedTitleOnMobile")){this.fireEvent("_titlePress");}};
f.prototype.onmouseover=function(){if(this._bTitleMouseOverFired){return;}this.fireEvent("_titleMouseOver");this._bTitleMouseOverFired=true;};
f.prototype.onmouseout=function(E){if(E&&this.getDomRef().contains(E.relatedTarget)){return;}this.fireEvent("_titleMouseOut");this._bTitleMouseOverFired=false;};
f.prototype.onkeyup=function(E){if(E&&E.which===K.SPACE&&!E.shiftKey){this.onsapenter(E);}};
f.prototype.onsapspace=function(E){if(E.srcControl===this){E.preventDefault();}};
f.prototype.onsapenter=function(E){if(E.srcControl===this){this.fireEvent("_titlePress");}};
["addAction","insertAction","removeAction","indexOfAction","removeAllActions","destroyActions","getActions"].forEach(function(s){f.prototype[s]=function(h){var t=this._getActionsToolbar(),j=s.replace(/Actions?/,"Content"),S=true,r;if(s==="addAction"||s==="insertAction"){if(!this._actionExists(h,"actions")){t[j].apply(t,arguments);this._preProcessAction(h,"actions");}r=this;}else if(s==="removeAction"){this._postProcessAction(h);}else if(s==="removeAllActions"){this.getActions().forEach(this._postProcessAction,this);}else if(s==="destroyActions"){this.getActions().forEach(this._postProcessAction,this);t[j].apply(t,arguments);r=this;}else if(s==="getActions"){S=false;}r=r||t[j].apply(t,arguments);S&&this._updateSeparatorVisibility();return r;};});["addNavigationAction","insertNavigationAction","removeNavigationAction","indexOfNavigationAction","removeAllNavigationActions","destroyNavigationActions","getNavigationActions"].forEach(function(s){f.prototype[s]=function(h){var t=this._getNavigationActionsToolbar(),j=s.replace(/NavigationActions?/,"Content"),k=true,r;if(s==="addNavigationAction"||s==="insertNavigationAction"){if(!this._actionExists(h,"navigationActions")){t[j].apply(t,arguments);this._preProcessAction(h,"navigationActions");}r=this;}else if(s==="removeNavigationAction"){this._postProcessAction(h);}else if(s==="removeAllNavigationActions"){this.getNavigationActions().forEach(this._postProcessAction,this);}else if(s==="destroyNavigationActions"){this.getNavigationActions().forEach(this._postProcessAction,this);t[j].apply(t,arguments);r=this;}else if(s==="getNavigationActions"){k=false;}r=r||t[j].apply(t,arguments);k&&this._updateTopAreaVisibility();return r;};});
f.prototype.clone=function(s,h,j){var t=C.prototype.clone.apply(this,arguments),k=true;if(j){k=!!j.cloneChildren;}if(!k){return t;}var n=function(A){if(!this.isBound(A)){var p=this.getMetadata().getAggregation(A);p.get(this).forEach(function(q){p.add(t,q.clone());},this);}}.bind(this);n("actions");n("navigationActions");return t;};
f.prototype._actionExists=function(A,s){return this.getMetadata().getAggregation(s).get(this).indexOf(A)>-1;};
f.prototype._cacheDomElements=function(){this.$topNavigationActionsArea=this.$("topNavigationArea");this.$mainNavigationActionsArea=this.$("mainNavigationArea");this.$beginArea=this.$("left-inner");this.$topArea=this.$("top");this.$mainArea=this.$("main");this.$middleArea=this.$("content");this.$snappedTitleOnMobileWrapper=this.$("snapped-title-on-mobile-wrapper");this.$snappedHeadingWrapper=this.$("snapped-heading-wrapper");this.$expandHeadingWrapper=this.$("expand-heading-wrapper");this.$snappedWrapper=this.$("snapped-wrapper");this.$expandWrapper=this.$("expand-wrapper");};
f.prototype._getActionsToolbar=function(){if(!this.getAggregation("_actionsToolbar")){this.setAggregation("_actionsToolbar",new O({id:this.getId()+"-_actionsToolbar",style:e.Clear}).addStyleClass("sapFDynamicPageTitleActionsBar"),true);}return this.getAggregation("_actionsToolbar");};
f.prototype._getNavigationActionsToolbar=function(){if(!this.getAggregation("_navActionsToolbar")){this.setAggregation("_navActionsToolbar",new T({id:this.getId()+"-navActionsToolbar",style:e.Clear}).addStyleClass("sapFDynamicPageTitleActionsBar"),true);}return this.getAggregation("_navActionsToolbar");};
f.prototype._getToolbarSeparator=function(){if(!this.getAggregation("_navActionsToolbarSeparator")){this.setAggregation("_navActionsToolbarSeparator",new a({id:this.getId()+"-separator"}),true);}return this.getAggregation("_navActionsToolbarSeparator");};
f.prototype._toggleFocusableState=function(F){var $;this._bIsFocusable=F;$=this._getFocusSpan().$();F?$.attr("tabindex",0):$.removeAttr("tabindex");};
f.prototype._preProcessAction=function(A,p){if(i(A._fnOriginalGetParent)){return;}this._observeControl(A);A._fnOriginalGetParent=A.getParent;A.getParent=this._fnActionSubstituteParentFunction;A._sOriginalParentAggregationName=A.sParentAggregationName;A.sParentAggregationName=p;};
f.prototype._postProcessAction=function(A){if(!i(A._fnOriginalGetParent)){return;}this._unobserveControl(A);A.getParent=A._fnOriginalGetParent;A._fnOriginalGetParent=null;A.sParentAggregationName=A._sOriginalParentAggregationName;A._sOriginalParentAggregationName=null;};
f.prototype._observeControl=function(h){this._oObserver.observe(h,{properties:["visible"]});};
f.prototype._unobserveControl=function(h){this._oObserver.unobserve(h,{properties:["visible"]});};
f.prototype._doNavigationActionsLayout=function(){var r,n,N;if(this.getNavigationActions().length===0){return;}N=this._getNavigationActionsToolbar();r=this._shouldRenderNavigationActionsInTopArea();if(r){n=this.$topNavigationActionsArea[0];}else{n=this.$mainNavigationActionsArea[0];}this._bNavigationActionsInTopArea=r;f._renderControl(n,N);this._updateSeparatorVisibility();};
f.prototype._updateTopAreaVisibility=function(h){var n=this._areNavigationActionsInTopArea(),N=this._shouldRenderNavigationActionsInTopArea(h),j=this.getBreadcrumbs()&&this.getBreadcrumbs().getVisible(),k=c.system.phone&&this.getSnappedTitleOnMobile()&&!this._bExpandedState,s=(j||N)&&!k,S=this.getNavigationActions().length>0&&(N^n);this._toggleTopAreaVisibility(s);if(S){this._toggleNavigationActionsPlacement(N);}else{this._updateSeparatorVisibility();}};
f.prototype._onResize=function(h){this._updateTopAreaVisibility(h);};
f.prototype._toggleNavigationActionsPlacement=function(s){this["_showNavigationActionsIn"+(s?"Top":"Main")+"Area"]();this._updateSeparatorVisibility();};
f.prototype._showNavigationActionsInTopArea=function(){var n=this._getNavigationActionsToolbar();if(this.$topNavigationActionsArea&&this.$topNavigationActionsArea.length>0){this.$topNavigationActionsArea.html(n.$());}this._bNavigationActionsInTopArea=true;};
f.prototype._showNavigationActionsInMainArea=function(){var n=this._getNavigationActionsToolbar();if(this.$mainNavigationActionsArea&&this.$mainNavigationActionsArea.length>0){this.$mainNavigationActionsArea.html(n.$());}this._bNavigationActionsInTopArea=false;};
f.prototype._areNavigationActionsInTopArea=function(){return this._bNavigationActionsInTopArea;};
f.prototype._updateSeparatorVisibility=function(){if(this.getDomRef()){this._getToolbarSeparator().toggleStyleClass("sapUiHidden",!this._shouldShowSeparator());}};
f.prototype._toggleTopAreaVisibility=function(s){if(this.getDomRef()){this.$("top").toggleClass("sapUiHidden",!s);}};
f.prototype._shouldShowSeparator=function(){var h,j;if(this._bNavigationActionsInTopArea){return false;}h=this._getVisibleActions().length>0;j=this._getVisibleNavigationActions().length>0;return h&&j;};
f.prototype._getVisibleActions=function(){return this.getActions().filter(function(A){return A.getVisible();});};
f.prototype._getVisibleNavigationActions=function(){return this.getNavigationActions().filter(function(A){return A.getVisible();});};
f.prototype._setShrinkFactors=function(h,j,A){this.$("left-inner").css("flex-shrink",h);this.$("content").css("flex-shrink",j);this.$("mainActions").css("flex-shrink",A);};
f.prototype._shouldRenderNavigationActionsInTopArea=function(h){var w,j,k;if(this._getVisibleNavigationActions().length===0){return false;}w=h?h:this._getWidth();j=this._getVisibleActions().length>0;k=this.getBreadcrumbs()&&this.getBreadcrumbs().getVisible();return w<f.NAV_ACTIONS_PLACEMENT_BREAK_POINT&&(k||j);};
f.prototype._toggleState=function(E,u){var h=this._bExpandedState;this._bExpandedState=E;if(c.system.phone&&this.getSnappedTitleOnMobile()){this.$snappedTitleOnMobileWrapper.toggleClass("sapUiHidden",E);this.$topArea.toggleClass("sapUiHidden",!E);this.$mainArea.toggleClass("sapUiHidden",!E);this.$().toggleClass("sapContrast",!E);}else{if(g(this.getSnappedHeading())){this.$snappedHeadingWrapper.toggleClass("sapUiHidden",E);}if(g(this.getExpandedHeading())){this.$expandHeadingWrapper.toggleClass("sapUiHidden",!E);}if(u&&h!==E){this.fireEvent("stateChange",{isExpanded:E});}}if(g(this.getSnappedContent())){this.$snappedWrapper.toggleClass("sapUiHidden",E);this.$snappedWrapper.parent().toggleClass("sapFDynamicPageTitleMainSnapContentVisible",!E);}if(g(this.getExpandedContent())){this.$expandWrapper.toggleClass("sapUiHidden",!E);this.$expandWrapper.parent().toggleClass("sapFDynamicPageTitleMainExpandContentVisible",E);}};
f.prototype._getExpandButton=function(){if(!this.getAggregation("_expandButton")){var E=new B({id:this.getId()+"-expandBtn",icon:"sap-icon://slim-arrow-down",press:this._onExpandButtonPress.bind(this),tooltip:this._oRB.getText("EXPAND_HEADER_BUTTON_TOOLTIP")}).addStyleClass("sapFDynamicPageToggleHeaderIndicator sapUiHidden");this.setAggregation("_expandButton",E,true);}return this.getAggregation("_expandButton");};
f.prototype._getSnappedTitleOnMobileIcon=function(){if(!this.getAggregation("_snappedTitleOnMobileIcon")){var h=new b({id:this.getId()+"-snappedTitleOnMobileIcon",src:"sap-icon://slim-arrow-down",press:this._onExpandButtonPress.bind(this)});this.setAggregation("_snappedTitleOnMobileIcon",h,true);}return this.getAggregation("_snappedTitleOnMobileIcon");};
f.prototype._onExpandButtonPress=function(){this.fireEvent("_titleVisualIndicatorPress");};
f.prototype._toggleExpandButton=function(t){this._setShowExpandButton(t);this._getExpandButton().$().toggleClass("sapUiHidden",!t);};
f.prototype._getShowExpandButton=function(){return this._bShowExpandButton;};
f.prototype._setShowExpandButton=function(v){this._bShowExpandButton=!!v;};
f.prototype._focusExpandButton=function(){this._getExpandButton().$().focus();};
f.prototype._getWidth=function(){return this.$().outerWidth();};
f.prototype._getState=function(){var h=this.getActions().length>0,j=this.getNavigationActions().length>0,k=this.getContent(),s=this.getSnappedContent(),E=this.getExpandedContent(),n=E.length>0,p=s.length>0,S=this._getShrinkFactorsObject(),q=this._getExpandButton(),F=this._getFocusSpan(),r=this.getBreadcrumbs(),t=this.getSnappedTitleOnMobile(),u=this._getSnappedTitleOnMobileIcon(),v=t&&c.system.phone,w=r||j,x=!!(r&&!j),y=j&&!r,A=this.getMetadata().getProperty("areaShrinkRatio").getDefaultValue();if(this.getAreaShrinkRatio()===A&&this.getPrimaryArea()===d.Middle){S.headingAreaShrinkFactor=f.PRIMARY_AREA_MIDDLE_SHRINK_FACTORS.headingAreaShrinkFactor;S.contentAreaShrinkFactor=f.PRIMARY_AREA_MIDDLE_SHRINK_FACTORS.contentAreaShrinkFactor;S.actionsAreaShrinkFactor=f.PRIMARY_AREA_MIDDLE_SHRINK_FACTORS.actionsAreaShrinkFactor;}q.toggleStyleClass("sapUiHidden",!this._getShowExpandButton());return{id:this.getId(),actionBar:this._getActionsToolbar(),navigationBar:this._getNavigationActionsToolbar(),hasActions:h,hasNavigationActions:j,content:k,hasContent:k.length>0,heading:this.getHeading(),snappedHeading:this.getSnappedHeading(),expandedHeading:this.getExpandedHeading(),expandButton:q,focusSpan:F,snappedTitleOnMobileContext:t,snappedTitleOnMobileIcon:u,snappedContent:s,expandedContent:E,hasSnappedContent:p,hasExpandedContent:n,hasSnappedTitleOnMobile:v,hasAdditionalContent:n||(p&&!v),isSnapped:!this._bExpandedState,headingAreaShrinkFactor:S.headingAreaShrinkFactor,contentAreaShrinkFactor:S.contentAreaShrinkFactor,actionsAreaShrinkFactor:S.actionsAreaShrinkFactor,breadcrumbs:this.getBreadcrumbs(),separator:this._getToolbarSeparator(),hasTopContent:w,hasOnlyBreadcrumbs:x,hasOnlyNavigationActions:y,contentAreaFlexBasis:this._sContentAreaFlexBasis,actionsAreaFlexBasis:this._sActionsAreaFlexBasis,isFocusable:this._bIsFocusable};};
f.prototype._getShrinkFactorsObject=function(){var r={},A=this.getAreaShrinkRatio().split(":");r.headingAreaShrinkFactor=parseFloat(A[0]);r.contentAreaShrinkFactor=parseFloat(A[1]);r.actionsAreaShrinkFactor=parseFloat(A[2]);return r;};
f.prototype._observeChanges=function(h){var j=h.object,s=h.name;if(j===this){if(s==="content"||s==="_actionsToolbar"){this._observeContentChanges(h);}}else if(s==="visible"){this._updateTopAreaVisibility();}};
f.prototype._observeContentChanges=function(h){var j=h.child,s=h.mutation;if(!(j instanceof O)){return;}if(s==="insert"){j.attachEvent("_contentSizeChange",this._onContentSizeChange,this);}else if(s==="remove"){j.detachEvent("_contentSizeChange",this._onContentSizeChange,this);this._setContentAreaFlexBasis(0,j.$().parent());}};
f.prototype._onContentSizeChange=function(E){var h=E.getParameter("contentSize"),n=E.getParameter("invalidate");if(n){this.invalidate();}else{this._setContentAreaFlexBasis(h,E.getSource().$().parent());}};
f.prototype._setContentAreaFlexBasis=function(h,$){var F,s;h=parseInt(h);F=h?h+"px":"auto";s=F!=="auto"?F:undefined;$.css({"flex-basis":F});if($.hasClass("sapFDynamicPageTitleMainContent")){this._sContentAreaFlexBasis=s;}else if($.hasClass("sapFDynamicPageTitleMainActions")){this._sActionsAreaFlexBasis=s;}};
f.prototype._updateARIAState=function(E){var A=this._getARIALabelReferences(E)||f.DEFAULT_HEADER_TEXT_ID,$=this._getFocusSpan().$();$.attr("aria-labelledby",A);$.attr("aria-expanded",E);return this;};
f.prototype._getARIALabelReferences=function(E){var r="",h=this.getHeading()||(E?this.getExpandedHeading():this.getSnappedHeading());if(h){r+=h.getId();}return r;};
f.prototype._focus=function(){this._getFocusSpan().$().focus();};
f.prototype._getFocusSpan=function(){if(!this.getAggregation("_focusSpan")){var t=this._bIsFocusable?'tabindex="0"':'',s=this._getARIALabelReferences(this._bExpandedState)||f.DEFAULT_HEADER_TEXT_ID,F=new H({id:this.getId()+"-focusSpan",preferDOM:false,content:'<span class="sapFDynamicPageTitleFocusSpan" role="button" '+t+'data-sap-ui="'+this.getId()+'-focusSpan"'+' aria-expanded="'+this._bExpandedState+'" aria-labelledby="'+s+'" aria-describedby="'+f.TOGGLE_HEADER_TEXT_ID+'"></span>'});F.onfocusin=this._addFocusClass.bind(this);F.onfocusout=this._removeFocusClass.bind(this);F.onsapenter=function(){this.fireEvent("_titlePress");}.bind(this);F.onkeyup=function(E){if(E&&E.which===K.SPACE&&!E.shiftKey){this.fireEvent("_titlePress");}}.bind(this);this.setAggregation("_focusSpan",F,true);}return this.getAggregation("_focusSpan");};
f.prototype._addFocusClass=function(){this.$().addClass("sapFDynamicPageTitleFocus");};
f.prototype._removeFocusClass=function(){this.$().removeClass("sapFDynamicPageTitleFocus");};
return f;});
sap.ui.predefine('sap/f/DynamicPageTitleRenderer',["./library"],function(l){"use strict";var D={apiVersion:2};
D.render=function(r,d){var o=d._getState(),s="sapFDynamicPageTitle",b=d.getBackgroundDesign();r.openStart("div",d);r.class(s);if(b){r.class(s+b);}r.openEnd();r.renderControl(o.focusSpan);this._renderTopArea(r,o);this._renderMainArea(r,o);this._renderSnappedExpandedContentArea(r,o);if(o.hasSnappedTitleOnMobile){this._renderSnappedTitleOnMobile(r,o);}r.renderControl(o.expandButton);r.close("div");};
D._renderTopArea=function(r,d){if(d.hasTopContent){r.openStart("div",d.id+"-top");r.class("sapFDynamicPageTitleTop");if(d.hasOnlyBreadcrumbs){r.class("sapFDynamicPageTitleTopBreadCrumbsOnly");}if(d.hasOnlyNavigationActions){r.class("sapFDynamicPageTitleTopNavActionsOnly");}r.openEnd();this._renderTopBreadcrumbsArea(r,d);this._renderTopNavigationArea(r,d);r.close("div");}};
D._renderTopBreadcrumbsArea=function(r,d){if(d.breadcrumbs){r.openStart("div",d.id+"-breadcrumbs");r.class("sapFDynamicPageTitleTopLeft");r.openEnd();r.renderControl(d.breadcrumbs);r.close("div");}};
D._renderTopNavigationArea=function(r,d){if(d.hasNavigationActions){r.openStart("div",d.id+"-topNavigationArea");r.class("sapFDynamicPageTitleTopRight");r.openEnd();r.close("div");}};
D._renderMainArea=function(r,d){r.openStart("div",d.id+"-main");r.class("sapFDynamicPageTitleMain");if(!d.hasContent){r.class("sapFDynamicPageTitleMainNoContent");}r.openEnd();r.openStart("div");r.class("sapFDynamicPageTitleMainInner");r.openEnd();this._renderMainHeadingArea(r,d);this._renderMainContentArea(r,d);this._renderMainActionsArea(r,d);r.close("div");this._renderMainNavigationArea(r,d);r.close("div");};
D._renderMainHeadingArea=function(r,d){r.openStart("div",d.id+"-left-inner");r.class("sapFDynamicPageTitleMainHeading");r.style("flex-shrink",d.headingAreaShrinkFactor);r.openEnd();r.openStart("div");r.class("sapFDynamicPageTitleHeading-CTX");r.class("sapFDynamicPageTitleMainHeadingInner");r.openEnd();if(d.heading){r.renderControl(d.heading);}else{if(d.snappedHeading){D._renderSnappedHeading(r,d);}if(d.expandedHeading){D._renderExpandHeading(r,d);}}r.close("div");r.close("div");};
D._renderMainContentArea=function(r,d){r.openStart("div",d.id+"-content");r.class("sapFDynamicPageTitleMainContent");r.class("sapFDynamicPageTitleContent-CTX");r.style("flex-shrink",d.contentAreaShrinkFactor);if(d.contentAreaFlexBasis){r.style("flex-basis",d.contentAreaFlexBasis);}r.openEnd();d.content.forEach(r.renderControl,r);r.close("div");};
D._renderMainActionsArea=function(r,d){r.openStart("div",d.id+"-mainActions");r.class("sapFDynamicPageTitleMainActions");r.style("flex-shrink",d.actionsAreaShrinkFactor);if(d.actionsAreaFlexBasis){r.style("flex-basis",d.actionsAreaFlexBasis);}r.openEnd();if(d.hasActions){r.renderControl(d.actionBar);}r.close("div");};
D._renderMainNavigationArea=function(r,d){if(d.hasNavigationActions){r.openStart("div",d.id+"-mainNavigationAreaWrapper");r.class("sapFDynamicPageTitleMainNavigationArea");r.openEnd();r.renderControl(d.separator);r.openStart("div",d.id+"-mainNavigationArea");r.class("sapFDynamicPageTitleMainNavigationAreaInner");r.openEnd();r.close("div");r.close("div");}};
D._renderSnappedExpandedContentArea=function(r,d){if(d.hasAdditionalContent){r.openStart("div");r.class("sapFDynamicPageTitleMainHeadingSnappedExpandContent");r.openEnd();if(d.hasSnappedContent&&!d.hasSnappedTitleOnMobile){D._renderSnappedContent(r,d);}if(d.hasExpandedContent){D._renderExpandContent(r,d);}r.close("div");}};
D._renderExpandHeading=function(r,d){r.openStart("div",d.id+"-expand-heading-wrapper");r.openEnd();r.renderControl(d.expandedHeading);r.close("div");};
D._renderSnappedHeading=function(r,d){r.openStart("div",d.id+"-snapped-heading-wrapper");if(!d.isSnapped){r.class("sapUiHidden");}r.openEnd();r.renderControl(d.snappedHeading);r.close("div");};
D._renderExpandContent=function(r,d){r.openStart("div",d.id+"-expand-wrapper");r.openEnd();d.expandedContent.forEach(r.renderControl,r);r.close("div");};
D._renderSnappedContent=function(r,d){r.openStart("div",d.id+"-snapped-wrapper");if(!d.isSnapped){r.class("sapUiHidden");}r.class("sapFDynamicPageTitleSnapped");r.openEnd();d.snappedContent.forEach(r.renderControl,r);r.close("div");};
D._renderSnappedTitleOnMobile=function(r,d){r.openStart("div",d.id+"-snapped-title-on-mobile-wrapper");if(!d.isSnapped){r.class("sapUiHidden");}r.class("sapFDynamicPageTitleSnappedTitleOnMobile");r.openEnd();r.renderControl(d.snappedTitleOnMobileContext);r.renderControl(d.snappedTitleOnMobileIcon);r.close("div");};
return D;},true);
sap.ui.predefine('sap/f/FlexibleColumnLayout',["sap/ui/thirdparty/jquery","./library","sap/ui/Device","sap/ui/core/ResizeHandler","sap/ui/core/Control","sap/m/library","sap/m/Button","sap/m/NavContainer","sap/ui/core/Configuration","sap/ui/core/theming/Parameters",'sap/ui/dom/units/Rem',"./FlexibleColumnLayoutRenderer","sap/base/assert"],function(q,l,D,R,C,m,B,N,a,P,b,F,c){"use strict";var L=l.LayoutType;
var d=C.extend("sap.f.FlexibleColumnLayout",{metadata:{properties:{layout:{type:"sap.f.LayoutType",defaultValue:L.OneColumn},defaultTransitionNameBeginColumn:{type:"string",group:"Appearance",defaultValue:"slide"},defaultTransitionNameMidColumn:{type:"string",group:"Appearance",defaultValue:"slide"},defaultTransitionNameEndColumn:{type:"string",group:"Appearance",defaultValue:"slide"},backgroundDesign:{type:"sap.m.BackgroundDesign",group:"Appearance",defaultValue:m.BackgroundDesign.Transparent}},aggregations:{beginColumnPages:{type:"sap.ui.core.Control",multiple:true,forwarding:{getter:"_getBeginColumn",aggregation:"pages"}},midColumnPages:{type:"sap.ui.core.Control",multiple:true,forwarding:{getter:"_getMidColumn",aggregation:"pages"}},endColumnPages:{type:"sap.ui.core.Control",multiple:true,forwarding:{getter:"_getEndColumn",aggregation:"pages"}},_beginColumnNav:{type:"sap.m.NavContainer",multiple:false,visibility:"hidden"},_midColumnNav:{type:"sap.m.NavContainer",multiple:false,visibility:"hidden"},_endColumnNav:{type:"sap.m.NavContainer",multiple:false,visibility:"hidden"},_beginColumnBackArrow:{type:"sap.m.Button",multiple:false,visibility:"hidden"},_midColumnForwardArrow:{type:"sap.m.Button",multiple:false,visibility:"hidden"},_midColumnBackArrow:{type:"sap.m.Button",multiple:false,visibility:"hidden"},_endColumnForwardArrow:{type:"sap.m.Button",multiple:false,visibility:"hidden"}},associations:{initialBeginColumnPage:{type:"sap.ui.core.Control",multiple:false},initialMidColumnPage:{type:"sap.ui.core.Control",multiple:false},initialEndColumnPage:{type:"sap.ui.core.Control",multiple:false}},events:{stateChange:{parameters:{layout:{type:"sap.f.LayoutType"},maxColumnsCount:{type:"int"},isNavigationArrow:{type:"boolean"},isResize:{type:"boolean"}}},beginColumnNavigate:{allowPreventDefault:true,parameters:{from:{type:"sap.ui.core.Control"},fromId:{type:"string"},to:{type:"sap.ui.core.Control"},toId:{type:"string"},firstTime:{type:"boolean"},isTo:{type:"boolean"},isBack:{type:"boolean"},isBackToTop:{type:"boolean"},isBackToPage:{type:"boolean"},direction:{type:"string"}}},afterBeginColumnNavigate:{parameters:{from:{type:"sap.ui.core.Control"},fromId:{type:"string"},to:{type:"sap.ui.core.Control"},toId:{type:"string"},firstTime:{type:"boolean"},isTo:{type:"boolean"},isBack:{type:"boolean"},isBackToTop:{type:"boolean"},isBackToPage:{type:"boolean"},direction:{type:"string"}}},midColumnNavigate:{allowPreventDefault:true,parameters:{from:{type:"sap.ui.core.Control"},fromId:{type:"string"},to:{type:"sap.ui.core.Control"},toId:{type:"string"},firstTime:{type:"boolean"},isTo:{type:"boolean"},isBack:{type:"boolean"},isBackToTop:{type:"boolean"},isBackToPage:{type:"boolean"},direction:{type:"string"}}},afterMidColumnNavigate:{parameters:{from:{type:"sap.ui.core.Control"},fromId:{type:"string"},to:{type:"sap.ui.core.Control"},toId:{type:"string"},firstTime:{type:"boolean"},isTo:{type:"boolean"},isBack:{type:"boolean"},isBackToTop:{type:"boolean"},isBackToPage:{type:"boolean"},direction:{type:"string"}}},endColumnNavigate:{allowPreventDefault:true,parameters:{from:{type:"sap.ui.core.Control"},fromId:{type:"string"},to:{type:"sap.ui.core.Control"},toId:{type:"string"},firstTime:{type:"boolean"},isTo:{type:"boolean"},isBack:{type:"boolean"},isBackToTop:{type:"boolean"},isBackToPage:{type:"boolean"},direction:{type:"string"}}},afterEndColumnNavigate:{parameters:{from:{type:"sap.ui.core.Control"},fromId:{type:"string"},to:{type:"sap.ui.core.Control"},toId:{type:"string"},firstTime:{type:"boolean"},isTo:{type:"boolean"},isBack:{type:"boolean"},isBackToTop:{type:"boolean"},isBackToPage:{type:"boolean"},direction:{type:"string"}}}}}});
d.COLUMN_RESIZING_ANIMATION_DURATION=560;d.PINNED_COLUMN_CLASS_NAME="sapFFCLPinnedColumn";
d.prototype.init=function(){this._initNavContainers();this._initButtons();this._oLayoutHistory=new e();this._oRenderedColumnPagesBoolMap={};this._iNavigationArrowWidth=b.toPx(P.get("_sap_f_FCL_navigation_arrow_width"));};
d.prototype._onNavContainerRendered=function(E){var o=E.srcControl,h=o.getPages().length>0,H=this._hasAnyColumnPagesRendered();this._setColumnPagesRendered(o.getId(),h);if(this._hasAnyColumnPagesRendered()!==H){this._hideShowArrows();}};
d.prototype._createNavContainer=function(s){var f=s.charAt(0).toUpperCase()+s.slice(1);var n=new N(this.getId()+"-"+s+"ColumnNav",{navigate:function(E){this._handleNavigationEvent(E,false,s);}.bind(this),afterNavigate:function(E){this._handleNavigationEvent(E,true,s);}.bind(this),defaultTransitionName:this["getDefaultTransitionName"+f+"Column"]()});n.addDelegate({"onAfterRendering":this._onNavContainerRendered},this);return n;};
d.prototype._handleNavigationEvent=function(E,A,s){var f,g;if(A){f="after"+(s.charAt(0).toUpperCase()+s.slice(1))+"ColumnNavigate";}else{f=s+"ColumnNavigate";}g=this.fireEvent(f,E.mParameters,true);if(!g){E.preventDefault();}};
d.prototype._getBeginColumn=function(){return this.getAggregation("_beginColumnNav");};
d.prototype._getMidColumn=function(){return this.getAggregation("_midColumnNav");};
d.prototype._getEndColumn=function(){return this.getAggregation("_endColumnNav");};
d.prototype._flushColumnContent=function(s){var o=this.getAggregation("_"+s+"ColumnNav"),r=sap.ui.getCore().createRenderManager();r.renderControl(o);r.flush(this._$columns[s].find(".sapFFCLColumnContent")[0],undefined,true);r.destroy();};
d.prototype.setLayout=function(n){n=this.validateProperty("layout",n);var s=this.getLayout();if(s===n){return this;}var r=this.setProperty("layout",n,true);this._oLayoutHistory.addEntry(n);this._hideShowArrows();this._resizeColumns();return r;};
d.prototype.onBeforeRendering=function(){this._deregisterResizeHandler();};
d.prototype.onAfterRendering=function(){this._registerResizeHandler();this._cacheDOMElements();this._hideShowArrows();this._resizeColumns();this._flushColumnContent("begin");this._flushColumnContent("mid");this._flushColumnContent("end");this._fireStateChange(false,false);};
d.prototype._getControlWidth=function(){return this.$().width();};
d.prototype.exit=function(){this._oRenderedColumnPagesBoolMap=null;this._deregisterResizeHandler();this._handleEvent(q.Event("Destroy"));};
d.prototype._registerResizeHandler=function(){c(!this._iResizeHandlerId,"Resize handler already registered");this._iResizeHandlerId=R.register(this,this._onResize.bind(this));};
d.prototype._deregisterResizeHandler=function(){if(this._iResizeHandlerId){R.deregister(this._iResizeHandlerId);this._iResizeHandlerId=null;}};
d.prototype._initNavContainers=function(){this.setAggregation("_beginColumnNav",this._createNavContainer("begin"),true);this.setAggregation("_midColumnNav",this._createNavContainer("mid"),true);this.setAggregation("_endColumnNav",this._createNavContainer("end"),true);};
d.prototype._initButtons=function(){var o=new B(this.getId()+"-beginBack",{icon:"sap-icon://slim-arrow-left",tooltip:d._getResourceBundle().getText("FCL_BEGIN_COLUMN_BACK_ARROW"),type:"Transparent",press:this._onArrowClick.bind(this,"left")}).addStyleClass("sapFFCLNavigationButton").addStyleClass("sapFFCLNavigationButtonRight");this.setAggregation("_beginColumnBackArrow",o,true);var M=new B(this.getId()+"-midForward",{icon:"sap-icon://slim-arrow-right",tooltip:d._getResourceBundle().getText("FCL_MID_COLUMN_FORWARD_ARROW"),type:"Transparent",press:this._onArrowClick.bind(this,"right")}).addStyleClass("sapFFCLNavigationButton").addStyleClass("sapFFCLNavigationButtonLeft");this.setAggregation("_midColumnForwardArrow",M,true);var f=new B(this.getId()+"-midBack",{icon:"sap-icon://slim-arrow-left",tooltip:d._getResourceBundle().getText("FCL_MID_COLUMN_BACK_ARROW"),type:"Transparent",press:this._onArrowClick.bind(this,"left")}).addStyleClass("sapFFCLNavigationButton").addStyleClass("sapFFCLNavigationButtonRight");this.setAggregation("_midColumnBackArrow",f,true);var E=new B(this.getId()+"-endForward",{icon:"sap-icon://slim-arrow-right",tooltip:d._getResourceBundle().getText("FCL_END_COLUMN_FORWARD_ARROW"),type:"Transparent",press:this._onArrowClick.bind(this,"right")}).addStyleClass("sapFFCLNavigationButton").addStyleClass("sapFFCLNavigationButtonLeft");this.setAggregation("_endColumnForwardArrow",E,true);};
d.prototype._cacheDOMElements=function(){this._cacheColumns();if(!D.system.phone){this._cacheArrows();}};
d.prototype._cacheColumns=function(){this._$columns={begin:this.$("beginColumn"),mid:this.$("midColumn"),end:this.$("endColumn")};};
d.prototype._cacheArrows=function(){this._$columnButtons={beginBack:this.$("beginBack"),midForward:this.$("midForward"),midBack:this.$("midBack"),endForward:this.$("endForward")};};
d.prototype._getVisibleColumnsCount=function(){return["begin","mid","end"].filter(function(s){return this._getColumnSize(s)>0;},this).length;};
d.prototype._getVisibleArrowsCount=function(){if(!this._$columnButtons||!this._$columnButtons.length){return 0;}return Object.keys(this._$columnButtons).filter(function(A){return this._$columnButtons[A].data("visible");},this).length;};
d.prototype._getTotalColumnsWidth=function(h){var s=this._getVisibleArrowsCount();if(h){s++;}return this._getControlWidth()-s*this._iNavigationArrowWidth;};
d.prototype._resizeColumns=function(){var p,A,f=["begin","mid","end"],r=sap.ui.getCore().getConfiguration().getRTL(),h=sap.ui.getCore().getConfiguration().getAnimationMode()!==a.AnimationMode.none,g,v,i,s,j,I;if(!this.isActive()){return;}v=this._getVisibleColumnsCount();if(v===0){return;}s=this.getLayout();i=this._getMaxColumnsCountForLayout(s,d.DESKTOP_BREAKPOINT);j=f[i-1];I=(v===3)&&(s===L.ThreeColumnsEndExpanded);A=this._getTotalColumnsWidth(I);if(h){f.forEach(function(k){var S=this._shouldConcealColumn(i,k),n=this._shouldRevealColumn(i,k===j),o=this._$columns[k];o.toggleClass(d.PINNED_COLUMN_CLASS_NAME,S||n);},this);}f.forEach(function(k){var o=this._$columns[k],n,t,S;p=this._getColumnSize(k);S=h&&this._shouldConcealColumn(i,k);if(!S){o.toggleClass("sapFFCLColumnActive",p>0);}o.toggleClass("sapFFCLColumnInset",I&&(k==="mid"));o.removeClass("sapFFCLColumnHidden");o.removeClass("sapFFCLColumnOnlyActive");o.removeClass("sapFFCLColumnLastActive");o.removeClass("sapFFCLColumnFirstActive");n=Math.round(A*(p/100));if([100,0].indexOf(p)!==-1){t=p+"%";}else{t=n+"px";}if(h){var u=o.get(0);if(o._iResumeResizeHandlerTimeout){clearTimeout(o._iResumeResizeHandlerTimeout);}R.suspend(u);o._iResumeResizeHandlerTimeout=setTimeout(function(){if(S){o.width(t);o.toggleClass("sapFFCLColumnActive",false);}R.resume(u);o._iResumeResizeHandlerTimeout=null;o.toggleClass(d.PINNED_COLUMN_CLASS_NAME,false);this._adjustColumnDisplay(o,n);}.bind(this),d.COLUMN_RESIZING_ANIMATION_DURATION);}else{this._adjustColumnDisplay(o,n);}if(!S){o.width(t);}if(!D.system.phone){this._updateColumnContextualSettings(k,n);this._updateColumnCSSClasses(k,n);}},this);g=f.filter(function(k){return this._getColumnSize(k)>0;},this);if(r){f.reverse();}if(g.length===1){this._$columns[g[0]].addClass("sapFFCLColumnOnlyActive");}if(g.length>1){this._$columns[g[0]].addClass("sapFFCLColumnFirstActive");this._$columns[g[g.length-1]].addClass("sapFFCLColumnLastActive");}this._storePreviousResizingInfo(i,j);};
d.prototype._adjustColumnDisplay=function(o,n){if(n===0){o.addClass("sapFFCLColumnHidden");}else{o.removeClass("sapFFCLColumnHidden");}};
d.prototype._storePreviousResizingInfo=function(v,s){var o=this.getLayout();this._iPreviousVisibleColumnsCount=v;this._bWasFullScreen=o===L.MidColumnFullScreen||o===L.EndColumnFullScreen;this._sPreviuosLastVisibleColumn=s;};
d.prototype._shouldRevealColumn=function(v,i){return(v>this._iPreviousVisibleColumnsCount)&&!this._bWasFullScreen&&i;};
d.prototype._shouldConcealColumn=function(v,s){return(v<this._iPreviousVisibleColumnsCount&&s===this._sPreviuosLastVisibleColumn&&!this._bWasFullScreen&&this._getColumnSize(s)===0);};
d.prototype._propagateContextualSettings=function(){};
d.prototype._updateColumnContextualSettings=function(s,w){var o,f;o=this.getAggregation("_"+s+"ColumnNav");if(!o){return;}f=o._getContextualSettings();if(!f||f.contextualWidth!==w){o._applyContextualSettings({contextualWidth:w});}};
d.prototype._updateColumnCSSClasses=function(s,w){var n="";this._$columns[s].removeClass("sapUiContainer-Narrow sapUiContainer-Medium sapUiContainer-Wide sapUiContainer-ExtraWide");if(w<D.media._predefinedRangeSets[D.media.RANGESETS.SAP_STANDARD_EXTENDED].points[0]){n="Narrow";}else if(w<D.media._predefinedRangeSets[D.media.RANGESETS.SAP_STANDARD_EXTENDED].points[1]){n="Medium";}else if(w<D.media._predefinedRangeSets[D.media.RANGESETS.SAP_STANDARD_EXTENDED].points[2]){n="Wide";}else{n="ExtraWide";}this._$columns[s].addClass("sapUiContainer-"+n);};
d.prototype._getColumnSize=function(s){var f=this.getLayout(),g=this._getColumnWidthDistributionForLayout(f),S=g.split("/"),M={begin:0,mid:1,end:2},h=S[M[s]];return parseInt(h);};
d.prototype.getMaxColumnsCount=function(){return this._getMaxColumnsCountForWidth(this._getControlWidth());};
d.prototype._getMaxColumnsCountForWidth=function(w){if(w>=d.DESKTOP_BREAKPOINT){return 3;}if(w>=d.TABLET_BREAKPOINT&&w<d.DESKTOP_BREAKPOINT){return 2;}if(w>0){return 1;}return 0;};
d.prototype._getMaxColumnsCountForLayout=function(s,w){var i=this._getMaxColumnsCountForWidth(w),f=this._getColumnWidthDistributionForLayout(s,false,i),S=f.split("/"),M={begin:0,mid:1,end:2},g,h,j=0;Object.keys(M).forEach(function(k){g=S[M[k]];h=parseInt(g);if(h){j++;}});return j;};
d.prototype._onResize=function(E){var o=E.oldSize.width,n=E.size.width,O,M;if(n===0){return;}O=this._getMaxColumnsCountForWidth(o);M=this._getMaxColumnsCountForWidth(n);this._resizeColumns();if(M!==O){this._hideShowArrows();this._fireStateChange(false,true);}};
d.prototype._setColumnPagesRendered=function(i,h){this._oRenderedColumnPagesBoolMap[i]=h;};
d.prototype._hasAnyColumnPagesRendered=function(){return Object.keys(this._oRenderedColumnPagesBoolMap).some(function(k){return this._oRenderedColumnPagesBoolMap[k];},this);};
d.prototype._onArrowClick=function(s){var f=this.getLayout(),i=typeof d.SHIFT_TARGETS[f]!=="undefined"&&typeof d.SHIFT_TARGETS[f][s]!=="undefined",n;c(i,"An invalid layout was used for determining arrow behavior");n=i?d.SHIFT_TARGETS[f][s]:L.OneColumn;this.setLayout(n);if(d.ARROWS_NAMES[n][s]!==d.ARROWS_NAMES[f][s]&&i){var o=s==='right'?'left':'right';this._$columnButtons[d.ARROWS_NAMES[n][o]].focus();}this._fireStateChange(true,false);};
d.prototype._hideShowArrows=function(){var s=this.getLayout(),M={},n=[],i,I;if(!this.isActive()||D.system.phone){return;}i=this.getMaxColumnsCount();if(i>1){M[L.TwoColumnsBeginExpanded]=["beginBack"];M[L.TwoColumnsMidExpanded]=["midForward"];M[L.ThreeColumnsMidExpanded]=["midForward","midBack"];M[L.ThreeColumnsEndExpanded]=["endForward"];M[L.ThreeColumnsMidExpandedEndHidden]=["midForward","midBack"];M[L.ThreeColumnsBeginExpandedEndHidden]=["beginBack"];if(typeof M[s]==="object"){n=M[s];}}I=this._hasAnyColumnPagesRendered();Object.keys(this._$columnButtons).forEach(function(k){this._toggleButton(k,n.indexOf(k)!==-1,I);},this);};
d.prototype._toggleButton=function(s,S,r){this._$columnButtons[s].toggle(S&&r);this._$columnButtons[s].data("visible",S);};
d.prototype._fireStateChange=function(i,I){if(this._getControlWidth()===0){return;}this.fireStateChange({isNavigationArrow:i,isResize:I,layout:this.getLayout(),maxColumnsCount:this.getMaxColumnsCount()});};
d.prototype.setInitialBeginColumnPage=function(p){this._getBeginColumn().setInitialPage(p);this.setAssociation('initialBeginColumnPage',p,true);return this;};
d.prototype.setInitialMidColumnPage=function(p){this._getMidColumn().setInitialPage(p);this.setAssociation('initialMidColumnPage',p,true);return this;};
d.prototype.setInitialEndColumnPage=function(p){this._getEndColumn().setInitialPage(p);this.setAssociation('initialEndColumnPage',p,true);return this;};
d.prototype.to=function(p,t,o,T){if(this._getBeginColumn().getPage(p)){this._getBeginColumn().to(p,t,o,T);}else if(this._getMidColumn().getPage(p)){this._getMidColumn().to(p,t,o,T);}else{this._getEndColumn().to(p,t,o,T);}return this;};
d.prototype.backToPage=function(p,o,t){if(this._getBeginColumn().getPage(p)){this._getBeginColumn().backToPage(p,o,t);}else if(this._getMidColumn().getPage(p)){this._getMidColumn().backToPage(p,o,t);}else{this._getEndColumn().backToPage(p,o,t);}return this;};
d.prototype._safeBackToPage=function(p,t,f,T){if(this._getBeginColumn().getPage(p)){this._getBeginColumn()._safeBackToPage(p,t,f,T);}else if(this._getMidColumn().getPage(p)){this._getMidColumn()._safeBackToPage(p,t,f,T);}else{this._getEndColumn()._safeBackToPage(p,t,f,T);}};
d.prototype.toBeginColumnPage=function(p,t,o,T){this._getBeginColumn().to(p,t,o,T);return this;};
d.prototype.toMidColumnPage=function(p,t,o,T){this._getMidColumn().to(p,t,o,T);return this;};
d.prototype.toEndColumnPage=function(p,t,o,T){this._getEndColumn().to(p,t,o,T);return this;};
d.prototype.backBeginColumn=function(f,t){return this._getBeginColumn().back(f,t);};
d.prototype.backMidColumn=function(f,t){return this._getMidColumn().back(f,t);};
d.prototype.backEndColumn=function(f,t){return this._getEndColumn().back(f,t);};
d.prototype.backBeginColumnToPage=function(p,f,t){return this._getBeginColumn().backToPage(p,f,t);};
d.prototype.backMidColumnToPage=function(p,f,t){return this._getMidColumn().backToPage(p,f,t);};
d.prototype.backEndColumnToPage=function(p,f,t){return this._getEndColumn().backToPage(p,f,t);};
d.prototype.backToTopBeginColumn=function(o,t){this._getBeginColumn().backToTop(o,t);return this;};
d.prototype.backToTopMidColumn=function(o,t){this._getMidColumn().backToTop(o,t);return this;};
d.prototype.backToTopEndColumn=function(o,t){this._getEndColumn().backToTop(o,t);return this;};
d.prototype.getCurrentBeginColumnPage=function(){return this._getBeginColumn().getCurrentPage();};
d.prototype.getCurrentMidColumnPage=function(){return this._getMidColumn().getCurrentPage();};
d.prototype.getCurrentEndColumnPage=function(){return this._getEndColumn().getCurrentPage();};
d.prototype.setDefaultTransitionNameBeginColumn=function(t){this.setProperty("defaultTransitionNameBeginColumn",t,true);this._getBeginColumn().setDefaultTransitionName(t);return this;};
d.prototype.setDefaultTransitionNameMidColumn=function(t){this.setProperty("defaultTransitionNameMidColumn",t,true);this._getMidColumn().setDefaultTransitionName(t);return this;};
d.prototype.setDefaultTransitionNameEndColumn=function(t){this.setProperty("defaultTransitionNameEndColumn",t,true);this._getEndColumn().setDefaultTransitionName(t);return this;};
d.prototype._getLayoutHistory=function(){return this._oLayoutHistory;};
d.prototype._getColumnWidthDistributionForLayout=function(s,A,M){var o={},r;M||(M=this.getMaxColumnsCount());if(M===0){r="0/0/0";}else{o[L.OneColumn]="100/0/0";o[L.MidColumnFullScreen]="0/100/0";o[L.EndColumnFullScreen]="0/0/100";if(M===1){o[L.TwoColumnsBeginExpanded]="0/100/0";o[L.TwoColumnsMidExpanded]="0/100/0";o[L.ThreeColumnsMidExpanded]="0/0/100";o[L.ThreeColumnsEndExpanded]="0/0/100";o[L.ThreeColumnsMidExpandedEndHidden]="0/0/100";o[L.ThreeColumnsBeginExpandedEndHidden]="0/0/100";}else{o[L.TwoColumnsBeginExpanded]="67/33/0";o[L.TwoColumnsMidExpanded]="33/67/0";o[L.ThreeColumnsMidExpanded]=M===2?"0/67/33":"25/50/25";o[L.ThreeColumnsEndExpanded]=M===2?"0/33/67":"25/25/50";o[L.ThreeColumnsMidExpandedEndHidden]="33/67/0";o[L.ThreeColumnsBeginExpandedEndHidden]="67/33/0";}r=o[s];}if(A){r=r.split("/").map(function(f){return parseInt(f);});}return r;};
d.DESKTOP_BREAKPOINT=1280;d.TABLET_BREAKPOINT=960;d.ARROWS_NAMES={TwoColumnsBeginExpanded:{"left":"beginBack"},TwoColumnsMidExpanded:{"right":"midForward"},ThreeColumnsMidExpanded:{"left":"midBack","right":"midForward"},ThreeColumnsEndExpanded:{"right":"endForward"},ThreeColumnsMidExpandedEndHidden:{"left":"midBack","right":"midForward"},ThreeColumnsBeginExpandedEndHidden:{"left":"beginBack"}};
d._getResourceBundle=function(){return sap.ui.getCore().getLibraryResourceBundle("sap.f");};
d.SHIFT_TARGETS={TwoColumnsBeginExpanded:{"left":L.TwoColumnsMidExpanded},TwoColumnsMidExpanded:{"right":L.TwoColumnsBeginExpanded},ThreeColumnsMidExpanded:{"left":L.ThreeColumnsEndExpanded,"right":L.ThreeColumnsMidExpandedEndHidden},ThreeColumnsEndExpanded:{"right":L.ThreeColumnsMidExpanded},ThreeColumnsMidExpandedEndHidden:{"left":L.ThreeColumnsMidExpanded,"right":L.ThreeColumnsBeginExpandedEndHidden},ThreeColumnsBeginExpandedEndHidden:{"left":L.ThreeColumnsMidExpandedEndHidden}};
function e(){this._aLayoutHistory=[];}
e.prototype.addEntry=function(s){if(typeof s!=="undefined"){this._aLayoutHistory.push(s);}};
e.prototype.getClosestEntryThatMatches=function(f){var i;for(i=this._aLayoutHistory.length-1;i>=0;i--){if(f.indexOf(this._aLayoutHistory[i])!==-1){return this._aLayoutHistory[i];}}};
return d;});
sap.ui.predefine('sap/f/FlexibleColumnLayoutRenderer',["sap/ui/core/InvisibleText","sap/ui/Device","sap/m/library"],function(I,D,m){"use strict";var F={apiVersion:2};
F.render=function(r,c){var b=c.getBackgroundDesign();r.openStart("div",c);r.class("sapFFCL");if(b!==m.BackgroundDesign.Transparent){r.class("sapFFCLBackgroundDesign"+b);}r.openEnd();F.renderBeginColumn(r,c);F.renderMidColumn(r,c);F.renderEndColumn(r,c);r.close("div");};
F.renderBeginColumn=function(r,c){var b=c.getAggregation("_beginColumnBackArrow");r.openStart("div",c.getId()+"-beginColumn");r.accessibilityState(c,{role:"region",labelledby:I.getStaticId("sap.f","FCL_BEGIN_COLUMN_REGION_TEXT")});r.class("sapFFCLColumn");r.class("sapFFCLColumnBegin");r.class("sapFFCLColumnActive");r.openEnd();F.renderColumnContentWrapper(r);r.close("div");F.renderArrow(r,b);};
F.renderMidColumn=function(r,c){var M=c.getAggregation("_midColumnForwardArrow"),o=c.getAggregation("_midColumnBackArrow");F.renderArrow(r,M);r.openStart("div",c.getId()+"-midColumn");r.accessibilityState(c,{role:"region",labelledby:I.getStaticId("sap.f","FCL_MID_COLUMN_REGION_TEXT")});r.class("sapFFCLColumn");r.class("sapFFCLColumnMid");r.openEnd();F.renderColumnContentWrapper(r);r.close("div");F.renderArrow(r,o);};
F.renderEndColumn=function(r,c){var e=c.getAggregation("_endColumnForwardArrow");F.renderArrow(r,e);r.openStart("div",c.getId()+"-endColumn");r.accessibilityState(c,{role:"region",labelledby:I.getStaticId("sap.f","FCL_END_COLUMN_REGION_TEXT")});r.class("sapFFCLColumn");r.class("sapFFCLColumnEnd");r.openEnd();F.renderColumnContentWrapper(r);r.close("div");};
F.renderArrow=function(r,a){if(!D.system.phone){r.openStart("div");r.class("sapFFCLArrow");r.class("sapContrastPlus");r.openEnd();r.renderControl(a);r.close("div");}};
F.renderColumnContentWrapper=function(r){r.openStart("div");r.class("sapFFCLColumnContent");r.openEnd();r.close("div");};
return F;},true);
sap.ui.predefine('sap/f/FlexibleColumnLayoutSemanticHelper',["./library","./FlexibleColumnLayout","sap/base/assert"],function(l,F,a){"use strict";var L=l.LayoutType;var b=function(f,s){var m={Normal:3,MasterDetail:2,SingleColumn:1},i,M;s||(s={});this._oFCL=f;this._defaultLayoutType=L.OneColumn;this._defaultTwoColumnLayoutType=[L.TwoColumnsBeginExpanded,L.TwoColumnsMidExpanded].indexOf(s.defaultTwoColumnLayoutType)!==-1?s.defaultTwoColumnLayoutType:L.TwoColumnsBeginExpanded;this._defaultThreeColumnLayoutType=[L.ThreeColumnsMidExpanded,L.ThreeColumnsEndExpanded].indexOf(s.defaultThreeColumnLayoutType)!==-1?s.defaultThreeColumnLayoutType:L.ThreeColumnsMidExpanded;if(["Normal","MasterDetail","SingleColumn"].indexOf(s.mode)!==-1&&!s.maxColumnsCount){M=m[s.mode];}else{M=s.maxColumnsCount?parseInt(s.maxColumnsCount):3;if(M<1||M>3){M=3;}}this._maxColumnsCount=M;i=s.initialColumnsCount?parseInt(s.initialColumnsCount):1;if(i<1||i>2||this._maxColumnsCount===1){i=1;}this._initialColumnsCount=i;};b._oInstances={};
b.getInstanceFor=function(f,s){a(f instanceof F,"Passed control is not FlexibleColumnLayout");var i=f.getId();if(typeof b._oInstances[i]==="undefined"){b._oInstances[i]=new b(f,s);var d={onDestroy:function(){delete b._oInstances[i];}};f.addEventDelegate(d);}return b._oInstances[i];};
b.prototype.getCurrentUIState=function(){var c=this._oFCL.getLayout();return this._getUIStateForLayout(c);};
b.prototype.getNextUIState=function(n){var c=this._oFCL.getLayout(),i=this._initialColumnsCount,N;if(n===0){if(i===2&&this._canShowTwoColumns()){N=this._defaultTwoColumnLayoutType;}else{N=L.OneColumn;}}if(n===1){if(this._maxColumnsCount===1){N=L.MidColumnFullScreen;}else{if([L.TwoColumnsBeginExpanded,L.TwoColumnsMidExpanded].indexOf(c)!==-1){N=c;}else if([L.MidColumnFullScreen,L.EndColumnFullScreen].indexOf(c)!==-1){N=L.MidColumnFullScreen;}else{N=this._defaultTwoColumnLayoutType;}}}if(n===2){if(this._maxColumnsCount<3){N=L.EndColumnFullScreen;}else{if([L.ThreeColumnsMidExpandedEndHidden,L.ThreeColumnsBeginExpandedEndHidden].indexOf(c)!==-1){N=this._defaultThreeColumnLayoutType;}else if([L.ThreeColumnsMidExpanded,L.ThreeColumnsEndExpanded].indexOf(c)!==-1){N=c;}else if([L.MidColumnFullScreen,L.EndColumnFullScreen].indexOf(c)!==-1){N=L.EndColumnFullScreen;}else{N=this._defaultThreeColumnLayoutType;}}}if(n>2){N=L.EndColumnFullScreen;}return this._getUIStateForLayout(N);};
b.prototype._getUIStateForLayout=function(s){var S=this._oFCL._getColumnWidthDistributionForLayout(s,true),c=S.join("/"),m=this._oFCL.getMaxColumnsCount();return{layout:s,maxColumnsCount:m,columnsSizes:this._getColumnsSizes(S),columnsVisibility:this._getColumnsVisibility(S),isFullScreen:this._getIsFullScreen(S),isLogicallyFullScreen:this._getIsLogicallyFullScreen(s),actionButtonsInfo:this._getActionButtonsInfo(c,m)};};
b.prototype._getColumnsSizes=function(s){return{beginColumn:s[0],midColumn:s[1],endColumn:s[2]};};
b.prototype._getColumnsVisibility=function(s){return{beginColumn:s[0]!==0,midColumn:s[1]!==0,endColumn:s[2]!==0};};
b.prototype._getIsFullScreen=function(s){return s.indexOf(100)!==-1;};
b.prototype._getIsLogicallyFullScreen=function(s){return[L.OneColumn,L.MidColumnFullScreen,L.EndColumnFullScreen].indexOf(s)!==-1;};
b.prototype._getActionButtonsInfo=function(c,m){var M={fullScreen:null,exitFullScreen:null,closeColumn:null},e={fullScreen:null,exitFullScreen:null,closeColumn:null},E,s;if(this._maxColumnsCount===1){return{midColumn:M,endColumn:e};}if(m===1){M.closeColumn=this._defaultLayoutType;e.closeColumn=this._defaultTwoColumnLayoutType;}else{if(c==="67/33/0"||c==="33/67/0"){M.fullScreen=L.MidColumnFullScreen;M.closeColumn=this._defaultLayoutType;}if(c==="25/50/25"||c==="25/25/50"||c==="0/67/33"||c==="0/33/67"){e.fullScreen=L.EndColumnFullScreen;e.closeColumn=this._defaultTwoColumnLayoutType;}if(c==="0/100/0"){E=[L.TwoColumnsBeginExpanded,L.TwoColumnsMidExpanded,L.ThreeColumnsBeginExpandedEndHidden,L.ThreeColumnsMidExpandedEndHidden];s=this._oFCL._getLayoutHistory().getClosestEntryThatMatches(E)||this._defaultTwoColumnLayoutType;M.exitFullScreen=s;M.closeColumn=this._defaultLayoutType;}if(c==="0/0/100"){if(this._maxColumnsCount!==2){E=[L.ThreeColumnsMidExpanded,L.ThreeColumnsEndExpanded];s=this._oFCL._getLayoutHistory().getClosestEntryThatMatches(E)||this._defaultThreeColumnLayoutType;e.exitFullScreen=s;e.closeColumn=this._defaultTwoColumnLayoutType;}}}return{midColumn:M,endColumn:e};};
b.prototype.getDefaultLayouts=function(){return{defaultLayoutType:this._defaultLayoutType,defaultTwoColumnLayoutType:this._defaultTwoColumnLayoutType,defaultThreeColumnLayoutType:this._defaultThreeColumnLayoutType};};
b.prototype._canShowTwoColumns=function(){var c=this._oFCL._getControlWidth(),m=this._oFCL._getMaxColumnsCountForWidth(c||window.innerWidth);return m>1;};
return b;},true);
sap.ui.predefine('sap/f/GridContainer',["sap/ui/core/Control","sap/ui/core/Core","sap/ui/base/ManagedObjectObserver",'sap/ui/core/ResizeHandler',"sap/ui/core/delegate/ItemNavigation","sap/f/GridContainerRenderer","sap/ui/Device","sap/ui/layout/cssgrid/VirtualGrid","sap/f/GridContainerSettings","sap/base/strings/capitalize","sap/ui/core/InvisibleRenderer"],function(C,a,M,R,I,G,D,V,b,c,d){"use strict";var e=a.getConfiguration().getRTL();var E=16;
function f(){return!D.browser.msie&&!(D.browser.edge&&D.browser.version<E);}
function g(i){var k=i.getLayoutData();return k?k.getColumns():1;}
function h(i){var k=i.getLayoutData();return k?k.getActualRows():1;}
function j(i){var k=i.getLayoutData();return k?k.hasAutoHeight():true;}
var l=C.extend("sap.f.GridContainer",{metadata:{library:"sap.f",interfaces:["sap.f.dnd.IGridDroppable"],properties:{width:{type:"sap.ui.core.CSSSize",group:"Appearance",defaultValue:""},containerQuery:{type:"boolean",group:"Behavior",defaultValue:false},snapToRow:{type:"boolean",group:"Appearance",defaultValue:false},allowDenseFill:{type:"boolean",group:"Appearance",defaultValue:false},inlineBlockLayout:{type:"boolean",group:"Appearance",defaultValue:false}},defaultAggregation:"items",aggregations:{items:{type:"sap.ui.core.Control",multiple:true,singularName:"item",dnd:true},layout:{type:"sap.f.GridContainerSettings",multiple:false},layoutXS:{type:"sap.f.GridContainerSettings",multiple:false},layoutS:{type:"sap.f.GridContainerSettings",multiple:false},layoutM:{type:"sap.f.GridContainerSettings",multiple:false},layoutL:{type:"sap.f.GridContainerSettings",multiple:false},layoutXL:{type:"sap.f.GridContainerSettings",multiple:false},_defaultLayout:{type:"sap.f.GridContainerSettings",multiple:false,visibility:"hidden"}},events:{layoutChange:{parameters:{layout:{type:"string"}}}},dnd:{draggable:false,droppable:true}}});
l.prototype.bUseExtendedChangeDetection=true;
l.prototype.getActiveLayoutSettings=function(){var s=this.getAggregation(this._sActiveLayout);if(!s&&this._sActiveLayout==="layoutXS"){s=this.getAggregation("layoutS");}if(!s){s=this.getAggregation("layout")||this.getAggregation("_defaultLayout");}return s;};
l.prototype._onBeforeItemRendering=function(){var o=this.getParent();if(o._reflectItemVisibilityToWrapper(this)&&!f()){o._scheduleIEPolyfill();}};
l.prototype._onAfterItemRendering=function(){var i=this.getParent();if(!i._resizeListeners[this.getId()]){i._resizeListeners[this.getId()]=R.register(this,i._resizeItemHandler);}i._setItemNavigationItems();if(!f()){i._scheduleIEPolyfill();return;}i._applyItemAutoRows(this);};
l.prototype._reflectItemVisibilityToWrapper=function(i){var o=i.getDomRef(),k=document.getElementById(d.createInvisiblePlaceholderId(i)),m,$;if(!o&&!k){return false;}m=(o?o:k).parentElement;$=jQuery(m);if(i.getVisible()&&$.hasClass("sapFGridContainerInvisiblePlaceholder")){$.removeClass("sapFGridContainerInvisiblePlaceholder");}else if(!i.getVisible()&&!$.hasClass("sapFGridContainerInvisiblePlaceholder")){$.addClass("sapFGridContainerInvisiblePlaceholder");return true;}return false;};
l.prototype._onItemChange=function(i){if(i.name!=="items"||!i.child){return;}if(i.mutation==="insert"){i.child.addEventDelegate(this._itemDelegate,i.child);}else if(i.mutation==="remove"){i.child.removeEventDelegate(this._itemDelegate,i.child);}};
l.prototype._deregisterResizeListeners=function(){var k,i;for(k in this._resizeListeners){i=this._resizeListeners[k];R.deregister(i);}delete this._resizeListeners;if(!this.getContainerQuery()){D.resize.detachHandler(this._resizeHandler);}};
l.prototype._setItemNavigationItems=function(){if(!this._isRenderingFinished){return;}};
l.prototype._detectActiveLayout=function(){var w=(this.getContainerQuery()&&this.getDomRef())?this._getComputedWidth():D.resize.width,r=D.media.getCurrentRange("GridContainerRangeSet",w),L="layout"+r.name,o=this.getActiveLayoutSettings(),s=false;if(!w){return false;}if(this._sActiveLayout!==L){this.addStyleClass("sapFGridContainer"+c(L));if(this._sActiveLayout){this.removeStyleClass("sapFGridContainer"+c(this._sActiveLayout));}this._sActiveLayout=L;s=o!==this.getActiveLayoutSettings();this.fireLayoutChange({layout:this._sActiveLayout});}return s;};
l.prototype._getActiveGridStyles=function(){var s=this.getActiveLayoutSettings(),i=s.getColumns()||"auto-fill",k=s.getColumnSize(),m=s.getMinColumnSize(),n=s.getMaxColumnSize(),S={"grid-gap":s.getGap()};if(m&&n){S["grid-template-columns"]="repeat("+i+", minmax("+m+", "+n+"))";}else{S["grid-template-columns"]="repeat("+i+", "+k+")";}if(this.getInlineBlockLayout()){S["grid-auto-rows"]="min-content";}else{S["grid-auto-rows"]=s.getRowSize();}return S;};
l.prototype.init=function(){this.setAggregation("_defaultLayout",new b());this._initRangeSet();this._resizeListeners={};this._itemDelegate={onBeforeRendering:this._onBeforeItemRendering,onAfterRendering:this._onAfterItemRendering};this._itemsObserver=new M(this._onItemChange.bind(this));this._itemsObserver.observe(this,{aggregations:["items"]});this._resizeHandler=this._resize.bind(this);if(!this.getContainerQuery()){D.resize.attachHandler(this._resizeHandler);}this._resizeItemHandler=this._resizeItem.bind(this);this._itemNavigation=new I().setCycling(false);this._itemNavigation.setDisabledModifiers({sapnext:["alt","meta"],sapprevious:["alt","meta"]});this.addDelegate(this._itemNavigation);if(!f()){this._attachDndPolyfill();}};
l.prototype.insertItem=function(i,k){if(!this.getDomRef()||!f()){return this.insertAggregation("items",i,k);}var r=a.createRenderManager(),w=this._createItemWrapper(i),t=this._getItemAt(k),o=this.getDomRef();if(t){o.insertBefore(w,t.getDomRef().parentElement);}else{o.appendChild(w);}this.insertAggregation("items",i,k,true);r.render(i,w);r.destroy();return this;};
l.prototype.removeItem=function(i){var r=this.removeAggregation("items",i,true),o=this.getDomRef(),k=r.getDomRef();if(!o||!k||!f()){this.invalidate();return r;}o.removeChild(k.parentElement);return r;};
l.prototype.onBeforeRendering=function(){this._detectActiveLayout();var r=this._resizeListeners[this.getId()];if(r){R.deregister(r);}this._isRenderingFinished=false;};
l.prototype.onAfterRendering=function(){this._resizeListeners[this.getId()]=R.register(this.getDomRef(),this._resizeHandler);this._isRenderingFinished=true;this._setItemNavigationItems();this._applyLayout(true);};
l.prototype.exit=function(){this._deregisterResizeListeners();if(this._itemsObserver){this._itemsObserver.disconnect();delete this._itemsObserver;}if(this._itemNavigation){this.removeDelegate(this._itemNavigation);this._itemNavigation.destroy();delete this._itemNavigation;}if(!f()){this._detachDndPolyfill();}};
l.prototype._initRangeSet=function(){if(!D.media.hasRangeSet("GridContainerRangeSet")){D.media.initRangeSet("GridContainerRangeSet",[375,600,1024,1440],"px",["XS","S","M","L","XL"]);}};
l.prototype._resize=function(){if(!this._isWidthChanged()){return;}var s=this._detectActiveLayout();this._applyLayout(s);};
l.prototype._isWidthChanged=function(){var i=this._getComputedWidth(),v=D.resize.width;if(this._lastGridWidth===i&&this._lastViewportWidth===v){return false;}this._lastGridWidth=i;this._lastViewportWidth=v;return true;};
l.prototype._getComputedWidth=function(){if(!this.getDomRef()){return null;}return this.getDomRef().getBoundingClientRect().width;};
l.prototype._resizeItem=function(o){if(!f()){this._scheduleIEPolyfill();return;}this._applyItemAutoRows(o.control);};
l.prototype._applyLayout=function(s){if(!this._isRenderingFinished){return;}if(!f()){this._scheduleIEPolyfill(s);return;}if(s){this.$().css(this._getActiveGridStyles());this.getItems().forEach(this._applyItemAutoRows.bind(this));}this._enforceMaxColumns();};
l.prototype._applyItemAutoRows=function(i){if(!this._isRenderingFinished){return;}if(this.getInlineBlockLayout()){return;}if(j(i)){var $=i.$(),s=this.getActiveLayoutSettings(),r=s.calculateRowsForItem($.outerHeight());if(!r){return;}$.parent().css({'grid-row':'span '+Math.max(r,h(i))});}};
l.prototype._enforceMaxColumns=function(){var s=this.getActiveLayoutSettings(),m=s.getComputedColumnsCount(this.$().innerWidth());if(!m){return;}this.getItems().forEach(function(i){i.$().parent().css("grid-column","span "+Math.min(g(i),m));});};
l.prototype._getItemAt=function(i){var k=this.getItems(),t;if(i<0){i=0;}if(k.length&&k[i]){t=k[i];}return t;};
l.prototype._createItemWrapper=function(i){var s=G.getStylesForItemWrapper(i,this),S=s.styles,k=s.classes,w=document.createElement("div");S.forEach(function(v,K){w.style.setProperty(K,v);});k.forEach(function(v){w.classList.add(v);});return w;};
l.prototype._scheduleIEPolyfill=function(i){if(this._iPolyfillCallId){clearTimeout(this._iPolyfillCallId);}if(i){this._applyIEPolyfillLayout();return;}this._iPolyfillCallId=setTimeout(this._applyIEPolyfillLayout.bind(this),0);};
l.prototype._applyIEPolyfillLayout=function(){if(!this._isRenderingFinished){return;}var $=this.$(),m=$.innerWidth(),s=this.getActiveLayoutSettings(),n=s.getMinColumnSizeInPx()||s.getColumnSizeInPx(),r=s.getRowSizeInPx(),o=s.getGapInPx(),p=s.getComputedColumnsCount(m),t=parseInt($.css("padding-top").replace("px","")),q=parseInt($.css("padding-left").replace("px","")),u=this.getItems();if(!n||!r){return;}if(!u.length){return;}var v=new V();v.init({numberOfCols:Math.max(1,p),cellWidth:n,cellHeight:r,unitOfMeasure:"px",gapSize:o,topOffset:t?t:0,leftOffset:q?q:0,allowDenseFill:this.getAllowDenseFill(),rtl:e,width:m});var i,k,w,x,y,z,F=[];var A=function(K){v.fitElement(K+'',this._polyfillDropIndicator.columns||s.calculateColumnsForItem(Math.round(this._polyfillDropIndicator.width)),this._polyfillDropIndicator.rows||s.calculateRowsForItem(Math.round(this._polyfillDropIndicator.height)));F.push({id:K+'',domRef:this._polyfillDropIndicator.domRef});}.bind(this);for(i=0,k=0;i<u.length;i++){if(this._polyfillDropIndicator&&this._polyfillDropIndicator.insertAt===i){A(k);k++;}w=u[i];x=w.$();if(!x.is(":visible")){continue;}y=g(w);if(j(w)){z=this._calcAutoRowsForPolyfill(w,s);}else{z=h(w);}v.fitElement(k+'',y,z);F.push({id:k+'',domRef:x.parent()});k++;}if(this._polyfillDropIndicator&&this._polyfillDropIndicator.insertAt>=u.length){A(u.length);}v.calculatePositions();F.forEach(function(B){var H=v.getItems()[B.id];B.domRef.css({position:'absolute',top:H.top,left:H.left,width:H.width,height:H.height});});$.css("height",v.getHeight()+"px");if(!this.getWidth()&&s.getColumns()){$.css("width",v.getWidth()+"px");}};
l.prototype._calcAutoRowsForPolyfill=function(i,o){var $=i.$(),k,r;if($.hasClass("sapFCardAnalytical")){k=$[0].scrollHeight;}else{k=$.outerHeight();}r=Math.max(o.calculateRowsForItem(k),h(i));return r;};
l.prototype._polyfillAfterDragOver=function(o){var $=o.getParameter("indicator");this._polyfillDropIndicator={rows:o.getParameter("rows"),columns:o.getParameter("columns"),width:o.getParameter("width"),height:o.getParameter("height"),domRef:$,insertAt:$.index()};this._scheduleIEPolyfill();};
l.prototype._polyfillAfterDragEnd=function(o){this._polyfillDropIndicator=null;};
l.prototype._attachDndPolyfill=function(){this.attachEvent("_gridPolyfillAfterDragOver",this._polyfillAfterDragOver,this);this.attachEvent("_gridPolyfillAfterDragEnd",this._polyfillAfterDragEnd,this);};
l.prototype._detachDndPolyfill=function(){this.detachEvent("_gridPolyfillAfterDragOver",this._polyfillAfterDragOver,this);this.detachEvent("_gridPolyfillAfterDragEnd",this._polyfillAfterDragEnd,this);};
return l;});
sap.ui.predefine('sap/f/GridContainerItemLayoutData',['sap/ui/core/LayoutData'],function(L){"use strict";
var G=L.extend("sap.f.GridContainerItemLayoutData",{metadata:{library:"sap.f",properties:{columns:{type:"int",group:"Misc",defaultValue:1},minRows:{type:"int",group:"Misc"},rows:{type:"int",group:"Misc"}}}});
G.prototype.hasAutoHeight=function(){return!this.getRows();};
G.prototype.getActualRows=function(){return Math.max(this.getRows()||1,this.getMinRows()||1);};
return G;});
sap.ui.predefine('sap/f/GridContainerRenderer',[],function(){"use strict";var G={};
G.render=function(r,c){r.write('<div');r.writeControlData(c);r.addClass("sapFGridContainer");if(c.getSnapToRow()){r.addClass("sapFGridContainerSnapToRow");}if(c.getAllowDenseFill()){r.addClass("sapFGridContainerDenseFill");}r.writeClasses();if(c.getWidth()){r.addStyle("width",c.getWidth());}this.addGridStyles(r,c);r.writeStyles();var t=c.getTooltip_AsString();if(t){r.writeAttributeEscaped("title",t);}r.write(">");c.getItems().forEach(function(i){this.renderItem(r,i,c);}.bind(this));r.write("</div>");};
G.addGridStyles=function(r,c){var s=c._getActiveGridStyles();for(var n in s){r.addStyle(n,s[n]);}};
G.renderItem=function(r,i,c){var s=G.getStylesForItemWrapper(i,c),S=s.styles,C=s.classes;r.write("<div");S.forEach(function(v,k){r.addStyle(k,v);});C.forEach(function(v){r.addClass(v);});r.writeClasses();r.writeStyles();r.write(">");r.renderControl(i);r.write("</div>");};
G.getStylesForItemWrapper=function(i,c){var s=new Map(),C=["sapFGridContainerItemWrapper"];var l=i.getLayoutData();if(l){var I=l.getColumns(),t=c.getActiveLayoutSettings().getColumns();if(I&&t){I=Math.min(I,t);}if(I){s.set("grid-column","span "+I);}if(c.getInlineBlockLayout()){s.set("grid-row","span 1");}else if(l.getRows()||l.getMinRows()){s.set("grid-row","span "+l.getActualRows());}if(!l.hasAutoHeight()){C.push("sapFGridContainerItemFixedRows");}}if(!i.getVisible()){C.push("sapFGridContainerInvisiblePlaceholder");}return{styles:s,classes:C};};
return G;},true);
sap.ui.predefine('sap/f/GridContainerSettings',["sap/ui/base/ManagedObject","sap/ui/dom/units/Rem","sap/base/Log"],function(M,R,L){"use strict";
function c(C){if(C===null||C===undefined){return C;}if(C===0||C==="0"){return 0;}var m=C.match(/^(\d+(\.\d+)?)(px|rem)$/),v;if(m){if(m[3]==="px"){v=parseFloat(m[1]);}else{v=R.toPx(parseFloat(m[1]));}}else{L.error("Css size '"+C+"' is not supported for some features in GridContainer. Only 'px' and 'rem' are supported.");v=NaN;}return Math.ceil(v);}
var G=M.extend("sap.f.GridContainerSettings",{metadata:{library:"sap.f",properties:{columns:{type:"int"},columnSize:{type:"sap.ui.core.CSSSize",defaultValue:"80px"},minColumnSize:{type:"sap.ui.core.CSSSize"},maxColumnSize:{type:"sap.ui.core.CSSSize"},rowSize:{type:"sap.ui.core.CSSSize",defaultValue:"80px"},gap:{type:"sap.ui.core.CSSSize",defaultValue:"16px"}}}});
G.prototype.getColumnSizeInPx=function(){return c(this.getColumnSize());};
G.prototype.getMinColumnSizeInPx=function(){return c(this.getMinColumnSize());};
G.prototype.getRowSizeInPx=function(){return c(this.getRowSize());};
G.prototype.getGapInPx=function(){return c(this.getGap());};
G.prototype.getComputedColumnsCount=function(g){if(this.getColumns()){return this.getColumns();}var i=this.getGapInPx(),C=this.getColumnSizeInPx();return Math.floor((g+i)/(C+i));};
G.prototype.calculateRowsForItem=function(i){var g=this.getGapInPx(),r=this.getRowSizeInPx();return Math.ceil((i+g)/(r+g));};
G.prototype.calculateColumnsForItem=function(i){var g=this.getGapInPx(),C=this.getColumnSizeInPx();return Math.ceil((i+g)/(C+g));};
return G;});
sap.ui.predefine('sap/f/GridList',["sap/m/ListBase","sap/ui/base/ManagedObjectObserver","sap/ui/layout/cssgrid/GridLayoutDelegate","sap/ui/layout/cssgrid/GridItemLayoutData","./GridListRenderer"],function(L,M,G,a,b){"use strict";
var c=L.extend("sap.f.GridList",{metadata:{library:"sap.f",interfaces:["sap.ui.layout.cssgrid.IGridConfigurable","sap.f.dnd.IGridDroppable"],aggregations:{customLayout:{type:"sap.ui.layout.cssgrid.GridLayoutBase",multiple:false}}}});
c.prototype.init=function(){L.prototype.init.apply(this,arguments);this._oItemDelegate={onAfterRendering:this._onAfterItemRendering};this._addGridLayoutDelegate();this._oGridObserver=new M(c.prototype._onGridChange.bind(this));this._oGridObserver.observe(this,{aggregations:["items"]});};
c.prototype.exit=function(){this._removeGridLayoutDelegate();if(this._oGridObserver){this._oGridObserver.disconnect();this._oGridObserver=null;}L.prototype.exit.apply(this,arguments);};
c.prototype.getGridDomRefs=function(){return[this.getItemsContainerDomRef()];};
c.prototype.getGridLayoutConfiguration=c.prototype.getCustomLayout;
c.prototype._addGridLayoutDelegate=function(){if(!this.oGridLayoutDelegate){this.oGridLayoutDelegate=new G();this.addEventDelegate(this.oGridLayoutDelegate,this);}};
c.prototype._removeGridLayoutDelegate=function(){if(this.oGridLayoutDelegate){this.removeEventDelegate(this.oGridLayoutDelegate);this.oGridLayoutDelegate.destroy();this.oGridLayoutDelegate=null;}};
c.prototype._onGridChange=function(C){if(C.name!=="items"||!C.child){return;}if(C.mutation==="insert"){C.child.addEventDelegate(this._oItemDelegate,C.child);}else if(C.mutation==="remove"){C.child.removeEventDelegate(this._oItemDelegate,C.child);}};
c.prototype._onAfterItemRendering=function(){a._setItemStyles(this);};
c.prototype.onLayoutDataChange=function(e){a._setItemStyles(e.srcControl);};
return c;});
sap.ui.predefine('sap/f/GridListItem',["sap/m/ListItemBase","./GridListItemRenderer"],function(L,G){"use strict";
var a=L.extend("sap.f.GridListItem",{metadata:{library:"sap.f",defaultAggregation:"content",aggregations:{content:{type:"sap.ui.core.Control",multiple:true,singularName:"content",bindable:"bindable"}}}});
a.prototype.getContentAnnouncement=function(){return this.getContent().map(function(c){return L.getAccessibilityText(c);}).join(" ").trim();};
return a;});
sap.ui.predefine('sap/f/GridListItemRenderer',["sap/m/ListItemBaseRenderer","sap/ui/core/Renderer","sap/m/library"],function(L,R,l){"use strict";var a=l.ListType;var b=l.ListMode;var M=-1;var G=R.extend(L);G.apiVersion=2;
G.renderLIAttributes=function(r,o){r.class("sapFGLI");};
G.renderContentFormer=function(r,o){this.renderHighlight(r,o);};
G.renderLIContentWrapper=function(r,o){r.openStart("div").class("sapFGLIWrapper").openEnd();this.renderToolbar(r,o);L.renderLIContentWrapper.apply(this,arguments);r.close("div");};
G.renderContentLatter=function(r,o){};
G.renderToolbar=function(r,o){var m=o.getMode(),i=m===b.Delete,t=o.getType();if(!o.getCounter()&&(m===""||m===b.None||m===b.SingleSelectMaster)&&(t===a.Inactive||t===a.Active)){return;}r.openStart("div",o.getId()+"-gridListItemToolbar");r.class("sapFGLIToolbar");r.openEnd();if(!i){this.renderMode(r,o,M);}this.renderToolbarSpacer(r);L.renderContentLatter.apply(this,arguments);r.close("div");};
G.renderLIContent=function(r,o){o.getContent().forEach(r.renderControl,r);};
G.renderToolbarSpacer=function(r){r.openStart("div").class("sapFGLIToolbarSpacer").openEnd().close("div");};
return G;});
sap.ui.predefine('sap/f/GridListRenderer',["sap/ui/core/Renderer","sap/m/ListBaseRenderer","sap/ui/layout/cssgrid/GridLayoutBase"],function(R,L,G){"use strict";var a=R.extend(L);
a.renderContainerAttributes=function(r,c){r.addClass("sapFGridList");L.renderContainerAttributes.apply(this,arguments);};
a.renderListStartAttributes=function(r,c){L.renderListStartAttributes.apply(this,arguments);this.renderGrid(r,c);};
a.renderGrid=function(r,c){var g=c.getGridLayoutConfiguration();if(g){g.renderSingleGridLayout(r);}else{r.addClass("sapFGridListDefault");}if(c.isGrouped()){r.addClass("sapFGridListGroup");}};
return a;});
sap.ui.predefine('sap/f/SearchManager',['sap/ui/core/Element','sap/ui/base/ManagedObjectObserver','./shellBar/Search'],function(E,M,S){"use strict";var r=sap.ui.getCore().getLibraryResourceBundle("sap.m");
var a=E.extend("sap.f.SearchManager",{metadata:{library:"sap.f",properties:{value:{type:"string",group:"Data",defaultValue:null,bindable:"bindable"},placeholder:{type:"string",group:"Misc",defaultValue:null},maxLength:{type:"int",group:"Behavior",defaultValue:0},enabled:{type:"boolean",group:"Behavior",defaultValue:true},enableSuggestions:{type:"boolean",group:"Behavior",defaultValue:false}},aggregations:{suggestionItems:{type:"sap.m.SuggestionItem",multiple:true,forwarding:{getter:"_getSearchField",aggregation:"suggestionItems"},singularName:"suggestionItem"}},events:{search:{parameters:{query:{type:"string"},clearButtonPressed:{type:"boolean"}}},liveChange:{parameters:{newValue:{type:"string"}}},suggest:{parameters:{suggestValue:{type:"string"}}}}}});
a.prototype.init=function(){this.setProperty("placeholder",r.getText("FACETFILTER_SEARCH"),true);this._oConfigObserver=new M(this._synchronizePropertiesWithConfig.bind(this));this._oConfigObserver.observe(this,{properties:Object.keys(this.getMetadata().getProperties())});this._initShellBarManagedSearch();};
a.prototype._synchronizePropertiesWithConfig=function(){var s=this._oSearch._getSearchField(),o=s.getMetadata(),c=this.getMetadata(),k,n;Object.keys(c.getAllProperties()).forEach(function(p){k=o.hasProperty(p);if(k){n=c.getProperty(p).get(this);o.getProperty(p).set(s,n);}},this);};
a.prototype._initShellBarManagedSearch=function(){if(!this._oSearch){this._oSearch=new S({search:this._onSearch.bind(this),liveChange:this._onLiveChange.bind(this),suggest:this._onSuggest.bind(this)});}};
a.prototype.exit=function(){if(this._oConfigObserver){this._oConfigObserver.disconnect();this._oConfigObserver=null;}if(this._oSearch){this._oSearch.destroy();}};
a.prototype._onLiveChange=function(e){var n=e.getParameters(),b=e.getParameter("newValue");n.id=this.getId();this.setProperty("value",b,true);this.fireLiveChange(n);};
a.prototype._onSearch=function(e){var n=e.getParameters();n.id=this.getId();this.fireSearch(n);};
a.prototype._onSuggest=function(e){var n=e.getParameters();n.id=this.getId();this.fireSuggest(n);};
a.prototype.suggest=function(s){this._getSearchField().suggest(s);};
a.prototype._getSearchField=function(){return this._oSearch._getSearchField();};
return a;});
sap.ui.predefine('sap/f/ShellBar',["sap/ui/core/Control","./shellBar/Factory","./shellBar/AdditionalContentSupport","./shellBar/ResponsiveHandler","./shellBar/Accessibility","sap/m/BarInPageEnabler","./ShellBarRenderer"],function(C,F,A,R,a,B){"use strict";
var S=C.extend("sap.f.ShellBar",{metadata:{library:"sap.f",interfaces:["sap.f.IShellBar","sap.m.IBar","sap.tnt.IToolHeader"],properties:{title:{type:"string",group:"Appearance",defaultValue:""},secondTitle:{type:"string",group:"Appearance",defaultValue:""},homeIcon:{type:"sap.ui.core.URI",group:"Appearance",defaultValue:""},homeIconTooltip:{type:"string",group:"Appearance",defaultValue:""},showMenuButton:{type:"boolean",group:"Appearance",defaultValue:false},showNavButton:{type:"boolean",group:"Appearance",defaultValue:false},showCopilot:{type:"boolean",group:"Appearance",defaultValue:false},showSearch:{type:"boolean",group:"Appearance",defaultValue:false},showNotifications:{type:"boolean",group:"Appearance",defaultValue:false},showProductSwitcher:{type:"boolean",group:"Appearance",defaultValue:false},notificationsNumber:{type:"string",group:"Appearance",defaultValue:""}},aggregations:{menu:{type:"sap.m.Menu",multiple:false,forwarding:{getter:"_getMenu",aggregation:"menu"}},searchManager:{type:"sap.f.SearchManager",multiple:false},profile:{type:"sap.f.Avatar",multiple:false,forwarding:{getter:"_getProfile",aggregation:"avatar"}},additionalContent:{type:"sap.f.IShellBar",multiple:true,singularName:"additionalContent"},_overflowToolbar:{type:"sap.m.OverflowToolbar",multiple:false,visibility:"hidden"}},events:{homeIconPressed:{parameters:{icon:{type:"sap.m.Image"}}},menuButtonPressed:{parameters:{button:{type:"sap.m.Button"}}},navButtonPressed:{parameters:{button:{type:"sap.m.Button"}}},copilotPressed:{parameters:{image:{type:"sap.m.Image"}}},searchButtonPressed:{parameters:{button:{type:"sap.m.Button"}}},notificationsPressed:{parameters:{button:{type:"sap.m.Button"}}},productSwitcherPressed:{parameters:{button:{type:"sap.m.Button"}}},avatarPressed:{parameters:{avatar:{type:"sap.f.Avatar"}}}}}});
A.apply(S.prototype);
S.prototype.init=function(){this._oFactory=new F(this);this._bOTBUpdateNeeded=true;this._oOverflowToolbar=this._oFactory.getOverflowToolbar();this.setAggregation("_overflowToolbar",this._oOverflowToolbar);this._oToolbarSpacer=this._oFactory.getToolbarSpacer();this._oControlSpacer=this._oFactory.getControlSpacer();this._oResponsiveHandler=new R(this);this._aOverflowControls=[];this._oAcc=new a(this);};
S.prototype.onBeforeRendering=function(){var n=this.getNotificationsNumber();this._assignControlsToOverflowToolbar();if(this.getShowNotifications()&&n!==undefined){this._updateNotificationsIndicators(n);}};
S.prototype.exit=function(){this._oResponsiveHandler.exit();this._oFactory.destroy();this._oAcc.exit();};
S.prototype.setHomeIcon=function(s){if(s){if(!this._oHomeIcon){this._oHomeIcon=this._oFactory.getHomeIcon();}this._oHomeIcon.setSrc(s);}else{this._oHomeIcon=null;}this._bOTBUpdateNeeded=true;return this.setProperty("homeIcon",s);};
S.prototype.setHomeIconTooltip=function(t){var d=this._oAcc.getEntityTooltip("LOGO");if(!this._oHomeIcon){this._oHomeIcon=this._oFactory.getHomeIcon();}if(t){this._oHomeIcon.setTooltip(t);}else{this._oHomeIcon.setTooltip(d);}this._bOTBUpdateNeeded=false;return this.setProperty("homeIconTooltip",t,true);};
S.prototype.setTitle=function(t){this._sTitle=t;if(!t){this._oPrimaryTitle=null;this._oMegaMenu=null;}else{if(!this._oMegaMenu){this._oMegaMenu=this._oFactory.getMegaMenu();}this._oMegaMenu.setText(t);if(!this._oPrimaryTitle){this._oPrimaryTitle=this._oFactory.getPrimaryTitle();}this._oPrimaryTitle.setText(t);}this._bOTBUpdateNeeded=true;return this.setProperty("title",t);};
S.prototype.setSecondTitle=function(t){if(t){if(!this._oSecondTitle){this._oSecondTitle=this._oFactory.getSecondTitle();}this._oSecondTitle.setText(t);}else{this._oSecondTitle=null;}this._bOTBUpdateNeeded=true;return this.setProperty("secondTitle",t);};
S.prototype.setShowCopilot=function(s){if(s){if(!this._oCopilot){this._oCopilot=this._oFactory.getCopilot();}}else{this._oCopilot=null;}this._bOTBUpdateNeeded=true;return this.setProperty("showCopilot",s);};
S.prototype.setShowSearch=function(s){if(s){if(!this._oSearch){this._oSearch=this._oFactory.getSearch();}}else{this._oSearch=null;}this._bOTBUpdateNeeded=true;return this.setProperty("showSearch",s);};
S.prototype.setSearchManager=function(c){this.setAggregation("searchManager",c);if(c){if(!this._oManagedSearch){this._oManagedSearch=this._oFactory.getManagedSearch();}}else{this._oManagedSearch=null;}this._bOTBUpdateNeeded=true;return this;};
S.prototype.setShowNotifications=function(s){if(s){if(!this._oNotifications){this._oNotifications=this._oFactory.getNotifications();}}else{this._oNotifications=null;}this._bOTBUpdateNeeded=true;return this.setProperty("showNotifications",s);};
S.prototype.setShowProductSwitcher=function(s){if(s){if(!this._oProductSwitcher){this._oProductSwitcher=this._oFactory.getProductSwitcher();}}else{this._oProductSwitcher=null;}this._bOTBUpdateNeeded=true;return this.setProperty("showProductSwitcher",s);};
S.prototype.setShowNavButton=function(s){if(s){if(!this._oNavButton){this._oNavButton=this._oFactory.getNavButton();}}else{this._oNavButton=null;}this._bOTBUpdateNeeded=true;return this.setProperty("showNavButton",s);};
S.prototype.setShowMenuButton=function(s){if(s){if(!this._oMenuButton){this._oMenuButton=this._oFactory.getMenuButton();}}else{this._oMenuButton=null;}this._bOTBUpdateNeeded=true;return this.setProperty("showMenuButton",s);};
S.prototype.setNotificationsNumber=function(n){if(this.getShowNotifications()&&n!==undefined){this._updateNotificationsIndicators(n);this._oAcc.updateNotificationsNumber(n);}return this.setProperty("notificationsNumber",n,true);};
S.prototype._assignControlsToOverflowToolbar=function(){var b;if(!this._oOverflowToolbar){return;}if(!this._bOTBUpdateNeeded){return;}this._aOverflowControls=[];this._oOverflowToolbar.removeAllContent();if(this._oNavButton){this._oOverflowToolbar.addContent(this._oNavButton);}if(this._oMenuButton){this._oOverflowToolbar.addContent(this._oMenuButton);}if(this._oHomeIcon){this._oOverflowToolbar.addContent(this._oHomeIcon);}this._oTitleControl=null;if(this.getShowMenuButton()&&this._oPrimaryTitle){this._oOverflowToolbar.addContent(this._oPrimaryTitle);this._oTitleControl=this._oPrimaryTitle;}else if(this._oMegaMenu){this._oOverflowToolbar.addContent(this._oMegaMenu);this._oTitleControl=this._oMegaMenu;}if(this._oSecondTitle){this._oOverflowToolbar.addContent(this._oSecondTitle);}if(this._oControlSpacer){this._oOverflowToolbar.addContent(this._oControlSpacer);}if(this._oCopilot){this._oOverflowToolbar.addContent(this._oCopilot);}this._oOverflowToolbar.addContent(this._oToolbarSpacer);if(this._oManagedSearch){this._oOverflowToolbar.addContent(this._oManagedSearch);this._aOverflowControls.push(this._oManagedSearch);}if(this._oSearch){this._oOverflowToolbar.addContent(this._oSearch);this._aOverflowControls.push(this._oSearch);}if(this._oNotifications){this._oOverflowToolbar.addContent(this._oNotifications);this._aOverflowControls.push(this._oNotifications);}b=this.getAdditionalContent();if(b){b.forEach(function(c){this._oOverflowToolbar.addContent(c);this._aOverflowControls.push(c);}.bind(this));}if(this._oAvatarButton){this._oOverflowToolbar.addContent(this._oAvatarButton);}if(this._oProductSwitcher){this._oOverflowToolbar.addContent(this._oProductSwitcher);this._aOverflowControls.push(this._oProductSwitcher);}this._bOTBUpdateNeeded=false;};
S.prototype._updateNotificationsIndicators=function(n){this._oOverflowToolbar._getOverflowButton().data("notifications",n,true);this._oNotifications.data("notifications",n,true);};
S.prototype._getProfile=function(){this._oAvatarButton=this._oFactory.getAvatarButton();return this._oAvatarButton;};
S.prototype._getMenu=function(){if(!this._oMegaMenu){this._oMegaMenu=this._oFactory.getMegaMenu();}return this._oMegaMenu;};
S.prototype._getOverflowToolbar=function(){return this._oOverflowToolbar;};
S.prototype.getContext=B.prototype.getContext;S.prototype.isContextSensitive=B.prototype.isContextSensitive;S.prototype.setHTMLTag=B.prototype.setHTMLTag;S.prototype.getHTMLTag=B.prototype.getHTMLTag;S.prototype.applyTagAndContextClassFor=B.prototype.applyTagAndContextClassFor;S.prototype._applyContextClassFor=B.prototype._applyContextClassFor;S.prototype._applyTag=B.prototype._applyTag;S.prototype._getContextOptions=B.prototype._getContextOptions;S.prototype._setRootAccessibilityRole=B.prototype._setRootAccessibilityRole;S.prototype._getRootAccessibilityRole=B.prototype._getRootAccessibilityRole;S.prototype._setRootAriaLevel=B.prototype._setRootAriaLevel;S.prototype._getRootAriaLevel=B.prototype._getRootAriaLevel;return S;},true);
sap.ui.predefine('sap/f/ShellBarRenderer',[],function(){"use strict";return{apiVersion:2,render:function(r,c){var a=c._oAcc,R=a.getRootAttributes(),t=c.getTitle(),b=t&&!c.getShowMenuButton();r.openStart("div",c);r.class("sapFShellBar");if(c.getShowNotifications()){r.class("sapFShellBarNotifications");}r.accessibilityState({role:R.role,label:R.label});r.openEnd();if(b){r.openStart("div",c.getId()+"-titleHidden").class("sapFShellBarTitleHidden").attr("role","heading").attr("aria-level","1").openEnd();r.text(t).close("div");}r.renderControl(c._getOverflowToolbar());r.close("div");},shouldAddIBarContext:function(){return false;}};},true);
sap.ui.predefine('sap/f/cards/AnalyticalContent',["sap/f/library","sap/f/cards/BaseContent","sap/viz/ui5/controls/VizFrame","sap/viz/ui5/controls/common/feeds/FeedItem","sap/viz/ui5/data/FlattenedDataset","sap/base/Log","sap/ui/core/Core","jquery.sap.global"],function(l,B,V,F,a,L,C,q){"use strict";var b={"Top":"top","Bottom":"bottom","Left":"left","Right":"right"};var c={"TopLeft":"topLeft","Center":"center"};var T={"Left":"left","Center":"center","Right":"right"};var d={"Line":"line","StackedColumn":"stacked_column","StackedBar":"stacked_bar","Donut":"donut"};var A=l.cards.AreaType;
var e=B.extend("sap.f.cards.AnalyticalContent",{renderer:{}});
e.prototype._getVizPropertiesObject=function(o){var t=o.title,f=o.legend,p=o.plotArea;if(!o){return this;}var v={"title":{"style":{"fontWeight":"normal"},"layout":{"respectPlotPosition":false}},"legend":{},"legendGroup":{"layout":{}},"plotArea":{"window":{"start":"firstDataPoint","end":"lastDataPoint"}},"categoryAxis":{"title":{}},"valueAxis":{"title":{}},"interaction":{"noninteractiveMode":true}};if(t){v.title.text=t.text;v.title.visible=t.visible;v.title.alignment=T[t.alignment];}if(f){v.legend.visible=f.visible;v.legendGroup.layout.position=b[f.position];v.legendGroup.layout.alignment=c[f.alignment];}if(p){if(p.dataLabel){v.plotArea.dataLabel=p.dataLabel;}if(p.categoryAxisText){v.categoryAxis.title.visible=p.categoryAxisText.visible;}if(p.valueAxisText){v.valueAxis.title.visible=p.valueAxisText.visible;}}return v;};
e.prototype._updateModel=function(){this._createChart();B.prototype._updateModel.apply(this,arguments);};
e.prototype._createChart=function(){var o=this.getConfiguration();if(!o.chartType){L.error("ChartType is a mandatory property");return;}var D=[];if(o.dimensions){var f=[];for(var i=0;i<o.dimensions.length;i++){var g=o.dimensions[i];var n=g.value.substring(1,g.value.length-1);D.push(n);var h={name:n,value:g.value};f.push(h);}}var m=[];if(o.measures){var M=[];for(var i=0;i<o.measures.length;i++){var j=o.measures[i];var n=j.value.substring(1,j.value.length-1);m.push(n);var k={name:n,value:j.value};M.push(k);}}var p=new a({measures:M,dimensions:f,data:{path:this.getBindingContext().getPath()}});var r=new V({uiConfig:{applicationSet:'fiori'},height:"100%",width:"100%",vizType:d[o.chartType],dataset:p,legendVisible:o.legend,feeds:[new F({uid:o.measureAxis,type:'Measure',values:m}),new F({uid:o.dimensionAxis,type:'Dimension',values:D})]});var v=this._getVizPropertiesObject(o);r.setVizProperties(v);this._oActions.setAreaType(A.Content);this._oActions.attach(o,this);this.setAggregation("_content",r);};
e.prototype.onBeforeRendering=function(){if(this._handleHostConfiguration){this._handleHostConfiguration();}};
e.prototype._handleHostConfiguration=function(){var p=this.getParent(),o=this.getAggregation("_content");if(p&&p.getHostConfigurationId&&o){var h=C.byId(p.getHostConfigurationId());if(h){var s=h.generateJSONSettings("vizProperties"),v=o.getVizProperties();v=q.extend(true,v,s);o.setVizProperties(v);}}};
return e;});
sap.ui.predefine('sap/f/cards/BaseContent',["sap/ui/core/Control","sap/ui/model/json/JSONModel","sap/base/Log","sap/ui/base/ManagedObjectObserver","sap/ui/core/Core","sap/f/cards/CardActions"],function(C,J,L,M,a,b){"use strict";
var B=C.extend("sap.f.cards.BaseContent",{
metadata:{library:"sap.f",aggregations:{_content:{multiple:false,visibility:"hidden"}},events:{press:{}}},
renderer:function(r,c){var s="sapFCard";var l=c.getMetadata().getLibraryName();var n=c.getMetadata().getName();var t=n.slice(l.length+1,n.length);var h=B.getMinHeight(t,c.getConfiguration());var o=c.getParent();s+=t;r.write("<div");r.writeElementData(c);r.addClass(s);r.addClass("sapFCardBaseContent");r.writeClasses();if(o&&o.isA("sap.f.ICard")&&o.getHeight()==="auto"){r.addStyle("min-height",h);}r.writeStyles();r.write(">");r.renderControl(c.getAggregation("_content"));r.write("</div>");}
});
B.prototype.init=function(){this._aReadyPromises=[];this._bReady=false;this._mObservers={};this._awaitEvent("_dataReady");this._awaitEvent("_actionContentReady");Promise.all(this._aReadyPromises).then(function(){this._bReady=true;this.fireEvent("_ready");}.bind(this));this.setBusyIndicatorDelay(0);this._oActions=new b();};
B.prototype.ontap=function(e){if(!e.isMarked()){this.firePress({});}};
B.prototype.exit=function(){this._oServiceManager=null;this._oDataProviderFactory=null;if(this._oDataProvider){this._oDataProvider.destroy();this._oDataProvider=null;}if(this._oActions){this._oActions.destroy();this._oActions=null;}};
B.prototype._awaitEvent=function(e){this._aReadyPromises.push(new Promise(function(r){this.attachEventOnce(e,function(){r();});}.bind(this)));};
B.prototype.destroy=function(){this.setAggregation("_content",null);this.setModel(null);this._aReadyPromises=null;if(this._mObservers){Object.keys(this._mObservers).forEach(function(k){this._mObservers[k].disconnect();delete this._mObservers[k];},this);}return C.prototype.destroy.apply(this,arguments);};
B.prototype.setConfiguration=function(c){this._oConfiguration=c;if(!c){return this;}var l=this.getInnerList(),m=c.maxItems;if(l&&m){l.setGrowing(true);l.setGrowingThreshold(parseInt(m));l.addStyleClass("sapFCardMaxItems");}this._setData(c.data);return this;};
B.prototype.getConfiguration=function(){return this._oConfiguration;};
B.prototype.getInnerList=function(){return null;};
B.prototype._setData=function(d){var p="/";if(d&&d.path){p=d.path;}this.bindObject(p);if(this._oDataProvider){this._oDataProvider.destroy();}if(this._oDataProviderFactory){this._oDataProvider=this._oDataProviderFactory.create(d,this._oServiceManager);}if(this._oDataProvider){this.setBusy(true);this.setModel(new J());this._oDataProvider.attachDataChanged(function(e){this._updateModel(e.getParameter("data"));this.setBusy(false);}.bind(this));this._oDataProvider.attachError(function(e){this._handleError(e.getParameter("message"));this.setBusy(false);}.bind(this));this._oDataProvider.triggerDataUpdate().then(function(){this.fireEvent("_dataReady");}.bind(this));}else{this.fireEvent("_dataReady");}};
function _(A,c,o){var d=this.getBindingContext(),e=c.getAggregation(A);if(d){o.path=d.getPath();c.bindAggregation(A,o);if(this.getModel("parameters")&&e){this.getModel("parameters").setProperty("/visibleItems",e.length);}if(!this._mObservers[A]){this._mObservers[A]=new M(function(f){if(f.name===A&&(f.mutation==="insert"||f.mutation==="remove")){var e=c.getAggregation(A);var l=e?e.length:0;if(this.getModel("parameters")){this.getModel("parameters").setProperty("/visibleItems",l);}}}.bind(this));this._mObservers[A].observe(c,{aggregations:[A]});}}}
B.prototype._bindAggregation=function(A,c,o){var d=A&&typeof A==="string";var e=o&&typeof o==="object";if(!d||!c||!e){return;}if(this.getBindingContext()){_.apply(this,arguments);}else{c.attachModelContextChange(_.bind(this,A,c,o));}};
B.prototype.isReady=function(){return this._bReady;};
B.prototype._updateModel=function(d){this.getModel().setData(d);};
B.prototype._handleError=function(l){this.fireEvent("_error",{logMessage:l});};
B.prototype.setServiceManager=function(s){this._oServiceManager=s;return this;};
B.prototype.setDataProviderFactory=function(d){this._oDataProviderFactory=d;return this;};
B.create=function(t,c,s,d,A){return new Promise(function(r,e){var f=function(g){var o=new g();o._sAppId=A;o.setServiceManager(s);o.setDataProviderFactory(d);o.setConfiguration(c);r(o);};try{switch(t.toLowerCase()){case"list":sap.ui.require(["sap/f/cards/ListContent"],f);break;case"table":sap.ui.require(["sap/f/cards/TableContent"],f);break;case"object":sap.ui.require(["sap/f/cards/ObjectContent"],f);break;case"analytical":a.loadLibrary("sap.viz",{async:true}).then(function(){sap.ui.require(["sap/f/cards/AnalyticalContent"],f);}).catch(function(){e("Analytical content type is not available with this distribution.");});break;case"timeline":a.loadLibrary("sap.suite.ui.commons",{async:true}).then(function(){sap.ui.require(["sap/f/cards/TimelineContent"],f);}).catch(function(){e("Timeline content type is not available with this distribution.");});break;case"component":sap.ui.require(["sap/f/cards/ComponentContent"],f);break;default:e(t.toUpperCase()+" content type is not supported.");}}catch(E){e(E);}});};
B.getMinHeight=function(t,c){var d=5,h;if(jQuery.isEmptyObject(c)){return"0rem";}switch(t){case"ListContent":h=B._getMinListHeight(c);break;case"TableContent":h=B._getMinTableHeight(c);break;case"TimelineContent":h=B._getMinTimelineHeight(c);break;case"AnalyticalContent":h=14;break;case"ObjectContent":h=0;break;default:h=0;}return(h!==0?h:d)+"rem";};
B._getMinListHeight=function(c){var i=c.maxItems||0,t=c.item,I=3;if(!t){return 0;}if(t.icon||t.description){I=4;}return i*I;};
B._getMinTableHeight=function(c){var i=c.maxItems||0,r=3,t=3;return i*r+t;};
B._getMinTimelineHeight=function(c){var i=c.maxItems||0,I=6;return i*I;};
return B;});
sap.ui.predefine('sap/f/cards/BindingHelper',["sap/ui/base/ManagedObject"],function(M){"use strict";var B={};
B.bindProperty=function(c,p,P,f){if(!P){return;}var b=M.bindingParser(P);if(b){if(!b.formatter&&f){b.formatter=f;}c.bindProperty(p,b);}else{var F=P;if(f){F=f.call(c,P);}c.setProperty(p,F);}};
return B;});
sap.ui.predefine('sap/f/cards/BindingResolver',["sap/ui/base/ManagedObject","sap/base/Log"],function(M,L){"use strict";
var S=M.extend("sap.f.cards.util.SimpleControl",{metadata:{properties:{resolved:{type:"any"}}}});
var s=new S();var B={};
function p(v,m,P,c,i){var R=c===i;if(R){L.warning("BindingResolver maximum level processing reached. Please check for circular dependencies.");}if(!v||R){return v;}if(Array.isArray(v)){v.forEach(function(I,b,A){if(typeof I==="object"){p(I,m,P,c+1,i);}else if(typeof I==="string"){A[b]=r(I,m,P);}},this);return v;}else if(typeof v==="object"){for(var a in v){if(typeof v[a]==="object"){p(v[a],m,P,c+1,i);}else if(typeof v[a]==="string"){v[a]=r(v[a],m,P);}}return v;}else if(typeof v==="string"){return r(v,m,P);}else{return v;}}
function r(b,m,P){if(!b){return b;}var o=M.bindingParser(b);if(!o){return b;}if(!P){P="/";}s.setModel(m);s.bindObject(P);s.bindProperty("resolved",o);var v=s.getResolved();s.unbindProperty("resolved");s.unbindObject();s.setModel(null);return v;}
B.resolveValue=function(v,m,P){var c,a,C=0,i=30;if(v&&typeof v==="object"){c=jQuery.extend(true,Array.isArray(v)?[]:{},v);}a=c||v;if(m){a=p(a,m,P,C,i);}return a;};
return B;});
sap.ui.predefine('sap/f/cards/CardActions',["sap/f/library","sap/ui/base/ManagedObject","sap/base/Log","sap/f/cards/BindingResolver"],function(l,M,L,B){"use strict";
function _(s){if(s&&typeof s==="object"){return s.name;}return s;}
var A=l.cards.AreaType;
var C=M.extend("sap.f.cards.CardActions",{metadata:{properties:{areaType:{type:"sap.f.cards.AreaType",defaultValue:A.None}}}});
C.prototype.exit=function(){this._oAreaControl=null;};
C.prototype.attach=function(i,a){this._oAreaControl=a;if(!i.actions){this._fireActionReady();return;}var o=i.actions[0];if(o&&o.type==="Navigation"){this._attachNavigationAction(i);}else{this._fireActionReady();}};
C.prototype._setItemTemplateTypeFormatter=function(a){var t=this,o=t._oAreaControl,i=o._oItemTemplate;var b=M.bindingParser("{path:''}");b.formatter=function(v){var c=this.getBindingContext(),m=this.getModel(),p,P;if(c){p=c.getPath();}P=B.resolveValue(a.parameters,m,p);if(v.__resolved){if(v.__enabled){return"Navigation";}else{return"Inactive";}}if(!v.__promise){v.__promise=true;o._oServiceManager.getService(_(a.service)).then(function(n){if(n){n.enabled({parameters:P}).then(function(e){v.__resolved=true;v.__enabled=e;o.getModel().checkUpdate(true);}).catch(function(){v.__resolved=true;v.__enabled=false;});}else{v.__resolved=true;v.__enabled=false;}});}return"Inactive";};i.bindProperty("type",b);};
C.prototype._setSingleActionEnabledState=function(i){var a=i.actions[0],o=this._oAreaControl,b=o.getBindingContext(),p=a.parameters,m=o.getModel(),P;if(b){P=b.getPath();}p=B.resolveValue(a.parameters,m,P);return new Promise(function(r){o._oServiceManager.getService(_(a.service)).then(function(n){if(n){n.enabled({parameters:p}).then(function(e){r(e);}).catch(function(){r(false);});}else{r(false);}}).catch(function(){r(false);});});};
C.prototype._setItemTemplateEnabledState=function(a){var b,t,i=this._oAreaControl._oItemTemplate;if(typeof a.enabled==="string"){b=M.bindingParser(a.enabled);b.formatter=function(v){if(v&&(typeof v==="string")){return"Navigation";}else{return"Inactive";}};}if(b){i.bindProperty("type",b);}else{t=a.enabled!==false?"Navigation":"Inactive";i.setProperty("type",t);}};
C.prototype._addClickableClass=function(){this._oAreaControl.addStyleClass("sapFCardClickable");};
C.prototype._fireActionReady=function(){var h=this.getAreaType()===A.Header;var e=h?"_actionHeaderReady":"_actionContentReady";this._oAreaControl.fireEvent(e);};
C.prototype._attachNavigationAction=function(i){var a=i.actions[0],o=this.getAreaType()===A.ContentItem?this._oAreaControl._oItemTemplate:this._oAreaControl,h,c=true,s=this.getAreaType(),S=s===A.Header||s===A.Content,b=s===A.ContentItem;var d=function(){o.attachPress(h.bind(this));if(S){this._addClickableClass();}}.bind(this);if(a.service){if(this.getAreaType()===A.ContentItem){this._setItemTemplateTypeFormatter(a);}h=function(E){var f=E.getSource(),g=f.getBindingContext(),m=f.getModel(),p;if(g){p=g.getPath();}this._oAreaControl._oServiceManager.getService(_(a.service)).then(function(n){if(n){n.navigate({parameters:B.resolveValue(a.parameters,m,p)});}}).catch(function(e){L.error("Navigation service unavailable",e);}).finally(function(){this._fireAction(E.getSource(),a.parameters,m,p);}.bind(this));}.bind(this);c=false;}else{if(b){this._setItemTemplateEnabledState(a);c=false;}if(a.url){h=function(e){var f=e.getSource(),g=f.getBindingContext(),m=f.getModel(),p,u;if(g){p=g.getPath();}u=B.resolveValue(a.url,m,p);this.openUrl(u,a);this._fireAction(e.getSource(),a.parameters,m,p);}.bind(this);}else{h=function(e){var f=e.getSource(),g=f.getBindingContext(),m=f.getModel(),p;if(g){p=g.getPath();}this._fireAction(e.getSource(),a.parameters,m,p);}.bind(this);}}if(S&&a.service){this._setSingleActionEnabledState(i).then(function(e){if(e){d();}this._fireActionReady();}.bind(this));}else{if(c){if(a.enabled!==false){d();}}else{d();}this._fireActionReady();}};
C.prototype.openUrl=function(u,a){window.open(u,a.target||"_blank");};
C.prototype._fireAction=function(s,a,m,p){this._oAreaControl.fireEvent("action",{type:"Navigation",actionSource:s,manifestParameters:B.resolveValue(a,m,p)});};
return C;});
sap.ui.predefine('sap/f/cards/ComponentContent',["sap/f/cards/BaseContent","sap/ui/core/ComponentContainer"],function(B,C){"use strict";
var a=B.extend("sap.f.cards.ComponentContent",{renderer:{}});
a.prototype.setConfiguration=function(c){B.prototype.setConfiguration.apply(this,arguments);if(!c){return;}var o=new C({manifest:c,async:true,componentCreated:function(){this.fireEvent("_actionContentReady");this.fireEvent("_updated");}.bind(this),componentFailed:function(){this.fireEvent("_actionContentReady");this._handleError("Card content failed to create component");}.bind(this)});this.setAggregation("_content",o);};
return a;});
sap.ui.predefine('sap/f/cards/DataProvider',["sap/ui/base/ManagedObject"],function(M){"use strict";
var D=M.extend("sap.f.cards.DataProvider",{metadata:{events:{dataChanged:{parameters:{data:{type:"object"}}},error:{parameters:{message:{type:"string"}}}}}});
D.prototype.setSettings=function(s){this._oSettings=s;};
D.prototype.getSettings=function(){return this._oSettings;};
D.prototype.triggerDataUpdate=function(){return this.getData().then(function(d){this.fireDataChanged({data:d});}.bind(this)).catch(function(e){this.fireError({message:e});}.bind(this));};
D.prototype.getData=function(){var d=this.getSettings();return new Promise(function(r,a){if(d.json){r(d.json);}else{a("Could not get card data.");}});};
D.prototype.setUpdateInterval=function(i){var v=parseInt(i);if(!v){return;}if(this._iIntervalId){clearInterval(this._iIntervalId);}this._iIntervalId=setInterval(function(){this.triggerDataUpdate();}.bind(this),v*1000);};
D.prototype.destroy=function(){if(this._iIntervalId){clearInterval(this._iIntervalId);this._iIntervalId=null;}this._oSettings=null;M.prototype.destroy.apply(this,arguments);};
return D;});
sap.ui.predefine('sap/f/cards/DataProviderFactory',["sap/ui/base/Object","sap/f/cards/ServiceDataProvider","sap/f/cards/RequestDataProvider","sap/f/cards/DataProvider"],function(B,S,R,D){"use strict";
var a=B.extend("sap.f.cards.DataProviderFactory",{constructor:function(){B.call(this);this._aDataProviders=[];}});
a.prototype.destroy=function(){B.prototype.destroy.apply(this,arguments);if(this._aDataProviders){this._aDataProviders.forEach(function(d){if(!d.bIsDestroyed){d.destroy();}});this._aDataProviders=null;}};
a.prototype.create=function(d,s){var o;if(!d){return null;}if(d.request){o=new R();}else if(d.service){o=new S();}else if(d.json){o=new D();}else{return null;}o.setSettings(d);if(o.isA("sap.f.cards.IServiceDataProvider")){o.createServiceInstances(s);}if(d.updateInterval){o.setUpdateInterval(d.updateInterval);}this._aDataProviders.push(o);return o;};
return a;});
sap.ui.predefine('sap/f/cards/Header',["sap/f/library","sap/ui/core/Control","sap/m/Text","sap/f/Avatar","sap/ui/Device",'sap/f/cards/DataProviderFactory','sap/ui/model/json/JSONModel',"sap/f/cards/HeaderRenderer","sap/f/cards/IconFormatter","sap/f/cards/CardActions","sap/base/strings/formatMessage"],function(l,C,T,A,D,a,J,H,I,b,f){"use strict";var c=l.AvatarShape;var d=l.cards.AreaType;
var e=C.extend("sap.f.cards.Header",{metadata:{library:"sap.f",interfaces:["sap.f.cards.IHeader"],properties:{title:{type:"string",defaultValue:""},subtitle:{type:"string",defaultValue:""},statusText:{type:"string",defaultValue:""},iconDisplayShape:{type:"sap.f.AvatarShape",defaultValue:c.Circle},iconSrc:{type:"sap.ui.core.URI",defaultValue:""},iconInitials:{type:"string",defaultValue:""}},aggregations:{_title:{type:"sap.m.Text",multiple:false,visibility:"hidden"},_subtitle:{type:"sap.m.Text",multiple:false,visibility:"hidden"},_avatar:{type:"sap.f.Avatar",multiple:false,visibility:"hidden"}},events:{press:{}}}});
e.prototype.init=function(){this._aReadyPromises=[];this._bReady=false;this._awaitEvent("_dataReady");this._awaitEvent("_actionHeaderReady");Promise.all(this._aReadyPromises).then(function(){this._bReady=true;this.fireEvent("_ready");}.bind(this));this.setBusyIndicatorDelay(0);};
e.prototype.exit=function(){this._oServiceManager=null;this._oDataProviderFactory=null;if(this._oDataProvider){this._oDataProvider.destroy();this._oDataProvider=null;}if(this._oActions){this._oActions.destroy();this._oActions=null;}};
e.prototype._awaitEvent=function(E){this._aReadyPromises.push(new Promise(function(r){this.attachEventOnce(E,function(){r();});}.bind(this)));};
e.prototype.isReady=function(){return this._bReady;};
e.prototype._getTitle=function(){var t=this.getAggregation("_title");if(!t){t=new T({maxLines:3}).addStyleClass("sapFCardTitle");this.setAggregation("_title",t);}return t;};
e.prototype._getSubtitle=function(){var s=this.getAggregation("_subtitle");if(!s){s=new T({maxLines:2}).addStyleClass("sapFCardSubtitle");this.setAggregation("_subtitle",s);}return s;};
e.prototype._getAvatar=function(){var o=this.getAggregation("_avatar");if(!o){o=new A().addStyleClass("sapFCardIcon");this.setAggregation("_avatar",o);}return o;};
e.prototype.onBeforeRendering=function(){this._getTitle().setText(this.getTitle());this._getSubtitle().setText(this.getSubtitle());this._getAvatar().setDisplayShape(this.getIconDisplayShape());if(this.isInsideIntegrationCard()&&this.getIconSrc()){var s=this.getBindingInfo("iconSrc");if(s){if(!s.formatter){s.formatter=function(v){return I.formatSrc(v,this._sAppId);}.bind(this);}this._getAvatar().bindProperty("src",s);}else{this._getAvatar().setSrc(I.formatSrc(this.getIconSrc(),this._sAppId));}}else{this._getAvatar().setSrc(this.getIconSrc());}this._getAvatar().setInitials(this.getIconInitials());};
e.prototype._getHeaderAccessibility=function(){var t=this._getTitle()?this._getTitle().getId():"",s=this._getSubtitle()?this._getSubtitle().getId():"",g=this._getAvatar()?this._getAvatar().getId():"";return t+" "+s+" "+g;};
e.prototype.onAfterRendering=function(){if(D.browser.msie){if(this.getTitle()){this._getTitle().clampText();}if(this.getSubtitle()){this._getSubtitle().clampText();}}};
e.prototype.ontap=function(){this.firePress();};
e.prototype.onsapselect=function(){this.firePress();};
e.prototype.isInsideIntegrationCard=function(){var p=this.getParent();if(p&&p.isA("sap.ui.integration.widgets.Card")){return true;}return false;};
e.create=function(m,s,o,g){var S={title:m.title,subtitle:m.subTitle};if(m.icon){S.iconSrc=m.icon.src;S.iconDisplayShape=m.icon.shape;S.iconInitials=m.icon.text;}if(m.status&&typeof m.status.text==="string"){S.statusText=m.status.text;}var h=new e(S);h._sAppId=g;if(m.status&&m.status.text&&m.status.text.format){e._bindStatusText(m.status.text.format,h);}h.setServiceManager(s);h.setDataProviderFactory(o);h._setData(m.data);var i=new b({areaType:d.Header});i.attach(m,h);h._oActions=i;return h;};
e._bindStatusText=function(F,h){if(F.parts&&F.translationKey&&F.parts.length===2){var B={parts:[F.translationKey,F.parts[0].toString(),F.parts[1].toString()],formatter:function(t,p,P){var s=p||F.parts[0];var g=P||F.parts[1];if(Array.isArray(p)){s=p.length;}if(Array.isArray(P)){g=P.length;}var i=parseFloat(s)||0;var j=parseFloat(g)||0;return f(t,[i,j]);}};h.bindProperty("statusText",B);}};
e.prototype.setServiceManager=function(s){this._oServiceManager=s;return this;};
e.prototype.setDataProviderFactory=function(o){this._oDataProviderFactory=o;return this;};
e.prototype._setData=function(o){var p="/";if(o&&o.path){p=o.path;}this.bindObject(p);if(this._oDataProvider){this._oDataProvider.destroy();}this._oDataProvider=this._oDataProviderFactory.create(o,this._oServiceManager);if(this._oDataProvider){this.setBusy(true);this.setModel(new J());this._oDataProvider.attachDataChanged(function(E){this._updateModel(E.getParameter("data"));this.setBusy(false);}.bind(this));this._oDataProvider.attachError(function(E){this._handleError(E.getParameter("message"));this.setBusy(false);}.bind(this));this._oDataProvider.triggerDataUpdate().then(function(){this.fireEvent("_dataReady");}.bind(this));}else{this.fireEvent("_dataReady");}};
e.prototype._updateModel=function(o){this.getModel().setData(o);};
e.prototype._handleError=function(L){this.fireEvent("_error",{logMessage:L});};
return e;});
sap.ui.predefine('sap/f/cards/HeaderRenderer',[],function(){"use strict";var H={},r=sap.ui.getCore().getLibraryResourceBundle("sap.f");
H.render=function(R,c){var s=c.getStatusText();R.write("<div");R.writeControlData(c);R.writeAttribute("tabindex","0");R.addClass("sapFCardHeader");R.writeAccessibilityState(c,{role:"group",labelledby:{value:c._getHeaderAccessibility(),append:true},roledescription:{value:r.getText("ARIA_ROLEDESCRIPTION_CARD_HEADER"),append:true}});R.writeClasses();R.write(">");if(c.getIconSrc()||c.getIconInitials()){R.renderControl(c._getAvatar());}if(c.getTitle()){R.write("<div");R.addClass("sapFCardHeaderText");R.writeClasses();R.write(">");R.write("<div");R.addClass("sapFCardHeaderTextFirstLine");R.writeClasses();R.write(">");R.write("<div");R.addClass("sapFCardHeaderTitle");R.writeClasses();R.write(">");R.renderControl(c._getTitle());R.write("</div>");if(s){R.write("<span");R.addClass("sapFCardStatus");R.writeClasses();R.write(">");R.writeEscaped(s);R.write("</span>");}R.write("</div>");if(c.getSubtitle()){R.renderControl(c._getSubtitle());}R.write("</div>");}R.write("</div>");};
return H;},true);
sap.ui.predefine('sap/f/cards/IconFormatter',["sap/ui/core/IconPool"],function(I){"use strict";var a={formatSrc:function(u,A){var i=0;if(!u||!A){return u;}if(I.isIconURI(u)||u.startsWith("http://")||u.startsWith("https://")){return u;}if(u.startsWith("..")){i=2;}else if(u.startsWith(".")){i=1;}return sap.ui.require.toUrl(A.replace(/\./g,"/")+u.slice(i,u.length));}};return a;});
sap.ui.predefine('sap/f/cards/ListContent',["sap/f/library","sap/f/cards/BaseContent","sap/m/List","sap/m/StandardListItem","sap/ui/base/ManagedObject","sap/f/cards/IconFormatter","sap/f/cards/BindingHelper"],function(l,B,s,S,M,I,a){"use strict";var A=l.cards.AreaType;
var L=B.extend("sap.f.cards.ListContent",{renderer:{}});
L.prototype._getList=function(){if(this._bIsBeingDestroyed){return null;}var o=this.getAggregation("_content");if(!o){o=new s({id:this.getId()+"-list",growing:false,showNoData:false,showSeparators:"None"});this.setAggregation("_content",o);}return o;};
L.prototype.init=function(){B.prototype.init.apply(this,arguments);var o=this._getList();var t=this;o.attachUpdateFinished(function(){if(t._iVisibleItems){var b=o.getItems();for(var i=t._iVisibleItems+1;i<b.length;i++){b[i].setVisible(false);}}});this._oItemTemplate=new S({iconDensityAware:false});};
L.prototype.exit=function(){B.prototype.exit.apply(this,arguments);if(this._oItemTemplate){this._oItemTemplate.destroy();this._oItemTemplate=null;}};
L.prototype.setConfiguration=function(c){B.prototype.setConfiguration.apply(this,arguments);if(!c){return this;}if(c.items){this._setStaticItems(c.items);return this;}if(c.item){this._setItem(c.item);}return this;};
L.prototype._setItem=function(i){i.title&&this._bindObjectItemProperty("title",i.title);i.description&&this._bindObjectItemProperty("description",i.description);i.icon&&i.icon.src&&a.bindProperty(this._oItemTemplate,"icon",i.icon.src,function(v){return I.formatSrc(v,this._sAppId);}.bind(this));i.highlight&&a.bindProperty(this._oItemTemplate,"highlight",i.highlight);i.info&&a.bindProperty(this._oItemTemplate,"info",i.info.value);i.info&&a.bindProperty(this._oItemTemplate,"infoState",i.info.state);this._oActions.setAreaType(A.ContentItem);this._oActions.attach(i,this);var b={template:this._oItemTemplate};this._bindAggregation("items",this._getList(),b);};
L.prototype._setStaticItems=function(i){var o=this._getList();i.forEach(function(b){var c=new S({iconDensityAware:false,title:b.title?b.title:"",description:b.description?b.description:"",icon:b.icon?b.icon:"",infoState:b.infoState?b.infoState:"None",info:b.info?b.info:"",highlight:b.highlight?b.highlight:"None"});if(b.action){c.setType("Navigation");if(b.action.url){c.attachPress(function(){window.open(b.action.url,b.target||"_blank");});}}o.addItem(c);});this.fireEvent("_actionContentReady");};
L.prototype._bindObjectItemProperty=function(p,P){if(typeof P==="string"){a.bindProperty(this._oItemTemplate,p,P);}else{a.bindProperty(this._oItemTemplate,p,P.value);}};
L.prototype.getInnerList=function(){return this._getList();};
return L;});
sap.ui.predefine('sap/f/cards/NumericHeader',['sap/f/library','sap/ui/core/Control',"sap/f/cards/CardActions",'sap/m/NumericContent','sap/m/Text','sap/ui/model/json/JSONModel',"sap/f/cards/NumericSideIndicator","sap/f/cards/NumericHeaderRenderer","sap/base/strings/formatMessage"],function(l,C,a,N,T,J,b,c,f){"use strict";var A=l.cards.AreaType;
var d=C.extend("sap.f.cards.NumericHeader",{metadata:{library:"sap.f",interfaces:["sap.f.cards.IHeader"],properties:{title:{"type":"string",group:"Appearance"},subtitle:{"type":"string",group:"Appearance"},statusText:{type:"string",defaultValue:""},unitOfMeasurement:{"type":"string",group:"Data"},number:{"type":"string",group:"Data"},scale:{"type":"string",group:"Data"},trend:{"type":"sap.m.DeviationIndicator",group:"Appearance",defaultValue:"None"},state:{"type":"sap.m.ValueColor",group:"Appearance",defaultValue:"Neutral"},details:{"type":"string",group:"Appearance"}},aggregations:{sideIndicators:{type:"sap.f.cards.NumericSideIndicator",multiple:true},_title:{type:"sap.m.Text",multiple:false,visibility:"hidden"},_subtitle:{type:"sap.m.Text",multiple:false,visibility:"hidden"},_unitOfMeasurement:{type:"sap.m.Text",multiple:false,visibility:"hidden"},_details:{type:"sap.m.Text",multiple:false,visibility:"hidden"},_mainIndicator:{type:"sap.m.NumericContent",multiple:false,visibility:"hidden"}},events:{press:{}}}});
d.prototype.init=function(){this._aReadyPromises=[];this._bReady=false;this._awaitEvent("_dataReady");Promise.all(this._aReadyPromises).then(function(){this._bReady=true;this.fireEvent("_ready");}.bind(this));this.setBusyIndicatorDelay(0);};
d.prototype.exit=function(){this._oServiceManager=null;this._oDataProviderFactory=null;if(this._oDataProvider){this._oDataProvider.destroy();this._oDataProvider=null;}if(this._oActions){this._oActions.destroy();this._oActions=null;}};
d.prototype._awaitEvent=function(e){this._aReadyPromises.push(new Promise(function(r){this.attachEventOnce(e,function(){r();});}.bind(this)));};
d.prototype.isReady=function(){return this._bReady;};
d.prototype.setTitle=function(v){this.setProperty("title",v,true);this._getTitle().setText(v);return this;};
d.prototype.setSubtitle=function(v){this.setProperty("subtitle",v,true);this._getSubtitle().setText(v);return this;};
d.prototype.setUnitOfMeasurement=function(v){this.setProperty("unitOfMeasurement",v,true);this._getUnitOfMeasurement().setText(v);return this;};
d.prototype.setDetails=function(v){this.setProperty("details",v,true);this._getDetails().setText(v);return this;};
d.prototype.setNumber=function(v){this.setProperty("number",v,true);this._getMainIndicator().setValue(v);return this;};
d.prototype.setScale=function(v){this.setProperty("scale",v,true);this._getMainIndicator().setScale(v);return this;};
d.prototype.setTrend=function(v){this.setProperty("trend",v,true);this._getMainIndicator().setIndicator(v);return this;};
d.prototype.setState=function(v){this.setProperty("state",v,true);this._getMainIndicator().setValueColor(v);return this;};
d.prototype._getTitle=function(){var o=this.getAggregation("_title");if(!o){o=new T({id:this.getId()+"-title",wrapping:true,maxLines:3});this.setAggregation("_title",o);}return o;};
d.prototype._getSubtitle=function(){var o=this.getAggregation("_subtitle");if(!o){o=new T({id:this.getId()+"-subtitle",wrapping:true,maxLines:2});this.setAggregation("_subtitle",o);}return o;};
d.prototype._getUnitOfMeasurement=function(){var o=this.getAggregation("_unitOfMeasurement");if(!o){o=new T({id:this.getId()+"-unitOfMeasurement",wrapping:false});this.setAggregation("_unitOfMeasurement",o);}return o;};
d.prototype._getDetails=function(){var o=this.getAggregation("_details");if(!o){o=new T({id:this.getId()+"-details",wrapping:false});this.setAggregation("_details",o);}return o;};
d.prototype._getMainIndicator=function(){var o=this.getAggregation("_mainIndicator");if(!o){o=new N({id:this.getId()+"-mainIndicator",withMargin:false,nullifyValue:false,animateTextChange:false,truncateValueTo:5});this.setAggregation("_mainIndicator",o);}return o;};
d.prototype.ontap=function(){this.firePress();};
d.prototype.onsapselect=function(){this.firePress();};
d.create=function(m,s,D,e){var S={title:m.title,subtitle:m.subTitle,unitOfMeasurement:m.unitOfMeasurement,details:m.details};if(m.mainIndicator){S.number=m.mainIndicator.number;S.scale=m.mainIndicator.unit;S.trend=m.mainIndicator.trend;S.state=m.mainIndicator.state;}if(m.sideIndicators){S.sideIndicators=m.sideIndicators.map(function(i){return new b(i);});}if(m.status&&typeof m.status.text==="string"){S.statusText=m.status.text;}var h=new d(S);h._sAppId=e;if(m.status&&m.status.text&&m.status.text.format){d._bindStatusText(m.status.text.format,h);}h.setServiceManager(s);h.setDataProviderFactory(D);h._setData(m.data);var o=new a({areaType:A.Header});o.attach(m,h);h._oActions=o;return h;};
d._bindStatusText=function(F,h){if(F.parts&&F.translationKey&&F.parts.length===2){var B={parts:[F.translationKey,F.parts[0].toString(),F.parts[1].toString()],formatter:function(t,p,P){var s=p||F.parts[0];var e=P||F.parts[1];if(Array.isArray(p)){s=p.length;}if(Array.isArray(P)){e=P.length;}var i=parseFloat(s)||0;var g=parseFloat(e)||0;return f(t,[i,g]);}};h.bindProperty("statusText",B);}};
d.prototype.setServiceManager=function(s){this._oServiceManager=s;return this;};
d.prototype.setDataProviderFactory=function(D){this._oDataProviderFactory=D;return this;};
d.prototype._setData=function(D){var p="/";if(D&&D.path){p=D.path;}this.bindObject(p);if(this._oDataProvider){this._oDataProvider.destroy();}this._oDataProvider=this._oDataProviderFactory.create(D,this._oServiceManager);if(this._oDataProvider){this.setBusy(true);this.setModel(new J());this._oDataProvider.attachDataChanged(function(e){this._updateModel(e.getParameter("data"));this.setBusy(false);}.bind(this));this._oDataProvider.attachError(function(e){this._handleError(e.getParameter("message"));this.setBusy(false);}.bind(this));this._oDataProvider.triggerDataUpdate().then(function(){this.fireEvent("_dataReady");}.bind(this));}else{this.fireEvent("_dataReady");}};
d.prototype._updateModel=function(D){this.getModel().setData(D);};
d.prototype._handleError=function(L){this.fireEvent("_error",{logMessage:L});};
d.prototype._getHeaderAccessibility=function(){var t=this._getTitle()?this._getTitle().getId():"",s=this._getSubtitle()?this._getSubtitle().getId():"",u=this._getUnitOfMeasurement()?this._getUnitOfMeasurement().getId():"",S=this.getSideIndicators()?this._getSideIndicatorIds():"",D=this._getDetails()?this._getDetails().getId():"",m=this._getMainIndicator()?this._getMainIndicator().getId():"";return t+" "+s+" "+u+" "+m+S+" "+D;};
d.prototype._getSideIndicatorIds=function(){var s="";this.getSideIndicators().forEach(function(S){s+=" "+S.getId();});return s;};
return d;});
sap.ui.predefine('sap/f/cards/NumericHeaderRenderer',[],function(){"use strict";var N={},r=sap.ui.getCore().getLibraryResourceBundle("sap.f");
N.render=function(R,c){R.write("<header");R.writeControlData(c);R.addClass("sapFCardHeader");R.addClass("sapFCardNumericHeader");R.writeAttribute("tabindex","0");R.writeAccessibilityState(c,{role:"group",labelledby:{value:c._getHeaderAccessibility(),append:true},roledescription:{value:r.getText("ARIA_ROLEDESCRIPTION_CARD_HEADER"),append:true}});R.writeClasses();R.writeStyles();R.write(">");N.renderHeaderText(R,c);N.renderIndicators(R,c);var d=c.getAggregation("_details");if(d&&d.getText()){d.addStyleClass("sapFCardHeaderDetails");R.renderControl(d);}R.write("</header>");};
N.renderHeaderText=function(R,c){var t=c.getAggregation("_title"),s=c.getAggregation("_subtitle"),u=c.getAggregation("_unitOfMeasurement"),S=c.getStatusText();R.write("<div");R.addClass("sapFCardHeaderText");R.writeClasses();R.write(">");R.write("<div");R.addClass("sapFCardHeaderTextFirstLine");R.writeClasses();R.write(">");if(t){t.addStyleClass("sapFCardTitle");R.renderControl(t);}if(S){R.write("<span");R.addClass("sapFCardStatus");R.writeClasses();R.write(">");R.writeEscaped(S);R.write("</span>");}R.write("</div>");if(s||u){R.write("<div");R.addClass("sapFCardSubtitle");R.writeClasses();R.write(">");R.write("<div>");if(s){R.renderControl(s);}R.write("</div>");R.write("<div>");if(u){u.addStyleClass("sapFCardHeaderUnitOfMeasurement");R.renderControl(u);}R.write("</div>");R.write("</div>");}R.write("</div>");};
N.renderIndicators=function(R,c){var m=c.getAggregation("_mainIndicator"),s=c.getAggregation("sideIndicators");if((m&&m.getValue())||s.length!==0){R.write("<div");R.addClass("sapFCardHeaderIndicators");R.writeClasses();R.write(">");if(m&&m.getValue()){m.addStyleClass("sapFCardHeaderMainIndicator");R.renderControl(m);R.write("<div");R.addClass("sapFCardHeaderIndicatorsGap");R.writeClasses();R.write(">");R.write("</div>");}if(s.length!==0){R.write("<div");R.addClass("sapFCardHeaderSideIndicators");R.writeClasses();R.write(">");s.forEach(function(i){R.renderControl(i);});R.write("</div>");}R.write("</div>");}};
return N;},true);
sap.ui.predefine('sap/f/cards/NumericSideIndicator',['sap/ui/core/Control','sap/m/Text',"sap/f/cards/NumericSideIndicatorRenderer"],function(C,T){"use strict";
var N=C.extend("sap.f.cards.NumericSideIndicator",{metadata:{library:"sap.f",properties:{title:{"type":"string",group:"Appearance"},number:{"type":"string",group:"Data"},unit:{"type":"string",group:"Data"}},aggregations:{_title:{type:"sap.m.Text",multiple:false,visibility:"hidden"},_number:{type:"sap.m.Text",multiple:false,visibility:"hidden"},_unit:{type:"sap.m.Text",multiple:false,visibility:"hidden"}}}});
N.prototype.setTitle=function(v){this.setProperty("title",v,true);this._getTitle().setText(v);return this;};
N.prototype.setNumber=function(v){this.setProperty("number",v,true);this._getNumber().setText(v);return this;};
N.prototype.setUnit=function(v){this.setProperty("unit",v,true);this._getUnit().setText(v);return this;};
N.prototype._getTitle=function(){var c=this.getAggregation("_title");if(!c){c=new T({id:this.getId()+"-title",wrapping:false});this.setAggregation("_title",c);}return c;};
N.prototype._getNumber=function(){var c=this.getAggregation("_number");if(!c){c=new T({id:this.getId()+"-number"});this.setAggregation("_number",c);}return c;};
N.prototype._getUnit=function(){var c=this.getAggregation("_unit");if(!c){c=new T({id:this.getId()+"-unit"});this.setAggregation("_unit",c);}return c;};
return N;});
sap.ui.predefine('sap/f/cards/NumericSideIndicatorRenderer',[],function(){"use strict";var N={};
N.render=function(r,c){r.write("<div");r.writeControlData(c);r.addClass("sapFCardHeaderSideIndicator");r.writeClasses();r.writeStyles();r.write(">");var t=c.getAggregation("_title");if(t){t.addStyleClass("sapFCardHeaderSITitle");r.renderControl(t);}r.write("<div");r.addClass("sapFCardHeaderSINumber");r.writeClasses();r.write(">");var n=c.getAggregation("_number");if(n){r.renderControl(n);}var u=c.getAggregation("_unit");if(u){r.renderControl(u);}r.write("</div>");r.write("</div>");};
return N;},true);
sap.ui.predefine('sap/f/cards/ObjectContent',["sap/f/library","sap/f/cards/BaseContent","sap/m/HBox","sap/m/VBox","sap/m/Text","sap/m/Title","sap/f/Avatar","sap/m/Link","sap/m/Label","sap/ui/core/ResizeHandler","sap/ui/layout/AlignedFlowLayout","sap/ui/dom/units/Rem","sap/f/cards/BindingHelper","sap/f/cards/IconFormatter"],function(l,B,H,V,T,a,A,L,b,R,c,d,e,I){"use strict";var f=l.cards.AreaType;
var O=B.extend("sap.f.cards.ObjectContent",{renderer:{}});
O.prototype._getRootContainer=function(){if(this._bIsBeingDestroyed){return null;}var o=this.getAggregation("_content");if(!o){o=new c();this.setAggregation("_content",o);}this._sResizeListenerId=R.register(o,this.onAlignedFlowLayoutResize.bind(this));return o;};
O.prototype.onAlignedFlowLayoutResize=function(E){if(E&&(E.size.width===E.oldSize.width)&&!E.control){return;}var C=E.control,m=C.getMinItemWidth(),n=C.getContent().length,M;if(m.lastIndexOf("rem")!==-1){M=d.toPx(m);}else if(m.lastIndexOf("px")!==-1){M=parseFloat(m);}var i=Math.floor(E.size.width/M);if(i>n){i=n;}if(this._iColsOld===i){return;}this._iColsOld=i;var g=i-1,r=Math.ceil(n/i);C.getContent().forEach(function(o,h){o.addStyleClass("sapFCardObjectSpaceBetweenGroup");if(g===h&&g<n){o.removeStyleClass("sapFCardObjectSpaceBetweenGroup");g+=i;}if(h+1>(r-1)*i){o.addStyleClass("sapFCardObjectGroupLastInColumn");}else{o.removeStyleClass("sapFCardObjectGroupLastInColumn");}});};
O.prototype.exit=function(){B.prototype.exit.apply(this,arguments);if(this._sResizeListenerId){R.deregister(this._sResizeListenerId);this._sResizeListenerId="";}};
O.prototype.setConfiguration=function(C){B.prototype.setConfiguration.apply(this,arguments);if(!C){return this;}if(C.groups){this._addGroups(C);}return this;};
O.prototype._addGroups=function(C){var o=this._getRootContainer();var g=C.groups||[];g.forEach(function(G){var h=new V().addStyleClass("sapFCardObjectGroup");var t=new a({text:G.title}).addStyleClass("sapFCardObjectItemTitle");h.addItem(t);G.items.forEach(function(i){var j,s=i.label,v=i.value,k,m;if(s){s=s[s.length-1]===":"?s:s+=":";k=new b({text:s}).addStyleClass("sapFCardObjectItemLabel");}if(v){switch(i.type){case'link':j=new L({href:i.url||v,text:v,target:i.target||'_blank'});break;case'email':m="mailto:"+v;if(i.emailSubject){m+='?subject='+i.emailSubject;}j=new L({href:m,text:v});break;case'phone':j=new L({href:"tel:"+v,text:v});break;default:j=new T({text:v});break;}}if(j){j.addStyleClass("sapFCardObjectItemText");}if(i.icon){var n=new A({customDisplaySize:"2.5rem",displaySize:"Custom"}).addStyleClass("sapFCardObjectItemAvatar sapFCardObjectItemLabel");var p=new V({items:[k,j]});var q=new H({items:[n,p]});e.bindProperty(n,"src",i.icon.src,function(v){return I.formatSrc(v,this._sAppId);}.bind(this));h.addItem(q);}else{h.addItem(k);h.addItem(j);}},this);o.addContent(h);},this);this._oActions.setAreaType(f.Content);this._oActions.attach(C,this);};
return O;});
sap.ui.predefine('sap/f/cards/RequestDataProvider',["sap/f/cards/DataProvider","jquery.sap.global","sap/base/Log"],function(D,q,L){"use strict";var m=["no-cors","same-origin","cors"];var M=["GET","POST"];
var R=D.extend("sap.f.cards.RequestDataProvider");
R.prototype.getData=function(){return this._fetch(this.getSettings().request);};
R.prototype._isValidRequest=function(r){if(!r){return false;}if(m.indexOf(r.mode)===-1){return false;}if(M.indexOf(r.method)===-1){return false;}if(typeof r.url!=="string"){return false;}return true;};
R.prototype._fetch=function(r){var s="Invalid request";return new Promise(function(a,b){if(!r){L.error(s);b(s);return;}var o={"mode":r.mode||"cors","url":r.url,"method":(r.method&&r.method.toUpperCase())||"GET","data":r.parameters,"headers":r.headers,"timeout":15000,"xhrFields":{"withCredentials":!!r.withCredentials}};if(o.method==="GET"){o.dataType="json";}if(this._isValidRequest(o)){q.ajax(o).done(function(d){a(d);}).fail(function(j,t,e){b(e);});}else{L.error(s);b(s);}}.bind(this));};
return R;});
sap.ui.predefine('sap/f/cards/ServiceDataProvider',["sap/f/cards/DataProvider"],function(D){"use strict";
var S=D.extend("sap.f.cards.ServiceDataProvider",{metadata:{interfaces:["sap.f.cards.IServiceDataProvider"]}});
S.prototype.destroy=function(){this._oDataServicePromise=null;if(this._oServiceManager){this._oServiceManager=null;}D.prototype.destroy.apply(this,arguments);};
S.prototype.createServiceInstances=function(s){this._oServiceManager=s;if(!this._oSettings||!this._oSettings.service){return;}var v=this._oSettings.service;if(v&&typeof v==="object"){v=v.name;}this._createServiceInstance(v);};
S.prototype._createServiceInstance=function(s){var d=this._oSettings;this._oDataServicePromise=this._oServiceManager.getService(s).then(function(o){o.attachDataChanged(function(e){this.fireDataChanged({data:e.data});}.bind(this),d.service.parameters);return o;}.bind(this));};
S.prototype.getData=function(){var d=this.getSettings();var s=d.service;return new Promise(function(r,a){if(s&&this._oDataServicePromise){this._oDataServicePromise.then(function(o){o.getData().then(function(b){r(b);}).catch(function(){a("Card data service failed to get data.");});}).catch(function(){a("Card data service unavailable.");});}else{a("Could not get card data.");}}.bind(this));};
return S;});
sap.ui.predefine('sap/f/cards/TableContent',["sap/f/library","sap/ui/base/ManagedObject","sap/m/Table","sap/f/cards/BaseContent","sap/m/Column","sap/m/ColumnListItem","sap/m/Text","sap/m/Link","sap/m/ProgressIndicator","sap/m/ObjectIdentifier","sap/m/ObjectStatus","sap/f/Avatar","sap/ui/core/library","sap/m/library","sap/f/cards/BindingResolver","sap/f/cards/BindingHelper","sap/f/cards/IconFormatter"],function(l,M,R,B,C,a,T,L,P,O,b,A,c,m,d,e,I){"use strict";var f=l.AvatarSize;var V=c.VerticalAlign;var g=m.ListSeparators;var h=m.ListType;var i=l.cards.AreaType;
var k=B.extend("sap.f.cards.TableContent",{renderer:{}});
k.prototype.exit=function(){B.prototype.exit.apply(this,arguments);if(this._oItemTemplate){this._oItemTemplate.destroy();this._oItemTemplate=null;}};
k.prototype._getTable=function(){if(this._bIsBeingDestroyed){return null;}var t=this.getAggregation("_content");if(!t){t=new R({id:this.getId()+"-Table",showSeparators:g.None});this.setAggregation("_content",t);}return t;};
k.prototype.setConfiguration=function(o){B.prototype.setConfiguration.apply(this,arguments);if(!o){return this;}if(o.rows&&o.columns){this._setStaticColumns(o.rows,o.columns);return this;}if(o.row&&o.row.columns){this._setColumns(o.row);}return this;};
k.prototype._setColumns=function(r){var j=[],t=this._getTable(),n=r.columns;n.forEach(function(p){this._getTable().addColumn(new C({header:new T({text:p.title}),width:p.width}));j.push(this._createCell(p));}.bind(this));this._oItemTemplate=new a({cells:j,vAlign:V.Middle});this._oActions.setAreaType(i.ContentItem);this._oActions.attach(r,this);var o={template:this._oItemTemplate};this._bindAggregation("items",t,o);};
k.prototype._setStaticColumns=function(r,n){var t=this._getTable();n.forEach(function(o){t.addColumn(new C({header:new T({text:o.title}),width:o.width}));});r.forEach(function(o){var p=new a({vAlign:V.Middle});if(o.cells&&Array.isArray(o.cells)){for(var j=0;j<o.cells.length;j++){p.addCell(this._createCell(o.cells[j]));}}if(o.actions&&Array.isArray(o.actions)){var q=o.actions[0];if(q.type===h.Navigation){p.setType(h.Navigation);}if(q.url){p.attachPress(function(){window.open(q.url,q.target||"_blank");});}}t.addItem(p);}.bind(this));this.fireEvent("_actionContentReady");};
k.prototype._createCell=function(o){if(o.url){return new L({text:o.value,href:o.url,target:o.target||"_blank"});}if(o.identifier){var j=new O({title:o.value});if(o.identifier.url){var n=M.bindingParser(o.identifier.url);if(n){n.formatter=function(v){if(typeof v==="string"){return true;}return false;};j.bindProperty("titleActive",n);}else{j.setTitleActive(!!o.identifier.url);}j.attachTitlePress(function(E){var s=E.getSource(),q=s.getBindingContext(),r=s.getModel(),t,u,v;if(q){t=q.getPath();}u=d.resolveValue(o.identifier.url,r,t);v=d.resolveValue(o.identifier.target,r,t);if(u){window.open(u,v||"_blank");}});}return j;}if(o.state){return new b({text:o.value,state:o.state});}if(o.value){return new T({text:o.value});}if(o.icon){var p=new A({displayShape:o.icon.shape,displaySize:f.XS});e.bindProperty(p,"src",o.icon.src,function(v){return I.formatSrc(v,this._sAppId);}.bind(this));return p;}if(o.progressIndicator){return new P({percentValue:o.progressIndicator.percent,displayValue:o.progressIndicator.text,state:o.progressIndicator.state});}};
k.prototype.getInnerList=function(){return this._getTable();};
return k;});
sap.ui.predefine('sap/f/cards/TimelineContent',["sap/f/cards/BaseContent","sap/suite/ui/commons/Timeline","sap/suite/ui/commons/library","sap/suite/ui/commons/TimelineItem",'sap/ui/base/ManagedObject',"sap/f/cards/BindingHelper","sap/f/cards/IconFormatter"],function(B,T,s,a,M,b,I){"use strict";
var c=B.extend("sap.f.cards.TimelineContent",{renderer:{}});
c.prototype.exit=function(){B.prototype.exit.apply(this,arguments);if(this._oTimeLineItemTemplate){this._oTimeLineItemTemplate.destroy();this._oTimeLineItemTemplate=null;}};
c.prototype._getTimeline=function(){var t=this.getAggregation("_content");if(this._bIsBeingDestroyed){return null;}if(!t){t=new T({id:this.getId()+"-Timeline",showHeaderBar:false,enableScroll:false});this.setAggregation("_content",t);}return t;};
c.prototype.setConfiguration=function(C){B.prototype.setConfiguration.apply(this,arguments);if(!C){return this;}if(C.items){this._setStaticItems(C.items);return this;}if(C.item){this._setItem(C.item);}return this;};
c.prototype._setItem=function(i){this._oTimeLineItemTemplate=new a({userNameClickable:false});i.title&&b.bindProperty(this._oTimeLineItemTemplate,"title",i.title.value);i.description&&b.bindProperty(this._oTimeLineItemTemplate,"text",i.description.value);i.ownerImage&&i.ownerImage.value&&b.bindProperty(this._oTimeLineItemTemplate,"userPicture",i.ownerImage.value,function(v){return I.formatSrc(v,this._sAppId);}.bind(this));i.dateTime&&b.bindProperty(this._oTimeLineItemTemplate,"dateTime",i.dateTime.value);i.owner&&b.bindProperty(this._oTimeLineItemTemplate,"userName",i.owner.value);i.icon&&b.bindProperty(this._oTimeLineItemTemplate,"icon",i.icon.src);this._oActions.attach(i,this);var o={template:this._oTimeLineItemTemplate};this._bindAggregation("content",this._getTimeline(),o);return this;};
c.prototype._setStaticItems=function(i){var t=this._getTimeline(),o;i.forEach(function(d){o=new a({title:d.title,text:d.description,userPicture:d.ownerImage,dateTime:d.dateTime,userName:d.owner,icon:d.icon});t.addContent(o);});};
c.prototype.getInnerList=function(){return this._getTimeline();};
return c;});
sap.ui.predefine('sap/f/changeHandler/MoveDynamicPageTitleActions',["sap/ui/fl/Utils"],function(F){"use strict";var M={};var A="actions";
M.applyChange=function(c,C,p){var m=p.modifier,v=p.view,a=p.appComponent,o=c.getDefinition().content.movedElements[0];var b=m.bySelector(o.selector,a,v),t=o.targetIndex;m.getAggregation(C,A).forEach(function(B,i){if(m.getId(B)===m.getId(b)){m.removeAggregation(C,A,B);m.insertAggregation(C,"dependents",B,undefined,v);c.setRevertData({index:i});}});m.insertAggregation(C,A,b,t,v);return true;};
M.revertChange=function(c,C,p){var m=p.modifier,v=p.view,a=p.appComponent,o=c.getDefinition().content.movedElements[0],r=c.getRevertData();var b=m.bySelector(o.selector,a,v),t=r?r.index:o.targetIndex,s=o.sourceIndex;m.removeAggregation(C,A,b,t,v);m.insertAggregation(C,A,b,s,v);return true;};
M.completeChangeContent=function(c,s,p){var m=p.modifier,a=p.appComponent,C=c.getDefinition();C.content={movedElements:[]};s.movedElements.forEach(function(e){var E=e.element||m.bySelector(e.id,a);C.content.movedElements.push({selector:m.getSelector(E,a),sourceIndex:e.sourceIndex,targetIndex:e.targetIndex});});};
return M;},true);
sap.ui.predefine('sap/f/dnd/GridDragOver',['sap/ui/base/Object',"sap/ui/thirdparty/jquery","sap/base/Log"],function(B,q,L){"use strict";
var G=B.extend("sap.f.dnd.GridDragOver",{
_iTimeoutBeforeDrop:200,
_$indicator:q("<div class='sapUiDnDGridIndicator'></div>"),
constructor:function(){this._oDragControlDelegate={ondragend:this.scheduleEndDrag};this._oDropContainerDelegate={ondragleave:this._onDragLeave};},
destroy:function(){this._oDragEndDelegate=null;}
});
G.prototype.setCurrentContext=function(d,D,t){if(this._oDragControl===d&&this._oDropContainer===D&&this._sTargetAggregation===t){return this;}if(this._oDragControl&&this._oDragControl!==d){this.endDrag();}this._oDragControl=d;this._oDropContainer=D;this._sTargetAggregation=t;this._mDragItemDimensions=this._getDimensions(d);this._bIsInSameContainer=d.getParent()===D;if(this._bIsInSameContainer){this._iDragFromIndex=D.indexOfAggregation(t,d);}else{this._iDragFromIndex=null;}D.getAggregation(t).forEach(function(c){c.addStyleClass("sapUiDnDGridControl");});this._attachEventDelegates();return this;};
G.prototype.handleDragOver=function(d){if(this._shouldFreeze(d.pageX,d.pageY)){return;}var D=this._calculateDropPosition(d);if(!D){return;}if(this._timeoutOnSamePosition(D)){if(D.targetControl===this._oDragControl){return;}this._hideDraggedItem();this._showIndicator(D,d);this._freezeCurrentPosition(d.pageX,d.pageY);}};
G.prototype.getSuggestedDropPosition=function(){return this._mLastDropPosition;};
G.prototype.setDropIndicatorSize=function(I){if(!I){this._mDropIndicatorSize=null;return;}if(!I.rows||!I.columns){L.error("Custom indicator size for grid drag and drop is not valid. It must be an object with rows and columns properties: '{rows: <int>, columns: <int>}'.");this._mDropIndicatorSize=null;return;}this._mDropIndicatorSize=I;};
G.prototype.scheduleEndDrag=function(){if(!this._isDragActive()){return;}var b=this._oDropContainer.getBindingInfo(this._sTargetAggregation);if(b&&b.template){setTimeout(this.endDrag.bind(this),0);}else{this.endDrag();}};
G.prototype.endDrag=function(){if(!this._isDragActive()){return;}this._$indicator.detach();this._showDraggedItem();this._removeEventDelegates();this._oDropContainer.fireEvent("_gridPolyfillAfterDragEnd",{indicator:this._$indicator});this._$indicator.attr("style","");this._mDropIndicatorSize=null;this._oDragControl=null;this._oDropContainer=null;this._sTargetAggregation=null;this._iDragFromIndex=null;this._iDropPositionHoldStart=null;this._mLastDropPosition=null;this._mFreezePosition=null;};
G.prototype._isDragActive=function(){return this._oDragControl&&this._oDropContainer;};
G.prototype._showIndicator=function(d,D){var $=this._findContainingGridItem(d.targetControl),a=$||d.targetControl.$(),s;if(this._oDropContainer.isA("sap.f.GridContainer")){a=a.closest(".sapFGridContainerItemWrapper");}if(this._mDropIndicatorSize){s={"grid-row-start":"span "+this._mDropIndicatorSize.rows,"grid-column-start":"span "+this._mDropIndicatorSize.columns};}else if($){s={"grid-column-start":this._mDragItemDimensions.columnsSpan,"grid-row-start":this._mDragItemDimensions.rowsSpan};}if(s){this._$indicator.css(s);}if(d.position=="Before"){this._$indicator.insertBefore(a);}else{this._$indicator.insertAfter(a);}this._$indicator.show();this._iDragFromIndex=this._$indicator.index();var e={indicator:this._$indicator};if(this._mDropIndicatorSize){e.rows=this._mDropIndicatorSize.rows;e.columns=this._mDropIndicatorSize.columns;}else{e.width=this._mDragItemDimensions.rect.width;e.height=this._mDragItemDimensions.rect.height;}this._oDropContainer.fireEvent("_gridPolyfillAfterDragOver",e);};
G.prototype._hideDraggedItem=function(){this._oDragControl.$().hide();var $=this._findContainingGridItem(this._oDragControl);if($){$.hide();}};
G.prototype._showDraggedItem=function(){if(this._oDragControl.getDomRef()){this._oDragControl.$().show();}var $=this._findContainingGridItem(this._oDragControl);if($){$.show();}};
G.prototype._timeoutOnSamePosition=function(d){if(!this._mLastDropPosition||d.targetControl!==this._mLastDropPosition.targetControl||d.position!=this._mLastDropPosition.position){this._iDropPositionHoldStart=Date.now();this._mLastDropPosition=d;return false;}return Date.now()-this._iDropPositionHoldStart>this._iTimeoutBeforeDrop;};
G.prototype._shouldFreeze=function(p,P){var t=20;return this._mFreezePosition&&Math.abs(this._mFreezePosition.pageX-p)<t&&Math.abs(this._mFreezePosition.pageY-P)<t;};
G.prototype._freezeCurrentPosition=function(p,P){this._mFreezePosition={pageX:p,pageY:P};};
G.prototype._calculateDropPosition=function(d){var $=this._findItemFromPoint(d.pageX,d.pageY),c,t,b;if(!$){c=this._findClosestItem(d.pageX,d.pageY);}if(c){$=c.target;}if(c&&c.direction==="Left"){b="After";}if(!$){$=this._getLastItem();b="After";}if($.hasClass("sapUiDnDGridIndicator")){return null;}t=$.control(0,true);if(!b){b=this._calculateDropBeforeOrAfter(t,d);}return{targetControl:t,position:b};};
G.prototype._calculateDropBeforeOrAfter=function(t,d){var D=this._getDimensions(t),c=D.rect;if(this._oDragControl===t){return"Before";}if((this._mDragItemDimensions.rect.width*1.5)<c.width){var p=window.pageXOffset,m={left:c.left+p,width:c.width},C=d.pageX-m.left;return C<m.width*0.5?"Before":"After";}if(this._iDragFromIndex===null){return"Before";}var T=this._oDropContainer.indexOfAggregation(this._sTargetAggregation,t);if(this._iDragFromIndex>T){return"Before";}return"After";};
G.prototype._getDimensions=function(c){var $=this._findContainingGridItem(c);if($){return{rect:$[0].getBoundingClientRect(),columnsSpan:$.css("grid-column-start"),rowsSpan:$.css("grid-row-start")};}return{rect:c.getDomRef().getBoundingClientRect(),columnsSpan:"span 1",rowsSpan:"span 1"};};
G.prototype._findContainingGridItem=function(c){var $=c.$(),d=$.parent().css("display");if(d==="grid"||d==="inline-grid"){return $;}d=$.parent().parent().css("display");if(d==="grid"||d==="inline-grid"){return $.parent();}return null;};
G.prototype._getLastItem=function(){var I=this._oDropContainer.getAggregation(this._sTargetAggregation),$;if(I.length){$=I[I.length-1].$();}return $;};
G.prototype._findItemFromPoint=function(p,P){var o=document.elementFromPoint(p,P),$=q(o).closest(".sapUiDnDGridControl, .sapUiDnDGridIndicator");if($.hasClass("sapUiDnDGridIndicator")){return $;}if($.hasClass("sapUiDnDGridControl")){return $;}return null;};
G.prototype._findClosestItem=function(p,P){var I=sap.ui.getCore().getConfiguration().getRTL(),a=I?-1:1,s=80*a,S=20,$,d,t=0,x=p-s;while(!$&&x>0&&t<4){$=this._findItemFromPoint(x,P);x-=s;t++;}if($){d="Left";}if(!$&&P-S>0){$=this._findItemFromPoint(p,P-20);d="Top";}return{target:$,direction:d};};
G.prototype._removeEventDelegates=function(){if(this._oDropContainer){this._oDropContainer.removeEventDelegate(this._oDropContainerDelegate);}if(this._oDragControl){this._oDragControl.removeEventDelegate(this._oDragControlDelegate);}};
G.prototype._attachEventDelegates=function(){this._removeEventDelegates();this._oDragControl.addEventDelegate(this._oDragControlDelegate,this);this._oDropContainer.addEventDelegate(this._oDropContainerDelegate,this);};
G.prototype._onDragLeave=function(e){var E=document.elementFromPoint(e.pageX,e.pageY),I=this._oDropContainer.getDomRef().contains(E);if(!I){this.scheduleEndDrag();}};
var i;
G.getInstance=function(){if(!i){i=new G();}return i;};
return G;});
sap.ui.predefine('sap/f/dnd/GridDropInfo',["sap/ui/core/library","sap/ui/core/dnd/DropInfo","sap/f/dnd/GridDragOver","sap/base/Log"],function(c,D,G,L){"use strict";
var a=D.extend("sap.f.dnd.GridDropInfo",{metadata:{library:"sap.ui.core",interfaces:["sap.ui.core.dnd.IDropInfo"],properties:{dropIndicatorSize:{type:"function",invalidate:false,parameters:{draggedControl:{type:"sap.ui.core.Control"}}}}}});
a.prototype.isDroppable=function(C,e){if(!this._shouldEnhance()){return D.prototype.isDroppable.apply(this,arguments);}if(!this.getEnabled()){return false;}if(!C||!e){return false;}var d=this.getDropTarget();if(!d){return false;}var A=d.getDomRefForSetting(this.getTargetAggregation());if(A&&A.contains(e.target)){e.setMark("DragWithin",this.getTargetAggregation());return true;}if(!A&&d===C){return true;}return false;};
a.prototype.fireDragEnter=function(e){if(!this._shouldEnhance()){return D.prototype.fireDragEnter.apply(this,arguments);}if(!e||!e.dragSession||!e.dragSession.getDragControl()){return null;}this._hideDefaultIndicator(e);var g=G.getInstance(),d=e.dragSession.getDragControl();if(this.getDropIndicatorSize()){g.setDropIndicatorSize(this.getDropIndicatorSize()(d));}g.setCurrentContext(e.dragSession.getDragControl(),this.getDropTarget(),this.getTargetAggregation());var m=g.getSuggestedDropPosition();var b=this.fireEvent("dragEnter",{dragSession:e.dragSession,browserEvent:e.originalEvent,target:m?m.targetControl:null},true);if(b){g.handleDragOver(e);}return b;};
a.prototype.fireDragOver=function(e){if(!this._shouldEnhance()){return D.prototype.fireDragOver.apply(this,arguments);}if(!e||!e.dragSession||!e.dragSession.getDragControl()){return null;}this._hideDefaultIndicator(e);var d=this._suggestDropPosition(e);if(d&&e.dragSession){e.dragSession.setDropControl(d.targetControl);}return this.fireEvent("dragOver",{dragSession:e.dragSession,browserEvent:e.originalEvent,target:d?d.targetControl:null,dropPosition:d?d.position:null});};
a.prototype.fireDrop=function(e){if(!this._shouldEnhance()){return D.prototype.fireDrop.apply(this,arguments);}if(!e||!e.dragSession||!e.dragSession.getDragControl()){return null;}var d=e.dragSession,g=G.getInstance(),m;g.setCurrentContext(d.getDragControl(),this.getDropTarget(),this.getTargetAggregation());m=g.getSuggestedDropPosition();this.fireEvent("drop",{dragSession:e.dragSession,browserEvent:e.originalEvent,dropPosition:m?m.position:null,draggedControl:d.getDragControl(),droppedControl:m?m.targetControl:null});g.scheduleEndDrag();};
a.prototype._shouldEnhance=function(){if(this._bShouldEnhance===undefined){if(!this.getParent().isA("sap.f.dnd.IGridDroppable")){L.error("The control which uses 'sap.f.dnd.GridDropInfo' has to implement 'sap.f.dnd.IGridDroppable'.","sap.f.dnd.GridDropInfo");this._bShouldEnhance=false;return this._bShouldEnhance;}this._bShouldEnhance=this.getDropPosition()===c.dnd.DropPosition.Between&&this.getDropLayout()===c.dnd.DropLayout.Horizontal;}return this._bShouldEnhance;};
a.prototype._suggestDropPosition=function(d){if(!d.dragSession||!d.dragSession.getDragControl()){return null;}var g=G.getInstance();g.setCurrentContext(d.dragSession.getDragControl(),this.getDropTarget(),this.getTargetAggregation());g.handleDragOver(d);return g.getSuggestedDropPosition();};
a.prototype._hideDefaultIndicator=function(d){d.dragSession.setIndicatorConfig({visibility:"hidden",position:"relative"});};
return a;},true);
sap.ui.predefine('sap/f/flexibility/DynamicPageTitle.flexibility',["sap/m/changeHandler/CombineButtons","sap/m/changeHandler/SplitMenuButton","sap/f/changeHandler/MoveDynamicPageTitleActions"],function(C,S,M){"use strict";return{"hideControl":"default","unhideControl":"default","combineButtons":{"changeHandler":C,"layers":{"CUSTOMER":false}},"splitMenuButton":{"changeHandler":S,"layers":{"CUSTOMER":false}},"moveActions":{"changeHandler":M},"moveControls":"default"};},true);
sap.ui.predefine('sap/f/library',["sap/ui/base/DataType","sap/ui/Global","sap/ui/core/library","sap/ui/layout/library","sap/m/library"],function(D){"use strict";sap.ui.getCore().initLibrary({name:"sap.f",version:"1.71.16",dependencies:["sap.ui.core","sap.m","sap.ui.layout"],designtime:"sap/f/designtime/library.designtime",interfaces:["sap.f.cards.IHeader","sap.f.ICard","sap.f.IShellBar","sap.f.IDynamicPageStickyContent","sap.f.dnd.IGridDroppable"],types:["sap.f.AvatarImageFitType","sap.f.AvatarShape","sap.f.AvatarSize","sap.f.AvatarType","sap.f.AvatarColor","sap.f.cards.HeaderPosition","sap.f.DynamicPageTitleArea","sap.f.DynamicPageTitleShrinkRatio","sap.f.LayoutType"],controls:["sap.f.Avatar","sap.f.cards.Header","sap.f.cards.NumericHeader","sap.f.cards.NumericSideIndicator","sap.f.Card","sap.f.GridContainer","sap.f.DynamicPage","sap.f.DynamicPageHeader","sap.f.DynamicPageTitle","sap.f.FlexibleColumnLayout","sap.f.semantic.SemanticPage","sap.f.GridList","sap.f.GridListItem","sap.f.ShellBar"],elements:["sap.f.DynamicPageAccessibleLandmarkInfo","sap.f.GridContainerItemLayoutData","sap.f.semantic.AddAction","sap.f.semantic.CloseAction","sap.f.semantic.CopyAction","sap.f.semantic.DeleteAction","sap.f.semantic.DiscussInJamAction","sap.f.semantic.EditAction","sap.f.semantic.ExitFullScreenAction","sap.f.semantic.FavoriteAction","sap.f.semantic.FlagAction","sap.f.semantic.FooterMainAction","sap.f.semantic.FullScreenAction","sap.f.semantic.MainAction","sap.f.semantic.MessagesIndicator","sap.f.semantic.NegativeAction","sap.f.semantic.PositiveAction","sap.f.semantic.PrintAction","sap.f.semantic.SemanticButton","sap.f.semantic.SemanticControl","sap.f.semantic.SemanticToggleButton","sap.f.semantic.SendEmailAction","sap.f.semantic.SendMessageAction","sap.f.semantic.ShareInJamAction","sap.f.semantic.TitleMainAction","sap.f.SearchManager"],extensions:{flChangeHandlers:{"sap.f.Avatar":{"hideControl":"default","unhideControl":"default"},"sap.f.DynamicPageHeader":{"hideControl":"default","unhideControl":"default","moveControls":"default"},"sap.f.DynamicPageTitle":"sap/f/flexibility/DynamicPageTitle","sap.f.semantic.SemanticPage":{"moveControls":"default"}},"sap.ui.support":{publicRules:true,internalRules:true}}});var t=sap.f;t.DynamicPageTitleArea={Begin:"Begin",Middle:"Middle"};t.DynamicPageTitleShrinkRatio=D.createType('sap.f.DynamicPageTitleShrinkRatio',{isValid:function(v){return/^(([0-9]\d*)(\.\d)?:([0-9]\d*)(\.\d)?:([0-9]\d*)(\.\d)?)$/.test(v);}},D.getType('string'));t.LayoutType={OneColumn:"OneColumn",TwoColumnsBeginExpanded:"TwoColumnsBeginExpanded",TwoColumnsMidExpanded:"TwoColumnsMidExpanded",MidColumnFullScreen:"MidColumnFullScreen",ThreeColumnsMidExpanded:"ThreeColumnsMidExpanded",ThreeColumnsEndExpanded:"ThreeColumnsEndExpanded",ThreeColumnsMidExpandedEndHidden:"ThreeColumnsMidExpandedEndHidden",ThreeColumnsBeginExpandedEndHidden:"ThreeColumnsBeginExpandedEndHidden",EndColumnFullScreen:"EndColumnFullScreen"};sap.ui.lazyRequire("sap.f.routing.Router");sap.ui.lazyRequire("sap.f.routing.Target");sap.ui.lazyRequire("sap.f.routing.TargetHandler");sap.ui.lazyRequire("sap.f.routing.Targets");t.AvatarShape={Circle:"Circle",Square:"Square"};t.AvatarSize={XS:"XS",S:"S",M:"M",L:"L",XL:"XL",Custom:"Custom"};t.AvatarType={Icon:"Icon",Image:"Image",Initials:"Initials"};t.AvatarColor={Accent1:"Accent1",Accent2:"Accent2",Accent3:"Accent3",Accent4:"Accent4",Accent5:"Accent5",Accent6:"Accent6",Accent7:"Accent7",Accent8:"Accent8",Accent9:"Accent9",Accent10:"Accent10",Random:"Random"};t.AvatarImageFitType={Cover:"Cover",Contain:"Contain"};t.cards.HeaderPosition={Top:"Top",Bottom:"Bottom"};t.cards.AreaType={None:'None',ContentItem:'ContentItem',Content:'Content',Header:'Header'};return t;});
sap.ui.predefine('sap/f/routing/Router',['sap/ui/core/routing/Router','./TargetHandler','./Targets'],function(R,T,a){"use strict";
var M=R.extend("sap.f.routing.Router",{
constructor:function(){this._oTargetHandler=new T();R.prototype.constructor.apply(this,arguments);},
destroy:function(){R.prototype.destroy.apply(this,arguments);this._oTargetHandler.destroy();this._oTargetHandler=null;},
getTargetHandler:function(){return this._oTargetHandler;},
_createTargets:function(c,t){return new a({views:this._oViews,config:c,targets:t,targetHandler:this._oTargetHandler});},
fireRouteMatched:function(A){var r=this.getRoute(A.name),t;if(r._oTarget){t=r._oTarget._oOptions;this._oTargetHandler.addNavigation({navigationIdentifier:A.name,transition:t.transition,transitionParameters:t.transitionParameters,eventData:A.arguments,targetControl:A.targetControl,view:A.view,layout:r._oConfig.layout});}return R.prototype.fireRouteMatched.apply(this,arguments);},
fireRoutePatternMatched:function(A){var r=A.name,v;if(this._oTargets&&this._oTargets._oLastDisplayedTarget){v=this._oTargets._getViewLevel(this._oTargets._oLastDisplayedTarget);}this._oTargetHandler.navigate({navigationIdentifier:r,viewLevel:v,askHistory:true});return R.prototype.fireRoutePatternMatched.apply(this,arguments);}
});
return M;});
sap.ui.predefine('sap/f/routing/Target',['sap/ui/core/routing/Target','sap/f/FlexibleColumnLayout','./async/Target'],function(T,F,a){"use strict";
var M=T.extend("sap.f.routing.Target",{
constructor:function(o,v,p,t){this._oTargetHandler=t;T.prototype.constructor.apply(this,arguments);var b=a;this._super={};for(var f in b){this._super[f]=this[f];this[f]=b[f];}},
_beforePlacingViewIntoContainer:function(A){var c=A.container;var r=A.data&&A.data.routeConfig;if(c instanceof F&&r&&r.layout){c.setLayout(r.layout);}T.prototype._beforePlacingViewIntoContainer.apply(this,arguments);}
});
return M;});
sap.ui.predefine('sap/f/routing/TargetHandler',['sap/m/InstanceManager','sap/f/FlexibleColumnLayout','sap/ui/base/Object','sap/ui/core/routing/History',"sap/base/Log"],function(I,F,B,H,L){"use strict";
var T=B.extend("sap.f.routing.TargetHandler",{constructor:function(c){this._aQueue=[];this._oNavigationOrderPromise=Promise.resolve();if(c===undefined){this._bCloseDialogs=true;}else{this._bCloseDialogs=!!c;}}});
T.prototype.setCloseDialogs=function(c){this._bCloseDialogs=!!c;return this;};
T.prototype.getCloseDialogs=function(){return this._bCloseDialogs;};
T.prototype.addNavigation=function(p){this._aQueue.push(p);};
T.prototype.navigate=function(d){var r=this._createResultingNavigations(d.navigationIdentifier),c=false,b=this._getDirection(d),n;while(r.length){n=this._applyNavigationResult(r.shift().oParams,b);c=c||n;}if(c){this._closeDialogs();}};
T.prototype._chainNavigation=function(n){this._oNavigationOrderPromise=this._oNavigationOrderPromise.then(n);return this._oNavigationOrderPromise;};
T.prototype._getDirection=function(d){var t=d.viewLevel,h=H.getInstance(),b=false;if(d.direction==="Backwards"){b=true;}else if(isNaN(t)||isNaN(this._iCurrentViewLevel)||t===this._iCurrentViewLevel){if(d.askHistory){b=h.getDirection()==="Backwards";}}else{b=t<this._iCurrentViewLevel;}this._iCurrentViewLevel=t;return b;};
T.prototype._createResultingNavigations=function(n){var i,c,C,o,r=[],R;while(this._aQueue.length){c=this._aQueue.shift();C=c.targetControl;o={oContainer:C,oParams:c};if(!a(C)){continue;}for(i=0;i<r.length;i++){R=r[i];if(R.oContainer!==C){continue;}}r.push(o);}return r;};
T.prototype._applyNavigationResult=function(p,b){var t=p.targetControl,A=p.eventData,s=p.transition||"",o=p.transitionParameters,v=p.view.getId(),c,i=t instanceof F,S=false;if(i){c=[t.getCurrentBeginColumnPage(),t.getCurrentMidColumnPage(),t.getCurrentEndColumnPage()];S=c.some(function(C){return C&&C.getId()===v;});}if(S){L.info("navigation to view with id: "+v+" is skipped since it already is displayed by its targetControl","sap.f.routing.TargetHandler");return false;}L.info("navigation to view with id: "+v+" the targetControl is "+t.getId()+" backwards is "+b);if(b){t._safeBackToPage(v,s,A,o);}else{t.to(v,s,A,o);}return true;};
T.prototype._closeDialogs=function(){if(!this._bCloseDialogs){return;}if(I.hasOpenPopover()){I.closeAllPopovers();}if(I.hasOpenDialog()){I.closeAllDialogs();}if(I.hasOpenLightBox()){I.closeAllLightBoxes();}};
function a(c){return c&&c.isA(["sap.m.NavContainer","sap.m.SplitContainer","sap.f.FlexibleColumnLayout"]);}
return T;});
sap.ui.predefine('sap/f/routing/Targets',['sap/ui/core/routing/Targets','./TargetHandler','./Target','./async/Targets'],function(T,a,b,c){"use strict";
var M=T.extend("sap.f.routing.Targets",{
constructor:function(o){o.config._async=true;if(o.targetHandler){this._oTargetHandler=o.targetHandler;}else{this._oTargetHandler=new a();this._bHasOwnTargetHandler=true;}T.prototype.constructor.apply(this,arguments);var d=c;this._super={};for(var f in d){this._super[f]=this[f];this[f]=d[f];}},
destroy:function(){T.prototype.destroy.apply(this,arguments);if(this._bHasOwnTargetHandler){this._oTargetHandler.destroy();}this._oTargetHandler=null;},
getTargetHandler:function(){return this._oTargetHandler;},
_constructTarget:function(o,p){return new b(o,this.getViews(),p,this._oTargetHandler);},
_getViewLevel:function(t){var v;do{v=t._oOptions.viewLevel;if(v!==undefined){return v;}t=t._oParent;}while(t);return v;}
});
return M;});
sap.ui.predefine('sap/f/routing/async/Target',[],function(){"use strict";return{_place:function(d){var p=this._super._place.apply(this,arguments),r=d&&d.routeConfig||{},t=this;return this._oTargetHandler._chainNavigation(function(){return p.then(function(v){t._oTargetHandler.addNavigation({navigationIdentifier:t._oOptions._name,transition:t._oOptions.transition,transitionParameters:t._oOptions.transitionParameters,eventData:d,targetControl:v.control,view:v.view,layout:r.layout});return v;});});}};},true);
sap.ui.predefine('sap/f/routing/async/Targets',[],function(){"use strict";return{display:function(){var v,n;this._oLastDisplayedTarget=null;var p=this._super.display.apply(this,arguments);return p.then(function(V){if(this._oLastDisplayedTarget){v=this._getViewLevel(this._oLastDisplayedTarget);n=this._oLastDisplayedTarget._oOptions._name;}this._oTargetHandler.navigate({viewLevel:v,navigationIdentifier:n});return V;}.bind(this));},_displaySingleTarget:function(t){var T=this.getTarget(t.name);return this._super._displaySingleTarget.apply(this,arguments).then(function(v){if(T){this._oLastDisplayedTarget=T;}return v;}.bind(this));}};},true);
sap.ui.predefine('sap/f/semantic/AddAction',['sap/f/semantic/SemanticButton'],function(S){"use strict";
var A=S.extend("sap.f.semantic.AddAction",{metadata:{library:"sap.f"}});
return A;});
sap.ui.predefine('sap/f/semantic/CloseAction',['./SemanticButton'],function(S){"use strict";
var C=S.extend("sap.f.semantic.CloseAction",{metadata:{library:"sap.f"}});
return C;});
sap.ui.predefine('sap/f/semantic/CopyAction',['./SemanticButton'],function(S){"use strict";
var C=S.extend("sap.f.semantic.CopyAction",{metadata:{library:"sap.f"}});
return C;});
sap.ui.predefine('sap/f/semantic/DeleteAction',['sap/f/semantic/SemanticButton'],function(S){"use strict";
var D=S.extend("sap.f.semantic.DeleteAction",{metadata:{library:"sap.f"}});
return D;});
sap.ui.predefine('sap/f/semantic/DiscussInJamAction',['sap/f/semantic/SemanticButton'],function(S){"use strict";
var D=S.extend("sap.f.semantic.DiscussInJamAction",{metadata:{library:"sap.f"}});
return D;});
sap.ui.predefine('sap/f/semantic/EditAction',['./SemanticButton'],function(S){"use strict";
var E=S.extend("sap.f.semantic.EditAction",{metadata:{library:"sap.f"}});
return E;});
sap.ui.predefine('sap/f/semantic/ExitFullScreenAction',['./SemanticButton'],function(S){"use strict";
var E=S.extend("sap.f.semantic.ExitFullScreenAction",{metadata:{library:"sap.f"}});
return E;});
sap.ui.predefine('sap/f/semantic/FavoriteAction',['./SemanticToggleButton'],function(S){"use strict";
var F=S.extend("sap.f.semantic.FavoriteAction",{metadata:{library:"sap.f"}});
return F;});
sap.ui.predefine('sap/f/semantic/FlagAction',['./SemanticToggleButton'],function(S){"use strict";
var F=S.extend("sap.f.semantic.FlagAction",{metadata:{library:"sap.f"}});
return F;});
sap.ui.predefine('sap/f/semantic/FooterMainAction',["./MainAction"],function(M){"use strict";
var F=M.extend("sap.f.semantic.FooterMainAction",{metadata:{library:"sap.f"}});
return F;});
sap.ui.predefine('sap/f/semantic/FullScreenAction',['./SemanticButton'],function(S){"use strict";
var F=S.extend("sap.f.semantic.FullScreenAction",{metadata:{library:"sap.f"}});
return F;});
sap.ui.predefine('sap/f/semantic/MainAction',['sap/f/semantic/SemanticButton'],function(S){"use strict";
var M=S.extend("sap.f.semantic.MainAction",{metadata:{library:"sap.f","abstract":true,properties:{text:{type:"string",group:"Misc",defaultValue:null}}}});
return M;});
sap.ui.predefine('sap/f/semantic/MessagesIndicator',['./SemanticButton'],function(S){"use strict";
var M=S.extend("sap.f.semantic.MessagesIndicator",{metadata:{library:"sap.f"}});
return M;});
sap.ui.predefine('sap/f/semantic/NegativeAction',['sap/f/semantic/SemanticButton'],function(S){"use strict";
var N=S.extend("sap.f.semantic.NegativeAction",{metadata:{library:"sap.f",properties:{text:{type:"string",group:"Misc",defaultValue:null}}}});
return N;});
sap.ui.predefine('sap/f/semantic/PositiveAction',['sap/f/semantic/SemanticButton'],function(S){"use strict";
var P=S.extend("sap.f.semantic.PositiveAction",{metadata:{library:"sap.f",properties:{text:{type:"string",group:"Misc",defaultValue:null}}}});
return P;});
sap.ui.predefine('sap/f/semantic/PrintAction',['sap/f/semantic/SemanticButton'],function(S){"use strict";
var P=S.extend("sap.f.semantic.PrintAction",{metadata:{library:"sap.f"}});
return P;});
sap.ui.predefine('sap/f/semantic/SemanticButton',["./SemanticControl","sap/m/Button","sap/m/OverflowToolbarButton"],function(S,B,O){"use strict";
var a=S.extend("sap.f.semantic.SemanticButton",{metadata:{library:"sap.f","abstract":true,properties:{enabled:{type:"boolean",group:"Behavior",defaultValue:true}},events:{press:{}}}});
a.prototype._getControl=function(){var c=this.getAggregation('_control'),C=this._getConfiguration(),o,n;if(!C){return null;}if(!c){o=C&&C.constraints==="IconOnly"?O:B;n=this._createInstance(o);n.applySettings(C.getSettings());if(typeof C.getEventDelegates==="function"){n.addEventDelegate(C.getEventDelegates(n));}this.setAggregation('_control',n,true);c=this.getAggregation('_control');}return c;};
a.prototype._createInstance=function(c){return new c({id:this.getId()+"-button",press:jQuery.proxy(this.firePress,this)});};
return a;});
sap.ui.predefine('sap/f/semantic/SemanticConfiguration',["sap/ui/base/Metadata","sap/ui/core/IconPool","sap/m/library","sap/m/OverflowToolbarLayoutData","sap/ui/core/InvisibleText"],function(M,I,m,O,a){"use strict";var b=m.OverflowToolbarPriority;var B=m.ButtonType;var S=M.createClass("sap.f.semantic.SemanticConfiguration",{});S._Placement={titleText:"titleText",titleIcon:"titleIcon",footerLeft:"footerLeft",footerRight:"footerRight",shareMenu:"shareMenu"};
S.isKnownSemanticType=function(t){return S.getConfiguration(t)!==null;};
S.getConfiguration=function(t){return S._oTypeConfigs[t]||null;};
S.getSettings=function(t){if(S.isKnownSemanticType(t)){return S._oTypeConfigs[t].getSettings();}return null;};
S.getConstraints=function(t){if(S.isKnownSemanticType(t)){return S._oTypeConfigs[t].constraints||null;}return null;};
S.getPlacement=function(t){if(S.isKnownSemanticType(t)){return S._oTypeConfigs[t].placement;}return null;};
S.getOrder=function(t){if(S.isKnownSemanticType(t)){return S._oTypeConfigs[t].order;}return null;};
S.shouldBePreprocessed=function(t){if(S.isKnownSemanticType(t)){return S._oTypeConfigs[t].needPreprocesing||false;}return false;};
S.isMainAction=function(t){if(S.isKnownSemanticType(t)){return S._oTypeConfigs[t].mainAction||false;}return false;};
S.isNavigationAction=function(t){if(S.isKnownSemanticType(t)){return S._oTypeConfigs[t].navigation||false;}return false;};
S._oTypeConfigs=(function(){var t={},o=sap.ui.getCore().getLibraryResourceBundle("sap.f");t["sap.f.semantic.TitleMainAction"]={placement:S._Placement.titleText,order:0,mainAction:true,getSettings:function(){return{type:B.Emphasized,layoutData:new O({priority:b.NeverOverflow})};}};t["sap.f.semantic.EditAction"]={placement:S._Placement.titleText,order:1,getSettings:function(){return{text:o.getText("SEMANTIC_CONTROL_EDIT"),tooltip:o.getText("SEMANTIC_CONTROL_EDIT"),type:B.Transparent};}};t["sap.f.semantic.DeleteAction"]={placement:S._Placement.titleText,order:2,getSettings:function(){return{text:o.getText("SEMANTIC_CONTROL_DELETE"),type:B.Transparent};}};t["sap.f.semantic.CopyAction"]={placement:S._Placement.titleText,order:3,getSettings:function(){return{text:o.getText("SEMANTIC_CONTROL_COPY"),type:B.Transparent};}};t["sap.f.semantic.AddAction"]={placement:S._Placement.titleText,order:4,getSettings:function(){return{text:o.getText("SEMANTIC_CONTROL_ADD"),tooltip:o.getText("SEMANTIC_CONTROL_ADD"),type:B.Transparent};}};t["sap.f.semantic.FavoriteAction"]={placement:S._Placement.titleIcon,order:0,constraints:"IconOnly",getSettings:function(){return{icon:I.getIconURI("favorite"),text:o.getText("SEMANTIC_CONTROL_FAVORITE"),type:B.Transparent};}};t["sap.f.semantic.FlagAction"]={placement:S._Placement.titleIcon,order:1,constraints:"IconOnly",getSettings:function(){return{icon:I.getIconURI("flag"),text:o.getText("SEMANTIC_CONTROL_FLAG"),type:B.Transparent};}};t["sap.f.semantic.FullScreenAction"]={placement:S._Placement.titleIcon,order:0,constraints:"IconOnly",navigation:true,getSettings:function(){return{icon:I.getIconURI("full-screen"),tooltip:o.getText("SEMANTIC_CONTROL_FULL_SCREEN"),layoutData:new O({priority:b.NeverOverflow}),type:B.Transparent};}};t["sap.f.semantic.ExitFullScreenAction"]={placement:S._Placement.titleIcon,order:1,constraints:"IconOnly",navigation:true,getSettings:function(){return{icon:I.getIconURI("exit-full-screen"),tooltip:o.getText("SEMANTIC_CONTROL_EXIT_FULL_SCREEN"),layoutData:new O({priority:b.NeverOverflow}),type:B.Transparent};}};t["sap.f.semantic.CloseAction"]={placement:S._Placement.titleIcon,order:2,constraints:"IconOnly",navigation:true,getSettings:function(){return{icon:I.getIconURI("decline"),tooltip:o.getText("SEMANTIC_CONTROL_CLOSE"),layoutData:new O({priority:b.NeverOverflow}),type:B.Transparent};}};t["sap.f.semantic.MessagesIndicator"]={placement:S._Placement.footerLeft,order:0,mainAction:false,getSettings:function(){var T=a.getStaticId("sap.f","SEMANTIC_CONTROL_MESSAGES_INDICATOR");return{icon:I.getIconURI("message-popup"),text:{path:"message>/",formatter:function(c){return c.length||0;}},tooltip:o.getText("SEMANTIC_CONTROL_MESSAGES_INDICATOR"),ariaLabelledBy:T,type:B.Emphasized,visible:{path:"message>/",formatter:function(c){return c&&c.length>0;}},models:{message:sap.ui.getCore().getMessageManager().getMessageModel()},layoutData:new O({priority:b.NeverOverflow})};}};t["sap.m.DraftIndicator"]={placement:S._Placement.footerRight,order:0,needPreprocesing:true,mainAction:false,getSettings:function(){return{layoutData:new O({shrinkable:false})};}};t["sap.f.semantic.FooterMainAction"]={placement:S._Placement.footerRight,order:1,mainAction:true,getSettings:function(){return{type:B.Emphasized,text:o.getText("SEMANTIC_CONTROL_SAVE"),layoutData:new O({priority:b.NeverOverflow})};}};t["sap.f.semantic.PositiveAction"]={placement:S._Placement.footerRight,order:2,mainAction:false,getSettings:function(){return{type:B.Accept,text:o.getText("SEMANTIC_CONTROL_ACCEPT"),layoutData:new O({priority:b.NeverOverflow})};}};t["sap.f.semantic.NegativeAction"]={placement:S._Placement.footerRight,order:3,mainAction:false,getSettings:function(){return{type:B.Reject,text:o.getText("SEMANTIC_CONTROL_REJECT"),layoutData:new O({priority:b.NeverOverflow})};}};t["sap.f.semantic.SendEmailAction"]={placement:S._Placement.shareMenu,order:0,constraints:"IconOnly",getSettings:function(){return{icon:I.getIconURI("email"),text:o.getText("SEMANTIC_CONTROL_SEND_EMAIL"),type:B.Transparent};}};t["sap.f.semantic.DiscussInJamAction"]={placement:S._Placement.shareMenu,order:1,constraints:"IconOnly",getSettings:function(){return{icon:I.getIconURI("discussion-2"),text:o.getText("SEMANTIC_CONTROL_DISCUSS_IN_JAM"),type:B.Transparent};}};t["sap.f.semantic.ShareInJamAction"]={placement:S._Placement.shareMenu,order:2,constraints:"IconOnly",getSettings:function(){return{icon:I.getIconURI("share-2"),text:o.getText("SEMANTIC_CONTROL_SHARE_IN_JAM"),type:B.Transparent};}};t["sap.f.semantic.SendMessageAction"]={placement:S._Placement.shareMenu,order:3,constraints:"IconOnly",getSettings:function(){return{icon:I.getIconURI("discussion"),text:o.getText("SEMANTIC_CONTROL_SEND_MESSAGE"),type:B.Transparent};}};t["saveAsTileAction"]={placement:S._Placement.shareMenu,order:4,constraints:"IconOnly"};t["sap.f.semantic.PrintAction"]={placement:S._Placement.shareMenu,order:5,constraints:"IconOnly",getSettings:function(){return{icon:I.getIconURI("print"),text:o.getText("SEMANTIC_CONTROL_PRINT"),type:B.Transparent};}};return t;})();return S;},false);
sap.ui.predefine('sap/f/semantic/SemanticContainer',["sap/ui/base/Metadata","./SemanticConfiguration","sap/base/Log"],function(M,S,L){"use strict";var a=M.createClass("sap.f.semantic.SemanticContainer",{constructor:function(c,p){if(!c){L.error("SemanticContainer :: missing argument - container reference",this);return;}this._oContainer=c;this._oParent=p;}});
a.prototype._getContainer=function(){return this._oContainer;};
a.prototype._getParent=function(){return this._oParent;};
a.prototype._shouldBePreprocessed=function(c){var t=(c._getType&&c._getType())||c.getMetadata().getName();return S.shouldBePreprocessed(t);};
a.prototype._getControlOrder=function(c){var t=(c._getType&&c._getType())||c.getMetadata().getName();return S.getOrder(t);};
a.prototype._getConstraints=function(c){return S.getConstraints(c.getMetadata().getName());};
a.prototype._getControl=function(c){return c._getControl?c._getControl():c;};
a.prototype._isMainAction=function(c){return S.isMainAction(c.getMetadata().getName());};
a.prototype._isNavigationAction=function(c){return S.isNavigationAction(c.getMetadata().getName());};
a.prototype._callContainerAggregationMethod=function(m){return this._getContainer()[m].apply(this._getContainer(),Array.prototype.slice.call(arguments).slice(1));};
a.prototype._sortControlByOrder=function(c,C){return this._getControlOrder(c)-this._getControlOrder(C);};
a.prototype.destroy=function(){this._oParent=null;this._oContainer=null;};
return a;},false);
sap.ui.predefine('sap/f/semantic/SemanticControl',["sap/ui/thirdparty/jquery","sap/ui/base/ManagedObject","sap/ui/core/Element","./SemanticConfiguration"],function(q,M,E,S){"use strict";
var a=E.extend("sap.f.semantic.SemanticControl",{metadata:{library:"sap.f","abstract":true,properties:{visible:{type:"boolean",group:"Appearance",defaultValue:true}},aggregations:{_control:{type:"sap.ui.core.Control",multiple:false,visibility:"hidden"}}}});
a.prototype.setProperty=function(k,v,s){M.prototype.setProperty.call(this,k,v,true);this._applyProperty(k,v,s);return this;};
a.prototype.updateAggregation=function(n){this._getControl().updateAggregation(n);};
a.prototype.refreshAggregation=function(n){this._getControl().refreshAggregation(n);};
a.prototype.setAggregation=function(A,o,s){if(A==='_control'){return M.prototype.setAggregation.call(this,A,o,s);}return this._getControl().setAggregation(A,o,s);};
a.prototype.getAggregation=function(A,d){if(A==='_control'){return M.prototype.getAggregation.call(this,A,d);}return this._getControl().getAggregation(A,d);};
a.prototype.indexOfAggregation=function(A,o){return this._getControl().indexOfAggregation(A,o);};
a.prototype.insertAggregation=function(A,o,i,s){return this._getControl().insertAggregation(A,o,i,s);};
a.prototype.addAggregation=function(A,o,s){return this._getControl().addAggregation(A,o,s);};
a.prototype.removeAggregation=function(A,o,s){return this._getControl().removeAggregation(A,o,s);};
a.prototype.removeAllAggregation=function(A,s){return this._getControl().removeAllAggregation(A,s);};
a.prototype.destroyAggregation=function(A,s){return this._getControl().destroyAggregation(A,s);};
a.prototype.bindAggregation=function(n,b){return this._getControl().bindAggregation(n,b);};
a.prototype.unbindAggregation=function(n,s){return this._getControl().unbindAggregation(n,s);};
a.prototype.clone=function(i,l){var C=E.prototype.clone.apply(this,arguments);var p=this._getControl().clone(i,l);C.setAggregation('_control',p);return C;};
a.prototype.destroy=function(){var r=E.prototype.destroy.apply(this,arguments);if(this.getAggregation("_control")){this.getAggregation("_control").destroy();}return r;};
a.prototype.getDomRef=function(s){return this._getControl().getDomRef(s);};
a.prototype.addEventDelegate=function(d,t){q.each(d,function(e,C){if(typeof C==='function'){d[e]=function(o){o.srcControl=this;C.call(t,o);}.bind(this);}}.bind(this));this._getControl().addEventDelegate(d,t);return this;};
a.prototype.removeEventDelegate=function(d){this._getControl().removeEventDelegate(d);return this;};
a.prototype._getConfiguration=function(){return S.getConfiguration(this.getMetadata().getName());};
a.prototype._applyProperty=function(k,v,s){var C=this._getControl(),b;if(C){b="set"+c(k);this._getControl()[b](v,s);}};
function c(n){return n.charAt(0).toUpperCase()+n.slice(1);}
return a;});
sap.ui.predefine('sap/f/semantic/SemanticFooter',["sap/m/ToolbarSpacer","sap/m/library","./SemanticContainer"],function(T,m,S){"use strict";var B=m.ButtonType;
var a=S.extend("sap.f.semantic.SemanticFooter",{constructor:function(c,p){S.call(this,c,p);this._aCustomContent=[];this._aSemanticLeftContent=[];this._aSemanticRightContent=[];this._iSemanticLeftContentCount=1;this._fnParentSubstitute=function(){return this._oParent;}.bind(this);this._insertSpacer();}});
a.mPlacementMethodMap={footerLeft:"LeftContent",footerRight:"RightContent"};
a.prototype.addCustomAction=function(c){c.setType(B.Transparent);this._callContainerAggregationMethod("addContent",c);this._aCustomContent.push(c);return this;};
a.prototype.insertCustomAction=function(c,i){var C=this._getCustomContentInsertIndex(i);c.setType(B.Transparent);this._callContainerAggregationMethod("insertContent",c,C);this._aCustomContent.splice(i,0,c);return this;};
a.prototype.getCustomActions=function(){return this._aCustomContent;};
a.prototype.indexOfCustomAction=function(c){return this._aCustomContent.indexOf(c);};
a.prototype.removeCustomAction=function(c){var r=this._callContainerAggregationMethod("removeContent",c);this._aCustomContent.splice(this._aCustomContent.indexOf(c),1);return r;};
a.prototype.removeAllCustomActions=function(){var r=[];this._aCustomContent.forEach(function(c){var R=this._callContainerAggregationMethod("removeContent",c);if(R){r.push(c);}},this);this._aCustomContent=[];return r;};
a.prototype.destroyCustomActions=function(){this.removeAllCustomActions(true).forEach(function(c){c.destroy();});return this;};
a.prototype.addContent=function(s,p){this["_insertSemantic"+a.mPlacementMethodMap[p]].call(this,s);return this;};
a.prototype.removeContent=function(s,p){this["_removeSemantic"+a.mPlacementMethodMap[p]].call(this,s);return this;};
a.prototype.destroy=function(){this._aCustomContent=null;this._aSemanticLeftContent=null;this._aSemanticRightContent=null;this._oSpacer=null;return S.prototype.destroy.call(this);};
a.prototype._insertSemanticLeftContent=function(s){var c=this._getControl(s),C=this._getControlOrder(s),i=this._getSemanticLeftContentInsertIndex(C);this._callContainerAggregationMethod("insertContent",c,i);this._iSemanticLeftContentCount++;this._aSemanticLeftContent.push(s);return this;};
a.prototype._insertSemanticRightContent=function(s){var c=this._getControl(s);this._aSemanticRightContent.push(s);this._callContainerAggregationMethod("insertContent",c,this._getSemanticRightContentInsertIndex(s));if(this._shouldBePreprocessed(s)){this._preProcessControl(c);}return this;};
a.prototype._removeSemanticLeftContent=function(s){var c=this._getControl(s);this._callContainerAggregationMethod("removeContent",c);this._iSemanticLeftContentCount--;this._aSemanticLeftContent.splice(this._aSemanticLeftContent.indexOf(c),1);return s;};
a.prototype._removeSemanticRightContent=function(s){var c=this._getControl(s);this._callContainerAggregationMethod("removeContent",c);this._aSemanticRightContent.splice(this._aSemanticRightContent.indexOf(s),1);this._postProcessControl(c);return s;};
a.prototype._getSemanticLeftContentInsertIndex=function(c){return this._iSemanticLeftContentCount>1?c:0;};
a.prototype._getSemanticRightContentInsertIndex=function(s){this._aSemanticRightContent.sort(this._sortControlByOrder.bind(this));return this._iSemanticLeftContentCount+this._aSemanticRightContent.indexOf(s);};
a.prototype._getCustomContentInsertIndex=function(i){return i+this._iSemanticLeftContentCount+this._aSemanticRightContent.length;};
a.prototype._insertSpacer=function(){this._callContainerAggregationMethod("addContent",this._getSpacer());return this;};
a.prototype._getSpacer=function(){if(!this._oSpacer){this._oSpacer=new T();}return this._oSpacer;};
a.prototype._preProcessControl=function(c){if(!(typeof c._fnOriginalGetParent==="function")){c._fnOriginalGetParent=c.getParent;c.getParent=this._fnParentSubstitute;}};
a.prototype._postProcessControl=function(c){if(c._fnOriginalGetParent){c.getParent=c._fnOriginalGetParent;delete c._fnOriginalGetParent;}};
return a;});
sap.ui.predefine('sap/f/semantic/SemanticPage',["sap/ui/core/Control","sap/ui/base/ManagedObject","sap/f/library","sap/f/DynamicPage","sap/f/DynamicPageTitle","sap/f/DynamicPageHeader","sap/m/OverflowToolbar","sap/m/ActionSheet","./SemanticTitle","./SemanticFooter","./SemanticShareMenu","./SemanticConfiguration","./SemanticPageRenderer"],function(C,M,l,D,a,b,O,A,S,c,d,e,f){"use strict";var g=l.DynamicPageTitleArea;
var h=C.extend("sap.f.semantic.SemanticPage",{metadata:{library:"sap.f",properties:{headerExpanded:{type:"boolean",group:"Behavior",defaultValue:true},headerPinnable:{type:"boolean",group:"Behavior",defaultValue:true},preserveHeaderStateOnScroll:{type:"boolean",group:"Behavior",defaultValue:false},toggleHeaderOnTitleClick:{type:"boolean",group:"Behavior",defaultValue:true},showFooter:{type:"boolean",group:"Behavior",defaultValue:false},titlePrimaryArea:{type:"sap.f.DynamicPageTitleArea",group:"Appearance",defaultValue:g.Begin},titleAreaShrinkRatio:{type:"sap.f.DynamicPageTitleShrinkRatio",group:"Appearance",defaultValue:"1:1.6:1.6"}},defaultAggregation:"content",aggregations:{titleHeading:{type:"sap.ui.core.Control",multiple:false,defaultValue:null,forwarding:{getter:"_getTitle",aggregation:"heading"}},titleExpandedHeading:{type:"sap.ui.core.Control",multiple:false,defaultValue:null,forwarding:{getter:"_getTitle",aggregation:"expandedHeading"}},titleSnappedHeading:{type:"sap.ui.core.Control",multiple:false,defaultValue:null,forwarding:{getter:"_getTitle",aggregation:"snappedHeading"}},titleBreadcrumbs:{type:"sap.m.IBreadcrumbs",multiple:false,defaultValue:null,forwarding:{getter:"_getTitle",aggregation:"breadcrumbs"}},titleSnappedOnMobile:{type:"sap.m.Title",multiple:false,forwarding:{getter:"_getTitle",aggregation:"snappedTitleOnMobile"}},titleSnappedContent:{type:"sap.ui.core.Control",multiple:true,forwarding:{getter:"_getTitle",aggregation:"snappedContent"}},titleExpandedContent:{type:"sap.ui.core.Control",multiple:true,forwarding:{getter:"_getTitle",aggregation:"expandedContent"}},titleContent:{type:"sap.ui.core.Control",multiple:true,forwarding:{getter:"_getTitle",aggregation:"content"}},titleMainAction:{type:"sap.f.semantic.TitleMainAction",multiple:false},editAction:{type:"sap.f.semantic.EditAction",multiple:false},deleteAction:{type:"sap.f.semantic.DeleteAction",multiple:false},copyAction:{type:"sap.f.semantic.CopyAction",multiple:false},addAction:{type:"sap.f.semantic.AddAction",multiple:false},flagAction:{type:"sap.f.semantic.FlagAction",multiple:false},favoriteAction:{type:"sap.f.semantic.FavoriteAction",multiple:false},fullScreenAction:{type:"sap.f.semantic.FullScreenAction",multiple:false},exitFullScreenAction:{type:"sap.f.semantic.ExitFullScreenAction",multiple:false},closeAction:{type:"sap.f.semantic.CloseAction",multiple:false},titleCustomTextActions:{type:"sap.m.Button",multiple:true},titleCustomIconActions:{type:"sap.m.OverflowToolbarButton",multiple:true},headerContent:{type:"sap.ui.core.Control",multiple:true,forwarding:{getter:"_getHeader",aggregation:"content"}},content:{type:"sap.ui.core.Control",multiple:false},footerMainAction:{type:"sap.f.semantic.FooterMainAction",multiple:false},messagesIndicator:{type:"sap.f.semantic.MessagesIndicator",multiple:false},draftIndicator:{type:"sap.m.DraftIndicator",multiple:false},positiveAction:{type:"sap.f.semantic.PositiveAction",multiple:false},negativeAction:{type:"sap.f.semantic.NegativeAction",multiple:false},footerCustomActions:{type:"sap.m.Button",multiple:true},discussInJamAction:{type:"sap.f.semantic.DiscussInJamAction",multiple:false},saveAsTileAction:{type:"sap.m.Button",multiple:false},shareInJamAction:{type:"sap.f.semantic.ShareInJamAction",multiple:false},sendMessageAction:{type:"sap.f.semantic.SendMessageAction",multiple:false},sendEmailAction:{type:"sap.f.semantic.SendEmailAction",multiple:false},printAction:{type:"sap.f.semantic.PrintAction",multiple:false},customShareActions:{type:"sap.m.Button",multiple:true},landmarkInfo:{type:"sap.f.DynamicPageAccessibleLandmarkInfo",multiple:false,forwarding:{getter:"_getPage",aggregation:"landmarkInfo"}},_dynamicPage:{type:"sap.f.DynamicPage",multiple:false,visibility:"hidden"}},dnd:{draggable:false,droppable:true},designtime:"sap/f/designtime/SemanticPage.designtime"}});
h._EVENTS={SHARE_MENU_CONTENT_CHANGED:"_shareMenuContentChanged"};h._SAVE_AS_TILE_ACTION="saveAsTileAction";h.CONTENT_PADDING_CLASSES_TO_FORWARD={"sapUiNoContentPadding":true,"sapUiContentPadding":true,"sapUiResponsiveContentPadding":true};
h.prototype.init=function(){this._bSPBeingDestroyed=false;this._initDynamicPage();this._attachShareMenuButtonChange();this._fnActionSubstituteParentFunction=function(){return this;}.bind(this);};
h.prototype.exit=function(){this._bSPBeingDestroyed=true;this._cleanMemory();};
h.prototype.setHeaderExpanded=function(H){this._getPage().setHeaderExpanded(H);return this;};
h.prototype.getHeaderExpanded=function(){return this._getPage().getHeaderExpanded();};
h.prototype.setHeaderPinnable=function(H){var o=this._getPage(),i=o.getHeader();i.setPinnable(H);return this.setProperty("headerPinnable",i.getPinnable(),true);};
h.prototype.setPreserveHeaderStateOnScroll=function(p){var o=this._getPage();o.setPreserveHeaderStateOnScroll(p);return this.setProperty("preserveHeaderStateOnScroll",o.getPreserveHeaderStateOnScroll(),true);};
h.prototype.setToggleHeaderOnTitleClick=function(t){this._getPage().setToggleHeaderOnTitleClick(t);return this.setProperty("toggleHeaderOnTitleClick",t,true);};
h.prototype.setShowFooter=function(s){this._getPage().setShowFooter(s);return this.setProperty("showFooter",s,true);};
h.prototype.setTitlePrimaryArea=function(p){var o=this._getTitle();o.setPrimaryArea(p);return this.setProperty("titlePrimaryArea",o.getPrimaryArea(),true);};
h.prototype.setTitleAreaShrinkRatio=function(s){var o=this._getTitle();o.setAreaShrinkRatio(s);return this.setProperty("titleAreaShrinkRatio",o.getAreaShrinkRatio(),true);};
h.prototype.addStyleClass=function(s,i){var o=this.getAggregation("_dynamicPage");if(h.CONTENT_PADDING_CLASSES_TO_FORWARD[s]){o.addStyleClass(s,true);}return C.prototype.addStyleClass.call(this,s,i);};
h.prototype.removeStyleClass=function(s,i){var o=this.getAggregation("_dynamicPage");if(h.CONTENT_PADDING_CLASSES_TO_FORWARD[s]){o.removeStyleClass(s,true);}return C.prototype.removeStyleClass.call(this,s,i);};
h.prototype.setAggregation=function(s,o,i){var j=this.mAggregations[s],t,p;if(j===o){return this;}o=this.validateAggregation(s,o,false);if(s===h._SAVE_AS_TILE_ACTION){t=h._SAVE_AS_TILE_ACTION;}else{t=this.getMetadata().getManagedAggregation(s).type;}if(e.isKnownSemanticType(t)){p=e.getPlacement(t);if(j){this._onRemoveAggregation(j,t);this._getSemanticContainer(p).removeContent(j,p);}if(o){o._getType=function(){return t;};this._getSemanticContainer(p).addContent(o,p);this._onAddAggregation(o,t);}return M.prototype.setAggregation.call(this,s,o,true);}return M.prototype.setAggregation.call(this,s,o,i);};
h.prototype.destroyAggregation=function(s,i){var o=this.getMetadata().getAggregations()[s],j,p,t;if(s===h._SAVE_AS_TILE_ACTION){t=h._SAVE_AS_TILE_ACTION;}else{t=o&&o.type;}if(t&&e.isKnownSemanticType(t)){j=M.prototype.getAggregation.call(this,s);if(j){p=e.getPlacement(t);this._onRemoveAggregation(j,t);!this._bSPBeingDestroyed&&this._getSemanticContainer(p).removeContent(j,p);}}return M.prototype.destroyAggregation.call(this,s,i);};
["getContent","setContent","destroyContent"].forEach(function(m){var i=/^(set|destroy)/.test(m);h.prototype[m]=function(o){var j=this._getPage();var r=j[m].apply(j,arguments);return i?this:r;};},this);["addTitleCustomTextAction","insertTitleCustomTextAction","indexOfTitleCustomTextAction","removeTitleCustomTextAction","removeAllTitleCustomTextActions","destroyTitleCustomTextActions","getTitleCustomTextActions"].forEach(function(m){var i=/^(add|insert|destroy)/.test(m);h.prototype[m]=function(){var s=this._getSemanticTitle(),j=m.replace(/TitleCustomTextAction?/,"CustomTextAction"),r;r=s[j].apply(s,arguments);return i?this:r;};},this);["addTitleCustomIconAction","insertTitleCustomIconAction","indexOfTitleCustomIconAction","removeTitleCustomIconAction","removeAllTitleCustomIconActions","destroyTitleCustomIconActions","getTitleCustomIconActions"].forEach(function(m){var i=/^(add|insert|destroy)/.test(m);h.prototype[m]=function(){var s=this._getSemanticTitle(),j=m.replace(/TitleCustomIconAction?/,"CustomIconAction"),r;r=s[j].apply(s,arguments);return i?this:r;};},this);["addFooterCustomAction","insertFooterCustomAction","indexOfFooterCustomAction","removeFooterCustomAction","removeAllFooterCustomActions","destroyFooterCustomActions","getFooterCustomActions"].forEach(function(m){var i=/^(add|insert|destroy)/.test(m);h.prototype[m]=function(){var s=this._getSemanticFooter(),j=m.replace(/FooterCustomAction?/,"CustomAction"),r;r=s[j].apply(s,arguments);return i?this:r;};},this);["addCustomShareAction","insertCustomShareAction","indexOfCustomShareAction","removeCustomShareAction","removeAllCustomShareActions","destroyCustomShareActions","getCustomShareActions"].forEach(function(m){var i=/^(add|insert|destroy)/.test(m);h.prototype[m]=function(){var s=this._getShareMenu(),j=m.replace(/CustomShareAction?/,"CustomAction"),r;r=s[j].apply(s,arguments);return i?this:r;};},this);
h.prototype._onAddAggregation=function(o,t){if(t===h._SAVE_AS_TILE_ACTION){this._replaceParent(o);}};
h.prototype._onRemoveAggregation=function(o,t){if(t===h._SAVE_AS_TILE_ACTION){this._restoreParent(o);}if(o._getType){delete o._getType;}};
h.prototype._replaceParent=function(o){if(o._fnOriginalGetParent){return;}o._fnOriginalGetParent=o.getParent;o.getParent=this._fnActionSubstituteParentFunction;};
h.prototype._restoreParent=function(o){if(o&&o._fnOriginalGetParent){o.getParent=o._fnOriginalGetParent;}};
h.prototype._attachShareMenuButtonChange=function(){this.attachEvent(h._EVENTS.SHARE_MENU_CONTENT_CHANGED,this._onShareMenuContentChanged,this);};
h.prototype._onShareMenuContentChanged=function(E){var s=E.getParameter("bEmpty"),o=this._getSemanticTitle(),i=this._getShareMenu(),j=i._getShareMenuButton();if(!j.getParent()){o.addContent(j,"shareIcon");return;}j.setVisible(!s);};
h.prototype._getPage=function(){if(!this.getAggregation("_dynamicPage")){this._initDynamicPage();}return this.getAggregation("_dynamicPage");};
h.prototype._initDynamicPage=function(){this.setAggregation("_dynamicPage",new D(this.getId()+"-page",{title:this._getTitle(),header:this._getHeader(),footer:this._getFooter()}),true);};
h.prototype._getTitle=function(){if(!this._oDynamicPageTitle){this._oDynamicPageTitle=this._getSemanticTitle()._getContainer();}return this._oDynamicPageTitle;};
h.prototype._getHeader=function(){if(!this._oDynamicPageHeader){this._oDynamicPageHeader=new b(this.getId()+"-pageHeader");}return this._oDynamicPageHeader;};
h.prototype._getFooter=function(){if(!this._oDynamicPageFooter){this._oDynamicPageFooter=this._getSemanticFooter()._getContainer();}return this._oDynamicPageFooter;};
h.prototype._getSemanticTitle=function(){if(!this._oSemanticTitle){this._oSemanticTitle=new S(new a(this.getId()+"-pageTitle"),this);}return this._oSemanticTitle;};
h.prototype._getShareMenu=function(){if(!this._oShareMenu){this._oShareMenu=new d(this._getActionSheet(),this);this.addDependent(this._oShareMenu._oContainer);}return this._oShareMenu;};
h.prototype._getActionSheet=function(){if(!this._oActionSheet){this._oActionSheet=new A(this.getId()+"-shareMenu");}return this._oActionSheet;};
h.prototype._getSemanticFooter=function(){if(!this._oSemanticFooter){this._oSemanticFooter=new c(this._getOverflowToolbar(),this);}return this._oSemanticFooter;};
h.prototype._getOverflowToolbar=function(){if(!this._oOverflowToolbar){this._oOverflowToolbar=new O(this.getId()+"-pageFooter");}return this._oOverflowToolbar;};
h.prototype._getSemanticContainer=function(p){var P=e._Placement;if(p===P.titleText||p===P.titleIcon){return this._getSemanticTitle();}else if(p===P.footerLeft||p===P.footerRight){return this._getSemanticFooter();}else if(p===P.shareMenu){return this._getShareMenu();}return null;};
h.prototype._cleanMemory=function(){if(this._oShareMenu){this._oShareMenu.destroy();this._oShareMenu=null;}if(this._oActionSheet){this._oActionSheet.destroy();this._oActionSheet=null;}if(this._oSemanticTitle){this._oSemanticTitle.destroy();this._oSemanticTitle=null;}if(this._oDynamicPageTitle){this._oDynamicPageTitle.destroy();this._oDynamicPageTitle=null;}if(this._oDynamicPageHeader){this._oDynamicPageHeader.destroy();this._oDynamicPageHeader=null;}if(this._oSemanticFooter){this._oSemanticFooter.destroy();this._oSemanticFooter=null;}if(this._oDynamicPageFooter){this._oDynamicPageFooter.destroy();this._oDynamicPageFooter=null;}if(this._oOverflowToolbar){this._oOverflowToolbar.destroy();this._oOverflowToolbar=null;}};
return h;});
sap.ui.predefine('sap/f/semantic/SemanticPageRenderer',[],function(){"use strict";var S={apiVersion:2};
S.render=function(r,s){r.openStart("div",s);r.class("sapFSemanticPage");r.openEnd();r.renderControl(s._getPage());r.close("div");};
return S;},true);
sap.ui.predefine('sap/f/semantic/SemanticShareMenu',["sap/ui/core/IconPool","sap/ui/base/EventProvider","sap/m/library","sap/m/OverflowToolbarButton","sap/m/OverflowToolbarLayoutData","./SemanticContainer"],function(I,E,m,O,a,S){"use strict";var B=m.ButtonType;
var b=S.extend("sap.f.semantic.SemanticShareMenu",{constructor:function(c,p){S.call(this,c,p);this._aShareMenuActions=[];this._aCustomShareActions=[];this._setMode(b._Mode.initial);}});
b._Mode={initial:"initial",menu:"menu"};
b.prototype.addCustomAction=function(c){this._onControlAdded(c);this._callContainerAggregationMethod("insertButton",c,this._getCustomActionInsertIndex());this._aCustomShareActions.push(c);return this;};
b.prototype.insertCustomAction=function(c,i){this._onControlAdded(c);this._callContainerAggregationMethod("insertButton",c,this._getCustomActionInsertIndex(i));this._aCustomShareActions.splice(i,0,c);return this;};
b.prototype.getCustomActions=function(){return this._aCustomShareActions;};
b.prototype.indexOfCustomAction=function(c){return this._aCustomShareActions.indexOf(c);};
b.prototype.removeCustomAction=function(c){var r=this._callContainerAggregationMethod("removeButton",c);this._aCustomShareActions.splice(this._aCustomShareActions.indexOf(c),1);this._onControlRemoved();return r;};
b.prototype.removeAllCustomActions=function(){var r=[];this._aCustomShareActions.forEach(function(c){var R=this._callContainerAggregationMethod("removeButton",c);if(R){r.push(c);}},this);this._aCustomShareActions=[];this._onControlRemoved();return r;};
b.prototype.destroyCustomActions=function(){this.removeAllCustomActions(true).forEach(function(c){c.destroy();});return this;};
b.prototype.addContent=function(s){var c=this._getControl(s);this._onControlAdded(c);this._aShareMenuActions.push(s);this._preProcessOverflowToolbarButton(c);this._callContainerAggregationMethod("insertButton",c,this._getSemanticActionInsertIndex(s));return this;};
b.prototype.removeContent=function(s){var c=this._getControl(s);this._callContainerAggregationMethod("removeButton",c);this._aShareMenuActions.splice(this._aShareMenuActions.indexOf(s),1);this._postProcessOverflowToolbarButton(s);this._onControlRemoved();return this;};
b.prototype.destroy=function(){this._oShareMenuBtn=null;this._aShareMenuActions=null;this._aCustomShareActions=null;return S.prototype.destroy.call(this);};
b.prototype._getMode=function(){return this._mode;};
b.prototype._setMode=function(M){if(this._getMode()===M){return this;}if(M===b._Mode.initial){if(this._getMode()){this._fireContentChanged(true);}this._mode=b._Mode.initial;return this;}if(M===b._Mode.menu){this._mode=b._Mode.menu;this._fireContentChanged(false);}return this;};
b.prototype._fireContentChanged=function(e){E.prototype.fireEvent.call(this._getParent(),"_shareMenuContentChanged",{"bEmpty":e});};
b.prototype._getShareMenuButton=function(){var c=this._getContainer();if(!this._oShareMenuBtn){this._oShareMenuBtn=new O(c.getId()+"-shareButton",{icon:I.getIconURI("action"),tooltip:sap.ui.getCore().getLibraryResourceBundle("sap.f").getText("SEMANTIC_CONTROL_ACTION_SHARE"),layoutData:new a({closeOverflowOnInteraction:false}),text:sap.ui.getCore().getLibraryResourceBundle("sap.f").getText("SEMANTIC_CONTROL_ACTION_SHARE"),type:B.Transparent,press:function(){c.openBy(this._oShareMenuBtn);}.bind(this)});this._oShareMenuBtn.addEventDelegate({onAfterRendering:function(){this._oShareMenuBtn.$().attr("aria-haspopup",true);}.bind(this)},this);}return this._oShareMenuBtn;};
b.prototype._getCustomActionInsertIndex=function(i){var c=this._aCustomShareActions.length;if(i===undefined){return this._aShareMenuActions.length+c;}i=i>=c?c:i;i+=this._aShareMenuActions.length;return i;};
b.prototype._getSemanticActionInsertIndex=function(s){this._aShareMenuActions.sort(this._sortControlByOrder.bind(this));return this._aShareMenuActions.indexOf(s);};
b.prototype._onControlAdded=function(c){if(this._isInitialMode()){this._setMode(b._Mode.menu,c);}};
b.prototype._onControlRemoved=function(){var A=this._aShareMenuActions.length,c=this._aCustomShareActions.length,e=(A+c)===0;if(this._isMenuMode()&&e){this._setMode(b._Mode.initial);}};
b.prototype._preProcessOverflowToolbarButton=function(o){if(o instanceof O){o._bInOverflow=true;}};
b.prototype._postProcessOverflowToolbarButton=function(o){if(o instanceof O){delete o._bInOverflow;}};
b.prototype._isInitialMode=function(){return this._getMode()===b._Mode.initial;};
b.prototype._isMenuMode=function(){return this._getMode()===b._Mode.menu;};
return b;});
sap.ui.predefine('sap/f/semantic/SemanticTitle',["sap/m/library","./SemanticContainer"],function(m,S){"use strict";var B=m.ButtonType;
var a=S.extend("sap.f.semantic.SemanticTitle",{constructor:function(c,p){S.call(this,c,p);this._iMainActionCount=0;this._aSemanticTextActions=[];this._aSemanticSimpleIconActions=[];this._aSemanticNavIconActions=[];this._aCustomTextActions=[];this._aCustomIconActions=[];}});
a.mPlacementMethodMap={titleText:"TextContent",titleIcon:"IconContent",shareIcon:"ShareContent"};
a.prototype.addContent=function(s,p){this["_insertSemantic"+a.mPlacementMethodMap[p]].call(this,s);return this;};
a.prototype.removeContent=function(s,p){this["_removeSemantic"+a.mPlacementMethodMap[p]].call(this,s);return this;};
a.prototype.destroy=function(){this._aSemanticSimpleIconActions=null;this._aSemanticTextActions=null;this._aCustomTextActions=null;this._aCustomIconActions=null;this._aSemanticNavIconActions=null;return S.prototype.destroy.call(this);};
a.prototype.addCustomTextAction=function(c){c.setType(B.Transparent);this._callContainerAggregationMethod("insertAction",c,this._getCustomTextActionInsertIndex());this._aCustomTextActions.push(c);return this;};
a.prototype.insertCustomTextAction=function(c,i){c.setType(B.Transparent);this._callContainerAggregationMethod("insertAction",c,this._getCustomTextActionInsertIndex(i));this._aCustomTextActions.splice(i,0,c);return this;};
a.prototype.indexOfCustomTextAction=function(c){return this._aCustomTextActions.indexOf(c);};
a.prototype.removeCustomTextAction=function(c){var i=this._aCustomTextActions.indexOf(c),r=this._callContainerAggregationMethod("removeAction",c);this._aCustomTextActions.splice(i,1);return r;};
a.prototype.removeAllCustomTextActions=function(){var r=[];this._aCustomTextActions.forEach(function(c){var R=this._callContainerAggregationMethod("removeAction",c);if(R){r.push(c);}},this);this._aCustomTextActions=[];return r;};
a.prototype.destroyCustomTextActions=function(){this.removeAllCustomTextActions().forEach(function(c){c.destroy();});return this;};
a.prototype.getCustomTextActions=function(){return this._aCustomTextActions;};
a.prototype.addCustomIconAction=function(c){c.setType(B.Transparent);this._callContainerAggregationMethod("insertAction",c,this._getCustomIconActionInsertIndex());this._aCustomIconActions.push(c);return this;};
a.prototype.insertCustomIconAction=function(c,i){c.setType(B.Transparent);this._callContainerAggregationMethod("insertAction",c,this._getCustomIconActionInsertIndex(i));this._aCustomIconActions.splice(i,0,c);return this;};
a.prototype.indexOfCustomIconAction=function(c){return this._aCustomIconActions.indexOf(c);};
a.prototype.removeCustomIconAction=function(c){var i=this._aCustomIconActions.indexOf(c),r=this._callContainerAggregationMethod("removeAction",c);this._aCustomIconActions.splice(i,1);return r;};
a.prototype.removeAllCustomIconActions=function(){var r=[];this._aCustomIconActions.forEach(function(c){var R=this._callContainerAggregationMethod("removeAction",c);if(R){r.push(c);}},this);this._aCustomIconActions=[];return r;};
a.prototype.destroyCustomIconActions=function(){this.removeAllCustomIconActions().forEach(function(c){c.destroy();});return this;};
a.prototype.getCustomIconActions=function(){return this._aCustomIconActions;};
a.prototype._insertSemanticTextContent=function(s){var c=this._getControl(s),i=this._isMainAction(s),I;this._aSemanticTextActions.push(s);if(i){this._iMainActionCount++;I=this._getSemanticTextMainActionInsertIndex();}else{I=this._getSemanticTextActionInsertIndex(s);}this._callContainerAggregationMethod("insertAction",c,I);return this;};
a.prototype._removeSemanticTextContent=function(s){var c=this._getControl(s),C=this._aSemanticTextActions.indexOf(s),i=this._isMainAction(s);if(i){this._iMainActionCount--;}this._aSemanticTextActions.splice(C,1);this._callContainerAggregationMethod("removeAction",c);return this;};
a.prototype._insertSemanticIconContent=function(s){var c=this._getControl(s),C,i;if(this._isNavigationAction(s)){this._aSemanticNavIconActions.push(s);i=this._getSemanticNavIconActionInsertIndex(s);C="insertNavigationAction";}else{this._aSemanticSimpleIconActions.push(s);i=this._getSemanticSimpleIconActionInsertIndex(s);C="insertAction";}this._callContainerAggregationMethod(C,c,i);return this;};
a.prototype._removeSemanticIconContent=function(s){var c=this._getControl(s),C,i;if(this._isNavigationAction(s)){i=this._aSemanticNavIconActions.indexOf(s);this._aSemanticNavIconActions.splice(i,1);C="removeNavigationAction";}else{i=this._aSemanticTextActions.indexOf(s);this._aSemanticSimpleIconActions.splice(i,1);C="removeAction";}this._callContainerAggregationMethod(C,c);return this;};
a.prototype._insertSemanticShareContent=function(s){var c=this._getControl(s),i=this._getSemanticShareMenuInsertIndex();this._callContainerAggregationMethod("insertAction",c,i);return this;};
a.prototype._removeSemanticShareContent=function(s){var c=this._getControl(s);this._callContainerAggregationMethod("removeAction",c);return this;};
a.prototype._getSemanticTextMainActionInsertIndex=function(){return 0;};
a.prototype._getCustomTextActionInsertIndex=function(i){var c=this._aCustomTextActions.length;if(i===undefined){return this._iMainActionCount+c;}i=i>=c?c:i;i+=this._iMainActionCount;return i;};
a.prototype._getSemanticTextActionInsertIndex=function(s){this._aSemanticTextActions.sort(this._sortControlByOrder.bind(this));return this._getCustomTextActionInsertIndex()+this._aSemanticTextActions.indexOf(s)-this._iMainActionCount;};
a.prototype._getCustomIconActionInsertIndex=function(i){var c=this._aCustomIconActions.length,p=this._aCustomTextActions.length+this._aSemanticTextActions.length;if(i===undefined){return p+c;}i=i>=c?c:i;i+=p;return i;};
a.prototype._getSemanticSimpleIconActionInsertIndex=function(s){this._aSemanticSimpleIconActions.sort(this._sortControlByOrder.bind(this));return this._getCustomIconActionInsertIndex()+this._aSemanticSimpleIconActions.indexOf(s);};
a.prototype._getSemanticNavIconActionInsertIndex=function(s){this._aSemanticNavIconActions.sort(this._sortControlByOrder.bind(this));return this._aSemanticNavIconActions.indexOf(s);};
a.prototype._getSemanticShareMenuInsertIndex=function(){return this._callContainerAggregationMethod("getActions").length;};
a.prototype._getContainerBar=function(){var c=this._getContainer();if(c){return c.getAggregation("_overflowToolbar");}return null;};
return a;});
sap.ui.predefine('sap/f/semantic/SemanticToggleButton',['./SemanticButton','sap/m/library',"sap/ui/events/KeyCodes"],function(S,m,K){"use strict";var B=m.ButtonType;
var a=S.extend("sap.f.semantic.SemanticToggleButton",{metadata:{library:"sap.f","abstract":true,properties:{pressed:{type:"boolean",group:"Data",defaultValue:false}}}});
a.prototype._onTap=function(e){e.setMarked();if(this.getEnabled()){this.setPressed(!this.getPressed());this.firePress({pressed:this.getPressed()});}};
a.prototype._onKeydown=function(e){if(e.which===K.SPACE||e.which===K.ENTER){this._onTap(e);}};
a.prototype._applyProperty=function(p,v,s){if(p==='pressed'){this._setPressed(v,s);}else{S.prototype._applyProperty.apply(this,arguments);}};
a.prototype._setPressed=function(p,s){var b=p?B.Emphasized:B.Transparent;this._getControl().setType(b,s);};
a.prototype._createInstance=function(c){var i=new c({id:this.getId()+"-toggleButton"});i.addEventDelegate({ontap:this._onTap,onkeydown:this._onKeydown},this);return i;};
return a;});
sap.ui.predefine('sap/f/semantic/SendEmailAction',['sap/f/semantic/SemanticButton'],function(S){"use strict";
var a=S.extend("sap.f.semantic.SendEmailAction",{metadata:{library:"sap.f"}});
return a;});
sap.ui.predefine('sap/f/semantic/SendMessageAction',['sap/f/semantic/SemanticButton'],function(S){"use strict";
var a=S.extend("sap.f.semantic.SendMessageAction",{metadata:{library:"sap.f"}});
return a;});
sap.ui.predefine('sap/f/semantic/ShareInJamAction',['sap/f/semantic/SemanticButton'],function(S){"use strict";
var a=S.extend("sap.f.semantic.ShareInJamAction",{metadata:{library:"sap.f"}});
return a;});
sap.ui.predefine('sap/f/semantic/TitleMainAction',["./MainAction"],function(M){"use strict";
var T=M.extend("sap.f.semantic.TitleMainAction",{metadata:{library:"sap.f"}});
return T;});
sap.ui.predefine('sap/f/shellBar/Accessibility',["sap/ui/core/Core"],function(C){"use strict";var A=function(c){if(c){this._oControl=c;this._oControl.addDelegate(this._controlDelegate,false,this);}this.oRb=C.getLibraryResourceBundle("sap.f");};A.prototype._controlDelegate={onBeforeRendering:function(){this.attachDelegates();}};
A.prototype.attachDelegates=function(){this._oDelegateSecondTitle={onAfterRendering:this.onAfterRenderingSecondTitle};this._oDelegateSearch={onAfterRendering:this.onAfterRenderingSearch};this._oDelegateNotifications={onAfterRendering:this.onAfterRenderingNotifications};this._oDelegateAvatar={onAfterRendering:this.onAfterRenderingAvatar};this._oDelegateProducts={onAfterRendering:this.onAfterRenderingProducts};this._oDelegateNavButton={onAfterRendering:this.onAfterRenderingNavButton};this._oDelegateMenuButton={onAfterRendering:this.onAfterRenderingMenuButton};if(this._oControl._oSecondTitle){this._oControl._oSecondTitle.addDelegate(this._oDelegateSecondTitle,false,this);}if(this._oControl._oSearch){this._oControl._oSearch.addDelegate(this._oDelegateSearch,false,this);}if(this._oControl._oNotifications){this._oControl._oNotifications.addDelegate(this._oDelegateNotifications,false,this);}if(this._oControl._oAvatarButton){this._oControl._oAvatarButton.addDelegate(this._oDelegateAvatar,false,this);}if(this._oControl._oProductSwitcher){this._oControl._oProductSwitcher.addDelegate(this._oDelegateProducts,false,this);}if(this._oControl._oNavButton){this._oControl._oNavButton.addDelegate(this._oDelegateNavButton,false,this);}if(this._oControl._oMenuButton){this._oControl._oMenuButton.addDelegate(this._oDelegateMenuButton,false,this);}};
A.prototype.getRootAttributes=function(){return{role:"banner",label:this.oRb.getText("SHELLBAR_CONTAINER_LABEL")};};
A.prototype.getCoPilotAttributes=function(){return{role:"button",label:this.oRb.getText("SHELLBAR_COPILOT_TOOLTIP")};};
A.prototype.getEntityTooltip=function(e){return this.oRb.getText("SHELLBAR_"+e+"_TOOLTIP")||"";};
A.prototype.updateNotificationsNumber=function(n){var t=this.getEntityTooltip("NOTIFICATIONS"),a=n?n+" "+t:t;this._oControl._oNotifications.setTooltip(a);this._oControl._oNotifications.$().attr("aria-label",a);};
A.prototype.onAfterRenderingSecondTitle=function(){var $=this._oControl._oSecondTitle.$();$.attr("role","heading");$.attr("aria-level","2");};
A.prototype.onAfterRenderingSearch=function(){this._oControl._oSearch.$().attr("aria-label",this.getEntityTooltip("SEARCH"));};
A.prototype.onAfterRenderingNotifications=function(){var $=this._oControl._oNotifications.$(),t=this.getEntityTooltip("NOTIFICATIONS"),n=this._oControl._oNotifications.data("notifications"),a=n?n+" "+t:t;$.attr("aria-label",a);$.attr("aria-haspopup","dialog");};
A.prototype.onAfterRenderingAvatar=function(){var $=this._oControl._oAvatarButton.$();$.attr("aria-label",this.getEntityTooltip("PROFILE"));$.attr("aria-haspopup","menu");};
A.prototype.onAfterRenderingProducts=function(){var $=this._oControl._oProductSwitcher.$();$.attr("aria-label",this.getEntityTooltip("PRODUCTS"));$.attr("aria-haspopup","menu");};
A.prototype.onAfterRenderingNavButton=function(){this._oControl._oNavButton.$().attr("aria-label",this.getEntityTooltip("BACK"));};
A.prototype.onAfterRenderingMenuButton=function(){var $=this._oControl._oMenuButton.$();$.attr("aria-label",this.getEntityTooltip("MENU"));$.attr("aria-haspopup","menu");};
A.prototype.exit=function(){if(this._oControl){this._oControl.removeDelegate(this._controlDelegate);}if(this._oControl._oSecondTitle){this._oControl._oSecondTitle.removeDelegate(this._oDelegateSecondTitle);}if(this._oControl._oSearch){this._oControl._oSearch.removeDelegate(this._oDelegateSearch);}if(this._oControl._oNotifications){this._oControl._oNotifications.removeDelegate(this._oDelegateNotifications);}if(this._oControl._oAvatarButton){this._oControl._oAvatarButton.removeDelegate(this._oDelegateAvatar);}if(this._oControl._oProductSwitcher){this._oControl._oProductSwitcher.removeDelegate(this._oDelegateProducts);}if(this._oControl._oNavButton){this._oControl._oNavButton.removeDelegate(this._oDelegateNavButton);}if(this._oControl._oMenuButton){this._oControl._oMenuButton.removeDelegate(this._oDelegateMenuButton);}};
return A;});
sap.ui.predefine('sap/f/shellBar/AdditionalContentSupport',["sap/m/OverflowToolbarLayoutData","sap/base/Log","sap/m/library"],function(O,L,l){"use strict";var a=l.OverflowToolbarPriority;var A=function(){if(!this.isA("sap.ui.core.Element")){return;}this._prepareNewAdditionalControl=function(c){if(!c.getLayoutData()){c.setLayoutData(new O({priority:a.Low}));}return c;};this.addAdditionalContent=function(c){if(!this._aAdditionalContent){this._aAdditionalContent=[];}this._aAdditionalContent.push(this._prepareNewAdditionalControl(c));this._bOTBUpdateNeeded=true;return this;};this.insertAdditionalContent=function(c,I){var i;if(!this._aAdditionalContent){this._aAdditionalContent=[];}if(I<0){i=0;}else if(I>this._aAdditionalContent.length){i=this._aAdditionalContent.length;}else{i=I;}this._aAdditionalContent.splice(i,0,c);this._bOTBUpdateNeeded=true;return this;};this.indexOfAdditionalContent=function(c){for(var i=0;i<this._aAdditionalContent.length;i++){if(this._aAdditionalContent[i]===c){return i;}}return-1;};this.removeAdditionalContent=function(o){var c,i;if(typeof(o)==="string"){for(i=0;i<this._aAdditionalContent.length;i++){if(this._aAdditionalContent[i]&&this._aAdditionalContent[i].getId()===o){o=i;break;}}}if(typeof(o)==="object"){for(i=0;i<this._aAdditionalContent.length;i++){if(this._aAdditionalContent[i]===o){o=i;break;}}}if(typeof(o)==="number"){if(o<0||o>=this._aAdditionalContent.length){L.warning("ShellBar.removeAggregation called with invalid index: AdditionalContent, "+o);}else{c=this._aAdditionalContent[o];this._aAdditionalContent.splice(o,1);c.setParent(null);}}};this.destroyAdditionalContent=function(c){return this;};this.getAdditionalContent=function(){return this._aAdditionalContent;};};return A;},false);
sap.ui.predefine('sap/f/shellBar/CoPilot',["sap/ui/core/Control","sap/ui/core/Configuration","sap/f/shellBar/CoPilotRenderer"],function(C,a,b){"use strict";
var c=C.extend("sap.f.shellBar.CoPilot",{
metadata:{library:"sap.f",events:{press:{}}},
renderer:b
});
c.prototype.ontap=function(e){e.setMarked();this.firePress({});};
c.prototype.getAnimation=function(){return sap.ui.getCore().getConfiguration().getAnimationMode()!==a.AnimationMode.none;};
return c;});
sap.ui.predefine('sap/f/shellBar/CoPilotRenderer',['./Accessibility'],function(A){"use strict";var C={};
C.render=function(r,c){var a=new A(),o=a.getCoPilotAttributes(),t=c.getTooltip();r.write("<div");r.writeAttribute("tabindex","0");if(t){r.writeAttributeEscaped("title",t);}r.writeAccessibilityState({role:o.role,label:o.label});r.writeControlData(c);r.addClass("CPImage");r.writeStyles();r.writeClasses();r.write(">");if(c.getAnimation()){r.write('<svg focusable="false" version="1.1" width="48" height="48" viewBox="-150 -150 300 300" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink"><defs><linearGradient id="grad1" x1="0%" x2="100%" y1="100%" y2="0%"><stop class="color1" offset="0%" style="stop-opacity:0.7"/><stop class="color2" offset="80%" style="stop-opacity:0.7"/></linearGradient><linearGradient id="grad2" x1="0%" x2="100%" y1="100%" y2="0%"><stop class="color1" offset="0%" style="stop-opacity:0.36"/><stop class="color2" offset="80%" style="stop-opacity:0.36"/></linearGradient><linearGradient id="grad3" x1="0%" x2="100%" y1="100%" y2="0%"><stop class="color1" offset="0%" style="stop-opacity:0.2"/><stop class="color2" offset="80%" style="stop-opacity:0.2"/></linearGradient><mask id="innerCircle"><circle cx="0" cy="0" r="120" fill="white" /><circle cx="0" cy="0" r="76" fill="black" /></mask><path id="path" d="M 98.1584 0 C 98.3156 17.3952 89.0511 31.3348 79.5494 45.9279 C 70.339 60.0814 60.6163 71.2177 46.1724 79.9729 C 31.4266 88.9178 17.2493 94.3909 5.77261e-15 94.2739 C -17.1547 94.1581 -30.8225 87.6907 -45.7979 79.3244 C -61.0143 70.8266 -73.5583 62.554 -83.0507 47.9493 C -92.6677 33.1579 -98.4872 17.5705 -97.1793 1.19010e-14 C -95.9465 -16.9777 -84.488 -29.0862 -76.1351 -43.9566 C -67.6795 -59.0155 -63.8629 -76.1085 -49.262 -85.3243 C -34.502 -94.6464 -17.4328 -93.0037 -1.69174e-14 -92.0939 C 16.8967 -91.214 31.8608 -89.0341 46.4198 -80.4014 C 60.872 -71.8326 69.6003 -59.5351 78.6792 -45.4254 C 88.0511 -30.9104 98.015 -17.2766 98.1584 0 Z"><animate id="animate0" attributeName="d" values="M 102 0 C 102 17.85951467281289, 86.87204367700592 29.533206594083104, 77.94228634059948 44.99999999999999 C 69.01252900419304 60.46679340591688, 66.4667934059169 79.40483384960629, 51.000000000000014 88.33459118601273 C 35.53320659408312 97.26434852241918, 17.859514672812903 90, 5.5109105961630896e-15 90 C -17.85951467281288 90, -35.53320659408308 97.26434852241918, -50.99999999999998 88.33459118601274 C -66.46679340591687 79.4048338496063, -69.01252900419303 60.46679340591692, -77.94228634059947 45.00000000000003 C -86.87204367700592 29.533206594083133, -102 17.859514672812914, -102 1.2491397351303002e-14 C -102 -17.85951467281287, -86.87204367700593 -29.533206594083083, -77.9422863405995 -44.99999999999997 C -69.01252900419306 -60.46679340591687, -66.46679340591693 -79.40483384960628, -51.00000000000004 -88.33459118601273 C -35.53320659408315 -97.26434852241918, -17.85951467281292 -89.99999999999999, -1.6532731788489267e-14 -90 C 17.859514672812853 -90.00000000000001, 35.533206594083055 -97.26434852241921, 50.99999999999993 -88.33459118601279 C 66.46679340591683 -79.40483384960635, 69.012529004193 -60.46679340591694, 77.94228634059945 -45.00000000000004 C 86.8720436770059 -29.53320659408314, 102 -17.85951467281291, 102 0 z ;M 104 0 C 103.6860370504768 18.670459122547623, 99.74513350853894 36.21879096669579, 88.33459118601274 50.99999999999999 C 77.42609021132327 65.13086500091876, 59.95986915829964 68.15050131663435, 44.50000000000001 77.07626093681503 C 29.040130841700375 86.00202055699572, 17.851519240361377 102, 6.245698675651501e-15 102 C -17.851519240361355 102, -28.89224164002164 85.74082198544978, -44.49999999999998 77.07626093681505 C -60.41578578366853 68.24070016127133, -78.942855942454 66.40974514759691, -90.0666419935816 52.000000000000036 C -101.58041073743591 37.08507152827802, -106.51375198961607 18.673591324066255, -104 1.2736326711132473e-14 C -101.57139126725896 -18.041098385442222, -86.17817517682458 -28.73502209016882, -77.07626093681506 -44.49999999999998 C -67.97434669680554 -60.264977909831146, -66.77256915682678 -79.42941623510848, -52.00000000000004 -90.0666419935816 C -36.96347614018194 -100.89393257665785, -18.33904556278876 -102.64701322308922, -1.8369701987210297e-14 -100 C 17.32727177622791 -97.49902374391826, 28.55026288749344 -84.4439984999364, 43.99999999999994 -76.21023553303064 C 60.07413421086994 -67.64370718198207, 78.79942390068253 -66.31128907769772, 90.06664199358158 -52.00000000000004 C 101.7221231317663 -37.19555062013585, 104.31680324149117 -18.83936298577321, 104 0 z ;M 102 0 C 101.82727211782054 17.85068357984393, 86.53189445508919 29.35841045474146, 77.07626093681505 44.49999999999999 C 67.96000753916402 59.09812997944896, 63.13859410212405 75.0566405949403, 49.000000000000014 84.87048957087498 C 34.41435518048109 94.99464438014832, 17.754300288879765 97.84390177587221, 6.000769315822031e-15 98 C -17.848085350949756 98.1569227951557, -34.936562555189376 96.05567507853976, -49.49999999999998 85.73651497465943 C -63.65084226105117 75.70970588855481, -67.15343120157955 58.79045409878119, -76.21023553303058 44.00000000000003 C -85.53194873850353 28.77692945084744, -101.82533168325062 17.849529545864502, -102 1.2491397351303002e-14 C -102.17467942383016 -17.85066458952948, -86.26579096020939 -29.195449136347488, -77.07626093681506 -44.49999999999998 C -68.05733453379239 -59.52042188438431, -65.25784853671414 -77.99137523784161, -50.00000000000004 -86.60254037844385 C -34.75370973790514 -95.20718230502631, -17.506833792572294 -87.99999999999999, -1.6165337748745062e-14 -88 C 17.50683379257223 -88.00000000000001, 34.671187347637854 -95.05929697358921, 49.999999999999936 -86.6025403784439 C 65.35816177516672 -78.12959215818911, 68.91293714727685 -60.037780348188306, 77.94228634059945 -45.00000000000004 C 87.13593221909689 -29.68859445350606, 102.172805244453 -17.858678638015444, 102 0 z ;M 88 0 C 87.0071643812453 16.750584310000846, 89.16591640357322 32.23066622251636, 82.48891971046778 47.62499999999999 C 75.39770857425334 63.9743373046321, 66.1406553264614 78.9687582413302, 50.250000000000014 87.03555308033607 C 34.54865539228622 95.00624548067042, 17.590620651271553 90.29638240436964, 5.480294426184406e-15 89.5 C -16.847968824431476 88.7372397661719, -32.382980242828936 89.6818280646011, -47.689999999999976 82.60150301295975 C -63.74959324223292 75.1730719952966, -77.27142977762603 65.04430269303984, -86.06560462809749 49.69000000000003 C -94.84784120247872 34.35654109365306, -96.67880542645688 17.590459164590612, -95 1.1634144591899855e-14 C -93.40474991806319 -16.714969454704665, -85.83878040009859 -30.176827189787602, -77.07626093681506 -44.49999999999998 C -68.48875537139932 -58.53709592172691, -59.78684881708811 -70.71810123462024, -46.12500000000004 -79.89084349911445 C -31.90399782177102 -89.43900857326942, -17.117492172090376 -95.6208569519316, -1.7680838162689912e-14 -96.25 C 17.42616675853088 -96.89048819537281, 32.604872069000194 -91.30523706046031, 48.124999999999936 -83.35494511425226 C 64.20208148728074 -75.11934989009448, 80.53937872975759 -67.29516003624032, 88.33459118601272 -51.00000000000004 C 96.03774549832913 -34.897278873736724, 89.0561690198359 -17.81911111787299, 88 0 z ;M 97 0 C 95.96205478306072 17.380245680862355, 92.31438589595038 33.26885450645463, 82.33303513778658 47.53499999999999 C 72.73454993850302 61.25392338906356, 58.07526843673644 67.1203245271079, 43.85500000000001 75.95908816593311 C 29.1689379616367 85.08737092091096, 17.266933647153582 97.78319544979668, 6.0442442771917615e-15 98.71 C -17.46539769433808 99.64745712962134, -31.760081272699992 89.97780532702197, -46.659999999999975 80.81749068116382 C -61.254519580560164 71.8449322457867, -74.9987279481924 63.057416617025154, -82.80068885583016 47.80500000000003 C -90.46529056195176 32.82111328110031, -87.3041822839497 16.816028610356618, -88 1.0776891832496709e-14 C -88.72578785785936 -17.54032572221827, -95.38715406508265 -34.80323520486043, -86.85368774554138 -50.144999999999975 C -78.30929038357452 -65.50641700627851, -59.99419319499677 -68.75787837688742, -44.82000000000004 -77.63051719523706 C -29.55758597966676 -86.55474040488905, -17.677948608071002 -101.20050810368325, -1.8540540215691355e-14 -100.93 C 17.66220221833233 -100.65973284769198, 28.66762264672243 -84.98120430879537, 44.03499999999994 -76.27085731129554 C 59.54270404931096 -67.48097206941182, 78.04582993349926 -65.57146684415069, 88.2133476294829 -50.93000000000004 C 98.53103081570782 -36.07229128519377, 98.0783410651801 -18.056668439457074, 97 0 z ;M 97 0 C 95.96205478306072 17.380245680862355, 92.31438589595038 33.26885450645463, 82.33303513778658 47.53499999999999 C 72.73454993850302 61.25392338906356, 58.07526843673644 67.1203245271079, 43.85500000000001 75.95908816593311 C 29.1689379616367 85.08737092091096, 17.266933647153582 97.78319544979668, 6.0442442771917615e-15 98.71 C -17.46539769433808 99.64745712962134, -31.760081272699992 89.97780532702197, -46.659999999999975 80.81749068116382 C -61.254519580560164 71.8449322457867, -74.9987279481924 63.057416617025154, -82.80068885583016 47.80500000000003 C -90.46529056195176 32.82111328110031, -87.3041822839497 16.816028610356618, -88 1.0776891832496709e-14 C -88.72578785785936 -17.54032572221827, -95.38715406508265 -34.80323520486043, -86.85368774554138 -50.144999999999975 C -78.30929038357452 -65.50641700627851, -59.99419319499677 -68.75787837688742, -44.82000000000004 -77.63051719523706 C -29.55758597966676 -86.55474040488905, -17.677948608071002 -101.20050810368325, -1.8540540215691355e-14 -100.93 C 17.66220221833233 -100.65973284769198, 28.66762264672243 -84.98120430879537, 44.03499999999994 -76.27085731129554 C 59.54270404931096 -67.48097206941182, 78.04582993349926 -65.57146684415069, 88.2133476294829 -50.93000000000004 C 98.53103081570782 -36.07229128519377, 98.0783410651801 -18.056668439457074, 97 0 z ;M 87.83 0 C 87.5551104106254 17.484718516847604, 95.16127715466017 34.74963105642935, 86.50727758402758 49.94499999999999 C 77.84990328247498 65.14629455992826, 59.80875022938145 68.6539166070951, 44.21500000000001 76.5826264566579 C 29.396758375489803 84.11702559690347, 16.533901742833184 92.20444258129785, 5.7515536921955445e-15 93.93 C -17.56198148944071 95.76285276019921, -35.17832492952776 96.1755728839107, -49.88499999999998 86.40335453557344 C -64.42964616977311 76.73880034577543, -67.07555683863683 58.889186090717956, -75.63865876653286 43.67000000000003 C -84.09849199523896 28.63435318786967, -98.51711635059414 17.25222189595266, -98.5 1.206277097160143e-14 C -98.48288504887265 -17.250811320073485, -84.34877504334715 -28.780575409619935, -75.55205622615443 -43.619999999999976 C -66.86093647073717 -58.281286656612146, -63.230342222349634 -75.4345590754149, -48.600000000000044 -84.17766924784742 C -33.93357389700559 -92.94234319091034, -17.025973616417954 -90.19821090033776, -1.630678445404658e-14 -88.77 C 15.977895940302826 -87.42970630164737, 29.38189187799461 -82.73892939223205, 44.10999999999994 -76.40076112186321 C 60.461233804495656 -69.36408876567695, 79.25079249329674 -66.31020434586661, 88.09210407295308 -50.86000000000004 C 96.93350510099964 -35.40963934294652, 88.10983120877545 -17.799036801646473, 87.83 0 z ;M 102.87 0 C 100.60412172987674 17.8655933362356, 85.53754352796288 28.604858280384207, 75.95908816593312 43.855 C 66.77647829932806 58.47490441348097, 64.20185353081875 76.67202079060546, 49.27000000000002 85.33814328891859 C 34.33463676216738 94.00630274472348, 17.255471196681203 88.61139941746183, 5.384771975850912e-15 87.94 C -16.62338090404565 87.29319481409648, -32.13105073147386 88.83642498642243, -47.104999999999976 81.58825329053197 C -62.593549158874595 74.0909884333756, -75.11183789801551 63.203277636192524, -82.85265038005723 47.83500000000003 C -90.43100426068291 32.78926071449635, -88.33481436911549 16.845994873358578, -88.2 1.0801384768479656e-14 C -88.0661541958799 -16.72496592774988, -90.31714156576788 -32.8325291006581, -82.09054802472696 -47.394999999999975 C -73.84119732253154 -61.99775494831187, -58.70114242558277 -68.16576009477593, -44.58000000000004 -77.21482500142054 C -29.826455382596357 -86.66914383925732, -17.522369834392396 -100.13333736150332, -1.8369701987210297e-14 -100 C 17.510547309053553 -99.86675260260256, 28.908254552710822 -85.0894876419882, 44.18999999999994 -76.53932518646872 C 59.70239533946346 -67.86011372570036, 77.14713304516553 -64.89164530763992, 87.9622002623854 -50.78500000000004 C 99.23322575875696 -36.08362498889298, 105.20080735972847 -18.37753465535834, 102.87 0 z ;M 96.65 0 C 97.5682370155223 17.290645042626103, 91.44243921640975 32.85986013368205, 81.65753532283473 47.144999999999996 C 72.23761953500264 60.89728781209352, 58.31868393027413 67.69602416070182, 44.205000000000005 76.5653059485822 C 29.586348647997518 85.75191795153148, 17.265486227503665 98.5023411385901, 6.0289361922024196e-15 98.46 C -17.260135494401737 98.41767198331847, -28.927850358240754 84.61477988915865, -44.07999999999998 76.34879959763612 C -59.63539109726837 67.86283824713713, -77.60369551546168 65.19715075831209, -87.6850721331744 50.625000000000036 C -97.93164740539275 35.81406243807856, -99.13895928925051 17.870177323503324, -96.9 1.1866827483737853e-14 C -94.78582581853146 -16.874209235069404, -84.03526438034655 -28.885451186299278, -75.855165117479 -43.79499999999998 C -67.48656343152348 -59.04812484966506, -64.58702634493868 -77.07802892327148, -49.685000000000045 -86.05694437405965 C -34.754341245902474 -95.05311170556791, -17.423866102474058 -90.01428351214383, -1.6440883278553216e-14 -89.5 C 16.944874403202444 -88.99985442555268, 33.406945286813375 -91.76595741651028, 48.01999999999994 -83.17307977945752 C 62.60280079933599 -74.59799227491723, 68.26035047536544 -58.944088507890214, 76.799132807604 -44.340000000000046 C 85.38138197865302 -29.66156909334073, 95.74829471964232 -16.979348111836277, 96.65 0 z ;M 100.43 0 C 99.44111609671702 17.552560474217483, 85.45003481640393 29.038106989746822, 76.37478035974965 44.09499999999999 C 67.47982214730594 58.85276076308644, 64.07619623688856 76.5210513546238, 49.13500000000001 85.10431642989678 C 34.197839864932604 93.68526288681738, 17.224945520414785 88.19944893969671, 5.386608946049633e-15 87.97 C -16.995859874251966 87.74360264955502, -33.675744430814035 92.32280785019591, -48.38499999999998 83.80527832422013 C -63.09093119233604 75.28967380919008, -67.46629494853046 58.573580703738266, -76.07167146842508 43.92000000000003 C -84.74078159210374 29.157891156391287, -97.50578376593529 17.119125303246612, -97.6 1.1952552759678167e-14 C -97.6942955026296 -17.13352843141885, -85.16966290503643 -29.388429432236997, -76.5566456945444 -44.19999999999998 C -67.96991930904315 -58.966358953746784, -62.77231119032221 -74.64857202786988, -48.62500000000004 -84.22097051803664 C -34.121978463364755 -94.03405086895964, -17.446142869940783 -97.50541642989344, -1.7634913907721887e-14 -96 C 16.824136546866306 -94.54825609504428, 29.53246273910814 -84.92008419882137, 44.00999999999994 -76.22755604110633 C 58.26564148077935 -67.66825740177873, 71.6180443525204 -60.425177429348025, 81.51031100419134 -47.060000000000045 C 92.07153193494764 -32.79101629986303, 101.4285520767086 -17.724169293174832, 100.43 0 z ;M 97.27 0 C 98.58345261039341 17.558366186082086, 94.2994917286897 34.203939932148074, 84.091066707469 48.54999999999999 C 74.21975411889315 62.42231066985079, 58.473444022898576 67.23312887448718, 43.57000000000001 75.46545368577598 C 28.941333692804605 83.54599751254223, 16.64874697133146 93.54662780123404, 5.8170722959499274e-15 95 C -17.27803955307615 96.50830704429953, -33.78857056294901 93.13333275238398, -48.19499999999998 83.47618867078205 C -62.265894952404224 74.04396533562448, -68.01933932212052 58.825944468473296, -76.14095350072783 43.96000000000003 C -84.0905443486636 29.408930041052358, -92.00739521206805 16.483816295811398, -93.8 1.1487186976002173e-14 C -95.70727280919573 -17.538240901971744, -94.76889052685837 -34.35072747684755, -86.34273275730855 -49.84999999999997 C -77.83404631199598 -65.50107770786477, -64.5344993843803 -76.3187721614444, -48.310000000000045 -83.67537451365246 C -32.817324666057125 -90.70014915251777, -17.009590728815464 -88.78959332709252, -1.6349034768617164e-14 -89 C 17.210968156731738 -89.21289768843408, 34.09370369400777 -93.47659088564015, 49.00499999999994 -84.87914982491287 C 63.91783177263862 -76.28082345658234, 68.61922431545376 -59.49398069945713, 77.12822246104209 -44.530000000000044 C 85.58365918742902 -29.660212768381562, 95.99397423560407 -17.058040356269963, 97.27 0 z ;M 102 0 C 102 17.85951467281289, 86.87204367700592 29.533206594083104, 77.94228634059948 44.99999999999999 C 69.01252900419304 60.46679340591688, 66.4667934059169 79.40483384960629, 51.000000000000014 88.33459118601273 C 35.53320659408312 97.26434852241918, 17.859514672812903 90, 5.5109105961630896e-15 90 C -17.85951467281288 90, -35.53320659408308 97.26434852241918, -50.99999999999998 88.33459118601274 C -66.46679340591687 79.4048338496063, -69.01252900419303 60.46679340591692, -77.94228634059947 45.00000000000003 C -86.87204367700592 29.533206594083133, -102 17.859514672812914, -102 1.2491397351303002e-14 C -102 -17.85951467281287, -86.87204367700593 -29.533206594083083, -77.9422863405995 -44.99999999999997 C -69.01252900419306 -60.46679340591687, -66.46679340591693 -79.40483384960628, -51.00000000000004 -88.33459118601273 C -35.53320659408315 -97.26434852241918, -17.85951467281292 -89.99999999999999, -1.6532731788489267e-14 -90 C 17.859514672812853 -90.00000000000001, 35.533206594083055 -97.26434852241921, 50.99999999999993 -88.33459118601279 C 66.46679340591683 -79.40483384960635, 69.012529004193 -60.46679340591694, 77.94228634059945 -45.00000000000004 C 86.8720436770059 -29.53320659408314, 102 -17.85951467281291, 102 0 z ;" dur="30s" repeatCount="indefinite"/><animateTransform attributeName="transform" type="scale" values="1;1.05;1.05;1.02;1" dur="0.15s" begin="click_area.mousedown" repeatCount="1" additive="sum"/></path></defs><g style="mask: url(#innerCircle)"><g fill="url(#grad3)" transform="rotate(54)"><use xlink:href="#path"><animateTransform id="animate1" attributeName="transform" type="rotate" from="54" to="416" dur="15s" repeatCount="indefinite"/></use></g><g fill="url(#grad2)" transform="rotate(74)"><use xlink:href="#path" /></g><g fill="url(#grad1)" transform="rotate(90)"><use xlink:href="#path"><animateTransform id="animate2" attributeName="transform" type="rotate" from="90" to="450" dur="30s" repeatCount="indefinite"/></use></g></g><circle cx="0" cy="0" r="76" fill="transparent" id="click_area"/></svg>');}else{r.write('<svg focusable="false" version="1.1" width="48" height="48" viewBox="-150 -150 300 300" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink"><defs><linearGradient id="grad1" x1="0%" x2="100%" y1="100%" y2="0%"><stop class="color1" offset="0%" style="stop-opacity:0.7"/><stop class="color2" offset="80%" style="stop-opacity:0.7"/></linearGradient><linearGradient id="grad2" x1="0%" x2="100%" y1="100%" y2="0%"><stop class="color1" offset="0%" style="stop-opacity:0.36"/><stop class="color2" offset="80%" style="stop-opacity:0.36"/></linearGradient><linearGradient id="grad3" x1="0%" x2="100%" y1="100%" y2="0%"><stop class="color1" offset="0%" style="stop-opacity:0.2"/><stop class="color2" offset="80%" style="stop-opacity:0.2"/></linearGradient><mask id="innerCircle"><circle cx="0" cy="0" r="120" fill="white" /><circle cx="0" cy="0" r="76" fill="black" /></mask><path id="path" d="M 98.1584 0 C 98.3156 17.3952 89.0511 31.3348 79.5494 45.9279 C 70.339 60.0814 60.6163 71.2177 46.1724 79.9729 C 31.4266 88.9178 17.2493 94.3909 5.77261e-15 94.2739 C -17.1547 94.1581 -30.8225 87.6907 -45.7979 79.3244 C -61.0143 70.8266 -73.5583 62.554 -83.0507 47.9493 C -92.6677 33.1579 -98.4872 17.5705 -97.1793 1.19010e-14 C -95.9465 -16.9777 -84.488 -29.0862 -76.1351 -43.9566 C -67.6795 -59.0155 -63.8629 -76.1085 -49.262 -85.3243 C -34.502 -94.6464 -17.4328 -93.0037 -1.69174e-14 -92.0939 C 16.8967 -91.214 31.8608 -89.0341 46.4198 -80.4014 C 60.872 -71.8326 69.6003 -59.5351 78.6792 -45.4254 C 88.0511 -30.9104 98.015 -17.2766 98.1584 0 Z"/></defs><g style="mask: url(#innerCircle)"><g fill="url(#grad3)" transform="rotate(54)"><use xlink:href="#path"/></g><g fill="url(#grad2)" transform="rotate(74)"><use xlink:href="#path" /></g><g fill="url(#grad1)" transform="rotate(90)"><use xlink:href="#path"/></g></g><circle cx="0" cy="0" r="76" fill="transparent" id="click_area"/></svg>');}r.write("</div>");};
return C;},true);
sap.ui.predefine('sap/f/shellBar/ContentButton',['sap/f/library','sap/m/Button','sap/f/shellBar/ContentButtonRenderer'],function(l,B,C){"use strict";var A=l.AvatarSize;
var c=B.extend("sap.f.shallBar.ContentButton",{
metadata:{library:"sap.f",aggregations:{avatar:{type:"sap.f.Avatar",multiple:false}}},
renderer:C
});
c.prototype.setAvatar=function(a){a.setDisplaySize(A.XS);return this.setAggregation("avatar",a);};
c.prototype._getText=function(){if(this._bInOverflow){return B.prototype._getText.call(this);}return"";};
return c;});
sap.ui.predefine('sap/f/shellBar/ContentButtonRenderer',["sap/m/ButtonRenderer",'sap/ui/core/Renderer'],function(B,R){"use strict";var C=R.extend(B);
C.writeImgHtml=function(r,c){var a=c.getAvatar();if(a){r.renderControl(a);}};
return C;},true);
sap.ui.predefine('sap/f/shellBar/ControlSpacer',['sap/ui/core/Control','sap/f/shellBar/ControlSpacerRenderer'],function(C,a){"use strict";
var b=C.extend("sap.f.shellBar.ControlSpacer",{
metadata:{library:"sap.f",properties:{width:{type:"sap.ui.core.CSSSize",group:"Appearance",defaultValue:''}}},
renderer:a
});
return b;});
sap.ui.predefine('sap/f/shellBar/ControlSpacerRenderer',[],function(){"use strict";var C={apiVersion:2};
C.render=function(r,c){r.openStart("div",c);r.class("sapMTBSpacer");r.style("width",c.getWidth());r.openEnd().close("div");};
return C;},true);
sap.ui.predefine('sap/f/shellBar/Factory',["sap/ui/core/Element","sap/m/Title","sap/m/Image","./ContentButton","sap/m/MenuButton","sap/m/OverflowToolbar","sap/m/OverflowToolbarButton","sap/f/SearchManager","./ControlSpacer","sap/m/ToolbarSpacer","sap/m/OverflowToolbarLayoutData","./CoPilot","./Accessibility","sap/m/library","sap/ui/core/library","sap/ui/core/theming/Parameters"],function(E,T,I,C,M,O,a,S,b,c,d,e,A,l,f,P){"use strict";var g=l.OverflowToolbarPriority;var h=l.ToolbarDesign;var B=l.ButtonType;var i=f.TitleLevel;var F=function(o){this._oContext=o;this._oControls={};this._oAcc=new A();this._alreadyAttachedSearchHandlers=false;};
F.prototype.getOverflowToolbar=function(){if(!this._oControls.oOverflowToolbar){this._oControls.oOverflowToolbar=new O({design:h.Transparent,style:"Clear"}).addStyleClass("sapFShellBarOTB");this._oControls.oOverflowToolbar._getOverflowButton().addStyleClass("sapFShellBarOverflowButton");}return this._oControls.oOverflowToolbar;};
F.prototype.getControlSpacer=function(){if(!this._oControls.oControlSpacer){this._oControls.oControlSpacer=new b().setLayoutData(new d({priority:g.NeverOverflow}));}return this._oControls.oControlSpacer;};
F.prototype.getToolbarSpacer=function(){if(!this._oControls.oToolbarSpacer){this._oControls.oToolbarSpacer=new c();}return this._oControls.oToolbarSpacer;};
F.prototype.getSecondTitle=function(){if(!this._oControls.oSecondTitle){this._oControls.oSecondTitle=new T({titleStyle:i.H6}).addStyleClass("sapFShellBarSecondTitle").setLayoutData(new d({priority:g.NeverOverflow}));}this._oControls.oSecondTitle._sFontSize=P.get("_sap_f_ShellBar_SecondTitle_FontSize");return this._oControls.oSecondTitle;};
F.prototype.getAvatarButton=function(){if(!this._oControls.oAvatarButton){this._oControls.oAvatarButton=new C({icon:"none",type:B.Transparent,tooltip:this._oAcc.getEntityTooltip("PROFILE"),iconDensityAware:false,press:function(){this._oContext.fireEvent("avatarPressed",{avatar:this._oControls.oAvatarButton.getAvatar()});}.bind(this)}).addStyleClass("sapFShellBarProfile").setLayoutData(new d({priority:g.NeverOverflow}));}return this._oControls.oAvatarButton;};
F.prototype.getHomeIcon=function(){if(!this._oControls.oHomeIcon){this._oControls.oHomeIcon=new I({densityAware:false,tooltip:this._oAcc.getEntityTooltip("LOGO"),press:function(){this._oContext.fireEvent("homeIconPressed",{icon:this._oControls.oHomeIcon});}.bind(this)}).addStyleClass("sapFShellBarHomeIcon").setLayoutData(new d({priority:g.NeverOverflow}));}return this._oControls.oHomeIcon;};
F.prototype.getMegaMenu=function(){if(!this._oControls.oMegaMenu){this._oControls.oMegaMenu=new M({type:B.Transparent,iconDensityAware:false}).addStyleClass("sapFSHMegaMenu").setLayoutData(new d({priority:g.NeverOverflow}));}this._oControls.oMegaMenu._iStaticWidth=36;this._oControls.oMegaMenu._sFontSize=P.get("_sap_f_ShellBar_PrimaryTitle_FontSize");return this._oControls.oMegaMenu;};
F.prototype.getPrimaryTitle=function(){if(!this._oControls.oPrimaryTitle){this._oControls.oPrimaryTitle=new T({titleStyle:i.H6,level:i.H1}).setLayoutData(new d({priority:g.NeverOverflow})).addStyleClass("sapFShellBarPrimaryTitle");}this._oControls.oPrimaryTitle._iStaticWidth=12;this._oControls.oPrimaryTitle._sFontSize=P.get("_sap_f_ShellBar_PrimaryTitle_FontSize");return this._oControls.oPrimaryTitle;};
F.prototype.getCopilot=function(){if(!this._oControls.oCopilot){this._oControls.oCopilot=new e({tooltip:this._oAcc.getEntityTooltip("COPILOT"),press:function(){this._oContext.fireEvent("copilotPressed",{image:this._oControls.oCopilot});}.bind(this)}).setLayoutData(new d({priority:g.NeverOverflow}));}return this._oControls.oCopilot;};
F.prototype.getSearch=function(){if(!this._oControls.oSearch){this._oControls.oSearch=new a({text:"Search",icon:"sap-icon://search",type:B.Transparent,tooltip:this._oAcc.getEntityTooltip("SEARCH"),press:function(){this._oContext.fireEvent("searchButtonPressed",{button:this._oControls.oSearch});}.bind(this)}).setLayoutData(new d({priority:g.Low}));}return this._oControls.oSearch;};
F.prototype.getManagedSearch=function(){if(!this._oControls.oManagedSearch){this._oControls.oManagedSearch=this._oContext.getSearchManager()._oSearch;}return this._oControls.oManagedSearch;};
F.prototype.getNavButton=function(){if(!this._oControls.oNavButton){this._oControls.oNavButton=new a({icon:"sap-icon://nav-back",type:B.Transparent,tooltip:this._oAcc.getEntityTooltip("BACK"),press:function(){this._oContext.fireEvent("navButtonPressed",{button:this._oControls.oNavButton});}.bind(this)}).setLayoutData(new d({priority:g.NeverOverflow}));}return this._oControls.oNavButton;};
F.prototype.getMenuButton=function(){if(!this._oControls.oMenuButton){this._oControls.oMenuButton=new a({icon:"sap-icon://menu2",type:B.Transparent,tooltip:this._oAcc.getEntityTooltip("MENU"),press:function(){this._oContext.fireEvent("menuButtonPressed",{button:this._oControls.oMenuButton});}.bind(this)}).setLayoutData(new d({priority:g.NeverOverflow}));}return this._oControls.oMenuButton;};
F.prototype.getNotifications=function(){if(!this._oControls.oNotifications){this._oControls.oNotifications=new a({text:"Notifications",icon:"sap-icon://bell",type:B.Transparent,tooltip:this._oAcc.getEntityTooltip("NOTIFICATIONS"),press:function(){this._oContext.fireEvent("notificationsPressed",{button:this._oControls.oNotifications});}.bind(this)}).addStyleClass("sapFButtonNotifications").setLayoutData(new d({priority:g.Low}));}return this._oControls.oNotifications;};
F.prototype.getProductSwitcher=function(){if(!this._oControls.oProductSwitcher){this._oControls.oProductSwitcher=new a({text:"My products",icon:"sap-icon://grid",type:B.Transparent,tooltip:this._oAcc.getEntityTooltip("PRODUCTS"),press:function(){this._oContext.fireEvent("productSwitcherPressed",{button:this._oControls.oProductSwitcher});}.bind(this)}).setLayoutData(new d({priority:g.High})).addStyleClass("sapFShellBarGridButton");}return this._oControls.oProductSwitcher;};
F.prototype.destroy=function(){Object.keys(this._oControls).forEach(function(k){var o=this._oControls[k];if(o){o.destroy();}}.bind(this));};
return F;});
sap.ui.predefine('sap/f/shellBar/ResponsiveHandler',["sap/m/OverflowToolbarLayoutData","sap/ui/Device","sap/ui/core/theming/Parameters","sap/m/library"],function(O,D,P,l){"use strict";var a=l.OverflowToolbarPriority;var R=function(c){this._oControl=c;this._iREMSize=parseInt(jQuery("body").css("font-size"));this._iChildControlMargin=parseInt(P.get("_sap_f_ShellBar_ChildMargin"));this._iDoubleChildControlMargin=this._iChildControlMargin*2;this._iCoPilotWidth=parseInt(P.get("_sap_f_ShellBar_CoPilotWidth"))+this._iDoubleChildControlMargin;this._iHalfCoPilotWidth=this._iCoPilotWidth/2;this._oDelegate={onAfterRendering:this.onAfterRendering,onBeforeRendering:this.onBeforeRendering};this._oControl.addDelegate(this._oDelegate,false,this);this._fnResize=this._resize;this._oControl._oOverflowToolbar.attachEvent("_controlWidthChanged",this._handleResize,this);};
R.prototype.onAfterRendering=function(){var p=D.media.getCurrentRange("Std",this._oControl.$().outerWidth(true)).name==="Phone";this._oButton=this._oControl._oMegaMenu&&this._oControl._oMegaMenu.getAggregation("_button");this._oDomRef=this._oControl.getDomRef();this.bIsMegaMenuConfigured=this._oControl._oTitleControl&&this._oControl._oTitleControl===this._oControl._oMegaMenu;if(this._oControl._oTitleControl){if(this.bIsMegaMenuConfigured&&this._oButton&&this._oButton._image){if(!this.bMenuButtonImageLoadAttached){this._oButton._image.attachEvent("load",this._updateMegaMenuWidth,this);this.bMenuButtonImageLoadAttached=true;}}if(!this.bIsMegaMenuConfigured){setTimeout(this._updateMegaMenuWidth.bind(this),0);}}if(this._oControl._oHomeIcon&&!this.bHomeIconLoadAttached){this._oControl._oHomeIcon.attachEvent("load",this._updateHomeIconWidth,this);this.bHomeIconLoadAttached=true;}if(this._oControl._oManagedSearch&&!this._bAttachedManagedSearchHandler){this._oControl._oManagedSearch.attachEvent("_updateVisualState",this._switchOpenStateOnSearch,this);this._bAttachedManagedSearchHandler=true;}if(p){this._transformTitleControlMobile();}this._initResize();this._handleResize();};
R.prototype.exit=function(){if(this._oControl._oOverflowToolbar){this._oControl._oOverflowToolbar.detachEvent("_controlWidthChanged",this._handleResize,this);}if(this._oControl._oHomeIcon){this._oControl._oHomeIcon.detachEvent("load",this._updateHomeIconWidth,this);this.bHomeIconLoadAttached=false;}if(this._oButton){this._oButton.detachEvent("load",this._updateMegaMenuWidth,this);}if(this._oControl._oTitleControl&&this.bIsMegaMenuConfigured&&this._oButton&&this._oButton._image){this._oButton._image.detachEvent("load",this._updateMegaMenuWidth,this);this.bMenuButtonImageLoadAttached=false;}this._oControl.removeDelegate(this._oDelegate);};
R.prototype._initResize=function(){this._iStaticWidth=0;this._iMBWidth=0;this._iStaticWidthForSearch=0;if(this._oControl._oTitleControl){this._iMBWidth=this.getTargetWidth(this._oControl._oTitleControl,true)+this._oControl._oTitleControl._iStaticWidth+this._iDoubleChildControlMargin;}this._iTitleWidth=this.getTargetWidth(this._oControl._oSecondTitle);if(this._oControl._oHomeIcon){this._iStaticWidth+=this._oControl._oHomeIcon.$().outerWidth(true);}if(this._oControl._oNavButton){this._iStaticWidth+=36+this._iDoubleChildControlMargin;}if(this._oControl._oMenuButton){this._iStaticWidth+=36+this._iChildControlMargin;}if(this._oControl._oAvatarButton){this._iStaticWidthForSearch+=36+this._iDoubleChildControlMargin;}if(this._oControl._oProductSwitcher||this._oControl._oNotifications||this._oControl.getAdditionalContent()){this._iStaticWidthForSearch+=36+this._iDoubleChildControlMargin;}if(this._oControl&&this._oControl._oCopilot){this._iStaticWidthForSearch+=this._iHalfCoPilotWidth;}};
R.prototype._updateHomeIconWidth=function(){this._iCurrentWidth=this._oControl._oHomeIcon.$().width();if(this._iCurrentWidth===this._iLastWidth){return;}this._iLastWidth=this._iCurrentWidth;this._initResize();this._fnResize();};
R.prototype._updateMegaMenuWidth=function(){this._initResize();this._fnResize();};
R.prototype._handleResize=function(){if(!this._oDomRef){return;}var c=this._oControl.$(),w=c.outerWidth(),C=D.media.getCurrentRange("Std",w),p;if(C){p=C.name==="Phone";c.toggleClass("sapFShellBarSizeDesktop",C.name==="Desktop");c.toggleClass("sapFShellBarSizeTablet",C.name==="Tablet");c.toggleClass("sapFShellBarSizePhone",p);}if(this._iPreviousWidth===w){return;}this._iPreviousWidth=w;if(!this._oControl._oNavButton&&!this._oControl._oMenuButton&&!this._oControl._oHomeIcon&&!this._oControl._oMegaMenu&&!this._oControl._oSecondTitle&&!this._oControl._oCopilot){return;}if(p&&!this.bWasInPhoneRange){this._fnResize=this._resizeOnPhone;this._transformToPhoneState();}else if(!p&&this.bWasInPhoneRange){this._fnResize=this._resize;this._transformToRegularState();}setTimeout(this._fnResize.bind(this),0);};
R.prototype._switchOpenStateOnSearch=function(){if(this.bWasInPhoneRange){this._transformToPhoneState();}else{this._transformToRegularState();}};
R.prototype._transformToPhoneState=function(){var s=this._oControl._oManagedSearch;if(this._oControl._oSecondTitle){this._oControl._oSecondTitle.setVisible(false);}this._transformTitleControlMobile();if(!this._controlsLayoutDataCached){this._cacheControlsLayoutData();this._controlsLayoutDataCached=true;}this._oControl._aOverflowControls.forEach(function(c){c.setLayoutData(new O({priority:a.AlwaysOverflow}));});this.bWasInPhoneRange=true;if(s){s.setPhoneMode(true);if(s.getIsOpen()){this._toggleAllControlsExceptSearch(false);this._bSearchWasOpen=true;}else if(this._bSearchWasOpen){this._toggleAllControlsExceptSearch(true);this._oControl._oHomeIcon.setVisible(false);this._oControl._oSecondTitle.setVisible(false);this._bSearchWasOpen=false;}}this._oControl.invalidate();};
R.prototype._transformToRegularState=function(){var s=this._oControl._oManagedSearch;this._toggleAllControlsExceptSearch(true);if(this._oControl._oSecondTitle){this._oControl._oSecondTitle.setVisible(true);}if(this._oControl._oHomeIcon){if(this._oControl._oMegaMenu){this._oControl._oMegaMenu.setWidth("auto").setText(this._oControl._sTitle).setIcon("");}if(this._oControl._oPrimaryTitle){this._oControl._oPrimaryTitle.setWidth("auto").setText(this._oControl._sTitle);}if(this.bIsMegaMenuConfigured){this._oControl._oHomeIcon.setVisible(true);}}if(this._controlsLayoutDataCached){this._restoreControlsLayoutData();this._controlsLayoutDataCached=false;}this.bWasInPhoneRange=false;s&&s.setPhoneMode(false);this._oControl.invalidate();};
R.prototype._transformTitleControlMobile=function(){if(this._oControl._oHomeIcon){if(this._oControl._oMegaMenu){this._oControl._oMegaMenu.setWidth("auto").setText("").setIcon(this._oControl.getHomeIcon());}if(this._oControl._oPrimaryTitle){this._oControl._oPrimaryTitle.setWidth("0").setText("");}this._oControl._oHomeIcon.setVisible(!this.bIsMegaMenuConfigured);}};
R.prototype._resizeOnPhone=function(){var w=this._oControl._getOverflowToolbar().$().width(),A;if(this._oControl._oCopilot){w-=this._iCoPilotWidth;A=(w/2)-this._iStaticWidth;}else{A=w-this._iStaticWidth-this._getWidthOfAllNonManagedControls();}if(!this._oControl._oHomeIcon&&this.bIsMegaMenuConfigured){if(this._iMBWidth>=A){this._oControl._oTitleControl.setWidth((A-this._iDoubleChildControlMargin)+"px");}else{this._oControl._oTitleControl.setWidth((this._iMBWidth-this._iDoubleChildControlMargin)+"px");}}if(this._oControl._oTitleControl){A-=this._oControl._oTitleControl.$().outerWidth(true);}if(A<0){A=0;}this._oControl._oCopilot&&this._oControl._oControlSpacer.setWidth(A+"px");};
R.prototype._resize=function(){var w=this._oControl._getOverflowToolbar().$().width(),A,o,h=w/2;if(this._oControl._oManagedSearch&&this._oControl._oManagedSearch.getIsOpen()){this._adaptSearch(h);}if(!this._oControl._oCopilot){o=this._getWidthOfAllNonManagedControls();A=w-o-this._iStaticWidth-(8*this._iREMSize);this._adaptManagedWidthControls(A);return;}A=h-this._iHalfCoPilotWidth-this._iStaticWidth;this._adaptManagedWidthControls(A);};
R.prototype._getWidthOfAllNonManagedControls=function(){var c=this._oControl._oOverflowToolbar.$().children(),o=0;c.filter(function(i,d){var C=jQuery(d),b=C.control(0);if(b===this._oControl._oNavButton){return false;}if(b===this._oControl._oMenuButton){return false;}if(b===this._oControl._oHomeIcon){return false;}if(b===this._oControl._oMegaMenu){return false;}if(b===this._oControl._oSecondTitle){return false;}if(b===this._oControl._oControlSpacer){return false;}if(b===this._oControl._oToolbarSpacer){return false;}o+=C.outerWidth(true);return true;}.bind(this));return o;};
R.prototype._adaptSearch=function(A){A=A-this._iStaticWidthForSearch-this._iDoubleChildControlMargin;if(A>464){this._oControl._oManagedSearch.setWidth("464px");return;}if(A<192){this._toggleAllControlsExceptSearch(false);this._oControl._oManagedSearch.setWidth("100%");this._oControl._oManagedSearch.setPhoneMode(true);this._bSearchFullWidth=true;return;}if(this._bSearchFullWidth){this._toggleAllControlsExceptSearch(true);this._oControl._oManagedSearch.setPhoneMode(false);this._bSearchFullWidth=false;}this._oControl._oManagedSearch.setWidth(A+"px");};
R.prototype._toggleAllControlsExceptSearch=function(s){this._oControl._oOverflowToolbar.getContent().forEach(function(o){if(o!==this._oControl._oManagedSearch){o.setVisible(s);}}.bind(this));};
R.prototype._adaptManagedWidthControls=function(A){var h=!!this._oControl._oTitleControl,m=h?this._iMBWidth:0,t=this._iTitleWidth,c=m+t,s=this._oControl._oSecondTitle,C=this._oControl._oControlSpacer,S,M=80,i;if(A<=0){C&&C.setWidth("0px");s&&s.setWidth("0px");h&&this._oControl._oTitleControl.setWidth(M+"px");return;}if(c<0){c=0;}if(m<0){m=0;}if(m>=A){C&&C.setWidth("0px");s&&s.setWidth("0px");i=A-this._iDoubleChildControlMargin<=M?M:A-this._iDoubleChildControlMargin;h&&this._oControl._oTitleControl.setWidth(i+"px");return;}else{i=m-this._iDoubleChildControlMargin<=M?M:m-this._iDoubleChildControlMargin;h&&this._oControl._oTitleControl.setWidth(i+"px");}if(A>=m&&A<=c){S=A-m;if(S<0){S=0;}if(S>32){C&&C.setWidth("0px");s&&s.setWidth(S+"px");}else{C&&C.setWidth(S+"px");s&&s.setWidth("0px");}return;}else{s&&s.setWidth(t+"px");}if(A>c){C&&C.setWidth((A-c)+"px");}};
R.prototype._cacheControlsLayoutData=function(){this._oCachedLayoutData={};this._oControl._aOverflowControls.forEach(function(c){this._oCachedLayoutData[c.getId()]=c.getLayoutData();}.bind(this));};
R.prototype._restoreControlsLayoutData=function(){this._oControl._aOverflowControls.forEach(function(c){var L=this._oCachedLayoutData[c.getId()];if(L){c.setLayoutData(L);}}.bind(this));};
R.prototype.getTargetWidth=function(c,b){if(!c){return 0;}var t=c.getText(),d=document.createElement("div"),T=document.createTextNode(t),s=sap.ui.getCore().getStaticAreaRef(),w;d.appendChild(T);d.style.setProperty("white-space","nowrap");d.style.setProperty("display","inline-block");d.style.setProperty("font-size",c._sFontSize);if(b){d.style.setProperty("font-weight","bold");}s.appendChild(d);if(d.getBoundingClientRect){w=d.getBoundingClientRect().width;}else{w=d.scrollWidth;}w+=1;s.removeChild(d);return w;};
return R;});
sap.ui.predefine('sap/f/shellBar/Search',['sap/ui/core/Control','sap/f/shellBar/SearchRenderer','sap/m/SearchField','sap/m/OverflowToolbarButton',"sap/m/OverflowToolbarLayoutData","sap/m/Button","sap/ui/events/KeyCodes","./Accessibility","sap/m/library"],function(C,S,a,O,b,B,K,A,l){"use strict";var c=l.ButtonType;var d=l.OverflowToolbarPriority;
var e=C.extend("sap.f.shellBar.Search",{
metadata:{interfaces:["sap.m.IOverflowToolbarContent"],library:"sap.f",properties:{isOpen:{type:"boolean",defaultValue:false},phoneMode:{type:"boolean",defaultValue:false},width:{type:"sap.ui.core.CSSSize",group:"Appearance",defaultValue:null}},aggregations:{_searchField:{type:"sap.m.SearchField",multiple:false},_searchButton:{type:"sap.m.OverflowToolbarButton",multiple:false},_cancelButton:{type:"sap.m.Button",multiple:false}},events:{search:{parameters:{query:{type:"string"},clearButtonPressed:{type:"boolean"}}},liveChange:{parameters:{newValue:{type:"string"}}},suggest:{parameters:{suggestValue:{type:"string"}}}}},
renderer:S
});
e.prototype.init=function(){this._sOldValue="";this._shouldFocusSearch=false;this._layoutDataWhenOpen=new b({priority:d.NeverOverflow});this._layoutDataWhenClosed=new b({priority:d.Low});this._oAcc=new A();};
e.prototype.onBeforeRendering=function(){this._switchOpenStateOnSearch();};
e.prototype.onAfterRendering=function(){setTimeout(function(){if(this._shouldFocusSearch){this._getSearchField().getFocusDomRef().focus();this._shouldFocusSearch=false;}}.bind(this),0);};
e.prototype.exit=function(){if(this._layoutDataWhenOpen){this._layoutDataWhenOpen.destroy();}if(this._layoutDataWhenClosed){this._layoutDataWhenClosed.destroy();}};
e.prototype._getSearchField=function(){var s=this.getAggregation("_searchField");if(!s){s=new a({showSearchButton:false,search:this._onSearch.bind(this),liveChange:this._onLiveChange.bind(this),suggest:this._onSuggest.bind(this)});this.setAggregation("_searchField",s);}return s;};
e.prototype._getSearchButton=function(){var s=this.getAggregation("_searchButton");if(!s){s=new O({text:"Search",icon:"sap-icon://search",type:c.Transparent,press:this._onPressSearchButtonHandler.bind(this),tooltip:this._oAcc.getEntityTooltip("SEARCH")});this.setAggregation("_searchButton",s);}return s;};
e.prototype._getCancelButton=function(){var o=this.getAggregation("_cancelButton");if(!o){o=new B({text:"Cancel",type:c.Transparent,press:this._onPressCancelButtonHandler.bind(this)});o.addStyleClass("sapFShellBarSearchCancelButton");this.setAggregation("_cancelButton",o);}return o;};
e.prototype.toggleVisibilityOfSearchField=function(){var i=this.getIsOpen();this.setIsOpen(!i);this._shouldFocusSearch=!i;this.fireEvent("_updateVisualState",{isOpen:!i});};
e.prototype._switchOpenStateOnSearch=function(){var L=this.getIsOpen()?this._layoutDataWhenOpen:this._layoutDataWhenClosed;if(this.getLayoutData()===L){return;}this.setLayoutData(L);};
e.prototype._onPressSearchButtonHandler=function(){var s=this._getSearchField();if(s.getValue()&&this.getIsOpen()){this.fireSearch({query:s.getValue(),clearButtonPressed:false});}else{this.toggleVisibilityOfSearchField();}};
e.prototype._onPressCancelButtonHandler=function(){this.toggleVisibilityOfSearchField();};
e.prototype._onSearch=function(E){var n=E.getParameters();n.id=this.getId();if(E.getParameter("clearButtonPressed")){this._shouldCloseOnNextEscape=false;}this.fireSearch(n);};
e.prototype._onLiveChange=function(E){var n=E.getParameters();delete n.refreshButtonPressed;delete n.suggestionItem;n.id=this.getId();this._shouldCloseOnNextEscape=!n.newValue;this.fireLiveChange(n);};
e.prototype._onSuggest=function(E){var n=E.getParameters();n.id=this.getId();this.fireSuggest(n);};
e.prototype.onkeyup=function(E){var s=this._getSearchField();if(E.keyCode===K.ESCAPE){if(s._oSuggest&&s._oSuggest.isOpen()){return;}if(this._shouldCloseOnNextEscape){this._shouldCloseOnNextEscape=false;return;}this.toggleVisibilityOfSearchField();}};
e.prototype._onBeforeEnterOverflow=function(){var s=this._getSearchButton();s._bInOverflow=true;s.addStyleClass("sapFShellBarSearchOverflowToolbar");};
e.prototype._onAfterExitOverflow=function(){var s=this._getSearchButton();s._bInOverflow=false;s.removeStyleClass("sapFShellBarSearchOverflowToolbar");};
e.prototype.getOverflowToolbarConfig=function(){var o={canOverflow:true};o.onBeforeEnterOverflow=this._onBeforeEnterOverflow.bind(this);o.onAfterExitOverflow=this._onAfterExitOverflow.bind(this);return o;};
return e;});
sap.ui.predefine('sap/f/shellBar/SearchRenderer',[],function(){"use strict";var S={apiVersion:2};
S.render=function(r,s){var o=s._getSearchField(),c=s._getCancelButton(),a=s._getSearchButton(),i=s.getIsOpen(),p=s.getPhoneMode(),b=s.getWidth();r.openStart("div",s);if(i){r.class("sapFShellBarSearch");}if(p){r.class("sapFShellBarSearchFullWidth");}if(b&&i&&!p){r.style("width",b);}r.openEnd();if(i){r.renderControl(o);}r.renderControl(a);if(i&&p){r.renderControl(c);}r.close("div");};
return S;},true);
sap.ui.require.preload({
	"sap/f/manifest.json":'{"_version":"1.9.0","sap.app":{"id":"sap.f","type":"library","embeds":[],"applicationVersion":{"version":"1.71.16"},"title":"SAPUI5 library with Fiori controls.","description":"SAPUI5 library with Fiori controls.","ach":"CA-UI5-CTR","resources":"resources.json","offline":true},"sap.ui":{"technology":"UI5","supportedThemes":["base","sap_hcb"]},"sap.ui5":{"dependencies":{"minUI5Version":"1.71","libs":{"sap.ui.core":{"minVersion":"1.71.16"},"sap.ui.layout":{"minVersion":"1.71.16"},"sap.m":{"minVersion":"1.71.16"}}},"library":{"i18n":"messagebundle.properties","content":{"controls":["sap.f.Avatar","sap.f.cards.Header","sap.f.cards.NumericHeader","sap.f.cards.NumericSideIndicator","sap.f.Card","sap.f.GridContainer","sap.f.DynamicPage","sap.f.DynamicPageHeader","sap.f.DynamicPageTitle","sap.f.FlexibleColumnLayout","sap.f.semantic.SemanticPage","sap.f.GridList","sap.f.GridListItem","sap.f.ShellBar"],"elements":["sap.f.DynamicPageAccessibleLandmarkInfo","sap.f.GridContainerItemLayoutData","sap.f.semantic.AddAction","sap.f.semantic.CloseAction","sap.f.semantic.CopyAction","sap.f.semantic.DeleteAction","sap.f.semantic.DiscussInJamAction","sap.f.semantic.EditAction","sap.f.semantic.ExitFullScreenAction","sap.f.semantic.FavoriteAction","sap.f.semantic.FlagAction","sap.f.semantic.FooterMainAction","sap.f.semantic.FullScreenAction","sap.f.semantic.MainAction","sap.f.semantic.MessagesIndicator","sap.f.semantic.NegativeAction","sap.f.semantic.PositiveAction","sap.f.semantic.PrintAction","sap.f.semantic.SemanticButton","sap.f.semantic.SemanticControl","sap.f.semantic.SemanticToggleButton","sap.f.semantic.SendEmailAction","sap.f.semantic.SendMessageAction","sap.f.semantic.ShareInJamAction","sap.f.semantic.TitleMainAction","sap.f.SearchManager"],"types":["sap.f.AvatarImageFitType","sap.f.AvatarShape","sap.f.AvatarSize","sap.f.AvatarType","sap.f.AvatarColor","sap.f.cards.HeaderPosition","sap.f.DynamicPageTitleArea","sap.f.DynamicPageTitleShrinkRatio","sap.f.LayoutType"],"interfaces":["sap.f.cards.IHeader","sap.f.ICard","sap.f.IShellBar","sap.f.IDynamicPageStickyContent","sap.f.dnd.IGridDroppable"]}}}}'
},"sap/f/library-preload"
);
//# sourceMappingURL=library-preload.js.map