/*
 * ! OpenUI5
 * (c) Copyright 2009-2019 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(['sap/ui/core/Control','sap/ui/model/base/ManagedObjectModel','sap/m/Toolbar','sap/m/ResponsivePopover','sap/m/Button','sap/m/ToggleButton','sap/m/ToolbarSpacer','sap/ui/model/Filter','sap/ui/model/FilterOperator','sap/ui/dom/containsOrEquals','sap/m/ColumnPopoverItem','sap/m/StandardListItem','sap/m/List'],function(C,M,T,R,B,a,b,F,c,d,e,S,L){"use strict";var f=C.extend("sap.m.ColumnHeaderPopover",{library:"sap.m",metadata:{properties:{},aggregations:{items:{type:"sap.m.ColumnPopoverItem",multiple:true,singularName:"item",bindable:true},_popover:{type:"sap.m.ResponsivePopover",multiple:false,visibility:"hidden"}},defaultAggregation:"items",associations:{ariaLabelledBy:{type:"sap.ui.core.Control",multiple:true,singularName:"ariaLabelledBy"}}}});f.prototype.init=function(){this._bPopoverCreated=false;this._oShownCustomContent=null;};f.prototype.exit=function(){this._oToolbar=null;};f.prototype._createPopover=function(){var t=this;this._oShownCustomContent=null;var o=sap.ui.getCore().getLibraryResourceBundle("sap.m"),s=o.getText("COLUMNHEADERPOPOVER_CLOSE_BUTTON");var p=new R(this.getId()+"-popover",{showArrow:false,showHeader:false,placement:"Bottom",verticalScrolling:true,horizontalScrolling:false,ariaLabelledBy:this.getAriaLabelledBy(),beforeClose:function(E){if(t._oShownCustomContent){t._oShownCustomContent.setVisible(false);t._oShownCustomContent=null;}t._cleanSelection(this);}});this.setAggregation("_popover",p);var g=new T(this.getId()+"-tb");p.addContent(g);var h=new F({path:"visible",operator:c.EQ,value1:true});var i=function(j,k){var I=k.getObject();var l;if(I.isA("sap.m.ColumnPopoverActionItem")){l=t._createActionItem(j,I);}else if(I.isA("sap.m.ColumnPopoverCustomItem")){l=t._createCustomItem(j,I);}else if(I.isA("sap.m.ColumnPopoverSortItem")){l=t._createSortItem(j,I);}I._sRelatedId=l.sId;l._sContentId=I._sContentId;l.destroy=function(){var D=this.getDomRef();if(D&&d(D,document.activeElement)){p.focus();p.removeContent(t._oShownCustomContent);}this.constructor.prototype.destroy.apply(this,arguments);};return l;};g.bindAggregation("content",{path:'/items',filters:[h],length:5,factory:i});g.updateAggregation=function(A){if(this._oShownCustomContent){this._oShownCustomContent=null;}T.prototype.updateAggregation.apply(this,arguments);var j=this.getContent();if(j.length<=2||!(j[j.length-2]instanceof b)){this.addContent(new b());this.addContent(new B({type:"Transparent",icon:"sap-icon://decline",tooltip:s,press:[p.close,p]}));}};var m=new M(this);g.setModel(m);this._oToolbar=g;};f.prototype._createActionItem=function(i,I){var t=this;return new B(i,{icon:"{icon}",tooltip:"{text}",type:"Transparent",visible:"{visible}",press:function(){var p=t.getAggregation("_popover");if(t._oShownCustomContent){t._oShownCustomContent.setVisible(false);t._oShownCustomContent=null;t._cleanSelection(p,this);}I.firePress();}});};f.prototype._createCustomItem=function(i,I){var t=this;var p=this.getAggregation("_popover");var o=I.getContent();if(o){o.setVisible(false);I._sContentId=o.sId;}p.addContent(o);return new a(i,{icon:"{icon}",type:"Transparent",tooltip:"{text}",visible:"{visible}",press:function(){if(t._oShownCustomContent){t._oShownCustomContent.setVisible(false);}if(this.getPressed()){t._cleanSelection(p,this);I.fireBeforeShowContent();if(o){o.setVisible(true);t._oShownCustomContent=o;}}else{if(o){o.setVisible(false);t._oShownCustomContent=null;}}}});};f.prototype._createSortItem=function(g,I){var t=this;var o=sap.ui.getCore().getLibraryResourceBundle("sap.m"),s=o.getText("COLUMNHEADERPOPOVER_SORT_BUTTON");var h=I.getSortChildren();if(h.length>1){var p=this.getAggregation("_popover");var l=new L();for(var i=0;i<h.length;i++){var j=new S({title:h[i].getText(),type:"Active"});l.addItem(j);j.data("key",h[i].getKey());}l.attachEvent("itemPress",function(E){p.close();var j=E.getParameter("listItem");I.fireSort({property:j.data("key")});});l.setVisible(false);p.addContent(l);return new a(g,{icon:"sap-icon://sort",type:"Transparent",tooltip:s,visible:"{visible}",press:function(){if(t._oShownCustomContent){t._oShownCustomContent.setVisible(false);}if(this.getPressed()){t._cleanSelection(p,this);if(l){l.setVisible(true);t._oShownCustomContent=l;}}else{if(l){l.setVisible(false);t._oShownCustomContent=null;}}}});}else{return new B(g,{icon:"sap-icon://sort",type:"Transparent",tooltip:s,visible:"{visible}",press:function(){var p=t.getAggregation("_popover");if(t._oShownCustomContent){t._oShownCustomContent.setVisible(false);t._oShownCustomContent=null;t._cleanSelection(p,this);}p.close();I.fireSort({property:h[0]?h[0].getKey():null});}});}};f.prototype._cleanSelection=function(p,o){var g=p.getContent()[0],h;h=g.getContent();if(h){h.forEach(function(i){if((!o||i!==o)&&i.getPressed&&i.getPressed()){i.setPressed(false);}});}};f.prototype.openBy=function(o){if(!this._bPopoverCreated){this._createPopover();this._bPopoverCreated=true;}else{this._oToolbar.getBinding("content").refresh(true);}var p=this.getAggregation("_popover");if(!this._bAppendedToUIArea&&!this.getParent()){var s=sap.ui.getCore().getStaticAreaRef();s=sap.ui.getCore().getUIArea(s);s.addContent(this,true);this._bAppendedToUIArea=true;}var O=o.getFocusDomRef();if(O){p.setOffsetY(-O.clientHeight);p.setContentWidth(O.clientWidth>128?O.clientWidth+"px":"128px");}p.openBy(o);};f.prototype.invalidate=function(o){var p=this.getAggregation("_popover");if(o===p){C.prototype.invalidate.apply(this,arguments);}return this;};f.prototype.addAssociation=function(A,i,s){if(A==="ariaLabelledBy"){var r=this.getAggregation("_popover");r&&r.addAssociation(A,i,s);}return C.prototype.addAssociation.apply(this,arguments);};f.prototype.removeAssociation=function(A,o,s){if(A==="ariaLabelledBy"){var r=this.getAggregation("_popover");r&&r.removeAssociation(A,o,s);}return C.prototype.removeAssociation.apply(this,arguments);};f.prototype.removeAllAssociation=function(A,s){if(A==="ariaLabelledBy"){var r=this.getAggregation("_popover");r&&r.removeAllAssociation(A,s);}return C.prototype.removeAllAssociation.apply(this,arguments);};return f;});
