/*!
 * OpenUI5
 * (c) Copyright 2009-2019 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(['sap/ui/thirdparty/jquery','sap/ui/Device','./InputBase','./DateTimeField','./Button','./ResponsivePopover','sap/ui/core/date/UniversalDate','./library','sap/ui/core/Control','sap/ui/core/library',"./DatePickerRenderer","sap/base/util/deepEqual","sap/base/assert","sap/base/Log","sap/ui/core/IconPool","./InstanceManager","sap/ui/unified/Calendar","sap/ui/unified/DateRange","sap/ui/unified/calendar/CustomMonthPicker","sap/ui/unified/calendar/CustomYearPicker","sap/ui/dom/jquery/cursorPos"],function(q,D,I,a,B,R,U,l,C,c,b,d,e,L,f,g,h,i,j,k){"use strict";var m=c.CalendarType;var r=sap.ui.getCore().getLibraryResourceBundle("sap.m");var n=a.extend("sap.m.DatePicker",{metadata:{library:"sap.m",properties:{displayFormatType:{type:"string",group:"Appearance",defaultValue:""},secondaryCalendarType:{type:"sap.ui.core.CalendarType",group:"Appearance",defaultValue:null},minDate:{type:"object",group:"Misc",defaultValue:null},maxDate:{type:"object",group:"Misc",defaultValue:null},showFooter:{type:"boolean",group:"Misc",defaultValue:false}},aggregations:{specialDates:{type:"sap.ui.core.Element",multiple:true,singularName:"specialDate"},_popup:{type:"sap.m.ResponsivePopover",multiple:false,visibility:"hidden"}},associations:{legend:{type:"sap.ui.core.Control",multiple:false}},events:{navigate:{parameters:{dateRange:{type:"sap.ui.unified.DateRange"},afterPopupOpened:{type:"boolean"}}}},designtime:"sap/m/designtime/DatePicker.designtime",dnd:{draggable:false,droppable:true}}});n.prototype.init=function(){a.prototype.init.apply(this,arguments);this._bIntervalSelection=false;this._bOnlyCalendar=true;this._bValid=true;this._oMinDate=new Date(1,0,1);this._oMinDate.setFullYear(1);this._oMaxDate=new Date(9999,11,31,23,59,59,999);var x=this.addEndIcon({id:this.getId()+"-icon",src:this.getIconSrc(),noTabStop:true,tooltip:r.getText("OPEN_PICKER_TEXT")});this._bShouldClosePicker=false;x.addEventDelegate({onmousedown:function(E){this._bShouldClosePicker=!!this.isOpen();}},this);x.attachPress(function(){this.toggleOpen(this._bShouldClosePicker);},this);};n.prototype.isValidValue=function(){return this._bValid;};n.prototype.isOpen=function(){return this._oPopup&&this._oPopup.isOpen();};n.prototype.toggleOpen=function(O){if(this.getEditable()&&this.getEnabled()){if(O){o.call(this);}else{_.call(this);}}};n.prototype.getIconSrc=function(){return f.getIconURI("appointment-2");};n.prototype.exit=function(){I.prototype.exit.apply(this,arguments);if(this._oPopup){if(this._oPopup.isOpen()){this._oPopup.close();}delete this._oPopup;}if(this._oCalendar){this._oCalendar.destroy();delete this._oCalendar;}if(this._iInvalidateCalendar){clearTimeout(this._iInvalidateCalendar);}this._sUsedDisplayPattern=undefined;this._sUsedDisplayCalendarType=undefined;this._oDisplayFormat=undefined;this._sUsedValuePattern=undefined;this._sUsedValueCalendarType=undefined;this._oValueFormat=undefined;};n.prototype.invalidate=function(O){if(!O||O!=this._oCalendar){C.prototype.invalidate.apply(this,arguments);this._iInvalidateCalendar=setTimeout(w.bind(this),0);}};n.prototype.onBeforeRendering=function(){a.prototype.onBeforeRendering.apply(this,arguments);this._checkMinMaxDate();var V=this._getValueHelpIcon();if(V){V.setProperty("visible",this.getEditable(),true);}};n.prototype.setWidth=function(W){return I.prototype.setWidth.call(this,W||"100%");};n.prototype.getWidth=function(W){return this.getProperty("width")||"100%";};n.prototype.applyFocusInfo=function(F){this._bFocusNoPopup=true;if(!D.support.touch||D.system.desktop){I.prototype.applyFocusInfo.apply(this,arguments);}};n.prototype.onfocusin=function(E){if(!q(E.target).hasClass("sapUiIcon")){I.prototype.onfocusin.apply(this,arguments);}this._bFocusNoPopup=undefined;};n.prototype.onsapshow=function(E){this.toggleOpen(this.isOpen());E.preventDefault();};n.prototype.onsaphide=n.prototype.onsapshow;n.prototype.onsappageup=function(E){p.call(this,1,"day");E.preventDefault();};n.prototype.onsappageupmodifiers=function(E){if(!E.ctrlKey&&E.shiftKey){p.call(this,1,"month");}else{p.call(this,1,"year");}E.preventDefault();};n.prototype.onsappagedown=function(E){p.call(this,-1,"day");E.preventDefault();};n.prototype.onsappagedownmodifiers=function(E){if(!E.ctrlKey&&E.shiftKey){p.call(this,-1,"month");}else{p.call(this,-1,"year");}E.preventDefault();};n.prototype.onkeypress=function(E){if(!E.charCode||E.metaKey||E.ctrlKey){return;}var F=this._getFormatter(true);var x=String.fromCharCode(E.charCode);if(x&&F.sAllowedCharacters&&F.sAllowedCharacters.indexOf(x)<0){E.preventDefault();}};n.prototype._getValueHelpIcon=function(){var V=this.getAggregation("_endIcon");return V&&V[0];};n.prototype._dateValidation=function(x){this._bValid=true;if(x&&(x.getTime()<this._oMinDate.getTime()||x.getTime()>this._oMaxDate.getTime())){this._bValid=false;e(this._bValid,"Date must be in valid range");}this.setProperty("dateValue",x);return x;};n.prototype.setMinDate=function(x){if(this._isValidDate(x)){throw new Error("Date must be a JavaScript date object; "+this);}if(d(this.getMinDate(),x)){return this;}if(x){var y=x.getFullYear();if(y<1||y>9999){throw new Error("Date must be between 0001-01-01 and 9999-12-31; "+this);}this._oMinDate=new Date(x.getTime());var z=this.getDateValue();if(z&&z.getTime()<x.getTime()){this._bValid=false;L.warning("DateValue not in valid date range",this);}}else{this._oMinDate=new Date(1,0,1);this._oMinDate.setFullYear(1);}this.setProperty("minDate",x);if(this._oCalendar){this._oCalendar.setMinDate(x);}this._oMinDate.setHours(0,0,0,0);return this;};n.prototype.setMaxDate=function(x){if(this._isValidDate(x)){throw new Error("Date must be a JavaScript date object; "+this);}if(d(this.getMaxDate(),x)){return this;}if(x){var y=x.getFullYear();if(y<1||y>9999){throw new Error("Date must be between 0001-01-01 and 9999-12-31; "+this);}this._oMaxDate=new Date(x.getTime());var z=this.getDateValue();if(z&&z.getTime()>x.getTime()){this._bValid=false;L.warning("DateValue not in valid date",this);}}else{this._oMaxDate=new Date(9999,11,31,23,59,59,999);}this.setProperty("maxDate",x);if(this._oCalendar){this._oCalendar.setMaxDate(x);}this._oMaxDate.setHours(23,59,59,999);return this;};n.prototype._checkMinMaxDate=function(){if(this._oMinDate.getTime()>this._oMaxDate.getTime()){L.warning("minDate > MaxDate -> dates switched",this);var M=new Date(this._oMinDate.getTime());var x=new Date(this._oMaxDate.getTime());this._oMinDate=new Date(x.getTime());this._oMaxDate=new Date(M.getTime());this.setProperty("minDate",x,true);this.setProperty("maxDate",M,true);if(this._oCalendar){this._oCalendar.setMinDate(x);this._oCalendar.setMaxDate(M);}}var y=this.getDateValue();if(y&&(y.getTime()<this._oMinDate.getTime()||y.getTime()>this._oMaxDate.getTime())){this._bValid=false;L.error("dateValue "+y.toString()+"(value="+this.getValue()+") does not match "+"min/max date range("+this._oMinDate.toString()+" - "+this._oMaxDate.toString()+"). App. "+"developers should take care to maintain dateValue/value accordingly.",this);}};n.prototype.getDisplayFormatType=function(){return this.getProperty("displayFormatType");};n.prototype._handleDateValidation=function(x){this._bValid=true;if(!x||x.getTime()<this._oMinDate.getTime()||x.getTime()>this._oMaxDate.getTime()){this._bValid=false;L.warning("Value can not be converted to a valid date",this);}this.setProperty("dateValue",x);};n.prototype.setDisplayFormatType=function(x){if(x){var F=false;for(var T in m){if(T==x){F=true;break;}}if(!F){throw new Error(x+" is not a valid calendar type"+this);}}this.setProperty("displayFormatType",x,true);this.setDisplayFormat(this.getDisplayFormat());return this;};n.prototype.setSecondaryCalendarType=function(x){this._bSecondaryCalendarTypeSet=true;this.setProperty("secondaryCalendarType",x,true);if(this._oCalendar){this._oCalendar.setSecondaryCalendarType(x);}return this;};n.prototype.setShowFooter=function(F){var P=this._oPopup,x=this._oCalendar;this.setProperty("showFooter",F);if(!P||!x){return this;}P._getButtonFooter().setVisible(F);return this;};n.prototype.addSpecialDate=function(S){v.call(this,S);this.addAggregation("specialDates",S,true);w.call(this);return this;};n.prototype.insertSpecialDate=function(S,x){v.call(this,S);this.insertAggregation("specialDates",S,x,true);w.call(this);return this;};n.prototype.removeSpecialDate=function(S){var x=this.removeAggregation("specialDates",S,true);w.call(this);return x;};n.prototype.removeAllSpecialDates=function(){var x=this.removeAllAggregation("specialDates",true);w.call(this);return x;};n.prototype.destroySpecialDates=function(){this.destroyAggregation("specialDates",true);w.call(this);return this;};n.prototype.setLegend=function(x){this.setAssociation("legend",x,true);var y=this.getLegend();if(y){var z=sap.ui.require("sap/ui/unified/CalendarLegend");x=sap.ui.getCore().byId(y);if(x&&!(typeof z=="function"&&x instanceof z)){throw new Error(x+" is not an sap.ui.unified.CalendarLegend. "+this);}}if(this._oCalendar){this._oCalendar.setLegend(y);}return this;};n.prototype.onChange=function(E){if(!this.getEditable()||!this.getEnabled()){return;}var V=this._$input.val(),O=this._formatValue(this.getDateValue()),x;if(V==O&&this._bValid){return;}if(this.getShowFooter()&&this._oPopup&&!V){this._oPopup.getBeginButton().setEnabled(false);}this._bValid=true;if(V!=""){x=this._parseValue(V,true);if(!x||x.getTime()<this._oMinDate.getTime()||x.getTime()>this._oMaxDate.getTime()){this._bValid=false;x=undefined;}else{V=this._formatValue(x);}}if(this.getDomRef()&&(this._$input.val()!==V)){this._$input.val(V);this._curpos=this._$input.cursorPos();}if(x){V=this._formatValue(x,true);}if(this._lastValue!==V||(x&&this.getDateValue()&&x.getFullYear()!==this.getDateValue().getFullYear())){this._lastValue=V;this.setProperty("value",V,true);var N=this.getValue();if(this._bValid&&V==N){this.setProperty("dateValue",x,true);}V=N;if(this.isOpen()){if(this._bValid){x=this.getDateValue();}this._oCalendar.focusDate(x);var S=this._oDateRange.getStartDate();if((!S&&x)||(S&&x&&S.getTime()!=x.getTime())){this._oDateRange.setStartDate(new Date(x.getTime()));}else if(S&&!x){this._oDateRange.setStartDate(undefined);}}this.fireChangeEvent(V,{valid:this._bValid});}};n.prototype._getInputValue=function(V){V=(typeof V=="undefined")?this._$input.val():V.toString();var x=this._parseValue(V,true);V=this._formatValue(x,true);return V;};n.prototype.updateDomValue=function(V){if(this.isActive()&&(this._$input.val()!==V)){this._bCheckDomValue=true;V=(typeof V=="undefined")?this._$input.val():V.toString();this._curpos=this._$input.cursorPos();var x=this._parseValue(V,true);V=this._formatValue(x);this._$input.val(V);if(document.activeElement===this._$input[0]){this._$input.cursorPos(this._curpos);}}return this;};n.prototype._storeInputSelection=function(x){if((D.browser.msie||D.browser.edge)&&!D.support.touch){this._oInputSelBeforePopupOpen={iStart:x.selectionStart,iEnd:x.selectionEnd};x.selectionStart=0;x.selectionEnd=0;}};n.prototype._restoreInputSelection=function(x){if((D.browser.msie||D.browser.edge)&&!D.support.touch){x.selectionStart=this._oInputSelBeforePopupOpen.iStart;x.selectionEnd=this._oInputSelBeforePopupOpen.iEnd;}};function _(){this._createPopup();this._createPopupContent();var x;var y=this.getBinding("value");if(y&&y.oType&&y.oType.oOutputFormat){x=y.oType.oOutputFormat.oFormatOptions.calendarType;}else if(y&&y.oType&&y.oType.oFormat){x=y.oType.oFormat.oFormatOptions.calendarType;}if(!x){x=this.getDisplayFormatType();}if(x){this._oCalendar.setPrimaryCalendarType(x);}var V=this._bValid?this._formatValue(this.getDateValue()):this.getValue();if(V!=this._$input.val()){this.onChange();}this._fillDateRange();this._openPopup();this.fireNavigate({dateRange:this._getVisibleDatesRange(this._oCalendar),afterPopupOpened:true});}n.prototype._createPopup=function(){var A,x;if(!this._oPopup){this._oPopup=new R(this.getId()+"-RP",{showCloseButton:false,showArrow:false,showHeader:false,placement:l.PlacementType.VerticalPreferedBottom}).addStyleClass("sapMRPCalendar");this._oPopup._getPopup().setAutoClose(true);this._oPopup.attachAfterOpen(s,this);this._oPopup.attachAfterClose(t,this);this._oPopup.setBeginButton(new B({text:r.getText("DATEPICKER_SELECTION_CONFIRM"),press:q.proxy(this._handleOKButton,this)}));if(D.system.phone){A=this.$("inner").attr("aria-labelledby");x=A?document.getElementById(A).getAttribute("aria-label"):"";this._oPopup.setTitle(x);this._oPopup.setShowHeader(true);this._oPopup.setShowCloseButton(true);}else{this._oPopup._getPopup().setDurations(0,0);this._oPopup.getBeginButton().setType(l.ButtonType.Emphasized);this._oPopup.setEndButton(new B({text:r.getText("DATEPICKER_SELECTION_CANCEL"),press:q.proxy(this._handleCancelButton,this)}));}this.setAggregation("_popup",this._oPopup,true);}};n.prototype._openPopup=function(){if(!this._oPopup){return;}this._storeInputSelection(this._$input.get(0));this._oPopup._getPopup().setAutoCloseAreas([this.getDomRef()]);this._oPopup.openBy(this);};n.prototype._getVisibleDatesRange=function(x){var V=x._getVisibleDays();return new i({startDate:V[0].toLocalJSDate(),endDate:V[V.length-1].toLocalJSDate()});};n.prototype._createPopupContent=function(){var P=this._getFormatter(true).aFormatArray.map(function(A){return A.type.toLowerCase();}),x=P.indexOf("day")>=0?true:false,M=P.indexOf("month")>=0?true:false,y=P.indexOf("year")>=0?true:false,z;if(!this._oCalendar){if(x&&M&&y){z=h;}else if(M&&y){z=j;}else if(y){z=k;}else{z=h;L.warning("Not valid date pattern! Openning default Calendar",this);}this._oCalendar=new z(this.getId()+"-cal",{intervalSelection:this._bIntervalSelection,minDate:this.getMinDate(),maxDate:this.getMaxDate(),legend:this.getLegend(),startDateChange:function(){this.fireNavigate({dateRange:this._getVisibleDatesRange(this._oCalendar)});}.bind(this)});this._oDateRange=new i();this._oCalendar.addSelectedDate(this._oDateRange);this._oCalendar._setSpecialDatesControlOrigin(this);if(this.$().closest(".sapUiSizeCompact").length>0){this._oCalendar.addStyleClass("sapUiSizeCompact");}if(this._bSecondaryCalendarTypeSet){this._oCalendar.setSecondaryCalendarType(this.getSecondaryCalendarType());}if(this._bOnlyCalendar){this._oCalendar.attachSelect(this._handleCalendarSelect,this);this._oCalendar.attachCancel(o,this);this._oCalendar.attachEvent("_renderMonth",u,this);this._oCalendar.setPopupMode(true);this._oPopup._getButtonFooter().setVisible(this.getShowFooter());this._getCalendar()._bSkipCancelButtonRendering=true;this._oPopup.addContent(this._getCalendar());if(!this.getDateValue()){this._oPopup.getBeginButton().setEnabled(false);}}}};n.prototype._fillDateRange=function(){var x=this.getDateValue();if(x&&x.getTime()>=this._oMinDate.getTime()&&x.getTime()<=this._oMaxDate.getTime()){this._oCalendar.focusDate(new Date(x.getTime()));if(!this._oDateRange.getStartDate()||this._oDateRange.getStartDate().getTime()!=x.getTime()){this._oDateRange.setStartDate(new Date(x.getTime()));}}else{var y=this.getInitialFocusedDateValue();var F=y?y:new Date();var M=this._oMaxDate.getTime();if(F.getTime()<this._oMinDate.getTime()||F.getTime()>M){F=this._oMinDate;}this._oCalendar.focusDate(F);if(this._oDateRange.getStartDate()){this._oDateRange.setStartDate(undefined);}}};n.prototype.getAccessibilityInfo=function(){var x=this.getRenderer();var y=I.prototype.getAccessibilityInfo.apply(this,arguments);var V=this.getValue()||"";if(this._bValid){var z=this.getDateValue();if(z){V=this._formatValue(z);}}y.type=r.getText("ACC_CTR_TYPE_DATEINPUT");y.description=[V,x.getLabelledByAnnouncement(this),x.getDescribedByAnnouncement(this)].join(" ").trim();return y;};n.prototype._selectDate=function(){var x=this.getDateValue(),y=this._getSelectedDate(),V="";if(!d(y,x)){this.setDateValue(new Date(y.getTime()));V=this.getValue();this.fireChangeEvent(V,{valid:true});this._focusInput();}else if(!this._bValid){V=this._formatValue(y);if(V!=this._$input.val()){this._bValid=true;if(this.getDomRef()){this._$input.val(V);this._lastValue=V;}V=this._formatValue(y,true);this.setProperty("value",V,true);this.fireChangeEvent(V,{valid:true});this._focusInput();}}else if(D.system.desktop||!D.support.touch){this.focus();}this._oPopup.close();};n.prototype._handleCalendarSelect=function(){if(this.getShowFooter()){this._oPopup.getBeginButton().setEnabled(true);return;}this._selectDate();};n.prototype._focusInput=function(){if(this.getDomRef()&&(D.system.desktop||!D.support.touch)){this._curpos=this._$input.val().length;this._$input.cursorPos(this._curpos);}return this;};n.prototype._getCalendar=function(){return this._oCalendar;};n.prototype._getSelectedDate=function(){var S=this._oCalendar.getSelectedDates();var x;if(S.length>0){x=S[0].getStartDate();}return x;};n.prototype._handleOKButton=function(){this._selectDate();};n.prototype._handleCancelButton=function(){if(!this.getDateValue()){this._oPopup.getBeginButton().setEnabled(false);}this._oPopup.close();};function o(E){if(this.isOpen()){this._oPopup.close();if((D.system.desktop||!D.support.touch)){this.focus();}}}function p(N,x){var O=this.getDateValue();var y=this._$input.cursorPos();if(O&&this.getEditable()&&this.getEnabled()){var z;var A=this.getBinding("value");if(A&&A.oType&&A.oType.oOutputFormat){z=A.oType.oOutputFormat.oFormatOptions.calendarType;}else if(A&&A.oType&&A.oType.oFormat){z=A.oType.oFormat.oFormatOptions.calendarType;}if(!z){z=this.getDisplayFormatType();}var E=U.getInstance(new Date(O.getTime()),z);O=U.getInstance(new Date(O.getTime()),z);switch(x){case"day":E.setDate(E.getDate()+N);break;case"month":E.setMonth(E.getMonth()+N);var M=(O.getMonth()+N)%12;if(M<0){M=12+M;}while(E.getMonth()!=M){E.setDate(E.getDate()-1);}break;case"year":E.setFullYear(E.getFullYear()+N);while(E.getMonth()!=O.getMonth()){E.setDate(E.getDate()-1);}break;default:break;}if(E.getTime()<this._oMinDate.getTime()){E=new U(this._oMinDate.getTime());}else if(E.getTime()>this._oMaxDate.getTime()){E=new U(this._oMaxDate.getTime());}if(!d(this.getDateValue(),E.getJSDate())){this.setDateValue(new Date(E.getTime()));this._curpos=y;this._$input.cursorPos(this._curpos);var V=this.getValue();this.fireChangeEvent(V,{valid:true});}}}function s(E){this.addStyleClass(I.ICON_PRESSED_CSS_CLASS);this._renderedDays=this._oCalendar.$("-Month0-days").find(".sapUiCalItem").length;this.$("inner").attr("aria-owns",this.getId()+"-cal");this.$("inner").attr("aria-expanded",true);g.addPopoverInstance(this._oPopup);this._getCalendar().focus();}function t(E){this.removeStyleClass(I.ICON_PRESSED_CSS_CLASS);this.$("inner").attr("aria-expanded",false);this._restoreInputSelection(this._$input.get(0));this._oCalendar._closedPickers();g.removePopoverInstance(this._oPopup);}function u(E){var x=E.getParameter("days"),P=this._oPopup._getPopup();if(x>this._renderedDays){this._renderedDays=x;P._applyPosition(P._oLastPosition);}}function v(S){var x=sap.ui.require("sap/ui/unified/DateTypeRange");if(S&&!(x&&S instanceof x)){throw new Error(S+"is not valid for aggregation \"specialDates\" of "+this);}}function w(){if(this.isOpen()){this._oCalendar._bDateRangeChanged=false;this._oCalendar.invalidate();}}return n;});
