/*!
 * OpenUI5
 * (c) Copyright 2009-2019 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(['sap/ui/Device','./DatePicker','./library','sap/ui/core/LocaleData','sap/ui/core/format/DateFormat','sap/ui/core/date/UniversalDate','./DateRangeSelectionRenderer',"sap/base/util/deepEqual","sap/base/Log","sap/base/assert","sap/ui/dom/jquery/cursorPos"],function(D,a,l,L,b,U,c,d,f,g){"use strict";var h=a.extend("sap.m.DateRangeSelection",{metadata:{library:"sap.m",properties:{delimiter:{type:"string",group:"Misc",defaultValue:'-'},secondDateValue:{type:"object",group:"Data",defaultValue:null},from:{type:"object",group:"Misc",defaultValue:null,deprecated:true},to:{type:"object",group:"Misc",defaultValue:null,deprecated:true}},designtime:"sap/m/designtime/DateRangeSelection.designtime",dnd:{draggable:false,droppable:true}}});var H=String.fromCharCode(45),E=String.fromCharCode(8211),j=String.fromCharCode(8212);h.prototype.init=function(){a.prototype.init.apply(this,arguments);this._bIntervalSelection=true;};h.prototype.onkeypress=function(e){if(!e.charCode||e.metaKey||e.ctrlKey){return;}var F=q.call(this);var i=p.call(this);var A=F.sAllowedCharacters+i+" ";var C=String.fromCharCode(e.charCode);if(C&&F.sAllowedCharacters&&A.indexOf(C)<0){e.preventDefault();}};h.prototype._getPlaceholder=function(){var P=this.getPlaceholder(),B,e,i,u;if(!P){B=this.getBinding("value");i=sap.ui.getCore().getConfiguration().getFormatSettings().getFormatLocale();u=L.getInstance(i);if(B&&B.getType()instanceof sap.ui.model.type.DateInterval){e=B.getType();if(e.oFormatOptions&&e.oFormatOptions.format){P=u.getCustomDateTimePattern(e.oFormatOptions.format);}else{P=u.getDatePattern("medium");}}else{P=this.getDisplayFormat();if(!P){P="medium";}if(this._checkStyle(P)){P=u.getDatePattern(P);}}var v=p.call(this);if(v&&v!==""){P=P+" "+v+" "+P;}}return P;};h.prototype.setValue=function(v){if(v!==this.getValue()){this._lastValue=v;}else{return this;}this.setProperty("value",v);this._bValid=true;var e=[undefined,undefined];if(v){e=this._parseValue(v);if(!n.call(this,e[0],e[1])[0]){this._bValid=false;f.warning("Value can not be converted to a valid dates",this);}}this.setProperty("dateValue",_(e[0]));this.setProperty("secondDateValue",_(e[1]));if(this.getDomRef()){var O=this._formatValue(e[0],e[1]);if(this._$input.val()!==O){this._$input.val(O);this._curpos=this._$input.cursorPos();}}return this;};function _(B){return(typeof B==='number')?new Date(B):B;}function k(B){return(B&&B.getTime)?B.getTime():B;}h.prototype.setValueFormat=function(v){this.setProperty("valueFormat",v,true);f.warning("Property valueFormat is not supported in sap.m.DateRangeSelection control.",this);return this;};h.prototype.setDisplayFormat=function(e){this.setProperty("displayFormat",e,true);var O=this._formatValue(this.getDateValue(),this.getSecondDateValue());this.setProperty("value",O,true);if(this.getDomRef()&&(this._$input.val()!==O)){this._$input.val(O);this._curpos=this._$input.cursorPos();}return this;};h.prototype.setFrom=function(F){this.setDateValue(F);return this;};h.prototype.getFrom=function(){return this.getDateValue();};h.prototype.setTo=function(T){this.setSecondDateValue(T);return this;};h.prototype.getTo=function(){return this.getSecondDateValue();};h.prototype.setDateValue=function(e){if(this._isValidDate(e)){throw new Error("Date must be a JavaScript date object; "+this);}if(d(this.getDateValue(),e)){return this;}a.prototype._dateValidation.call(this,e);this._syncDateObjectsToValue(e,this.getSecondDateValue());return this;};h.prototype.setSecondDateValue=function(S){if(this._isValidDate(S)){throw new Error("Date must be a JavaScript date object; "+this);}if(d(this.getSecondDateValue(),S)){return this;}this._bValid=true;if(S&&(S.getTime()<this._oMinDate.getTime()||S.getTime()>this._oMaxDate.getTime())){this._bValid=false;g(this._bValid,"Date must be in valid range");}this.setProperty("secondDateValue",S);this._syncDateObjectsToValue(this.getDateValue(),S);return this;};h.prototype.setMinDate=function(e){a.prototype.setMinDate.apply(this,arguments);if(e){var S=this.getSecondDateValue();if(S&&S.getTime()<this._oMinDate.getTime()){f.warning("SecondDateValue not in valid date range",this);}}return this;};h.prototype.setMaxDate=function(e){a.prototype.setMaxDate.apply(this,arguments);if(e){var S=this.getSecondDateValue();if(S&&S.getTime()>this._oMaxDate.getTime()){f.warning("SecondDateValue not in valid date range",this);}}return this;};h.prototype._checkMinMaxDate=function(){a.prototype._checkMinMaxDate.apply(this,arguments);var S=this.getSecondDateValue();if(S&&(S.getTime()<this._oMinDate.getTime()||S.getTime()>this._oMaxDate.getTime())){f.error("secondDateValue "+S.toString()+"(value="+this.getValue()+") does not match "+"min/max date range("+this._oMinDate.toString()+" - "+this._oMaxDate.toString()+"). App. "+"developers should take care to maintain secondDateValue/value accordingly.",this);}};h.prototype._parseValue=function(v){var F;var i=[];var u,w;var B=this.getBinding("value");if(B&&B.getType()instanceof sap.ui.model.type.DateInterval){try{i=B.getType().parseValue(v,"string");}catch(e){return[undefined,undefined];}if(B.getType().oFormatOptions&&B.getType().oFormatOptions.UTC){i=i.map(function(z){return new Date(z.getUTCFullYear(),z.getUTCMonth(),z.getUTCDate(),z.getUTCHours(),z.getUTCMinutes(),z.getUTCSeconds());});}return i;}var x=p.call(this);if(x&&v){v=v.trim();v=t(v,[x," "]);i=this._splitValueByDelimiter(v,x);if(i.length===2){if(i[0].slice(i[0].length-1,i[0].length)==" "){i[0]=i[0].slice(0,i[0].length-1);}if(i[1].slice(0,1)==" "){i[1]=i[1].slice(1);}}else{i=v.split(" "+x+" ");}if(v.indexOf(x)===-1){var y=v.split(" ");if(y.length===2){i=y;}}}if(v&&i.length<=2){F=q.call(this);if((!x||x==="")||i.length===1){u=F.parse(v);}else if(i.length===2){u=F.parse(i[0]);w=F.parse(i[1]);if(!u||!w){u=undefined;w=undefined;}}}return[u,w];};h.prototype._splitValueByDelimiter=function(v,e){var u=[H,E,j],i;if(e){if(u.indexOf(e)===-1){return v.split(e);}}for(i=0;i<u.length;i++){if(v.indexOf(u[i])>0){return v.split(u[i]);}}return v?v.split(" "):[];};h.prototype._formatValue=function(e,S){var v="",i=p.call(this),F,B,u,w;u=e;w=S;if(u){B=this.getBinding("value");if(B&&B.getType()instanceof sap.ui.model.type.DateInterval){if(B.getType().oFormatOptions&&B.getType().oFormatOptions.source&&B.getType().oFormatOptions.source.pattern==="timestamp"){v=B.getType().formatValue([k(e),k(S)],"string");}else{if(B.getType().oFormatOptions&&B.getType().oFormatOptions.UTC){u=new Date(Date.UTC(e.getFullYear(),e.getMonth(),e.getDate(),e.getHours(),e.getMinutes(),e.getSeconds()));if(S){w=new Date(Date.UTC(S.getFullYear(),S.getMonth(),S.getDate(),S.getHours(),S.getMinutes(),S.getSeconds()));}}v=B.getType().formatValue([u,w],"string");}}else{F=q.call(this);if(i&&i!==""&&w){v=F.format(u)+" "+i+" "+F.format(w);}else{v=F.format(u);}}}return v;};h.prototype.onChange=function(){if(!this.getEditable()||!this.getEnabled()){return;}var v=this._$input.val();var e=[undefined,undefined];if(this.getShowFooter()&&this._oPopup&&!v){this._oPopup.getBeginButton().setEnabled(false);}this._bValid=true;if(v!=""){e=this._parseValue(v);e[1]&&e[1].setHours(23,59,59,999);e=n.call(this,e[0],e[1]);if(e[0]){v=this._formatValue(e[0],e[1]);}else{this._bValid=false;}}if(v!==this._lastValue){if(this.getDomRef()&&(this._$input.val()!==v)){this._$input.val(v);this._curpos=this._$input.cursorPos();}this._lastValue=v;this.setProperty("value",v,true);if(this._bValid){this.setProperty("dateValue",_(e[0]),true);this.setProperty("secondDateValue",_(e[1]),true);}if(this._oPopup&&this._oPopup.isOpen()){var S=this.getDateValue();if(S){if(!this._oDateRange.getStartDate()||this._oDateRange.getStartDate().getTime()!==S.getTime()){this._oDateRange.setStartDate(new Date(S.getTime()));this._oCalendar.focusDate(S);}}else{if(this._oDateRange.getStartDate()){this._oDateRange.setStartDate(undefined);}}var i=this.getSecondDateValue();if(i){if(!this._oDateRange.getEndDate()||this._oDateRange.getEndDate().getTime()!==i.getTime()){this._oDateRange.setEndDate(new Date(i.getTime()));this._oCalendar.focusDate(i);}}else{if(this._oDateRange.getEndDate()){this._oDateRange.setEndDate(undefined);}}}m.call(this,this._bValid);}};h.prototype._getInputValue=function(v){v=(typeof v=="undefined")?this._$input.val():v.toString();if(!v){return"";}var e=this._parseValue(v);v=this._formatValue(e[0],e[1]);return v;};h.prototype.updateDomValue=function(v){this._bCheckDomValue=true;v=(typeof v=="undefined")?this._$input.val():v.toString();this._curpos=this._$input.cursorPos();var e=this._parseValue(v);v=this._formatValue(e[0],e[1]);if(this.isActive()&&(this._$input.val()!==v)){this._$input.val(v);this._$input.cursorPos(this._curpos);}return this;};h.prototype.onsappageup=function(e){this._increaseDateRange(1,"day");e.preventDefault();};h.prototype.onsappageupmodifiers=function(e){if(e.shiftKey&&!e.ctrlKey){this._increaseDateRange(1,"month");}else if(e.shiftKey&&e.ctrlKey){this._increaseDateRange(1,"year");}e.preventDefault();};h.prototype.onsappagedown=function(e){this._increaseDateRange(-1,"day");e.preventDefault();};h.prototype.onsappagedownmodifiers=function(e){if(e.shiftKey&&!e.ctrlKey){this._increaseDateRange(-1,"month");}else if(e.shiftKey&&e.ctrlKey){this._increaseDateRange(-1,"year");}e.preventDefault();};h.prototype._fillDateRange=function(){a.prototype._fillDateRange.apply(this,arguments);var e=this.getSecondDateValue();if(e&&e.getTime()>=this._oMinDate.getTime()&&e.getTime()<=this._oMaxDate.getTime()){if(!this._oDateRange.getEndDate()||this._oDateRange.getEndDate().getTime()!==e.getTime()){this._oDateRange.setEndDate(new Date(e.getTime()));}}else{if(this._oDateRange.getEndDate()){this._oDateRange.setEndDate(undefined);}}};h.prototype._selectDate=function(){var S=this._oCalendar.getSelectedDates();if(S.length>0){var e=S[0].getStartDate();var i=S[0].getEndDate();if(e&&i){var u=this.getDateValue();var v=this.getSecondDateValue();i.setHours(23,59,59,999);var V;if(!d(e,u)||!d(i,v)){if(d(i,v)){this.setDateValue(e);}else{this.setProperty("dateValue",e,true);this.setSecondDateValue(i);}V=this.getValue();m.call(this,true);if(D.system.desktop||!D.support.touch){this._curpos=V.length;this._$input.cursorPos(this._curpos);}}else if(!this._bValid){V=this._formatValue(e,i);if(V!=this._$input.val()){this._bValid=true;if(this.getDomRef()){this._$input.val(V);}m.call(this,true);}}this._oPopup.close();}}};h.prototype.getAccessibilityInfo=function(){var R=this.getRenderer();var i=a.prototype.getAccessibilityInfo.apply(this,arguments);var v=this.getValue()||"";if(this._bValid){var e=this.getDateValue();if(e){v=this._formatValue(e,this.getSecondDateValue());}}i.description=[v,R.getLabelledByAnnouncement(this),R.getDescribedByAnnouncement(this)].join(" ").trim();return i;};h.prototype._syncDateObjectsToValue=function(e,S){var v=this._formatValue(e,S);if(v!==this.getValue()){this._lastValue=v;}this.setProperty("value",v);if(this.getDomRef()){var O=this._formatValue(e,S);if(this._$input.val()!==O){this._$input.val(O);this._curpos=this._$input.cursorPos();}}};function m(v){this.fireChangeEvent(this.getValue(),{from:this.getDateValue(),to:this.getSecondDateValue(),valid:v});}function n(e,S){var F,i;if(e&&e.getTime){F=e.getTime();}else if(typeof e==='number'){F=e;}if(S&&S.getTime){i=S.getTime();}else if(typeof S==='number'){i=S;}if(e&&S&&F>i){var T=e;e=S;S=T;}if((e&&(F<this._oMinDate.getTime()||F>this._oMaxDate.getTime()))||(S&&(i<this._oMinDate.getTime()||i>this._oMaxDate.getTime()))){return[undefined,undefined];}else{return[e,S];}}h.prototype._increaseDateRange=function(N,u){var v=this._$input.val(),e=this._parseValue(v),F=e[0],S=e[1],i=q.call(this),w=p.call(this),C,x,y,V,z,A,B;if(!this.getEditable()||!this.getEnabled()){return;}if(!n.call(this,F,S)[0]){f.warning("Value can not be converted to a valid dates or dates are outside of the min/max range",this);this._bValid=false;m.call(this,this._bValid);return;}v=t(v,[w," "]);C=this._$input.cursorPos();x=i.format(F).length;y=i.format(S).length;V=v.length;z=C<=x+1;A=C>=V-y-1&&C<=V;if(z&&F){B=o.call(this,F,N,u);if(!d(this.getDateValue(),B.getJSDate())){this.setDateValue(new Date(B.getTime()));this._curpos=C;this._$input.cursorPos(this._curpos);this.fireChangeEvent(this.getValue(),{valid:this._bValid});}}else if(A&&S){B=o.call(this,S,N,u);if(!d(this.getSecondDateValue(),B.getJSDate())){this.setSecondDateValue(new Date(B.getTime()));this._curpos=C;this._$input.cursorPos(this._curpos);this.fireChangeEvent(this.getValue(),{valid:this._bValid});}}};function o(O,N,u){var B=this.getBinding("value"),C,M,e,i;if(B&&B.oType&&B.oType.oOutputFormat){C=B.oType.oOutputFormat.oFormatOptions.calendarType;}else if(B&&B.oType&&B.oType.oFormat){C=B.oType.oFormat.oFormatOptions.calendarType;}if(!C){C=this.getDisplayFormatType();}e=U.getInstance(new Date(O.getTime()),C);i=e.getMonth();switch(u){case"day":e.setDate(e.getDate()+N);break;case"month":e.setMonth(e.getMonth()+N);M=(i+N)%12;if(M<0){M=12+M;}while(e.getMonth()!=M){e.setDate(e.getDate()-1);}break;case"year":e.setFullYear(e.getFullYear()+N);while(e.getMonth()!=i){e.setDate(e.getDate()-1);}break;default:break;}if(e.getTime()<this._oMinDate.getTime()){e=new U(this._oMinDate.getTime());}else if(e.getTime()>this._oMaxDate.getTime()){e=new U(this._oMaxDate.getTime());}return e;}function p(){var e=this.getDelimiter();if(!e){if(!this._sLocaleDelimiter){var i=sap.ui.getCore().getConfiguration().getFormatSettings().getFormatLocale();var u=L.getInstance(i);var P=u.getIntervalPattern();var I=P.indexOf("{0}")+3;var v=P.indexOf("{1}");e=P.slice(I,v);if(e.length>1){if(e.slice(0,1)==" "){e=e.slice(1);}if(e.slice(e.length-1,e.length)==" "){e=e.slice(0,e.length-1);}}this._sLocaleDelimiter=e;}else{e=this._sLocaleDelimiter;}}return e;}function q(){var P=(this.getDisplayFormat()||"medium");var F;var C=this.getDisplayFormatType();if(P==this._sUsedDisplayPattern&&C==this._sUsedDisplayCalendarType){F=this._oDisplayFormat;}else{if(this._checkStyle(P)){F=b.getInstance({style:P,strictParsing:true,calendarType:C});}else{F=b.getInstance({pattern:P,strictParsing:true,calendarType:C});}this._sUsedDisplayPattern=P;this._sUsedDisplayCalendarType=C;this._oDisplayFormat=F;}return F;}function r(v,e){return v&&e&&v.lastIndexOf(e)===v.length-e.length;}function s(v,S){return v&&S&&v.indexOf(S)===0;}function t(v,P){var i=0,T=P;if(!T){T=[" "];}while(i<T.length){if(r(v,T[i])){v=v.substring(0,v.length-T[i].length);i=0;continue;}i++;}i=0;while(i<T.length){if(s(v,T[i])){v=v.substring(T[i].length);i=0;continue;}i++;}return v;}return h;});
