/*!
 * OpenUI5
 * (c) Copyright 2009-2019 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["sap/ui/thirdparty/jquery",'sap/ui/core/Control','./library','./DatePicker','./DateTimePicker','./TimePicker','sap/ui/model/type/Date','sap/ui/model/type/Time','sap/ui/model/type/DateTime','sap/ui/model/odata/type/ODataType','sap/ui/core/library','sap/ui/Device',"./DateTimeInputRenderer"],function(q,C,l,D,a,T,b,c,d,O,e,f,g){"use strict";var h=l.DateTimeInputType;var j=e.TextDirection;var k=e.TextAlign;var V=e.ValueState;var m=C.extend("sap.m.DateTimeInput",{metadata:{library:"sap.m",designtime:"sap/m/designtime/DateTimeInput.designtime",properties:{value:{type:"string",group:"Data",defaultValue:null,bindable:"bindable"},width:{type:"sap.ui.core.CSSSize",group:"Dimension",defaultValue:"100%"},enabled:{type:"boolean",group:"Behavior",defaultValue:true},editable:{type:"boolean",group:"Behavior",defaultValue:true},valueState:{type:"sap.ui.core.ValueState",group:"Appearance",defaultValue:V.None},valueStateText:{type:"string",group:"Misc",defaultValue:null},showValueStateMessage:{type:"boolean",group:"Misc",defaultValue:true},name:{type:"string",group:"Misc",defaultValue:null},placeholder:{type:"string",group:"Misc",defaultValue:null},textAlign:{type:"sap.ui.core.TextAlign",group:"Appearance",defaultValue:k.Initial},textDirection:{type:"sap.ui.core.TextDirection",group:"Appearance",defaultValue:j.Inherit},type:{type:"sap.m.DateTimeInputType",group:"Data",defaultValue:h.Date},displayFormat:{type:"string",group:"Appearance",defaultValue:null},valueFormat:{type:"string",group:"Data",defaultValue:null},dateValue:{type:"object",group:"Data",defaultValue:null}},aggregations:{_picker:{type:"sap.ui.core.Control",multiple:false,visibility:"hidden"}},associations:{ariaLabelledBy:{type:"sap.ui.core.Control",multiple:true,singularName:"ariaLabelledBy"}},events:{change:{parameters:{value:{type:"string"},dateValue:{type:"object"},valid:{type:"boolean"}}}}}});!(function(P,$,i){var r=l.getLocaleData();q.extend(P,{_types:{Date:{valueFormat:r.getDatePattern("short"),displayFormat:r.getDatePattern("medium")},Time:{valueFormat:r.getTimePattern("short"),displayFormat:r.getTimePattern("short")},DateTime:{valueFormat:r.getDateTimePattern("short"),displayFormat:r.getDateTimePattern("short")}}});["Time","Date"].forEach(function(t,s){["valueFormat","displayFormat"].forEach(function(F){var u=P._types;u.DateTime[F]=u.DateTime[F].replace("{"+s+"}",u[t][F]);});});}(m.prototype,q,f));m.prototype.init=function(){this.setType(h.Date);};m.prototype.onBeforeRendering=function(){o.call(this);};m.prototype.getFocusDomRef=function(){var P=_.call(this);return P.getFocusDomRef();};m.prototype.getIdForLabel=function(){var P=_.call(this);return P.getIdForLabel();};function n(t){var P;switch(t){case h.DateTime:P=new a(this.getId()+"-Picker");break;case h.Time:P=new T(this.getId()+"-Picker",{localeId:sap.ui.getCore().getConfiguration().getFormatSettings().getFormatLocale().toString()});break;default:P=new D(this.getId()+"-Picker");break;}P.setDisplayFormat(this.getDisplayFormat()||this._types[t].displayFormat);P.setValueFormat(this.getValueFormat()||this._types[t].valueFormat);if(this.getDateValue()){P.setDateValue(this.getDateValue());}P.setEnabled(this.getEnabled());P.setEditable(this.getEditable());P.setValueState(this.getValueState());P.setValueStateText(this.getValueStateText());P.setShowValueStateMessage(this.getShowValueStateMessage());P.setName(this.getName());P.setPlaceholder(this.getPlaceholder());P.setTextAlign(this.getTextAlign());P.setTextDirection(this.getTextDirection());P.setWidth("100%");P.attachChange(p,this);var A=this.getAriaLabelledBy();for(var i=0;i<A.length;i++){P.addAriaLabelledBy(A[i]);}return P;}m.prototype.setType=function(t){if(t==this.getType()&&_.call(this)){return this;}this.destroyAggregation("_picker");var P=n.call(this,t);this.setAggregation("_picker",P);this.setProperty("type",t);return this;};m.prototype.setWidth=function(w){this.setProperty("width",w);if(this.getDomRef()){w=this.getWidth();this.$().css("width",w);}return this;};m.prototype.setValue=function(v){o.call(this);v=this.validateProperty("value",v);if(v.toLowerCase()=="now"){return this.setDateValue(new Date());}if(v===this.getValue()){return this;}this.setProperty("value",v,true);var P=_.call(this);P.setValue(v);var i=P.getDateValue();this.setProperty("dateValue",i,true);return this;};m.prototype.setDateValue=function(i){if(this._isValidDate(i)){throw new Error("Date must be a JavaScript date object; "+this);}o.call(this);this.setProperty("dateValue",i,true);var P=_.call(this);P.setDateValue(i);var v=P.getValue();this.setProperty("value",v,true);return this;};m.prototype.setDisplayFormat=function(s){this.setProperty("displayFormat",s,true);var P=_.call(this);P.setDisplayFormat(s||this._types[this.getType()].displayFormat);return this;};m.prototype.setValueFormat=function(v){this.setProperty("valueFormat",v,true);var P=_.call(this);P.setValueFormat(v||this._types[this.getType()].ValueFormat);return this;};m.prototype.setEnabled=function(E){this.setProperty("enabled",E,true);var P=_.call(this);P.setEnabled(E);return this;};m.prototype.setEditable=function(E){this.setProperty("editable",E,true);var P=_.call(this);P.setEditable(E);return this;};m.prototype.setValueState=function(v){this.setProperty("valueState",v,true);var P=_.call(this);P.setValueState(v);return this;};m.prototype.setValueStateText=function(v){this.setProperty("valueStateText",v,true);var P=_.call(this);P.setValueStateText(v);return this;};m.prototype.setShowValueStateMessage=function(s){this.setProperty("showValueStateMessage",s,true);var P=_.call(this);P.setShowValueStateMessage(s);return this;};m.prototype.setName=function(N){this.setProperty("name",N,true);var P=_.call(this);P.setName(N);return this;};m.prototype.setPlaceholder=function(P){this.setProperty("placeholder",P,true);var i=_.call(this);i.setPlaceholder(P);return this;};m.prototype.setTextAlign=function(t){this.setProperty("textAlign",t,true);var P=_.call(this);P.setTextAlign(t);return this;};m.prototype.setTextDirection=function(t){this.setProperty("textDirection",t,true);var P=_.call(this);P.setTextDirection(t);return this;};m.prototype.addAriaLabelledBy=function(i){this.addAssociation("ariaLabelledBy",i,true);var P=_.call(this);P.addAriaLabelledBy(i);return this;};m.prototype.removeAriaLabelledBy=function(i){this.removeAssociation("ariaLabelledBy",i,true);var P=_.call(this);P.removeAriaLabelledBy(i);return this;};m.prototype.removeAllAriaLabelledBy=function(){this.removeAssociation("ariaLabelledBy",true);var P=_.call(this);P.removeAllAriaLabelledBy();return this;};m.prototype.getAccessibilityInfo=function(){var P=_.call(this);return P&&P.getAccessibilityInfo?P.getAccessibilityInfo():null;};m.prototype._getPickerByTypeAndPattern=function(t,i,r){var R=/[DdYyMLWwGQUur]/,s=/[HhKkmsa]/,u=s.test(r),v=R.test(r),w=u&&!v,x=v&&!u,y=v&&u,N,z;switch(t){case h.Time:case h.Date:case h.DateTime:if(w&&i.getMetadata().getName()!=="sap.m.TimePicker"){N=h.Time;}else if(x&&i.getMetadata().getName()!=="sap.m.DatePicker"){N=h.Date;}else if(y&&i.getMetadata().getName()!=="sap.m.DateTimePicker"){N=h.DateTime;}break;default:{throw"Invalid type: "+t+". Expected is one of the sap.m.DateTimeInputType";}}if(N){this.destroyAggregation("_picker");z=n.call(this,N);this.setAggregation("_picker",z);}return z||i;};m.prototype._getBoundValueTypePattern=function(){var B=this.getBinding("value"),i=B&&B.getType()&&B.getType();if(i instanceof b||i instanceof c||i instanceof d){return i.getOutputPattern();}if(i instanceof O&&i.oFormat){return i.oFormat.oFormatOptions.pattern;}return undefined;};function _(){return this.getAggregation("_picker");}m.prototype._isValidDate=function(i){return i&&q.type(i)!=="date";};function o(){if(this._getBoundValueTypePattern()){var P=this._getBoundValueTypePattern();var i=_.call(this);i=this._getPickerByTypeAndPattern(this.getType(),i,P);if(i.getValueFormat()!=P){i.setValueFormat(P);}if(i.getDisplayFormat()!=P){i.setDisplayFormat(P);}}}function p(E){var v=E.getParameter("value");var i;var r=E.getParameter("valid");this.setProperty("value",v,true);if(r){i=E.oSource.getDateValue();this.setProperty("dateValue",i,true);}this.fireChange({value:v,newValue:v,valid:r,dateValue:i,newDateValue:i});}return m;});
