/*!
 * OpenUI5
 * (c) Copyright 2009-2019 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["./library","sap/ui/core/Control","sap/ui/core/IconPool","sap/m/TextArea","sap/m/Button","./FeedInputRenderer","sap/ui/thirdparty/jquery"],function(l,C,I,T,B,F,q){"use strict";var a=l.ButtonType;var M=15,b=2,U=0;var c=C.extend("sap.m.FeedInput",{metadata:{library:"sap.m",designtime:"sap/m/designtime/FeedInput.designtime",properties:{enabled:{type:"boolean",group:"Behavior",defaultValue:true},rows:{type:"int",group:"Appearance",defaultValue:2},showExceededText:{type:"boolean",group:"Behavior",defaultValue:false},maxLength:{type:"int",group:"Behavior",defaultValue:0},growing:{type:"boolean",group:"Behavior",defaultValue:false},growingMaxLines:{type:"int",group:"Behavior",defaultValue:0},placeholder:{type:"string",group:"Appearance",defaultValue:"Post something here"},value:{type:"string",group:"Data",defaultValue:null},icon:{type:"sap.ui.core.URI",group:"Data",defaultValue:null},showIcon:{type:"boolean",group:"Behavior",defaultValue:true},iconDensityAware:{type:"boolean",group:"Appearance",defaultValue:true},buttonTooltip:{type:"sap.ui.core.TooltipBase",group:"Accessibility",defaultValue:"Submit"},ariaLabelForPicture:{type:"string",group:"Accessibility",defaultValue:null}},events:{post:{parameters:{value:{type:"string"}}}}}});c.prototype.init=function(){var o=sap.ui.getCore().getLibraryResourceBundle("sap.m");this.setProperty("placeholder",o.getText("FEEDINPUT_PLACEHOLDER"),true);this.setProperty("buttonTooltip",o.getText("FEEDINPUT_SUBMIT"),true);};c.prototype.exit=function(){if(this._oTextArea){this._oTextArea.destroy();}if(this._oButton){this._oButton.destroy();}if(this._oImageControl){this._oImageControl.destroy();}};c.prototype.setIconDensityAware=function(i){this.setProperty("iconDensityAware",i,true);var f=sap.ui.require("sap/m/Image");if(this._getImageControl()instanceof f){this._getImageControl().setDensityAware(i);}return this;};c.prototype.setRows=function(r){var m=this.getProperty("growingMaxLines");if(r>M){r=M;}else if(r<b){r=b;}if(r>m&&m!==0){this.setProperty("growingMaxLines",r,true);this._getTextArea().setGrowingMaxLines(r);}this.setProperty("rows",r,true);this._getTextArea().setRows(r);return this;};c.prototype.setShowExceededText=function(v){this.setProperty("showExceededText",v,true);this._getTextArea().setShowExceededText(v);return this;};c.prototype.setMaxLength=function(m){this.setProperty("maxLength",m,true);this._getTextArea().setMaxLength(m);return this;};c.prototype.setGrowing=function(g){this.setProperty("growing",g,true);this._getTextArea().setGrowing(g);return this;};c.prototype.setGrowingMaxLines=function(m){var r=this.getProperty("rows");if(m!==U){if(m<r){m=r;}else if(m>M){m=M;}}this.setProperty("growingMaxLines",m,true);this._getTextArea().setGrowingMaxLines(m);return this;};c.prototype.setValue=function(v){this.setProperty("value",v,true);this._getTextArea().setValue(v);this._enablePostButton();return this;};c.prototype.setPlaceholder=function(v){this.setProperty("placeholder",v,true);this._getTextArea().setPlaceholder(v);return this;};c.prototype.setEnabled=function(e){this.setProperty("enabled",e,true);this._getTextArea().setEnabled(e);this._enablePostButton();return this;};c.prototype.setButtonTooltip=function(v){this.setProperty("buttonTooltip",v,true);this._getPostButton().setTooltip(v);return this;};c.prototype._getTextArea=function(){var t=this;if(!this._oTextArea){this._oTextArea=new T(this.getId()+"-textArea",{value:this.getValue(),maxLength:this.getMaxLength(),placeholder:this.getPlaceholder(),growing:this.getGrowing(),growingMaxLines:this.getGrowingMaxLines(),showExceededText:this.getShowExceededText(),rows:this.getRows(),liveChange:q.proxy(function(e){var v=e.getParameter("value");this.setProperty("value",v,true);this._enablePostButton();},this)});this._oTextArea.setParent(this);this._oTextArea.addEventDelegate({onAfterRendering:function(){t.$("counterContainer").empty();t.$("counterContainer").html(t._oTextArea.getAggregation("_counter").$());}});}return this._oTextArea;};c.prototype._getPostButton=function(){if(!this._oButton){this._oButton=new B(this.getId()+"-button",{enabled:false,type:a.Default,icon:"sap-icon://feeder-arrow",tooltip:this.getButtonTooltip(),press:q.proxy(function(){this._oTextArea.focus();this.firePost({value:this.getValue()});this.setValue(null);},this)});this._oButton.setParent(this);}return this._oButton;};c.prototype._enablePostButton=function(){var p=this._isControlEnabled();var o=this._getPostButton();o.setEnabled(p);};c.prototype._isControlEnabled=function(){var v=this.getValue();return this.getEnabled()&&q.type(v)==="string"&&v.trim().length>0;};c.prototype._getImageControl=function(){var i=this.getIcon()||I.getIconURI("person-placeholder"),s=this.getId()+'-icon',p={src:i,alt:this.getAriaLabelForPicture(),densityAware:this.getIconDensityAware(),decorative:false,useIconTooltip:false},d=['sapMFeedInImage'];this._oImageControl=l.ImageHelper.getImageControl(s,this._oImageControl,this,p,d);return this._oImageControl;};return c;});
