/*
 * ! OpenUI5
 * (c) Copyright 2009-2019 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(['./library','sap/ui/core/library','sap/ui/core/Control','sap/ui/core/IconPool','sap/ui/Device','sap/ui/core/InvisibleText','sap/ui/core/ResizeHandler','sap/ui/core/Item','sap/ui/core/ListItem','sap/ui/model/odata/type/Boolean','sap/ui/model/type/String','sap/ui/model/odata/type/String','sap/ui/model/type/Date','sap/ui/model/type/Time','sap/ui/model/odata/type/DateTime','sap/ui/model/type/Float','./Button','./OverflowToolbar','./OverflowToolbarLayoutData','./ToolbarSpacer','./Text','./SearchField','./CheckBox','./ComboBox','./Select','./Label','./Input','./DatePicker','./TimePicker','./DateTimePicker','sap/base/Log','sap/ui/thirdparty/jquery'],function(a,c,C,I,D,b,R,d,L,B,S,e,f,T,g,F,h,O,k,m,o,q,r,s,t,u,v,x,y,z,A,Q){"use strict";var V=c.ValueState;var E=a.ButtonType;var G=a.ToolbarDesign;var H=c.TextAlign;var J=a.OverflowToolbarPriority;var K;var M;var N;var P;var U=C.extend("sap.m.P13nConditionPanel",{metadata:{library:"sap.m",properties:{maxConditions:{type:"string",group:"Misc",defaultValue:'-1'},exclude:{type:"boolean",group:"Misc",defaultValue:false},containerQuery:{type:"boolean",group:"Misc",defaultValue:false},autoAddNewRow:{type:"boolean",group:"Misc",defaultValue:false},disableFirstRemoveIcon:{type:"boolean",group:"Misc",defaultValue:false},alwaysShowAddIcon:{type:"boolean",group:"Misc",defaultValue:true},usePrevConditionSetting:{type:"boolean",group:"Misc",defaultValue:true},autoReduceKeyFieldItems:{type:"boolean",group:"Misc",defaultValue:false},layoutMode:{type:"string",group:"Misc",defaultValue:null},showLabel:{type:"boolean",group:"Misc",defaultValue:false},displayFormat:{type:"string",group:"Misc",defaultValue:null},validationExecutor:{type:"object",group:"Misc",defaultValue:null}},aggregations:{content:{type:"sap.ui.core.Control",multiple:true,singularName:"content",visibility:"hidden"}},events:{dataChange:{}}},renderer:function(j,l){j.write("<section");j.writeControlData(l);j.addClass("sapMConditionPanel");j.writeClasses();j.writeStyles();j.write(">");j.write("<div");j.addClass("sapMConditionPanelContent");j.addClass("sapMConditionPanelBG");j.writeClasses();j.write(">");var n=l.getAggregation("content");var p=n.length;for(var i=0;i<p;i++){j.renderControl(n[i]);}j.write("</div>");j.write("</section>");}});U.prototype.setConditions=function(j){if(!j){A.error("sap.m.P13nConditionPanel : aCondition is not defined");}if(this._bIgnoreSetConditions){return;}this._oConditionsMap={};this._aConditionKeys=[];this._iConditions=0;for(var i=0;i<j.length;i++){this._addCondition2Map(j[i]);}this._clearConditions();this._fillConditions();};U.prototype.removeAllConditions=function(){this._oConditionsMap={};this._aConditionKeys=[];this._iConditions=0;this._clearConditions();this._fillConditions();};U.prototype.addCondition=function(i){if(this._bIgnoreSetConditions){return;}i.index=this._iConditions;this._addCondition2Map(i);this._addCondition(i);};U.prototype.insertCondition=function(i,j){if(this._bIgnoreSetConditions){return;}if(j!==undefined){i.index=j;}this._addCondition2Map(i);this._addCondition(i);};U.prototype.removeCondition=function(i){this._clearConditions();if(typeof i=="string"){this._removeConditionFromMap(i);}if(typeof i=="object"){this._removeConditionFromMap(i.key);}this._fillConditions();};U.prototype._addCondition2Map=function(i){if(!i.key){i.key="condition_"+this._iConditions;if(this.getExclude()){i.key="x"+i.key;}}this._iConditions++;this._oConditionsMap[i.key]=i;this._aConditionKeys.push(i.key);};U.prototype._removeConditionFromMap=function(j){this._iConditions--;delete this._oConditionsMap[j];var i=this._aConditionKeys.indexOf(j);if(i>=0){this._aConditionKeys.splice(i,1);}};U.prototype.getConditions=function(){var i;var j=[];if(this._oConditionsMap){for(var l in this._oConditionsMap){i=this._oConditionsMap[l];var n=i.value;if(!n){n=this._getFormatedConditionText(i.operation,i.value1,i.value2,i.exclude,i.keyField,i.showIfGrouped);}if(!i._oGrid||i._oGrid.select.getSelected()){j.push({"key":l,"text":n,"exclude":i.exclude,"operation":i.operation,"keyField":i.keyField,"value1":i.value1,"value2":i.operation===W.BT?i.value2:null,"showIfGrouped":i.showIfGrouped});}}}return j;};U.prototype.setOperations=function(i,j){j=j||"default";this._oTypeOperations[j]=i;this._updateAllOperations();};U.prototype.setValues=function(i,j){j=j||"default";this._oTypeValues[j]=i;};U.prototype.addOperation=function(i,j){j=j||"default";this._oTypeOperations[j].push(i);this._updateAllOperations();};U.prototype.removeAllOperations=function(i){i=i||"default";this._oTypeOperations[i]=[];this._updateAllOperations();};U.prototype.getOperations=function(i){i=i||"default";return this._oTypeOperations[i];};U.prototype.setKeyFields=function(i){this._aKeyFields=i;this._aKeyFields.forEach(function(j){U._createKeyFieldTypeInstance(j);},this);this._updateKeyFieldItems(this._oConditionsGrid,true);this._updateAllConditionsEnableStates();this._createAndUpdateAllKeyFields();this._updateAllOperations();};U.prototype.addKeyField=function(i){this._aKeyFields.push(i);U._createKeyFieldTypeInstance(i);this._updateKeyFieldItems(this._oConditionsGrid,true,true);this._updateAllConditionsEnableStates();this._createAndUpdateAllKeyFields();this._updateAllOperations();};U._createKeyFieldTypeInstance=function(i){var j;if(!i.typeInstance){switch(i.type){case"boolean":i.typeInstance=new B();break;case"numc":if(!(i.formatSettings&&i.formatSettings.isDigitSequence)){A.error("sap.m.P13nConditionPanel","NUMC type support requires isDigitSequence==true!");i.formatSettings=Object.assign({},i.formatSettings,{isDigitSequence:true});}j=i.formatSettings;if(i.maxLength){j=Object.assign({},j,{maxLength:i.maxLength});}if(!j.maxLength){A.error("sap.m.P13nConditionPanel","NUMC type suppport requires maxLength!");}i.typeInstance=new e({},j);break;case"date":i.typeInstance=new f(Object.assign({},i.formatSettings,{strictParsing:true}),{});break;case"time":i.typeInstance=new T(Object.assign({},i.formatSettings,{strictParsing:true}),{});break;case"datetime":i.typeInstance=new g(Object.assign({},i.formatSettings,{strictParsing:true}),{displayFormat:"Date"});var n=i.typeInstance;if(!n.oFormat){n.formatValue(new Date(),"string");}if(n.oFormat){n.oFormat.oFormatOptions.UTC=false;}break;case"stringdate":sap.ui.getCore().loadLibrary("sap.ui.comp");P=P||sap.ui.requireSync("sap/ui/comp/odata/type/StringDate");i.typeInstance=new P(Object.assign({},i.formatSettings,{strictParsing:true}));break;case"numeric":if(i.precision||i.scale){j={};if(i.precision){j["maxIntegerDigits"]=parseInt(i.precision);}if(i.scale){j["maxFractionDigits"]=parseInt(i.scale);}}i.typeInstance=new F(j);break;default:var l=i.formatSettings;if(i.maxLength){l=Object.assign({},l,{maxLength:i.maxLength});}i.typeInstance=new S({},l);break;}}};U.prototype.removeAllKeyFields=function(){this._aKeyFields=[];this._updateKeyFieldItems(this._oConditionsGrid,true);};U.prototype.getKeyFields=function(){return this._aKeyFields;};U.prototype.setAlwaysShowAddIcon=function(i){this.setProperty("alwaysShowAddIcon",i);if(this._oConditionsGrid){this._oConditionsGrid.toggleStyleClass("conditionRootGrid",this.getLayoutMode()!=="Desktop");}return this;};U.prototype.setLayoutMode=function(l){this.setProperty("layoutMode",l);if(this._oConditionsGrid){this._oConditionsGrid.toggleStyleClass("conditionRootGrid",l!=="Desktop");}this._updateConditionFieldSpans(l);this._clearConditions();this._fillConditions();return this;};U.prototype.setContainerQuery=function(i){this._unregisterResizeHandler();this.setProperty("containerQuery",i);this._registerResizeHandler();this._clearConditions();this._fillConditions();return this;};U.prototype._updateConditionFieldSpans=function(i){if(this._aConditionsFields){var j=i==="Desktop";if(j){this._aConditionsFields[2].SpanFilter="L3 M3 S3";this._aConditionsFields[4].SpanFilter="L2 M2 S2";this._aConditionsFields[5].SpanFilter="L3 M3 S3";this._aConditionsFields[6].SpanFilter="L2 M2 S2";this._aConditionsFields[7].SpanFilter="L1 M1 S1";}var l=i==="Tablet";if(l){this._aConditionsFields[2].SpanFilter="L5 M5 S5";this._aConditionsFields[4].SpanFilter="L5 M5 S5";this._aConditionsFields[5].SpanFilter="L10 M10 S10";this._aConditionsFields[6].SpanFilter="L10 M10 S10";this._aConditionsFields[7].SpanFilter="L1 M1 S1";}}};U.prototype.init=function(){sap.ui.getCore().loadLibrary("sap.ui.layout");K=K||sap.ui.requireSync("sap/ui/layout/Grid");M=M||sap.ui.requireSync("sap/ui/layout/GridData");N=N||sap.ui.requireSync("sap/ui/layout/HorizontalLayout");this._oRb=sap.ui.getCore().getLibraryResourceBundle("sap.m");this._sFromLabelText=this._oRb.getText("CONDITIONPANEL_LABELFROM");this._sToLabelText=this._oRb.getText("CONDITIONPANEL_LABELTO");this._sValueLabelText=this._oRb.getText("CONDITIONPANEL_LABELVALUE");this._sShowIfGroupedLabelText=this._oRb.getText("CONDITIONPANEL_LABELGROUPING");this._sValidationDialogFieldMessage=this._oRb.getText("CONDITIONPANEL_FIELDMESSAGE");this._oTypeOperations={"default":[]};this._oTypeValues={"default":[]};this._aKeyFields=[];this._oConditionsMap={};this._aConditionKeys=[];this._iConditions=0;this._sLayoutMode="Desktop";this._sConditionType="Filter";this._sAddRemoveIconTooltip="FILTER";this._iBreakPointTablet=D.media._predefinedRangeSets[D.media.RANGESETS.SAP_STANDARD].points[0];this._iBreakPointDesktop=D.media._predefinedRangeSets[D.media.RANGESETS.SAP_STANDARD].points[1];this._oConditionsGrid=new K({width:"100%",defaultSpan:"L12 M12 S12",hSpacing:0,vSpacing:0}).toggleStyleClass("conditionRootGrid",this.getLayoutMode()!=="Desktop");this._oConditionsGrid.addStyleClass("sapUiRespGridOverflowHidden");this._iFirstConditionIndex=0;this._iConditionPageSize=10;this._oInvisibleTextField=new b({text:this._oRb.getText("CONDITIONPANEL_FIELD_LABEL")});this._oInvisibleTextOperator=new b({text:this._oRb.getText("CONDITIONPANEL_OPERATOR_LABEL")});this.addAggregation("content",this._oInvisibleTextField);this.addAggregation("content",this._oInvisibleTextOperator);this.addAggregation("content",this._oConditionsGrid);this._registerResizeHandler();this._aConditionsFields=[{"ID":"select","Label":"","SpanFilter":"L1 M1 S1","SpanSort":"L1 M1 S1","SpanGroup":"L1 M1 S1","Control":"CheckBox","Value":""},{"ID":"keyFieldLabel","Text":"Sort By","SpanFilter":"L1 M1 S1","SpanSort":"L1 M1 S1","SpanGroup":"L1 M1 S1","Control":"Label"},{"ID":"keyField","Label":"","SpanFilter":"L3 M5 S10","SpanSort":"L5 M5 S12","SpanGroup":"L4 M4 S12","Control":"ComboBox"},{"ID":"operationLabel","Text":"Sort Order","SpanFilter":"L1 M1 S1","SpanSort":"L1 M1 S1","SpanGroup":"L1 M1 S1","Control":"Label"},{"ID":"operation","Label":"","SpanFilter":"L2 M5 S10","SpanSort":D.system.phone?"L5 M5 S8":"L5 M5 S9","SpanGroup":"L2 M5 S10","Control":"ComboBox"},{"ID":"value1","Label":this._sFromLabelText,"SpanFilter":"L3 M10 S10","SpanSort":"L3 M10 S10","SpanGroup":"L3 M10 S10","Control":"TextField","Value":""},{"ID":"value2","Label":this._sToLabelText,"SpanFilter":"L2 M10 S10","SpanSort":"L2 M10 S10","SpanGroup":"L2 M10 S10","Control":"TextField","Value":""},{"ID":"showIfGrouped","Label":this._sShowIfGroupedLabelText,"SpanFilter":"L1 M10 S10","SpanSort":"L1 M10 S10","SpanGroup":"L3 M4 S9","Control":"CheckBox","Value":"false"}];this._oButtonGroupSpan={"SpanFilter":"L2 M2 S2","SpanSort":D.system.phone?"L2 M2 S4":"L2 M2 S3","SpanGroup":"L2 M2 S3"};this._updateConditionFieldSpans(this.getLayoutMode());this._fillConditions();};U.prototype._createPaginatorToolbar=function(){this._bPaginatorButtonsVisible=false;var i=this;this._oPrevButton=new h({icon:I.getIconURI("navigation-left-arrow"),tooltip:this._oRb.getText("WIZARD_FINISH"),visible:true,press:function(j){i._iFirstConditionIndex=Math.max(0,i._iFirstConditionIndex-i._iConditionPageSize);i._clearConditions();i._fillConditions();},layoutData:new k({priority:J.NeverOverflow})});this._oNextButton=new h({icon:I.getIconURI("navigation-right-arrow"),tooltip:this._oRb.getText("WIZARD_NEXT"),visible:true,press:function(j){i._iFirstConditionIndex+=i._iConditionPageSize;i._clearConditions();i._fillConditions();},layoutData:new k({priority:J.NeverOverflow})});this._oRemoveAllButton=new h({text:this._oRb.getText("CONDITIONPANEL_REMOVE_ALL"),visible:true,press:function(j){i._aConditionKeys.forEach(function(l,n){if(n>=0){this.fireDataChange({key:l,index:n,operation:"remove",newData:null});}},i);this._iFirstConditionIndex=0;i.removeAllConditions();},layoutData:new k({priority:J.Low})});this._oAddButton=new h({icon:I.getIconURI("add"),tooltip:this._oRb.getText("CONDITIONPANEL_ADD"+(this._sAddRemoveIconTooltipKey?"_"+this._sAddRemoveIconTooltipKey:"")+"_TOOLTIP"),visible:true,press:function(j){var l=i._createConditionRow(i._oConditionsGrid,undefined,null,0);i._changeField(l);setTimeout(function(){l.keyField.focus();});i._updatePaginatorToolbar();},layoutData:new k({priority:J.Low})});this._oHeaderText=new o({wrapping:false,layoutData:new k({priority:J.NeverOverflow})});this._oPageText=new o({wrapping:false,textAlign:H.Center,layoutData:new k({priority:J.NeverOverflow})});this._oFilterField=new q({width:"12rem",layoutData:new k({priority:J.High})});this._oPaginatorToolbar=new O({height:"3rem",design:G.Transparent,content:[this._oHeaderText,new m(),this._oFilterField,this._oPrevButton,this._oPageText,this._oNextButton,this._oRemoveAllButton,this._oAddButton]});};U.prototype._updatePaginatorToolbar=function(){if(this._sConditionType!=="Filter"||this.getMaxConditions()!=="-1"){return;}var i=this._aConditionKeys.length;var p=1+Math.floor(Math.max(0,i-1)/this._iConditionPageSize);var j=1+Math.floor(this._iFirstConditionIndex/this._iConditionPageSize);var l=this.getParent();if(!this._oPaginatorToolbar){if(i>this._iConditionPageSize){this._createPaginatorToolbar();this.insertAggregation("content",this._oPaginatorToolbar,0);this._onGridResize();}else{if(l&&l.setHeaderText){if(this._sOrgHeaderText==undefined){this._sOrgHeaderText=l.getHeaderText();}l.setHeaderText(this._sOrgHeaderText+(i>0?" ("+i+")":""));}return;}}this._oPrevButton.setEnabled(this._iFirstConditionIndex>0);this._oNextButton.setEnabled(this._iFirstConditionIndex+this._iConditionPageSize<i);if(l&&l.setHeaderToolbar){if(!l.getHeaderToolbar()){this.removeAggregation("content",this._oPaginatorToolbar);l.setHeaderToolbar(this._oPaginatorToolbar);l.attachExpand(function(X){this._setToolbarElementVisibility(X.getSource().getExpanded()&&this._bPaginatorButtonsVisible);}.bind(this));}}if(l&&l.setHeaderText){if(this._sOrgHeaderText==undefined){this._sOrgHeaderText=l.getHeaderText();}var n=this._sOrgHeaderText+(i>0?" ("+i+")":"");l.setHeaderText(n);this._oHeaderText.setText(n);}else{this._oHeaderText.setText(i+" Conditions");}this._oPageText.setText(j+"/"+p);this._bPaginatorButtonsVisible=this._bPaginatorButtonsVisible||p>1;this._setToolbarElementVisibility(this._bPaginatorButtonsVisible);if(j>p){this._iFirstConditionIndex-=Math.max(0,this._iConditionPageSize);this._clearConditions();this._fillConditions();}var w=0;this._oConditionsGrid.getContent().forEach(function(X){if(X.select.getSelected()){w++;}},this);if(p==j&&(i-this._iFirstConditionIndex)>w){this._clearConditions();this._fillConditions();}};U.prototype._setToolbarElementVisibility=function(i){this._oPrevButton.setVisible(i);this._oNextButton.setVisible(i);this._oPageText.setVisible(i);this._oFilterField.setVisible(false);this._oAddButton.setVisible(i);this._oRemoveAllButton.setVisible(i);};U.prototype.exit=function(){this._clearConditions();this._unregisterResizeHandler();this._aConditionsFields=null;this._aKeys=null;this._aKeyFields=null;this._oTypeOperations=null;this._oRb=null;this._sFromLabelText=null;this._sToLabelText=null;this._sValueLabelText=null;this._sValidationDialogFieldMessage=null;this._oConditionsMap=null;this._aConditionKeys=[];};U.prototype._clearConditions=function(){var i=this._oConditionsGrid.getContent();i.forEach(function(j){for(var l in this._aConditionsFields){var n=this._aConditionsFields[l];if(j[n["ID"]]&&j.getContent().indexOf(j[n["ID"]])===-1){j[n["ID"]].destroy();}}},this);this._oConditionsGrid.destroyContent();};U.prototype._fillConditions=function(){var j,l;var i=0,p=this._getMaxConditionsAsNumber(),n=this._aConditionKeys.length;if(this._oConditionsMap){var w=this._sConditionType!=="Filter"||this.getMaxConditions()!=="-1"?9999:this._iConditionPageSize;n=Math.min(n,Math.min(p,this._iFirstConditionIndex+w));for(i=this._iFirstConditionIndex;i<n;i++){l=this._aConditionKeys[i];j=this._oConditionsMap[l];this._createConditionRow(this._oConditionsGrid,j,l);}}this._updatePaginatorToolbar();if((this.getAutoAddNewRow()||this._oConditionsGrid.getContent().length===0)&&this._oConditionsGrid.getContent().length<p){this._createConditionRow(this._oConditionsGrid);}};U.prototype._addCondition=function(j){var i=0;var l=this._getMaxConditionsAsNumber();if(this._oConditionsMap){for(var n in this._oConditionsMap){if(i<l&&j===this._oConditionsMap[n]){this._createConditionRow(this._oConditionsGrid,j,n,i);}i++;}}this._updatePaginatorToolbar();};U.prototype._getMaxConditionsAsNumber=function(){return this.getMaxConditions()==="-1"?9999:parseInt(this.getMaxConditions());};U.prototype.onAfterRendering=function(){if(this.getLayoutMode()){this._sLayoutMode=this.getLayoutMode();return;}};U.prototype._handleMediaChange=function(p){this._sLayoutMode=p.name;this._updateLayout(p);};U.prototype._unregisterResizeHandler=function(){if(this._sContainerResizeListener){R.deregister(this._sContainerResizeListener);this._sContainerResizeListener=null;}D.media.detachHandler(this._handleMediaChange,this,D.media.RANGESETS.SAP_STANDARD);};U.prototype._registerResizeHandler=function(){if(this.getContainerQuery()){this._sContainerResizeListener=R.register(this._oConditionsGrid,this._onGridResize.bind(this));this._onGridResize();}else{D.media.attachHandler(this._handleMediaChange,this,D.media.RANGESETS.SAP_STANDARD);}};U.prototype._getKeyFromConditionGrid=function(i){var j=i.data("_key");if(!j){j=this._createConditionKey();}return j;};U.prototype._createConditionKey=function(){var i=0;var j;do{j="condition_"+i;if(this.getExclude()){j="x"+j;}i++;}while(this._oConditionsMap[j]);return j;};U.prototype._createConditionRow=function(i,j,l,p,n){var w=null;var X;var Y=this;if(p===undefined){p=i.getContent().length;}var Z=new K({width:"100%",defaultSpan:"L12 M12 S12",hSpacing:1,vSpacing:0,containerQuery:this.getContainerQuery()}).data("_key",l);Z.addStyleClass("sapUiRespGridOverflowHidden");for(var $ in this._aConditionsFields){var _;var a1=this._aConditionsFields[$];switch(a1["Control"]){case"CheckBox":_=new r({enabled:false,visible:false,layoutData:new M({span:a1["Span"+this._sConditionType]})});if(a1["ID"]==="showIfGrouped"){_.setEnabled(true);_.setText(a1["Label"]);_.attachSelect(function(){Y._changeField(Z);});_.setSelected(j?j.showIfGrouped:true);}else{if(j){_.setSelected(true);_.setEnabled(true);}}break;case"ComboBox":if(a1["ID"]==="keyField"){_=new s({width:"100%",ariaLabelledBy:this._oInvisibleTextField});var b1=_.setSelectedKey.bind(_);_.setSelectedKey=function(l){b1(l);var o1=Y.getValidationExecutor();if(o1){o1();}};var c1=_.setSelectedItem.bind(_);_.setSelectedItem=function(o1){c1(o1);var p1=Y.getValidationExecutor();if(p1){p1();}};_.setLayoutData(new M({span:a1["Span"+this._sConditionType]}));this._fillKeyFieldListItems(_,this._aKeyFields);if(_.attachSelectionChange){_.attachSelectionChange(function(o1){var p1=Y.getValidationExecutor();if(p1){p1();}Y._handleSelectionChangeOnKeyField(i,Z);});}if(_.attachChange){_.attachChange(function(o1){Z.keyField.close();Y._handleChangeOnKeyField(i,Z);});}if(_.setSelectedItem){if(j){_.setSelectedKey(j.keyField);this._aKeyFields.forEach(function(d1,o1){var p1=d1.key;if(p1===undefined){p1=d1;}if(j.keyField===p1){_.setSelectedItem(_.getItems()[o1]);}},this);}else{if(this.getUsePrevConditionSetting()&&!this.getAutoReduceKeyFieldItems()){if(p>0&&!l&&n){X=i.getContent()[p-1];if(X.keyField.getSelectedKey()){_.setSelectedKey(X.keyField.getSelectedKey());}else{if(!_.getSelectedItem()&&_.getItems().length>0){_.setSelectedItem(_.getItems()[0]);}}}else{this._aKeyFields.some(function(d1,o1){if(d1.isDefault){_.setSelectedItem(_.getItems()[o1]);return true;}if(!_.getSelectedItem()&&d1.type!=="boolean"){_.setSelectedItem(_.getItems()[o1]);}},this);if(!_.getSelectedItem()&&_.getItems().length>0){_.setSelectedItem(_.getItems()[0]);}}}else{this._aKeyFields.forEach(function(d1,o1){if(d1.isDefault){_.setSelectedItem(_.getItems()[o1]);}},this);}}}}if(a1["ID"]==="operation"){_=new t({width:"100%",ariaLabelledBy:this._oInvisibleTextOperator,layoutData:new M({span:a1["Span"+this._sConditionType]})});_.attachChange(function(){Y._handleChangeOnOperationField(i,Z);});Z[a1["ID"]]=_;this._updateOperationItems(i,Z);if(j){var d1=this._getCurrentKeyFieldItem(Z.keyField);var e1=this._oTypeOperations["default"];if(d1){if(d1.type&&this._oTypeOperations[d1.type]){e1=this._oTypeOperations[d1.type];}if(d1.operations){e1=d1.operations;}}e1.some(function(o1,p1){if(j.operation===o1){_.setSelectedKey(o1);return true;}},this);}else{if(this.getUsePrevConditionSetting()){if(p>0&&l===null){var X=i.getContent()[p-1];_.setSelectedKey(X.operation.getSelectedKey());}}}}if(_.getSelectedItem&&_.getSelectedItem()){_.setTooltip(_.getSelectedItem().getTooltip()||_.getSelectedItem().getText());}break;case"TextField":var f1=this._getCurrentKeyFieldItem(Z.keyField);_=this._createValueField(f1,a1,Z);_.oTargetGrid=i;if(j&&j[a1["ID"]]!==undefined){var g1=j[a1["ID"]];if(_ instanceof t){if(typeof g1==="boolean"){_.setSelectedIndex(g1?2:1);}}else if(g1!==null&&Z.oType){if(typeof g1==="string"&&Z.oType.getName()==="sap.ui.comp.odata.type.StringDate"){_.setValue(g1);}else{if(typeof g1==="string"&&["String","sap.ui.model.odata.type.String","sap.ui.model.odata.type.Decimal"].indexOf(Z.oType.getName())==-1){try{g1=Z.oType.parseValue(g1,"string");_.setValue(Z.oType.formatValue(g1,"string"));}catch(h1){A.error("sap.m.P13nConditionPanel","Value '"+g1+"' does not have the expected type format for "+Z.oType.getName()+".parseValue()");}}else{_.setValue(Z.oType.formatValue(g1,"string"));}}}else{_.setValue(g1);}}break;case"Label":_=new u({text:a1["Text"]+":",visible:this.getShowLabel(),layoutData:new M({span:a1["Span"+this._sConditionType]})}).addStyleClass("conditionLabel");_.oTargetGrid=i;break;}Z[a1["ID"]]=_;Z.addContent(_);}w=new N({layoutData:new M({span:this.getLayoutMode()==="Desktop"?"L2 M2 S2":this._oButtonGroupSpan["Span"+this._sConditionType]})}).addStyleClass("floatRight");Z.addContent(w);Z["ButtonContainer"]=w;var i1=new h({type:E.Transparent,icon:I.getIconURI("sys-cancel"),tooltip:this._oRb.getText("CONDITIONPANEL_REMOVE"+(this._sAddRemoveIconTooltipKey?"_"+this._sAddRemoveIconTooltipKey:"")+"_TOOLTIP"),press:function(){Y._handleRemoveCondition(this.oTargetGrid,Z);},layoutData:new M({span:this.getLayoutMode()==="Desktop"?"L1 M1 S1":"L1 M2 S2"})});i1.oTargetGrid=i;w.addContent(i1);Z["remove"]=i1;var j1=new h({type:E.Transparent,icon:I.getIconURI("add"),tooltip:this._oRb.getText("CONDITIONPANEL_ADD"+(this._sAddRemoveIconTooltipKey?"_"+this._sAddRemoveIconTooltipKey:"")+"_TOOLTIP"),press:function(){Y._handleAddCondition(this.oTargetGrid,Z,true);},layoutData:new M({span:this.getLayoutMode()==="Desktop"?"L1 M1 S1":"L1 M10 S10"})});j1.oTargetGrid=i;j1.addStyleClass("conditionAddBtnFloatRight");w.addContent(j1);Z["add"]=j1;i.insertContent(Z,p);this._updateOperationItems(i,Z);this._changeOperationValueFields(i,Z);this._updateAllConditionsEnableStates();this._updateConditionButtons(i);if(this.getAutoReduceKeyFieldItems()){this._updateKeyFieldItems(i,false);}if(this._sLayoutMode){this._updateLayout({name:this._sLayoutMode});}if(j){var k1=this._getFormatedConditionText(j.operation,j.value1,j.value2,j.exclude,j.keyField,j.showIfGrouped);j._oGrid=Z;j.value=k1;this._oConditionsMap[l]=j;}var l1=Z.operation.getSelectedKey();if(l1==="BT"&&Z.value1.setMinDate&&Z.value2.setMaxDate){var m1=Z.value1.getDateValue();var n1=Z.value2.getDateValue();this._updateMinMaxDate(Z,m1,n1);}else{this._updateMinMaxDate(Z,null,null);}return Z;};U.prototype._handleRemoveCondition=function(i,j){var l=i.getContent().indexOf(j);this._removeCondition(i,j);if(this.getAutoReduceKeyFieldItems()){this._updateKeyFieldItems(i,false);}if(l>=0){l=Math.min(l,i.getContent().length-1);var j=i.getContent()[l];setTimeout(function(){j.remove.focus();});}this._updatePaginatorToolbar();};U.prototype._handleAddCondition=function(i,j,l){var p=i.getContent().indexOf(j);var n=this._createConditionRow(i,undefined,null,p+1,l);this._changeField(n);setTimeout(function(){n.keyField.focus();});this._updatePaginatorToolbar();};U.prototype._getCurrentKeyFieldItem=function(i){if(i.getSelectedKey&&i.getSelectedKey()){var j=i.getSelectedKey();var l=this._aKeyFields;for(var n in l){var p=l[n];if(p.key===j){return p;}}}return null;};U.prototype._createValueField=function(j,n,p){var w;var X;var Y=this;var Z={value:n["Value"],width:"100%",placeholder:n["Label"],change:function(i){Y._validateAndFormatFieldValue(i);Y._changeField(p,i);},layoutData:new M({span:n["Span"+this._sConditionType]})};if(j&&j.typeInstance){var $=j.typeInstance;X=this._findConfig($,"ctrl");if(X==="DateTimePicker"&&$.getMetadata().getName()==="sap.ui.model.odata.type.DateTime"){if(!($.oConstraints&&$.oConstraints.isDateOnly)){A.error("sap.m.P13nConditionPanel","sap.ui.model.odata.type.DateTime without displayFormat = Date is not supported!");$.oConstraints=Object.assign({},$.oConstraints,{isDateOnly:true});}X="DatePicker";}p.oType=$;if(X=="select"){var _=[];var a1=j.values||this._oTypeValues[X]||["",$.formatValue(false,"string"),$.formatValue(true,"string")];a1.forEach(function(i,c1){_.push(new d({key:c1.toString(),text:i.toString()}));});Z={width:"100%",items:_,change:function(){Y._changeField(p);},layoutData:new M({span:n["Span"+this._sConditionType]})};w=new t(Z);}else if(X=="TimePicker"){if($.oFormatOptions&&$.oFormatOptions.style){Z.displayFormat=$.oFormatOptions.style;}w=new y(Z);}else if(X=="DateTimePicker"){if($.oFormatOptions&&$.oFormatOptions.style){Z.displayFormat=$.oFormatOptions.style;}w=new z(Z);}else if(X==="DatePicker"){if($.oFormatOptions){Z.displayFormat=$.oFormatOptions.style||$.oFormatOptions.pattern;if($.isA("sap.ui.comp.odata.type.StringDate")){Z.valueFormat="yyyyMMdd";}}w=new x(Z);}else{w=new v(Z);if(this._fSuggestCallback){j=this._getCurrentKeyFieldItem(p.keyField);if(j&&j.key){var b1=this._fSuggestCallback(w,j.key);if(b1){w._oSuggestProvider=b1;}}}}}else{p.oType=null;w=new v(Z);}if(X!=="boolean"&&X!=="enum"&&w){w.onpaste=function(c1){var d1;if(window.clipboardData){d1=window.clipboardData.getData("Text");}else{d1=c1.originalEvent.clipboardData.getData('text/plain');}var p=c1.srcControl.getParent();var e1=d1.split(/\r\n|\r|\n/g);var f1=p.operation;var op=f1.getSelectedKey();if(e1&&e1.length>1&&op!=="BT"){setTimeout(function(){var g1=e1?e1.length:0;var h1=Y._getCurrentKeyFieldItem(p.keyField);var f1=p.operation;for(var i=0;i<g1;i++){if(Y._aConditionKeys.length>=Y._getMaxConditionsAsNumber()){break;}var i1=e1[i].trim();if(i1){var j1;if(h1.typeInstance){try{j1=h1.typeInstance.parseValue(i1,"string");h1.typeInstance.validateValue(j1);}catch(k1){A.error("sap.m.P13nConditionPanel.onPaste","not able to parse value "+i1+" with type "+h1.typeInstance.getName());i1="";j1=null;}if(!j1){continue;}}var l1={"key":Y._createConditionKey(),"exclude":Y.getExclude(),"operation":f1.getSelectedKey(),"keyField":h1.key,"value1":j1,"value2":null};Y._addCondition2Map(l1);Y.fireDataChange({key:l1.key,index:l1.index,operation:"add",newData:l1});}}Y._clearConditions();Y._fillConditions();},0);}};}if(j&&j.maxLength&&w.setMaxLength){var l=-1;if(typeof j.maxLength==="string"){l=parseInt(j.maxLength);}if(typeof j.maxLength==="number"){l=j.maxLength;}if(l>0&&(!w.getShowSuggestion||!w.getShowSuggestion())){w.setMaxLength(l);}}return w;};U.prototype._fillOperationListItems=function(i,j,l){if(l==="_STRING_"){l="";}if(l==="_TIME_"||l==="_DATETIME_"){l="_DATE_";}if(l==="_BOOLEAN_"||l==="_NUMC_"){l="";}i.destroyItems();for(var n in j){var p=this._oRb.getText("CONDITIONPANEL_OPTION"+l+j[n]);if(p.startsWith("CONDITIONPANEL_OPTION")){p=this._oRb.getText("CONDITIONPANEL_OPTION"+j[n]);}i.addItem(new L({key:j[n],text:p,tooltip:p}));}};U.prototype._fillKeyFieldListItems=function(i,j){i.destroyItems();for(var l in j){var n=j[l];i.addItem(new L({key:n.key,text:n.text,tooltip:n.tooltip?n.tooltip:n.text}));}i.setEditable(i.getItems().length>1);};U.prototype._handleChangeOnOperationField=function(i,j){this._changeOperationValueFields(i,j);this._changeField(j);};U.prototype._handleSelectionChangeOnKeyField=function(i,j){if(this._sConditionType==="Filter"){this._updateOperationItems(i,j);this._createAndUpdateValueFields(i,j);this._changeOperationValueFields(i,j);}this._changeField(j);};U.prototype._handleChangeOnKeyField=function(i,j){if(this.getAutoReduceKeyFieldItems()){this._updateKeyFieldItems(i,false,false,j.keyField);}};U.prototype._createAndUpdateAllKeyFields=function(){var i=this._oConditionsGrid.getContent();i.forEach(function(j){this._createAndUpdateValueFields(this._oConditionsGrid,j);this._changeOperationValueFields(this._oConditionsGrid,j);},this);};U.prototype._createAndUpdateValueFields=function(i,j){var l=this._getCurrentKeyFieldItem(j.keyField);var n=function(j,p,w){var X=p.getValue?p.getValue():"";var Y=j.indexOfContent(p);j.removeContent(p);if(p._oSuggestProvider){p._oSuggestProvider.destroy();p._oSuggestProvider=null;}p.destroy();var Z=this._aConditionsFields[w];p=this._createValueField(l,Z,j);j[Z["ID"]]=p;j.insertContent(p,Y===-1?j.indexOfContent(j.operation)+1:Y);var $,_;if(j.oType&&X){try{$=j.oType.parseValue(X,"string");j.oType.validateValue($);_=j.oType.formatValue($,"string");p.setValue(_);}catch(a1){var b1=a1.message;this._makeFieldValid(p,false,b1);p.setValue(X);}}};n.bind(this)(j,j.value1,5);n.bind(this)(j,j.value2,6);};U.prototype._updateAllOperations=function(){var i=this._oConditionsGrid.getContent();i.forEach(function(j){this._updateOperationItems(this._oConditionsGrid,j);this._changeOperationValueFields(this._oConditionsGrid,j);},this);};U.prototype._updateOperationItems=function(i,j){var l="";var n=this._getCurrentKeyFieldItem(j.keyField);var p=j.operation;var w=this._oTypeOperations["default"];var X=p.getSelectedItem();if(n){if(n.type&&n.type!==""&&this._oTypeOperations[n.type]){l=n.type;w=this._oTypeOperations[l];}if(n.operations){w=n.operations;}}this._fillOperationListItems(p,w,l?"_"+l.toUpperCase()+"_":"");if(X&&p.getItemByKey(X.getKey())){p.setSelectedKey(X.getKey());}else{p.setSelectedItem(p.getItems()[0]);}this._sConditionType="Filter";if(w[0]===W.Ascending||w[0]===W.Descending){this._sConditionType="Sort";}if(w[0]===W.GroupAscending||w[0]===W.GroupDescending){this._sConditionType="Group";}this._adjustValue1Span(j);};U.prototype._updateKeyFieldItems=function(l,p,w,X){var n=l.getContent().length;var i;var Y={};if(!p){for(i=0;i<n;i++){var Z=l.getContent()[i].keyField;var $=Z.getSelectedKey();if($!=null&&$!==""){Y[$]=true;}}}for(i=0;i<n;i++){var Z=l.getContent()[i].keyField;var _=l.getContent()[i].select;var a1=Z.getSelectedKey();var j=0;var b1=this._aKeyFields;if(Z!==X){if(w){j=b1.length-1;}else{Z.destroyItems();}for(j;j<b1.length;j++){var c1=b1[j];if(c1.key==null||c1.key===""||!Y[c1.key]||c1.key===a1){Z.addItem(new L({key:c1.key,text:c1.text,tooltip:c1.tooltip?c1.tooltip:c1.text}));}}Z.setEditable(Z.getItems().length>1);}if(a1){Z.setSelectedKey(a1);}else if(Z.getItems().length>0){Z.setSelectedItem(Z.getItems()[0]);}if(!_.getSelected()){this._aKeyFields.some(function(d1,e1){if(d1.isDefault){Z.setSelectedItem(Z.getItems()[e1]);return true;}if(!Z.getSelectedItem()){if(d1.type!=="boolean"){Z.setSelectedItem(Z.getItems()[e1]);}}},this);}if(Z.getSelectedItem()){Z.setTooltip(Z.getSelectedItem().getTooltip()||Z.getSelectedItem().getText());}}};U.prototype._changeOperationValueFields=function(i,j){var l=j.operation;var n=l.getSelectedKey();var p=j.value1;var w=j.value2;var X=j.showIfGrouped;if(!n){return;}if(n===W.BT){if(p.setPlaceholder&&p.getPlaceholder()!==this._sFromLabelText){p.setPlaceholder(this._sFromLabelText);}if(!p.getVisible()){p.setVisible(true);j.insertContent(p,j.getContent().length-1);}if(w.setPlaceholder&&w.getPlaceholder()!==this._sToLabelText){w.setPlaceholder(this._sToLabelText);}if(!w.getVisible()){w.setVisible(true);j.insertContent(w,j.getContent().length-1);}}else{if(n===W.GroupAscending||n===W.GroupDescending){if(p.getVisible()){p.setVisible(false);j.removeContent(p);}if(w.getVisible()){w.setVisible(false);j.removeContent(w);}if(l.getVisible()){l.setVisible(false);j.removeContent(l);}X.setVisible(this._getMaxConditionsAsNumber()!=1);}else{if(n===W.NotEmpty||n===W.Empty||n===W.Initial||n===W.Ascending||n===W.Descending||n===W.Total||n===W.Average||n===W.Minimum||n===W.Maximum){if(p.getVisible()){p.setVisible(false);j.removeContent(p);}if(w.getVisible()){w.setVisible(false);j.removeContent(w);}j.removeContent(X);}else{if(p.setPlaceholder&&p.getPlaceholder()!==this._sValueLabelText){p.setPlaceholder(this._sValueLabelText);}if(!p.getVisible()){p.setVisible(true);j.insertContent(p,j.getContent().length-1);}if(w.getVisible()){w.setVisible(false);j.removeContent(w);}}}}this._adjustValue1Span(j);};U.prototype._adjustValue1Span=function(i){if(this._sConditionType==="Filter"&&i.value1&&i.operation){var j=i.operation;var n=this._aConditionsFields[5]["Span"+this._sConditionType];if(j.getSelectedKey()!=="BT"){n="L5 M10 S10";}var l=i.value1.getLayoutData();if(l.getSpan()!==n){l.setSpan(n);}}};U.prototype._getIndexOfCondition=function(i){var j=-1;i.getParent().getContent().some(function(l){if(l.select.getSelected()){j++;}return(l===i);},this);return j+this._iFirstConditionIndex;};U.prototype._makeFieldValid=function(i,j,l){if(j){i.setValueState(V.None);i.setValueStateText("");}else{i.setValueState(V.Warning);i.setValueStateText(l?l:this._sValidationDialogFieldMessage);}};U.prototype._validateAndFormatFieldValue=function(i){var j=i.oSource;var l=j.getParent();var n;if(j.getDateValue&&i){n=i.getParameter("value");var p=i.getParameter("valid");this._makeFieldValid(j,p);return;}else{n=j.getValue&&j.getValue();}if(!l){return;}if(this.getDisplayFormat()==="UpperCase"&&n){n=n.toUpperCase();j.setValue(n);}if(l.oType&&n){try{var w=l.oType.parseValue(n,"string");l.oType.validateValue(w);this._makeFieldValid(j,true);n=l.oType.formatValue(w,"string");j.setValue(n);}catch(X){var Y=X.message;this._makeFieldValid(j,false,Y);}}else{this._makeFieldValid(j,true);}};U.prototype._updateMinMaxDate=function(i,j,l){if(i.value1.setMinDate&&i.value2.setMaxDate){if(i.value1&&i.value1.setMaxDate){i.value1.setMaxDate(l instanceof Date?l:null);}if(i.value2&&i.value2.setMinDate){i.value2.setMinDate(j instanceof Date?j:null);}}};U.prototype._changeField=function(i,j){var l=i.keyField.getSelectedKey();if(i.keyField.getSelectedItem()){i.keyField.setTooltip(i.keyField.getSelectedItem().getTooltip()||i.keyField.getSelectedItem().getText());}else{i.keyField.setTooltip(null);}var n=i.operation.getSelectedKey();if(i.operation.getSelectedItem()){i.operation.setTooltip(i.operation.getSelectedItem().getTooltip()||i.operation.getSelectedItem().getText());}else{i.operation.setTooltip(null);}var p=function(h1,i1){var d1;var j1;if(h1.getDateValue&&!(h1.isA("sap.m.TimePicker"))&&i1.getName()!=="sap.ui.comp.odata.type.StringDate"){j1=h1.getDateValue();if(i1&&j1){if(j&&j.getParameter("valid")){d1=i1.formatValue(j1,"string");}else{d1="";}}}else{d1=this._getValueTextFromField(h1);j1=d1;if(i1&&i1.getName()==="sap.ui.comp.odata.type.StringDate"){d1=i1.formatValue(j1,"string");}else if(i1&&d1){try{j1=i1.parseValue(d1,"string");i1.validateValue(j1);}catch(k1){A.error("sap.m.P13nConditionPanel","not able to parse value "+d1+" with type "+i1.getName());d1="";}}}return[j1,d1];}.bind(this);var w=p(i.value1,i.oType);var X=w[0],Y=w[1];w=p(i.value2,i.oType);var Z=w[0],$=w[1];if(n==="BT"){this._updateMinMaxDate(i,X,Z);}else{this._updateMinMaxDate(i,null,null);}var _=this._getCurrentKeyFieldItem(i.keyField);if(_&&_.type==="numc"){if([W.Contains,W.EndsWith].indexOf(n)!=-1){X=i.oType.formatValue(X,"string");}}var a1=i.showIfGrouped.getSelected();var b1=this.getExclude();var c1=i.select;var d1="";var e1;if(l===""||l==null){l=null;e1=this._getKeyFromConditionGrid(i);this._removeConditionFromMap(e1);this._enableCondition(i,false);var f1=this._getIndexOfCondition(i);if(c1.getSelected()){c1.setSelected(false);c1.setEnabled(false);this._bIgnoreSetConditions=true;this.fireDataChange({key:e1,index:f1,operation:"remove",newData:null});this._bIgnoreSetConditions=false;}return;}this._enableCondition(i,true);d1=this._getFormatedConditionText(n,Y,$,b1,l,a1);var g1={"value":d1,"exclude":b1,"operation":n,"keyField":l,"value1":X,"value2":n===W.BT?Z:null,"showIfGrouped":a1};e1=this._getKeyFromConditionGrid(i);if(d1!==""){c1.setSelected(true);c1.setEnabled(true);var n="update";if(!this._oConditionsMap[e1]){n="add";}this._oConditionsMap[e1]=g1;if(n==="add"){this._aConditionKeys.splice(this._getIndexOfCondition(i),0,e1);}i.data("_key",e1);this.fireDataChange({key:e1,index:this._getIndexOfCondition(i),operation:n,newData:g1});}else if(this._oConditionsMap[e1]!==undefined){this._removeConditionFromMap(e1);i.data("_key",null);var f1=this._getIndexOfCondition(i);if(c1.getSelected()){c1.setSelected(false);c1.setEnabled(false);this._bIgnoreSetConditions=true;this.fireDataChange({key:e1,index:f1,operation:"remove",newData:null});this._bIgnoreSetConditions=false;}}this._updatePaginatorToolbar();};U.prototype._getValueTextFromField=function(i){if(i instanceof t){return i.getSelectedItem()?i.getSelectedItem().getText():"";}return i.getValue();};U.prototype._updateAllConditionsEnableStates=function(){var i=this._oConditionsGrid.getContent();i.forEach(function(j){var l=this._getCurrentKeyFieldItem(j.keyField);var n=l&&l.key!==undefined?l.key:l;var p=n!==""&&n!==null;this._enableCondition(j,p);},this);};U.prototype._enableCondition=function(i,j){i.operation.setEnabled(j);i.value1.setEnabled(j);i.value2.setEnabled(j);i.showIfGrouped.setEnabled(j);};U.prototype._removeCondition=function(i,j){var l=this._getKeyFromConditionGrid(j);var n=-1;if(j.select.getSelected()){n=this._getIndexOfCondition(j);}this._removeConditionFromMap(l);j.destroy();if(i.getContent().length<1){this._createConditionRow(i);}else{this._updateConditionButtons(i);}if(n>=0){this.fireDataChange({key:l,index:n,operation:"remove",newData:null});}};U.prototype._updateConditionButtons=function(j){var l=this._getMaxConditionsAsNumber();var n=j.getContent().length;for(var i=0;i<n;i++){var p=j.getContent()[i].add;if((this.getAlwaysShowAddIcon()&&(n<l))||(i===n-1&&i<l-1)){p.removeStyleClass("displayNone");}else{p.addStyleClass("displayNone");}var w=j.getContent()[i].remove;if(l===1||(i===0&&n===1&&this.getDisableFirstRemoveIcon())){w.addStyleClass("displayNone");}else{w.removeStyleClass("displayNone");}}};U.prototype.validateConditions=function(){var j=this;var l=function(n){var p=true;for(var i=0;i<n.length;i++){var w=n[i];var X=j._checkCondition(w,i===n.length-1);p=p&&X;}return p;};return l(this._oConditionsGrid.getContent());};U.prototype.removeValidationErrors=function(){this._oConditionsGrid.getContent().forEach(function(i){var j=i.value1;var l=i.value2;j.setValueState(V.None);j.setValueStateText("");l.setValueState(V.None);l.setValueStateText("");},this);};U.prototype.removeInvalidConditions=function(){var i=[];this._oConditionsGrid.getContent().forEach(function(j){if(j.value1.getValueState()!==V.None||j.value2.getValueState()!==V.None){i.push(j);}},this);i.forEach(function(j){this._removeCondition(this._oConditionsGrid,j);if(this.getAutoReduceKeyFieldItems()){this._updateKeyFieldItems(this._oConditionsGrid,false);}},this);};U.prototype._checkCondition=function(i,j){var l=true;var n=i.value1;var p=i.value2;var w=n&&(n.getVisible()&&!this._getValueTextFromField(n));var X=n&&n.getVisible()&&n.getValueState?n.getValueState():V.None;var Y=p&&(p.getVisible()&&!this._getValueTextFromField(p));var Z=p&&p.getVisible()&&p.getValueState?p.getValueState():V.None;var $=i.operation.getSelectedKey();if($===W.BT){if(!w?Y:!Y){if(w){n.setValueState(V.Warning);n.setValueStateText(this._sValidationDialogFieldMessage);}if(Y){p.setValueState(V.Warning);p.setValueStateText(this._sValidationDialogFieldMessage);}l=false;}else if(X!==V.None||Z!==V.None){l=false;}else{n.setValueState(V.None);n.setValueStateText("");p.setValueState(V.None);p.setValueStateText("");}}if((n.getVisible()&&n.getValueState&&n.getValueState()!==V.None)||(p.getVisible()&&p.getValueState&&p.getValueState()!==V.None)){l=false;}return l;};U.prototype._getFormatedConditionText=function(j,l,n,p,w,X){var Y=U.getFormatedConditionText(j,l,n,p);if(!Y){switch(j){case W.Initial:Y="=''";break;case W.NotEmpty:Y="!''";break;case W.Ascending:Y="ascending";break;case W.GroupAscending:Y="ascending";Y+=" showIfGrouped:"+X;break;case W.Descending:Y="descending";break;case W.GroupDescending:Y="descending";Y+=" showIfGrouped:"+X;break;case W.Total:Y="total";break;case W.Average:Y="average";break;case W.Minimum:Y="minimum";break;case W.Maximum:Y="maximum";break;}if(p&&Y!==""){Y="!("+Y+")";}}if(this._aKeyFields&&this._aKeyFields.length>1){var Z=null;for(var i=0;i<this._aKeyFields.length;i++){var $=this._aKeyFields[i];if(typeof $!=="string"){if($.key===w&&$.text){Z=$.text;}}}if(Z&&Y!==""){Y=Z+": "+Y;}}return Y;};var W=sap.m.P13nConditionOperation={BT:"BT",EQ:"EQ",Contains:"Contains",StartsWith:"StartsWith",EndsWith:"EndsWith",LT:"LT",LE:"LE",GT:"GT",GE:"GE",Initial:"Initial",Empty:"Empty",NotEmpty:"NotEmpty",Ascending:"Ascending",Descending:"Descending",GroupAscending:"GroupAscending",GroupDescending:"GroupDescending",Total:"Total",Average:"Average",Minimum:"Minimum",Maximum:"Maximum"};U._oConditionMap={"EQ":"=$0","GT":">$0","GE":">=$0","LT":"<$0","LE":"<=$0","Contains":"*$0*","StartsWith":"$0*","EndsWith":"*$0","BT":"$0...$1","Empty":"<$r>"};(function(){var _=sap.ui.getCore().getLibraryResourceBundle("sap.m");U._oConditionMap[W.Empty]=U._oConditionMap[W.Empty].replace("$r",_.getText("CONDITIONPANEL_OPTIONEmpty"));})();U._templateReplace=function(i,j){return i.replace(/\$\d/g,function(l){return j[parseInt(l.substr(1))];});};U.getFormatedConditionText=function(i,j,l,n){var p="";switch(i){case W.Empty:p=U._templateReplace(U._oConditionMap[i],[]);break;case W.EQ:case W.GT:case W.GE:case W.LT:case W.LE:case W.Contains:case W.StartsWith:case W.EndsWith:if(j!==""&&j!==undefined){p=U._templateReplace(U._oConditionMap[i],[j]);}break;case W.BT:if(j!==""&&j!==undefined){if(l!==""&&l!==undefined){p=U._templateReplace(U._oConditionMap[i],[j,l]);}}break;default:break;}if(n&&p!==""){p="!("+p+")";}return p;};U.prototype._updateLayout=function(j){if(!this._oConditionsGrid){return;}var l=this._oConditionsGrid.getContent();var n=this._aConditionsFields.length;var p=n;if(j.name==="Tablet"){p=5;}if(j.name==="Phone"){p=3;}if(this._sConditionType==="Filter"){for(var i=0;i<l.length;i++){var w=l[i];w.ButtonContainer.removeStyleClass("floatRight");w.removeContent(w.ButtonContainer);w.insertContent(w.ButtonContainer,p);if(!this.getAlwaysShowAddIcon()){if(p!==n){w.ButtonContainer.removeContent(w.add);w.addContent(w.add);}else{w.removeContent(w.add);w.ButtonContainer.addContent(w.add);}}}}};U.prototype._onGridResize=function(){var w;if(this._oPaginatorToolbar&&this._oConditionsGrid&&this._oConditionsGrid.getContent().length>0){var i=this._oConditionsGrid.getContent()[0];if(i.remove&&i.remove.$().position()){w=0;if(this._oPaginatorToolbar.getParent()&&this._oPaginatorToolbar.getParent().getExpandable&&this._oPaginatorToolbar.getParent().getExpandable()){w=48-4;}var j=i.remove.$().position().left-w+i.remove.$().width();this._oPaginatorToolbar.setWidth(j+"px");}}var l=this._oConditionsGrid.getDomRef();if(!l){return;}if(!Q(l).is(":visible")){return;}w=l.clientWidth;var n={};if(w<=this._iBreakPointTablet){n.name="Phone";}else if((w>this._iBreakPointTablet)&&(w<=this._iBreakPointDesktop)){n.name="Tablet";}else{n.name="Desktop";}if(n.name==="Phone"&&this._sLayoutMode!==n.name){this._updateLayout(n);this._sLayoutMode=n.name;}if(n.name==="Tablet"&&this._sLayoutMode!==n.name){this._updateLayout(n);this._sLayoutMode=n.name;}if(n.name==="Desktop"&&this._sLayoutMode!==n.name){this._updateLayout(n);this._sLayoutMode=n.name;}};U.prototype._findConfig=function(i,j){if(typeof i==="object"){i=i.getMetadata().getName();}var l;while(i&&!(l=this._getConfig(i,j))){i=this._getParentType(i);}return l;};U.prototype._getConfig=function(i,j){var l=this._mOpsForType[i];if(l){return l[j];}};U.prototype._getParentType=function(i){return this._mTypes[i];};U.prototype._mTypes={"base":undefined,"string":"base","numeric":"base","date":"base","time":"base","boolean":"base","int":"numeric","float":"numeric","sap.ui.model.type.Boolean":"boolean","sap.ui.model.type.Date":"date","sap.ui.model.type.FileSize":"string","sap.ui.model.type.Float":"float","sap.ui.model.type.Integer":"int","sap.ui.model.type.String":"string","sap.ui.model.type.Time":"time","sap.ui.comp.odata.type.StringDate":"date","sap.ui.model.odata.type.Boolean":"boolean","sap.ui.model.odata.type.Byte":"int","sap.ui.model.odata.type.Date":"date","sap.ui.model.odata.type.DateTime":"datetime","sap.ui.model.odata.type.DateTimeOffset":"datetime","sap.ui.model.odata.type.Decimal":"float","sap.ui.model.odata.type.Double":"float","sap.ui.model.odata.type.Single":"float","sap.ui.model.odata.type.Guid":"string","sap.ui.model.odata.type.Int16":"int","sap.ui.model.odata.type.Int32":"int","sap.ui.model.odata.type.Int64":"int","sap.ui.model.odata.type.Raw":"string","sap.ui.model.odata.type.SByte":"int","sap.ui.model.odata.type.String":"string","sap.ui.model.odata.type.Time":"time","sap.ui.model.odata.type.TimeOfDay":"time","Edm.Boolean":"sap.ui.model.odata.type.Boolean","Edm.Byte":"sap.ui.model.odata.type.Byte","Edm.Date":"sap.ui.model.odata.type.Date","Edm.DateTime":"sap.ui.model.odata.type.DateTime","Edm.DateTimeOffset":"sap.ui.model.odata.type.DateTimeOffset","Edm.Decimal":"sap.ui.model.odata.type.Decimal","Edm.Double":"sap.ui.model.odata.type.Double","Edm.Single":"sap.ui.model.odata.type.Single","Edm.Guid":"sap.ui.model.odata.type.Guid","Edm.Int16":"sap.ui.model.odata.type.Int16","Edm.Int32":"sap.ui.model.odata.type.Int32","Edm.Int64":"sap.ui.model.odata.type.Int64","Edm.SByte":"sap.ui.model.odata.type.SByte","Edm.String":"sap.ui.model.odata.type.String","Edm.Time":"sap.ui.model.odata.type.Time","Edm.TimeOfDay":"sap.ui.model.odata.type.TimeOfDay"};U.prototype._mOpsForType={"base":{ctrl:"input"},"string":{ctrl:"input"},"date":{ctrl:"DatePicker"},"datetime":{ctrl:"DateTimePicker"},"numeric":{ctrl:"input"},"time":{ctrl:"TimePicker"},"boolean":{ctrl:"select"}};return U;});
