/*
 * ! OpenUI5
 * (c) Copyright 2009-2019 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(['./library','./P13nConditionPanel','./P13nPanel','./P13nSortItem'],function(l,P,a,c){"use strict";var d=l.P13nPanelType;var e=l.P13nConditionOperation;var f=a.extend("sap.m.P13nSortPanel",{metadata:{library:"sap.m",properties:{containerQuery:{type:"boolean",group:"Misc",defaultValue:false},layoutMode:{type:"string",group:"Misc",defaultValue:null}},aggregations:{content:{type:"sap.ui.core.Control",multiple:true,singularName:"content",visibility:"hidden"},sortItems:{type:"sap.m.P13nSortItem",multiple:true,singularName:"sortItem",bindable:"bindable"}},events:{addSortItem:{},removeSortItem:{},updateSortItem:{}}},renderer:function(r,C){if(!C.getVisible()){return;}r.write("<section");r.writeControlData(C);r.addClass("sapMSortPanel");r.writeClasses();r.writeStyles();r.write(">");r.write("<div");r.addClass("sapMSortPanelContent");r.addClass("sapMSortPanelBG");r.writeClasses();r.write(">");var b=C.getAggregation("content");var L=b.length;for(var i=0;i<L;i++){r.renderControl(b[i]);}r.write("</div>");r.write("</section>");}});f.prototype._getConditions=function(){return this._oSortPanel.getConditions();};f.prototype.setContainerQuery=function(b){this.setProperty("containerQuery",b);this._oSortPanel.setContainerQuery(b);return this;};f.prototype.setLayoutMode=function(m){this.setProperty("layoutMode",m);this._oSortPanel.setLayoutMode(m);return this;};f.prototype.validateConditions=function(){return this._oSortPanel.validateConditions();};f.prototype.removeInvalidConditions=function(){this._oSortPanel.removeInvalidConditions();};f.prototype.removeValidationErrors=function(){this._oSortPanel.removeValidationErrors();};f.prototype.onBeforeNavigationFrom=function(){return this.validateConditions();};f.prototype.onAfterNavigationFrom=function(){return this.removeInvalidConditions();};f.prototype.setOperations=function(o){this._aOperations=o;if(this._oSortPanel){this._oSortPanel.setOperations(this._aOperations);}return this;};f.prototype.init=function(){this.setType(d.sort);this.setTitle(sap.ui.getCore().getLibraryResourceBundle("sap.m").getText("SORTPANEL_TITLE"));sap.ui.getCore().loadLibrary("sap.ui.layout");this._aKeyFields=[];if(!this._aOperations){this.setOperations([e.Ascending,e.Descending]);}this._oSortPanel=new P({autoReduceKeyFieldItems:true,layoutMode:this.getLayoutMode(),dataChange:this._handleDataChange()});this._oSortPanel.setOperations(this._aOperations);this._oSortPanel._sAddRemoveIconTooltipKey="SORT";this.addAggregation("content",this._oSortPanel);};f.prototype.exit=function(){var b=function(o){if(o&&o.destroy){o.destroy();}return null;};this._aKeyFields=b(this._aKeyFields);this._aOperations=b(this._aOperations);};f.prototype.onBeforeRendering=function(){if(this._bUpdateRequired){this._bUpdateRequired=false;var k=[];var m=(this.getBindingInfo("items")||{}).model;var g=function(n,o,i){var b=i.getBinding(n);if(b&&o){return o.getObject()[b.getPath()];}return i.getMetadata().getProperty(n)?i.getProperty(n):i.getAggregation(n);};this.getItems().forEach(function(i){var o=i.getBindingContext(m);if(i.getBinding("key")){o.getObject()[i.getBinding("key").getPath()]=i.getKey();}k.push({key:i.getColumnKey(),text:g("text",o,i),tooltip:g("tooltip",o,i)});});k.splice(0,0,{key:null,text:sap.ui.getCore().getLibraryResourceBundle("sap.m").getText("P13NDIALOG_SELECTION_NONE")});this._oSortPanel.setKeyFields(k);var C=[];m=(this.getBindingInfo("sortItems")||{}).model;this.getSortItems().forEach(function(s){var o=s.getBindingContext(m);if(s.getBinding("key")){o.getObject()[s.getBinding("key").getPath()]=s.getKey();}C.push({key:s.getKey(),keyField:g("columnKey",o,s),operation:g("operation",o,s)});});this._oSortPanel.setConditions(C);}};f.prototype.addItem=function(i){a.prototype.addItem.apply(this,arguments);if(!this._bIgnoreBindCalls){this._bUpdateRequired=true;}return this;};f.prototype.removeItem=function(i){var r=a.prototype.removeItem.apply(this,arguments);if(!this._bIgnoreBindCalls){this._bUpdateRequired=true;}return r;};f.prototype.destroyItems=function(){this.destroyAggregation("items");if(!this._bIgnoreBindCalls){this._bUpdateRequired=true;}return this;};f.prototype.addSortItem=function(s){this.addAggregation("sortItems",s,true);if(!this._bIgnoreBindCalls){this._bUpdateRequired=true;}return this;};f.prototype.insertSortItem=function(s,i){this.insertAggregation("sortItems",s,i,true);if(!this._bIgnoreBindCalls){this._bUpdateRequired=true;}return this;};f.prototype.updateSortItems=function(r){this.updateAggregation("sortItems");if(r==="change"&&!this._bIgnoreBindCalls){this._bUpdateRequired=true;this.invalidate();}};f.prototype.removeSortItem=function(s){s=this.removeAggregation("sortItems",s,true);if(!this._bIgnoreBindCalls){this._bUpdateRequired=true;}return s;};f.prototype.removeAllSortItems=function(){var s=this.removeAllAggregation("sortItems",true);if(!this._bIgnoreBindCalls){this._bUpdateRequired=true;}return s;};f.prototype.destroySortItems=function(){this.destroyAggregation("sortItems");if(!this._bIgnoreBindCalls){this._bUpdateRequired=true;}return this;};f.prototype._handleDataChange=function(){var t=this;return function(E){var n=E.getParameter("newData");var o=E.getParameter("operation");var k=E.getParameter("key");var i=E.getParameter("index");var s;if(o==="update"){s=t.getSortItems()[i];if(s){s.setColumnKey(n.keyField);s.setOperation(n.operation);}t.fireUpdateSortItem({key:k,index:i,sortItemData:s});t._notifyChange();}if(o==="add"){s=new c({key:k,columnKey:n.keyField,operation:n.operation});t._bIgnoreBindCalls=true;t.fireAddSortItem({key:k,index:i,sortItemData:s});t._bIgnoreBindCalls=false;t._notifyChange();}if(o==="remove"){t._bIgnoreBindCalls=true;t.fireRemoveSortItem({key:k,index:i});t._bIgnoreBindCalls=false;t._notifyChange();}};};f.prototype._notifyChange=function(){var L=this.getChangeNotifier();if(L){L(this);}};return f;});
