/*!
 * OpenUI5
 * (c) Copyright 2009-2019 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(['sap/m/delegate/DateNavigation','sap/ui/core/Control','sap/ui/base/ManagedObject','sap/ui/base/ManagedObjectObserver','sap/ui/unified/library','sap/ui/unified/calendar/CalendarUtils','sap/ui/unified/calendar/CalendarDate','sap/ui/unified/calendar/DatesRow','sap/ui/unified/calendar/OneMonthDatesRow','sap/ui/unified/calendar/MonthsRow','sap/ui/unified/calendar/TimesRow','sap/ui/unified/DateRange','sap/ui/unified/CalendarAppointment','sap/ui/unified/CalendarRow','sap/ui/unified/CalendarRowRenderer','sap/ui/Device','sap/ui/core/Element','sap/ui/core/Renderer','sap/ui/core/ResizeHandler','sap/ui/core/InvisibleText','sap/ui/core/Item','sap/ui/core/dnd/DragInfo','sap/ui/core/dnd/DropInfo','sap/ui/core/dnd/DragDropInfo','sap/ui/core/format/DateFormat','sap/m/Select','sap/m/Button','sap/m/OverflowToolbar','sap/m/Toolbar','sap/m/Table','sap/m/Column','sap/m/ColumnListItem','sap/m/ColumnListItemRenderer','sap/m/SegmentedButtonItem','sap/m/StandardListItem','sap/m/StandardListItemRenderer','sap/m/PlanningCalendarHeader','sap/m/PlanningCalendarRow','sap/m/PlanningCalendarRenderer','sap/m/PlanningCalendarView','sap/m/CheckBox','sap/m/library',"sap/base/util/deepEqual","sap/base/Log","sap/ui/thirdparty/jquery","sap/ui/dom/jquery/control"],function(D,C,M,a,u,b,c,d,O,e,T,f,g,h,k,l,E,R,m,I,n,o,p,q,r,S,B,s,t,v,w,x,y,z,A,F,P,G,H,J,K,L,N,Q,U){"use strict";var V=L.Sticky;var W=u.CalendarDayType;var X=L.ListMode;var Y=L.ToolbarDesign;var Z=L.PlanningCalendarBuiltInView;var $=L.ScreenSize;var _=u.CalendarAppointmentVisualization;var a1=u.GroupAppointmentsMode;var b1=u.CalendarIntervalType;var c1="DragDropConfig";var d1="ResizeConfig";var e1="CreateConfig";var f1="-CLI";var g1=C.extend("sap.m.PlanningCalendar",{metadata:{library:"sap.m",properties:{startDate:{type:"object",group:"Data"},viewKey:{type:"string",group:"Appearance",defaultValue:b1.Hour},singleSelection:{type:"boolean",group:"Misc",defaultValue:true},width:{type:"sap.ui.core.CSSSize",group:"Dimension",defaultValue:null},height:{type:"sap.ui.core.CSSSize",group:"Dimension",defaultValue:null},showIntervalHeaders:{type:"boolean",group:"Appearance",defaultValue:true},showEmptyIntervalHeaders:{type:"boolean",group:"Appearance",defaultValue:true},showRowHeaders:{type:"boolean",group:"Appearance",defaultValue:true},noDataText:{type:"string",group:"Misc",defaultValue:null},groupAppointmentsMode:{type:"sap.ui.unified.GroupAppointmentsMode",group:"Appearance",defaultValue:a1.Collapsed},appointmentsReducedHeight:{type:"boolean",group:"Appearance",defaultValue:false},appointmentsVisualization:{type:"sap.ui.unified.CalendarAppointmentVisualization",group:"Appearance",defaultValue:_.Standard},minDate:{type:"object",group:"Misc",defaultValue:null},maxDate:{type:"object",group:"Misc",defaultValue:null},showDayNamesLine:{type:"boolean",group:"Appearance",defaultValue:false},showWeekNumbers:{type:"boolean",group:"Appearance",defaultValue:false},builtInViews:{type:"string[]",group:"Appearance",defaultValue:[]},stickyHeader:{type:"boolean",group:"Appearance",defaultValue:false}},aggregations:{rows:{type:"sap.m.PlanningCalendarRow",multiple:true,singularName:"row"},views:{type:"sap.m.PlanningCalendarView",multiple:true,singularName:"view"},specialDates:{type:"sap.ui.unified.DateTypeRange",multiple:true,singularName:"specialDate"},toolbarContent:{type:"sap.ui.core.Control",multiple:true,singularName:"toolbarContent",forwarding:{getter:"_getHeader",aggregation:"actions"},forwardBinding:true},table:{type:"sap.m.Table",multiple:false,visibility:"hidden"},header:{type:"sap.ui.core.Control",multiple:false,visibility:"hidden"}},associations:{ariaLabelledBy:{type:"sap.ui.core.Control",multiple:true,singularName:"ariaLabelledBy"},legend:{type:"sap.ui.unified.CalendarLegend",multiple:false}},events:{appointmentSelect:{parameters:{appointment:{type:"sap.ui.unified.CalendarAppointment"},appointments:{type:"sap.ui.unified.CalendarAppointment[]"},multiSelect:{type:"boolean"},domRefId:{type:"string"}}},intervalSelect:{parameters:{startDate:{type:"object"},endDate:{type:"object"},subInterval:{type:"boolean"},row:{type:"sap.m.PlanningCalendarRow"}}},rowSelectionChange:{parameters:{rows:{type:"sap.m.PlanningCalendarRow[]"}}},startDateChange:{},viewChange:{},rowHeaderClick:{row:{type:"sap.m.PlanningCalendarRow"}}},designtime:"sap/m/designtime/PlanningCalendar.designtime"},constructor:function(i,j){C.prototype.constructor.apply(this,arguments);if(typeof i!=="string"){j=i;}if(j&&typeof j.customAppointmentsSorterCallback==="function"){this._fnCustomSortedAppointments=j.customAppointmentsSorterCallback;}}});var h1=["_oTimesRow","_oDatesRow","_oMonthsRow","_oWeeksRow","_oOneMonthsRow"],i1={};i1[b1.Day]={sInstanceName:"_oDatesRow",sIdSuffix:"-DatesRow",oClass:d};i1[b1.Week]={sInstanceName:"_oWeeksRow",sIdSuffix:"-WeeksRow",oClass:d};i1[b1.OneMonth]={sInstanceName:"_oOneMonthsRow",sIdSuffix:"-OneMonthsRow",oClass:O};var j1=$.Desktop;var k1=[Z.Hour,Z.Day,Z.Month,Z.Week,Z.OneMonth];var l1={PHONE:"600",TABLET:"1024"};var m1=["sap.ui.unified.calendar.TimesRow","sap.ui.unified.calendar.DatesRow","sap.ui.unified.calendar.MonthsRow","sap.ui.unified.calendar.OneMonthDatesRow"];var n1=C.extend("CalendarHeader",{metadata:{aggregations:{"toolbar":{type:"sap.m.Toolbar",multiple:false},"allCheckBox":{type:"sap.m.CheckBox",multiple:false}}},renderer:function(i,j){i.write("<div");i.writeControlData(j);i.addClass("sapMPlanCalHead");i.writeClasses();i.write(">");var O1=j.getToolbar();if(O1){i.renderControl(O1);}var P1=j.getAllCheckBox();if(P1){i.renderControl(P1);}i.write("</div>");}});g1.prototype.init=function(){this._dateNav=new D();this._iBreakPointTablet=l.media._predefinedRangeSets[l.media.RANGESETS.SAP_STANDARD_EXTENDED].points[0];this._iBreakPointDesktop=l.media._predefinedRangeSets[l.media.RANGESETS.SAP_STANDARD_EXTENDED].points[1];this._iBreakPointLargeDesktop=l.media._predefinedRangeSets[l.media.RANGESETS.SAP_STANDARD_EXTENDED].points[2];if(l.system.phone||U('html').hasClass("sapUiMedia-Std-Phone")){this._iSize=0;this._iSizeScreen=0;}else if((l.system.tablet||U('html').hasClass("sapUiMedia-Std-Tablet"))&&!(l.system.desktop||U('html').hasClass("sapUiMedia-Std-Desktop"))){this._iSize=1;this._iSizeScreen=1;}else{this._iSize=2;this._iSizeScreen=2;}this.setAggregation("header",this._createHeader());this._attachHeaderEvents();this._oRB=sap.ui.getCore().getLibraryResourceBundle("sap.m");var i=this.getId();this._oIntervalTypeSelect=this._getHeader()._getOrCreateViewSwitch();this._oIntervalTypeSelect.attachEvent("selectionChange",o1,this);this._oTodayButton=this._getHeader()._getTodayButton();this._oCalendarHeader=new n1(i+"-CalHead",{});this._oInfoToolbar=new t(i+"-InfoToolbar",{height:"auto",design:Y.Transparent,content:[this._oCalendarHeader,this._oTimesRow]});var j=new v(i+"-Table",{sticky:[],infoToolbar:this._oInfoToolbar,mode:X.SingleSelectMaster,columns:[new w({styleClass:"sapMPlanCalRowHead"}),new w({width:"80%",styleClass:"sapMPlanCalAppRow",minScreenWidth:j1,demandPopin:true})],ariaLabelledBy:i+"-Descr"});j.attachEvent("selectionChange",E1,this);j.addDelegate({onBeforeRendering:function(){if(this._rowHeaderClickEvent){this._rowHeaderClickEvent.off();}},onAfterRendering:function(){this._rowHeaderClickEvent=j.$().find(".sapMPlanCalRowHead > div.sapMLIB").click(function(O1){var P1=U(O1.currentTarget).control(0),Q1=A1(P1.getParent());this.fireRowHeaderClick({row:Q1});}.bind(this));this._adjustColumnHeadersTopOffset();}},false,this);this.setAggregation("table",j,true);this.setStartDate(new Date());this._resizeProxy=U.proxy(s1,this);this._fnCustomSortedAppointments=undefined;this.iWidth=0;};g1.prototype.exit=function(){if(this._sResizeListener){m.deregister(this._sResizeListener);this._sResizeListener=undefined;}l.orientation.detachHandler(this._updateStickyHeader,this);if(this._sUpdateCurrentTime){clearTimeout(this._sUpdateCurrentTime);this._sUpdateCurrentTime=undefined;}var i=this.getAggregation("table");i.removeAllItems();h1.forEach(function(O1){if(this[O1]){this[O1]._oPlanningCalendar=undefined;this[O1].destroy();this[O1]=undefined;}},this);if(this._oViews){for(var j in this._oViews){this._oViews[j].destroy();}}if(this._oSelectAllCheckBox){this._oSelectAllCheckBox.destroy();}if(this._rowHeaderClickEvent){this._rowHeaderClickEvent.off();this._rowHeaderClickEvent=null;}};g1.prototype.onBeforeRendering=function(){this._bBeforeRendering=true;if((!this._oTimesRow&&!this._oDatesRow&&!this._oMonthsRow&&!this._oWeeksRow&&!this._oOneMonthsRow)||this._bCheckView){this.setViewKey(this.getViewKey());this._bCheckView=undefined;}H1.call(this);if(this._sUpdateCurrentTime){clearTimeout(this._sUpdateCurrentTime);this._sUpdateCurrentTime=undefined;}this._updatePickerSelection();l.orientation.detachHandler(this._updateStickyHeader,this);this._bBeforeRendering=undefined;this._toggleStickyClasses();};g1.prototype.attachEvent=function(i,j,O1,P1){C.prototype.attachEvent.call(this,i,j,O1,P1);if(this.hasListeners("intervalSelect")){h1.forEach(function(Q1){if(this[Q1]){this[Q1]._setAriaRole("button");}},this);}return this;};g1.prototype.detachEvent=function(i,j,O1){C.prototype.detachEvent.call(this,i,j,O1);if(!this.hasListeners("intervalSelect")){h1.forEach(function(P1){if(this[P1]){this[P1]._setAriaRole("gridcell");}},this);}return this;};g1.prototype._createHeader=function(){var i=new P(this.getId()+"-Header");i.getAggregation("_actionsToolbar").addAriaLabelledBy(I.getStaticId("sap.m","PC_FUNCTIONS_TOOLBAR"));i.getAggregation("_navigationToolbar").addAriaLabelledBy(I.getStaticId("sap.m","PC_INTERVAL_SELECTION_TOOLBAR"));return i;};g1.prototype._attachHeaderEvents=function(){var i=this._getHeader();i.attachEvent("pressPrevious",this._handlePressArrow,this);i.attachEvent("pressToday",this._handleTodayPress,this);i.attachEvent("pressNext",this._handlePressArrow,this);i.attachEvent("dateSelect",this._handleDateSelect,this);return this;};g1.prototype._handlePressArrow=function(i){this._applyArrowsLogic(i.getId()==="pressPrevious");};g1.prototype._applyArrowsLogic=function(i){if(i){this._dateNav.previous();}else{this._dateNav.next();}var j=this._getRowInstanceByViewKey(this.getViewKey());this.setStartDate(this._dateNav.getStart());j.setDate(this._dateNav.getCurrent());this._updatePickerSelection();this.fireStartDateChange();};g1.prototype._formatPickerText=function(){var i=this._getFirstAndLastRangeDate(),j=b._createLocalDate(i.oStartDate,true),O1=b._createLocalDate(i.oEndDate,true),P1=this.getViewKey(),Q1=b1[P1]?b1[P1]:this._getView(P1).getIntervalType(),R1=sap.ui.getCore().getConfiguration().getRTL(),S1,T1,U1,V1;switch(Q1){case b1.Hour:S1=r.getDateInstance({format:"yMMMMd"});U1=S1.format(j);if(j.getDate()!==O1.getDate()){V1=S1.format(O1);}break;case b1.Day:case b1.Week:S1=r.getDateInstance({format:"yMMMMd"});U1=S1.format(j);V1=S1.format(O1);break;case b1.OneMonth:S1=r.getDateInstance({format:"yMMMM"});U1=S1.format(j);break;case b1.Month:S1=r.getDateInstance({format:"y"});U1=S1.format(j);if(j.getFullYear()!==O1.getFullYear()){V1=S1.format(O1);}break;default:throw new Error("Unknown IntervalType: "+P1+"; "+this);}if(!R1){T1=U1;if(V1){T1+=" - "+V1;}}else{if(V1){T1=V1+" - "+U1;}else{T1=U1;}}return T1;};g1.prototype._getFirstAndLastRangeDate=function(){var i=b._createUniversalUTCDate(this.getStartDate(),"Gregorian",true),j=b._createUniversalUTCDate(this._dateNav.getEnd(),"Gregorian",true);return{oStartDate:i,oEndDate:j};};g1.prototype._getHeader=function(){return this.getAggregation("header");};g1.prototype._toggleStickyClasses=function(){this.toggleStyleClass("sapMPCSticky",this.getStickyHeader());return this;};g1.prototype._adjustColumnHeadersTopOffset=function(){var i=this.getStickyHeader(),j=this.getDomRef().querySelector(".sapMListInfoTBarContainer"),O1;switch(i){case true:O1=this._getHeader().$().outerHeight()+"px";break;default:O1="auto";break;}j.style.top=O1;return this;};g1.prototype._setAriaRole=function(i){if(this.hasListeners("intervalSelect")){i._setAriaRole("button");}else{i._setAriaRole("gridcell");}};g1.prototype._updateTodayButtonState=function(){if(this._oTodayButton){this._oTodayButton.setEnabled(!this._dateMatchesVisibleRange(new Date(),this.getViewKey()));}};g1.prototype._dateMatchesVisibleRange=function(i,j){var O1=this._getView(j,!this._bBeforeRendering);if(!O1){return false;}var P1=O1.getIntervalType(),Q1=i1[P1],R1=Q1?this[Q1.sInstanceName]:null,S1=false;if(R1&&j==="One Month"){return b._isSameMonthAndYear(c.fromLocalJSDate(this.getStartDate()),c.fromLocalJSDate(i));}else if(R1&&j==="Week"){var T1=R1.getDays(),U1=c.fromLocalJSDate(i),V1=c.fromLocalJSDate(this.getStartDate()),W1=c.fromLocalJSDate(this.getStartDate());W1.setDate(W1.getDate()+T1);return U1.isSameOrAfter(V1)&&U1.isBefore(W1);}return S1;};g1.prototype.onAfterRendering=function(i){i.size={width:this.getDomRef().offsetWidth};s1.call(this,i,true);if(!this._sResizeListener){this._sResizeListener=m.register(this,this._resizeProxy);}if(l.system.phone&&this.getStickyHeader()){l.orientation.attachHandler(this._updateStickyHeader,this);}this._updateCurrentTimeVisualization(false);if(this.getHeight()){var j=this.getDomRef().querySelector("table");if(this.getHeight().indexOf("%")>-1){j.style.height=this.getHeight();return;}var O1=this.$().height()-this._oInfoToolbar.$().height()+"px";j.style.height=O1;}this._adjustColumnHeadersTopOffset();};g1.prototype.onThemeChanged=function(){if(this.getDomRef()){this._adjustColumnHeadersTopOffset();}};g1.prototype.addToolbarContent=function(i){if(i&&i.isA("sap.m.Title")){this._getHeader().setTitle(i.getText());}else{this.addAggregation("toolbarContent",i);}return this;};g1.prototype.insertToolbarContent=function(i,j){if(i&&i.isA("sap.m.Title")){this._getHeader().setTitle(i.getText());}else{this.insertAggregation("toolbarContent",i,j);}return this;};g1.prototype.removeToolbarContent=function(i){var j;if(i&&i.isA("sap.m.Title")){this._getHeader().setTitle("");}else{j=this.removeAggregation("toolbarContent",i);}return j;};g1.prototype.removeAllToolbarContent=function(){var i=this.removeAllAggregation("toolbarContent");this._getHeader().setTitle("");return i;};g1.prototype.destroyToolbarContent=function(){var i=this.destroyAggregation("toolbarContent");this._getHeader().setTitle("");return i;};g1.prototype.setStartDate=function(i){var j,O1,P1;if(!i){P1=new Date();}else{b._checkJSDateObject(i);P1=new Date(i.getTime());}if(this.getViewKey()===Z.Week){j=b.getFirstDateOfWeek(b._createUniversalUTCDate(P1,undefined,true));P1.setTime(b._createLocalDate(j,true).getTime());}if(this.getViewKey()===Z.OneMonth||this.getViewKey()===Z.Month){O1=b.getFirstDateOfMonth(b._createUniversalUTCDate(P1,undefined,true));P1.setTime(b._createLocalDate(O1,true).getTime());}if(N(P1,this.getStartDate())){this._updateTodayButtonState();return this;}var Q1=P1.getFullYear();b._checkYearInValidRange(Q1);var R1=this.getMinDate();if(R1&&R1.getTime()>P1.getTime()){Q.warning("StartDate < minDate -> StartDate set to minDate",this);P1=new Date(R1.getTime());}else{var S1=this.getMaxDate();if(S1&&S1.getTime()<P1.getTime()){Q.warning("StartDate > maxDate -> StartDate set to minDate",this);if(R1){P1=new Date(R1.getTime());}else{P1=new Date(1,0,1);P1.setFullYear(1);}}}this.setProperty("startDate",P1,true);this._dateNav.setStart(P1);this._getHeader().setStartDate(P1);h1.forEach(function(T1){if(this[T1]){this[T1].setStartDate(new Date(P1.getTime()));}},this);if(this.getViewKey()===Z.OneMonth&&this._oOneMonthsRow.getMode()<2&&this._oOneMonthsRow.getSelectedDates().length){this._setRowsStartDate(this._oOneMonthsRow.getSelectedDates()[0].getStartDate());}else{this._setRowsStartDate(new Date(P1.getTime()));}if(this.getViewKey()===Z.Week||this.getViewKey()===Z.OneMonth){this._updateTodayButtonState();}if(this.getDomRef()){this._updateCurrentTimeVisualization(false);this._updatePickerSelection();}return this;};g1.prototype.setMinDate=function(i){if(N(i,this.getMinDate())){return this;}var j=this.getMaxDate(),O1=this._getHeader();if(i){b._checkJSDateObject(i);var P1=i.getFullYear();b._checkYearInValidRange(P1);this.setProperty("minDate",i,true);this._bNoStartDateChange=true;O1.getAggregation("_calendarPicker").setMinDate(new Date(i.getTime()));if(j&&j.getTime()<i.getTime()){Q.warning("minDate > maxDate -> maxDate set to end of the month",this);j=new Date(i.getTime());j.setMonth(j.getMonth()+1,0);j.setHours(23);j.setMinutes(59);j.setSeconds(59);j.setMilliseconds(0);this.setMaxDate(j);}this._bNoStartDateChange=undefined;var Q1=this.getStartDate();if(Q1&&Q1.getTime()<i.getTime()){Q.warning("StartDate < minDate -> StartDate set to minDate",this);Q1=new Date(i.getTime());this.setStartDate(Q1);O1.setPickerText(this._formatPickerText());}}else{this.setProperty("minDate",undefined,true);O1.getAggregation("_calendarPicker").setMinDate();}var R1=new Date();if(i&&R1.getTime()<i.getTime()){this._oTodayButton.setVisible(false);}else if(!j||R1.getTime()<j.getTime()){this._oTodayButton.setVisible(true);}return this;};g1.prototype.setMaxDate=function(i){if(N(i,this.getMaxDate())){return this;}var j=this.getMinDate(),O1=this._getHeader();if(i){b._checkJSDateObject(i);var P1=i.getFullYear();b._checkYearInValidRange(P1);this.setProperty("maxDate",i,true);this._bNoStartDateChange=true;O1.getAggregation("_calendarPicker").setMaxDate(new Date(i.getTime()));if(j&&j.getTime()>i.getTime()){Q.warning("maxDate < minDate -> maxDate set to begin of the month",this);j=new Date(i.getTime());j.setDate(1);j.setHours(0);j.setMinutes(0);j.setSeconds(0);j.setMilliseconds(0);this.setMinDate(j);}this._bNoStartDateChange=undefined;var Q1=this.getStartDate();if(Q1&&Q1.getTime()>i.getTime()){Q.warning("StartDate > maxDate -> StartDate set to minDate",this);if(j){Q1=new Date(j.getTime());}else{Q1=new Date(1,0,1);Q1.setFullYear(1);}this.setStartDate(Q1);O1.setPickerText(this._formatPickerText());}}else{this.setProperty("maxDate",undefined,true);O1.getAggregation("_calendarPicker").setMaxDate();}var R1=new Date();if(i&&R1.getTime()>i.getTime()){this._oTodayButton.setVisible(false);}else if(!j||R1.getTime()>j.getTime()){this._oTodayButton.setVisible(true);}return this;};g1.prototype.removeIntervalInstanceFromInfoToolbar=function(){var i=this._oInfoToolbar.getContent();i.forEach(function(j){if(j.isA(m1)){this._oInfoToolbar.removeContent(j);}}.bind(this));};g1.prototype.setViewKey=function(j){var O1,P1,Q1,R1=this.getViewKey(),S1=this._getHeader(),T1;this.setProperty("viewKey",j,true);this._oIntervalTypeSelect.setSelectedKey(j);this.removeIntervalInstanceFromInfoToolbar();var U1=this.getStartDate();var V1=this.getMinDate();var W1=this.getMaxDate();var X1=this._getView(j,!this._bBeforeRendering);if(!X1){this._bCheckView=true;this.invalidate();}else{var Y1=X1.getIntervalType();var Z1=this._getIntervals(X1);this._bCheckView=false;this._dateNav.setUnit(Y1);this._dateNav.setStep(Z1);this._dateNav.setCurrent(undefined);switch(Y1){case b1.Hour:if(!this._oTimesRow){this._oTimesRow=new T(this.getId()+"-TimesRow",{startDate:new Date(U1.getTime()),items:Z1,legend:this.getLegend()});this._setAriaRole(this._oTimesRow);this._oTimesRow._setLegendControlOrigin(this);this._oTimesRow.attachEvent("focus",this._handleFocus,this);this._oTimesRow.attachEvent("select",this._handleCalendarSelect,this);this._oTimesRow._oPlanningCalendar=this;this._oTimesRow.getSpecialDates=function(){return this._oPlanningCalendar.getSpecialDates();};}else if(this._oTimesRow.getItems()!==Z1){this._oTimesRow.setItems(Z1);this._dateNav.setStep(Z1);}this._oTimesRow.addAriaLabelledBy(I.getStaticId("sap.m","PC_INTERVAL_TOOLBAR"));this._insertInterval(this._oTimesRow);S1.setAssociation("currentPicker",S1.getAggregation("_calendarPicker"));break;case b1.Day:case b1.Week:case b1.OneMonth:Q1=i1[Y1];O1=this[Q1.sInstanceName];if(!O1){O1=new Q1.oClass(this.getId()+Q1.sIdSuffix,{startDate:new Date(U1.getTime()),days:Z1,showDayNamesLine:this.getShowDayNamesLine(),legend:this.getLegend(),showWeekNumbers:this.getShowWeekNumbers()});this._setAriaRole(O1);O1.attachEvent("select",this._handleCalendarSelect,this);O1.attachEvent("focus",this._handleFocus,this);if(j===Z.OneMonth){O1._setRowsStartDate=this._setRowsStartDate.bind(this);}O1._oPlanningCalendar=this;O1.getSpecialDates=function(){return this._oPlanningCalendar.getSpecialDates();};}else if(O1.getDays()!==Z1){O1.setDays(Z1);this._dateNav.setStep(Z1);}O1.addAriaLabelledBy(I.getStaticId("sap.m","PC_INTERVAL_TOOLBAR"));this._insertInterval(O1);this[Q1.sInstanceName]=O1;if(Y1===b1.OneMonth){S1.setAssociation("currentPicker",S1.getAggregation("_monthPicker"));}else{S1.setAssociation("currentPicker",S1.getAggregation("_calendarPicker"));}break;case b1.Month:if(!this._oMonthsRow){this._oMonthsRow=new e(this.getId()+"-MonthsRow",{startDate:new Date(U1.getTime()),months:Z1,legend:this.getLegend()});this._setAriaRole(this._oMonthsRow);this._oMonthsRow._setLegendControlOrigin(this);this._oMonthsRow.attachEvent("focus",this._handleFocus,this);this._oMonthsRow.attachEvent("select",this._handleCalendarSelect,this);this._oMonthsRow._oPlanningCalendar=this;this._oMonthsRow.getSpecialDates=function(){return this._oPlanningCalendar.getSpecialDates();};}else if(this._oMonthsRow.setMonths()!==Z1){this._oMonthsRow.setMonths(Z1);this._dateNav.setStep(Z1);}this._oMonthsRow.addAriaLabelledBy(I.getStaticId("sap.m","PC_INTERVAL_TOOLBAR"));this._insertInterval(this._oMonthsRow);S1.setAssociation("currentPicker",S1.getAggregation("_yearPicker"));break;default:throw new Error("Unknown IntervalType: "+Y1+"; "+this);}var $1=this.getRows();for(var i=0;i<$1.length;i++){var _1=$1[i];var a2=D1(_1);a2.setIntervalType(Y1);a2.setIntervals(Z1);a2.setShowSubIntervals(X1.getShowSubIntervals());}if(this.getDomRef()){this._updateCurrentTimeVisualization(false);q1.call(this,this.getShowWeekNumbers(),this._viewAllowsWeekNumbers(j));r1.call(this,this.getShowDayNamesLine(),!!O1);}this._updatePickerSelection();}if(j===Z.Week||j===Z.OneMonth||j===Z.Month){P1=this.getStartDate();this.setStartDate(new Date(P1.getTime()));if(P1.getTime()!==this.getStartDate().getTime()){this.fireStartDateChange();}}if(this._oOneMonthsRow&&j===Z.OneMonth){this._oOneMonthsRow.setMode(this._iSize);this._adjustSelectedDate(c.fromLocalJSDate(P1));if(this._iSize<2){this._setRowsStartDate(P1);}}else if(this._oOneMonthsRow&&R1===Z.OneMonth&&this._oOneMonthsRow.getSelectedDates().length){T1=this._oOneMonthsRow.getSelectedDates()[0].getStartDate();if(T1){this.setStartDate(T1);}}if(V1){S1.getAggregation("_calendarPicker").setMinDate(new Date(V1.getTime()));}if(W1){S1.getAggregation("_calendarPicker").setMaxDate(new Date(W1.getTime()));}this._updateTodayButtonState();return this;};g1.prototype._handleFocus=function(i){var j=i.getParameter("date");var O1=i.getParameter("restoreOldDate");if(O1){return;}this.shiftToDate(j,i.getParameter("otherMonth"));};g1.prototype.shiftToDate=function(i,j){var O1=this._getRowInstanceByViewKey(this.getViewKey()),P1,Q1;this._dateNav.toDate(i);P1=this._dateNav.getStart();Q1=this._dateNav.getCurrent();if(O1&&!(O1.getMode&&O1.getMode()<2&&!j)){this.setStartDate(P1);O1.setStartDate(P1);O1.setDate(Q1);}};g1.prototype._updatePickerSelection=function(){var i=this._getFirstAndLastRangeDate(),j=this._getHeader().getAssociation("currentPicker"),O1=sap.ui.getCore().byId(j),P1;P1=new f({startDate:new Date(i.oStartDate),endDate:new Date(i.oEndDate)});O1.destroySelectedDates();O1.addSelectedDate(P1);this._getHeader().setPickerText(this._formatPickerText());this._updateTodayButtonState();};g1.prototype._adjustSelectedDate=function(i,j){var O1=j?b._getFirstDateOfMonth(i):i,P1=O1.toLocalJSDate();if(this._oOneMonthsRow.getMode&&this._oOneMonthsRow.getMode()<2){this._oOneMonthsRow.removeAllSelectedDates();this._oOneMonthsRow.addSelectedDate(new f({startDate:P1}));this._oOneMonthsRow.selectDate(P1);}};g1.prototype._insertInterval=function(i){if(this._iSizeScreen>1){this._oInfoToolbar.addContent(i);}else{this._oInfoToolbar.insertContent(i,1);}};g1.prototype._viewAllowsWeekNumbers=function(i){var j=this._getView(i).getIntervalType(),O1=i1[j];return!!O1&&!!O1.oClass.prototype.setShowWeekNumbers;};g1.prototype._viewAllowsDayNamesLine=function(i){var j=this._getView(i).getIntervalType(),O1=i1[j];return!!O1&&!!O1.oClass.prototype.setShowDayNamesLine;};g1.prototype._getRowInstanceByViewKey=function(i){var j=this._getView(i).getIntervalType(),O1=i1[j],P1;if(O1){P1=this[O1.sInstanceName];}if(j===b1.Month){P1=this._oMonthsRow;}if(j===b1.Hour){P1=this._oTimesRow;}return P1;};g1.prototype.setShowWeekNumbers=function(i){this.setProperty("showWeekNumbers",i,true);this._getViews().forEach(function(j){var O1=j.getKey(),P1=this._viewAllowsWeekNumbers(O1),Q1=this._getRowInstanceByViewKey(O1);if(Q1&&P1){Q1.setShowWeekNumbers(i);}if(this.getDomRef()&&this.getViewKey()===O1){q1.call(this,i,P1);}},this);return this;};g1.prototype.setShowIntervalHeaders=function(j){this.setProperty("showIntervalHeaders",j,true);var O1=this.getRows();for(var i=0;i<O1.length;i++){var P1=O1[i];D1(P1).setShowIntervalHeaders(j);}return this;};g1.prototype.setShowEmptyIntervalHeaders=function(j){this.setProperty("showEmptyIntervalHeaders",j,true);var O1=this.getRows();for(var i=0;i<O1.length;i++){var P1=O1[i];D1(P1).setShowEmptyIntervalHeaders(j);}return this;};g1.prototype.setGroupAppointmentsMode=function(j){this.setProperty("groupAppointmentsMode",j,true);var O1=this.getRows();for(var i=0;i<O1.length;i++){var P1=O1[i];D1(P1).setGroupAppointmentsMode(j);}return this;};g1.prototype.setAppointmentsReducedHeight=function(j){this.setProperty("appointmentsReducedHeight",j,true);var O1=this.getRows();for(var i=0;i<O1.length;i++){var P1=O1[i];D1(P1).setAppointmentsReducedHeight(j);}return this;};g1.prototype.setAppointmentsVisualization=function(j){this.setProperty("appointmentsVisualization",j,true);var O1=this.getRows();for(var i=0;i<O1.length;i++){var P1=O1[i];D1(P1).setAppointmentsVisualization(j);}return this;};g1.prototype.setShowRowHeaders=function(i){this.setProperty("showRowHeaders",i,true);var j=this.getAggregation("table");j.getColumns()[0].setVisible(i);this._toggleAppointmentsColumnPopinState(i);this.$().toggleClass("sapMPlanCalNoHead",!i);L1.call(this);M1.call(this);return this;};g1.prototype.setShowDayNamesLine=function(i){var j,O1,P1,Q1=!!this.getDomRef(),R1=this.getViewKey();for(j in i1){O1=i1[j].sInstanceName;if(this[O1]){P1=this[O1];P1.setShowDayNamesLine(i);if(Q1&&j===R1){r1.call(this,i,true);}}}return this.setProperty("showDayNamesLine",i,false);};g1.prototype.setStickyHeader=function(i){if(this.getStickyHeader()===i){return this;}this.setProperty("stickyHeader",i,true);if(l.system.phone){if(i){l.orientation.attachHandler(this._updateStickyHeader,this);}else{l.orientation.detachHandler(this._updateStickyHeader,this);}}this._updateStickyHeader();return this;};g1.prototype._updateStickyHeader=function(){var i=[],j=this.getStickyHeader(),O1=this.getViewKey()===Z.OneMonth&&this._iSize<2,P1=j&&!l.system.phone&&!O1,Q1=j&&!(l.system.phone&&l.orientation.landscape)&&!O1;if(P1){i.push(V.HeaderToolbar);}if(this._oInfoToolbar&&Q1){i.push(V.InfoToolbar);}this.getAggregation("table").setSticky(i);};g1.prototype.addRow=function(i){this.addAggregation("rows",i,true);this.getAggregation("table").addItem(this._createPlanningCalendarListItem(i));return this;};g1.prototype.insertRow=function(i,j){this.insertAggregation("rows",i,j);this.getAggregation("table").insertItem(this._createPlanningCalendarListItem(i),j,true);return this;};g1.prototype.removeRow=function(i){var j=this.removeAggregation("rows",i,true),O1=this.getAggregation("table");O1.removeItem(B1(j),true);this._handleRowRemoval(j);K1.call(this);M1.call(this);return j;};g1.prototype.removeAllRows=function(){var i=this.removeAllAggregation("rows",true),j=this.getAggregation("table");j.removeAllItems(true);i.forEach(this._handleRowRemoval,this);K1.call(this);M1.call(this);return i;};g1.prototype.destroyRows=function(){var i;var j=this.getAggregation("table");j.destroyItems(true);i=this.destroyAggregation("rows");K1.call(this);M1.call(this);return i;};g1.prototype.setSingleSelection=function(i){this.setProperty("singleSelection",i,true);L1.call(this);M1.call(this);if(i){this.selectAllRows(false);}else{K1.call(this);}this.$().toggleClass("sapMPlanCalMultiSel",!i);return this;};g1.prototype.setNoDataText=function(i){this.setProperty("noDataText",i,true);var j=this.getAggregation("table");j.setNoDataText(i);return this;};g1.prototype.setLegend=function(j){this.setAssociation("legend",j,true);var O1=this.getRows(),P1=this.getLegend()&&sap.ui.getCore().byId(this.getLegend()),Q1;for(var i=0;i<O1.length;i++){var R1=O1[i];D1(R1).setLegend(j);}h1.forEach(function(S1){if(this[S1]){this[S1].setLegend(j);}},this);if(P1){Q1=new a(function(S1){this.invalidate();}.bind(this));Q1.observe(P1,{destroy:true});}return this;};g1.prototype.addAriaLabelledBy=function(i){this.addAssociation("ariaLabelledBy",i,true);var j=this.getAggregation("table");j.addAriaLabelledBy(i);return this;};g1.prototype.removeAriaLabelledBy=function(i){this.removeAssociation("ariaLabelledBy",i,true);var j=this.getAggregation("table");j.removeAriaLabelledBy(i);return this;};g1.prototype.removeAllAriaLabelledBy=function(){this.removeAllAssociation("ariaLabelledBy",true);var i=this.getAggregation("table");i.removeAllAriaLabelledBy();i.addAriaLabelledBy(this.getId()+"-Descr");return this;};g1.prototype.invalidate=function(i){var j=i&&i instanceof f;if(!this._bIsBeingDestroyed&&(this._bDateRangeChanged||j)){if(this.getDomRef()){var O1=this.getViewKey();var P1=this._getView(O1);var Q1=P1.getIntervalType();switch(Q1){case b1.Hour:if(this._oTimesRow){this._oTimesRow.invalidate(arguments);}break;case b1.Day:if(this._oDatesRow){this._oDatesRow.invalidate(arguments);}break;case b1.Month:if(this._oMonthsRow){this._oMonthsRow.invalidate(arguments);}break;case b1.OneMonth:if(this._oOneMonthsRow){this._oOneMonthsRow.invalidate(arguments);}break;case b1.Week:if(this._oWeeksRow){this._oWeeksRow.invalidate(arguments);}break;default:throw new Error("Unknown IntervalType: "+Q1+"; "+this);}}this._bDateRangeChanged=undefined;}else{if(i&&i instanceof sap.m.PlanningCalendarView){this._bCheckView=true;}C.prototype.invalidate.apply(this,arguments);}};g1.prototype.addSpecialDate=function(i){this._bDateRangeChanged=true;return C.prototype.addAggregation.call(this,"specialDates",i);};g1.prototype.insertSpecialDate=function(i,j){this._bDateRangeChanged=true;return C.prototype.insertAggregation.call(this,"specialDates",i,j);};g1.prototype.removeSpecialDate=function(i){this._bDateRangeChanged=true;return C.prototype.removeAggregation.call(this,"specialDates",i);};g1.prototype.removeAllSpecialDates=function(){this._bDateRangeChanged=true;return this.removeAllAggregation("specialDates");};g1.prototype.destroySpecialDates=function(){this._bDateRangeChanged=true;return this.destroyAggregation("specialDates");};g1.prototype.removeAllViews=function(){this._bCheckView=true;var i=this.removeAllAggregation("views"),j=this.getBuiltInViews();if(j.length){this.setViewKey(j[0]);}else{this.setViewKey(k1[0]);}return i;};g1.prototype.destroyViews=function(){this._bCheckView=true;var i=this.destroyAggregation("views"),j=this.getBuiltInViews();if(j.length){this.setViewKey(j[0]);}else{this.setViewKey(k1[0]);}return i;};g1.prototype.getSelectedRows=function(){return this.getRows().filter(function(i){return i.getSelected();});};g1.prototype.selectAllRows=function(j){var O1=this.getRows();if(!(j&&this.getSingleSelection())){for(var i=0;i<O1.length;i++){var P1=O1[i];P1.setSelected(j);}if(this._oSelectAllCheckBox){this._oSelectAllCheckBox.setSelected(j);}}return this;};g1.prototype.onsaphomemodifiers=function(i){if((i.metaKey||i.ctrlKey)&&!i.altKey&&!i.shiftKey){var j=this.getRows();var O1=j[0];var P1=new U.Event("saphome");P1._bPlanningCalendar=true;D1(O1).onsaphome(P1);i.preventDefault();i.stopPropagation();}};g1.prototype.onsapendmodifiers=function(i){if((i.metaKey||i.ctrlKey)&&!i.altKey&&!i.shiftKey){var j=this.getRows();var O1=j[j.length-1];var P1=new U.Event("sapend");P1._bPlanningCalendar=true;D1(O1).onsapend(P1);i.preventDefault();i.stopPropagation();}};g1.prototype.setBuiltInViews=function(i){this.setProperty("builtInViews",i);this.setViewKey(this._getViews()[0].getKey());return this;};g1.prototype.removeView=function(i){var j=this.removeAggregation("views",i);if(!this.getViews().length){this.setViewKey(this._getViews()[0].getKey());}return j;};g1.prototype._getIntervals=function(i){var j=0;switch(this._iSize){case 0:j=i.getIntervalsS();break;case 1:j=i.getIntervalsM();break;default:j=i.getIntervalsL();break;}return j;};g1.prototype._getView=function(j,O1){var P1=this._getViews();var Q1;for(var i=0;i<P1.length;i++){Q1=P1[i];if(Q1.getKey()!=j){Q1=undefined;}else{break;}}if(!Q1&&!O1){throw new Error("PlanningCalendarView with key "+j+"not assigned "+this);}return Q1;};g1.prototype._changeStartDate=function(i){if(this._bNoStartDateChange){return;}this.setStartDate(new Date(i.getTime()));this._updatePickerSelection();this.fireStartDateChange();};g1.prototype._updateCurrentTimeVisualization=function(j){if(this._sUpdateCurrentTime){clearTimeout(this._sUpdateCurrentTime);this._sUpdateCurrentTime=undefined;}if(j){var O1=this.getRows();for(var i=0;i<O1.length;i++){var P1=O1[i];D1(P1).updateCurrentTimeVisualization();}}var Q1=new Date();var R1=this.getStartDate();var S1=this.getViewKey();var T1=this._getView(S1);var U1=T1.getIntervalType();var V1=this._getIntervals(T1);var W1=0;var X1=0;var Y1=0;switch(U1){case b1.Hour:W1=60000;X1=R1.getTime()-3600000;Y1=R1.getTime()+V1*3600000;break;case b1.Day:case b1.Week:case b1.OneMonth:W1=1800000;X1=R1.getTime()-3600000;Y1=R1.getTime()+V1*86400000;break;default:W1=-1;break;}if(Q1.getTime()<=Y1&&Q1.getTime()>=X1&&W1>0){this._sUpdateCurrentTime=setTimeout(this['_updateCurrentTimeVisualization'].bind(this,true),W1);}};function o1(i){this.setViewKey(i.getParameter("item").getKey());this.fireViewChange();}g1.prototype._handleTodayPress=function(i){var j=new Date(),O1,P1=this.getViewKey();if(P1===Z.OneMonth){O1=b.getFirstDateOfMonth(b._createUniversalUTCDate(j,undefined,true));this._adjustSelectedDate(c.fromLocalJSDate(j),false);j=b._createLocalDate(O1,true);}if(P1===Z.Week){O1=this.getStartDate();j.setHours(O1.getHours());j.setMinutes(O1.getMinutes());j.setSeconds(O1.getSeconds());}this.setStartDate(j);this._dateNav.setCurrent(j);this._updatePickerSelection();this.fireStartDateChange();};g1.prototype._handleStartDateChange=function(i){var j=i.oSource.getStartDate();if(this._getView(this.getViewKey()).getIntervalType()!==b1.Hour){var O1=this.getStartDate();j.setHours(O1.getHours());j.setMinutes(O1.getMinutes());j.setSeconds(O1.getSeconds());}this._changeStartDate(j);};g1.prototype._handleDateSelect=function(i){var j=i.oSource.getStartDate();if(this._getView(this.getViewKey()).getIntervalType()===b1.Hour){var O1=this.getStartDate();j.setHours(O1.getHours());j.setMinutes(O1.getMinutes());j.setSeconds(O1.getSeconds());}this._changeStartDate(j);var P1=this.getViewKey(),Q1=this._getView(P1),R1=Q1.getIntervalType(),S1;if(R1==="Hour"){R1="Time";}else if(R1==="Day"){R1="Date";}else if(R1==="One Month"){R1="OneMonth";}S1="_o"+R1+"sRow";if(this[S1]){this[S1].setDate(j);}};g1.prototype._handleCalendarSelect=function(i){var j=i.getSource().getSelectedDates();if(!j.length){return;}var O1=new Date(j[0].getStartDate());var P1=b._createUniversalUTCDate(O1,undefined,true);var Q1=this.getViewKey();var R1=this._getView(Q1);var S1=R1.getIntervalType();if(S1!==b1.OneMonth||this._iSize>1){j[0].setStartDate();}switch(S1){case b1.Hour:P1.setUTCHours(P1.getUTCHours()+1);break;case b1.Day:case b1.Week:P1.setUTCDate(P1.getUTCDate()+1);break;case b1.OneMonth:if(this._iSize<2){var T1=new Date(O1.getTime());if(b.monthsDiffer(this.getStartDate(),O1)){this.setStartDate(O1);this._getHeader().setPickerText(this._formatPickerText());}this._setRowsStartDate(T1);this._oOneMonthsRow._focusDate(c.fromLocalJSDate(T1),true);}else if(b._isNextMonth(O1,this.getStartDate())){this.shiftToDate(O1);return;}P1.setUTCDate(P1.getUTCDate()+1);break;case b1.Month:P1.setUTCMonth(P1.getUTCMonth()+1);break;default:throw new Error("Unknown IntervalType: "+S1+"; "+this);}P1.setUTCMilliseconds(P1.getUTCMilliseconds()-1);P1=b._createLocalDate(P1,true);this._formatPickerText();this.fireIntervalSelect({startDate:O1,endDate:P1,subInterval:false,row:undefined});};function p1(i){var j=i.getParameter("startDate");var O1=this.getViewKey();var P1=this._getView(O1);var Q1=P1.getIntervalType();if(Q1===b1.OneMonth&&b._isNextMonth(j,this.getStartDate())){this.shiftToDate(j);return;}var R1=i.getParameter("endDate");var S1=i.getParameter("subInterval");var T1=A1(i.oSource.getParent());this._formatPickerText();this.fireIntervalSelect({startDate:j,endDate:R1,subInterval:S1,row:T1});}g1.prototype._applyContextualSettings=function(i){return C.prototype._applyContextualSettings.call(this,i||M._defaultContextualSettings);};function q1(i,j){this.$().toggleClass("sapMPlanCalWithWeekNumbers",i&&j);}function r1(i,j){this.$().toggleClass("sapMPlanCalWithDayNamesLine",i&&j);}function s1(j,O1){if(j.size.width<=0){return;}if(Math.abs(this.iWidth-j.size.width)<15){return;}this.iWidth=j.size.width;this._applyContextualSettings({contextualWidth:this.iWidth});var P1=this.getRows();var Q1;var i=0;var R1=this._iSize;F1.call(this,j.size.width);if(R1!=this._iSize){G1.call(this,this._iSize);var S1=this.getViewKey();var T1=this._getView(S1);var U1=T1.getIntervalType();var V1=this._getIntervals(T1);for(i=0;i<P1.length;i++){Q1=P1[i];var W1=D1(Q1);if(V1!=W1.getIntervals()){W1.setIntervals(V1);}else{W1.handleResize();}}switch(U1){case b1.Hour:if(this._oTimesRow&&this._oTimesRow.getItems()!=V1){this._oTimesRow.setItems(V1);this._dateNav.setStep(V1);}break;case b1.Day:if(this._oDatesRow&&this._oDatesRow.getDays()!=V1){this._oDatesRow.setDays(V1);this._dateNav.setStep(V1);}break;case b1.Month:if(this._oMonthsRow&&this._oMonthsRow.getMonths()!=V1){this._oMonthsRow.setMonths(V1);this._dateNav.setStep(V1);}break;case b1.Week:if(this._oWeeksRow&&this._oWeeksRow.getDays()!=V1){this._oWeeksRow.setDays(V1);this._dateNav.setStep(V1);}break;case b1.OneMonth:if(this._oOneMonthsRow&&this._oOneMonthsRow.getDays()!=V1){this._oOneMonthsRow.setDays(V1);this._dateNav.setStep(V1);if(this._iSize>1){this._setRowsStartDate(new Date(this.getStartDate().getTime()));}}break;default:throw new Error("Unknown IntervalType: "+U1+"; "+this);}L1.call(this);}else if(!O1){for(i=0;i<P1.length;i++){Q1=P1[i];D1(Q1).handleResize();}}if(this._oOneMonthsRow){this._oOneMonthsRow.setMode(this._iSize);this._adjustSelectedDate(c.fromLocalJSDate(this.getStartDate()));}if(this.getStickyHeader()){this._updateStickyHeader();}}function t1(O1){var P1=O1.getParameter("appointment"),Q1=O1.getParameter("multiSelect"),R1=O1.getParameter("appointments"),S1=O1.getParameter("domRefId"),T1,U1,V1,W1,X1,i,j;if(!Q1){U1=this.getRows();for(i=0;i<U1.length;i++){V1=U1[i];if(O1.oSource!=D1(V1)){W1=V1.getAppointments();for(j=0;j<W1.length;j++){X1=W1[j];X1.setSelected(false);}}}}T1={appointment:P1,appointments:R1,multiSelect:Q1,domRefId:S1};this.fireAppointmentSelect(T1);}g1.prototype._setRowsStartDate=function(j){var O1=this.getRows(),P1,i;for(i=0;i<O1.length;i++){P1=O1[i];D1(P1).setStartDate(j);}};g1.prototype._toggleAppointmentsColumnPopinState=function(i){var j=this.getAggregation("table"),O1=j.getColumns()[1];O1.setDemandPopin(i);O1.setMinScreenWidth(i?j1:"");};g1.prototype._getViews=function(){var i=this.getViews(),j=this.getBuiltInViews(),O1,P1=[],Q1=Z,R1=b1;if(!this._oViews){this._oViews={};}if(j.length){P1=j;}else{P1=i.length?[]:k1;}O1=P1.map(function(T1){switch(T1){case Q1.Hour:return this._oViews[Q1.Hour]||(this._oViews[Q1.Hour]=new J(this.getId()+"-HourView",{key:Q1.Hour,intervalType:R1.Hour,description:this._oRB&&this._oRB.getText("PLANNINGCALENDAR_HOURS"),intervalsS:6,intervalsM:6,intervalsL:12}));case Q1.Day:return this._oViews[Q1.Day]||(this._oViews[Q1.Day]=new J(this.getId()+"-DayView",{key:Q1.Day,intervalType:R1.Day,description:this._oRB&&this._oRB.getText("PLANNINGCALENDAR_DAYS"),intervalsS:7,intervalsM:7,intervalsL:14}));case Q1.Month:return this._oViews[Q1.Month]||(this._oViews[Q1.Month]=new J(this.getId()+"-MonthView",{key:Q1.Month,intervalType:R1.Month,description:this._oRB&&this._oRB.getText("PLANNINGCALENDAR_MONTHS"),intervalsS:3,intervalsM:6,intervalsL:12}));case Q1.Week:return this._oViews[Q1.Week]||(this._oViews[Q1.Week]=new J(this.getId()+"-WeekView",{key:Q1.Week,intervalType:R1.Week,description:this._oRB&&this._oRB.getText("PLANNINGCALENDAR_WEEK"),intervalsS:7,intervalsM:7,intervalsL:7}));case Q1.OneMonth:return this._oViews[Q1.OneMonth]||(this._oViews[Q1.OneMonth]=new J(this.getId()+"-OneMonthView",{key:Q1.OneMonth,intervalType:R1.OneMonth,description:this._oRB&&this._oRB.getText("PLANNINGCALENDAR_ONE_MONTH"),intervalsS:1,intervalsM:1,intervalsL:31}));default:Q.error("Cannot get PlanningCalendar views. Invalid view key "+T1);break;}},this);for(var S1 in this._oViews){if(P1.indexOf(S1)<0){this._oViews[S1].destroy();delete this._oViews[S1];}}if(i.length){O1=O1.concat(i);}return O1;};g1.prototype.getSelectedAppointments=function(){var i=[];this.getRows().filter(function(j){i.push.apply(i,D1(j).aSelectedAppointments);});return i;};g1.prototype.setCustomAppointmentsSorterCallback=function(i){if(typeof i==="function"||i===null||i===undefined){this.getRows().forEach(function(j){D1(j)._setCustomAppointmentsSorterCallback(i);});this._fnCustomSortedAppointments=i;}else{Q.warning("Your custom sort function won't be used, but the old one will be preserved.",this);}return this;};g1.prototype.getCustomAppointmentsSorterCallback=function(){return this._fnCustomSortedAppointments;};g1.prototype._onRowDeselectAppointment=function(){var O1=this.getRows();for(var i=0;i<O1.length;i++){var P1=D1(O1[i]).aSelectedAppointments;for(var j=0;j<P1.length;j++){var Q1=sap.ui.getCore().byId(P1[j]);if(Q1){Q1.setProperty("selected",false,true);Q1.$().removeClass("sapUiCalendarAppSel");}}D1(O1[i]).aSelectedAppointments=[];}};g1.prototype._updateRowTimeline=function(i){var j=D1(i),O1,P1,Q1,R1,S1=this.getViewKey()===Z.OneMonth&&this._iSize<2,T1=this.getStartDate();j.setNonWorkingDays(i.getNonWorkingDays());j.setNonWorkingHours(i.getNonWorkingHours());if(S1&&this._oOneMonthsRow&&this._oOneMonthsRow.getSelectedDates().length){T1=this._oOneMonthsRow.getSelectedDates()[0].getStartDate();}j.setStartDate(T1);j.setShowIntervalHeaders(this.getShowIntervalHeaders());j.setShowEmptyIntervalHeaders(this.getShowEmptyIntervalHeaders());j.setGroupAppointmentsMode(this.getGroupAppointmentsMode());j.setAppointmentsReducedHeight(this.getAppointmentsReducedHeight());j.setLegend(this.getLegend());j.setAppointmentsVisualization(this.getAppointmentsVisualization());j.attachEvent("select",t1,this);j.attachEvent("startDateChange",this._handleStartDateChange,this);j.attachEvent("leaveRow",J1,this);j.attachEvent("intervalSelect",p1,this);K1.call(this);if(N1.call(this)){O1=this.getViewKey();P1=this._getView(O1);Q1=P1.getIntervalType();R1=this._getIntervals(P1);j.setIntervalType(Q1);j.setIntervals(R1);j.setShowSubIntervals(P1.getShowSubIntervals());}M1.call(this);if(this._fnCustomSortedAppointments){j._setCustomAppointmentsSorterCallback(this._fnCustomSortedAppointments);}};g1.prototype._observeRowChanges=function(i){var j=B1(i),O1=C1(i),P1=D1(i);var Q1={destroy:function(){j.destroy();},change:{title:function(R1){O1.setProperty(R1.name,R1.current);},icon:function(R1){O1.setProperty(R1.name,R1.current);},text:function(R1){P1.toggleStyleClass("sapMPlanCalRowLarge",!!R1.current);O1.setProperty("description",R1.current);},enableAppointmentsDragAndDrop:function(R1){this._enableAppointmentsDragAndDrop(i);}.bind(this),enableAppointmentsResize:function(R1){this._enableAppointmentsResize(i);}.bind(this),enableAppointmentsCreate:function(R1){this._enableAppointmentsCreate(i);}.bind(this),nonWorkingDays:function(R1){P1.setProperty(R1.name,R1.current);},nonWorkingHours:function(R1){P1.setProperty(R1.name,R1.current);},selected:function(R1){K1.call(this);j.setProperty(R1.name,R1.current);}.bind(this),tooltip:function(R1){if(R1.mutation==="insert"){O1.setTooltip(R1.child);}else if(R1.mutation==="remove"){O1.setTooltip();}},intervalHeaders:function(R1){P1.invalidate();},appointments:function(R1){P1.invalidate();}}};new a(function(R1){if(R1.type==="destroy"){Q1.destroy();}else if(Q1.change[R1.name]){Q1.change[R1.name](R1);}}).observe(i,{properties:["icon","text","title","nonWorkingDays","nonWorkingHours","selected","enableAppointmentsDragAndDrop","enableAppointmentsResize","enableAppointmentsCreate"],aggregations:["tooltip","appointments","intervalHeaders","headerContent"],destroy:true});i.invalidate=function(R1){if(!R1||!(R1 instanceof g)){E.prototype.invalidate.apply(this,arguments);}else if(j){P1.invalidate(R1);}};i.applyFocusInfo=function(R1){P1.applyFocusInfo(R1);return this;};};g1.prototype._createPlanningCalendarListItem=function(i){var j,O1,P1;if(i.getHeaderContent().length||i.getBindingInfo("headerContent")){O1=i._getPlanningCalendarCustomRowHeader();}else{O1=new u1(i.getId()+"-Head",{icon:i.getIcon(),description:i.getText(),title:i.getTitle(),tooltip:i.getTooltip(),iconDensityAware:false});}P1=new w1(i.getId()+"-CalRow",{checkResize:false,updateCurrentTime:false,ariaLabelledBy:O1.getId()});P1.getAppointments=function(){return i.getAppointments();};P1.getIntervalHeaders=function(){return i.getIntervalHeaders();};j=new y1(i.getId()+f1,{cells:[O1,P1]});this._updateRowTimeline(i);this._observeRowChanges(i);this._enableAppointmentsDragAndDrop(i);this._enableAppointmentsResize(i);this._enableAppointmentsCreate(i);return j;};g1.prototype._handleRowRemoval=function(i){var j=D1(i);j.detachEvent("select",t1,this);j.detachEvent("startDateChange",this._handleStartDateChange,this);j.detachEvent("leaveRow",J1,this);j.detachEvent("intervalSelect",p1,this);if(this._fnCustomSortedAppointments){j._fnCustomSortedAppointments=undefined;}B1(i).destroy();};var u1=A.extend("PlanningCalendarRowHeader",{renderer:R.extend(F),TagName:"div"});u1.prototype.isSelectable=function(){return false;};PlanningCalendarRowHeaderRenderer.renderTabIndex=function(i,j){};PlanningCalendarRowHeaderRenderer.getAriaRole=function(i,j){};var v1=R.extend(k);v1.getLegendItems=function(i){var j=[],O1,P1=i.getLegend();if(P1){O1=sap.ui.getCore().byId(P1);if(O1){j=O1.getAppointmentItems?O1.getAppointmentItems():O1.getItems();}else{Q.error("PlanningCalendarLegend with id '"+P1+"' does not exist!",i);}}return j;};v1.renderBeforeAppointments=function(j,O1){var P1=A1(O1.getParent()),Q1;if(!P1.getEnableAppointmentsDragAndDrop()&&!P1.getEnableAppointmentsResize()&&!P1.getEnableAppointmentsCreate()||O1._isOneMonthsRowOnSmallSizes()){return;}Q1=O1.getAggregation("_intervalPlaceholders");j.write("<div class=\"sapUiCalendarRowAppsOverlay\">");if(Q1){for(var i=0;i<Q1.length;i++){var R1=Q1[i];R1.setWidth(100/Q1.length+"%");j.renderControl(R1);}}j.write("</div>");};v1.renderResizeHandle=function(i,j,O1){if(!A1(j.getParent()).getEnableAppointmentsResize()||j._isOneMonthsRowOnSmallSizes()||(O1._aAppointments&&O1._aAppointments.length>0)){return;}i.write("<span");i.addClass("sapUiCalendarAppResizeHandle");i.writeClasses();i.write(">");i.write("</span>");};v1.writeCustomAttributes=function(i,j){if(A1(j.getParent()).getEnableAppointmentsCreate()){i.writeAttribute("draggable","true");}};v1.renderInterval=function(j,O1,P1,Q1,R1,S1,T1,U1,V1,W1,X1,Y1,Z1){var $1=O1.getIntervalType();if($1===b1.Day||$1===b1.Week||$1===b1.OneMonth){var _1=A1(O1.getParent()),a2=_1.getParent(),b2=function(l2){return l2.getType()===W.NonWorking;},c2=_1.getSpecialDates().filter(b2),d2=a2.getSpecialDates().filter(b2),e2=O1.getStartDate(),f2,g2,h2,i2;if(d2&&c2){f2=d2.concat(c2);}else if(c2){f2=c2;}if(f2&&f2.length){var j2=function(l2){return l2===g2.getDay();};g2=new Date(e2.getTime());g2.setHours(0,0,0);g2.setDate(e2.getDate()+P1);for(var i=0;i<f2.length;i++){if(f2[i].getStartDate()){h2=new Date(f2[i].getStartDate().getTime());}if(f2[i].getEndDate()){i2=new Date(f2[i].getEndDate().getTime());}else{i2=new Date(f2[i].getStartDate().getTime());i2.setHours(23,59,59);}if(g2.getTime()>=h2.getTime()&&g2.getTime()<=i2.getTime()){var k2=S1.some(j2);if(!k2){j.addClass("sapUiCalendarRowAppsNoWork");}}}}}k.renderInterval(j,O1,P1,Q1,R1,S1,T1,U1,V1,W1,X1,Y1,Z1);};var w1=h.extend("PlanningCalendarRowTimeline",{metadata:{aggregations:{intervalHeaders:{type:"sap.ui.unified.CalendarAppointment",multiple:true},_intervalPlaceholders:{type:"IntervalPlaceholder",multiple:true,visibility:"hidden",dnd:{droppable:true}}},dnd:true},renderer:v1});w1.prototype._updatePlaceholders=function(){var j=this.getProperty("intervals");if(this.getIntervalType()===b1.Hour){j*=2;}this.removeAllAggregation("_intervalPlaceholders");for(var i=0;i<j;i++){this.addAggregation("_intervalPlaceholders",new x1());}};w1.prototype.onBeforeRendering=function(){h.prototype.onBeforeRendering.call(this);this._updatePlaceholders();};w1.prototype.onmousedown=function(i){var j=i.target.classList;this._isResizeHandleMouseDownTarget=j.contains("sapUiCalendarAppResizeHandle");this._isRowAppsIntervalMouseDownTarget=j.contains("sapUiCalendarRowAppsInt");};w1.prototype._isResizingPerformed=function(){return this._isResizeHandleMouseDownTarget;};w1.prototype._isDraggingPerformed=function(){return!this._isResizeHandleMouseDownTarget&&!this._isRowAppsIntervalMouseDownTarget;};w1.prototype._isCreatingPerformed=function(){return this._isRowAppsIntervalMouseDownTarget;};var x1=C.extend("IntervalPlaceholder",{metadata:{properties:{width:{type:"sap.ui.core.CSSSize",group:"Appearance",defaultValue:null}}},renderer:function(i,j){i.write("<div");i.writeControlData(j);i.addStyle("width",j.getWidth());i.writeStyles();i.addClass("sapUiCalendarRowAppsPlaceholder");i.writeClasses();i.write("></div>");}});var y1=x.extend("sap.m.internal.PlanningCalendarRowListItem",{metadata:{library:"sap.m"},renderer:y});y1.prototype.getHeader=function(){return this.getCells()[0];};y1.prototype.getTimeline=function(){return this.getCells()[1];};y1.prototype.getCustomData=function(){return A1(this).getCustomData();};g1.prototype._getSelectedDates=function(){var i=this.getViewKey(),j=this._getView(i),O1=j.getIntervalType(),P1=i1[O1];return this[P1.sInstanceName].getSelectedDates();};g1.prototype._enableAppointmentsDragAndDrop=function(i){var j=D1(i),O1;if(i.getEnableAppointmentsDragAndDrop()){O1=i.getDragDropConfig().some(function(P1){return P1.getGroupName()===c1;});if(!O1){this._addDragDropInfo(i,D1(i));}}else{i.getDragDropConfig().forEach(function(P1){if(P1.getGroupName()===c1){i.removeDragDropConfig(P1);}});j.getDragDropConfig().forEach(function(P1){if(P1.getGroupName()===c1){j.removeDragDropConfig(P1);}});}};g1.prototype._enableAppointmentsResize=function(i){var j=i.getEnableAppointmentsResize(),O1=this._getConfigFromDragDropConfigAggregation(i.getAggregation("dragDropConfig"),d1),P1=this._getResizeConfig(i);if(j&&!O1){i.addAggregation("dragDropConfig",P1,true);}if(!j){i.removeAggregation("dragDropConfig",O1,true);}};g1.prototype._enableAppointmentsCreate=function(i){var j=i.getEnableAppointmentsCreate(),O1=D1(i),P1=this._getConfigFromDragDropConfigAggregation(O1.getAggregation("dragDropConfig"),e1),Q1=this._getAppointmentsCreateConfig(i);if(j&&!P1){O1.addAggregation("dragDropConfig",Q1,true);}if(!j){O1.removeAggregation("dragDropConfig",P1,true);}};g1.prototype._addDragDropInfo=function(i,j){i.addDragDropConfig(new o({groupName:c1,sourceAggregation:"appointments",dragStart:function(O1){var P1=function(){var Q1=U(".sapUiCalendarRowAppsOverlay");setTimeout(function(){Q1.addClass("sapUiCalendarRowAppsOverlayDragging");},0);U(document).one("dragend",function(){Q1.removeClass("sapUiCalendarRowAppsOverlayDragging");});};if(j._isOneMonthsRowOnSmallSizes()||!j._isDraggingPerformed()){O1.preventDefault();return;}P1();}}));j.addDragDropConfig(new p({groupName:c1,targetAggregation:"_intervalPlaceholders",dragEnter:function(O1){var P1=O1.getParameter("dragSession"),Q1=P1.getDragControl(),R1=j.getIntervalType(),S1=j.getStartDate(),T1=j.indexOfAggregation("_intervalPlaceholders",P1.getDropControl()),U1=j.getId(),V1,W1=function(){var Y1=U(P1.getIndicator()),Z1=P1.getDropControl().getDomRef().getBoundingClientRect(),$1=sap.ui.getCore().byId(U1).getDomRef().getBoundingClientRect(),_1=P1.getDragControl().$().outerWidth(),a2=sap.ui.getCore().getConfiguration().getRTL(),b2=a2?Math.ceil(Z1.right)-$1.left:$1.right-Math.ceil(Z1.left);Y1.css("min-width",(_1<b2)?_1:b2).css(a2?"border-left-width":"border-right-width",(_1>b2)?"0":"").css("margin-left",a2?-(Y1.outerWidth()-parseFloat(Y1.context.style.width)):"");};if(i.hasListeners("appointmentDragEnter")){if(R1===b1.Hour){V1=this._calcNewHoursAppPos(S1,Q1.getStartDate(),Q1.getEndDate(),T1);}else if(R1===b1.Day||R1===b1.Week||(R1===b1.OneMonth&&!j._isOneMonthsRowOnSmallSizes())){V1=this._calcNewDaysAppPos(S1,Q1.getStartDate(),Q1.getEndDate(),T1);}else if(R1===b1.Month){V1=this._calcNewMonthsAppPos(S1,Q1.getStartDate(),Q1.getEndDate(),T1);}var X1=i.fireAppointmentDragEnter({appointment:Q1,startDate:V1.startDate,endDate:V1.endDate,calendarRow:A1(j.getParent())});if(!X1){O1.preventDefault();return;}}else if(D1(Q1.getParent())!==j){O1.preventDefault();return;}if(j.getIntervalType()!==b1.Hour){return;}if(!P1.getIndicator()){setTimeout(W1,0);}else{W1();}}.bind(this),drop:function(O1){var P1=O1.getParameter("dragSession"),Q1=P1.getDragControl(),R1=j.getIntervalType(),S1=j.getStartDate(),T1=j.indexOfAggregation("_intervalPlaceholders",P1.getDropControl()),U1,V1=O1.getParameter("browserEvent"),W1=(V1.metaKey||V1.ctrlKey);if(R1===b1.Hour){U1=this._calcNewHoursAppPos(S1,Q1.getStartDate(),Q1.getEndDate(),T1);}else if(R1===b1.Day||R1===b1.Week||(R1===b1.OneMonth&&!j._isOneMonthsRowOnSmallSizes())){U1=this._calcNewDaysAppPos(S1,Q1.getStartDate(),Q1.getEndDate(),T1);}else if(R1===b1.Month){U1=this._calcNewMonthsAppPos(S1,Q1.getStartDate(),Q1.getEndDate(),T1);}j.$().find(".sapUiCalendarRowAppsOverlay").removeClass("sapUiCalendarRowAppsOverlayDragging");if(Q1.getStartDate().getTime()===U1.startDate.getTime()&&Q1.getParent()===A1(j.getParent())){return;}i.fireAppointmentDrop({appointment:Q1,startDate:U1.startDate,endDate:U1.endDate,calendarRow:A1(j.getParent()),copy:W1});}.bind(this)}));};g1.prototype._calcNewHoursAppPos=function(i,j,O1,P1){var Q1=new Date(i.getFullYear(),i.getMonth(),i.getDate(),i.getHours());Q1=new Date(Q1.getTime()+(P1*30*60*1000));return{startDate:Q1,endDate:new Date(Q1.getTime()+O1.getTime()-j.getTime())};};g1.prototype._calcNewDaysAppPos=function(i,j,O1,P1){var Q1=new Date(i);Q1.setDate(Q1.getDate()+P1);Q1=new Date(Q1.getFullYear(),Q1.getMonth(),Q1.getDate(),j.getHours(),j.getMinutes(),j.getSeconds());return{startDate:Q1,endDate:new Date(Q1.getTime()+O1.getTime()-j.getTime())};};g1.prototype._calcNewMonthsAppPos=function(i,j,O1,P1){var Q1=new Date(i);Q1.setMonth(Q1.getMonth()+P1);Q1=new Date(Q1.getFullYear(),Q1.getMonth(),j.getDate(),j.getHours(),j.getMinutes(),j.getSeconds());return{startDate:Q1,endDate:new Date(Q1.getTime()+O1.getTime()-j.getTime())};};g1.prototype._getResizeConfig=function(i){var j=D1(i),O1=new q({sourceAggregation:"appointments",targetAggregation:"_intervalPlaceholders",targetElement:D1(i),dragStart:function(P1){if(!i.getEnableAppointmentsResize()||j._isOneMonthsRowOnSmallSizes()||!j._isResizingPerformed()){P1.preventDefault();return;}var Q1=P1.getParameter("dragSession"),R1=j.$().find(".sapUiCalendarRowAppsOverlay"),S1=U(Q1.getIndicator()),T1=Q1.getDragControl().$();S1.addClass("sapUiDnDIndicatorHide");setTimeout(function(){R1.addClass("sapUiCalendarRowAppsOverlayDragging");},0);U(document).one("dragend",function(){R1.removeClass("sapUiCalendarRowAppsOverlayDragging");S1.removeClass("sapUiDnDIndicatorHide");T1.css({width:"auto","min-width":"auto","z-index":"auto",opacity:1});});if(!l.browser.msie&&!l.browser.edge){P1.getParameter("browserEvent").dataTransfer.setDragImage(z1(),0,0);}},dragEnter:function(P1){var Q1=P1.getParameter("dragSession"),R1=this.getTargetElement(),S1=function(){var W1=U(Q1.getIndicator());W1.addClass("sapUiDnDIndicatorHide");},T1=Q1.getDropControl().getDomRef().getBoundingClientRect(),U1=sap.ui.getCore().byId(R1).getDomRef().getBoundingClientRect(),V1={width:T1.left+T1.width-(Q1.getDragControl().$().position().left+U1.left),"min-width":Math.min(Q1.getDragControl().$().outerWidth(),Q1.getDropControl().$().outerWidth()),"z-index":1,opacity:0.8};Q1.getDragControl().$().css(V1);if(!Q1.getIndicator()){setTimeout(S1,0);}else{S1();}},drop:function(P1){var j=D1(i),Q1=P1.getParameter("dragSession"),R1=Q1.getDragControl(),S1=j.getIntervalType(),T1=j.getStartDate(),U1=j.indexOfAggregation("_intervalPlaceholders",Q1.getDropControl()),V1;if(S1===b1.Hour){V1=this._calcResizeNewHoursAppPos(T1,R1.getStartDate(),R1.getEndDate(),U1);}else if(S1===b1.Day||S1===b1.Week||(S1===b1.OneMonth&&!j._isOneMonthsRowOnSmallSizes())){V1=this._calcResizeNewDaysAppPos(T1,R1.getStartDate(),R1.getEndDate(),U1);}else if(S1===b1.Month){V1=this._calcResizeNewMonthsAppPos(T1,R1.getStartDate(),R1.getEndDate(),U1);}j.$().find(".sapUiCalendarRowAppsOverlay").removeClass("sapUiCalendarRowAppsOverlayDragging");U(Q1.getIndicator()).removeClass("sapUiDnDIndicatorHide");R1.$().css({width:"auto","min-width":"auto","z-index":"auto",opacity:1});if(R1.getEndDate().getTime()===V1.endDate.getTime()){return;}i.fireAppointmentResize({appointment:R1,startDate:V1.startDate,endDate:V1.endDate,calendarRow:i});}.bind(this)});O1.setProperty("groupName",d1);return O1;};g1.prototype._calcResizeNewHoursAppPos=function(i,j,O1,P1){var Q1=new Date(i.getFullYear(),i.getMonth(),i.getDate(),i.getHours()),R1=30*60*1000;Q1=new Date(Q1.getTime()+((P1+1)*R1));if(Q1.getTime()<=j.getTime()){Q1=new Date(j.getTime()+R1);}return{startDate:j,endDate:Q1};};g1.prototype._calcResizeNewDaysAppPos=function(i,j,O1,P1){var Q1=new Date(i),R1=Q1.getDate()+P1+1,S1=new Date(Q1.getFullYear(),Q1.getMonth(),Q1.getDate());S1.setDate(R1);if(S1.getTime()<=j.getTime()){R1=j.getDate()+1;}Q1.setDate(R1);Q1=new Date(Q1.getFullYear(),Q1.getMonth(),Q1.getDate());return{startDate:j,endDate:Q1};};g1.prototype._calcResizeNewMonthsAppPos=function(i,j,O1,P1){var Q1=new Date(i),R1=Q1.getMonth()+P1+1;if(R1<=j.getMonth()){R1=j.getMonth()+1;}Q1.setMonth(R1);Q1=new Date(Q1.getFullYear(),Q1.getMonth(),1);return{startDate:j,endDate:Q1};};g1.prototype._calcCreateNewAppHours=function(i,j,O1){var P1=30*60*1000,Q1,R1;if(j<=O1){Q1=new Date(i.getTime()+(j*P1));R1=new Date(i.getTime()+((O1+1)*P1));}else{Q1=new Date(i.getTime()+(O1*P1));R1=new Date(i.getTime()+(j*P1));}return{startDate:Q1,endDate:R1};};g1.prototype._calcCreateNewAppDays=function(i,j,O1){var P1=new Date(i),Q1=new Date(i);if(j<=O1){P1=new Date(i.getFullYear(),i.getMonth(),i.getDate()+j);Q1=new Date(i.getFullYear(),i.getMonth(),i.getDate()+O1+1);}else{P1=new Date(i.getFullYear(),i.getMonth(),i.getDate()+O1);Q1=new Date(i.getFullYear(),i.getMonth(),i.getDate()+j);}return{startDate:P1,endDate:Q1};};g1.prototype._calcCreateNewAppMonths=function(i,j,O1){var P1=new Date(i),Q1=new Date(i);if(j<=O1){P1=new Date(i.getFullYear(),i.getMonth()+j,1);Q1=new Date(i.getFullYear(),i.getMonth()+O1+1,1);}else{P1=new Date(i.getFullYear(),i.getMonth()+O1,1);Q1=new Date(i.getFullYear(),i.getMonth()+j,1);}return{startDate:P1,endDate:Q1};};g1.prototype._getConfigFromDragDropConfigAggregation=function(j,O1){var P1=j,Q1=P1&&P1.length;for(var i=0;i<Q1;i++){if(P1[i].getGroupName()===O1){return P1[i];}}return null;};g1.prototype._getAppointmentsCreateConfig=function(i){var j=D1(i),O1=new q({targetAggregation:"_intervalPlaceholders",dragStart:function(P1){if(!i.getEnableAppointmentsCreate()||j._isOneMonthsRowOnSmallSizes()||!j._isCreatingPerformed()){P1.preventDefault();return;}var Q1=P1.getParameter("dragSession"),R1=j.$().find(".sapUiCalendarRowAppsOverlay"),S1=U(Q1.getIndicator());setTimeout(function(){R1.addClass("sapUiCalendarRowAppsOverlayDragging");},0);U(document).one("dragend",function(){R1.removeClass("sapUiCalendarRowAppsOverlayDragging");S1.html("");S1.removeClass("sapUiCalendarApp sapUiCalendarAppType01 sapUiAppCreate");});if(!l.browser.msie&&!l.browser.edge){P1.getParameter("browserEvent").dataTransfer.setDragImage(z1(),0,0);}},dragEnter:function(P1){var Q1=P1.getParameter("dragSession"),R1=Q1.getDropControl().getDomRef().getBoundingClientRect(),S1=function(){var U1=U(Q1.getIndicator());U1.addClass("sapUiCalendarApp sapUiCalendarAppType01 sapUiAppCreate");};var T1=Q1.getData("text")?parseFloat(Q1.getData("text").split("|")[0]):0;if(T1){if(T1<=R1.left){Q1.setIndicatorConfig({left:T1,width:Math.max((R1.left+R1.width-T1),R1.width)});}else{Q1.setIndicatorConfig({left:R1.left,width:T1-R1.left});}}else{Q1.setData("text",R1.left+"|"+j.indexOfAggregation("_intervalPlaceholders",Q1.getDropControl()));}if(!Q1.getIndicator()){setTimeout(S1,0);}else{S1();}},drop:function(P1){var Q1=P1.getParameter("dragSession"),R1=U(Q1.getIndicator()),S1=j.getIntervalType(),T1=D1(i).getStartDate(),U1=parseInt(Q1.getData("text").split("|")[1]),V1=j.indexOfAggregation("_intervalPlaceholders",Q1.getDropControl()),W1;if(S1===b1.Hour){W1=this._calcCreateNewAppHours(T1,U1,V1);}else if(S1===b1.Day||S1===b1.Week||(S1===b1.OneMonth&&!j._isOneMonthsRowOnSmallSizes())){W1=this._calcCreateNewAppDays(T1,U1,V1);}else if(S1===b1.Month){W1=this._calcCreateNewAppMonths(T1,U1,V1);}i.fireAppointmentCreate({startDate:W1.startDate,endDate:W1.endDate,calendarRow:i});R1.html("");R1.removeClass("sapUiCalendarApp sapUiCalendarAppType01 sapUiAppCreate");}.bind(this)});O1.setProperty("groupName",e1);return O1;};function z1(){var i=U("<span></span>").addClass("sapUiCalAppResizeGhost");i.appendTo(document.body);setTimeout(function(){i.remove();},0);return i.get(0);}function A1(i){var j=i.getId();return sap.ui.getCore().byId(j.substring(0,j.indexOf(f1)));}function B1(i){return sap.ui.getCore().byId(i.getId()+f1);}function C1(i){var j=B1(i);return j?j.getHeader():null;}function D1(i){var j=B1(i);return j?j.getTimeline():null;}function E1(j){var O1=[];var P1=this.getRows();for(var i=0;i<P1.length;i++){var Q1=P1[i];var R1=B1(Q1);var S1=R1.getSelected();if(Q1.getSelected()!=S1){Q1.setProperty("selected",S1,true);O1.push(Q1);}}if(!this.getSingleSelection()){K1.call(this);}if(O1.length>0){this.fireRowSelectionChange({rows:O1});}}function F1(i){if(i<this._iBreakPointTablet){this._iSize=0;}else if(i<this._iBreakPointDesktop){this._iSize=1;}else{this._iSize=2;}if(i<l1.PHONE){this._iSizeScreen=0;}else if(i<l1.TABLET){this._iSizeScreen=1;}else{this._iSizeScreen=2;}}function G1(j){var O1='sapMSize'+j,P1=this.$(),i,Q1;if(P1){for(i=0;i<3;i++){Q1='sapMSize'+i;if(Q1===O1){P1.addClass(Q1);}else{P1.removeClass(Q1);}}}}function H1(){var j=this._getViews();this._oIntervalTypeSelect.destroyItems();var i;var O1;for(i=0;i<j.length;i++){var P1=j[i];O1=new z(this.getId()+"-"+i,{key:P1.getKey(),text:P1.getDescription(),tooltip:P1.getTooltip()});this._oIntervalTypeSelect.addItem(O1);}if(this._oIntervalTypeSelect.getItems().length>4){this._getHeader()._convertViewSwitchToSelect();}else{this._getHeader()._convertViewSwitchToSegmentedButton();}this._oIntervalTypeSelect.setVisible(!(j.length===1));}function I1(i){var j=i.getParameter("selected");var O1=this.getRows();if(j){O1=this.getRows().filter(function(P1){return!P1.getSelected();});}this.selectAllRows(j);this.fireRowSelectionChange({rows:O1});}function J1(j){var O1=j.oSource;var P1=j.getParameter("type");var Q1=this.getRows();var R1;var S1;var T1;var U1;var i=0;var V1=0;var W1;for(i=0;i<Q1.length;i++){R1=Q1[i];if(D1(R1)==O1){V1=i;break;}}switch(P1){case"sapup":T1=O1.getFocusedAppointment();U1=T1.getStartDate();if(V1>0){V1--;}S1=Q1[V1];D1(S1).focusNearestAppointment(U1);break;case"sapdown":T1=O1.getFocusedAppointment();U1=T1.getStartDate();if(V1<Q1.length-1){V1++;}S1=Q1[V1];D1(S1).focusNearestAppointment(U1);break;case"saphome":if(V1>0){S1=Q1[0];W1=new U.Event(P1);W1._bPlanningCalendar=true;D1(S1).onsaphome(W1);}break;case"sapend":if(V1<Q1.length-1){S1=Q1[Q1.length-1];W1=new U.Event(P1);W1._bPlanningCalendar=true;D1(S1).onsapend(W1);}break;default:break;}}function K1(){if(this._oSelectAllCheckBox){var i=this.getRows();var j=this.getSelectedRows();if(i.length==j.length&&j.length>0){this._oSelectAllCheckBox.setSelected(true);}else{this._oSelectAllCheckBox.setSelected(false);}}}function L1(){if(this.getSingleSelection()){if(this._oCalendarHeader.getAllCheckBox()){this._oCalendarHeader.setAllCheckBox();}else if(this._oInfoToolbar.getContent().length>2){this._oInfoToolbar.removeContent(this._oSelectAllCheckBox);}}else{if(!this._oSelectAllCheckBox){this._oSelectAllCheckBox=new K(this.getId()+"-All",{text:this._oRB.getText("COLUMNSPANEL_SELECT_ALL")});this._oSelectAllCheckBox.attachEvent("select",I1,this);}if(this._iSizeScreen<2||!this.getShowRowHeaders()){var i=this._oInfoToolbar.indexOfContent(this._oSelectAllCheckBox);if(this._iSizeScreen<2){if(i<this._oInfoToolbar.getContent().length-1){this._oInfoToolbar.addContent(this._oSelectAllCheckBox);}}else if(i<0||i>1){if(i>1){this._oInfoToolbar.removeContent(this._oSelectAllCheckBox);}this._oInfoToolbar.insertContent(this._oSelectAllCheckBox,1);}}else{this._oCalendarHeader.setAllCheckBox(this._oSelectAllCheckBox);}}}function M1(){var i=this.getAggregation("table");var j=i.getMode();var O1;if(this.getSingleSelection()){if(!this.getShowRowHeaders()&&this.getRows().length==1){O1=X.None;}else{O1=X.SingleSelectMaster;}}else{O1=X.MultiSelect;}if(j!=O1){i.setMode(O1);}}function N1(){return this._oTimesRow||this._oDatesRow||this._oMonthsRow||this._oWeeksRow||this._oOneMonthsRow;}return g1;});
