/*!
 * OpenUI5
 * (c) Copyright 2009-2019 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(['./Dialog','./Popover','./SelectList','./library','sap/ui/core/Core','sap/ui/core/Control','sap/ui/core/EnabledPropagator','sap/ui/core/Icon','sap/ui/core/IconPool','./Button','./Bar','./Title','./delegate/ValueStateMessage','sap/ui/core/message/MessageMixin','sap/ui/core/library','sap/ui/core/Item','sap/ui/Device','sap/ui/core/InvisibleText','./SelectRenderer',"sap/ui/dom/containsOrEquals","sap/ui/events/KeyCodes",'./Text','sap/m/SimpleFixFlex'],function(D,P,S,l,C,a,E,I,b,B,c,T,V,M,d,e,f,g,h,j,K,k,m){"use strict";var n=l.SelectListKeyboardNavigationMode;var o=l.PlacementType;var p=d.ValueState;var q=d.TextDirection;var r=d.TextAlign;var s=l.SelectType;var t=a.extend("sap.m.Select",{metadata:{interfaces:["sap.ui.core.IFormContent","sap.m.IOverflowToolbarContent","sap.f.IShellBar"],library:"sap.m",properties:{name:{type:"string",group:"Misc",defaultValue:""},enabled:{type:"boolean",group:"Behavior",defaultValue:true},editable:{type:"boolean",group:"Behavior",defaultValue:true},width:{type:"sap.ui.core.CSSSize",group:"Dimension",defaultValue:"auto"},maxWidth:{type:"sap.ui.core.CSSSize",group:"Dimension",defaultValue:"100%"},selectedKey:{type:"string",group:"Data",defaultValue:""},selectedItemId:{type:"string",group:"Misc",defaultValue:""},icon:{type:"sap.ui.core.URI",group:"Appearance",defaultValue:""},type:{type:"sap.m.SelectType",group:"Appearance",defaultValue:s.Default},autoAdjustWidth:{type:"boolean",group:"Appearance",defaultValue:false},textAlign:{type:"sap.ui.core.TextAlign",group:"Appearance",defaultValue:r.Initial},textDirection:{type:"sap.ui.core.TextDirection",group:"Appearance",defaultValue:q.Inherit},valueState:{type:"sap.ui.core.ValueState",group:"Appearance",defaultValue:p.None},valueStateText:{type:"string",group:"Misc",defaultValue:""},showSecondaryValues:{type:"boolean",group:"Misc",defaultValue:false},forceSelection:{type:"boolean",group:"Behavior",defaultValue:true},wrapItemsText:{type:"boolean",group:"Behavior",defaultValue:false}},defaultAggregation:"items",aggregations:{items:{type:"sap.ui.core.Item",multiple:true,singularName:"item",bindable:"bindable",forwarding:{getter:"getList",aggregation:"items"}},picker:{type:"sap.ui.core.PopupInterface",multiple:false,visibility:"hidden"},_valueIcon:{type:"sap.ui.core.Icon",multiple:false,visibility:"hidden"},_pickerHeader:{type:"sap.m.Bar",multiple:false,visibility:"hidden"},_pickerValueStateContent:{type:"sap.m.Text",multiple:false,visibility:"hidden"}},associations:{selectedItem:{type:"sap.ui.core.Item",multiple:false},ariaLabelledBy:{type:"sap.ui.core.Control",multiple:true,singularName:"ariaLabelledBy"}},events:{change:{parameters:{selectedItem:{type:"sap.ui.core.Item"}}}},designtime:"sap/m/designtime/Select.designtime"}});b.insertFontFaceStyle();E.apply(t.prototype,[true]);M.call(t.prototype);function H(i){if(i){this.setSelection(i);this.setValue(i.getText());this.scrollToItem(i);}}t.prototype._handleFocusout=function(i){this._bFocusoutDueRendering=this.bRenderingPhase;if(this._bFocusoutDueRendering){this._bProcessChange=false;return;}if(this._bProcessChange){if(!this.isOpen()||i.target===this.getAggregation("picker")){this._checkSelectionChange();}else{this._revertSelection();}this._bProcessChange=false;}else{this._bProcessChange=true;}};t.prototype._checkSelectionChange=function(){var i=this.getSelectedItem();if(this._oSelectionOnFocus!==i){this.fireChange({selectedItem:i});}};t.prototype._revertSelection=function(){var i=this.getSelectedItem();if(this._oSelectionOnFocus!==i){this.setSelection(this._oSelectionOnFocus);this.setValue(this._getSelectedItemText());}};t.prototype._getSelectedItemText=function(i){i=i||this.getSelectedItem();if(!i){i=this.getDefaultSelectedItem();}if(i){return i.getText();}return"";};t.prototype.getOverflowToolbarConfig=function(){var i=["enabled","selectedKey"];if(!this.getAutoAdjustWidth()||this._bIsInOverflow){i.push("selectedItemId");}var u={canOverflow:true,autoCloseEvents:["change"],invalidationEvents:["_itemTextChange"],propsUnrelatedToSize:i};u.onBeforeEnterOverflow=function(v){var w=v.getParent();if(!w.isA("sap.m.OverflowToolbar")){return;}v._prevSelectType=v.getType();v._bIsInOverflow=true;if(v.getType()!==s.Default){v.setProperty("type",s.Default,true);}};u.onAfterExitOverflow=function(v){var w=v.getParent();if(!w.isA("sap.m.OverflowToolbar")){return;}v._bIsInOverflow=false;if(v.getType()!==v._prevSelectType){v.setProperty("type",v._prevSelectType,true);}};return u;};t.prototype.getList=function(){if(this.bIsDestroyed){return null;}return this._oList;};t.prototype.findFirstEnabledItem=function(i){var L=this.getList();return L?L.findFirstEnabledItem(i):null;};t.prototype.findLastEnabledItem=function(i){var L=this.getList();return L?L.findLastEnabledItem(i):null;};t.prototype.setSelectedIndex=function(i,_){var u;_=_||this.getItems();i=(i>_.length-1)?_.length-1:Math.max(0,i);u=_[i];if(u){this.setSelection(u);}};t.prototype.scrollToItem=function(i){var u=this.getPicker().getDomRef(),v=i&&i.getDomRef();if(!u||!v){return;}var w=u.querySelector('.sapUiSimpleFixFlexFlexContent'),x=u.querySelector('.sapMSltPickerValueState'),y=x?x.clientHeight:0,z=w.scrollTop,A=v.offsetTop-y,F=w.clientHeight,G=v.offsetHeight;if(z>A){w.scrollTop=A;}else if((A+G)>(z+F)){w.scrollTop=Math.ceil(A+G-F);}};t.prototype.setValue=function(v){var i=this.getDomRef(),u=i&&i.querySelector(".sapMSelectListItemText");if(u){u.textContent=v;}this._getValueIcon();};t.prototype._getValueIcon=function(){if(this.bIsDestroyed){return null;}var v=this.getAggregation("_valueIcon"),i=this.getSelectedItem(),u=!!(i&&i.getIcon&&i.getIcon()),w=u?i.getIcon():"sap-icon://pull-down";if(!v){v=new I(this.getId()+"-labelIcon",{src:w,visible:false});this.setAggregation("_valueIcon",v,true);}if(v.getVisible()!==u){v.setVisible(u);v.toggleStyleClass("sapMSelectListItemIcon",u);}if(u&&i.getIcon()!==v.getSrc()){v.setSrc(w);}return v;};t.prototype._isShadowListRequired=function(){if(this.getAutoAdjustWidth()){return false;}else if(this.getWidth()==="auto"){return true;}return false;};t.prototype._handleAriaActiveDescendant=function(i){var u=this.getDomRef(),v=i&&i.getDomRef(),A="aria-activedescendant";if(!u){return;}if(v&&this.isOpen()){u.setAttribute(A,i.getId());}else{u.removeAttribute(A);}};t.prototype.updateItems=function(R){S.prototype.updateItems.apply(this,arguments);this._oSelectionOnFocus=this.getSelectedItem();};t.prototype.refreshItems=function(){S.prototype.refreshItems.apply(this,arguments);};t.prototype.onBeforeOpen=function(i){var u=this["_onBeforeOpen"+this.getPickerType()],v=this.getRenderer().CSS_CLASS;this.addStyleClass(v+"Pressed");this.addStyleClass(v+"Expanded");this.closeValueStateMessage();this.addContent();this.addContentToFlex();u&&u.call(this);};t.prototype.onAfterOpen=function(i){var u=this.getFocusDomRef(),v=null,$=this.$("label");if(!u){return;}v=this.getSelectedItem();u.setAttribute("aria-expanded","true");$.attr("aria-live",null);u.setAttribute("aria-controls",this.getList().getId());if(v){u.setAttribute("aria-activedescendant",v.getId());this.scrollToItem(v);}};t.prototype.onBeforeClose=function(i){var u=this.getFocusDomRef(),v=this.getRenderer().CSS_CLASS;if(u){u.removeAttribute("aria-controls");u.removeAttribute("aria-activedescendant");if(this.shouldValueStateMessageBeOpened()&&(document.activeElement===u)){this.openValueStateMessage();}}this.removeStyleClass(v+"Expanded");};t.prototype.onAfterClose=function(i){var u=this.getFocusDomRef(),v=this.getRenderer().CSS_CLASS,w=v+"Pressed",$=this.$("label");if(u){u.setAttribute("aria-expanded","false");u.removeAttribute("aria-activedescendant");$.attr("aria-live","polite");}this.removeStyleClass(w);};t.prototype.getPicker=function(){if(this.bIsDestroyed){return null;}return this.createPicker(this.getPickerType());};t.prototype.getSimpleFixFlex=function(){if(this.bIsDestroyed){return null;}else if(this.oSimpleFixFlex){return this.oSimpleFixFlex;}this.oSimpleFixFlex=new m({id:this.getPickerValueStateContentId(),fixContent:this._getPickerValueStateContent().addStyleClass(this.getRenderer().CSS_CLASS+"PickerValueState"),flexContent:this.createList()});return this.oSimpleFixFlex;};t.prototype.setPickerType=function(i){this._sPickerType=i;};t.prototype.getPickerType=function(){return this._sPickerType;};t.prototype._getPickerValueStateContent=function(){if(!this.getAggregation("_pickerValueStateContent")){this.setAggregation("_pickerValueStateContent",new k({wrapping:true,text:this._getTextForPickerValueStateContent()}));}return this.getAggregation("_pickerValueStateContent");};t.prototype._updatePickerValueStateContentText=function(){var i=this.getPicker().getContent()[0].getFixContent(),u;if(i){u=this._getTextForPickerValueStateContent();i.setText(u);}};t.prototype._getTextForPickerValueStateContent=function(){var v=this.getValueStateText(),i;if(v){i=v;}else{i=this._getDefaultTextForPickerValueStateContent();}return i;};t.prototype._getDefaultTextForPickerValueStateContent=function(){var v=this.getValueState(),R,i;if(v===p.None){i="";}else{R=C.getLibraryResourceBundle("sap.ui.core");i=R.getText("VALUE_STATE_"+v.toUpperCase());}return i;};t.prototype._updatePickerValueStateContentStyles=function(){var v=this.getValueState(),i=p,u=this.getRenderer().CSS_CLASS,w=u+"Picker",x=w+v+"State",y=w+"WithSubHeader",z=this.getPicker(),A=z.getContent()[0].getFixContent();if(A){this._removeValueStateClassesForPickerValueStateContent(z);A.addStyleClass(x);if(v!==i.None){z.addStyleClass(y);}else{z.removeStyleClass(y);}}};t.prototype._removeValueStateClassesForPickerValueStateContent=function(i){var v=p,u=this.getRenderer().CSS_CLASS,w=u+"Picker",x=i.getContent()[0].getFixContent();Object.keys(v).forEach(function(y){var O=w+y+"State";x.removeStyleClass(O);});};t.prototype._createPopover=function(){var i=this;var u=new P({showArrow:false,showHeader:false,placement:o.VerticalPreferredBottom,offsetX:0,offsetY:0,initialFocus:this,bounce:false,ariaLabelledBy:[this.getPickerValueStateContentId(),this._getPickerHiddenLabelId()]});u.addEventDelegate({ontouchstart:function(v){var w=this.getDomRef("cont");if((v.target===w)||(v.srcControl instanceof e)){i._bProcessChange=false;}}},u);this._decoratePopover(u);return u;};t.prototype._decoratePopover=function(i){var u=this;i.open=function(){return this.openBy(u);};};t.prototype._onBeforeRenderingPopover=function(){var i=this.getPicker(),w=this.$().outerWidth()+"px";if(i){i.setContentMinWidth(w);}};t.prototype._createDialog=function(){var i=this;return new D({stretch:true,ariaLabelledBy:[this.getPickerValueStateContentId(),this._getPickerHiddenLabelId()],customHeader:this._getPickerHeader(),beforeOpen:function(){i.updatePickerHeaderTitle();}});};t.prototype._getPickerTitle=function(){var i=this.getPicker(),u=i&&i.getCustomHeader();if(u){return u.getContentMiddle()[0];}return null;};t.prototype._getPickerHeader=function(){var i=b.getIconURI("decline"),R;if(!this.getAggregation("_pickerHeader")){R=C.getLibraryResourceBundle("sap.m");this.setAggregation("_pickerHeader",new c({contentMiddle:new T({text:R.getText("SELECT_PICKER_TITLE_TEXT")}),contentRight:new B({icon:i,press:this.close.bind(this)})}));}return this.getAggregation("_pickerHeader");};t.prototype._getPickerHiddenLabelId=function(){return g.getStaticId("sap.m","INPUT_AVALIABLE_VALUES");};t.prototype.getPickerValueStateContentId=function(){return this.getId()+"-valueStateText";};t.prototype.updatePickerHeaderTitle=function(){var i=this.getPicker();if(!i){return;}var L=this.getLabels();if(L.length){var u=L[0],v=this._getPickerTitle();if(u&&(typeof u.getText==="function")){v&&v.setText(u.getText());}}};t.prototype._onBeforeOpenDialog=function(){};t.prototype.init=function(){this.setPickerType(f.system.phone?"Dialog":"Popover");this.createPicker(this.getPickerType());this._oSelectionOnFocus=null;this.bRenderingPhase=false;this._bFocusoutDueRendering=false;this._bProcessChange=false;this.sTypedChars="";this.iTypingTimeoutID=-1;this._oValueStateMessage=new V(this);this._bValueStateMessageOpened=false;};t.prototype.onBeforeRendering=function(){this.bRenderingPhase=true;this.synchronizeSelection({forceSelection:this.getForceSelection()});this._updatePickerValueStateContentText();this._updatePickerValueStateContentStyles();};t.prototype.onAfterRendering=function(){this.bRenderingPhase=false;};t.prototype.exit=function(){var v=this.getValueStateMessage(),i=this._getValueIcon();this._oSelectionOnFocus=null;if(v){this.closeValueStateMessage();v.destroy();}if(i){i.destroy();}this._oValueStateMessage=null;this._bValueStateMessageOpened=false;};t.prototype.ontouchstart=function(i){i.setMarked();if(this.getEnabled()&&this.getEditable()&&this.isOpenArea(i.target)){this.addStyleClass(this.getRenderer().CSS_CLASS+"Pressed");}};t.prototype.ontouchend=function(i){i.setMarked();if(this.getEnabled()&&this.getEditable()&&!this.isOpen()&&this.isOpenArea(i.target)){this.removeStyleClass(this.getRenderer().CSS_CLASS+"Pressed");}};t.prototype.ontap=function(i){var u=this.getRenderer().CSS_CLASS;i.setMarked();if(!this.getEnabled()||!this.getEditable()){return;}if(this.isOpenArea(i.target)){if(this.isOpen()){this.close();this.removeStyleClass(u+"Pressed");return;}if(f.system.phone){this.focus();}this.open();}if(this.isOpen()){this.addStyleClass(u+"Pressed");}};t.prototype.onSelectionChange=function(i){var u=i.getParameter("selectedItem");this.close();this.setSelection(u);this.fireChange({selectedItem:u});this.setValue(this._getSelectedItemText());};t.prototype.onkeypress=function(i){if(!this.getEnabled()||!this.getEditable()){return;}i.setMarked();var u=String.fromCharCode(i.which),v;this.sTypedChars+=u;v=(/^(.)\1+$/i).test(this.sTypedChars)?u:this.sTypedChars;clearTimeout(this.iTypingTimeoutID);this.iTypingTimeoutID=setTimeout(function(){this.sTypedChars="";this.iTypingTimeoutID=-1;}.bind(this),1000);H.call(this,this.searchNextItemByText(v));};t.prototype.onsapshow=function(i){if(!this.getEnabled()||!this.getEditable()){return;}i.setMarked();if(i.which===K.F4){i.preventDefault();}this.toggleOpenState();};t.prototype.onsaphide=t.prototype.onsapshow;t.prototype.onsapescape=function(i){if(!this.getEnabled()||!this.getEditable()){return;}if(this.isOpen()){i.setMarked();this.close();this._revertSelection();}};t.prototype.onsapenter=function(i){if(!this.getEnabled()||!this.getEditable()){return;}i.setMarked();this.close();this._checkSelectionChange();};t.prototype.onsapspace=function(i){i.preventDefault();};t.prototype.onkeyup=function(i){if(!this.getEnabled()||!this.getEditable()){return;}if(i.which===K.SPACE&&!i.shiftKey){i.setMarked();i.preventDefault();if(this.isOpen()){this._checkSelectionChange();}this.toggleOpenState();}};t.prototype.onsapdown=function(i){if(!this.getEnabled()||!this.getEditable()){return;}i.setMarked();i.preventDefault();var N,u=this.getSelectableItems();N=u[u.indexOf(this.getSelectedItem())+1];H.call(this,N);};t.prototype.onsapup=function(i){if(!this.getEnabled()||!this.getEditable()){return;}i.setMarked();i.preventDefault();var u,v=this.getSelectableItems();u=v[v.indexOf(this.getSelectedItem())-1];H.call(this,u);};t.prototype.onsaphome=function(i){if(!this.getEnabled()||!this.getEditable()){return;}i.setMarked();i.preventDefault();var F=this.getSelectableItems()[0];H.call(this,F);};t.prototype.onsapend=function(i){if(!this.getEnabled()||!this.getEditable()){return;}i.setMarked();i.preventDefault();var L=this.findLastEnabledItem(this.getSelectableItems());H.call(this,L);};t.prototype.onsappagedown=function(i){if(!this.getEnabled()||!this.getEditable()){return;}i.setMarked();i.preventDefault();var u=this.getSelectableItems(),v=this.getSelectedItem();this.setSelectedIndex(u.indexOf(v)+10,u);v=this.getSelectedItem();if(v){this.setValue(v.getText());}this.scrollToItem(v);};t.prototype.onsappageup=function(i){if(!this.getEnabled()||!this.getEditable()){return;}i.setMarked();i.preventDefault();var u=this.getSelectableItems(),v=this.getSelectedItem();this.setSelectedIndex(u.indexOf(v)-10,u);v=this.getSelectedItem();if(v){this.setValue(v.getText());}this.scrollToItem(v);};t.prototype.onsaptabnext=function(i){if(!this.getEnabled()){return;}if(this.isOpen()){this.close();this._checkSelectionChange();}};t.prototype.onsaptabprevious=t.prototype.onsaptabnext;t.prototype.onfocusin=function(i){if(!this._bFocusoutDueRendering&&!this._bProcessChange){this._oSelectionOnFocus=this.getSelectedItem();}this._bProcessChange=true;setTimeout(function(){if(!this.isOpen()&&this.shouldValueStateMessageBeOpened()&&(document.activeElement===this.getFocusDomRef())){this.openValueStateMessage();}}.bind(this),100);if(i.target!==this.getFocusDomRef()){this.focus();}};t.prototype.onfocusout=function(i){this._handleFocusout(i);if(this.bRenderingPhase){return;}this.closeValueStateMessage();};t.prototype.onsapfocusleave=function(i){var u=this.getAggregation("picker");if(!i.relatedControlId||!u){return;}var v=C.byId(i.relatedControlId),F=v&&v.getFocusDomRef();if(f.system.desktop&&j(u.getFocusDomRef(),F)){this.focus();}};t.prototype.setSelection=function(i){var L=this.getList(),u;if(L){L.setSelection(i);}this.setAssociation("selectedItem",i,true);this.setProperty("selectedItemId",(i instanceof e)?i.getId():i,true);if(typeof i==="string"){i=C.byId(i);}u=i?i.getKey():"";this.setProperty("selectedKey",u,true);this._handleAriaActiveDescendant(i);};t.prototype.isSelectionSynchronized=function(){return S.prototype.isSelectionSynchronized.apply(this,arguments);};t.prototype.synchronizeSelection=function(){S.prototype.synchronizeSelection.apply(this,arguments);};t.prototype.addContent=function(i){};t.prototype.addContentToFlex=function(){};t.prototype.createPicker=function(i){var u=this.getAggregation("picker"),v=this.getRenderer().CSS_CLASS;if(u){return u;}u=this["_create"+i]();this.setAggregation("picker",u,true);u.setHorizontalScrolling(false).addStyleClass(v+"Picker").addStyleClass(v+"Picker-CTX").addStyleClass("sapUiNoContentPadding").attachBeforeOpen(this.onBeforeOpen,this).attachAfterOpen(this.onAfterOpen,this).attachBeforeClose(this.onBeforeClose,this).attachAfterClose(this.onAfterClose,this).addEventDelegate({onBeforeRendering:this.onBeforeRenderingPicker,onAfterRendering:this.onAfterRenderingPicker},this).addContent(this.getSimpleFixFlex());return u;};t.prototype.searchNextItemByText=function(u){var v=this.getItems(),w=this.getSelectedIndex(),x=v.splice(w+1,v.length-w),y=v.splice(0,v.length-1);v=x.concat(y);for(var i=0,z;i<v.length;i++){z=v[i];var A=typeof u==="string"&&u!=="";if(z.getEnabled()&&!(z instanceof sap.ui.core.SeparatorItem)&&z.getText().toLowerCase().startsWith(u.toLowerCase())&&A){return z;}}return null;};t.prototype.createList=function(){var L=n,i=f.system.phone?L.Delimited:L.None;this._oList=new S({width:"100%",maxWidth:"600px",keyboardNavigationMode:i}).addStyleClass(this.getRenderer().CSS_CLASS+"List-CTX").addEventDelegate({ontap:function(u){this._checkSelectionChange();this.close();}},this).attachSelectionChange(this.onSelectionChange,this);this._oList.toggleStyleClass("sapMSelectListWrappedItems",this.getWrapItemsText());return this._oList;};t.prototype.setWrapItemsText=function(w){if(this._oList){this._oList.toggleStyleClass("sapMSelectListWrappedItems",w);}return this.setProperty("wrapItemsText",w,true);};t.prototype.hasContent=function(){return this.getItems().length>0;};t.prototype.onBeforeRenderingPicker=function(){var O=this["_onBeforeRendering"+this.getPickerType()];O&&O.call(this);};t.prototype.onAfterRenderingPicker=function(){var O=this["_onAfterRendering"+this.getPickerType()];O&&O.call(this);};t.prototype.open=function(){var i=this.getPicker();if(i){i.open();}return this;};t.prototype.toggleOpenState=function(){if(this.isOpen()){this.close();}else{this.open();}return this;};t.prototype.getVisibleItems=function(){var L=this.getList();return L?L.getVisibleItems():[];};t.prototype.isItemSelected=function(i){return i&&(i.getId()===this.getAssociation("selectedItem"));};t.prototype.getSelectedIndex=function(){var i=this.getSelectedItem();return i?this.indexOfItem(this.getSelectedItem()):-1;};t.prototype.getDefaultSelectedItem=function(i){return this.getForceSelection()?this.findFirstEnabledItem():null;};t.prototype.getSelectableItems=function(){var L=this.getList();return L?L.getSelectableItems():[];};t.prototype.getOpenArea=function(){return this.getDomRef();};t.prototype.isOpenArea=function(i){var O=this.getOpenArea();return O&&O.contains(i);};t.prototype.findItem=function(i,v){var L=this.getList();return L?L.findItem(i,v):null;};t.prototype.clearSelection=function(){this.setSelection(null);};t.prototype.onItemChange=function(i){var u=this.getAssociation("selectedItem"),v=i.getParameter("id"),w=i.getParameter("name"),N=i.getParameter("newValue"),O,x,F,y;if(w==="key"&&!this.isBound("selectedKey")){x=this.getSelectedKey();F=this.getItemByKey(N);if(N===x&&u!==v&&F&&v===F.getId()){this.setSelection(F);return;}O=i.getParameter("oldValue");if(u===v&&x===O&&!this.getItemByKey(O)){this.setSelectedKey(N);return;}y=this.getItemByKey(x);if(u===v&&N!==x&&y){this.setSelection(y);return;}}if(w==="text"&&u===v){this.fireEvent("_itemTextChange");this.setValue(N);}};t.prototype.fireChange=function(i){this._oSelectionOnFocus=i.selectedItem;return this.fireEvent("change",i);};t.prototype.addAggregation=function(A,O,i){if(A==="items"&&!i&&!this.isInvalidateSuppressed()){this.invalidate(O);}return a.prototype.addAggregation.apply(this,arguments);};t.prototype.destroyAggregation=function(A,i){if(A==="items"&&!i&&!this.isInvalidateSuppressed()){this.invalidate();}return a.prototype.destroyAggregation.apply(this,arguments);};t.prototype.setAssociation=function(A,i,u){var L=this.getList();if(L&&(A==="selectedItem")){S.prototype.setAssociation.apply(L,arguments);}return a.prototype.setAssociation.apply(this,arguments);};t.prototype.setProperty=function(i,v,u){var L=this.getList();if((i==="selectedKey")||(i==="selectedItemId")){L&&S.prototype.setProperty.apply(L,arguments);}return a.prototype.setProperty.apply(this,arguments);};t.prototype.removeAllAssociation=function(A,i){var L=this.getList();if(L&&(A==="selectedItem")){S.prototype.removeAllAssociation.apply(L,arguments);}return a.prototype.removeAllAssociation.apply(this,arguments);};t.prototype.clone=function(){var i=a.prototype.clone.apply(this,arguments),u=this.getSelectedItem(),v=this.getSelectedKey();if(!this.isBound("selectedKey")&&!i.isSelectionSynchronized()){if(u&&(v==="")){i.setSelectedIndex(this.indexOfItem(u));}else{i.setSelectedKey(v);}}return i;};t.prototype.updateValueStateClasses=function(v,O){var $=this.$(),L=this.$("label"),A=this.$("arrow"),i=p,u=this.getRenderer().CSS_CLASS;if(O!==i.None){$.removeClass(u+"State");$.removeClass(u+O);L.removeClass(u+"LabelState");L.removeClass(u+"Label"+O);A.removeClass(u+"ArrowState");}if(v!==i.None){$.addClass(u+"State");$.addClass(u+v);L.addClass(u+"LabelState");L.addClass(u+"Label"+v);A.addClass(u+"ArrowState");}};t.prototype.updateAriaLabelledBy=function(v,O){var $=this.$(),A=$.attr("aria-labelledby"),i=A?A.split(" "):[],N;if(O!==p.None&&O!==p.Error){i.pop();}if(v!==p.None&&v!==p.Error){i.push(g.getStaticId("sap.ui.core","VALUE_STATE_"+v.toUpperCase()));}N=i.join(" ");$.attr("aria-labelledby",N);};t.prototype.getLabels=function(){var L=this.getAriaLabelledBy().map(function(u){return C.byId(u);});var i=sap.ui.require("sap/ui/core/LabelEnablement");if(i){L=L.concat(i.getReferencingLabels(this).map(function(u){return C.byId(u);}));}return L;};t.prototype.getDomRefForValueStateMessage=function(){return this.getDomRef();};t.prototype.getValueStateMessageId=function(){return this.getId()+"-message";};t.prototype.getValueStateMessage=function(){return this._oValueStateMessage;};t.prototype.openValueStateMessage=function(){var v=this.getValueStateMessage();if(v&&!this._bValueStateMessageOpened){this._bValueStateMessageOpened=true;v.open();}};t.prototype.closeValueStateMessage=function(){var v=this.getValueStateMessage();if(v&&this._bValueStateMessageOpened){this._bValueStateMessageOpened=false;v.close();}};t.prototype.shouldValueStateMessageBeOpened=function(){return(this.getValueState()!==p.None)&&this.getEnabled()&&this.getEditable()&&!this._bValueStateMessageOpened;};t.prototype.setShowSecondaryValues=function(A){var i=!this._isShadowListRequired();this.setProperty("showSecondaryValues",A,i);var L=this.getList();if(L){L.setShowSecondaryValues(A);}return this;};t.prototype.addItem=function(i){this.addAggregation("items",i);if(i){i.attachEvent("_change",this.onItemChange,this);}return this;};t.prototype.insertItem=function(i,u){this.insertAggregation("items",i,u);if(i){i.attachEvent("_change",this.onItemChange,this);}return this;};t.prototype.findAggregatedObjects=function(){var L=this.getList();if(L){return S.prototype.findAggregatedObjects.apply(L,arguments);}return[];};t.prototype.getItems=function(){var L=this.getList();return L?L.getItems():[];};t.prototype.setSelectedItem=function(i){if(typeof i==="string"){this.setAssociation("selectedItem",i,true);i=C.byId(i);}if(!(i instanceof e)&&i!==null){return this;}if(!i){i=this.getDefaultSelectedItem();}this.setSelection(i);this.setValue(this._getSelectedItemText(i));this._oSelectionOnFocus=i;return this;};t.prototype.setSelectedItemId=function(i){i=this.validateProperty("selectedItemId",i);if(!i){i=this.getDefaultSelectedItem();}this.setSelection(i);this.setValue(this._getSelectedItemText());this._oSelectionOnFocus=this.getSelectedItem();return this;};t.prototype.setSelectedKey=function(i){i=this.validateProperty("selectedKey",i);var u=(i==="");if(!this.getForceSelection()&&u){this.setSelection(null);this.setValue("");return this;}var v=this.getItemByKey(i);if(v||u){if(!v&&u){v=this.getDefaultSelectedItem();}this.setSelection(v);this.setValue(this._getSelectedItemText(v));this._oSelectionOnFocus=v;return this;}return this.setProperty("selectedKey",i);};t.prototype.setValueState=function(v){var O=this.getValueState();this.setProperty("valueState",v,true);v=this.getValueState();if(v===O){return this;}var i=this.getDomRefForValueState();if(!i){return this;}var u=p;if(v===u.Error){i.setAttribute("aria-invalid",true);}else{i.removeAttribute("aria-invalid");}if(!this.isOpen()&&this.shouldValueStateMessageBeOpened()&&document.activeElement===i){this.openValueStateMessage();}else{this.closeValueStateMessage();}this.updateValueStateClasses(v,O);this.updateAriaLabelledBy(v,O);this._updatePickerValueStateContentText();this._updatePickerValueStateContentStyles();return this;};t.prototype.setValueStateText=function(v){this.setProperty("valueStateText",v,true);if(this.getDomRefForValueState()){this._updatePickerValueStateContentText();this._updatePickerValueStateContentStyles();}return this;};t.prototype.getItemAt=function(i){return this.getItems()[+i]||null;};t.prototype.getSelectedItem=function(){var v=this.getAssociation("selectedItem");return(v===null)?null:C.byId(v)||null;};t.prototype.getFirstItem=function(){return this.getItems()[0]||null;};t.prototype.getLastItem=function(){var i=this.getItems();return i[i.length-1]||null;};t.prototype.getEnabledItems=function(i){var L=this.getList();return L?L.getEnabledItems(i):[];};t.prototype.getItemByKey=function(i){var L=this.getList();return L?L.getItemByKey(i):null;};t.prototype.removeItem=function(i){var u;i=this.removeAggregation("items",i);if(this.getItems().length===0){this.clearSelection();}else if(this.isItemSelected(i)){u=this.findFirstEnabledItem();if(u){this.setSelection(u);}}this.setValue(this._getSelectedItemText());if(i){i.detachEvent("_change",this.onItemChange,this);}return i;};t.prototype.removeAllItems=function(){var u=this.removeAllAggregation("items");this.setValue("");if(this._isShadowListRequired()){this.$().find(".sapMSelectListItemBase").remove();}for(var i=0;i<u.length;i++){u[i].detachEvent("_change",this.onItemChange,this);}return u;};t.prototype.destroyItems=function(){this.destroyAggregation("items");this.setValue("");if(this._isShadowListRequired()){this.$().find(".sapMSelectListItemBase").remove();}return this;};t.prototype.isOpen=function(){var i=this.getAggregation("picker");return!!(i&&i.isOpen());};t.prototype.close=function(){var i=this.getAggregation("picker");if(i){i.close();}return this;};t.prototype.getDomRefForValueState=function(){return this.getDomRef();};t.prototype.getAccessibilityInfo=function(){var i=this.getType()==="IconOnly",u={role:this.getRenderer().getAriaRole(this),focusable:this.getEnabled(),enabled:this.getEnabled(),readonly:i?undefined:this.getEnabled()&&!this.getEditable()};if(i){var v=this.getTooltip_AsString();if(!v){var w=b.getIconInfo(this.getIcon());v=w&&w.text?w.text:"";}u.type=C.getLibraryResourceBundle("sap.m").getText("ACC_CTR_TYPE_BUTTON");u.description=v;}else if(this.getType()==="Default"){u.type=C.getLibraryResourceBundle("sap.m").getText("ACC_CTR_TYPE_COMBO");u.description=this._getSelectedItemText();}return u;};t.prototype.getIdForLabel=function(){return this.getId()+"-hiddenInput";};return t;});
