/*!
 * OpenUI5
 * (c) Copyright 2009-2019 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(['sap/ui/thirdparty/jquery','sap/base/Log','./library','sap/ui/core/Control','sap/ui/core/Popup','./MessageToast','./MessageList','./MessageBarRenderer','sap/ui/dom/jquery/rect'],function(q,L,l,C,P,M,a,b){"use strict";var c=l.MessageType;var d=C.extend("sap.ui.commons.MessageBar",{metadata:{deprecated:true,library:"sap.ui.commons",properties:{anchorID:{type:"string",group:"Appearance",defaultValue:''},visible:{type:"boolean",group:"Behavior",defaultValue:true},maxToasted:{type:"int",group:"Misc",defaultValue:3},maxListed:{type:"int",group:"Misc",defaultValue:7},anchorSnapPoint:{type:"string",group:"Misc",defaultValue:"begin top"}}}});d.prototype.init=function(){this.aErrors=[];this.aWarnings=[];this.aSuccesses=[];this.aToasts=[];this.maxToastsReached=false;this.oPopup=new P(this,false,true,false);this.oList=null;var i=this.getId();this.oToast=new M(i+"__Toast",{anchorId:i+"__sums"});var t=this;this.oToast.attachNext(function(){t.checkForToast();});this.snapPoint=null;this.oHomePosition=null;this.oDropPosition=null;this.bToggleListBackAfterDrag=null;};d.prototype.exit=function(){this.onmouseup();this.close();this.oPopup.destroy();this.oPopup=null;this.oToast.destroy();this.oToast=null;if(this.oList){this.oList.destroy();this.oList=null;}};d.prototype.ondragstart=function(e){e.preventDefault();e.stopPropagation();};d.prototype.onmousedown=function(e){var s=e.target;var S=q(s);if(S.css('cursor')!="move"){return;}this.sDragMode="move";this.oMsgBarDragStartPosition=this.$().rect();this.oMsgBarDragStartPosition.right=Number(this.$().css('right').replace("px",""));if(!this.oHomePosition){this.oHomePosition=this.oMsgBarDragStartPosition;}this.mouseDragStartPositionX=e.screenX;this.mouseDragStartPositionY=e.screenY;var D=q(window.document);D.bind("mousemove",q.proxy(this.handleMove,this));if(window.parent){q(window.parent.document).bind("mousemove",q.proxy(this.handleMove,this),true);}D.bind("selectstart",q.proxy(this.ondragstart,this),true);};d.prototype.handleMove=function(e){if(!this.sDragMode){return;}if(this.bToggleListBackAfterDrag==null&&this.oList){this.bToggleListBackAfterDrag=this.oList.getVisible();if(this.bToggleListBackAfterDrag){this.toggleList();}}e=e||window.event;var t=this.oMsgBarDragStartPosition.top+e.screenY-this.mouseDragStartPositionY;var i=this.oMsgBarDragStartPosition.left+e.screenX-this.mouseDragStartPositionX;var r=this.oMsgBarDragStartPosition.right-e.screenX+this.mouseDragStartPositionX;this.oPopup._$().css('top',t);if(this.snapPoint.indexOf("right")!=-1){this.oPopup._$().css('right',r);}else{this.oPopup._$().css('left',i);}this.oDropPosition={top:t,left:i,right:r};e.cancelBubble=true;return false;};d.prototype.onmouseup=function(e){if(!this.sDragMode){return;}if(this.oDropPosition){this.addStyleClass("sapUiMsgBarMoved");}if(this.bToggleListBackAfterDrag){this.toggleList();}this.bToggleListBackAfterDrag=null;var D=q(window.document);D.unbind("mousemove",q.proxy(this.handleMove,this));if(window.parent){q(window.parent.document).unbind("mousemove",q.proxy(this.handleMove,this));}D.unbind("selectstart",q.proxy(this.ondragstart,this));this.sDragMode=null;this.checkForToast();};d.prototype.onclick=function(e){var s=e.target;var S=q(s);if(S.css('cursor')!="pointer"){return;}if(S.hasClass("sapUiMsgBarToggle")){this.toggleList();}else if(S.hasClass("sapUiMsgBarHome")){this.backHome();}else{L.debug("Warning: MessageBar unsupported click on "+S.attr('className'));}};d.prototype.checkForToast=function(){if(this.maxToastsReached){return;}if(this.aToasts==null||this.aToasts.length==0){return;}var m=this.getMaxToasted();if(m==0){return;}if(this.sDragMode){return;}var n=null;var e="";if(this.aToasts.length>this.getMaxToasted()){this.aToasts=[];this.maxToastsReached=true;e=this.getId()+"__arrowImg";}else{if(!this.oToast.isIdle()){return;}n=this.aToasts.splice(0,1)[0];e=this.getId()+"__"+n.getType()+"Img";}this.oToast.toast(n,e);};d.prototype.addToasts=function(m){for(var i=0,e=m.length;i<e;i++){var n=m[i];var f=false;for(var j=this.aToasts.length;j>=0;j--){if(n==this.aToasts[j]){f=true;break;}}if(!f){this.aToasts.push(n);}}};d.prototype.deleteToast=function(i){if(!this.aToasts){return;}for(var j=0,e=this.aToasts.length;j<e;j++){if(this.aToasts[j].getId()==i){this.aToasts.splice(j,1);return;}}};d.prototype.deleteOneMessage=function(i){if(!i){return;}for(var j=0,e=this.aErrors.length;j<e;j++){if(this.aErrors[j].getId()==i){this.aErrors[j].closeDetails();this.aErrors.splice(j,1);return;}}for(var j=0,e=this.aWarnings.length;j<e;j++){if(this.aWarnings[j].getId()==i){this.aWarnings[j].closeDetails();this.aWarnings.splice(j,1);return;}}for(var j=0,e=this.aSuccesses.length;j<e;j++){if(this.aSuccesses[j].getId()==i){this.aSuccesses[j].closeDetails();this.aSuccesses.splice(j,1);return;}}};d.prototype.getSnapPoint=function(){if(!this.snapPoint){this.snapPoint=this.getAnchorSnapPoint();if(sap.ui.getCore().getConfiguration().getRTL()){this.snapPoint=this.snapPoint.replace("begin","right").replace("end","left");}else{this.snapPoint=this.snapPoint.replace("begin","left").replace("end","right");}}return this.snapPoint;};d.prototype.open=function(){var e=0;var s=this.getSnapPoint();var f=null;var g=this.getAnchorID();if(g){f=document.getElementById(g);}if(!f){f=document.body;}this.oPopup.open(e,s,s,f,"0 0");if(this.oDropPosition){this.oPopup._$().css('top',this.oDropPosition.top);if(s.indexOf("right")!=-1){this.oPopup._$().css('right',this.oDropPosition.right);}else{this.oPopup._$().css('left',this.oDropPosition.left);}}if(this.hasStyleClass("sapUiMsgBarOpen")){this.oList.setVisible(true);}};d.prototype.close=function(){if(this.oList&&this.oList.getVisible()){this.oList.setVisible(false);}var e=0;this.oPopup.close(e);this.maxToastsReached=false;};d.prototype.updateCountersAndVisibility=function(){if(!this.getProperty("visible")){return;}var i=this.getId();var o=document.getElementById(i+"__ErrorCount");if(!o){this.open();o=document.getElementById(i+"__ErrorCount");}var e=this.aErrors.length;var f=o.innerHTML;var n="("+e+")";var I=null;var j=null;if(n!=f){o.innerHTML=n;if(n=="(0)"){I=q(document.getElementById(i+"__ErrorImg"));j=q(document.getElementById(i+"__ErrorCount"));I.addClass("sapUiMsgBarZeroCount");j.addClass("sapUiMsgBarZeroCount");}else if(f=="(0)"){I=q(document.getElementById(i+"__ErrorImg"));j=q(document.getElementById(i+"__ErrorCount"));I.removeClass("sapUiMsgBarZeroCount");j.removeClass("sapUiMsgBarZeroCount");}}o=document.getElementById(i+"__WarningCount");e=this.aWarnings.length;f=o.innerHTML;n="("+e+")";I=null;j=null;if(n!=f){o.innerHTML=n;if(n=="(0)"){I=q(document.getElementById(i+"__WarningImg"));j=q(document.getElementById(i+"__WarningCount"));I.addClass("sapUiMsgBarZeroCount");j.addClass("sapUiMsgBarZeroCount");}else if(f=="(0)"){I=q(document.getElementById(i+"__WarningImg"));j=q(document.getElementById(i+"__WarningCount"));I.removeClass("sapUiMsgBarZeroCount");j.removeClass("sapUiMsgBarZeroCount");}}o=document.getElementById(i+"__SuccessCount");e=this.aSuccesses.length;f=o.innerHTML;n="("+e+")";I=null;j=null;if(n!=f){o.innerHTML=n;if(n=="(0)"){I=q(document.getElementById(i+"__SuccessImg"));j=q(document.getElementById(i+"__SuccessCount"));I.addClass("sapUiMsgBarZeroCount");j.addClass("sapUiMsgBarZeroCount");}else if(f=="(0)"){I=q(document.getElementById(i+"__SuccessImg"));j=q(document.getElementById(i+"__SuccessCount"));I.removeClass("sapUiMsgBarZeroCount");j.removeClass("sapUiMsgBarZeroCount");}}if(this.aErrors.length==0&&this.aWarnings.length==0&&this.aSuccesses.length==0){this.close();return;}else{this.open();}if(this.oList&&this.oList.getVisible()){this.oList.setMessages(this.aSuccesses.concat(this.aWarnings).concat(this.aErrors));}this.checkForToast();};d.prototype.toggleList=function(){if(!this.oList){var e=this.getId()+"__List";this.oList=new a(e,{anchorId:this.getId(),maxListed:this.getMaxListed()});}var v=this.oList.getVisible();if(!v){this.oList.setMessages(this.aSuccesses.concat(this.aWarnings).concat(this.aErrors));this.addStyleClass("sapUiMsgBarOpen");}else{this.removeStyleClass("sapUiMsgBarOpen");}this.oList.setVisible(!v);};d.prototype.backHome=function(){var p=this.oPopup._$();if(this.oList&&this.oList.getVisible()){this.toggleList();var t=this;if(this.snapPoint.indexOf("right")!=-1){p.animate({right:this.oHomePosition.right+"px",top:this.oHomePosition.top+"px"},200,function(){t.toggleList();});}else{p.animate({left:this.oHomePosition.left+"px",top:this.oHomePosition.top+"px"},200,function(){t.toggleList();});}}else{if(this.snapPoint.indexOf("right")!=-1){p.animate({right:this.oHomePosition.right+"px",top:this.oHomePosition.top+"px"},200);}else{p.animate({left:this.oHomePosition.left+"px",top:this.oHomePosition.top+"px"},200);}}this.oDropPosition=null;this.removeStyleClass("sapUiMsgBarMoved");};d.prototype.addMessages=function(m){if(!m){return;}for(var i=0,e=m.length;i<e;i++){this.deleteOneMessage(m[i].getId());switch(m[i].getType()){case c.Error:this.aErrors.push(m[i]);break;case c.Warning:this.aWarnings.push(m[i]);break;case c.Success:this.aSuccesses.push(m[i]);break;default:L.debug("ERROR: MessageBar supplied messageType="+m[i].getType());}}this.addToasts(m);this.updateCountersAndVisibility();return this;};d.prototype.deleteMessages=function(I){if(!I){return;}for(var i=0,e=I.length;i<e;i++){this.deleteOneMessage(I[i]);this.deleteToast(I[i]);}this.updateCountersAndVisibility();return this;};d.prototype.deleteAllMessages=function(){for(var j=this.aErrors.length-1;j>=0;j--){this.aErrors[j].closeDetails();}for(var j=this.aWarnings.length-1;j>=0;j--){this.aWarnings[j].closeDetails();}for(var j=this.aSuccesses.length-1;j>=0;j--){this.aSuccesses[j].closeDetails();}this.aErrors=[];this.aWarnings=[];this.aSuccesses=[];this.aToasts=[];this.updateCountersAndVisibility();return this;};d.prototype.setVisible=function(v){this.setProperty("visible",v);if(v){this.updateCountersAndVisibility();}else{this.close();}return this;};return d;});
