/*!
 * OpenUI5
 * (c) Copyright 2009-2019 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(['sap/ui/thirdparty/jquery','./library','sap/ui/core/Control','./RowRepeaterRenderer','./Toolbar','./Paginator','./Button','sap/ui/model/FilterType'],function(q,a,C,R,T,P,B,F){"use strict";var b=a.PaginatorEvent;var c=a.ToolbarDesign;var d=a.RowRepeaterDesign;var e=C.extend("sap.ui.commons.RowRepeater",{metadata:{library:"sap.ui.commons",properties:{numberOfRows:{type:"int",group:"Dimension",defaultValue:5},currentPage:{type:"int",group:"Data",defaultValue:1},showMoreSteps:{type:"int",group:"Behavior",defaultValue:0},fixedRowHeight:{type:"sap.ui.core.CSSSize",group:"Appearance",defaultValue:''},design:{type:"sap.ui.commons.RowRepeaterDesign",group:"Appearance",defaultValue:d.Standard},threshold:{type:"int",defaultValue:null}},defaultAggregation:"rows",aggregations:{rows:{type:"sap.ui.core.Control",multiple:true,singularName:"row",bindable:"bindable"},title:{type:"sap.ui.core.Title",multiple:false},filters:{type:"sap.ui.commons.RowRepeaterFilter",multiple:true,singularName:"filter"},sorters:{type:"sap.ui.commons.RowRepeaterSorter",multiple:true,singularName:"sorter"},noData:{type:"sap.ui.core.Control",multiple:false},filterToolbar:{type:"sap.ui.commons.Toolbar",multiple:false,visibility:"hidden"},sorterToolbar:{type:"sap.ui.commons.Toolbar",multiple:false,visibility:"hidden"},headerShowMoreButton:{type:"sap.ui.commons.Button",multiple:false,visibility:"hidden"},footerShowMoreButton:{type:"sap.ui.commons.Button",multiple:false,visibility:"hidden"},footerPager:{type:"sap.ui.commons.Paginator",multiple:false,visibility:"hidden"}},events:{filter:{parameters:{filterId:{type:"string"}}},sort:{parameters:{sorterId:{type:"string"}}},page:{parameters:{currentPage:{type:"int"},previousPage:{type:"int"}}},resize:{parameters:{numberOfRows:{type:"int"},previousNumberOfRows:{type:"int"}}}}}});e.prototype.bPagingMode=true;e.prototype.bShowAnimation=true;e.SHOW_MORE="show_more";e.RESIZE="resize";e.FIRST_PAGE="first_page";e.LAST_PAGE="last_page";e.PREVIOUS_PAGE="previous_page";e.NEXT_PAGE="next_page";e.GOTO_PAGE="goto_page";e.prototype.init=function(){var i=this.getId();this.oResourceBundle=sap.ui.getCore().getLibraryResourceBundle("sap.ui.commons");this.sCurrentAnimation=null;this.aAnimationQueue=[];this.aRemoveBuffer=[];this.iPreviousPage=this.getCurrentPage();this.iPreviousNumberOfRows=this.getNumberOfRows();this.setAggregation("filterToolbar",new T(i+"-ftb",{standalone:false,design:c.Transparent}));this.setAggregation("sorterToolbar",new T(i+"-stb",{standalone:false}));var p=new P(i+"-fp",{page:[this.paging,this]});this.setAggregation("footerPager",p);var s=this.oResourceBundle.getText("SHOW_MORE");this.setAggregation("headerShowMoreButton",new B(i+"-hsm",{text:s,tooltip:s,press:[this.triggerShowMore,this]}));this.setAggregation("footerShowMoreButton",new B(i+"-fsm",{text:s,tooltip:s,press:[this.triggerShowMore,this]}));this._bSecondPage=false;};e.prototype.triggerShowMore=function(){if(this.getShowMoreSteps()<=0){return this;}var s=this.getShowMoreSteps();var n=this.getNumberOfRows();var N=Math.min(this._getRowCount(),n+s);if(n===N){return this;}if(this.getDomRef()&&this.bShowAnimation){if(this.sCurrentAnimation!==null){this.aAnimationQueue.push({name:e.SHOW_MORE,animationFunction:this.triggerShowMore,args:arguments});return this;}else{this.sCurrentAnimation=e.SHOW_MORE;}this.iPreviousNumberOfRows=n;this.setProperty("numberOfRows",N,true);this.startResizeAnimation();}else{this.setNumberOfRows(N);}this.fireResize({numberOfRows:N,previousNumberOfRows:n});return this;};e.prototype.resize=function(n){if(this.getShowMoreSteps()<=0){return this;}var N=this.getNumberOfRows();if(n<=0||n>this._getRowCount()||n===N){return this;}if(this.getDomRef()&&this.bShowAnimation){if(this.sCurrentAnimation!==null){this.aAnimationQueue.push({name:e.RESIZE,animationFunction:this.resize,args:arguments});return this;}else{this.sCurrentAnimation=e.RESIZE;}this.iPreviousNumberOfRows=N;this.setProperty("numberOfRows",n,true);this.startResizeAnimation();}else{this.setNumberOfRows(n);}this.fireResize({numberOfRows:n,previousNumberOfRows:N});return this;};e.prototype.applyFilter=function(i){var f=this.getFilters();var l=this.getBinding("rows");var o,n;if(f.length===0||l===null){return this;}for(n=0;n<f.length;n++){if(f[n].getId()===i){o=f[n];break;}}if(o){l.filter(o.getFilters(),F.Control);this.fireFilter({filterId:i});this.firstPage();}return this;};e.prototype.triggerSort=function(i){var s=this.getSorters();var l=this.getBinding("rows");var S,n;if(s.length===0||l===null){return this;}for(n=0;n<s.length;n++){if(s[n].getId()===i){S=s[n];break;}}if(S){l.sort(S.getSorter());this.fireSort({sorterId:i});this.firstPage();}return this;};e.prototype.firstPage=function(){if(this.getShowMoreSteps()>0){return this;}var i=this.getCurrentPage();if(i===1){return this;}this.getAggregation("footerPager").setCurrentPage(1);if(this.getDomRef()&&this.bShowAnimation){if(this.sCurrentAnimation!==null){this.aAnimationQueue.push({name:e.FIRST_PAGE,animationFunction:this.firstPage,args:arguments});return this;}else{this.sCurrentAnimation=e.FIRST_PAGE;}this.iPreviousPage=i;this.setProperty("currentPage",1,true);this.startPagingAnimation();}else{this.setCurrentPage(1);}this.firePage({currentPage:1,previousPage:i});return this;};e.prototype.lastPage=function(){if(this.getShowMoreSteps()>0){return this;}var i=this.getCurrentPage();var l=Math.ceil(this._getRowCount()/this.getNumberOfRows());if(i===l){return this;}this.getAggregation("footerPager").setCurrentPage(l);if(this.getDomRef()&&this.bShowAnimation){if(this.sCurrentAnimation!==null){this.aAnimationQueue.push({name:e.LAST_PAGE,animationFunction:this.lastPage,args:arguments});return this;}else{this.sCurrentAnimation=e.LAST_PAGE;}this.iPreviousPage=i;this.setProperty("currentPage",l,true);this.startPagingAnimation();}else{this.setCurrentPage(l);}this.firePage({currentPage:l,previousPage:i});return this;};e.prototype.previousPage=function(){if(this.getShowMoreSteps()>0){return this;}var i=this.getCurrentPage();if(i<=1){return this;}this.getAggregation("footerPager").setCurrentPage(i-1);if(this.getDomRef()&&this.bShowAnimation){if(this.sCurrentAnimation!==null){this.aAnimationQueue.push({name:e.PREVIOUS_PAGE,animationFunction:this.previousPage,args:arguments});return this;}else{this.sCurrentAnimation=e.PREVIOUS_PAGE;}this.iPreviousPage=i;this.setProperty("currentPage",i-1,true);this.startPagingAnimation();}else{this.setCurrentPage(i-1);}this.firePage({currentPage:i-1,previousPage:i});return this;};e.prototype.nextPage=function(){if(this.getShowMoreSteps()>0){return this;}var i=this.getCurrentPage();var l=Math.ceil(this._getRowCount()/this.getNumberOfRows());if(i>=l){return this;}this.getAggregation("footerPager").setCurrentPage(i+1);if(this.getDomRef()&&this.bShowAnimation){if(this.sCurrentAnimation!==null){this.aAnimationQueue.push({name:e.NEXT_PAGE,animationFunction:this.nextPage,args:arguments});return this;}else{this.sCurrentAnimation=e.NEXT_PAGE;}this.iPreviousPage=i;this.setProperty("currentPage",i+1,true);this.startPagingAnimation();}else{this.setCurrentPage(i+1);}this.firePage({currentPage:i+1,previousPage:i});return this;};e.prototype.gotoPage=function(p){if(this.getShowMoreSteps()>0){return this;}var i=this.getCurrentPage();var l=Math.ceil(this._getRowCount()/this.getNumberOfRows());if(p<1||p>l||i===p){return this;}this.getAggregation("footerPager").setCurrentPage(p);if(this.getDomRef()&&this.bShowAnimation){if(this.sCurrentAnimation!==null){this.aAnimationQueue.push({name:e.GOTO_PAGE,animationFunction:this.gotoPage,args:arguments});return this;}else{this.sCurrentAnimation=e.GOTO_PAGE;}this.iPreviousPage=i;this.setProperty("currentPage",p,true);this.startPagingAnimation();}else{this.setCurrentPage(p);}this.firePage({currentPage:p,previousPage:i});return this;};e.prototype.setNumberOfRows=function(n){this.setProperty("numberOfRows",n);if(this.getBinding("rows")){this.updateRows(true);}this.updateChildControls();return this;};e.prototype.setCurrentPage=function(i){if(this.getCurrentPage()!=i){this.setProperty("currentPage",i);if(this.getBinding("rows")){this.updateRows(true);}this.updateChildControls();}return this;};e.prototype.setShowMoreSteps=function(s){var n=s>0?false:true,o=this.getBinding("rows");if(n!==this.bPagingMode){this.bPagingMode=n;this.setCurrentPage(1);}this.setProperty("showMoreSteps",s);if(o){this._bSecondPage=false;this.updateRows(true);}return this;};e.prototype.insertRow=function(r,i){this.insertAggregation("rows",r,i);this.updateChildControls();return this;};e.prototype.addRow=function(r){this.addAggregation("rows",r);this.updateChildControls();return this;};e.prototype.removeRow=function(E){this.removeAggregation("rows",E);this.updateChildControls();return this;};e.prototype.removeAllRows=function(){this.removeAllAggregation("rows");this.updateChildControls();return this;};e.prototype.destroyRows=function(){this.destroyAggregation("rows");this.updateChildControls();return this;};e.prototype.setThreshhold=function(t){this.setProperty("threshold",t,true);return this;};e.prototype.insertFilter=function(f,i){var t=this.getAggregation("filterToolbar");var s=f.getId();var o=new B({text:f.getText(),icon:f.getIcon(),tooltip:f.getTooltip(),press:[function(){this.applyFilter(s);},this]});t.insertItem(o,i);this.insertAggregation("filters",f,i);return this;};e.prototype.addFilter=function(f){var t=this.getAggregation("filterToolbar");var s=f.getId();var o=new B({text:f.getText(),icon:f.getIcon(),tooltip:f.getTooltip(),press:[function(){this.applyFilter(s);},this]});t.addItem(o);this.addAggregation("filters",f);return this;};e.prototype.removeFilter=function(E){var t=this.getAggregation("filterToolbar");t.removeItem(E);return this.removeAggregation("filters",E);};e.prototype.removeAllFilters=function(){var t=this.getAggregation("filterToolbar");t.removeAllItems();return this.removeAllAggregation("filters");};e.prototype.destroyFilters=function(){var t=this.getAggregation("filterToolbar");t.removeAllItems();this.destroyAggregation("filters");return this;};e.prototype.insertSorter=function(s,i){var t=this.getAggregation("sorterToolbar");var S=s.getId();var o=new B({text:s.getText(),icon:s.getIcon(),tooltip:s.getTooltip(),press:[function(){this.triggerSort(S);},this]});t.insertItem(o,i);this.insertAggregation("sorters",s,i);return this;};e.prototype.addSorter=function(s){var t=this.getAggregation("sorterToolbar");var S=s.getId();var o=new B({text:s.getText(),icon:s.getIcon(),tooltip:s.getTooltip(),press:[function(){this.triggerSort(S);},this]});t.addItem(o);this.addAggregation("sorters",s);return this;};e.prototype.removeSorter=function(E){var t=this.getAggregation("sorterToolbar");t.removeItem(E);return this.removeAggregation("sorters",E);};e.prototype.removeAllSorters=function(){var t=this.getAggregation("sorterToolbar");t.removeAllItems();return this.removeAllAggregation("sorters");};e.prototype.destroySorters=function(){var t=this.getAggregation("sorterToolbar");t.removeAllItems();this.destroyAggregation("sorters");return this;};e.prototype.startPagingAnimation=function(){var o=sap.ui.getCore(),r=o.getRenderManager(),i=this.getId(),p=this.iPreviousPage,f=this.getCurrentPage(),N=this.getNumberOfRows(),s=(f-1)*N,g=this.getRows(),h=this._getRowCount()>N*f?N:this._getRowCount()-N*(f-1),n,j=this.getBinding("rows");var D,J=this.$("page_"+p),k=this.getDomRef("body"),l=q(k);l.css("height",l.outerHeight());var m;if(sap.ui.getCore()&&sap.ui.getCore().getConfiguration()&&sap.ui.getCore().getConfiguration().getRTL()){m=(f<p)?"left":"right";}else{m=(f<p)?"right":"left";}if(j){this._bSecondPage=!this._bSecondPage;this.updateRows(true);g=this.getRows();s=(this._bSecondPage?1:0)*N;}var S="\"top:-"+J.outerHeight(true)+"px;"+m+":"+J.outerWidth(true)+"px;\"";q("<ul id=\""+i+"-page_"+f+"\" class=\"sapUiRrPage\" style="+S+"/>").appendTo(k);var t=k.lastChild;var u=q(t);for(n=s;n<s+h;n++){q("<li id=\""+i+"-row_"+n+"\" class=\"sapUiRrRow\"/>").appendTo(t);D=t.lastChild;r.render(g[n],D);}if(m==="right"){J.animate({right:-J.outerWidth(true)},"slow");u.animate({right:0},"slow");}else{J.animate({left:-J.outerWidth(true)},"slow");u.animate({left:0},"slow");}l.animate({height:u.outerHeight(true)},"slow",q.proxy(this.endPagingAnimation,this));};e.prototype.endPagingAnimation=function(){var D=this.getDomRef("body");var o=this.getDomRef("page_"+this.iPreviousPage);var f=this.getDomRef("page_"+this.getCurrentPage());var j=q(f);q(D).css("height","");q(o).remove();var s;if(sap.ui.getCore()&&sap.ui.getCore().getConfiguration()&&sap.ui.getCore().getConfiguration().getRTL()){s=(this.getCurrentPage()<this.iPreviousPage)?"left":"right";}else{s=(this.getCurrentPage()<this.iPreviousPage)?"right":"left";}j.css("top","");j.css(s,"");this.sCurrentAnimation=null;this.nextQueuedAnimation();};e.prototype.startResizeAnimation=function(){var r=sap.ui.getCore().getRenderManager(),N=this.getNumberOfRows(),o=this.iPreviousNumberOfRows,i=this.getId(),s=0,f,g=this.getBinding("rows");var D,h=this.getDomRef("body"),j=q(h),k=this.getDomRef("page_"+this.getCurrentPage());j.css("height",j.outerHeight());if(g){this.updateRows(true);}f=this.getRows();if(N>o){for(var n=o;n<N;n++){q("<li id=\""+i+"-row_"+n+"\" class=\"sapUiRrRow\"/>").appendTo(k);D=k.lastChild;r.render(f[n],D);}}else{for(var n=N;n<o;n++){D=this.getDomRef("row_"+n);s-=q(D).outerHeight(true);this.aRemoveBuffer.push(D);}}j.animate({height:q(k).outerHeight(true)+s},"slow",q.proxy(this.endResizeAnimation,this));};e.prototype.endResizeAnimation=function(){var D=this.getDomRef("body");while(this.aRemoveBuffer.length>0){q(this.aRemoveBuffer.pop()).remove();}q(D).css("height","");this.sCurrentAnimation=null;this.nextQueuedAnimation();};e.prototype.nextQueuedAnimation=function(){var n,l;var i=1;var Q=this.aAnimationQueue;var p,N;if(Q.length>0){n=Q.shift();}if(n&&Q.length>0){while(Q[0]&&Q[0].name===n.name){i++;l=Q.shift();}if(i>0){switch(n.name){case e.SHOW_MORE:N=Math.min(this._getRowCount(),this.getNumberOfRows()+this.getShowMoreSteps()*i);n={name:e.RESIZE,animationFunction:this.resize,args:[N]};break;case e.RESIZE:n=l;break;case e.FIRST_PAGE:break;case e.LAST_PAGE:break;case e.PREVIOUS_PAGE:p=Math.max(1,this.getCurrentPage()-i);n={name:e.GOTO_PAGE,animationFunction:this.gotoPage,args:[p]};break;case e.NEXT_PAGE:p=Math.min(Math.ceil(this._getRowCount()/this.getNumberOfRows()),this.getCurrentPage()+i);n={name:e.GOTO_PAGE,animationFunction:this.gotoPage,args:[p]};break;case e.GOTO_PAGE:n=l;break;}}}if(n){n.animationFunction.apply(this,n.args);}};e.prototype.paging=function(E){switch(E.getParameter("type")){case b.First:this.firstPage();break;case b.Last:this.lastPage();break;case b.Previous:this.previousPage();break;case b.Next:this.nextPage();break;case b.Goto:this.gotoPage(E.getParameter("targetPage"));break;}};e.prototype.updateChildControls=function(){var s,p;var S;if(this.bPagingMode){var i=this.getCurrentPage();var l=Math.ceil(this._getRowCount()/this.getNumberOfRows());if(this._getRowCount()==0){l=1;}p=this.getAggregation("footerPager");if(p){p.setCurrentPage(i);p.setNumberOfPages(l);}}else{S=this._getRowCount()>this.getNumberOfRows();s=this.getAggregation("headerShowMoreButton");if(s){s.setEnabled(S);}s=this.getAggregation("footerShowMoreButton");if(s){s.setEnabled(S);}}};e.prototype.isBound=function(n){return C.prototype.isBound.call(this,n||"rows");};e.prototype._getRowCount=function(){var o=this.getBinding("rows");if(o){return o.getLength();}else{return this.getRows().length;}};e.prototype.unbindAggregation=function(n){C.prototype.unbindAggregation.apply(this,arguments);if(n==="rows"){this.destroyRows();}return this;};e.prototype.refreshRows=function(){var o=this.getBindingInfo("rows"),f=o.binding,r=this._getRowCount(),n=this.getNumberOfRows(),N=Math.min(r,n),t=this.getThreshold();this.setProperty("currentPage",1,true);f.getContexts(0,N,t);};e.prototype.updateRows=function(v){var o=this.getBindingInfo("rows"),f=o.factory,g=o.binding,s=this.getShowMoreSteps(),S=s>0,h=this.getCurrentPage(),r=this._getRowCount(),n=this.getNumberOfRows(),N=Math.min(r,n),L=Math.ceil(r/n)||1;if(h>L){h=L;this.setProperty("currentPage",h);this._bSecondPage=false;}var j=S?0:(h-1)*N,k=(this._bSecondPage?1:0)*N,t=this.getThreshold(),m=g?g.getContexts(j,N,t):[];if(v!==true){this._bSecondPage=false;this.destroyRows();for(var i=0,l=N;i<l;i++){var I=this.getId()+"-"+i,p=f(I,m[i]);p.setBindingContext(m[i],o.model);this.addRow(p);}}else{this._bSuppressInvalidate=true;for(var i=0,l=N;i<l;i++){var u=k+i;var w=this.getRows()[u];if(!S){if(w){this.removeAggregation("rows",w,true);w.destroy();}w=undefined;}if(!w){var I=this.getId()+"-"+u;w=f(I,m[i]);w.setBindingContext(m[i],o.model);this.insertAggregation("rows",w,u,true);}else{w.setBindingContext(m[i],o.model);}}this._bSuppressInvalidate=false;}this.updateChildControls();};e.prototype.invalidate=function(o){if(this._bSuppressInvalidate){return;}C.prototype.invalidate.apply(this,arguments);};return e;});
