/*!
 * OpenUI5
 * (c) Copyright 2009-2019 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(['sap/base/assert','../Device','./Control','./IconPool','./InvisibleText','./library',"./IconRenderer","sap/ui/events/KeyCodes","sap/ui/thirdparty/jquery","sap/base/Log"],function(a,D,C,I,b,l,c,K,q,L){"use strict";var d=l.IconColor;var e=l.CSSColor;var i=function(v){if(v!=null&&v!==""&&!e.isValid(v)&&!(v in d)){L.error("\""+v+"\" is not of type sap.ui.core.CSSColor nor of type sap.ui.core.IconColor.");return false;}else{return true;}};var f=C.extend("sap.ui.core.Icon",{metadata:{interfaces:["sap.ui.core.IFormContent"],library:"sap.ui.core",designtime:"sap/ui/core/designtime/Icon.designtime",properties:{src:{type:"sap.ui.core.URI",group:"Data",defaultValue:null},size:{type:"sap.ui.core.CSSSize",group:"Dimension",defaultValue:null},color:{type:"string",group:"Appearance",defaultValue:null},hoverColor:{type:"string",group:"Appearance",defaultValue:null},activeColor:{type:"string",group:"Appearance",defaultValue:null},width:{type:"sap.ui.core.CSSSize",group:"Dimension",defaultValue:null},height:{type:"sap.ui.core.CSSSize",group:"Dimension",defaultValue:null},backgroundColor:{type:"string",group:"Appearance",defaultValue:null},hoverBackgroundColor:{type:"string",group:"Appearance",defaultValue:null},activeBackgroundColor:{type:"string",group:"Appearance",defaultValue:null},decorative:{type:"boolean",group:"Accessibility",defaultValue:true},useIconTooltip:{type:"boolean",group:"Accessibility",defaultValue:true},alt:{type:"string",group:"Accessibility",defaultValue:null},noTabStop:{type:"boolean",group:"Accessibility",defaultValue:false}},aggregations:{_invisibleText:{type:"sap.ui.core.InvisibleText",multiple:false,visibility:"hidden"}},associations:{ariaLabelledBy:{type:"sap.ui.core.Control",multiple:true,singularName:"ariaLabelledBy"}},events:{press:{}}}});f.prototype[D.support.touch?"ontouchstart":"onmousedown"]=function(E){if(this.hasListeners("press")){E.setMarked();}var A=this.getActiveColor(),s=this.getActiveBackgroundColor(),$;if(A||s){if(!E.targetTouches||(E.targetTouches&&E.targetTouches.length===1)){$=this.$();$.addClass("sapUiIconActive");if(A){this._addColorClass(A,"color");}if(s){this._addColorClass(s,"background-color");}}}};f.prototype[D.support.touch?"ontouchend":"onmouseup"]=function(E){if(!E.targetTouches||(E.targetTouches&&E.targetTouches.length===0)){this.$().removeClass("sapUiIconActive");this._restoreColors(D.system.desktop?"hover":undefined);}};f.prototype.onmouseover=function(){var h=this.getHoverColor(),H=this.getHoverBackgroundColor();if(h){this._addColorClass(h,"color");}if(H){this._addColorClass(H,"background-color");}};f.prototype.onmouseout=function(){this._restoreColors();};f.prototype[D.support.touch&&!D.system.desktop?"ontap":"onclick"]=function(E){if(this.hasListeners("press")){E.setMarked();}this.firePress({});};f.prototype.onkeydown=function(E){if(E.which===K.SPACE||E.which===K.ENTER){E.preventDefault();var $=this.$(),A=this.getActiveColor(),s=this.getActiveBackgroundColor();$.addClass("sapUiIconActive");if(A){this._addColorClass(A,"color");}if(s){this._addColorClass(s,"background-color");}}};f.prototype.onkeyup=function(E){if(E.which===K.SPACE||E.which===K.ENTER){this.$().removeClass("sapUiIconActive");this._restoreColors();this.firePress({});}};f.prototype._restoreColors=function(m){var s,B;if(m==="hover"){s=this.getHoverColor();B=this.getHoverBackgroundColor();}s=s||this.getColor();B=B||this.getBackgroundColor();this._addColorClass(s||"","color");this._addColorClass(B||"","background-color");};f.prototype.setSrc=function(s){a(s==null||I.isIconURI(s),this+": Property 'src' (value: '"+s+"') should be a valid Icon URI (sap-icon://...)");var v=I.getIconInfo(s,undefined,"mixed"),$=this.$(),g,t,u,h,o;this.setProperty("src",s,!!v);if(v instanceof Promise){v.then(this.invalidate.bind(this));}else if(v&&$.length){$.css("font-family",v.fontFamily);$.attr("data-sap-ui-icon-content",v.content);$.toggleClass("sapUiIconMirrorInRTL",!v.suppressMirroring);t=this.getTooltip_AsString();h=this.getAriaLabelledBy();u=this.getUseIconTooltip();g=this._getIconLabel(v);if(t||(u&&v.text)){$.attr("title",t||v.text);}else{$.attr("title",null);}if(h.length===0){if(g){$.attr("aria-label",g);}else{$.attr("aria-label",null);}}else{o=this.getAggregation("_invisibleText");if(o){o.setText(g);}}}return this;};f.prototype.setWidth=function(w){this.setProperty("width",w,true);this.$().css("width",w);return this;};f.prototype.setHeight=function(h){this.setProperty("height",h,true);this.$().css({"height":h,"line-height":h});return this;};f.prototype.setSize=function(s){this.setProperty("size",s,true);this.$().css("font-size",s);return this;};f.prototype.setColor=function(s){if(i(s)){this.setProperty("color",s,true);this._addColorClass(s,"color");}return this;};f.prototype._addColorClass=function(s,g){var $=this.$(),t=this;var h="";if(g==="color"){h="sapUiIconColor";}else if(g==="background-color"){h="sapUiIconBGColor";}else{return;}q.each(d,function(p,P){t.removeStyleClass(h+P);});if(s in d){$.css(g,"");this.addStyleClass(h+s);}else{$.css(g,s);}};f.prototype.setActiveColor=function(s){if(i(s)){return this.setProperty("activeColor",s,true);}return this;};f.prototype.setHoverColor=function(s){if(i(s)){return this.setProperty("hoverColor",s,true);}return this;};f.prototype.setBackgroundColor=function(s){if(i(s)){this.setProperty("backgroundColor",s,true);this._addColorClass(s,"background-color");}return this;};f.prototype.setActiveBackgroundColor=function(s){if(i(s)){return this.setProperty("activeBackgroundColor",s,true);}return this;};f.prototype.setHoverBackgroundColor=function(s){if(i(s)){return this.setProperty("hoverBackgroundColor",s,true);}return this;};f.prototype.attachPress=function(){var m=Array.prototype.slice.apply(arguments);m.unshift("press");C.prototype.attachEvent.apply(this,m);if(this.hasListeners("press")){this.$().toggleClass("sapUiIconPointer",true).attr({role:"button",tabindex:this.getNoTabStop()?undefined:0});}return this;};f.prototype.detachPress=function(){var m=Array.prototype.slice.apply(arguments);m.unshift("press");C.prototype.detachEvent.apply(this,m);if(!this.hasListeners("press")){this.$().toggleClass("sapUiIconPointer",false).attr({role:this.getDecorative()?"presentation":"img"}).removeAttr("tabindex");}return this;};f.prototype._getOutputTitle=function(o){var t=this.getTooltip_AsString(),u=this.getUseIconTooltip();if(t||(u&&o&&o.text)){return t||o.text;}};f.prototype._getIconLabel=function(o){var A=this.getAlt(),t=this.getTooltip_AsString(),u=this.getUseIconTooltip(),s=A||t||(u&&o&&(o.text||o.name)),O=this._getOutputTitle(o);if(s&&s!==O){return s;}};f.prototype._createInvisibleText=function(t){var o=this.getAggregation("_invisibleText");if(!o){o=new b(this.getId()+"-label",{text:t});this.setAggregation("_invisibleText",o,true);}else{o.setProperty("text",t,true);}return o;};f.prototype._getAccessibilityAttributes=function(o){var g=this.getAriaLabelledBy(),A={},s=this._getIconLabel(o),h;if(this.getDecorative()){A.role="presentation";A.hidden="true";}else{if(this.hasListeners("press")){A.role="button";}else{A.role="img";}}if(g.length>0){if(s){h=this._createInvisibleText(s);g.push(h.getId());}A.labelledby=g.join(" ");}else if(s){A.label=s;}return A;};f.prototype.getAccessibilityInfo=function(){if(this.getDecorative()){return null;}var h=this.hasListeners("press");var o=I.getIconInfo(this.getSrc(),undefined,"sync");return{role:h?"button":"img",type:sap.ui.getCore().getLibraryResourceBundle("sap.ui.core").getText(h?"ACC_CTR_TYPE_BUTTON":"ACC_CTR_TYPE_IMAGE"),description:this.getAlt()||this.getTooltip_AsString()||(o?o.text||o.name:""),focusable:h};};return f;});
