/*!
 * OpenUI5
 * (c) Copyright 2009-2019 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(['sap/ui/thirdparty/jquery','sap/ui/base/Object','./CalendarType','./Locale','sap/base/assert','sap/base/util/LoaderExtensions'],function(q,B,C,L,a,b){"use strict";var c=B.extend("sap.ui.core.LocaleData",{constructor:function(o){this.oLocale=o;B.apply(this);this.mData=h(o);},_get:function(){return this._getDeep(this.mData,arguments);},_getMerged:function(){return this._get.apply(this,arguments);},_getDeep:function(o,p){var r=o;for(var i=0;i<p.length;i++){r=r[p[i]];if(r===undefined){break;}}return r;},getOrientation:function(){return this._get("orientation");},getLanguages:function(){return this._get("languages");},getScripts:function(){return this._get("scripts");},getTerritories:function(){return this._get("territories");},getMonths:function(w,s){a(w=="narrow"||w=="abbreviated"||w=="wide","sWidth must be narrow, abbreviated or wide");return this._get(g(s),"months","format",w);},getMonthsStandAlone:function(w,s){a(w=="narrow"||w=="abbreviated"||w=="wide","sWidth must be narrow, abbreviated or wide");return this._get(g(s),"months","stand-alone",w);},getDays:function(w,s){a(w=="narrow"||w=="abbreviated"||w=="wide"||w=="short","sWidth must be narrow, abbreviate, wide or short");return this._get(g(s),"days","format",w);},getDaysStandAlone:function(w,s){a(w=="narrow"||w=="abbreviated"||w=="wide"||w=="short","sWidth must be narrow, abbreviated, wide or short");return this._get(g(s),"days","stand-alone",w);},getQuarters:function(w,s){a(w=="narrow"||w=="abbreviated"||w=="wide","sWidth must be narrow, abbreviated or wide");return this._get(g(s),"quarters","format",w);},getQuartersStandAlone:function(w,s){a(w=="narrow"||w=="abbreviated"||w=="wide","sWidth must be narrow, abbreviated or wide");return this._get(g(s),"quarters","stand-alone",w);},getDayPeriods:function(w,s){a(w=="narrow"||w=="abbreviated"||w=="wide","sWidth must be narrow, abbreviated or wide");return this._get(g(s),"dayPeriods","format",w);},getDayPeriodsStandAlone:function(w,s){a(w=="narrow"||w=="abbreviated"||w=="wide","sWidth must be narrow, abbreviated or wide");return this._get(g(s),"dayPeriods","stand-alone",w);},getDatePattern:function(s,i){a(s=="short"||s=="medium"||s=="long"||s=="full","sStyle must be short, medium, long or full");return this._get(g(i),"dateFormats",s);},getTimePattern:function(s,i){a(s=="short"||s=="medium"||s=="long"||s=="full","sStyle must be short, medium, long or full");return this._get(g(i),"timeFormats",s);},getDateTimePattern:function(s,i){a(s=="short"||s=="medium"||s=="long"||s=="full","sStyle must be short, medium, long or full");return this._get(g(i),"dateTimeFormats",s);},getCombinedDateTimePattern:function(D,t,s){a(D=="short"||D=="medium"||D=="long"||D=="full","sStyle must be short, medium, long or full");a(t=="short"||t=="medium"||t=="long"||t=="full","sStyle must be short, medium, long or full");var i=this.getDateTimePattern(D,s),j=this.getDatePattern(D,s),T=this.getTimePattern(t,s);return i.replace("{0}",T).replace("{1}",j);},getCustomDateTimePattern:function(s,i){var A=this._get(g(i),"dateTimeFormats","availableFormats");return this._getFormatPattern(s,A,i);},getIntervalPattern:function(i,s){var I=this._get(g(s),"dateTimeFormats","intervalFormats"),j,n,D,o,p;if(i){j=i.split("-");n=j[0];D=j[1];o=I[n];if(o){p=o[D];if(p){return p;}}}return I.intervalFormatFallback;},getCombinedIntervalPattern:function(p,s){var i=this._get(g(s),"dateTimeFormats","intervalFormats"),F=i.intervalFormatFallback;return F.replace(/\{(0|1)\}/g,p);},getCustomIntervalPattern:function(s,G,i){var A=this._get(g(i),"dateTimeFormats","intervalFormats");return this._getFormatPattern(s,A,i,G);},_getFormatPattern:function(s,A,i,D){var p,P,I;if(!D){p=A[s];}else if(typeof D==="string"){if(D=="j"||D=="J"){D=this.getPreferredHourSymbol();}I=A[s];p=I&&I[D];}if(p){if(typeof p==="object"){P=Object.keys(p).map(function(K){return p[K];});}else{return p;}}if(!P){P=this._createFormatPattern(s,A,i,D);}if(P&&P.length===1){return P[0];}return P;},_createFormatPattern:function(s,A,j,D){var t=this._parseSkeletonFormat(s),p,o=this._findBestMatch(t,s,A),T,n,S,G,P,r,u,v,w=/^([GyYqQMLwWEecdD]+)([hHkKjJmszZvVOXx]+)$/,x,i;if(D){if(typeof D==="string"){v=d[D]?d[D].group:"";if(v){x=m[v].index>t[t.length-1].index;}u=D;}else{x=true;if(t[0].symbol==="y"&&o&&o.pattern.G){S=d["G"];G=m[S.group];t.splice(0,0,{symbol:"G",group:S.group,match:S.match,index:G.index,field:G.field,length:1});}for(i=t.length-1;i>=0;i--){T=t[i];if(D[T.group]){x=false;break;}}for(i=0;i<t.length;i++){T=t[i];if(D[T.group]){u=T.symbol;break;}}if((u=="h"||u=="K")&&D.DayPeriod){u="a";}}if(x){return[this.getCustomDateTimePattern(s,j)];}if(o&&o.missingTokens.length===0){P=o.pattern[u];if(P&&o.distance>0){P=this._expandFields(P,o.patternTokens,t);}}if(!P){n=this._get(g(j),"dateTimeFormats","availableFormats");if(w.test(s)&&"ahHkKjJms".indexOf(u)>=0){P=this._getMixedFormatPattern(s,n,j,D);}else{r=this._getFormatPattern(s,n,j);P=this.getCombinedIntervalPattern(r,j);}}p=[P];}else if(!o){P=s;p=[P];}else{if(typeof o.pattern==="string"){p=[o.pattern];}else if(typeof o.pattern==="object"){p=[];for(var K in o.pattern){P=o.pattern[K];p.push(P);}}if(o.distance>0){if(o.missingTokens.length>0){if(w.test(s)){p=[this._getMixedFormatPattern(s,A,j)];}else{p=this._expandFields(p,o.patternTokens,t);p=this._appendItems(p,o.missingTokens,j);}}else{p=this._expandFields(p,o.patternTokens,t);}}}if(s.indexOf("J")>=0){p.forEach(function(P,I){p[I]=P.replace(/ ?[abB](?=([^']*'[^']*')*[^']*)$/g,"");});}return p;},_parseSkeletonFormat:function(s){var t=[],T={index:-1},S,o,G;for(var i=0;i<s.length;i++){S=s.charAt(i);if(S=="j"||S=="J"){S=this.getPreferredHourSymbol();}if(S==T.symbol){T.length++;continue;}o=d[S];G=m[o.group];if(o.group=="Other"||G.diffOnly){throw new Error("Symbol '"+S+"' is not allowed in skeleton format '"+s+"'");}if(G.index<=T.index){throw new Error("Symbol '"+S+"' at wrong position or duplicate in skeleton format '"+s+"'");}T={symbol:S,group:o.group,match:o.match,index:G.index,field:G.field,length:1};t.push(T);}return t;},_findBestMatch:function(t,s,A){var T,j,o,n,p,D,r,F,u,v,w={distance:10000,firstDiffPos:-1};for(var x in A){if(x==="intervalFormatFallback"||x.indexOf("B")>-1){continue;}T=this._parseSkeletonFormat(x);D=0;j=[];r=true;if(t.length<T.length){continue;}p=0;F=t.length;for(var i=0;i<t.length;i++){o=t[i];n=T[p];if(F===t.length){F=i;}if(n){u=d[o.symbol];v=d[n.symbol];if(o.symbol===n.symbol){if(o.length===n.length){if(F===i){F=t.length;}}else{if(o.length<u.numericCeiling?n.length<v.numericCeiling:n.length>=v.numericCeiling){D+=Math.abs(o.length-n.length);}else{D+=5;}}p++;continue;}else{if(o.match==n.match){D+=Math.abs(o.length-n.length)+10;p++;continue;}}}j.push(o);D+=50-i;}if(p<T.length){r=false;}if(r&&(D<w.distance||(D===w.distance&&F>w.firstDiffPos))){w.distance=D;w.firstDiffPos=F;w.missingTokens=j;w.pattern=A[x];w.patternTokens=T;}}if(w.pattern){return w;}},_expandFields:function(p,P,t){var s=(typeof p==="string");var n;if(s){n=[p];}else{n=p;}var r=n.map(function(o){var G={},u={},R="",Q=false,i=0,S,v,w,N,x,y,z,A;t.forEach(function(T){G[T.group]=T;});P.forEach(function(T){u[T.group]=T;});while(i<o.length){A=o.charAt(i);if(Q){R+=A;if(A=="'"){Q=false;}}else{z=d[A];if(z&&G[z.group]&&u[z.group]){x=G[z.group];y=u[z.group];S=x.length;w=y.length;v=1;while(o.charAt(i+1)==A){i++;v++;}if(S===w||((S<z.numericCeiling)?(v>=z.numericCeiling):(v<z.numericCeiling))){N=v;}else{N=Math.max(v,S);}for(var j=0;j<N;j++){R+=A;}}else{R+=A;if(A=="'"){Q=true;}}}i++;}return R;});return s?r[0]:r;},_appendItems:function(p,j,s){var A=this._get(g(s),"dateTimeFormats","appendItems");p.forEach(function(P,I){var D,n,o;j.forEach(function(t){n=A[t.group];D="'"+this.getDisplayName(t.field)+"'";o="";for(var i=0;i<t.length;i++){o+=t.symbol;}p[I]=n.replace(/\{0\}/,P).replace(/\{1\}/,o).replace(/\{2\}/,D);}.bind(this));}.bind(this));return p;},_getMixedFormatPattern:function(s,A,i,D){var r=/^([GyYqQMLwWEecdD]+)([hHkKjJmszZvVOXx]+)$/,j=/MMMM|LLLL/,n=/MMM|LLL/,o=/E|e|c/,R,p,t,S,u,T,v,w;R=r.exec(s);p=R[1];t=R[2];u=this._getFormatPattern(p,A,i);if(D){T=this.getCustomIntervalPattern(t,D,i);}else{T=this._getFormatPattern(t,A,i);}if(j.test(p)){S=o.test(p)?"full":"long";}else if(n.test(p)){S="medium";}else{S="short";}v=this.getDateTimePattern(S,i);w=v.replace(/\{1\}/,u).replace(/\{0\}/,T);return w;},getNumberSymbol:function(t){a(t=="decimal"||t=="group"||t=="plusSign"||t=="minusSign"||t=="percentSign","sType must be decimal, group, plusSign, minusSign or percentSign");return this._get("symbols-latn-"+t);},getLenientNumberSymbols:function(t){a(t=="plusSign"||t=="minusSign","sType must be plusSign or minusSign");return this._get("lenient-scope-number")[t];},getDecimalPattern:function(){return this._get("decimalFormat").standard;},getCurrencyPattern:function(s){return this._get("currencyFormat")[s]||this._get("currencyFormat").standard;},getCurrencySpacing:function(p){return this._get("currencyFormat","currencySpacing",p==="after"?"afterCurrency":"beforeCurrency");},getPercentPattern:function(){return this._get("percentFormat").standard;},getMiscPattern:function(n){a(n=="approximately"||n=="atLeast"||n=="atMost"||n=="range","sName must be approximately, atLeast, atMost or range");return this._get("miscPattern")[n];},getMinimalDaysInFirstWeek:function(){return this._get("weekData-minDays");},getFirstDayOfWeek:function(){return this._get("weekData-firstDay");},getWeekendStart:function(){return this._get("weekData-weekendStart");},getWeekendEnd:function(){return this._get("weekData-weekendEnd");},getCustomCurrencyCodes:function(){var i=this._get("currency")||{},j={};Object.keys(i).forEach(function(s){j[s]=s;});return j;},getCurrencyDigits:function(s){var i=this._get("currency");if(i){if(i[s]&&i[s].hasOwnProperty("digits")){return i[s].digits;}else if(i["DEFAULT"]&&i["DEFAULT"].hasOwnProperty("digits")){return i["DEFAULT"].digits;}}var D=this._get("currencyDigits",s);if(D==null){D=this._get("currencyDigits","DEFAULT");if(D==null){D=2;}}return D;},getCurrencySymbol:function(s){var o=this.getCurrencySymbols();return(o&&o[s])||s;},getCurrencyCodeBySymbol:function(s){var o=this._get("currencySymbols"),i;for(i in o){if(o[i]===s){return i;}}return s;},getCurrencySymbols:function(){var i=this._get("currency"),j={},I;for(var s in i){I=i[s].isoCode;if(i[s].symbol){j[s]=i[s].symbol;}else if(I){j[s]=this._get("currencySymbols")[I];}}return Object.assign({},this._get("currencySymbols"),j);},getUnitDisplayName:function(u){var U=this.getUnitFormat(u);return(U&&U["displayName"])||"";},getRelativePatterns:function(s,S){if(S===undefined){S="wide";}a(S==="wide"||S==="short"||S==="narrow","sStyle is only allowed to be set with 'wide', 'short' or 'narrow'");var p=[],P=this.getPluralCategories(),o,t,v,i;if(!s){s=["year","month","week","day","hour","minute","second"];}s.forEach(function(j){o=this._get("dateFields",j+"-"+S);for(var E in o){if(E.indexOf("relative-type-")===0){v=parseInt(E.substr(14));p.push({scale:j,value:v,pattern:o[E]});}else if(E.indexOf("relativeTime-type-")==0){t=o[E];i=E.substr(18)==="past"?-1:1;P.forEach(function(K){p.push({scale:j,sign:i,pattern:t["relativeTimePattern-count-"+K]});});}}}.bind(this));return p;},getRelativePattern:function(s,D,F,S){var p,t,K,P;if(typeof F==="string"){S=F;F=undefined;}if(F===undefined){F=D>0;}if(S===undefined){S="wide";}a(S==="wide"||S==="short"||S==="narrow","sStyle is only allowed to be set with 'wide', 'short' or 'narrow'");K=s+"-"+S;if(D===0||D===-2||D===2){p=this._get("dateFields",K,"relative-type-"+D);}if(!p){t=this._get("dateFields",K,"relativeTime-type-"+(F?"future":"past"));P=this.getPluralCategory(Math.abs(D).toString());p=t["relativeTimePattern-count-"+P];}return p;},getRelativeSecond:function(D,s){return this.getRelativePattern("second",D,s);},getRelativeMinute:function(D,s){if(D==0){return null;}return this.getRelativePattern("minute",D,s);},getRelativeHour:function(D,s){if(D==0){return null;}return this.getRelativePattern("hour",D,s);},getRelativeDay:function(D,s){return this.getRelativePattern("day",D,s);},getRelativeWeek:function(D,s){return this.getRelativePattern("week",D,s);},getRelativeMonth:function(D,s){return this.getRelativePattern("month",D,s);},getDisplayName:function(t,s){a(t=="second"||t=="minute"||t=="hour"||t=="zone"||t=="day"||t=="weekday"||t=="week"||t=="month"||t=="quarter"||t=="year"||t=="era","sType must be second, minute, hour, zone, day, weekday, week, month, quarter, year, era");if(s===undefined){s="wide";}a(s==="wide"||s==="short"||s==="narrow","sStyle is only allowed to be set with 'wide', 'short' or 'narrow'");var S=["era","weekday","zone"],K=S.indexOf(t)===-1?t+"-"+s:t;return this._get("dateFields",K,"displayName");},getRelativeYear:function(D,s){return this.getRelativePattern("year",D,s);},getDecimalFormat:function(s,n,p){var F;var o;switch(s){case"long":o=this._get("decimalFormat-long");break;default:o=this._get("decimalFormat-short");break;}if(o){var N=n+"-"+p;F=o[N];if(!F){N=n+"-other";F=o[N];}}return F;},getCurrencyFormat:function(s,n,p){var F;var o;switch(s){default:o=this._get("currencyFormat-short");break;}if(o){var N=n+"-"+p;F=o[N];if(!F){N=n+"-other";F=o[N];}}return F;},getListFormat:function(t,s){var F=this._get("listPattern-"+(t||"standard")+"-"+(s||"wide"));if(F){return F;}return{};},getResolvedUnitFormat:function(u){u=this.getUnitFromMapping(u)||u;return this.getUnitFormat(u);},getUnitFormat:function(u){return this._get("units","short",u);},getUnitFormats:function(){return this._getMerged("units","short");},getUnitFromMapping:function(s){return this._get("unitMappings",s);},getEras:function(w,s){a(w=="wide"||w=="abbreviated"||w=="narrow","sWidth must be wide, abbreviate or narrow");var E=this._get(g(s),"era-"+w),j=[];for(var i in E){j[parseInt(i)]=E[i];}return j;},getEraDates:function(s){var E=this._get("eras-"+s.toLowerCase()),j=[];for(var i in E){j[parseInt(i)]=E[i];}return j;},getCalendarWeek:function(s,w){a(s=="wide"||s=="narrow","sStyle must be wide or narrow");var o=sap.ui.getCore().getLibraryResourceBundle("sap.ui.core",this.oLocale.toString()),K="date.week.calendarweek."+s;return o.getText(K,w);},getPreferredCalendarType:function(){var s=this._get("calendarPreference"),j=s?s.split(" "):[],n,t,i;for(i=0;i<j.length;i++){n=j[i].split("-")[0];for(t in C){if(n===t.toLowerCase()){return t;}}}return C.Gregorian;},getPreferredHourSymbol:function(){return this._get("timeData","_preferred");},getPluralCategories:function(){var p=this._get("plurals"),i=Object.keys(p);i.push("other");return i;},getPluralCategory:function(n){var p=this._get("plurals");if(typeof n==="number"){n=n.toString();}if(!this._pluralTest){this._pluralTest={};}for(var s in p){var t=this._pluralTest[s];if(!t){t=this._parsePluralRule(p[s]);this._pluralTest[s]=t;}if(t(n)){return s;}}return"other";},_parsePluralRule:function(r){var O="or",j="and",n="%",p="=",s="!=",t="n",u="i",v="f",w="t",x="v",y="w",R="..",S=",";var i=0,T;T=r.split(" ");function z(o){if(T[i]===o){i++;return true;}return false;}function A(){var o=T[i];i++;return o;}function D(){var K,J;K=E();if(z(O)){J=D();return function(o){return K(o)||J(o);};}return K;}function E(){var K,N;K=F();if(z(j)){N=E();return function(o){return K(o)&&N(o);};}return K;}function F(){var K,N,P;K=G();if(z(p)){P=true;}else if(z(s)){P=false;}else{throw new Error("Expected '=' or '!='");}N=I();if(P){return function(o){return N(o).indexOf(K(o))>=0;};}else{return function(o){return N(o).indexOf(K(o))===-1;};}}function G(){var K;K=H();if(z(n)){var N=parseInt(A());return function(o){return K(o)%N;};}return K;}function H(){if(z(t)){return function(o){return o.n;};}else if(z(u)){return function(o){return o.i;};}else if(z(v)){return function(o){return o.f;};}else if(z(w)){return function(o){return o.t;};}else if(z(x)){return function(o){return o.v;};}else if(z(y)){return function(o){return o.w;};}else{throw new Error("Unknown operand: "+A());}}function I(){var V=[],K=A(),P=K.split(S),N,Q,U;P.forEach(function(o){N=o.split(R);if(N.length===1){V.push(parseInt(o));}else{Q=parseInt(N[0]);U=parseInt(N[1]);for(var i=Q;i<=U;i++){V.push(i);}}});return function(o){return V;};}var J=D();if(i!=T.length){throw new Error("Not completely parsed");}return function(V){var K=V.indexOf("."),N,P,Q,o;if(K===-1){N=V;P="";Q="";}else{N=V.substr(0,K);P=V.substr(K+1);Q=P.replace(/0+$/,'');}o={n:parseFloat(V),i:parseInt(N),v:P.length,w:Q.length,f:parseInt(P),t:parseInt(Q)};return J(o);};}});var m={"Era":{field:"era",index:0},"Year":{field:"year",index:1},"Quarter":{field:"quarter",index:2},"Month":{field:"month",index:3},"Week":{field:"week",index:4},"Day-Of-Week":{field:"weekday",index:5},"Day":{field:"day",index:6},"DayPeriod":{field:"hour",index:7,diffOnly:true},"Hour":{field:"hour",index:8},"Minute":{field:"minute",index:9},"Second":{field:"second",index:10},"Timezone":{field:"zone",index:11}};var d={"G":{group:"Era",match:"Era",numericCeiling:1},"y":{group:"Year",match:"Year",numericCeiling:100},"Y":{group:"Year",match:"Year",numericCeiling:100},"Q":{group:"Quarter",match:"Quarter",numericCeiling:3},"q":{group:"Quarter",match:"Quarter",numericCeiling:3},"M":{group:"Month",match:"Month",numericCeiling:3},"L":{group:"Month",match:"Month",numericCeiling:3},"w":{group:"Week",match:"Week",numericCeiling:100},"W":{group:"Week",match:"Week",numericCeiling:100},"d":{group:"Day",match:"Day",numericCeiling:100},"D":{group:"Day",match:"Day",numericCeiling:100},"E":{group:"Day-Of-Week",match:"Day-Of-Week",numericCeiling:1},"e":{group:"Day-Of-Week",match:"Day-Of-Week",numericCeiling:3},"c":{group:"Day-Of-Week",match:"Day-Of-Week",numericCeiling:2},"h":{group:"Hour",match:"Hour12",numericCeiling:100},"H":{group:"Hour",match:"Hour24",numericCeiling:100},"k":{group:"Hour",match:"Hour24",numericCeiling:100},"K":{group:"Hour",match:"Hour12",numericCeiling:100},"m":{group:"Minute",match:"Minute",numericCeiling:100},"s":{group:"Second",match:"Second",numericCeiling:100},"z":{group:"Timezone",match:"Timezone",numericCeiling:1},"Z":{group:"Timezone",match:"Timezone",numericCeiling:1},"O":{group:"Timezone",match:"Timezone",numericCeiling:1},"v":{group:"Timezone",match:"Timezone",numericCeiling:1},"V":{group:"Timezone",match:"Timezone",numericCeiling:1},"X":{group:"Timezone",match:"Timezone",numericCeiling:1},"x":{group:"Timezone",match:"Timezone",numericCeiling:1},"S":{group:"Other",numericCeiling:100},"u":{group:"Other",numericCeiling:100},"U":{group:"Other",numericCeiling:1},"r":{group:"Other",numericCeiling:100},"F":{group:"Other",numericCeiling:100},"g":{group:"Other",numericCeiling:100},"a":{group:"DayPeriod",numericCeiling:1},"b":{group:"Other",numericCeiling:1},"B":{group:"Other",numericCeiling:1},"A":{group:"Other",numericCeiling:100}};var M={"orientation":"left-to-right","languages":{},"scripts":{},"territories":{},"ca-gregorian":{"dateFormats":{"full":"EEEE, MMMM d, y","long":"MMMM d, y","medium":"MMM d, y","short":"M/d/yy"},"timeFormats":{"full":"h:mm:ss a zzzz","long":"h:mm:ss a z","medium":"h:mm:ss a","short":"h:mm a"},"dateTimeFormats":{"full":"{1} 'at' {0}","long":"{1} 'at' {0}","medium":"{1}, {0}","short":"{1}, {0}","availableFormats":{"d":"d","E":"ccc","Ed":"d E","Ehm":"E h:mm a","EHm":"E HH:mm","Ehms":"E h:mm:ss a","EHms":"E HH:mm:ss","Gy":"y G","GyMMM":"MMM y G","GyMMMd":"MMM d, y G","GyMMMEd":"E, MMM d, y G","h":"h a","H":"HH","hm":"h:mm a","Hm":"HH:mm","hms":"h:mm:ss a","Hms":"HH:mm:ss","hmsv":"h:mm:ss a v","Hmsv":"HH:mm:ss v","hmv":"h:mm a v","Hmv":"HH:mm v","M":"L","Md":"M/d","MEd":"E, M/d","MMM":"LLL","MMMd":"MMM d","MMMEd":"E, MMM d","MMMMd":"MMMM d","ms":"mm:ss","y":"y","yM":"M/y","yMd":"M/d/y","yMEd":"E, M/d/y","yMMM":"MMM y","yMMMd":"MMM d, y","yMMMEd":"E, MMM d, y","yMMMM":"MMMM y","yQQQ":"QQQ y","yQQQQ":"QQQQ y"},"appendItems":{"Day":"{0} ({2}: {1})","Day-Of-Week":"{0} {1}","Era":"{0} {1}","Hour":"{0} ({2}: {1})","Minute":"{0} ({2}: {1})","Month":"{0} ({2}: {1})","Quarter":"{0} ({2}: {1})","Second":"{0} ({2}: {1})","Timezone":"{0} {1}","Week":"{0} ({2}: {1})","Year":"{0} {1}"},"intervalFormats":{"intervalFormatFallback":"{0} – {1}","d":{"d":"d – d"},"h":{"a":"h a – h a","h":"h – h a"},"H":{"H":"HH – HH"},"hm":{"a":"h:mm a – h:mm a","h":"h:mm – h:mm a","m":"h:mm – h:mm a"},"Hm":{"H":"HH:mm – HH:mm","m":"HH:mm – HH:mm"},"hmv":{"a":"h:mm a – h:mm a v","h":"h:mm – h:mm a v","m":"h:mm – h:mm a v"},"Hmv":{"H":"HH:mm – HH:mm v","m":"HH:mm – HH:mm v"},"hv":{"a":"h a – h a v","h":"h – h a v"},"Hv":{"H":"HH – HH v"},"M":{"M":"M – M"},"Md":{"d":"M/d – M/d","M":"M/d – M/d"},"MEd":{"d":"E, M/d – E, M/d","M":"E, M/d – E, M/d"},"MMM":{"M":"MMM – MMM"},"MMMd":{"d":"MMM d – d","M":"MMM d – MMM d"},"MMMEd":{"d":"E, MMM d – E, MMM d","M":"E, MMM d – E, MMM d"},"y":{"y":"y – y"},"yM":{"M":"M/y – M/y","y":"M/y – M/y"},"yMd":{"d":"M/d/y – M/d/y","M":"M/d/y – M/d/y","y":"M/d/y – M/d/y"},"yMEd":{"d":"E, M/d/y – E, M/d/y","M":"E, M/d/y – E, M/d/y","y":"E, M/d/y – E, M/d/y"},"yMMM":{"M":"MMM – MMM y","y":"MMM y – MMM y"},"yMMMd":{"d":"MMM d – d, y","M":"MMM d – MMM d, y","y":"MMM d, y – MMM d, y"},"yMMMEd":{"d":"E, MMM d – E, MMM d, y","M":"E, MMM d – E, MMM d, y","y":"E, MMM d, y – E, MMM d, y"},"yMMMM":{"M":"MMMM – MMMM y","y":"MMMM y – MMMM y"}}},"months":{"format":{"abbreviated":["Jan","Feb","Mar","Apr","May","Jun","Jul","Aug","Sep","Oct","Nov","Dec"],"narrow":["J","F","M","A","M","J","J","A","S","O","N","D"],"wide":["January","February","March","April","May","June","July","August","September","October","November","December"]},"stand-alone":{"abbreviated":["Jan","Feb","Mar","Apr","May","Jun","Jul","Aug","Sep","Oct","Nov","Dec"],"narrow":["J","F","M","A","M","J","J","A","S","O","N","D"],"wide":["January","February","March","April","May","June","July","August","September","October","November","December"]}},"days":{"format":{"abbreviated":["Sun","Mon","Tue","Wed","Thu","Fri","Sat"],"narrow":["S","M","T","W","T","F","S"],"short":["Su","Mo","Tu","We","Th","Fr","Sa"],"wide":["Sunday","Monday","Tuesday","Wednesday","Thursday","Friday","Saturday"]},"stand-alone":{"abbreviated":["Sun","Mon","Tue","Wed","Thu","Fri","Sat"],"narrow":["S","M","T","W","T","F","S"],"short":["Su","Mo","Tu","We","Th","Fr","Sa"],"wide":["Sunday","Monday","Tuesday","Wednesday","Thursday","Friday","Saturday"]}},"quarters":{"format":{"abbreviated":["Q1","Q2","Q3","Q4"],"narrow":["1","2","3","4"],"wide":["1st quarter","2nd quarter","3rd quarter","4th quarter"]},"stand-alone":{"abbreviated":["Q1","Q2","Q3","Q4"],"narrow":["1","2","3","4"],"wide":["1st quarter","2nd quarter","3rd quarter","4th quarter"]}},"dayPeriods":{"format":{"abbreviated":["AM","PM"],"narrow":["a","p"],"wide":["AM","PM"]},"stand-alone":{"abbreviated":["AM","PM"],"narrow":["AM","PM"],"wide":["AM","PM"]}},"era-wide":{"0":"Before Christ","1":"Anno Domini"},"era-abbreviated":{"0":"BC","1":"AD"},"era-narrow":{"0":"B","1":"A"}},"eras-gregorian":{"0":{"_end":"0-12-31"},"1":{"_start":"1-01-01"}},"dateFields":{"era":{"displayName":"era"},"year-wide":{"displayName":"year","relative-type--1":"last year","relative-type-0":"this year","relative-type-1":"next year","relativeTime-type-future":{"relativeTimePattern-count-one":"in {0} year","relativeTimePattern-count-other":"in {0} years"},"relativeTime-type-past":{"relativeTimePattern-count-one":"{0} year ago","relativeTimePattern-count-other":"{0} years ago"}},"year-short":{"displayName":"yr.","relative-type--1":"last yr.","relative-type-0":"this yr.","relative-type-1":"next yr.","relativeTime-type-future":{"relativeTimePattern-count-one":"in {0} yr.","relativeTimePattern-count-other":"in {0} yr."},"relativeTime-type-past":{"relativeTimePattern-count-one":"{0} yr. ago","relativeTimePattern-count-other":"{0} yr. ago"}},"year-narrow":{"displayName":"yr.","relative-type--1":"last yr.","relative-type-0":"this yr.","relative-type-1":"next yr.","relativeTime-type-future":{"relativeTimePattern-count-one":"in {0} yr.","relativeTimePattern-count-other":"in {0} yr."},"relativeTime-type-past":{"relativeTimePattern-count-one":"{0} yr. ago","relativeTimePattern-count-other":"{0} yr. ago"}},"quarter-wide":{"displayName":"quarter","relative-type--1":"last quarter","relative-type-0":"this quarter","relative-type-1":"next quarter","relativeTime-type-future":{"relativeTimePattern-count-one":"in {0} quarter","relativeTimePattern-count-other":"in {0} quarters"},"relativeTime-type-past":{"relativeTimePattern-count-one":"{0} quarter ago","relativeTimePattern-count-other":"{0} quarters ago"}},"quarter-short":{"displayName":"qtr.","relative-type--1":"last qtr.","relative-type-0":"this qtr.","relative-type-1":"next qtr.","relativeTime-type-future":{"relativeTimePattern-count-one":"in {0} qtr.","relativeTimePattern-count-other":"in {0} qtrs."},"relativeTime-type-past":{"relativeTimePattern-count-one":"{0} qtr. ago","relativeTimePattern-count-other":"{0} qtrs. ago"}},"quarter-narrow":{"displayName":"qtr.","relative-type--1":"last qtr.","relative-type-0":"this qtr.","relative-type-1":"next qtr.","relativeTime-type-future":{"relativeTimePattern-count-one":"in {0} qtr.","relativeTimePattern-count-other":"in {0} qtrs."},"relativeTime-type-past":{"relativeTimePattern-count-one":"{0} qtr. ago","relativeTimePattern-count-other":"{0} qtrs. ago"}},"month-wide":{"displayName":"month","relative-type--1":"last month","relative-type-0":"this month","relative-type-1":"next month","relativeTime-type-future":{"relativeTimePattern-count-one":"in {0} month","relativeTimePattern-count-other":"in {0} months"},"relativeTime-type-past":{"relativeTimePattern-count-one":"{0} month ago","relativeTimePattern-count-other":"{0} months ago"}},"month-short":{"displayName":"mo.","relative-type--1":"last mo.","relative-type-0":"this mo.","relative-type-1":"next mo.","relativeTime-type-future":{"relativeTimePattern-count-one":"in {0} mo.","relativeTimePattern-count-other":"in {0} mo."},"relativeTime-type-past":{"relativeTimePattern-count-one":"{0} mo. ago","relativeTimePattern-count-other":"{0} mo. ago"}},"month-narrow":{"displayName":"mo.","relative-type--1":"last mo.","relative-type-0":"this mo.","relative-type-1":"next mo.","relativeTime-type-future":{"relativeTimePattern-count-one":"in {0} mo.","relativeTimePattern-count-other":"in {0} mo."},"relativeTime-type-past":{"relativeTimePattern-count-one":"{0} mo. ago","relativeTimePattern-count-other":"{0} mo. ago"}},"week-wide":{"displayName":"week","relative-type--1":"last week","relative-type-0":"this week","relative-type-1":"next week","relativeTime-type-future":{"relativeTimePattern-count-one":"in {0} week","relativeTimePattern-count-other":"in {0} weeks"},"relativeTime-type-past":{"relativeTimePattern-count-one":"{0} week ago","relativeTimePattern-count-other":"{0} weeks ago"},"relativePeriod":"the week of {0}"},"week-short":{"displayName":"wk.","relative-type--1":"last wk.","relative-type-0":"this wk.","relative-type-1":"next wk.","relativeTime-type-future":{"relativeTimePattern-count-one":"in {0} wk.","relativeTimePattern-count-other":"in {0} wk."},"relativeTime-type-past":{"relativeTimePattern-count-one":"{0} wk. ago","relativeTimePattern-count-other":"{0} wk. ago"},"relativePeriod":"the week of {0}"},"week-narrow":{"displayName":"wk.","relative-type--1":"last wk.","relative-type-0":"this wk.","relative-type-1":"next wk.","relativeTime-type-future":{"relativeTimePattern-count-one":"in {0} wk.","relativeTimePattern-count-other":"in {0} wk."},"relativeTime-type-past":{"relativeTimePattern-count-one":"{0} wk. ago","relativeTimePattern-count-other":"{0} wk. ago"},"relativePeriod":"the week of {0}"},"day-wide":{"displayName":"day","relative-type--1":"yesterday","relative-type-0":"today","relative-type-1":"tomorrow","relativeTime-type-future":{"relativeTimePattern-count-one":"in {0} day","relativeTimePattern-count-other":"in {0} days"},"relativeTime-type-past":{"relativeTimePattern-count-one":"{0} day ago","relativeTimePattern-count-other":"{0} days ago"}},"day-short":{"displayName":"day","relative-type--1":"yesterday","relative-type-0":"today","relative-type-1":"tomorrow","relativeTime-type-future":{"relativeTimePattern-count-one":"in {0} day","relativeTimePattern-count-other":"in {0} days"},"relativeTime-type-past":{"relativeTimePattern-count-one":"{0} day ago","relativeTimePattern-count-other":"{0} days ago"}},"day-narrow":{"displayName":"day","relative-type--1":"yesterday","relative-type-0":"today","relative-type-1":"tomorrow","relativeTime-type-future":{"relativeTimePattern-count-one":"in {0} day","relativeTimePattern-count-other":"in {0} days"},"relativeTime-type-past":{"relativeTimePattern-count-one":"{0} day ago","relativeTimePattern-count-other":"{0} days ago"}},"weekday":{"displayName":"day of the week"},"hour-wide":{"displayName":"hour","relative-type-0":"this hour","relativeTime-type-future":{"relativeTimePattern-count-one":"in {0} hour","relativeTimePattern-count-other":"in {0} hours"},"relativeTime-type-past":{"relativeTimePattern-count-one":"{0} hour ago","relativeTimePattern-count-other":"{0} hours ago"}},"hour-short":{"displayName":"hr.","relative-type-0":"this hour","relativeTime-type-future":{"relativeTimePattern-count-one":"in {0} hr.","relativeTimePattern-count-other":"in {0} hr."},"relativeTime-type-past":{"relativeTimePattern-count-one":"{0} hr. ago","relativeTimePattern-count-other":"{0} hr. ago"}},"hour-narrow":{"displayName":"hr.","relative-type-0":"this hour","relativeTime-type-future":{"relativeTimePattern-count-one":"in {0} hr.","relativeTimePattern-count-other":"in {0} hr."},"relativeTime-type-past":{"relativeTimePattern-count-one":"{0} hr. ago","relativeTimePattern-count-other":"{0} hr. ago"}},"minute-wide":{"displayName":"minute","relative-type-0":"this minute","relativeTime-type-future":{"relativeTimePattern-count-one":"in {0} minute","relativeTimePattern-count-other":"in {0} minutes"},"relativeTime-type-past":{"relativeTimePattern-count-one":"{0} minute ago","relativeTimePattern-count-other":"{0} minutes ago"}},"minute-short":{"displayName":"min.","relative-type-0":"this minute","relativeTime-type-future":{"relativeTimePattern-count-one":"in {0} min.","relativeTimePattern-count-other":"in {0} min."},"relativeTime-type-past":{"relativeTimePattern-count-one":"{0} min. ago","relativeTimePattern-count-other":"{0} min. ago"}},"minute-narrow":{"displayName":"min.","relative-type-0":"this minute","relativeTime-type-future":{"relativeTimePattern-count-one":"in {0} min.","relativeTimePattern-count-other":"in {0} min."},"relativeTime-type-past":{"relativeTimePattern-count-one":"{0} min. ago","relativeTimePattern-count-other":"{0} min. ago"}},"second-wide":{"displayName":"second","relative-type-0":"now","relativeTime-type-future":{"relativeTimePattern-count-one":"in {0} second","relativeTimePattern-count-other":"in {0} seconds"},"relativeTime-type-past":{"relativeTimePattern-count-one":"{0} second ago","relativeTimePattern-count-other":"{0} seconds ago"}},"second-short":{"displayName":"sec.","relative-type-0":"now","relativeTime-type-future":{"relativeTimePattern-count-one":"in {0} sec.","relativeTimePattern-count-other":"in {0} sec."},"relativeTime-type-past":{"relativeTimePattern-count-one":"{0} sec. ago","relativeTimePattern-count-other":"{0} sec. ago"}},"second-narrow":{"displayName":"sec.","relative-type-0":"now","relativeTime-type-future":{"relativeTimePattern-count-one":"in {0} sec.","relativeTimePattern-count-other":"in {0} sec."},"relativeTime-type-past":{"relativeTimePattern-count-one":"{0} sec. ago","relativeTimePattern-count-other":"{0} sec. ago"}},"zone":{"displayName":"time zone"}},"decimalFormat":{"standard":"#,##0.###"},"currencyFormat":{"standard":"¤#,##0.00","currencySpacing":{"beforeCurrency":{"currencyMatch":"[:^S:]","surroundingMatch":"[:digit:]","insertBetween":" "},"afterCurrency":{"currencyMatch":"[:^S:]","surroundingMatch":"[:digit:]","insertBetween":" "}}},"percentFormat":{"standard":"#,##0%"},"miscPattern":{"approximately":"~{0}","atLeast":"{0}+","atMost":"≤{0}","range":"{0}–{1}"},"symbols-latn-decimal":".","symbols-latn-group":",","symbols-latn-plusSign":"+","symbols-latn-minusSign":"-","symbols-latn-percentSign":"%","weekData-minDays":4,"weekData-firstDay":1,"weekData-weekendStart":6,"weekData-weekendEnd":0,"timeData":{_allowed:"H h",_preferred:"H"},"lenient-scope-number":{"minusSign":"-‐‒–⁻₋−➖﹣","commaSign":",،٫、︐︑﹐﹑，","plusSign":"+⁺₊➕﬩﹢"},"plurals":{},"units":{"short":{"per":{"compoundUnitPattern":"{0}/{1}"},"acceleration-g-force":{"displayName":"g-force","unitPattern-count-one":"{0} G","unitPattern-count-other":"{0} G"},"acceleration-meter-per-second-squared":{"displayName":"meters/sec²","unitPattern-count-one":"{0} m/s²","unitPattern-count-other":"{0} m/s²"},"angle-revolution":{"displayName":"rev","unitPattern-count-one":"{0} rev","unitPattern-count-other":"{0} rev"},"angle-radian":{"displayName":"radians","unitPattern-count-one":"{0} rad","unitPattern-count-other":"{0} rad"},"angle-degree":{"displayName":"degrees","unitPattern-count-one":"{0} deg","unitPattern-count-other":"{0} deg"},"angle-arc-minute":{"displayName":"arcmins","unitPattern-count-one":"{0} arcmin","unitPattern-count-other":"{0} arcmins"},"angle-arc-second":{"displayName":"arcsecs","unitPattern-count-one":"{0} arcsec","unitPattern-count-other":"{0} arcsecs"},"area-square-kilometer":{"displayName":"km²","unitPattern-count-one":"{0} km²","unitPattern-count-other":"{0} km²","perUnitPattern":"{0}/km²"},"area-hectare":{"displayName":"hectares","unitPattern-count-one":"{0} ha","unitPattern-count-other":"{0} ha"},"area-square-meter":{"displayName":"meters²","unitPattern-count-one":"{0} m²","unitPattern-count-other":"{0} m²","perUnitPattern":"{0}/m²"},"area-square-centimeter":{"displayName":"cm²","unitPattern-count-one":"{0} cm²","unitPattern-count-other":"{0} cm²","perUnitPattern":"{0}/cm²"},"area-square-mile":{"displayName":"sq miles","unitPattern-count-one":"{0} sq mi","unitPattern-count-other":"{0} sq mi","perUnitPattern":"{0}/mi²"},"area-acre":{"displayName":"acres","unitPattern-count-one":"{0} ac","unitPattern-count-other":"{0} ac"},"area-square-yard":{"displayName":"yards²","unitPattern-count-one":"{0} yd²","unitPattern-count-other":"{0} yd²"},"area-square-foot":{"displayName":"sq feet","unitPattern-count-one":"{0} sq ft","unitPattern-count-other":"{0} sq ft"},"area-square-inch":{"displayName":"inches²","unitPattern-count-one":"{0} in²","unitPattern-count-other":"{0} in²","perUnitPattern":"{0}/in²"},"concentr-karat":{"displayName":"karats","unitPattern-count-one":"{0} kt","unitPattern-count-other":"{0} kt"},"concentr-milligram-per-deciliter":{"displayName":"mg/dL","unitPattern-count-one":"{0} mg/dL","unitPattern-count-other":"{0} mg/dL"},"concentr-millimole-per-liter":{"displayName":"millimol/liter","unitPattern-count-one":"{0} mmol/L","unitPattern-count-other":"{0} mmol/L"},"concentr-part-per-million":{"displayName":"parts/million","unitPattern-count-one":"{0} ppm","unitPattern-count-other":"{0} ppm"},"consumption-liter-per-kilometer":{"displayName":"liters/km","unitPattern-count-one":"{0} L/km","unitPattern-count-other":"{0} L/km"},"consumption-liter-per-100kilometers":{"displayName":"L/100 km","unitPattern-count-one":"{0} L/100 km","unitPattern-count-other":"{0} L/100 km"},"consumption-mile-per-gallon":{"displayName":"miles/gal","unitPattern-count-one":"{0} mpg","unitPattern-count-other":"{0} mpg"},"consumption-mile-per-gallon-imperial":{"displayName":"miles/gal Imp.","unitPattern-count-one":"{0} mpg Imp.","unitPattern-count-other":"{0} mpg Imp."},"digital-terabyte":{"displayName":"TByte","unitPattern-count-one":"{0} TB","unitPattern-count-other":"{0} TB"},"digital-terabit":{"displayName":"Tbit","unitPattern-count-one":"{0} Tb","unitPattern-count-other":"{0} Tb"},"digital-gigabyte":{"displayName":"GByte","unitPattern-count-one":"{0} GB","unitPattern-count-other":"{0} GB"},"digital-gigabit":{"displayName":"Gbit","unitPattern-count-one":"{0} Gb","unitPattern-count-other":"{0} Gb"},"digital-megabyte":{"displayName":"MByte","unitPattern-count-one":"{0} MB","unitPattern-count-other":"{0} MB"},"digital-megabit":{"displayName":"Mbit","unitPattern-count-one":"{0} Mb","unitPattern-count-other":"{0} Mb"},"digital-kilobyte":{"displayName":"kByte","unitPattern-count-one":"{0} kB","unitPattern-count-other":"{0} kB"},"digital-kilobit":{"displayName":"kbit","unitPattern-count-one":"{0} kb","unitPattern-count-other":"{0} kb"},"digital-byte":{"displayName":"byte","unitPattern-count-one":"{0} byte","unitPattern-count-other":"{0} byte"},"digital-bit":{"displayName":"bit","unitPattern-count-one":"{0} bit","unitPattern-count-other":"{0} bit"},"duration-century":{"displayName":"c","unitPattern-count-one":"{0} c","unitPattern-count-other":"{0} c"},"duration-year":{"displayName":"years","unitPattern-count-one":"{0} yr","unitPattern-count-other":"{0} yrs","perUnitPattern":"{0}/y"},"duration-month":{"displayName":"months","unitPattern-count-one":"{0} mth","unitPattern-count-other":"{0} mths","perUnitPattern":"{0}/m"},"duration-week":{"displayName":"weeks","unitPattern-count-one":"{0} wk","unitPattern-count-other":"{0} wks","perUnitPattern":"{0}/w"},"duration-day":{"displayName":"days","unitPattern-count-one":"{0} day","unitPattern-count-other":"{0} days","perUnitPattern":"{0}/d"},"duration-hour":{"displayName":"hours","unitPattern-count-one":"{0} hr","unitPattern-count-other":"{0} hr","perUnitPattern":"{0}/h"},"duration-minute":{"displayName":"mins","unitPattern-count-one":"{0} min","unitPattern-count-other":"{0} min","perUnitPattern":"{0}/min"},"duration-second":{"displayName":"secs","unitPattern-count-one":"{0} sec","unitPattern-count-other":"{0} sec","perUnitPattern":"{0}/s"},"duration-millisecond":{"displayName":"millisecs","unitPattern-count-one":"{0} ms","unitPattern-count-other":"{0} ms"},"duration-microsecond":{"displayName":"μsecs","unitPattern-count-one":"{0} μs","unitPattern-count-other":"{0} μs"},"duration-nanosecond":{"displayName":"nanosecs","unitPattern-count-one":"{0} ns","unitPattern-count-other":"{0} ns"},"electric-ampere":{"displayName":"amps","unitPattern-count-one":"{0} A","unitPattern-count-other":"{0} A"},"electric-milliampere":{"displayName":"milliamps","unitPattern-count-one":"{0} mA","unitPattern-count-other":"{0} mA"},"electric-ohm":{"displayName":"ohms","unitPattern-count-one":"{0} Ω","unitPattern-count-other":"{0} Ω"},"electric-volt":{"displayName":"volts","unitPattern-count-one":"{0} V","unitPattern-count-other":"{0} V"},"energy-kilocalorie":{"displayName":"kcal","unitPattern-count-one":"{0} kcal","unitPattern-count-other":"{0} kcal"},"energy-calorie":{"displayName":"cal","unitPattern-count-one":"{0} cal","unitPattern-count-other":"{0} cal"},"energy-foodcalorie":{"displayName":"Cal","unitPattern-count-one":"{0} Cal","unitPattern-count-other":"{0} Cal"},"energy-kilojoule":{"displayName":"kilojoule","unitPattern-count-one":"{0} kJ","unitPattern-count-other":"{0} kJ"},"energy-joule":{"displayName":"joules","unitPattern-count-one":"{0} J","unitPattern-count-other":"{0} J"},"energy-kilowatt-hour":{"displayName":"kW-hour","unitPattern-count-one":"{0} kWh","unitPattern-count-other":"{0} kWh"},"frequency-gigahertz":{"displayName":"GHz","unitPattern-count-one":"{0} GHz","unitPattern-count-other":"{0} GHz"},"frequency-megahertz":{"displayName":"MHz","unitPattern-count-one":"{0} MHz","unitPattern-count-other":"{0} MHz"},"frequency-kilohertz":{"displayName":"kHz","unitPattern-count-one":"{0} kHz","unitPattern-count-other":"{0} kHz"},"frequency-hertz":{"displayName":"Hz","unitPattern-count-one":"{0} Hz","unitPattern-count-other":"{0} Hz"},"length-kilometer":{"displayName":"km","unitPattern-count-one":"{0} km","unitPattern-count-other":"{0} km","perUnitPattern":"{0}/km"},"length-meter":{"displayName":"m","unitPattern-count-one":"{0} m","unitPattern-count-other":"{0} m","perUnitPattern":"{0}/m"},"length-decimeter":{"displayName":"dm","unitPattern-count-one":"{0} dm","unitPattern-count-other":"{0} dm"},"length-centimeter":{"displayName":"cm","unitPattern-count-one":"{0} cm","unitPattern-count-other":"{0} cm","perUnitPattern":"{0}/cm"},"length-millimeter":{"displayName":"mm","unitPattern-count-one":"{0} mm","unitPattern-count-other":"{0} mm"},"length-micrometer":{"displayName":"µmeters","unitPattern-count-one":"{0} µm","unitPattern-count-other":"{0} µm"},"length-nanometer":{"displayName":"nm","unitPattern-count-one":"{0} nm","unitPattern-count-other":"{0} nm"},"length-picometer":{"displayName":"pm","unitPattern-count-one":"{0} pm","unitPattern-count-other":"{0} pm"},"length-mile":{"displayName":"miles","unitPattern-count-one":"{0} mi","unitPattern-count-other":"{0} mi"},"length-yard":{"displayName":"yards","unitPattern-count-one":"{0} yd","unitPattern-count-other":"{0} yd"},"length-foot":{"displayName":"feet","unitPattern-count-one":"{0} ft","unitPattern-count-other":"{0} ft","perUnitPattern":"{0}/ft"},"length-inch":{"displayName":"inches","unitPattern-count-one":"{0} in","unitPattern-count-other":"{0} in","perUnitPattern":"{0}/in"},"length-parsec":{"displayName":"parsecs","unitPattern-count-one":"{0} pc","unitPattern-count-other":"{0} pc"},"length-light-year":{"displayName":"light yrs","unitPattern-count-one":"{0} ly","unitPattern-count-other":"{0} ly"},"length-astronomical-unit":{"displayName":"au","unitPattern-count-one":"{0} au","unitPattern-count-other":"{0} au"},"length-furlong":{"displayName":"furlongs","unitPattern-count-one":"{0} fur","unitPattern-count-other":"{0} fur"},"length-fathom":{"displayName":"fathoms","unitPattern-count-one":"{0} ftm","unitPattern-count-other":"{0} ftm"},"length-nautical-mile":{"displayName":"nmi","unitPattern-count-one":"{0} nmi","unitPattern-count-other":"{0} nmi"},"length-mile-scandinavian":{"displayName":"smi","unitPattern-count-one":"{0} smi","unitPattern-count-other":"{0} smi"},"length-point":{"displayName":"points","unitPattern-count-one":"{0} pt","unitPattern-count-other":"{0} pt"},"light-lux":{"displayName":"lux","unitPattern-count-one":"{0} lx","unitPattern-count-other":"{0} lx"},"mass-metric-ton":{"displayName":"t","unitPattern-count-one":"{0} t","unitPattern-count-other":"{0} t"},"mass-kilogram":{"displayName":"kg","unitPattern-count-one":"{0} kg","unitPattern-count-other":"{0} kg","perUnitPattern":"{0}/kg"},"mass-gram":{"displayName":"grams","unitPattern-count-one":"{0} g","unitPattern-count-other":"{0} g","perUnitPattern":"{0}/g"},"mass-milligram":{"displayName":"mg","unitPattern-count-one":"{0} mg","unitPattern-count-other":"{0} mg"},"mass-microgram":{"displayName":"µg","unitPattern-count-one":"{0} µg","unitPattern-count-other":"{0} µg"},"mass-ton":{"displayName":"tons","unitPattern-count-one":"{0} tn","unitPattern-count-other":"{0} tn"},"mass-stone":{"displayName":"stones","unitPattern-count-one":"{0} st","unitPattern-count-other":"{0} st"},"mass-pound":{"displayName":"pounds","unitPattern-count-one":"{0} lb","unitPattern-count-other":"{0} lb","perUnitPattern":"{0}/lb"},"mass-ounce":{"displayName":"oz","unitPattern-count-one":"{0} oz","unitPattern-count-other":"{0} oz","perUnitPattern":"{0}/oz"},"mass-ounce-troy":{"displayName":"oz troy","unitPattern-count-one":"{0} oz t","unitPattern-count-other":"{0} oz t"},"mass-carat":{"displayName":"carats","unitPattern-count-one":"{0} CD","unitPattern-count-other":"{0} CD"},"power-gigawatt":{"displayName":"GW","unitPattern-count-one":"{0} GW","unitPattern-count-other":"{0} GW"},"power-megawatt":{"displayName":"MW","unitPattern-count-one":"{0} MW","unitPattern-count-other":"{0} MW"},"power-kilowatt":{"displayName":"kW","unitPattern-count-one":"{0} kW","unitPattern-count-other":"{0} kW"},"power-watt":{"displayName":"watts","unitPattern-count-one":"{0} W","unitPattern-count-other":"{0} W"},"power-milliwatt":{"displayName":"mW","unitPattern-count-one":"{0} mW","unitPattern-count-other":"{0} mW"},"power-horsepower":{"displayName":"hp","unitPattern-count-one":"{0} hp","unitPattern-count-other":"{0} hp"},"pressure-hectopascal":{"displayName":"hPa","unitPattern-count-one":"{0} hPa","unitPattern-count-other":"{0} hPa"},"pressure-millimeter-of-mercury":{"displayName":"mmHg","unitPattern-count-one":"{0} mmHg","unitPattern-count-other":"{0} mmHg"},"pressure-pound-per-square-inch":{"displayName":"psi","unitPattern-count-one":"{0} psi","unitPattern-count-other":"{0} psi"},"pressure-inch-hg":{"displayName":"inHg","unitPattern-count-one":"{0} inHg","unitPattern-count-other":"{0} inHg"},"pressure-millibar":{"displayName":"mbar","unitPattern-count-one":"{0} mbar","unitPattern-count-other":"{0} mbar"},"speed-kilometer-per-hour":{"displayName":"km/hour","unitPattern-count-one":"{0} kph","unitPattern-count-other":"{0} kph"},"speed-meter-per-second":{"displayName":"meters/sec","unitPattern-count-one":"{0} m/s","unitPattern-count-other":"{0} m/s"},"speed-mile-per-hour":{"displayName":"miles/hour","unitPattern-count-one":"{0} mph","unitPattern-count-other":"{0} mph"},"speed-knot":{"displayName":"kn","unitPattern-count-one":"{0} kn","unitPattern-count-other":"{0} kn"},"temperature-generic":{"displayName":"°","unitPattern-count-other":"{0}°"},"temperature-celsius":{"displayName":"deg. C","unitPattern-count-one":"{0}°C","unitPattern-count-other":"{0}°C"},"temperature-fahrenheit":{"displayName":"deg. F","unitPattern-count-one":"{0}°F","unitPattern-count-other":"{0}°F"},"temperature-kelvin":{"displayName":"K","unitPattern-count-one":"{0} K","unitPattern-count-other":"{0} K"},"volume-cubic-kilometer":{"displayName":"km³","unitPattern-count-one":"{0} km³","unitPattern-count-other":"{0} km³"},"volume-cubic-meter":{"displayName":"m³","unitPattern-count-one":"{0} m³","unitPattern-count-other":"{0} m³","perUnitPattern":"{0}/m³"},"volume-cubic-centimeter":{"displayName":"cm³","unitPattern-count-one":"{0} cm³","unitPattern-count-other":"{0} cm³","perUnitPattern":"{0}/cm³"},"volume-cubic-mile":{"displayName":"mi³","unitPattern-count-one":"{0} mi³","unitPattern-count-other":"{0} mi³"},"volume-cubic-yard":{"displayName":"yards³","unitPattern-count-one":"{0} yd³","unitPattern-count-other":"{0} yd³"},"volume-cubic-foot":{"displayName":"feet³","unitPattern-count-one":"{0} ft³","unitPattern-count-other":"{0} ft³"},"volume-cubic-inch":{"displayName":"inches³","unitPattern-count-one":"{0} in³","unitPattern-count-other":"{0} in³"},"volume-megaliter":{"displayName":"ML","unitPattern-count-one":"{0} ML","unitPattern-count-other":"{0} ML"},"volume-hectoliter":{"displayName":"hL","unitPattern-count-one":"{0} hL","unitPattern-count-other":"{0} hL"},"volume-liter":{"displayName":"liters","unitPattern-count-one":"{0} L","unitPattern-count-other":"{0} L","perUnitPattern":"{0}/L"},"volume-deciliter":{"displayName":"dL","unitPattern-count-one":"{0} dL","unitPattern-count-other":"{0} dL"},"volume-centiliter":{"displayName":"cL","unitPattern-count-one":"{0} cL","unitPattern-count-other":"{0} cL"},"volume-milliliter":{"displayName":"mL","unitPattern-count-one":"{0} mL","unitPattern-count-other":"{0} mL"},"volume-pint-metric":{"displayName":"mpt","unitPattern-count-one":"{0} mpt","unitPattern-count-other":"{0} mpt"},"volume-cup-metric":{"displayName":"mcup","unitPattern-count-one":"{0} mc","unitPattern-count-other":"{0} mc"},"volume-acre-foot":{"displayName":"acre ft","unitPattern-count-one":"{0} ac ft","unitPattern-count-other":"{0} ac ft"},"volume-bushel":{"displayName":"bushels","unitPattern-count-one":"{0} bu","unitPattern-count-other":"{0} bu"},"volume-gallon":{"displayName":"gal","unitPattern-count-one":"{0} gal","unitPattern-count-other":"{0} gal","perUnitPattern":"{0}/gal US"},"volume-gallon-imperial":{"displayName":"Imp. gal","unitPattern-count-one":"{0} gal Imp.","unitPattern-count-other":"{0} gal Imp.","perUnitPattern":"{0}/gal Imp."},"volume-quart":{"displayName":"qts","unitPattern-count-one":"{0} qt","unitPattern-count-other":"{0} qt"},"volume-pint":{"displayName":"pints","unitPattern-count-one":"{0} pt","unitPattern-count-other":"{0} pt"},"volume-cup":{"displayName":"cups","unitPattern-count-one":"{0} c","unitPattern-count-other":"{0} c"},"volume-fluid-ounce":{"displayName":"fl oz","unitPattern-count-one":"{0} fl oz","unitPattern-count-other":"{0} fl oz"},"volume-tablespoon":{"displayName":"tbsp","unitPattern-count-one":"{0} tbsp","unitPattern-count-other":"{0} tbsp"},"volume-teaspoon":{"displayName":"tsp","unitPattern-count-one":"{0} tsp","unitPattern-count-other":"{0} tsp"},"coordinateUnit":{"east":"{0} E","north":"{0} N","south":"{0} S","west":"{0} W"}}}};var e={"iw":"he","ji":"yi","in":"id","sh":"sr"};var f=(function(){var j=L._cldrLocales,r={},i;if(j){for(i=0;i<j.length;i++){r[j[i]]=true;}}return r;}());var l={};function g(s){if(!s){s=sap.ui.getCore().getConfiguration().getCalendarType();}return"ca-"+s.toLowerCase();}function h(o){var s=o.getLanguage()||"",S=o.getScript()||"",r=o.getRegion()||"",D;function i(n,p){var t,v,u;if(!p){return;}for(t in p){if(p.hasOwnProperty(t)){v=n[t];u=p[t];if(v===undefined){n[t]=u;}else if(v===null){delete n[t];}else if(typeof v==='object'&&typeof u==='object'){i(v,u);}}}}function j(I){if(!l[I]&&(!f||f[I]===true)){var n=l[I]=b.loadResource("sap/ui/core/cldr/"+I+".json",{dataType:"json",failOnError:false});if(n&&n.__fallbackLocale){i(n,j(n.__fallbackLocale));delete n.__fallbackLocale;}}return l[I];}s=(s&&e[s])||s;if(s==="no"){s="nb";}if(s==="zh"&&!r){if(S==="Hans"){r="CN";}else if(S==="Hant"){r="TW";}}var I=s+"_"+r;if(s&&r){D=j(I);}if(!D&&s){D=j(s);}l[I]=D||M;return l[I];}var k=c.extend("sap.ui.core.CustomLocaleData",{constructor:function(o){c.apply(this,arguments);this.mCustomData=sap.ui.getCore().getConfiguration().getFormatSettings().getCustomLocaleData();},_get:function(){var A=Array.prototype.slice.call(arguments),s,K;if(A[0].indexOf("ca-")==0){s=A[0];if(s==g()){A=A.slice(1);}}K=A.join("-");var v=this.mCustomData[K];if(v==null){v=this._getDeep(this.mCustomData,arguments);if(v==null){v=this._getDeep(this.mData,arguments);}}return v;},_getMerged:function(){var D=this._getDeep(this.mData,arguments);var i=this._getDeep(this.mCustomData,arguments);return q.extend({},D,i);}});c.getInstance=function(o){return o.hasPrivateUseSubtag("sapufmt")?new k(o):new c(o);};return c;});
