/*!
 * OpenUI5
 * (c) Copyright 2009-2019 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(['sap/ui/thirdparty/jquery','sap/ui/base/DataType','sap/ui/base/ManagedObject','sap/ui/core/CustomData','./mvc/View','./mvc/EventHandlerResolver','./ExtensionPoint','./StashedControlSupport','sap/ui/base/SyncPromise','sap/base/Log','sap/base/util/ObjectPath','sap/base/util/values','sap/base/assert','sap/base/security/encodeXML','sap/base/util/LoaderExtensions','sap/base/util/JSTokenizer','sap/base/util/isEmptyObject'],function(q,D,M,C,V,E,a,S,b,L,O,v,c,d,f,J,g){"use strict";function p(t,s,N,o,r){var B=M.bindingParser(s,o,true,false,false,false,r);if(B&&typeof B==="object"){return B;}var e=s=B||s;var T=D.getType(t);if(T){if(T instanceof D){e=T.parseValue(s,{context:o,locals:r});if(!T.isValid(e)){L.error("Value '"+s+"' is not valid for type '"+T.getName()+"'.");}}}else{throw new Error("Property "+N+" has unknown type "+t);}return typeof e==="string"?M.bindingParser.escape(e):e;}function l(x){return x.localName||x.baseName||x.nodeName;}function u(e){if(e.isRejected()){throw e.getResult();}return e.getResult();}function h(A,e){function s(j,o,r,t){var w,x,y=[];for(w=j.firstChild;w;w=w.nextSibling){x=e(j,o,r,w,false,t);if(x){y.push(u(x));}}return b.resolve(y);}function i(j,o,r,t){var w,x=Promise.resolve(),y=[t];for(w=j.firstChild;w;w=w.nextSibling){x=x.then(e.bind(null,j,o,r,w,false,t));y.push(x);}return Promise.all(y);}return A?i:s;}var X={};X.loadTemplate=function(t,e){var r=t.replace(/\./g,"/")+("."+(e||"view")+".xml");return f.loadResource(r).documentElement;};X.loadTemplatePromise=function(t,e){var r=t.replace(/\./g,"/")+("."+(e||"view")+".xml");return f.loadResource(r,{async:true}).then(function(R){return R.documentElement;});};X.parseViewAttributes=function(x,o,s){var A=o.getMetadata().getAllProperties();for(var i=0;i<x.attributes.length;i++){var e=x.attributes[i];if(e.name==='controllerName'){o._controllerName=e.value;}else if(e.name==='resourceBundleName'){o._resourceBundleName=e.value;}else if(e.name==='resourceBundleUrl'){o._resourceBundleUrl=e.value;}else if(e.name==='resourceBundleLocale'){o._resourceBundleLocale=e.value;}else if(e.name==='resourceBundleAlias'){o._resourceBundleAlias=e.value;}else if(e.name==='class'){o.addStyleClass(e.value);}else if(!s[e.name]&&A[e.name]){s[e.name]=p(A[e.name].type,e.value,e.name,o._oContainingView.oController);}}};X.enrichTemplateIds=function(x,o){X.enrichTemplateIdsPromise(x,o,false);return x;};X.enrichTemplateIdsPromise=function(x,o,A){return n(x,o,true,A).then(function(){return x;});};X.parseTemplate=function(x,o){return u(X.parseTemplatePromise(x,o,false));};X.parseTemplatePromise=function(x,o,A,P){return n(x,o,false,A,P);};function k(r){var e,i=/^[a-zA-Z_$][a-zA-Z0-9_$]*$/;if(!r||typeof r!=="object"){e="core:require in XMLView can't be parsed to a valid object";}else{Object.keys(r).some(function(K){if(!i.test(K)){e="core:require in XMLView contains invalid identifier: '"+K+"'";return true;}if(!r[K]||typeof r[K]!=="string"){e="core:require in XMLView contains invalide value '"+r[K]+"'under key '"+K+"'";return true;}});}return e;}function m(x,A){var s=x.getAttributeNS("sap.ui.core","require"),r,o,j;if(s){try{r=J.parseJS(s);}catch(e){L.error("Require attribute can't be parsed on Node: ",x.nodeName);throw e;}j=k(r);if(j){throw new Error(j+" on Node: "+x.nodeName);}if(!g(r)){o={};if(A){return new Promise(function(t,w){sap.ui.require(v(r),function(){var y=arguments;Object.keys(r).forEach(function(K,i){o[K]=y[i];});t(o);},w);});}else{Object.keys(r).forEach(function(K){o[K]=sap.ui.requireSync(r[K]);});return b.resolve(o);}}}}function n(x,o,r,A,P){var R=[],s=m(x,A)||b.resolve();A=A&&o._sProcessingMode==="sequential";L.debug("XML processing mode is "+(A?"sequential":"default"),"","XMLTemplateProcessor");var t=sap.ui.getCore().getConfiguration().getDesignMode();if(t){o._sapui_declarativeSourceInfo={xmlNode:x,xmlRootNode:o._oContainingView===o?x:o._oContainingView._sapui_declarativeSourceInfo.xmlRootNode};}var w=o.sViewName||o._sFragmentName;if(!w){var T=o;var y=0;while(++y<1000&&T&&T!==T._oContainingView){T=T._oContainingView;}w=T.sViewName;}if(o.isSubView()){H(x,true,false,s);}else{if(x.localName==="View"&&x.namespaceURI!=="sap.ui.core.mvc"){L.warning("XMLView root node must have the 'sap.ui.core.mvc' namespace, not '"+x.namespaceURI+"'"+(w?" (View name: "+w+")":""));}I(x,false,false,s);}var i=0;function z(){for(;i<R.length;i++){var e=R[i];if(e&&typeof e.then==='function'){return e.then(B).then(z);}}return R;}function B(e){var j=[i,1].concat(e);Array.prototype.splice.apply(R,j);}return s.then(z);function F(e){return e;}function G(e){return o._oContainingView.createId(e);}function H(x,e,j,Z){if(x.nodeType===1){var $=l(x);if(x.namespaceURI==="http://www.w3.org/1999/xhtml"||x.namespaceURI==="http://www.w3.org/2000/svg"){R.push("<"+$+" ");var _=false;for(var i=0;i<x.attributes.length;i++){var a1=x.attributes[i];var b1=a1.value;if(a1.name==="id"){_=true;b1=W(o,x);}R.push(a1.name+"=\""+d(b1)+"\" ");}if(e===true){R.push("data-sap-ui-preserve"+"=\""+o.getId()+"\" ");if(!_){R.push("id"+"=\""+o.getId()+"\" ");}}R.push(">");var c1=x;if(window.HTMLTemplateElement&&x instanceof HTMLTemplateElement&&x.content instanceof DocumentFragment){c1=x.content;}I(c1,false,false,Z);R.push("</"+$+">");}else if($==="FragmentDefinition"&&x.namespaceURI==="sap.ui.core"){I(x,false,true,Z);}else{s=s.then(function(){return Q(x,Z).then(function(f1){for(var i=0;i<f1.length;i++){var g1=f1[i];if(o.getMetadata().hasAggregation("content")){o.addAggregation("content",g1);}else if(o.getMetadata().hasAssociation(("content"))){o.addAssociation("content",g1);}}return f1;});});R.push(s);}}else if(x.nodeType===3&&!j){var d1=x.textContent||x.text,e1=l(x.parentNode);if(d1){if(e1!="style"){d1=d(d1);}R.push(d1);}}}function I(x,e,j,Z){var $=x.childNodes;for(var i=0;i<$.length;i++){H($[i],e,j,Z);}}function K(e,j){var Z;var $=sap.ui.getCore().getLoadedLibraries();q.each($,function(c1,d1){if(e===d1.namespace||e===d1.name){Z=d1.name+"."+((d1.tagNames&&d1.tagNames[j])||j);}});Z=Z||e+"."+j;function _(b1){if(!b1){L.error("Control '"+Z+"' did not return a class definition from sap.ui.define.","","XMLTemplateProcessor");b1=O.get(Z);}if(!b1){L.error("Can't find object class '"+Z+"' for XML-view","","XMLTemplateProcessor");}return b1;}var a1=Z.replace(/\./g,"/");var b1=sap.ui.require(a1);if(!b1){if(A){return new Promise(function(c1){sap.ui.require([a1],function(b1){b1=_(b1);c1(b1);});});}else{b1=sap.ui.requireSync(a1);b1=_(b1);}}return b1;}function N(e,j){if(e.namespaceURI==="http://www.w3.org/1999/xhtml"||e.namespaceURI==="http://www.w3.org/2000/svg"){var Z=e.attributes['id']?e.attributes['id'].textContent||e.attributes['id'].text:null;if(r){return X.enrichTemplateIdsPromise(e,o,A).then(function(){return[];});}else{var $=function(a1){var b1={id:Z?W(o,e,Z):undefined,xmlNode:e,containingView:o._oContainingView,processingMode:o._sProcessingMode};if(o.fnScopedRunWithOwner){return o.fnScopedRunWithOwner(function(){return new a1(b1);});}return new a1(b1);};if(A){return new Promise(function(a1,b1){sap.ui.require(["sap/ui/core/mvc/XMLView"],function(_){a1([$(_)]);});});}else{var _=sap.ui.requireSync("sap/ui/core/mvc/XMLView");return b.resolve([$(_)]);}}}else{return Q(e,j);}}function Q(e,j){if(l(e)==="ExtensionPoint"&&e.namespaceURI==="sap.ui.core"){if(r){return b.resolve([]);}else{var Z=o instanceof V?o._oContainingView:o;var $=a._factory.bind(null,Z,e.getAttribute("name"),function(){var a1=b.resolve();var b1=[];var c1=e.childNodes;for(var i=0;i<c1.length;i++){var d1=c1[i];if(d1.nodeType===1){a1=a1.then(N.bind(null,d1,j));b1.push(a1);}}return b.all(b1).then(function(e1){var f1=[];e1.forEach(function(g1){f1=f1.concat(g1);});return f1;});});return b.resolve(o.fnScopedRunWithOwner?o.fnScopedRunWithOwner($):$());}}else{var _=K(e.namespaceURI,l(e));if(_&&typeof _.then==='function'){return _.then(function(a1){return U(e,a1,j);});}else{return U(e,_,j);}}}function U(Z,$,_){var ns=Z.namespaceURI,b1={},c1="",d1=[],e1=null,f1=null;if(!$){return b.resolve([]);}var g1=$.getMetadata();var h1=g1.getAllSettings();var i1=m(Z,A);if(i1){_=b.all([_,i1]).then(function(e){return Object.assign({},e[0],e[1]);});}_=_.then(function(j){if(g(j)){j=null;}if(!r){for(var i=0;i<Z.attributes.length;i++){var a1=Z.attributes[i],n1=a1.name,o1=h1[n1],p1=a1.value;if(n1==="id"){b1[n1]=W(o,Z,p1);}else if(n1==="class"){c1+=p1;}else if(n1==="viewName"){b1[n1]=p1;}else if(n1==="fragmentName"){b1[n1]=p1;b1['containingView']=o._oContainingView;}else if((n1==="binding"&&!o1)||n1==='objectBindings'){var q1=M.bindingParser(p1,o._oContainingView.oController);if(q1){b1.objectBindings=b1.objectBindings||{};b1.objectBindings[q1.model||undefined]=q1;}}else if(n1==='metadataContexts'){var r1=null;try{r1=X._calculatedModelMapping(p1,o._oContainingView.oController,true);}catch(e){L.error(o+":"+e.message);}if(r1){b1.metadataContexts=r1;if(X._preprocessMetadataContexts){X._preprocessMetadataContexts($.getMetadata().getName(),b1,o._oContainingView.oController);}}}else if(n1.indexOf(":")>-1){if(a1.namespaceURI==="http://schemas.sap.com/sapui5/extension/sap.ui.core.CustomData/1"){var s1=l(a1);d1.push(new C({key:s1,value:p("any",p1,s1,o._oContainingView.oController)}));}else if(a1.namespaceURI==="http://schemas.sap.com/sapui5/extension/sap.ui.core.support.Support.info/1"){f1=p1;}else if(a1.namespaceURI&&a1.namespaceURI.indexOf("http://schemas.sap.com/sapui5/preprocessorextension/")===0){L.debug(o+": XMLView parser ignored preprocessor attribute '"+n1+"' (value: '"+p1+"')");}else if(n1.indexOf("xmlns:")!==0){if(!e1){e1={};}if(!e1.hasOwnProperty(a1.namespaceURI)){e1[a1.namespaceURI]={};}e1[a1.namespaceURI][l(a1)]=a1.nodeValue;L.debug(o+": XMLView parser encountered unknown attribute '"+n1+"' (value: '"+p1+"') with unknown namespace, stored as sap-ui-custom-settings of customData");}}else if(o1&&o1._iKind===0){b1[n1]=p(o1.type,p1,n1,o._oContainingView.oController,j);}else if(o1&&o1._iKind===1&&o1.altTypes){b1[n1]=p(o1.altTypes[0],p1,n1,o._oContainingView.oController,j);}else if(o1&&o1._iKind===2){var q1=M.bindingParser(p1,o._oContainingView.oController,false,false,false,false,j);if(q1){b1[n1]=q1;}else{L.error(o+": aggregations with cardinality 0..n only allow binding paths as attribute value (wrong value: "+n1+"='"+p1+"')");}}else if(o1&&o1._iKind===3){b1[n1]=G(p1);}else if(o1&&o1._iKind===4){b1[n1]=p1.split(/[\s,]+/g).filter(F).map(G);}else if(o1&&o1._iKind===5){var t1=[];E.parse(p1).forEach(function(u1){var v1=E.resolveEventHandler(u1,o._oContainingView.oController,j);if(v1){t1.push(v1);}else{L.warning(o+": event handler function \""+u1+"\" is not a function or does not exist in the controller.");}});if(t1.length){b1[n1]=t1;}}else if(o1&&o1._iKind===-1){if(V.prototype.isPrototypeOf($.prototype)&&n1=="async"){b1[n1]=p(o1.type,p1,n1,o._oContainingView.oController,j);}else{L.warning(o+": setting '"+n1+"' for class "+g1.getName()+" (value:'"+p1+"') is not supported");}}else{c(n1==='xmlns',o+": encountered unknown setting '"+n1+"' for class "+g1.getName()+" (value:'"+p1+"')");if(X._supportInfo){X._supportInfo({context:Z,env:{caller:"createRegularControls",error:true,info:"unknown setting '"+n1+"' for class "+g1.getName()}});}}}if(e1){d1.push(new C({key:"sap-ui-custom-settings",value:e1}));}if(d1.length>0){b1.customData=d1;}}return j;});var j1=h(A,k1);function k1(Z,l1,m1,e,a1,_){var n1,o1;if(e.nodeType===1){if(e.namespaceURI==="http://schemas.sap.com/sapui5/extension/sap.ui.core.xmlcomposite/1"){b1[l(e)]=e.querySelector("*");return;}n1=e.namespaceURI===ns&&m1&&m1[l(e)];if(n1){return j1(e,n1,false,_);}else if(l1){if(!a1&&e.getAttribute("stashed")==="true"&&!r){o1=function(){S.createStashedControl(W(o,e),{sParentId:b1["id"],sParentAggregationName:l1.name,fnCreate:function(){var j=A;A=false;try{return u(k1(Z,l1,m1,e,true,_));}finally{A=j;}}});};if(o.fnScopedRunWithOwner){o.fnScopedRunWithOwner(o1);}else{o1();}return;}return N(e,_).then(function(p1){for(var j=0;j<p1.length;j++){var q1=p1[j];var r1=l1.name;if(l1.multiple){if(!b1[r1]){b1[r1]=[];}if(typeof b1[r1].path==="string"){c(!b1[r1].template,"list bindings support only a single template object");b1[r1].template=q1;}else{b1[r1].push(q1);}}else{c(!b1[r1],"multiple aggregates defined for aggregation with cardinality 0..1");b1[r1]=q1;}}return p1;});}else if(l(Z)!=="FragmentDefinition"||Z.namespaceURI!=="sap.ui.core"){throw new Error("Cannot add direct child without default aggregation defined for control "+g1.getElementName());}}else if(e.nodeType===3){if(q.trim(e.textContent||e.text)){throw new Error("Cannot add text nodes as direct child of an aggregation. For adding text to an aggregation, a surrounding html tag is needed: "+q.trim(e.textContent||e.text));}}}var l1=g1.getDefaultAggregation();var m1=g1.getAllAggregations();return j1(Z,l1,m1,_).then(function(){var e;if(r&&Z.hasAttribute("id")){Y(o,Z);}else if(!r){if(V.prototype.isPrototypeOf($.prototype)&&typeof $._sType==="string"){var j=function(){if($.getMetadata().isA("sap.ui.core.mvc.XMLView")&&o._sProcessingMode==="sequential"){b1.processingMode="sequential";}return V._legacyCreate(b1,undefined,$._sType);};if(o.fnScopedRunWithOwner){e=o.fnScopedRunWithOwner(j);}else{e=j();}}else{var a1=function(){if($.getMetadata().isA("sap.ui.core.Fragment")&&Z.getAttribute("type")!=="JS"&&o._sProcessingMode==="sequential"){b1.processingMode="sequential";}if(o.fnScopedRunWithOwner){return o.fnScopedRunWithOwner(function(){return new $(b1);});}else{return new $(b1);}};if(P&&P.fnRunWithPreprocessor){e=P.fnRunWithPreprocessor(a1);}else{e=a1();}}if(c1&&e.addStyleClass){e.addStyleClass(c1);}}if(!e){e=[];}else if(!Array.isArray(e)){e=[e];}if(X._supportInfo&&e){for(var i=0,n1=e.length;i<n1;i++){var o1=e[i];if(o1&&o1.getId()){var p1=X._supportInfo({context:Z,env:{caller:"createRegularControls",nodeid:Z.getAttribute("id"),controlid:o1.getId()}}),q1=f1?f1+",":"";q1+=p1;X._supportInfo.addSupportInfo(o1.getId(),q1);}}}if(t){e.forEach(function(o1){if(g1.getCompositeAggregationName){var r1=Z.getElementsByTagName(o1.getMetadata().getCompositeAggregationName());for(var i=0;i<r1.length;i++){Z.removeChild(r1[0]);}}o1._sapui_declarativeSourceInfo={xmlNode:Z,xmlRootNode:o._sapui_declarativeSourceInfo.xmlRootNode,fragmentName:g1.getName()==='sap.ui.core.Fragment'?b1['fragmentName']:null};});}return e;});}function W(o,x,e){if(x.getAttributeNS("http://schemas.sap.com/sapui5/extension/sap.ui.core.Internal/1","id")){return x.getAttribute("id");}else{return G(e?e:x.getAttribute("id"));}}function Y(o,x){x.setAttribute("id",G(x.getAttribute("id")));x.setAttributeNS("http://schemas.sap.com/sapui5/extension/sap.ui.core.Internal/1","id",true);}}X._preprocessMetadataContexts=null;X._calculatedModelMapping=function(B,o,A){var e,j={},r=M.bindingParser(B,o);function s(F){if(F.length%2===0){throw new Error("The last entry is no binding");}for(var i=1;i<=F.length;i=i+2){if(typeof F[i-1]=='string'){throw new Error("Binding expected not a string");}if(F[i]){if((typeof F[i]!='string')||(F[i]!=",")){throw new Error("Missing delimiter ','");}}}}if(r){if(!r.formatter){e=r;r={parts:[e]};}else{s(r.formatter.textFragments);}for(var i=0;i<r.parts.length;i++){e=r.parts[i];j[e.model]=j[e.model]||(A?[]:null);if(Array.isArray(j[e.model])){j[e.model].push(e);}else{j[e.model]=e;}}}return j;};return X;},true);
