/*!
 * OpenUI5
 * (c) Copyright 2009-2019 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(['sap/ui/base/Object','sap/ui/core/Locale','sap/ui/core/LocaleData','sap/base/Log','sap/base/assert','sap/ui/thirdparty/jquery'],function(B,L,a,b,c,q){"use strict";var N=B.extend("sap.ui.core.format.NumberFormat",{constructor:function(F){throw new Error();}});var r=/0+(\.0+)?/;var n={INTEGER:"integer",FLOAT:"float",CURRENCY:"currency",UNIT:"unit",PERCENT:"percent"};var R={FLOOR:"floor",CEILING:"ceiling",TOWARDS_ZERO:"towards_zero",AWAY_FROM_ZERO:"away_from_zero",HALF_FLOOR:"half_floor",HALF_CEILING:"half_ceiling",HALF_TOWARDS_ZERO:"half_towards_zero",HALF_AWAY_FROM_ZERO:"half_away_from_zero"};var m={};m[R.FLOOR]=Math.floor;m[R.CEILING]=Math.ceil;m[R.TOWARDS_ZERO]=function(i){return i>0?Math.floor(i):Math.ceil(i);};m[R.AWAY_FROM_ZERO]=function(i){return i>0?Math.ceil(i):Math.floor(i);};m[R.HALF_TOWARDS_ZERO]=function(i){return i>0?Math.ceil(i-0.5):Math.floor(i+0.5);};m[R.HALF_AWAY_FROM_ZERO]=function(i){return i>0?Math.floor(i+0.5):Math.ceil(i-0.5);};m[R.HALF_FLOOR]=function(i){return Math.ceil(i-0.5);};m[R.HALF_CEILING]=Math.round;N.RoundingMode=R;N.oDefaultIntegerFormat={minIntegerDigits:1,maxIntegerDigits:99,minFractionDigits:0,maxFractionDigits:0,groupingEnabled:false,groupingSize:3,groupingSeparator:",",decimalSeparator:".",plusSign:"+",minusSign:"-",isInteger:true,type:n.INTEGER,showMeasure:false,style:"standard",parseAsString:false,roundingMode:N.RoundingMode.TOWARDS_ZERO,emptyString:NaN,showScale:true};N.oDefaultFloatFormat={minIntegerDigits:1,maxIntegerDigits:99,minFractionDigits:0,maxFractionDigits:99,groupingEnabled:true,groupingSize:3,groupingSeparator:",",decimalSeparator:".",plusSign:"+",minusSign:"-",isInteger:false,type:n.FLOAT,showMeasure:false,style:"standard",parseAsString:false,roundingMode:N.RoundingMode.HALF_AWAY_FROM_ZERO,emptyString:NaN,showScale:true};N.oDefaultPercentFormat={minIntegerDigits:1,maxIntegerDigits:99,minFractionDigits:0,maxFractionDigits:99,groupingEnabled:true,groupingSize:3,groupingSeparator:",",decimalSeparator:".",plusSign:"+",minusSign:"-",percentSign:"%",isInteger:false,type:n.PERCENT,showMeasure:false,style:"standard",parseAsString:false,roundingMode:N.RoundingMode.HALF_AWAY_FROM_ZERO,emptyString:NaN,showScale:true};N.oDefaultCurrencyFormat={minIntegerDigits:1,maxIntegerDigits:99,groupingEnabled:true,groupingSize:3,groupingSeparator:",",decimalSeparator:".",plusSign:"+",minusSign:"-",isInteger:false,type:n.CURRENCY,showMeasure:true,currencyCode:true,currencyContext:'standard',style:"standard",customCurrencies:undefined,parseAsString:false,roundingMode:N.RoundingMode.HALF_AWAY_FROM_ZERO,emptyString:NaN,showScale:true,ignorePrecision:true};N.oDefaultUnitFormat={minIntegerDigits:1,maxIntegerDigits:99,groupingEnabled:true,groupingSize:3,groupingSeparator:",",decimalSeparator:".",plusSign:"+",minusSign:"-",isInteger:false,type:n.UNIT,showMeasure:true,style:"standard",customUnits:undefined,allowedUnits:undefined,parseAsString:false,roundingMode:N.RoundingMode.HALF_AWAY_FROM_ZERO,emptyString:NaN,showScale:true};N.getInstance=function(F,o){return this.getFloatInstance(F,o);};N.getFloatInstance=function(F,o){var i=this.createInstance(F,o),s=this.getLocaleFormatOptions(i.oLocaleData,n.FLOAT);i.oFormatOptions=q.extend(false,{},this.oDefaultFloatFormat,s,F);return i;};N.getIntegerInstance=function(F,o){var i=this.createInstance(F,o),s=this.getLocaleFormatOptions(i.oLocaleData,n.INTEGER);i.oFormatOptions=q.extend(false,{},this.oDefaultIntegerFormat,s,F);return i;};N.getCurrencyInstance=function(F,o){var i=this.createInstance(F,o),C=F&&F.currencyContext,s=this.getLocaleFormatOptions(i.oLocaleData,n.CURRENCY,C);i.oFormatOptions=q.extend(false,{},this.oDefaultCurrencyFormat,s,F);i._defineCustomCurrencySymbols();return i;};N.getUnitInstance=function(F,o){var i=this.createInstance(F,o),s=this.getLocaleFormatOptions(i.oLocaleData,n.UNIT);i.oFormatOptions=q.extend(false,{},this.oDefaultUnitFormat,s,F);return i;};N.getPercentInstance=function(F,o){var i=this.createInstance(F,o),s=this.getLocaleFormatOptions(i.oLocaleData,n.PERCENT);i.oFormatOptions=q.extend(false,{},this.oDefaultPercentFormat,s,F);return i;};N.createInstance=function(F,o){var i=Object.create(this.prototype),P;if(F instanceof L){o=F;F=undefined;}if(!o){o=sap.ui.getCore().getConfiguration().getFormatSettings().getFormatLocale();}i.oLocale=o;i.oLocaleData=a.getInstance(o);i.oOriginalFormatOptions=F;if(F){if(F.pattern){P=this.parseNumberPattern(F.pattern);q.each(P,function(s,O){F[s]=O;});}if(F.emptyString!==undefined){c(F.emptyString===""||F.emptyString===0||F.emptyString===null||F.emptyString!==F.emptyString,"The format option 'emptyString' must be either 0, null or NaN");}}return i;};N.getDefaultUnitPattern=function(s){return"{0} "+s;};N.getLocaleFormatOptions=function(o,t,C){var i,s;switch(t){case n.PERCENT:s=o.getPercentPattern();break;case n.CURRENCY:s=o.getCurrencyPattern(C);break;case n.UNIT:s=o.getDecimalPattern();break;default:s=o.getDecimalPattern();}i=this.parseNumberPattern(s);i.plusSign=o.getNumberSymbol("plusSign");i.minusSign=o.getNumberSymbol("minusSign");i.decimalSeparator=o.getNumberSymbol("decimal");i.groupingSeparator=o.getNumberSymbol("group");i.percentSign=o.getNumberSymbol("percentSign");i.pattern=s;switch(t){case n.UNIT:case n.FLOAT:case n.PERCENT:i.minFractionDigits=0;i.maxFractionDigits=99;break;case n.INTEGER:i.minFractionDigits=0;i.maxFractionDigits=0;i.groupingEnabled=false;break;case n.CURRENCY:i.minFractionDigits=undefined;i.maxFractionDigits=undefined;break;}return i;};N.parseNumberPattern=function(F){var M=0,o=0,s=0,G=false,t=0,u=0,S=F.indexOf(";"),v={Integer:0,Fraction:1},w=v.Integer;if(S!==-1){F=F.substring(0,S);}for(var i=0;i<F.length;i++){var C=F[i];switch(C){case",":if(G){t=u;u=0;}G=true;break;case".":w=v.Fraction;break;case"0":if(w===v.Integer){M++;if(G){u++;}}else{o++;s++;}break;case"#":if(w===v.Integer){if(G){u++;}}else{s++;}break;}}if(!t){t=u;u=0;}return{minIntegerDigits:M,minFractionDigits:o,maxFractionDigits:s,groupingEnabled:G,groupingSize:t,groupingBaseSize:u};};N.prototype._defineCustomCurrencySymbols=function(){var o=this.oFormatOptions;var C=this.oLocaleData.getCurrencySymbols();var F=function(s,i){var u=[];var S;for(var K in s){S=s[K];if(u.indexOf(S)===-1){u.push(S);}else if(S!==undefined){i[S]=true;b.error("Symbol '"+S+"' is defined multiple times in custom currencies.",undefined,"NumberFormat");}}};if(o.customCurrencies&&typeof o.customCurrencies==="object"){this.mKnownCurrencySymbols={};this.mKnownCurrencyCodes={};Object.keys(o.customCurrencies).forEach(function(K){if(o.customCurrencies[K].symbol){this.mKnownCurrencySymbols[K]=o.customCurrencies[K].symbol;}else{var i=o.customCurrencies[K].isoCode;if(i){this.mKnownCurrencySymbols[K]=C[i];}}this.mKnownCurrencyCodes[K]=K;}.bind(this));}else{this.mKnownCurrencySymbols=C;this.mKnownCurrencyCodes=this.oLocaleData.getCustomCurrencyCodes();}this.mDuplicatedSymbols={};F(this.mKnownCurrencySymbols,this.mDuplicatedSymbols);};N.prototype.format=function(v,M){if(Array.isArray(v)){M=v[1];v=v[0];}var i="",F="",G="",s="",o="",P="",t=0,u=0,w=0,x=0,y=v<0,D=-1,O=q.extend({},this.oFormatOptions),z=this.oOriginalFormatOptions,I=O.type===n.CURRENCY&&M==="INR"&&this.oLocale.getLanguage()==="en"&&this.oLocale.getRegion()==="IN",A,S,C,E,U,H;if(v===O.emptyString||(isNaN(v)&&isNaN(O.emptyString))){return"";}if(M&&O.customCurrencies&&!O.customCurrencies[M]){b.error("Currency '"+M+"' is unknown.");return"";}if(O.type===n.UNIT){if(O.customUnits&&typeof O.customUnits==="object"){U=O.customUnits[M];}else{H=this.oLocaleData.getUnitFromMapping(M)||M;U=this.oLocaleData.getUnitFormat(H);}O.decimals=(U&&(typeof U.decimals==="number"&&U.decimals>=0))?U.decimals:O.decimals;O.precision=(U&&(typeof U.precision==="number"&&U.precision>=0))?U.precision:O.precision;}if(O.type==n.CURRENCY){if(O.customCurrencies&&O.customCurrencies[M]){O.decimals=O.customCurrencies[M].decimals!==undefined?O.customCurrencies[M].decimals:O.decimals;}}if(O.decimals!==undefined){O.minFractionDigits=O.decimals;O.maxFractionDigits=O.decimals;}if(O.shortLimit===undefined||Math.abs(v)>=O.shortLimit){C=O.shortRefNumber===undefined?v:O.shortRefNumber;S=g(C,O,this.oLocaleData,I);if(S&&S.formatString!="0"){v=v/S.magnitude;if(O.shortDecimals!==undefined){O.minFractionDigits=O.shortDecimals;O.maxFractionDigits=O.shortDecimals;}else{if(z.minFractionDigits===undefined&&z.maxFractionDigits===undefined&&z.decimals===undefined&&z.precision===undefined&&z.pattern===undefined){O.precision=2;O.minFractionDigits=0;O.maxFractionDigits=99;}if(z.maxFractionDigits===undefined&&z.decimals===undefined){O.maxFractionDigits=99;}}O.roundingMode=N.RoundingMode.HALF_AWAY_FROM_ZERO;}}if((S||!O.ignorePrecision)&&O.precision!==undefined){O.maxFractionDigits=Math.min(O.maxFractionDigits,j(v,O.precision));O.minFractionDigits=Math.min(O.minFractionDigits,O.maxFractionDigits);}if(O.type==n.PERCENT){v=N._shiftDecimalPoint(v,2);}if(O.type==n.CURRENCY){var J=this.oLocaleData.getCurrencyDigits(M);if(O.customCurrencies&&O.customCurrencies[M]&&O.customCurrencies[M].decimals!==undefined){J=O.customCurrencies[M].decimals;}if(O.maxFractionDigits===undefined){O.maxFractionDigits=J;}if(O.minFractionDigits===undefined){O.minFractionDigits=J;}}if(typeof v==="number"){v=f(v,O.maxFractionDigits,O.roundingMode);}if(v==0){y=false;}o=this.convertToDecimal(v);if(o=="NaN"){return o;}if(y){o=o.substr(1);}D=o.indexOf(".");if(D>-1){i=o.substr(0,D);F=o.substr(D+1);}else{i=o;}if(i.length<O.minIntegerDigits){i=i.padStart(O.minIntegerDigits,"0");}else if(i.length>O.maxIntegerDigits){i="".padStart(O.maxIntegerDigits,"?");}if(F.length<O.minFractionDigits){F=F.padEnd(O.minFractionDigits,"0");}else if(F.length>O.maxFractionDigits){F=F.substr(0,O.maxFractionDigits);}u=i.length;if(O.groupingEnabled){if(I){var K=[3,2,2],Q,T=0;t=i.length;while(t>0){Q=K[T%3];t-=Q;if(T>0){G=O.groupingSeparator+G;}if(t<0){Q+=t;t=0;}G=i.substr(t,Q)+G;T++;}}else{w=O.groupingSize;x=O.groupingBaseSize||w;t=Math.max(u-x,0)%w||w;G=i.substr(0,t);while(u-t>=x){G+=O.groupingSeparator;G+=i.substr(t,w);t+=w;}G+=i.substr(t);}}else{G=i;}if(y){s=O.minusSign;}s+=G;if(F){s+=O.decimalSeparator+F;}if(S&&S.formatString&&O.showScale&&O.type!==n.CURRENCY){E=this.oLocaleData.getPluralCategory(i+"."+F);S.formatString=this.oLocaleData.getDecimalFormat(O.style,S.key,E);s=S.formatString.replace(S.valueSubString,s);s=s.replace(/'.'/g,".");}if(O.type===n.CURRENCY){P=O.pattern;if(S&&S.formatString&&O.showScale){E=this.oLocaleData.getPluralCategory(i+"."+F);if(I){P=e("short",S.key,E);}else{P=this.oLocaleData.getCurrencyFormat("short",S.key,E);}P=P.replace(/'.'/g,".");}A=P.split(";");if(A.length===2){P=y?A[1]:A[0];if(y){s=s.substring(1);}}if(!O.currencyCode){var V;if(O.customCurrencies&&typeof O.customCurrencies==="object"){V=this.mKnownCurrencySymbols[M];}else{V=this.oLocaleData.getCurrencySymbol(M);}if(V&&V!==M){M=V;}}s=this._composeCurrencyResult(P,s,M,{showMeasure:O.showMeasure,negative:y,minusSign:O.minusSign});}if(O.type===n.PERCENT){P=O.pattern;s=P.replace(/[0#.,]+/,s);s=s.replace(/%/,O.percentSign);}if(O.showMeasure&&O.type===n.UNIT){E=this.oLocaleData.getPluralCategory(i+"."+F);c(E,"Cannot find plural category for "+(i+"."+F));var W=!O.allowedUnits||O.allowedUnits.indexOf(M)>=0;if(!W){c(W,"The given unit '"+M+"' is not part of the allowed unit types: ["+O.allowedUnits.join(",")+"].");return"";}if(U){P=U["unitPattern-count-"+E];if(!P){P=U["unitPattern-count-other"];}c(P,"Cannot find pattern 'unitPattern-count-"+E+"' in '"+M+"'");if(!P){return"";}s=P.replace("{0}",s);}else if(!O.unitOptional){c(U,"Unit '"+M+"' is unknown");return"";}}if(sap.ui.getCore().getConfiguration().getOriginInfo()){s=new String(s);s.originInfo={source:"Common Locale Data Repository",locale:this.oLocale.toString()};}return s;};N.prototype._composeCurrencyResult=function(P,F,M,o){var s=o.minusSign;P=P.replace(/[0#.,]+/,F);if(o.showMeasure&&M){var i="\u00a4",t={"[:digit:]":/\d/,"[:^S:]":/[^\$\xA2-\xA5\u058F\u060B\u09F2\u09F3\u09FB\u0AF1\u0BF9\u0E3F\u17DB\u20A0-\u20BD\uA838\uFDFC\uFE69\uFF04\uFFE0\uFFE1\uFFE5\uFFE6]/},u=P.indexOf(i),v=u<P.length/2?"after":"before",S=this.oLocaleData.getCurrencySpacing(v),C=(v==="after"?M.charAt(M.length-1):M.charAt(0)),w,x=t[S.currencyMatch],y=t[S.surroundingMatch],I;P=P.replace(i,M);w=(v==="after"?P.charAt(u+M.length):P.charAt(u-1));if(x&&x.test(C)&&y&&y.test(w)){if(v==="after"){I=u+M.length;}else{I=u;}P=P.slice(0,I)+S.insertBetween+P.slice(I);}else if(o.negative&&v==="after"){s="\ufeff"+o.minusSign;}}else{P=P.replace(/\s*\u00a4\s*/,"");}if(o.negative){P=P.replace(/-/,s);}return P;};N.prototype.parse=function(v){var o=this.oFormatOptions,P=o.plusSign+this.oLocaleData.getLenientNumberSymbols("plusSign"),M=o.minusSign+this.oLocaleData.getLenientNumberSymbols("minusSign"),s=h(P+M),G=h(o.groupingSeparator),D=h(o.decimalSeparator),t="^\\s*(["+s+"]?(?:[0-9"+G+"]+|[0-9"+G+"]*"+D+"[0-9]*)(?:[eE][+-][0-9]+)?)\\s*$",u="^\\s*(["+s+"]?[0-9"+G+"]+)\\s*$",w=new RegExp(G,"g"),x=new RegExp(D,"g"),y=this.oLocaleData.getNumberSymbol("percentSign"),I=o.type===n.CURRENCY&&this.oLocale.getLanguage()==="en"&&this.oLocale.getRegion()==="IN",z,A,C,E,F=0,S,H;if(v===""){H=o.emptyString;if(o.parseAsString&&(o.emptyString===0||isNaN(o.emptyString))){H=o.emptyString+"";}if(o.type===n.CURRENCY||o.type===n.UNIT){return[H,undefined];}else{return H;}}E=o.type===n.PERCENT?o.pattern:this.oLocaleData.getPercentPattern();if(E.charAt(0)==="%"){t=t.slice(0,1)+"%?"+t.slice(1);}else if(E.charAt(E.length-1)==="%"){t=t.slice(0,t.length-1)+"%?"+t.slice(t.length-1);}var U;if(o.type===n.UNIT){var J;if(o.customUnits&&typeof o.customUnits==="object"){J=o.customUnits;}else{J=this.oLocaleData.getUnitFormats();}c(J,"Unit patterns cannot be loaded");if(o.allowedUnits){var K={};for(var i=0;i<o.allowedUnits.length;i++){var O=o.allowedUnits[i];K[O]=J[O];}J=K;}var Q=p(J,v);var T=false;U=Q.cldrCode;if(U.length===1){C=U[0];}else if(U.length===0){if((o.unitOptional||!o.showMeasure)&&typeof v==="string"){Q.numberValue=v;}else{c(U.length===1,"Cannot find unit for input: '"+(v)+"'");return null;}}else{c(U.length===1,"Ambiguous unit ["+U.join(", ")+"] for input: '"+(v)+"'");C=undefined;T=true;}if(o.strictParsing){if((C&&!o.showMeasure)||T){return null;}}v=Q.numberValue||v;}var V;if(o.type===n.CURRENCY){V=l({value:v,currencySymbols:this.mKnownCurrencySymbols,customCurrencyCodes:this.mKnownCurrencyCodes,duplicatedSymbols:this.mDuplicatedSymbols,customCurrenciesAvailable:!!o.customCurrencies});if(!V){return null;}if(o.strictParsing){if((o.showMeasure&&!V.currencyCode)||V.duplicatedSymbolFound){return null;}}v=V.numberValue;C=V.currencyCode;if((o.customCurrencies&&C===null)||(!o.showMeasure&&C)){return null;}}if(typeof v==="string"||v instanceof String){v=v.replace(/[\u202a\u200e\u202c\u202b\u200f]/g,"");v=v.replace(/\s/g,"");}S=d(v,this.oLocaleData,I);if(S){v=S.number;}if(o.isInteger&&!S){z=new RegExp(u);}else{z=new RegExp(t);}if(!z.test(v)){return o.type===n.CURRENCY||o.type===n.UNIT?null:NaN;}v=v.replace(w,"");var W=v.length;for(var X=0;X<W;X++){var Y=v[X];if(P.includes(Y)){v=v.replace(Y,"+");break;}else if(M.includes(Y)){v=v.replace(Y,"-");break;}}v=v.replace(/^\+/,"");if(S){v=v.replace(x,".");v=N._shiftDecimalPoint(v,Math.round(Math.log(S.factor)/Math.LN10));}if(o.isInteger){F=o.parseAsString?v:parseInt(v);}else{v=v.replace(x,".");if(v.indexOf(y)!==-1){A=true;v=v.replace(y,"");}F=o.parseAsString?v:parseFloat(v);if(A){F=N._shiftDecimalPoint(F,-2);}}if(o.parseAsString){F=N._shiftDecimalPoint(v,0);}if(o.type===n.CURRENCY||o.type===n.UNIT){return[F,C];}return F;};N.prototype.convertToDecimal=function(v){var V=""+v,o,s,D,F,E,P;if(V.indexOf("e")==-1&&V.indexOf("E")==-1){return V;}var t=V.match(/^([+-]?)((\d+)(?:\.(\d+))?)[eE]([+-]?\d+)$/);o=t[1]=="-";s=t[2].replace(/\./g,"");D=t[3]?t[3].length:0;F=t[4]?t[4].length:0;E=parseInt(t[5]);if(E>0){if(E<F){P=D+E;V=s.substr(0,P)+"."+s.substr(P);}else{V=s;E-=F;for(var i=0;i<E;i++){V+="0";}}}else{if(-E<D){P=D+E;V=s.substr(0,P)+"."+s.substr(P);}else{V=s;E+=D;for(var i=0;i>E;i--){V="0"+V;}V="0."+V;}}if(o){V="-"+V;}return V;};N.prototype.getScale=function(){if((this.oFormatOptions.style!=="short"&&this.oFormatOptions.style!=="long")||this.oFormatOptions.shortRefNumber===undefined){return;}var s=g(this.oFormatOptions.shortRefNumber,this.oFormatOptions,this.oLocaleData),S;if(s&&s.formatString){S=s.formatString.replace(r,"").replace(/'.'/g,".").trim();if(S){return S;}}};N._shiftDecimalPoint=function(v,s){if(typeof s!=="number"){return NaN;}var M="";var E=v.toString().toLowerCase().split("e");if(typeof v==="number"){s=E[1]?(+E[1]+s):s;return+(E[0]+"e"+s);}else if(typeof v==="string"){if(parseFloat(v)===0&&s>=0){return v;}var F=E[0].charAt(0);M=F==="-"?F:"";if(M){E[0]=E[0].slice(1);}v=E[0];var D=v.indexOf("."),A,i,o;if(D===-1){v=v+".";D=v.length-1;}if(E[1]){D+=(+E[1]);}A=D+s;if(A<=0){v=v.padStart(v.length-A+1,'0');A=1;}else if(A>=v.length-1){v=v.padEnd(A+1,'0');A=v.length-1;}v=v.replace(".","");i=v.substring(0,A);o=v.substring(A);i=i.replace(/^(-?)0+(\d)/,"$1$2");return M+i+(o?("."+o):"");}else{return null;}};function g(v,o,s,I){var S,K,t,C,u=o.style,P=o.precision!==undefined?o.precision:2;if(u!="short"&&u!="long"){return undefined;}for(var i=0;i<15;i++){K=Math.pow(10,i);if(f(Math.abs(v)/K,P-1)<10){break;}}t=K.toString();if(o.type===n.CURRENCY){if(I){C=e(u,t,"other",true);}else{C=s.getCurrencyFormat(u,t,"other");}}else{C=s.getDecimalFormat(u,t,"other");}if(!C||C=="0"){return undefined;}else{S={};S.key=t;S.formatString=C;var w=C.match(r);if(w){S.valueSubString=w[0];var x=S.valueSubString.indexOf(".");if(x==-1){S.decimals=0;S.magnitude=K*Math.pow(10,1-S.valueSubString.length);}else{S.decimals=S.valueSubString.length-x-1;S.magnitude=K*Math.pow(10,1-x);}}else{return undefined;}}return S;}function d(v,o,I){var s,F=1,K=10,P=o.getPluralCategories(),C,t={number:undefined,factor:F},G=function(w,K,S,x){if(x){C=e(S,K.toString(),w,true);}else{C=o.getDecimalFormat(S,K.toString(),w);}if(C){C=C.replace(/[\s\u00a0\u200F]/g,"");C=C.replace(/'.'/g,".");var y=C.match(r);if(y){var V=y[0];var U=C.replace(V,"");if(!U){return;}var z=v.indexOf(U);if(z>=0){s=v.replace(U,"");s=s.replace(/\u200F/g,"");F=K;F*=Math.pow(10,1-V.length);if(t.number===undefined||s.length<t.number.length){t.number=s;t.factor=F;}}}}};["long","short"].forEach(function(S){K=10;while(K<1e15){for(var i=0;i<P.length;i++){var u=P[i];G(u,K,S);}K=K*10;}});if(I&&!s){K=10;while(K<1e15){for(var i=0;i<P.length;i++){var u=P[i];G(u,K,"short",true);}K=K*10;}}if(!s){return;}return t;}function e(s,K,P,D){var F,o={"short":{"1000-one":"¤0000","1000-other":"¤0000","10000-one":"¤00000","10000-other":"¤00000","100000-one":"¤0 Lk","100000-other":"¤0 Lk","1000000-one":"¤00 Lk","1000000-other":"¤00 Lk","10000000-one":"¤0 Cr","10000000-other":"¤0 Cr","100000000-one":"¤00 Cr","100000000-other":"¤00 Cr","1000000000-one":"¤000 Cr","1000000000-other":"¤000 Cr","10000000000-one":"¤0000 Cr","10000000000-other":"¤0000 Cr","100000000000-one":"¤00000 Cr","100000000000-other":"¤00000 Cr","1000000000000-one":"¤0 Lk Cr","1000000000000-other":"¤0 Lk Cr","10000000000000-one":"¤00 Lk Cr","10000000000000-other":"¤00 Lk Cr","100000000000000-one":"¤0 Cr Cr","100000000000000-other":"¤0 Cr Cr"}};s="short";if(P!=="one"){P="other";}F=o[s][K+"-"+P];if(F&&D){F=F.substr(1);}return F;}function f(v,M,s){if(typeof v!=="number"){return NaN;}s=s||N.RoundingMode.HALF_AWAY_FROM_ZERO;M=parseInt(M);if(typeof s==="function"){v=s(v,M);}else{if(!M){return m[s](v);}v=N._shiftDecimalPoint(m[s](N._shiftDecimalPoint(v,M)),-M);}return v;}function h(s){return s.replace(/([.?*+^$[\]\\(){}|-])/g,"\\$1");}function j(v,P){var i=Math.floor(Math.log(Math.abs(v))/Math.LN10);return Math.max(0,P-i-1);}function p(u,v){var o={numberValue:undefined,cldrCode:[]};if(typeof v!=="string"){return o;}var i=Number.POSITIVE_INFINITY;var U,K;for(U in u){for(K in u[U]){if(K.indexOf("unitPattern")===0){var s=u[U][K];var t=s.indexOf("{0}");var C=t>-1;if(C){var P=s.substring(0,t);var w=s.substring(t+"{0}".length);var M=v.startsWith(P)&&v.endsWith(w);var x=M&&v.substring(P.length,v.length-w.length);if(x){if(x.length<i){i=x.length;o.numberValue=x;o.cldrCode=[U];}else if(x.length===i&&o.cldrCode.indexOf(U)===-1){o.cldrCode.push(U);}}}else if(s===v){o.cldrCode=[U];var y;if(K.endsWith("-zero")){y="0";}else if(K.endsWith("-one")){y="1";}else if(K.endsWith("-two")){y="2";}o.numberValue=y;return o;}}}}return o;}function k(v,C){var s="",i,o;for(var t in C){o=C[t];if(v.indexOf(o)>=0&&s.length<o.length){s=o;i=t;}}return{symbol:s,code:i};}function l(C){var v=C.value;var M=k(v,C.currencySymbols);if(!M.code){M=k(v,C.customCurrencyCodes);if(!M.code&&!C.customCurrenciesAvailable){var i=v.match(/(^[A-Z]{3}|[A-Z]{3}$)/);M.code=i&&i[0];}}if(M.code){var o=M.code.length-1;var s=M.code.charAt(o);var D;var t=/[\-\s]+/;if(/\d$/.test(s)){if(v.startsWith(M.code)){D=o+1;if(!t.test(v.charAt(D))){return undefined;}}}else if(/^\d/.test(M.code)){if(v.endsWith(M.code)){D=v.indexOf(M.code)-1;if(!t.test(v.charAt(D))){return undefined;}}}v=v.replace(M.symbol||M.code,"");}var u=false;if(C.duplicatedSymbols&&C.duplicatedSymbols[M.symbol]){M.code=undefined;u=true;b.error("The parsed currency symbol '"+M.symbol+"' is defined multiple "+"times in custom currencies.Therefore the result is not distinct.");}return{numberValue:v,currencyCode:M.code||undefined,duplicatedSymbolFound:u};}return N;});
