/*!
 * OpenUI5
 * (c) Copyright 2009-2019 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["jquery.sap.global","sap/ui/Device","sap/ui/documentation/sdk/controller/BaseController","sap/ui/model/json/JSONModel","sap/ui/documentation/sdk/controller/util/ControlsInfo","sap/m/GroupHeaderListItem","sap/ui/model/Filter","sap/ui/model/Sorter","sap/base/util/Version","sap/ui/thirdparty/jquery","sap/base/util/UriParameters","sap/ui/util/Storage","sap/ui/core/Core"],function(q,D,B,J,C,G,F,S,V,Q,U,a,b){"use strict";var c="cozy",d="compact",e="condensed";return B.extend("sap.ui.documentation.sdk.controller.ControlsMaster",{_oStorage:new a(a.Type.local),_sStorageKey:"UI5_EXPLORED_LIST_SETTINGS_FROM_1_48",_oViewSettings:{densityMode:d,themeActive:"sap_fiori_3",rtl:false},_oDefaultSettings:{densityMode:d,themeActive:"sap_fiori_3",rtl:false},_oListSettings:{filter:{},groupProperty:"category",groupDescending:false,version:V(sap.ui.version).getMajor()+"."+V(sap.ui.version).getMinor()},_mGroupFunctions:{"name":function(o){var k=o.getProperty("name").charAt(0);return{key:k,text:k};},"namespace":true,"category":true,"since":true,"formFactors":true},_sFilterValue:"",onInit:function(){var E,o,f,O=function(g){this._oView.getModel().setData({entityCount:g.entityCount,entities:g.entities});this.getModel("filter").setData(g.filter);this._toggleListItem(this._getItemToSelect(),true);}.bind(this);this._oRouter=this.getRouter();this._bNavToEntityViaList=false;this._oView=this.getView();C.loadData().then(O);E=new J();E.setSizeLimit(100000);this._oView.setModel(E);o=new J({listMode:(D.system.phone)?"None":"SingleSelectMaster",listItemType:(D.system.phone)?"Active":"Inactive"});o.setDefaultBindingMode("OneWay");this._oView.setModel(o,"viewModel");f=new J();f.setSizeLimit(100000);this.setModel(f,"filter");this._vsFilterBar=this._oView.byId("vsFilterBar");this._vsFilterLabel=this._oView.byId("vsFilterLabel");this._oRouter.getRoute("listFilter").attachPatternMatched(this._onFilterMatched,this);this._oRouter.getRoute("group").attachPatternMatched(this._onGroupMatched,this);this._oRouter.getRoute("entity").attachPatternMatched(this._onEntityMatched,this);this._oRouter.getRoute("sample").attachPatternMatched(this._onSampleMatched,this);this._oRouter.getRoute("code").attachPatternMatched(this._onSampleMatched,this);this._oRouter.getRoute("codeFile").attachPatternMatched(this._onSampleMatched,this);this._oRouter.getRoute("controls").attachPatternMatched(this._onControlsMatched,this);this._oRouter.getRoute("controlsMaster").attachPatternMatched(this._onControlsMasterMatched,this);this.LIST_SCROLL_DURATION=0;this._iDomRenderingDelay=0;this._getList().addEventDelegate({onAfterRendering:function(){setTimeout(this._scrollToSelectedListItem.bind(this),this._iDomRenderingDelay);}},this);this._oCore.attachThemeChanged(this._scrollToSelectedListItem,this);this._oCore.attachLocalizationChanged(this._onLocalizationChange,this);this._oView.addEventDelegate({onBeforeFirstShow:this.onBeforeFirstShow.bind(this)});this._oComponent=this.getOwnerComponent();this._oRootView=this.getRootView();switch(this._oComponent.getContentDensityClass()){case"sapUiSizeCompact":this._oViewSettings.densityMode=d;break;case"sapUiSizeCondensed":this._oViewSettings.densityMode=e;break;default:this._oViewSettings.densityMode=c;}this._oViewSettings.rtl=this._oCore.getConfiguration().getRTL();this._oDefaultSettings.densityMode=this._oViewSettings.densityMode;this._oDefaultSettings.rtl=this._oViewSettings.rtl;this._initListSettings();this.bus=b.getEventBus();},_viewSettingsResetOnNavigation:function(E){var r=E.getParameter("name");if(["group","entity","sample","code","code_file","controls","controlsMaster","listFilter"].indexOf(r)===-1){this._applyAppConfiguration(this._oDefaultSettings.themeActive,this._oDefaultSettings.densityMode,this._oDefaultSettings.rtl);this.getRouter().detachBeforeRouteMatched(this._viewSettingsResetOnNavigation,this);}},_initListSettings:function(){var j=this._oStorage.get(this._sStorageKey);if(j){this._oListSettings=JSON.parse(j);}},_toggleContentDensityClasses:function(o,s){switch(s){case d:o.toggleClass("sapUiSizeCompact",true).toggleClass("sapUiSizeCozy",false).toggleClass("sapUiSizeCondensed",false);break;case e:o.toggleClass("sapUiSizeCondensed",true).toggleClass("sapUiSizeCozy",false).toggleClass("sapUiSizeCompact",true);break;default:o.toggleClass("sapUiSizeCozy",true).toggleClass("sapUiSizeCondensed",false).toggleClass("sapUiSizeCompact",false);}},_applyAppConfiguration:function(t,s,r){var o,f,$,R,T,g;if(this._oViewSettings.densityMode!==s){this._toggleContentDensityClasses(Q(document.body),s);this._oViewSettings.densityMode=s;g=true;}if(this._oViewSettings.rtl!==r){this._oCore.getConfiguration().setRTL(r);this._oViewSettings.rtl=r;R=true;}if(this._oViewSettings.themeActive!==t){this._oCore.applyTheme(t);this._oViewSettings.themeActive=t;T=true;this.bus.publish("themeChanged","onDemoKitThemeChanged",{sThemeActive:t});}else if(g){this._oCore.notifyContentDensityChanged();}if(R||g||T){$=Q("#sampleFrame");if($.length>0){o=$[0].contentWindow;if(o){f=o.sap.ui.getCore();if(g){this._toggleContentDensityClasses(o.jQuery('body'),s);}if(R){f.getConfiguration().setRTL(r);}if(T){f.applyTheme(t);}else if(g){f.notifyContentDensityChanged();}}}}},_onGroupMatched:function(f){this._onMatched('#/group/',f);},_onEntityMatched:function(f){this._onMatched('#/entity/',f);},_onSampleMatched:function(f){this._onMatched('#/sample/',f);},_onMatched:function(n,E){var o=this._getList().getModel(),s=E.getParameter("arguments").entityId;this.showMasterSide();this._topicId=n+s;this._entityId=s;o.refresh();this._updateListSelection();},_onControlsMasterMatched:function(f){this.showMasterSide();if(!D.system.phone){this.getRouter().navTo("controls");}},_onFilterMatched:function(E){var f=E.getParameter("arguments").value,s;if(f){f=decodeURI(f);s=this.byId("searchField");s.setValue(f).fireLiveChange({newValue:f});setTimeout(function(){this.getSplitApp().showMaster();}.bind(this),0);if(D.system.phone){this.getRouter().navTo("controlsMaster",{});}}this._onControlsMatched(E);},_onControlsMatched:function(){this.showMasterSide();this._resetListSelection();if(D.system.desktop){setTimeout(function(){this.getView().byId("searchField").getFocusDomRef().focus();}.bind(this),0);}},_onLocalizationChange:function(E){this._iDomRenderingDelay=3000;setTimeout(function(){this._iDomRenderingDelay=0;}.bind(this),this._iDomRenderingDelay);},onNavToEntity:function(E){var i=E.getParameter("listItem"),I=(i)?i:E.getSource(),p=I.getBindingContext().getPath(),o=this.getView().getModel().getProperty(p);this._bNavToEntityViaList=true;this.getRouter().navTo("entity",{id:o.id,part:"samples"});},getGroupHeader:function(g){return new G({title:g.key,upperCase:false});},_updateListSelection:function(){var i=this._getItemToSelect();if(!i){return;}this._toggleListItem(i,true);if(!this._bNavToEntityViaList){setTimeout(this._scrollToSelectedListItem.bind(this),0);}this._bNavToEntityViaList=false;},_resetListSelection:function(){var s=this._getList().getSelectedItem();if(s){this._toggleListItem(s,false);setTimeout(this._scrollPageTo.bind(this,0,0),0);}},_toggleListItem:function(i,s){this._getList().setSelectedItem(i,s,false);},_scrollToSelectedListItem:function(){var i=this._getList().getSelectedItem();if(i){this._getPage().scrollToElement(i,this.LIST_SCROLL_DURATION);}},_scrollPageTo:function(p,i){this._getPage().scrollTo(p,i);},_getItemToSelect:function(){var l=this._getList(),E=l.getModel(),o,i,I,L=this._entityId,f=null;l.getItems().forEach(function(g){i=g.getBindingContext();if(i){I=i.getPath();o=E.getProperty(I);if(o.id===L){f=g;return false;}}});return f;},_getPage:function(){if(!this.oPage){this.oPage=this.byId("exploredMasterPage");}return this.oPage;},_getList:function(){if(!this.oList){this.oList=this.byId("exploredMasterList");}return this.oList;},onBeforeFirstShow:function(){this._updateView();},onExit:function(){this._oCore.detachThemeChanged(this._scrollToSelectedListItem,this);this._oCore.detachLocalizationChanged(this._onLocalizationChange,this);},onConfirmViewSettings:function(E){var g=E.getParameter("groupItem");this._oListSettings.filter=E.getParameter("filterCompoundKeys");this._oListSettings.groupProperty=g?g.getKey():null;this._oListSettings.groupDescending=E.getParameter("groupDescending");this._oStorage.put(this._sStorageKey,JSON.stringify(this._oListSettings));this._updateView();},handleListSettings:function(){if(!this._oVSDialog){this._oVSDialog=sap.ui.xmlfragment(this.getView().getId(),"sap.ui.documentation.sdk.view.viewSettingsDialog",this);this.getView().addDependent(this._oVSDialog);}this._oVSDialog.setSelectedFilterCompoundKeys(this._oListSettings.filter);this._oVSDialog.setSelectedGroupItem(this._oListSettings.groupProperty);this._oVSDialog.setGroupDescending(this._oListSettings.groupDescending);this._oVSDialog.open();},handleListFilter:function(E){this._sFilterValue=E.getParameter("newValue").trim();this._updateView();},_updateListBinding:function(){var f,s,g=[],h=[],i=false,j=false,l=this._oView.byId("exploredMasterList"),o=l.getBinding("items");i=true;g.push(new F("searchTags","Contains",this._sFilterValue));Q.each(this._oListSettings.filter,function(p,v){var P=[];Q.each(v,function(k,m){var O=(p==="formFactors")?"Contains":"EQ";P.push(new F(p,O,k));});i=true;g.push(new F(P,false));});if(i&&g.length===0){o.filter(g,"Application");}else if(i&&g.length>0){f=new F(g,true);o.filter(f,"Application");}if(this._oListSettings.groupProperty&&this._oListSettings.groupProperty!==this._sCurrentGroup){j=true;}else if(this._oListSettings.groupProperty&&this._oListSettings.groupDescending!==this._bCurrentlyGroupedDescending){j=true;}if(j){s=new S(this._oListSettings.groupProperty,this._oListSettings.groupDescending,this._mGroupFunctions[this._oListSettings.groupProperty]);h.push(s);h.push(new S("name",false));o.sort(h);}this._sCurrentGroup=this._oListSettings.groupProperty;this._bCurrentlyGroupedDescending=this._oListSettings.groupDescending;this._bIsViewUpdatedAtLeastOnce=true;},_updateView:function(){this._updateFilterBarDisplay();this._updateListBinding();},_updateFilterBarDisplay:function(){var f=[];Q.each(this._oListSettings.filter,function(p,v){f=f.concat(Object.keys(v));});if(f.length>0){this._vsFilterBar.setVisible(true);this._vsFilterLabel.setText(f.join(", "));}else{this._vsFilterBar.setVisible(false);}},handleSettings:function(){if(!this._oSettingsDialog){this._oSettingsDialog=new sap.ui.xmlfragment("sap.ui.documentation.sdk.view.appSettingsDialog",this);this._oView.addDependent(this._oSettingsDialog);}setTimeout(function(){var A=this._oCore.getConfiguration(),t=this._oCore.byId("ThemeSelect"),u=U.fromQuery(window.location.search).get("sap-theme"),f=this._oViewSettings.densityMode;t.setSelectedKey(u?u:A.getTheme());this._oCore.byId("RTLSwitch").setState(A.getRTL());this._oCore.byId("DensityModeSwitch").setSelectedKey(f);this._oSettingsDialog.open();}.bind(this),0);},handleCloseAppSettings:function(){this._oSettingsDialog.close();},handleSaveAppSettings:function(){var f,s=this._oCore.byId('DensityModeSwitch').getSelectedKey(),t=this._oCore.byId('ThemeSelect').getSelectedKey(),r=this._oCore.byId('RTLSwitch').getState();this._oSettingsDialog.close();if(!this._oBusyDialog){q.sap.require("sap.m.BusyDialog");f=sap.ui.require("sap/m/BusyDialog");this._oBusyDialog=new f();this.getView().addDependent(this._oBusyDialog);}this._oBusyDialog.open();setTimeout(function(){this._oBusyDialog.close();}.bind(this),1000);this._applyAppConfiguration(t,s,r);this.getRouter().attachBeforeRouteMatched(this._viewSettingsResetOnNavigation,this);}});});
