/*!
 * OpenUI5
 * (c) Copyright 2009-2019 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(['sap/ui/core/Control','sap/m/Button','sap/m/SearchField','sap/m/library'],function(C,B,S,m){"use strict";var a=C.extend("sap.ui.documentation.sdk.controls.Search",{metadata:{library:"sap.ui.documentation",properties:{isOpen:{type:"boolean",group:"Appearance",defaultValue:false},width:{type:"sap.ui.core.CSSSize",group:"Appearance",defaultValue:null}},aggregations:{_openingButton:{type:"sap.m.Button",multiple:false},_closingButton:{type:"sap.m.Button",multiple:false},_searchField:{type:"sap.m.SearchField",multiple:false}},events:{toggle:{isOpen:{type:"boolean"}},search:{parameters:{query:{type:"string"},suggestionItem:{type:"sap.m.SuggestionItem"},refreshButtonPressed:{type:"boolean"},clearButtonPressed:{type:"boolean"}}}}},renderer:{apiVersion:2,render:function(r,c){var w=c.getWidth(),o,b,s;r.openStart("div",c);r.style("width",w);r.class("sapUiDocumentationSearch");r.openEnd();if(c.getIsOpen()){s=c._lazyLoadSearchField(true);b=c._lazyLoadClosingButton(true);r.renderControl(s);r.renderControl(b);}else{o=c._lazyLoadOpeningButton(true);r.renderControl(o);}r.close("div");}}});a.prototype.onAfterRendering=function(){if(this.getIsOpen()){this._maximizeSearchField();}};a.prototype._maximizeSearchField=function(){return this._resizeSearchField("100%");};a.prototype._minimizeSearchField=function(){return this._resizeSearchField("10%");};a.prototype._resizeSearchField=function(w){return new Promise(function(r,b){var $=this.$("searchField");if(!$.length){b();}if($.css("max-width")===w){r();}$.one("webkitTransitionEnd otransitionend oTransitionEnd msTransitionEnd transitionend",function(){r();});$.css("max-width",w);}.bind(this));};a.prototype._toggleOpen=function(o){this.setIsOpen(o);this.fireToggle({isOpen:o});};a.prototype._lazyLoadOpeningButton=function(s){if(!this.getAggregation("_openingButton")){var b=new B(this.getId()+"-openingBtn",{icon:"sap-icon://search",type:m.ButtonType.Transparent,press:function(){this._toggleOpen(true);}.bind(this)});b.addStyleClass("sdkHeaderSearchButton");this.setAggregation("_openingButton",b,s);}return this.getAggregation("_openingButton");};a.prototype._lazyLoadClosingButton=function(s){if(!this.getAggregation("_closingButton")){var b=new B(this.getId()+"-closingBtn",{text:"Close",type:m.ButtonType.Transparent,press:function(){this._minimizeSearchField().then(function(){this._toggleOpen(false);}.bind(this));}.bind(this)});this.setAggregation("_closingButton",b,s);}return this.getAggregation("_closingButton");};a.prototype._lazyLoadSearchField=function(s){if(!this.getAggregation("_searchField")){var o=new S(this.getId()+"-searchField",{showSearchButton:true,search:function(e){var p=e.getParameters();p.id=this.getId();this.fireSearch(p);}.bind(this)});o.addStyleClass("sdkHeaderSearchField");this.setAggregation("_searchField",o,s);}return this.getAggregation("_searchField");};return a;});
