/*!
 * OpenUI5
 * (c) Copyright 2009-2019 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["sap/ui/core/Control","sap/ui/model/json/JSONModel","sap/ui/table/TreeTable","sap/ui/table/Column","sap/m/Toolbar","sap/m/ToolbarSpacer","sap/m/Button","sap/m/SearchField","sap/m/Text","sap/m/RatingIndicator","./TableRenderer"],function(C,J,T,a,b,c,B,S,d,R){"use strict";var t=C.extend("sap.ui.dt.enablement.report.Table",{metadata:{properties:{data:{type:"object"}},aggregations:{_table:{type:"sap.ui.table.TreeTable",hidden:true,multiple:false}}},init:function(){this.setAggregation("_table",this._createTable());},exit:function(){clearTimeout(this._iFilterTimeout);this.setData(null);},setData:function(D){if(this._oModel){this._oModel.destroy();delete this._oModel;}if(D){this._oModel=new J(D);this._getTable().setModel(this._oModel);}else{this._getTable().setModel(null);}this.setProperty("data",D);},filter:function(f){var m=this._getTable().getModel();if(m){if(f.length>0){var D=this.getData();var F=D.children.filter(function(e){if(f.indexOf("status=")!==-1){return e.status.value===f.substring(f.indexOf("=")+1);}return e.name.toLowerCase().indexOf(f.toLowerCase())!==-1;});m.setData(F);}else{m.setData(this.getData());}}},_createTable:function(){var t=new T(this.getId()+"--table",{selectionMode:"MultiToggle",visibleRowCount:20,enableSelectAll:false,ariaLabelledBy:"title",toolbar:this._createToolbar(),rows:"{path:'/', parameters: {arrayNames:['children']}}",columns:[this._createTextColumn("name","Name","{name}"),this._createRatingIndicatorColumn("value","Status Values","{status/value}","{status/text} ({status/value})"),this._createTextColumn("status","Status","{status/text}"),this._createTextColumn("message","Message","{message}")]});return t;},_createToolbar:function(){return new b(this.getId()+"--toolbar",{content:[new c(this.getId()+"--toolbar-spacer"),new B(this.getId()+"--toolbar-collapse-button",{text:"Collapse all",press:this._onCollapseAll.bind(this)}),new B(this.getId()+"--toolbar-expand-button",{text:"Expand",press:this._onExpandSecondLevel.bind(this)}),new S(this.getId()+"--toolbar-search-field",{liveChange:this._onSearch.bind(this)})]});},_onSearch:function(e){var f=e.getParameter('newValue');clearTimeout(this._iFilterTimeout);this._iFilterTimeout=setTimeout(function(){this.filter(f);}.bind(this),100);},_createTextColumn:function(i,s,r){return this._createColumn(i,s,new d({text:r}));},_createRatingIndicatorColumn:function(i,s,r,e){return this._createColumn(i,s,new R({maxValue:3,value:r,enabled:false,tooltip:e}));},_createColumn:function(i,s,o){return new a(this.getId()+"--table-column-"+i,{label:s,width:"13em",template:o});},_getTable:function(){return this.getAggregation("_table");},_onCollapseAll:function(){var t=this._getTable();t.collapseAll();},_onExpandSecondLevel:function(){var t=this._getTable();t.expandToLevel(2);}});return t;});
