/*
 * ! OpenUI5
 * (c) Copyright 2009-2019 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["sap/ui/fl/FakeLrepConnector","sap/ui/fl/LrepConnector","sap/ui/fl/Cache","sap/ui/fl/ChangePersistenceFactory","sap/ui/fl/LayerUtils"],function(F,L,C,a,b){"use strict";return function(f){c._oBackendInstances={};function c(S,i){this.mSettings=Object.assign({isKeyUser:true,isAtoAvailable:false,isProductiveSystem:false},S);this.mInfo=Object.assign({isResetEnabled:false,isPublishEnabled:false},i);this._iChangeCounter=0;}Object.assign(c.prototype,F.prototype);c.prototype.create=function(v){var r;if(Array.isArray(v)){r=v.map(function(m){return this._saveChange(m);}.bind(this));}else{r=this._saveChange(v);}return Promise.resolve({response:r,status:'success'});};c.prototype._saveChange=function(m){var n;if(!m.creation){n=Date.now()+this._iChangeCounter++;m.creation=new Date(n).toISOString();}f.saveChange(m.fileName,m);return m;};c.prototype.update=function(m){return Promise.resolve({response:this._saveChange(m),status:'success'});};c.prototype.send=function(){return F.prototype.send.apply(this,arguments);};c.prototype.resetChanges=function(p){function _(o){var D=true;if(p.aSelectorIds){if(o.selector){D=p.aSelectorIds.indexOf(o.selector.id)>-1;}else{D=false;}}if(D&&p.aChangeTypes){D=p.aChangeTypes.indexOf(o.changeType)>-1;}return D;}return this.send(this._getUrlPrefix(),"DELETE").then(function(){var r=[];f.getChanges(p.sReference,p.sLayer).forEach(function(o){if(_(o)){r.push({layer:o.layer,name:o.fileName,namespace:o.namespace,type:o.fileType});f.deleteChange(o);}});return{response:r,status:"success"};});};c.prototype.deleteChange=function(o){f.deleteChange(o);return Promise.resolve({response:undefined,status:"nocontent"});};c.prototype.deleteChanges=function(){f.deleteChanges();return Promise.resolve({response:undefined,status:"nocontent"});};c.prototype.loadChanges=function(m,p,B){var h=f.getChanges(m.name);if(B){h=h.concat(B);}return new Promise(function(r,i){var R={};if(this.mSettings.sInitialComponentJsonPath){jQuery.getJSON(this.mSettings.sInitialComponentJsonPath).done(function(o){R={changes:o,componentClassName:m.name};r(R);}).fail(function(j){i(j);});}else{r(R);}}.bind(this)).then(function(r){var v=[];var i=[];var j=[];var k=[];h.forEach(function(o){if(o.fileType==="ctrl_variant"&&o.variantManagementReference){v.push(o);}else if(o.fileType==="ctrl_variant_change"){i.push(o);}else if(o.fileType==="ctrl_variant_management_change"){j.push(o);}else{k.push(o);}});r=this._createChangesMap(r,v);r=this._addChangesToMap(r,k,i,j);r=this._sortChanges(r);r=this._assignVariantReferenceChanges(r);r.changes.contexts=[];r.changes.settings=this.mSettings;r.componentClassName=m.name;return r;}.bind(this));};c.prototype._createChangesMap=function(r,v){if(!r||!r.changes){r={changes:{}};}if(!r.changes.changes){r.changes.changes=[];}if(!r.changes.variantSection){r.changes.variantSection={};}var h=function(E,n){return E.some(function(o){return o.content.fileName===n.fileName;});};var V={};v.forEach(function(o){V=r.changes.variantSection[o.variantManagementReference];if(!V){var S=this._fakeStandardVariant(o.variantManagementReference);V=this._getVariantManagementStructure([this._getVariantStructure(S,[],{}),this._getVariantStructure(o,[],{})],{});r.changes.variantSection[o.variantManagementReference]=V;}else if(!h(V.variants,o)){V.variants.push(this._getVariantStructure(o,[],{}));}}.bind(this));return r;};c.prototype._getVariantStructure=function(v,h,V){return{content:v,controlChanges:h,variantChanges:V};};c.prototype._getVariantManagementStructure=function(v,V){return{variants:v,variantManagementChanges:V};};function s(A){A.sort(d);}function d(o,h){var l=b.getLayerIndex(o.layer);var i=b.getLayerIndex(h.layer);if(l!==i){return l-i;}return new Date(o.creation)-new Date(h.creation);}c.prototype._sortChanges=function(r){if(r.changes.changes){s(r.changes.changes);}e(r,function(v){Object.keys(v.variantManagementChanges||{}).forEach(function(V){s(v.variantManagementChanges[V]);});});g(r,function(v){Object.keys(v.variantChanges).forEach(function(V){s(v.variantChanges[V]);});s(v.controlChanges);});return r;};function e(r,h){Object.keys(r.changes.variantSection).forEach(function(v){h(r.changes.variantSection[v]);});}function g(r,h){e(r,function(v){v.variants.forEach(h);});}c.prototype._assignVariantReferenceChanges=function(r){g(r,function(v){var V=v.content.variantReference;var E=v.controlChanges;if(V){E=this._getReferencedChanges(r,v).concat(E);}v.controlChanges=E;}.bind(this));return r;};function w(r,v,V,h){r.changes.variantSection[v].variants.some(function(o){if(o.content.fileName===V){h(o);return true;}});}c.prototype._getReferencedChanges=function(r,o){var R=[];w(r,o.content.variantManagementReference,o.content.variantReference,function(v){R=v.controlChanges.filter(function(h){return b.compareAgainstCurrentLayer(h.layer,o.layer)===-1;});if(v.content.variantReference){R=R.concat(this._getReferencedChanges(r,v));}}.bind(this));return R;};c.prototype._addChangesToMap=function(r,h,i,j){var A=function(r,V,o){w(r,V,o.variantReference,function(m){m.controlChanges.push(o);});};var k=function(r,V,o){w(r,V,o.selector.id,function(m){if(!m.variantChanges[o.changeType]){m.variantChanges[o.changeType]=[];}m.variantChanges[o.changeType].push(o);});};function l(r,V){return Object.keys(r.changes.variantSection).some(function(m){var n=r.changes.variantSection[m].variants;return n.some(function(o){return o.content.fileName===V;});});}var v={};j.forEach(function(V){var m=V.selector.id;if(!r.changes.variantSection[m]){r.changes.variantSection[m]=this._getVariantManagementStructure([this._getVariantStructure(this._fakeStandardVariant(m),[],{})],{});}v=r.changes.variantSection[m].variantManagementChanges;if(!v[V.changeType]){v[V.changeType]=[];}v[V.changeType].push(V);}.bind(this));h.forEach(function(o){if(!o.variantReference){r.changes.changes.push(o);}else if(!l(r,o.variantReference)){r.changes.variantSection[o.variantReference]=this._getVariantManagementStructure([this._getVariantStructure(this._fakeStandardVariant(o.variantReference),[o],{})],{});}else{Object.keys(r.changes.variantSection).forEach(function(V){A(r,V,o);});}}.bind(this));i.forEach(function(V){if(!l(r,V.selector.id)){var m={};m[V.changeType]=[V];r.changes.variantSection[V.selector.id]=this._getVariantManagementStructure([this._getVariantStructure(this._fakeStandardVariant(V.selector.id),[],m)],{});}else{Object.keys(r.changes.variantSection).forEach(function(n){k(r,n,V);});}}.bind(this));return r;};c.prototype._fakeStandardVariant=function(v){return{fileName:v,fileType:"ctrl_variant",variantManagementReference:v,variantReference:"",content:{title:sap.ui.getCore().getLibraryResourceBundle("sap.ui.fl").getText("STANDARD_VARIANT_TITLE")}};};c.enableFakeConnector=function(S,A,h,i){S=S||{};function r(){c.enableFakeConnector.original=L.createConnector;L.createConnector=function(){if(!c._oFakeInstance){c._oFakeInstance=new c(S);}var j=f.getChanges(A);this.mInfo={isResetEnabled:j.length>0,isPublishEnabled:j.length>0};c._oFakeInstance.setInfo(this.mInfo);return c._oFakeInstance;};}if(A&&h){var o=a.getChangePersistenceForComponent(A,h);if(!(o._oConnector instanceof c)){if(!i){c.clearCacheAndResetVariants(A,h,o);}if(!c._oBackendInstances[A]){c._oBackendInstances[A]={};}c._oBackendInstances[A][h]=o._oConnector;o._oConnector=new c(S);}r();return;}if(!i){C.clearEntries();}if(c.enableFakeConnector.original){return;}r();};c.disableFakeConnector=function(A,h){function r(){if(c.enableFakeConnector.original){L.createConnector=c.enableFakeConnector.original;c.enableFakeConnector.original=undefined;c._oFakeInstance=undefined;}}if(A&&h){var o=a.getChangePersistenceForComponent(A,h);if(!(o._oConnector instanceof L)){c.clearCacheAndResetVariants(A,h,o);if(c._oBackendInstances[A]&&c._oBackendInstances[A][h]){o._oConnector=c._oBackendInstances[A][h];c._oBackendInstances[A][h]=undefined;}}r();return;}C.clearEntries();r();};c.clearCacheAndResetVariants=function(h,A,o){C.clearEntry(h,A);o.resetVariantMap(true);};return c;};},true);
