//@ui5-bundle sap/ui/fl/library-preload.js
/*
 * ! OpenUI5
 * (c) Copyright 2009-2019 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine('sap/ui/fl/ControlPersonalizationAPI',["sap/ui/fl/Utils","sap/ui/fl/LayerUtils","sap/ui/fl/registry/ChangeRegistry","sap/ui/fl/FlexControllerFactory","sap/ui/core/util/reflection/JsControlTreeModifier","sap/ui/core/Element","sap/ui/base/ManagedObject","sap/base/util/includes","sap/ui/fl/variants/VariantManagement","sap/ui/fl/apply/_internal/variants/URLHandler","sap/ui/core/Component","sap/base/Log","sap/base/util/merge","sap/ui/thirdparty/jquery"],function(U,L,C,F,J,E,M,i,V,a,b,c,m,q){"use strict";var d={_determineParameters:function(o){var A=U.getAppComponentForControl(o);var f=F.createForControl(A);var r=A.getRootControl();var v=A.getModel(U.VARIANT_MODEL_NAME);var p={rootControl:r,variantModel:v,variantManagement:{},flexController:f};var e;var g;q.makeArray(p.rootControl.$().find(".sapUiFlVarMngmt")).map(function(h){e=sap.ui.getCore().byId(h.id);if(e.getMetadata().getName()==="sap.ui.fl.variants.VariantManagement"){g=e.getFor();g.forEach(function(s){p.variantManagement[s]=p.variantModel.getLocalId(h.id,A);});}});return p;},_getVariantManagement:function(o,p){p=p||this._determineParameters(o);var f=function(o){if(!p.variantManagement[o.getId()]&&o.getParent()&&o.getId()!==p.rootControl.getId()){return f(o.getParent());}else if(!o.getParent()||o.getId()===p.rootControl.getId()){return p.variantManagement[o.getId()]||"";}return p.variantManagement[o.getId()];};return f(o);},clearVariantParameterInURL:function(o){var u;var A=U.getAppComponentForControl(o);var v=A instanceof b?A.getModel(U.VARIANT_MODEL_NAME):undefined;if(!v){c.warning("Variant model could not be found on the provided control");}if(o instanceof V){var s=v.getLocalId(o.getId(),A);var e=a.removeURLParameterForVariantManagement({model:v,vmReference:s});u=e.parameters;}a.update({parameters:u||[],updateURL:true,updateHashEntry:!!v,model:v||{},silent:!v});},activateVariant:function(e,v){var o;return Promise.resolve().then(function(){if(typeof e==='string'||e instanceof String){o=b.get(e);if(!(o instanceof b)){o=sap.ui.getCore().byId(e);if(!(o instanceof E)){throw new Error("No valid component or control found for the provided ID");}}}else if(e instanceof b||e instanceof E){o=e;}var A=U.getAppComponentForControl(o);if(!A){throw new Error("A valid variant management control or component (instance or ID) should be passed as parameter");}var f=A.getModel(U.VARIANT_MODEL_NAME);if(!f){throw new Error("No variant management model found for the passed control or application component");}var s=f.getVariantManagementReference(v).variantManagementReference;if(!s){throw new Error("A valid control or component, and a valid variant/ID combination are required");}return f.updateCurrentVariant(s,v,A);})["catch"](function(f){c.error(f);return Promise.reject(f);});},_checkChangeSpecificData:function(o,l){return Promise.resolve().then(function(){if(!o.changeSpecificData){throw new Error("No changeSpecificData available");}if(!o.changeSpecificData.changeType){throw new Error("No valid changeType");}if(!(o.selectorControl instanceof E)){throw new Error("No valid selectorControl");}var s=o.selectorControl.getMetadata().getName();var e=C.getInstance();return e.getChangeHandler(o.changeSpecificData.changeType,s,o.selectorControl,J,l);}).then(function(e){if(!e){throw new Error("No valid ChangeHandler");}});},addPersonalizationChanges:function(p){var s=[];var l=L.getCurrentLayer(true);var P=[];p.controlChanges.forEach(function(o){var e={};Object.assign(e,{developerMode:false,layer:l});function f(){return this._checkChangeSpecificData(o,l).then(function(){var g=this._determineParameters(o.selectorControl);if(!p.ignoreVariantManagement){if(!o.changeSpecificData.variantReference){var v=this._getVariantManagement(o.selectorControl,g);if(v){var h=g.variantModel.oData[v].currentVariant;o.changeSpecificData.variantReference=h;}}}else{delete o.changeSpecificData.variantReference;}return g.flexController.createAndApplyChange(Object.assign(e,o.changeSpecificData),o.selectorControl);}.bind(this)).then(function(A){s.push(A);}).catch(function(g){return Promise.reject({change:o,message:g.message});});}P.push(f.bind(this));}.bind(this));return U.execPromiseQueueSequentially(P).then(function(){return s;});},isPersonalized:function(e,f){if(!e||e.length===0){return this._reject("At least one control ID has to be provided as a parameter");}var A=e[0].appComponent||U.getAppComponentForControl(e[0]);if(!A){return this._reject("App Component could not be determined");}var I=e.map(function(g){return g.id||g.getId();});var o=F.createForControl(A);return o.getComponentChanges({currentLayer:"USER",includeCtrlVariants:true}).then(function(g){return g.filter(this._filterBySelectors.bind(this,A,I)).filter(this._filterByChangeType.bind(this,f)).some(this._ifValidFileType);}.bind(this));},_reject:function(s){c.error(s);return Promise.reject(s);},_filterBySelectors:function(A,I,o){var s=o.getSelector();var e=J.getControlIdBySelector(s,A);return i(I,e);},_filterByChangeType:function(e,o){return(Array.isArray(e)&&e.length>0)?i(e,o.getChangeType()):true;},_ifValidFileType:function(o){return o.getFileType()==="change";},resetChanges:function(e,f){if(!e||e.length===0){return this._reject("At least one control ID has to be provided as a parameter");}var A=e[0].appComponent||U.getAppComponentForControl(e[0]);if(!A){return this._reject("App Component could not be determined");}var s=e.map(function(v){var g=v.id||v.getId();var l=A.getLocalId(g);return l||g;});var o=F.createForControl(A);return o.resetChanges("USER",undefined,A,s,f);},saveChanges:function(e,o){if(!(o instanceof M)){var s="A valid sap.ui.base.ManagedObject instance is required as a parameter";c.error(s);return Promise.reject(s);}var p=d._determineParameters(o);var v=Object.keys(p.variantManagement).reduce(function(r,f){return r.concat([p.variantManagement[f]]);},[]);return p.flexController.saveSequenceOfDirtyChanges(e).then(function(r){p.variantModel.checkDirtyStateForControlModels(v);return r;});},hasVariantManagement:function(o){try{return!!this._getVariantManagement(o);}catch(e){c.error(e.message);return false;}}};return d;},true);
sap.ui.predefine('sap/ui/fl/FakeLrepConnectorLocalStorage',["sap/ui/fl/FakeLrepConnectorStorage","sap/ui/fl/FakeLrepLocalStorage"],function(F,a){"use strict";return F(a);},true);
sap.ui.predefine('sap/ui/fl/FakeLrepConnectorSessionStorage',["sap/ui/fl/FakeLrepConnectorStorage","sap/ui/fl/FakeLrepSessionStorage"],function(F,a){"use strict";return F(a);},true);
sap.ui.predefine('sap/ui/fl/FakeLrepConnectorStorage',["sap/ui/fl/FakeLrepConnector","sap/ui/fl/LrepConnector","sap/ui/fl/Cache","sap/ui/fl/ChangePersistenceFactory","sap/ui/fl/LayerUtils"],function(F,L,C,a,b){"use strict";return function(f){c._oBackendInstances={};function c(S,i){this.mSettings=Object.assign({isKeyUser:true,isAtoAvailable:false,isProductiveSystem:false},S);this.mInfo=Object.assign({isResetEnabled:false,isPublishEnabled:false},i);this._iChangeCounter=0;}Object.assign(c.prototype,F.prototype);c.prototype.create=function(v){var r;if(Array.isArray(v)){r=v.map(function(m){return this._saveChange(m);}.bind(this));}else{r=this._saveChange(v);}return Promise.resolve({response:r,status:'success'});};c.prototype._saveChange=function(m){var n;if(!m.creation){n=Date.now()+this._iChangeCounter++;m.creation=new Date(n).toISOString();}f.saveChange(m.fileName,m);return m;};c.prototype.update=function(m){return Promise.resolve({response:this._saveChange(m),status:'success'});};c.prototype.send=function(){return F.prototype.send.apply(this,arguments);};c.prototype.resetChanges=function(p){function _(o){var D=true;if(p.aSelectorIds){if(o.selector){D=p.aSelectorIds.indexOf(o.selector.id)>-1;}else{D=false;}}if(D&&p.aChangeTypes){D=p.aChangeTypes.indexOf(o.changeType)>-1;}return D;}return this.send(this._getUrlPrefix(),"DELETE").then(function(){var r=[];f.getChanges(p.sReference,p.sLayer).forEach(function(o){if(_(o)){r.push({layer:o.layer,name:o.fileName,namespace:o.namespace,type:o.fileType});f.deleteChange(o);}});return{response:r,status:"success"};});};c.prototype.deleteChange=function(o){f.deleteChange(o);return Promise.resolve({response:undefined,status:"nocontent"});};c.prototype.deleteChanges=function(){f.deleteChanges();return Promise.resolve({response:undefined,status:"nocontent"});};c.prototype.loadChanges=function(m,p,B){var h=f.getChanges(m.name);if(B){h=h.concat(B);}return new Promise(function(r,i){var R={};if(this.mSettings.sInitialComponentJsonPath){jQuery.getJSON(this.mSettings.sInitialComponentJsonPath).done(function(o){R={changes:o,componentClassName:m.name};r(R);}).fail(function(j){i(j);});}else{r(R);}}.bind(this)).then(function(r){var v=[];var i=[];var j=[];var k=[];h.forEach(function(o){if(o.fileType==="ctrl_variant"&&o.variantManagementReference){v.push(o);}else if(o.fileType==="ctrl_variant_change"){i.push(o);}else if(o.fileType==="ctrl_variant_management_change"){j.push(o);}else{k.push(o);}});r=this._createChangesMap(r,v);r=this._addChangesToMap(r,k,i,j);r=this._sortChanges(r);r=this._assignVariantReferenceChanges(r);r.changes.contexts=[];r.changes.settings=this.mSettings;r.componentClassName=m.name;return r;}.bind(this));};c.prototype._createChangesMap=function(r,v){if(!r||!r.changes){r={changes:{}};}if(!r.changes.changes){r.changes.changes=[];}if(!r.changes.variantSection){r.changes.variantSection={};}var h=function(E,n){return E.some(function(o){return o.content.fileName===n.fileName;});};var V={};v.forEach(function(o){V=r.changes.variantSection[o.variantManagementReference];if(!V){var S=this._fakeStandardVariant(o.variantManagementReference);V=this._getVariantManagementStructure([this._getVariantStructure(S,[],{}),this._getVariantStructure(o,[],{})],{});r.changes.variantSection[o.variantManagementReference]=V;}else if(!h(V.variants,o)){V.variants.push(this._getVariantStructure(o,[],{}));}}.bind(this));return r;};c.prototype._getVariantStructure=function(v,h,V){return{content:v,controlChanges:h,variantChanges:V};};c.prototype._getVariantManagementStructure=function(v,V){return{variants:v,variantManagementChanges:V};};function s(A){A.sort(d);}function d(o,h){var l=b.getLayerIndex(o.layer);var i=b.getLayerIndex(h.layer);if(l!==i){return l-i;}return new Date(o.creation)-new Date(h.creation);}c.prototype._sortChanges=function(r){if(r.changes.changes){s(r.changes.changes);}e(r,function(v){Object.keys(v.variantManagementChanges||{}).forEach(function(V){s(v.variantManagementChanges[V]);});});g(r,function(v){Object.keys(v.variantChanges).forEach(function(V){s(v.variantChanges[V]);});s(v.controlChanges);});return r;};function e(r,h){Object.keys(r.changes.variantSection).forEach(function(v){h(r.changes.variantSection[v]);});}function g(r,h){e(r,function(v){v.variants.forEach(h);});}c.prototype._assignVariantReferenceChanges=function(r){g(r,function(v){var V=v.content.variantReference;var E=v.controlChanges;if(V){E=this._getReferencedChanges(r,v).concat(E);}v.controlChanges=E;}.bind(this));return r;};function w(r,v,V,h){r.changes.variantSection[v].variants.some(function(o){if(o.content.fileName===V){h(o);return true;}});}c.prototype._getReferencedChanges=function(r,o){var R=[];w(r,o.content.variantManagementReference,o.content.variantReference,function(v){R=v.controlChanges.filter(function(h){return b.compareAgainstCurrentLayer(h.layer,o.layer)===-1;});if(v.content.variantReference){R=R.concat(this._getReferencedChanges(r,v));}}.bind(this));return R;};c.prototype._addChangesToMap=function(r,h,i,j){var A=function(r,V,o){w(r,V,o.variantReference,function(m){m.controlChanges.push(o);});};var k=function(r,V,o){w(r,V,o.selector.id,function(m){if(!m.variantChanges[o.changeType]){m.variantChanges[o.changeType]=[];}m.variantChanges[o.changeType].push(o);});};function l(r,V){return Object.keys(r.changes.variantSection).some(function(m){var n=r.changes.variantSection[m].variants;return n.some(function(o){return o.content.fileName===V;});});}var v={};j.forEach(function(V){var m=V.selector.id;if(!r.changes.variantSection[m]){r.changes.variantSection[m]=this._getVariantManagementStructure([this._getVariantStructure(this._fakeStandardVariant(m),[],{})],{});}v=r.changes.variantSection[m].variantManagementChanges;if(!v[V.changeType]){v[V.changeType]=[];}v[V.changeType].push(V);}.bind(this));h.forEach(function(o){if(!o.variantReference){r.changes.changes.push(o);}else if(!l(r,o.variantReference)){r.changes.variantSection[o.variantReference]=this._getVariantManagementStructure([this._getVariantStructure(this._fakeStandardVariant(o.variantReference),[o],{})],{});}else{Object.keys(r.changes.variantSection).forEach(function(V){A(r,V,o);});}}.bind(this));i.forEach(function(V){if(!l(r,V.selector.id)){var m={};m[V.changeType]=[V];r.changes.variantSection[V.selector.id]=this._getVariantManagementStructure([this._getVariantStructure(this._fakeStandardVariant(V.selector.id),[],m)],{});}else{Object.keys(r.changes.variantSection).forEach(function(n){k(r,n,V);});}}.bind(this));return r;};c.prototype._fakeStandardVariant=function(v){return{fileName:v,fileType:"ctrl_variant",variantManagementReference:v,variantReference:"",content:{title:sap.ui.getCore().getLibraryResourceBundle("sap.ui.fl").getText("STANDARD_VARIANT_TITLE")}};};c.enableFakeConnector=function(S,A,h,i){S=S||{};function r(){c.enableFakeConnector.original=L.createConnector;L.createConnector=function(){if(!c._oFakeInstance){c._oFakeInstance=new c(S);}var j=f.getChanges(A);this.mInfo={isResetEnabled:j.length>0,isPublishEnabled:j.length>0};c._oFakeInstance.setInfo(this.mInfo);return c._oFakeInstance;};}if(A&&h){var o=a.getChangePersistenceForComponent(A,h);if(!(o._oConnector instanceof c)){if(!i){c.clearCacheAndResetVariants(A,h,o);}if(!c._oBackendInstances[A]){c._oBackendInstances[A]={};}c._oBackendInstances[A][h]=o._oConnector;o._oConnector=new c(S);}r();return;}if(!i){C.clearEntries();}if(c.enableFakeConnector.original){return;}r();};c.disableFakeConnector=function(A,h){function r(){if(c.enableFakeConnector.original){L.createConnector=c.enableFakeConnector.original;c.enableFakeConnector.original=undefined;c._oFakeInstance=undefined;}}if(A&&h){var o=a.getChangePersistenceForComponent(A,h);if(!(o._oConnector instanceof L)){c.clearCacheAndResetVariants(A,h,o);if(c._oBackendInstances[A]&&c._oBackendInstances[A][h]){o._oConnector=c._oBackendInstances[A][h];c._oBackendInstances[A][h]=undefined;}}r();return;}C.clearEntries();r();};c.clearCacheAndResetVariants=function(h,A,o){C.clearEntry(h,A);o.resetVariantMap(true);};return c;};},true);
sap.ui.predefine('sap/ui/fl/FakeLrepLocalStorage',["sap/ui/fl/FakeLrepStorage"],function(F){"use strict";return F(window.localStorage);},true);
sap.ui.predefine('sap/ui/fl/FakeLrepSessionStorage',["sap/ui/fl/FakeLrepStorage"],function(F){"use strict";return F(window.sessionStorage);},true);
sap.ui.predefine('sap/ui/fl/FakeLrepStorage',function(){"use strict";return function(s){var F="sap.ui.fl.change";var a="sap.ui.fl.variant";var b={};b.setStorage=function(n){s=n;};b.createChangeKey=function(i){if(i){return F+"."+i;}};b.createVariantKey=function(i){if(i){return a+"."+i;}};b.forEachLrepChangeInLocalStorage=function(p){var k=Object.keys(s);k.forEach(function(K){if(K.includes(F)||K.includes(a)){p(K);}});};b.getChange=function(i){if(i){var c=s.getItem(this.createChangeKey(i));if(!c){c=s.getItem(this.createVariantKey(i));}return JSON.parse(c);}};b.getChanges=function(r,l){var c=[];var C;this.forEachLrepChangeInLocalStorage(function(k){C=JSON.parse(s[k]);var S=C.reference===r||C.reference+".Component"===r;var d=C.layer===l;if(r&&!S||l&&!d){return;}c.push(C);});return c;};b.getNumChanges=function(){var c=0;this.forEachLrepChangeInLocalStorage(function(){c++;});return c;};b._aModifyCallbacks=[];b.attachModifyCallback=function(c){this._aModifyCallbacks.push(c);};b.detachModifyCallback=function(c){var i=this._aModifyCallbacks.indexOf(c);if(i!==-1){this._aModifyCallbacks.splice(i,1);}};b._callModifyCallbacks=function(m){this._aModifyCallbacks.forEach(function(c){c(m);});};b.deleteChange=function(f){if(f&&f.fileName){s.removeItem(this.createChangeKey(f.fileName));s.removeItem(this.createVariantKey(f.fileName));}this._callModifyCallbacks("delete");};b.deleteChanges=function(){this.forEachLrepChangeInLocalStorage(function(k){s.removeItem(k);});this._callModifyCallbacks("delete");};b.saveChange=function(i,c){var C;var d;if(i&&c){if(c.fileType==="ctrl_variant"&&c.variantManagementReference){C=this.createVariantKey(i);}else{C=this.createChangeKey(i);}d=JSON.stringify(c);s.setItem(C,d);}this._callModifyCallbacks("save");};return b;};},true);
sap.ui.predefine('sap/ui/fl/apply/_internal/ChangesController',["sap/ui/fl/FlexControllerFactory","sap/ui/fl/Utils"],function(O,F){"use strict";var C={getFlexControllerInstance:function(s,a){if(typeof s==="string"){return O.create(s,a);}var m=s.appComponent||s;return O.createForControl(m);},getDescriptorFlexControllerInstance:function(s){if(typeof s.appId==="string"){return O.create(s.appId,s.appVersion);}var a=s.appComponent||s;var A=F.getAppDescriptorComponentObjectForControl(a);return O.create(A.name,A.version);},getAppComponentForSelector:function(s){return s.appComponent||F.getAppComponentForControl(s);}};return C;},true);
sap.ui.predefine('sap/ui/fl/apply/_internal/Connector',["sap/ui/fl/apply/_internal/connectors/Utils","sap/ui/fl/apply/_internal/ConnectorResultMerger","sap/ui/fl/apply/_internal/ConnectorResultDisassembler"],function(A,C,a){"use strict";
function l(p,g){var h=g.map(function(o){var i=Object.assign(p,{url:o.url});return o.connectorModule.loadFlexData(i).catch(A.logAndResolveDefault.bind(undefined,A.getEmptyFlexDataResponse(),o,"loadFlexData"));});return Promise.all(h);}
function f(r){var F=[];r.forEach(function(R){if(Array.isArray(R)){F=F.concat(R);}else{F.push(R);}});return F;}
function c(r){return r.some(function(R){return R.variants&&R.variants.length>0||R.variantChanges&&R.variantChanges.length>0||R.variantDependentControlChanges&&R.variantDependentControlChanges.length>0||R.variantManagementChanges&&R.variantManagementChanges.length>0;});}
function b(r){var v=0;r.forEach(function(R){if(R.variantSection&&Object.keys(R.variantSection).length>0){v++;}});return v;}
function d(r){var D=[];var R=c(r);var n=b(r);var v=!R&&n<=1;if(v){D=r;}else{D=r.map(function(o){return o.variantSection?a.disassemble(o):o;});}return{responses:D,variantSectionSufficient:v};}
var e={};
e.loadFlexData=function(p){if(!p||!p.reference){return Promise.reject("loadFlexData: No reference was provided.");}return A.getApplyConnectors().then(l.bind(this,p)).then(f).then(d).then(C.merge);};
return e;},true);
sap.ui.predefine('sap/ui/fl/apply/_internal/ConnectorResultDisassembler',[],function(){"use strict";return{disassemble:function(r){return r;}};});
sap.ui.predefine('sap/ui/fl/apply/_internal/ConnectorResultMerger',["sap/base/util/merge"],function(m){"use strict";
function f(r){var v={};r.some(function(R){if(R.variantSection&&Object.keys(R.variantSection).length>0){v=R.variantSection;return true;}});return v;}
function c(){return{variantManagementChanges:{},variants:[]};}
function a(v,V){var r=v[V];if(!r){r=C._createStandardVariant(V);v[V]=r;}return r;}
function g(r){if(!r){return[];}return r.controlChanges.map(function(o){return o;});}
function b(v,V){var o=m({},v);V.forEach(function(p){var s=p.variantReference;var r;if(s){r=a(o,s);}o[p.fileName]={content:p,controlChanges:g(r),variantChanges:{}};});return o;}
function d(v,V){var o=m({},v);V.forEach(function(p){o[p.variantReference]=o[p.variantReference]||C._createStandardVariant(p.variantReference);o[p.variantReference].controlChanges.push(p);});return o;}
function e(v,V){var o=m({},v);V.forEach(function(p){o[p.selector.id]=o[p.selector.id]||C._createStandardVariant(p.selector.id);var q=o[p.selector.id].variantChanges[p.changeType]||[];q.push(p);o[p.selector.id].variantChanges[p.changeType]=q;});return o;}
function h(r,v){var R=m({},r);Object.keys(v).forEach(function(V){var o=v[V];var s=o.content.variantManagementReference;if(!R.variantSection[s]){R.variantSection[s]=c();}R.variantSection[s].variants.push(o);});return R;}
function i(r,v){var R=m({},r);v.forEach(function(o){var V=o.selector.id;if(!R.variantSection[V]){R.variantSection[V]=c();}var s=o.changeType;if(!R.variantSection[V].variantManagementChanges[s]){R.variantSection[V].variantManagementChanges[s]=[];}R.variantSection[V].variantManagementChanges[s].push(o);});return R;}
function j(r){var R=m({},r);Object.keys(R.variantSection).forEach(function(v){var V=R.variantSection[v];var s=V.variants.findIndex(function(o){return o.content.fileName===v;});var S;if(s===-1){S=C._createStandardVariant(v);}else{S=V.variants[s];V.variants.splice(s,1);}V.variants.unshift(S);});return R;}
function k(r){var v=[];r.forEach(function(R){v=v.concat(R.variantManagementChanges);});return v;}
function l(r){var v={};r.forEach(function(R){v=b(v,R.variants);v=d(v,R.variantDependentControlChanges);v=e(v,R.variantChanges);});return v;}
function n(r,v,V){r=h(r,v);r=i(r,V);r=j(r);return r;}
var C={};
C._concatChanges=function(r){var o=[];r.forEach(function(R){o=o.concat(R.changes);});var p=[];o=o.filter(function(q){var F=q.fileName;var s=p.indexOf(F)!==-1;if(s){return false;}p.push(F);return true;});return o;};
C.merge=function(p){var r={changes:C._concatChanges(p.responses),variantSection:{}};if(p.variantSectionSufficient){r.variantSection=f(p.responses);}else{var v=l(p.responses);var V=k(p.responses);r=n(r,v,V);}return r;};
C._createStandardVariant=function(v){return{content:{fileName:v,variantManagementReference:v,content:{title:"STANDARD_VARIANT_TITLE"},favorite:true,visible:true},variantChanges:{},controlChanges:[]};};
return C;});
sap.ui.predefine('sap/ui/fl/apply/_internal/connectors/BrowserStorageConnector',["sap/base/util/merge","sap/ui/fl/library","sap/ui/fl/apply/connectors/BaseConnector","sap/ui/fl/apply/_internal/connectors/BrowserStorageUtils","sap/ui/fl/LayerUtils"],function(m,l,B,c,L){"use strict";
function d(p){var F=[];c.forEachChangeInStorage(p,function(a){F.push(a.changeDefinition);});return F;}
function g(F){var G={};Object.keys(l.Layer).forEach(function(s){G[s]={variants:[],variantChanges:[],variantManagementChanges:[],variantDependentControlChanges:[],changes:[],index:L.getLayerIndex(s)};});F.forEach(function(o){var s=o.layer;if(o.fileType==="ctrl_variant"&&o.variantManagementReference){G[s].variants.push(o);}else if(o.fileType==="ctrl_variant_change"){G[s].variantChanges.push(o);}else if(o.fileType==="ctrl_variant_management_change"){G[s].variantManagementChanges.push(o);}else if(o.fileType==="change"){if(o.variantReference){G[s].variantDependentControlChanges.push(o);}else{G[s].changes.push(o);}}});Object.keys(G).forEach(function(s){c.sortGroupedFlexObjects(G[s]);});return G;}
function f(G){var r=[];Object.keys(G).forEach(function(s){r.push(G[s]);});r=r.filter(function(R){return R.changes.length>0||R.variants.length>0||R.variantChanges.length>0||R.variantManagementChanges.length>0||R.variantDependentControlChanges.length>0;});r.sort(function(a,b){return a.index-b.index;});return r;}
var e=m({},B,{oStorage:undefined,loadFlexData:function(p){var F=d({storage:this.oStorage,reference:p.reference});var G=g(F);var r=f(G);return Promise.resolve(r);}});return e;},true);
sap.ui.predefine('sap/ui/fl/apply/_internal/connectors/BrowserStorageUtils',[],function(){"use strict";var F="sap.ui.fl.change";var a="sap.ui.fl.variant";return{forEachChangeInStorage:function(p,P){var r=p.storage.getItems&&p.storage.getItems()||p.storage;var k=Object.keys(r);k.forEach(function(K){var i=K.includes(F)||K.includes(a);if(!i){return;}var f=JSON.parse(r[K]);var s=true;if(p.reference){s=f.reference===p.reference||f.reference+".Component"===p.reference;}var S=true;if(p.layer){S=f.layer===p.layer;}if(!s||!S){return;}P({changeDefinition:f,key:K});});},getAllFlexObjects:function(p){var f=[];this.forEachChangeInStorage(p,function(m){f.push(m);});return f;},createChangeKey:function(i){if(i){return F+"."+i;}},createVariantKey:function(i){if(i){return a+"."+i;}},createFlexObjectKey:function(f){if(f.fileType==="ctrl_variant"&&f.variantManagementReference){return this.createVariantKey(f.fileName);}return this.createChangeKey(f.fileName);},sortGroupedFlexObjects:function(r){function b(c,C){return new Date(c.creation)-new Date(C.creation);}["changes","variantChanges","variants","variantDependentControlChanges","variantManagementChanges"].forEach(function(s){r[s]=r[s].sort(b);});return r;}};});
sap.ui.predefine('sap/ui/fl/apply/_internal/connectors/JsObjectConnector',["sap/base/util/merge","sap/ui/fl/apply/_internal/connectors/BrowserStorageConnector"],function(m,B){"use strict";var M={_items:{},setItem:function(k,v){M._items[k]=v;},removeItem:function(k){delete M._items[k];},clear:function(){M._items={};},getItem:function(k){return M._items[k];},getItems:function(){return M._items;}};var J=m({},B,{oStorage:M});return J;},true);
sap.ui.predefine('sap/ui/fl/apply/_internal/connectors/KeyUserConnector',["sap/base/util/merge","sap/ui/fl/apply/connectors/BaseConnector","sap/ui/fl/apply/_internal/connectors/Utils","sap/base/util/restricted/_pick"],function(m,B,A,_){"use strict";var P="/flex/keyuser";var a="/v1";var R={DATA:P+a+"/data/"};var K=m({},B,{xsrfToken:undefined,loadFlexData:function(p){var b=_(p,["appVersion"]);var d=A.getUrl(R.DATA,p,b);return A.sendRequest(d,"GET",{xsrfToken:this.xsrfToken}).then(function(r){var o=r.response;if(r.xsrfToken){this.xsrfToken=r.xsrfToken;}o.changes=o.changes.concat(o.compVariants||[]);return o;}.bind(this));}});return K;},true);
sap.ui.predefine('sap/ui/fl/apply/_internal/connectors/LocalStorageConnector',["sap/base/util/merge","sap/ui/fl/apply/_internal/connectors/BrowserStorageConnector"],function(m,B){"use strict";var L=m({},B,{oStorage:window.localStorage});return L;},true);
sap.ui.predefine('sap/ui/fl/apply/_internal/connectors/LrepConnector',["sap/base/util/merge","sap/base/security/encodeURLParameters","sap/ui/fl/apply/connectors/BaseConnector","sap/ui/fl/apply/_internal/connectors/Utils","sap/ui/fl/Utils","sap/base/util/restricted/_pick"],function(m,e,B,A,F,_){"use strict";var R={DATA:"/flex/data/",MODULES:"/flex/modules/"};var L=m({},B,{xsrfToken:undefined,loadFlexData:function(p){var P=_(p,["appVersion"]);var c=F.getUrlParameter("sap-client");if(c){P["sap-client"]=c;}var d=A.getUrl(R.DATA,p,P);return A.sendRequest(d,"GET",{xsrfToken:this.xsrfToken}).then(function(r){var o=r.response;if(r.token){this.xsrfToken=r.token;}if(!o.loadModules){return o;}var M=A.getUrl(R.MODULES,p,P);return A.sendRequest(M,"GET").then(function(a){return a.response;});}.bind(this));}});return L;},true);
sap.ui.predefine('sap/ui/fl/apply/_internal/connectors/PersonalizationConnector',["sap/base/util/merge","sap/ui/fl/apply/connectors/BaseConnector","sap/ui/fl/apply/_internal/connectors/Utils","sap/base/util/restricted/_pick"],function(m,B,A,_){"use strict";var P="/flex/personalization";var a="/v1";var R={DATA:P+a+"/data/"};var b=m({},B,{xsrfToken:undefined,loadFlexData:function(p){var c=_(p,["appVersion"]);var d=A.getUrl(R.DATA,p,c);return A.sendRequest(d,"GET",{xsrfToken:this.xsrfToken}).then(function(r){var o=r.response;if(r.xsrfToken){this.xsrfToken=r.xsrfToken;}o.changes=o.changes.concat(o.compVariants||[]);return o;}.bind(this));}});return b;},true);
sap.ui.predefine('sap/ui/fl/apply/_internal/connectors/SessionStorageConnector',["sap/base/util/merge","sap/ui/fl/apply/_internal/connectors/BrowserStorageConnector"],function(m,B){"use strict";var S=m({},B,{oStorage:window.sessionStorage});return S;},true);
sap.ui.predefine('sap/ui/fl/apply/_internal/connectors/StaticFileConnector',["sap/base/util/merge","sap/ui/fl/apply/connectors/BaseConnector","sap/ui/fl/apply/_internal/connectors/Utils","sap/base/Log","sap/base/util/LoaderExtensions"],function(m,B,U,L,a){"use strict";var S=m({},B,{loadFlexData:function(p){var r=p.reference;var R=r.replace(/\./g,"/")+"/changes/changes-bundle.json";var c=!!sap.ui.loader._.getModuleState(R);var C=sap.ui.getCore().getConfiguration();if(c||C.getDebug()||C.isFlexBundleRequestForced()){try{var o={changes:a.loadResource(R)};return Promise.resolve(o);}catch(e){L.warning("flexibility did not find a changes-bundle.json for the application: "+r);}}return Promise.resolve(U.getEmptyFlexDataResponse());}});return S;},true);
sap.ui.predefine('sap/ui/fl/apply/_internal/connectors/Utils',["sap/base/security/encodeURLParameters","sap/base/Log"],function(e,L){"use strict";var A="sap/ui/fl/apply/_internal/connectors/";var S={layerFilter:[],connector:"StaticFileConnector"};
function _(l,v){return l.filter(function(s){return v.indexOf(s)!==-1||v[0]==="ALL";});}
return{getConnectors:function(n,l){var c=sap.ui.getCore().getConfiguration().getFlexibilityServices();var C=[];if(l){C=[S];}C=C.concat(c);return new Promise(function(r){var a=C.map(function(m){var s=m.connector;var b;if(!m.custom){b=n+s;}else{b=l?m.applyConnector:m.writeConnector;}return b;});sap.ui.require(a,function(){Array.from(arguments).forEach(function(o,i){if(!l){if(!C[i].layers){C[i].layers=o.layers;}else{C[i].layers=_(C[i].layers,o.layers);}}C[i].connectorModule=o;});r(C);});});},getApplyConnectors:function(){return this.getConnectors(A,true);},logAndResolveDefault:function(r,c,f,E){L.error("Connector ("+c.connector+") failed call '"+f+"': "+E);return r;},getUrl:function(r,p,P){if(!r||!p.url){throw new Error("Not all necessary parameters were passed");}var u=p.url+r;if(p.cacheKey){u+="~"+p.cacheKey+"~/";}if(p.reference){u+=p.reference;}else if(p.fileName){u+=p.fileName;}if(P){Object.keys(P).forEach(function(k){if(P[k]===undefined){delete P[k];}});var q=e(P);if(q.length>0){u+="?"+q;}}return u;},sendRequest:function(u,m,p){m=m||"GET";m=m.toUpperCase();return new Promise(function(r,a){var x=new XMLHttpRequest();x.open(m,u);if((m==="GET"||m==="HEAD")&&(!p||!p.xsrfToken)){x.setRequestHeader("X-CSRF-Token","fetch");}if((m==="POST"||m==="PUT"||m==="DELETE")&&p&&p.xsrfToken){x.setRequestHeader("X-CSRF-Token",p.xsrfToken);}if(p&&p.contentType){x.setRequestHeader("Content-Type",p.contentType);}if(p&&p.dataType){x.responseType=p.dataType;}x.onload=function(){if(x.status>=200&&x.status<400){var R={};if(x.response){R.response=typeof x.response==="string"?JSON.parse(x.response):x.response;}R.status=x.status;if(x.getResponseHeader("X-CSRF-Token")){R.xsrfToken=x.getResponseHeader("X-CSRF-Token");}r(R);}else{a({status:x.status,message:x.statusText});}};if(p&&p.payload){x.send(p.payload);}else{x.send();}});},getEmptyFlexDataResponse:function(){return Object.assign({},{changes:[],variants:[],variantChanges:[],variantDependentControlChanges:[],variantManagementChanges:[]});}};});
sap.ui.predefine('sap/ui/fl/apply/_internal/variants/URLHandler',["sap/ui/core/Component","sap/ui/fl/Utils","sap/ui/core/routing/History","sap/ui/core/routing/HashChanger","sap/base/Log","sap/base/util/deepEqual","sap/base/util/merge","sap/base/util/isEmptyObject","sap/ui/base/ManagedObjectObserver","sap/ui/thirdparty/hasher"],function(C,U,H,a,L,d,m,i,M,h){"use strict";
function g(o,N){var f=N.params[e.variantTechnicalParameterName];return f.reduce(function(r,v){var V=o.getVariantManagementReference(v).variantManagementReference;if(V&&o.oData[V].currentVariant!==v){r.updateRequired=true;if(o.oData[V].currentVariant!==o.oData[V].defaultVariant){r.currentVariantReferences.push(o.oData[V].currentVariant);}}else{r.currentVariantReferences.push(v);}return r;},{updateRequired:false,currentVariantReferences:[]});}
function n(o,N){var u=U.getUshellContainer();var S=u.getService("ShellNavigation");try{var f=u.getService("URLParsing");var j=f.parseShellHash(N);var r=j&&j.params.hasOwnProperty(e.variantTechnicalParameterName);if(r){var k=g(o,j);if(k.updateRequired){e.update({updateURL:!o._bDesignTimeMode,parameters:k.currentVariantReferences,updateHashEntry:true,model:o});}if(o._bDesignTimeMode){e.clearAllVariantURLParameters({model:o});}}}catch(E){L.error(E.message);}return S.NavigationFilterStatus.Continue;}
function s(o,S){var f=S?"registerNavigationFilter":"unregisterNavigationFilter";var u=U.getUshellContainer();if(u){u.getService("ShellNavigation")[f](n.bind(null,o));}}
function b(p){var P=U.getParsedURLHash(e.variantTechnicalParameterName);if(P.params){var t=U.getTechnicalParametersForComponent(p.model.oAppComponent);if(!t){L.warning("Component instance not provided, so technical parameters in component data and browser history remain unchanged");}if(p.parameters.length===0){delete P.params[e.variantTechnicalParameterName];t&&delete t[e.variantTechnicalParameterName];}else{P.params[e.variantTechnicalParameterName]=p.parameters;t&&(t[e.variantTechnicalParameterName]=p.parameters);}if(p.silent){h.changed.active=false;h.replaceHash(U.getUshellContainer().getService("URLParsing").constructShellHash(P));h.changed.active=true;}else{var o=U.getUshellContainer().getService("CrossApplicationNavigation");o.toExternal({target:{semanticObject:P.semanticObject,action:P.action,context:P.contextRaw},params:P.params,appSpecificRoute:P.appSpecificRoute,writeHistory:false});}}}
function c(p){var r={index:-1};var u=U.getParsedURLHash().params;if(u){r.parameters=[];if(p.model._bDesignTimeMode){u[e.variantTechnicalParameterName]=e.getStoredHashParams(p);}if(Array.isArray(u[e.variantTechnicalParameterName])){u[e.variantTechnicalParameterName]=u[e.variantTechnicalParameterName].map(decodeURIComponent);u[e.variantTechnicalParameterName].some(function(P,I){if(p.model.oVariantController.getVariant(p.vmReference,P)){r.index=I;return true;}});}}return m(r,u&&u[e.variantTechnicalParameterName]&&{parameters:u[e.variantTechnicalParameterName]});}
var e={variantTechnicalParameterName:"sap-ui-fl-control-variant-id",initialize:function(p){var u=U.getParsedURLHash().params;p.model._oHashData={hashParams:(u&&u[e.variantTechnicalParameterName])||[],controlPropertyObservers:[],variantControlIds:[]};e.attachHandlers(p);},updateVariantInURL:function(p){var u=e.removeURLParameterForVariantManagement(p);if(!u.parameters){return;}var P=u.parameters||[];var I=u.index;var f=p.newVReference===p.model.oData[p.vmReference].defaultVariant;if(!f){if(I===-1){P=P.concat([p.newVReference]);}else{P=P.slice(0,I).concat([p.newVReference],P.slice(I));}}if(!f||I>-1){e.update({parameters:P,updateURL:!p.model._bDesignTimeMode,updateHashEntry:true,model:p.model});}},removeURLParameterForVariantManagement:function(p){var v=c(p);if(v.index>-1){v.parameters.splice(v.index,1);}return v;},attachHandlers:function(p){function o(){return p.model._oVariantSwitchPromise.then(function(){p.model._oHashData.controlPropertyObservers.forEach(function(O){O.destroy();});s(p.model,false);p.model.oChangePersistence.resetVariantMap();p.model.destroy();p.model.oComponentDestroyObserver.unobserve(p.model.oAppComponent,{destroy:true});p.model.oComponentDestroyObserver.destroy();});}s(p.model,true);if(!p.model.oComponentDestroyObserver&&p.model.oAppComponent instanceof C){p.model.oComponentDestroyObserver=new M(o.bind(null));p.model.oComponentDestroyObserver.observe(p.model.oAppComponent,{destroy:true});}if(p.updateURL){p.model._oHashData.variantControlIds.push(p.vmReference);}},update:function(p){if(!p||!Array.isArray(p.parameters)){L.info("Variant URL parameters could not be updated since invalid parameters were received");return;}if(p.updateURL){b(p);}if(p.updateHashEntry&&!i(p.model)){p.model._oHashData.hashParams=p.parameters;}},getStoredHashParams:function(p){return Array.prototype.slice.call(p.model._oHashData.hashParams);},handleModelContextChange:function(p){var f="modelContextChange";function j(E,P){var v=P.model.getVariantManagementReferenceForControl(E.getSource());var V=P.model._oHashData.variantControlIds;var I=V.indexOf(v);if(I>-1){V.slice(I).forEach(function(k){if(c({vmReference:k,model:p.model}).index===-1){P.model.switchToDefaultForVariantManagement(k);}});}}var o=new M(function(E){if(E.current===true&&E.old===false){E.object.attachEvent(f,{model:p.model},j);}else if(E.current===false&&E.old===true){E.object.detachEvent(f,j);}});o.observe(p.vmControl,{properties:["resetOnContextChange"]});p.model._oHashData.controlPropertyObservers.push(o);if(p.vmControl.getResetOnContextChange()!==false){p.vmControl.attachEvent(f,{model:p.model},j);}},clearAllVariantURLParameters:function(p){e.update({updateURL:true,parameters:[],updateHashEntry:false,model:p.model});}};return e;},true);
sap.ui.predefine('sap/ui/fl/apply/api/ControlVariantApplyAPI',["sap/ui/fl/ControlPersonalizationAPI"],function(O){"use strict";var C={clearVariantParameterInURL:function(p){O.clearVariantParameterInURL(p.control);},activateVariant:function(p){return O.activateVariant(p.element,p.variantReference);}};return C;},true);
sap.ui.predefine('sap/ui/fl/apply/api/FlexRuntimeInfoAPI',["sap/ui/fl/ControlPersonalizationAPI","sap/ui/fl/Utils","sap/ui/fl/apply/_internal/ChangesController"],function(O,U,C){"use strict";var F={isPersonalized:function(p){return O.isPersonalized(p.selectors,p.changeTypes);},waitForChanges:function(p){return C.getFlexControllerInstance(p.element).waitForChangesToBeApplied(p.element);},isFlexSupported:function(p){return!!U.getAppComponentForControl(p.element);},hasVariantManagement:function(p){return O.hasVariantManagement(p.element);}};return F;},true);
sap.ui.predefine('sap/ui/fl/apply/api/SmartVariantManagementApplyAPI',["sap/ui/fl/DefaultVariant","sap/ui/fl/StandardVariant","sap/ui/fl/ChangePersistenceFactory","sap/ui/fl/registry/Settings","sap/ui/fl/Utils","sap/ui/fl/LayerUtils","sap/base/Log"],function(D,S,C,a,U,L,b){"use strict";var c={_PERSISTENCY_KEY:"persistencyKey",loadChanges:function(p){var o=p.control;var A=U.getAppDescriptor(o);var s=U.getSiteId(o);var d=this._getStableId(o);var P={appDescriptor:A,siteId:s,includeVariants:true};var e=C.getChangePersistenceForControl(o);return e.getChangesForVariant(this._PERSISTENCY_KEY,d,P);},getChangeById:function(p){var o=p.control;var i=p.id;if(!i||!o){b.error("sId or oControl is not defined");return undefined;}var d=this._getChangeMap(o);return d[i];},isVariantSharingEnabled:function(){return a.getInstance().then(function(i){return i.isVariantSharingEnabled();});},isApplicationVariant:function(p){var o=p.control;if(U.isApplicationVariant(o)){return true;}var d=U.getComponentForControl(o);if(d&&d.getAppComponent){d=d.getAppComponent();if(d){return true;}}return false;},isVendorLayer:function(){return L.isVendorLayer();},isVariantDownport:function(){return c.isVendorLayer()&&U.isHotfixMode();},getDefaultVariantId:function(p){var o=this._getChangeMap(p.control);return D.getDefaultVariantId(o);},getExecuteOnSelect:function(p){var o=this._getChangeMap(p.control);return S.getExecuteOnSelect(o);},_getStableId:function(o){if(!o){return undefined;}var s;try{s=o.getPersistencyKey();}catch(e){s="";}return s;},_getChangeMap:function(o){var d=C.getChangePersistenceForControl(o);var s=c._getStableId(o);return d.getSmartVariantManagementChangeMap()[s]||{};}};return c;},true);
sap.ui.predefine('sap/ui/fl/apply/api/UI2PersonalizationApplyAPI',["sap/ui/fl/apply/_internal/ChangesController","sap/ui/fl/Cache"],function(C,a){"use strict";var U={load:function(p){var f=C.getDescriptorFlexControllerInstance(p.selector);p.reference=f.getComponentName();p.appVersion=f.getAppVersion();if(!p.reference||!p.containerKey){return Promise.reject(new Error("not all mandatory properties were provided for the loading of the personalization"));}return a.getPersonalization(p.reference,p.appVersion,p.containerKey,p.itemName);}};return U;},true);
sap.ui.predefine('sap/ui/fl/apply/connectors/BaseConnector',[],function(){"use strict";var B={loadFlexData:function(){return Promise.reject("loadFlexData is not implemented");}};return B;},true);
sap.ui.predefine('sap/ui/fl/variants/VariantManagement',["sap/ui/model/Context","sap/ui/model/PropertyBinding","sap/ui/model/json/JSONModel","sap/ui/model/Filter","sap/ui/model/FilterOperator","sap/ui/Device","sap/ui/core/InvisibleText","sap/ui/core/Control","sap/ui/core/Icon","sap/ui/layout/HorizontalLayout","sap/ui/layout/Grid","sap/m/SearchField","sap/m/RadioButton","sap/m/ColumnListItem","sap/m/Column","sap/m/Text","sap/m/Bar","sap/m/Table","sap/m/Page","sap/m/Toolbar","sap/m/ToolbarSpacer","sap/m/Button","sap/m/CheckBox","sap/m/Dialog","sap/m/Input","sap/m/Label","sap/m/Title","sap/m/ResponsivePopover","sap/m/SelectList","sap/m/ObjectIdentifier","sap/m/OverflowToolbar","sap/m/OverflowToolbarLayoutData","sap/m/VBox","sap/ui/events/KeyCodes","sap/ui/core/library","sap/m/library","sap/ui/fl/Utils"],function(C,P,J,F,a,D,I,b,c,H,G,S,R,d,f,T,B,g,h,i,j,k,l,m,n,L,o,p,q,O,r,s,V,K,t,u,v){"use strict";var w=u.OverflowToolbarPriority;var x=u.ButtonType;var y=u.PlacementType;var z=u.PopinDisplay;var A=u.ScreenSize;var E=t.ValueState;var M=t.TextAlign;
var N=b.extend("sap.ui.fl.variants.VariantManagement",{
metadata:{library:"sap.ui.fl",designtime:"sap/ui/fl/designtime/variants/VariantManagement.designtime",properties:{showExecuteOnSelection:{type:"boolean",group:"Misc",defaultValue:false},showSetAsDefault:{type:"boolean",group:"Misc",defaultValue:true},manualVariantKey:{type:"boolean",group:"Misc",defaultValue:false},inErrorState:{type:"boolean",group:"Misc",defaultValue:false},editable:{type:"boolean",group:"Misc",defaultValue:true},modelName:{type:"string",group:"Misc",defaultValue:null},updateVariantInURL:{type:"boolean",group:"Misc",defaultValue:false},resetOnContextChange:{type:"boolean",group:"Misc",defaultValue:true}},associations:{"for":{type:"sap.ui.core.Control",multiple:true}},events:{save:{parameters:{name:{type:"string"},overwrite:{type:"boolean"},key:{type:"string"},execute:{type:"boolean"},def:{type:"boolean"}}},manage:{},initialized:{},select:{parameters:{key:{type:"string"}}}}},
renderer:function(e,Q){e.write("<div ");e.writeControlData(Q);e.addClass("sapUiFlVarMngmt");e.writeClasses();e.write(">");e.renderControl(Q.oVariantLayout);e.write("</div>");}
});
N.INNER_MODEL_NAME="$sapUiFlVariants";N.MAX_NAME_LEN=100;N.COLUMN_FAV_IDX=0;N.COLUMN_NAME_IDX=1;
N.prototype.init=function(){this._sModelName=v.VARIANT_MODEL_NAME;this.attachModelContextChange(this._setModel,this);this._oRb=sap.ui.getCore().getLibraryResourceBundle("sap.ui.fl");this._createInnerModel();this.oVariantInvisibleText=new I({text:{parts:[{path:'currentVariant',model:this._sModelName},{path:"modified",model:this._sModelName}],formatter:function(Q,U){if(U){Q=this._oRb.getText("VARIANT_MANAGEMENT_SEL_VARIANT_MOD",[Q]);}else{Q=this._oRb.getText("VARIANT_MANAGEMENT_SEL_VARIANT",[Q]);}}.bind(this)}});this.oVariantText=new o(this.getId()+"-text",{text:{path:'currentVariant',model:this._sModelName,formatter:function(Q){var U=this.getSelectedVariantText(Q);return U;}.bind(this)}});this.oVariantText.addStyleClass("sapUiFlVarMngmtClickable");this.oVariantText.addStyleClass("sapUiFlVarMngmtTitle");if(D.system.phone){this.oVariantText.addStyleClass("sapUiFlVarMngmtTextPhoneMaxWidth");}else{this.oVariantText.addStyleClass("sapUiFlVarMngmtTextMaxWidth");}var e=new L(this.getId()+"-modified",{text:"*",visible:{path:"modified",model:this._sModelName,formatter:function(Q){return(Q===null||Q===undefined)?false:Q;}}});e.setVisible(false);e.addStyleClass("sapUiFlVarMngmtModified");e.addStyleClass("sapUiFlVarMngmtClickable");e.addStyleClass("sapMTitleStyleH4");this.oVariantPopoverTrigger=new k(this.getId()+"-trigger",{icon:"sap-icon://slim-arrow-down",type:x.Transparent});this.oVariantPopoverTrigger.addAriaLabelledBy(this.oVariantInvisibleText);this.oVariantPopoverTrigger.addStyleClass("sapUiFlVarMngmtTriggerBtn");this.oVariantPopoverTrigger.addStyleClass("sapMTitleStyleH4");this.oVariantLayout=new H({content:[this.oVariantText,e,this.oVariantPopoverTrigger,this.oVariantInvisibleText]});this.oVariantLayout.addStyleClass("sapUiFlVarMngmtLayout");this.addDependent(this.oVariantLayout);};
N.prototype.getTitle=function(){return this.oVariantText;};
N.prototype._createInnerModel=function(){var e=new J({showExecuteOnSelection:false,showSetAsDefault:true,editable:true,popoverTitle:this._oRb.getText("VARIANT_MANAGEMENT_VARIANTS")});this.setModel(e,N.INNER_MODEL_NAME);this._bindProperties();};
N.prototype._bindProperties=function(){this.bindProperty("showExecuteOnSelection",{path:"/showExecuteOnSelection",model:N.INNER_MODEL_NAME});this.bindProperty("showSetAsDefault",{path:"/showSetAsDefault",model:N.INNER_MODEL_NAME});this.bindProperty("editable",{path:"/editable",model:N.INNER_MODEL_NAME});};
N.prototype.getOriginalDefaultVariantKey=function(){var e=this.getModel(this._sModelName);if(e&&this.oContext){return e.getProperty(this.oContext+"/originalDefaultVariant");}return null;};
N.prototype.setDefaultVariantKey=function(e){var Q=this.getModel(this._sModelName);if(Q&&this.oContext){Q.setProperty(this.oContext+"/defaultVariant",e);}};
N.prototype.getDefaultVariantKey=function(){var e=this.getModel(this._sModelName);if(e&&this.oContext){return e.getProperty(this.oContext+"/defaultVariant");}return null;};
N.prototype.setCurrentVariantKey=function(e){var Q=this.getModel(this._sModelName);if(Q&&this.oContext){Q.setProperty(this.oContext+"/currentVariant",e);}return this;};
N.prototype.getCurrentVariantKey=function(){var e=this.getModel(this._sModelName);if(e&&this.oContext){return e.getProperty(this.oContext+"/currentVariant");}return null;};
N.prototype._assignPopoverTitle=function(){var e;var Q;var U=this.getModel(this._sModelName);if(U&&this.oContext){e=U.getProperty(this.oContext+"/popoverTitle");}if(e!==undefined){Q=this.getModel(N.INNER_MODEL_NAME);if(Q){Q.setProperty("/popoverTitle",e);}}};
N.prototype.getVariants=function(){return this._getItems();};
N.prototype.setModified=function(e){var Q=this.getModel(this._sModelName);if(Q&&this.oContext){Q.setProperty(this.oContext+"/modified",e);}};
N.prototype.getModified=function(){var e=this.getModel(this._sModelName);if(e&&this.oContext){return e.getProperty(this.oContext+"/modified");}return false;};
N.prototype.getSelectedVariantText=function(e){var Q=this._getItemByKey(e);if(Q){return Q.title;}return"";};
N.prototype.getStandardVariantKey=function(){var e=this._getItems();if(e&&e[0]){return e[0].key;}return null;};
N.prototype.getShowFavorites=function(){var e=this.getModel(this._sModelName);if(e&&this.oContext){return e.getProperty(this.oContext+"/showFavorites");}return false;};
N.prototype._clearDeletedItems=function(){this._aDeletedItems=[];};
N.prototype._addDeletedItem=function(e){this._aDeletedItems.push(e);};
N.prototype._getDeletedItems=function(){return this._aDeletedItems;};
N.prototype._getItems=function(){var e=[];if(this.oContext&&this.oContext.getObject()){e=this.oContext.getObject().variants.filter(function(Q){if(!Q.hasOwnProperty("visible")){return true;}return Q.visible;});}return e;};
N.prototype._getItemByKey=function(e){var Q=null;var U=this._getItems();U.some(function(W){if(W.key===e){Q=W;}return(Q!==null);});return Q;};
N.prototype._rebindControl=function(){this.oVariantInvisibleText.unbindProperty("text");this.oVariantInvisibleText.bindProperty("text",{parts:[{path:'currentVariant',model:this._sModelName},{path:"modified",model:this._sModelName}],formatter:function(e,Q){if(Q){e=this._oRb.getText("VARIANT_MANAGEMENT_SEL_VARIANT_MOD",[e]);}else{e=this._oRb.getText("VARIANT_MANAGEMENT_SEL_VARIANT",[e]);}}.bind(this)});this.oVariantText.unbindProperty("text");this.oVariantText.bindProperty("text",{path:'currentVariant',model:this._sModelName,formatter:function(e){var Q=this.getSelectedVariantText(e);return Q;}.bind(this)});this.oVariantText.unbindProperty("visible",{path:"modified",model:this._sModelName,formatter:function(e){return(e===null||e===undefined)?false:e;}});};
N.prototype.setModelName=function(e){if(this.getModelName()){this.oContext=null;}this.setProperty("modelName",e);this._sModelName=e;this._rebindControl();return this;};
N.prototype._setBindingContext=function(){var e;var Q;if(!this.oContext){e=this.getModel(this._sModelName);if(e){Q=this._getLocalId(e);if(Q){this.oContext=new C(e,"/"+Q);this.setBindingContext(this.oContext,this._sModelName);if(!this.getModelName()&&e.registerToModel){e.registerToModel(this);}this._assignPopoverTitle();this._registerPropertyChanges(e);this.fireInitialized();}}}};
N.prototype._getLocalId=function(e){if(this.getModelName()&&(this._sModelName!==v.VARIANT_MODEL_NAME)){return this.getId();}return e.getVariantManagementReferenceForControl(this);};
N.prototype._setModel=function(){this._setBindingContext();};
N.prototype._registerPropertyChanges=function(e){var Q=new P(e,this.oContext+"/variantsEditable");Q.attachChange(function(U){if(U&&U.oSource&&U.oSource.oModel&&U.oSource.sPath){var W;var X=U.oSource.oModel.getProperty(U.oSource.sPath);W=this.getModel(N.INNER_MODEL_NAME);if(W){W.setProperty("/editable",X);}}}.bind(this));};
N.prototype.handleOpenCloseVariantPopover=function(){if(!this.bPopoverOpen){this._openVariantList();}else if(this.oVariantPopOver&&this.oVariantPopOver.isOpen()){this.oVariantPopOver.close();}else if(this.getInErrorState()&&this.oErrorVariantPopOver&&this.oErrorVariantPopOver.isOpen()){this.oErrorVariantPopOver.close();}};
N.prototype.getFocusDomRef=function(){if(this.oVariantPopoverTrigger){return this.oVariantPopoverTrigger.getFocusDomRef();}};
N.prototype.onclick=function(){if(this.oVariantPopoverTrigger&&!this.bPopoverOpen){this.oVariantPopoverTrigger.focus();}this.handleOpenCloseVariantPopover();};
N.prototype.onkeyup=function(e){if(e.which===K.F4||e.which===K.SPACE||e.altKey===true&&e.which===K.ARROW_UP||e.altKey===true&&e.which===K.ARROW_DOWN){this._openVariantList();}};
N.prototype.onAfterRendering=function(){this.oVariantText.$().off("mouseover").on("mouseover",function(){this.oVariantPopoverTrigger.addStyleClass("sapUiFlVarMngmtTriggerBtnHover");}.bind(this));this.oVariantText.$().off("mouseout").on("mouseout",function(){this.oVariantPopoverTrigger.removeStyleClass("sapUiFlVarMngmtTriggerBtnHover");}.bind(this));};
N.prototype._openInErrorState=function(){var Q;if(!this.oErrorVariantPopOver){Q=new V({fitContainer:true,alignItems:sap.m.FlexAlignItems.Center,items:[new c({size:"4rem",color:"lightgray",src:"sap-icon://message-error"}),new o({titleStyle:sap.ui.core.TitleLevel.H2,text:this._oRb.getText("VARIANT_MANAGEMENT_ERROR_TEXT1")}),new T({textAlign:sap.ui.core.TextAlign.Center,text:this._oRb.getText("VARIANT_MANAGEMENT_ERROR_TEXT2")})]});Q.addStyleClass("sapUiFlVarMngmtErrorPopover");this.oErrorVariantPopOver=new p(this.getId()+"-errorpopover",{title:{path:"/popoverTitle",model:N.INNER_MODEL_NAME},contentWidth:"400px",placement:y.Bottom,content:[new h(this.getId()+"-errorselpage",{showSubHeader:false,showNavButton:false,showHeader:false,content:[Q]})],afterOpen:function(){this.bPopoverOpen=true;}.bind(this),afterClose:function(){if(this.bPopoverOpen){setTimeout(function(){this.bPopoverOpen=false;}.bind(this),200);}}.bind(this),contentHeight:"300px"});this.oErrorVariantPopOver.attachBrowserEvent("keyup",function(e){if(e.which===32){this.oErrorVariantPopOver.close();}}.bind(this));}if(this.bPopoverOpen){return;}this.oErrorVariantPopOver.openBy(this.oVariantLayout);};
N.prototype._createVariantList=function(){if(this.oVariantPopOver){return;}this.oVariantManageBtn=new k(this.getId()+"-manage",{text:this._oRb.getText("VARIANT_MANAGEMENT_MANAGE"),enabled:true,press:function(){this._openManagementDialog();}.bind(this),layoutData:new s({priority:w.Low})});this.oVariantSaveBtn=new k(this.getId()+"-mainsave",{text:this._oRb.getText("VARIANT_MANAGEMENT_SAVE"),press:function(){this._handleVariantSave();}.bind(this),visible:{path:"modified",model:this._sModelName,formatter:function(Q){return Q;}},type:sap.m.ButtonType.Emphasized,layoutData:new s({priority:w.Low})});this.oVariantSaveAsBtn=new k(this.getId()+"-saveas",{text:this._oRb.getText("VARIANT_MANAGEMENT_SAVEAS"),press:function(){this._openSaveAsDialog();}.bind(this),layoutData:new s({priority:w.Low})});this._oVariantList=new q(this.getId()+"-list",{selectedKey:{path:"currentVariant",model:this._sModelName},itemPress:function(Q){var U=null;if(Q&&Q.getParameters()){var W=Q.getParameters().item;if(W){U=W.getKey();}}if(U){this.setCurrentVariantKey(U);this.fireEvent("select",{key:U});this.oVariantPopOver.close();}}.bind(this)});this._oVariantList.setNoDataText(this._oRb.getText("VARIANT_MANAGEMENT_NODATA"));var e=new sap.ui.core.Item({key:'{'+this._sModelName+">key}",text:'{'+this._sModelName+">title}"});this._oVariantList.bindAggregation("items",{path:"variants",model:this._sModelName,template:e});this._oSearchField=new S(this.getId()+"-search");this._oSearchField.attachLiveChange(function(Q){this._triggerSearch(Q,this._oVariantList);}.bind(this));this.oVariantSelectionPage=new h(this.getId()+"-selpage",{subHeader:new i({content:[this._oSearchField]}),content:[this._oVariantList],footer:new r({content:[new j(this.getId()+"-spacer"),this.oVariantSaveBtn,this.oVariantSaveAsBtn,this.oVariantManageBtn]}),showNavButton:false,showHeader:false,showFooter:{path:"/editable",model:N.INNER_MODEL_NAME}});this.oVariantPopOver=new p(this.getId()+"-popover",{title:{path:"/popoverTitle",model:N.INNER_MODEL_NAME},contentWidth:"400px",placement:y.Bottom,content:[this.oVariantSelectionPage],afterOpen:function(){this.bPopoverOpen=true;}.bind(this),afterClose:function(){if(this.bPopoverOpen){setTimeout(function(){this.bPopoverOpen=false;}.bind(this),200);}}.bind(this),contentHeight:"300px"});this.oVariantPopOver.addStyleClass("sapUiFlVarMngmtPopover");if(this.oVariantLayout.$().closest(".sapUiSizeCompact").length>0){this.oVariantPopOver.addStyleClass("sapUiSizeCompact");}this.addDependent(this.oVariantPopOver);};
N.prototype.showSaveButton=function(e){if(e===false){this.oVariantSaveAsBtn.setType(sap.m.ButtonType.Emphasized);this.oVariantSaveBtn.setVisible(false);}else{this.oVariantSaveAsBtn.setType(sap.m.ButtonType.Default);this.oVariantSaveBtn.setVisible(true);}};
N.prototype._openVariantList=function(){var e;if(this.getInErrorState()){this._openInErrorState();return;}if(this.bPopoverOpen){return;}if(!this.oContext){return;}this._createVariantList();this._oSearchField.setValue("");this._oVariantList.getBinding("items").filter(this._getFilters());this.oVariantSelectionPage.setShowSubHeader(this._oVariantList.getItems().length>9);this.showSaveButton(false);if(this.getModified()){e=this._getItemByKey(this.getCurrentVariantKey());if(e&&e.change){this.showSaveButton(true);}}this.oVariantPopOver.openBy(this.oVariantLayout);};
N.prototype._triggerSearch=function(e,Q){if(!e){return;}var U=e.getParameters();if(!U){return;}var W=U.newValue?U.newValue:"";var X=new F({path:"title",operator:a.Contains,value1:W});Q.getBinding("items").filter(this._getFilters(X));};
N.prototype._createSaveAsDialog=function(){if(!this.oSaveAsDialog){this.oInputName=new n(this.getId()+"-name",{liveChange:function(){this._checkVariantNameConstraints(this.oInputName,this.oSaveSave);}.bind(this)});var e=new L(this.getId()+"-namelabel",{text:this._oRb.getText("VARIANT_MANAGEMENT_NAME"),required:true});e.setLabelFor(this.oInputName);this.oDefault=new l(this.getId()+"-default",{text:this._oRb.getText("VARIANT_MANAGEMENT_SETASDEFAULT"),visible:{path:"/showSetAsDefault",model:N.INNER_MODEL_NAME},width:"100%"});this.oExecuteOnSelect=new l(this.getId()+"-execute",{text:this._oRb.getText("VARIANT_MANAGEMENT_EXECUTEONSELECT"),visible:{path:"/showExecuteOnSelection",model:N.INNER_MODEL_NAME},width:"100%"});this.oInputManualKey=new n(this.getId()+"-key",{liveChange:function(){this._checkVariantNameConstraints(this.oInputManualKey);}.bind(this)});this.oLabelKey=new L(this.getId()+"-keylabel",{text:this._oRb.getText("VARIANT_MANAGEMENT_KEY"),required:true});this.oLabelKey.setLabelFor(this.oInputManualKey);this.oSaveSave=new k(this.getId()+"-variantsave",{text:this._oRb.getText("VARIANT_MANAGEMENT_SAVE"),press:function(){this._bSaveCanceled=false;this._handleVariantSaveAs(this.oInputName.getValue());}.bind(this),enabled:true});var Q=new G({defaultSpan:"L12 M12 S12"});if(this.getShowSetAsDefault()){Q.addContent(this.oDefault);}if(this.getShowExecuteOnSelection()){Q.addContent(this.oExecuteOnSelect);}this.oSaveAsDialog=new m(this.getId()+"-savedialog",{title:this._oRb.getText("VARIANT_MANAGEMENT_SAVEDIALOG"),beginButton:this.oSaveSave,endButton:new k(this.getId()+"-variantcancel",{text:this._oRb.getText("VARIANT_MANAGEMENT_CANCEL"),press:function(){this._bSaveCanceled=true;this.oSaveAsDialog.close();}.bind(this)}),content:[e,this.oInputName,this.oLabelKey,this.oInputManualKey,Q],stretch:D.system.phone});this.oSaveAsDialog.addStyleClass("sapUiPopupWithPadding");this.oSaveAsDialog.addStyleClass("sapUiFlVarMngmtSaveDialog");if(this.oVariantLayout.$().closest(".sapUiSizeCompact").length>0){this.oSaveAsDialog.addStyleClass("sapUiSizeCompact");}this.addDependent(this.oSaveAsDialog);}};
N.prototype._openSaveAsDialog=function(){this._createSaveAsDialog();this.oInputName.setValue(this.getSelectedVariantText(this.getCurrentVariantKey()));this.oSaveSave.setEnabled(false);this.oInputName.setEnabled(true);this.oInputName.setValueState(E.None);this.oInputName.setValueStateText(null);this.oDefault.setSelected(false);this.oExecuteOnSelect.setSelected(false);if(this.oVariantPopOver){this.oVariantPopOver.close();}if(this.getManualVariantKey()){this.oInputManualKey.setVisible(true);this.oInputManualKey.setEnabled(true);this.oInputManualKey.setValueState(E.None);this.oInputManualKey.setValueStateText(null);this.oLabelKey.setVisible(true);}else{this.oInputManualKey.setVisible(false);this.oLabelKey.setVisible(false);}this.oSaveAsDialog.open();};
N.prototype._handleVariantSaveAs=function(e){var Q=null;var U=e.trim();var W=this.oInputManualKey.getValue().trim();if(U===""){this.oInputName.setValueState(E.Error);this.oInputName.setValueStateText(this._oRb.getText("VARIANT_MANAGEMENT_ERROR_EMPTY"));return;}if(this.getManualVariantKey()){if(W===""){this.oInputManualKey.setValueState(E.Error);this.oInputManualKey.setValueStateText(this._oRb.getText("VARIANT_MANAGEMENT_ERROR_EMPTY"));return;}Q=W;}if(this.oSaveAsDialog){this.oSaveAsDialog.close();}if(this.oDefault.getSelected()){this.setDefaultVariantKey(Q);}this.setModified(false);this.fireSave({key:Q,name:U,overwrite:false,def:this.oDefault.getSelected(),execute:this.oExecuteOnSelect.getSelected()});};
N.prototype._handleVariantSave=function(){var e=this._getItemByKey(this.getCurrentVariantKey());var Q=false;if(this.getDefaultVariantKey()===e.key){Q=true;}if(this.oVariantPopOver){this.oVariantPopOver.close();}this.fireSave({name:e.title,overwrite:true,key:e.key,def:Q});this.setModified(false);};
N.prototype.openManagementDialog=function(e,Q){if(e&&this.oManagementDialog){this.oManagementDialog.destroy();this.oManagementDialog=undefined;}this._openManagementDialog(Q);};
N.prototype._triggerSearchInManageDialog=function(e,Q){if(!e){return;}var U=e.getParameters();if(!U){return;}var W=U.newValue?U.newValue:"";var X=[this._getVisibleFilter(),new F({filters:[new F({path:"title",operator:a.Contains,value1:W}),new F({path:"author",operator:a.Contains,value1:W})],and:false})];Q.getBinding("items").filter(X);this._bDeleteOccured=true;};
N.prototype._createManagementDialog=function(){if(!this.oManagementDialog){this.oManagementTable=new g(this.getId()+"-managementTable",{growing:true,columns:[new f({width:"3rem",visible:{path:"showFavorites",model:this._sModelName}}),new f({header:new T({text:this._oRb.getText("VARIANT_MANAGEMENT_NAME")}),width:"14rem"}),new f({header:new T({text:this._oRb.getText("VARIANT_MANAGEMENT_DEFAULT")}),width:"4rem",demandPopin:true,popinDisplay:z.Inline,minScreenWidth:A.Tablet,visible:{path:"/showSetAsDefault",model:N.INNER_MODEL_NAME}}),new f({header:new T({text:this._oRb.getText("VARIANT_MANAGEMENT_EXECUTEONSELECT")}),width:"6rem",hAlign:M.Center,demandPopin:true,popinDisplay:z.Inline,minScreenWidth:"800px",visible:{path:"/showExecuteOnSelection",model:N.INNER_MODEL_NAME}}),new f({header:new T({text:this._oRb.getText("VARIANT_MANAGEMENT_AUTHOR")}),width:"8rem",demandPopin:true,popinDisplay:z.Inline,minScreenWidth:"900px"}),new f({width:"2rem",hAlign:M.Center}),new f({visible:false})]});this.oManagementSave=new k(this.getId()+"-managementsave",{text:this._oRb.getText("VARIANT_MANAGEMENT_OK"),enabled:true,type:sap.m.ButtonType.Emphasized,press:function(){this._handleManageSavePressed();}.bind(this)});this.oManagementCancel=new k(this.getId()+"-managementcancel",{text:this._oRb.getText("VARIANT_MANAGEMENT_CANCEL"),press:function(){this.oManagementDialog.close();this._handleManageCancelPressed();}.bind(this)});this.oManagementDialog=new m(this.getId()+"-managementdialog",{resizable:true,draggable:true,customHeader:new B(this.getId()+"-managementHeader",{contentMiddle:[new T(this.getId()+"-managementHeaderText",{text:this._oRb.getText("VARIANT_MANAGEMENT_MANAGEDIALOG")})]}),beginButton:this.oManagementSave,endButton:this.oManagementCancel,content:[this.oManagementTable],stretch:D.system.phone});this.oManagementDialog.isPopupAdaptationAllowed=function(){return false;};this._oSearchFieldOnMgmtDialog=new S();this._oSearchFieldOnMgmtDialog.attachLiveChange(function(Q){this._triggerSearchInManageDialog(Q,this.oManagementTable);}.bind(this));var e=new B(this.getId()+"-mgmHeaderSearch",{contentRight:[this._oSearchFieldOnMgmtDialog]});this.oManagementDialog.setSubHeader(e);if(this.oVariantLayout.$().closest(".sapUiSizeCompact").length>0){this.oManagementDialog.addStyleClass("sapUiSizeCompact");}this.addDependent(this.oManagementDialog);this.oManagementTable.bindAggregation("items",{path:"variants",model:this._sModelName,factory:this._templateFactoryManagementDialog.bind(this),filters:this._getVisibleFilter()});this._bDeleteOccured=false;}};
N.prototype._setFavoriteIcon=function(e,Q){if(e){e.setSrc(Q?"sap-icon://favorite":"sap-icon://unfavorite");e.setTooltip(this._oRb.getText(Q?"VARIANT_MANAGEMENT_FAV_DEL_TOOLTIP":"VARIANT_MANAGEMENT_FAV_ADD_TOOLTIP"));}};
N.prototype._templateFactoryManagementDialog=function(e,Q){var U=null;var W;var X;var Y;var Z=Q.getObject();if(!Z){return undefined;}var $=function(g1){this._checkVariantNameConstraints(g1.oSource,this.oManagementSave,g1.oSource.getBindingContext(this._sModelName).getObject().key);}.bind(this);var _=function(g1){this._handleManageTitleChanged(g1.oSource.getBindingContext(this._sModelName).getObject());}.bind(this);var a1=function(g1){if(g1.getParameters().selected===true){this._handleManageDefaultVariantChange(g1.oSource,g1.oSource.getBindingContext(this._sModelName).getObject());}}.bind(this);var b1=function(g1){this._handleManageExecuteOnSelectionChanged(g1.oSource.getBindingContext(this._sModelName).getObject());}.bind(this);var c1=function(g1){this._handleManageDeletePressed(g1.oSource.getBindingContext(this._sModelName).getObject());}.bind(this);var d1=function(g1){this._handleManageFavoriteChanged(g1.oSource,g1.oSource.getBindingContext(this._sModelName).getObject());}.bind(this);if(Z.rename){Y=new n({liveChange:$,change:_,value:'{'+this._sModelName+">title}"});}else{Y=new O({title:'{'+this._sModelName+">title}"});if(U){Y.setTooltip(U);}}W=new k({icon:"sap-icon://sys-cancel",enabled:true,type:x.Transparent,press:c1,tooltip:this._oRb.getText("VARIANT_MANAGEMENT_DELETE"),visible:Z.remove});this._assignColumnInfoForDeleteButton(W);X=this.oContext.getPath();var e1=new c({src:{path:"favorite",model:this._sModelName,formatter:function(g1){return g1?"sap-icon://favorite":"sap-icon://unfavorite";}},tooltip:{path:'favorite',model:this._sModelName,formatter:function(g1){return this._oRb.getText(g1?"VARIANT_MANAGEMENT_FAV_DEL_TOOLTIP":"VARIANT_MANAGEMENT_FAV_ADD_TOOLTIP");}.bind(this)},press:d1});e1.addStyleClass("sapUiFlVarMngmtFavColor");var f1=new d({cells:[e1,Y,new R({groupName:this.getId(),select:a1,selected:{path:X+"/defaultVariant",model:this._sModelName,formatter:function(g1){return Z.key===g1;}}}),new l({select:b1,selected:'{'+this._sModelName+">executeOnSelect}"}),new T({text:'{'+this._sModelName+">author}",textAlign:"Begin"}),W,new T({text:'{'+this._sModelName+">key}"})]});return f1;};
N.prototype._openManagementDialog=function(e){this._createManagementDialog();if(this.oVariantPopOver){this.oVariantPopOver.close();}this._clearDeletedItems();this.oManagementSave.setEnabled(false);this._oSearchFieldOnMgmtDialog.setValue("");if(this._bDeleteOccured){this._bDeleteOccured=false;this.oManagementTable.bindAggregation("items",{path:"variants",model:this._sModelName,factory:this._templateFactoryManagementDialog.bind(this),filters:this._getVisibleFilter()});}if(e){this.oManagementDialog.addStyleClass(e);}this.oManagementDialog.open();};
N.prototype._assignColumnInfoForDeleteButton=function(e){if(!this._oInvisibleDeleteColumnName){this._oInvisibleDeleteColumnName=new I({text:this._oRb.getText("VARIANT_MANAGEMENT_ACTION_COLUMN")});this.oManagementDialog.addContent(this._oInvisibleDeleteColumnName);}if(this._oInvisibleDeleteColumnName){e.addAriaLabelledBy(this._oInvisibleDeleteColumnName);}};
N.prototype._handleManageDefaultVariantChange=function(e,Q){var U=Q.key;if(!this._anyInErrorState(this.oManagementTable)){this.oManagementSave.setEnabled(true);}if(this.getShowFavorites()&&!Q.favorite&&e){Q.favorite=true;this._setFavoriteIcon(e.getParent().getCells()[N.COLUMN_FAV_IDX],true);}this.setDefaultVariantKey(U);};
N.prototype._handleManageCancelPressed=function(){var e;var Q;this._getDeletedItems().forEach(function(U){U.visible=true;});this._getItems().forEach(function(U){U.title=U.originalTitle;U.favorite=U.originalFavorite;U.executeOnSelection=U.originalExecuteOnSelection;});e=this.getOriginalDefaultVariantKey();if(e!==this.getDefaultVariantKey()){this.setDefaultVariantKey(e);}Q=this.getModel(this._sModelName);if(Q){Q.checkUpdate();}};
N.prototype._handleManageFavoriteChanged=function(e,Q){if(!this._anyInErrorState(this.oManagementTable)){this.oManagementSave.setEnabled(true);}if((this.getDefaultVariantKey()===Q.key)&&Q.favorite){return;}Q.favorite=!Q.favorite;this._setFavoriteIcon(e,Q.favorite);};
N.prototype._getRowForKey=function(e){var Q=null;if(this.oManagementTable){this.oManagementTable.getItems().some(function(U){if(e===U.getCells()[0].getBindingContext(this._sModelName).getObject().key){Q=U;}return Q!==null;}.bind(this));}return Q;};
N.prototype._handleManageDeletePressed=function(e){var Q;var U=e.key;if(this.oManagementTable.getItems().length===1){return;}if(!this._anyInErrorState(this.oManagementTable)){this.oManagementSave.setEnabled(true);}e.visible=false;this._addDeletedItem(e);if((U===this.getDefaultVariantKey())){this.setDefaultVariantKey(this.getStandardVariantKey());if(this.getShowFavorites()){var W=this._getItemByKey(this.getStandardVariantKey());if(W&&!W.favorite){var X=this._getRowForKey(this.getStandardVariantKey());if(X){W.favorite=true;this._setFavoriteIcon(X.getCells()[N.COLUMN_FAV_IDX],true);}}}}Q=this.getModel(this._sModelName);if(Q){Q.checkUpdate();}this.oManagementCancel.focus();};
N.prototype._handleManageExecuteOnSelectionChanged=function(){if(!this._anyInErrorState(this.oManagementTable)){this.oManagementSave.setEnabled(true);}};
N.prototype._handleManageTitleChanged=function(){if(!this._anyInErrorState(this.oManagementTable)){this.oManagementSave.setEnabled(true);}};
N.prototype._handleManageSavePressed=function(){this._getDeletedItems().some(function(e){if(e.key===this.getCurrentVariantKey()){var Q=this.getStandardVariantKey();this.setModified(false);this.setCurrentVariantKey(Q);this.fireEvent("select",{key:Q});return true;}return false;}.bind(this));this.fireManage();this.oManagementDialog.close();};
N.prototype._anyInErrorState=function(e){var Q;var U;var W=false;if(e){Q=e.getItems();Q.some(function(X){U=X.getCells()[N.COLUMN_NAME_IDX];if(U&&U.getValueState&&(U.getValueState()===E.Error)){W=true;}return W;});}return W;};
N.prototype._getFilters=function(e){var Q=[];if(e){Q.push(e);}Q.push(this._getVisibleFilter());if(this.getShowFavorites()){Q.push(this._getFilterFavorites());}return Q;};
N.prototype._getVisibleFilter=function(){return new F({path:"visible",operator:a.EQ,value1:true});};
N.prototype._getFilterFavorites=function(){return new F({path:"favorite",operator:a.EQ,value1:true});};
N.prototype._checkVariantNameConstraints=function(e,Q,U){if(!e){return;}var W=e.getValue();W=W.trim();if(!this._checkIsDuplicate(W,U)){if(W===""){e.setValueState(E.Error);e.setValueStateText(this._oRb.getText("VARIANT_MANAGEMENT_ERROR_EMPTY"));}else if(W.indexOf('{')>-1){e.setValueState(E.Error);e.setValueStateText(this._oRb.getText("VARIANT_MANAGEMENT_NOT_ALLOWED_CHAR",["{"]));}else if(W.length>N.MAX_NAME_LEN){e.setValueState(E.Error);e.setValueStateText(this._oRb.getText("VARIANT_MANAGEMENT_MAX_LEN",[N.MAX_NAME_LEN]));}else{e.setValueState(E.None);e.setValueStateText(null);}}else{e.setValueState(E.Error);e.setValueStateText(this._oRb.getText("VARIANT_MANAGEMENT_ERROR_DUPLICATE"));}if(Q){if(e.getValueState()===E.Error){Q.setEnabled(false);}else{Q.setEnabled(true);}}};
N.prototype._checkIsDuplicate=function(e,Q){var U=false;var W=this._getItems();var X=e.toLowerCase();W.some(function(Y){if(Y.title.toLowerCase()===X){if(Q&&(Q===Y.key)){return false;}U=true;}return U;});return U;};
N.prototype.exit=function(){var e;if(this.oDefault&&!this.oDefault._bIsBeingDestroyed){this.oDefault.destroy();}this.oDefault=undefined;if(this.oExecuteOnSelect&&!this.oExecuteOnSelect._bIsBeingDestroyed){this.oExecuteOnSelect.destroy();}this.oExecuteOnSelect=undefined;this._oRb=undefined;this.oContext=undefined;this._oVariantList=undefined;this.oVariantSelectionPage=undefined;this.oVariantLayout=undefined;this.oVariantText=undefined;this.oVariantPopoverTrigger=undefined;this.oVariantInvisibleText=undefined;this._oSearchField=undefined;this._oSearchFieldOnMgmtDialog=undefined;e=this.getModel(N.INNER_MODEL_NAME);if(e){e.destroy();}};
return N;},true);
sap.ui.predefine('sap/ui/fl/variants/VariantModel',["sap/ui/model/json/JSONModel","sap/ui/fl/Utils","sap/ui/fl/LayerUtils","sap/ui/core/util/reflection/JsControlTreeModifier","sap/ui/fl/Change","sap/ui/fl/changeHandler/Base","sap/ui/core/BusyIndicator","sap/ui/fl/apply/_internal/variants/URLHandler","sap/base/util/merge","sap/base/util/includes","sap/base/util/ObjectPath"],function(J,U,L,a,C,B,b,c,f,i,O){"use strict";var r=function(){var v=Object.keys(this.oData);v.forEach(function(s){var p={variantManagementReference:s,currentVariantReference:this.oData[s].currentVariant||this.oData[s].defaultVariant,newVariantReference:true};var m=this.oChangePersistence.loadSwitchChangesMapForComponent(p);this._oVariantSwitchPromise=this._oVariantSwitchPromise.then(this.oFlexController.revertChangesOnControl.bind(this.oFlexController,m.changesToBeReverted,this.oAppComponent)).then(function(){delete this.oData[s];delete this.oVariantController.getChangeFileContent()[s];this._ensureStandardVariantExists(s);}.bind(this));}.bind(this));c.initialize({model:this});c.update({parameters:[],updateHashEntry:true,model:this});return this._oVariantSwitchPromise;};
var V=J.extend("sap.ui.fl.variants.VariantModel",{constructor:function(d,F,A,o){this.pSequentialImportCompleted=Promise.resolve();J.apply(this,arguments);this.bObserve=o;if(!F){F=sap.ui.requireSync("sap/ui/fl/FlexControllerFactory").createForControl(A);}this.oFlexController=F;this.oChangePersistence=this.oFlexController._oChangePersistence;this.oVariantController=this.oChangePersistence._oVariantController;this.oAppComponent=A;this._oResourceBundle=sap.ui.getCore().getLibraryResourceBundle("sap.ui.fl");this._oVariantSwitchPromise=Promise.resolve();this.oVariantController.assignResetMapListener(r.bind(this));c.initialize({model:this});if(d&&typeof d==="object"){Object.keys(d).forEach(function(k){d[k].variants.forEach(function(v){if(!d[k].currentVariant&&(v.key===d[k].defaultVariant)){d[k].currentVariant=v.key;}v.originalTitle=v.title;v.originalFavorite=v.favorite;v.originalVisible=v.visible;});d[k].originalCurrentVariant=d[k].currentVariant;d[k].originalDefaultVariant=d[k].defaultVariant;});this.setData(d);}}});
V.prototype.updateCurrentVariant=function(v,n,A){var s;var m;s=this.oData[v].originalCurrentVariant;var p={variantManagementReference:v,currentVariantReference:s,newVariantReference:n};m=this.oChangePersistence.loadSwitchChangesMapForComponent(p);var S=function(){var P={};P.promise=new Promise(function(d){P.resolveFunction=d;});this.oFlexController.setVariantSwitchPromise(P.promise);this.oFlexController.revertChangesOnControl(m.changesToBeReverted,A||this.oAppComponent).then(this.oFlexController.applyVariantChanges.bind(this.oFlexController,m.changesToBeApplied,A||this.oAppComponent)).then(function(){this.oData[v].originalCurrentVariant=n;this.oData[v].currentVariant=n;if(this.oData[v].updateVariantInURL){c.updateVariantInURL({vmReference:v,newVReference:n,model:this});this.oVariantController.updateCurrentVariantInMap(v,n);}this.checkUpdate();P.resolveFunction();}.bind(this)).catch(function(e){P.resolveFunction();throw e;});return P.promise;}.bind(this);this._oVariantSwitchPromise=this._oVariantSwitchPromise.then(S);return this._oVariantSwitchPromise;};
V.prototype.getCurrentVariantReference=function(v){return this.oData[v].currentVariant;};
V.prototype.getVariantManagementReference=function(v){var s="";var I=-1;Object.keys(this.oData).some(function(k){return this.oData[k].variants.some(function(o,d){if(o.key===v){s=k;I=d;return true;}});}.bind(this));return{variantManagementReference:s,variantIndex:I};};
V.prototype.getVariant=function(v,s){return this.oVariantController.getVariant(s||this.getVariantManagementReference(v).variantManagementReference,v);};
V.prototype.getVariantProperty=function(v,p){return this.getVariant(v).content.content[p];};
V.prototype.addChange=function(o){var v=o.getVariantReference();var s=this.getVariantManagementReference(v).variantManagementReference;this.oData[s].modified=!!this.oData[s].variantsEditable;this.checkUpdate(true);return this.oVariantController.addChangeToVariant(o,s,v);};
V.prototype.removeChange=function(o){var v=o.getVariantReference();var s=this.getVariantManagementReference(v).variantManagementReference;return this.oVariantController.removeChangeFromVariant(o,s,v);};
V.prototype._removeDirtyChanges=function(v,s,d,A){var e=this._getDirtyChangesFromVariantChanges(v);e.forEach(function(o){this.oVariantController.removeChangeFromVariant(o,s,d);this.oFlexController.deleteChange(o,A);}.bind(this));};
V.prototype._getVariantTitleCount=function(n,v){var d=this.getData();return d[v].variants.reduce(function(e,o){if(n.toLowerCase()===o.title.toLowerCase()&&o.visible){e++;}return e;},0);};
V.prototype._duplicateVariant=function(p){var n=p.newVariantReference;var s=p.sourceVariantReference;var v=p.variantManagementReference;var S=this.getVariant(s);var d=this.oVariantController.getVariantChanges(v,s,true).map(function(h){return h.getDefinition();});var D={content:{},controlChanges:d,variantChanges:{}};var e=L.compareAgainstCurrentLayer(S.content.layer,!this._bDesignTimeMode?"USER":"");Object.keys(S.content).forEach(function(k){if(k==="fileName"){D.content[k]=n;}else if(k==="variantReference"){if(e===0){D.content[k]=S.content["variantReference"];}else if(e===-1){D.content[k]=s;}}else if(k==="content"){D.content[k]=JSON.parse(JSON.stringify(S.content[k]));D.content.content.title=p.title;}else{D.content[k]=S.content[k];}});D.content["layer"]=p.layer;d=D.controlChanges.slice();var o={};var g;D.controlChanges=d.reduce(function(h,j){if(L.compareAgainstCurrentLayer(j.layer,!this._bDesignTimeMode?"USER":"")===0){o=f({},j);o.variantReference=D.content.fileName;if(!o.support){o.support={};}o.support.sourceChangeFileName=j.fileName;o.packageName="$TMP";g=C.createInitialFileContent(o);h.push(new C(g));}return h;}.bind(this),[]);return D;};
V.prototype.copyVariant=function(p){var d=this._duplicateVariant(p);var v={key:d.content.fileName,layer:p.layer,title:d.content.content.title,originalTitle:d.content.content.title,favorite:true,originalFavorite:true,rename:true,change:true,remove:true,visible:true,originalVisible:true};var o=this.oFlexController.createVariant(d,p.appComponent);var e=[];[o].concat(o.getControlChanges()).forEach(function(g){e.push(this.oChangePersistence.addDirtyChange(g));}.bind(this));var I=this.oVariantController.addVariantToVariantManagement(f({},o.getDefinitionWithChanges(),{content:{content:{visible:v.visible,favorite:v.favorite}}}),p.variantManagementReference);this.oData[p.variantManagementReference].variants.splice(I,0,v);return this.updateCurrentVariant(p.variantManagementReference,o.getId(),p.appComponent).then(function(){return e;});};
V.prototype.removeVariant=function(p){var d=this.oChangePersistence.getDirtyChanges().filter(function(o){return(o.getVariantReference&&o.getVariantReference()===p.variant.getId())||o.getId()===p.variant.getId();});return this.updateCurrentVariant(p.variantManagementReference,p.sourceVariantReference,p.component).then(function(){var I=this.oVariantController.removeVariantFromVariantManagement(p.variant,p.variantManagementReference);this.oData[p.variantManagementReference].variants.splice(I,1);this.checkUpdate();d.forEach(function(o){this.oChangePersistence.deleteChange(o);}.bind(this));}.bind(this));};
V.prototype.collectModelChanges=function(v,l){var d=this.getData()[v];var m=d.variants;var e=[];var p={};m.forEach(function(o){if(o.originalTitle!==o.title){p={variantReference:o.key,changeType:"setTitle",title:o.title,originalTitle:o.originalTitle,layer:l};e.push(p);}if(o.originalFavorite!==o.favorite){p={variantReference:o.key,changeType:"setFavorite",favorite:o.favorite,originalFavorite:o.originalFavorite,layer:l};e.push(p);}if(!o.visible&&o.originalVisible){p={variantReference:o.key,changeType:"setVisible",visible:false,layer:l};e.push(p);}});if(d.originalDefaultVariant!==d.defaultVariant){p={variantManagementReference:v,changeType:"setDefault",defaultVariant:d.defaultVariant,originalDefaultVariant:d.originalDefaultVariant,layer:l};e.push(p);}return e;};
V.prototype.manageVariants=function(v,s,l,d){return new Promise(function(e){v.attachEventOnce("manage",{resolve:e,variantManagementReference:s,layer:l},this.fnManageClickRta,this);v.openManagementDialog(true,d);}.bind(this));};
V.prototype.setVariantProperties=function(v,p,A){var d=-1;var o;var e=null;var D=this.getData();if(p.variantReference){d=this.getVariantManagementReference(p.variantReference).variantIndex;o=D[v].variants[d];}var n={};var m={};switch(p.changeType){case"setTitle":m.title=p.title;o.title=p.title;o.originalTitle=o.title;break;case"setFavorite":m.favorite=p.favorite;o.favorite=p.favorite;o.originalFavorite=o.favorite;break;case"setVisible":m.visible=p.visible;m.createdByReset=false;o.visible=p.visible;o.originalVisible=o.visible;break;case"setDefault":m.defaultVariant=p.defaultVariant;D[v].defaultVariant=p.defaultVariant;D[v].originalDefaultVariant=D[v].defaultVariant;var h=c.getStoredHashParams({model:this});if(h){if(D[v].defaultVariant!==D[v].currentVariant&&h.indexOf(D[v].currentVariant)===-1){c.update({parameters:h.concat(D[v].currentVariant),updateURL:!this._bDesignTimeMode,updateHashEntry:true,model:this});}else if(D[v].defaultVariant===D[v].currentVariant&&h.indexOf(D[v].currentVariant)>-1){h.splice(h.indexOf(D[v].currentVariant),1);c.update({parameters:h,updateURL:!this._bDesignTimeMode,updateHashEntry:true,model:this});}}break;default:break;}if(d>-1){var s=this.oVariantController._setVariantData(m,v,d);D[v].variants.splice(d,1);D[v].variants.splice(s,0,o);}else if(this.oVariantController._mVariantManagement[v]){this.oVariantController._mVariantManagement[v].defaultVariant=p.defaultVariant;}if(A===true){n.changeType=p.changeType;n.layer=p.layer;if(p.changeType==="setDefault"){n.fileType="ctrl_variant_management_change";n.selector=a.getSelector(v,p.appComponent);}else{if(p.changeType==="setTitle"){B.setTextInChange(n,"title",p.title,"XFLD");}n.fileType="ctrl_variant_change";n.selector=a.getSelector(p.variantReference,p.appComponent);}e=this.oFlexController.createBaseChange(n,p.appComponent);e.setContent(m);this.oVariantController._updateChangesForVariantManagementInMap(e.getDefinition(),v,true);this.oChangePersistence.addDirtyChange(e);}else{if(p.change){this.oVariantController._updateChangesForVariantManagementInMap(p.change.getDefinition(),v,false);this.oChangePersistence.deleteChange(p.change);}}this.setData(D);this.checkUpdate(true);return e;};
V.prototype._ensureStandardVariantExists=function(v){if(!this.oVariantController){throw new Error("An sap.ui.fl.variants.VariantController instance was not found.");}var d=this.getData();if(!d[v]){d[v]={currentVariant:v,originalCurrentVariant:v,defaultVariant:v,originalDefaultVariant:v,variants:[{key:v,title:this._oResourceBundle.getText("STANDARD_VARIANT_TITLE"),originalTitle:this._oResourceBundle.getText("STANDARD_VARIANT_ORIGINAL_TITLE"),favorite:true,originalFavorite:true,visible:true,originalVisible:true,author:this.oVariantController.DEFAULT_AUTHOR}]};this.setData(d);var o={changes:{variantSection:{}}};var D={defaultVariant:v,variantManagementChanges:{},variants:[{content:{fileName:v,fileType:"ctrl_variant",variantManagementReference:v,variantReference:"",support:{user:this.oVariantController.DEFAULT_AUTHOR},content:{title:this._oResourceBundle.getText("STANDARD_VARIANT_TITLE")}},controlChanges:[],variantChanges:{}}]};o.changes.variantSection[v]=D;this.oVariantController.setChangeFileContent(o,{});}};
V.prototype.setModelPropertiesForControl=function(v,d,o){var R=function(g,v,d){if((g.layer===L.getCurrentLayer(!d))&&(g.key!==v)){return true;}return false;};this.oData[v].modified=false;this.oData[v].showFavorites=true;var e=this._bDesignTimeMode;if(e!==d){this._bDesignTimeMode=d;if(d){c.clearAllVariantURLParameters({model:this});}else if(e){c.update({parameters:c.getStoredHashParams({model:this}),updateURL:true,updateHashEntry:false,model:this});}}if(!(typeof this.fnManageClick==="function"&&typeof this.fnManageClickRta==="function")){this._initializeManageVariantsEvents();}o.detachManage(this.fnManageClick,this);if(d){this.oData[v].variantsEditable=false;this.oData[v].variants.forEach(function(g){g.rename=true;g.change=true;g.remove=R(g,v,d);});}else{if(this.oData[v]._isEditable){o.attachManage({variantManagementReference:v},this.fnManageClick,this);this.oData[v].variantsEditable=true;this.oData[v].variants.forEach(function(g){g.remove=R(g,v,d);if(g.layer===L.getCurrentLayer(true)){g.rename=true;g.change=true;}else{g.rename=false;g.change=false;}});}else{this.oData[v].variantsEditable=false;this.oData[v].variants.forEach(function(g){g.remove=false;g.rename=false;g.change=false;});}}};
V.prototype._initializeManageVariantsEvents=function(){this.fnManageClickRta=function(e,d){var g=this.collectModelChanges(d.variantManagementReference,d.layer);d.resolve(g);};this.fnManageClick=function(e,d){if(!this.oFlexController||!this.oVariantController){return;}var g=this.collectModelChanges(d.variantManagementReference,L.getCurrentLayer(true));g.forEach(function(o){o.appComponent=this.oAppComponent;this.setVariantProperties(d.variantManagementReference,o,true);}.bind(this));this.oChangePersistence.saveDirtyChanges();};};
V.prototype._handleCurrentVariantChange=function(e,o){var p=e.getSource();var v=p.getContext().getPath().replace(/^\//,'');if(O.get([v,"currentVariant"],this.oData)&&this.oData[v].currentVariant!==this.oData[v].originalCurrentVariant){var s=this.oData[v].originalCurrentVariant;this.updateCurrentVariant(v,p.getValue(),U.getAppComponentForControl(o)).then(function(){if(this.oData[v].modified){var S=this.oVariantController.getVariantChanges(v,s,true);this.oData[v].modified=false;this.checkUpdate(true);this._removeDirtyChanges(S,v,s,this.oAppComponent);}}.bind(this));}};
V.prototype._handleSave=function(e){var v=e.getSource();var s=e.getParameter("def");var A=U.getAppComponentForControl(v);var d=this.getLocalId(v.getId(),A);var S=this.getCurrentVariantReference(d);var g=this.oVariantController.getVariantChanges(d,S,true);if(e.getParameter("overwrite")){return this.oFlexController.saveSequenceOfDirtyChanges(this._getDirtyChangesFromVariantChanges(g)).then(function(R){this.checkDirtyStateForControlModels([d]);return R;}.bind(this));}var n=U.createDefaultFileName();var p={variantManagementReference:d,appComponent:A,layer:L.getCurrentLayer(true),title:e.getParameter("name"),sourceVariantReference:S,newVariantReference:n};return this.copyVariant(p).then(function(h){if(s){var P={changeType:"setDefault",defaultVariant:n,originalDefaultVariant:this.oData[d].defaultVariant,appComponent:A,layer:L.getCurrentLayer(true),variantManagementReference:d};var o=this.setVariantProperties(d,P,true);h.push(o);}this.oData[d].modified=false;this.checkUpdate(true);return this.oFlexController.saveSequenceOfDirtyChanges(h);}.bind(this)).then(this._removeDirtyChanges.bind(this,g,d,S,p.appComponent));};
V.prototype.getLocalId=function(I,A){return a.getSelector(I,A).id;};
V.prototype.getVariantManagementReferenceForControl=function(v){var s=v.getId();var A=U.getAppComponentForControl(v);return(A&&A.getLocalId(s))||s;};
V.prototype.switchToDefaultForVariantManagement=function(v){if(this.oData[v].currentVariant!==this.oData[v].defaultVariant){b.show(200);this.updateCurrentVariant(v,this.oData[v].defaultVariant).then(function(){b.hide();});}};
V.prototype.switchToDefaultForVariant=function(v){Object.keys(this.oData).forEach(function(s){if(!v||this.oData[s].currentVariant===v){this.switchToDefaultForVariantManagement(s);}}.bind(this));};
V.prototype.registerToModel=function(v){var s=this.getVariantManagementReferenceForControl(v);this._ensureStandardVariantExists(s);this.oData[s]._isEditable=v.getEditable();v.getTitle().getBinding("text").attachEvent("change",v,this._handleCurrentVariantChange,this);v.attachSave(this._handleSave,this);this.setModelPropertiesForControl(s,false,v);var u=v.getUpdateVariantInURL();this.oData[s].updateVariantInURL=u;c.attachHandlers({vmReference:s,updateURL:!!u,model:this});c.handleModelContextChange({model:this,vmControl:v});};
V.prototype._getDirtyChangesFromVariantChanges=function(d){var e=d.map(function(o){return o.getDefinition().fileName;});return this.oChangePersistence.getDirtyChanges().filter(function(o){return i(e,o.getId());});};
V.prototype.checkDirtyStateForControlModels=function(v){v.forEach(function(s){var m=this.oData[s];if(m.modified===true){var d=this.getCurrentVariantReference(s);var e=this.oVariantController.getVariantChanges(s,d,true);var D=this._getDirtyChangesFromVariantChanges(e);if(D.length===0){m.modified=false;}}}.bind(this));this.checkUpdate(true);};
V.prototype.getCurrentControlVariantIds=function(){return Object.keys(this.oData||{}).reduce(function(d,v){return d.concat([this.oData[v].currentVariant]);}.bind(this),[]);};
return V;},true);
sap.ui.predefine('sap/ui/fl/write/_internal/CompatibilityConnector',["sap/ui/fl/apply/_internal/Connector","sap/ui/fl/write/_internal/Connector"],function(A,W){"use strict";var C=function(){};
C.prototype.loadChanges=function(c){return A.loadFlexData({reference:c.name,appVersion:c.appVersion}).then(function(f){return{changes:f,loadModules:false};});};
C.prototype.loadSettings=function(){return W.loadFeatures();};
C.prototype.create=function(f,c,i){var F=f;if(!Array.isArray(F)){F=[f];}return W.write({layer:F[0].layer,flexObjects:F,_transport:c,isLegacyVariant:i});};
C.prototype.update=function(f,c){return W.update({flexObject:f,layer:f.layer,_transport:c});};
C.prototype.deleteChange=function(f,c){return W.remove({flexObject:f,layer:f.layer,_transport:c});};
C.prototype.getFlexInfo=function(p){return W.getFlexInfo(p);};
C.prototype.resetChanges=function(p){return W.reset({reference:p.sReference,layer:p.sLayer,appVersion:p.sAppVersion,generator:p.sGenerator,selectorIds:p.aSelectorIds,changeTypes:p.aChangeTypes});};
return C;},true);
sap.ui.predefine('sap/ui/fl/write/_internal/Connector',["sap/ui/fl/apply/_internal/connectors/Utils","sap/ui/fl/write/_internal/connectors/Utils","sap/ui/fl/write/_internal/connectors/ConnectorFeaturesMerger"],function(A,W,C){"use strict";
function f(l,c){var F=c.filter(function(o){return o.layers.indexOf("ALL")!==-1||o.layers.indexOf(l)!==-1;});if(F.length===1){return F[0];}if(F.length===0){throw new Error("No Connector configuration could be found to write into layer: "+l);}if(F.length>1){throw new Error("sap.ui.core.Configuration 'flexibilityServices' has a misconfiguration: Multiple Connector configurations were found to write into layer: "+l);}}
function s(c){var b=c.map(function(o){return o.connectorModule.loadFeatures({url:o.url}).catch(A.logAndResolveDefault.bind(null,{},o,"loadFeatures"));});return Promise.all(b);}
function g(l){if(!l){return Promise.reject("No layer was provided");}return W.getWriteConnectors().then(f.bind(this,l));}
function e(b,p){return g(p.layer).then(function(c){p.url=c.url;return c.connectorModule[b](p);});}
var a={};
a.write=function(p){return e("write",p);};
a.remove=function(p){return e("remove",p);};
a.update=function(p){return e("update",p);};
a.reset=function(p){return e("reset",p);};
a.getFlexInfo=function(p){return e("getFlexInfo",p);};
a.loadFeatures=function(){return W.getWriteConnectors().then(s).then(C.mergeResults);};
return a;},true);
sap.ui.predefine('sap/ui/fl/write/_internal/SaveAs',["sap/ui/fl/descriptorRelated/api/DescriptorVariantFactory","sap/ui/fl/transport/TransportSelection","sap/ui/fl/descriptorRelated/api/DescriptorInlineChangeFactory","sap/ui/fl/apply/_internal/ChangesController","sap/ui/fl/Utils","sap/ui/fl/Change","sap/base/Log","sap/base/util/includes","sap/base/util/merge"],function(D,T,a,C,U,b,L,i,m){"use strict";
function _(P){if(P&&P.package&&P.transport&&P.selector&&P.selector.appId){return Promise.resolve({packageName:P.package,transport:P.transport});}return Promise.resolve({packageName:"",transport:""});}
function c(A,t){if(t){if(t.transport&&t.packageName!=="$TMP"){return A.setTransportRequest(t.transport).then(A.setPackage(t.packageName));}return Promise.resolve();}return Promise.reject();}
function d(q){var I=[];q.forEach(function(r){var s=r.getDefinition();I.push(a.createNew(s.changeType,s.content,s.texts));});return Promise.all(I);}
function e(q,A){var P={reference:A.getId()};var s=U.createNamespace(P,"changes");q.setNamespace(s);q.setComponent(A.getId());if(A.getVersion()){q.setValidAppVersions({creation:A.getVersion(),from:A.getVersion()});}}
function f(A,q){var r=[];A.forEach(function(I){I.replaceHostingIdForTextKey(q.getId(),q.getReference(),I.getContent(),I.getTexts());r.push(q.addDescriptorInlineChange(I));});return Promise.all(r);}
function g(A){var t=new T();return t.openTransportSelection(A);}
function h(A,P){if(P&&P.transport&&P.selector&&P.selector.appId){return Promise.resolve({packageName:A.getPackage(),transport:P.transport});}return g(A);}
function j(s){var q=C.getDescriptorFlexControllerInstance(s)._oChangePersistence;if(q){var r=q.getDirtyChanges();r=r.slice();return r;}return[];}
function k(s){var F=C.getFlexControllerInstance(s)._oChangePersistence;if(F){var u=F.getDirtyChanges();u=u.slice();return u;}return[];}
function l(s){var F=C.getFlexControllerInstance(s)._oChangePersistence;var q=C.getDescriptorFlexControllerInstance(s)._oChangePersistence;return F===q;}
function n(s,A,q){var r=[];if(A){j(s).forEach(function(t){if(i(a.getDescriptorChangeTypes(),t.getDefinition().changeType)){r.push(t);}else{e(t,q);}});}else{k(s).forEach(function(t){e(t,q);});r=j(s);}return r;}
function o(s){j(s).forEach(function(q){if(i(a.getDescriptorChangeTypes(),q.getChangeType())){C.getDescriptorFlexControllerInstance(s)._oChangePersistence.deleteChange(q);}});}
function p(A){return new b({fileName:A.getDefinition().fileName,fileType:A.getDefinition().fileType,packageName:A.getPackage(),namespace:A.getNamespace()});}
var S={saveAs:function(P){var A;var q;var r=false;return D.createAppVariant(P).then(function(s){A=m({},s);return _(P);}).then(function(t){return c(A,t);}).then(function(){r=l(P.selector);var s=n(P.selector,r,A);return d(s);}).then(function(s){return f(s,A);}).then(function(){return A.submit().catch(function(E){E.messageKey="MSG_SAVE_APP_VARIANT_FAILED";E.saveAsFailed=true;throw E;});}).then(function(R){q=m({},R);if(r){o(P.selector);}var F=C.getFlexControllerInstance(P.selector);var u=k(P.selector);if(u.length){return F.saveAll(true).catch(function(E){if(r){o(P.selector);}return this.deleteAppVar({referenceAppId:P.id}).then(function(){E.messageKey="MSG_COPY_UNSAVED_CHANGES_FAILED";throw E;});}.bind(this));}return Promise.resolve();}.bind(this)).then(function(){if(!r){o(P.selector);}return q;}).catch(function(E){L.error("the app variant could not be created.",E.message||E.name);throw E;});},deleteAppVar:function(P){var A;return D.loadAppVariant(P.referenceAppId,true).catch(function(E){E.messageKey="MSG_LOAD_APP_VARIANT_FAILED";throw E;}).then(function(q){A=m({},q);var r=p(q);return h(r,P);}).then(function(t){if(t==="cancel"){return Promise.reject("cancel");}if(t){if(t.transport){return A.setTransportRequest(t.transport);}return t;}throw new Error("Transport information could not be determined");}).then(function(){return A.submit().catch(function(E){E.messageKey="MSG_DELETE_APP_VARIANT_FAILED";throw E;});}).catch(function(E){if(E!=="cancel"){L.error("the app variant could not be deleted.",E.message||E.name);throw E;}});}};return S;},true);
sap.ui.predefine('sap/ui/fl/write/_internal/connectors/BrowserStorageConnector',["sap/base/util/merge","sap/ui/fl/write/connectors/BaseConnector","sap/ui/fl/apply/_internal/connectors/BrowserStorageUtils"],function(m,B,a){"use strict";
function s(p,c){var d=true;if(p.selectorIds){if(c.selector){d=p.selectorIds.indexOf(c.selector.id)>-1;}else{d=false;}}if(d&&p.changeTypes){d=p.changeTypes.indexOf(c.changeType)>-1;}return d;}
var b=m({},B,{oStorage:undefined,layers:["ALL"],write:function(p){p.flexObjects.forEach(function(f){var c=a.createFlexObjectKey(f);var C;C=JSON.stringify(f);this.oStorage.setItem(c,C);}.bind(this));return Promise.resolve();},update:function(p){var c=a.createFlexObjectKey(p.flexObject);var C=JSON.stringify(p.flexObject);this.oStorage.setItem(c,C);return Promise.resolve();},reset:function(p){a.forEachChangeInStorage({storage:this.oStorage,reference:p.reference,layer:p.layer},function(f){if(s(p,f.changeDefinition)){this.oStorage.removeItem(f.key);}}.bind(this));return Promise.resolve();},remove:function(p){var c=a.createFlexObjectKey(p.flexObject);this.oStorage.removeItem(c);return Promise.resolve();},loadFeatures:function(){return Promise.resolve({});},getFlexInfo:function(p){p.storage=this.oStorage;return Promise.resolve({isResetEnabled:a.getAllFlexObjects(p).length>0});}});return b;},true);
sap.ui.predefine('sap/ui/fl/write/_internal/connectors/ConnectorFeaturesMerger',[],function(){"use strict";var D={isKeyUser:false,isVariantSharingEnabled:false,isAtoAvailable:false,isAtoEnabled:false,isProductiveSystem:true,isZeroDowntimeUpgradeRunning:false,system:"",client:""};return{mergeResults:function(r){var R=D;r.forEach(function(o){Object.keys(o).forEach(function(k){R[k]=o[k];});});return R;}};});
sap.ui.predefine('sap/ui/fl/write/_internal/connectors/JsObjectConnector',["sap/base/util/merge","sap/ui/fl/apply/_internal/connectors/JsObjectConnector","sap/ui/fl/write/_internal/connectors/BrowserStorageConnector"],function(m,L,B){"use strict";var J=m({},B,{oStorage:L.oStorage});return J;},true);
sap.ui.predefine('sap/ui/fl/write/_internal/connectors/KeyUserConnector',["sap/base/util/merge","sap/ui/fl/write/connectors/BaseConnector","sap/ui/fl/apply/_internal/connectors/KeyUserConnector","sap/ui/fl/apply/_internal/connectors/Utils","sap/ui/fl/write/_internal/connectors/Utils","sap/ui/fl/library","sap/base/util/restricted/_pick"],function(m,B,A,a,W,f,_){"use strict";var P="/flex/keyuser";var b="/v1";var R={CHANGES:P+b+"/changes/",SETTINGS:P+b+"/settings",TOKEN:P+b+"/settings"};
function c(p){if(p.flexObject){p.fileName=p.flexObject.fileName;}var w=a.getUrl(R.CHANGES,p);delete p.fileName;var t=a.getUrl(R.TOKEN,p);var r=W.getRequestOptions(A,t,p.flexObjects||p.flexObject,"application/json; charset=utf-8","json");return W.sendRequest(w,p.method,r);}
var K=m({},B,{xsrfToken:null,layers:[f.Layer.CUSTOMER],reset:function(p){var d=["reference","appVersion","generator"];var e=_(p,d);if(p.selectorIds){e.selector=p.selectorIds;}if(p.changeTypes){e.changeType=p.changeTypes;}delete p.reference;var r=a.getUrl(R.CHANGES,p,e);var t=a.getUrl(R.SETTINGS,p);var o=W.getRequestOptions(A,t);return W.sendRequest(r,"DELETE",o);},write:function(p){p.method="POST";return c(p);},update:function(p){p.method="PUT";return c(p);},remove:function(p){var d={namespace:p.flexObject.namespace};p.fileName=p.flexObject.fileName;var D=a.getUrl(R.CHANGES,p,d);delete p.fileName;var t=a.getUrl(R.TOKEN,p);var r=W.getRequestOptions(A,t,undefined,"application/json; charset=utf-8","json");return W.sendRequest(D,"DELETE",r);},loadFeatures:function(p){var F=a.getUrl(R.SETTINGS,p);return a.sendRequest(F).then(function(r){return r.response;});}});return K;},true);
sap.ui.predefine('sap/ui/fl/write/_internal/connectors/LocalStorageConnector',["sap/base/util/merge","sap/ui/fl/write/_internal/connectors/BrowserStorageConnector"],function(m,B){"use strict";var L=m({},B,{oStorage:window.localStorage});return L;},true);
sap.ui.predefine('sap/ui/fl/write/_internal/connectors/LrepConnector',["sap/base/util/merge","sap/ui/fl/write/connectors/BaseConnector","sap/ui/fl/apply/_internal/connectors/LrepConnector","sap/ui/fl/apply/_internal/connectors/Utils","sap/ui/fl/write/_internal/connectors/Utils","sap/ui/fl/Utils","sap/base/util/restricted/_pick"],function(m,B,A,a,W,F,_){"use strict";var R={FLEX_INFO:"/flex/info/",PUBLISH:"/actions/make_changes_transportable/",CHANGES:"/changes/",VARIANTS:"/variants/",SETTINGS:"/flex/settings"};var d=function(p){var r=p.isLegacyVariant?R.VARIANTS:R.CHANGES;var P=p.transport?{changelist:p.transport}:undefined;if(p.flexObject){p.fileName=p.flexObject.fileName;}var w=a.getUrl(r,p,P);delete p.fileName;var t=a.getUrl(R.SETTINGS,p);var o=W.getRequestOptions(A,t,p.flexObjects||p.flexObject,"application/json; charset=utf-8","json");return W.sendRequest(w,p.method,o);};var L=m({},B,{layers:["ALL"],reset:function(p){var P=["reference","layer","appVersion","changelist","generator"];var b=_(p,P);var c=F.getUrlParameter("sap-client");if(c){b["sap-client"]=c;}if(p.selectorIds){b.selector=p.selectorIds;}if(p.changeTypes){b.changeType=p.changeTypes;}delete p.reference;var D=a.getUrl(R.CHANGES,p,b);return a.sendRequest(D,"DELETE");},publish:function(p){var P=["reference","layer","appVersion","changelist","package"];var b=_(p,P);var c=F.getUrlParameter("sap-client");if(c){b["sap-client"]=c;}delete p.reference;var D=a.getUrl(R.PUBLISH,p,b);return a.sendRequest(D,"POST");},getFlexInfo:function(p){var P=["layer","appVersion"];var b=_(p,P);var c=F.getUrlParameter("sap-client");if(c){b["sap-client"]=c;}var D=a.getUrl(R.FLEX_INFO,p,b);return a.sendRequest(D);},loadFeatures:function(p){var P={};var c=F.getUrlParameter("sap-client");if(c){P["sap-client"]=c;}var f=a.getUrl(R.SETTINGS,p,P);return a.sendRequest(f);},write:function(p){p.method="POST";return d(p);},update:function(p){if(p.flexObject.fileType==="variant"){p.isLegacyVariant=true;}p.method="PUT";return d(p);},remove:function(p){var P={namespace:p.flexObject.namespace,layer:p.flexObject.layer};if(p.transport){P.changelist=p.transport;}p.fileName=p.flexObject.fileName;var D=a.getUrl(R.CHANGES,p,P);delete p.fileName;var t=a.getUrl(R.SETTINGS,p);var r=W.getRequestOptions(A,t,undefined,"application/json; charset=utf-8","json");return W.sendRequest(D,"DELETE",r);}});return L;},true);
sap.ui.predefine('sap/ui/fl/write/_internal/connectors/PersonalizationConnector',["sap/base/util/merge","sap/ui/fl/write/connectors/BaseConnector","sap/ui/fl/apply/_internal/connectors/PersonalizationConnector","sap/ui/fl/apply/_internal/connectors/Utils","sap/ui/fl/write/_internal/connectors/Utils","sap/ui/fl/library","sap/base/util/restricted/_pick"],function(m,B,A,a,W,f,_){"use strict";var P="/flex/personalization";var b="/v1";var R={CHANGES:P+b+"/changes/",TOKEN:P+b+"/actions/getcsrftoken"};var F={isProductiveSystem:true};
function c(p){if(p.flexObject){p.fileName=p.flexObject.fileName;}var w=a.getUrl(R.CHANGES,p);delete p.fileName;var t=a.getUrl(R.TOKEN,p);var r=W.getRequestOptions(A,t,p.flexObjects||p.flexObject,"application/json; charset=utf-8","json");return W.sendRequest(w,p.method,r);}
var d=m({},B,{layers:[f.Layer.USER],write:function(p){p.method="POST";return c(p);},update:function(p){p.method="PUT";return c(p);},remove:function(p){var e={namespace:p.flexObject.namespace};p.fileName=p.flexObject.fileName;var D=a.getUrl(R.CHANGES,p,e);delete p.fileName;var t=a.getUrl(R.TOKEN,p);var r=W.getRequestOptions(A,t,undefined,"application/json; charset=utf-8","json");return W.sendRequest(D,"DELETE",r);},reset:function(p){var e=["reference","appVersion","generator"];var g=_(p,e);if(p.selectorIds){g.selector=p.selectorIds;}if(p.changeTypes){g.changeType=p.changeTypes;}delete p.reference;var r=a.getUrl(R.CHANGES,p,g);var t=a.getUrl(R.TOKEN,p);var o=W.getRequestOptions(A,t);return W.sendRequest(r,"DELETE",o);},loadFeatures:function(){return Promise.resolve(F);}});return d;},true);
sap.ui.predefine('sap/ui/fl/write/_internal/connectors/SessionStorageConnector',["sap/base/util/merge","sap/ui/fl/write/_internal/connectors/BrowserStorageConnector"],function(m,B){"use strict";var S=m({},B,{oStorage:window.sessionStorage});return S;},true);
sap.ui.predefine('sap/ui/fl/write/_internal/connectors/Utils',["sap/ui/fl/apply/_internal/connectors/Utils"],function(A){"use strict";var W="sap/ui/fl/write/_internal/connectors/";
function u(p){return A.sendRequest(p.tokenUrl,"HEAD").then(function(r){if(r&&r.xsrfToken){p.applyConnector.xsrfToken=r.xsrfToken;p.xsrfToken=r.xsrfToken;return p;}});}
function a(p,U,m){return u(p).then(A.sendRequest.bind(undefined,U,m)).then(function(r){return r.response;});}
function b(s,t,k){if(!t[k]){t[k]=s[k];return;}if(Array.isArray(t[k])){t[k]=t[k].concat(s[k]);return;}if(typeof t[k]==='object'){Object.keys(s[k]).forEach(function(i){b(s[k],t[k],i);});}t[k]=s[k];}
return{getWriteConnectors:function(){return A.getConnectors(W,false);},getRequestOptions:function(o,t,f,c,d){var O={xsrfToken:o.xsrfToken,tokenUrl:t,applyConnector:o};if(f){O.payload=JSON.stringify(f);}if(c){O.contentType=c;}if(d){O.dataType=d;}return O;},sendRequest:function(U,m,p){if(!p.applyConnector||!p.applyConnector.xsrfToken){return a(p,U,m);}return A.sendRequest(U,m,p).then(function(r){return r;}).catch(function(f){if(f.status===403){return a(p,U,m);}throw f;});},mergeResults:function(r){var R={};r.forEach(function(o){Object.keys(o).forEach(function(k){b(o,R,k);});});return R;}};});
sap.ui.predefine('sap/ui/fl/write/api/ChangesWriteAPI',["sap/ui/fl/apply/_internal/ChangesController","sap/ui/fl/descriptorRelated/api/DescriptorInlineChangeFactory","sap/ui/fl/descriptorRelated/api/DescriptorChangeFactory","sap/base/Log","sap/ui/core/Component","sap/ui/core/Element","sap/base/util/includes","sap/ui/core/util/reflection/JsControlTreeModifier","sap/base/util/restricted/_omit"],function(C,D,a,L,b,E,i,J,_){"use strict";var c={create:function(p){var f;if(i(D.getDescriptorChangeTypes(),p.changeSpecificData.changeType)){f=C.getDescriptorFlexControllerInstance(p.selector);var r=f.getComponentName();var l;if(p.changeSpecificData.layer){l=p.changeSpecificData.layer;delete p.changeSpecificData.layer;}return D.createDescriptorInlineChange(p.changeSpecificData.changeType,p.changeSpecificData.content,p.changeSpecificData.texts).then(function(A){return new a().createNew(r,A,l,p.selector);}).catch(function(e){L.error("the change could not be created.",e.message);throw e;});}f=C.getFlexControllerInstance(p.selector);if(p.selector instanceof b){return f.createBaseChange(p.changeSpecificData,p.selector);}return f.createChange(p.changeSpecificData,p.selector);},apply:function(p){var f=C.getFlexControllerInstance(p.element);p.appComponent=C.getAppComponentForSelector(p.element);if(!p.modifier){p.modifier=J;}var d=f.checkForOpenDependenciesForControl(p.change.getSelector(),p.modifier,p.appComponent);if(!d&&p.element instanceof E){return f.checkTargetAndApplyChange(p.change,p.element,_(p,["element","change"]));}return Promise.reject(new Error("The following Change cannot be applied because of a dependency: "+p.change.getId()));},revert:function(p){var A;if(p.element instanceof E){A=C.getAppComponentForSelector(p.element);}var r={modifier:J,appComponent:A};return C.getFlexControllerInstance(p.element||{})._revertChange(p.change,p.element,r);}};return c;},true);
sap.ui.predefine('sap/ui/fl/write/api/ControlPersonalizationWriteAPI',["sap/ui/fl/ControlPersonalizationAPI","sap/ui/fl/Utils"],function(O,U){"use strict";var C={add:function(p){p.changes.forEach(function(P){P.selectorControl=P.selectorElement;});p.controlChanges=p.changes;return O.addPersonalizationChanges(p);},reset:function(p){p.selectors=p.selectors||[];return O.resetChanges(p.selectors,p.changeTypes);},save:function(p){var a=p.selector.appComponent||U.getAppComponentForControl(p.selector);return O.saveChanges(p.changes,a);},buildSelectorFromElementIdAndType:function(p){var a=U.getAppComponentForControl(p.element);if(!a||!p.elementId||!p.elementType){throw new Error("Not enough information given to build selector.");}return{elementId:p.elementId,elementType:p.elementType,appComponent:a,id:p.elementId,controlType:p.elementType};}};return C;},true);
sap.ui.predefine('sap/ui/fl/write/api/FeaturesAPI',["sap/ui/fl/registry/Settings"],function(S){"use strict";var F={isPublishAvailable:function(){return S.getInstance().then(function(s){return!s.isProductiveSystem();});},isKeyUser:function(){return S.getInstance().then(function(s){return s.isKeyUser();});}};return F;});
sap.ui.predefine('sap/ui/fl/write/api/PersistenceWriteAPI',["sap/base/util/includes","sap/ui/core/util/reflection/JsControlTreeModifier","sap/ui/fl/apply/_internal/ChangesController","sap/ui/fl/descriptorRelated/api/DescriptorInlineChangeFactory","sap/ui/fl/write/_internal/SaveAs","sap/ui/fl/write/api/FeaturesAPI","sap/base/util/restricted/_omit","sap/base/Log"],function(i,J,C,D,S,F,_,L){"use strict";
function a(c){return(c._getMap&&i(D.getDescriptorChangeTypes(),c._getMap().changeType))||(c.getChangeType&&i(D.getDescriptorChangeTypes(),c.getChangeType()));}
function h(p){p.includeCtrlVariants=true;p.invalidateCache=false;return P._getUIChanges(p).then(function(c){return c.length>0;});}
function b(p){p.includeCtrlVariants=true;p.invalidateCache=false;return P._getUIChanges(p).then(function(c){return c.some(function(o){return o.packageName==="$TMP"||o.packageName==="";});});}
var P={hasHigherLayerChanges:function(p){return C.getFlexControllerInstance(p.selector).hasHigherLayerChanges(_(p,"selector"));},save:function(p){var f=C.getFlexControllerInstance(p.selector);var d=C.getDescriptorFlexControllerInstance(p.selector);p.invalidateCache=true;return f.saveAll(p.skipUpdateCache).then(d.saveAll.bind(d,p.skipUpdateCache)).then(P._getUIChanges.bind(null,_(p,"skipUpdateCache")));},saveAs:function(p){var f=C.getDescriptorFlexControllerInstance(p.selector);p.reference=f.getComponentName();return S.saveAs(p);},deleteAppVariant:function(p){var f=C.getDescriptorFlexControllerInstance(p.selector);p.referenceAppId=f.getComponentName();return S.deleteAppVar(p);},getResetAndPublishInfo:function(p){return Promise.all([h(p),b(p),F.isPublishAvailable()]).then(function(r){var f={isResetEnabled:r[0],isPublishEnabled:r[1]};var c=r[2];var I=!f.isResetEnabled||(c&&!f.isPublishEnabled);if(I){return C.getFlexControllerInstance(p.selector).getResetAndPublishInfo(p).then(function(R){f.isResetEnabled=f.isResetEnabled||R.isResetEnabled;f.isPublishEnabled=f.isPublishEnabled||R.isPublishEnabled;return f;}).catch(function(e){L.error("Sending request to flex/info route failed: "+e.message);return f;});}return f;});},reset:function(p){var A=C.getAppComponentForSelector(p.selector);var f=C.getFlexControllerInstance(A);var d=C.getDescriptorFlexControllerInstance(A);var c=[p.layer,p.generator,A,p.selectorIds,p.changeTypes];return f.resetChanges.apply(f,c).then(d.resetChanges.bind.apply(d.resetChanges,[d].concat(c)));},publish:function(p){p.styleClass=p.styleClass||"";var A=C.getAppComponentForSelector(p.selector);return C.getFlexControllerInstance(A)._oChangePersistence.transportAllUIChanges({},p.styleClass,p.layer,p.appVariantDescriptors);},add:function(p){if(a(p.change)){return p.change.store();}var A=C.getAppComponentForSelector(p.selector);return C.getFlexControllerInstance(A).addPreparedChange(p.change,A);},remove:function(p){if(!p.selector){throw new Error("An invalid selector was passed so change could not be removed with id: "+p.change.getId());}var A=C.getAppComponentForSelector(p.selector);if(!A){throw new Error("Invalid application component for selector, change could not be removed with id: "+p.change.getId());}if(a(p.change)){var d=C.getDescriptorFlexControllerInstance(A);d.deleteChange(p.change,A);return;}var e=J.bySelector(p.change.getSelector(),A);var f=C.getFlexControllerInstance(A);if(e){f._removeChangeFromControl(e,p.change,J);}f.deleteChange(p.change,A);},_getUIChanges:function(p){if(p.layer){p.currentLayer=p.layer;}return C.getFlexControllerInstance(p.selector)._oChangePersistence.getChangesForComponent(_(p,["invalidateCache","selector"]),p.invalidateCache);}};return P;},true);
sap.ui.predefine('sap/ui/fl/write/api/SmartVariantManagementWriteAPI',["sap/ui/fl/DefaultVariant","sap/ui/fl/StandardVariant","sap/ui/fl/apply/api/SmartVariantManagementApplyAPI","sap/ui/fl/ChangePersistenceFactory","sap/ui/fl/transport/TransportSelection"],function(D,S,a,C,T){"use strict";var b={add:function(p){var s=a._getStableId(p.control);var c=C.getChangePersistenceForControl(p.control);return c.addChangeForVariant(a._PERSISTENCY_KEY,s,p.changeSpecificData);},save:function(p){var s=a._getStableId(p.control);var c=C.getChangePersistenceForControl(p.control);return c.saveAllChangesForVariant(s);},setDefaultVariantId:function(p){var P;var c;var s=a._getStableId(p.control);var m={};m[a._PERSISTENCY_KEY]=s;var o=C.getChangePersistenceForControl(p.control);P={defaultVariantId:p.defaultVariantId,reference:o.getComponentName(),selector:m,validAppVersions:{creation:o._mComponent.appVersion,from:o._mComponent.appVersion}};var d=a._getChangeMap(p.control);c=D.updateDefaultVariantId(d,p.defaultVariantId);if(c){return c;}c=D.createChangeObject(P);var e=c.getId();d[e]=c;return c;},setExecuteOnSelect:function(p){var P;var c;var s=a._getStableId(p.control);var m={};m[a._PERSISTENCY_KEY]=s;var o=C.getChangePersistenceForControl(p.control);P={executeOnSelect:p.executeOnSelect,reference:o.getComponentName(),selector:m};var d=a._getChangeMap(p.control);c=S.updateExecuteOnSelect(d,p.executeOnSelect);if(c){return c;}c=S.createChangeObject(P);var e=c.getId();d[e]=c;return c;},_getTransportSelection:function(){return new T();}};return b;},true);
sap.ui.predefine('sap/ui/fl/write/api/UI2PersonalizationWriteAPI',["sap/ui/fl/apply/_internal/ChangesController","sap/ui/fl/Cache"],function(C,a){"use strict";var U={create:function(p){var f=C.getDescriptorFlexControllerInstance(p.selector);p.reference=f.getComponentName();if(!p.reference||!p.containerKey||!p.itemName||!p.content){return Promise.reject(new Error("not all mandatory properties were provided for the storage of the personalization"));}return a.setPersonalization({reference:p.reference,containerKey:p.containerKey,itemName:p.itemName,content:p.content});},deletePersonalization:function(p){var f=C.getDescriptorFlexControllerInstance(p.selector);p.reference=f.getComponentName();if(!p.reference||!p.containerKey||!p.itemName){return Promise.reject(new Error("not all mandatory properties were provided for the deletion of the personalization"));}return a.deletePersonalization(p.reference,p.containerKey,p.itemName);}};return U;},true);
sap.ui.predefine('sap/ui/fl/write/connectors/BaseConnector',[],function(){"use strict";var B={layers:[],write:function(){return Promise.reject("write is not implemented");},update:function(){return Promise.reject("write is not implemented");},remove:function(){return Promise.reject("remove is not implemented");},reset:function(){return Promise.reject("reset is not implemented");},publish:function(){return Promise.reject("publish is not implemented");},getFlexInfo:function(){return Promise.resolve({});},loadFeatures:function(){return Promise.reject("loadFeatures is not implemented");}};return B;},true);
/*!
 * OpenUI5
 * (c) Copyright 2009-2019 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine('sap/ui/fl/Cache',["sap/ui/fl/LrepConnector","sap/ui/fl/Utils","sap/base/strings/formatMessage","sap/base/Log","sap/ui/thirdparty/jquery","sap/base/util/LoaderExtensions","sap/base/util/ObjectPath","sap/ui/fl/apply/_internal/ConnectorResultMerger"],function(L,U,f,a,q,b,O,C){"use strict";var c=function(){};c._isOn=true;c._entries={};c._switches={};c._oFlexDataPromise=undefined;
c.getSwitches=function(){return c._switches;};
c.isActive=function(){return c._isOn;};
c.setActive=function(A){c._isOn=A;};
c.getFlexDataPromise=function(){return c._oFlexDataPromise;};
c.getEntries=function(){return c._entries;};
c.clearEntries=function(){c._entries={};};
c.getEntry=function(s,A){if(!c._entries[s]){c._entries[s]={};}if(!c._entries[s][A]){c._entries[s][A]={file:{changes:{changes:[],contexts:[],variantSection:{},ui2personalization:{}}}};}return c._entries[s][A];};
c.clearEntry=function(s,A){c.getEntry(s,A);c._entries[s][A]={};};
c._deleteEntry=function(s,A){if(c._entries[s]&&c._entries[s][A]){delete c._entries[s][A];}if(q.isEmptyObject(c._entries[s])){delete c._entries[s];}};
c.getChangesFillingCache=function(l,m,p,i){var s=m.name;var A=m.appVersion||U.DEFAULT_APP_VERSION;var o=c.getEntry(s,A);var d;p=p||{};p.isTrial=U.isTrialSystem();if(o.promise&&!i){return o.promise;}var e=c._getChangesFromBundle(p);if(p.cacheKey==="<NO CHANGES>"){d=e.then(function(h){o.file={changes:{changes:h,contexts:[],variantSection:{},ui2personalization:{}},componentClassName:s};return o.file;}).then(function(r){if(p.isTrial&&l instanceof L){return l.enableFakeConnectorForTrial(m,r);}return r;});o.promise=d;return d;}var F=l.loadChanges(m,p);var g=F.then(function(r){return r;},function(E){var M="";if(E.messages&&E.messages.length!==0&&E.messages[0].text){M=E.messages[0].text;}var h=f("Loading changes for {0} failed!\nError code: {1}\nMessage: {2}",m.name,E.code||"",M);a.error(h);return Promise.resolve({changes:{changes:[],variantSection:{},ui2personalization:{}}});});d=Promise.all([e,g]).then(function(v){var h=v[0];var j=v[1];if(j&&j.changes){var k=[{changes:h},Object.assign({},j.changes)];j.changes.changes=C._concatChanges(k);}o.file=j;return o.file;},function(h){c._deleteEntry(s,A);throw h;});o.promise=d;c._oFlexDataPromise=F;return d;};
c._getChangesFromBundle=function(p){var d=p.appName;if(!d){return Promise.resolve([]);}var r=p.appName.replace(/\./g,"/")+"/changes/changes-bundle.json";var g=!!sap.ui.loader._.getModuleState(r);if(g){return Promise.resolve(b.loadResource(r));}var o=sap.ui.getCore().getConfiguration();if(o.getDebug()||o.getComponentPreload()==="off"||o.isFlexBundleRequestForced()){try{return Promise.resolve(b.loadResource(r));}catch(e){a.warning("flexibility did not find a changesBundle.json  for the application");}}return Promise.resolve([]);};
c.NOTAG="<NoTag>";
c._trimEtag=function(s){return s.replace(/(^W\/|")/g,'');};
c._concatControlVariantIdWithCacheKey=function(s,d){if(!d){return s;}return s===c.NOTAG?s.replace(/>$/,''.concat('-',d,'>')):s.concat('-',d);};
c.getCacheKey=function(m,A){if(!m||!m.name||!m.appVersion||!A){a.warning("Not all parameters were passed to determine a flexibility cache key.");return Promise.resolve(c.NOTAG);}return this.getChangesFillingCache(L.createConnector(),m).then(function(w){if(w&&w.etag){return c._trimEtag(w.etag);}return c.NOTAG;}).then(function(s){var v=A.getModel(U.VARIANT_MODEL_NAME);var d=v?v.getCurrentControlVariantIds():[];return c._concatControlVariantIdWithCacheKey(s,d.join("-"));});};
c._getChangeArray=function(o){var s=o.name;var A=o.appVersion||U.DEFAULT_APP_VERSION;var e=c.getEntry(s,A);return e.file.changes.changes;};
c.addChange=function(o,d){var e=c._getChangeArray(o);if(!e){return;}e.push(d);};
c.setVariantManagementSection=function(o,v){var s=o.name;var A=o.appVersion||U.DEFAULT_APP_VERSION;var e=c.getEntry(s,A);if(!O.get("file.changes.variantSection",e)){return;}e.file.changes.variantSection=v;};
c.updateChange=function(o,d){var e=c._getChangeArray(o);if(!e){return;}for(var i=0;i<e.length;i++){if(e[i].fileName===d.fileName){e.splice(i,1,d);break;}}};
c.deleteChange=function(o,d){var e=c._getChangeArray(o);if(!e){return;}for(var i=0;i<e.length;i++){if(e[i].fileName===d.fileName){e.splice(i,1);break;}}};
c.removeChanges=function(o,d){var e=c.getEntry(o.name,o.appVersion);e.file.changes.changes=e.file.changes.changes.filter(function(g){return d.indexOf(g.fileName)===-1;});var v=e.file.changes.variantSection;Object.keys(v).forEach(function(i){v[i].variants.forEach(function(V){V.controlChanges=V.controlChanges.filter(function(g){return d.indexOf(g.getFileName())===-1;});});});};
c.getPersonalization=function(r,A,s,i){var m={name:r,appVersion:A};return this.getChangesFillingCache(L.createConnector(),m).then(function(R){if(!R||!R.changes||!R.changes.ui2personalization||!R.changes.ui2personalization[s]){return i?undefined:[];}if(!i){return R.changes.ui2personalization[s]||[];}return R.changes.ui2personalization[s].filter(function(e){return e.itemName===i;})[0];});};
c.setPersonalization=function(p){if(!p||!p.reference||!p.containerKey||!p.itemName||!p.content){return Promise.reject("not all mandatory properties were provided for the storage of the personalization");}return L.createConnector().send("/sap/bc/lrep/ui2personalization/","PUT",p,{}).then(this._addPersonalizationToEntries.bind(this,p));};
c._addPersonalizationToEntries=function(p){Object.keys(this._entries[p.reference]).forEach(function(v){var e=this._entries[p.reference][v];var P=e.file.changes.ui2personalization;if(!P[p.containerKey]){P[p.containerKey]=[];}P[p.containerKey].push(p);}.bind(this));};
c.deletePersonalization=function(r,s,i){if(!r||!s||!i){return Promise.reject("not all mandatory properties were provided for the storage of the personalization");}var u="/sap/bc/lrep/ui2personalization/?reference=";u+=r+"&containerkey="+s+"&itemname="+i;return L.createConnector().send(u,"DELETE",{}).then(this._removePersonalizationFromEntries.bind(this,r,s,i));};
c._removePersonalizationFromEntries=function(r,s,i){var d=[];Object.keys(this._entries[r]).forEach(function(A){var g=this.getPersonalization(r,A,s);var G=this.getPersonalization(r,A,s,i);var D=Promise.all([g,G]).then(function(p){var I=p[0];var t=p[1];var n=I.indexOf(t);I.splice(n,1);});d.push(D);}.bind(this));return Promise.all(d);};
return c;},true);
sap.ui.predefine('sap/ui/fl/Change',["sap/ui/thirdparty/jquery","sap/ui/base/ManagedObject","sap/ui/fl/Utils","sap/ui/fl/LayerUtils","sap/ui/fl/registry/Settings","sap/base/Log","sap/ui/fl/descriptorRelated/api/DescriptorInlineChangeFactory","sap/base/util/includes"],function(q,M,U,L,S,a,D,i){"use strict";
var C=M.extend("sap.ui.fl.Change",{
constructor:function(f){M.apply(this);if(!q.isPlainObject(f)){a.error("Constructor : sap.ui.fl.Change : oFile is not defined");}this._oDefinition=f;this._sRequest='';this._bUserDependent=(f.layer==="USER");this._vRevertData=null;this._aUndoOperations=null;this.setState(C.states.NEW);this.setModuleName(f.moduleName);this.setInitialApplyState();this._oChangeProcessingPromises={};},
metadata:{properties:{state:{type:"string"},moduleName:{type:"string"},applyState:{type:"int"}}}
});
C.states={NEW:"NEW",PERSISTED:"NONE",DELETED:"DELETE",DIRTY:"UPDATE"};C.applyState={INITIAL:0,APPLYING:1,APPLY_FINISHED:2,REVERTING:3,REVERT_FINISHED:4};C.operations={APPLY:0,REVERT:1};
C.prototype.setState=function(s){if(this._isValidState(s)){this.setProperty("state",s);}return this;};
C.prototype.setQueuedForRevert=function(){this._aQueuedProcesses.unshift(C.operations.REVERT);};
C.prototype.isQueuedForRevert=function(){return this._aQueuedProcesses.indexOf(C.operations.REVERT)>-1;};
C.prototype.setQueuedForApply=function(){this._aQueuedProcesses.unshift(C.operations.APPLY);};
C.prototype.isQueuedForApply=function(){return this._aQueuedProcesses.indexOf(C.operations.APPLY)>-1;};
C.prototype.setInitialApplyState=function(){this._aQueuedProcesses=[];this.setApplyState(C.applyState.INITIAL);};
C.prototype.startApplying=function(){this.setApplyState(C.applyState.APPLYING);};
C.prototype.markFinished=function(r){this._aQueuedProcesses.pop();this._resolveChangeProcessingPromiseWithError(C.operations.APPLY,r);this.setApplyState(C.applyState.APPLY_FINISHED);};
C.prototype.startReverting=function(){this.setApplyState(C.applyState.REVERTING);};
C.prototype.markRevertFinished=function(r){this._aQueuedProcesses.pop();this._resolveChangeProcessingPromiseWithError(C.operations.REVERT,r);this.setApplyState(C.applyState.REVERT_FINISHED);};
C.prototype.hasApplyProcessStarted=function(){return this.getApplyState()===C.applyState.APPLYING;};
C.prototype.isApplyProcessFinished=function(){return this.getApplyState()===C.applyState.APPLY_FINISHED;};
C.prototype.hasRevertProcessStarted=function(){return this.getApplyState()===C.applyState.REVERTING;};
C.prototype.isRevertProcessFinished=function(){return this.getApplyState()===C.applyState.REVERT_FINISHED;};
C.prototype.isCurrentProcessFinished=function(){return this._aQueuedProcesses.length===0;};
C.prototype.addChangeProcessingPromise=function(k){if(!this._oChangeProcessingPromises[k]){this._oChangeProcessingPromises[k]={};this._oChangeProcessingPromises[k].promise=new Promise(function(r){this._oChangeProcessingPromises[k].resolveFunction={resolve:r};}.bind(this));}return this._oChangeProcessingPromises[k].promise;};
C.prototype.addChangeProcessingPromises=function(){var r=[];this._aQueuedProcesses.forEach(function(p){r.push(this.addChangeProcessingPromise(p));},this);return r;};
C.prototype.addPromiseForApplyProcessing=function(){return this.addChangeProcessingPromise(C.operations.APPLY);};
C.prototype._resolveChangeProcessingPromiseWithError=function(k,r){if(this._oChangeProcessingPromises[k]){this._oChangeProcessingPromises[k].resolveFunction.resolve(r);delete this._oChangeProcessingPromises[k];}};
C.prototype._isValidState=function(s){var b=false;Object.keys(C.states).some(function(k){if(C.states[k]===s){b=true;}return b;});if(!b){return false;}if((this.getState()===C.states.NEW)&&(s===C.states.DIRTY)){return false;}return true;};
C.prototype.isValid=function(){var I=true;if(typeof(this._oDefinition)!=="object"){I=false;}if(!this._oDefinition.fileType){I=false;}if(!this._oDefinition.fileName){I=false;}if(!this._oDefinition.changeType){I=false;}if(!this._oDefinition.layer){I=false;}if(!this._oDefinition.originalLanguage){I=false;}return I;};
C.prototype.isVariant=function(){return this._oDefinition.fileType==="variant";};
C.prototype.getChangeType=function(){if(this._oDefinition){return this._oDefinition.changeType;}};
C.prototype.getFileName=function(){if(this._oDefinition){return this._oDefinition.fileName;}};
C.prototype.getFileType=function(){if(this._oDefinition){return this._oDefinition.fileType;}};
C.prototype.getOriginalLanguage=function(){if(this._oDefinition&&this._oDefinition.originalLanguage){return this._oDefinition.originalLanguage;}return"";};
C.prototype.getContext=function(){if(this._oDefinition&&this._oDefinition.context){return this._oDefinition.context;}return"";};
C.prototype.getPackage=function(){return this._oDefinition.packageName;};
C.prototype.getNamespace=function(){return this._oDefinition.namespace;};
C.prototype.setNamespace=function(n){this._oDefinition.namespace=n;};
C.prototype.getProjectId=function(){return this._oDefinition.projectId;};
C.prototype.setProjectId=function(p){this._oDefinition.projectId=p;};
C.prototype.getId=function(){return this._oDefinition.fileName;};
C.prototype.getContent=function(){return this._oDefinition.content;};
C.prototype.setContent=function(c){this._oDefinition.content=c;this.setState(C.states.DIRTY);};
C.prototype.getVariantReference=function(){return this._oDefinition.variantReference||"";};
C.prototype.setVariantReference=function(v){this._oDefinition.variantReference=v;this.setState(C.states.DIRTY);};
C.prototype.getSelector=function(){return this._oDefinition.selector;};
C.prototype.getSourceSystem=function(){return this._oDefinition.sourceSystem;};
C.prototype.getSourceClient=function(){return this._oDefinition.sourceClient;};
C.prototype.getOwnerId=function(){return this._oDefinition.support?this._oDefinition.support.user:"";};
C.prototype.getText=function(t){if(typeof(t)!=="string"){a.error("sap.ui.fl.Change.getTexts : sTextId is not defined");}if(this._oDefinition.texts){if(this._oDefinition.texts[t]){return this._oDefinition.texts[t].value;}}return"";};
C.prototype.setText=function(t,n){if(typeof(t)!=="string"){a.error("sap.ui.fl.Change.setTexts : sTextId is not defined");return;}if(this._oDefinition.texts){if(this._oDefinition.texts[t]){this._oDefinition.texts[t].value=n;this.setState(C.states.DIRTY);}}};
C.prototype.isReadOnly=function(){return this._isReadOnlyDueToLayer()||this._isReadOnlyWhenNotKeyUser()||this.isChangeFromOtherSystem();};
C.prototype._isReadOnlyWhenNotKeyUser=function(){if(this.isUserDependent()){return false;}var r=this.getDefinition().reference;if(!r){return true;}var s=S.getInstanceOrUndef();if(!s){return true;}return!s.isKeyUser();};
C.prototype.isLabelReadOnly=function(){if(this._isReadOnlyDueToLayer()){return true;}return this._isReadOnlyDueToOriginalLanguage();};
C.prototype._isReadOnlyDueToLayer=function(){var c;c=L.getCurrentLayer(this._bUserDependent);return(this._oDefinition.layer!==c);};
C.prototype.isChangeFromOtherSystem=function(){var s=this.getSourceSystem();var b=this.getSourceClient();if(!s||!b){return false;}var o=S.getInstanceOrUndef();if(!o){return true;}var c=o.getSystem();var d=o.getClient();if(!c||!d){return false;}return(s!==c||b!==d);};
C.prototype._isReadOnlyDueToOriginalLanguage=function(){var c;var o;o=this.getOriginalLanguage();if(!o){return false;}c=U.getCurrentLanguage();return(c!==o);};
C.prototype.markForDeletion=function(){this.setState(C.states.DELETED);};
C.prototype.setRequest=function(r){if(typeof(r)!=="string"){a.error("sap.ui.fl.Change.setRequest : sRequest is not defined");}this._sRequest=r;};
C.prototype.getRequest=function(){return this._sRequest;};
C.prototype.getLayer=function(){return this._oDefinition.layer;};
C.prototype.getComponent=function(){return this._oDefinition.reference;};
C.prototype.setComponent=function(c){this._oDefinition.reference=c;};
C.prototype.setValidAppVersions=function(v){this._oDefinition.validAppVersions=v;};
C.prototype.getCreation=function(){return this._oDefinition.creation;};
C.prototype.isUserDependent=function(){return(this._bUserDependent);};
C.prototype.getPendingAction=function(){return this.getState();};
C.prototype.getDefinition=function(){return this._oDefinition;};
C.prototype.setResponse=function(r){var R=JSON.stringify(r);if(R){this._oDefinition=JSON.parse(R);this.setState(C.states.PERSISTED);}};
C.prototype.getFullFileIdentifier=function(){var l=this.getLayer();var n=this.getNamespace();var f=this.getDefinition().fileName;var F=this.getDefinition().fileType;return l+"/"+n+"/"+f+"."+F;};
C.prototype.addDependentControl=function(c,A,p,m){if(!c){throw new Error("Parameter vControl is mandatory");}if(!A){throw new Error("Parameter sAlias is mandatory");}if(!p){throw new Error("Parameter mPropertyBag is mandatory");}if(!this._oDefinition.dependentSelector){this._oDefinition.dependentSelector={};}if(this._oDefinition.dependentSelector[A]){throw new Error("Alias '"+A+"' already exists in the change.");}var o=p.modifier;var b=p.appComponent;if(Array.isArray(c)){var s=[];c.forEach(function(d){s.push(o.getSelector(d,b,m));});this._oDefinition.dependentSelector[A]=s;}else{this._oDefinition.dependentSelector[A]=o.getSelector(c,b,m);}delete this._aDependentSelectorList;};
C.prototype.getDependentControl=function(A,p){var d=[];var o;if(!A){throw new Error("Parameter sAlias is mandatory");}if(!p){throw new Error("Parameter mPropertyBag is mandatory");}var m=p.modifier;var b=p.appComponent;if(!this._oDefinition.dependentSelector){return undefined;}o=this._oDefinition.dependentSelector[A];if(Array.isArray(o)){o.forEach(function(s){d.push(m.bySelector(s,b,p.view));});return d;}return m.bySelector(o,b,p.view);};
C.prototype.getDependentSelectorList=function(){var t=this;var d=[this.getSelector()];if(!this._aDependentSelectorList){if(this._oDefinition.dependentSelector){Object.keys(this._oDefinition.dependentSelector).forEach(function(A){var c=t._oDefinition.dependentSelector[A];if(!Array.isArray(c)){c=[c];}c.forEach(function(o){if(o&&U.indexOfObject(d,o)===-1){d.push(o);}});});}this._aDependentSelectorList=d;}return this._aDependentSelectorList;};
C.prototype.getDependentControlSelectorList=function(){var d=this.getDependentSelectorList().concat();if(d.length>0){var s=this.getSelector();var I=U.indexOfObject(d,s);if(I>-1){d.splice(I,1);}}return d;};
C.prototype.getRevertData=function(){return this._vRevertData;};
C.prototype.setRevertData=function(d){this._vRevertData=d;};
C.prototype.resetRevertData=function(){this.setRevertData(null);};
C.prototype.getUndoOperations=function(){return this._aUndoOperations;};
C.prototype.setUndoOperations=function(d){this._aUndoOperations=d;};
C.prototype.resetUndoOperations=function(){this.setUndoOperations(null);};
C.createInitialFileContent=function(p){if(!p){p={};}var f;if(p.fileType){f=p.fileType;}else{f=p.isVariant?"variant":"change";}var n={fileName:p.id||U.createDefaultFileName(p.changeType),fileType:f,changeType:p.changeType||"",moduleName:p.moduleName||"",reference:p.reference||"",packageName:p.packageName||"",content:p.content||{},selector:p.selector||{id:""},layer:p.layer||L.getCurrentLayer(p.isUserDependent),texts:p.texts||{},namespace:p.namespace||U.createNamespace(p,"changes"),projectId:p.projectId||(p.reference&&p.reference.replace(".Component",""))||"",creation:"",originalLanguage:U.getCurrentLanguage(),conditions:{},context:p.context||"",support:{generator:p.generator||"Change.createInitialFileContent",service:p.service||"",user:"",sapui5Version:sap.ui.version,sourceChangeFileName:p.support&&p.support.sourceChangeFileName||"",compositeCommand:p.support&&p.support.compositeCommand||""},oDataInformation:p.oDataInformation||{},dependentSelector:p.dependentSelector||{},validAppVersions:p.validAppVersions||{},jsOnly:p.jsOnly||false,variantReference:p.variantReference||"",appDescriptorChange:i(D.getDescriptorChangeTypes(),p.changeType)};return n;};
return C;},true);
sap.ui.predefine('sap/ui/fl/ChangePersistence',["sap/ui/fl/Change","sap/ui/fl/Variant","sap/ui/fl/Utils","sap/ui/fl/LayerUtils","sap/ui/fl/LrepConnector","sap/ui/fl/Cache","sap/ui/fl/context/ContextManager","sap/ui/fl/registry/Settings","sap/ui/fl/transport/TransportSelection","sap/ui/fl/variants/VariantController","sap/ui/core/BusyIndicator","sap/ui/core/Component","sap/m/MessageBox","sap/ui/model/json/JSONModel","sap/ui/thirdparty/jquery","sap/base/util/merge","sap/base/util/isEmptyObject","sap/base/Log"],function(C,V,U,L,a,b,c,S,T,d,B,e,M,J,q,m,i,f){"use strict";var g=function(j){this._mComponent=j;this._mChanges=h();this._mChangesInitial=m({},this._mChanges);this._mVariantsChanges={};if(!this._mComponent||!this._mComponent.name){f.error("The Control does not belong to an SAPUI5 component. Personalization and changes for this control might not work as expected.");throw new Error("Missing component name.");}this._oVariantController=new d(this._mComponent.name,this._mComponent.appVersion,{});this._oTransportSelection=new T();this._oConnector=this._createLrepConnector();this._aDirtyChanges=[];this._oMessagebundle=undefined;this._mChangesEntries={};this._bHasChangesOverMaxLayer=false;this.HIGHER_LAYER_CHANGES_EXIST="higher_layer_changes_exist";};
function h(){return{mChanges:{},mDependencies:{},mDependentChangesOnMe:{},mControlsWithDependencies:{},aChanges:[]};}
g.prototype.getComponentName=function(){return this._mComponent.name;};
g.prototype._createLrepConnector=function(){return a.createConnector();};
g.prototype.getCacheKey=function(A){return b.getCacheKey(this._mComponent,A);};
g.prototype._preconditionsFulfilled=function(A,I,o){var j=o instanceof C?o.getDefinition():o;if(!j.fileName){f.warning("A change without fileName is detected and excluded from component: "+this._mComponent.name);return false;}function k(){if(I){return(j.fileType==="change")||(j.fileType==="variant");}return(j.fileType==="change")&&(j.changeType!=="defaultVariant");}function l(){if(I){if((j.fileType==="variant")||(j.changeType==="defaultVariant")){return j.selector&&j.selector.persistencyKey;}}return true;}function n(){return c.doesContextMatch(j,A);}function p(){if((j.fileType==="ctrl_variant")||(j.fileType==="ctrl_variant_change")||(j.fileType==="ctrl_variant_management_change")){return j.variantManagementReference||j.variantReference||(j.selector&&j.selector.id);}}if((k()&&l()&&n())||p()){return true;}return false;};
g.prototype.getChangesForComponent=function(p,I){return b.getChangesFillingCache(this._oConnector,this._mComponent,p,I).then(function(w){var o=m({},w);var A=p&&p.component&&U.getAppComponentForControl(p.component);if(o.changes&&o.changes.settings){S._storeInstance(o.changes.settings);}var F=o.changes&&Array.isArray(o.changes.changes)&&o.changes.changes.length!==0;var v=o.changes&&o.changes.variantSection&&!i(o.changes.variantSection);if(!F&&!v){return[];}var l=A?A.getComponentData():(p&&p.componentData||{});var n=o.changes.changes;if(!this._oMessagebundle&&o.messagebundle&&A){if(!A.getModel("i18nFlexVendor")){if(n.some(function(G){return G.layer==="VENDOR";})){this._oMessagebundle=o.messagebundle;var s=new J(this._oMessagebundle);A.setModel(s,"i18nFlexVendor");}}}var t=p&&p.includeCtrlVariants;var u=p&&p.currentLayer;var x=!(p&&p.ignoreMaxLayerParameter);var y=[o.changes.variantSection];if(u){n=n.filter(this._filterChangeForCurrentLayer.bind(this,u));y.push(false,u);}else if(L.isLayerFilteringRequired()&&x){n=n.filter(this._filterChangeForMaxLayer.bind(this));y.push(true);}else if(this._bHasChangesOverMaxLayer&&!x){this._bHasChangesOverMaxLayer=false;return this.HIGHER_LAYER_CHANGES_EXIST;}if(v){if(t||y.length>1){var z=this._getAllCtrlVariantChanges.apply(this,y);n=t?n.concat(z):n;}this._oVariantController.checkAndSetVariantContent(o,l&&l.technicalParameters);}if(!t&&!i(this._oVariantController.getChangeFileContent())){n=n.concat(this._oVariantController.loadInitialChanges());}var D=p&&p.includeVariants;var E=o.changes.contexts||[];return new Promise(function(G){c.getActiveContexts(E).then(function(H){G(n.filter(this._preconditionsFulfilled.bind(this,H,D)).map(k.bind(this,o)));}.bind(this));}.bind(this));}.bind(this));function j(v,o){var F;Object.keys(v).some(function(s){return v[s].variants.some(function(l){if(l.content.fileName===o.getDefinition().variantReference){F=l;return true;}});});return F;}function r(v,o){return v.controlChanges.some(function(l,n){if(l.fileName===o.getDefinition().fileName){v.controlChanges.splice(n,1,o);return true;}});}function k(F,o){var l;if(o instanceof C){l=o;this._mChangesEntries[l.getFileName()]=l;}else{if(!this._mChangesEntries[o.fileName]){this._mChangesEntries[o.fileName]=new C(o);}l=this._mChangesEntries[o.fileName];l.setState(C.states.PERSISTED);if(l.getVariantReference()){var v=this._oVariantController.getChangeFileContent();var n=j.call(this,v,l);if(n&&r(n,l)){b.setVariantManagementSection(this._mComponent,v);}}}return l;}};
g.prototype._filterChangeForMaxLayer=function(o){if(L.isOverMaxLayer(this._getLayerFromChangeOrChangeContent(o))){if(!this._bHasChangesOverMaxLayer){this._bHasChangesOverMaxLayer=true;}return false;}return true;};
g.prototype._filterChangeForCurrentLayer=function(l,o){return l===this._getLayerFromChangeOrChangeContent(o);};
g.prototype._getLayerFromChangeOrChangeContent=function(o){var s;if(o instanceof V||o instanceof C){s=o.getLayer();}else{s=o.layer;}return s;};
g.prototype._getAllCtrlVariantChanges=function(v,F,s){var j=[];var k=function(){return true;};if(F){k=this._filterChangeForMaxLayer.bind(this);}else if(typeof s==="string"&&s!==""){k=this._filterChangeForCurrentLayer.bind(this,s);}Object.keys(v).forEach(function(l){var o=v[l];o.variants=o.variants.filter(function(n){return!n.content.layer||k(n.content);});o.variants.forEach(function(n){if(Array.isArray(n.variantChanges.setVisible)){n.variantChanges.setVisible=n.variantChanges.setVisible.filter(k);var A=n.variantChanges.setVisible.slice(-1)[0];if(A&&!A.content.visible&&A.content.createdByReset){return;}j=j.concat(n.variantChanges.setVisible);}Object.keys(n.variantChanges).forEach(function(p){if(p!=="setVisible"){n.variantChanges[p]=n.variantChanges[p].filter(k);j=n.variantChanges[p].length>0?j.concat(n.variantChanges[p].slice(-1)[0]):j;}});j=(n.content.fileName!==l)?j.concat([n.content]):j;n.controlChanges=n.controlChanges.filter(k);j=j.concat(n.controlChanges);});Object.keys(o.variantManagementChanges).forEach(function(n){o.variantManagementChanges[n]=o.variantManagementChanges[n].filter(k);j=o.variantManagementChanges[n].length>0?j.concat(o.variantManagementChanges[n].slice(-1)[0]):j;});});return j;};
g.prototype.getSmartVariantManagementChangeMap=function(){return this._mVariantsChanges;};
g.prototype.getChangesForVariant=function(s,j,p){if(this._mVariantsChanges[j]){return Promise.resolve(this._mVariantsChanges[j]);}var k=function(o){var n=false;var r=o._oDefinition.selector;q.each(r,function(t,v){if(t===s&&v===j){n=true;}});return n;};var l=function(n,t){f.error("key : "+n+" and text : "+t.value);};return this.getChangesForComponent(p).then(function(n){return n.filter(k);}).then(function(n){if(!this._mVariantsChanges[j]){this._mVariantsChanges[j]={};}var I;n.forEach(function(o){I=o.getId();if(o.isValid()){if(this._mVariantsChanges[j][I]&&o.isVariant()){f.error("Id collision - two or more variant files having the same id detected: "+I);q.each(o.getDefinition().texts,l);f.error("already exists in variant : ");q.each(this._mVariantsChanges[j][I].getDefinition().texts,l);}this._mVariantsChanges[j][I]=o;}}.bind(this));return this._mVariantsChanges[j];}.bind(this));};
g.prototype.addChangeForVariant=function(s,j,p){var F;var I;var k;var o;var l;if(!p){return undefined;}if(!p.type){f.error("sap.ui.fl.Persistence.addChange : type is not defined");}var n=q.type(p.content);if(n!=='object'&&n!=='array'){f.error("mParameters.content is not of expected type object or array, but is: "+n,"sap.ui.fl.Persistence#addChange");}k={};if(typeof(p.texts)==="object"){q.each(p.texts,function(r,t){k[r]={value:t,type:"XFLD"};});}var v={creation:this._mComponent.appVersion,from:this._mComponent.appVersion};if(this._mComponent.appVersion&&p.developerMode){v.to=this._mComponent.appVersion;}I={changeType:p.type,service:p.ODataService,texts:k,content:p.content,reference:this._mComponent.name,isVariant:p.isVariant,packageName:p.packageName,isUserDependent:p.isUserDependent,validAppVersions:v};I.selector={};I.selector[s]=j;F=C.createInitialFileContent(I);if(p.id){F.fileName=p.id;}o=new C(F);l=o.getId();if(!this._mVariantsChanges[j]){this._mVariantsChanges[j]={};}this._mVariantsChanges[j][l]=o;return o.getId();};
g.prototype.saveAllChangesForVariant=function(s){var p=[];var t=this;q.each(this._mVariantsChanges[s],function(j,o){var k=o.getId();switch(o.getPendingAction()){case"NEW":p.push(t._oConnector.create(o.getDefinition(),o.getRequest(),o.isVariant()).then(function(r){o.setResponse(r.response);if(b.isActive()){b.addChange({name:t._mComponent.name,appVersion:t._mComponent.appVersion},r.response);}return r;}));break;case"UPDATE":p.push(t._oConnector.update(o.getDefinition(),o.getRequest()).then(function(r){o.setResponse(r.response);if(b.isActive()){b.updateChange({name:t._mComponent.name,appVersion:t._mComponent.appVersion},r.response);}return r;}));break;case"DELETE":p.push(t._oConnector.deleteChange(o.getDefinition(),o.getRequest()).then(function(r){var o=t._mVariantsChanges[s][k];if(o.getPendingAction()==="DELETE"){delete t._mVariantsChanges[s][k];}if(b.isActive()){b.deleteChange({name:t._mComponent.name,appVersion:t._mComponent.appVersion},o.getDefinition());}return r;}));break;default:break;}});return Promise.all(p);};
function _(s,A){return s.idIsLocal?A.createId(s.id):s.id;}
g.prototype._addChangeIntoMap=function(A,o){var s=o.getSelector();if(s&&s.id){var j=_(s,A);this._addMapEntry(j,o);if(s.idIsLocal===undefined&&j.indexOf("---")!==-1){var k=j.split("---")[0];if(k!==A.getId()){j=j.split("---")[1];j=A.createId(j);this._addMapEntry(j,o);}}}return this._mChanges;};
g.prototype._addMapEntry=function(s,o){if(!this._mChanges.mChanges[s]){this._mChanges.mChanges[s]=[];}if(this._mChanges.mChanges[s].indexOf(o)===-1){this._mChanges.mChanges[s].push(o);}if(this._mChanges.aChanges.indexOf(o)===-1){this._mChanges.aChanges.push(o);}};
g.prototype._addDependency=function(D,o,r){var j=r?this._mChangesInitial:this._mChanges;if(!j.mDependencies[D.getId()]){j.mDependencies[D.getId()]={changeObject:D,dependencies:[]};}j.mDependencies[D.getId()].dependencies.push(o.getId());if(!j.mDependentChangesOnMe[o.getId()]){j.mDependentChangesOnMe[o.getId()]=[];}j.mDependentChangesOnMe[o.getId()].push(D.getId());};
g.prototype._addControlsDependencies=function(D,A,j,r){var k=r?this._mChangesInitial:this._mChanges;if(j.length>0){if(!k.mDependencies[D.getId()]){k.mDependencies[D.getId()]={changeObject:D,dependencies:[],controlsDependencies:[]};}k.mDependencies[D.getId()].controlsDependencies=j;var s;j.forEach(function(o){s=_(o,A);k.mControlsWithDependencies[s]=true;});}};
g.prototype.loadChangesMapForComponent=function(A,p){p.component=!i(A)&&A;return this.getChangesForComponent(p).then(j.bind(this));function j(k){this._mChanges=h();k.forEach(this._addChangeAndUpdateDependencies.bind(this,A));this._mChangesInitial=m({},this._mChanges);return this.getChangesMapForComponent.bind(this);}};
g.prototype.checkForOpenDependenciesForControl=function(s,o,A){return Object.keys(this._mChanges.mDependencies).some(function(k){return this._mChanges.mDependencies[k].changeObject.getDependentSelectorList().some(function(D){return D===o.getControlIdBySelector(s,A);});},this);};
g.prototype.copyDependenciesFromInitialChangesMap=function(o,D,A){var I=m({},this._mChangesInitial.mDependencies);var j=I[o.getId()];if(j){var n=[];j.dependencies.forEach(function(s){if(D(s)){this._mChanges.mDependentChangesOnMe[s]=this._mChanges.mDependentChangesOnMe[s]||[];this._mChanges.mDependentChangesOnMe[s].push(o.getId());n.push(s);}}.bind(this));o.getDependentControlSelectorList().forEach(function(s){this._mChanges.mControlsWithDependencies[_(s,A)]=true;}.bind(this));j.dependencies=n;this._mChanges.mDependencies[o.getId()]=j;}return this._mChanges;};
g.prototype._addChangeAndUpdateDependencies=function(A,o){o.setInitialApplyState();this._addChangeIntoMap(A,o);this._updateDependencies(o,A,false);};
g.prototype._addRunTimeCreatedChangeAndUpdateDependencies=function(A,o){this._addChangeIntoMap(A,o);this._updateDependencies(o,A,true);};
g.prototype._updateDependencies=function(o,A,r){var j=this.getChangesMapForComponent().aChanges;var D=o.getDependentSelectorList();var k=o.getDependentControlSelectorList();this._addControlsDependencies(o,A,k,r);j.slice(0,j.length-1).reverse().forEach(function(E){var l=E.getDependentSelectorList();D.some(function(n){var p=U.indexOfObject(l,n);if(p>-1){this._addDependency(o,E,r);return true;}}.bind(this));}.bind(this));};
g.prototype.getChangesMapForComponent=function(){return this._mChanges;};
g.prototype.getChangesForView=function(v,p){var t=this;return this.getChangesForComponent(p).then(function(k){return k.filter(j.bind(t));});function j(o){var s=o.getSelector();if(!s){return false;}var k=s.id;if(!k||!p){return false;}var l=k.slice(0,k.lastIndexOf("--"));var v;if(o.getSelector().idIsLocal){var n=p.appComponent;if(n){v=n.getLocalId(p.viewId);}}else{v=p.viewId;}return l===v;}};
g.prototype.addChange=function(v,A){var o=this.addDirtyChange(v);this._addRunTimeCreatedChangeAndUpdateDependencies(A,o);this._addPropagationListener(A);return o;};
g.prototype.addDirtyChange=function(v){var n;if(v instanceof C||v instanceof V){n=v;}else{n=new C(v);}if(this._aDirtyChanges.indexOf(n)===-1){this._aDirtyChanges.push(n);}return n;};
g.prototype._addPropagationListener=function(o){var A=U.getAppComponentForControl(o);if(A instanceof e){var j=function(p){return!p._bIsSapUiFlFlexControllerApplyChangesOnControl;};var n=A.getPropagationListeners().every(j);if(n){var k=A.getManifestObject();var v=U.getAppVersionFromManifest(k);var F=sap.ui.require("sap/ui/fl/FlexControllerFactory");var l=F.create(this.getComponentName(),v);var p=l.getBoundApplyChangesOnControl(this.getChangesMapForComponent.bind(this),A);A.addPropagationListener(p);}}};
g.prototype.saveDirtyChanges=function(s){var D=this._aDirtyChanges.slice(0);var j=this._aDirtyChanges;var r=this._getRequests(D);var p=this._getPendingActions(D);if(p.length===1&&r.length===1&&p[0]==="NEW"){var R=r[0];var P=this._prepareDirtyChanges(j);return this._oConnector.create(P,R).then(function(o){this._massUpdateCacheAndDirtyState(j,D,s);return o;}.bind(this));}return this.saveSequenceOfDirtyChanges(D,s);};
g.prototype.saveSequenceOfDirtyChanges=function(D,s){var A=this.getDirtyChanges();return D.reduce(function(p,o){return p.then(this._performSingleSaveAction(o)).then(this._updateCacheAndDirtyState.bind(this,A,o,s));}.bind(this),Promise.resolve());};
g.prototype._performSingleSaveAction=function(D){return function(){if(D.getPendingAction()==="NEW"){return this._oConnector.create(D.getDefinition(),D.getRequest());}if(D.getPendingAction()==="DELETE"){return this._oConnector.deleteChange(D.getDefinition(),D.getRequest());}}.bind(this);};
g.prototype._updateCacheAndDirtyState=function(D,o,s){if(!s){if(o.getPendingAction()==="NEW"){U.isChangeRelatedToVariants(o)?b.setVariantManagementSection(this._mComponent,m({},this._oVariantController.getChangeFileContent())):b.addChange(this._mComponent,o.getDefinition());}else if(o.getPendingAction()==="DELETE"){U.isChangeRelatedToVariants(o)?b.setVariantManagementSection(this._mComponent,m({},this._oVariantController.getChangeFileContent())):b.deleteChange(this._mComponent,o.getDefinition());}}var I=D.indexOf(o);if(I>-1){D.splice(I,1);}};
g.prototype._massUpdateCacheAndDirtyState=function(D,j,s){j.forEach(function(o){this._updateCacheAndDirtyState(D,o,s);},this);};
g.prototype._getRequests=function(D){var r=[];D.forEach(function(o){var R=o.getRequest();if(r.indexOf(R)===-1){r.push(R);}});return r;};
g.prototype._getPendingActions=function(D){var p=[];D.forEach(function(o){var P=o.getPendingAction();if(p.indexOf(P)===-1){p.push(P);}});return p;};
g.prototype._prepareDirtyChanges=function(D){var j=[];D.forEach(function(o){j.push(o.getDefinition());});return j;};
g.prototype.getDirtyChanges=function(){return this._aDirtyChanges;};
g.prototype.deleteChange=function(o,r){var n=this._aDirtyChanges.indexOf(o);if(n>-1){if(o.getPendingAction()==="DELETE"){return;}this._aDirtyChanges.splice(n,1);this._deleteChangeInMap(o,r);return;}o.markForDeletion();this.addDirtyChange(o);this._deleteChangeInMap(o,r);};
g.prototype._deleteChangeInMap=function(o,r){var s=o.getId();var j=this._mChanges.mChanges;var k=r?this._mChangesInitial:this._mChanges;var D=k.mDependencies;var l=k.mDependentChangesOnMe;Object.keys(j).some(function(n){var p=j[n];var t=p.map(function(E){return E.getId();}).indexOf(o.getId());if(t!==-1){p.splice(t,1);return true;}});Object.keys(D).forEach(function(n){if(n===s){delete D[n];}else if(D[n].dependencies&&Array.isArray(D[n].dependencies)&&D[n].dependencies.indexOf(s)!==-1){D[n].dependencies.splice(D[n].dependencies.indexOf(s),1);if(D[n].dependencies.length===0){delete D[n];}}});Object.keys(l).forEach(function(n){if(n===s){delete l[n];}else if(Array.isArray(l[n])&&l[n].indexOf(s)!==-1){l[n].splice(l[n].indexOf(s),1);if(l[n].length===0){delete l[n];}}});var I=this._mChanges.aChanges.indexOf(o);if(I!==-1){this._mChanges.aChanges.splice(I,1);}};
g.prototype.loadSwitchChangesMapForComponent=function(p){p.changesMap=this._mChanges.mChanges;return this._oVariantController.getChangesForVariantSwitch(p);};
g.prototype.transportAllUIChanges=function(r,s,l,A){var H=function(E){B.hide();var R=sap.ui.getCore().getLibraryResourceBundle("sap.ui.fl");var j=R.getText("MSG_TRANSPORT_ERROR",E?[E.message||E]:undefined);var t=R.getText("HEADER_TRANSPORT_ERROR");f.error("transport error"+E);M.show(j,{icon:M.Icon.ERROR,title:t,styleClass:s});return"Error";};return this._oTransportSelection.openTransportSelection(null,r,s).then(function(t){if(this._oTransportSelection.checkTransportInfo(t)){B.show(0);return this.getChangesForComponent({currentLayer:l,includeCtrlVariants:true}).then(function(j){var o={reference:this.getComponentName(),appVersion:this._mComponent.appVersion,layer:l};return this._oTransportSelection._prepareChangesForTransport(t,j,A,o).then(function(){B.hide();});}.bind(this));}return"Cancel";}.bind(this))['catch'](H);};
g.prototype._getChangesFromMapByNames=function(n){return this._mChanges.aChanges.filter(function(o){return n.indexOf(o.getFileName())!==-1;});};
g.prototype.resetChanges=function(l,G,s,j){var k=[];var t;var n=s&&s.length>0;var o=j&&j.length>0;if(!G&&!n&&!o){f.error("Of the generator, selector IDs and change types parameters at least one has to filled");return Promise.reject("Of the generator, selector IDs and change types parameters at least one has to filled");}if(l==="USER"){t=Promise.resolve();}else{t=this.getChangesForComponent({currentLayer:l,includeCtrlVariants:true}).then(function(p){k=p;return S.getInstance(this.getComponentName());}.bind(this)).then(function(p){if(!p.isProductiveSystem()){return this._oTransportSelection.setTransports(k,e.get(this.getComponentName()));}}.bind(this));}return t.then(function(){var p="";k.some(function(r){if(r.getRequest()){p=r.getRequest();return true;}return false;});var P={sReference:this.getComponentName(),sAppVersion:this._mComponent.appVersion,sLayer:l,sChangelist:p};if(G){P.sGenerator=G;}if(n){P.aSelectorIds=s;}if(o){P.aChangeTypes=j;}return this._oConnector.resetChanges(P);}.bind(this)).then(function(r){var p=[];if(s||j){var N=[];if(r&&r.response&&r.response.length>0){r.response.forEach(function(u){N.push(u.name);});}b.removeChanges(this._mComponent,N);p=this._getChangesFromMapByNames(N);}return p;}.bind(this));};
g.prototype.resetVariantMap=function(r){return this._oVariantController.resetMap(r);};
return g;},true);
sap.ui.predefine('sap/ui/fl/ChangePersistenceFactory',["sap/ui/thirdparty/jquery","sap/ui/core/Component","sap/ui/fl/ChangePersistence","sap/ui/fl/Utils"],function(q,C,a,U){"use strict";var b={};b._instanceCache={};
b.getChangePersistenceForComponent=function(c,A){var o;A=A||U.DEFAULT_APP_VERSION;if(!b._instanceCache[c]){b._instanceCache[c]={};}o=b._instanceCache[c][A];if(!o){var d={name:c,appVersion:A};o=new a(d);b._instanceCache[c][A]=o;}return o;};
b.getChangePersistenceForControl=function(c){var s;s=this._getComponentClassNameForControl(c);var A=U.getAppVersionFromManifest(U.getAppComponentForControl(c).getManifest());return b.getChangePersistenceForComponent(s,A);};
b._getComponentClassNameForControl=function(c){return U.getComponentClassName(c);};
b.registerLoadComponentEventHandler=function(){C._fnLoadComponentCallback=this._onLoadComponent.bind(this);};
b._doLoadComponent=function(c,m){var o={oChangePersistence:{},oRequestOptions:{appName:c.name}};var s=U.getFlexReference(m);var A=U.getAppVersionFromManifest(m);var S;S=c&&c.componentData&&c.componentData.startupParameters||{};if(S["sap-app-id"]&&S["sap-app-id"].length===1){s=S["sap-app-id"][0];}else if(c){var d=c.asyncHints;if(d&&d.requests&&Array.isArray(d.requests)){var f=this._findFlAsyncHint(d.requests,s);if(f){o.oRequestOptions.cacheKey=f.cachebusterToken||"<NO CHANGES>";}}}o.oRequestOptions.siteId=U.getSiteIdByComponentData(c.componentData);o.oChangePersistence=this.getChangePersistenceForComponent(s,A);return o;};
b._onLoadComponent=function(c,m){if(!U.isApplication(m)){return;}var o=this._doLoadComponent(c,m);o.oRequestOptions.componentData={};Object.assign(o.oRequestOptions.componentData,c.componentData);o.oChangePersistence.getChangesForComponent(o.oRequestOptions);};
b._getChangesForComponentAfterInstantiation=function(c,m,o){if(!U.isApplication(m)){return Promise.resolve(function(){return{mChanges:{},mDependencies:{},mDependentChangesOnMe:{}};});}var d=this._doLoadComponent(c,m);return d.oChangePersistence.loadChangesMapForComponent(o,d.oRequestOptions);};
b._findFlAsyncHint=function(A,r){var t=this;var f;q.each(A,function(n,o){if(t._flAsyncHintMatches(o,r)){f=o;return false;}});return f;};
b._flAsyncHintMatches=function(A,r){return A.name==="sap.ui.fl.changes"&&A.reference===r;};
return b;},true);
sap.ui.predefine('sap/ui/fl/DefaultVariant',["sap/ui/fl/Change"],function(C){"use strict";var D=function(){};
D.prototype.getDefaultVariantId=function(c){var d=this.getNewestDefaultVariantChangeDeleteTheRest(c);if(d){return d.getContent().defaultVariantName;}return"";};
D.prototype.getNewestDefaultVariantChangeDeleteTheRest=function(c){var d=this.getDefaultVariantChanges(c).sort(function(a,b){var e=new Date(a.getCreation());var f=new Date(b.getCreation());if(isNaN(e.getDate())){return-1;}if(isNaN(f.getDate())){return 1;}return f-e;});var n=d.shift();d.forEach(function(o){o.markForDeletion();});return n;};
D.prototype.getDefaultVariantChanges=function(c){if(!c||typeof c!=='object'){return[];}return Object.keys(c).map(a).filter(d);function a(s){return c[s];}function d(o){return o.getChangeType()==='defaultVariant';}};
D.prototype.updateDefaultVariantId=function(c,n){var N=this.getNewestDefaultVariantChangeDeleteTheRest(c);if(N){var o=N.getContent();o.defaultVariantName=n;N.setContent(o);}return N;};
D.prototype._createChangeFile=function(p){var f;p.changeType='defaultVariant';f=C.createInitialFileContent(p);f.content.defaultVariantName=p.defaultVariantId;f.layer='USER';return f;};
D.prototype.createChangeObject=function(p){var f;var c;f=this._createChangeFile(p);c=new C(f);return c;};
return new D();},true);
sap.ui.predefine('sap/ui/fl/EventHistory',function(){"use strict";var E=function(){};E._aEventIds=["ControlForPersonalizationRendered"];E._aUnsubscribedEventIds=[];E._oHistory={};
E.start=function(){E._aEventIds.forEach(function(e){if(E._aUnsubscribedEventIds.indexOf(e)===-1){sap.ui.getCore().getEventBus().subscribe("sap.ui",e,E.saveEvent);E._oHistory[e]=[];}});};
E.saveEvent=function(c,e,p){var o={channelId:c,eventId:e,parameters:p.getId()};if(E._oHistory[e]){var b=E._oHistory[e].some(function(O){return(O.channelId===o.channelId&&O.eventId===o.eventId&&O.parameters===o.parameters);});if(!b){E._oHistory[e].push(o);}}};
E.getHistoryAndStop=function(e){sap.ui.getCore().getEventBus().unsubscribe("sap.ui",e,E.saveEvent);E._addUnsubscribedEvent(e);return E._oHistory[e]||[];};
E._addUnsubscribedEvent=function(e){if(E._aUnsubscribedEventIds.indexOf(e)===-1){E._aUnsubscribedEventIds.push(e);}};
return E;},true);
sap.ui.predefine('sap/ui/fl/FakeLrepConnector',["sap/ui/thirdparty/jquery","sap/ui/fl/LrepConnector","sap/ui/fl/Cache","sap/ui/fl/ChangePersistenceFactory","sap/ui/fl/Utils"],function(q,L,C,a,U){"use strict";var l=Object.create(L.prototype);F._oBackendInstances={};
function F(i){this.sInitialComponentJsonPath=i;this.mSettings={};this.mInfo={};}
for(var p in l){if(typeof l[p]==='function'){F.prototype[p]=(function(p){return function(){throw new Error('Method '+p+'() is not implemented in FakeLrepConnector.');};}(p));}}
F.prototype._getUrlPrefix=function(i){if(i){return U.getLrepUrl()+"/variants/";}return U.getLrepUrl()+"/changes/";};
F.prototype.getFlexInfo=function(){return Promise.resolve(this.mInfo);};
F.prototype.setInfo=function(i){this.mInfo=i;};
F.prototype.loadSettings=function(){this.setFlexServiceAvailability(true);return Promise.resolve(this.mSettings);};
F.prototype.setSettings=function(s){this.mSettings=s;};
F.prototype.setFlexServiceAvailability=function(A){L._bServiceAvailability=A;};
F.prototype.loadChanges=function(s){var i=this.sInitialComponentJsonPath;return new Promise(function(r,f){q.getJSON(i).done(function(R){var g={changes:R,componentClassName:s};r(g);}).fail(function(g){f(g);});});};
F.prototype.create=function(f,g,i){if(!i){return Promise.resolve();}if(!f.creation){f.creation=new Date().toISOString();}return Promise.resolve({response:f,status:'success'});};
F.prototype.update=function(f){if(!f.fileType||(f.fileType!=="variant")){return Promise.resolve();}return Promise.resolve({response:f,status:'success'});};
F.prototype.deleteChange=function(f){if(!f.fileType||(f.fileType!=="variant")){return Promise.resolve();}return Promise.resolve({response:undefined,status:'nocontent'});};
F.prototype.send=function(u,m,D,o){return new Promise(function(r,f){e(u,m,D,o,r,f);d(u,m,D,o,r,f);c(u,m,D,o,r,f);b(u,m,D,o,r,f);h(u,m,D,o,r,f);});};
function h(u,m,D,o,r){var f=/\/sap\/bc\/lrep\/appdescr_variants\/([\w.]+)/;var g=f.exec(u);if(g&&m==='GET'){var R={content:[],fileName:"manifest",fileType:"appdescr_variant",id:g[1],layer:"CUSTOMER",namespace:"apps/sap.ui.test.application/appVariants/"+g[1],packageName:"$TMP",reference:"sap.ui.test.application"};r({response:JSON.stringify(R)});}else if(g&&m==='DELETE'){r();}}
function b(u,m,D,o,r){if(u.match(/^\/sap\/bc\/lrep\/changes\//)&&m==='DELETE'){var f=[];var g=/\?reference=([\w.]+)\&.+\&layer=(\w+)\&generator=([\w.]+)/;f=u.match(g);r({response:{parameters:f},status:"success"});}}
function c(u,m,D,o,r){if(u.match(/^\/sap\/bc\/ui2\/app_index\/ui5_app_mani_first_supported\//)&&m==='GET'){r({response:false,status:"success"});}}
function d(u,m,D,o,r){if(u.match(/^\/sap\/bc\/lrep\/actions\/make_changes_transportable\//)&&m==='POST'){r();}}
function e(u,m,D,o,r){if(u.match(/^\/sap\/bc\/lrep\/actions\/gettransports\//)){r({response:{transports:[{transportId:"U31K008488",description:"The Ultimate Transport",owner:"Fantasy Owner",locked:true}],localonly:false,errorCode:""}});}}
F.enableFakeConnector=function(i,A,s){function r(){F.enableFakeConnector.original=L.createConnector;L.createConnector=function(){if(!F._oFakeInstance){F._oFakeInstance=new F(i);}return F._oFakeInstance;};}if(A&&s){var o=a.getChangePersistenceForComponent(A,s);if(!(o._oConnector instanceof F)){F.clearCacheAndResetVariants(A,s,o);if(!F._oBackendInstances[A]){F._oBackendInstances[A]={};}F._oBackendInstances[A][s]=o._oConnector;o._oConnector=new F(i);}r();return;}C.clearEntries();if(F.enableFakeConnector.original){return;}r();};
F.disableFakeConnector=function(A,s){function r(){if(F.enableFakeConnector.original){L.createConnector=F.enableFakeConnector.original;F.enableFakeConnector.original=undefined;F._oFakeInstance=undefined;}}if(A&&s){var o=a.getChangePersistenceForComponent(A,s);if(!(o._oConnector instanceof L)){F.clearCacheAndResetVariants(A,s,o);if(F._oBackendInstances[A]&&F._oBackendInstances[A][s]){o._oConnector=F._oBackendInstances[A][s];F._oBackendInstances[A][s]=undefined;}}r();return;}C.clearEntries();r();};
F.clearCacheAndResetVariants=function(s,A,o){C.clearEntry(s,A);o.resetVariantMap(true);};
return F;},true);
sap.ui.predefine('sap/ui/fl/FlexController',["sap/ui/fl/registry/ChangeRegistry","sap/ui/fl/registry/ChangeHandlerRegistration","sap/ui/fl/Utils","sap/ui/fl/LayerUtils","sap/ui/fl/FlexCustomData","sap/ui/fl/write/api/FeaturesAPI","sap/ui/fl/Change","sap/ui/fl/Variant","sap/ui/fl/registry/Settings","sap/ui/fl/LrepConnector","sap/ui/fl/ChangePersistenceFactory","sap/ui/fl/context/ContextManager","sap/ui/core/util/reflection/JsControlTreeModifier","sap/ui/core/util/reflection/XmlTreeModifier","sap/ui/core/Component","sap/ui/core/Element","sap/base/Log","sap/base/util/restricted/_uniqWith","sap/ui/fl/apply/_internal/variants/URLHandler"],function(C,a,U,L,F,b,c,V,d,e,f,g,J,X,h,E,l,_,m){"use strict";var o=function(s,A){this._oChangePersistence=undefined;this._sComponentName=s||"";this._sAppVersion=A||U.DEFAULT_APP_VERSION;if(this._sComponentName&&this._sAppVersion){this._createChangePersistence();}};o.PENDING="sap.ui.fl:PendingChange";
o.prototype.setComponentName=function(s){this._sComponentName=s;this._createChangePersistence();};
o.prototype.getComponentName=function(){return this._sComponentName;};
o.prototype.getAppVersion=function(){return this._sAppVersion;};
o.prototype.getVariantModelData=function(){var D;if(this._oChangePersistence&&this._oChangePersistence._oVariantController._mVariantManagement&&Object.keys(this._oChangePersistence._oVariantController._mVariantManagement).length>0){D=this._oChangePersistence._oVariantController.fillVariantModel();}return D;};
o.prototype.setVariantSwitchPromise=function(p){this._oVariantSwitchPromise=p;};
o.prototype.waitForVariantSwitch=function(){if(!this._oVariantSwitchPromise){this._oVariantSwitchPromise=Promise.resolve();}return this._oVariantSwitchPromise;};
o.prototype.createBaseChange=function(i,A){var j;var k;var n=g._getContextIdsFromUrl();if(n.length>1){throw new Error("More than one DesignTime Context is currently active.");}if(!A){throw new Error("No application component found. To offer flexibility a valid relation to its owning component must be present.");}i.reference=this.getComponentName();i.packageName="$TMP";i.context=n.length===1?n[0]:"";i.validAppVersions=U.getValidAppVersions({appVersion:this.getAppVersion(),developerMode:i.developerMode,scenario:i.scenario});j=c.createInitialFileContent(i);k=new c(j);if(i.variantReference){k.setVariantReference(i.variantReference);}return k;};
o.prototype.createChange=function(i,j){var A;var k;return Promise.resolve().then(function(){if(!j){throw new Error("A flexibility change cannot be created without a targeted control.");}var s=j.id||j.getId();if(!i.selector){i.selector={};}A=j.appComponent||U.getAppComponentForControl(j);if(!A){throw new Error("No application component found. To offer flexibility, the control with the ID '"+s+"' has to have a valid relation to its owning application component.");}Object.assign(i.selector,J.getSelector(s,A));k=this.createBaseChange(i,A);var n=j.controlType||U.getControlType(j);if(!n){throw new Error("No control type found - the change handler can not be retrieved.");}return this._getChangeHandler(k,n,j,J);}.bind(this)).then(function(n){if(n){n.completeChangeContent(k,i,{modifier:J,appComponent:A});}else{throw new Error("Change handler could not be retrieved for change "+JSON.stringify(i)+".");}return k;});};
o.prototype.createVariant=function(v,A){var i;var j;if(!A){throw new Error("No Application Component found - to offer flexibility the variant has to have a valid relation to its owning application component.");}if(v.content.variantManagementReference){var k=J.checkControlId(v.content.variantManagementReference,A);if(!k){throw new Error("Generated ID attribute found - to offer flexibility a stable VariantManagement ID is needed to assign the changes to, but for this VariantManagement control the ID was generated by SAPUI5 "+v.content.variantManagementReference);}}v.content.reference=this.getComponentName();v.content.packageName="$TMP";v.content.validAppVersions=U.getValidAppVersions(this.getAppVersion(),v.developerMode,v.scenario);j=V.createInitialFileContent(v);i=new V(j);return i;};
o.prototype.addChange=function(i,j){return this.createChange(i,j).then(function(k){var A=U.getAppComponentForControl(j);this.addPreparedChange(k,A);return k;}.bind(this));};
o.prototype.addPreparedChange=function(i,A){if(i.getVariantReference()){var M=A.getModel(U.VARIANT_MODEL_NAME);M.addChange(i);}this._oChangePersistence.addChange(i,A);return i;};
o.prototype.deleteChange=function(i,A){this._oChangePersistence.deleteChange(i);if(i.getVariantReference()){A.getModel(U.VARIANT_MODEL_NAME).removeChange(i);}};
o.prototype.createAndApplyChange=function(i,j){var k;return Promise.resolve().then(function(){return this.addChange(i,j);}.bind(this)).then(function(A){k=A;var p={modifier:J,appComponent:U.getAppComponentForControl(j),view:U.getViewForControl(j)};k.setQueuedForApply();return this.checkTargetAndApplyChange(k,j,p);}.bind(this)).then(function(r){if(!r.success){var n=r.error||new Error("The change could not be applied.");this._oChangePersistence.deleteChange(k,true);throw n;}return k;}.bind(this));};
o.prototype._checkDependencies=function(j,D,k,A,r){var R=this._canChangePotentiallyBeApplied(j,A);if(!R){return[];}r.push(j);var s=j.getId();var p=D[s]&&D[s].dependencies||[];for(var i=0,n=p.length;i<n;i++){var q=U.getChangeFromChangesMap(k,p[i]);R=this._checkDependencies(q,D,k,A,r);if(R.length===0){r=[];break;}delete D[s];}return r;};
o.prototype._canChangePotentiallyBeApplied=function(i,A){var s=i.getDependentControlSelectorList();s.push(i.getSelector());return!s.some(function(S){return!J.bySelector(S,A);});};
o.prototype.waitForChangesToBeApplied=function(i){var j=this._oChangePersistence.getChangesMapForComponent();var p=[];var D=Object.assign({},j.mDependencies);var k=j.mChanges;var n=k[i.getId()]||[];var N=n.filter(function(q){return!q.isCurrentProcessFinished();},this);var A=U.getAppComponentForControl(i);var r=[];N.forEach(function(q){var s=this._checkDependencies(q,D,j.mChanges,A,[]);s.forEach(function(t){if(r.indexOf(t)===-1){r.push(t);}});}.bind(this));r.forEach(function(q){p=p.concat(q.addChangeProcessingPromises());},this);p.push(this.waitForVariantSwitch());return Promise.all(p).then(function(){return undefined;});};
o.prototype.saveAll=function(s){return this._oChangePersistence.saveDirtyChanges(s);};
o.prototype.processXmlView=function(v,p){var i=h.get(p.componentId);var A=U.getAppComponentForControl(i);var M=A.getManifest();p.appComponent=A;p.appDescriptor=M;p.modifier=X;p.view=v;return this.processViewByModifier(p);};
o.prototype.processViewByModifier=function(p){p.siteId=U.getSiteId(p.appComponent);return this._oChangePersistence.getChangesForView(p.viewId,p).then(this._resolveGetChangesForView.bind(this,p),this._handlePromiseChainError.bind(this,p.view));};
o.prototype._checkForDependentSelectorControls=function(i,p){var D=i.getDependentControlSelectorList();D.forEach(function(s){var j=p.modifier.bySelector(s,p.appComponent,p.view);if(!j){throw new Error("A dependent selector control of the flexibility change is not available.");}});};
o.prototype._resolveGetChangesForView=function(p,i){var P=[];if(!Array.isArray(i)){var s="No list of changes was passed for processing the flexibility on view: "+p.view+".";l.error(s,undefined,"sap.ui.fl.FlexController");return[];}i.forEach(function(j){try{var S=this._getSelectorOfChange(j);if(!S||!S.id){throw new Error("No selector in change found or no selector ID.");}var k=p.modifier.bySelector(S,p.appComponent,p.view);if(!k){throw new Error("A flexibility change tries to change a nonexistent control.");}this._checkForDependentSelectorControls(j,p);j.setQueuedForApply();P.push(function(){var I=this._isChangeCurrentlyApplied(k,j,p.modifier);var q=j.isApplyProcessFinished();if(q&&!I){j.setInitialApplyState();}else if(!q&&I){j.markFinished();return new U.FakePromise();}return this.checkTargetAndApplyChange(j,k,p).then(function(r){if(!r.success){this._logApplyChangeError(r.error||{},j);}}.bind(this));}.bind(this));}catch(n){this._logApplyChangeError(n,j);}}.bind(this));return U.execPromiseQueueSequentially(P).then(function(){return p.view;});};
o.prototype._logApplyChangeError=function(i,j){var D=j.getDefinition();var s=D.changeType;var t=D.selector.id;var k=D.namespace+D.fileName+"."+D.fileType;var w="A flexibility change could not be applied.";w+="\nThe displayed UI might not be displayed as intedend.";if(i.message){w+="\n   occurred error message: '"+i.message+"'";}w+="\n   type of change: '"+s+"'";w+="\n   LRep location of the change: "+k;w+="\n   id of targeted control: '"+t+"'.";l.warning(w,undefined,"sap.ui.fl.FlexController");};
o.prototype._isXmlModifier=function(p){return p.modifier.targets==="xmlTree";};
o.prototype.checkTargetAndApplyChange=function(i,j,p){var x=this._isXmlModifier(p);var M=p.modifier;var s=M.getControlType(j);var k=this._getControlIfTemplateAffected(i,j,s,p);var r;var n=M.getLibraryName(k.control);var w=new U.FakePromise();if(a.isChangeHandlerRegistrationInProgress(n)){w=a.waitForChangeHandlerRegistration(n);}return w.then(function(){return this._getChangeHandler(i,k.controlType,k.control,M);}.bind(this)).then(function(q){if(!q){var t="Change handler implementation for change not found or change type not enabled for current layer - Change ignored";l.warning(t);r={success:false,error:new Error(t)};i.setInitialApplyState();return r;}if(x&&i.getDefinition().jsOnly){r={success:false,error:new Error("Change cannot be applied in XML. Retrying in JS.")};i.setInitialApplyState();return r;}if(i.hasApplyProcessStarted()){return i.addPromiseForApplyProcessing().then(function(r){i.markFinished();return r;});}else if(!i.isApplyProcessFinished()){return new U.FakePromise().then(function(){i.startApplying();return q.applyChange(i,k.control,p);}).then(function(I){if(I instanceof E){k.control=I;}if(k.control){M.updateAggregation(j,i.getContent().boundAggregation);}F.addAppliedCustomData(k.control,i,p,x);r={success:true};i.markFinished(r);return r;}).catch(function(R){this._logErrorAndWriteCustomData(R,i,p,k.control,x);r={success:false,error:R};if(x){i.setInitialApplyState();}else{i.markFinished(r);}return r;}.bind(this));}r={success:true};i.markFinished(r);return r;}.bind(this));};
o.prototype._removeFromAppliedChangesAndMaybeRevert=function(i,j,p,r){var R=Promise.resolve(true);if(r){R=this._revertChange(i,j,p);}return R.then(function(v){this._removeChangeFromControl(v||j,i,p.modifier);return!!v;}.bind(this));};
o.prototype._revertChange=function(i,j,p){var M=p.modifier;var s;var k;var I;var n;var q={};return new U.FakePromise().then(function(){if(!j){throw Error("A flexibility change tries to revert changes on a nonexistent control");}k=M.getControlType(j);q=this._getControlIfTemplateAffected(i,j,k,p);}.bind(this)).then(this._getChangeHandler.bind(this,i,q.controlType,q.control,M)).then(function(r){n=r;var t;if(!n){t="Change handler implementation for change not found or change type not enabled for current layer - Change ignored";}else if(!(typeof n.revertChange==="function")){t="No revert change function available to handle revert data for control type "+q.controlType;}if(t){l.error(t);i.markRevertFinished(new Error(t));return new U.FakePromise(false);}if(i.getChangeType()==="stashControl"&&k==="sap.ui.core._StashedControl"){s=true;if(!i.getRevertData()){n.setChangeRevertData(i,false);}}I=i.isApplyProcessFinished();if(!I&&i.hasApplyProcessStarted()){return i.addPromiseForApplyProcessing().then(function(R){if(R&&R.error){i.markRevertFinished(R.error);throw Error(R.error);}return true;});}return false;}).then(function(P){if(P||(!P&&I)||s){if(!i.getRevertData()){i.setRevertData(F.getParsedRevertDataFromCustomData(j,i,M));}i.startReverting();return n.revertChange(i,q.control,p);}throw Error("Change was never applied");}).then(function(){q.control=p.modifier.bySelector(i.getSelector(),p.appComponent,p.view);if(q.bTemplateAffected){M.updateAggregation(q.control,i.getContent().boundAggregation);}i.markRevertFinished();return q.control;}).catch(function(r){var t="Change could not be reverted: "+r.message;l.error(t);i.markRevertFinished(t);return false;});};
o.prototype._removeChangeFromControl=function(i,j,M){F.destroyAppliedCustomData(i,j,M);};
o.prototype._logErrorAndWriteCustomData=function(r,i,p,j,x){var s=i.getId();var k="Change ''{0}'' could not be applied.";var n=r instanceof Error;var q=F.getCustomDataIdentifier(false,n,x);switch(q){case F.notApplicableChangesCustomDataKey:U.formatAndLogMessage("info",[k,r.message],[s]);break;case F.failedChangesCustomDataKeyXml:U.formatAndLogMessage("warning",[k,"Merge error detected while processing the XML tree."],[s],r.stack);break;case F.failedChangesCustomDataKeyJs:U.formatAndLogMessage("error",[k,"Merge error detected while processing the JS control tree."],[s],r.stack);break;}F.addFailedCustomData(j,i,p,q);};
o.prototype._isChangeCurrentlyApplied=function(i,j,M){return F.hasChangeApplyFinishedCustomData(i,j,M);};
o.prototype._handlePromiseChainError=function(v,i){l.error("Error processing view "+i+".");return v;};
o.prototype._getSelectorOfChange=function(i){if(!i||!i.getSelector){return undefined;}return i.getSelector();};
o.prototype._getChangeHandler=function(i,s,j,M){var k=i.getChangeType();var n=i.getLayer();return this._getChangeRegistry().getChangeHandler(k,s,j,M,n);};
o.prototype._getChangeRegistry=function(){var i=C.getInstance();i.initSettings();return i;};
o.prototype._getControlIfTemplateAffected=function(i,j,s,p){var k=i.getDefinition();var n={};if(i.getContent().boundAggregation&&k.dependentSelector.originalSelector){var M=p.modifier;n.control=M.bySelector(k.dependentSelector.originalSelector,p.appComponent,p.view);n.controlType=M.getControlType(n.control);n.bTemplateAffected=true;}else{n.control=j;n.controlType=s;n.bTemplateAffected=false;}return n;};
o.prototype.getComponentChanges=function(p,i){return this._oChangePersistence.getChangesForComponent(p,i);};
o.prototype.checkForOpenDependenciesForControl=function(s,M,i){return this._oChangePersistence.checkForOpenDependenciesForControl(s,M,i);};
o.prototype.hasHigherLayerChanges=function(p){p=p||{};var s=p.upToLayer||L.getCurrentLayer(false);p.includeVariants=true;p.includeCtrlVariants=true;return this.getComponentChanges(p).then(function(v){var H=v===this._oChangePersistence.HIGHER_LAYER_CHANGES_EXIST||v.some(function(i){return L.compareAgainstCurrentLayer(i.getLayer(),s)>0;});return!!H;}.bind(this));};
o.prototype._createChangePersistence=function(){this._oChangePersistence=f.getChangePersistenceForComponent(this.getComponentName(),this.getAppVersion());return this._oChangePersistence;};
o.prototype.resetChanges=function(s,G,i,S,j){return this._oChangePersistence.resetChanges(s,G,S,j).then(function(k){if(k.length!==0){return this.revertChangesOnControl(k,i);}}.bind(this)).then(function(){if(i){var M=i.getModel(U.VARIANT_MODEL_NAME);if(M){m.update({parameters:[],updateURL:true,updateHashEntry:true,model:M});}}});};
o.prototype.discardChanges=function(i,D){var A=L.getCurrentLayer(!!D);var I=0;var j;var k;j=i.length;while(I<i.length){k=i[I];if(k&&k.getLayer&&k.getLayer()===A){this._oChangePersistence.deleteChange(k);}if(j===i.length){I++;}else{j=i.length;}}return this._oChangePersistence.saveDirtyChanges();};
o.prototype.discardChangesForId=function(i,D){if(!i){return Promise.resolve();}var j=this._oChangePersistence.getChangesMapForComponent();var k=j.mChanges[i]||[];return this.discardChanges(k,D);};
o.prototype._checkIfDependencyIsStillValid=function(A,M,s){var i=U.getChangeFromChangesMap(this._oChangePersistence._mChanges.mChanges,s);var j=M.bySelector(i.getSelector(),A);if(this._isChangeCurrentlyApplied(j,i,M)||i.hasApplyProcessStarted()){return false;}return true;};
o.prototype._applyChangesOnControl=function(G,A,i){var p=[];var s=i.getId();var j=G();var k=j.mChanges;var D=j.mDependencies;var n=j.mControlsWithDependencies;var q=k[s]||[];var P={modifier:J,appComponent:A,view:U.getViewForControl(i)};q.forEach(function(r){var t=J.getControlType(i);var u=this._getControlIfTemplateAffected(r,i,t,P);var I=this._isChangeCurrentlyApplied(u.control,r,P.modifier);var v=r.isApplyProcessFinished();if(v&&!I){j=this._oChangePersistence.copyDependenciesFromInitialChangesMap(r,this._checkIfDependencyIsStillValid.bind(this,A,P.modifier),A);D=j.mDependencies;n=j.mControlsWithDependencies;r.setInitialApplyState();}else if(!v&&I){r.markFinished();}r.setQueuedForApply();if(!D[r.getId()]){p.push(function(){return this.checkTargetAndApplyChange(r,i,P).then(function(){this._updateDependencies(j,r.getId());}.bind(this));}.bind(this));}else{D[r.getId()][o.PENDING]=this.checkTargetAndApplyChange.bind(this,r,i,P);}}.bind(this));if(q.length||n[s]){delete n[s];return U.execPromiseQueueSequentially(p).then(function(){return this._processDependentQueue(j,A);}.bind(this));}return new U.FakePromise();};
o.prototype.getBoundApplyChangesOnControl=function(G,i){var B=this._applyChangesOnControl.bind(this,G,i);B._bIsSapUiFlFlexControllerApplyChangesOnControl=true;return B;};
o.prototype.revertChangesOnControl=function(i,A){var p=[];i.forEach(function(j){j.setQueuedForRevert();p.push(function(){var s=this._getSelectorOfChange(j);var k=J.bySelector(s,A);if(!k){l.warning("A flexibility change tries to revert changes on a nonexistent control with id "+s.id);return Promise.resolve();}var P={modifier:J,appComponent:A,view:U.getViewForControl(k)};return this._removeFromAppliedChangesAndMaybeRevert(j,k,P,true).then(function(S){if(S){this._oChangePersistence._deleteChangeInMap(j);}}.bind(this));}.bind(this));}.bind(this));return U.execPromiseQueueSequentially(p);};
o.prototype.applyVariantChanges=function(i,A){var p=[];var M=J;var j=i.map(function(k){this._oChangePersistence._addChangeAndUpdateDependencies(A,k);return this._getSelectorOfChange(k);}.bind(this));var s=function(S,t){return S.id===t.id;};j=_(j,s);j.forEach(function(S){p.push(function(){var k=M.bySelector(S,A);if(!k){l.error("A flexibility change tries to change a nonexistent control.");return new U.FakePromise();}return this._applyChangesOnControl(this._oChangePersistence.getChangesMapForComponent.bind(this._oChangePersistence),A,k);}.bind(this));}.bind(this));return U.execPromiseQueueSequentially(p);};
o.prototype.removeFromAppliedChangesOnControl=function(i,A,j){var p={modifier:J,appComponent:A,view:U.getViewForControl(j)};return this._removeFromAppliedChangesAndMaybeRevert(i,j,p,false);};
o.prototype._updateControlsDependencies=function(i,A){var j;Object.keys(i.mDependencies).forEach(function(s){var D=i.mDependencies[s];if(D.controlsDependencies&&D.controlsDependencies.length>0){var k=D.controlsDependencies.length;while(k--){var S=D.controlsDependencies[k];j=J.bySelector(S,A);if(j){D.controlsDependencies.splice(k,1);delete i.mControlsWithDependencies[j.getId()];}}}});};
o.prototype._updateDependencies=function(i,s){if(i.mDependentChangesOnMe[s]){i.mDependentChangesOnMe[s].forEach(function(k){var D=i.mDependencies[k];var I=D?D.dependencies.indexOf(s):-1;if(I>-1){D.dependencies.splice(I,1);}});delete i.mDependentChangesOnMe[s];}};
o.prototype._iterateDependentQueue=function(i,A){var n=[];var D=[];var p=[];this._updateControlsDependencies(i,A);Object.keys(i.mDependencies).forEach(function(s){var j=i.mDependencies[s];if(j[o.PENDING]&&j.dependencies.length===0&&!(j.controlsDependencies&&j.controlsDependencies.length>0)){p.push(function(){return j[o.PENDING]().then(function(){D.push(s);n.push(j.changeObject.getId());});});}});return U.execPromiseQueueSequentially(p).then(function(){for(var j=0;j<D.length;j++){delete i.mDependencies[D[j]];}for(var k=0;k<n.length;k++){this._updateDependencies(i,n[k]);}return n;}.bind(this));};
o.prototype._processDependentQueue=function(i,A){return this._iterateDependentQueue(i,A).then(function(j){if(j.length>0){return this._processDependentQueue(i,A);}}.bind(this));};
o.prototype.saveSequenceOfDirtyChanges=function(D){return this._oChangePersistence.saveSequenceOfDirtyChanges(D);};
o.prototype.getResetAndPublishInfo=function(p){p.reference=this._sComponentName;p.appVersion=this._sAppVersion;return e.createConnector().getFlexInfo(p);};
return o;},true);
sap.ui.predefine('sap/ui/fl/FlexControllerFactory',["sap/ui/fl/FlexController","sap/ui/fl/Utils","sap/ui/fl/ChangePersistenceFactory","sap/ui/fl/variants/VariantModel","sap/base/Log"],function(F,U,C,V,L){"use strict";var a={};a._instanceCache={};
a.create=function(c,A){A=A||U.DEFAULT_APP_VERSION;if(!a._instanceCache[c]){a._instanceCache[c]={};}var f=a._instanceCache[c][A];if(!f){f=new F(c,A);a._instanceCache[c][A]=f;}return f;};
a.createForControl=function(c,m){try{var A=U.getAppComponentForControl(c);var s=U.getComponentClassName(A||c);var b=U.getAppVersionFromManifest(A?A.getManifest():m);return a.create(s,b);}catch(e){L.error(e.message,undefined,"sap.ui.fl.FlexControllerFactory");}};
a.getChangesAndPropagate=function(c,v){if(U.isApplicationComponent(c)){return _(c,v);}else if(U.isEmbeddedComponent(c)){var A=U.getAppComponentForControl(c);if(A){return Promise.resolve().then(function(){var e=A.getModel(U.VARIANT_MODEL_NAME);if(!e){return _(A,v);}return e;}).then(function(o){c.setModel(o,U.VARIANT_MODEL_NAME);});}}};
function _(A,c){var m=A.getManifestObject();var f;f=a.createForControl(A,m);return C._getChangesForComponentAfterInstantiation(c,m,A).then(function(g){A.addPropagationListener(f.getBoundApplyChangesOnControl(g,A));var d=f.getVariantModelData()||{};var v=new V(d,f,A);A.setModel(v,U.VARIANT_MODEL_NAME);return v;});}
return a;},true);
sap.ui.predefine('sap/ui/fl/FlexCustomData',["sap/ui/core/CustomData"],function(){"use strict";var F={};F.appliedChangesCustomDataKey="sap.ui.fl.appliedChanges";F.failedChangesCustomDataKeyJs="sap.ui.fl.failedChanges.js";F.failedChangesCustomDataKeyXml="sap.ui.fl.failedChanges.xml";F.notApplicableChangesCustomDataKey="sap.ui.fl.notApplicableChanges";
F.getAppliedCustomDataValue=function(c,C,m){var a=this._getCustomData(c,m,this._getCustomDataKey(C,F.appliedChangesCustomDataKey));return a.customDataValue;};
F.getParsedRevertDataFromCustomData=function(c,C,m){var s=this.getAppliedCustomDataValue(c,C,m);return s&&JSON.parse(s);};
F.hasFailedCustomDataJs=function(c,C,m){var a=this._getCustomData(c,m,this._getCustomDataKey(C,F.failedChangesCustomDataKeyJs));return!!a.customDataValue;};
F.hasAppliedCustomData=function(c,C,m){return!!this.getAppliedCustomDataValue(c,C,m);};
F.hasNotApplicableCustomData=function(c,C,m){var a=this._getCustomData(c,m,this._getCustomDataKey(C,F.notApplicableChangesCustomDataKey));return!!a.customDataValue;};
F.hasChangeApplyFinishedCustomData=function(c,C,m){var a=["hasAppliedCustomData","hasFailedCustomDataJs","hasNotApplicableCustomData"];return a.some(function(s){return!!this[s](c,C,m);},this);};
F.addAppliedCustomData=function(c,C,p,s){var a;var b=this._getCustomDataKey(C,F.appliedChangesCustomDataKey);if(s){a=this._escapeCurlyBracketsInString(JSON.stringify(C.getRevertData()));}else{a="true";}this._writeCustomData(c,b,a,p);};
F.addFailedCustomData=function(c,C,p,i){var s=this._getCustomDataKey(C,i);this._writeCustomData(c,s,"true",p);};
F.destroyAppliedCustomData=function(c,C,m){var k=this._getCustomDataKey(C,F.appliedChangesCustomDataKey);var a=this._getCustomData(c,m,k);if(a.customData){m.destroy(a.customData);}};
F.getCustomDataIdentifier=function(s,e,x){if(s){return F.appliedChangesCustomDataKey;}if(!e){return F.notApplicableChangesCustomDataKey;}if(x){return F.failedChangesCustomDataKeyXml;}return F.failedChangesCustomDataKeyJs;};
F._escapeCurlyBracketsInString=function(t){return t.replace(/{/g,'\\\{').replace(/}/g,'\\\}');};
F._getCustomDataKey=function(c,i){return i+"."+c.getId();};
F._writeCustomData=function(c,k,v,p){var C=this._getCustomData(c,p.modifier,k);if(!C.customData){this._createAndAddCustomDataControl(c,p,k,v);}else{p.modifier.setProperty(C.customData,"value",v);}};
F._createAndAddCustomDataControl=function(c,p,C,v){var m=p.modifier;var V=p.view;var o=p.appComponent;var a=m.createControl("sap.ui.core.CustomData",o,V,undefined,undefined,false);m.setProperty(a,"key",C);m.setProperty(a,"value",v);m.insertAggregation(c,"customData",a,0,V);return a;};
F._getCustomData=function(c,m,C){var a=m.getAggregation(c,"customData")||[];var r={};a.some(function(o){var k=m.getProperty(o,"key");if(k===C){r.customData=o;r.customDataValue=m.getProperty(o,"value");return true;}});return r;};
return F;},true);
sap.ui.predefine('sap/ui/fl/LayerUtils',["sap/base/util/UriParameters","sap/ui/thirdparty/hasher"],function(U,h){"use strict";var L={BASE:"BASE",VENDOR:"VENDOR",PARTNER:"PARTNER",CUSTOMER_BASE:"CUSTOMER_BASE",CUSTOMER:"CUSTOMER",USER:"USER"};var l=[L.BASE,L.VENDOR,L.PARTNER,L.CUSTOMER_BASE,L.CUSTOMER,L.USER];var m={};l.forEach(function(s,i){m[s]=i;});var a={_mLayersIndex:m,_sTopLayer:l[l.length-1],FL_MAX_LAYER_PARAM:"sap-ui-fl-max-layer",isVendorLayer:function(){return this.getCurrentLayer(false)===L.VENDOR;},isCustomerDependentLayer:function(s){return([L.CUSTOMER,L.CUSTOMER_BASE].indexOf(s)>-1);},doesCurrentLayerRequirePackage:function(){var c=this.getCurrentLayer(false);return(c===L.VENDOR)||(c===L.PARTNER)||(c===L.CUSTOMER_BASE);},getMaxLayer:function(){var p;var u=this.getUshellContainer();if(u){var P=u.getService("URLParsing").parseShellHash(h.getHash())||{};if(P.params&&P.params.hasOwnProperty(this.FL_MAX_LAYER_PARAM)){p=P.params[this.FL_MAX_LAYER_PARAM][0];}}return p||this.getUrlParameter(this.FL_MAX_LAYER_PARAM)||this._sTopLayer;},getLayerIndex:function(s){return this._mLayersIndex[s];},isOverMaxLayer:function(s){return(this.getLayerIndex(s)>this.getLayerIndex(this.getMaxLayer()));},compareAgainstCurrentLayer:function(s,c){var C=c||a.getCurrentLayer(false);if((this.getLayerIndex(C)>this.getLayerIndex(s))||!s){return-1;}else if(this.getLayerIndex(C)===this.getLayerIndex(s)){return 0;}return 1;},isLayerFilteringRequired:function(){return!(this._sTopLayer===this.getMaxLayer());},getCurrentLayer:function(i){if(i){return L.USER;}var s=this.getUrlParameter("sap-ui-layer")||"";s=s.toUpperCase();return s||L.CUSTOMER;},getUrlParameter:function(p){return U.fromQuery(window.location.search).get(p);},getUshellContainer:function(){return sap.ushell&&sap.ushell.Container;}};return a;},true);
sap.ui.predefine('sap/ui/fl/LrepConnector',["sap/ui/thirdparty/jquery","sap/ui/thirdparty/URI","sap/ui/fl/Utils","sap/ui/fl/write/_internal/CompatibilityConnector","sap/base/util/merge","sap/ui/dom/includeScript"],function(q,u,F,C,b,I){"use strict";var L=function(p){this._initClientParam();this._initLanguageParam();if(p){this._sXsrfToken=p.XsrfToken;}};
L.createConnector=function(p){if(F.areNewConnectorsNecessary()){return new C(p);}return new L(p);};
L._bServiceAvailability=undefined;L._oLoadSettingsPromise=undefined;L.prototype._sClient=undefined;L.prototype._sLanguage=undefined;L.prototype._aSentRequestListeners=[];L.prototype._sRequestUrlPrefix="";L.DEFAULT_CONTENT_TYPE="application/json; charset=utf-8";L.ROUTES={CONTENT:"/content/",CSRF:"/actions/getcsrftoken/",PUBLISH:"/actions/publish/",DATA:"/flex/data/",MODULES:"/flex/modules/",SETTINGS:"/flex/settings",INFO:"/flex/info"};
L.isFlexServiceAvailable=function(){if(L._bServiceAvailability!==undefined){return Promise.resolve(L._bServiceAvailability);}return L.createConnector().loadSettings().then(function(){return Promise.resolve(L._bServiceAvailability);});};
L.attachSentRequest=function(c){if(typeof c==="function"&&L.prototype._aSentRequestListeners.indexOf(c)===-1){L.prototype._aSentRequestListeners.push(c);}};
L.detachSentRequest=function(c){var i=L.prototype._aSentRequestListeners.indexOf(c);if(i!==-1){L.prototype._aSentRequestListeners.splice(i,1);}};
L.prototype._initClientParam=function(){var c=F.getClient();if(c){this._sClient=c;}};
L.prototype._initLanguageParam=function(){var l;l=F.getUrlParameter("sap-language")||F.getUrlParameter("sap-ui-language");if(l){this._sLanguage=l;}};
L.prototype.setRequestUrlPrefix=function(r){this._sRequestUrlPrefix=r;};
L.prototype._resolveUrl=function(r){if(!r.startsWith("/")){r="/"+r;}r=this._sRequestUrlPrefix+r;var U=u(r).absoluteTo("");return U.toString();};
L.prototype._getDefaultHeader=function(){return{headers:{"X-CSRF-Token":this._sXsrfToken||"fetch"}};};
L.prototype._getDefaultOptions=function(m,c,d){var o;if(!c){c=L.DEFAULT_CONTENT_TYPE;}else if(c.indexOf("charset")===-1){c+="; charset=utf-8";}o=b(this._getDefaultHeader(),{type:m,async:true,contentType:c,processData:false,headers:{"Content-Type":c}});if(d&&o.contentType.indexOf("application/json")===0){o.dataType="json";if(typeof d==="object"){o.data=JSON.stringify(d);}else{o.data=d;}}else if(d){o.data=d;}if(m==="DELETE"){delete o.data;delete o.contentType;}return o;};
L.prototype.send=function(U,m,d,o){m=m||"GET";m=m.toUpperCase();o=o||{};U=this._resolveUrl(U);o=b(this._getDefaultOptions(m,o.contentType,d),o);return this._sendAjaxRequest(U,o);};
L.prototype._getMessagesFromXHR=function(x){var a;var m;var l;var i;m=[];try{a=JSON.parse(x.responseText);if(a&&a.messages&&a.messages.length>0){l=a.messages.length;for(i=0;i<l;i++){m.push({severity:a.messages[i].severity,text:a.messages[i].text});}}}catch(e){}return m;};
L.prototype._sendAjaxRequest=function(U,o){var f=F.getLrepUrl();if(!f){return Promise.reject({status:"warning",messages:[{severity:"warning",text:"Flexibility Services requests were not sent. The UI5 bootstrap is configured to not send any requests."}]});}var s=f+L.ROUTES.CSRF;var m={headers:{"X-CSRF-Token":"fetch"},type:"HEAD"};if(this._sClient){m.headers["sap-client"]=this._sClient;}return new Promise(function(r,a){function h(e,S,x){var n=x.getResponseHeader("X-CSRF-Token");this._sXsrfToken=n||this._sXsrfToken;var E=x.getResponseHeader("etag");var g={status:S,etag:E,response:e};r(g);q.each(this._aSentRequestListeners,function(i,j){j(g);});}function p(e,x,S,E){var g=new Error(E);g.status=S;g.code=x.statusCode().status;g.messages=this._getMessagesFromXHR(x);if(!g.stack){try{throw g;}catch(i){e(i);}}else{e(g);}}function c(e,S,x){this._sXsrfToken=x.getResponseHeader("X-CSRF-Token");o.headers=o.headers||{};o.headers["X-CSRF-Token"]=this._sXsrfToken;q.ajax(U,o).done(h).fail(p.bind(this,a));}function d(e,g,x,S,E){if(x.status===403){q.ajax(s,m).done(c.bind(this)).fail(function(){g({status:"error"});});}else if(o&&o.type==="DELETE"&&x.status===404){e();}else{p.call(this,g,x,S,E);}}var R=true;if(o&&o.type){if(o.type==="GET"||o.type==="HEAD"){R=false;}else if(this._sXsrfToken&&this._sXsrfToken!=="fetch"){R=false;}}if(R){q.ajax(s,m).done(c.bind(this)).fail(p.bind(this,a));}else{q.ajax(U,o).done(h.bind(this)).fail(d.bind(this,r,a));}}.bind(this));};
L.prototype.loadChanges=function(c,p){function _(p){var o={};if(p.cacheKey){o.cache=true;}if(p.siteId){if(!o.headers){o.headers={};}o.headers={"X-LRep-Site-Id":p.siteId};}if(p.appDescriptor){if(p.appDescriptor["sap.app"]){if(!o.headers){o.headers={};}o.headers={"X-LRep-AppDescriptor-Id":p.appDescriptor["sap.app"].id};}}return o;}function a(c,p,s){var U={};var f=F.getLrepUrl()+L.ROUTES.DATA;var d=F.getLrepUrl()+L.ROUTES.MODULES;var P="";if(p.cacheKey){P+="~"+p.cacheKey+"~/";}P+=c.name;if(p.layer){P+="&upToLayerType="+p.layer;}if(s){P+="&sap-client="+s;}if(c.appVersion&&(c.appVersion!==F.DEFAULT_APP_VERSION)){P+="&appVersion="+c.appVersion;}P=P.replace("&","?");U.flexDataUrl=U.flexDataUrl||f+P;U.flexModulesUrl=U.flexModulesUrl||d+P;return U;}p=p||{};if(!c.name){return Promise.reject(new Error("Component name not specified"));}var o=_(p);var U=a.call(this,c,p,this._sClient);return this.send(U.flexDataUrl,undefined,undefined,o).then(this._onChangeResponseReceived.bind(this,c.name,U.flexModulesUrl,p.cacheKey)).then(function(f){if(p.isTrial){return this.enableFakeConnectorForTrial(c,f);}return f;}.bind(this)).catch(function(e){if(e.code===404){L._bServiceAvailability=false;}throw(e);});};
L.prototype.getFlexInfo=function(p){if(!p.reference){throw new Error("No Component to get flex info");}var r=F.getLrepUrl()+L.ROUTES.INFO+"/"+p.reference;var P=[];if(p.appVersion){P.push({name:"appVersion",value:p.appVersion});}if(p.layer){P.push({name:"layer",value:p.layer});}r+=this._buildParams(P);return this.send(r,"GET",null,null).then(function(R){return R.response;},function(){return Promise.resolve({});});};
L.prototype.enableFakeConnectorForTrial=function(c,f){return new Promise(function(r){sap.ui.require(["sap/ui/fl/FakeLrepConnectorLocalStorage","sap/ui/fl/registry/Settings"],function(a,S){var s=S.getInstanceOrUndef()._oSettings;a.enableFakeConnector(s,c.name,c.appVersion,true);var o=L.createConnector();r(o.loadChanges(c.name,undefined,f.changes.changes));});});};
L.prototype._onChangeResponseReceived=function(c,f,s,r){L._bServiceAvailability=true;if(r.etag===null){r.etag=s;}var m={changes:r.response,loadModules:r.response.loadModules,messagebundle:r.response.messagebundle,componentClassName:c,etag:r.etag};if(!m.loadModules){return m;}return this._loadModules(f).then(function(){return m;});};
L.prototype._loadModules=function(f){return new Promise(function(r,a){I(f,undefined,r,a);});};
L.prototype.loadSettings=function(){if(!L._oLoadSettingsPromise){var U=F.getLrepUrl()+L.ROUTES.SETTINGS;if(this._sClient){U+="?sap-client="+this._sClient;}L._oLoadSettingsPromise=this.send(U,undefined,undefined,{});}return L._oLoadSettingsPromise.then(function(r){L._bServiceAvailability=true;return r.response;},function(e){if(e.code===404){L._bServiceAvailability=false;}return Promise.resolve();});};
L.prototype._buildParams=function(p){if(!p){p=[];}if(this._sClient){p.push({name:"sap-client",value:this._sClient});}if(this._sLanguage){p.push({name:"sap-language",value:this._sLanguage});}var r="";var l=p.length;for(var i=0;i<l;i++){if(i===0){r+="?";}else if(i>0&&i<l){r+="&";}r+=p[i].name+"="+p[i].value;}return r;};
L.prototype._getUrlPrefix=function(i){if(i){return F.getLrepUrl()+"/variants/";}return F.getLrepUrl()+"/changes/";};
L.prototype.create=function(p,c,i){var r=this._getUrlPrefix(i);var P=[];if(c){P.push({name:"changelist",value:c});}r+=this._buildParams(P);return this.send(r,"POST",p,null);};
L.prototype.update=function(f,c){var r=this._getUrlPrefix(f.fileType==="variant");r+=f.fileName;var p=[];if(c){p.push({name:"changelist",value:c});}r+=this._buildParams(p);return this.send(r,"PUT",f,null);};
L.prototype.deleteChange=function(f,c){var r=this._getUrlPrefix(f.fileType==="variant");r+=f.fileName;var p=[];p.push({name:"layer",value:f.layer});p.push({name:"namespace",value:f.namespace});if(c){p.push({name:"changelist",value:c});}r+=this._buildParams(p);return this.send(r,"DELETE",{},null);};
L.prototype.resetChanges=function(p){var r=this._getUrlPrefix();var P=[];if(p.sReference){P.push({name:"reference",value:p.sReference});}if(p.sAppVersion){P.push({name:"appVersion",value:p.sAppVersion});}if(p.sLayer){P.push({name:"layer",value:p.sLayer});}if(p.sChangelist){P.push({name:"changelist",value:p.sChangelist});}if(p.sGenerator){P.push({name:"generator",value:p.sGenerator});}if(p.aSelectorIds){P.push({name:"selector",value:p.aSelectorIds.join(",")});}if(p.aChangeTypes){P.push({name:"changeType",value:p.aChangeTypes.join(",")});}r+=this._buildParams(P);return this.send(r,"DELETE");};
L.prototype.getStaticResource=function(n,N,t,i){var r=F.getLrepUrl()+L.ROUTES.CONTENT;r+=n+"/"+N+"."+t;var p=[];if(!i){p.push({name:"dt",value:"true"});}r+=this._buildParams(p);return this.send(r,"GET",null,null);};
L.prototype.getFileAttributes=function(n,N,t,l){var r=F.getLrepUrl()+L.ROUTES.CONTENT;r+=n+"/"+N+"."+t;var p=[];p.push({name:"metadata",value:"true"});if(l){p.push({name:"layer",value:l});}r+=this._buildParams(p);return this.send(r,"GET",null,null);};
L.prototype.upsert=function(n,N,t,l,c,s,a){var d=this;return Promise.resolve(d._fileAction("PUT",n,N,t,l,c,s,a));};
L.prototype.deleteFile=function(n,N,t,l,c){return this._fileAction("DELETE",n,N,t,l,null,null,c);};
L.prototype._fileAction=function(m,n,N,t,l,c,s,a){var r=F.getLrepUrl()+L.ROUTES.CONTENT;r+=n+"/"+N+"."+t;var p=[];p.push({name:"layer",value:l});if(a){p.push({name:"changelist",value:a});}r+=this._buildParams(p);var o={contentType:s||L.DEFAULT_CONTENT_TYPE};return this.send(r,m.toUpperCase(),c,o);};
L.prototype.publish=function(o,n,t,O,T,s,c){var r=F.getLrepUrl()+L.ROUTES.PUBLISH;r+=o+"/"+n+"."+t;var p=[];if(O){p.push({name:"layer",value:O});}if(T){p.push({name:"target-layer",value:T});}if(s){p.push({name:"target-namespace",value:s});}if(c){p.push({name:"changelist",value:c});}r+=this._buildParams(p);return this.send(r,"POST",{},null);};
L.prototype.listContent=function(n,l){var r=F.getLrepUrl()+L.ROUTES.CONTENT;r+=n;var p=[];if(l){p.push({name:"layer",value:l});}r+=this._buildParams(p);return this.send(r,"GET",null,null);};
return L;},true);
sap.ui.predefine('sap/ui/fl/Preprocessor',["sap/ui/base/Object"],function(B){"use strict";return B.extend("sap.ui.fl.Preprocessor",{});},true);
sap.ui.predefine('sap/ui/fl/PreprocessorImpl',["sap/ui/core/Component","sap/ui/fl/Utils","sap/ui/fl/ChangePersistenceFactory","sap/base/Log"],function(C,U,a,L){'use strict';
function i(c){return c.getChangeType()==="codeExt";}
function b(c,o){var s=o.getSelector().controllerName;return c===s;}
var P=function(){};
P.prototype.getControllerExtensions=function(c,s,A){if(A){if(!s){L.warning("No component ID for determining the anchor of the code extensions was passed.");return Promise.resolve([]);}var o=C.get(s);var d=U.getAppComponentForControl(o);if(!U.isApplication(d.getManifestObject())){return Promise.resolve([]);}var f=U.getComponentClassName(d);var e=U.getAppVersionFromManifest(d.getManifest());var g=a.getChangePersistenceForComponent(f,e);return g.getChangesForComponent().then(function(h){var E=h.filter(function(j){return i(j)&&b(c,j);}).map(function(j){return j.getModuleName();});return P.getExtensionModules(E);});}L.warning("Synchronous extensions are not supported by sap.ui.fl.PreprocessorImpl");return[];};
P.getExtensionModules=function(c){if(c.length===0){return Promise.resolve([]);}return new Promise(function(r){sap.ui.require(c,function(){var m=Array.prototype.slice.call(arguments);r(m);},function(e){L.error("Code Extension not found",e.message);r([]);});});};
return P;},true);
sap.ui.predefine('sap/ui/fl/RegistrationDelegator',["sap/ui/fl/FlexControllerFactory","sap/ui/core/Component","sap/ui/fl/registry/ChangeHandlerRegistration","sap/ui/fl/ChangePersistenceFactory","sap/ui/core/mvc/Controller","sap/ui/core/mvc/XMLView","sap/ui/fl/EventHistory"],function(F,C,a,b,M,X,E){"use strict";var R={};
R.registerChangesInComponent=function(){C._fnOnInstanceCreated=F.getChangesAndPropagate;};
R.registerChangeHandlers=function(){return a.getChangeHandlersOfLoadedLibsAndRegisterOnNewLoadedLibs();};
R.registerLoadComponentEventHandler=function(){C._fnLoadComponentCallback=b._onLoadComponent.bind(b);};
R.registerExtensionProvider=function(){M.registerExtensionProvider("sap.ui.fl.PreprocessorImpl");};
R.registerXMLPreprocessor=function(){if(X.registerPreprocessor){X.registerPreprocessor("viewxml","sap.ui.fl.XmlPreprocessorImpl",true);}};
R.registerEventListener=function(){E.start();};
R.registerAll=function(){R.registerEventListener();R.registerChangeHandlers();R.registerLoadComponentEventHandler();R.registerExtensionProvider();R.registerChangesInComponent();R.registerXMLPreprocessor();};
return R;},true);
sap.ui.predefine('sap/ui/fl/StandardVariant',["sap/ui/fl/Change"],function(C){"use strict";var S=function(){};
S.prototype.getExecuteOnSelect=function(c){var a=this.getNewestStandardVariantChangeDeleteTheRest(c);if(a){return a.getContent().executeOnSelect;}return null;};
S.prototype.getNewestStandardVariantChangeDeleteTheRest=function(c){var d=this.getStandardVariantChanges(c).sort(function(a,b){var D=new Date(a.getCreation());var e=new Date(b.getCreation());if(isNaN(D.getDate())){return-1;}if(isNaN(e.getDate())){return 1;}return e-D;});var n=d.shift();d.forEach(function(o){o.markForDeletion();});return n;};
S.prototype.getStandardVariantChanges=function(c){if(!c||typeof c!=='object'){return[];}return Object.keys(c).map(a).filter(b);function a(s){return c[s];}function b(o){return o.getChangeType()==='standardVariant';}};
S.prototype.updateExecuteOnSelect=function(c,n){var N=this.getNewestStandardVariantChangeDeleteTheRest(c);if(N){var o=N.getContent();o.executeOnSelect=n;N.setContent(o);}return N;};
S.prototype._createChangeFile=function(p){var f;p.namespace=p.component+'/changes/standard';p.componentName=p.component;p.changeType='standardVariant';f=C.createInitialFileContent(p);f.content.executeOnSelect=p.executeOnSelect;f.layer='USER';return f;};
S.prototype.createChangeObject=function(p){var f;var c;f=this._createChangeFile(p);c=new C(f);return c;};
return new S();},true);
sap.ui.predefine('sap/ui/fl/Utils',["sap/ui/thirdparty/jquery","sap/ui/core/Component","sap/ui/core/util/reflection/BaseTreeModifier","sap/ui/thirdparty/hasher","sap/base/Log","sap/base/util/UriParameters","sap/base/util/uid","sap/base/strings/formatMessage","sap/ui/base/ManagedObject","sap/ui/core/mvc/View"],function(q,C,B,h,L,U,u,f,M,V){"use strict";var a={DEFAULT_APP_VERSION:"DEFAULT_APP_VERSION",APP_ID_AT_DESIGN_TIME:"${pro"+"ject.art"+"ifactId}",VARIANT_MODEL_NAME:"$FlexVariants",formatAndLogMessage:function(l,m,v,c){var s=m.join(' ');s=f(s,v);L[l](s,c||"");},getXSRFTokenFromControl:function(c){var m;if(!c){return"";}if(c&&typeof c.getModel==="function"){m=c.getModel();return a._getXSRFTokenFromModel(m);}return"";},_getXSRFTokenFromModel:function(m){var H;if(!m){return"";}if(typeof m.getHeaders==="function"){H=m.getHeaders();if(H){return H["x-csrf-token"];}}return"";},getComponentClassName:function(c){var A;if(c){A=this.getAppComponentForControl(c);if(A){var v=this._getComponentStartUpParameter(A,"sap-app-id");if(v){return v;}if(A.getManifestEntry("sap.ui5")&&A.getManifestEntry("sap.ui5").appVariantId){return A.getManifestEntry("sap.ui5").appVariantId;}}}return a.getComponentName(A);},isVariantByStartupParameter:function(c){if(c){var A=this.getAppComponentForControl(c);if(A){return!!this._getComponentStartUpParameter(A,"sap-app-id");}}return false;},isTrialSystem:function(){var o=a.getUshellContainer();if(o){return o.getLogonSystem().isTrial();}return false;},getAppComponentClassNameForComponent:function(c){return a.getComponentClassName(c);},getAppDescriptor:function(c){var m=null;var o=null;var b=null;if(c){o=this.getAppComponentForControl(c);if(o&&o.getMetadata){b=o.getMetadata();if(b&&b.getManifest){m=b.getManifest();}}}return m;},getSiteId:function(c){var s=null;var A=null;if(c){A=this.getAppComponentForControl(c);if(A){s=this._getComponentStartUpParameter(A,"hcpApplicationId");}}return s;},getSiteIdByComponentData:function(c){var s=null;s=this._getStartUpParameter(c,"hcpApplicationId");return s;},isBinding:function(p){var i=false;if(p&&typeof p==="string"&&p.substring(0,1)==="{"&&p.slice(-1)==="}"){i=true;}return i;},isApplicationVariant:function(c){var F=a.getComponentClassName(c);var A=a.getAppComponentForControl(c);var s=a.getComponentName(A);return F!==s;},isChangeRelatedToVariants:function(c){return c.getFileType()==="ctrl_variant_change"||c.getFileType()==="ctrl_variant_management_change"||c.getFileType()==="ctrl_variant"||c.getVariantReference();},_getComponentStartUpParameter:function(c,p){var s=null;if(p){if(c&&c.getComponentData){s=this._getStartUpParameter(c.getComponentData(),p);}}return s;},_getStartUpParameter:function(c,p){if(c&&c.startupParameters&&p){if(Array.isArray(c.startupParameters[p])){return c.startupParameters[p][0];}}},getComponentName:function(c){var s="";if(c){s=c.getMetadata().getName();}if(s.length>0&&s.indexOf(".Component")<0){s+=".Component";}return s;},_getComponent:function(c){var o;if(c){o=C.get(c);}return o;},_getComponentIdForControl:function(c){var s=a._getOwnerIdForControl(c);if(!s){if(c&&typeof c.getParent==="function"){var p=c.getParent();if(p){return a._getComponentIdForControl(p);}}}return s||"";},getComponentForControl:function(c){return a._getComponentForControl(c);},getAppComponentForControl:function(c){var o=c instanceof C?c:this._getComponentForControl(c);return this._getAppComponentForComponent(o);},getAppDescriptorComponentObjectForControl:function(c){var A=this.getAppComponentForControl(c);var m=A.getManifest();return{name:this.getAppIdFromManifest(m),version:this.getAppVersionFromManifest(m)};},_getComponentForControl:function(c){var o=null;var s=null;if(c){s=a._getComponentIdForControl(c);if(s){o=a._getComponent(s);}}return o;},_getAppComponentForComponent:function(c){var s=null;if(c&&c.getAppComponent){return c.getAppComponent();}if(c&&c.oComponentData&&c.oComponentData.appComponent){return c.oComponentData.appComponent;}if(c&&c.getManifestEntry){s=c.getManifestEntry("sap.app");}else{return c;}if(s&&s.type&&s.type!=="application"){if(c instanceof C){c=this._getComponentForControl(c);}return this.getAppComponentForControl(c);}return c;},getViewForControl:function(c){return a.getFirstAncestorOfControlWithControlType(c,sap.ui.core.mvc.View);},getFirstAncestorOfControlWithControlType:function(c,b){if(c instanceof b){return c;}if(c&&typeof c.getParent==="function"){c=c.getParent();return a.getFirstAncestorOfControlWithControlType(c,b);}},hasControlAncestorWithId:function(c,A){var o;if(c===A){return true;}o=sap.ui.getCore().byId(c);while(o){if(o.getId()===A){return true;}if(typeof o.getParent==="function"){o=o.getParent();}else{return false;}}return false;},_isView:function(c){return c instanceof V;},_getOwnerIdForControl:function(c){return C.getOwnerIdFor(c);},getClient:function(){var o;var c;o=this._getUriParameters();c=o.get("sap-client");return c||undefined;},_getUriParameters:function(){return U.fromQuery(window.location.search);},isHotfixMode:function(){var o;var i;o=this._getUriParameters();i=o.get("hotfix");return(i==="true");},convertBrowserLanguageToISO639_1:function(b){if(!b||typeof b!=="string"){return"";}var n=b.indexOf("-");if((n<0)&&(b.length<=2)){return b.toUpperCase();}if(n>0&&n<=2){return b.substring(0,n).toUpperCase();}return"";},getLrepUrl:function(){var F=sap.ui.getCore().getConfiguration().getFlexibilityServices();var l=F.find(function(s){return s.connector==="LrepConnector";});return l?l.url:"";},areNewConnectorsNecessary:function(){var F=sap.ui.getCore().getConfiguration().getFlexibilityServices();var o=F.every(function(s){return s.connector==="LrepConnector";});return!o;},getCurrentLanguage:function(){var l=sap.ui.getCore().getConfiguration().getLanguage();return a.convertBrowserLanguageToISO639_1(l);},getControlType:function(c){var m;if(c&&typeof c.getMetadata==="function"){m=c.getMetadata();if(m&&typeof m.getElementName==="function"){return m.getElementName();}}},asciiToString:function(b){var c=b.split(",");var p="";q.each(c,function(i,d){p+=String.fromCharCode(d);});return p;},stringToAscii:function(s){var b="";for(var i=0;i<s.length;i++){b+=s.charCodeAt(i)+",";}b=b.substring(0,b.length-1);return b;},checkControlId:function(c,A){if(!A){c=c instanceof M?c:sap.ui.getCore().byId(c);A=a.getAppComponentForControl(c);}return B.checkControlId(c,A);},hasLocalIdSuffix:B.hasLocalIdSuffix,_getAllUrlParameters:function(){return window.location.search.substring(1);},getTechnicalParametersForComponent:function(c){return c&&c.getComponentData&&c.getComponentData()&&c.getComponentData().technicalParameters;},getParsedURLHash:function(){var o=a.getUshellContainer();if(o){var b=o.getService("URLParsing");var p=b.parseShellHash(h.getHash());return p||{};}return{};},isDebugEnabled:function(){var o=this._getUriParameters();var d=o.get("sap-ui-debug")||"";if(sap.ui.getCore().getConfiguration().getDebug()||d==="true"){return true;}var D=d.split(",");return D.indexOf("sap/ui/fl")!==-1||D.indexOf("sap/ui/fl/")!==-1;},getUrlParameter:function(p){return U.fromQuery(window.location.search).get(p);},getUshellContainer:function(){return sap.ushell&&sap.ushell.Container;},createDefaultFileName:function(n){var F=u().replace(/-/g,"_");if(n){F+='_'+n;}return F;},createNamespace:function(p,s){var r=p.reference.replace('.Component','');var n='apps/'+r+"/"+s+"/";return n;},buildLrepRootNamespace:function(b,s,p){var r="apps/";var e=new Error("Error in sap.ui.fl.Utils#buildLrepRootNamespace: ");if(!b){e.message+="for every scenario you need a base ID";throw e;}switch(s){case sap.ui.fl.Scenario.VersionedAppVariant:if(!p){e.message+="in a versioned app variant scenario you additionally need a project ID";throw e;}r+=b+"/appVariants/"+p+"/";break;case sap.ui.fl.Scenario.AppVariant:if(!p){e.message+="in an app variant scenario you additionally need a project ID";throw e;}r+=b+"/appVariants/"+p+"/";break;case sap.ui.fl.Scenario.AdaptationProject:if(!p){e.message+="in a adaptation project scenario you additionally need a project ID";throw e;}r+=b+"/adapt/"+p+"/";break;case sap.ui.fl.Scenario.FioriElementsFromScratch:case sap.ui.fl.Scenario.UiAdaptation:default:r+=b+"/";}return r;},getValidAppVersions:function(p){var A=p.appVersion;var d=p.developerMode;var s=p.scenario;var v={creation:A,from:A};if(this._isValidAppVersionToRequired(A,d,s)){v.to=A;}return v;},_isValidAppVersionToRequired:function(A,d,s){return!!A&&!!d&&s!==sap.ui.fl.Scenario.AdaptationProject&&s!==sap.ui.fl.Scenario.AppVariant;},_getComponentTypeFromManifest:function(m){return m&&m.getEntry&&m.getEntry("sap.app")&&m.getEntry("sap.app").type;},isApplication:function(m){return a._getComponentTypeFromManifest(m)==="application";},isApplicationComponent:function(c){return c instanceof C&&a.isApplication(c.getManifestObject());},isEmbeddedComponent:function(c){return c instanceof C&&a._getComponentTypeFromManifest(c.getManifestObject())==="component";},getFlexReference:function(m){if(m){if(m.getEntry("sap.ui5")){if(m.getEntry("sap.ui5").appVariantId){return m.getEntry("sap.ui5").appVariantId;}if(m.getEntry("sap.ui5").componentName){var c=m.getEntry("sap.ui5").componentName;if(c.length>0&&c.indexOf(".Component")<0){c+=".Component";}return c;}}if(m.getEntry("sap.app")&&m.getEntry("sap.app").id){var A=m.getEntry("sap.app").id;if(A===a.APP_ID_AT_DESIGN_TIME&&m.getComponentName){A=m.getComponentName();}if(A.length>0&&A.indexOf(".Component")<0){A+=".Component";}return A;}}L.warning("No Manifest received.");return"";},getAppIdFromManifest:function(m){if(m){var s=(m.getEntry)?m.getEntry("sap.app"):m["sap.app"];return s&&s.id;}throw new Error("No Manifest received, descriptor changes are not possible");},getAppVersionFromManifest:function(m){var v="";if(m){var s=(m.getEntry)?m.getEntry("sap.app"):m["sap.app"];if(s&&s.applicationVersion&&s.applicationVersion.version){v=s.applicationVersion.version;}}else{L.warning("No Manifest received.");}return v;},getODataServiceUriFromManifest:function(m){var s="";if(m){var S=(m.getEntry)?m.getEntry("sap.app"):m["sap.app"];if(S&&S.dataSources&&S.dataSources.mainService&&S.dataSources.mainService.uri){s=S.dataSources.mainService.uri;}}else{L.warning("No Manifest received.");}return s;},isCorrectAppVersionFormat:function(v){v=v.replace(/\s/g,"");var r=/\b\d{1,5}(.\d{1,5}){0,2}/g;var R=/\b\d{1,5}(\.\d{1,5}){0,2}/g;var n=v.match(r)?v.match(r)[0].length:0;var b=v.match(R)?v.match(R)[0].length:0;if(b<1||b!==n){return false;}if(b&&v!==v.substr(0,b)){var c=v.substr(b,1);var o=/^[0-9.]$/;if(o.test(c)){return false;}}var d=v.substr(0,b).split(".");if(d.length>3){return false;}if(!d.every(function(p){return p.length<=5;})){return false;}return true;},indexOfObject:function(A,o){var O=-1;A.some(function(b,i){var k;var K;if(!b){k=[];}else{k=Object.keys(b);}if(!o){K=[];}else{K=Object.keys(o);}var s=k.length===K.length;var c=s&&!k.some(function(d){return b[d]!==o[d];});if(c){O=i;}return c;});return O;},execPromiseQueueSequentially:function(p,t,A){if(p.length===0){if(A){return Promise.resolve();}return new a.FakePromise();}var P=p.shift();if(typeof P==="function"){try{var r=P();}catch(e){r=Promise.reject(e);}return r.then(function(){if(!A&&r instanceof Promise){A=true;}}).catch(function(e){var E="Error during execPromiseQueueSequentially processing occured";E+=e?": "+e.message:"";L.error(E);if(t){throw new Error(E);}}).then(function(){return this.execPromiseQueueSequentially(p,t,A);}.bind(this));}L.error("Changes could not be applied, promise not wrapped inside function.");return this.execPromiseQueueSequentially(p,t,A);},FakePromise:function(i,e,I){a.FakePromise.fakePromiseIdentifier="sap.ui.fl.Utils.FakePromise";this.vValue=i;this.vError=e;this.bContinueWithFakePromise=arguments.length<3||(I===a.FakePromise.fakePromiseIdentifier);var r=function(p,b){try{var R=b(p,a.FakePromise.fakePromiseIdentifier);if(R instanceof Promise||R instanceof a.FakePromise){return R;}return new a.FakePromise(R);}catch(E){var v=E;return new a.FakePromise(undefined,v);}};a.FakePromise.prototype.then=function(b){if(!this.bContinueWithFakePromise){return Promise.resolve(b(this.vValue));}if(!this.vError){return r(this.vValue,b);}return this;};a.FakePromise.prototype.catch=function(b){if(!this.bContinueWithFakePromise){return Promise.reject(b(this.vError));}if(this.vError){return r(this.vError,b);}return this;};if(this.vValue instanceof Promise||this.vValue instanceof a.FakePromise){return this.vValue;}},getChangeFromChangesMap:function(c,s){var r;Object.keys(c).forEach(function(b){c[b].some(function(o){if(o.getId()===s){r=o;return true;}});});return r;},requireAsync:function(m){return new Promise(function(r,R){sap.ui.require([m],function(o){r(o);},function(e){R(e);});});}};return a;},true);
sap.ui.predefine('sap/ui/fl/Variant',["sap/ui/thirdparty/jquery","sap/ui/base/ManagedObject","sap/ui/fl/Utils","sap/ui/fl/LayerUtils","sap/ui/fl/registry/Settings","sap/base/util/merge","sap/base/Log"],function(q,M,U,L,S,m,a){"use strict";
var V=M.extend("sap.ui.fl.Variant",{
constructor:function(f){M.apply(this);if(!q.isPlainObject(f)){a.error("Constructor : sap.ui.fl.Variant : oFile is not defined");}this._oDefinition=f;this._oOriginDefinition=m({},f);this._sRequest='';this._bUserDependent=(f.content.layer==="USER");this._vRevertData=null;this.setState(V.states.NEW);},
metadata:{properties:{state:{type:"string"}}}
});
V.states={NEW:"NEW",PERSISTED:"NONE",DELETED:"DELETE",DIRTY:"UPDATE"};V.events={markForDeletion:"markForDeletion"};
V.prototype.setState=function(s){if(this._isValidState(s)){this.setProperty("state",s);}return this;};
V.prototype._isValidState=function(s){var b=false;Object.keys(V.states).some(function(k){if(V.states[k]===s){b=true;}return b;});if(!b){return false;}if((this.getState()===V.states.NEW)&&(s===V.states.DIRTY)){return false;}return true;};
V.prototype.isValid=function(){var i=true;if(typeof(this._oDefinition)!=="object"){i=false;}if(!this._oDefinition.content.fileType||this._oDefinition.content.fileType!=="ctrl_variant"){i=false;}if(!this._oDefinition.content.fileName){i=false;}if(!this._oDefinition.content.content.title){i=false;}if(!this._oDefinition.content.variantManagementReference){i=false;}if(!this._oDefinition.content.layer){i=false;}if(!this._oDefinition.content.originalLanguage){i=false;}return i;};
V.prototype.isVariant=function(){return true;};
V.prototype.getDefinitionWithChanges=function(){return this._oDefinition;};
V.prototype.getTitle=function(){if(this._oDefinition){return this._oDefinition.content.content.title;}};
V.prototype.getFileType=function(){if(this._oDefinition){return this._oDefinition.content.fileType;}};
V.prototype.getControlChanges=function(){return this._oDefinition.controlChanges;};
V.prototype.getOriginalLanguage=function(){if(this._oDefinition&&this._oDefinition.content.originalLanguage){return this._oDefinition.content.originalLanguage;}return"";};
V.prototype.getPackage=function(){return this._oDefinition.content.packageName;};
V.prototype.getNamespace=function(){return this._oDefinition.content.namespace;};
V.prototype.setNamespace=function(n){this._oDefinition.content.namespace=n;};
V.prototype.getId=function(){return this._oDefinition.content.fileName;};
V.prototype.getContent=function(){return this._oDefinition.content.content;};
V.prototype.setContent=function(c){this._oDefinition.content.content=c;this.setState(V.states.DIRTY);};
V.prototype.getVariantManagementReference=function(){return this._oDefinition.content.variantManagementReference;};
V.prototype.getVariantReference=function(){return this._oDefinition.content.variantReference;};
V.prototype.getOwnerId=function(){return this._oDefinition.content.support?this._oDefinition.content.support.user:"";};
V.prototype.getText=function(t){if(typeof(t)!=="string"){a.error("sap.ui.fl.Variant.getTexts : sTextId is not defined");}if(this._oDefinition.content.texts){if(this._oDefinition.content.texts[t]){return this._oDefinition.content.texts[t].value;}}return"";};
V.prototype.setText=function(t,n){if(typeof(t)!=="string"){a.error("sap.ui.fl.Variant.setTexts : sTextId is not defined");return;}if(this._oDefinition.content.texts){if(this._oDefinition.content.texts[t]){this._oDefinition.content.texts[t].value=n;this.setState(V.states.DIRTY);}}};
V.prototype.isReadOnly=function(){return this._isReadOnlyDueToLayer()||this._isReadOnlyWhenNotKeyUser();};
V.prototype._isReadOnlyWhenNotKeyUser=function(){if(this.isUserDependent()){return false;}var r=this.getDefinition().reference;if(!r){return true;}var s=S.getInstanceOrUndef();if(!s){return true;}return!s.isKeyUser();};
V.prototype._isReadOnlyDueToLayer=function(){var c;c=L.getCurrentLayer(this._bUserDependent);return(this._oDefinition.content.layer!==c);};
V.prototype._isReadOnlyDueToOriginalLanguage=function(){var c;var o;o=this.getOriginalLanguage();if(!o){return false;}c=U.getCurrentLanguage();return(c!==o);};
V.prototype.markForDeletion=function(){this.setState(V.states.DELETED);};
V.prototype.setRequest=function(r){if(typeof(r)!=="string"){a.error("sap.ui.fl.Variant.setRequest : sRequest is not defined");}this._sRequest=r;};
V.prototype.getRequest=function(){return this._sRequest;};
V.prototype.getLayer=function(){return this._oDefinition.content.layer;};
V.prototype.getComponent=function(){return this._oDefinition.content.reference;};
V.prototype.setComponent=function(c){this._oDefinition.content.reference=c;};
V.prototype.getCreation=function(){return this._oDefinition.content.creation;};
V.prototype.isUserDependent=function(){return(this._bUserDependent);};
V.prototype.getPendingAction=function(){return this.getState();};
V.prototype.getDefinition=function(){return this._oDefinition.content;};
V.prototype.setResponse=function(r){var R=JSON.stringify(r);if(R){this._oDefinition=JSON.parse(R);this._oOriginDefinition=JSON.parse(R);this.setState(V.states.PERSISTED);}};
V.prototype.getFullFileIdentifier=function(){var l=this.getLayer();var n=this.getNamespace();var f=this.getDefinition().content.fileName;var F=this.getDefinition().content.fileType;return l+"/"+n+"/"+f+"."+F;};
V.prototype.getRevertData=function(){return this._vRevertData;};
V.prototype.setRevertData=function(d){this._vRevertData=d;};
V.prototype.resetRevertData=function(){this.setRevertData(null);};
V.createInitialFileContent=function(p){if(!p){p={};}var f=p.content.fileName||U.createDefaultFileName();var n=p.content.namespace||U.createNamespace(p.content,"variants");var N={content:{fileName:f,fileType:"ctrl_variant",variantManagementReference:p.content.variantManagementReference,variantReference:p.content.variantReference||"",reference:p.content.reference||"",packageName:p.content.packageName||"",content:{title:p.content.content.title||""},self:n+f+"."+"ctrl_variant",layer:p.content.layer||L.getCurrentLayer(p.isUserDependent),texts:p.content.texts||{},namespace:n,creation:"",originalLanguage:U.getCurrentLanguage(),conditions:{},support:{generator:p.generator||"Change.createInitialFileContent",service:p.service||"",user:"",sapui5Version:sap.ui.version},validAppVersions:p.content.validAppVersions||{}},controlChanges:p.controlChanges||[],variantChanges:{}};return N;};
return V;},true);
sap.ui.predefine('sap/ui/fl/XmlPreprocessorImpl',["sap/ui/core/Component","sap/ui/fl/FlexControllerFactory","sap/ui/fl/Utils","sap/ui/fl/ChangePersistenceFactory","sap/base/Log"],function(C,F,U,a,L){"use strict";var X=function(){};
X.process=function(v,p){try{if(!p||p.sync){L.warning("Flexibility feature for applying changes on an XML view is only available for "+"asynchronous views; merge is be done later on the JS controls.");return(v);}p.viewId=p.id;var c=C.get(p.componentId);if(!c){L.warning("View is generated without a component. Flexibility features are not possible.");return Promise.resolve(v);}var A=U.getAppComponentForControl(c);if(!U.isApplication(A.getManifestObject())){return Promise.resolve(v);}var f=U.getComponentClassName(A);var s=U.getAppVersionFromManifest(A.getManifest());var o=F.create(f,s);return o.processXmlView(v,p).then(function(){L.debug("flex processing view "+p.id+" finished");return v;}).catch(function(){L.warning("Error happens when getting flex cache key! flexibility XML view preprocessing is skipped. "+"The processing will be done later on the JS controls.");return Promise.resolve(v);});}catch(e){var E="view "+p.id+": "+e;L.info(E);return Promise.resolve(v);}};
X.getCacheKey=function(p){var c=C.get(p.componentId);var A=U.getAppComponentForControl(c);if(U.isVariantByStartupParameter(A)){return Promise.resolve();}var f=U.getComponentClassName(A);var s=U.getAppVersionFromManifest(A.getManifest());var o=a.getChangePersistenceForComponent(f,s);return o.getCacheKey(A);};
return X;},true);
sap.ui.predefine('sap/ui/fl/changeHandler/AddXML',["sap/ui/fl/Utils","sap/ui/fl/changeHandler/Base","sap/base/util/LoaderExtensions"],function(U,B,L){"use strict";var A={};var d=function(c){c.forEach(function(C){if(C.destroy){C.destroy();}});};
A.applyChange=function(c,C,p){var m=p.modifier;var o=c.getDefinition();var a=o.content.targetAggregation;var n=B.instantiateFragment(c,p);var i=o.content.index;var v=p.view;var b=m.findAggregation(C,a);if(!b){d(n);throw new Error("The given Aggregation is not available in the given control: "+m.getId(C));}var M=c.getModuleName();var f=L.loadResource(M,{dataType:"text"});n.forEach(function(N,I){if(!m.validateType(N,b,C,f,I)){d(n);throw new Error("The content of the xml fragment does not match the type of the targetAggregation: "+b.type);}});n.forEach(function(N,I){m.insertAggregation(C,a,N,i+I,v);});c.setRevertData(n.map(function(e){return m.getId(e);}));return true;};
A.revertChange=function(c,C,p){var m=p.modifier;var o=c.getDefinition();var a=o.content.targetAggregation;var v=p.view||U.getViewForControl(C);var b=p.appComponent;var r=c.getRevertData()||[];var e=r.map(function(i){return m.bySelector(i,b,v)||v&&v.createId&&m.bySelector(v.createId(i));});e.forEach(function(f){m.removeAggregation(C,a,f);});d(e);c.resetRevertData();return true;};
A.completeChangeContent=function(c,s){var C=c.getDefinition();var _=function(a){throw new Error("Attribute missing from the change specific content'"+a+"'");};if(!C.content){C.content={};}if(s.fragmentPath){C.content.fragmentPath=s.fragmentPath;}else{_("fragmentPath");}if(s.targetAggregation){C.content.targetAggregation=s.targetAggregation;}else{_("targetAggregation");}if(s.index!==undefined){C.content.index=s.index;}else{_("index");}var g=function(C){var m=C.reference.replace(/\./g,"/");m+="/changes/";m+=C.content.fragmentPath.replace(/\.fragment\.xml/g,"");return m;};var m=g(C);c.setModuleName(m);};
return A;},true);
sap.ui.predefine('sap/ui/fl/changeHandler/Base',["sap/base/util/LoaderExtensions"],function(L){"use strict";var B={setTextInChange:function(c,k,t,T){if(!c.texts){c.texts={};}if(!c.texts[k]){c.texts[k]={};}c.texts[k].value=t;c.texts[k].type=T;},instantiateFragment:function(c,p){var m=c.getModuleName();if(!m){throw new Error("The module name of the fragment is not set. This should happen in the backend");}var M=p.modifier;var v=p.view;var f=L.loadResource(m,{dataType:"text"});var n=c.getProjectId();try{return M.instantiateFragment(f,n,v);}catch(e){throw new Error("The following XML Fragment could not be instantiated: "+f+" Reason: "+e.message);}},markAsNotApplicable:function(n,a){var r={message:n};if(!a){throw r;}return Promise.reject(r);}};return B;},true);
sap.ui.predefine('sap/ui/fl/changeHandler/BaseRename',["sap/ui/fl/changeHandler/Base","sap/base/Log"],function(B,L){"use strict";var a={createRenameChangeHandler:function(r){r.changePropertyName=r.changePropertyName||"newText";return{applyChange:function(c,C,p){var m=p.modifier;var P=r.propertyName;var o=c.getDefinition();var t=o.texts[r.changePropertyName];var v=t.value;if(o.texts&&t&&typeof(v)==="string"){c.setRevertData(m.getPropertyBindingOrProperty(C,P));m.setPropertyBindingOrProperty(C,P,v);return true;}L.error("Change does not contain sufficient information to be applied: ["+o.layer+"]"+o.namespace+"/"+o.fileName+"."+o.fileType);},revertChange:function(c,C,p){var m=p.modifier;var P=r.propertyName;var o=c.getRevertData();if(o||o===""){m.setPropertyBindingOrProperty(C,P,o);c.resetRevertData();return true;}L.error("Change doesn't contain sufficient information to be reverted. Most Likely the Change didn't go through applyChange.");},completeChangeContent:function(c,s,p){var C=c.getDefinition();var b=r.changePropertyName;var t=r.translationTextType;var o=p.modifier.bySelector(c.getSelector(),p.appComponent);C.content.originalControlType=p.modifier.getControlType(o);if(typeof(s.value)==="string"){B.setTextInChange(C,b,s.value,t);}else{throw new Error("oSpecificChangeInfo.value attribute required");}}};}};return a;},true);
sap.ui.predefine('sap/ui/fl/changeHandler/BaseTreeModifier',["sap/ui/core/util/reflection/BaseTreeModifier"],function(B){"use strict";return B;});
sap.ui.predefine('sap/ui/fl/changeHandler/ChangeHandlerMediator',["sap/base/Log","sap/base/strings/capitalize","sap/ui/fl/registry/ChangeHandlerRegistration"],function(L,c,C){"use strict";var a={};a._aChangeHandlerSettings=[];["addODataField","addODataFieldWithLabel"].forEach(function(s){["2.0","1.0"].forEach(function(v){a._aChangeHandlerSettings.push({key:{scenario:s,oDataServiceVersion:v},content:{requiredLibraries:{"sap.ui.comp":{minVersion:"1.48",lazy:false}}},scenarioInitialized:false});});});
a.addChangeHandlerSettings=function(k,s){var n;if(!(k&&s)){throw new Error('New entry in ChangeHandlerMediator requires a key and settings');}n={key:k,content:s,scenarioInitialized:false};return this.getChangeHandlerSettings(k,true).then(function(e){var i=this._aChangeHandlerSettings.indexOf(e);if(i>-1){Object.assign(this._aChangeHandlerSettings[i].content,n.content);this._aChangeHandlerSettings[i].scenarioInitialized=false;}else{this._aChangeHandlerSettings.push(n);return this._createChangeHandlerSettingsGetter(n);}}.bind(this));};
a.getChangeHandlerSettings=function(k,s){var K=Object.keys(k);var f;if(K.length>0){f=this._aChangeHandlerSettings.filter(function(e){var E=Object.keys(e.key);if(E.length===K.length){var m=K.filter(function(b){if(e.key[b]===k[b]){return true;}});if(m.length===K.length){return true;}}})[0];if(!s&&f&&!f.scenarioInitialized){return this._initializeScenario(f).then(function(){return f;}).catch(function(){return undefined;});}}return Promise.resolve(f);};
a._initializeScenario=function(f){var l=[];if(f.content.requiredLibraries){var b=Object.keys(f.content.requiredLibraries);b.forEach(function(s){var d=s;var o=sap.ui.getCore().loadLibrary(s,{async:true}).catch(function(){L.warning("Required library not available: "+d+" - "+f.key.scenario+" could not be initialized");return Promise.reject();}).then(function(){return C.waitForChangeHandlerRegistration(d);});l.push(o);});return Promise.all(l).then(function(){f.scenarioInitialized=true;});}return Promise.resolve();};
a._createChangeHandlerSettingsGetter=function(m){var g='get'+c(m.key.scenario)+'Settings';if(!a[g]){a[g]=function(o){var O;try{O=o.getModel().getMetaModel().getProperty("/dataServices/dataServiceVersion");}catch(e){L.warning("Data service version could not be retrieved");}return this.getChangeHandlerSettings({scenario:m.key.scenario,oDataServiceVersion:O}).then(function(f){if(f&&f.content&&f.content.createFunction){return f;}});};}};
a._aChangeHandlerSettings.forEach(function(m){a._createChangeHandlerSettingsGetter(m);});return a;},true);
sap.ui.predefine('sap/ui/fl/changeHandler/HideControl',["sap/base/Log"],function(L){"use strict";var H={};
H.applyChange=function(c,C,p){c.setRevertData({originalValue:p.modifier.getVisible(C)});p.modifier.setVisible(C,false);return true;};
H.revertChange=function(c,C,p){var r=c.getRevertData();if(r){p.modifier.setVisible(C,r.originalValue);c.resetRevertData();}else{L.error("Attempt to revert an unapplied change.");return false;}return true;};
H.completeChangeContent=function(){};
return H;},true);
sap.ui.predefine('sap/ui/fl/changeHandler/JsControlTreeModifier',["sap/ui/core/util/reflection/JsControlTreeModifier"],function(J){"use strict";return J;},true);
sap.ui.predefine('sap/ui/fl/changeHandler/MoveControls',["sap/base/Log"],function(L){"use strict";var M={};M.SOURCE_ALIAS="source";M.TARGET_ALIAS="target";M.MOVED_ELEMENTS_ALIAS="movedElements";
M._checkConditions=function(c,m,v,a){if(!c){throw new Error("No change instance");}var C=c.getContent();if(!C||!C.movedElements||C.movedElements.length===0){throw new Error("Change format invalid");}if(!C.source||!C.source.selector){throw new Error("No source supplied for move");}if(!C.target||!C.target.selector){throw new Error("No target supplied for move");}if(!m.bySelector(C.source.selector,a,v)){throw new Error("Move source parent not found");}if(!m.bySelector(C.target.selector,a,v)){throw new Error("Move target parent not found");}if(!C.source.selector.aggregation){throw new Error("No source aggregation supplied for move");}if(!C.target.selector.aggregation){throw new Error("No target aggregation supplied for move");}};
M._getElementControlOrThrowError=function(m,o,a,v){if(!m.selector&&!m.id){throw new Error("Change format invalid - moveElements element has no id attribute");}if(typeof m.targetIndex!=="number"){throw new Error("Missing targetIndex for element with id '"+m.selector.id+"' in movedElements supplied");}var c=o.bySelector(m.selector||m.id,a,v);if(!c){throw new Error("Control to move was not found. Id: '"+m.selector.id+"'");}return c;};
M._checkCompleteChangeContentConditions=function(s){if(!s.movedElements){throw new Error("mSpecificChangeInfo.movedElements attribute required");}if(s.movedElements.length===0){throw new Error("MovedElements array is empty");}s.movedElements.forEach(function(e){if(!e.id){throw new Error("MovedControls element has no id attribute");}if(typeof(e.sourceIndex)!=="number"){throw new Error("SourceIndex attribute at MovedElements element is no number");}if(typeof(e.targetIndex)!=="number"){throw new Error("TargetIndex attribute at MovedElements element is no number");}});};
M._getSpecificChangeInfo=function(m,s,a){delete s.source.publicAggregation;delete s.target.publicAggregation;var S=s.source.parent||m.bySelector(s.source.id,a);var t=s.target.parent||m.bySelector(s.target.id,a);var b=s.source.aggregation;var T=s.target.aggregation;var A={aggregation:s.source.aggregation,type:m.getControlType(S)};var c={aggregation:s.target.aggregation,type:m.getControlType(t)};var d={source:{id:S.getId(),aggregation:b,type:A.type,selector:m.getSelector(s.source.id,a,A)},target:{id:t.getId(),aggregation:T,type:c.type,selector:m.getSelector(s.target.id,a,c)},movedElements:s.movedElements};return d;};
M.applyChange=function(c,r,p){var m=p.modifier;var v=p.view;var a=p.appComponent;this._checkConditions(c,m,v,a);var C=c.getContent();var s=p.sourceAggregation||C.source.selector.aggregation;var t=p.targetAggregation||C.target.selector.aggregation;var S=m.bySelector(C.source.selector,a,v);var T=m.bySelector(C.target.selector,a,v);var R=[];C.movedElements.forEach(function(b){var o=this._getElementControlOrThrowError(b,m,a,v);var i=m.findIndexInParentAggregation(o);var I=b.targetIndex;if(i>-1){if(i===I){i=b.sourceIndex;}else{s=p.sourceAggregation||m.getParentAggregationName(o,S);S=m.getParent(o);}R.unshift({index:i,aggregation:s,sourceParent:m.getSelector(S,a)});}m.removeAggregation(S,s,o);m.insertAggregation(T,t,o,I,v);},this);c.setRevertData(R);return true;};
M.revertChange=function(c,r,p){var m=p.modifier;var v=p.view;var a=p.appComponent;this._checkConditions(c,m,v,a);var C=c.getContent();var s=m.bySelector(C.source.selector,a,v);var S=C.source.selector.aggregation;var t=m.bySelector(C.target.selector,a,v);var T=C.target.selector.aggregation;var R=c.getRevertData();c.getContent().movedElements.reverse();C.movedElements.forEach(function(b,e){var o=this._getElementControlOrThrowError(b,m,a,v);if(!o){L.warning("Element to move not found");return;}var i=b.sourceIndex;if(R){var d=R[e];S=d.aggregation;i=d.index;s=m.bySelector(d.sourceParent,a,v);}m.removeAggregation(t,T,o);m.insertAggregation(s,S,o,i,v);},this);c.resetRevertData();return true;};
M.completeChangeContent=function(c,s,p){this._checkCompleteChangeContentConditions(s);var m=p.modifier;var a=p.appComponent;var C=c.getDefinition();s=this._getSpecificChangeInfo(m,s,a);C.content={movedElements:[],source:{selector:s.source.selector},target:{selector:s.target.selector}};s.movedElements.forEach(function(e){var E=e.element||m.bySelector(e.id,a);C.content.movedElements.push({selector:m.getSelector(E,a),sourceIndex:e.sourceIndex,targetIndex:e.targetIndex});});c.addDependentControl(s.source.id,M.SOURCE_ALIAS,p);c.addDependentControl(s.target.id,M.TARGET_ALIAS,p);c.addDependentControl(s.movedElements.map(function(e){return e.id;}),M.MOVED_ELEMENTS_ALIAS,p);};
return M;},true);
sap.ui.predefine('sap/ui/fl/changeHandler/MoveElements',["sap/base/Log"],function(L){"use strict";var M={};M.CHANGE_TYPE="moveElements";
M.applyChange=function(c,s,p){function a(c,m,v,A){if(!c){throw new Error("No change instance");}var C=c.getContent();if(!C||!C.movedElements||C.movedElements.length===0){throw new Error("Change format invalid");}if(!c.getSelector().aggregation){throw new Error("No source aggregation supplied via selector for move");}if(!C.target||!C.target.selector){throw new Error("No target supplied for move");}if(!m.bySelector(C.target.selector,A,v)){throw new Error("Move target parent not found");}if(!C.target.selector.aggregation){throw new Error("No target aggregation supplied for move");}}function g(b,m,A,v){if(!b.selector&&!b.id){throw new Error("Change format invalid - moveElements element has no id attribute");}if(typeof b.targetIndex!=="number"){throw new Error("Missing targetIndex for element with id '"+b.selector.id+"' in movedElements supplied");}return m.bySelector(b.selector||b.id,A,v);}var m=p.modifier;var v=p.view;var A=p.appComponent;a(c,m,v,A);var C=c.getContent();var t=m.bySelector(C.target.selector,A,v);var S=c.getSelector().aggregation;var T=C.target.selector.aggregation;C.movedElements.forEach(function(b){var o=g(b,m,A,v);if(!o){L.warning("Element to move not found");return;}m.removeAggregation(s,S,o);m.insertAggregation(t,T,o,b.targetIndex,v);});return true;};
M.completeChangeContent=function(){throw new Error('Using deprecated change handler. Please consider of using \'MoveControls\' instead');};
M.getSpecificChangeInfo=function(m,s){var S=s.source.parent||m.bySelector(s.source.id);var t=s.target.parent||m.bySelector(s.target.id);var a=s.source.aggregation;var T=s.target.aggregation;var b={source:{id:S.getId(),aggregation:a,type:m.getControlType(S)},target:{id:t.getId(),aggregation:T,type:m.getControlType(t)},movedElements:s.movedElements};return b;};
return M;},true);
sap.ui.predefine('sap/ui/fl/changeHandler/PropertyBindingChange',["sap/base/Log"],function(L){"use strict";var P={};
P.applyChange=function(c,C,p){var d=c.getDefinition();var s=d.content.property;var v=d.content.newBinding;var m=p.modifier;var o=m.getPropertyBindingOrProperty(C,s);c.setRevertData({originalValue:o});m.setPropertyBinding(C,s,v);};
P.revertChange=function(c,C,p){var r=c.getRevertData();if(r){var d=c.getDefinition();var s=d.content.property;var v=r.originalValue;var m=p.modifier;m.setPropertyBindingOrProperty(C,s,v);c.resetRevertData();}else{L.error("Attempt to revert an unapplied change.");return false;}return true;};
P.completeChangeContent=function(c,s){var C=c.getDefinition();if(!s.content){throw new Error("oSpecificChangeInfo attribute required");}C.content=s.content;};
return P;},true);
sap.ui.predefine('sap/ui/fl/changeHandler/PropertyChange',["sap/ui/thirdparty/jquery","sap/ui/fl/Utils","sap/base/Log"],function(q,F,L){"use strict";var P={};
function i(p){return F.isBinding(p)||q.isPlainObject(p);}
function c(C,p,v,m){try{if(i(v)){m.setPropertyBinding(C,p,v);}else{m.setProperty(C,p,v);}}catch(e){throw new Error("Applying property changes failed: "+e);}}
P.applyChange=function(C,o,p){var d=C.getDefinition();var s=d.content.property;var v=d.content.newValue;var m=p.modifier;C.setRevertData({originalValue:m.getPropertyBindingOrProperty(o,s)});c(o,s,v,m);};
P.revertChange=function(C,o,p){var r=C.getRevertData();if(r){var d=C.getDefinition();var s=d.content.property;var v=r.originalValue;var m=p.modifier;c(o,s,v,m);C.resetRevertData();}else{L.error("Attempt to revert an unapplied change.");return false;}return true;};
P.completeChangeContent=function(C,s){var o=C.getDefinition();if(!s.content){throw new Error("oSpecificChangeInfo attribute required");}o.content=s.content;};
return P;},true);
sap.ui.predefine('sap/ui/fl/changeHandler/StashControl',["sap/base/Log"],function(L){"use strict";var S={};
S.applyChange=function(c,C,p){var s=p.modifier.getStashed(C);var o=p.modifier.findIndexInParentAggregation(C);this.setChangeRevertData(c,s,o);p.modifier.setStashed(C,true);return true;};
S.revertChange=function(c,C,p){var r=c.getRevertData();if(r){var u=p.modifier.setStashed(C,r.originalValue,p.appComponent);if(u){var U=p.modifier.findIndexInParentAggregation((u));if(U!==r.originalIndex){var P=p.modifier.getParent(u);var a=p.modifier.getParentAggregationName(u);p.modifier.removeAggregation(P,a,u);p.modifier.insertAggregation(P,a,u,r.originalIndex);}}c.resetRevertData();}else{L.error("Attempt to revert an unapplied change.");return false;}return true;};
S.completeChangeContent=function(){};
S.setChangeRevertData=function(c,v,o){c.setRevertData({originalValue:v,originalIndex:o});};
return S;},true);
sap.ui.predefine('sap/ui/fl/changeHandler/UnhideControl',["sap/base/Log"],function(L){"use strict";var U={};
U.applyChange=function(c,C,p){c.setRevertData({originalValue:p.modifier.getProperty(C,'visible')});p.modifier.setVisible(C,true);return true;};
U.revertChange=function(c,C,p){var r=c.getRevertData();if(r){p.modifier.setVisible(C,r.originalValue);c.resetRevertData();}else{L.error("Attempt to revert an unapplied change.");return false;}return true;};
U.completeChangeContent=function(){};
return U;},true);
sap.ui.predefine('sap/ui/fl/changeHandler/UnstashControl',["sap/base/Log"],function(L){"use strict";var U={};
U.applyChange=function(c,C,p){var m=c.getContent();var M=p.modifier;var s=false;c.setRevertData({originalValue:p.modifier.getStashed(C)});var u=M.setStashed(C,s,p.appComponent)||C;if(m.parentAggregationName){var t=m.parentAggregationName;var T=M.getParent(u);M.removeAggregation(T,t,u);M.insertAggregation(T,t,u,m.index,p.view);}return u;};
U.revertChange=function(c,C,p){var r=c.getRevertData();if(r){p.modifier.setStashed(C,r.originalValue);c.resetRevertData();}else{L.error("Attempt to revert an unapplied change.");return false;}return true;};
U.completeChangeContent=function(c,s){var C=c.getDefinition();if(s.content){C.content=s.content;}};
return U;},true);
sap.ui.predefine('sap/ui/fl/changeHandler/XmlTreeModifier',["sap/ui/core/util/reflection/XmlTreeModifier"],function(X){"use strict";return X;},true);
sap.ui.predefine('sap/ui/fl/codeExt/CodeExtManager',["sap/ui/fl/LrepConnector","sap/ui/fl/Change"],function(L,C){"use strict";var a;a={_oLrepConnector:L.createConnector(),createOrUpdateCodeExtChange:function(p,o){if(!p.content||!p.content.codeRef){throw new Error("no code reference passed for the code extension change");}if(!p.selector||!p.selector.id){throw new Error("no controller name passed for the code extension change");}if(!p.reference){throw new Error("no reference passed for the code extension change");}p.changeType=p.changeType||"codeExt";var c=C.createInitialFileContent(p);var u="/sap/bc/lrep/content/"+c.namespace+c.fileName+".change";u+="?layer="+c.layer;if(o){if(o.transportId){u+="&changelist="+o.transportId;}if(o.packageName){u+="&package="+o.packageName;}}var m="PUT";return this._oLrepConnector.send(u,m,c,{});},createCodeExtChanges:function(c,o){c=c||[];if(c.length===0){return Promise.resolve();}var p=[];c.forEach(function(b){b.changeType=b.changeType||"codeExt";b.packageName=o.packageName;b.content={codeRef:o.codeRef};p.push(C.createInitialFileContent(b));});return this._oLrepConnector.create(p,o.transportId);},deleteCodeExtChange:function(c,o){if(c.changeType!=="codeExt"||c.fileType!=="change"){throw new Error("the change is not of type 'code extension'");}if(!c.fileName){throw new Error("the extension does not contains a file name");}if(c.namespace===undefined){throw new Error("the extension does not contains a namespace");}var u="/sap/bc/lrep/content/"+c.namespace+c.fileName+".change";if(c.layer){u+="&layer="+c.layer;}if(o){if(o.transportId){u+="&changelist="+o.transportId;}if(o.packageName){u+="&package="+o.packageName;}}u=u.replace("&","?");var m="DELETE";return this._oLrepConnector.send(u,m,c,{});}};return a;},true);
sap.ui.predefine('sap/ui/fl/context/BaseContextProvider',["sap/ui/base/ManagedObject"],function(M){"use strict";
var B=M.extend("sap.ui.fl.context.BaseContextProvider",{metadata:{properties:{text:{type:"String"},description:{type:"String"}}}});
B.prototype.loadData=function(){return Promise.resolve({});};
B.prototype.getValue=function(r){return this.loadData().then(function(d){var R=r&&r.split(".")||[];var m=R.reduce(function(c,C){if(c&&c.hasOwnProperty(C)){return c[C];}return undefined;},d);return m;});};
B.prototype.getValueHelp=function(){return Promise.resolve({});};
B.prototype.validate=function(){return Promise.resolve(true);};
return B;},true);
sap.ui.predefine('sap/ui/fl/context/Context',['sap/ui/base/ManagedObject',"sap/base/Log"],function(M,L){"use strict";
var C=M.extend("sap.ui.fl.context.Context",{metadata:{library:"sap.ui.fl",properties:{configuration:{type:"object"},content:{type:"object"}},aggregations:{contextProviders:{type:"object",multiple:true}},events:{}}});
C.prototype.getValue=function(R){return this._getProviderContent(R,"getValue");};
C.prototype.getValueHelp=function(R){return this._getProviderContent(R,"getValueHelp");};
var r=function(d,R){if(d.indexOf(R)!==-1){return undefined;}if(R.indexOf(d+".")!==-1){return R.substring(d.length+1);}throw new Error("Invalid request for sap.ui.fl.context - domain:"+d+"request:"+R);};
C.prototype._getProviderContent=function(R,p){var t=this;var P=[];var a=[];var h=function(s){var A=t._assureDomain(s);if(A){var o=t._loadProvider(A);P.push(o);a.push({domain:A,request:r(A,s)});}else{a.push({domain:undefined,request:s});}};var m=function(D){var c=t.getConfiguration();var b=false;for(var i=0;i<D.length;i++){var o=D[i];if(o){c[o.domain]=o.provider;b=true;}}if(b){t.setConfiguration(c);}};if(R instanceof Array){R.forEach(function(s){h(s);});}else if(R===undefined){for(var d in this.getConfiguration()){P.push(this._loadProvider(d));}a=Object.keys(this.getConfiguration()).map(function(d){return{domain:d,request:undefined};});}return Promise.all(P).then(m).then(function(){return t._mergeProviderContent(a,p);});};
C.prototype._assureDomain=function(d){var c=this.getConfiguration();if(c.hasOwnProperty(d)){return d;}var k=Object.keys(c);for(var i=0;i<k.length;i++){var K=k[i];if(d.indexOf(K)===0||K.indexOf(d)===0){return K;}}return null;};
C.prototype._loadProvider=function(d){var a=this.getConfiguration()[d];if(typeof(a)==="string"){return new Promise(function(b){try{sap.ui.require([a],function(P){var p=new P();b({domain:d,provider:p});},function(e){L.error(e);b();return;});}catch(e){L.error(e);b();return;}});}return Promise.resolve();};
C.prototype._mergeProviderContent=function(R,p){var P=[];var c=this.getConfiguration();R.forEach(function(o){if(c.hasOwnProperty(o.domain)){var a=c[o.domain];if(a instanceof sap.ui.fl.context.BaseContextProvider){P.push(a[p](o.request).then(function(v){var s={};var b=o.domain;if(o.request){b=b+"."+o.request;}s[b]=v;return s;}));}}else{var s={};s[o.request]=undefined;P.push(Promise.resolve(s));}});return Promise.all(P).then(function(a){return a.reduce(function(m,b){var k=Object.keys(b)[0];m[k]=b[k];return m;},{});});};
return C;},true);
sap.ui.predefine('sap/ui/fl/context/ContextManager',["sap/ui/fl/LrepConnector","sap/ui/fl/Utils","sap/ui/fl/LayerUtils","sap/ui/fl/context/Context","sap/base/Log"],function(L,U,a,C,b){"use strict";var c;c={_oContext:new C({configuration:{device:"sap/ui/fl/context/DeviceContextProvider",switches:"sap/ui/fl/context/SwitchContextProvider"}}),_oLrepConnector:L.createConnector(),doesContextMatch:function(o,A){var s=o.context||"";if(!s){return true;}return A&&A.indexOf(s)!==-1;},getActiveContexts:function(d){var D=this._getContextIdsFromUrl();if(D.length===0){return this._getContextParametersFromAPI(d).then(this._getActiveContextsByAPIParameters.bind(this,d));}return Promise.resolve(this._getActiveContextsByUrlParameters(d,D));},_getContextParametersFromAPI:function(d){var r=[];d.forEach(function(o){o.parameters.forEach(function(e){var s=e.selector;if(r.indexOf(s)===-1){r.push(s);}});});return this._oContext.getValue(r);},_getActiveContextsByAPIParameters:function(d,r){var t=this;var A=[];d.forEach(function(o){if(t._isContextObjectActive(o,r)){A.push(o.id);}});return A;},_getActiveContextsByUrlParameters:function(d,D){var A=[];d.forEach(function(o){var e=((D?Array.prototype.indexOf.call(D,o.id):-1))!==-1;if(e){A.push(o.id);}});return A;},_isContextObjectActive:function(o,r){var t=this;var d=true;var p=o.parameters;p.every(function(P){d=d&&t._checkContextParameter(P,r);return d;});return d;},_getContextIdsFromUrl:function(){var s=U.getUrlParameter("sap-ui-flexDesignTimeContext");if(!s){return[];}return s.split(",");},_checkContextParameter:function(p,r){var s=p.selector;var o=p.operator;var v=p.value;switch(o){case"EQ":return this._checkEquals(s,v,r);case"NE":return!this._checkEquals(s,v,r);default:b.info("A context within a flexibility change with the operator '"+o+"' could not be verified");return false;}},_checkEquals:function(s,v,r){return r[s]===v;},createOrUpdateContextObject:function(p){if(!p.reference){throw new Error("no reference passed for the context object");}if(!p.namespace){throw new Error("no namespace passed for the context object");}var i=p.id||U.createDefaultFileName();p={id:i,fileName:i,title:p.title||"",description:p.description||"",parameters:p.parameters||[],fileType:"context",reference:p.reference||"",packageName:p.packageName||"",layer:p.layer||a.getCurrentLayer(false),namespace:p.namespace,creation:p.creation||"",originalLanguage:p.originalLanguage||U.getCurrentLanguage(),support:p.support||{generator:p.generator||"",service:"",user:""},validAppVersions:p.validAppVersions||{}};var u="/sap/bc/lrep/content/"+p.namespace+p.fileName+".context";u+="?layer="+p.layer;var m="PUT";return this._oLrepConnector.send(u,m,p,{});}};return c;},true);
sap.ui.predefine('sap/ui/fl/context/DeviceContextProvider',["sap/ui/fl/context/BaseContextProvider","sap/ui/Device"],function(B,D){"use strict";
var a=B.extend("sap.ui.fl.context.DeviceContextProvider",{metadata:{properties:{text:{type:"String",defaultValue:"Device"},description:{type:"String",defaultValue:"Returns the values of sap.ui.Device"}}}});
a.prototype.loadData=function(){return Promise.resolve(D);};
a.prototype.getValueHelp=function(){return Promise.resolve({});};
a.prototype.validate=function(){return Promise.resolve(true);};
return a;},true);
sap.ui.predefine('sap/ui/fl/context/SwitchContextProvider',["sap/ui/fl/context/BaseContextProvider","sap/ui/fl/Cache"],function(B,C){"use strict";
var S=B.extend("sap.ui.fl.context.SwitchContextProvider",{metadata:{properties:{text:{type:"String",defaultValue:"Switch"},description:{type:"String",defaultValue:"Returns the values of switches received in the flexibility response from the back end"}}}});
S.prototype.loadData=function(){return Promise.resolve(C.getSwitches());};
S.prototype.getValueHelp=function(){return Promise.resolve({});};
S.prototype.validate=function(){return Promise.resolve(true);};
return S;},true);
sap.ui.predefine('sap/ui/fl/descriptorRelated/api/DescriptorChangeFactory',["sap/ui/fl/ChangePersistenceFactory","sap/ui/fl/Change","sap/ui/fl/descriptorRelated/internal/Utils","sap/ui/fl/registry/Settings","sap/ui/fl/Utils","sap/ui/fl/LayerUtils","sap/base/util/merge"],function(C,a,U,S,F,L,b){"use strict";var D=function(m,i,s){this._mChangeFile=m;this._mChangeFile.packageName='$TMP';this._oInlineChange=i;this._sTransportRequest=null;this._oSettings=s;};
D.prototype.setTransportRequest=function(t){try{U.checkTransportRequest(t);}catch(e){return Promise.reject(e);}this._sTransportRequest=t;return Promise.resolve();};
D.prototype.setPackage=function(p){try{U.checkPackage(p);}catch(e){return Promise.reject(e);}this._mChangeFile.packageName=p;return Promise.resolve();};
D.prototype.submit=function(){this.store();var o=this._getChangePersistence(this._mChangeFile.reference);return o.saveDirtyChanges();};
D.prototype.store=function(){var s=this._mChangeFile.reference;var A=this._mChangeFile.validAppVersions.creation;var o=this._getChangePersistence(s,A);var d=this._getChangeToSubmit();o.addChange(d);return d;};
D.prototype._getChangePersistence=function(s,A){return C.getChangePersistenceForComponent(s,A);};
D.prototype._getChangeToSubmit=function(){var o=new a(this._getMap());if(this._sTransportRequest){o.setRequest(this._sTransportRequest);}else if(this._oSettings.isAtoEnabled()&&L.isCustomerDependentLayer(this._mChangeFile.layer)){o.setRequest('ATO_NOTIFICATION');}return o;};
D.prototype._getMap=function(){var i=this._oInlineChange.getMap();this._mChangeFile.content=i.content;this._mChangeFile.texts=i.texts;return this._mChangeFile;};
D.prototype.getJson=function(){return b({},this._getMap());};
var c=function(){};
c.prototype.createNew=function(r,i,l,A,t){var s=function(_,I){if(_["setHostingIdForTextKey"]){_.setHostingIdForTextKey(I);}};s(i,r);var d;if(A){d=A.appVersion;if(!A.appId&&!d){var m=A.getManifest();d=F.getAppVersionFromManifest(m);}}var p={};p.changeType=i._getChangeType();p.componentName=r;p.reference=r;p.validAppVersions=d?{creation:d,from:d}:{};p.generator=t;p.layer=l||'CUSTOMER';var e=a.createInitialFileContent(p);return S.getInstance().then(function(o){return Promise.resolve(new D(e,i,o));});};
return c;},true);
sap.ui.predefine('sap/ui/fl/descriptorRelated/api/DescriptorInlineChangeFactory',["sap/ui/fl/descriptorRelated/internal/Utils"],function(U){"use strict";var D=function(c,p,t){U.checkTexts(t);this._mParameters={};this._mParameters.changeType=c;this._mParameters.content=p;this._mParameters.texts=t;};
D.prototype._getChangeType=function(){return this._mParameters.changeType;};
D.prototype.getMap=function(){return this._mParameters;};
D.prototype.getContent=function(){return this._mParameters.content;};
D.prototype.getTexts=function(){return this._mParameters.texts;};
D.prototype.replaceHostingIdForTextKey=function(n,o,c,t){var C=JSON.stringify(c);if(t){Object.keys(t).forEach(function(s){var b;if(s.indexOf(o)===0){b=n+s.substring(o.length);this._mParameters.texts[b]=this._mParameters.texts[s];delete this._mParameters.texts[s];C=C.split("{{"+s+"}}").join("{{"+b+"}}");}},this);this._mParameters.content=JSON.parse(C);}};
var a={};
a.getDescriptorChangeTypes=function(){return["appdescr_ovp_addNewCard","appdescr_ovp_removeCard","appdescr_ovp_changeCard","appdescr_app_addNewInbound","appdescr_app_changeInbound","appdescr_app_removeInbound","appdescr_app_removeAllInboundsExceptOne","appdescr_app_addNewOutbound","appdescr_app_changeOutbound","appdescr_app_removeOutbound","appdescr_app_addNewDataSource","appdescr_app_changeDataSource","appdescr_app_removeDataSource","appdescr_app_addAnnotationsToOData","appdescr_app_addTechnicalAttributes","appdescr_app_removeTechnicalAttributes","appdescr_app_setTitle","appdescr_app_setSubTitle","appdescr_app_setShortTitle","appdescr_app_setDescription","appdescr_app_setInfo","appdescr_app_setDestination","appdescr_app_setKeywords","appdescr_app_setAch","appdescr_flp_setConfig","appdescr_ui5_addNewModel","appdescr_ui5_addNewModelEnhanceWith","appdescr_ui5_removeModel","appdescr_ui5_replaceComponentUsage","appdescr_ui5_setMinUI5Version","appdescr_smb_addNamespace","appdescr_smb_changeNamespace","appdescr_ui_generic_app_setMainPage","appdescr_ui_setIcon","appdescr_ui_setDeviceTypes","appdescr_ui5_addLibraries","appdescr_url_setUri","appdescr_fiori_setRegistrationIds"];};
a.getCondensableDescriptorChangeTypes=function(){return["appdescr_app_setTitle","appdescr_app_setInfo","appdescr_app_setShortTitle","appdescr_app_setSubTitle","appdescr_app_setDescription","appdescr_app_setDestination","appdescr_app_setKeywords","appdescr_app_setAch","appdescr_ui_setIcon","appdescr_ui_setDeviceTypes","appdescr_ui_setIcon","appdescr_ui_setDeviceTypes","appdescr_fiori_setRegistrationIds","appdescr_smb_changeNamespace"];};
a.createNew=function(c,p,t){var d=new D(c,p,t);return new Promise(function(r,b){if(d){r(d);}else{var e={};b(e);}});};
a._createDescriptorInlineChange=function(d,p,t){var o=new D(d,p,t);return new Promise(function(r,b){if(o){r(o);}else{var e={};b(e);}});};
a.createDescriptorInlineChange=function(d,p,t){var f=d.replace("appdescr","create");return this[f](p,t);};
a.create_ovp_addNewCard=function(p,t){U.checkParameterAndType(p,"card","object");return this._createDescriptorInlineChange('appdescr_ovp_addNewCard',p,t);};
a.create_ovp_removeCard=function(p){U.checkParameterAndType(p,"cardId","string");return this._createDescriptorInlineChange('appdescr_ovp_removeCard',p);};
a.create_ovp_changeCard=function(p,t){U.checkParameterAndType(p,"cardId","string");U.checkEntityPropertyChange(p);return this._createDescriptorInlineChange('appdescr_ovp_changeCard',p,t);};
a.create_app_addNewInbound=function(p,t){U.checkParameterAndType(p,"inbound","object");return this._createDescriptorInlineChange('appdescr_app_addNewInbound',p,t);};
a.create_app_removeInbound=function(p){U.checkParameterAndType(p,"inboundId","string");return this._createDescriptorInlineChange('appdescr_app_removeInbound',p);};
a.create_app_removeAllInboundsExceptOne=function(p){U.checkParameterAndType(p,"inboundId","string");return this._createDescriptorInlineChange('appdescr_app_removeAllInboundsExceptOne',p);};
a.create_app_changeInbound=function(p,t){U.checkParameterAndType(p,"inboundId","string");U.checkEntityPropertyChange(p);return this._createDescriptorInlineChange('appdescr_app_changeInbound',p,t);};
a.create_app_addNewOutbound=function(p){U.checkParameterAndType(p,"outbound","object");return this._createDescriptorInlineChange('appdescr_app_addNewOutbound',p);};
a.create_app_removeOutbound=function(p){U.checkParameterAndType(p,"outboundId","string");return this._createDescriptorInlineChange('appdescr_app_removeOutbound',p);};
a.create_app_changeOutbound=function(p){U.checkParameterAndType(p,"outboundId","string");U.checkEntityPropertyChange(p);return this._createDescriptorInlineChange('appdescr_app_changeOutbound',p);};
a.create_app_addNewDataSource=function(p){U.checkParameterAndType(p,"dataSource","object");return this._createDescriptorInlineChange('appdescr_app_addNewDataSource',p);};
a.create_app_removeDataSource=function(p){U.checkParameterAndType(p,"dataSourceId","string");return this._createDescriptorInlineChange('appdescr_app_removeDataSource',p);};
a.create_app_changeDataSource=function(p){U.checkParameterAndType(p,"dataSourceId","string");U.checkEntityPropertyChange(p);return this._createDescriptorInlineChange('appdescr_app_changeDataSource',p);};
var T={BEGINNING:"BEGINNING",END:"END"};
a.create_app_addAnnotationsToOData=function(p){U.checkParameterAndType(p,"dataSourceId","string");U.checkParameterAndType(p,"annotations","array");U.checkParameterAndType(p,"dataSource","object");return this._createDescriptorInlineChange('appdescr_app_addAnnotationsToOData',p);};
a.create_app_setTitle=function(p,t){if(!t){t={"":p};}return this._createDescriptorInlineChange('appdescr_app_setTitle',{},t).then(function(d){return new Promise(function(r){d["setHostingIdForTextKey"]=function(h){var b=d;var s=h+"_sap.app.title";b._mParameters.texts[s]=b._mParameters.texts[""];delete b._mParameters.texts[""];};r(d);});});};
a.create_app_setSubTitle=function(p,t){if(!t){t={"":p};}return this._createDescriptorInlineChange('appdescr_app_setSubTitle',{},t).then(function(d){return new Promise(function(r){d["setHostingIdForTextKey"]=function(h){var b=d;var s=h+"_sap.app.subTitle";b._mParameters.texts[s]=b._mParameters.texts[""];delete b._mParameters.texts[""];};r(d);});});};
a.create_app_setShortTitle=function(p,t){if(!t){t={"":p};}return this._createDescriptorInlineChange('appdescr_app_setShortTitle',{},t).then(function(d){return new Promise(function(r){d["setHostingIdForTextKey"]=function(h){var b=d;var s=h+"_sap.app.shortTitle";b._mParameters.texts[s]=b._mParameters.texts[""];delete b._mParameters.texts[""];};r(d);});});};
a.create_app_setDescription=function(p,t){if(!t){t={"":p};}return this._createDescriptorInlineChange('appdescr_app_setDescription',{},t).then(function(d){return new Promise(function(r){d["setHostingIdForTextKey"]=function(h){var b=d;var s=h+"_sap.app.description";b._mParameters.texts[s]=b._mParameters.texts[""];delete b._mParameters.texts[""];};r(d);});});};
a.create_app_setInfo=function(p){var t={"":p};return this._createDescriptorInlineChange('appdescr_app_setInfo',{},t).then(function(d){return new Promise(function(r){d["setHostingIdForTextKey"]=function(h){var b=d;var s=h+"_sap.app.info";b._mParameters.texts[s]=b._mParameters.texts[""];delete b._mParameters.texts[""];};r(d);});});};
a.create_app_setAch=function(p){U.checkParameterAndType(p,"ach","string");return this._createDescriptorInlineChange('appdescr_app_setAch',p);};
a.create_app_setDestination=function(p){U.checkParameterAndType(p,"destination","object");return this._createDescriptorInlineChange('appdescr_app_setDestination',p);};
a.create_app_setKeywords=function(p,t){U.checkParameterAndType(p,"keywords","array");return this._createDescriptorInlineChange('appdescr_app_setKeywords',p,t);};
a.create_app_addTechnicalAttributes=function(p){U.checkParameterAndType(p,"technicalAttributes","array");return this._createDescriptorInlineChange('appdescr_app_addTechnicalAttributes',p);};
a.create_app_removeTechnicalAttributes=function(p){U.checkParameterAndType(p,"technicalAttributes","array");return this._createDescriptorInlineChange('appdescr_app_removeTechnicalAttributes',p);};
a.create_flp_setConfig=function(p){U.checkParameterAndType(p,"config","object");return this._createDescriptorInlineChange('appdescr_flp_setConfig',p);};
a.create_ui5_addNewModel=function(p){U.checkParameterAndType(p,"model","object");return this._createDescriptorInlineChange('appdescr_ui5_addNewModel',p);};
a.create_ui5_removeModel=function(p){U.checkParameterAndType(p,"modelId","string");return this._createDescriptorInlineChange('appdescr_ui5_removeModel',p);};
a.create_ui5_addNewModelEnhanceWith=function(p,t){U.checkParameterAndType(p,"modelId","string");return this._createDescriptorInlineChange('appdescr_ui5_addNewModelEnhanceWith',p,t);};
a.create_ui5_replaceComponentUsage=function(p){U.checkParameterAndType(p,"componentUsageId","string");U.checkParameterAndType(p,"componentUsage","object");return this._createDescriptorInlineChange('appdescr_ui5_replaceComponentUsage',p);};
a.create_ui5_addLibraries=function(p){U.checkParameterAndType(p,"libraries","object");return this._createDescriptorInlineChange('appdescr_ui5_addLibraries',p);};
a.create_ui5_setMinUI5Version=function(p){U.checkParameterAndType(p,"minUI5Version","string");return this._createDescriptorInlineChange('appdescr_ui5_setMinUI5Version',p);};
a.create_smb_addNamespace=function(p){U.checkParameterAndType(p,"smartBusinessApp","object");return this._createDescriptorInlineChange('appdescr_smb_addNamespace',p);};
a.create_smb_changeNamespace=function(p){U.checkParameterAndType(p,"smartBusinessApp","object");return this._createDescriptorInlineChange('appdescr_smb_changeNamespace',p);};
a.create_ui_generic_app_setMainPage=function(p,t){U.checkParameterAndType(p,"page","object");return this._createDescriptorInlineChange('appdescr_ui_generic_app_setMainPage',p,t);};
a.create_ui_setIcon=function(p){U.checkParameterAndType(p,"icon","string");return this._createDescriptorInlineChange('appdescr_ui_setIcon',p);};
a.create_ui_setDeviceTypes=function(p){U.checkParameterAndType(p,"deviceTypes","object");return this._createDescriptorInlineChange('appdescr_ui_setDeviceTypes',p);};
a.create_url_setUri=function(p){U.checkParameterAndType(p,"uri","string");return this._createDescriptorInlineChange('appdescr_url_setUri',p);};
a.create_fiori_setRegistrationIds=function(p){U.checkParameterAndType(p,"registrationIds","array");return this._createDescriptorInlineChange('appdescr_fiori_setRegistrationIds',p);};
return a;},true);
sap.ui.predefine('sap/ui/fl/descriptorRelated/api/DescriptorVariantFactory',["sap/ui/fl/LayerUtils","sap/ui/fl/descriptorRelated/internal/Utils","sap/ui/fl/registry/Settings","sap/ui/thirdparty/jquery","sap/base/util/merge"],function(L,U,S,q,b){"use strict";var D=function(p,f,d,s){if(p&&d){this._id=p.id;this._mode='DELETION';this._mMap=f;}else if(p){this._id=p.id;this._reference=p.reference;this._layer=p.layer;if(typeof p.isAppVariantRoot!=="undefined"){this._isAppVariantRoot=p.isAppVariantRoot;}if(typeof p.referenceVersion!=="undefined"){this._referenceVersion=p.referenceVersion;}this._mode='NEW';this._skipIam=p.skipIam;this._version=p.version;}else if(f){this._mMap=f;this._mode='FROM_EXISTING';}this._oSettings=s;this._sTransportRequest=null;this._content=[];};
D.prototype.addDescriptorInlineChange=function(d){var t=this;return new Promise(function(r){var s=function(_,i){if(_["setHostingIdForTextKey"]){_.setHostingIdForTextKey(i);}};switch(t._mode){case'NEW':s(d,t._id);t._content.push(d.getMap());break;case'FROM_EXISTING':s(d,t._mMap.id);t._mMap.content.push(d.getMap());break;default:}r(null);});};
D.prototype.setTransportRequest=function(t){try{U.checkTransportRequest(t);}catch(e){return Promise.reject(e);}this._sTransportRequest=t;return Promise.resolve();};
D.prototype.setPackage=function(p){try{U.checkPackage(p);}catch(e){return Promise.reject(e);}this._package=p;return Promise.resolve();};
D.prototype.submit=function(){var r='/sap/bc/lrep/appdescr_variants/';var m;switch(this._mode){case'NEW':m='POST';break;case'FROM_EXISTING':m='PUT';r=r+this._getMap().id;break;case'DELETION':m='DELETE';r=r+this._id;break;default:}var M=this._getMap();if(this._sTransportRequest){r+='?changelist='+this._sTransportRequest;}else if(this._oSettings.isAtoEnabled()&&(this._skipIam||((m==='PUT'||m==='DELETE')&&M.packageName!=='$TMP'))&&L.isCustomerDependentLayer(M.layer)){r+='?changelist=ATO_NOTIFICATION';}if(this._skipIam){r+=(r.indexOf('?')<0)?'?':'&';r+='skipIam='+this._skipIam;}return U.sendRequest(r,m,M);};
D.prototype.getId=function(){return this._getMap().id;};
D.prototype.setReference=function(r){if(r===undefined||typeof r!=="string"){throw new Error("No parameter sReference of type string provided");}this._reference=r;};
D.prototype.getReference=function(){return this._reference;};
D.prototype.getVersion=function(){return this._version;};
D.prototype.getNamespace=function(){return this._getMap().namespace;};
D.prototype.getPackage=function(){return this._getMap().packageName;};
D.prototype.getDefinition=function(){return this._getMap();};
D.prototype.getSettings=function(){return this._oSettings;};
D.prototype.getJson=function(){return b({},this._getMap());};
D.prototype._getMap=function(){switch(this._mode){case'NEW':var r={fileName:this._getNameAndNameSpace().fileName,fileType:"appdescr_variant",namespace:this._getNameAndNameSpace().namespace,layer:this._layer,packageName:this._package?this._package:"",reference:this._reference,id:this._id,content:this._content};if(typeof this._isAppVariantRoot!=="undefined"){r.isAppVariantRoot=this._isAppVariantRoot;}if(r.isAppVariantRoot!==undefined&&!r.isAppVariantRoot){r.fileType="cdmapp_config";}if(typeof this._referenceVersion!=="undefined"){r.referenceVersion=this._referenceVersion;}if(this._version){r.version=this._version;}return r;case'FROM_EXISTING':case'DELETION':{return this._mMap;}default:}};
D.prototype._getNameAndNameSpace=function(){return U.getNameAndNameSpace(this._id,this._reference);};
var a={};
a._getDescriptorVariant=function(i){var r='/sap/bc/lrep/appdescr_variants/'+i;return U.sendRequest(r,'GET');};
a.createNew=function(p){return a.createAppVariant(p);};
a.createAppVariant=function(p){U.checkParameterAndType(p,"reference","string");U.checkParameterAndType(p,"id","string");if(p.version){U.checkParameterAndType(p,"version","string");}if(!p.layer){p.layer='CUSTOMER';}else{U.checkParameterAndType(p,"layer","string");}if(p.isAppVariantRoot){U.checkParameterAndType(p,"isAppVariantRoot","boolean");}if(p.skipIam){U.checkParameterAndType(p,"skipIam","boolean");}return S.getInstance().then(function(s){return Promise.resolve(new D(p,null,false,s));});};
a.createForExisting=function(i){return a.loadAppVariant(i,false);};
a.createFromJson=function(p){if(!q.isPlainObject(p)){throw new Error("Parameter \"mParameters\" must be provided of type object");}return S.getInstance().then(function(s){return Promise.resolve(new D(null,p,false,s));});};
a.createDeletion=function(i){return a.loadAppVariant(i,true);};
a.loadAppVariant=function(i,d){if(i===undefined||typeof i!=="string"){throw new Error("Parameter \"sId\" must be provided of type string");}var _;return a._getDescriptorVariant(i).then(function(r){_=r;return S.getInstance();}).then(function(s){var m=_.response;if(!q.isPlainObject(m)){m=JSON.parse(m);}return d?Promise.resolve(new D({id:i},m,d,s)):Promise.resolve(new D(null,m,d,s));});};
return a;},true);
sap.ui.predefine('sap/ui/fl/descriptorRelated/internal/Utils',["sap/ui/fl/LrepConnector"],function(L){"use strict";var U=function(){};
U.prototype.sendRequest=function(r,m,M){if(!this._oLREPConnector){this._oLREPConnector=L.createConnector();}return this._oLREPConnector.send(r,m,M);};
U.prototype.getNameAndNameSpace=function(i,r){return{fileName:"manifest",namespace:"apps/"+r+"/appVariants/"+i+"/"};};
U.prototype.checkEntityPropertyChange=function(p){this.checkParameterAndType(p,"entityPropertyChange","object");if(p.entityPropertyChange instanceof Array){for(var i=0;i<p.entityPropertyChange.length;i++){var c=p.entityPropertyChange[i];this.checkEntityPropertyChangeContent(c);}}else if(p.entityPropertyChange instanceof Object){this.checkEntityPropertyChangeContent(p.entityPropertyChange);}};
U.prototype.checkEntityPropertyChangeContent=function(c){this.checkParameterAndType(c,"propertyPath","string");this.checkParameterAndType(c,"operation","string");if(['INSERT','UPDATE','UPSERT','DELETE'].indexOf(c.operation)===-1){throw new Error("Parameter \"entityPropertyChange.operation\" needs to be one of 'INSERT', 'UPDATE', 'UPSERT', 'DELETE'");}if(c.propertyValue===undefined&&c.operation!=='DELETE'){throw new Error("No parameter \"entityPropertyChange.propertyValue\" provided");}};
U.prototype.checkParameterAndType=function(p,P,t){if(t==="array"){if(p===undefined||p[P]===undefined||!Array.isArray(p[P])){throw new Error("No parameter \""+P+"\" of type "+t+" provided");}}else if(p===undefined||p[P]===undefined||typeof p[P]!==t){throw new Error("No parameter \""+P+"\" of type "+t+" provided");}};
U.prototype.checkTexts=function(t){if(t!==undefined&&typeof t!=="object"){throw new Error("Wrong format for provided \"texts\" parameter");}};
U.prototype.checkTransportRequest=function(t){if(!/^[A-Z0-9]{1,20}$/.test(t)&&t!=='ATO_NOTIFICATION'){throw new Error("Wrong format for provided \"sTransportRequest\" parameter");}};
U.prototype.checkPackage=function(p){if(!/^[A-Z0-9/_]{1,30}$/.test(p)){throw new Error("Wrong format for provided \"sPackage\" parameter");}};
return new U();},true);
sap.ui.predefine('sap/ui/fl/fieldExt/Access',["sap/ui/util/Storage","sap/ui/fl/Utils","sap/base/security/encodeURLParameters","sap/ui/thirdparty/jquery"],function(S,U,a,q){"use strict";var A={};A._mServiceType={v2:"v2",v4:"v4"};A._sODataV4ResourcePathPrefix="sap/opu/odata4/";A._sStorageKey="sap.ui.fl.fieldExt.Access";A._iValidityPeriod=1*7*24*60*60*1000;
A.getBusinessContexts=function(s,e,E){var m=this._getEntityInfo(e,E);var b=this._parseServiceUri(s);var B=this._buildBusinessContextRetrievalUri(b,m);var p=this._executeAjaxCall(B,b,m);return p;};
A.isServiceOutdated=function(s){if(!this._isSystemInfoAvailable()){return false;}var m=this._getServiceItem(this._createServiceItem(s));if(m){if(this._isServiceExpired(m)){this.setServiceValid(s);return false;}return true;}return false;};
A.setServiceValid=function(s){if(this._isSystemInfoAvailable()){var d=this._getDataFromLocalStorage();delete d[this._createServiceItem(s).serviceKey];this._setDataToLocalStorage(d);}};
A.setServiceInvalid=function(s){if(this._isSystemInfoAvailable()){var d=this._getDataFromLocalStorage();var i=this._createServiceItem(s);d[i.serviceKey]=i;this._setDataToLocalStorage(d);}};
A._getEntityInfo=function(e,E){var o={entityTypeName:e||"",entitySetName:E||""};if(((o.entitySetName.length===0)&&(o.entityTypeName.length===0))||(!(o.entitySetName.length===0)&&!(o.entityTypeName.length===0))){throw new Error("sap.ui.fl.fieldExt.Access._getEntityInfo()"+"Inconsistent input parameters EntityType: "+o.entityTypeName+" EntitySet: "+o.entitySetName);}return o;};
A._parseServiceUri=function(s){if(s.toLowerCase().indexOf(this._sODataV4ResourcePathPrefix)!==-1){return this._parseV4ServiceUri(s);}return this._parseV2ServiceUri(s);};
A._parseV2ServiceUri=function(s){var r=/.*sap\/opu\/odata\/([^\/]+)\/([^\/]+)/i;var R=/([^;]+);v=(\d{1,4})/i;var o="sap/opu/odata";var b;if(s.toLowerCase().indexOf(o)!==-1){var c=s.match(r);if(!c||c.length!==3){throw new Error("sap.ui.fl.fieldExt.Access._parseV2ServiceUri: Malformed service URI (Invalid service name)");}if(c[1].toLowerCase()!=="sap"){b="/"+c[1]+"/"+c[2];}else{b=c[2];}}else{if(s.length>0&&s.lastIndexOf("/")+1===s.length){s=s.substring(0,s.length-1);}b=s.substring(s.lastIndexOf("/")+1);}if(b.indexOf(";v=")!==-1){var v=b.match(R);if(!v||v.length!==3){throw new Error("sap.ui.fl.fieldExt.Access._parseV2ServiceUri: Malformed service URI (Invalid version)");}return{serviceName:v[1],serviceVersion:v[2],serviceType:this._mServiceType.v2};}return{serviceName:b,serviceVersion:"0001",serviceType:this._mServiceType.v2};};
A._parseV4ServiceUri=function(s){var r=/^\/?sap\/opu\/odata4((?:\/[^/]+){5})(\/[^/]+){1}(\/.*)?/i;var b=s.match(r);if(!b||b.length!==4){throw new Error("sap.ui.fl.fieldExt.Access._parseV4ServiceUri: Malformed service URI");}var n=b[1].split("/");n.splice(0,3);var R=/(\d{1,4})/i;var v=b[2].match(R);return{serviceName:n.join("/"),serviceVersion:v[1],serviceType:this._mServiceType.v4};};
A._buildBusinessContextRetrievalUri=function(s,e){var b="/sap/opu/odata/SAP/APS_CUSTOM_FIELD_MAINTENANCE_SRV/";if(s.serviceType===this._mServiceType.v4){var r=this._sODataV4ResourcePathPrefix+s.serviceName+"/"+s.serviceVersion;b+="GetBusinessContextsByResourcePath?"+a({ResourcePath:"'"+r+"'"});}else{b+="GetBusinessContextsByEntityType?"+"ServiceName=\'"+s.serviceName+"\'"+"&ServiceVersion=\'"+s.serviceVersion+"\'";}b+="&EntitySetName=\'"+e.entitySetName+"\'"+"&EntityTypeName=\'"+e.entityTypeName+"\'"+"&$format=json";return b;};
A._executeAjaxCall=function(b,s,e){var t=this;var m=this._getAjaxSettings();var d=q.Deferred();var r={BusinessContexts:[],ServiceName:s.serviceName,ServiceVersion:s.serviceVersion};q.ajax(b,m).done(function(c){r.BusinessContexts=t._extractBusinessContexts(c);d.resolve(r);}).fail(function(j){if(j.status===404&&s.serviceType===t._mServiceType.v4){d.resolve(r);}else{var E=t._getMessagesFromXHR(j);var o={errorOccured:true,errorMessages:E,serviceName:s.serviceName,serviceVersion:s.serviceVersion,entityType:e.entityTypeName,entitySet:e.entitySetName};d.reject(o);}});return d.promise();};
A._getAjaxSettings=function(){var s={type:"GET",async:true,dataType:"json"};return s;};
A._extractBusinessContexts=function(d){var r=null;var b=[];if(d&&d.d){r=d.d.results;}if(r!==null&&r.length>0){for(var i=0;i<r.length;i++){if(r[i].BusinessContext!==null){b.push({BusinessContext:r[i].BusinessContext,BusinessContextDescription:r[i].BusinessContextDescription});}}}return b;};
A._getMessagesFromXHR=function(x){var m=[];try{var E=JSON.parse(x.responseText);if(E&&E.error&&E.error.message&&E.error.message.value&&E.error.message.value!==''){m.push({severity:"error",text:E.error.message.value});}else{m.push({severity:"error",text:x.responseText});}}catch(e){}return m;};
A._getCurrentTime=function(){return Date.now();};
A._isServiceExpired=function(s){return s.expirationDate<=this._getCurrentTime();};
A._getLocalStorage=function(){return new S(S.Type.local);};
A.isLocalStorageAvailable=function(){return this._getLocalStorage()&&this._getLocalStorage().isSupported();};
A._getServiceItem=function(s){return this._getDataFromLocalStorage()[s.serviceKey]||null;};
A._createServiceItem=function(s){var e=this._getCurrentTime()+this._iValidityPeriod;var m=this._getSystemInfo();var p=this._extractServiceInfo(s);return{serviceKey:m.getName()+m.getClient()+p.serviceName+p.serviceVersion,expirationDate:e};};
A._extractServiceInfo=function(s){if(typeof s==="string"){return this._parseServiceUri(s);}return s;};
A._isSystemInfoAvailable=function(){var u=U.getUshellContainer();return u&&u.getLogonSystem;};
A._getSystemInfo=function(){var u=U.getUshellContainer();return u&&u.getLogonSystem();};
A._setDataToLocalStorage=function(d){if(this.isLocalStorageAvailable()){this._getLocalStorage().put(A._sStorageKey,JSON.stringify(d));}};
A._getDataFromLocalStorage=function(){if(!this.isLocalStorageAvailable()){return{};}var s=this._getLocalStorage().get(A._sStorageKey);if(!s){return{};}return JSON.parse(s);};
return A;},true);
sap.ui.predefine('sap/ui/fl/library',["sap/ui/fl/RegistrationDelegator","sap/ui/core/library","sap/m/library"],function(R){"use strict";sap.ui.getCore().initLibrary({name:"sap.ui.fl",version:"1.71.16",controls:["sap.ui.fl.variants.VariantManagement"],dependencies:["sap.ui.core","sap.m"],designtime:"sap/ui/fl/designtime/library.designtime",extensions:{"sap.ui.support":{diagnosticPlugins:["sap/ui/fl/support/Flexibility"],publicRules:true}}});sap.ui.fl.Layer={USER:"USER",CUSTOMER:"CUSTOMER",CUSTOMER_BASE:"CUSTOMER_BASE",PARTNER:"PARTNER",VENDOR:"VENDOR",BASE:"BASE"};sap.ui.fl.Scenario={AppVariant:"APP_VARIANT",VersionedAppVariant:"VERSIONED_APP_VARIANT",AdaptationProject:"ADAPTATION_PROJECT",FioriElementsFromScratch:"FE_FROM_SCRATCH",UiAdaptation:"UI_ADAPTATION"};R.registerAll();return sap.ui.fl;});
sap.ui.predefine('sap/ui/fl/registry/ChangeHandlerRegistration',["sap/ui/fl/registry/ChangeRegistry","sap/ui/thirdparty/jquery"],function(C,q){"use strict";var a={_mRegistrationPromises:{},_addRegistrationPromise:function(k,p){this._mRegistrationPromises[k]=p;p.then(function(){delete this._mRegistrationPromises[k];}.bind(this));p.catch(function(e){delete this._mRegistrationPromises[k];return Promise.reject(e);}.bind(this));},waitForChangeHandlerRegistration:function(k){return this._mRegistrationPromises[k]||Promise.resolve();},isChangeHandlerRegistrationInProgress:function(k){return!!this._mRegistrationPromises[k];},getChangeHandlersOfLoadedLibsAndRegisterOnNewLoadedLibs:function(){var c=sap.ui.getCore();var A=c.getLoadedLibraries();var p=[];q.each(A,function(l,L){if(L.extensions&&L.extensions.flChangeHandlers){p.push(this._registerFlexChangeHandlers(L.extensions.flChangeHandlers));}}.bind(this));c.attachLibraryChanged(this._handleLibraryRegistrationAfterFlexLibraryIsLoaded.bind(this));return Promise.all(p);},_registerFlexChangeHandlers:function(f){if(f){var c=C.getInstance();return c.registerControlsForChanges(f);}return Promise.resolve();},_handleLibraryRegistrationAfterFlexLibraryIsLoaded:function(l){if(l.getParameter("operation")==="add"){var L=l.getParameter("metadata");var o=L.sName;if(L&&L.extensions&&L.extensions.flChangeHandlers){var f=L.extensions.flChangeHandlers;var r=this._registerFlexChangeHandlers(f);this._addRegistrationPromise(o,r);return r;}}return Promise.resolve();}};return a;},true);
sap.ui.predefine('sap/ui/fl/registry/ChangeRegistry',["sap/ui/fl/Utils","sap/ui/thirdparty/jquery","sap/ui/fl/registry/ChangeRegistryItem","sap/ui/fl/registry/ChangeTypeMetadata","sap/ui/fl/registry/Settings","sap/ui/fl/changeHandler/HideControl","sap/ui/fl/changeHandler/MoveElements","sap/ui/fl/changeHandler/MoveControls","sap/ui/fl/changeHandler/PropertyChange","sap/ui/fl/changeHandler/PropertyBindingChange","sap/ui/fl/changeHandler/UnhideControl","sap/ui/fl/changeHandler/StashControl","sap/ui/fl/changeHandler/UnstashControl","sap/ui/fl/changeHandler/AddXML","sap/base/Log"],function(U,q,C,a,S,H,M,b,P,c,d,e,f,A,L){"use strict";var g=function(){this._registeredItems={};this.initSettings();this.initDeveloperModeChangeHandlers();};g._instance=undefined;g.prototype._oDefaultActiveChangeHandlers={};g.prototype._oDefaultChangeHandlers={hideControl:H,moveElements:M,moveControls:b,unhideControl:d,stashControl:e,unstashControl:f};g.prototype._mDeveloperModeChangeHandlers={propertyChange:{changeHandler:P},propertyBindingChange:{changeHandler:c},addXML:{changeHandler:A}};
g.prototype.initDeveloperModeChangeHandlers=function(){Object.keys(this._mDeveloperModeChangeHandlers).forEach(function(s){var o=this._mDeveloperModeChangeHandlers[s].changeHandler;var l=this._oSettings.getDeveloperModeLayerPermissions();var h={changeType:s,changeHandler:o,layers:l};var i=this._createChangeRegistryItemForSimpleChange("defaultActiveForAllControls",h);this._oDefaultActiveChangeHandlers[s]=i;}.bind(this));};
g.getInstance=function(){if(!g._instance){g._instance=new g();}return g._instance;};
g.prototype.hasRegisteredChangeHandlersForControl=function(s){var h=Object.keys(this._registeredItems);return h.indexOf(s)!==-1;};
g.prototype.hasChangeHandlerForControlAndChange=function(s,h){if(!this.hasRegisteredChangeHandlersForControl(s)){return false;}var r=this._registeredItems[s];var i=Object.keys(r);return i.indexOf(h)!==-1;};
g.prototype.registerControlsForChanges=function(m){var p=[];q.each(m,function(s,v){var h={};if(Array.isArray(v)){v.forEach(function(o){h[o.changeType]=o.changeHandler;});}else{h=v;}p.push(this._registerChangeHandlersForControl(s,h));}.bind(this));return Promise.all(p);};
g.prototype._registerChangeHandlersForControl=function(s,o){var p=Promise.resolve(o);var h="ChangeRegistry._registerChangeHandlersForControl.skip_next_then";if(typeof o==="string"){p=U.requireAsync(o+".flexibility").catch(function(E){L.error("Flexibility change handler registration failed.\nControlType: "+s+"\n"+E.message);return Promise.resolve(h);});}return p.then(function(r){if(r!==h){q.each(r,function(i,j){var k=this._getChangeHandlerEntry(i,j);var l={changeType:i,changeHandler:k.changeHandler,layers:k.layers};this.registerControlForSimpleChange(s,l);}.bind(this));}}.bind(this));};
g.prototype._getInstanceSpecificChangeRegistryItem=function(s,o,m){var h=m.getChangeHandlerModulePath(o);if(typeof h!=="string"){return new U.FakePromise(undefined);}return U.requireAsync(h).then(function(i){var v=i[s];if(!v){return undefined;}var j=this._getChangeHandlerEntry(s,v);var k={changeType:s,changeHandler:j.changeHandler,layers:j.layers};var l=m.getControlType(o);var n=this._createChangeRegistryItemForSimpleChange(l,k);return n;}.bind(this)).catch(function(E){L.error("Flexibility registration for control "+m.getId(o)+" failed to load module "+h+"\n"+E.message);return undefined;});};
g.prototype._getChangeHandlerEntry=function(s,v){var r={};var D=Object.keys(this._mDeveloperModeChangeHandlers);if(!v||!v.changeHandler){r.changeHandler=v;}else{r=v;}if(r.changeHandler==="default"){r.changeHandler=this._oDefaultChangeHandlers[s];}else if(D.indexOf(s)>-1){throw new Error("You can't use a custom change handler for the following Developer Mode change types: "+D.toString()+". Please use 'default' instead.");}return r;};
g.prototype._getChangeRegistryItem=function(s,h,l){if(!s||!h){return undefined;}var m=this.getRegistryItems({changeTypeName:s,controlType:h,layer:l});if(m&&m[h]&&m[h][s]){return m[h][s];}else if(m&&m[h]){return m[h];}return m;};
g.prototype._extractChangeHandlerFromRegistryItem=function(r){if(r&&r.getChangeTypeMetadata){return r.getChangeTypeMetadata().getChangeHandler();}};
g.prototype.getChangeHandler=function(s,h,o,m,l){return this._getInstanceSpecificChangeRegistryItem(s,o,m).then(function(i){return this._extractChangeHandlerFromRegistryItem(i);}.bind(this)).then(function(i){if(i){return i;}var j=this._getChangeRegistryItem(s,h,l);return this._extractChangeHandlerFromRegistryItem(j);}.bind(this));};
g.prototype.registerControlForSimpleChange=function(s,o){var h;if(!s){return;}if(!o||!o.changeType||!o.changeHandler){return;}h=this._createChangeRegistryItemForSimpleChange(s,o);if(h){this.addRegistryItem(h);}};
g.prototype._createChangeRegistryItemForSimpleChange=function(s,o){var p;var h;var i;var l;l=Object.assign({},this._oSettings.getDefaultLayerPermissions());var j=o.layers;if(j){Object.keys(j).forEach(function(k){if(l[k]===undefined){throw new Error("The Layer '"+k+"' is not supported. Please only use supported layers");}l[k]=j[k];});}p={name:o.changeType,changeHandler:o.changeHandler,layers:l};h=new a(p);p={changeTypeMetadata:h,controlType:s};i=new C(p);return i;};
g.prototype.addRegistryItem=function(r){var s;var h;if(!r){return;}s=r.getChangeTypeName();h=r.getControlType();this._registeredItems[h]=this._registeredItems[h]||{};this._registeredItems[h][s]=r;};
g.prototype.removeRegistryItem=function(p){if(!p.changeTypeName&&!p.controlType){L.error("sap.ui.fl.registry.ChangeRegistry: ChangeType and/or ControlType required");return;}if(p.controlType&&p.changeTypeName){if(this._registeredItems[p.controlType]){if(Object.keys(this._registeredItems[p.controlType]).length===1){delete this._registeredItems[p.controlType];}else{delete this._registeredItems[p.controlType][p.changeTypeName];}}}else if(p.controlType){if(this._registeredItems[p.controlType]){delete this._registeredItems[p.controlType];}}else if(p.changeTypeName){for(var h in this._registeredItems){var i=this._registeredItems[h];delete i[p.changeTypeName];}}};
g.prototype._getSingleRegistryItem=function(s,h){var o=this._registeredItems[s];if(o){var i=o[h];if(i){return i;}}var D=this._oDefaultActiveChangeHandlers[h];if(D){return D;}};
g.prototype._getRegistryItemsByChangeAndControlType=function(s,h){var r;var R=this._getSingleRegistryItem(s,h);if(R){r={};r[s]={};r[s][h]=R;}return r;};
g.prototype._getRegistryItemsByControlType=function(s){var r={};r[s]={};if(this._registeredItems[s]){var h=Object.keys(this._registeredItems[s]);h.forEach(function(i){r[s][i]=this._getSingleRegistryItem(s,i);}.bind(this));}for(var k in this._oDefaultActiveChangeHandlers){r[s][k]=this._oDefaultActiveChangeHandlers[k];}return r;};
g.prototype._getRegistryItemsByChangeType=function(s){var r={};for(var h in this._registeredItems){if(this._registeredItems[h][s]){r[h]={};r[h][s]=this._getSingleRegistryItem(h,s);}}r["defaultActiveForAllControls"]={};for(var k in this._oDefaultActiveChangeHandlers){r["defaultActiveForAllControls"][k]=this._oDefaultActiveChangeHandlers[k];}return r;};
g.prototype.getRegistryItems=function(p){var r;if(!p){L.error("sap.ui.fl.registry.ChangeRegistry: no parameters passed for getRegistryItems");}var s=p.changeTypeName;var h=p.controlType;if(!s&&!h){L.error("sap.ui.fl.registry.ChangeRegistry: Change Type Name and/or Control Type required");}if(h&&s){r=this._getRegistryItemsByChangeAndControlType(h,s);}else if(h){r=this._getRegistryItemsByControlType(h);}else if(s){r=this._getRegistryItemsByChangeType(s);}this._filterChangeTypes(r,p.layer);return r;};
g.prototype.initSettings=function(){this._oSettings=S.getInstanceOrUndef();if(!this._oSettings){this._oSettings=new S({});}};
g.prototype._filterChangeTypes=function(r,l){if(this._oSettings&&l&&r){var i=false;q.each(r,function(s,o){q.each(o,function(h,R){var j=R.getChangeTypeMetadata().getLayers();i=j[l];if(!i){L.warning("Change type "+h+" not enabled for layer "+l);delete o[h];}});});}};
g.prototype.getDragInfo=function(s){var h=this._registeredItems[s];if(h){return h.getDragInfo();}return null;};
return g;},true);
sap.ui.predefine('sap/ui/fl/registry/ChangeRegistryItem',["sap/base/Log"],function(L){"use strict";var C=function(p){if(!p.changeTypeMetadata){L.error("sap.ui.fl.registry.ChangeRegistryItem: ChangeTypeMetadata required");}if(!p.controlType){L.error("sap.ui.fl.registry.ChangeRegistryItem: ControlType required");}this._changeTypeMetadata=p.changeTypeMetadata;this._controlType=p.controlType;if(p.permittedRoles){this._permittedRoles=p.permittedRoles;}if(p.dragTargets){this._dragTargets=p.dragTargets;}};C.prototype._changeTypeMetadata=undefined;C.prototype._controlType=undefined;C.prototype._permittedRoles={};C.prototype._dragTargets=[];
C.prototype.getChangeTypeMetadata=function(){return this._changeTypeMetadata;};
C.prototype.getChangeTypeName=function(){return this._changeTypeMetadata.getName();};
C.prototype.getControlType=function(){return this._controlType;};
C.prototype.getPermittedRoles=function(){return this._permittedRoles;};
C.prototype.getDragTargets=function(){return this._dragTargets;};
return C;},true);
sap.ui.predefine('sap/ui/fl/registry/ChangeTypeMetadata',["sap/base/Log","sap/ui/fl/Utils"],function(L,U){"use strict";var C=function(p){if(!p.name){L.error("sap.ui.fl.registry.ChangeType: Name required");}if(!p.changeHandler){L.error("sap.ui.fl.registry.ChangeType: ChangeHandler required");}this._name=p.name;this._changeHandler=p.changeHandler;this._layers=p.layers;if(p.labelKey){this._labelKey=p.labelKey;}if(p.tooltipKey){this._tooltipKey=p.tooltipKey;}if(p.iconKey){this._iconKey=p.iconKey;}if(p.sortIndex){this._sortIndex=p.sortIndex;}};C.prototype._name="";C.prototype._changeHandler="";C.prototype._layers=[];C.prototype._sortIndex=0;C.prototype._labelKey="";C.prototype._tooltipKey="";C.prototype._iconKey="";
C.prototype.getName=function(){return this._name;};
C.prototype.getChangeHandler=function(){var p=new U.FakePromise();if(typeof this._changeHandler==="string"){p=U.requireAsync(this._changeHandler.replace(/\./g,"/")).then(function(c){this._changeHandler=c;}.bind(this));}return p.then(function(){if(!this._changeHandler||typeof this._changeHandler.completeChangeContent!=="function"||typeof this._changeHandler.applyChange!=="function"||typeof this._changeHandler.revertChange!=="function"){return Promise.reject(new Error("The ChangeHandler is either not available or does not fulfill all needed requirements"));}return this._changeHandler;}.bind(this));};
C.prototype.getLayers=function(){return this._layers;};
C.prototype.getLabel=function(){return this._labelKey;};
C.prototype.getTooltip=function(){return this._tooltipKey;};
C.prototype.getIcon=function(){return this._iconKey;};
C.prototype.getSortIndex=function(){return this._sortIndex;};
return C;},true);
sap.ui.predefine('sap/ui/fl/registry/Settings',["sap/ui/fl/LrepConnector","sap/ui/fl/Cache","sap/ui/fl/Utils","sap/base/util/UriParameters","sap/base/Log"],function(L,C,U,a,b){"use strict";var S=function(s){if(!s){throw new Error("no flex settings provided");}if(!s.defaultLayerPermissions){s.defaultLayerPermissions={VENDOR:true,CUSTOMER_BASE:true,CUSTOMER:true,USER:false};}if(!s.developerModeLayerPermissions){s.developerModeLayerPermissions={VENDOR:true,CUSTOMER_BASE:true,CUSTOMER:false,USER:false};}if(!(S._IS_VARIANT_SHARING_ENABLED in s)){s.isVariantSharingEnabled=true;}this._oSettings=s;};
S._initInstance=function(){var s;if(U.isTrialSystem()){s=new S({isKeyUser:true,isVariantSharingEnabled:false});}S._instance=s;};
S._initInstance();S._IS_VARIANT_SHARING_ENABLED="isVariantSharingEnabled";
S.attachEvent=function(e,c){S._oEventProvider.attachEvent(e,c);};
S.detachEvent=function(e,c){S._oEventProvider.detachEvent(e,c);};
S.getInstance=function(){if(S._instance){return Promise.resolve(S._instance);}var p=C.getFlexDataPromise();if(p){return p.then(function(f){var s={};if(f.changes&&f.changes.settings){s=f.changes.settings;return S._storeInstance(s);}return S._loadSettings();},function(){return S._loadSettings();});}return S._loadSettings();};
S._loadSettings=function(){return L.createConnector().loadSettings().then(function(s){if(!s){b.error("The request for flexibility settings failed; A default response is generated and returned to consuming APIs");s={isKeyUser:false,isVariantSharingEnabled:false,isAtoAvailable:false,isAtoEnabled:false,isProductiveSystem:true,_bFlexChangeMode:false,_bFlexibilityAdaptationButtonAllowed:false};}return S._storeInstance(s);});};
S._storeInstance=function(s){if(!S._instance){S._instance=new S(s);}return S._instance;};
S.getInstanceOrUndef=function(){var s;if(S._instance){s=S._instance;}return s;};
S.prototype._getBooleanProperty=function(p){var v=false;if(this._oSettings[p]){v=this._oSettings[p];}return v;};
S.prototype.isKeyUser=function(){return this._getBooleanProperty("isKeyUser");};
S.prototype.isModelS=function(){return this._getBooleanProperty("isAtoAvailable");};
S.prototype.isAtoEnabled=function(){return this._getBooleanProperty("isAtoEnabled");};
S.prototype.isAtoAvailable=function(){return this._getBooleanProperty("isAtoAvailable");};
S.prototype.isProductiveSystem=function(){return this._getBooleanProperty("isProductiveSystem");};
S.prototype.isVariantSharingEnabled=function(){return(this._oSettings.isVariantSharingEnabled===true);};
S.prototype.getSystem=function(){return this._oSettings.system;};
S.prototype.getClient=function(){return this._oSettings.client;};
S.prototype.getDefaultLayerPermissions=function(){return this._oSettings.defaultLayerPermissions;};
S.prototype.getDeveloperModeLayerPermissions=function(){return this._oSettings.developerModeLayerPermissions;};
return S;},true);
sap.ui.predefine('sap/ui/fl/registry/SimpleChanges',["sap/ui/fl/changeHandler/HideControl","sap/ui/fl/changeHandler/UnhideControl","sap/ui/fl/changeHandler/StashControl","sap/ui/fl/changeHandler/UnstashControl","sap/ui/fl/changeHandler/MoveElements","sap/ui/fl/changeHandler/MoveControls","sap/ui/fl/changeHandler/PropertyChange","sap/ui/fl/changeHandler/PropertyBindingChange"],function(H,U,S,a,M,b,P,c){"use strict";var d={hideControl:{changeType:"hideControl",changeHandler:H},unhideControl:{changeType:"unhideControl",changeHandler:U},stashControl:{changeType:"stashControl",changeHandler:S},unstashControl:{changeType:"unstashControl",changeHandler:a},moveElements:{changeType:"moveElements",changeHandler:M},moveControls:{changeType:"moveControls",changeHandler:b},propertyChange:{changeType:"propertyChange",changeHandler:P},propertyBindingChange:{changeType:"propertyBindingChange",changeHandler:c}};return d;},true);
sap.ui.predefine('sap/ui/fl/transport/TransportDialog',["sap/m/List","sap/m/InputListItem","sap/m/Button","sap/m/ComboBox","sap/m/Dialog","sap/m/DialogRenderer","sap/m/Input","sap/m/MessageToast","sap/ui/core/ListItem"],function(L,I,B,C,D,a,b,M,c){"use strict";
var T=D.extend("sap.ui.fl.transport.TransportDialog",{
metadata:{library:"sap.ui.fl",properties:{pkg:{type:"string",group:"Misc",defaultValue:null},transports:{type:"any",group:"Misc",defaultValue:null},lrepObject:{type:"any",group:"Misc",defaultValue:null},hidePackage:{type:"boolean",group:"Misc",defaultValue:null}},events:{ok:{},cancel:{}}},
renderer:a.render
});
T.prototype.init=function(){D.prototype.init.apply(this);this._oResources=sap.ui.getCore().getLibraryResourceBundle("sap.ui.fl");this.setTitle(this._oResources.getText("TRANSPORT_DIALOG_TITLE"));this._oPackageLabel=null;this._oPackage=this._createPackageField();this._oTransport=this._createTransportCombo();this.addContent(this._createContentList());this._createButtons();this.setEscapeHandler(function(p){this.fireCancel();p.resolve();}.bind(this));};
T.prototype._createContentList=function(){this._oPackageListItem=new I({label:this._oResources.getText("TRANSPORT_DIALOG_PACKAGE"),content:[this._oPackage]});this._oTransportListItem=new I({label:this._oResources.getText("TRANSPORT_DIALOG_TRANSPORT"),content:[this._oTransport]});return new L({items:[this._oPackageListItem,this._oTransportListItem]});};
T.prototype._createButtons=function(){var t=this;this.addButton(new B({text:this._oResources.getText("TRANSPORT_DIALOG_LOCAL_OBJECT"),tooltip:this._oResources.getText("TRANSPORT_DIALOG_LOCAL_OBJECT"),press:function(){t._onLocal();}}));this.addButton(new B({text:this._oResources.getText("TRANSPORT_DIALOG_OK"),tooltip:this._oResources.getText("TRANSPORT_DIALOG_OK"),enabled:false,press:function(){t._onOkay();}}));this.addButton(new B({text:this._oResources.getText("TRANSPORT_DIALOG_CANCEL"),tooltip:this._oResources.getText("TRANSPORT_DIALOG_CANCEL"),press:function(){t.fireCancel();t.close();t.destroy();}}));};
T.prototype._onLocal=function(){this.fireOk({selectedTransport:"",selectedPackage:this.getPkg()||"$TMP",dialog:true});this.close();this.destroy();};
T.prototype._onOkay=function(){var t=this._oTransport.getSelectedKey();if(this._checkOkay(t)){this.fireOk({selectedTransport:t,selectedPackage:this.getPkg()||this._oPackage.getValue(),dialog:true});this.close();this.destroy();}else{this.getButtons()[1].setEnabled(false);this._oTransport.setValueState(sap.ui.core.ValueState.Error);this._oTransport.setValueStateText(this.getTitle());}};
T.prototype._checkOkay=function(t){if(t){return true;}return false;};
T.prototype._createTransportCombo=function(){var t=this;return new C({showSecondaryValues:true,enabled:false,tooltip:this._oResources.getText("TRANSPORT_DIALOG_TRANSPORT_TT"),width:"100%",selectionChange:function(){if(t._oPackageListItem.getVisible()&&!t._oPackage.getValue()){return;}t.getButtons()[1].setEnabled(true);t._oTransport.setValueState(sap.ui.core.ValueState.None);},change:function(e){var f=function(i){if((i&&e.mParameters.newValue!==i.getText())||!i){return true;}return false;};if(e&&e.mParameters&&e.mParameters.newValue){if(f(t._oTransport.getSelectedItem())){t.getButtons()[1].setEnabled(false);t._oTransport.setValueState(sap.ui.core.ValueState.Error);t._oTransport.setValueStateText(t._oResources.getText("TRANSPORT_DIALOG_TRANSPORT_TT"));}}}});};
T.prototype._createPackageField=function(){var t=this;return new b({tooltip:this._oResources.getText("TRANSPORT_DIALOG_PACKAGE_TT"),width:"100%",change:function(){var o;var p;var O;O=t._createObjectInfo();o=new sap.ui.fl.transport.Transports();p=o.getTransports(O);p.then(function(r){t._onPackageChangeSuccess(r);},function(r){t._onPackageChangeError(r);});},liveChange:function(e){if(e.mParameters.liveValue&&e.mParameters.liveValue.length>3){t._oTransport.setEnabled(true);}}});};
T.prototype._createObjectInfo=function(){var o;var r={"package":this._oPackage.getValue()||""};o=this.getProperty("lrepObject");if(o){if(o.name){r.name=o.name;}if(o.type){r.type=o.type;}if(o.namespace){r.namespace=o.namespace;}}return r;};
T.prototype._onPackageChangeSuccess=function(t){if(t){if(t.localonly){this._oTransport.setEnabled(false);this.getButtons()[1].setEnabled(true);}else if(t.transports&&t.transports.length>0){this._oTransport.setEnabled(true);this._setTransports(t);}else if(t.errorCode){this.getButtons()[1].setEnabled(false);this._oPackage.setValueState(sap.ui.core.ValueState.Error);this._oPackage.setValueStateText(this._oResources.getText("TRANSPORT_DIALOG_"+t.errorCode));this._setTransports(t);}else{M.show(this._oResources.getText("TRANSPORT_DIALOG_NO_TRANSPORTS"));}}};
T.prototype._setTransports=function(t){var l;var d;l=this._hasLock(t.transports);if(l){d=[l];}else{d=t.transports;}this.setTransports(d);if(d&&d.length===1){this._oTransport.setValue(d[0].description,true);this.getButtons()[1].setEnabled(true);}if(!d||d.length===0){this._oTransport.setSelectedKey(null);this._oTransport.setValueState(sap.ui.core.ValueState.None);this.getButtons()[1].setEnabled(false);}};
T.prototype._onPackageChangeError=function(r){M.show(r);this.setTransports([]);};
T.prototype._hasLock=function(t){var o;var l=t.length;while(l--){o=t[l];if(o.locked){return o;}}return null;};
T.prototype.setPkg=function(p){if(p&&!this.getProperty("pkg")){this.setProperty("pkg",p);this._oPackage.setValue(p);this._oPackage.setEnabled(false);this._oTransport.setEnabled(true);this.setTitle(this._oResources.getText("TRANSPORT_DIALOG_TITLE_SIMPLE"));this.getButtons()[0].setVisible(false);}return this;};
T.prototype.setTransports=function(s){var i;var l=0;var o;if(s){this.setProperty("transports",s);this._oTransport.removeAllItems();l=s.length;for(i=0;i<l;i++){o=s[i];this._oTransport.addItem(new c({key:o.transportId,text:o.transportId,additionalText:o.description}));}if(l===1){this._oTransport.setSelectedKey(s[0].transportId);this.getButtons()[1].setEnabled(true);}if(l>0){this._oTransport.setEnabled(true);}}return this;};
T.prototype.setLrepObject=function(o){if(o&&!this.getProperty("lrepObject")){this.setProperty("lrepObject",o);}return this;};
T.prototype.setHidePackage=function(h){this.setProperty("hidePackage",h);this._oPackageListItem.setVisible(!h);if(h){this.getButtons()[0].setEnabled(h);this.setTitle(this._oResources.getText("TRANSPORT_DIALOG_TITLE_SIMPLE"));}return this;};
return T;},true);
sap.ui.predefine('sap/ui/fl/transport/TransportSelection',["sap/ui/fl/LayerUtils","sap/ui/fl/transport/Transports","sap/ui/fl/transport/TransportDialog","sap/ui/fl/registry/Settings"],function(L,T,a,F){"use strict";var b=function(){this.oTransports=new sap.ui.fl.transport.Transports();};
b.prototype.selectTransport=function(o,O,e,c,C,s){var t=this;if(o){var l=L.getCurrentLayer(false);if(l&&l==='CUSTOMER'){F.getInstance().then(function(S){if(S.isAtoEnabled()){var d={transportId:"ATO_NOTIFICATION"};O(t._createEventObject(o,d));}else{t._selectTransport(o,O,e,c,s);}});}else{t._selectTransport(o,O,e,c,s);}}};
b.prototype._selectTransport=function(o,O,e,c,s){var t=this;if(o){this.oTransports.getTransports(o).then(function(g){var d;if(t._checkDialog(g)){t._openDialog({hidePackage:!L.doesCurrentLayerRequirePackage(),pkg:o.package,transports:g.transports,lrepObject:t._toLREPObject(o)},O,e,c,s);}else{d=t._getTransport(g);O(t._createEventObject(o,d));}},function(r){e(r);});}};
b.prototype._createEventObject=function(o,t){return{mParameters:{selectedTransport:t.transportId,selectedPackage:o["package"],dialog:false},getParameters:function(){return this.mParameters;},getParameter:function(n){return this.mParameters[n];}};};
b.prototype._toLREPObject=function(o){var O={};if(o.namespace){O.namespace=o.namespace;}if(o.name){O.name=o.name;}if(o.type){O.type=o.type;}return O;};
b.prototype._openDialog=function(c,o,e,C,s){var d=new a(c);d.attachOk(o);d.attachCancel(e);d.addStyleClass(s);if(C){d.addStyleClass("sapUiSizeCompact");}else{d.removeStyleClass("sapUiSizeCompact");}d.open();return d;};
b.prototype._getTransport=function(t){var o;if(!t.localonly){o=this._hasLock(t.transports);}else{o={transportId:""};}return o;};
b.prototype._checkDialog=function(t){if(t){if(t.localonly||this._hasLock(t.transports)){return false;}}return true;};
b.prototype._hasLock=function(t){var l=t.length;while(l--){var o=t[l];if(o.locked){return o;}}return false;};
b.prototype.setTransports=function(c,C){var i=c.length-1;var t=this;var s=function(c,i,C,d,f){if(i>=0){var o=c[i];if(f===true){if(o.getDefinition().packageName!=="$TMP"){o.setRequest(d);}i--;return s(c,i,C,d,f);}if(o.getDefinition().packageName!=="$TMP"){return t.openTransportSelection(o,C).then(function(e){o.setRequest(e.transport);if(e.fromDialog===true){d=e.transport;f=true;}i--;return s(c,i,C,d,f);},function(){return null;});}i--;return s(c,i,C,d,f);}return Promise.resolve();};return s(c,i,C);};
b.prototype.openTransportSelection=function(c,C,s){var t=this;return new Promise(function(r,d){var o=function(R){if(R&&R.getParameters){var f=R.getParameters().selectedTransport;var p=R.getParameters().selectedPackage;var g=R.getParameters().dialog;var h={transport:f,packageName:p,fromDialog:g};r(h);}else{r({});}};var e=function(E){if(E.sId==='cancel'){r(E.sId);}else{d(E);}};var O={};if(c){O["package"]=c.getPackage();O.namespace=c.getNamespace();O.name=c.getId();O.type=c.getDefinition().fileType;}t.selectTransport(O,o,e,false,C,s);});};
b.prototype.checkTransportInfo=function(t){return t&&t.transport&&t.packageName!=="$TMP";};
b.prototype._prepareChangesForTransport=function(t,A,c,C){var o=new T();var d=o._convertToChangeTransportData(A,c);var e={};e.package=t.packageName;e.transportId=t.transport;e.changeIds=d;e.reference=C.reference;e.appVersion=C.appVersion;e.layer=C.layer;return o.makeChangesTransportable(e).then(function(){A.forEach(function(f){if(f.getPackage()==='$TMP'){var D=f.getDefinition();D.packageName=t.packageName;f.setResponse(D);}});});};
return b;},true);
sap.ui.predefine('sap/ui/fl/transport/Transports',["sap/ui/fl/LrepConnector","sap/ui/fl/Utils"],function(L,F){"use strict";var T=function(){};
T.prototype.getTransports=function(p){if(F.areNewConnectorsNecessary()){return Promise.resolve({localonly:true});}var u;var c;var l;var P;u='/sap/bc/lrep/actions/gettransports/';if(p['package']){u+='&package='+p['package'];}if(p.name){u+='&name='+p.name;}if(p.namespace){u+='&namespace='+p.namespace;}if(p.type){u+='&type='+p.type;}c=F.getClient();if(c){u+='&sap-client='+c;}u=u.replace('&','?');l=L.createConnector();P=l.send(u);return P.then(function(r){if(r.response){if(!r.response.localonly){r.response.localonly=false;}if(!r.response.errorCode){r.response.errorCode="";}return Promise.resolve(r.response);}return Promise.reject('response is empty');});};
T.prototype.makeChangesTransportable=function(p){var u;var c;var l;u='/sap/bc/lrep/actions/make_changes_transportable/';c=F.getClient();if(c){u+='?sap-client='+c;}if(!p.transportId){return Promise.reject(new Error("no transportId provided as attribute of mParameters"));}if(!p.changeIds){return Promise.reject(new Error("no changeIds provided as attribute of mParameters"));}l=L.createConnector();return l.send(u,'POST',p);};
T.prototype._convertToChangeTransportData=function(l,a){var t=[];var i;if(a&&a.length){for(i=0;i<a.length;i++){var A=a[i];var p={};p.namespace=A.getNamespace();p.fileName=A.getDefinition().fileName;p.fileType=A.getDefinition().fileType;t.push(p);}}var b=l.length;for(i=0;i<b;i++){var c=l[i];var d={};d.namespace=c.getNamespace();d.fileName=c.getId();d.fileType=c.getDefinition().fileType;t.push(d);}return t;};
return T;},true);
sap.ui.predefine('sap/ui/fl/util/ManagedObjectModel',["sap/ui/core/Element","sap/ui/model/base/ManagedObjectModel"],function(E,M){"use strict";
function c(n){return n.charAt(0).toUpperCase()+n.slice(1);}
var a=E.extend("sap.ui.fl.util.ManagedObjectModel",{
metadata:{library:"sap.ui.fl",properties:{data:{type:"object"},name:{type:"string",defaultValue:"$sap.ui.fl.ManagedObjectModel"}},associations:{object:{type:"sap.ui.core.Element"}}},
constructor:function(){E.apply(this,arguments);this._oManagedObjectModel=new M(sap.ui.getCore().byId(this.getObject()),this.getData());["data","name","object"].forEach(function(n){this["set"+c(n)]=function(){throw new Error("sap.ui.fl.util.ManagedObjectModel: Can't change the value of `"+n+"` after the object is initialized. Please recreate the object with correct values in the constructor.");};},this);}
});
a.prototype.setParent=function(n){var o=this.getParent();if(o){o.setModel(null,this.getName());}if(n){n.setModel(this._oManagedObjectModel,this.getName());}E.prototype.setParent.apply(this,arguments);};
a.prototype.exit=function(){this._oManagedObjectModel.destroy();};
return a;},true);
sap.ui.predefine('sap/ui/fl/variants/VariantController',["sap/ui/fl/Utils","sap/ui/fl/LayerUtils","sap/ui/fl/Change","sap/ui/fl/Variant","sap/base/util/ObjectPath","sap/base/util/includes","sap/base/Log","sap/ui/fl/apply/_internal/variants/URLHandler"],function(U,L,C,V,O,i,a,b){"use strict";var _=function(){};var c=function(s,A,o){this._sComponentName=s||"";this._sAppVersion=A||U.DEFAULT_APP_VERSION;this._mVariantManagement={};this.setChangeFileContent(o,{});this._oResourceBundle=sap.ui.getCore().getLibraryResourceBundle("sap.ui.fl");this.DEFAULT_AUTHOR="SAP";};
c.prototype.getComponentName=function(){return this._sComponentName;};
c.prototype.getAppVersion=function(){return this._sAppVersion;};
c.prototype.setChangeFileContent=function(o,t){if(Object.keys(this._mVariantManagement).length===0){this._mVariantManagement={};}if(o&&o.changes&&o.changes.variantSection){Object.keys(o.changes.variantSection).forEach(function(v){if(this._mVariantManagement[v]){return;}this._mVariantManagement[v]={};var d=o.changes.variantSection[v];var e=d.variants.concat();var s;var I=-1;e.forEach(function(f,g){if(f.content.fileName===v){I=g;if(!O.get("content.support.user",f)){var h={support:{user:this.DEFAULT_AUTHOR}};Object.assign(f.content,h);}}if(!f.content.content.favorite){f.content.content.favorite=true;}if(!f.content.content.visible){f.content.content.visible=true;}var T=f.content.content.title.match(/.i18n>(\w+)./);if(T){f.content.content.title=this._oResourceBundle.getText(T[1]);}this._applyChangesOnVariant(f);if(!s){s=i(t&&t[b.variantTechnicalParameterName],f.content.fileName)&&f.content.fileName;}}.bind(this));if(I>-1){var S=e.splice(I,1)[0];e.sort(this.compareVariants);e.splice(0,0,S);}this._mVariantManagement[v].variants=e;this._mVariantManagement[v].defaultVariant=v;if(s){this._mVariantManagement[v].currentVariant=s;}this._mVariantManagement[v].variantManagementChanges=o.changes.variantSection[v].variantManagementChanges;this._applyChangesOnVariantManagement(this._mVariantManagement[v]);}.bind(this));}};
c.prototype.getChangeFileContent=function(){return this._mVariantManagement;};
c.prototype.compareVariants=function(v,o){if(v.content.content.title.toLowerCase()<o.content.content.title.toLowerCase()){return-1;}else if(v.content.content.title.toLowerCase()>o.content.content.title.toLowerCase()){return 1;}return 0;};
c.prototype.getVariants=function(v){var d=this._mVariantManagement[v]&&this._mVariantManagement[v].variants;return d||[];};
c.prototype.getVariant=function(v,s){var o;var d=this.getVariants(v);d.some(function(e){if(e.content.fileName===s){o=e;return true;}});return o;};
c.prototype.getVariantChanges=function(v,s,d){s=s||this._mVariantManagement[v].defaultVariant;var r=[];if(s&&typeof s==="string"){var o=this.getVariant(v,s);r=o.controlChanges;if(d){r=r.map(function(e,f){var g;if(!e.getDefinition){g=new C(e);o.controlChanges.splice(f,1,g);}else{g=e;}return g;});}}return r;};
c.prototype._getReferencedChanges=function(v,o){var r=[];if(o.content.variantReference){r=this.getVariantChanges(v,o.content.variantReference,true);return r.filter(function(R){return L.compareAgainstCurrentLayer(R.getDefinition().layer,o.content.layer)===-1;});}return r;};
c.prototype.setVariantChanges=function(v,s,d){if(!v||!s||!Array.isArray(d)){a.error("Cannot set variant changes without Variant reference");return undefined;}return this._mVariantManagement[v].variants.some(function(o){if(o.content.fileName===s){o.controlChanges=d;return true;}});};
c.prototype._setVariantData=function(m,v,p){var d=this._mVariantManagement[v].variants;var o=d[p];Object.keys(m).forEach(function(P){if(o.content.content[P]){o.content.content[P]=m[P];}});if(o.content.fileName!==v){d.splice(p,1);var s=this._getIndexToSortVariant(d.slice(1),o);d.splice(s+1,0,o);return s+1;}d.splice(p,1,o);return p;};
c.prototype._updateChangesForVariantManagementInMap=function(o,v,A){var d=this._mVariantManagement[v];var s=o.changeType;if(o.fileType==="ctrl_variant_change"){d.variants.some(function(e){if(e.content.fileName===o.selector.id){if(!e.variantChanges[s]){e.variantChanges[s]=[];}if(A){e.variantChanges[s].push(o);}else{e.variantChanges[s].some(function(E,I){if(E.fileName===o.fileName){e.variantChanges[s].splice(I,1);return true;}});}return true;}});}else if(o.fileType==="ctrl_variant_management_change"){if(!d.variantManagementChanges){d.variantManagementChanges={};}if(!d.variantManagementChanges[s]){d.variantManagementChanges[s]=[];}if(A){d.variantManagementChanges[s].push(o);}else{d.variantManagementChanges[s].some(function(e,I){if(e.fileName===o.fileName){d.variantManagementChanges[s].splice(I,1);return true;}});}}};
c.prototype.loadInitialChanges=function(){return Object.keys(this._mVariantManagement).reduce(function(I,v){var s=this._mVariantManagement[v].currentVariant?"currentVariant":"defaultVariant";var o=this.getVariant(v,this._mVariantManagement[v][s]);if(!o||!o.content.content.visible){this._mVariantManagement[v][s]=v;}return I.concat(this.getVariantChanges(v,this._mVariantManagement[v][s],false));}.bind(this),[]);};
c.prototype.getChangesForVariantSwitch=function(p){var d=this.getVariantChanges(p.variantManagementReference,p.currentVariantReference,true);var m=[];var e=[];Object.keys(p.changesMap).forEach(function(f){p.changesMap[f].forEach(function(M){m=m.concat(M);e=e.concat(M.getId());});});d=d.reduce(function(f,o){var M=e.indexOf(o.getDefinition().fileName);if(M>-1){f=f.concat(m[M]);}return f;},[]);var n=this.getVariantChanges(p.variantManagementReference,p.newVariantReference,true);var r=[];if(n.length>0){r=d.slice();d.some(function(o){if(n[0]&&o.getId()===n[0].getId()){n.shift();r.shift();}else{return true;}});}else{r=d;}var s={changesToBeReverted:r.reverse(),changesToBeApplied:n};return s;};
c.prototype._applyChangesOnVariant=function(v){var m=v.variantChanges;var A;Object.keys(m).forEach(function(s){switch(s){case"setTitle":A=this._getActiveChange(s,m);if(A){v.content.content.title=A.getText("title");}break;case"setFavorite":A=this._getActiveChange(s,m);if(A){v.content.content.favorite=A.getContent().favorite;}break;case"setVisible":A=this._getActiveChange(s,m);if(A){v.content.content.visible=A.getContent().visible;}break;default:a.error("No valid changes on variant "+v.content.content.title+" available");}}.bind(this));};
c.prototype._applyChangesOnVariantManagement=function(v){var m=v.variantManagementChanges;var A;if(Object.keys(m).length>0){A=this._getActiveChange("setDefault",m);if(A){v.defaultVariant=A.getContent().defaultVariant;}}};
c.prototype._getActiveChange=function(s,m){var l=m[s].length-1;if(l>-1){return new C(m[s][l]);}return false;};
c.prototype.fillVariantModel=function(){var v={};Object.keys(this._mVariantManagement).forEach(function(k){v[k]={defaultVariant:this._mVariantManagement[k].defaultVariant,variants:[]};if(this._mVariantManagement[k].currentVariant){v[k].currentVariant=this._mVariantManagement[k].currentVariant;}this.getVariants(k).forEach(function(o,d){v[k].variants[d]=JSON.parse(JSON.stringify({key:o.content.fileName,title:o.content.content.title,layer:o.content.layer,favorite:o.content.content.favorite,visible:o.content.content.visible,author:O.get("content.support.user",o)}));});}.bind(this));return v;};
c.prototype.updateCurrentVariantInMap=function(v,n){this._mVariantManagement[v].currentVariant=n;};
c.prototype.addChangeToVariant=function(o,v,s){var n=this.getVariantChanges(v,s,true);var d=n.map(function(o){return o.getDefinition().fileName;});var I=d.indexOf(o.getDefinition().fileName);if(I===-1){n.push(o);return this.setVariantChanges(v,s,n);}return false;};
c.prototype.removeChangeFromVariant=function(o,v,s){var d=this.getVariantChanges(v,s,true);d=d.filter(function(e){return e.getId()!==o.getId();});return this.setVariantChanges(v,s,d);};
c.prototype.addVariantToVariantManagement=function(v,s){var d=this._mVariantManagement[s].variants.slice().splice(1);var I=this._getIndexToSortVariant(d,v);if(v.content.variantReference){var r=this._getReferencedChanges(s,v);v.controlChanges=r.concat(v.controlChanges);}this._mVariantManagement[s].variants.splice(I+1,0,v);return I+1;};
c.prototype._getIndexToSortVariant=function(v,o){var I=0;v.some(function(e,d){if(this.compareVariants(o,e)<0){I=d;return true;}I=d+1;}.bind(this));return I;};
c.prototype.removeVariantFromVariantManagement=function(v,s){var I;var f=this._mVariantManagement[s].variants.some(function(o,d){var e=new V(o);if(e.getId()===v.getId()){I=d;return true;}});if(f){this._mVariantManagement[s].variants.splice(I,1);}return I;};
c.prototype.assignResetMapListener=function(l){_=l;};
c.prototype.resetMap=function(r){if(r){return Promise.resolve(_());}this._mVariantManagement={};return Promise.resolve();};
c.prototype.checkAndSetVariantContent=function(o,t){var v=this.getChangeFileContent();var s=Object.keys(v).length===0||Object.keys(v).every(function(d){var e=v[d].variants;return e.length===1&&!e[0].content.layer&&e[0].controlChanges.length===0&&Object.keys(e[0].variantChanges).length===0;});if(s){this.setChangeFileContent(o,t);}};
return c;},true);
sap.ui.require.preload({
	"sap/ui/fl/manifest.json":'{"_version":"1.9.0","sap.app":{"id":"sap.ui.fl","type":"library","embeds":["support/apps/contentbrowser","support/apps/uiFlexibilityDiagnostics"],"applicationVersion":{"version":"1.71.16"},"title":"SAPUI5 library with sap.ui.fl controls.","description":"SAPUI5 library with sap.ui.fl controls.","ach":"CA-UI5-FL","resources":"resources.json","offline":true},"sap.ui":{"technology":"UI5","supportedThemes":["base"]},"sap.ui5":{"dependencies":{"minUI5Version":"1.71","libs":{"sap.ui.core":{"minVersion":"1.71.16"},"sap.m":{"minVersion":"1.71.16"}}},"library":{"i18n":"messagebundle.properties","content":{"controls":["sap.ui.fl.variants.VariantManagement"]}}}}'
},"sap/ui/fl/library-preload"
);
//# sourceMappingURL=library-preload.js.map