/*!
 * OpenUI5
 * (c) Copyright 2009-2019 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["sap/ui/fl/Utils","sap/ui/fl/LayerUtils","sap/ui/fl/Change","sap/ui/fl/Variant","sap/base/util/ObjectPath","sap/base/util/includes","sap/base/Log","sap/ui/fl/apply/_internal/variants/URLHandler"],function(U,L,C,V,O,i,a,b){"use strict";var _=function(){};var c=function(s,A,o){this._sComponentName=s||"";this._sAppVersion=A||U.DEFAULT_APP_VERSION;this._mVariantManagement={};this.setChangeFileContent(o,{});this._oResourceBundle=sap.ui.getCore().getLibraryResourceBundle("sap.ui.fl");this.DEFAULT_AUTHOR="SAP";};c.prototype.getComponentName=function(){return this._sComponentName;};c.prototype.getAppVersion=function(){return this._sAppVersion;};c.prototype.setChangeFileContent=function(o,t){if(Object.keys(this._mVariantManagement).length===0){this._mVariantManagement={};}if(o&&o.changes&&o.changes.variantSection){Object.keys(o.changes.variantSection).forEach(function(v){if(this._mVariantManagement[v]){return;}this._mVariantManagement[v]={};var d=o.changes.variantSection[v];var e=d.variants.concat();var s;var I=-1;e.forEach(function(f,g){if(f.content.fileName===v){I=g;if(!O.get("content.support.user",f)){var h={support:{user:this.DEFAULT_AUTHOR}};Object.assign(f.content,h);}}if(!f.content.content.favorite){f.content.content.favorite=true;}if(!f.content.content.visible){f.content.content.visible=true;}var T=f.content.content.title.match(/.i18n>(\w+)./);if(T){f.content.content.title=this._oResourceBundle.getText(T[1]);}this._applyChangesOnVariant(f);if(!s){s=i(t&&t[b.variantTechnicalParameterName],f.content.fileName)&&f.content.fileName;}}.bind(this));if(I>-1){var S=e.splice(I,1)[0];e.sort(this.compareVariants);e.splice(0,0,S);}this._mVariantManagement[v].variants=e;this._mVariantManagement[v].defaultVariant=v;if(s){this._mVariantManagement[v].currentVariant=s;}this._mVariantManagement[v].variantManagementChanges=o.changes.variantSection[v].variantManagementChanges;this._applyChangesOnVariantManagement(this._mVariantManagement[v]);}.bind(this));}};c.prototype.getChangeFileContent=function(){return this._mVariantManagement;};c.prototype.compareVariants=function(v,o){if(v.content.content.title.toLowerCase()<o.content.content.title.toLowerCase()){return-1;}else if(v.content.content.title.toLowerCase()>o.content.content.title.toLowerCase()){return 1;}return 0;};c.prototype.getVariants=function(v){var d=this._mVariantManagement[v]&&this._mVariantManagement[v].variants;return d||[];};c.prototype.getVariant=function(v,s){var o;var d=this.getVariants(v);d.some(function(e){if(e.content.fileName===s){o=e;return true;}});return o;};c.prototype.getVariantChanges=function(v,s,d){s=s||this._mVariantManagement[v].defaultVariant;var r=[];if(s&&typeof s==="string"){var o=this.getVariant(v,s);r=o.controlChanges;if(d){r=r.map(function(e,f){var g;if(!e.getDefinition){g=new C(e);o.controlChanges.splice(f,1,g);}else{g=e;}return g;});}}return r;};c.prototype._getReferencedChanges=function(v,o){var r=[];if(o.content.variantReference){r=this.getVariantChanges(v,o.content.variantReference,true);return r.filter(function(R){return L.compareAgainstCurrentLayer(R.getDefinition().layer,o.content.layer)===-1;});}return r;};c.prototype.setVariantChanges=function(v,s,d){if(!v||!s||!Array.isArray(d)){a.error("Cannot set variant changes without Variant reference");return undefined;}return this._mVariantManagement[v].variants.some(function(o){if(o.content.fileName===s){o.controlChanges=d;return true;}});};c.prototype._setVariantData=function(m,v,p){var d=this._mVariantManagement[v].variants;var o=d[p];Object.keys(m).forEach(function(P){if(o.content.content[P]){o.content.content[P]=m[P];}});if(o.content.fileName!==v){d.splice(p,1);var s=this._getIndexToSortVariant(d.slice(1),o);d.splice(s+1,0,o);return s+1;}d.splice(p,1,o);return p;};c.prototype._updateChangesForVariantManagementInMap=function(o,v,A){var d=this._mVariantManagement[v];var s=o.changeType;if(o.fileType==="ctrl_variant_change"){d.variants.some(function(e){if(e.content.fileName===o.selector.id){if(!e.variantChanges[s]){e.variantChanges[s]=[];}if(A){e.variantChanges[s].push(o);}else{e.variantChanges[s].some(function(E,I){if(E.fileName===o.fileName){e.variantChanges[s].splice(I,1);return true;}});}return true;}});}else if(o.fileType==="ctrl_variant_management_change"){if(!d.variantManagementChanges){d.variantManagementChanges={};}if(!d.variantManagementChanges[s]){d.variantManagementChanges[s]=[];}if(A){d.variantManagementChanges[s].push(o);}else{d.variantManagementChanges[s].some(function(e,I){if(e.fileName===o.fileName){d.variantManagementChanges[s].splice(I,1);return true;}});}}};c.prototype.loadInitialChanges=function(){return Object.keys(this._mVariantManagement).reduce(function(I,v){var s=this._mVariantManagement[v].currentVariant?"currentVariant":"defaultVariant";var o=this.getVariant(v,this._mVariantManagement[v][s]);if(!o||!o.content.content.visible){this._mVariantManagement[v][s]=v;}return I.concat(this.getVariantChanges(v,this._mVariantManagement[v][s],false));}.bind(this),[]);};c.prototype.getChangesForVariantSwitch=function(p){var d=this.getVariantChanges(p.variantManagementReference,p.currentVariantReference,true);var m=[];var e=[];Object.keys(p.changesMap).forEach(function(f){p.changesMap[f].forEach(function(M){m=m.concat(M);e=e.concat(M.getId());});});d=d.reduce(function(f,o){var M=e.indexOf(o.getDefinition().fileName);if(M>-1){f=f.concat(m[M]);}return f;},[]);var n=this.getVariantChanges(p.variantManagementReference,p.newVariantReference,true);var r=[];if(n.length>0){r=d.slice();d.some(function(o){if(n[0]&&o.getId()===n[0].getId()){n.shift();r.shift();}else{return true;}});}else{r=d;}var s={changesToBeReverted:r.reverse(),changesToBeApplied:n};return s;};c.prototype._applyChangesOnVariant=function(v){var m=v.variantChanges;var A;Object.keys(m).forEach(function(s){switch(s){case"setTitle":A=this._getActiveChange(s,m);if(A){v.content.content.title=A.getText("title");}break;case"setFavorite":A=this._getActiveChange(s,m);if(A){v.content.content.favorite=A.getContent().favorite;}break;case"setVisible":A=this._getActiveChange(s,m);if(A){v.content.content.visible=A.getContent().visible;}break;default:a.error("No valid changes on variant "+v.content.content.title+" available");}}.bind(this));};c.prototype._applyChangesOnVariantManagement=function(v){var m=v.variantManagementChanges;var A;if(Object.keys(m).length>0){A=this._getActiveChange("setDefault",m);if(A){v.defaultVariant=A.getContent().defaultVariant;}}};c.prototype._getActiveChange=function(s,m){var l=m[s].length-1;if(l>-1){return new C(m[s][l]);}return false;};c.prototype.fillVariantModel=function(){var v={};Object.keys(this._mVariantManagement).forEach(function(k){v[k]={defaultVariant:this._mVariantManagement[k].defaultVariant,variants:[]};if(this._mVariantManagement[k].currentVariant){v[k].currentVariant=this._mVariantManagement[k].currentVariant;}this.getVariants(k).forEach(function(o,d){v[k].variants[d]=JSON.parse(JSON.stringify({key:o.content.fileName,title:o.content.content.title,layer:o.content.layer,favorite:o.content.content.favorite,visible:o.content.content.visible,author:O.get("content.support.user",o)}));});}.bind(this));return v;};c.prototype.updateCurrentVariantInMap=function(v,n){this._mVariantManagement[v].currentVariant=n;};c.prototype.addChangeToVariant=function(o,v,s){var n=this.getVariantChanges(v,s,true);var d=n.map(function(o){return o.getDefinition().fileName;});var I=d.indexOf(o.getDefinition().fileName);if(I===-1){n.push(o);return this.setVariantChanges(v,s,n);}return false;};c.prototype.removeChangeFromVariant=function(o,v,s){var d=this.getVariantChanges(v,s,true);d=d.filter(function(e){return e.getId()!==o.getId();});return this.setVariantChanges(v,s,d);};c.prototype.addVariantToVariantManagement=function(v,s){var d=this._mVariantManagement[s].variants.slice().splice(1);var I=this._getIndexToSortVariant(d,v);if(v.content.variantReference){var r=this._getReferencedChanges(s,v);v.controlChanges=r.concat(v.controlChanges);}this._mVariantManagement[s].variants.splice(I+1,0,v);return I+1;};c.prototype._getIndexToSortVariant=function(v,o){var I=0;v.some(function(e,d){if(this.compareVariants(o,e)<0){I=d;return true;}I=d+1;}.bind(this));return I;};c.prototype.removeVariantFromVariantManagement=function(v,s){var I;var f=this._mVariantManagement[s].variants.some(function(o,d){var e=new V(o);if(e.getId()===v.getId()){I=d;return true;}});if(f){this._mVariantManagement[s].variants.splice(I,1);}return I;};c.prototype.assignResetMapListener=function(l){_=l;};c.prototype.resetMap=function(r){if(r){return Promise.resolve(_());}this._mVariantManagement={};return Promise.resolve();};c.prototype.checkAndSetVariantContent=function(o,t){var v=this.getChangeFileContent();var s=Object.keys(v).length===0||Object.keys(v).every(function(d){var e=v[d].variants;return e.length===1&&!e[0].content.layer&&e[0].controlChanges.length===0&&Object.keys(e[0].variantChanges).length===0;});if(s){this.setChangeFileContent(o,t);}};return c;},true);
