/*!
 * OpenUI5
 * (c) Copyright 2009-2019 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["sap/ui/thirdparty/jquery","sap/ui/core/Core","sap/ui/core/Control","sap/ui/integration/util/Manifest","sap/base/Log",'sap/ui/model/json/JSONModel',"sap/ui/model/resource/ResourceModel","sap/ui/integration/WidgetRenderer","sap/ui/integration/library","sap/base/util/LoaderExtensions","sap/ui/core/ComponentContainer"],function(q,C,a,W,L,J,R,b,l,c,d){"use strict";var M={APP_TYPE:"/sap.app/type",PARAMS:"/sap.widget/configuration/parameters"};var e=a.extend("sap.ui.integration.Widget",{metadata:{library:"sap.ui.integration",properties:{manifest:{type:"any",defaultValue:""},parameters:{type:"object",defaultValue:null},configuration:{type:"object"},baseUrl:{type:"string",defaultValue:""}},aggregations:{_content:{type:"sap.ui.core.Control",multiple:false,visibility:"hidden"}},events:{action:{parameters:{actionSource:{type:"sap.ui.core.Control"},manifestParameters:{type:"object"}}}}},renderer:b});e.prototype.init=function(){this.setBusyIndicatorDelay(0);};e.prototype.onBeforeRendering=function(){if(this._bApplyManifest){this._bApplyManifest=false;var m=this.getManifest();if(!m){this.destroyManifest();}else{this.createManifest(m,this.getBaseUrl());}}};e.prototype.exit=function(){this.destroyManifest();};e.prototype.destroyManifest=function(){if(this._oWidgetManifest){this._oWidgetManifest.destroy();this._oWidgetManifest=null;}this.destroyAggregation("_content");};e.prototype.setManifest=function(v){this.setProperty("manifest",v);this._bApplyManifest=true;return this;};e.prototype.setParameters=function(v){this.setProperty("parameters",v);this._bApplyManifest=true;return this;};e.prototype.getManifest=function(){var v=this.getProperty("manifest");if(v&&typeof v==="object"){return q.extend(true,{},v);}return v;};e.prototype.createManifest=function(m,B){var o={};if(typeof m==="string"){o.manifestUrl=m;m=null;}o.processI18n=false;this.setBusy(true);this._oWidgetManifest=new W("sap.widget",m,B);return this._oWidgetManifest.load(o).then(this._applyManifest.bind(this)).catch(this._applyManifest.bind(this));};e.prototype.setConfiguration=function(v){this._bApplyManifest=true;this.setBusy(true);this.setProperty("configuration",v);return this;};e.prototype.getParameters=function(){var v=this.getProperty("parameters");if(v&&typeof v==="object"){return q.extend(true,{},v);}return v;};e.prototype._applyManifest=function(){var p=this.getParameters(),A=this._oWidgetManifest.get(M.APP_TYPE),o=this.getConfiguration();if(A&&A!=="widget"){L.error("sap.app/type entry in manifest is not 'widget'");}this._oWidgetManifest._mergeConfiguration(o);this._registerManifestModulePath();this._oWidgetManifest.processParameters(p);return this._createComponent(this._oWidgetManifest.getJson(),this.getBaseUrl());};e.prototype._registerManifestModulePath=function(){if(!this._oWidgetManifest){return;}var A=this._oWidgetManifest.get("/sap.app/id");if(A){c.registerResourcePath(A.replace(/\./g,"/"),this._oWidgetManifest.getUrl());}else{L.error("Widget sap.app/id entry in the manifest is mandatory");}};e.prototype._createComponent=function(m,B){var o={manifest:m};if(B){o.url=B;o.altManifestUrl=B;}return sap.ui.core.Component.load(o).then(function(f){var g=new d({component:f().getId()});g.attachEvent("action",function(E){this.fireEvent("action",{actionSource:E.getParameter("actionSource"),manifestParameters:E.getParameter("manifestParameters")});}.bind(this));this.setAggregation("_content",g);this.setBusy(false);this.fireEvent("_ready");}.bind(this));};e.prototype.loadDesigntime=function(){if(!this._oWidgetManifest){return Promise.reject("Manifest not yet available");}var A=this._oWidgetManifest.get("/sap.app/id");if(!A){return Promise.reject("App id not maintained");}var m=A.replace(/\./g,"/");return new Promise(function(r,f){var s=m+"/"+(this._oWidgetManifest.get("/sap.widget/designtime")||"designtime/Widget.designtime");if(s){sap.ui.require([s,"sap/base/util/deepClone"],function(D,g){r({configuration:g(this._oWidgetManifest.get("/sap.widget"),30),designtime:D,manifest:g(this._oWidgetManifest.oJson,30)});}.bind(this),function(){f({error:s+" not found"});});}else{f();}}.bind(this));};return e;});
