/*!
 * OpenUI5
 * (c) Copyright 2009-2019 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["sap/ui/core/Core","sap/ui/core/Control","./library","sap/ui/core/ResizeHandler","./AlignedFlowLayoutRenderer","sap/ui/dom/units/Rem"],function(C,a,l,R,A,b){"use strict";var c=a.extend("sap.ui.layout.AlignedFlowLayout",{metadata:{library:"sap.ui.layout",properties:{minItemWidth:{type:"sap.ui.core.AbsoluteCSSSize",defaultValue:"12rem"},maxItemWidth:{type:"sap.ui.core.AbsoluteCSSSize",defaultValue:"24rem"}},defaultAggregation:"content",aggregations:{content:{type:"sap.ui.core.Control",multiple:true},endContent:{type:"sap.ui.core.Control",multiple:true}}}});c.prototype.init=function(){this._sResizeListenerId=R.register(this,this.onResize.bind(this));};c.prototype.exit=function(){if(this._sResizeListenerId){R.deregister(this._sResizeListenerId);this._sResizeListenerId="";}};c.prototype._onRenderingOrThemeChanged=function(){var d=this.getDomRef(),e=this.getDomRef("endItem"),E=this.getContent().length&&d&&e;if(E){var L=window.getComputedStyle(d,null),i=L.getPropertyValue("padding-top"),m=e.style;if(C.getConfiguration().getRTL()){m.left=L.getPropertyValue("padding-left");}else{m.right=L.getPropertyValue("padding-right");}m.bottom=i;}this.reflow({domRef:d,endItemDomRef:e});};c.prototype.onAfterRendering=c.prototype._onRenderingOrThemeChanged;c.prototype.onThemeChanged=c.prototype._onRenderingOrThemeChanged;c.prototype.onResize=function(e){if(e&&(e.size.width!==e.oldSize.width)){this.reflow();}};c.prototype.reflow=function(s){if(this.getContent().length===0){return;}s=s||{};var d=s.domRef||this.getDomRef();if(!d||!d.offsetParent){return;}var e=this.getRenderer().CSS_CLASS+"OneLine",E=true;var o=s.endItemDomRef||this.getDomRef("endItem"),L=this.getLastItemDomRef();if(o&&L){var f=d.lastElementChild,m=f.style;m.width="";m.height="";m.display="";d.classList.remove(e);var i=o.offsetHeight,g=o.offsetWidth,h=L.offsetTop,j=L.offsetLeft,k,n;if(C.getConfiguration().getRTL()){n=j;}else{var r=j+L.offsetWidth;n=d.offsetWidth-r;}E=n>=g;if(E){if(this.checkItemsWrapping(d)){if(o.offsetTop<h){m.height=Math.max(0,i-h)+"px";if(L.offsetTop>=o.offsetTop){k=o.offsetLeft;j=L.offsetLeft;if((k>=j)&&(k<=(j+L.offsetWidth))){m.height=i+"px";}}m.display="block";}else{m.height="0";m.display="";}}else{if(o.offsetTop<h){m.height=i+"px";}m.display="block";}}else{m.height=i+"px";m.display="block";}var p=g+"px";m.width=p;m.minWidth=p;}var q={excludeEndItem:true};if(this.checkItemsWrapping(d,q)){d.classList.remove(e);}else{d.classList.add(e);}};c.prototype.checkItemsWrapping=function(d,s){d=d||this.getDomRef();if(!d){return false;}var D={excludeEndItem:false};s=Object.assign(D,s);var f=d.firstElementChild,L=this.getLastItemDomRef();if(!f||!L){return false;}var F=f.offsetTop,i=L.offsetTop,e=f.offsetHeight;if(i>=(F+e)){return true;}if(s.excludeEndItem){return false;}var E=this.getDomRef("endItem");return!!E&&(E.offsetTop>=(F+e));};c.prototype.getLastItemDomRef=function(){var d=this.getContent(),i=d.length;if(i){var o=d[i-1],e=o.getDomRef();if(e){return e.parentElement;}}return null;};c.prototype.getLastVisibleDomRef=function(){return this.getDomRef("endItem")||this.getLastItemDomRef();};c.prototype.getNumberOfSpacers=function(){var i=this.getContent().length;if(i===0){return 0;}var s=i,m=this.getMinItemWidth(),M;if(m.lastIndexOf("rem")!==-1){M=b.toPx(m);}else if(m.lastIndexOf("px")!==-1){M=parseFloat(m);}if(M){var d=Math.max(document.documentElement.clientWidth,window.screen.width);s=Math.abs(d/M);}s=Math.min(s,i-1);s=Math.max(1,s);s=Math.floor(s);return s;};return c;});
